# JBuy (Spring Boot + Angular)
An e-commerce website using Spring Boot and Angular
## Demo
https://jbuy.shop

## Features
- Rest API
- Product search 
- Full text search
- Faceted search
- Search text autocomplete
- Shopping cart, checkout, review
- OpenAPI

## Technology Stacks
- Spring Boot
- Spring Security
- Spring Data JPA
- Hibernate
- Hibernate Search
- Lucene
- Hazelcast
- Springdoc
- Rapidoc

- Angular
- Angular Material
- Elf

## Requirement:
```
Java 11 or above
Node 16 or above
npm 8.5 or above
Angular/cli 13 or above
```

## Run dev mode
- Spring
```
---From root folder
$ cd api
$ ./mvnw clean install
$ ./mvnw spring-boot:run
```

- Angular
```
---From root folder
$ cd webapp
$ npm install
$ ng serve -o
```

## Screenshot
![screenshot1](https://i.imgur.com/0vvbyK5.png)

---
![screenshot1](https://i.imgur.com/6Y94mz3.png)

---
![screenshot1](https://i.imgur.com/6YWZ0aC.png)

---
![screenshot1](https://i.imgur.com/CbSWxCq.png)

---
![screenshot1](https://i.imgur.com/esTYyvs.png)

---
![screenshot1](https://i.imgur.com/xFqYUIj.png)
