---
title: What is this all about?
sidebar_label: What is this all about?
---

<div align="left">
<img src="./assets/logo.png" alt="Margarita" title="Margarita" width="250"/>
</div>

<p><br><strong>Margarita is multi-platform <span title="travel">✈️</span> travel app for iOS, Android and Web</strong>
built with <strong>React Native, GraphQL and <a href="https://partners.kiwi.com/presenting-tequila-revolution-travel-industry/" target="_blank">Tequila API</a></strong></p>

## Demo

- **Web version**: https://kiwicom-margarita.netlify.com
- Project in Expo: https://expo.io/@kiwicom-margarita-public/margarita-mobile

**If you like this project**, please give us ⭐ on <a href="https://github.com/kiwicom/margarita" targe="_blank">GitHub</a> — it helps!

<div align="center">
  <img src="./assets/screens/search.png" alt="Search" title="Search" width="250"/>
  <img src="./assets/screens/results.png" alt="Results" title="Results" width="250"/>
  <img src="./assets/screens/mmb.png" alt="Bookings" title="Bookings" width="250"/>
</div>

<img src="./assets/mac.png" alt="Search" title="Search" />

## Devstack

This project follows the react-native-web philosophy of **Write Once, Render Anywhere**.

- [React Native](https://facebook.github.io/react-native/)
- [Expo](https://expo.io/)
- [React Native Web](https://github.com/necolas/react-native-web)
- [Next.js](https://nextjs.org/)
- [Relay](http://facebook.github.io/relay/)
- [Flow](https://flow.org/)

More detailed info about our devstack can be found in [Technical Overview docs](technical-overview)

## App features

The app consists of 4 main parts which should cover the whole searching and booking flow:

- Search for connections
- Booking
- Manage my booking
- Payments

More detailed info can be found in [Features docs](features).

## How it works

<img src="./assets/schema.png" alt="Schema" title="Schema" />

## Links

- 🎮 [GraphQL Playground](https://p2kwd3i3a8.execute-api.eu-central-1.amazonaws.com/staging/graphql)
- 🚀 [GraphQL Voyager](https://margarita-graphql-voyager.now.sh/)
- 📘 [Storybook for Universal components](https://kiwicom-universal-components.netlify.com)
- 🍸 [Margarita product page](http://margarita.kiwi.com)
- 🥝 [Open source projects at Kiwi.com](https://github.com/kiwicom/)

## License

The code in this project is licensed under [MIT license](LICENSE). By contributing to Margarita, you agree that your contributions will be licensed under its MIT license.
