// @flow

export default {
  locations: [
    {
      id: 'prague_cz',
      active: true,
      name: 'Prague',
      slug: 'prague-czechia',
      code: 'PRG',
      alternative_names: ['Praha'],
      rank: 29,
      global_rank_dst: 6,
      timezone: 'Europe/Prague',
      population: 1165581,
      airports: 1,
      stations: 1,
      hotels: 0,
      bus_stations: 8,
      subdivision: null,
      autonomous_territory: null,
      country: {
        id: 'CZ',
        name: 'Czechia',
        slug: 'czechia',
        code: 'CZ',
      },
      region: {
        id: 'central-europe',
        name: 'Central Europe',
        slug: 'central-europe',
      },
      continent: {
        id: 'europe',
        name: 'Europe',
        slug: 'europe',
        code: 'EU',
      },
      location: {
        lat: 50.075538,
        lon: 14.4378,
      },
      tags: [
        {
          tag: 'nightlife',
          month_to: -1,
          month_from: -1,
        },
        {
          tag: 'sightseeing&culture',
          month_to: -1,
          month_from: -1,
        },
      ],
      alternative_departure_points: [
        {
          id: 'AOC',
          distance: 250.41,
          duration: 9817.2,
        },
        {
          id: 'BYU',
          distance: 262.45,
          duration: 11139.1,
        },
        {
          id: 'ZDN',
          distance: 206.32,
          duration: 7778.8,
        },
        {
          id: 'BRQ',
          distance: 213.13,
          duration: 8368.5,
        },
        {
          id: '003',
          distance: 172.48,
          duration: 8572.1,
        },
        {
          id: 'ZTZ',
          distance: 161.3,
          duration: 8293.7,
        },
        {
          id: 'WRO',
          distance: 322.33,
          duration: 14204.7,
        },
        {
          id: 'ZTT',
          distance: 262.6,
          duration: 11016.7,
        },
        {
          id: 'CBU',
          distance: 294.21,
          duration: 12420.6,
        },
        {
          id: 'ZSU',
          distance: 319.27,
          duration: 11792,
        },
        {
          id: 'DRS',
          distance: 169.23,
          duration: 6899.3,
        },
        {
          id: 'XIR',
          distance: 148.48,
          duration: 6138.6,
        },
        {
          id: 'PFL',
          distance: 2.87,
          duration: 245.9,
        },
        {
          id: 'ZGA',
          distance: 277.04,
          duration: 10291.2,
        },
        {
          id: 'ZGE',
          distance: 163.92,
          duration: 7896.4,
        },
        {
          id: 'ZHZ',
          distance: 285.42,
          duration: 10801.8,
        },
        {
          id: 'HOQ',
          distance: 223.83,
          duration: 11077.2,
        },
        {
          id: 'GTW',
          distance: 284.45,
          duration: 10853.3,
        },
        {
          id: 'XYJ',
          distance: 4.97,
          duration: 435.1,
        },
        {
          id: 'ZJS',
          distance: 316.48,
          duration: 11750.8,
        },
        {
          id: 'KLV',
          distance: 123.17,
          duration: 6790.3,
        },
        {
          id: 'ZIK',
          distance: 127.84,
          duration: 6903.9,
        },
        {
          id: 'UHE',
          distance: 282.84,
          duration: 11956.5,
        },
        {
          id: 'XIT',
          distance: 253.62,
          duration: 9806.9,
        },
        {
          id: 'LEJ',
          distance: 269.28,
          duration: 10516.7,
        },
        {
          id: 'LNZ',
          distance: 259.88,
          duration: 13139.6,
        },
        {
          id: 'LZS',
          distance: 246,
          duration: 12306.7,
        },
        {
          id: 'ZWT',
          distance: 313.35,
          duration: 12842.6,
        },
        {
          id: 'MKA',
          distance: 163.62,
          duration: 6830,
        },
        {
          id: 'XJC',
          distance: 282.26,
          duration: 10690.6,
        },
        {
          id: 'PED',
          distance: 118.73,
          duration: 5053.6,
        },
        {
          id: 'XJP',
          distance: 116.16,
          duration: 4816.1,
        },
        {
          id: 'ZPF',
          distance: 218.36,
          duration: 11425.9,
        },
        {
          id: 'XYG',
          distance: 1.43,
          duration: 134.3,
        },
        {
          id: 'PRV',
          distance: 285.58,
          duration: 10958,
        },
        {
          id: 'ZPM',
          distance: 260.92,
          duration: 9941.8,
        },
        {
          id: 'ZRX',
          distance: 203.71,
          duration: 8580.7,
        },
        {
          id: 'ZAU',
          distance: 170.27,
          duration: 9217.1,
        },
        {
          id: 'ZSC',
          distance: 143.29,
          duration: 7844.5,
        },
        {
          id: 'RBM',
          distance: 233.14,
          duration: 11196.9,
        },
        {
          id: 'CZ-UHER-UHER',
          distance: 276.37,
          duration: 11453.1,
        },
        {
          id: 'PRG',
          distance: 17.19,
          duration: 1772.9,
        },
        {
          id: '5FU',
          distance: 321.83,
          duration: 14319.7,
        },
        {
          id: 'ZIT',
          distance: 133.04,
          duration: 5926.1,
        },
      ],
      type: 'city',
    },
    {
      id: 'PRG',
      int_id: 5212,
      active: true,
      code: 'PRG',
      icao: 'LKPR',
      name: 'Václav Havel Airport Prague',
      slug: 'vaclav-havel-airport-prague-prague-czechia',
      alternative_names: ['Letiště Václava Havla Praha'],
      rank: 23,
      global_rank_dst: 5,
      dst_popularity_score: 3334037,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [
        {
          id: 'sedlec-ossuary_poi',
          name: 'Sedlec Ossuary',
          slug: 'sedlec-ossuary',
        },
        {
          id: 'prague-castle_poi',
          name: 'Prague Castle',
          slug: 'prague-castle',
        },
        {
          id: 'old-town-square-prague_poi',
          name: 'Old Town Square, Prague',
          slug: 'old-town-square',
        },
        {
          id: 'karlstejn-castle_poi',
          name: 'Karlstejn Castle',
          slug: 'karlstejn-castle',
        },
        {
          id: 'zwinger_poi',
          name: 'Zwinger',
          slug: 'zwinger',
        },
        {
          id: 'charles-bridge_poi',
          name: 'Charles Bridge',
          slug: 'charles-bridge',
        },
      ],
      location: {
        lat: 50.100833,
        lon: 14.26,
      },
      alternative_departure_points: [
        {
          id: 'AOC',
          distance: 198.98,
          duration: 10232.1,
        },
        {
          id: 'ZDN',
          distance: 227.33,
          duration: 8915.1,
        },
        {
          id: 'BRQ',
          distance: 234.14,
          duration: 9504.8,
        },
        {
          id: '003',
          distance: 183.72,
          duration: 9430.3,
        },
        {
          id: 'ZTZ',
          distance: 154.78,
          duration: 8095.9,
        },
        {
          id: 'DRS',
          distance: 183.51,
          duration: 8191.7,
        },
        {
          id: 'XIR',
          distance: 162.77,
          duration: 7431,
        },
        {
          id: 'PFL',
          distance: 17.75,
          duration: 1869.6,
        },
        {
          id: 'ZGA',
          distance: 225.94,
          duration: 10767.8,
        },
        {
          id: 'ZGE',
          distance: 178.29,
          duration: 9325.3,
        },
        {
          id: 'HOQ',
          distance: 214.21,
          duration: 10743.5,
        },
        {
          id: 'XYJ',
          distance: 16.92,
          duration: 1756.4,
        },
        {
          id: 'KLV',
          distance: 113.54,
          duration: 6456.6,
        },
        {
          id: 'ZIK',
          distance: 118.22,
          duration: 6570.2,
        },
        {
          id: 'MKA',
          distance: 159.96,
          duration: 6653,
        },
        {
          id: 'PED',
          distance: 136.33,
          duration: 6698.1,
        },
        {
          id: 'XJP',
          distance: 133.75,
          duration: 6460.6,
        },
        {
          id: 'XYG',
          distance: 19.48,
          duration: 1929.3,
        },
        {
          id: 'ZPM',
          distance: 257.26,
          duration: 9764.8,
        },
        {
          id: 'ZRX',
          distance: 218,
          duration: 9873.1,
        },
        {
          id: 'ZAU',
          distance: 163.75,
          duration: 9019.3,
        },
        {
          id: 'ZSC',
          distance: 157.58,
          duration: 9136.9,
        },
        {
          id: 'ZIT',
          distance: 147.42,
          duration: 7355,
        },
      ],
      tags: [
        {
          tag: 'sightseeing&culture',
          month_to: -1,
          month_from: -1,
        },
        {
          tag: 'nightlife',
          month_to: -1,
          month_from: -1,
        },
      ],
      type: 'airport',
    },
    {
      id: 'prague-castle_poi',
      active: true,
      name: 'Prague Castle',
      code: null,
      slug: 'prague-castle',
      alternative_names: [],
      rank: 149,
      global_rank_dst: 98,
      category: 'fortification',
      location: {
        lat: 50.090811,
        lon: 14.400523,
      },
      locations_nearby: [
        {
          id: 'PRG',
          distance: 16.51,
          duration: 2717,
        },
        {
          id: 'PED',
          distance: 124.65,
          duration: 5196,
        },
        {
          id: 'BRQ',
          distance: 218.56,
          duration: 8969,
        },
        {
          id: 'XYG',
          distance: 5.8,
          duration: 1063,
        },
        {
          id: 'PFL',
          distance: 4.64,
          duration: 936,
        },
        {
          id: 'DRS',
          distance: 169.69,
          duration: 6748,
        },
        {
          id: 'KLV',
          distance: 126.29,
          duration: 6769,
        },
        {
          id: 'XJP',
          distance: 122.52,
          duration: 4998,
        },
        {
          id: 'XIR',
          distance: 149.01,
          duration: 6306,
        },
        {
          id: 'ZIK',
          distance: 132.26,
          duration: 7198,
        },
      ],
      type: 'special',
    },
    {
      id: 'old-town-square-prague_poi',
      active: true,
      name: 'Old Town Square, Prague',
      code: null,
      slug: 'old-town-square',
      alternative_names: [],
      rank: 151,
      global_rank_dst: 100,
      category: 'architecture',
      location: {
        lat: 50.087462,
        lon: 14.421211,
      },
      locations_nearby: [
        {
          id: 'PRG',
          distance: 17.07,
          duration: 2944,
        },
        {
          id: 'PED',
          distance: 123.21,
          duration: 5124,
        },
        {
          id: 'BRQ',
          distance: 216.45,
          duration: 8938,
        },
        {
          id: 'XYG',
          distance: 3.91,
          duration: 854,
        },
        {
          id: 'PFL',
          distance: 2,
          duration: 761,
        },
        {
          id: 'DRS',
          distance: 168.25,
          duration: 6675,
        },
        {
          id: 'KLV',
          distance: 126.85,
          duration: 6996,
        },
        {
          id: 'XJP',
          distance: 121.08,
          duration: 4925,
        },
        {
          id: 'XIR',
          distance: 147.56,
          duration: 6234,
        },
        {
          id: 'ZIK',
          distance: 132.82,
          duration: 7425,
        },
      ],
      type: 'special',
    },
    {
      id: 'CZ-PRAG-PRA6',
      int_id: 305,
      active: true,
      code: 'CZ-PRAG-PRA6',
      icao: null,
      name: 'Prague ,Hradčanská',
      slug: 'prague-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 1024,
      dst_popularity_score: 0,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [],
      location: {
        lat: 50.096993,
        lon: 14.402517,
      },
      alternative_departure_points: [
        {
          id: 'XYG',
          distance: 7.32,
          duration: 573,
        },
        {
          id: 'PFL',
          distance: 5.59,
          duration: 510,
        },
        {
          id: 'PRG',
          distance: 13.55,
          duration: 1480,
        },
        {
          id: 'ZSC',
          distance: 144.37,
          duration: 7898,
        },
        {
          id: 'ZIT',
          distance: 135.09,
          duration: 6043,
        },
        {
          id: 'PED',
          distance: 124.01,
          duration: 5386,
        },
        {
          id: 'XJP',
          distance: 121.43,
          duration: 5148,
        },
        {
          id: 'KLV',
          distance: 119.53,
          duration: 6497,
        },
        {
          id: 'ZIK',
          distance: 124.2,
          duration: 6611,
        },
        {
          id: 'XIR',
          distance: 149.56,
          duration: 6192,
        },
        {
          id: 'ZGE',
          distance: 165.97,
          duration: 8013,
        },
        {
          id: 'DRS',
          distance: 170.31,
          duration: 6952,
        },
        {
          id: 'ZAU',
          distance: 163.97,
          duration: 8869,
        },
        {
          id: 'ZTZ',
          distance: 155,
          duration: 7945,
        },
        {
          id: 'ZRX',
          distance: 204.79,
          duration: 8634,
        },
        {
          id: 'ZPF',
          distance: 220.07,
          duration: 11426,
        },
        {
          id: 'ZTT',
          distance: 263.68,
          duration: 11070,
        },
        {
          id: 'ZGA',
          distance: 278.12,
          duration: 10344,
        },
        {
          id: 'ZDN',
          distance: 213.63,
          duration: 8164,
        },
        {
          id: 'BRQ',
          distance: 220.44,
          duration: 8754,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
    {
      id: 'PFL',
      int_id: 11884,
      active: true,
      code: 'PFL',
      icao: null,
      name: 'Prague - Florenc Bus Station',
      slug: 'florenc-bus-station-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 648,
      dst_popularity_score: 251,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [
        {
          id: 'old-town-square-prague_poi',
          name: 'Old Town Square, Prague',
          slug: 'old-town-square',
        },
        {
          id: 'sedlec-ossuary_poi',
          name: 'Sedlec Ossuary',
          slug: 'sedlec-ossuary',
        },
        {
          id: 'charles-bridge_poi',
          name: 'Charles Bridge',
          slug: 'charles-bridge',
        },
        {
          id: 'prague-castle_poi',
          name: 'Prague Castle',
          slug: 'prague-castle',
        },
        {
          id: 'karlstejn-castle_poi',
          name: 'Karlstejn Castle',
          slug: 'karlstejn-castle',
        },
      ],
      location: {
        lat: 50.089525,
        lon: 14.440954,
      },
      alternative_departure_points: [
        {
          id: 'AOC',
          distance: 248.41,
          duration: 9671.6,
        },
        {
          id: 'ZDN',
          distance: 207.88,
          duration: 7937.2,
        },
        {
          id: 'BRQ',
          distance: 214.68,
          duration: 8526.9,
        },
        {
          id: '003',
          distance: 174.03,
          duration: 8730.5,
        },
        {
          id: 'ZTZ',
          distance: 158.58,
          duration: 8245.3,
        },
        {
          id: 'DRS',
          distance: 167.22,
          duration: 6753.7,
        },
        {
          id: 'XIR',
          distance: 146.48,
          duration: 5993,
        },
        {
          id: 'ZGA',
          distance: 275.04,
          duration: 10145.6,
        },
        {
          id: 'ZGE',
          distance: 161.49,
          duration: 7715.4,
        },
        {
          id: 'ZHZ',
          distance: 283.42,
          duration: 10656.2,
        },
        {
          id: 'XYJ',
          distance: 2.96,
          duration: 289.5,
        },
        {
          id: 'KLV',
          distance: 123.46,
          duration: 6796.4,
        },
        {
          id: 'ZIK',
          distance: 128.14,
          duration: 6910,
        },
        {
          id: 'XIT',
          distance: 251.62,
          duration: 9661.3,
        },
        {
          id: 'LEJ',
          distance: 267.28,
          duration: 10371.1,
        },
        {
          id: 'MKA',
          distance: 166.67,
          duration: 6873.8,
        },
        {
          id: 'PED',
          distance: 119.53,
          duration: 5088.2,
        },
        {
          id: 'XJP',
          distance: 116.95,
          duration: 4850.7,
        },
        {
          id: 'XYG',
          distance: 2.15,
          duration: 218.6,
        },
        {
          id: 'ZPM',
          distance: 263.97,
          duration: 9985.6,
        },
        {
          id: 'ZRX',
          distance: 201.71,
          duration: 8435.1,
        },
        {
          id: 'ZAU',
          distance: 167.55,
          duration: 9168.7,
        },
        {
          id: 'ZSC',
          distance: 141.29,
          duration: 7698.9,
        },
        {
          id: 'PRG',
          distance: 17.48,
          duration: 1779,
        },
        {
          id: 'ZIT',
          distance: 130.61,
          duration: 5745.1,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
    {
      id: 'CZ-PRAG-PRA2',
      int_id: 298,
      active: true,
      code: 'CZ-PRAG-PRA2',
      icao: null,
      name: 'Prague - Libeň',
      slug: 'prague-liben-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 1024,
      dst_popularity_score: 0,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [],
      location: {
        lat: 50.100761,
        lon: 14.502088,
      },
      alternative_departure_points: [
        {
          id: 'PFL',
          distance: 5.69,
          duration: 513,
        },
        {
          id: 'XYG',
          distance: 7.84,
          duration: 589,
        },
        {
          id: 'PRG',
          distance: 22.88,
          duration: 2036,
        },
        {
          id: 'ZSC',
          distance: 139.93,
          duration: 7499,
        },
        {
          id: 'PED',
          distance: 112.29,
          duration: 4679,
        },
        {
          id: 'XJP',
          distance: 109.72,
          duration: 4442,
        },
        {
          id: 'ZIT',
          distance: 126.44,
          duration: 5343,
        },
        {
          id: 'KLV',
          distance: 128.86,
          duration: 7054,
        },
        {
          id: 'ZIK',
          distance: 133.54,
          duration: 7167,
        },
        {
          id: 'XIR',
          distance: 145.12,
          duration: 5793,
        },
        {
          id: 'ZGE',
          distance: 157.31,
          duration: 7313,
        },
        {
          id: 'DRS',
          distance: 165.86,
          duration: 6554,
        },
        {
          id: 'ZTZ',
          distance: 212.4,
          duration: 8098,
        },
        {
          id: 'ZAU',
          distance: 248.73,
          duration: 9290,
        },
        {
          id: 'ZRX',
          distance: 200.35,
          duration: 8235,
        },
        {
          id: 'ZDN',
          distance: 208.58,
          duration: 8020,
        },
        {
          id: 'ZTT',
          distance: 259.23,
          duration: 10671,
        },
        {
          id: 'ZPF',
          distance: 225.33,
          duration: 11963,
        },
        {
          id: 'BRQ',
          distance: 215.39,
          duration: 8610,
        },
        {
          id: 'ZGA',
          distance: 273.67,
          duration: 9946,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
    {
      id: 'CZ-PRAG-PRAG',
      int_id: 291,
      active: true,
      code: 'CZ-PRAG-PRAG',
      icao: null,
      name: 'Prague Anděl',
      slug: 'prague-andel-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 1024,
      dst_popularity_score: 0,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [],
      location: {
        lat: 50.068608,
        lon: 14.404425,
      },
      alternative_departure_points: [
        {
          id: 'XYG',
          distance: 4.05,
          duration: 395,
        },
        {
          id: 'PFL',
          distance: 5.48,
          duration: 507,
        },
        {
          id: 'PRG',
          distance: 14.9,
          duration: 1550,
        },
        {
          id: 'ZSC',
          distance: 145.86,
          duration: 8084,
        },
        {
          id: 'PED',
          distance: 126.63,
          duration: 5354,
        },
        {
          id: 'XJP',
          distance: 124.06,
          duration: 5117,
        },
        {
          id: 'ZIT',
          distance: 135.72,
          duration: 6181,
        },
        {
          id: 'KLV',
          distance: 120.88,
          duration: 6567,
        },
        {
          id: 'ZIK',
          distance: 125.55,
          duration: 6681,
        },
        {
          id: 'XIR',
          distance: 151.06,
          duration: 6378,
        },
        {
          id: 'ZGE',
          distance: 166.59,
          duration: 8152,
        },
        {
          id: 'DRS',
          distance: 171.8,
          duration: 7139,
        },
        {
          id: 'ZAU',
          distance: 167.99,
          duration: 8994,
        },
        {
          id: 'ZTZ',
          distance: 159.02,
          duration: 8071,
        },
        {
          id: 'ZRX',
          distance: 206.29,
          duration: 8821,
        },
        {
          id: 'ZPF',
          distance: 215.45,
          duration: 11085,
        },
        {
          id: 'ZDN',
          distance: 209.01,
          duration: 7823,
        },
        {
          id: 'ZTT',
          distance: 265.17,
          duration: 11257,
        },
        {
          id: 'ZGA',
          distance: 279.61,
          duration: 10531,
        },
        {
          id: 'BRQ',
          distance: 215.82,
          duration: 8413,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
    {
      id: 'CZ-PRAG-PRA0',
      int_id: 292,
      active: true,
      code: 'CZ-PRAG-PRA0',
      icao: null,
      name: 'Prague East (Černý Most)',
      slug: 'prague-east-cerny-most-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 1024,
      dst_popularity_score: 0,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [],
      location: {
        lat: 50.108898,
        lon: 14.577435,
      },
      alternative_departure_points: [
        {
          id: 'PFL',
          distance: 12.16,
          duration: 1045,
        },
        {
          id: 'XYG',
          distance: 17.28,
          duration: 1186,
        },
        {
          id: 'PRG',
          distance: 29.64,
          duration: 2588,
        },
        {
          id: 'PED',
          distance: 106.76,
          duration: 4188,
        },
        {
          id: 'XJP',
          distance: 104.18,
          duration: 3950,
        },
        {
          id: 'ZSC',
          distance: 144.18,
          duration: 7716,
        },
        {
          id: 'ZIT',
          distance: 119.94,
          duration: 4965,
        },
        {
          id: 'ZGE',
          distance: 150.81,
          duration: 6936,
        },
        {
          id: 'KLV',
          distance: 135.62,
          duration: 7605,
        },
        {
          id: 'XIR',
          distance: 149.37,
          duration: 6010,
        },
        {
          id: 'ZIK',
          distance: 140.29,
          duration: 7719,
        },
        {
          id: 'DRS',
          distance: 170.11,
          duration: 6770,
        },
        {
          id: 'ZTZ',
          distance: 216.65,
          duration: 8315,
        },
        {
          id: 'ZAU',
          distance: 252.98,
          duration: 9507,
        },
        {
          id: 'ZRX',
          distance: 204.6,
          duration: 8452,
        },
        {
          id: 'ZDN',
          distance: 214.8,
          duration: 8162,
        },
        {
          id: 'ZTT',
          distance: 263.48,
          duration: 10888,
        },
        {
          id: 'BRQ',
          distance: 221.61,
          duration: 8752,
        },
        {
          id: 'ZPF',
          distance: 233.33,
          duration: 12083,
        },
        {
          id: 'ZGA',
          distance: 277.92,
          duration: 10162,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
    {
      id: 'CZ-PRAG-PRA4',
      int_id: 301,
      active: true,
      code: 'CZ-PRAG-PRA4',
      icao: null,
      name: 'Prague Roztyly',
      slug: 'prague-roztyly-prague-czechia',
      alternative_names: [],
      rank: 1024,
      global_rank_dst: 1024,
      dst_popularity_score: 0,
      timezone: 'Europe/Prague',
      city: {
        id: 'prague_cz',
        name: 'Prague',
        code: 'PRG',
        slug: 'prague-czechia',
        subdivision: null,
        autonomous_territory: null,
        country: {
          id: 'CZ',
          name: 'Czechia',
          slug: 'czechia',
          code: 'CZ',
        },
        region: {
          id: 'central-europe',
          name: 'Central Europe',
          slug: 'central-europe',
        },
        continent: {
          id: 'europe',
          name: 'Europe',
          slug: 'europe',
          code: 'EU',
        },
      },
      special: [],
      location: {
        lat: 50.037867,
        lon: 14.476984,
      },
      alternative_departure_points: [
        {
          id: 'XYG',
          distance: 8.29,
          duration: 634,
        },
        {
          id: 'PFL',
          distance: 9.72,
          duration: 746,
        },
        {
          id: 'PRG',
          distance: 31.12,
          duration: 2098,
        },
        {
          id: 'PED',
          distance: 118.78,
          duration: 4950,
        },
        {
          id: 'XJP',
          distance: 116.2,
          duration: 4712,
        },
        {
          id: 'ZSC',
          distance: 150.26,
          duration: 8305,
        },
        {
          id: 'ZIT',
          distance: 134.48,
          duration: 5854,
        },
        {
          id: 'KLV',
          distance: 135.4,
          duration: 7040,
        },
        {
          id: 'ZIK',
          distance: 140.07,
          duration: 7153,
        },
        {
          id: 'XIR',
          distance: 155.45,
          duration: 6599,
        },
        {
          id: 'ZGE',
          distance: 165.35,
          duration: 7824,
        },
        {
          id: 'DRS',
          distance: 176.2,
          duration: 7360,
        },
        {
          id: 'ZAU',
          distance: 182.49,
          duration: 9476,
        },
        {
          id: 'ZTZ',
          distance: 173.52,
          duration: 8553,
        },
        {
          id: 'ZRX',
          distance: 210.68,
          duration: 9041,
        },
        {
          id: 'ZPF',
          distance: 220.53,
          duration: 11348,
        },
        {
          id: 'ZDN',
          distance: 199.92,
          duration: 7285,
        },
        {
          id: 'BRQ',
          distance: 206.73,
          duration: 7875,
        },
        {
          id: 'ZTT',
          distance: 269.57,
          duration: 11477,
        },
        {
          id: 'ZGA',
          distance: 284.01,
          duration: 10752,
        },
      ],
      tags: [],
      type: 'bus_station',
    },
  ],
};
