# Random Simpsons Quotes


**A fun project that displays random quotes from The Simpsons using HTML, CSS, and JavaScript.**  
This project allows users to fetch random quotes from the popular animated show "The Simpsons."
![Alt text](capture.png )
### Features
- **Random Quote Generation**: Users can click a button to fetch a new quote from The Simpsons.
- **Dynamic Content**: The quote and associated character image are displayed instantly upon fetching.
- **Loader Animation**: A visual loading animation  is displayed while the quote is being fetched.
- **Error Handling**: Displays an error message for network issues or when the API call fails.

## Description
This project provides a simple interface for users to interact with an API that returns quotes from "The Simpsons." Users can click a button to retrieve a random quote, which is then displayed along with an image of the character who said it.

The project utilizes HTML for structure, CSS for styling and animation, and JavaScript to handle the logic of fetching quotes from the API and updating the UI dynamically.

## Prerequisites
Before running this project, you should have a basic understanding of the following technologies:
- **HTML**: Used for structuring the user interface of the quote generator.
- **CSS**: Used to style the interface and provide a visually appealing layout.
- **JavaScript**: Handles the logic for fetching quotes from the API and updating the display based on user interactions.

## How to Use
1. Open the `index.html` file in your web browser.
2. Click the button labeled "Get a New Quote" to fetch a random quote.
3. The quote and the associated character's image will be displayed on the screen.
4. If there is an error while fetching the quote, an error message will be shown.

## Installation
To run this project locally:
1. Clone the repository or download the files.
2. Open `index.html` in any web browser.

## Installing Instructions
Explain how to set up and run your package/script on the user's local machine. Include steps like:
1. Clone the repository:
    ```bash
    git clone https://github.com/king04aman/All-In-One-Javascript-Projects.git
    ```
2. Navigate to the project directory:
    ```bash
    cd All-In-One-Javascript-Projects/Temperature-convertor
    ```
3. Open `index.html` in a web browser. 

## Author
- [Basset Gaëtan](https://github.com/gbasset)
