# Awesome Myanmar Unicode

A curated list of resources for Myanmar Unicode.

- [Awesome Myanmar Unicode](#awesome-myanmar-unicode)
  - [Fonts](#fonts)
  - [Browser Extensions](#browser-extensions)
  - [Libraries](#libraries)
  - [Typography Projects](#typography-projects)
  - [Applications](#applications)
  - [Communities](#communities)
---

## Fonts

- [Angoun](https://github.com/khmertype/Angoun)
- [Black](https://github.com/khmertype/MyanmarBlack)
- [Census](https://www.dropbox.com/s/el88jmvu2mkr28r/mmrCensus.v5.minbe5.ttf?dl=1)
- [Chatu](https://github.com/khmertype/Chatu)
- [ChatuLight](https://github.com/khmertype/ChatuLight)
- [Cherry Unicode](https://www.dropbox.com/s/bmqpcm8iomgom0w/Cherry%20Unicode.ttf?dl=0)
- [Gantgaw](https://github.com/khmertype/Gantgaw)
- [Kamjing-2](https://www.dropbox.com/s/t20u1keu4cme4uc/Kamjing-2.ttf)
- [Khyay](https://github.com/khmertype/Khyay)
- [Kuttar](https://github.com/khmertype/Kuttar)
- [Masterpiece Uni Round](http://prahita.sourceforge.net/files/win8/MasterpieceUniRound.ttf)
- [Masterpiece Uni Sans](http://prahita.sourceforge.net/)
- [Mon3 Anonta 1](http://code.google.com/p/mon2uni/downloads/list)
- [Myanmar3](http://code.google.com/p/myanmar3source/)
- [MyanmarSquareLight](https://github.com/khmertype/MyanmarSquareLight)
- [MyanmarYinmar](https://github.com/khmertype/MyanmarYinmar)
- [Myanmar Sans Pro](http://fonts.gstatic.com/ea/myanmarsanspro/v4/download.zip)
- [Myanmar Text](https://www.microsoft.com/typography/fonts/font.aspx?FMID=2143)
- [NamKhone Unicode](https://www.dropbox.com/s/wdyp2kgkgjxvix0/NamKhoneUnicode.ttf)
- [Nayone](https://github.com/khmertype/Nayone)
- [Nijaun](https://github.com/khmertype/Njaun)
- [NK SSmart2](https://www.dropbox.com/s/gg6nn6yq2wxb2ov/NK%20SSmart2.ttf)
- [NK SSmart3](https://www.dropbox.com/s/lptg4ucrgp94zq8/NK_SSmart3.ttf)
- [NK SSmart4](https://www.dropbox.com/s/uqyo5gi2gelsxfo/NK_SSmart4.ttf)
- [Noto Sans Myanmar](http://www.google.com/get/noto/#/family/noto-sans-mymr)
- [Noto Sans Myanmar UI - Regular](https://noto.googlecode.com/git/fonts/individual/unhinted/NotoSansMyanmarUI-Regular.ttf)
- [Noto Sans Myanmar UI - Bold](https://noto.googlecode.com/git/fonts/individual/unhinted/NotoSansMyanmarUI-Bold.ttf)
- [Noto Serif Myanmar](https://www.google.com/get/noto/#serif-mymr)
- [Padauk](http://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=Padauk)
- [Pauklay](https://github.com/khmertype/Pauklay)
- [Phetsot](https://github.com/khmertype/Phetsot)
- [Phiksel](https://github.com/khmertype/Phiksel)
- [PhikselSmooth](https://github.com/khmertype/PhikselSmooth)
- [Ponenyet](https://github.com/khmertype/Ponenyet)
- [Sabae](https://github.com/khmertype/Sabae)
- [Sagar](https://github.com/khmertype/Sagar)
- [Sanpya](https://github.com/khmertype/Sanpya)
- [Square](https://github.com/khmertype/Square)
- [Tagu](https://github.com/khmertype/Tagu)
- [Thanlwin](https://github.com/thanlwinsoft/thanlwinfont/releases)
- [Tharlon](https://code.google.com/p/tharlon-font/)
- [Thuriya](https://github.com/khmertype/Thuriya)
- [Warso](https://github.com/khmertype/Waso)
- [Yangon](http://khnews.info/fonts/Yangon.ttf)
- [YoeYar](http://www.mmunicode.org/news/yoeyarfont)

## Hybrid fonts

- [ZawDecode](http://guides.mmunicode.org/index.php/File:ZawDecode1.1_for_Windows01.ttf)

## Browser Extensions

*Google Chrome*

- [Magic Button](https://chrome.google.com/webstore/detail/magic-button/anonbddkeifgmiekhengieaajehcpdcg) - Generates zawgyi and unicode versions of your facebook status.
- [MyanmarFontTagger](https://chrome.google.com/webstore/detail/myanmarfonttagger/ildjeipiccodnhbpjebhhodledejdeip) - Use both Zawgyi-One and Unicode at the same time when you browse the web.
- [Tagu](https://chrome.google.com/webstore/detail/tagu/ddjpcdpfemhkibhpmgcdbfajdhgpegdk) - Detect and font embed zawgyi and unicode.
- [ZUZ](https://chrome.google.com/webstore/detail/zuz/eaonjjaifdnimemboemfipieiohpfggo) - Online/Offline Zawgyi <> Unicode text converter app for Chrome.
- [oneclick-fontchanger](https://chrome.google.com/webstore/detail/oneclick-fontchanger/lcibcnkknknmafeamdfcjlidodipfffe) - Let you switch between two (configurable) fonts for chrome via  two shortcuts (intended for unicode and zawgyi)
- [MUA Web Unicode Converter](https://chrome.google.com/webstore/detail/mua-web-unicode-converter/jnmdbgnckbbmblkbammnfagdmikchhnp?hl=en) - It checks web content and converts to Unicode text if they are written with Zawgyi. There's also extension for Safari.
- [Myanmar ZawGyi and Unicode Converter](https://chrome.google.com/webstore/detail/myanmar-zawgyi-and-unicod/elnngfdiiddneiinllplklpadfogajck) - Convert texts between Myanmar ZawGyi and Unicode from Chrome's tool bar.

*Firefox*

- [Magic Converter](https://addons.mozilla.org/en-US/firefox/addon/magicconverter/) - A myanmar text converter addon to convert between zawgyi and unicode for firefox.
- [Tagu](https://addons.mozilla.org/en-US/firefox/addon/tagu/) - Detect and font embed zawgyi and unicode.
- [Kain Na Yi](https://addons.mozilla.org/en-US/firefox/addon/kain-na-yi-plug-in/) - Works as helper for converting zawgyi to unicode.
- [Firefox Myanmar Converter](https://github.com/thanlwinsoft/firefoxmyext) - Converts Myanmar pages using non-Unicode fonts such as ZawGyi-One, WinInnwa, WinBurmese to Unicode. It allows sending data that was typed in Unicode as ZawGyi-One. A basic Myanmar Unicode spell-checker is also included.
- [MUA Web Unicode Converter](https://addons.mozilla.org/en-US/firefox/addon/mua-web-unicode-converter/) - It will check web content and convert to Unicode text if they are written with Zawgyi. Also available for Firefox for Android.

*Safari*

- [ZUZ Converter](http://cl.ly/aX6v/download/ZUZ%20Converter.safariextz) - Online/Offline Zawgyi <> Unicode text converter extension for Safari.
- [MUA Web Unicode Converter](http://cl.ly/c26M/download/MUA%20Web%20Unicode%20Converter.safariextz) - It will check web content and convert to Unicode text if they are written with Zawgyi.

*Opera*

- [MUA Web Unicode Converter](https://addons.opera.com/en-gb/extensions/details/mua-web-unicode-converter/) - It will check web content and convert to Unicode text if they are written with Zawgyi.

## Libraries

- General

  - [Paytan](https://github.com/trhura/paytan) - Collections of algorithms commonly used in myanmar language processing.
  - [Parabaik](https://github.com/Zwenexsys/parabaik) - Text converter (Zawgyi <> Unicode).

- Javascript

  - [jQuery mymr](https://github.com/andjc/jquery.mymr) - jQuery support to
  - [knayi-myscript](https://github.com/greenlikeorange/knayi-myscript) - Standalone Myanmar languages JavaScript library, use to build Myanmar Unicode standard easily.
  - [mm-unicoder](https://github.com/ha-shine/mm-unicoder) - Vanilla javascript library to convert english characters to myanmar unicode characters

- Ruby

  - [mmfont](https://github.com/yelinaung/mmfont) - A simple Ruby gem which converts zawgyi <=> unicode strings
  - [mmunicode_rails](https://github.com/dreamingblackcat/mmunicode_rails) - Myanmar font toolkit for rails app.

- PHP

  - [PHP Mmfont](https://github.com/setkyar/mmfont) - Simple PHP package whcich converts zawgyi <=> unicode.

- Python

  - [mmfont](https://github.com/khzaw/mmfont) - A simple Python package which converts zawgyi <=> unicode strings

* Multi
  - [Rabbit](https://github.com/Rabbit-Converter) - Zawgyi <=> Unicode conversion library with Java, Obj-C, Swift, Python, PHP, Ruby, Node, Elixir, Zephir language support.
  - [Myanmar Tools](https://github.com/googlei18n/myanmar-tools) - Zawgyi-One (or) Unicode detector library with C++, Java, and JavaScript (both Node.js and browser).

## Typography Projects

- [Beautiful Burmese Type](https://khzaw.github.io/beautiful-burmese-type/)
- [Myanmar Web](https://github.com/enabling-languages/myanmarweb)

## Applications

*Mac OSX*

* [Unicode-Zawgyi-Converter](https://github.com/saturngod/Unicode-Zawgyi-Converter/releases) - Unicode <=> Zawgyi Converter for Mac.

## Communities
 - [Myanmar Unicode Area](http://www.mmunicode.org/) - [Facebook](https://www.facebook.com/groups/mmUnicode)
 - [Unicode Today](http://www.unicode.today/)
 - [Myanmar Language](http://myanmarlanguage.org/)
