# 操作系统内置的中文字体

## Windows

- 宋体，即中易宋体 (SimSun)，从 Windows 95 开始内置；在 Windows XP SP3 中会额外安装宋体-PUA (SimSun-PUA)（包含在 simsun.ttc 文件中）；微软曾经为 Windows 2000 和 XP 提供 GB18030 支持包，增加 SimSun18030.ttc 字体文件，即 SimSun-18030；Windows Vista 后增加 Unicode 扩展 B 区字体 SimSun-ExtB
- 新宋体，即中易新宋体 (NSimSun)，从 Windows XP 开始内置，和普通中易宋体的区别在于其字体信息被标记为等宽字体（中易宋体被标记为比例字体）
- 黑体，即中易黑体 (SimHei)，从 Windows 95 开始内置
- 楷体_GB2312，即长城楷体 (KaiTi_GB2312)，仅 Windows 95/98/XP 等旧版本 Windows 内置
- 仿宋_GB2312，即长城仿宋 (FangSong_GB2312)，仅 Windows 95/98/XP 等旧版本 Windows 内置
- 楷体，即中易楷体 (KaiTi)，从 Windows Vista 开始内置，在 Windows 10 中需要手动下载
- 仿宋，即中易仿宋 (FangSong)，从 Windows Vista 开始内置，在 Windows 10 中需要手动下载
- 等线，即方正等线体 (DengXian)，从 Windows 10 开始内置
- 细明体 (MingLiU)、细明体_HKSCS (MingLiU_HKSCS)
- 新细明体 (PMingLiU)，从 Windows XP 开始内置，和细明体的区别在于将 ASCII 字符从等宽字体改为比例字体（Proportional Font）
- 标楷体 (DFKai-SB)，从 Windows 95 开始跟随繁体中文版的 Windows 安装
- 微软雅黑 (Microsoft YaHei) 、微软正黑 (Microsoft JhengHei)，从 Windows Vista 开始内置
- 微软雅黑 UI (Microsoft YaHei UI)、微软正黑 UI (Microsoft JhengHei UI)，从 Windows 8 开始内置，和微软雅黑、微软正黑的行距、部分字形略有差异
- 开发中的新字体，代号 Noble Scarlet

注意：其中楷体_GB2312和仿宋_GB2312虽然字体文件名为 **simkai.ttf** 和 **simfang.ttf**，但并非像 **simsun.ttc**、**simhei.ttf** 一样出自 ZHONGYI Electronic Co.（北京中易中标电子信息技术有限公司），而是由 GreatWall Computer Co.（疑似中国长城计算机集团公司）开发。Windows Vista 以及之后的系统内置的 **simkai.ttf** 和 **simfang.ttf** 为北京中易中标电子信息技术有限公司开发。

早期 Microsoft Office 版本内置的隶书（LiSu，**simli.ttf**）和幼圆（YouYuan，**simyou.ttf**）版权属于 Stone Co.（疑似北京四通利方信息技术有限公司）。`sim-*` 表示 Simplified 简体。

对于 Windows XP 以及更早版本的 Windows 系统，不同语言版本内置的字体不同，仅简体中文版默认包含宋黑楷仿字体。

## OS X & macOS

- Hei (Hei Regular、SIL-Hei-Med-Jian)
- Kai (Kai Regular、SIL-Kai-Reg-Jian)
- 标楷体 (DFKaiShu-SB)
- GB18030 Bitmap，点阵字体
- 华文宋体 (STSong)，华文黑体 (STHeiti)，华文细黑 (STXihei)，华文楷体 (STKaiti)，华文仿宋 (STFangsong)
- 苹果俪细宋 (Apple LiSung Light)、苹果俪中黑 (Apple LiGothic Medium)
- 俪宋 Pro (LiSong Pro)，俪黑 Pro (LiHei Pro)，即华康俪宋和华康俪黑
- 宋体-简 (Songti SC)、宋体-繁 (Songti TC)，新版华文宋体，从 OS X 10.6 Snow Leopard 开始内置
- 黑体-简 (Heiti SC)、黑体-繁 (Heiti TC)，新版华文黑体，从 OS X 10.6 Snow Leopard 开始内置
- 楷体-简 (Kaiti SC)、楷体-繁 (Kaiti TC)，新版华文楷体，从 OS X 10.6 Snow Leopard 开始内置
- ヒラギノ角ゴ 簡体中文 (Hiragino Sans GB，中文名称：冬青黑体简体中文)，从 OS X 10.6 Snow Leopard 开始内置
- ヒラギノ角ゴ 繁体中文 (Hiragino Sans CNS，中文名称：冬青黑体繁体中文)，首次出现于 OS X 10.6 Snow Leopard 开发预览版，macOS 10.12 Sierra 开始内置
- 雅痞-简 (Yuppy SC)、雅痞-繁 (Yuppy TC)，蒙纳，从 OS X 10.8 Mountain Lion 开始内置
- 兰亭黑-简 (Lantinghei SC)、兰亭黑-繁 (Lantinghei TC)，方正，从 OS X 10.9 Mavericks 开始内置
- 行楷-简 (Xingkai SC)、行楷-繁 (Xingkai TC)，华文，从 OS X 10.9 Mavericks 开始内置
- 圆体-简 (Yuanti SC)、圆体-繁 (Yuanti TC)，华文，从 OS X 10.9 Mavericks 开始内置
- 报隶-简 (Baoli SC)、报隶-繁 (Baoli TC)，华文，从 OS X 10.9 Mavericks 开始内置
- 隶变-简 (Libian SC)、隶变-繁 (Libian TC)，华文，从 OS X 10.9 Mavericks 开始内置
- 魏碑-简 (Weibei SC)、魏碑-繁 (Weibei TC)，文鼎，从 OS X 10.9 Mavericks 开始内置
- 娃娃体-简 (Wawati SC)、娃娃体-繁 (Wawati TC)，华康，从 OS X 10.9 Mavericks 开始内置
- 翩翩体-简 (HanziPen SC)、翩翩体-繁 (HanziPen TC)，华康，从 OS X 10.9 Mavericks 开始内置
- 手札体-简 (Hannotate SC)、手札体-繁 (Hannotate TC)，华康，从 OS X 10.9 Mavericks 开始内置
- 苹方-简 (PingFang SC)、苹方-繁 (PingFang TC)、苹方-港 (PingFang HK)，从 OS X 10.11 El Capitan 开始内置
- 凌慧体-简 (LingWai SC)、凌慧体-繁 (LingWai TC)，蒙纳，从 macOS 10.12 Sierra 开始内置

注意：其中简体和繁体版本发布的时间可能并不一致。

## iOS

- 华文黑体，即黑体-简 (Heiti SC)、黑体-繁 (Heiti TC)
- 苹方，从 iOS 9 开始内置

## GNU/Linux

- 文泉驿点阵宋体
- 文泉驿正黑
- 文泉驿微米黑
- 思源黑体
- 思源宋体
- 思源等宽

## Android

- Droid Sans Fallback，社区从该字体衍生出文泉驿微米黑
- Noto Sans CJK (2014年7月16日发布)，中文部分即思源黑体，从 5.0 Lollipop (2014年10月15日发布) 开始内置，只包含 Regular 字重
- Noto Serif CJK (2017年4月5日发布)，中文部分即思源宋体，从 9.0 Pie (2018年8月7日发布) 开始内置，只包含 Regular 字重

### MIUI (小米, 红米)

- 小米兰亭，随 MIUI 8 发布，包含 Thin、Light、Regular、Bold 4个字重，由方正字库制作
- 小米兰亭Pro，随 MIUI 11 发布，可变字体，包含10个字重，由方正字库制作

### EMUI (华为, 荣耀)

- Huawei Font, 由蒙纳制作

### Funtouch OS (vivo)

- vivo type，由方正字库制作
- 汉仪旗黑

### ColorOS (OPPO, Realme)

- OPPO Sans，由汉仪字库制作

### Flyme (魅族)

- Flyme, 基于思源黑体

## 参考链接

- [Fonts and supported products - Typography | Microsoft Docs](https://docs.microsoft.com/en-us/typography/font-list/)
- [如何保证网页的字体在各平台都尽量显示为最高质量的黑体？ - 梁海的回答 - 知乎](https://www.zhihu.com/question/19911793/answer/13329819)
- [Windows 7 中的 SimSun-ExtB 是什么字体，为何与中易宋体 SimSun 显示出来不一样？ - 知乎](https://www.zhihu.com/question/20394954)
- [微软雅黑和微软正黑的 UI 版与普通版有何区别？ - 知乎](https://www.zhihu.com/question/20137844)
- [如何评价 Windows 10 17025 测试版开始出现的「新版微软雅黑」？ - 知乎](https://www.zhihu.com/question/67196637)
- [「俪黑」有什么版本？有简体版本吗？ - 知乎](https://www.zhihu.com/question/19705760)
- [OS X 提供了哪些中文黑体？ - 知乎](https://www.zhihu.com/question/20158887)
- [OS X Mountain Lion 和 iOS 6 的自带字体有何变化？OS X 新增的 8 款中文字体是哪些？ - 知乎](https://www.zhihu.com/question/20291055)
- [OS X 的默认中文字体是什么？ - 知乎](https://www.zhihu.com/question/19693837)
- [如何看待小米联合方正发布「小米兰亭」？ - 知乎](https://www.zhihu.com/question/45967799)
