<p align="center">
  <a href="http://fontisto.com"><img src="http://fontisto.com/assets/images/fontisto-cover-1.png"></a>
  
  <p align="center">
   Fontisto gives you scalable vector icons that can instantly be customized: size, color, drop shadow and anything that can be done with the power of CSS.
    <br>
    <a href="http://www.fontisto.com/get-started"><strong>Fontisto get-started</strong></a> &middot;
    <a href="http://fontisto.com/examples"><strong>Fontisto example</strong></a> &middot;
    <a href="http://fontisto.com/icons"><strong>Fontisto icons</strong></a> &middot;
    <a href="http://fontisto.com/icons-cheatsheet"><strong>Fontisto cheatsheet</strong></a>
  </p>
  <p align="center">
    <a href="https://www.npmjs.org/package/fontisto">
      <img src="https://img.shields.io/npm/v/fontisto.svg?style=flat" alt="npm">
    </a>
  </p>
</p>

## Fontisto (The iconic font and CSS toolkit)

Fontisto is a full suite of 616+ pictographic icons for easy scalable vector graphics on websites,
created and maintained by [Kenan Gündoğan](https://www.linkedin.com/in/kenangundogan).
Stay up to date with the latest release and announcements on Twitter:
[@fontisto](http://twitter.com/fontisto).

Get started at http://fontisto.com


## Quick start
[![Build Status](https://travis-ci.org/kenangundogan/fontisto.svg?branch=master)](https://travis-ci.org/kenangundogan/fontisto)
[![npm version](https://badge.fury.io/js/fontisto.svg)](https://badge.fury.io/js/fontisto)
[![PHP version](https://badge.fury.io/ph/kenangundogan%2Ffontisto.svg)](https://badge.fury.io/ph/kenangundogan%2Ffontisto)
[![Meteor Atmosphere](https://img.shields.io/badge/meteor-kenangundogan/fontisto-blue.svg)](https://atmospherejs.com/kenangundogan/fontisto)

- [Download the latest release.](https://codeload.github.com/kenangundogan/fontisto/zip/master)
- Clone the repo: `git clone https://github.com/kenangundogan/fontisto.git`
- Install with [npm](https://www.npmjs.com/package/fontisto): `npm install fontisto`
- Install with [bower](https://bower.io): `bower install fontisto`
- Install with [yarn](https://yarnpkg.com/en/package/fontisto): `yarn add fontisto`
- Install with [composer](https://packagist.org/packages/kenangundogan/fontisto): `composer require kenangundogan/fontisto`
- Install with [meteor](https://atmospherejs.com/kenangundogan/fontisto): `meteor add kenangundogan:fontisto`


## What's included
Within the download you'll find the following directories and files, logically grouping common assets and providing both compiled and minified variations. 

#### Outuput File

```
	css/
	├── fontisto/
		├── fontisto.css
		├── fontisto.css.map
		├── fontisto.min.css
		└── fontisto.min.css.map
```

#### Source File (Sass/Scss)
```
	sass/
	├── fontisto/
		├── fontisto.scss
		├── _variables.scss
		├── _color.scss
		├── _font.scss
		├── _icons.scss
		├── _animated.scss
		├── _list.scss 
		├── _bordered.scss
		├── _rotated.scss
		├── _stacked.scss
		├── _fixed-width.scss
		└── _screen-readers.scss
```
#### Source File (Less)
```
	less/
	├── fontisto/
		├── fontisto.less
		├── variables.less
		├── color.less
		├── font.less
		├── icons.less
		├── animated.less
		├── list.less 
		├── bordered.less
		├── rotated.less
		├── stacked.less
		├── fixed-width.less
		└── screen-readers.less
```
#### Source File (Stylus)
```
	stylus/
	├── fontisto/
		├── fontisto.styl
		├── variables.styl
		├── color.styl
		├── font.styl
		├── icons.styl
		├── animated.styl
		├── list.styl 
		├── bordered.styl
		├── rotated.styl
		├── stacked.styl
		├── fixed-width.styl
		└── screen-readers.styl
```


## Versioning
Fontisto will be maintained under the Semantic Versioning guidelines as much as possible. Releases will be numbered with the following format:
```
<major>.<minor>.<patch>
```

## License

- The Fontisto font is licensed under the SIL OFL 1.1:
  - http://scripts.sil.org/OFL
- Fontisto CSS, LESS, and Sass files are licensed under the MIT License:
  - https://opensource.org/licenses/mit-license.html
- The Fontisto documentation is licensed under the CC BY 3.0 License:
  - http://creativecommons.org/licenses/by/3.0/
- Attribution is no longer required as of Fontisto 3.0, but much appreciated:
  - `Fontisto by Kenan Gündoğan - http://fontisto.com`
- Full details: http://fontisto.com/license


## Copyright and license
Designed and built by @kenangundogan, @ulasderin and @mstfsnc
<br>
2017 Currently - Code licensed [MIT License](https://github.com/kenangundogan/fontisto/blob/master/LICENSE)


<p align="center">
  <a href="http://fontisto.com/browser-addon"><img src="http://fontisto.com/assets/images/browser-addon-screen-shot/fontisto-browser-extension-1280x800-2.png"></a>
  
  <p align="center">
   Fontisto browser addons (chrome, firefox, opera)
    <br>
    <a href="http://fontisto.com/browser-addon"><strong>Fontisto Browser Addons</strong></a> &middot;
    <a href="https://chrome.google.com/webstore/detail/fontisto/gnmccfjgnhfoihcpglcogbclihomaidh?hl=en"><strong>Fontisto Chrome Extension</strong></a> &middot;
    <a href="https://addons.mozilla.org/tr/firefox/addon/fontisto/"><strong>Fontisto Firefox Addon</strong></a> &middot;
    <a href="https://addons.opera.com/tr/extensions/details/fontisto/"><strong>Fontisto Opera Addon</strong></a> &middot;
  </p>
</p>

## ToDo List (font with css)
- [x] font width css (**completed**)
- [x] scss to css (**completed**)
- [x] less to css (**completed**)
- [x] stylus to css (**completed**)

## ToDo List (Advanced Packaged)
- [ ] Svg with js
- [ ] Svg sprite
- [ ] Vue.js
- [ ] React
- [ ] Angular

## ToDo List (icon set)
- [x] Brand (**completed**)
- [x] Browser (**completed**)
- [x] Accessibility (**completed**)
- [x] Chart (**completed**)
- [x] currency (**completed**)
- [x] Directional (**completed**)
- [x] Form Control (**completed**)
- [x] Gender (**completed**)
- [x] Hand (**completed**)
- [x] Payment (**completed**)
- [x] Player (**completed**)
- [x] Spinner (**completed**)
- [x] Transportation (**completed**)
- [x] Web Application (**completed**)
- [x] Text Editor (**completed**)
- [x] Weather Foreces (**completed**)
- [x] Emoji (**completed**)
- [x] Shopping (**completed**)
- [x] Snow Flake (**completed**)
- [x] Travel (**completed**)
- [ ] Sports
- [x] Medical (**completed**)
- [ ] Eat
- [ ] Shapes
