# Contributing to Fontisto

Looking to contribute something to Fontisto? **Here's how you can help.**



## Requesting new icons

New icons mostly start as requests by the [Fontisto community on GitHub](../../issues). Want to request a new icon? Here are some things to keep in mind:

1. Please do not request comprehensive sets of icons related to a very specific field.
2. Please [search](../../search?type=Issues) to see if your icon request already exists. If a request is found, please add a 👍 reaction to that one.
3. Please make requests for single icons, unless you are requesting a couple of strictly related icons (e.g., like/dislike).
4. Please and thank you if you include the following:
  - Title your [new issue](../../issues/new?title=Icon%20Request:%20icon-) `Icon request: icon-name` (e.g., `Icon request: icon-heart`).
  - Include a few use cases for your requested icon. How do you plan on using it?
  - Request concrete objects



## Suggesting icon keyword addition/removal

Icon filters are maintained by the [Fontisto community on GitHub](../../pulls?q=is%3Apr+label%3Adoc).

If you feel that an icon

* is missing keyword(s)
* contains invalid keyword(s)

please send a [PR](https://help.github.com/articles/using-pull-requests/) to the `master` branch.



## Reporting issues

We only accept issues that are icon requests, bug reports, or feature requests. Bugs must be isolated and reproducible problems that we can fix within the Fontisto core. Please read the following guidelines to ensure you are the paragon of bug reporting.

1. **Search for existing issues.** We get a lot of duplicate issues, and you'd help us out a lot by first checking if someone else has reported the same issue. Moreover, the issue may have already been resolved with a fix available.
2. **Create an isolated and reproducible test case.** Be sure the problem exists in Fontisto's code with a [reduced test case](http://css-tricks.com/reduced-test-cases/) that should be included in each bug report.
3. **Include a live example.** Make use of jsFiddle, jsBin, or Codepen to share your isolated test cases.
4. **Share as much information as possible.** Include operating system and version, browser and version, version of Fontisto, etc. where appropriate. Also include steps to reproduce the bug.



## Coding standards: HTML

- Two spaces for indentation, never tabs
- Double quotes only, never single quotes
- Use tags and elements appropriate for an HTML5 doctype (e.g., self-closing tags)



## Coding standards: CSS

- Adhere to the [Recess CSS property order](http://markdotto.com/2011/11/29/css-property-order/)
- Multiple-line approach (one property and value per line)
- Always a space after a property's colon (e.g., `display: block;` and not `display:block;`)
- End all lines with a semi-colon
- For multiple, comma-separated selectors, place each selector on its own line



## License

By contributing your code, you agree to license your contribution under the terms of the MIT License:
- http://opensource.org/licenses/mit-license.html


