# Latest FontAwesome-Icons / Material-Icons
Guide to get latest Google's Material Design Icons & FontAwesome Pro Icons to work for your Local Developement Environments

[![Build Status](https://travis-ci.com/kathirr007/FA-MD-Icons-Updated.svg?branch=master)](https://travis-ci.com/kathirr007/FA-MD-Icons-Updated)

**[Latest FontAwesome-Icons / Material-Icons](git@github.com:kathirr007/FA-MD-Icons-Updated)** is the Guide to get latest Google's Material Design Icons & FontAwesome Pro Icons to work for your Local Developement Environments.

For latest working icon fonts please checkout **[here](https://kathirr007.github.io/FA-MD-Icons-Updated/icons-test.html)**

## Testing setup
```
npm install
```

### Compiles and hot-reloads for development
```
gulp
```
### To check the latest fonts 
open index.html and see working icons

## Guide to Get latest Material-Icons for your local Develeopment Environment or for Self hosting.

### Material Icons Regular

Filenames are always the same. Each file has its unique last char + filetype:

"**flUhRq6tzZclQEJ-Vdg-IuiaDsN**" + [ **Y**.eot | **c**.woff2 | **a**.woff | **Z**.ttf ]

```
https://fonts.gstatic.com/s/materialicons/v48/flUhRq6tzZclQEJ-Vdg-IuiaDsNc.woff2
https://fonts.gstatic.com/s/materialicons/v48/flUhRq6tzZclQEJ-Vdg-IuiaDsNY.eot
https://fonts.gstatic.com/s/materialicons/v48/flUhRq6tzZclQEJ-Vdg-IuiaDsNa.woff
https://fonts.gstatic.com/s/materialicons/v48/flUhRq6tzZclQEJ-Vdg-IuiaDsNZ.ttf
```

For future updates, just check the lastest version available from here:  
https://fonts.googleapis.com/icon?family=Material+Icons

Replace the old version number with the new one.

### Material Icons Outlined

Filenames are always the same. Each file has its unique last char + filetype: 

"**gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUc**" + [ **e**.woff2 | **a**.eot | **Y**.woff | **d**.otf ]

```
https://fonts.gstatic.com/s/materialiconsoutlined/v13/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUce.woff2
https://fonts.gstatic.com/s/materialiconsoutlined/v13/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUca.eot
https://fonts.gstatic.com/s/materialiconsoutlined/v13/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUcY.woff
https://fonts.gstatic.com/s/materialiconsoutlined/v13/gok-H7zzDkdnRel8-DQ6KAXJ69wP1tGnf4ZGhUcd.otf
```

For future updates, just check the lastest version available from here:  
https://fonts.googleapis.com/css?family=Material+Icons+Outlined

Replace the old version number with the new one.

### Material Icons Round

Filenames are always the same. Each file has its unique last char + filetype: 

"**LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwm**" + [ **P**.woff2 | **L**.eot | **J**.woff | **M**.otf ]

```
https://fonts.gstatic.com/s/materialiconsround/v13/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwmP.woff2
https://fonts.gstatic.com/s/materialiconsround/v13/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwmL.eot
https://fonts.gstatic.com/s/materialiconsround/v13/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwmJ.woff
https://fonts.gstatic.com/s/materialiconsround/v13/LDItaoyNOAY6Uewc665JcIzCKsKc_M9flwmM.otf
```

For future updates, just check the lastest version available from here:  
https://fonts.googleapis.com/css?family=Material+Icons+Round

Replace the old version number with the new one.

### Material Icons Sharp

Filenames are always the same. Each file has its unique last char + filetype: 

"**oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmv**" + [ **R**.woff2 | **V**.eot | **X**.woff | **S**.ttf ]

```
https://fonts.gstatic.com/s/materialiconssharp/v14/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmvR.woff2
https://fonts.gstatic.com/s/materialiconssharp/v14/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmvV.eot
https://fonts.gstatic.com/s/materialiconssharp/v14/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmvX.woff
https://fonts.gstatic.com/s/materialiconssharp/v14/oPWQ_lt5nv4pWNJpghLP75WiFR4kLh3kvmvS.otf
```

For future updates, just check the lastest version available from here:  
https://fonts.googleapis.com/css?family=Material+Icons+Sharp

Replace the old version number with the new one.

### Material Icons Two Tone

Filenames are always the same. Each file has its unique last char + filetype: 

"**hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCu**" + [ **0**.woff2 | **w**.eot | **y**.woff | **3**.ttf ]

```
https://fonts.gstatic.com/s/materialiconstwotone/v12/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCu0.woff2
https://fonts.gstatic.com/s/materialiconstwotone/v12/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCuw.eot
https://fonts.gstatic.com/s/materialiconstwotone/v12/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCuy.woff
https://fonts.gstatic.com/s/materialiconstwotone/v12/hESh6WRmNCxEqUmNyh3JDeGxjVVyMg4tHGctNCu3.otf
```

For future updates, just check the lastest version available from here:  
https://fonts.googleapis.com/css?family=Material+Icons+Two+Tone

Replace the old version number with the new one.

## Guide to use FontAwesome Icons in your local Develeopment Environment.

- Visit the FontAwesome icons page https://fontawesome.com/icons?d=gallery

- Inspect using chrome devtools and navigate to sources tab, in that find any directory with the name containing "pro", eg:"pro-next.fontawesome.com"

- Inside that you will get the latest releases files like "css" & "webfonts"

- In "css" directory you can find "all.css" or "pro.min.css" and in "webfonts" directory you can find font files

- Now you know what to do to get things work in local Develeopment.

### Hint to download all webfonts at once
- Use Internet Download Manager to download all at once.
- Copy the links below 

```
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-brands-400.eot
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-brands-400.svg
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-brands-400.ttf
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-brands-400.woff
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-brands-400.woff2
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-light-300.eot
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-light-300.svg
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-light-300.ttf
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-light-300.woff
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-light-300.woff2
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-regular-400.eot
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-regular-400.svg
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-regular-400.ttf
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-regular-400.woff
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-regular-400.woff2
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-solid-900.eot
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-solid-900.svg
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-solid-900.ttf
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-solid-900.woff
https://pro-next.fontawesome.com/releases/v5.8.2/webfonts/fa-solid-900.woff2
```

**for latest as of Oct'19**

```
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.5.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.5.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.5.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.5.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.5.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.7.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.7.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.7.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.7.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.7.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.9.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.9.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.9.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.9.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.9.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.10.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.10.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.10.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.10.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.10.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.11.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.11.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.11.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.11.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.11.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.13.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.13.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.13.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.13.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.0.13.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.1.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.2.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.2.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.2.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.2.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.2.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.3.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.3.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.3.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.3.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.3.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.4.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.5.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.5.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.5.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.5.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.5.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.6.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.7.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.8.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.9.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.9.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.9.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.9.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.9.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.10.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.5.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.7.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.9.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.10.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.11.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.13.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.2.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.3.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.9.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.5.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.7.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.9.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.10.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.11.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.13.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.2.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.3.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.9.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.5.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.7.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.9.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.10.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.11.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.13.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.2.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.3.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.9.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.5.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.7.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.9.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.10.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.11.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.13.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.2.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.3.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.9.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.5.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.7.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.9.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.10.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.11.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.0.13.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.1.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.2.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.3.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.4.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.6.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.7.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.8.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.9.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.10.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.5.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.7.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.9.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.10.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.11.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.13.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.2.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.3.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.3.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.9.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.5.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.7.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.9.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.10.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.11.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.13.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.2.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.3.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.3.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.5.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.7.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.9.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.10.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.11.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.13.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.2.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.3.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.3.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.9.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.5.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.7.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.9.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.10.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.11.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.13.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.2.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.3.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.3.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.9.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.5.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.7.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.9.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.10.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.11.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.0.13.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.1.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.2.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.3.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.4.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.6.3.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.7.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.8.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.9.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.10.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.5.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.7.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.9.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.10.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.11.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.2.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.3.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.6.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.8.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.9.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.5.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.7.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.9.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.10.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.11.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.2.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.3.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.6.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.8.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.9.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.5.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.7.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.9.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.10.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.11.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.2.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.3.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.6.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.8.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.9.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.5.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.7.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.9.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.10.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.11.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.2.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.3.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.6.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.8.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.9.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.5.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.7.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.9.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.10.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.0.11.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.1.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.2.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.3.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.4.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.6.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.7.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.8.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.9.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.10.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-duotone-900-pro-5.11.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-light-300-pro-5.11.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-regular-400-pro-5.11.2.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.0.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.0.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.0.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.0.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.0.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.1.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.1.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.1.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.1.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.1.woff2
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.2.eot
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.2.svg
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.2.ttf
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.2.woff
https://kit-pro.fontawesome.com/algo/2/webfonts/fa-solid-900-pro-5.11.2.woff2
```

- Now select Tasks --> Add batch download from clipboard

- Check All and download at once

- For future releases just change the version number and download them

... Enjoy FontAwesome Pro Icons ....
