# Spring MVC sample

[![Build Status](https://travis-ci.org/kartoch/spring-mvc-sample.svg?branch=master)](https://travis-ci.org/kartoch/spring-mvc-sample)   [![Coverage Status](https://coveralls.io/repos/github/kartoch/spring-mvc-sample/badge.svg?branch=master)](https://coveralls.io/github/kartoch/spring-mvc-sample?branch=master)

This is a Spring Boot template to be used as a basic project for teaching
purposes but also as a starter kit for spring newcomers and students.
  
## Description

The project is a simple web application:
- authenticate user (default user: admin/admin)
- list users
- add user (only admin user can create new user)

It is based on Spring boot 1.5.3.RELEASE and includes the following components:
* **spring-boot-starter-data-jpa** for spring-data-jpa support
* **spring-boot-starter-web** for spring MVC support
* **spring-boot-starter-security** for Spring security support
* **spring-boot-starter-test** for Spring test support

Additionally, it includes the following helpful components: 
* **spring-boot-starter-tomcat** and **tomcat-embed-jasper** to embed a tomcat instance 
in the application and starts it from maven goals 
(no tomcat setup required !)
* **spring-boot-devtools** for hot swapping
* **H2** in-memory database for fast development (no local database required !)

For the web part, views are render via Servlets/JSP/JSTL and a webjar 
containing jquery is available.

## Try it !

You can launch the project via the following maven goal:

    mvn spring-boot:run

After few seconds, the web application is available on http://localhost:8080/

## Web

## Persitance



## Tests