<?php
/*
	本插件：$this->model('worker')->方法名();
	其他地方调用：model('jy_scrm/worker')->方法名();
*/
namespace jy_scrm;
defined('BY_JYA') or exit('error');
class worker extends \plugin{
	public function get_userid($workerid){
		$userid=pdo_getcolumn('jy_scrm_worker',array('id'=>$workerid,'uniacid'=>$_SESSION['uniacid']),'userid');
		return $userid;
	}
	public function get_workerid($userid){
		$workerid=pdo_getcolumn('jy_scrm_worker',array('id'=>$userid,'uniacid'=>$_SESSION['uniacid']),'id');
		return $workerid;
	}
	public function batch($bumenid,$fetch_child=1){
		if(!$bumenid){
			exi('请传入部门ID','error');
		}
		$userlist=model('core/wxwork_userapi')->get_worker_batch($bumenid,$fetch_child);
		foreach($userlist as $item){
			$ischeck=pdo_getcolumn('jy_scrm_worker',array('userid'=>$item['userid'],'uniacid'=>$_SESSION['uniacid']),'id');
			if($ischeck){
				continue;
			}
			$this->create($item);
		}
	}
	public function batchinfo($bumenid,$fetch_child=1){
		if(!$bumenid){
			exi('请传入部门ID','error');
		}
		$userlist=model('core/wxwork_userapi')->get_worker_batchinfo($bumenid,$fetch_child);
		foreach($userlist as $item){
			$ischeck=pdo_getcolumn('jy_scrm_worker',array('userid'=>$item['userid'],'uniacid'=>$_SESSION['uniacid']),'id');
			if($ischeck){
				continue;
			}
			$this->create($item);
		}
	}
	public function create($params){
		$department=array();
		foreach($params['department'] as $k=>$item){
			$department[]=array('id'=>$item,'order'=>$params['order'][$k],'is_leader_in_dept'=>$params['is_leader_in_dept'][$k]);
		}
		$worker=array(
			'userid'=>$params['userid'],
			'name'=>$params['name'],
			'open_userid'=>$params['open_userid'],
			'department'=>ijson_encode($department),
			'position'=>$params['position'],
			'mobile'=>$params['mobile'],
			'gender'=>$params['gender'],
			'email'=>$params['email'],
			'avatar'=>$params['avatar'],
			'thumb_avatar'=>$params['thumb_avatar'],
			'telephone'=>$params['telephone'],
			'alias'=>$params['alias'],
			'status'=>$params['status'],
			'address'=>$params['address'],
			'hide_mobile'=>$params['hide_mobile'],
			'english_name'=>$params['english_name'],
			'open_userid'=>$params['open_userid'],
			'main_department'=>$params['main_department'],
			'extattr'=>ijson_encode($params['extattr']['attrs']),
			'qr_code'=>$params['qr_code'],
			'external_position'=>$params['external_position'],
			'external_profile'=>ijson_encode($params['external_profile']),
		);
		$id=pdo_getcolumn('jy_scrm_worker',array('userid'=>$params['userid'],'uniacid'=>$_SESSION['uniacid']),'id');
		if($id){
			$this->pdo_update('worker',$worker,array('userid'=>$params['userid'],'uniacid'=>$_SESSION['uniacid']));	
		}else{
			$worker['uniacid']=$_SESSION['uniacid'];
			$worker['createtime']=$params['createtime']?:TIMESTAMP;
			$this->pdo_insert('worker',$worker);
			$id=$this->pdo_insertid();
		}
		return $id;
	}
	//查询企业红包记录
	public function workwxredpack($params){
		$api_url='https://api.mch.weixin.qq.com/mmpaymkttransfers/queryworkwxredpack';
		$fields=array('mch_billno');
		foreach($fields as $key){
			if(!$params[$key]){
				return error('关键参数未设置：'.$key);
			}
		}
		$post=array(
			'nonce_str'=>random(32),
			'mch_billno'=>$params['mch_billno'],//商户订单号
			'mch_id'=>$this->config['mch_id'],
			'appid'=>$this->config['appid'],
			'sign'=>$sign,
		);
		return $this->request($api_url,$post,true,true);
	}
	public function get_dimissionworker($page_id=0,$cursor='',$page_size=100){
		$content=model('core/wxwork_userapi')->get_dimissionworker_members($page_id,$cursor,$page_size);
		foreach($content['info'] as $item){
			$this->createdimission($item);
		}
		if($content['next_cursor'] && !$content['is_last']){
			$this->get_dimissionworker($page_id,$content['next_cursor'],$page_size);
		}
		return true;
	}
	public function createdimission($params){
		$data=array(
			'handover_userid'=>$params['handover_userid'],
			'external_userid'=>$params['external_userid'],
			'dimission_time'=>$params['dimission_time'],
		);
		$id=pdo_getcolumn('jy_scrm_worker_dimission',array('handover_userid'=>$params['handover_userid'],'external_userid'=>$params['external_userid'],'uniacid'=>$_SESSION['uniacid']),'id');
		if($id){
			continue;
		}else{
			$data['uniacid']=$_SESSION['uniacid'];
			$this->pdo_insert('worker_dimission',$data);
			$id=$this->pdo_insertid();
		}		
		$this->pdo_update('worker',array('status'=>4,'dimissiontime'=>$params['dimission_time']),array('userid'=>$params['external_userid'],'uniacid'=>$_SESSION['uniacid']));
		return $id;
	}
}
?>