<?php
/*
	订单状态变更函数
	//$this->order_change(array('order_id'=>'2','status'=>1));
	$params=array(
		'order_id'=>'订单ID',
		'status'=>'订单状态',
	);
*/
defined('BY_JYA') or exit('error');
$order=pdo_get('jy_meye_order',array('id'=>$params['order_id']));
if(!$order){
	return error('订单不存在！');
}
//更新订单状态
pdo_update('jy_meye_order',array('status'=>$params['status']),array('id'=>$params['order_id']));
//新增订单变更日志
$insert=array(
	'uniacid'=>$order['uniacid'],
	'order_id'=>$order['id'],
	'old_status'=>$order['status'],
	'status'=>$params['status'],
	'createtime'=>TIMESTAMP,
);
pdo_insert('jy_meye_order_log',$insert);
//发送模版消息
$setting=$this->plugin_setting('message_tpl');
$order_status=$this->type__order_status();
$remarks=array(
	'1'=>'订单已收到，火速处理中！',
	'2'=>'您点的菜已送到啦，快去尝尝吧！',
	'3'=>'您的退款申请已收到，请耐心等待管理员审核！',
	'4'=>'您的退款申请已审核通过！',
	'5'=>'您已经取消订单，更多信息可以查看订单详情～',
);
if($setting['order']){
	//已设置模版ID
	$data=array();
	$data['first']=array(
		'value'=>'订单状态变更提醒',
		'color'=>'#173177',
	);
	$data['keyword1']=array(
		'value'=>$order_status[$params['status']],
		'color'=>'#173177',
	);
	$data['keyword2']=array(
		'value'=>date('y/m/d H:i:s'),
		'color'=>'#173177',
	);
	$data['remark']=array(
		'value'=>$remarks[$params['status']],
		'color'=>'#173177',
	);
	cfc('account')->sendTplNotice($order['mid'],$setting['order'],$data,custom_url('jy_meye/order_show/detail/id='.$order['id']));
}
return true;