<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * 门店管理
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$services=array(
	'1'=>'wifi',
	'2'=>'刷卡',
	'3'=>'包厢',
	'4'=>'停车',
);
if($_RQ['op']=='list'){
	$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','title','logo','status','createtime','pcd');
	$list=pdo_getslice('jy_meye_store',$params,array($pindex,$psize),$total,$fields,'','id desc');
	foreach($list as &$item){
		$item['url']=custom_url('jy_meye/store//id='.$item['id'],true);
		$item['pcd']=json_decode($item['pcd'],true);
		$item['pcd']=$item['pcd']['province'].''.$item['pcd']['city'].''.$item['pcd']['district'];
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['dish_types']=$dish_types;
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'门店列表'),
			array('op'=>'edit','title'=>'创建门店'),
		),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'id','title'=>'门店ID','type'=>'string'),
			array('name'=>'title','title'=>'门店名称','type'=>'string'),
			array('name'=>'logo','title'=>'门店logo','type'=>'image'),
			array('name'=>'url','title'=>'二维码','type'=>'ewm'),
			array('name'=>'url','title'=>'复制链接','type'=>'copy'),
			array('name'=>'status','title'=>'是否开启','type'=>'switch','set'=>'set'),
			array('name'=>'createtime','title'=>'创建时间','type'=>'time'),
		),'action'=>array(
			array('type'=>'href','op'=>'manage','title'=>'管理'),
		)),
		'search'=>array(
			array('type'=>'string','width'=>'15','name'=>'title','title'=>'门店名称','width'=>'50'),
		),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='edit'){
	$return=array('dish_types'=>$dish_types,'services'=>$services);
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_meye_store',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['lat_lng']=$item['lat_lng']?json_decode($item['lat_lng'],true):array('lat'=>0);
		$item['images']=$item['images']?json_decode($item['images'],true):array();
		$item['time']=$item['time']?json_decode($item['time'],true):'';
	}else{
		$item=array();
	}
	$item['pcd']=$item['pcd']?json_decode($item['pcd'],true):array('city'=>'');
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回门店列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('type'=>'string','title'=>'门店名称','name'=>'title','help'=>'客户端显示：品牌名称（门店名称）'),
					array('type'=>'string','title'=>'品牌名称','name'=>'brandname','help'=>'客户端显示：品牌名称（门店名称）'),
					array('type'=>'image','title'=>'门店logo','name'=>'logo','help'=>''),
					array('type'=>'switch','title'=>'显示在列表页','name'=>'show_list','help'=>'开启后，将会显示在门店列表页；否则不显示在门店列表页'),
					array('type'=>'images','title'=>'展示图片','name'=>'images','help'=>'上传门店展示图片'),
					array('type'=>'text','title'=>'门店介绍','name'=>'desc','help'=>'填写门店介绍'),
					array('type'=>'string','title'=>'人均消费','name'=>'money','help'=>''),
					array('type'=>'time_hour','title'=>'营业时间','name'=>'time','help'=>'设置门店营业时间'),
					array('type'=>'string','title'=>'联系电话','name'=>'mobile','help'=>'设置门店联系电话，显示在门店详情页'),
					array('name'=>'pcd','title'=>'所属区域','type'=>'pcd'),
					array('type'=>'string','title'=>'门店地址','name'=>'address','help'=>'设置门店地址，显示在门店详情页'),
					array('type'=>'lat_lng','title'=>'门店坐标','name'=>'lat_lng','help'=>'设置门店坐标'),
					array('type'=>'switch','title'=>'是否启用','name'=>'status','help'=>'开启后门店方可用'),
				)
			),
			array(
				'title'=>'运营参数',
				'list'=>array(
					array('type'=>'switch','title'=>'支付订单自动确认','name'=>'confirm','help'=>'开启后，顾客支付的订单会自动确认，无需管理员手动确认' ),
					array('type'=>'switch','title'=>'首次下单短信验证','name'=>'sms_code','help'=>'开启后，首次下单的用户将会要求输入短信验证码'),
					array('type'=>'checkbox','title'=>'提供服务','name'=>'service','help'=>'勾选门店提供的服务，将会在门店详情页显示','options'=>'services'),
				),
			)
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	$pcd = $postdata['pcd'];
	if(!$pcd['province'] || !$pcd['city'] || !$pcd['district']){
		exi('请完善门店所属区域！','error');
	}
	$code=$this->model('model')->get_area_code($pcd);
	$data=array(
		'title'=>trim($postdata['title']),
		'logo'=>trim($postdata['logo']),
		'show_list'=>intval($postdata['show_list']),
		'images'=>ijson_encode($postdata['images']),
		'desc'=>trim($postdata['desc']),
		'money'=>intval($postdata['money']),
		'time'=>ijson_encode($postdata['time']),
		'mobile'=>trim($postdata['mobile']),
		'address'=>trim($postdata['address']),
		'lat_lng'=>ijson_encode($postdata['lat_lng']),
		'status'=>intval($postdata['status']),
		'confirm'=>intval($postdata['confirm']),
		'sms_code'=>intval($postdata['sms_code']),
		'service'=>trim($postdata['service']),
		'brandname'=>trim($postdata['brandname']),
		'pcd'=>ijson_encode($postdata['pcd']),
		'code'=>trim($code['area_code']),
	);
	$id=intval($postdata['id']);
	if($id){
		pdo_update('jy_meye_store',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		$data['createtime']=TIMESTAMP;
		pdo_insert('jy_meye_store',$data);
	}
	exi('操作成功！','','list');
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('参数错误！','error');
	}
	$update=array();
	$post=get_postdata();
	if(isset($post['status'])){
		$update['status']=intval($post['status']);
	}
	if($post['dish_type']){
		$update['dish_type']=trim($post['dish_type']);
	}
	if($update){
		pdo_update('jy_meye_store',$update,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	exi('操作成功！');
}
if($_RQ['op']=='del'){
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
	}else{
		$del=array();
	}
	if($_RQ['id']){
		$del[]=$_RQ['id'];
	}
	foreach($del as $id){
		$id=intval($id);
		if($id){
			pdo_delete('jy_meye_store',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='manage'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择门店~','error');
	}
	$this->session('store_id',$id);
	exi('','','store.index/');
}
