//
//  RAD: Recreation of the game "Radix - beyond the void"
//       powered by the DelphiDoom engine
//
//  Copyright (C) 1995 by Epic MegaGames, Inc.
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2004-2022 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//  DESCRIPTION:
//   Extra sprites for editing WAD (keys and fog)
//
//------------------------------------------------------------------------------
//  Site: https://sourceforge.net/projects/rad-x/
//------------------------------------------------------------------------------

{$I RAD.inc}

unit radix_extra_sprites;

interface

const
  BKEYA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF, $02, $0E, $98, $98, $99, $99, $99, $99,
    $99, $99, $99, $99, $9A, $99, $98, $98, $9C, $9C, $FF, $01, $0F, $98, $98,
    $99, $99, $99, $98, $99, $99, $9A, $9A, $9A, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $99, $99, $9A, $99, $99, $9A, $9A, $99, $99,
    $9A, $99, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $98, $9A, $99, $99,
    $98, $99, $99, $99, $9A, $9A, $99, $99, $98, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $84, $84, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $99, $99, $99, $99, $99, $99, $99,
    $99, $99, $9A, $9A, $9A, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $84,
    $84, $99, $99, $99, $9A, $9A, $99, $99, $99, $99, $9A, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $98, $98, $99, $99, $99, $99, $9A, $99, $99,
    $99, $99, $9A, $99, $9C, $9C, $FF, $00, $10, $98, $98, $84, $84, $99, $99,
    $99, $9A, $99, $99, $99, $98, $99, $99, $99, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $99, $99, $99, $99, $99, $98, $99, $99, $99, $99, $9A, $99, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $84, $84, $9A, $98, $99, $99, $9A,
    $99, $99, $99, $99, $99, $99, $9A, $9C, $9C, $FF, $00, $10, $98, $98, $98,
    $99, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF
  );

  BKEYB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF, $02, $0E, $98, $98, $99, $99, $99, $99,
    $99, $99, $99, $99, $9A, $99, $98, $98, $9C, $9C, $FF, $01, $0F, $98, $98,
    $99, $99, $99, $98, $99, $99, $9A, $9A, $9A, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $99, $99, $9A, $99, $99, $9A, $9A, $99, $99,
    $9A, $99, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $98, $9A, $99, $99,
    $98, $99, $99, $99, $9A, $9A, $99, $99, $98, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $81, $81, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $99, $99, $99, $99, $99, $99, $99,
    $99, $99, $9A, $9A, $9A, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $81,
    $81, $99, $99, $99, $9A, $9A, $99, $99, $99, $99, $9A, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $98, $98, $99, $99, $99, $99, $9A, $99, $99,
    $99, $99, $9A, $99, $9C, $9C, $FF, $00, $10, $98, $98, $81, $81, $99, $99,
    $99, $9A, $99, $99, $99, $98, $99, $99, $99, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $99, $99, $99, $99, $99, $98, $99, $99, $99, $99, $9A, $99, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $81, $81, $9A, $98, $99, $99, $9A,
    $99, $99, $99, $99, $99, $99, $9A, $9C, $9C, $FF, $00, $10, $98, $98, $98,
    $99, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF
  );

  BSKUA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF, $02, $0E, $98, $98, $99, $99, $99, $99,
    $99, $99, $99, $99, $9A, $99, $98, $98, $9C, $9C, $FF, $01, $0F, $98, $98,
    $99, $99, $99, $9A, $9C, $99, $9C, $9D, $9A, $9B, $9C, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $99, $99, $9A, $9B, $9C, $9A, $9C, $9C, $99,
    $9C, $9C, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $98, $9A, $99, $99,
    $9A, $9C, $99, $9B, $9D, $9A, $9B, $9C, $98, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $84, $84, $99, $99, $9B, $9D, $99, $9B, $9D, $99, $9B, $9C, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $99, $99, $99, $99, $9B, $9C, $99,
    $9B, $9C, $9A, $9C, $9D, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $84,
    $84, $99, $99, $9B, $9D, $9A, $9B, $9C, $99, $9B, $9D, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $98, $98, $99, $9B, $9C, $99, $9C, $9C, $99,
    $9B, $9C, $9A, $99, $9C, $9C, $FF, $00, $10, $98, $98, $84, $84, $99, $99,
    $9B, $9D, $99, $9B, $9C, $98, $9B, $9C, $99, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $99, $99, $99, $99, $9B, $9C, $99, $9B, $9C, $99, $9C, $9C, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $84, $84, $9A, $98, $9B, $9C, $9A,
    $9B, $9C, $99, $9B, $9C, $99, $9A, $9C, $9C, $FF, $00, $10, $98, $98, $98,
    $99, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF
  );

  BSKUB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF, $02, $0E, $98, $98, $99, $99, $99, $99,
    $99, $99, $99, $99, $9A, $99, $98, $98, $9C, $9C, $FF, $01, $0F, $98, $98,
    $99, $99, $99, $9A, $9C, $99, $9C, $9D, $9A, $9B, $9C, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $99, $99, $9A, $9B, $9C, $9A, $9C, $9C, $99,
    $9C, $9C, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $98, $9A, $99, $99,
    $9A, $9C, $99, $9B, $9D, $9A, $9B, $9C, $98, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $81, $81, $99, $99, $9B, $9D, $99, $9B, $9D, $99, $9B, $9C, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $99, $99, $99, $99, $9B, $9C, $99,
    $9B, $9C, $9A, $9C, $9D, $99, $99, $9C, $9C, $FF, $00, $10, $98, $98, $81,
    $81, $99, $99, $9B, $9D, $9A, $9B, $9C, $99, $9B, $9D, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $98, $98, $98, $99, $9B, $9C, $99, $9C, $9C, $99,
    $9B, $9C, $9A, $99, $9C, $9C, $FF, $00, $10, $98, $98, $81, $81, $99, $99,
    $9B, $9D, $99, $9B, $9C, $98, $9B, $9C, $99, $99, $9C, $9C, $FF, $00, $10,
    $98, $98, $99, $99, $99, $99, $9B, $9C, $99, $9B, $9C, $99, $9C, $9C, $99,
    $9A, $9C, $9C, $FF, $00, $10, $98, $98, $81, $81, $9A, $98, $9B, $9C, $9A,
    $9B, $9C, $99, $9B, $9C, $99, $9A, $9C, $9C, $FF, $00, $10, $98, $98, $98,
    $99, $99, $99, $99, $9A, $99, $99, $9A, $99, $99, $99, $99, $99, $9C, $9C,
    $FF, $00, $10, $98, $98, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B, $9B,
    $9B, $9B, $9B, $9B, $9C, $9C, $FF
  );

  IFOGA0_RawData: packed array[0..746] of Byte = (
    $28, $00, $25, $00, $12, $00, $21, $00, $A8, $00, $00, $00, $A9, $00, $00,
    $00, $AA, $00, $00, $00, $B5, $00, $00, $00, $B6, $00, $00, $00, $CE, $00,
    $00, $00, $CF, $00, $00, $00, $EB, $00, $00, $00, $EC, $00, $00, $00, $0A,
    $01, $00, $00, $0B, $01, $00, $00, $2E, $01, $00, $00, $2F, $01, $00, $00,
    $51, $01, $00, $00, $52, $01, $00, $00, $78, $01, $00, $00, $79, $01, $00,
    $00, $9D, $01, $00, $00, $9E, $01, $00, $00, $C8, $01, $00, $00, $C9, $01,
    $00, $00, $EC, $01, $00, $00, $ED, $01, $00, $00, $12, $02, $00, $00, $13,
    $02, $00, $00, $3A, $02, $00, $00, $3B, $02, $00, $00, $5D, $02, $00, $00,
    $5E, $02, $00, $00, $80, $02, $00, $00, $81, $02, $00, $00, $A0, $02, $00,
    $00, $A1, $02, $00, $00, $C1, $02, $00, $00, $C2, $02, $00, $00, $D8, $02,
    $00, $00, $D9, $02, $00, $00, $E8, $02, $00, $00, $E9, $02, $00, $00, $EA,
    $02, $00, $00, $FF, $FF, $0F, $06, $99, $99, $99, $98, $99, $99, $98, $98,
    $FF, $FF, $09, $0C, $9D, $9D, $9D, $9D, $98, $99, $99, $98, $98, $96, $97,
    $99, $99, $99, $17, $03, $98, $98, $99, $99, $99, $FF, $FF, $07, $04, $98,
    $98, $98, $99, $99, $99, $0D, $0F, $98, $98, $98, $99, $99, $98, $99, $99,
    $98, $98, $99, $99, $99, $97, $96, $98, $98, $FF, $FF, $06, $19, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99,
    $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $07, $08, $98,
    $98, $98, $99, $9D, $9D, $9D, $9D, $99, $99, $12, $0B, $98, $98, $99, $99,
    $98, $98, $96, $97, $99, $99, $99, $98, $98, $1E, $03, $99, $99, $99, $98,
    $98, $FF, $FF, $05, $1D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $05, $0A, $99, $99, $99, $98, $98,
    $96, $97, $99, $99, $99, $98, $98, $11, $0B, $98, $98, $99, $99, $98, $98,
    $96, $97, $99, $99, $99, $98, $98, $1D, $04, $99, $99, $99, $98, $99, $99,
    $FF, $FF, $04, $1F, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99,
    $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $03, $08, $99, $99, $99, $98,
    $98, $98, $97, $97, $98, $98, $0D, $07, $99, $99, $99, $99, $99, $98, $98,
    $9A, $9A, $16, $04, $98, $98, $98, $99, $99, $99, $1D, $06, $9D, $9D, $9D,
    $9D, $99, $99, $98, $98, $FF, $FF, $04, $1E, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $03, $20,
    $99, $99, $99, $98, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D, $9D,
    $99, $99, $98, $98, $FF, $FF, $04, $0A, $98, $98, $99, $99, $98, $98, $96,
    $97, $99, $99, $99, $99, $10, $08, $99, $99, $99, $98, $99, $98, $98, $99,
    $99, $99, $19, $08, $98, $98, $98, $99, $99, $98, $96, $97, $99, $99, $FF,
    $FF, $08, $04, $99, $99, $98, $99, $99, $99, $0E, $09, $99, $99, $99, $99,
    $97, $96, $98, $98, $99, $99, $99, $19, $08, $99, $99, $97, $96, $98, $98,
    $99, $99, $98, $98, $FF, $FF, $05, $1D, $9D, $9D, $99, $99, $98, $98, $99,
    $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $99, $99, $98, $98, $FF, $FF, $06, $1A, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $99, $99, $98, $98, $99, $99, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $99, $99, $99, $99, $98, $98, $FF, $FF, $07, $03,
    $99, $99, $99, $98, $98, $0B, $0C, $98, $98, $96, $98, $96, $97, $99, $98,
    $98, $98, $97, $97, $98, $98, $19, $04, $99, $99, $99, $99, $98, $98, $FF,
    $FF, $09, $11, $99, $99, $99, $98, $99, $99, $9D, $9D, $9D, $9D, $9D, $98,
    $96, $97, $99, $99, $99, $98, $98, $FF, $FF, $0C, $0A, $99, $99, $99, $98,
    $9D, $9D, $9D, $98, $99, $99, $98, $98, $FF, $FF, $FF, $FF
  );

  IFOGB0_RawData: packed array[0..633] of Byte = (
    $22, $00, $1E, $00, $10, $00, $1A, $00, $90, $00, $00, $00, $91, $00, $00,
    $00, $A3, $00, $00, $00, $A4, $00, $00, $00, $B8, $00, $00, $00, $B9, $00,
    $00, $00, $D3, $00, $00, $00, $D4, $00, $00, $00, $F5, $00, $00, $00, $F6,
    $00, $00, $00, $14, $01, $00, $00, $15, $01, $00, $00, $39, $01, $00, $00,
    $3A, $01, $00, $00, $5A, $01, $00, $00, $5B, $01, $00, $00, $81, $01, $00,
    $00, $82, $01, $00, $00, $A3, $01, $00, $00, $A4, $01, $00, $00, $C6, $01,
    $00, $00, $C7, $01, $00, $00, $ED, $01, $00, $00, $EE, $01, $00, $00, $0F,
    $02, $00, $00, $10, $02, $00, $00, $2E, $02, $00, $00, $2F, $02, $00, $00,
    $4B, $02, $00, $00, $4C, $02, $00, $00, $65, $02, $00, $00, $66, $02, $00,
    $00, $78, $02, $00, $00, $79, $02, $00, $00, $FF, $0A, $07, $99, $99, $98,
    $98, $96, $97, $99, $99, $99, $13, $02, $98, $98, $99, $99, $FF, $FF, $09,
    $0F, $98, $98, $98, $99, $99, $98, $99, $99, $98, $98, $99, $99, $99, $97,
    $96, $98, $98, $FF, $FF, $05, $15, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $FF, $FF, $03, $08, $98, $98, $98, $99, $9D, $9D, $9D, $9D, $99, $99, $0E,
    $0B, $98, $98, $99, $99, $98, $98, $96, $97, $99, $99, $99, $98, $98, $1A,
    $01, $99, $99, $99, $FF, $FF, $02, $19, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D,
    $9D, $9D, $9D, $9D, $9D, $FF, $FF, $02, $09, $99, $99, $98, $98, $96, $97,
    $99, $99, $99, $98, $98, $0D, $0B, $98, $98, $99, $99, $98, $98, $96, $97,
    $99, $99, $99, $98, $98, $19, $03, $99, $99, $99, $98, $98, $FF, $FF, $02,
    $1B, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $FF, $FF, $01, $06, $98, $98, $98, $98, $97, $97, $98, $98, $09, $07, $99,
    $99, $99, $99, $99, $98, $98, $9A, $9A, $12, $04, $98, $98, $98, $99, $99,
    $99, $19, $04, $9D, $9D, $9D, $9D, $99, $99, $FF, $FF, $01, $1C, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF,
    $00, $1D, $99, $99, $98, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D,
    $9D, $99, $99, $FF, $FF, $00, $0A, $98, $98, $99, $99, $98, $98, $96, $97,
    $99, $99, $99, $99, $0C, $08, $99, $99, $99, $98, $99, $98, $98, $99, $99,
    $99, $15, $07, $98, $98, $98, $99, $99, $98, $96, $97, $97, $FF, $FF, $04,
    $04, $99, $99, $98, $99, $99, $99, $0A, $09, $99, $99, $99, $99, $97, $96,
    $98, $98, $99, $99, $99, $15, $07, $99, $99, $97, $96, $98, $98, $99, $99,
    $99, $FF, $FF, $02, $19, $99, $99, $99, $98, $98, $99, $99, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $FF, $FF, $03, $17, $9D, $9D, $9D, $9D, $9D, $9D, $99, $99, $98,
    $98, $99, $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $99, $99, $99,
    $99, $FF, $FF, $07, $0C, $98, $98, $96, $98, $96, $97, $99, $98, $98, $98,
    $97, $97, $98, $98, $15, $04, $99, $99, $99, $99, $98, $98, $FF, $FF, $09,
    $0D, $99, $99, $9D, $9D, $9D, $9D, $9D, $98, $96, $97, $99, $99, $99, $98,
    $98, $FF, $FF, $FF
  );

  IFOGC0_RawData: packed array[0..211] of Byte = (
    $11, $00, $10, $00, $06, $00, $0F, $00, $4C, $00, $00, $00, $4D, $00, $00,
    $00, $4E, $00, $00, $00, $5E, $00, $00, $00, $5F, $00, $00, $00, $74, $00,
    $00, $00, $75, $00, $00, $00, $88, $00, $00, $00, $89, $00, $00, $00, $9B,
    $00, $00, $00, $9C, $00, $00, $00, $AE, $00, $00, $00, $AF, $00, $00, $00,
    $C0, $00, $00, $00, $C1, $00, $00, $00, $D2, $00, $00, $00, $D3, $00, $00,
    $00, $FF, $FF, $03, $0B, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $FF, $FF, $01, $06, $96, $96, $97, $99, $99, $99, $98, $98,
    $09, $06, $98, $98, $99, $99, $98, $98, $96, $96, $FF, $FF, $01, $0E, $9D,
    $9D, $9D, $98, $98, $99, $99, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $98, $98,
    $FF, $FF, $01, $02, $97, $97, $98, $98, $05, $07, $99, $99, $99, $99, $99,
    $98, $98, $9A, $9A, $FF, $FF, $01, $0D, $9D, $9D, $9D, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $02, $0C, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $03, $03,
    $99, $99, $99, $99, $99, $08, $05, $99, $99, $99, $98, $99, $98, $98, $FF,
    $FF, $FF
  );

  IFOGD0_RawData: packed array[0..95] of Byte = (
    $09, $00, $08, $00, $04, $00, $0A, $00, $2C, $00, $00, $00, $2D, $00, $00,
    $00, $39, $00, $00, $00, $3A, $00, $00, $00, $46, $00, $00, $00, $47, $00,
    $00, $00, $53, $00, $00, $00, $54, $00, $00, $00, $5F, $00, $00, $00, $FF,
    $02, $01, $98, $98, $98, $05, $02, $98, $98, $99, $99, $FF, $FF, $01, $07,
    $99, $99, $99, $9D, $9D, $9D, $9D, $9D, $9D, $FF, $FF, $01, $07, $99, $99,
    $99, $99, $99, $98, $98, $9A, $9A, $FF, $FF, $01, $06, $9D, $9D, $9D, $9D,
    $9D, $9D, $9D, $9D, $FF, $FF
  );

  IFOGE0_RawData: packed array[0..40] of Byte = (
    $03, $00, $04, $00, $02, $00, $07, $00, $14, $00, $00, $00, $1A, $00, $00,
    $00, $23, $00, $00, $00, $01, $01, $98, $98, $98, $FF, $00, $04, $99, $99,
    $98, $98, $9A, $9A, $FF, $02, $01, $98, $98, $98, $FF
  );

  RKEYA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF, $02, $0E, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $EE, $EE, $F0, $EE, $EC, $EC, $F4, $F4, $FF, $01, $0F, $EE, $EE,
    $EE, $EE, $EE, $EC, $EE, $EE, $F0, $F0, $F0, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EE, $EE, $F0, $EE, $EE, $F0, $F0, $EE, $EE,
    $F0, $EE, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC, $F0, $EE, $EE,
    $EC, $EE, $EE, $EE, $F0, $F0, $EE, $EE, $EC, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $84, $84, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $F0, $F0, $F0, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $84,
    $84, $EE, $EE, $EE, $F0, $F0, $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EC, $EC, $EE, $EE, $EE, $EE, $F0, $EE, $EE,
    $EE, $EE, $F0, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $84, $84, $EE, $EE,
    $EE, $F0, $EE, $EE, $EE, $EC, $EE, $EE, $EE, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EC, $EE, $EE, $EE, $EE, $F0, $EE, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $84, $84, $F0, $EC, $EE, $EE, $F0,
    $EE, $EE, $EE, $EE, $EE, $EE, $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC,
    $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF
  );

  RKEYB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF, $02, $0E, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $EE, $EE, $F0, $EE, $EC, $EC, $F4, $F4, $FF, $01, $0F, $EE, $EE,
    $EE, $EE, $EE, $EC, $EE, $EE, $F0, $F0, $F0, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EE, $EE, $F0, $EE, $EE, $F0, $F0, $EE, $EE,
    $F0, $EE, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC, $F0, $EE, $EE,
    $EC, $EE, $EE, $EE, $F0, $F0, $EE, $EE, $EC, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $81, $81, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $F0, $F0, $F0, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $81,
    $81, $EE, $EE, $EE, $F0, $F0, $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EC, $EC, $EE, $EE, $EE, $EE, $F0, $EE, $EE,
    $EE, $EE, $F0, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $81, $81, $EE, $EE,
    $EE, $F0, $EE, $EE, $EE, $EC, $EE, $EE, $EE, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $EE, $EE, $EE, $EE, $EE, $EC, $EE, $EE, $EE, $EE, $F0, $EE, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $81, $81, $F0, $EC, $EE, $EE, $F0,
    $EE, $EE, $EE, $EE, $EE, $EE, $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC,
    $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF
  );

  RSKUA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF, $02, $0E, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $EE, $EE, $F0, $EE, $EC, $EC, $F4, $F4, $FF, $01, $0F, $EE, $EE,
    $EE, $EE, $EE, $F0, $F4, $EE, $F2, $F5, $F0, $F2, $F4, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EE, $EE, $F0, $F2, $F4, $F0, $F2, $F4, $EE,
    $F2, $F4, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC, $F0, $EE, $EE,
    $F0, $F4, $EE, $F2, $F5, $F0, $F2, $F4, $EC, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $84, $84, $EE, $EE, $F2, $F5, $EE, $F2, $F5, $EE, $F2, $F4, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EE, $EE, $EE, $EE, $F2, $F4, $EE,
    $F2, $F4, $F0, $F2, $F5, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $84,
    $84, $EE, $EE, $F2, $F5, $F0, $F2, $F4, $EE, $F2, $F5, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EC, $EC, $EE, $F2, $F4, $EE, $F2, $F4, $EE,
    $F2, $F4, $F0, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $84, $84, $EE, $EE,
    $F2, $F5, $EE, $F2, $F4, $EC, $F2, $F4, $EE, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $EE, $EE, $EE, $EE, $F2, $F3, $EE, $F2, $F4, $EE, $F2, $F4, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $84, $84, $F0, $EC, $F2, $F4, $F0,
    $F2, $F4, $EE, $F2, $F4, $EE, $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC,
    $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF
  );

  RSKUB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF, $02, $0E, $EE, $EE, $EE, $EE, $EE, $EE,
    $EE, $EE, $EE, $EE, $F0, $EE, $EC, $EC, $F4, $F4, $FF, $01, $0F, $EE, $EE,
    $EE, $EE, $EE, $F0, $F4, $EE, $F2, $F5, $F0, $F2, $F4, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EE, $EE, $F0, $F2, $F4, $F0, $F2, $F4, $EE,
    $F2, $F4, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC, $F0, $EE, $EE,
    $F0, $F4, $EE, $F2, $F5, $F0, $F2, $F4, $EC, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $81, $81, $EE, $EE, $F2, $F5, $EE, $F2, $F5, $EE, $F2, $F4, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EE, $EE, $EE, $EE, $F2, $F4, $EE,
    $F2, $F4, $F0, $F2, $F5, $EE, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $81,
    $81, $EE, $EE, $F2, $F5, $F0, $F2, $F4, $EE, $F2, $F5, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $EC, $EC, $EC, $EE, $F2, $F4, $EE, $F2, $F4, $EE,
    $F2, $F4, $F0, $EE, $F4, $F4, $FF, $00, $10, $EE, $EE, $81, $81, $EE, $EE,
    $F2, $F5, $EE, $F2, $F4, $EC, $F2, $F4, $EE, $EE, $F4, $F4, $FF, $00, $10,
    $EE, $EE, $EE, $EE, $EE, $EE, $F2, $F3, $EE, $F2, $F4, $EE, $F2, $F4, $EE,
    $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $81, $81, $F0, $EC, $F2, $F4, $F0,
    $F2, $F4, $EE, $F2, $F4, $EE, $F0, $F4, $F4, $FF, $00, $10, $EE, $EE, $EC,
    $EE, $EE, $EE, $EE, $F0, $EE, $EE, $F0, $EE, $EE, $EE, $EE, $EE, $F4, $F4,
    $FF, $00, $10, $EE, $EE, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2, $F2,
    $F2, $F2, $F2, $F2, $F4, $F4, $FF
  );

  TFOGA0_RawData: packed array[0..1279] of Byte = (
    $29, $00, $38, $00, $13, $00, $3A, $00, $AC, $00, $00, $00, $C1, $00, $00,
    $00, $C2, $00, $00, $00, $E3, $00, $00, $00, $E4, $00, $00, $00, $18, $01,
    $00, $00, $19, $01, $00, $00, $47, $01, $00, $00, $48, $01, $00, $00, $7D,
    $01, $00, $00, $7E, $01, $00, $00, $B2, $01, $00, $00, $B3, $01, $00, $00,
    $EF, $01, $00, $00, $F0, $01, $00, $00, $2D, $02, $00, $00, $2E, $02, $00,
    $00, $67, $02, $00, $00, $68, $02, $00, $00, $A7, $02, $00, $00, $A8, $02,
    $00, $00, $EB, $02, $00, $00, $EC, $02, $00, $00, $2B, $03, $00, $00, $2C,
    $03, $00, $00, $68, $03, $00, $00, $69, $03, $00, $00, $A4, $03, $00, $00,
    $A5, $03, $00, $00, $E4, $03, $00, $00, $E5, $03, $00, $00, $18, $04, $00,
    $00, $19, $04, $00, $00, $4C, $04, $00, $00, $4D, $04, $00, $00, $84, $04,
    $00, $00, $85, $04, $00, $00, $B0, $04, $00, $00, $B1, $04, $00, $00, $DA,
    $04, $00, $00, $DB, $04, $00, $00, $0F, $01, $87, $87, $87, $14, $01, $87,
    $87, $87, $23, $01, $87, $87, $87, $28, $01, $87, $87, $87, $FF, $FF, $10,
    $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1C, $07,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $25, $03, $87, $87, $87, $87,
    $87, $FF, $FF, $0A, $01, $87, $87, $87, $0D, $0B, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $1A, $03, $87, $87, $87, $87, $87,
    $1E, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $27, $04, $87, $87,
    $87, $87, $87, $87, $2D, $01, $87, $87, $87, $FF, $FF, $0A, $07, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $12, $0F, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $23, $0B, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $0B,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $13, $0F,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $24, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $06, $16, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $1F, $0B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $2C, $06, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF,
    $03, $06, $87, $87, $87, $87, $87, $87, $87, $87, $0B, $0D, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1B, $15, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $32, $03, $87, $87, $87, $87, $87, $FF,
    $FF, $02, $0C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $10, $18, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $2A, $0C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $FF, $FF, $04, $0C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $12, $18, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $2C, $08, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF,
    $FF, $01, $05, $87, $87, $87, $87, $87, $87, $87, $08, $19, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $23, $14, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $FF, $FF, $00, $16, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $18, $11, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $2B, $04, $87, $87, $87, $87, $87, $87,
    $31, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $02, $06,
    $87, $87, $87, $87, $87, $87, $87, $87, $0A, $0E, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1A, $07, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $23, $13, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $FF, $FF, $03, $16, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1A, $0F,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $2B, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $FF, $FF, $02, $24, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $28, $0E,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $FF, $FF, $01, $0B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $0E, $09, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $19, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $27, $10, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $07, $0E, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $17, $15, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $2E, $03, $87, $87, $87, $87, $87, $FF, $FF, $06,
    $29, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $31,
    $01, $87, $87, $87, $FF, $FF, $08, $01, $87, $87, $87, $0A, $02, $87, $87,
    $87, $87, $0E, $09, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $19, $15, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $2F, $01, $87, $87, $87,
    $FF, $FF, $0A, $1D, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $29, $05, $87, $87, $87, $87, $87, $87, $87, $FF,
    $FF, $0C, $01, $87, $87, $87, $0F, $07, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $1A, $0F, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $2B, $01, $87, $87, $87, $FF, $FF, $10, $01,
    $87, $87, $87, $12, $01, $87, $87, $87, $14, $01, $87, $87, $87, $1B, $02,
    $87, $87, $87, $87, $23, $01, $87, $87, $87, $25, $01, $87, $87, $87, $27,
    $01, $87, $87, $87, $FF
  );

  TFOGB0_RawData: packed array[0..1106] of Byte = (
    $2A, $00, $2D, $00, $13, $00, $33, $00, $B0, $00, $00, $00, $B1, $00, $00,
    $00, $CE, $00, $00, $00, $CF, $00, $00, $00, $F1, $00, $00, $00, $F2, $00,
    $00, $00, $15, $01, $00, $00, $16, $01, $00, $00, $43, $01, $00, $00, $44,
    $01, $00, $00, $6F, $01, $00, $00, $70, $01, $00, $00, $9B, $01, $00, $00,
    $9C, $01, $00, $00, $D0, $01, $00, $00, $D1, $01, $00, $00, $04, $02, $00,
    $00, $05, $02, $00, $00, $36, $02, $00, $00, $37, $02, $00, $00, $6C, $02,
    $00, $00, $6D, $02, $00, $00, $A6, $02, $00, $00, $A7, $02, $00, $00, $DD,
    $02, $00, $00, $DE, $02, $00, $00, $0F, $03, $00, $00, $10, $03, $00, $00,
    $45, $03, $00, $00, $46, $03, $00, $00, $79, $03, $00, $00, $7A, $03, $00,
    $00, $A5, $03, $00, $00, $A6, $03, $00, $00, $D3, $03, $00, $00, $D4, $03,
    $00, $00, $FA, $03, $00, $00, $FB, $03, $00, $00, $22, $04, $00, $00, $23,
    $04, $00, $00, $3A, $04, $00, $00, $3B, $04, $00, $00, $FF, $0E, $01, $87,
    $87, $87, $10, $01, $87, $87, $87, $12, $01, $87, $87, $87, $18, $04, $87,
    $87, $87, $87, $87, $87, $1D, $01, $87, $87, $87, $FF, $FF, $0A, $01, $87,
    $87, $87, $0D, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $18, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $FF, $FF, $08, $05, $87, $87, $87, $87, $87, $87, $87, $0F, $15, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $01, $87, $87, $87, $08, $18,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $22, $02, $87, $87,
    $87, $87, $25, $01, $87, $87, $87, $FF, $FF, $04, $01, $87, $87, $87, $07,
    $21, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $FF, $FF, $05, $03, $87, $87, $87, $87, $87,
    $0A, $0D, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $19, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $00, $0F, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $13, $0D, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $22, $0B,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF,
    $00, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $10, $1C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $01, $0A, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $0D, $1E, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $00, $13, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $15, $0F, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $26, $06, $87, $87, $87, $87,
    $87, $87, $87, $87, $FF, $FF, $00, $05, $87, $87, $87, $87, $87, $87, $87,
    $07, $04, $87, $87, $87, $87, $87, $87, $0D, $0A, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $18, $15, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $FF, $FF, $00, $13, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $15, $11, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $28, $05, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $02,
    $08, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $0C, $10, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $1E, $0C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $FF, $FF, $00, $0C, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $0E, $10, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $20, $0C, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $03,
    $87, $87, $87, $87, $87, $06, $1D, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $25, $06, $87, $87, $87, $87, $87,
    $87, $87, $87, $FF, $FF, $04, $06, $87, $87, $87, $87, $87, $87, $87, $87,
    $0C, $1C, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $FF, $FF, $04, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $14, $07, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $1D, $0B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $FF, $FF, $08, $0B, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $15, $07, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $1D, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $08,
    $01, $87, $87, $87, $0B, $04, $87, $87, $87, $87, $87, $87, $11, $10, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $23, $01, $87, $87, $87, $FF, $FF, $0E, $03, $87, $87, $87, $87,
    $87, $13, $0B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $FF, $FF, $0D, $04, $87, $87, $87, $87, $87, $87, $12, $01, $87, $87,
    $87, $19, $01, $87, $87, $87, $1E, $01, $87, $87, $87, $FF
  );

  TFOGC0_RawData: packed array[0..919] of Byte = (
    $28, $00, $25, $00, $14, $00, $2D, $00, $A8, $00, $00, $00, $C5, $00, $00,
    $00, $C6, $00, $00, $00, $E8, $00, $00, $00, $E9, $00, $00, $00, $0A, $01,
    $00, $00, $0B, $01, $00, $00, $2C, $01, $00, $00, $2D, $01, $00, $00, $52,
    $01, $00, $00, $53, $01, $00, $00, $78, $01, $00, $00, $79, $01, $00, $00,
    $A1, $01, $00, $00, $A2, $01, $00, $00, $CE, $01, $00, $00, $CF, $01, $00,
    $00, $F9, $01, $00, $00, $FA, $01, $00, $00, $25, $02, $00, $00, $26, $02,
    $00, $00, $55, $02, $00, $00, $56, $02, $00, $00, $80, $02, $00, $00, $81,
    $02, $00, $00, $AD, $02, $00, $00, $AE, $02, $00, $00, $D7, $02, $00, $00,
    $D8, $02, $00, $00, $FC, $02, $00, $00, $FD, $02, $00, $00, $23, $03, $00,
    $00, $24, $03, $00, $00, $48, $03, $00, $00, $49, $03, $00, $00, $66, $03,
    $00, $00, $67, $03, $00, $00, $7E, $03, $00, $00, $7F, $03, $00, $00, $97,
    $03, $00, $00, $0B, $01, $87, $87, $87, $0D, $04, $87, $87, $87, $87, $87,
    $87, $16, $01, $87, $87, $87, $18, $01, $87, $87, $87, $1A, $01, $87, $87,
    $87, $FF, $FF, $07, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $12, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $1E, $01, $87, $87, $87, $FF, $FF, $06, $14, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $1C, $04, $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $01, $87,
    $87, $87, $09, $17, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF,
    $FF, $05, $1B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $21, $01, $87, $87, $87, $FF, $FF, $06, $0A, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $12, $0D, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $20, $01, $87, $87, $87,
    $FF, $FF, $02, $05, $87, $87, $87, $87, $87, $87, $87, $09, $0D, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1A, $09,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $18,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1B, $05, $87, $87,
    $87, $87, $87, $87, $87, $22, $02, $87, $87, $87, $87, $FF, $FF, $02, $1A,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1E, $07,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $13, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $16, $0F, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $00, $05, $87, $87, $87,
    $87, $87, $87, $87, $06, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $16, $0F, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $03, $08,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $0D, $10, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $1F, $05, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $08, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $0B, $10, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1D, $07,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $02, $1E, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $22, $02, $87, $87, $87, $87, $FF, $FF, $05, $18, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $1F, $03, $87, $87, $87, $87, $87, $FF, $FF,
    $05, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $0E, $07, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $17, $0B, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $06, $87, $87, $87, $87,
    $87, $87, $87, $87, $0D, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $16, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF,
    $FF, $08, $10, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $1A, $04, $87, $87, $87, $87, $87, $87, $FF,
    $FF, $0B, $0B, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $18, $03, $87, $87, $87, $87, $87, $FF, $FF, $0A, $01, $87, $87, $87,
    $0F, $01, $87, $87, $87, $16, $01, $87, $87, $87, $18, $04, $87, $87, $87,
    $87, $87, $87, $FF, $FF
  );

  TFOGD0_RawData: packed array[0..627] of Byte = (
    $1E, $00, $22, $00, $0F, $00, $2C, $00, $80, $00, $00, $00, $93, $00, $00,
    $00, $94, $00, $00, $00, $AB, $00, $00, $00, $AC, $00, $00, $00, $C9, $00,
    $00, $00, $CA, $00, $00, $00, $ED, $00, $00, $00, $EE, $00, $00, $00, $13,
    $01, $00, $00, $14, $01, $00, $00, $38, $01, $00, $00, $39, $01, $00, $00,
    $60, $01, $00, $00, $61, $01, $00, $00, $8B, $01, $00, $00, $8C, $01, $00,
    $00, $B2, $01, $00, $00, $B3, $01, $00, $00, $D7, $01, $00, $00, $D8, $01,
    $00, $00, $FC, $01, $00, $00, $FD, $01, $00, $00, $1D, $02, $00, $00, $1E,
    $02, $00, $00, $3E, $02, $00, $00, $3F, $02, $00, $00, $5C, $02, $00, $00,
    $5D, $02, $00, $00, $73, $02, $00, $00, $0A, $04, $87, $87, $87, $87, $87,
    $87, $14, $01, $87, $87, $87, $19, $01, $87, $87, $87, $FF, $FF, $09, $03,
    $87, $87, $87, $87, $87, $0E, $0B, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $06, $04, $87, $87, $87, $87, $87, $87,
    $0C, $10, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $05, $09, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $10, $07, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $18, $06, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $03, $0A,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $0F, $07, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $18, $07, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $FF, $FF, $03, $03, $87, $87, $87, $87, $87, $07, $18,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $02,
    $87, $87, $87, $87, $05, $1C, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $06, $87, $87, $87, $87, $87,
    $87, $87, $87, $09, $10, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $1B, $07, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $FF, $FF, $02, $08, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $0E, $0D, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $1D, $04, $87, $87, $87, $87, $87, $87, $FF, $FF,
    $04, $01, $87, $87, $87, $06, $0C, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $14, $0A, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $FF, $FF, $03, $01, $87, $87, $87, $05, $1A, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $05,
    $16, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $1D, $01, $87, $87, $87,
    $FF, $FF, $05, $03, $87, $87, $87, $87, $87, $0A, $14, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $FF, $FF, $08, $0A, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $13, $0A, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $FF, $FF, $0A, $04, $87, $87, $87, $87, $87, $87, $13, $04,
    $87, $87, $87, $87, $87, $87, $18, $01, $87, $87, $87, $FF, $FF
  );

  TFOGE0_RawData: packed array[0..228] of Byte = (
    $11, $00, $10, $00, $08, $00, $22, $00, $4C, $00, $00, $00, $55, $00, $00,
    $00, $56, $00, $00, $00, $67, $00, $00, $00, $68, $00, $00, $00, $7A, $00,
    $00, $00, $7B, $00, $00, $00, $8E, $00, $00, $00, $8F, $00, $00, $00, $A4,
    $00, $00, $00, $A5, $00, $00, $00, $BC, $00, $00, $00, $BD, $00, $00, $00,
    $CD, $00, $00, $00, $CE, $00, $00, $00, $DC, $00, $00, $00, $DD, $00, $00,
    $00, $05, $04, $87, $87, $87, $87, $87, $87, $FF, $FF, $03, $01, $87, $87,
    $87, $05, $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $02,
    $02, $87, $87, $87, $87, $06, $07, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $FF, $FF, $01, $0E, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $FF, $FF, $00, $10, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF,
    $00, $01, $87, $87, $87, $03, $0D, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $03, $0B, $87, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $02, $87, $87,
    $87, $87, $0A, $03, $87, $87, $87, $87, $87, $FF, $FF, $08, $03, $87, $87,
    $87, $87, $87, $FF
  );

  TFOGF0_RawData: packed array[0..126] of Byte = (
    $09, $00, $08, $00, $04, $00, $1E, $00, $2C, $00, $00, $00, $3A, $00, $00,
    $00, $3B, $00, $00, $00, $4E, $00, $00, $00, $4F, $00, $00, $00, $5F, $00,
    $00, $00, $60, $00, $00, $00, $70, $00, $00, $00, $71, $00, $00, $00, $01,
    $01, $87, $87, $87, $03, $04, $87, $87, $87, $87, $87, $87, $FF, $FF, $00,
    $02, $87, $87, $87, $87, $03, $02, $87, $87, $87, $87, $06, $02, $87, $87,
    $87, $87, $FF, $FF, $00, $05, $87, $87, $87, $87, $87, $87, $87, $06, $02,
    $87, $87, $87, $87, $FF, $FF, $00, $02, $87, $87, $87, $87, $03, $05, $87,
    $87, $87, $87, $87, $87, $87, $FF, $FF, $01, $03, $87, $87, $87, $87, $87,
    $05, $02, $87, $87, $87, $87, $FF
  );

  TFOGG0_RawData: packed array[0..36] of Byte = (
    $03, $00, $03, $00, $01, $00, $1B, $00, $14, $00, $00, $00, $1C, $00, $00,
    $00, $1D, $00, $00, $00, $00, $03, $87, $87, $87, $87, $87, $FF, $FF, $00,
    $03, $87, $87, $87, $87, $87, $FF
  );

  TFOGH0_RawData: packed array[0..63] of Byte = (
    $07, $00, $07, $00, $03, $00, $1D, $00, $24, $00, $00, $00, $25, $00, $00,
    $00, $2B, $00, $00, $00, $2C, $00, $00, $00, $38, $00, $00, $00, $39, $00,
    $00, $00, $3F, $00, $00, $00, $FF, $03, $01, $87, $87, $87, $FF, $FF, $00,
    $07, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $03, $01, $87,
    $87, $87, $FF, $FF
  );

  TFOGI0_RawData: packed array[0..127] of Byte = (
    $0D, $00, $0D, $00, $06, $00, $1C, $00, $3C, $00, $00, $00, $42, $00, $00,
    $00, $43, $00, $00, $00, $49, $00, $00, $00, $4A, $00, $00, $00, $54, $00,
    $00, $00, $55, $00, $00, $00, $67, $00, $00, $00, $68, $00, $00, $00, $72,
    $00, $00, $00, $73, $00, $00, $00, $79, $00, $00, $00, $7A, $00, $00, $00,
    $06, $01, $87, $87, $87, $FF, $FF, $06, $01, $87, $87, $87, $FF, $FF, $04,
    $05, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $00, $0D, $87, $87, $87,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $04,
    $05, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $06, $01, $87, $87, $87,
    $FF, $FF, $06, $01, $87, $87, $87, $FF
  );

  TFOGJ0_RawData: packed array[0..181] of Byte = (
    $11, $00, $11, $00, $08, $00, $1E, $00, $4C, $00, $00, $00, $52, $00, $00,
    $00, $53, $00, $00, $00, $5B, $00, $00, $00, $5C, $00, $00, $00, $66, $00,
    $00, $00, $67, $00, $00, $00, $75, $00, $00, $00, $76, $00, $00, $00, $8C,
    $00, $00, $00, $8D, $00, $00, $00, $9B, $00, $00, $00, $9C, $00, $00, $00,
    $A6, $00, $00, $00, $A7, $00, $00, $00, $AF, $00, $00, $00, $B0, $00, $00,
    $00, $08, $01, $87, $87, $87, $FF, $FF, $07, $03, $87, $87, $87, $87, $87,
    $FF, $FF, $06, $05, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $04, $09,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $FF, $FF, $00, $11,
    $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $FF, $FF, $04, $09, $87, $87, $87, $87, $87, $87, $87,
    $87, $87, $87, $87, $FF, $FF, $06, $05, $87, $87, $87, $87, $87, $87, $87,
    $FF, $FF, $07, $03, $87, $87, $87, $87, $87, $FF, $FF, $08, $01, $87, $87,
    $87, $FF
  );

  YKEYA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF, $02, $0E, $88, $88, $89, $89, $89, $89,
    $89, $89, $89, $89, $8A, $89, $87, $87, $AE, $AE, $FF, $01, $0F, $88, $88,
    $89, $89, $89, $87, $89, $89, $8A, $8A, $8A, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $89, $89, $8A, $89, $89, $8A, $8A, $89, $89,
    $8A, $89, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $87, $8A, $89, $89,
    $87, $89, $89, $89, $8A, $8A, $89, $89, $87, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $81, $81, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $89, $89, $89, $89, $89, $89, $89,
    $89, $89, $8A, $8A, $8A, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $81,
    $81, $89, $89, $89, $8A, $8A, $89, $89, $89, $89, $8A, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $87, $87, $89, $89, $89, $89, $8A, $89, $89,
    $89, $89, $8A, $89, $AE, $AE, $FF, $00, $10, $88, $88, $81, $81, $89, $89,
    $89, $8A, $89, $89, $89, $87, $89, $89, $89, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $89, $89, $89, $89, $89, $87, $89, $89, $89, $89, $8A, $89, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $81, $81, $8A, $87, $89, $89, $8A,
    $89, $89, $89, $89, $89, $89, $8A, $AE, $AE, $FF, $00, $10, $88, $88, $87,
    $89, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF
  );

  YKEYB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF, $02, $0E, $88, $88, $89, $89, $89, $89,
    $89, $89, $89, $89, $8A, $89, $87, $87, $AE, $AE, $FF, $01, $0F, $88, $88,
    $89, $89, $89, $87, $89, $89, $8A, $8A, $8A, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $89, $89, $8A, $89, $89, $8A, $8A, $89, $89,
    $8A, $89, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $87, $8A, $89, $89,
    $87, $89, $89, $89, $8A, $8A, $89, $89, $87, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $80, $80, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $89, $89, $89, $89, $89, $89, $89,
    $89, $89, $8A, $8A, $8A, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $80,
    $80, $89, $89, $89, $8A, $8A, $89, $89, $89, $89, $8A, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $87, $87, $89, $89, $89, $89, $8A, $89, $89,
    $89, $89, $8A, $89, $AE, $AE, $FF, $00, $10, $88, $88, $80, $80, $89, $89,
    $89, $8A, $89, $89, $89, $87, $89, $89, $89, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $89, $89, $89, $89, $89, $87, $89, $89, $89, $89, $8A, $89, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $80, $80, $8A, $87, $89, $89, $8A,
    $89, $89, $89, $89, $89, $89, $8A, $AE, $AE, $FF, $00, $10, $88, $88, $87,
    $89, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF
  );

  YSKUA0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF, $02, $0E, $88, $88, $89, $89, $89, $89,
    $89, $89, $89, $89, $8A, $89, $87, $87, $AE, $AE, $FF, $01, $0F, $88, $88,
    $89, $89, $89, $8A, $AE, $89, $AD, $52, $8A, $8A, $AE, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $89, $89, $8A, $8A, $AE, $8A, $AD, $AE, $89,
    $AD, $AE, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $87, $8A, $89, $89,
    $8A, $AE, $89, $8A, $52, $8A, $8A, $AE, $87, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $81, $81, $89, $89, $8A, $52, $89, $8A, $52, $89, $8A, $AE, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $89, $89, $89, $89, $8A, $AE, $89,
    $8A, $AE, $8A, $AD, $52, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $81,
    $81, $89, $89, $8A, $52, $8A, $8A, $AE, $89, $8A, $52, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $87, $87, $89, $8A, $AE, $89, $AD, $AE, $89,
    $8A, $AE, $8A, $89, $AE, $AE, $FF, $00, $10, $88, $88, $81, $81, $89, $89,
    $8A, $52, $89, $8A, $AE, $87, $8A, $AE, $89, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $89, $89, $89, $89, $8A, $AD, $89, $8A, $AE, $89, $AD, $AE, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $81, $81, $8A, $87, $8A, $AE, $8A,
    $8A, $AE, $89, $8A, $AE, $89, $8A, $AE, $AE, $FF, $00, $10, $88, $88, $87,
    $89, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF
  );

  YSKUB0_RawData: packed array[0..351] of Byte = (
    $0E, $00, $10, $00, $07, $00, $12, $00, $40, $00, $00, $00, $52, $00, $00,
    $00, $65, $00, $00, $00, $79, $00, $00, $00, $8E, $00, $00, $00, $A3, $00,
    $00, $00, $B8, $00, $00, $00, $CD, $00, $00, $00, $E2, $00, $00, $00, $F7,
    $00, $00, $00, $0C, $01, $00, $00, $21, $01, $00, $00, $36, $01, $00, $00,
    $4B, $01, $00, $00, $03, $0D, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF, $02, $0E, $88, $88, $89, $89, $89, $89,
    $89, $89, $89, $89, $8A, $89, $87, $87, $AE, $AE, $FF, $01, $0F, $88, $88,
    $89, $89, $89, $8A, $AE, $89, $AD, $52, $8A, $8A, $AE, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $89, $89, $8A, $8A, $AE, $8A, $AD, $AE, $89,
    $AD, $AE, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $87, $8A, $89, $89,
    $8A, $AE, $89, $8A, $52, $8A, $8A, $AE, $87, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $80, $80, $89, $89, $8A, $52, $89, $8A, $52, $89, $8A, $AE, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $89, $89, $89, $89, $8A, $AE, $89,
    $8A, $AE, $8A, $AD, $52, $89, $89, $AE, $AE, $FF, $00, $10, $88, $88, $80,
    $80, $89, $89, $8A, $52, $8A, $8A, $AE, $89, $8A, $52, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $87, $87, $87, $89, $8A, $AE, $89, $AD, $AE, $89,
    $8A, $AE, $8A, $89, $AE, $AE, $FF, $00, $10, $88, $88, $80, $80, $89, $89,
    $8A, $52, $89, $8A, $AE, $87, $8A, $AE, $89, $89, $AE, $AE, $FF, $00, $10,
    $88, $88, $89, $89, $89, $89, $8A, $AD, $89, $8A, $AE, $89, $AD, $AE, $89,
    $8A, $AE, $AE, $FF, $00, $10, $88, $88, $80, $80, $8A, $87, $8A, $AE, $8A,
    $8A, $AE, $89, $8A, $AE, $89, $8A, $AE, $AE, $FF, $00, $10, $88, $88, $87,
    $89, $89, $89, $89, $8A, $89, $89, $8A, $89, $89, $89, $89, $89, $AE, $AE,
    $FF, $00, $10, $88, $88, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A, $8A,
    $8A, $8A, $8A, $8A, $AE, $AE, $FF
  );

implementation

end.

