//
//  RAD: Recreation of the game "Radix - beyond the void"
//       powered by the DelphiDoom engine
//
//  Copyright (C) 1995 by Epic MegaGames, Inc.
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2004-2022 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//  DESCRIPTION:
//   End screen data
//
//------------------------------------------------------------------------------
//  Site: https://sourceforge.net/projects/rad-x/
//------------------------------------------------------------------------------

{$I RAD.inc}

unit radix_end_screen;

interface

//==============================================================================
//
// RX_GetEndScreenData
//
//==============================================================================
function RX_GetEndScreenData: pointer;

implementation

uses
  doomdef,
  doomstat,
  radix_version;

const
  end_screen_v20_reg: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $52, $4A, $45, $4A, $4D, $4A, $49, $4A, $58,
    $4A, $20, $4A, $76, $4A, $32, $4A, $2E, $4A, $30, $4A, $20, $4A, $2D, $4A,
    $20, $4A, $52, $4A, $65, $4A, $67, $4A, $69, $4A, $73, $4A, $74, $4A, $65,
    $4A, $72, $4A, $65, $4A, $64, $4A, $20, $4A, $56, $4A, $65, $4A, $72, $4A,
    $73, $4A, $69, $4A, $6F, $4A, $6E, $4A, $20, $4A, $20, $4A, $20, $4A, $20,
    $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $3E, $CE, $3E, $CE, $3E, $CE, $20, $CE,
    $44, $CE, $4F, $CE, $20, $CE, $4E, $CE, $4F, $CE, $54, $CE, $20, $CE, $44,
    $CE, $49, $CE, $53, $CE, $54, $CE, $52, $CE, $49, $CE, $42, $CE, $55, $CE,
    $54, $CE, $45, $CE, $20, $CE, $3C, $CE, $3C, $CE, $3C, $CE, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $CE, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $43, $47,
    $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47, $67, $47, $68, $47, $74,
    $47, $20, $47, $28, $47, $43, $47, $29, $47, $20, $47, $31, $47, $39, $47,
    $39, $47, $36, $47, $20, $47, $45, $47, $70, $47, $69, $47, $63, $47, $20,
    $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47, $47, $61, $47, $6D, $47,
    $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63, $47, $2E,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4C, $20, $4C, $45, $4C, $20, $4C, $59, $4C, $20, $4C, $4F, $4C, $20,
    $4C, $4E, $4C, $20, $4C, $44, $4C, $20, $4C, $20, $4C, $20, $4C, $54, $4C,
    $20, $4C, $48, $4C, $20, $4C, $45, $4C, $20, $4C, $20, $4C, $20, $4C, $56,
    $4C, $20, $4C, $4F, $4C, $20, $4C, $49, $4C, $20, $4C, $44, $4C, $20, $4C,
    $20, $4C, $20, $4C, $20, $4C, $20, $4C, $44, $47, $65, $47, $76, $47, $65,
    $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64, $47, $20, $47, $62, $47,
    $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47, $72, $47, $61, $47, $6C,
    $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72, $47, $6D, $47, $20, $47,
    $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47, $74, $47, $61, $47, $69,
    $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $54,
    $4B, $68, $4B, $69, $4B, $73, $4B, $20, $4B, $69, $4B, $73, $4B, $20, $4B,
    $61, $4B, $20, $4B, $72, $4B, $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74,
    $4B, $65, $4B, $72, $4B, $65, $4B, $64, $4B, $20, $4B, $76, $4B, $65, $4B,
    $72, $4B, $73, $4B, $69, $4B, $6F, $4B, $6E, $4B, $20, $4B, $6F, $4B, $66,
    $4B, $20, $4B, $52, $4B, $61, $4B, $64, $4B, $69, $4B, $78, $4B, $2E, $4B,
    $20, $4B, $20, $4B, $49, $4B, $66, $4B, $20, $4B, $79, $4B, $6F, $4B, $75,
    $4B, $20, $4B, $64, $4B, $6F, $4B, $20, $4B, $6E, $4B, $6F, $4B, $74, $4B,
    $20, $4B, $68, $4B, $61, $4B, $76, $4B, $65, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $72, $4B, $20, $4B, $6F, $4B, $77, $4B, $6E, $4B, $20, $4B,
    $70, $4B, $65, $4B, $72, $4B, $73, $4B, $6F, $4B, $6E, $4B, $61, $4B, $6C,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $72, $4B,
    $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74, $4B, $65, $4B, $72, $4B, $65,
    $4B, $64, $4B, $20, $4B, $63, $4B, $6F, $4B, $70, $4B, $79, $4B, $20, $4B,
    $6F, $4B, $66, $4B, $20, $4B, $74, $4B, $68, $4B, $69, $4B, $73, $4B, $20,
    $4B, $67, $4B, $61, $4B, $6D, $4B, $65, $4B, $2C, $4B, $20, $4B, $6F, $4B,
    $72, $4B, $64, $4B, $65, $4B, $72, $4B, $20, $4B, $69, $4B, $74, $4B, $20,
    $4B, $6E, $4B, $6F, $4B, $77, $4B, $20, $4B, $62, $4B, $79, $4B, $20, $4B,
    $63, $4B, $61, $4B, $6C, $4B, $6C, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $31, $41, $2D, $41, $38, $41, $30, $41, $30, $41, $2D, $41, $39, $41,
    $37, $41, $32, $41, $2D, $41, $37, $41, $34, $41, $33, $41, $34, $41, $20,
    $41, $61, $4B, $6E, $4B, $64, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $70, $4B, $72, $4B, $65, $4B, $76, $4B, $65, $4B,
    $6E, $4B, $74, $4B, $20, $4B, $79, $4B, $6F, $4B, $75, $4B, $72, $4B, $73,
    $4B, $65, $4B, $6C, $4B, $66, $4B, $20, $4B, $66, $4B, $72, $4B, $6F, $4B,
    $6D, $4B, $20, $4B, $62, $4B, $65, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $73, $4B, $75, $4B, $63, $4B, $6B, $4B, $65, $4B, $64, $4B, $20, $4B,
    $69, $4B, $6E, $4B, $74, $4B, $6F, $4B, $20, $4B, $74, $4B, $68, $4B, $65,
    $4B, $20, $4B, $76, $4B, $6F, $4B, $69, $4B, $64, $4B, $21, $4B, $20, $4B,
    $54, $4B, $68, $4B, $61, $4B, $6E, $4B, $6B, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $2E, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $50,
    $47, $72, $47, $6F, $47, $67, $47, $72, $47, $61, $47, $6D, $47, $6D, $47,
    $69, $47, $6E, $47, $67, $47, $3A, $47, $20, $47, $44, $4F, $61, $4F, $6E,
    $4F, $20, $4F, $44, $4F, $75, $4F, $46, $4F, $65, $4F, $75, $4F, $2C, $4F,
    $20, $4F, $53, $4F, $68, $4F, $61, $4F, $68, $4F, $7A, $4F, $61, $4F, $64,
    $4F, $20, $4F, $4D, $4F, $61, $4F, $6C, $4F, $69, $4F, $6B, $4F, $2C, $4F,
    $20, $4F, $4A, $4F, $6F, $4F, $6E, $4F, $61, $4F, $74, $4F, $68, $4F, $61,
    $4F, $6E, $4F, $20, $4F, $4D, $4F, $61, $4F, $76, $4F, $6F, $4F, $72, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4B, $20, $4B, $20, $4B,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $41, $47, $72, $47,
    $74, $47, $3A, $47, $20, $47, $43, $4F, $79, $4F, $67, $4F, $6E, $4F, $75,
    $4F, $73, $4F, $20, $4F, $4D, $4F, $75, $4F, $6C, $4F, $74, $4F, $69, $4F,
    $6D, $4F, $65, $4F, $64, $4F, $69, $4F, $61, $4F, $2C, $4F, $20, $4F, $47,
    $4F, $72, $4F, $65, $4F, $67, $4F, $20, $4F, $4D, $4F, $61, $4F, $63, $4F,
    $4D, $4F, $61, $4F, $72, $4F, $74, $4F, $69, $4F, $6E, $4F, $2C, $4F, $20,
    $4F, $4A, $4F, $61, $4F, $73, $4F, $6F, $4F, $6E, $4F, $20, $4F, $53, $4F,
    $74, $4F, $72, $4F, $81, $4F, $63, $4F, $6B, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4B, $20, $4B, $20, $4B, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $41, $47, $64, $47, $64, $47,
    $69, $47, $74, $47, $69, $47, $6F, $47, $6E, $47, $61, $47, $6C, $47, $20,
    $47, $50, $47, $72, $47, $6F, $47, $67, $47, $72, $47, $61, $47, $6D, $47,
    $6D, $47, $69, $47, $6E, $47, $67, $47, $3A, $47, $20, $47, $4D, $4F, $61,
    $4F, $72, $4F, $6B, $4F, $20, $4F, $4C, $4F, $65, $4F, $77, $4F, $69, $4F,
    $73, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4B, $20, $4B, $20, $4B, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $4D, $47, $75, $47, $73, $47, $69, $47, $63, $47, $3A, $47,
    $20, $47, $4D, $4F, $61, $4F, $72, $4F, $63, $4F, $20, $4F, $47, $4F, $72,
    $4F, $61, $4F, $76, $4F, $65, $4F, $6C, $4F, $6C, $4F, $65, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $53, $47, $6F, $47, $75, $47, $6E, $47, $64, $47, $20, $47,
    $46, $47, $58, $47, $3A, $47, $20, $47, $4D, $4F, $61, $4F, $72, $4F, $6B,
    $4F, $20, $4F, $54, $4F, $6F, $4F, $74, $4F, $74, $4F, $69, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4B, $20, $4B, $20, $4B,
    $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C, $53,
    $4C, $70, $4C, $65, $4C, $63, $4C, $69, $4C, $61, $4C, $6C, $4C, $20, $4C,
    $74, $4C, $68, $4C, $61, $4C, $6E, $4C, $6B, $4C, $73, $4C, $20, $4C, $74,
    $4C, $6F, $4C, $20, $4C, $47, $4C, $72, $4C, $65, $4C, $67, $4C, $20, $4C,
    $61, $4C, $6E, $4C, $64, $4C, $20, $4C, $44, $4C, $61, $4C, $6E, $4C, $20,
    $4C, $66, $4C, $6F, $4C, $72, $4C, $20, $4C, $70, $4C, $72, $4C, $6F, $4C,
    $64, $4C, $75, $4C, $63, $4C, $69, $4C, $6E, $4C, $67, $4C, $20, $4C, $74,
    $4C, $68, $4C, $65, $4C, $20, $4C, $52, $4C, $65, $4C, $6D, $4C, $69, $4C,
    $78, $4C, $20, $4C, $56, $4C, $65, $4C, $72, $4C, $73, $4C, $69, $4C, $6F,
    $4C, $6E, $4C, $21, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C,
    $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4C, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $1F, $20, $1F, $20, $1F, $45, $1E, $70, $1E, $69, $1E, $63,
    $1E, $20, $1E, $4D, $1E, $65, $1E, $67, $1E, $61, $1E, $47, $1E, $61, $1E,
    $6D, $1E, $65, $1E, $73, $1E, $2C, $1E, $20, $1E, $49, $1E, $6E, $1E, $63,
    $1E, $2E, $1E, $20, $1E, $20, $1E, $20, $1E, $DC, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $4B, $20, $4B, $20, $4B, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $10, $20,
    $10, $20, $10, $31, $1B, $30, $1B, $34, $1B, $30, $1B, $36, $1B, $20, $1B,
    $48, $1B, $6F, $1B, $6C, $1B, $62, $1B, $72, $1B, $6F, $1B, $6F, $1B, $6B,
    $1B, $20, $1B, $44, $1B, $72, $1B, $69, $1B, $76, $1B, $65, $1B, $20, $1B,
    $20, $1B, $20, $1B, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $4B, $20, $4B, $20, $4B,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $10, $20, $10, $50, $1B, $6F, $1B,
    $74, $1B, $6F, $1B, $6D, $1B, $61, $1B, $63, $1B, $2C, $1B, $20, $1B, $4D,
    $1B, $44, $1B, $2C, $1B, $20, $1B, $32, $1B, $30, $1B, $38, $1B, $35, $1B,
    $34, $1B, $20, $1B, $55, $1B, $53, $1B, $41, $1B, $20, $1B, $20, $1B, $DB,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $4B, $20, $4B, $20, $4B, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $4B, $20, $4B, $20, $4B, $20, $70, $20, $70, $55, $78, $53, $78, $41, $78,
    $2F, $78, $43, $78, $41, $78, $4E, $78, $41, $78, $44, $78, $41, $78, $3A,
    $78, $20, $78, $28, $74, $38, $74, $30, $74, $30, $74, $29, $74, $39, $74,
    $37, $74, $32, $74, $2D, $74, $37, $74, $34, $74, $33, $74, $34, $74, $20,
    $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2C, $7F,
    $20, $7F, $28, $74, $33, $74, $30, $74, $31, $74, $29, $74, $39, $74, $38,
    $74, $33, $74, $2D, $74, $39, $74, $37, $74, $37, $74, $31, $74, $20, $74,
    $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F, $4E,
    $7F, $53, $7F, $2C, $7F, $20, $7F, $28, $74, $33, $74, $30, $74, $31, $74,
    $29, $74, $32, $74, $39, $74, $39, $74, $2D, $74, $33, $74, $38, $74, $34,
    $74, $31, $74, $20, $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $55,
    $78, $4B, $78, $3A, $78, $20, $78, $2B, $74, $34, $74, $34, $74, $20, $74,
    $28, $74, $30, $74, $29, $74, $20, $74, $31, $74, $32, $74, $30, $74, $32,
    $74, $20, $74, $35, $74, $32, $74, $31, $74, $30, $74, $31, $74, $31, $74,
    $20, $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2F,
    $7F, $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F,
    $4E, $7F, $53, $7F, $2C, $7F, $20, $7F, $2B, $74, $34, $74, $34, $74, $20,
    $74, $28, $74, $30, $74, $29, $74, $20, $74, $31, $74, $32, $74, $30, $74,
    $32, $74, $20, $74, $35, $74, $32, $74, $32, $74, $38, $74, $33, $74, $37,
    $74, $20, $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20,
    $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $47, $78, $45, $78, $52, $78, $4D, $78, $41, $78, $4E,
    $78, $59, $78, $3A, $78, $20, $78, $37, $74, $32, $74, $31, $74, $39, $74,
    $20, $74, $37, $74, $32, $74, $32, $74, $34, $74, $2D, $74, $30, $74, $20,
    $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2F, $7F,
    $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F, $4E,
    $7F, $53, $7F, $2C, $7F, $20, $7F, $37, $74, $32, $74, $31, $74, $39, $74,
    $20, $74, $37, $74, $32, $74, $32, $74, $34, $74, $32, $74, $34, $74, $20,
    $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20,
    $7F, $20, $7F, $20, $7F, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07
  );

  end_screen_v20_sha: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $52, $4A, $45, $4A, $4D, $4A, $49, $4A, $58,
    $4A, $20, $4A, $76, $4A, $32, $4A, $2E, $4A, $30, $4A, $20, $4A, $2D, $4A,
    $20, $4A, $53, $4A, $68, $4A, $61, $4A, $72, $4A, $65, $4A, $77, $4A, $61,
    $4A, $72, $4A, $65, $4A, $20, $4A, $56, $4A, $65, $4A, $72, $4A, $73, $4A,
    $69, $4A, $6F, $4A, $6E, $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $20,
    $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $20, $4A, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $44, $4F, $49, $4F, $53, $4F, $54, $4F, $52, $4F, $49, $4F, $42, $4F, $55,
    $4F, $54, $4F, $45, $4F, $20, $4F, $46, $4F, $52, $4F, $45, $4F, $45, $4F,
    $4C, $4F, $59, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $43, $47,
    $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47, $67, $47, $68, $47, $74,
    $47, $20, $47, $28, $47, $43, $47, $29, $47, $20, $47, $31, $47, $39, $47,
    $39, $47, $36, $47, $20, $47, $45, $47, $70, $47, $69, $47, $63, $47, $20,
    $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47, $47, $61, $47, $6D, $47,
    $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63, $47, $2E,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4C, $20, $4C, $45, $4C, $20, $4C, $59, $4C, $20, $4C, $4F, $4C, $20,
    $4C, $4E, $4C, $20, $4C, $44, $4C, $20, $4C, $20, $4C, $20, $4C, $54, $4C,
    $20, $4C, $48, $4C, $20, $4C, $45, $4C, $20, $4C, $20, $4C, $20, $4C, $56,
    $4C, $20, $4C, $4F, $4C, $20, $4C, $49, $4C, $20, $4C, $44, $4C, $20, $4C,
    $20, $4C, $20, $4C, $20, $4C, $20, $4C, $44, $47, $65, $47, $76, $47, $65,
    $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64, $47, $20, $47, $62, $47,
    $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47, $72, $47, $61, $47, $6C,
    $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72, $47, $6D, $47, $20, $47,
    $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47, $74, $47, $61, $47, $69,
    $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $21, $40, $21,
    $40, $21, $40, $20, $40, $4F, $C0, $52, $C0, $44, $C0, $45, $C0, $52, $C0,
    $20, $C0, $4E, $C0, $4F, $C0, $57, $C0, $20, $C0, $21, $40, $21, $40, $21,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $47, $4E, $45, $4E,
    $54, $4E, $20, $4E, $54, $4E, $48, $4E, $45, $4E, $20, $4E, $52, $4E, $45,
    $4E, $47, $4E, $49, $4E, $53, $4E, $54, $4E, $45, $4E, $52, $4E, $45, $4E,
    $44, $4E, $20, $4E, $52, $4E, $45, $4E, $4D, $4E, $49, $4E, $58, $4E, $20,
    $4E, $56, $4E, $45, $4E, $52, $4E, $53, $4E, $49, $4E, $4F, $4E, $4E, $4E,
    $20, $4E, $41, $4E, $4E, $4E, $44, $4E, $20, $4E, $52, $4E, $45, $4E, $43,
    $4E, $45, $4E, $49, $4E, $56, $4E, $45, $4E, $3A, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $FE, $4B, $20, $4B, $61, $4B, $20, $4B, $74, $4B, $6F, $4B, $74,
    $4B, $61, $4B, $6C, $4B, $20, $4B, $6F, $4B, $66, $4B, $20, $4B, $32, $4F,
    $37, $4F, $20, $4F, $61, $4B, $63, $4B, $74, $4B, $69, $4B, $6F, $4B, $6E,
    $4B, $20, $4B, $70, $4B, $61, $4B, $63, $4B, $6B, $4B, $65, $4B, $64, $4B,
    $20, $4B, $6C, $4B, $65, $4B, $76, $4B, $65, $4B, $6C, $4B, $73, $4B, $2C,
    $4B, $20, $4B, $77, $4B, $69, $4B, $74, $4B, $68, $4B, $20, $4B, $61, $4B,
    $6C, $4B, $6C, $4B, $20, $4B, $6E, $4B, $65, $4B, $77, $4B, $20, $4B, $67,
    $4B, $72, $4B, $61, $4B, $70, $4B, $68, $4B, $69, $4B, $63, $4B, $73, $4B,
    $2C, $4B, $20, $4B, $6D, $4B, $75, $4B, $73, $4B, $69, $4B, $63, $4B, $2C,
    $4B, $20, $4B, $61, $4B, $6E, $4B, $64, $4B, $20, $4B, $73, $4B, $6F, $4B,
    $75, $4B, $6E, $4B, $64, $4B, $21, $4B, $20, $4B, $20, $4B, $FE, $4B, $20,
    $4B, $74, $4B, $68, $4B, $65, $4B, $20, $4B, $4D, $4B, $65, $4B, $67, $4B,
    $61, $4B, $2D, $4B, $43, $4B, $6F, $4B, $6F, $4B, $6C, $4B, $20, $4B, $52,
    $4B, $41, $4B, $44, $4B, $49, $4B, $58, $4B, $20, $4B, $6D, $4B, $61, $4B,
    $6E, $4B, $75, $4B, $61, $4B, $6C, $4B, $20, $4B, $66, $4B, $69, $4B, $6C,
    $4B, $6C, $4B, $65, $4B, $64, $4B, $20, $4B, $77, $4B, $69, $4B, $74, $4B,
    $68, $4B, $20, $4B, $61, $4B, $77, $4B, $65, $4B, $73, $4B, $6F, $4B, $6D,
    $4B, $65, $4B, $20, $4B, $52, $4B, $41, $4B, $44, $4B, $49, $4B, $58, $4B,
    $20, $4B, $69, $4B, $6E, $4B, $66, $4B, $6F, $4B, $21, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $FE, $4B, $20, $4B, $34, $4F, $20, $4F,
    $64, $4B, $65, $4B, $61, $4B, $64, $4B, $6C, $4B, $79, $4B, $20, $4B, $6E,
    $4B, $65, $4B, $77, $4B, $20, $4B, $65, $4B, $6E, $4B, $65, $4B, $6D, $4B,
    $69, $4B, $65, $4B, $73, $4B, $2C, $4B, $20, $4B, $61, $4B, $6E, $4B, $64,
    $4B, $20, $4B, $32, $4F, $20, $4F, $6D, $4B, $6F, $4B, $72, $4B, $65, $4B,
    $20, $4B, $63, $4B, $68, $4B, $61, $4B, $6C, $4B, $6C, $4B, $65, $4B, $6E,
    $4B, $67, $4B, $69, $4B, $6E, $4B, $67, $4B, $20, $4B, $65, $4B, $6E, $4B,
    $64, $4B, $20, $4B, $62, $4B, $6F, $4B, $73, $4B, $73, $4B, $65, $4B, $73,
    $4B, $21, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $FE, $4B, $20, $4B, $34, $4F, $20, $4F, $6E, $4B, $65, $4B, $77,
    $4B, $20, $4B, $77, $4B, $65, $4B, $61, $4B, $70, $4B, $6F, $4B, $6E, $4B,
    $73, $4B, $20, $4B, $2D, $4B, $20, $4B, $41, $4B, $64, $4B, $76, $4B, $61,
    $4B, $6E, $4B, $63, $4B, $65, $4B, $64, $4B, $20, $4B, $45, $4B, $50, $4B,
    $43, $4B, $73, $4B, $2C, $4B, $20, $4B, $4E, $4B, $75, $4B, $6B, $4B, $65,
    $4B, $73, $4B, $2C, $4B, $20, $4B, $50, $4B, $68, $4B, $61, $4B, $73, $4B,
    $65, $4B, $20, $4B, $54, $4B, $6F, $4B, $72, $4B, $70, $4B, $65, $4B, $64,
    $4B, $6F, $4B, $65, $4B, $73, $4B, $2C, $4B, $20, $4B, $61, $4B, $6E, $4B,
    $64, $4B, $20, $4B, $54, $4B, $68, $4B, $65, $4B, $20, $4B, $47, $4B, $72,
    $4B, $61, $4B, $76, $4B, $69, $4B, $74, $4B, $79, $4B, $20, $4B, $57, $4B,
    $61, $4B, $76, $4B, $65, $4B, $21, $4B, $20, $4B, $20, $4B, $FE, $4B, $20,
    $4B, $6D, $4B, $6F, $4B, $72, $4B, $65, $4B, $20, $4B, $63, $4B, $6F, $4B,
    $6F, $4B, $6C, $4B, $20, $4B, $70, $4B, $6F, $4B, $77, $4B, $65, $4B, $72,
    $4B, $2D, $4B, $75, $4B, $70, $4B, $73, $4B, $2C, $4B, $20, $4B, $6C, $4B,
    $69, $4B, $6B, $4B, $65, $4B, $20, $4B, $74, $4B, $68, $4B, $65, $4B, $20,
    $4B, $41, $4B, $75, $4B, $74, $4B, $6F, $4B, $6D, $4B, $61, $4B, $74, $4B,
    $65, $4B, $64, $4B, $20, $4B, $4C, $4B, $61, $4B, $73, $4B, $65, $4B, $72,
    $4B, $20, $4B, $44, $4B, $65, $4B, $66, $4B, $65, $4B, $6E, $4B, $63, $4B,
    $65, $4B, $20, $4B, $53, $4B, $79, $4B, $73, $4B, $74, $4B, $65, $4B, $6D,
    $4B, $21, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $FE, $4B, $20, $4B, $77, $4B, $69, $4B,
    $6C, $4B, $64, $4B, $20, $4B, $6E, $4B, $65, $4B, $77, $4B, $20, $4B, $65,
    $4B, $6E, $4B, $76, $4B, $69, $4B, $72, $4B, $6F, $4B, $6E, $4B, $6D, $4B,
    $65, $4B, $6E, $4B, $74, $4B, $61, $4B, $6C, $4B, $20, $4B, $68, $4B, $61,
    $4B, $7A, $4B, $61, $4B, $72, $4B, $64, $4B, $73, $4B, $2C, $4B, $20, $4B,
    $73, $4B, $75, $4B, $63, $4B, $68, $4B, $20, $4B, $61, $4B, $73, $4B, $20,
    $4B, $74, $4B, $65, $4B, $6C, $4B, $65, $4B, $70, $4B, $6F, $4B, $72, $4B,
    $74, $4B, $73, $4B, $20, $4B, $61, $4B, $6E, $4B, $64, $4B, $20, $4B, $6C,
    $4B, $61, $4B, $76, $4B, $61, $4B, $20, $4B, $70, $4B, $6F, $4B, $6F, $4B,
    $6C, $4B, $73, $4B, $21, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $70, $4F,
    $74, $72, $74, $64, $74, $65, $74, $72, $74, $20, $74, $52, $74, $41, $74,
    $44, $74, $49, $74, $58, $74, $20, $74, $6E, $74, $6F, $74, $77, $74, $20,
    $74, $66, $74, $6F, $74, $72, $74, $20, $74, $6F, $74, $6E, $74, $6C, $74,
    $79, $74, $20, $74, $24, $74, $33, $74, $35, $74, $2E, $74, $30, $74, $30,
    $74, $20, $74, $55, $74, $53, $74, $2E, $74, $20, $74, $20, $74, $DC, $40,
    $20, $40, $20, $70, $4D, $7F, $41, $7F, $49, $7F, $4C, $7F, $20, $7F, $4F,
    $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $3A, $7F, $20, $7F,
    $45, $78, $70, $78, $69, $78, $63, $78, $20, $78, $4D, $78, $65, $78, $67,
    $78, $61, $78, $47, $78, $61, $78, $6D, $78, $65, $78, $73, $78, $2C, $78,
    $20, $78, $49, $78, $6E, $78, $63, $78, $2E, $78, $20, $78, $20, $78, $20,
    $78, $DC, $40, $20, $40, $20, $40, $20, $70, $41, $71, $64, $71, $64, $71,
    $20, $71, $24, $71, $34, $71, $20, $71, $55, $71, $53, $71, $20, $71, $53,
    $71, $26, $71, $48, $71, $20, $71, $28, $71, $24, $71, $36, $71, $20, $71,
    $69, $71, $6E, $71, $74, $71, $65, $71, $72, $71, $6E, $71, $61, $71, $74,
    $71, $69, $71, $6F, $71, $6E, $71, $61, $71, $6C, $71, $29, $71, $2E, $71,
    $20, $71, $20, $71, $20, $71, $20, $71, $DB, $40, $20, $40, $20, $70, $20,
    $70, $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $20, $70,
    $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $31, $71, $30, $71, $34,
    $71, $30, $71, $36, $71, $20, $71, $48, $71, $6F, $71, $6C, $71, $62, $71,
    $72, $71, $6F, $71, $6F, $71, $6B, $71, $20, $71, $44, $71, $72, $71, $69,
    $71, $76, $71, $65, $71, $20, $71, $20, $71, $20, $71, $DB, $40, $20, $40,
    $20, $40, $20, $70, $4D, $71, $44, $71, $20, $71, $72, $71, $65, $71, $73,
    $71, $69, $71, $64, $71, $65, $71, $6E, $71, $74, $71, $73, $71, $20, $71,
    $61, $71, $64, $71, $64, $71, $20, $71, $35, $71, $25, $71, $20, $71, $73,
    $71, $61, $71, $6C, $71, $65, $71, $73, $71, $20, $71, $74, $71, $61, $71,
    $78, $71, $2E, $71, $20, $71, $20, $71, $20, $71, $20, $71, $20, $71, $20,
    $71, $20, $71, $DB, $40, $20, $40, $20, $70, $20, $70, $20, $70, $20, $70,
    $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $20, $70, $20,
    $70, $20, $70, $20, $70, $50, $71, $6F, $71, $74, $71, $6F, $71, $6D, $71,
    $61, $71, $63, $71, $2C, $71, $20, $71, $4D, $71, $44, $71, $2C, $71, $20,
    $71, $32, $71, $30, $71, $38, $71, $35, $71, $34, $71, $20, $71, $55, $71,
    $53, $71, $41, $71, $20, $71, $DB, $40, $20, $40, $20, $40, $20, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $20, $40, $20, $70, $20, $70, $55, $78, $53, $78, $41, $78,
    $2F, $78, $43, $78, $41, $78, $4E, $78, $41, $78, $44, $78, $41, $78, $3A,
    $78, $20, $78, $28, $74, $38, $74, $30, $74, $30, $74, $29, $74, $39, $74,
    $37, $74, $32, $74, $2D, $74, $37, $74, $34, $74, $33, $74, $34, $74, $20,
    $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2C, $7F,
    $20, $7F, $28, $74, $33, $74, $30, $74, $31, $74, $29, $74, $39, $74, $38,
    $74, $33, $74, $2D, $74, $39, $74, $37, $74, $37, $74, $31, $74, $20, $74,
    $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F, $4E,
    $7F, $53, $7F, $2C, $7F, $20, $7F, $28, $74, $33, $74, $30, $74, $31, $74,
    $29, $74, $32, $74, $39, $74, $39, $74, $2D, $74, $33, $74, $38, $74, $34,
    $74, $31, $74, $20, $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $55,
    $78, $4B, $78, $3A, $78, $20, $78, $2B, $74, $34, $74, $34, $74, $20, $74,
    $28, $74, $30, $74, $29, $74, $20, $74, $31, $74, $32, $74, $30, $74, $32,
    $74, $20, $74, $35, $74, $32, $74, $31, $74, $30, $74, $31, $74, $31, $74,
    $20, $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2F,
    $7F, $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F,
    $4E, $7F, $53, $7F, $2C, $7F, $20, $7F, $2B, $74, $34, $74, $34, $74, $20,
    $74, $28, $74, $30, $74, $29, $74, $20, $74, $31, $74, $32, $74, $30, $74,
    $32, $74, $20, $74, $35, $74, $32, $74, $32, $74, $38, $74, $33, $74, $37,
    $74, $20, $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20,
    $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $47, $78, $45, $78, $52, $78, $4D, $78, $41, $78, $4E,
    $78, $59, $78, $3A, $78, $20, $78, $37, $74, $32, $74, $31, $74, $39, $74,
    $20, $74, $37, $74, $32, $74, $32, $74, $34, $74, $2D, $74, $30, $74, $20,
    $74, $4F, $7F, $52, $7F, $44, $7F, $45, $7F, $52, $7F, $53, $7F, $2F, $7F,
    $51, $7F, $55, $7F, $45, $7F, $53, $7F, $54, $7F, $49, $7F, $4F, $7F, $4E,
    $7F, $53, $7F, $2C, $7F, $20, $7F, $37, $74, $32, $74, $31, $74, $39, $74,
    $20, $74, $37, $74, $32, $74, $32, $74, $34, $74, $32, $74, $34, $74, $20,
    $74, $46, $7F, $41, $7F, $58, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F,
    $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20, $7F, $20,
    $7F, $20, $7F, $20, $7F, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20,
    $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07, $20, $07,
    $20, $07, $20, $07, $20, $07, $20, $07, $20, $07
  );

  end_screen_v11_sha: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $53, $4F, $48, $4F, $41, $4F, $52, $4F, $45, $4F, $57, $4F, $41, $4F, $52,
    $4F, $45, $4F, $20, $4F, $56, $4F, $45, $4F, $52, $4F, $53, $4F, $49, $4F,
    $4F, $4F, $4E, $4F, $20, $4F, $2D, $4F, $20, $4F, $44, $4F, $49, $4F, $53,
    $4F, $54, $4F, $52, $4F, $49, $4F, $42, $4F, $55, $4F, $54, $4F, $45, $4F,
    $20, $4F, $46, $4F, $52, $4F, $45, $4F, $45, $4F, $4C, $4F, $59, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $43, $47, $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47,
    $67, $47, $68, $47, $74, $47, $20, $47, $28, $47, $43, $47, $29, $47, $20,
    $47, $31, $47, $39, $47, $39, $47, $35, $47, $20, $47, $45, $47, $70, $47,
    $69, $47, $63, $47, $20, $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47,
    $47, $61, $47, $6D, $47, $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47,
    $6E, $47, $63, $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $44, $47,
    $65, $47, $76, $47, $65, $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64,
    $47, $20, $47, $62, $47, $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47,
    $72, $47, $61, $47, $6C, $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72,
    $47, $6D, $47, $20, $47, $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47,
    $74, $47, $61, $47, $69, $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4E, $20, $4E, $45, $4E, $20, $4E, $59, $4E, $20, $4E, $4F, $4E, $20,
    $4E, $4E, $4E, $20, $4E, $44, $4E, $20, $4E, $20, $4E, $20, $4E, $54, $4E,
    $20, $4E, $48, $4E, $20, $4E, $45, $4E, $20, $4E, $20, $4E, $20, $4E, $56,
    $4E, $20, $4E, $4F, $4E, $20, $4E, $49, $4E, $20, $4E, $44, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $61, $47, $6E, $47, $64, $47, $20, $47, $55, $47, $6E, $47,
    $69, $47, $6F, $47, $6E, $47, $20, $47, $4C, $47, $6F, $47, $67, $47, $69,
    $47, $63, $47, $20, $47, $53, $47, $6F, $47, $66, $47, $74, $47, $77, $47,
    $61, $47, $72, $47, $65, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63,
    $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $21, $4B, $21,
    $4B, $21, $4B, $20, $4B, $4F, $CB, $52, $CB, $44, $CB, $45, $CB, $52, $CB,
    $20, $CB, $4E, $CB, $4F, $CB, $57, $CB, $20, $CB, $21, $4B, $21, $4B, $21,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $52, $4F, $45, $4F, $47, $4F, $49, $4F, $53, $4F, $54, $4F, $45, $4F, $52,
    $4F, $20, $4F, $52, $4F, $41, $4F, $44, $4F, $49, $4F, $58, $4F, $20, $4F,
    $4E, $4F, $4F, $4F, $57, $4F, $20, $4F, $41, $4F, $4E, $4F, $44, $4F, $20,
    $4F, $59, $4F, $4F, $4F, $55, $4F, $20, $4F, $57, $4F, $49, $4F, $4C, $4F,
    $4C, $4F, $20, $4F, $52, $4F, $45, $4F, $43, $4F, $45, $4F, $49, $4F, $56,
    $4F, $45, $4F, $3A, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $FE, $4E, $20, $4E, $61, $4E, $20, $4E, $74, $4E, $6F, $4E, $74,
    $4E, $61, $4E, $6C, $4E, $20, $4E, $6F, $4E, $66, $4E, $20, $4E, $32, $4E,
    $37, $4E, $20, $4E, $61, $4E, $63, $4E, $74, $4E, $69, $4E, $6F, $4E, $6E,
    $4E, $20, $4E, $70, $4E, $61, $4E, $63, $4E, $6B, $4E, $65, $4E, $64, $4E,
    $20, $4E, $6C, $4E, $65, $4E, $76, $4E, $65, $4E, $6C, $4E, $73, $4E, $2C,
    $4E, $20, $4E, $77, $4E, $69, $4E, $74, $4E, $68, $4E, $20, $4E, $61, $4E,
    $6C, $4E, $6C, $4E, $20, $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $67,
    $4E, $72, $4E, $61, $4E, $70, $4E, $68, $4E, $69, $4E, $63, $4E, $73, $4E,
    $2C, $4E, $20, $4E, $6D, $4E, $75, $4E, $73, $4E, $69, $4E, $63, $4E, $2C,
    $4E, $20, $4E, $61, $4E, $6E, $4E, $64, $4E, $20, $4E, $73, $4E, $6F, $4E,
    $75, $4E, $6E, $4E, $64, $4E, $21, $4E, $20, $4E, $20, $4E, $FE, $4E, $20,
    $4E, $74, $4E, $68, $4E, $65, $4E, $20, $4E, $4D, $4E, $65, $4E, $67, $4E,
    $61, $4E, $2D, $4E, $43, $4E, $6F, $4E, $6F, $4E, $6C, $4E, $20, $4E, $52,
    $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E, $20, $4E, $6D, $4E, $61, $4E,
    $6E, $4E, $75, $4E, $61, $4E, $6C, $4E, $20, $4E, $66, $4E, $69, $4E, $6C,
    $4E, $6C, $4E, $65, $4E, $64, $4E, $20, $4E, $77, $4E, $69, $4E, $74, $4E,
    $68, $4E, $20, $4E, $61, $4E, $77, $4E, $65, $4E, $73, $4E, $6F, $4E, $6D,
    $4E, $65, $4E, $20, $4E, $52, $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E,
    $20, $4E, $69, $4E, $6E, $4E, $66, $4E, $6F, $4E, $21, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20, $4E, $34, $4E, $20, $4E,
    $64, $4E, $65, $4E, $61, $4E, $64, $4E, $6C, $4E, $79, $4E, $20, $4E, $6E,
    $4E, $65, $4E, $77, $4E, $20, $4E, $65, $4E, $6E, $4E, $65, $4E, $6D, $4E,
    $69, $4E, $65, $4E, $73, $4E, $2C, $4E, $20, $4E, $61, $4E, $6E, $4E, $64,
    $4E, $20, $4E, $32, $4E, $20, $4E, $6D, $4E, $6F, $4E, $72, $4E, $65, $4E,
    $20, $4E, $63, $4E, $68, $4E, $61, $4E, $6C, $4E, $6C, $4E, $65, $4E, $6E,
    $4E, $67, $4E, $69, $4E, $6E, $4E, $67, $4E, $20, $4E, $65, $4E, $6E, $4E,
    $64, $4E, $20, $4E, $62, $4E, $6F, $4E, $73, $4E, $73, $4E, $65, $4E, $73,
    $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $FE, $4E, $20, $4E, $33, $4E, $20, $4E, $61, $4E, $64, $4E, $64,
    $4E, $69, $4E, $74, $4E, $69, $4E, $6F, $4E, $6E, $4E, $61, $4E, $6C, $4E,
    $20, $4E, $52, $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E, $20, $4E, $77,
    $4E, $65, $4E, $61, $4E, $70, $4E, $6F, $4E, $6E, $4E, $73, $4E, $20, $4E,
    $2D, $4E, $20, $4E, $4E, $4E, $75, $4E, $6B, $4E, $65, $4E, $73, $4E, $2C,
    $4E, $20, $4E, $50, $4E, $68, $4E, $61, $4E, $73, $4E, $65, $4E, $20, $4E,
    $54, $4E, $6F, $4E, $72, $4E, $70, $4E, $65, $4E, $64, $4E, $6F, $4E, $65,
    $4E, $73, $4E, $2C, $4E, $20, $4E, $61, $4E, $6E, $4E, $64, $4E, $20, $4E,
    $54, $4E, $68, $4E, $65, $4E, $20, $4E, $47, $4E, $72, $4E, $61, $4E, $76,
    $4E, $69, $4E, $74, $4E, $79, $4E, $20, $4E, $57, $4E, $61, $4E, $76, $4E,
    $65, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20,
    $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $70, $4E, $6F, $4E, $77, $4E,
    $65, $4E, $72, $4E, $2D, $4E, $75, $4E, $70, $4E, $73, $4E, $2C, $4E, $20,
    $4E, $6C, $4E, $69, $4E, $6B, $4E, $65, $4E, $20, $4E, $74, $4E, $68, $4E,
    $65, $4E, $20, $4E, $41, $4E, $75, $4E, $74, $4E, $6F, $4E, $6D, $4E, $61,
    $4E, $74, $4E, $65, $4E, $64, $4E, $20, $4E, $4C, $4E, $61, $4E, $73, $4E,
    $65, $4E, $72, $4E, $20, $4E, $44, $4E, $65, $4E, $66, $4E, $65, $4E, $6E,
    $4E, $63, $4E, $65, $4E, $20, $4E, $53, $4E, $79, $4E, $73, $4E, $74, $4E,
    $65, $4E, $6D, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20, $4E, $77, $4E, $69, $4E,
    $6C, $4E, $64, $4E, $20, $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $65,
    $4E, $6E, $4E, $76, $4E, $69, $4E, $72, $4E, $6F, $4E, $6E, $4E, $6D, $4E,
    $65, $4E, $6E, $4E, $74, $4E, $61, $4E, $6C, $4E, $20, $4E, $68, $4E, $61,
    $4E, $7A, $4E, $61, $4E, $72, $4E, $64, $4E, $73, $4E, $2C, $4E, $20, $4E,
    $73, $4E, $75, $4E, $63, $4E, $68, $4E, $20, $4E, $61, $4E, $73, $4E, $20,
    $4E, $74, $4E, $65, $4E, $6C, $4E, $65, $4E, $70, $4E, $6F, $4E, $72, $4E,
    $74, $4E, $73, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $10, $4F,
    $1C, $72, $1C, $64, $1C, $65, $1C, $72, $1C, $20, $1C, $52, $1C, $41, $1C,
    $44, $1C, $49, $1C, $58, $1C, $20, $1C, $6E, $1C, $6F, $1C, $77, $1C, $20,
    $1C, $66, $1C, $6F, $1C, $72, $1C, $20, $1C, $6F, $1C, $6E, $1C, $6C, $1C,
    $79, $1C, $20, $1C, $24, $1C, $33, $1C, $35, $1C, $2E, $1C, $30, $1C, $30,
    $1C, $20, $1C, $55, $1C, $53, $1C, $2E, $1C, $20, $1C, $20, $1C, $DC, $40,
    $20, $40, $20, $10, $4D, $1F, $41, $1F, $49, $1F, $4C, $1F, $20, $1F, $4F,
    $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $3A, $1F, $20, $1F,
    $45, $1E, $70, $1E, $69, $1E, $63, $1E, $20, $1E, $4D, $1E, $65, $1E, $67,
    $1E, $61, $1E, $47, $1E, $61, $1E, $6D, $1E, $65, $1E, $73, $1E, $2C, $1E,
    $20, $1E, $49, $1E, $6E, $1E, $63, $1E, $2E, $1E, $20, $1E, $20, $1E, $20,
    $1E, $DC, $40, $20, $40, $20, $40, $20, $10, $41, $1B, $64, $1B, $64, $1B,
    $20, $1B, $24, $1B, $34, $1B, $20, $1B, $55, $1B, $53, $1B, $20, $1B, $53,
    $1B, $26, $1B, $48, $1B, $20, $1B, $28, $1B, $24, $1B, $36, $1B, $20, $1B,
    $69, $1B, $6E, $1B, $74, $1B, $65, $1B, $72, $1B, $6E, $1B, $61, $1B, $74,
    $1B, $69, $1B, $6F, $1B, $6E, $1B, $61, $1B, $6C, $1B, $29, $1B, $2E, $1B,
    $20, $1B, $20, $1B, $20, $1B, $20, $1B, $DB, $40, $20, $40, $20, $10, $20,
    $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10,
    $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $31, $1B, $30, $1B, $34,
    $1B, $30, $1B, $36, $1B, $20, $1B, $48, $1B, $6F, $1B, $6C, $1B, $62, $1B,
    $72, $1B, $6F, $1B, $6F, $1B, $6B, $1B, $20, $1B, $44, $1B, $72, $1B, $69,
    $1B, $76, $1B, $65, $1B, $20, $1B, $20, $1B, $20, $1B, $DB, $40, $20, $40,
    $20, $40, $20, $10, $4D, $1B, $44, $1B, $20, $1B, $72, $1B, $65, $1B, $73,
    $1B, $69, $1B, $64, $1B, $65, $1B, $6E, $1B, $74, $1B, $73, $1B, $20, $1B,
    $61, $1B, $64, $1B, $64, $1B, $20, $1B, $35, $1B, $25, $1B, $20, $1B, $73,
    $1B, $61, $1B, $6C, $1B, $65, $1B, $73, $1B, $20, $1B, $74, $1B, $61, $1B,
    $78, $1B, $2E, $1B, $20, $1B, $20, $1B, $20, $1B, $20, $1B, $20, $1B, $20,
    $1B, $20, $1B, $DB, $40, $20, $40, $20, $10, $20, $10, $20, $10, $20, $10,
    $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20,
    $10, $20, $10, $20, $10, $50, $1B, $6F, $1B, $74, $1B, $6F, $1B, $6D, $1B,
    $61, $1B, $63, $1B, $2C, $1B, $20, $1B, $4D, $1B, $44, $1B, $2C, $1B, $20,
    $1B, $32, $1B, $30, $1B, $38, $1B, $35, $1B, $34, $1B, $20, $1B, $55, $1B,
    $53, $1B, $41, $1B, $20, $1B, $DB, $40, $20, $40, $20, $40, $20, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $20, $40, $20, $10, $20, $10, $55, $1E, $53, $1E, $41, $1E,
    $2F, $1E, $43, $1E, $41, $1E, $4E, $1E, $41, $1E, $44, $1E, $41, $1E, $3A,
    $1E, $20, $1E, $28, $1A, $38, $1A, $30, $1A, $30, $1A, $29, $1A, $39, $1A,
    $37, $1A, $32, $1A, $2D, $1A, $37, $1A, $34, $1A, $33, $1A, $34, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2C, $1F,
    $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A, $29, $1A, $39, $1A, $38,
    $1A, $33, $1A, $2D, $1A, $39, $1A, $37, $1A, $37, $1A, $31, $1A, $20, $1A,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A,
    $29, $1A, $32, $1A, $39, $1A, $39, $1A, $2D, $1A, $33, $1A, $38, $1A, $34,
    $1A, $31, $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $55,
    $1E, $4B, $1E, $3A, $1E, $20, $1E, $2B, $1A, $34, $1A, $34, $1A, $20, $1A,
    $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A, $37,
    $1A, $20, $1A, $32, $1A, $36, $1A, $30, $1A, $39, $1A, $30, $1A, $33, $1A,
    $20, $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F,
    $1F, $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F,
    $4E, $1F, $53, $1F, $2C, $1F, $20, $1F, $2B, $1A, $34, $1A, $34, $1A, $20,
    $1A, $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A,
    $37, $1A, $20, $1A, $32, $1A, $36, $1A, $32, $1A, $30, $1A, $34, $1A, $33,
    $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $47, $1E, $45, $1E, $52, $1E, $4D, $1E, $41, $1E, $4E,
    $1E, $59, $1E, $3A, $1E, $20, $1E, $37, $1A, $32, $1A, $31, $1A, $39, $1A,
    $20, $1A, $37, $1A, $32, $1A, $32, $1A, $34, $1A, $2D, $1A, $30, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F, $1F,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $37, $1A, $32, $1A, $31, $1A, $39, $1A,
    $20, $1A, $37, $1A, $32, $1A, $32, $1A, $34, $1A, $32, $1A, $34, $1A, $20,
    $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20,
    $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F,
    $20, $0F, $20, $0F, $20, $0F, $20, $0F, $20, $0F
  );

  end_screen_v10_sha: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $53, $4F, $48, $4F, $41, $4F, $52, $4F, $45, $4F, $57, $4F, $41, $4F, $52,
    $4F, $45, $4F, $20, $4F, $56, $4F, $45, $4F, $52, $4F, $53, $4F, $49, $4F,
    $4F, $4F, $4E, $4F, $20, $4F, $2D, $4F, $20, $4F, $44, $4F, $49, $4F, $53,
    $4F, $54, $4F, $52, $4F, $49, $4F, $42, $4F, $55, $4F, $54, $4F, $45, $4F,
    $20, $4F, $46, $4F, $52, $4F, $45, $4F, $45, $4F, $4C, $4F, $59, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $43, $47, $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47,
    $67, $47, $68, $47, $74, $47, $20, $47, $28, $47, $43, $47, $29, $47, $20,
    $47, $31, $47, $39, $47, $39, $47, $35, $47, $20, $47, $45, $47, $70, $47,
    $69, $47, $63, $47, $20, $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47,
    $47, $61, $47, $6D, $47, $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47,
    $6E, $47, $63, $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $44, $47,
    $65, $47, $76, $47, $65, $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64,
    $47, $20, $47, $62, $47, $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47,
    $72, $47, $61, $47, $6C, $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72,
    $47, $6D, $47, $20, $47, $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47,
    $74, $47, $61, $47, $69, $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4E, $20, $4E, $45, $4E, $20, $4E, $59, $4E, $20, $4E, $4F, $4E, $20,
    $4E, $4E, $4E, $20, $4E, $44, $4E, $20, $4E, $20, $4E, $20, $4E, $54, $4E,
    $20, $4E, $48, $4E, $20, $4E, $45, $4E, $20, $4E, $20, $4E, $20, $4E, $56,
    $4E, $20, $4E, $4F, $4E, $20, $4E, $49, $4E, $20, $4E, $44, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $61, $47, $6E, $47, $64, $47, $20, $47, $55, $47, $6E, $47,
    $69, $47, $6F, $47, $6E, $47, $20, $47, $4C, $47, $6F, $47, $67, $47, $69,
    $47, $63, $47, $20, $47, $53, $47, $6F, $47, $66, $47, $74, $47, $77, $47,
    $61, $47, $72, $47, $65, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63,
    $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $21, $4B, $21,
    $4B, $21, $4B, $20, $4B, $4F, $CB, $52, $CB, $44, $CB, $45, $CB, $52, $CB,
    $20, $CB, $4E, $CB, $4F, $CB, $57, $CB, $20, $CB, $21, $4B, $21, $4B, $21,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $52, $4F, $45, $4F, $47, $4F, $49, $4F, $53, $4F, $54, $4F, $45, $4F, $52,
    $4F, $20, $4F, $52, $4F, $41, $4F, $44, $4F, $49, $4F, $58, $4F, $20, $4F,
    $4E, $4F, $4F, $4F, $57, $4F, $20, $4F, $41, $4F, $4E, $4F, $44, $4F, $20,
    $4F, $59, $4F, $4F, $4F, $55, $4F, $20, $4F, $57, $4F, $49, $4F, $4C, $4F,
    $4C, $4F, $20, $4F, $52, $4F, $45, $4F, $43, $4F, $45, $4F, $49, $4F, $56,
    $4F, $45, $4F, $3A, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $FE, $4E, $20, $4E, $61, $4E, $20, $4E, $74, $4E, $6F, $4E, $74,
    $4E, $61, $4E, $6C, $4E, $20, $4E, $6F, $4E, $66, $4E, $20, $4E, $32, $4E,
    $37, $4E, $20, $4E, $61, $4E, $63, $4E, $74, $4E, $69, $4E, $6F, $4E, $6E,
    $4E, $20, $4E, $70, $4E, $61, $4E, $63, $4E, $6B, $4E, $65, $4E, $64, $4E,
    $20, $4E, $6C, $4E, $65, $4E, $76, $4E, $65, $4E, $6C, $4E, $73, $4E, $2C,
    $4E, $20, $4E, $77, $4E, $69, $4E, $74, $4E, $68, $4E, $20, $4E, $61, $4E,
    $6C, $4E, $6C, $4E, $20, $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $67,
    $4E, $72, $4E, $61, $4E, $70, $4E, $68, $4E, $69, $4E, $63, $4E, $73, $4E,
    $2C, $4E, $20, $4E, $6D, $4E, $75, $4E, $73, $4E, $69, $4E, $63, $4E, $2C,
    $4E, $20, $4E, $61, $4E, $6E, $4E, $64, $4E, $20, $4E, $73, $4E, $6F, $4E,
    $75, $4E, $6E, $4E, $64, $4E, $21, $4E, $20, $4E, $20, $4E, $FE, $4E, $20,
    $4E, $74, $4E, $68, $4E, $65, $4E, $20, $4E, $4D, $4E, $65, $4E, $67, $4E,
    $61, $4E, $2D, $4E, $43, $4E, $6F, $4E, $6F, $4E, $6C, $4E, $20, $4E, $52,
    $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E, $20, $4E, $6D, $4E, $61, $4E,
    $6E, $4E, $75, $4E, $61, $4E, $6C, $4E, $20, $4E, $66, $4E, $69, $4E, $6C,
    $4E, $6C, $4E, $65, $4E, $64, $4E, $20, $4E, $77, $4E, $69, $4E, $74, $4E,
    $68, $4E, $20, $4E, $61, $4E, $77, $4E, $65, $4E, $73, $4E, $6F, $4E, $6D,
    $4E, $65, $4E, $20, $4E, $52, $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E,
    $20, $4E, $69, $4E, $6E, $4E, $66, $4E, $6F, $4E, $21, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20, $4E, $34, $4E, $20, $4E,
    $64, $4E, $65, $4E, $61, $4E, $64, $4E, $6C, $4E, $79, $4E, $20, $4E, $6E,
    $4E, $65, $4E, $77, $4E, $20, $4E, $65, $4E, $6E, $4E, $65, $4E, $6D, $4E,
    $69, $4E, $65, $4E, $73, $4E, $2C, $4E, $20, $4E, $61, $4E, $6E, $4E, $64,
    $4E, $20, $4E, $32, $4E, $20, $4E, $6D, $4E, $6F, $4E, $72, $4E, $65, $4E,
    $20, $4E, $63, $4E, $68, $4E, $61, $4E, $6C, $4E, $6C, $4E, $65, $4E, $6E,
    $4E, $67, $4E, $69, $4E, $6E, $4E, $67, $4E, $20, $4E, $65, $4E, $6E, $4E,
    $64, $4E, $20, $4E, $62, $4E, $6F, $4E, $73, $4E, $73, $4E, $65, $4E, $73,
    $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $FE, $4E, $20, $4E, $33, $4E, $20, $4E, $61, $4E, $64, $4E, $64,
    $4E, $69, $4E, $74, $4E, $69, $4E, $6F, $4E, $6E, $4E, $61, $4E, $6C, $4E,
    $20, $4E, $52, $4E, $41, $4E, $44, $4E, $49, $4E, $58, $4E, $20, $4E, $77,
    $4E, $65, $4E, $61, $4E, $70, $4E, $6F, $4E, $6E, $4E, $73, $4E, $20, $4E,
    $2D, $4E, $20, $4E, $4E, $4E, $75, $4E, $6B, $4E, $65, $4E, $73, $4E, $2C,
    $4E, $20, $4E, $50, $4E, $68, $4E, $61, $4E, $73, $4E, $65, $4E, $20, $4E,
    $54, $4E, $6F, $4E, $72, $4E, $70, $4E, $65, $4E, $64, $4E, $6F, $4E, $65,
    $4E, $73, $4E, $2C, $4E, $20, $4E, $61, $4E, $6E, $4E, $64, $4E, $20, $4E,
    $54, $4E, $68, $4E, $65, $4E, $20, $4E, $47, $4E, $72, $4E, $61, $4E, $76,
    $4E, $69, $4E, $74, $4E, $79, $4E, $20, $4E, $57, $4E, $61, $4E, $76, $4E,
    $65, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20,
    $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $70, $4E, $6F, $4E, $77, $4E,
    $65, $4E, $72, $4E, $2D, $4E, $75, $4E, $70, $4E, $73, $4E, $2C, $4E, $20,
    $4E, $6C, $4E, $69, $4E, $6B, $4E, $65, $4E, $20, $4E, $74, $4E, $68, $4E,
    $65, $4E, $20, $4E, $41, $4E, $75, $4E, $74, $4E, $6F, $4E, $6D, $4E, $61,
    $4E, $74, $4E, $65, $4E, $64, $4E, $20, $4E, $4C, $4E, $61, $4E, $73, $4E,
    $65, $4E, $72, $4E, $20, $4E, $44, $4E, $65, $4E, $66, $4E, $65, $4E, $6E,
    $4E, $63, $4E, $65, $4E, $20, $4E, $53, $4E, $79, $4E, $73, $4E, $74, $4E,
    $65, $4E, $6D, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $FE, $4E, $20, $4E, $77, $4E, $69, $4E,
    $6C, $4E, $64, $4E, $20, $4E, $6E, $4E, $65, $4E, $77, $4E, $20, $4E, $65,
    $4E, $6E, $4E, $76, $4E, $69, $4E, $72, $4E, $6F, $4E, $6E, $4E, $6D, $4E,
    $65, $4E, $6E, $4E, $74, $4E, $61, $4E, $6C, $4E, $20, $4E, $68, $4E, $61,
    $4E, $7A, $4E, $61, $4E, $72, $4E, $64, $4E, $73, $4E, $2C, $4E, $20, $4E,
    $73, $4E, $75, $4E, $63, $4E, $68, $4E, $20, $4E, $61, $4E, $73, $4E, $20,
    $4E, $74, $4E, $65, $4E, $6C, $4E, $65, $4E, $70, $4E, $6F, $4E, $72, $4E,
    $74, $4E, $73, $4E, $21, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $10, $4F,
    $1C, $72, $1C, $64, $1C, $65, $1C, $72, $1C, $20, $1C, $52, $1C, $41, $1C,
    $44, $1C, $49, $1C, $58, $1C, $20, $1C, $6E, $1C, $6F, $1C, $77, $1C, $20,
    $1C, $66, $1C, $6F, $1C, $72, $1C, $20, $1C, $6F, $1C, $6E, $1C, $6C, $1C,
    $79, $1C, $20, $1C, $24, $1C, $33, $1C, $35, $1C, $2E, $1C, $30, $1C, $30,
    $1C, $20, $1C, $55, $1C, $53, $1C, $2E, $1C, $20, $1C, $20, $1C, $DC, $40,
    $20, $40, $20, $10, $4D, $1F, $41, $1F, $49, $1F, $4C, $1F, $20, $1F, $4F,
    $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $3A, $1F, $20, $1F,
    $45, $1E, $70, $1E, $69, $1E, $63, $1E, $20, $1E, $4D, $1E, $65, $1E, $67,
    $1E, $61, $1E, $47, $1E, $61, $1E, $6D, $1E, $65, $1E, $73, $1E, $2C, $1E,
    $20, $1E, $49, $1E, $6E, $1E, $63, $1E, $2E, $1E, $20, $1E, $20, $1E, $20,
    $1E, $DC, $40, $20, $40, $20, $40, $20, $10, $41, $1B, $64, $1B, $64, $1B,
    $20, $1B, $24, $1B, $34, $1B, $20, $1B, $55, $1B, $53, $1B, $20, $1B, $53,
    $1B, $26, $1B, $48, $1B, $20, $1B, $28, $1B, $24, $1B, $36, $1B, $20, $1B,
    $69, $1B, $6E, $1B, $74, $1B, $65, $1B, $72, $1B, $6E, $1B, $61, $1B, $74,
    $1B, $69, $1B, $6F, $1B, $6E, $1B, $61, $1B, $6C, $1B, $29, $1B, $2E, $1B,
    $20, $1B, $20, $1B, $20, $1B, $20, $1B, $DB, $40, $20, $40, $20, $10, $20,
    $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10,
    $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $31, $1B, $30, $1B, $34,
    $1B, $30, $1B, $36, $1B, $20, $1B, $48, $1B, $6F, $1B, $6C, $1B, $62, $1B,
    $72, $1B, $6F, $1B, $6F, $1B, $6B, $1B, $20, $1B, $44, $1B, $72, $1B, $69,
    $1B, $76, $1B, $65, $1B, $20, $1B, $20, $1B, $20, $1B, $DB, $40, $20, $40,
    $20, $40, $20, $10, $4D, $1B, $44, $1B, $20, $1B, $72, $1B, $65, $1B, $73,
    $1B, $69, $1B, $64, $1B, $65, $1B, $6E, $1B, $74, $1B, $73, $1B, $20, $1B,
    $61, $1B, $64, $1B, $64, $1B, $20, $1B, $35, $1B, $25, $1B, $20, $1B, $73,
    $1B, $61, $1B, $6C, $1B, $65, $1B, $73, $1B, $20, $1B, $74, $1B, $61, $1B,
    $78, $1B, $2E, $1B, $20, $1B, $20, $1B, $20, $1B, $20, $1B, $20, $1B, $20,
    $1B, $20, $1B, $DB, $40, $20, $40, $20, $10, $20, $10, $20, $10, $20, $10,
    $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20, $10, $20,
    $10, $20, $10, $20, $10, $50, $1B, $6F, $1B, $74, $1B, $6F, $1B, $6D, $1B,
    $61, $1B, $63, $1B, $2C, $1B, $20, $1B, $4D, $1B, $44, $1B, $2C, $1B, $20,
    $1B, $32, $1B, $30, $1B, $38, $1B, $35, $1B, $34, $1B, $20, $1B, $55, $1B,
    $53, $1B, $41, $1B, $20, $1B, $DB, $40, $20, $40, $20, $40, $20, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $20, $40, $20, $10, $20, $10, $55, $1E, $53, $1E, $41, $1E,
    $2F, $1E, $43, $1E, $41, $1E, $4E, $1E, $41, $1E, $44, $1E, $41, $1E, $3A,
    $1E, $20, $1E, $28, $1A, $38, $1A, $30, $1A, $30, $1A, $29, $1A, $39, $1A,
    $37, $1A, $32, $1A, $2D, $1A, $37, $1A, $34, $1A, $33, $1A, $34, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2C, $1F,
    $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A, $29, $1A, $39, $1A, $38,
    $1A, $33, $1A, $2D, $1A, $39, $1A, $37, $1A, $37, $1A, $31, $1A, $20, $1A,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A,
    $29, $1A, $32, $1A, $39, $1A, $39, $1A, $2D, $1A, $33, $1A, $38, $1A, $34,
    $1A, $31, $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $55,
    $1E, $4B, $1E, $3A, $1E, $20, $1E, $2B, $1A, $34, $1A, $34, $1A, $20, $1A,
    $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A, $37,
    $1A, $20, $1A, $32, $1A, $36, $1A, $30, $1A, $39, $1A, $30, $1A, $33, $1A,
    $20, $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F,
    $1F, $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F,
    $4E, $1F, $53, $1F, $2C, $1F, $20, $1F, $2B, $1A, $34, $1A, $34, $1A, $20,
    $1A, $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A,
    $37, $1A, $20, $1A, $32, $1A, $36, $1A, $32, $1A, $30, $1A, $34, $1A, $33,
    $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $47, $1E, $45, $1E, $52, $1E, $4D, $1E, $41, $1E, $4E,
    $1E, $59, $1E, $3A, $1E, $20, $1E, $30, $1A, $31, $1A, $33, $1A, $30, $1A,
    $20, $1A, $38, $1A, $32, $1A, $32, $1A, $34, $1A, $39, $1A, $35, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F, $1F,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $30, $1A, $31, $1A, $33, $1A, $30, $1A,
    $20, $1A, $38, $1A, $32, $1A, $32, $1A, $38, $1A, $38, $1A, $36, $1A, $20,
    $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20,
    $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08, $20, $08,
    $20, $08, $20, $08, $20, $08, $20, $08, $20, $08
  );

  end_screen_v11_reg: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $52, $4F, $45, $4F, $47, $4F, $49, $4F, $53, $4F, $54, $4F,
    $45, $4F, $52, $4F, $45, $4F, $44, $4F, $20, $4F, $56, $4F, $45, $4F, $52,
    $4F, $53, $4F, $49, $4F, $4F, $4F, $4E, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $21, $CF, $21, $CF, $20, $CF,
    $44, $CF, $4F, $CF, $20, $CF, $4E, $CF, $4F, $CF, $54, $CF, $20, $CF, $44,
    $CF, $49, $CF, $53, $CF, $54, $CF, $52, $CF, $49, $CF, $42, $CF, $55, $CF,
    $54, $CF, $45, $CF, $20, $CF, $21, $CF, $21, $CF, $20, $CF, $20, $CF, $20,
    $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF,
    $20, $CF, $20, $CF, $20, $CF, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $43, $47, $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47,
    $67, $47, $68, $47, $74, $47, $20, $47, $28, $47, $43, $47, $29, $47, $20,
    $47, $31, $47, $39, $47, $39, $47, $35, $47, $20, $47, $45, $47, $70, $47,
    $69, $47, $63, $47, $20, $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47,
    $47, $61, $47, $6D, $47, $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47,
    $6E, $47, $63, $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $44, $47,
    $65, $47, $76, $47, $65, $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64,
    $47, $20, $47, $62, $47, $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47,
    $72, $47, $61, $47, $6C, $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72,
    $47, $6D, $47, $20, $47, $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47,
    $74, $47, $61, $47, $69, $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4E, $20, $4E, $45, $4E, $20, $4E, $59, $4E, $20, $4E, $4F, $4E, $20,
    $4E, $4E, $4E, $20, $4E, $44, $4E, $20, $4E, $20, $4E, $20, $4E, $54, $4E,
    $20, $4E, $48, $4E, $20, $4E, $45, $4E, $20, $4E, $20, $4E, $20, $4E, $56,
    $4E, $20, $4E, $4F, $4E, $20, $4E, $49, $4E, $20, $4E, $44, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $61, $47, $6E, $47, $64, $47, $20, $47, $55, $47, $6E, $47,
    $69, $47, $6F, $47, $6E, $47, $20, $47, $4C, $47, $6F, $47, $67, $47, $69,
    $47, $63, $47, $20, $47, $53, $47, $6F, $47, $66, $47, $74, $47, $77, $47,
    $61, $47, $72, $47, $65, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63,
    $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $54,
    $4B, $68, $4B, $69, $4B, $73, $4B, $20, $4B, $69, $4B, $73, $4B, $20, $4B,
    $61, $4B, $20, $4B, $72, $4B, $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74,
    $4B, $65, $4B, $72, $4B, $65, $4B, $64, $4B, $20, $4B, $76, $4B, $65, $4B,
    $72, $4B, $73, $4B, $69, $4B, $6F, $4B, $6E, $4B, $20, $4B, $6F, $4B, $66,
    $4B, $20, $4B, $52, $4B, $61, $4B, $64, $4B, $69, $4B, $78, $4B, $2E, $4B,
    $20, $4B, $20, $4B, $49, $4B, $66, $4B, $20, $4B, $79, $4B, $6F, $4B, $75,
    $4B, $20, $4B, $64, $4B, $6F, $4B, $20, $4B, $6E, $4B, $6F, $4B, $74, $4B,
    $20, $4B, $68, $4B, $61, $4B, $76, $4B, $65, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $72, $4B, $20, $4B, $6F, $4B, $77, $4B, $6E, $4B, $20, $4B,
    $70, $4B, $65, $4B, $72, $4B, $73, $4B, $6F, $4B, $6E, $4B, $61, $4B, $6C,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $72, $4B,
    $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74, $4B, $65, $4B, $72, $4B, $65,
    $4B, $64, $4B, $20, $4B, $63, $4B, $6F, $4B, $70, $4B, $79, $4B, $20, $4B,
    $6F, $4B, $66, $4B, $20, $4B, $74, $4B, $68, $4B, $69, $4B, $73, $4B, $20,
    $4B, $67, $4B, $61, $4B, $6D, $4B, $65, $4B, $2C, $4B, $20, $4B, $6F, $4B,
    $72, $4B, $64, $4B, $65, $4B, $72, $4B, $20, $4B, $69, $4B, $74, $4B, $20,
    $4B, $6E, $4B, $6F, $4B, $77, $4B, $20, $4B, $62, $4B, $79, $4B, $20, $4B,
    $63, $4B, $61, $4B, $6C, $4B, $6C, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $31, $41, $2D, $41, $38, $41, $30, $41, $30, $41, $2D, $41, $39, $41,
    $37, $41, $32, $41, $2D, $41, $37, $41, $34, $41, $33, $41, $34, $41, $20,
    $41, $61, $4B, $6E, $4B, $64, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $70, $4B, $72, $4B, $65, $4B, $76, $4B, $65, $4B,
    $6E, $4B, $74, $4B, $20, $4B, $79, $4B, $6F, $4B, $75, $4B, $72, $4B, $73,
    $4B, $65, $4B, $6C, $4B, $66, $4B, $20, $4B, $66, $4B, $72, $4B, $6F, $4B,
    $6D, $4B, $20, $4B, $62, $4B, $65, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $73, $4B, $75, $4B, $63, $4B, $6B, $4B, $65, $4B, $64, $4B, $20, $4B,
    $69, $4B, $6E, $4B, $74, $4B, $6F, $4B, $20, $4B, $74, $4B, $68, $4B, $65,
    $4B, $20, $4B, $76, $4B, $6F, $4B, $69, $4B, $64, $4B, $21, $4B, $20, $4B,
    $54, $4B, $68, $4B, $61, $4B, $6E, $4B, $6B, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $2E, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $43, $4E, $52, $4E, $45, $4E, $44, $4E, $49, $4E, $54, $4E, $53,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $50, $47, $72, $47, $6F, $47,
    $67, $47, $72, $47, $61, $47, $6D, $47, $6D, $47, $69, $47, $6E, $47, $67,
    $47, $3A, $47, $20, $47, $44, $4F, $61, $4F, $6E, $4F, $20, $4F, $44, $4F,
    $75, $4F, $66, $4F, $65, $4F, $75, $4F, $2C, $4F, $20, $4F, $53, $4F, $68,
    $4F, $61, $4F, $68, $4F, $7A, $4F, $61, $4F, $64, $4F, $20, $4F, $4D, $4F,
    $61, $4F, $6C, $4F, $69, $4F, $6B, $4F, $2C, $4F, $20, $4F, $4A, $4F, $6F,
    $4F, $6E, $4F, $61, $4F, $74, $4F, $68, $4F, $61, $4F, $6E, $4F, $20, $4F,
    $4D, $4F, $61, $4F, $76, $4F, $6F, $4F, $72, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $41, $47, $72, $47, $74, $47, $3A, $47, $20,
    $47, $43, $4F, $79, $4F, $67, $4F, $6E, $4F, $75, $4F, $73, $4F, $20, $4F,
    $4D, $4F, $75, $4F, $6C, $4F, $74, $4F, $69, $4F, $6D, $4F, $65, $4F, $64,
    $4F, $69, $4F, $61, $4F, $2C, $4F, $20, $4F, $47, $4F, $72, $4F, $65, $4F,
    $67, $4F, $20, $4F, $4D, $4F, $61, $4F, $63, $4F, $4D, $4F, $61, $4F, $72,
    $4F, $74, $4F, $69, $4F, $6E, $4F, $2C, $4F, $20, $4F, $4A, $4F, $61, $4F,
    $73, $4F, $6F, $4F, $6E, $4F, $20, $4F, $53, $4F, $74, $4F, $72, $4F, $81,
    $4F, $63, $4F, $6B, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $41, $47, $64, $47, $64, $47, $69, $47, $74, $47, $69,
    $47, $6F, $47, $6E, $47, $61, $47, $6C, $47, $20, $47, $50, $47, $72, $47,
    $6F, $47, $67, $47, $72, $47, $61, $47, $6D, $47, $6D, $47, $69, $47, $6E,
    $47, $67, $47, $3A, $47, $20, $47, $4D, $4F, $61, $4F, $72, $4F, $6B, $4F,
    $20, $4F, $4C, $4F, $65, $4F, $77, $4F, $69, $4F, $73, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $4D, $47,
    $75, $47, $73, $47, $69, $47, $63, $47, $3A, $47, $20, $47, $4D, $4F, $61,
    $4F, $72, $4F, $63, $4F, $20, $4F, $47, $4F, $72, $4F, $61, $4F, $76, $4F,
    $65, $4F, $6C, $4F, $6C, $4F, $65, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $53, $47,
    $6F, $47, $75, $47, $6E, $47, $64, $47, $20, $47, $46, $47, $58, $47, $3A,
    $47, $20, $47, $4D, $4F, $61, $4F, $72, $4F, $6B, $4F, $20, $4F, $54, $4F,
    $6F, $4F, $74, $4F, $74, $4F, $69, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $1F, $20, $1F, $20, $1F, $45, $1E, $70, $1E, $69, $1E, $63,
    $1E, $20, $1E, $4D, $1E, $65, $1E, $67, $1E, $61, $1E, $47, $1E, $61, $1E,
    $6D, $1E, $65, $1E, $73, $1E, $2C, $1E, $20, $1E, $49, $1E, $6E, $1E, $63,
    $1E, $2E, $1E, $20, $1E, $20, $1E, $20, $1E, $DC, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $10, $20,
    $10, $20, $10, $31, $1B, $30, $1B, $34, $1B, $30, $1B, $36, $1B, $20, $1B,
    $48, $1B, $6F, $1B, $6C, $1B, $62, $1B, $72, $1B, $6F, $1B, $6F, $1B, $6B,
    $1B, $20, $1B, $44, $1B, $72, $1B, $69, $1B, $76, $1B, $65, $1B, $20, $1B,
    $20, $1B, $20, $1B, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $10, $20, $10, $50, $1B, $6F, $1B,
    $74, $1B, $6F, $1B, $6D, $1B, $61, $1B, $63, $1B, $2C, $1B, $20, $1B, $4D,
    $1B, $44, $1B, $2C, $1B, $20, $1B, $32, $1B, $30, $1B, $38, $1B, $35, $1B,
    $34, $1B, $20, $1B, $55, $1B, $53, $1B, $41, $1B, $20, $1B, $20, $1B, $DB,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $10, $20, $10, $55, $1E, $53, $1E, $41, $1E,
    $2F, $1E, $43, $1E, $41, $1E, $4E, $1E, $41, $1E, $44, $1E, $41, $1E, $3A,
    $1E, $20, $1E, $28, $1A, $38, $1A, $30, $1A, $30, $1A, $29, $1A, $39, $1A,
    $37, $1A, $32, $1A, $2D, $1A, $37, $1A, $34, $1A, $33, $1A, $34, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2C, $1F,
    $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A, $29, $1A, $39, $1A, $38,
    $1A, $33, $1A, $2D, $1A, $39, $1A, $37, $1A, $37, $1A, $31, $1A, $20, $1A,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A,
    $29, $1A, $32, $1A, $39, $1A, $39, $1A, $2D, $1A, $33, $1A, $38, $1A, $34,
    $1A, $31, $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $55,
    $1E, $4B, $1E, $3A, $1E, $20, $1E, $2B, $1A, $34, $1A, $34, $1A, $20, $1A,
    $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A, $37,
    $1A, $20, $1A, $32, $1A, $36, $1A, $30, $1A, $39, $1A, $30, $1A, $33, $1A,
    $20, $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F,
    $1F, $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F,
    $4E, $1F, $53, $1F, $2C, $1F, $20, $1F, $2B, $1A, $34, $1A, $34, $1A, $20,
    $1A, $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A,
    $37, $1A, $20, $1A, $32, $1A, $36, $1A, $32, $1A, $30, $1A, $34, $1A, $33,
    $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $47, $1E, $45, $1E, $52, $1E, $4D, $1E, $41, $1E, $4E,
    $1E, $59, $1E, $3A, $1E, $20, $1E, $37, $1A, $32, $1A, $31, $1A, $39, $1A,
    $20, $1A, $37, $1A, $32, $1A, $32, $1A, $34, $1A, $2D, $1A, $30, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F, $1F,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $37, $1A, $32, $1A, $31, $1A, $39, $1A,
    $20, $1A, $37, $1A, $32, $1A, $32, $1A, $34, $1A, $32, $1A, $34, $1A, $20,
    $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20,
    $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A,
    $20, $0A, $20, $0A, $20, $0A, $20, $0A, $20, $0A
  );

  end_screen_v10_reg: packed array[0..3999] of Byte = (
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40,
    $DC, $40, $20, $40, $20, $40, $DB, $40, $DB, $40, $DB, $40, $20, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $DB, $40,
    $DB, $40, $DB, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20,
    $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $52, $4F, $45, $4F, $47, $4F, $49, $4F, $53, $4F, $54, $4F,
    $45, $4F, $52, $4F, $45, $4F, $44, $4F, $20, $4F, $56, $4F, $45, $4F, $52,
    $4F, $53, $4F, $49, $4F, $4F, $4F, $4E, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $DE, $40,
    $DB, $40, $20, $40, $20, $40, $DC, $40, $DB, $40, $DF, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40,
    $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $DF, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $21, $CF, $21, $CF, $20, $CF,
    $44, $CF, $4F, $CF, $20, $CF, $4E, $CF, $4F, $CF, $54, $CF, $20, $CF, $44,
    $CF, $49, $CF, $53, $CF, $54, $CF, $52, $CF, $49, $CF, $42, $CF, $55, $CF,
    $54, $CF, $45, $CF, $20, $CF, $21, $CF, $21, $CF, $20, $CF, $20, $CF, $20,
    $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF, $20, $CF,
    $20, $CF, $20, $CF, $20, $CF, $DE, $40, $DB, $40, $DF, $40, $DF, $40, $DB,
    $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $DF, $40, $DF, $40, $DF, $40,
    $DB, $40, $DD, $40, $20, $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DB,
    $40, $20, $40, $20, $40, $DE, $40, $DD, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $DC, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $43, $47, $6F, $47, $70, $47, $79, $47, $72, $47, $69, $47,
    $67, $47, $68, $47, $74, $47, $20, $47, $28, $47, $43, $47, $29, $47, $20,
    $47, $31, $47, $39, $47, $39, $47, $35, $47, $20, $47, $45, $47, $70, $47,
    $69, $47, $63, $47, $20, $47, $4D, $47, $65, $47, $67, $47, $61, $47, $47,
    $47, $61, $47, $6D, $47, $65, $47, $73, $47, $2C, $47, $20, $47, $49, $47,
    $6E, $47, $63, $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $DE,
    $40, $DB, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20, $40,
    $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $DE, $40, $DB, $40, $20,
    $40, $DB, $40, $DB, $40, $DB, $40, $DB, $40, $DF, $40, $20, $40, $DE, $40,
    $DB, $40, $DB, $40, $DD, $40, $20, $40, $20, $40, $DB, $40, $20, $40, $20,
    $40, $20, $40, $DF, $40, $DB, $40, $DC, $40, $20, $40, $20, $40, $44, $47,
    $65, $47, $76, $47, $65, $47, $6C, $47, $6F, $47, $70, $47, $65, $47, $64,
    $47, $20, $47, $62, $47, $79, $47, $20, $47, $4E, $47, $65, $47, $75, $47,
    $72, $47, $61, $47, $6C, $47, $20, $47, $53, $47, $74, $47, $6F, $47, $72,
    $47, $6D, $47, $20, $47, $45, $47, $6E, $47, $74, $47, $65, $47, $72, $47,
    $74, $47, $61, $47, $69, $47, $6E, $47, $6D, $47, $65, $47, $6E, $47, $74,
    $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $42, $4E, $20, $47, $45, $4E, $20, $4E, $59, $4E, $20, $4E, $4F, $4E, $20,
    $4E, $4E, $4E, $20, $4E, $44, $4E, $20, $4E, $20, $4E, $20, $4E, $54, $4E,
    $20, $4E, $48, $4E, $20, $4E, $45, $4E, $20, $4E, $20, $4E, $20, $4E, $56,
    $4E, $20, $4E, $4F, $4E, $20, $4E, $49, $4E, $20, $4E, $44, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $61, $47, $6E, $47, $64, $47, $20, $47, $55, $47, $6E, $47,
    $69, $47, $6F, $47, $6E, $47, $20, $47, $4C, $47, $6F, $47, $67, $47, $69,
    $47, $63, $47, $20, $47, $53, $47, $6F, $47, $66, $47, $74, $47, $77, $47,
    $61, $47, $72, $47, $65, $47, $2C, $47, $20, $47, $49, $47, $6E, $47, $63,
    $47, $2E, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47, $20, $47,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4,
    $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40,
    $C4, $40, $C4, $40, $C4, $40, $C4, $40, $C4, $40, $20, $40, $20, $40, $54,
    $4B, $68, $4B, $69, $4B, $73, $4B, $20, $4B, $69, $4B, $73, $4B, $20, $4B,
    $61, $4B, $20, $4B, $72, $4B, $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74,
    $4B, $65, $4B, $72, $4B, $65, $4B, $64, $4B, $20, $4B, $76, $4B, $65, $4B,
    $72, $4B, $73, $4B, $69, $4B, $6F, $4B, $6E, $4B, $20, $4B, $6F, $4B, $66,
    $4B, $20, $4B, $52, $4B, $61, $4B, $64, $4B, $69, $4B, $78, $4B, $2E, $4B,
    $20, $4B, $20, $4B, $49, $4B, $66, $4B, $20, $4B, $79, $4B, $6F, $4B, $75,
    $4B, $20, $4B, $64, $4B, $6F, $4B, $20, $4B, $6E, $4B, $6F, $4B, $74, $4B,
    $20, $4B, $68, $4B, $61, $4B, $76, $4B, $65, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $72, $4B, $20, $4B, $6F, $4B, $77, $4B, $6E, $4B, $20, $4B,
    $70, $4B, $65, $4B, $72, $4B, $73, $4B, $6F, $4B, $6E, $4B, $61, $4B, $6C,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $72, $4B,
    $65, $4B, $67, $4B, $69, $4B, $73, $4B, $74, $4B, $65, $4B, $72, $4B, $65,
    $4B, $64, $4B, $20, $4B, $63, $4B, $6F, $4B, $70, $4B, $79, $4B, $20, $4B,
    $6F, $4B, $66, $4B, $20, $4B, $74, $4B, $68, $4B, $69, $4B, $73, $4B, $20,
    $4B, $67, $4B, $61, $4B, $6D, $4B, $65, $4B, $2C, $4B, $20, $4B, $6F, $4B,
    $72, $4B, $64, $4B, $65, $4B, $72, $4B, $20, $4B, $69, $4B, $74, $4B, $20,
    $4B, $6E, $4B, $6F, $4B, $77, $4B, $20, $4B, $62, $4B, $79, $4B, $20, $4B,
    $63, $4B, $61, $4B, $6C, $4B, $6C, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $31, $41, $2D, $41, $38, $41, $30, $41, $30, $41, $2D, $41, $39, $41,
    $37, $41, $32, $41, $2D, $41, $37, $41, $34, $41, $33, $41, $34, $41, $20,
    $41, $61, $4B, $6E, $4B, $64, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $70, $4B, $72, $4B, $65, $4B, $76, $4B, $65, $4B,
    $6E, $4B, $74, $4B, $20, $4B, $79, $4B, $6F, $4B, $75, $4B, $72, $4B, $73,
    $4B, $65, $4B, $6C, $4B, $66, $4B, $20, $4B, $66, $4B, $72, $4B, $6F, $4B,
    $6D, $4B, $20, $4B, $62, $4B, $65, $4B, $69, $4B, $6E, $4B, $67, $4B, $20,
    $4B, $73, $4B, $75, $4B, $63, $4B, $6B, $4B, $65, $4B, $64, $4B, $20, $4B,
    $69, $4B, $6E, $4B, $74, $4B, $6F, $4B, $20, $4B, $74, $4B, $68, $4B, $65,
    $4B, $20, $4B, $76, $4B, $6F, $4B, $69, $4B, $64, $4B, $21, $4B, $20, $4B,
    $54, $4B, $68, $4B, $61, $4B, $6E, $4B, $6B, $4B, $20, $4B, $79, $4B, $6F,
    $4B, $75, $4B, $2E, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20,
    $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B, $20, $4B,
    $20, $4B, $43, $4E, $52, $4E, $45, $4E, $44, $4E, $49, $4E, $54, $4E, $53,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E,
    $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $20,
    $4E, $20, $4E, $20, $4E, $20, $4E, $20, $4E, $50, $47, $72, $47, $6F, $47,
    $67, $47, $72, $47, $61, $47, $6D, $47, $6D, $47, $69, $47, $6E, $47, $67,
    $47, $3A, $47, $20, $47, $44, $4F, $61, $4F, $6E, $4F, $20, $4F, $44, $4F,
    $75, $4F, $66, $4F, $65, $4F, $75, $4F, $2C, $4F, $20, $4F, $53, $4F, $68,
    $4F, $61, $4F, $68, $4F, $7A, $4F, $61, $4F, $64, $4F, $20, $4F, $4D, $4F,
    $61, $4F, $6C, $4F, $69, $4F, $6B, $4F, $2C, $4F, $20, $4F, $4A, $4F, $6F,
    $4F, $6E, $4F, $61, $4F, $74, $4F, $68, $4F, $61, $4F, $6E, $4F, $20, $4F,
    $4D, $4F, $61, $4F, $76, $4F, $6F, $4F, $72, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $41, $47, $72, $47, $74, $47, $3A, $47, $20,
    $47, $43, $4F, $79, $4F, $67, $4F, $6E, $4F, $75, $4F, $73, $4F, $20, $4F,
    $4D, $4F, $75, $4F, $6C, $4F, $74, $4F, $69, $4F, $6D, $4F, $65, $4F, $64,
    $4F, $69, $4F, $61, $4F, $2C, $4F, $20, $4F, $47, $4F, $72, $4F, $65, $4F,
    $67, $4F, $20, $4F, $4D, $4F, $61, $4F, $63, $4F, $4D, $4F, $61, $4F, $72,
    $4F, $74, $4F, $69, $4F, $6E, $4F, $2C, $4F, $20, $4F, $4A, $4F, $61, $4F,
    $73, $4F, $6F, $4F, $6E, $4F, $20, $4F, $53, $4F, $74, $4F, $72, $4F, $81,
    $4F, $63, $4F, $6B, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $41, $47, $64, $47, $64, $47, $69, $47, $74, $47, $69,
    $47, $6F, $47, $6E, $47, $61, $47, $6C, $47, $20, $47, $50, $47, $72, $47,
    $6F, $47, $67, $47, $72, $47, $61, $47, $6D, $47, $6D, $47, $69, $47, $6E,
    $47, $67, $47, $3A, $47, $20, $47, $4D, $4F, $61, $4F, $72, $4F, $6B, $4F,
    $20, $4F, $4C, $4F, $65, $4F, $77, $4F, $69, $4F, $73, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $4D, $47,
    $75, $47, $73, $47, $69, $47, $63, $47, $3A, $47, $20, $47, $4D, $4F, $61,
    $4F, $72, $4F, $63, $4F, $20, $4F, $47, $4F, $72, $4F, $61, $4F, $76, $4F,
    $65, $4F, $6C, $4F, $6C, $4F, $65, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $53, $47,
    $6F, $47, $75, $47, $6E, $47, $64, $47, $20, $47, $46, $47, $58, $47, $3A,
    $47, $20, $47, $4D, $4F, $61, $4F, $72, $4F, $6B, $4F, $20, $4F, $54, $4F,
    $6F, $4F, $74, $4F, $74, $4F, $69, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20,
    $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F, $20, $4F,
    $20, $4F, $20, $1F, $20, $1F, $20, $1F, $45, $1E, $70, $1E, $69, $1E, $63,
    $1E, $20, $1E, $4D, $1E, $65, $1E, $67, $1E, $61, $1E, $47, $1E, $61, $1E,
    $6D, $1E, $65, $1E, $73, $1E, $2C, $1E, $20, $1E, $49, $1E, $6E, $1E, $63,
    $1E, $2E, $1E, $20, $1E, $20, $1E, $20, $1E, $DC, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $10, $20,
    $10, $20, $10, $31, $1B, $30, $1B, $34, $1B, $30, $1B, $36, $1B, $20, $1B,
    $48, $1B, $6F, $1B, $6C, $1B, $62, $1B, $72, $1B, $6F, $1B, $6F, $1B, $6B,
    $1B, $20, $1B, $44, $1B, $72, $1B, $69, $1B, $76, $1B, $65, $1B, $20, $1B,
    $20, $1B, $20, $1B, $DB, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $10, $20, $10, $50, $1B, $6F, $1B,
    $74, $1B, $6F, $1B, $6D, $1B, $61, $1B, $63, $1B, $2C, $1B, $20, $1B, $4D,
    $1B, $44, $1B, $2C, $1B, $20, $1B, $32, $1B, $30, $1B, $38, $1B, $35, $1B,
    $34, $1B, $20, $1B, $55, $1B, $53, $1B, $41, $1B, $20, $1B, $20, $1B, $DB,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40,
    $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF,
    $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $DF, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40,
    $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20, $40, $20,
    $40, $20, $40, $20, $40, $20, $10, $20, $10, $55, $1E, $53, $1E, $41, $1E,
    $2F, $1E, $43, $1E, $41, $1E, $4E, $1E, $41, $1E, $44, $1E, $41, $1E, $3A,
    $1E, $20, $1E, $28, $1A, $38, $1A, $30, $1A, $30, $1A, $29, $1A, $39, $1A,
    $37, $1A, $32, $1A, $2D, $1A, $37, $1A, $34, $1A, $33, $1A, $34, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2C, $1F,
    $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A, $29, $1A, $39, $1A, $38,
    $1A, $33, $1A, $2D, $1A, $39, $1A, $37, $1A, $37, $1A, $31, $1A, $20, $1A,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $28, $1A, $33, $1A, $30, $1A, $31, $1A,
    $29, $1A, $32, $1A, $39, $1A, $39, $1A, $2D, $1A, $33, $1A, $38, $1A, $34,
    $1A, $31, $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $55,
    $1E, $4B, $1E, $3A, $1E, $20, $1E, $2B, $1A, $34, $1A, $34, $1A, $20, $1A,
    $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A, $37,
    $1A, $20, $1A, $32, $1A, $36, $1A, $30, $1A, $39, $1A, $30, $1A, $33, $1A,
    $20, $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F,
    $1F, $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F,
    $4E, $1F, $53, $1F, $2C, $1F, $20, $1F, $2B, $1A, $34, $1A, $34, $1A, $20,
    $1A, $28, $1A, $30, $1A, $29, $1A, $20, $1A, $31, $1A, $37, $1A, $36, $1A,
    $37, $1A, $20, $1A, $32, $1A, $36, $1A, $32, $1A, $30, $1A, $34, $1A, $33,
    $1A, $20, $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $47, $1E, $45, $1E, $52, $1E, $4D, $1E, $41, $1E, $4E,
    $1E, $59, $1E, $3A, $1E, $20, $1E, $30, $1A, $31, $1A, $33, $1A, $30, $1A,
    $20, $1A, $38, $1A, $32, $1A, $32, $1A, $34, $1A, $39, $1A, $35, $1A, $20,
    $1A, $4F, $1F, $52, $1F, $44, $1F, $45, $1F, $52, $1F, $53, $1F, $2F, $1F,
    $51, $1F, $55, $1F, $45, $1F, $53, $1F, $54, $1F, $49, $1F, $4F, $1F, $4E,
    $1F, $53, $1F, $2C, $1F, $20, $1F, $30, $1A, $31, $1A, $33, $1A, $30, $1A,
    $20, $1A, $38, $1A, $32, $1A, $32, $1A, $38, $1A, $38, $1A, $36, $1A, $20,
    $1A, $46, $1F, $41, $1F, $58, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F,
    $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20, $1F, $20,
    $1F, $20, $1F, $20, $1F, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20,
    $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E,
    $20, $0E, $20, $0E, $20, $0E, $20, $0E, $20, $0E
  );

//==============================================================================
//
// RX_GetEndScreenData
//
//==============================================================================
function RX_GetEndScreenData: pointer;
begin
  case radixversion of
    rv10sha: result := @end_screen_v10_sha;
    rv10reg: result := @end_screen_v10_reg;
    rv11sha: result := @end_screen_v11_sha;
    rv11reg: result := @end_screen_v11_reg;
    rv20sha: result := @end_screen_v20_sha;
    rv20reg: result := @end_screen_v20_reg;
  else
    if gamemode = shareware then
      result := @end_screen_v10_sha
    else
      result := @end_screen_v10_reg;
  end;
end;

end.
