#pragma once
/** \file float.h
  * Characteristics of floating types
  *
  * This file is part of the C standard library for the jsix operating
  * system.
  *
  * This Source Code Form is subject to the terms of the Mozilla Public
  * License, v. 2.0. If a copy of the MPL was not distributed with this
  * file, You can obtain one at https://mozilla.org/MPL/2.0/.
  */

#define FLT_RADIX           __FLT_RADIX__

#define FLT_MANT_DIG        __FLT_MANT_DIG__
#define DBL_MANT_DIG        __DBL_MANT_DIG__
#define LDBL_MANT_DIG       __LDBL_MANT_DIG__

#define FLT_DECIMAL_DIG     __FLT_DECIMAL_DIG__
#define DBL_DECIMAL_DIG     __DBL_DECIMAL_DIG__
#define LDBL_DECIMAL_DIG    __LDBL_DECIMAL_DIG__
#define DECIMAL_DIG         __DECIMAL_DIG__

#define FLT_DIG             __FLT_DIG__
#define DBL_DIG             __DBL_DIG__
#define LDBL_DIG            __LDBL_DIG__

#define FLT_MIN_EXP         __FLT_MIN_EXP__
#define DBL_MIN_EXP         __DBL_MIN_EXP__
#define LDBL_MIN_EXP        __LDBL_MIN_EXP__

#define FLT_MAX_EXP         __FLT_MAX_EXP__
#define DBL_MAX_EXP         __DBL_MAX_EXP__
#define LDBL_MAX_EXP        __LDBL_MAX_EXP__

#define FLT_MIN_10_EXP      __FLT_MIN_10_EXP__
#define DBL_MIN_10_EXP      __DBL_MIN_10_EXP__
#define LDBL_MIN_10_EXP     __LDBL_MIN_10_EXP__

#define FLT_MAX_10_EXP      __FLT_MAX_10_EXP__
#define DBL_MAX_10_EXP      __DBL_MAX_10_EXP__
#define LDBL_MAX_10_EXP     __LDBL_MAX_10_EXP__

#define FLT_MIN             __FLT_MIN__
#define FLT_MAX             __FLT_MAX__
#define FLT_EPSILON         __FLT_EPSILON__
#define FLT_TRUE_MIN        FLT_MIN

#define DBL_MIN             __DBL_MIN__
#define DBL_MAX             __DBL_MAX__
#define DBL_EPSILON         __DBL_EPSILON__
#define DBL_TRUE_MIN        DBL_MIN

#define LDBL_MIN            __LDBL_MIN__
#define LDBL_MAX            __LDBL_MAX__
#define LDBL_EPSILON        __LDBL_EPSILON__
#define LDBL_TRUE_MIN       LDBL_MIN

