#pragma once
#ifndef _uefi_protos_simple_text_output_h_
#define _uefi_protos_simple_text_output_h_

// This file was auto generated by the j6-uefi-headers project. Please see
// https://github.com/justinian/j6-uefi-headers for more information.

#include <uefi/guid.h>
#include <uefi/types.h>
#include <uefi/graphics.h>

namespace uefi {
namespace protos {
struct simple_text_output;

struct simple_text_output
{
    static constexpr uefi::guid guid{ 0x387477c2,0x69c7,0x11d2,{0x8e,0x39,0x00,0xa0,0xc9,0x69,0x72,0x3b} };


    inline uefi::status reset(bool extended_verification) {
        return _reset(this, extended_verification);
    }

    inline uefi::status output_string(const wchar_t * string) {
        return _output_string(this, string);
    }

    inline uefi::status test_string(const wchar_t * string) {
        return _test_string(this, string);
    }

    inline uefi::status query_mode(uint64_t mode_number, uint64_t * columns, uint64_t * rows) {
        return _query_mode(this, mode_number, columns, rows);
    }

    inline uefi::status set_mode(uint64_t mode_number) {
        return _set_mode(this, mode_number);
    }

    inline uefi::status set_attribute(uefi::attribute attribute) {
        return _set_attribute(this, attribute);
    }

    inline uefi::status clear_screen() {
        return _clear_screen(this);
    }

    inline uefi::status set_cursor_position(uint64_t column, uint64_t row) {
        return _set_cursor_position(this, column, row);
    }

    inline uefi::status enable_cursor(bool visible) {
        return _enable_cursor(this, visible);
    }


protected:
    using _reset_def = uefi::status (*)(uefi::protos::simple_text_output *, bool);
    _reset_def _reset;

    using _output_string_def = uefi::status (*)(uefi::protos::simple_text_output *, const wchar_t *);
    _output_string_def _output_string;

    using _test_string_def = uefi::status (*)(uefi::protos::simple_text_output *, const wchar_t *);
    _test_string_def _test_string;

    using _query_mode_def = uefi::status (*)(uefi::protos::simple_text_output *, uint64_t, uint64_t *, uint64_t *);
    _query_mode_def _query_mode;

    using _set_mode_def = uefi::status (*)(uefi::protos::simple_text_output *, uint64_t);
    _set_mode_def _set_mode;

    using _set_attribute_def = uefi::status (*)(uefi::protos::simple_text_output *, uefi::attribute);
    _set_attribute_def _set_attribute;

    using _clear_screen_def = uefi::status (*)(uefi::protos::simple_text_output *);
    _clear_screen_def _clear_screen;

    using _set_cursor_position_def = uefi::status (*)(uefi::protos::simple_text_output *, uint64_t, uint64_t);
    _set_cursor_position_def _set_cursor_position;

    using _enable_cursor_def = uefi::status (*)(uefi::protos::simple_text_output *, bool);
    _enable_cursor_def _enable_cursor;

public:
    uefi::text_output_mode * mode;
};

} // namespace protos
} // namespace uefi

#endif // _uefi_protos_simple_text_output_h_