#pragma once
#ifndef _uefi_protos_ip6_h_
#define _uefi_protos_ip6_h_

// This file was auto generated by the j6-uefi-headers project. Please see
// https://github.com/justinian/j6-uefi-headers for more information.

#include <uefi/guid.h>
#include <uefi/types.h>
#include <uefi/networking.h>

namespace uefi {
namespace protos {
struct ip6;

struct ip6
{
    static constexpr uefi::guid guid{ 0x2c8759d5,0x5c2d,0x66ef,{0x92,0x5f,0xb6,0x6c,0x10,0x19,0x57,0xe2} };
    static constexpr uefi::guid service_binding{ 0xec835dd3,0xfe0f,0x617b,{0xa6,0x21,0xb3,0x50,0xc3,0xe1,0x33,0x88} };


    inline uefi::status get_mode_data(uefi::ip6_mode_data * ip6_mode_data, uefi::managed_network_config_data * mnp_config_data, uefi::simple_network_mode * snp_config_data) {
        return _get_mode_data(this, ip6_mode_data, mnp_config_data, snp_config_data);
    }

    inline uefi::status configure(uefi::ip6_config_data * ip6_config_data) {
        return _configure(this, ip6_config_data);
    }

    inline uefi::status groups(bool join_flag, uefi::ipv6_address * group_address) {
        return _groups(this, join_flag, group_address);
    }

    inline uefi::status routes(bool delete_route, uefi::ipv6_address * destination, uint8_t prefix_length, uefi::ipv6_address * gateway_address) {
        return _routes(this, delete_route, destination, prefix_length, gateway_address);
    }

    inline uefi::status neighbors(bool delete_flag, uefi::ipv6_address * target_ip6_address, uefi::mac_address * target_link_address, uint32_t timeout, bool override) {
        return _neighbors(this, delete_flag, target_ip6_address, target_link_address, timeout, override);
    }

    inline uefi::status transmit(uefi::ip6_completion_token * token) {
        return _transmit(this, token);
    }

    inline uefi::status receive(uefi::ip6_completion_token * token) {
        return _receive(this, token);
    }

    inline uefi::status cancel(uefi::ip6_completion_token * token) {
        return _cancel(this, token);
    }

    inline uefi::status poll() {
        return _poll(this);
    }


protected:
    using _get_mode_data_def = uefi::status (*)(uefi::protos::ip6 *, uefi::ip6_mode_data *, uefi::managed_network_config_data *, uefi::simple_network_mode *);
    _get_mode_data_def _get_mode_data;

    using _configure_def = uefi::status (*)(uefi::protos::ip6 *, uefi::ip6_config_data *);
    _configure_def _configure;

    using _groups_def = uefi::status (*)(uefi::protos::ip6 *, bool, uefi::ipv6_address *);
    _groups_def _groups;

    using _routes_def = uefi::status (*)(uefi::protos::ip6 *, bool, uefi::ipv6_address *, uint8_t, uefi::ipv6_address *);
    _routes_def _routes;

    using _neighbors_def = uefi::status (*)(uefi::protos::ip6 *, bool, uefi::ipv6_address *, uefi::mac_address *, uint32_t, bool);
    _neighbors_def _neighbors;

    using _transmit_def = uefi::status (*)(uefi::protos::ip6 *, uefi::ip6_completion_token *);
    _transmit_def _transmit;

    using _receive_def = uefi::status (*)(uefi::protos::ip6 *, uefi::ip6_completion_token *);
    _receive_def _receive;

    using _cancel_def = uefi::status (*)(uefi::protos::ip6 *, uefi::ip6_completion_token *);
    _cancel_def _cancel;

    using _poll_def = uefi::status (*)(uefi::protos::ip6 *);
    _poll_def _poll;

public:
};

} // namespace protos
} // namespace uefi

#endif // _uefi_protos_ip6_h_