#pragma once
#ifndef _uefi_protos_file_h_
#define _uefi_protos_file_h_

// This file was auto generated by the j6-uefi-headers project. Please see
// https://github.com/justinian/j6-uefi-headers for more information.

#include <uefi/guid.h>
#include <uefi/types.h>

namespace uefi {
namespace protos {
struct file;

struct file
{


    inline uefi::status open(file ** new_handle, const wchar_t * file_name, file_mode open_mode, file_attr attributes) {
        return _open(this, new_handle, file_name, open_mode, attributes);
    }

    inline uefi::status close() {
        return _close(this);
    }

    inline uefi::status delete_file() {
        return _delete_file(this);
    }

    inline uefi::status read(uint64_t * buffer_size, void * buffer) {
        return _read(this, buffer_size, buffer);
    }

    inline uefi::status write(uint64_t * buffer_size, void * buffer) {
        return _write(this, buffer_size, buffer);
    }

    inline uefi::status get_position(uint64_t * position) {
        return _get_position(this, position);
    }

    inline uefi::status set_position(uint64_t position) {
        return _set_position(this, position);
    }

    inline uefi::status get_info(const guid * info_type, uint64_t * buffer_size, void * buffer) {
        return _get_info(this, info_type, buffer_size, buffer);
    }

    inline uefi::status set_info(const guid * info_type, uint64_t buffer_size, void * buffer) {
        return _set_info(this, info_type, buffer_size, buffer);
    }

    inline uefi::status flush() {
        return _flush(this);
    }

    inline uefi::status open_ex(file ** new_handle, const wchar_t * file_name, uint64_t open_mode, uint64_t attributes, file_io_token * token) {
        return _open_ex(this, new_handle, file_name, open_mode, attributes, token);
    }

    inline uefi::status read_ex(file_io_token * token) {
        return _read_ex(this, token);
    }

    inline uefi::status write_ex(file_io_token * token) {
        return _write_ex(this, token);
    }

    inline uefi::status flush_ex(file_io_token * token) {
        return _flush_ex(this, token);
    }

    uint64_t revision;

protected:
    using _open_def = uefi::status (*)(uefi::protos::file *, file **, const wchar_t *, file_mode, file_attr);
    _open_def _open;

    using _close_def = uefi::status (*)(uefi::protos::file *);
    _close_def _close;

    using _delete_file_def = uefi::status (*)(uefi::protos::file *);
    _delete_file_def _delete_file;

    using _read_def = uefi::status (*)(uefi::protos::file *, uint64_t *, void *);
    _read_def _read;

    using _write_def = uefi::status (*)(uefi::protos::file *, uint64_t *, void *);
    _write_def _write;

    using _get_position_def = uefi::status (*)(uefi::protos::file *, uint64_t *);
    _get_position_def _get_position;

    using _set_position_def = uefi::status (*)(uefi::protos::file *, uint64_t);
    _set_position_def _set_position;

    using _get_info_def = uefi::status (*)(uefi::protos::file *, const guid *, uint64_t *, void *);
    _get_info_def _get_info;

    using _set_info_def = uefi::status (*)(uefi::protos::file *, const guid *, uint64_t, void *);
    _set_info_def _set_info;

    using _flush_def = uefi::status (*)(uefi::protos::file *);
    _flush_def _flush;

    using _open_ex_def = uefi::status (*)(uefi::protos::file *, file **, const wchar_t *, uint64_t, uint64_t, file_io_token *);
    _open_ex_def _open_ex;

    using _read_ex_def = uefi::status (*)(uefi::protos::file *, file_io_token *);
    _read_ex_def _read_ex;

    using _write_ex_def = uefi::status (*)(uefi::protos::file *, file_io_token *);
    _write_ex_def _write_ex;

    using _flush_ex_def = uefi::status (*)(uefi::protos::file *, file_io_token *);
    _flush_ex_def _flush_ex;

public:
};

} // namespace protos
} // namespace uefi

#endif // _uefi_protos_file_h_