(import 
  (scheme base)
  (cyclone concurrent)
  (cyclone test))

(test-group "basic"
  (define q (make-shared-queue))
  (test "predicate" #t (shared-queue? q))
  (test "empty" #t (shared-queue-empty? q))
  (test "empty" 0 (shared-queue-size q))
  (shared-queue-add! q 'a)
  (test "add a" #f (shared-queue-empty? q))
  (test "add a" 1 (shared-queue-size q))
  (shared-queue-add! q 'b)
  (test "add b" #f (shared-queue-empty? q))
  (test "add b" 2 (shared-queue-size q))
  (shared-queue-add! q 'c)
  (shared-queue-add! q 'd)
  (shared-queue-add! q 'e)
  (shared-queue-add! q 'f)
  (shared-queue-add! q 'g)
  (shared-queue-add! q 'h)
  (shared-queue-add! q 'i)
  (shared-queue-add! q 'j)
  (test "add many" #f (shared-queue-empty? q))
  (test "add many" 10 (shared-queue-size q))
  (test "remove" 'a (shared-queue-remove! q))
  (test "remove a - size" 9 (shared-queue-size q))
  (test "remove" 'b (shared-queue-remove! q))
  (test "remove" 'c (shared-queue-remove! q))
  (test "remove" 'd (shared-queue-remove! q))
  (test "remove d - size" 6 (shared-queue-size q))
  
  (shared-queue-add! q 'a)
  (shared-queue-add! q 'b)
  (shared-queue-add! q 'c)
  (shared-queue-add! q 'd)
  (test "add many back" 10 (shared-queue-size q))

  (shared-queue-clear! q)
  (test "clear" 0 (shared-queue-size q))
)

(test-exit)
