# SRFI 28 - Basic format strings

Specifies a method of interpreting a Scheme string which contains a number of
escape sequences, into which other data is interpolated according to the
semantics of each sequence.

See the [SRFI document][http://srfi.schemers.org/srfi-28/srfi-28.html] for more information.

## Limitations

Currently, this translates newline escape sequences into LF. This may cause
issues if this is ever used on Windows (which expects CRLF instead). Given that
Cyclone does not currently support Windows, this issue should not arise in
practice.

## Interface

# format

    (format format-string [obj ...])

Processes ``format-string``, replacing any escape sequences in order with one or
more characters. These characters depend on the semantics of the escape
sequence.

An 'escape sequence' is a two-character sequence in ``format-string``, where the
first character is a tilde ('~'). The following are all of the valid escape
codes, as well as their semantics:

- ``~a``: The corresponding value is inserted into the string as if printed by
  ``display``.
- ``~s``: The corresponding value is inserted into the string as if printed by
  ``write``.
- ``~%``: A newline is inserted.
- ``~~``: A literal tilde is inserted.

``~a`` and ``~s``, when encountered, require a corresponding Scheme value to be
present as an argument to ``format``. The values provided in ``obj ...`` are
used by the escape sequences in order. It is an error if fewer values are
provided than escape sequences which require them. ``~%`` and ``~~`` do not need
a corresponding value.

Example: The call ``(format "This is the ~ast example: ~s~%" 1 '(foo bar 17))``
would produce the string ``"This is the 1st example: (foo bar 17)
"`` (note the newline).

