# SRFI 27 - Sources of random bits

The `(srfi 27)` library provides sources of random bits. 

See the [SRFI document](http://srfi.schemers.org/srfi-27/srfi-27.html) for more information.

- [`random-integer`](#random-integer)
- [`random-real`](#random-real)
- [`default-random-source`](#default-random-source)
- [`make-random-source`](#make-random-source)
- [`random-source?`](#random-source)
- [`random-source-state-ref`](#random-source-state-ref)
- [`random-source-state-set!`](#random-source-state-set)
- [`random-source-randomize!`](#random-source-randomize)
- [`random-source-pseudo-randomize!`](#random-source-pseudo-randomize)
- [`random-source-make-integers`](#random-source-make-integers)
- [`random-source-make-reals`](#random-source-make-reals)

# random-integer

    (random-integer n)

Return the next integer in `{0, ..., n-1}`.

# random-real

    (random-real)

The next number `x` such that `0 < x < 1`.

# default-random-source

A random source from which random-integer and random-real have been derived using random-source-make-integers and random-source-make-reals. Note that an assignment to default-random-source does not change random or random-real; it is also strongly recommended not to assign a new value.

# make-random-source

    (make-random-source)

Create a new random source.

# random-source?

    (random-source? obj)

Determine if the given object is a random source.

# random-source-state-ref

    (random-source-state-ref s)

# random-source-state-set!

    (random-source-state-set! s state)

# random-source-randomize!

    (random-source-randomize! s)

# random-source-pseudo-randomize!

    (random-source-pseudo-randomize! s i j)

# random-source-make-integers

    (random-source-make-integers s)

# random-source-make-reals

    (random-source-make-reals s)

