# SRFI 143 - Fixnums

This SRFI describes arithmetic procedures applicable to a limited range of exact integers only. These procedures are semantically similar to the corresponding generic-arithmetic procedures, but allow more efficient implementations.

See the [SRFI document](http://srfi.schemers.org/srfi-143/srfi-143.html) for more information.

## Constants
[`fx-width`](#fx-width)
[`fx-greatest`](#fx-greatest)
[`fx-least`](#fx-least)

## Predicates
[`fixnum?`](#fixnum)
[`fx=?`](#fx)
[`fx<?`](#fx-1)
[`fx>?`](#fx-2)
[`fx<=?`](#fx-3)
[`fx>=?`](#fx-4)
[`fxzero?`](#fxzero)
[`fxpositive?`](#fxpositive)
[`fxnegative?`](#fxnegative)
[`fxodd?`](#fxodd)
[`fxeven?`](#fxeven)
[`fxmax`](#fxmax)
[`fxmin`](#fxmin)

## Basic arithmetic
[`fx+`](#fx-5)
[`fx-`](#fx-)
[`fx*`](#fx-6)
[`fxneg`](#fxneg)
[`fxquotient`](#fxquotient)
[`fxremainder`](#fxremainder)
[`fxabs`](#fxabs)
[`fxsquare`](#fxsquare)
[`fxsqrt`](#fxsqrt)

# Bitwise operations
[`fxnot`](#fxnot)
[`fxand`](#fxand)
[`fxior`](#fxior)
[`fxxor`](#fxxor)
[`fxarithmetic-shift`](#fxarithmetic-shift)
[`fxarithmetic-shift-left`](#fxarithmetic-shift-left)
[`fxarithmetic-shift-right`](#fxarithmetic-shift-right)
[`fxbit-count`](#fxbit-count)
[`fxlength`](#fxlength)
[`fxif`](#fxif)
[`fxbit-set?`](#fxbit-set)
[`fxcopy-bit`](#fxcopy-bit)
[`fxfirst-set-bit`](#fxfirst-set-bit)
[`fxbit-field`](#fxbit-field)
[`fxbit-field-rotate`](#fxbit-field-rotate)
[`fxbit-field-reverse`](#fxbit-field-reverse)

# fx-width 

    (fx-width)

Bound to the value `w` that specifies the implementation-defined fixnum integer range.

# fx-greatest 

    (fx-greatest)

Returns value of the largest representable fixnum.

# fx-least

    (fx-least)

Returns value of the smallest representable fixnum.

# fixnum?

    (fixnum? obj)

Returns `#t` if `obj` is an exact integer within the fixnum range, and `#f` otherwise.

# fx=? 

    (fx=? i j)

Semantically equivalent to `=`.

# fx<? 

    (fx<? i j)

Semantically equivalent to `<`.

# fx>? 

    (fx>? i j)

Semantically equivalent to `>`.

# fx<=? 

    (fx<=? i j)

Semantically equivalent to `<=`.

# fx>=?

    (fx>=? i j)

Semantically equivalent to `>=`.

# fxzero? 

    (fxzero? i)

Semantically equivalent to `zero?`.

# fxpositive? 

    (fxpostiive? i)

Semantically equivalent to `positive?`.

# fxnegative? 

    (fxnegative? i)

Semantically equivalent to `negative?`.

# fxodd? 

    (fxodd? i)

Semantically equivalent to `odd?`.

# fxeven?

    (fxeven? i)

Semantically equivalent to `even?`.

# fxmax 

    (fxmax i j)

Semantically equivalent to `max`.

# fxmin

    (fxmin i j)

Semantically equivalent to `min`.

# fx+ 

    (fx+ i j)

Semantically equivalent to `+`, but accepts exactly two arguments.

# fx- 

    (fx- i j)

Semantically equivalent to `-`, but accepts exactly two arguments.

# fx*

    (fx* i j)

Semantically equivalent to `*`, but accepts exactly two arguments.

# fxneg

    (fxneg i)

Semantically equivalent to `-`, but accepts exactly one argument.

# fxquotient 

    (fxquotient i j)

Semantically equivalent to `quotient`.

# fxremainder

    (fxremainder i j)

Semantically equivalent to `remainder`.

# fxabs 

    (fxabs i)

Semantically equivalent to `abs`.

# fxsquare 

    (fxsquare i)

Semantically equivalent to `square`.

# fxsqrt 

    (fxsqrt i)

Semantically equivalent to `sqrt`.

# fxnot 

    (fxnot i)

Semantically equivalent to `bitwise-not`.

# fxand 

    (fxand i j)

Semantically equivalent to `bitwise-and`.

# fxior 

    (fxior i j)

Semantically equivalent to `bitwise-ior`.

# fxxor 

    (fxxor i j)

Semantically equivalent to `bitwise-xor`.

# fxarithmetic-shift 

    (fxarithmetic-shift i count)

Semantically equivalent to `arithmetic-shift`, except that it is an error for the absolute value of count to exceed `w-1`.

# fxarithmetic-shift-left 

    (fxarithmetic-shift-left i count)

The same as `fxarithmetic-shift` except that a negative value of count is an error. This is provided for additional efficiency.

# fxarithmetic-shift-right

    (fxarithmetic-shift-right i count)

The same as `fxarithmetic-shift` except that a non-negative value of count specifies the number of bits to shift right, and a negative value is an error. This is provided for additional efficiency.

# fxbit-count 

    (fxbit-count i)

Semantically equivalent to SRFI 151 `bit-count`.

# fxlength 

    (fxlength i)

Semantically equivalent to `integer-length`.

# fxif 

    (fxif mask i j)

Semantically equivalent to `bitwise-if`.


# fxbit-set? 

    (fxbit-set? index i)

Semantically equivalent to SRFI 151 `bit-set?`, except that it is an error for `index` to be larger than or equal to `fx-width`.

# fxcopy-bit

    (fxcopy-bit index i boolean)

Semantically equivalent to SRFI 151 `copy-bit`, except that it is an error for `index` to be larger than or equal to `fx-width`.

# fxfirst-set-bit 
    (fxfirst-set-bit i)

Semantically equivalent to `first-set-bit`.


# fxbit-field

    (fxbit-field i start end)

Semantically equivalent to `bit-field`.

# fxbit-field-rotate 

    (fxbit-field-rotate i count start end)

Semantically equivalent to SRFI 151 `bit-field-rotate`.

# fxbit-field-reverse

    (fxbit-field-reverse i start end)

Semantically equivalent to `bit-field-reverse`.

