# SRFI 111 - Boxes

The `(srfi 111)` library defines boxes, a container for an object of any Scheme type, including another box. Boxes are normally used as minimal mutable storage, and can inject a controlled amount of mutability into an otherwise immutable data structure (or one that is conventionally treated as immutable). 

See the [SRFI document](http://srfi.schemers.org/srfi-111/srfi-111.html) for more information.

- [`box`](#box)
- [`box?`](#box-1) 
- [`unbox`](#unbox) 
- [`set-box!`](#set-box)

# box 

    (box value)

Constructor. Returns a newly allocated box initialized to value.

# box?

    (box? object)

Predicate. Returns #t if object is a box, and #f otherwise.

# unbox

    (unbox box)

Accessor. Returns the current value of box.

# set-box!

    (set-box! box value)

Mutator. Changes box to hold value.

