# SRFI 106 - Basic socket interface

The `(srfi 106)` library provides a basic socket interface.

See the [SRFI document](http://srfi.schemers.org/srfi-106/srfi-106.html) for more information.

## Constructors and predicate
[`make-client-socket`](#make-client-socket)
[`make-server-socket`](#make-server-socket)
[`socket?`](#socket)

## Socket operations
[`socket-accept`](#socket-accept)
[`socket-send`](#socket-send)
[`socket-recv`](#socket-recv)
[`socket-shutdown`](#socket-shutdown)
[`socket-close`](#socket-close)

## Port conversion
[`socket-input-port`](#socket-input-port)
[`socket-output-port`](#socket-output-port)

## Control feature
[`call-with-socket`](#call-with-socket)

## Flag operations
[`address-family`](#address-family)
[`address-info`](#address-info)
[`socket-domain`](#socket-domain)
[`ip-protocol`](#ip-protocol)
[`message-type`](#message-type)
[`shutdown-method`](#shutdown-method)
[`socket-merge-flags`](#socket-merge-flags)
[`socket-purge-flags`](#socket-purge-flags)

## Constant values
[`*af-unspec*`](#af-unspec)
[`*af-inet*`](#af-inet)
[`*af-inet6*`](#af-inet6)
[`*sock-stream*`](#sock-stream)
[`*sock-dgram*`](#sock-dgram)
[`*ai-canonname*`](#ai-canonname)
[`*ai-numerichost*`](#ai-numerichost)
[`*ai-v4mapped*`](#ai-v4mapped)
[`*ai-all*`](#ai-all)
[`*ai-addrconfig*`](#ai-addrconfig)
[`*ipproto-ip*`](#ipproto-ip)
[`*ipproto-tcp*`](#ipproto-tcp)
[`*ipproto-udp*`](#ipproto-udp)
[`*msg-peek*`](#msg-peek)
[`*msg-oob*`](#msg-oob)
[`*msg-waitall*`](#msg-waitall)
[`*shut-rd*`](#shut-rd)
[`*shut-wr*`](#shut-wr)
[`*shut-rdwr*`](#shut-rdwr)

# make-client-socket

    (make-client-socket node service [ai-family [ai-socktype [ai-flags [ai-protocol]]]]) -> socket

Returns a client socket connected to an Internet address.
The Internet address is identified by node and service. node and service must be string.
Example value of node: `"localhost" "127.0.0.1"`
Example value of service: `"http" "80"`
The optional parameter may specify the created socket's behaviour.
If the optional argument(s) is omitted, then following flags should be used as default:

    ai-family
      *af-inet*
    ai-socktype
      *sock-stream*
    ai-flags
      (socket-merge-flags *ai-v4mapped* *ai-addrconfig*)
    ai-protocol
      *ipproto-ip*

The created socket may not be closed automatically so it is users' responsibility to close it explicitly.

# make-server-socket

    (make-server-socket service [ai-family [ai-socktype [ai-protocol]]]) -> socket

Returns a server socket waiting for connection.
The description of node argument is the same as make-client-socket.
The optional parameter may specify the created socket's behaviour.

If the optional argument(s) is omitted, then following flags should be used as default.

    ai-family
      *af-inet*
    ai-socktype
      *sock-stream*
    ai-protocol
      *ipproto-ip*

The created socket may not be closed automatically so it is users' responsibility to close it explicitly.

# socket?

    (socket? object) -> boolean

Returns `#t` if given `object` is socket object. Otherwise `#f`.

# socket-accept

    (socket-accept socket) -> socket

Wait for an incoming connection request, and returns a fresh connected client socket.

# socket-send

    (socket-send socket bv [flags]) -> size

Sends a binary data block to a socket and returns the sent data size.
`flags` may specify the procedure's behaviour.

If the `flags` is omitted, the default value must be the result of following form:

    (message-type none)

# socket-recv

    (socket-recv socket size [flags]) -> bv

Receives a binary data block from a socket. If zero length bytevector is returned, it means the peer connection is closed.
`flags` may specify the procedure's behaviour.

If the `flags` is omitted, the default value must be the result of following form:

    (message-type none)

# socket-shutdown

    (socket-shutdown socket how) -> (unspecified)

Shutdowns a socket.
`how` must be one of the following constants:

    *shut-rd*
    *shut-wr*
    *shut-rdwr*

# socket-close

    (socket-close socket) -> (unspecified)

Closes a socket.
The procedure does not shutdown the given socket. To shutdown a socket, socket-shutdown should be called explicitly.

# socket-input-port

    (socket-input-port socket) -> binary-input-port

Returns a fresh binary input port associated with a socket, respectively.
The port should not close underlying socket when it's closing.

# socket-output-port

    (socket-output-port socket) -> binary-output-port

Returns a fresh binary output port associated with a socket, respectively.
The port should not close underlying socket when it's closing.

# call-with-socket

    (call-with-socket socket proc) -> object

Calls a given procedure with a given socket as an argument.

If given `proc` returns then it returns the result of `proc` and socket will be automatically closed. If `proc` doesn't return then given socket won't be closed automatically. It's analogy of `call-with-port`.

# address-family

*Syntax*

    (address-family name) -> address-family

Returns proper address family from given name.

    inet

Returns `*af-inet*`

    inet6

Returns `*af-inet6*`

    unspec

Returns `*af-unspec*`

# address-info 

*Syntax*

    (address-info names ...) -> address-info

Returns merged address info flags from given names.

    canoname

Returns `*ai-canonname*`

    numerichost

Returns `*ai-numerichost*`

    v4mapped

Returns `*ai-v4mapped*`

    all

Returns `*ai-all*`

    addrconfig

Returns `*ai-addrconfig*`

# socket-domain

*Syntax*

    (socket-domain name) -> socket-domain

Returns socket domain flags from given name.

    stream

Returns `*sock-stream*`

    datagram

Returns `*sock-dgram*`

# ip-protocol

*Syntax*

    (ip-protocol name) -> ip-protocol

Returns ip-protocol flag from given name.

   ip

Returns `*ipproto-ip*`

    tcp

Returns `*ipproto-tcp*`

    udp

Returns `*ipproto-udp*`

# message-type

*Syntax*

    (message-type names ...) -> message-type

Returns message type flag from given name.

The flag can be used both socket-recv and socket-send.

    none

Returns no flag.

    peek

Returns `*msg-peek*`

    oob

Returns `*msg-oob*`

    wait-all

Returns `*msg-waitall*`

# shutdown-method

*Syntax*

    (shutdown-method names ...) -> shutdown-method

Returns shutdown method flags from given names.

    read

Returns `*shut-rd*`

    write

Returns `*shut-wr*`

If shutdown-method is given both read and write, then it must return `*shut-rdwr*`

# socket-merge-flags

    (socket-merge-flags flags ...) -> new-flags

Merges given `flags` and returns a new flag.

# socket-purge-flags

    (socket-purge-flags base-flag flags ...) -> new-flags

Removes `flags` from `base-flag` if exists and returns a new flag.

# \*af-unspec\*

This must behave the same as POSIX's `AF_UNSPEC`.

# \*af-inet\*

Internet domain sockets for use with IPv4 addresses.
This must behave the same as POSIX's `AF_INET`.

# \*af-inet6\*

Internet domain sockets for use with IPv6 addresses.
This must behave the same as POSIX's `AF_INET6`.

# \*sock-stream\*

Byte-stream socket.
This must behave the same as POSIX's `SOCK_STREAM`.

# \*sock-dgram\*

Datagram socket.
This must behave the same as POSIX's `SOCK_DGRAM`.

# \*ai-canonname\*

This must behave the same as POSIX's `AI_CANONNAME`.

# \*ai-numerichost\*

This must behave the same as POSIX's `AI_NUMERICHOST`.

# \*ai-v4mapped\*

This must behave the same as POSIX's `AI_V4MAPPED`.

# \*ai-all\*

This must behave the same as POSIX's `AI_ALL`.

# \*ai-addrconfig\*

This must behave the same as POSIX's `AI_ADDRCONFIG`.

# \*ipproto-ip\*

Internet protocol.
This must behave the same as POSIX's `IPPROTO_IP`.

# \*ipproto-tcp\*

Transmission control protocol.
This must behave the same as POSIX's `IPPROTO_TCP`.

# \*ipproto-udp\*

User datagram protocol.
This must behave the same as POSIX's `IPPROTO_UDP`.

# \*msg-peek\*

For socket-recv.
Peeks at an incoming message. The data is treated as unread and the next socket-recv shall still return this data.
This must behave the same as `POSIX's MSG_PEEK`.

# \*msg-oob\*

For both `socket-recv` and `socket-send`.
Requests/sends out-of-band data.
This must behave the same as POSIX's `MSG_OOB`.

# \*msg-waitall\*

For socket-recv.
On sockets created with `*sock-stream*` flag, this requests the procedure block until the full amount of data ban be returned.
This must behave the same as POSIX's `MSG_WAITALL`.

# \*shut-rd\*

Disables further receive operation.
This must behave the same as POSIX's `SHUT_RD`.

# \*shut-wr\*

Disables further send operations.
This must behave the same as POSIX's `SHUT_WR`.

# \*shut-rdwr\*

Disables further send and receive operations.
This must behave the same as POSIX's `SHUT_RDWR`.

