# Development Guide

- [Introduction](#introduction)
- [Environment](#environment)
- [Building](#building)
- [Testing a Build](#testing-a-build)
- [Debugging the Runtime](#debugging-the-runtime)

## Introduction

This document provides some basic instructions for developing Cyclone itself - the compiler, interpreter, and libraries. Some of this information may also be applicable when troubleshooting problems with the runtime and/or compiled programs.

## Environment

During development it is a good idea to clone the `cyclone-bootstrap` repository as well as the `cyclone` one. Place both directories in the same parent directory and you can use `sync.sh` to copy individual compiled files to `cyclone-bootstrap`, or `make bootstrap` to copy everything.

## Building

Please use cyclone-bootstrap if you are installing Cyclone on a machine for the first time. Otherwise, if you already have a copy of Cyclone installed you can build from Scheme source. 

The following prerequisites are required:

- libck (see install instructions)
- make
- gcc

From the source directory, use the following commands to build and install:

    $ make
    $ make test
    $ sudo make install
    $ cyclone
    
By default everything is installed under `/usr/local`. This may be changed by passing a different `PREFIX`. For example:

    make PREFIX=/home/me install

## Testing a Build

`make test` may be used to perform basic testing. 

To make sure everything works, install a modified copy of Cyclone and run the following to rebuild the libraries, compiler, interpreter, and examples from source:

    $ make clean
    $ make
    $ make test
    $ make bootstrap

This confirms that the compiler - with any changes - can still be built from source, and syncs any changes up to `cyclone-bootstrap`. Before checking in a set of changes or releasing a build it is also a good idea to do a rebuild of the bootstrap repo also, to make sure it still works.

## Debugging the Runtime

Cyclone should never segfault unless there is a bug in the runtime/compiler. To debug a segfault using the C compiler's tools, first rebuild Cyclone with debugging turned on. With GCC, you can do this by changing two lines at the top of `Makefile.config` to use the `-g` option instead of `-O2`. 

For example:

    CFLAGS       ?= -g -Wall -Iinclude -L.
    COMP_CFLAGS  ?= -g -Wall -I$(PREFIX)/include -L$(PREFIX)/lib

Then rebuild/reinstall everything. This may be easiest to do using the [cyclone-bootstrap](https://github.com/justinethier/cyclone-bootstrap) repository; just modify `Makefile.config` and follow the install instructions.

Now that the C compiler is producing debugging information, you can use `gdb` to debug the segfault directly:

    $ gdb ./crashing-program
    (gdb) run

If you need to specify any command line arguments to the program:

    (gdb) run arg1 arg2 ...

At this point when the program crashes you should be able to see exactly where it failed. If it failed in `runtime.c` or one of the native C files, it should be straightforward to figure out the problem. If the crash is in a C file generated by Cyclone, the problem will be harder to debug, because likely the compiler either generated code incorrectly or the compiler did not catch an error (such as a missing function parameter) and generated bad code as a result.
