[<img src="images/cyclone-logo-04-header.png" alt="cyclone-scheme">](http://github.com/justinethier/cyclone)

# API Documentation

- [Standard Libraries](#standard-libraries)
- [SRFI Libraries](#srfi-libraries)
- [Cyclone Libraries](#cyclone-libraries)
- [Internal Compiler API](#internal-compiler-api)
- [C API](#c-api)
- [Index](#index)

# Standard Libraries

This section of the Cyclone API is based on the [R<sup>7</sup>RS Scheme Specification](r7rs.pdf):

Library Name                                               | Description
---------------------------------------------------------- | -----------
[Primitives](api/primitives.md)                            | This is not actually a library but rather a summary of all of the built-in functions (AKA primitives).
[`scheme base`](api/scheme/base.md)                        | The R7RS base library. This is quite extensive and will be required by most programs.
[`scheme case-lambda`](api/scheme/case-lambda.md)          | Exports the `case-lambda` syntax.
[`scheme char`](api/scheme/char.md)                        | Provides procedures for dealing with characters.
[`scheme complex`](api/scheme/complex.md)                  | Exports procedures for working with non-real numbers.
[`scheme cxr`](api/scheme/cxr.md)                          | Exports twenty-four procedures which are the compositions of from three to four `car` and `cdr` operations. 
[`scheme eval`](api/scheme/eval.md)                        | Exports procedures for evaluating Scheme data as programs.
[`scheme file`](api/scheme/file.md)                        | Provides procedures for accessing files.
[`scheme inexact`](api/scheme/inexact.md)                  | Procedures which are typically only useful with inexact values.
[`scheme lazy`](api/scheme/lazy.md)                        | Procedures and syntax keywords for lazy evaluation.
[`scheme load`](api/scheme/load.md)                        | Procedures for loading Scheme expressions from files.
[`scheme process-context`](api/scheme/process-context.md)  | Procedures for accessing with the program's calling context.
[`scheme read`](api/scheme/read.md)                        | Provides procedures for reading Scheme objects.
[`scheme repl`](api/scheme/repl.md)                        | Provides functions related to Read-Eval-Print-Loops.
[`scheme time`](api/scheme/time.md)                        | Provides access to time-related values.
[`scheme write`](api/scheme/write.md)                      | Provides procedures for writing Scheme objects.

# SRFI Libraries

Cyclone supports the following [Scheme Requests for Implementation (SRFI)](http://srfi.schemers.org/) libraries. Detailed information is available in the linked SRFI page as well as the provided Cyclone API.

Note that these libraries may be imported using either the SRFI number, such as `(srfi 1)`, or a descriptive name: `(scheme list)`. These descriptive names follow the recommendations from R7RS Large where available.

Library Name                            | SRFI Number | Description | External Documentation
--------------------------------------- | ----------- | ----------- | ----------------------
[`scheme list`](api/srfi/1.md)          | [`srfi 1`](api/srfi/1.md)     | List library | [Link](http://srfi.schemers.org/srfi-1/srfi-1.html)
[`cyclone and-let*`](api/srfi/2.md)     | [`srfi 2`](api/srfi/2.md)     | `AND-LET*`: an `AND` with local bindings, a guarded `LET*` special form | [Link](http://srfi.schemers.org/srfi-2/srfi-2.html)
 N/A                                    | [`srfi 8`](api/srfi/8.md)     | Binding to multiple values - Included as part of `scheme base`. | [Link](http://srfi.schemers.org/srfi-8/srfi-8.html)
[`cyclone threads`](api/srfi/18.md)     | [`srfi 18`](api/srfi/18.md)   | Multithreading support | [Link](http://srfi.schemers.org/srfi-18/srfi-18.html)
[`cyclone random`](api/srfi/27.md)      | [`srfi 27`](api/srfi/27.md)   | Sources of random bits | [Link](http://srfi.schemers.org/srfi-27/srfi-27.html)
[`cyclone format`](api/srfi/28.md)      | [`srfi 28`](api/srfi/28.md)   | Basic format strings | [Link](http://srfi.schemers.org/srfi-28/srfi-28.html)
[`cyclone integer-bits`](api/srfi/60.md)| [`srfi 60`](api/srfi/60.md)   | Integers as bits | [Link](http://srfi.schemers.org/srfi-60/srfi-60.html)
[`scheme hash-table`](api/srfi/69.md)   | [`srfi 69`](api/srfi/69.md)   | Basic hash tables | [Link](http://srfi.schemers.org/srfi-69/srfi-69.html)
[`cyclone socket`](api/srfi/106.md)     | [`srfi 106`](api/srfi/106.md) | Basic socket interface | [Link](http://srfi.schemers.org/srfi-106/srfi-106.html)
[`scheme box`](api/srfi/111.md)         | [`srfi 111`](api/srfi/111.md) | Boxes | [Link](http://srfi.schemers.org/srfi-111/srfi-111.html)
[`scheme set`](api/srfi/113.md)         | [`srfi 113`](api/srfi/113.md) | Sets and bags | [Link](http://srfi.schemers.org/srfi-113/srfi-113.html)
[`scheme list-queue`](api/srfi/117.md)  | [`srfi 117`](api/srfi/117.md) | Mutable queues | [Link](http://srfi.schemers.org/srfi-117/srfi-117.html)
[`scheme generator`](api/srfi/121.md)   | [`srfi 121`](api/srfi/121.md) | Generators | [Link](http://srfi.schemers.org/srfi-121/srfi-121.html)
[`scheme comparator`](api/srfi/128.md)  | [`srfi 128`](api/srfi/128.md) | Comparators | [Link](http://srfi.schemers.org/srfi-128/srfi-128.html)
[`scheme sort`](api/srfi/132.md)        | [`srfi 132`](api/srfi/132.md) | Sort libraries | [Link](http://srfi.schemers.org/srfi-132/srfi-132.html)
[`scheme vector`](api/srfi/133.md)      | [`srfi 133`](api/srfi/133.md) | Vector library (R7RS-compatible) | [Link](http://srfi.schemers.org/srfi-133/srfi-133.html)
[`cyclone fixnum`](api/srfi/143.md)     | [`srfi 143`](api/srfi/143.md) | Fixnums | [Link](http://srfi.schemers.org/srfi-143/srfi-143.html)

# Cyclone Libraries

These libraries are provided as Cyclone-specific extensions:

Library Name | Description
------------ | -----------
[`cyclone concurrent`](api/cyclone/concurrent.md) | A helper library for writing concurrent code.
[`cyclone foreign`](api/cyclone/foreign.md) | Provides a convenient interface for integrating with C code. It is recommended to use this library if possible rather than our lower-level FFI.
[`cyclone match`](api/cyclone/match.md) | A hygienic pattern matcher based on Alex Shinn's portable `match.scm`.
[`cyclone test`](api/cyclone/test.md) | A unit testing framework ported from `(chibi test)`.
[`scheme cyclone pretty-print`](api/scheme/cyclone/pretty-print.md) | A pretty printer.

# Internal Compiler API

These libraries are used by the Cyclone compiler. Some of these are stable and unlikely to change, whereas others could change as the compiler evolves.

Library Name                                                                  | Description
----------------------------------------------------------------------------- | -----------
[`scheme cyclone ast`](api/scheme/cyclone/ast.md)                             | Abstract syntax tree types used during compilation.
[`scheme cyclone cgen`](api/scheme/cyclone/cgen.md)                           | C code generation
[`scheme cyclone common`](api/scheme/cyclone/common.md)                       | Mostly version numbers and header comments
[`scheme cyclone cps-optimizations`](api/scheme/cyclone/cps-optimizations.md) | Compiler optimizations, analysis, and related transformations
[`scheme cyclone libraries`](api/scheme/cyclone/libraries.md)                 | Compiler support for R7RS libraries
[`scheme cyclone primitives`](api/scheme/cyclone/primitives.md)               | Compiler support for primitives
[`scheme cyclone transforms`](api/scheme/cyclone/transforms.md)               | Various Scheme-to-Scheme transformations of the intermediate code 
[`scheme cyclone util`](api/scheme/cyclone/util.md)                           | Utility functions used internally by the compiler

# C API

[This documentation](http://justinethier.github.io/cyclone/c-api/modules.html) covers the C API provided by Cyclone Scheme. It is intended both to help understand how the Cyclone runtime works as well as to provide a useful reference manual when working with the Cyclone FFI.

# Index

This section is an alphabetic listing of all the functions, objects, and macros provided by the previous libraries.

- - -
[`%adb:make-fnc`](api/scheme/cyclone/cps-optimizations.md#adbmake-fnc-1)
[`%adb:make-var`](api/scheme/cyclone/cps-optimizations.md#adbmake-var-1)

- - -
[`*Cyc-version-banner*`](api/scheme/cyclone/common.md#cyc-version-banner)
[`*`](api/primitives.md#)
[`*af-inet*`](api/srfi/106.md#af-inet)
[`*af-inet6*`](api/srfi/106.md#af-inet6)
[`*af-unspec*`](api/srfi/106.md#af-unspec)
[`*ai-addrconfig*`](api/srfi/106.md#ai-addrconfig)
[`*ai-all*`](api/srfi/106.md#ai-all)
[`*ai-canonname*`](api/srfi/106.md#ai-canonname)
[`*ai-numerichost*`](api/srfi/106.md#ai-numerichost)
[`*ai-v4mapped*`](api/srfi/106.md#ai-v4mapped)
[`*c-file-header-comment*`](api/scheme/cyclone/common.md#c-file-header-comment)
[`*defined-macros*          `](api/scheme/cyclone/transforms.md#*defined-macros)
[`*do-code-gen*             `](api/scheme/cyclone/transforms.md#*do-code-gen)
[`*ipproto-ip*`](api/srfi/106.md#ipproto-ip)
[`*ipproto-tcp*`](api/srfi/106.md#ipproto-tcp)
[`*ipproto-udp*`](api/srfi/106.md#ipproto-udp)
[`*msg-oob*`](api/srfi/106.md#msg-oob)
[`*msg-peek*`](api/srfi/106.md#msg-peek)
[`*msg-waitall*`](api/srfi/106.md#msg-waitall)
[`*primitives*              `](api/scheme/cyclone/transforms.md#*primitives)
[`*primitives*`](api/scheme/cyclone/primitives.md#primitives)
[`*primitives-num-args*`](api/scheme/cyclone/primitives.md#primitives-num-args)
[`*shut-rd*`](api/srfi/106.md#shut-rd)
[`*shut-rdwr*`](api/srfi/106.md#shut-rdwr)
[`*shut-wr*`](api/srfi/106.md#shut-wr)
[`*sock-dgram*`](api/srfi/106.md#sock-dgram)
[`*sock-stream*`](api/srfi/106.md#sock-stream)
[`*trace-level*             `](api/scheme/cyclone/transforms.md#*trace-level)
[`*version*`](api/scheme/cyclone/common.md#version)
[`*version-banner*`](api/scheme/cyclone/common.md#version-banner)
[`*version-name*`](api/scheme/cyclone/common.md#version-name)
[`*version-number*`](api/scheme/cyclone/common.md#version-number)

- - -
[`+`](api/primitives.md#-1)

- - -
[`->heap`](api/srfi/18.md#-heap)
[`-`](api/primitives.md#-)

- - -
[`/`](api/primitives.md#-2)

- - -
[`<=?                           `](api/srfi/128.md#-3)
[`<=`](api/primitives.md#-4)
[`<?                            `](api/srfi/128.md#-1)
[`<`](api/primitives.md#-3)

- - -
[`=?                            `](api/srfi/128.md#)
[`=`](api/primitives.md#-5)

- - -
[`>=?                           `](api/srfi/128.md#-4)
[`>=`](api/primitives.md#-7)
[`>?                            `](api/srfi/128.md#-2)
[`>`](api/primitives.md#-6)

- - -
[`Cyc-er-compare?            `](api/scheme/cyclone/util.md#cyc-er-compare)
[`Cyc-er-rename              `](api/scheme/cyclone/util.md#cyc-er-rename)
[`Cyc-minor-gc`](api/srfi/18.md#cyc-minor-gc)

- - -
[`abs`](api/scheme/base.md#abs)
[`acos`](api/scheme/inexact.md#acos)
[`adb:clear!`](api/scheme/cyclone/cps-optimizations.md#adbclear)
[`adbf:set-simple!`](api/scheme/cyclone/cps-optimizations.md#adbfset-simple)
[`adbf:set-unused-params!`](api/scheme/cyclone/cps-optimizations.md#adbfset-unused-params)
[`adbf:simple`](api/scheme/cyclone/cps-optimizations.md#adbfsimple)
[`adb:function?`](api/scheme/cyclone/cps-optimizations.md#adbfunction)
[`adbf:unused-params`](api/scheme/cyclone/cps-optimizations.md#adbfunused-params)
[`adb:get`](api/scheme/cyclone/cps-optimizations.md#adbget)
[`adb:get-db`](api/scheme/cyclone/cps-optimizations.md#adbget-db)
[`adb:get/default`](api/scheme/cyclone/cps-optimizations.md#adbgetdefault)
[`adb:make-fnc`](api/scheme/cyclone/cps-optimizations.md#adbmake-fnc)
[`adb:make-var`](api/scheme/cyclone/cps-optimizations.md#adbmake-var)
[`adb:set!`](api/scheme/cyclone/cps-optimizations.md#adbset)
[`adb:variable?`](api/scheme/cyclone/cps-optimizations.md#adbvariable)
[`adbv:assigned-value`](api/scheme/cyclone/cps-optimizations.md#adbvassigned-value)
[`adbv:const?`](api/scheme/cyclone/cps-optimizations.md#adbvconst) 
[`adbv:const-value`](api/scheme/cyclone/cps-optimizations.md#adbvconst-value)
[`adbv:defined-by`](api/scheme/cyclone/cps-optimizations.md#adbvdefined-by)
[`adbv:global?`](api/scheme/cyclone/cps-optimizations.md#adbvglobal)
[`adbv:reassigned?`](api/scheme/cyclone/cps-optimizations.md#adbvreassigned) 
[`adbv:ref-by`](api/scheme/cyclone/cps-optimizations.md#adbvref-by)
[`adbv:set-assigned-value!`](api/scheme/cyclone/cps-optimizations.md#adbvset-assigned-value)
[`adbv:set-const!`](api/scheme/cyclone/cps-optimizations.md#adbvset-const)
[`adbv:set-const-value!`](api/scheme/cyclone/cps-optimizations.md#adbvset-const-value)
[`adbv:set-defined-by!`](api/scheme/cyclone/cps-optimizations.md#adbvset-defined-by)
[`adbv:set-global!`](api/scheme/cyclone/cps-optimizations.md#adbvset-global)
[`adbv:set-reassigned!`](api/scheme/cyclone/cps-optimizations.md#adbvset-reassigned)
[`adbv:set-ref-by!`](api/scheme/cyclone/cps-optimizations.md#adbvset-ref-by)
[`address-family`](api/srfi/106.md#address-family)
[`address-info`](api/srfi/106.md#address-info)
[`alist->bag         `](api/srfi/113.md#alist-bag)
[`alist-cons`](api/srfi/1.md#alist-cons)
[`alist-copy`](api/srfi/1.md#alist-copy)
[`alist-delete`](api/srfi/1.md#alist-delete)
[`alist-delete!`](api/srfi/1.md#alist-delete-1)
[`alist->hash-table`](api/srfi/69.md#alist-hash-table)
[`alpha-convert             `](api/scheme/cyclone/transforms.md#alpha-convert)
[`analyze-cps`](api/scheme/cyclone/cps-optimizations.md#analyze-cps)
[`analyze-mutable-variables `](api/scheme/cyclone/transforms.md#analyze-mutable-variables)
[`and`](api/scheme/base.md#and)
[`and-let*`](api/srfi/2.md#and-let)
[`angle`](api/scheme/complex.md#angle)
[`any`](api/scheme/base.md#any)
[`any`](api/srfi/1.md#any)
[`any-bits-set?`](api/srfi/60.md#any-bits-set)
[`app?                       `](api/scheme/cyclone/util.md#app)
[`app->args                 `](api/scheme/cyclone/transforms.md#app-args) 
[`append`](api/scheme/base.md#append)
[`append!`](api/srfi/1.md#append)
[`append-map`](api/srfi/1.md#append-map)
[`append-map!`](api/srfi/1.md#append-map-1)
[`append-reverse`](api/srfi/1.md#append-reverse)
[`append-reverse!`](api/srfi/1.md#append-reverse-1)
[`app->fun                  `](api/scheme/cyclone/transforms.md#app-fun) 
[`apply                 `](api/primitives.md#apply)
[`arithmetic-shift`](api/srfi/60.md#ash)
[`ash`](api/srfi/60.md#ash)
[`asin`](api/scheme/inexact.md#asin)
[`assoc`](api/scheme/base.md#assoc)
[`assq`](api/scheme/base.md#assq)
[`assq-remove-key           `](api/scheme/cyclone/transforms.md#assq-remove-key)
[`assq-remove-keys          `](api/scheme/cyclone/transforms.md#assq-remove-keys)
[`assv`](api/scheme/base.md#assv)
[`ast:ast->pp-sexp`](api/scheme/cyclone/ast.md#astast-pp-sexp)
[`ast:ast->sexp`](api/scheme/cyclone/ast.md#astast-sexp)
[`ast:lambda?`](api/scheme/cyclone/ast.md#astlambda)
[`ast:lambda-args`](api/scheme/cyclone/ast.md#astlambda-args) 
[`ast:lambda-body`](api/scheme/cyclone/ast.md#astlambda-body)
[`ast:lambda-formals->list  `](api/scheme/cyclone/transforms.md#astlambda-formals-list)
[`ast:lambda-formals-type   `](api/scheme/cyclone/transforms.md#astlambda-formals-type)
[`ast:lambda-id`](api/scheme/cyclone/ast.md#astlambda-id)
[`ast:make-lambda`](api/scheme/cyclone/ast.md#astmake-lambda)
[`ast:set-lambda-args!`](api/scheme/cyclone/ast.md#astset-lambda-args)
[`ast:set-lambda-body!`](api/scheme/cyclone/ast.md#astset-lambda-body)
[`ast:sexp->ast`](api/scheme/cyclone/ast.md#astsexp-ast) 
[`atan`](api/scheme/inexact.md#atan)
[`atom`](api/cyclone/concurrent.md#atom)
[`atom?`](api/cyclone/concurrent.md#atom-1)
[`azip                      `](api/scheme/cyclone/transforms.md#azip)

- - -
[`%adb:make-fnc`](api/scheme/cyclone/cps-optimizations.md#adbmake-fnc-1)
[`%adb:make-var`](api/scheme/cyclone/cps-optimizations.md#adbmake-var-1)

- - -
[`*af-inet6*`](api/srfi/106.md#af-inet6)
[`*af-inet*`](api/srfi/106.md#af-inet)
[`*af-unspec*`](api/srfi/106.md#af-unspec)
[`*ai-addrconfig*`](api/srfi/106.md#ai-addrconfig)
[`*ai-all*`](api/srfi/106.md#ai-all)
[`*ai-canonname*`](api/srfi/106.md#ai-canonname)
[`*ai-numerichost*`](api/srfi/106.md#ai-numerichost)
[`*ai-v4mapped*`](api/srfi/106.md#ai-v4mapped)

- - -
[`-`](api/primitives.md#-)

- - -
[`*`](api/primitives.md#)

- - -
[`+`](api/primitives.md#-1)

- - -
[`/`](api/primitives.md#-2)

- - -
[`<`](api/primitives.md#-3)
[`<=`](api/primitives.md#-4)

- - -
[`=`](api/primitives.md#-5)

- - -
[`>`](api/primitives.md#-6)
[`>=`](api/primitives.md#-7)

- - -
[`=?                            `](api/srfi/128.md#)

- - -
[`<?                            `](api/srfi/128.md#-1)

- - -
[`>?                            `](api/srfi/128.md#-2)

- - -
[`<=?                           `](api/srfi/128.md#-3)

- - -
[`>=?                           `](api/srfi/128.md#-4)

- - -
[`bag-adjoin      `](api/srfi/113.md#bag-adjoin)
[`bag-adjoin!     `](api/srfi/113.md#bag-adjoin-1)
[`bag->alist         `](api/srfi/113.md#bag-alist)
[`bag-any?  `](api/srfi/113.md#bag-any)
[`bag`](api/srfi/113.md#bag)
[`bag?         `](api/srfi/113.md#bag-1)
[`bag=? `](api/srfi/113.md#bag-2)
[`bag<? `](api/srfi/113.md#bag-3)
[`bag>? `](api/srfi/113.md#bag-4)
[`bag<=?`](api/srfi/113.md#bag-5)
[`bag>=?`](api/srfi/113.md#bag-6)
[`bag-comparator`](api/srfi/113.md#bag-comparator)
[`bag-contains? `](api/srfi/113.md#bag-contains)
[`bag-copy  `](api/srfi/113.md#bag-copy)
[`bag-count `](api/srfi/113.md#bag-count)
[`bag-decrement!     `](api/srfi/113.md#bag-decrement)
[`bag-delete-all  `](api/srfi/113.md#bag-delete-all)
[`bag-delete-all! `](api/srfi/113.md#bag-delete-all-1)
[`bag-delete      `](api/srfi/113.md#bag-delete)
[`bag-delete!     `](api/srfi/113.md#bag-delete-1)
[`bag-difference   `](api/srfi/113.md#bag-difference)
[`bag-difference!  `](api/srfi/113.md#bag-difference-1)
[`bag-disjoint?`](api/srfi/113.md#bag-disjoint)
[`bag-element-comparator`](api/srfi/113.md#bag-element-comparator)
[`bag-element-count  `](api/srfi/113.md#bag-element-count)
[`bag-empty?   `](api/srfi/113.md#bag-empty)
[`bag-every?`](api/srfi/113.md#bag-every)
[`bag-filter    `](api/srfi/113.md#bag-filter)
[`bag-filter!   `](api/srfi/113.md#bag-filter-1)
[`bag-find  `](api/srfi/113.md#bag-find)
[`bag-fold      `](api/srfi/113.md#bag-fold)
[`bag-fold-unique    `](api/srfi/113.md#bag-fold-unique)
[`bag-for-each  `](api/srfi/113.md#bag-for-each)
[`bag-for-each-unique`](api/srfi/113.md#bag-for-each-unique)
[`bag-increment!     `](api/srfi/113.md#bag-increment)
[`bag-intersection `](api/srfi/113.md#bag-intersection)
[`bag-intersection!`](api/srfi/113.md#bag-intersection-1)
[`bag->list `](api/srfi/113.md#bag-list)
[`bag-map       `](api/srfi/113.md#bag-map)
[`bag-member            `](api/srfi/113.md#bag-member)
[`bag-partition `](api/srfi/113.md#bag-partition)
[`bag-partition!`](api/srfi/113.md#bag-partition-)
[`bag-product        `](api/srfi/113.md#bag-product)
[`bag-product!       `](api/srfi/113.md#bag-product-1)
[`bag-remove    `](api/srfi/113.md#bag-remove)
[`bag-remove!   `](api/srfi/113.md#bag-remove-1)
[`bag-replace     `](api/srfi/113.md#bag-replace)
[`bag-replace!    `](api/srfi/113.md#bag-replace-1)
[`bag-search!     `](api/srfi/113.md#bag-search)
[`bag->set           `](api/srfi/113.md#bag-set)
[`bag-size  `](api/srfi/113.md#bag-size)
[`bag-sum            `](api/srfi/113.md#bag-sum)
[`bag-sum!           `](api/srfi/113.md#bag-sum-1)
[`bag-unfold`](api/srfi/113.md#bag-unfold)
[`bag-union        `](api/srfi/113.md#bag-union)
[`bag-union!       `](api/srfi/113.md#bag-union-1)
[`bag-unique-size    `](api/srfi/113.md#bag-unique-size)
[`bag-xor          `](api/srfi/113.md#bag-xor)
[`bag-xor!         `](api/srfi/113.md#bag-xor-1)
[`basename                  `](api/scheme/cyclone/transforms.md#basename)
[`begin`](api/scheme/base.md#begin)
[`begin?                     `](api/scheme/cyclone/util.md#begin)
[`begin->exps               `](api/scheme/cyclone/transforms.md#begin-exps)
[`bit-count`](api/srfi/60.md#bit-count)
[`bit-field`](api/srfi/60.md#bit-field)
[`bit-set?`](api/srfi/60.md#bit-set)
[`bitwise-and`](api/srfi/60.md#bitwise-and)
[`bitwise-if`](api/srfi/60.md#bitwise-if)
[`bitwise-ior`](api/srfi/60.md#bitwise-ior)
[`bitwise-merge`](api/srfi/60.md#bitwise-merge)
[`bitwise-not`](api/srfi/60.md#bitwise-not)
[`bitwise-xor`](api/srfi/60.md#bitwise-xor)
[`boolean?              `](api/primitives.md#boolean)
[`boolean=?`](api/scheme/base.md#boolean)
[`boolean-hash                  `](api/srfi/128.md#boolean-hash)
[`booleans->integer`](api/srfi/60.md#booleans-integer)
[`box`](api/srfi/111.md#box)
[`box?`](api/srfi/111.md#box-1) 
[`break`](api/srfi/1.md#break)
[`break!`](api/srfi/1.md#break-1)
[`built-in-syms             `](api/scheme/cyclone/transforms.md#built-in-syms)
[`bytevector            `](api/primitives.md#bytevector)
[`bytevector?           `](api/primitives.md#bytevector)
[`bytevector-append     `](api/primitives.md#bytevector-append)
[`bytevector-copy`](api/scheme/base.md#bytevector-copy)
[`bytevector-copy!`](api/scheme/base.md#bytevector-copy-1)
[`bytevector->generator`](api/srfi/121.md#bytevector-generator)
[`bytevector-length     `](api/primitives.md#bytevector-length)
[`bytevector-u8-ref     `](api/primitives.md#bytevector-u8-ref)
[`bytevector-u8-set!    `](api/primitives.md#bytevector-u8-set)

- - -
[`caaaar`](api/scheme/cxr.md#caaaar)
[`caaadr`](api/scheme/cxr.md#caaadr)
[`caaar`](api/scheme/cxr.md#caaar)
[`caadar`](api/scheme/cxr.md#caadar)
[`caaddr`](api/scheme/cxr.md#caaddr)
[`caadr`](api/scheme/cxr.md#caadr)
[`caar                  `](api/primitives.md#caar)
[`cadaar`](api/scheme/cxr.md#cadaar)
[`cadadr`](api/scheme/cxr.md#cadadr)
[`cadar`](api/scheme/cxr.md#cadar)
[`caddar`](api/scheme/cxr.md#caddar)
[`cadddr`](api/scheme/cxr.md#cadddr)
[`caddr`](api/scheme/cxr.md#caddr)
[`cadr                  `](api/primitives.md#cadr)
[`call/cc`](api/scheme/base.md#callcc)
[`call-with-current-continuation`](api/scheme/base.md#call-with-current-continuation)
[`call-with-input-file`](api/scheme/file.md#call-with-input-file)
[`call-with-output-file`](api/scheme/file.md#call-with-output-file)
[`call-with-port`](api/scheme/base.md#call-with-port)
[`call-with-socket`](api/srfi/106.md#call-with-socket)
[`call-with-values`](api/scheme/base.md#call-with-values)
[`car                   `](api/primitives.md#car)
[`car+cdr`](api/srfi/1.md#carcdr)
[`case`](api/scheme/base.md#case)
[`case-lambda`](api/scheme/case-lambda.md#case-lambda)
[`c-code`](api/cyclone/foreign.md#c-code)
[`cdaaar`](api/scheme/cxr.md#cdaaar)
[`cdaadr`](api/scheme/cxr.md#cdaadr)
[`cdaar`](api/scheme/cxr.md#cdaar)
[`cdadar`](api/scheme/cxr.md#cdadar)
[`cdaddr`](api/scheme/cxr.md#cdaddr)
[`cdadr`](api/scheme/cxr.md#cdadr)
[`cdar                  `](api/primitives.md#cdar)
[`cddaar`](api/scheme/cxr.md#cddaar)
[`cddadr`](api/scheme/cxr.md#cddadr)
[`cddar`](api/scheme/cxr.md#cddar)
[`cdddar`](api/scheme/cxr.md#cdddar)
[`cddddr`](api/scheme/cxr.md#cddddr)
[`cdddr`](api/scheme/cxr.md#cdddr)
[`cddr                  `](api/primitives.md#cddr)
[`c-define`](api/cyclone/foreign.md#c-define)
[`c-define-type`](api/cyclone/foreign.md#c-define-type)
[`cdr                   `](api/primitives.md#cdr)
[`ceiling`](api/scheme/base.md#ceiling)
[`cell?                     `](api/scheme/cyclone/transforms.md#cell)
[`cell-get?                 `](api/scheme/cyclone/transforms.md#cell-get)
[`cell-get->cell            `](api/scheme/cyclone/transforms.md#cell-get-cell)
[`cell->value               `](api/scheme/cyclone/transforms.md#cell-value)
[`char-alphabetic?`](api/scheme/char.md#char-alphabetic)
[`char?                 `](api/primitives.md#char)
[`char<=?`](api/scheme/base.md#char)
[`char<?`](api/scheme/base.md#char-1)
[`char=?`](api/scheme/base.md#char-2)
[`char>=?`](api/scheme/base.md#char-3)
[`char>?`](api/scheme/base.md#char-4)
[`char-ci<=?`](api/scheme/char.md#char-ci)
[`char-ci<?`](api/scheme/char.md#char-ci-1)
[`char-ci=?`](api/scheme/char.md#char-ci-2)
[`char-ci>=?`](api/scheme/char.md#char-ci-3)
[`char-ci>?`](api/scheme/char.md#char-ci-4)
[`char-ci-hash                  `](api/srfi/128.md#char-ci-hash)
[`char-downcase`](api/scheme/char.md#char-downcase)
[`char-foldcase`](api/scheme/char.md#char-foldcase)
[`char-hash                     `](api/srfi/128.md#char-hash)
[`char->integer         `](api/primitives.md#char-integer)
[`char-lower-case?`](api/scheme/char.md#char-lower-case)
[`char-numeric?`](api/scheme/char.md#char-numeric)
[`char-upcase`](api/scheme/char.md#char-upcase)
[`char-upper-case?`](api/scheme/char.md#char-upper-case)
[`char-whitespace?`](api/scheme/char.md#char-whitespace)
[`circular-list?`](api/srfi/1.md#circular-list)
[`circular-list`](api/srfi/1.md#circular-list-1)
[`clear-mutables            `](api/scheme/cyclone/transforms.md#clear-mutables)
[`close-input-port      `](api/primitives.md#close-input-port)
[`close-output-port     `](api/primitives.md#close-output-port)
[`close-port            `](api/primitives.md#close-port)
[`closure?                  `](api/scheme/cyclone/transforms.md#closure)
[`closure-convert           `](api/scheme/cyclone/transforms.md#closure-convert)
[`closure->env              `](api/scheme/cyclone/transforms.md#closure-env)
[`closure->fv               `](api/scheme/cyclone/transforms.md#closure-fv)
[`closure->lam              `](api/scheme/cyclone/transforms.md#closure-lam) 
[`command-line`](api/scheme/process-context.md#command-line)
[`command-line-arguments`](api/primitives.md#command-line-arguments)
[`comparator?                   `](api/srfi/128.md#comparator)
[`comparator-check-type         `](api/srfi/128.md#comparator-check-type)
[`comparator-equality-predicate `](api/srfi/128.md#comparator-equality-predicate)
[`comparator-hashable?          `](api/srfi/128.md#comparator-hashable)
[`comparator-hash               `](api/srfi/128.md#comparator-hash)
[`comparator-hash-function      `](api/srfi/128.md#comparator-hash-function)
[`comparator-if<=>              `](api/srfi/128.md#comparator-if)
[`comparator-ordered?           `](api/srfi/128.md#comparator-ordered)
[`comparator-ordering-predicate `](api/srfi/128.md#comparator-ordering-predicate)
[`comparator-register-default!  `](api/srfi/128.md#comparator-register-default)
[`comparator-test-type          `](api/srfi/128.md#comparator-test-type)
[`comparator-type-test-predicate`](api/srfi/128.md#comparator-type-test-predicate)
[`compare-and-set!`](api/cyclone/concurrent.md#compare-and-set)
[`complex?`](api/scheme/base.md#complex)
[`concatenate`](api/srfi/1.md#concatenate)
[`concatenate!`](api/srfi/1.md#concatenate-1)
[`cond`](api/scheme/base.md#cond)
[`cond-expand`](api/scheme/base.md#cond-expand)
[`condition-variable?`](api/srfi/18.md#condition-variable)
[`condition-variable-broadcast!`](api/srfi/18.md#condition-variable-broadcast)
[`condition-variable-signal!`](api/srfi/18.md#condition-variable-signal)
[`condition-variable-wait!`](api/srfi/18.md#condition-variable-wait)
[`cons                  `](api/primitives.md#cons)
[`cons*`](api/srfi/1.md#cons)
[`const?                     `](api/scheme/cyclone/util.md#const) 
[`copy-bit`](api/srfi/60.md#copy-bit)
[`copy-bit-field`](api/srfi/60.md#copy-bit-field)
[`cos`](api/scheme/inexact.md#cos)
[`count`](api/srfi/1.md#count)
[`cps-convert               `](api/scheme/cyclone/transforms.md#cps-convert)
[`create-environment`](api/scheme/eval.md#create-environment)
[`current-error-port`](api/scheme/base.md#current-error-port)
[`current-input-port`](api/scheme/base.md#current-input-port)
[`current-jiffy`](api/scheme/time.md#current-jiffy)
[`current-output-port`](api/scheme/base.md#current-output-port)
[`current-second`](api/scheme/time.md#current-second)
[`current-test-applier`](api/cyclone/test.md#current-test-applier)
[`current-test-comparator`](api/cyclone/test.md#current-test-comparator)
[`current-test-epsilon`](api/cyclone/test.md#current-test-epsilon)
[`current-test-group`](api/cyclone/test.md#current-test-group)
[`current-test-group-reporter`](api/cyclone/test.md#current-test-group-reporter)
[`current-test-skipper`](api/cyclone/test.md#current-test-skipper)
[`current-test-verbosity`](api/cyclone/test.md#current-test-verbosity)
[`current-thread`](api/srfi/18.md#current-thread)
[`current-thread-data`](api/srfi/18.md#current-thread-data)
[`c-value`](api/cyclone/foreign.md#c-value)

- - -
[`Cyc-er-compare?            `](api/scheme/cyclone/util.md#cyc-er-compare)
[`Cyc-er-rename              `](api/scheme/cyclone/util.md#cyc-er-rename)

- - -
[`cyc:error                 `](api/scheme/cyclone/transforms.md#cycerror)

- - -
[`Cyc-minor-gc`](api/srfi/18.md#cyc-minor-gc)

- - -
[`*c-file-header-comment*`](api/scheme/cyclone/common.md#c-file-header-comment)
[`*Cyc-version-banner*`](api/scheme/cyclone/common.md#cyc-version-banner)

- - -
[`default-hash                  `](api/srfi/128.md#default-hash)
[`default-random-source`](api/srfi/27.md#default-random-source)
[`define?                    `](api/scheme/cyclone/util.md#define)
[`define-c?                  `](api/scheme/cyclone/util.md#define-c)
[`define->exp                `](api/scheme/cyclone/util.md#define-exp) 
[`define->lambda            `](api/scheme/cyclone/transforms.md#define-lambda) 
[`define-lambda?            `](api/scheme/cyclone/transforms.md#define-lambda-1)
[`define-record-type`](api/scheme/base.md#define-record-type)
[`define->var                `](api/scheme/cyclone/util.md#define-var)
[`delay`](api/scheme/lazy.md#delay) 
[`delay-force`](api/scheme/lazy.md#delay-force) 
[`delete                     `](api/scheme/cyclone/util.md#delete)
[`delete`](api/srfi/1.md#delete)
[`delete!`](api/srfi/1.md#delete-1)
[`delete-duplicates          `](api/scheme/cyclone/util.md#delete-duplicates)
[`delete-duplicates`](api/srfi/1.md#delete-duplicates)
[`delete-duplicates!`](api/srfi/1.md#delete-duplicates-1)
[`delete-file           `](api/primitives.md#delete-file)
[`deliver`](api/cyclone/concurrent.md#deliver)
[`denominator`](api/scheme/base.md#denominator)
[`deref`](api/cyclone/concurrent.md#deref)
[`difference                `](api/scheme/cyclone/transforms.md#difference)
[`digit-value`](api/scheme/char.md#digit-value)
[`display`](api/scheme/write.md#display)
[`do`](api/scheme/base.md#do)
[`dotted-list?`](api/srfi/1.md#dotted-list)
[`drop`](api/srfi/1.md#drop)
[`drop-right`](api/srfi/1.md#drop-right)
[`drop-right!`](api/srfi/1.md#drop-right-1)
[`drop-while`](api/srfi/1.md#drop-while)
[`dynamic-wind`](api/scheme/base.md#dynamic-wind)

- - -
[`*defined-macros*          `](api/scheme/cyclone/transforms.md#*defined-macros)
[`*do-code-gen*             `](api/scheme/cyclone/transforms.md#*do-code-gen)

- - -
[`eighth`](api/srfi/1.md#eighth)
[`emergency-exit`](api/scheme/process-context.md#emergency-exit)
[`emit`](api/scheme/cyclone/cgen.md#emit)
[`emit*`](api/scheme/cyclone/cgen.md#emit-1)
[`emit-newline`](api/scheme/cyclone/cgen.md#emit-newline)
[`emits`](api/scheme/cyclone/cgen.md#emits)
[`emits*`](api/scheme/cyclone/cgen.md#emits-1)
[`env:add-binding-to-frame!  `](api/scheme/cyclone/util.md#envadd-binding-to-frame)
[`env:all-values             `](api/scheme/cyclone/util.md#envall-values)
[`env:all-variables          `](api/scheme/cyclone/util.md#envall-variables)
[`env:define-variable!       `](api/scheme/cyclone/util.md#envdefine-variable) 
[`env:enclosing-environment  `](api/scheme/cyclone/util.md#envenclosing-environment)
[`env:extend-environment     `](api/scheme/cyclone/util.md#envextend-environment)
[`env:first-frame            `](api/scheme/cyclone/util.md#envfirst-frame)
[`env:frame-values           `](api/scheme/cyclone/util.md#envframe-values) 
[`env:frame-variables        `](api/scheme/cyclone/util.md#envframe-variables)
[`env-get?                  `](api/scheme/cyclone/transforms.md#env-get)
[`env-get->env              `](api/scheme/cyclone/transforms.md#env-get-env)
[`env-get->field            `](api/scheme/cyclone/transforms.md#env-get-field)
[`env-get->id               `](api/scheme/cyclone/transforms.md#env-get-id)
[`env:lookup                 `](api/scheme/cyclone/util.md#envlookup)
[`env:_lookup-variable-value `](api/scheme/cyclone/util.md#envlookup-variable-value)
[`env:lookup-variable-value  `](api/scheme/cyclone/util.md#envlookup-variable-value)
[`env-make?                 `](api/scheme/cyclone/transforms.md#env-make)
[`env-make->fields          `](api/scheme/cyclone/transforms.md#env-make-fields)
[`env:make-frame             `](api/scheme/cyclone/util.md#envmake-frame)
[`env-make->id              `](api/scheme/cyclone/transforms.md#env-make-id)
[`env-make->values          `](api/scheme/cyclone/transforms.md#env-make-values)
[`env:set-variable-value!    `](api/scheme/cyclone/util.md#envset-variable-value)
[`env:the-empty-environment  `](api/scheme/cyclone/util.md#envthe-empty-environment)
[`eof-object?           `](api/primitives.md#eof-object)
[`eof-object`](api/scheme/base.md#eof-object)
[`eq?                   `](api/primitives.md#eq)
[`equal?                `](api/primitives.md#equal)
[`eqv?                  `](api/primitives.md#eqv)
[`error                 `](api/primitives.md#error)
[`error`](api/scheme/base.md#error)
[`eval`](api/scheme/eval.md#eval)
[`even?`](api/scheme/base.md#even)
[`every`](api/scheme/base.md#every)
[`every`](api/srfi/1.md#every)
[`exact`](api/scheme/base.md#exact)
[`exact?`](api/scheme/base.md#exact)
[`exact-integer?`](api/scheme/base.md#exact-integer)
[`exit                  `](api/primitives.md#exit)
[`expand`](api/scheme/eval.md#expand)
[`exp`](api/scheme/inexact.md#exp)
[`expt`](api/scheme/base.md#expt)

- - -
[`features`](api/scheme/base.md#features)
[`fifth`](api/srfi/1.md#fifth)
[`file-exists?          `](api/primitives.md#file-exists)
[`filter                     `](api/scheme/cyclone/util.md#filter)
[`filter`](api/srfi/1.md#filter)
[`filter!`](api/srfi/1.md#filter-1)
[`filter-map`](api/srfi/1.md#filter-map)
[`filter-unused-variables   `](api/scheme/cyclone/transforms.md#filter-unused-variables)
[`find`](api/srfi/1.md#find)
[`find-tail`](api/srfi/1.md#find-tail)
[`finite?`](api/scheme/inexact.md#finite)
[`first`](api/srfi/1.md#first)
[`first-set-bit`](api/srfi/60.md#first-set-bit)
[`fixnum?`](api/srfi/143.md#fixnum)
[`flatten                    `](api/scheme/cyclone/util.md#flatten)
[`floor`](api/scheme/base.md#floor)
[`floor/`](api/scheme/base.md#floor-1)
[`floor-quotient`](api/scheme/base.md#floor-quotient)
[`floor-remainder`](api/scheme/base.md#floor-remainder )
[`floor-remainder`](api/scheme/base.md#floor-remainder)
[`flush-output-port`](api/scheme/base.md#flush-output-port)
[`fold`](api/srfi/1.md#fold)
[`foldl`](api/scheme/base.md#foldl)
[`foldr`](api/scheme/base.md#foldr)
[`fold-right`](api/srfi/1.md#fold-right)
[`force`](api/scheme/lazy.md#force) 
[`for-each`](api/scheme/base.md#for-each)
[`formals->list              `](api/scheme/cyclone/util.md#formals-list)
[`fourth`](api/srfi/1.md#fourth)
[`free-vars                 `](api/scheme/cyclone/transforms.md#free-vars)
[`future?`](api/cyclone/concurrent.md#future)
[`future`](api/cyclone/concurrent.md#future-1)
[`future-call`](api/cyclone/concurrent.md#future-call)
[`future-deref`](api/cyclone/concurrent.md#future-deref)
[`future-done?`](api/cyclone/concurrent.md#future-done)
[`fxabs`](api/srfi/143.md#fxabs)
[`fxand`](api/srfi/143.md#fxand)
[`fx=?`](api/srfi/143.md#fx)
[`fx-`](api/srfi/143.md#fx-)
[`fx<?`](api/srfi/143.md#fx-1)
[`fx>?`](api/srfi/143.md#fx-2)
[`fx<=?`](api/srfi/143.md#fx-3)
[`fx>=?`](api/srfi/143.md#fx-4)
[`fx+`](api/srfi/143.md#fx-5)
[`fx*`](api/srfi/143.md#fx-6)
[`fxarithmetic-shift`](api/srfi/143.md#fxarithmetic-shift)
[`fxarithmetic-shift-left`](api/srfi/143.md#fxarithmetic-shift-left)
[`fxarithmetic-shift-right`](api/srfi/143.md#fxarithmetic-shift-right)
[`fxbit-count`](api/srfi/143.md#fxbit-count)
[`fxbit-field`](api/srfi/143.md#fxbit-field)
[`fxbit-field-reverse`](api/srfi/143.md#fxbit-field-reverse)
[`fxbit-field-rotate`](api/srfi/143.md#fxbit-field-rotate)
[`fxbit-set?`](api/srfi/143.md#fxbit-set)
[`fxcopy-bit`](api/srfi/143.md#fxcopy-bit)
[`fxeven?`](api/srfi/143.md#fxeven)
[`fxfirst-set-bit`](api/srfi/143.md#fxfirst-set-bit)
[`fx-greatest`](api/srfi/143.md#fx-greatest)
[`fxif`](api/srfi/143.md#fxif)
[`fxior`](api/srfi/143.md#fxior)
[`fx-least`](api/srfi/143.md#fx-least)
[`fxlength`](api/srfi/143.md#fxlength)
[`fxmax`](api/srfi/143.md#fxmax)
[`fxmin`](api/srfi/143.md#fxmin)
[`fxneg`](api/srfi/143.md#fxneg)
[`fxnegative?`](api/srfi/143.md#fxnegative)
[`fxnot`](api/srfi/143.md#fxnot)
[`fxodd?`](api/srfi/143.md#fxodd)
[`fxpositive?`](api/srfi/143.md#fxpositive)
[`fxquotient`](api/srfi/143.md#fxquotient)
[`fxremainder`](api/srfi/143.md#fxremainder)
[`fxsqrt`](api/srfi/143.md#fxsqrt)
[`fxsquare`](api/srfi/143.md#fxsquare)
[`fx-width`](api/srfi/143.md#fx-width)
[`fxxor`](api/srfi/143.md#fxxor)
[`fxzero?`](api/srfi/143.md#fxzero)

- - -
[`gappend`](api/srfi/121.md#gappend)
[`gcd`](api/scheme/base.md#gcd)
[`gcombine`](api/srfi/121.md#gcombine)
[`gcons*`](api/srfi/121.md#gcons)
[`gdelete`](api/srfi/121.md#gdelete)
[`gdelete-neighbor-dups`](api/srfi/121.md#gdelete-neighbor-dups)
[`gdrop`](api/srfi/121.md#gdrop)
[`gdrop-while`](api/srfi/121.md#gdrop-while)
[`generator-any`](api/srfi/121.md#generator-any)
[`generator`](api/srfi/121.md#generator)
[`generator-count`](api/srfi/121.md#generator-count)
[`generator-every`](api/srfi/121.md#generator-every)
[`generator-find`](api/srfi/121.md#generator-find)
[`generator-fold`](api/srfi/121.md#generator-fold)
[`generator-for-each`](api/srfi/121.md#generator-for-each)
[`generator->list`](api/srfi/121.md#generator-list)
[`generator->reverse-list`](api/srfi/121.md#generator-reverse-list)
[`generator->string`](api/srfi/121.md#generator-string)
[`generator-unfold`](api/srfi/121.md#generator-unfold)
[`generator->vector`](api/srfi/121.md#generator-vector)
[`generator->vector!`](api/srfi/121.md#generator-vector!)
[`gensym                     `](api/scheme/cyclone/util.md#gensym)
[`get-environment-variable`](api/scheme/process-context.md#get-environment-variable)
[`get-environment-variables`](api/scheme/process-context.md#get-environment-variables)
[`get-macros                `](api/scheme/cyclone/transforms.md#get-macros)
[`get-output-bytevector`](api/scheme/base.md#get-output-bytevector)
[`get-output-string`](api/scheme/base.md#get-output-string)
[`gfilter`](api/srfi/121.md#gfilter)
[`gindex`](api/srfi/121.md#gindex)
[`global-vars               `](api/scheme/cyclone/transforms.md#global-vars) 
[`gremove`](api/srfi/121.md#gremove)
[`gselect`](api/srfi/121.md#gselect)
[`gtake`](api/srfi/121.md#gtake)
[`gtake-while`](api/srfi/121.md#gtake-while)
[`guard`](api/scheme/base.md#guard)

- - -
[`->heap`](api/srfi/18.md#-heap)

- - -
[`has-global?               `](api/scheme/cyclone/transforms.md#has-global)
[`hash`](api/srfi/69.md#hash)
[`hash-bound                    `](api/srfi/128.md#hash-bound)
[`hash-by-identity`](api/srfi/69.md#hash-by-identity)
[`hash-salt                     `](api/srfi/128.md#hash-salt)
[`hash-table->alist`](api/srfi/69.md#hash-table-alist)
[`hash-table?`](api/srfi/69.md#hash-table)
[`hash-table-copy`](api/srfi/69.md#hash-table-copy)
[`hash-table-delete!`](api/srfi/69.md#hash-table-delete)
[`hash-table-equivalence-function`](api/srfi/69.md#hash-table-equivalence-function)
[`hash-table-exists?`](api/srfi/69.md#hash-table-exists)
[`hash-table-fold`](api/srfi/69.md#hash-table-fold)
[`hash-table-hash-function`](api/srfi/69.md#hash-table-hash-function)
[`hash-table-keys`](api/srfi/69.md#hash-table-keys)
[`hash-table-merge!`](api/srfi/69.md#hash-table-merge)
[`hash-table-ref`](api/srfi/69.md#hash-table-ref)
[`hash-table-ref/default`](api/srfi/69.md#hash-table-refdefault)
[`hash-table-set!`](api/srfi/69.md#hash-table-set)
[`hash-table-size`](api/srfi/69.md#hash-table-size)
[`hash-table-update!`](api/srfi/69.md#hash-table-update)
[`hash-table-update!/default`](api/srfi/69.md#hash-table-updatedefault)
[`hash-table-values`](api/srfi/69.md#hash-table-values)
[`hash-table-walk`](api/srfi/69.md#hash-table-walk)

- - -
[`identifier=?               `](api/scheme/cyclone/util.md#identifier)
[`identifier?                `](api/scheme/cyclone/util.md#identifier-1)
[`identifier->symbol         `](api/scheme/cyclone/util.md#identifier-symbol)
[`if?                        `](api/scheme/cyclone/util.md#if)
[`if->condition              `](api/scheme/cyclone/util.md#if-condition)
[`if->else                   `](api/scheme/cyclone/util.md#if-else)
[`if-else?                   `](api/scheme/cyclone/util.md#if-else) 
[`if->then                   `](api/scheme/cyclone/util.md#if-then)
[`imag-part`](api/scheme/complex.md#imag-part)
[`immutable?`](api/cyclone/concurrent.md#immutable)
[`inexact`](api/scheme/base.md#inexact)
[`inexact?`](api/scheme/base.md#inexact-1)
[`infinite?`](api/scheme/inexact.md#infinite)
[`input-port?`](api/scheme/base.md#input-port)
[`input-port-open?`](api/scheme/base.md#input-port-open)
[`insert                    `](api/scheme/cyclone/transforms.md#insert)
[`integer?              `](api/primitives.md#integer)
[`integer->char         `](api/primitives.md#integer-char)
[`integer-length`](api/srfi/60.md#integer-length)
[`integer->list`](api/srfi/60.md#integer-list)
[`interaction-environment`](api/scheme/repl.md#interaction-environment)
[`iota`](api/srfi/1.md#iota)
[`ip-protocol`](api/srfi/106.md#ip-protocol)
[`is-mutable?               `](api/scheme/cyclone/transforms.md#is-mutable)
[`isolate-globals           `](api/scheme/cyclone/transforms.md#isolate-globals)

- - -
[`*ipproto-ip*`](api/srfi/106.md#ipproto-ip)
[`*ipproto-tcp*`](api/srfi/106.md#ipproto-tcp)
[`*ipproto-udp*`](api/srfi/106.md#ipproto-udp)

- - -
[`jiffies-per-second`](api/scheme/time.md#jiffies-per-second)

- - -
[`lambda?                    `](api/scheme/cyclone/util.md#lambda)
[`lambda->exp                `](api/scheme/cyclone/util.md#lambda-exp)
[`lambda->formals            `](api/scheme/cyclone/util.md#lambda-formals)
[`lambda-formals->list       `](api/scheme/cyclone/util.md#lambda-formals-list)
[`lambda-formals-type        `](api/scheme/cyclone/util.md#lambda-formals-type)
[`lambda-num-args           `](api/scheme/cyclone/transforms.md#lambda-num-args)
[`lambda-varargs?            `](api/scheme/cyclone/util.md#lambda-varargs)
[`lambda-varargs-var         `](api/scheme/cyclone/util.md#lambda-varargs-var)
[`last`](api/srfi/1.md#last)
[`last-pair`](api/srfi/1.md#last-pair)
[`lcm`](api/scheme/base.md#lcm)
[`length                `](api/primitives.md#length)
[`length+`](api/srfi/1.md#length)
[`length/obj                 `](api/scheme/cyclone/util.md#lengthobj)
[`let`](api/scheme/base.md#let)
[`let*`](api/scheme/base.md#let-1)
[`let?                      `](api/scheme/cyclone/transforms.md#let)
[`let->args                 `](api/scheme/cyclone/transforms.md#let-args)
[`let->bindings             `](api/scheme/cyclone/transforms.md#let-bindings) 
[`let->bound-vars           `](api/scheme/cyclone/transforms.md#let-bound-vars)
[`let->exp                  `](api/scheme/cyclone/transforms.md#let-exp)
[`let=>lambda               `](api/scheme/cyclone/transforms.md#letlambda)
[`letrec`](api/scheme/base.md#letrec)
[`letrec*`](api/scheme/base.md#letrec-1)
[`letrec?                   `](api/scheme/cyclone/transforms.md#letrec)
[`letrec->args              `](api/scheme/cyclone/transforms.md#letrec-args)
[`letrec->bindings          `](api/scheme/cyclone/transforms.md#letrec-bindings)
[`letrec->bound-vars        `](api/scheme/cyclone/transforms.md#letrec-bound-vars)
[`letrec->exp               `](api/scheme/cyclone/transforms.md#letrec-exp)
[`let*-values`](api/scheme/base.md#let-values)
[`let-values`](api/scheme/base.md#let-values-1)
[`lib:body`](api/scheme/cyclone/libraries.md#libbody)
[`lib:exports`](api/scheme/cyclone/libraries.md#libexports)
[`lib:get-all`](api/scheme/cyclone/libraries.md#libget-all)
[`lib:get-all-import-deps`](api/scheme/cyclone/libraries.md#libget-all-import-deps)
[`lib:get-dep-list`](api/scheme/cyclone/libraries.md#libget-dep-list)
[`lib:idb:ids`](api/scheme/cyclone/libraries.md#libidb:ids)
[`lib:import->export-list`](api/scheme/cyclone/libraries.md#libimport-export-list)
[`lib:import->filename`](api/scheme/cyclone/libraries.md#libimport-filename)
[`lib:import->metalist`](api/scheme/cyclone/libraries.md#libimport-metalist)
[`lib:import->path`](api/scheme/cyclone/libraries.md#libimport-path)
[`lib:imports`](api/scheme/cyclone/libraries.md#libimports)
[`lib:imports->idb`](api/scheme/cyclone/libraries.md#libimports-idb)
[`lib:include-c-headers`](api/scheme/cyclone/libraries.md#libinclude-c-headers)
[`lib:includes`](api/scheme/cyclone/libraries.md#libincludes)
[`lib:list->import-set`](api/scheme/cyclone/libraries.md#liblist-import-set)
[`lib:name`](api/scheme/cyclone/libraries.md#libname)
[`lib:name->string`](api/scheme/cyclone/libraries.md#libname-string)
[`lib:name->symbol`](api/scheme/cyclone/libraries.md#libname-symbol)
[`lib:name->unique-string`](api/scheme/cyclone/libraries.md#libname-unique-string)
[`library?`](api/scheme/cyclone/libraries.md#library)
[`library-exists?`](api/scheme/cyclone/libraries.md#library-exists)
[`lib:read-imports`](api/scheme/cyclone/libraries.md#libread-imports)
[`lib:rename-exports`](api/scheme/cyclone/libraries.md#librename-exports)
[`lib:resolve-meta`](api/scheme/cyclone/libraries.md#libresolve-meta)
[`lib:result`](api/scheme/cyclone/libraries.md#libresult)
[`list`](api/scheme/base.md#list)
[`list?`](api/scheme/base.md#list-1)
[`list=`](api/srfi/1.md#list=)
[`list->bag `](api/srfi/113.md#list-bag)
[`list->bag!`](api/srfi/113.md#list-bag-1)
[`list-copy`](api/scheme/base.md#list-copy)
[`list-copy`](api/srfi/1.md#list-copy)
[`list-delete-neighbor-dups`](api/srfi/132.md#list-delete-neighbor-dups)
[`list-delete-neighbor-dups!`](api/srfi/132.md#list-delete-neighbor-dups-1)
[`list->generator`](api/srfi/121.md#list-generator)
[`list-index2                `](api/scheme/cyclone/util.md#list-index2)
[`list-index                `](api/scheme/cyclone/transforms.md#list-index)
[`list-index`](api/srfi/1.md#list-index)
[`list-insert-at!            `](api/scheme/cyclone/util.md#list-insert-at)
[`list->integer`](api/srfi/60.md#list-integer)
[`list->lambda-formals      `](api/scheme/cyclone/transforms.md#list-lambda-formals)
[`list-merge`](api/srfi/132.md#list-merge)
[`list-merge!`](api/srfi/132.md#list-merge-1)
[`list->pair                `](api/scheme/cyclone/transforms.md#list-pair)
[`list-prefix?               `](api/scheme/cyclone/util.md#list-prefix)
[`list-queue-add-back!`](api/srfi/117.md#list-queue-add-back)
[`list-queue-add-front!`](api/srfi/117.md#list-queue-add-front)
[`list-queue`](api/srfi/117.md#list-queue)
[`list-queue?`](api/srfi/117.md#list-queue-1)
[`list-queue-append`](api/srfi/117.md#list-queue-append)
[`list-queue-append!`](api/srfi/117.md#list-queue-append-1)
[`list-queue-back`](api/srfi/117.md#list-queue-back)
[`list-queue-concatenate`](api/srfi/117.md#list-queue-concatenate)
[`list-queue-copy`](api/srfi/117.md#list-queue-copy)
[`list-queue-empty?`](api/srfi/117.md#list-queue-empty)
[`list-queue-first-last`](api/srfi/117.md#list-queue-first-last)
[`list-queue-for-each`](api/srfi/117.md#list-queue-for-each)
[`list-queue-front`](api/srfi/117.md#list-queue-front)
[`list-queue-list`](api/srfi/117.md#list-queue-list)
[`list-queue-map`](api/srfi/117.md#list-queue-map)
[`list-queue-map!`](api/srfi/117.md#list-queue-map-1)
[`list-queue-remove-all!`](api/srfi/117.md#list-queue-remove-all)
[`list-queue-remove-back!`](api/srfi/117.md#list-queue-remove-back)
[`list-queue-remove-front!`](api/srfi/117.md#list-queue-remove-front)
[`list-queue-set-list!`](api/srfi/117.md#list-queue-set-list)
[`list-queue-unfold`](api/srfi/117.md#list-queue-unfold)
[`list-queue-unfold-right`](api/srfi/117.md#list-queue-unfold-right)
[`list-ref`](api/scheme/base.md#list-ref)
[`list-set!`](api/scheme/base.md#list-set)
[`list->set `](api/srfi/113.md#list-set)
[`list->set!`](api/srfi/113.md#list-set-1)
[`list-sort`](api/srfi/132.md#list-sort)
[`list-sort!`](api/srfi/132.md#list-sort-1)
[`list-sorted?`](api/srfi/132.md#list-sorted)
[`list-stable-sort`](api/srfi/132.md#list-stable-sort)
[`list-stable-sort!`](api/srfi/132.md#list-stable-sort)
[`list->string          `](api/primitives.md#list-string)
[`list-tabulate`](api/srfi/1.md#list-tabulate)
[`list-tail`](api/scheme/base.md#list-tail)
[`list->vector          `](api/primitives.md#list-vector)
[`load`](api/scheme/load.md#load)
[`log2-binary-factors`](api/srfi/60.md#log2-binary-factors)
[`logand`](api/srfi/60.md#logand)
[`log`](api/scheme/inexact.md#log)
[`logbit?`](api/srfi/60.md#logbit)
[`logcount`](api/srfi/60.md#logcount)
[`logior`](api/srfi/60.md#logior)
[`lognot`](api/srfi/60.md#lognot)
[`logtest`](api/srfi/60.md#logtest)
[`logxor`](api/srfi/60.md#logxor)
[`lset-adjoin`](api/srfi/1.md#lset-adjoin)
[`lset<=`](api/srfi/1.md#lset)
[`lset=`](api/srfi/1.md#lset-1)
[`lset-difference`](api/srfi/1.md#lset-difference)
[`lset-difference!`](api/srfi/1.md#lset-difference-1)
[`lset-diff+intersection`](api/srfi/1.md#lset-diffintersection)
[`lset-diff+intersection!`](api/srfi/1.md#lset-diffintersection-1)
[`lset-intersection`](api/srfi/1.md#lset-intersection)
[`lset-intersection!`](api/srfi/1.md#lset-intersection-1)
[`lset-union`](api/srfi/1.md#lset-union)
[`lset-union!`](api/srfi/1.md#lset-union)
[`lset-xor`](api/srfi/1.md#lset-xor)
[`lset-xor!`](api/srfi/1.md#lset-xor-1)

- - -
[`magnitude`](api/scheme/complex.md#magnitude)
[`make-atom`](api/cyclone/concurrent.md#make-atom)
[`make-bytevector       `](api/primitives.md#make-bytevector)
[`make-client-socket`](api/srfi/106.md#make-client-socket)
[`make-comparator               `](api/srfi/128.md#make-comparator)
[`make-condition-variable`](api/srfi/18.md#make-condition-variable)
[`make-constructor`](api/scheme/base.md#make-constructor)
[`make-coroutine-generator`](api/srfi/121.md#make-coroutine-generator)
[`make-default-comparator       `](api/srfi/128.md#make-default-comparator)
[`make-eq-comparator            `](api/srfi/128.md#make-eq-comparator)
[`make-equal-comparator         `](api/srfi/128.md#make-equal-comparator)
[`make-eqv-comparator           `](api/srfi/128.md#make-eqv-comparator)
[`make-for-each-generator`](api/srfi/121.md#make-for-each-generator)
[`make-getter`](api/scheme/base.md#make-getter)
[`make-hash-table`](api/srfi/69.md#make-hash-table)
[`make-iota-generator`](api/srfi/121.md#make-iota-generator)
[`make-list`](api/scheme/base.md#make-list)
[`make-list`](api/srfi/1.md#make-list)
[`make-list-comparator          `](api/srfi/128.md#make-list-comparator)
[`make-list-queue`](api/srfi/117.md#make-list-queue)
[`make-mutex`](api/srfi/18.md#make-mutex) 
[`make-pair-comparator          `](api/srfi/128.md#make-pair-comparator)
[`make-parameter`](api/scheme/base.md#make-parameter)
[`make-polar`](api/scheme/complex.md#make-polar)
[`make-promise`](api/scheme/lazy.md#make-promise) 
[`make-random-source`](api/srfi/27.md#make-random-source)
[`make-range-generator`](api/srfi/121.md#make-range-generator)
[`make-rectangular`](api/scheme/complex.md#make-rectangular)
[`make-server-socket`](api/srfi/106.md#make-server-socket)
[`make-setter`](api/scheme/base.md#make-setter)
[`make-shared-delay`](api/cyclone/concurrent.md#make-shared-delay)
[`make-shared-promise`](api/cyclone/concurrent.md#make-shared-promise)
[`make-shared-queue`](api/cyclone/concurrent.md#make-shared-queue)
[`make-string`](api/scheme/base.md#make-string)
[`make-thread`](api/srfi/18.md#make-thread)
[`make-thread-pool`](api/cyclone/concurrent.md#make-thread-pool)
[`make-type-predicate`](api/scheme/base.md#make-type-predicate)
[`make-unfold-generator`](api/srfi/121.md#make-unfold-generator)
[`make-vector           `](api/primitives.md#make-vector)
[`make-vector-comparator        `](api/srfi/128.md#make-vector-comparator)
[`mangle                     `](api/scheme/cyclone/util.md#mangle)
[`mangle-global              `](api/scheme/cyclone/util.md#mangle-global)
[`map`](api/scheme/base.md#map)
[`map!`](api/srfi/1.md#map)
[`map-in-order`](api/srfi/1.md#map-in-order)
[`mark-mutable              `](api/scheme/cyclone/transforms.md#mark-mutable)
[`match`](api/cyclone/match.md#match)
[`match-lambda`](api/cyclone/match.md#match-lambda)
[`match-lambda*`](api/cyclone/match.md#match-lambda-1)
[`match-let`](api/cyclone/match.md#match-let)
[`match-let*`](api/cyclone/match.md#match-let-1)
[`match-letrec`](api/cyclone/match.md#match-letrec)
[`max`](api/scheme/base.md#max)
[`member`](api/scheme/base.md#member)
[`memq`](api/scheme/base.md#memq)
[`memv`](api/scheme/base.md#memv)
[`message-type`](api/srfi/106.md#message-type)
[`min`](api/scheme/base.md#min)
[`modulo`](api/scheme/base.md#modulo)
[`mta:code-gen`](api/scheme/cyclone/cgen.md#mtacode-gen)
[`mutex?`](api/srfi/18.md#mutex)
[`mutex-lock!`](api/srfi/18.md#mutex-lock)
[`mutex-unlock!`](api/srfi/18.md#mutex-unlock)

- - -
[`*msg-oob*`](api/srfi/106.md#msg-oob)
[`*msg-peek*`](api/srfi/106.md#msg-peek)
[`*msg-waitall*`](api/srfi/106.md#msg-waitall)

- - -
[`nan?`](api/scheme/inexact.md#nan)
[`negative?`](api/scheme/base.md#negative)
[`newline`](api/scheme/base.md#newline)
[`ninth`](api/srfi/1.md#ninth)
[`not`](api/scheme/base.md#not)
[`not-pair?`](api/srfi/1.md#not-pair)
[`null?                 `](api/primitives.md#null)
[`null-list?`](api/srfi/1.md#null-list)
[`number?               `](api/primitives.md#number)
[`number-hash                   `](api/srfi/128.md#number-hash)
[`number->string        `](api/primitives.md#number-string)
[`numerator`](api/scheme/base.md#numerator)

- - -
[`odd?`](api/scheme/base.md#odd)
[`one-instance-of-new-mutable-obj?`](api/scheme/cyclone/cps-optimizations.md#one-instance-of-new-mutable-obj)
[`open-input-bytevector`](api/scheme/base.md#open-input-bytevector)
[`open-input-file       `](api/primitives.md#open-input-file)
[`open-input-string`](api/scheme/base.md#open-input-string)
[`open-output-bytevector`](api/scheme/base.md#open-output-bytevector)
[`open-output-file      `](api/primitives.md#open-output-file)
[`open-output-string`](api/scheme/base.md#open-output-string)
[`opt:contract`](api/scheme/cyclone/cps-optimizations.md#optcontract)
[`optimize-cps`](api/scheme/cyclone/cps-optimizations.md#optimize-cps)
[`opt:inline-prims`](api/scheme/cyclone/cps-optimizations.md#optinline-prims)
[`or`](api/scheme/base.md#or)
[`output-port?`](api/scheme/base.md#output-port)
[`output-port-open?`](api/scheme/base.md#output-port-open)

- - -
[`pack-lambda-arguments      `](api/scheme/cyclone/util.md#pack-lambda-arguments)
[`pair?                 `](api/primitives.md#pair)
[`pair-fold`](api/srfi/1.md#pair-fold)
[`pair-fold-right`](api/srfi/1.md#pair-fold-right)
[`pair-for-each`](api/srfi/1.md#pair-for-each)
[`pair->list                 `](api/scheme/cyclone/util.md#pair-list)
[`parameterize`](api/scheme/base.md#parameterize)
[`partition`](api/srfi/1.md#partition)
[`partition!`](api/srfi/1.md#partition-1)
[`peek-char             `](api/primitives.md#peek-char)
[`port?                 `](api/primitives.md#port)
[`pos-in-list               `](api/scheme/cyclone/transforms.md#pos-in-list)
[`positive?`](api/scheme/base.md#positive)
[`precompute-prim-app?      `](api/scheme/cyclone/transforms.md#precompute-prim-app)
[`pretty-print`](api/scheme/cyclone/pretty-print.md#pretty-print)
[`prim:allocates-object?)`](api/scheme/cyclone/primitives.md#primallocates-object)
[`prim?`](api/scheme/cyclone/primitives.md#prim)
[`prim:arg-count?`](api/scheme/cyclone/primitives.md#primarg-count)
[`prim-call?`](api/scheme/cyclone/primitives.md#prim-call)
[`prim->c-func`](api/scheme/cyclone/primitives.md#prim-c-func)
[`prim:check-arg-count`](api/scheme/cyclone/primitives.md#primcheck-arg-count)
[`prim:cont?`](api/scheme/cyclone/primitives.md#primcont)
[`prim:cont/no-args?`](api/scheme/cyclone/primitives.md#primcontno-args)
[`prim/cvar?`](api/scheme/cyclone/primitives.md#primcvar)
[`prim/c-var-assign`](api/scheme/cyclone/primitives.md#primc-var-assign)
[`prim/data-arg?`](api/scheme/cyclone/primitives.md#primdata-arg)
[`prim:mutates?`](api/scheme/cyclone/primitives.md#primmutates)
[`procedure?            `](api/primitives.md#procedure)
[`promise?`](api/scheme/lazy.md#promise)
[`proper-list?`](api/srfi/1.md#proper-list)

- - -
[`*primitives*              `](api/scheme/cyclone/transforms.md#*primitives)

- - -
[`quasiquote`](api/scheme/base.md#quasiquote)
[`quote?                     `](api/scheme/cyclone/util.md#quote) 
[`quotient`](api/scheme/base.md#quotient)

- - -
[`raise`](api/scheme/base.md#raise)
[`raise-continuable`](api/scheme/base.md#raise-continuable)
[`random-integer`](api/srfi/27.md#random-integer)
[`random-real`](api/srfi/27.md#random-real)
[`random-source?`](api/srfi/27.md#random-source)
[`random-source-make-integers`](api/srfi/27.md#random-source-make-integers)
[`random-source-make-reals`](api/srfi/27.md#random-source-make-reals)
[`random-source-pseudo-randomize!`](api/srfi/27.md#random-source-pseudo-randomize)
[`random-source-randomize!`](api/srfi/27.md#random-source-randomize)
[`random-source-state-ref`](api/srfi/27.md#random-source-state-ref)
[`random-source-state-set!`](api/srfi/27.md#random-source-state-set)
[`rational?`](api/scheme/base.md#rational)
[`read-all`](api/scheme/read.md#read-all)
[`read`](api/scheme/read.md#read)
[`read-char             `](api/primitives.md#read-char)
[`read-line`](api/scheme/base.md#read-line)
[`read-string`](api/scheme/base.md#read-string)
[`real?                 `](api/primitives.md#real)
[`realized?`](api/cyclone/concurrent.md#realized)
[`real-part`](api/scheme/complex.md#real-part)
[`receive`](api/scheme/base.md#receive)
[`record?`](api/scheme/base.md#record)
[`reduce                    `](api/scheme/cyclone/transforms.md#reduce)
[`reduce`](api/srfi/1.md#reduce)
[`reduce-right`](api/srfi/1.md#reduce-right)
[`ref?                       `](api/scheme/cyclone/util.md#ref)
[`remainder`](api/scheme/base.md#remainder)
[`remove                    `](api/scheme/cyclone/transforms.md#remove)
[`remove`](api/srfi/1.md#remove)
[`remove!`](api/srfi/1.md#remove-1)
[`repl`](api/scheme/repl.md#repl)
[`reverse`](api/scheme/base.md#reverse)
[`reverse!`](api/srfi/1.md#reverse)
[`reverse-list->vector`](api/srfi/133.md#reverse-list-vector)
[`reverse-vector->generator`](api/srfi/121.md#reverse-vector-generator)
[`reverse-vector->list`](api/srfi/133.md#reverse-vector-list)
[`rotate-bit-field`](api/srfi/60.md#rotate-bit-field)
[`round`](api/scheme/base.md#round)

- - -
[`*shut-rd*`](api/srfi/106.md#shut-rd)
[`*shut-rdwr*`](api/srfi/106.md#shut-rdwr)
[`*shut-wr*`](api/srfi/106.md#shut-wr)
[`*sock-dgram*`](api/srfi/106.md#sock-dgram)
[`*sock-stream*`](api/srfi/106.md#sock-stream)

- - -
[`second`](api/srfi/1.md#second)
[`set-adjoin      `](api/srfi/113.md#set-adjoin)
[`set-adjoin!     `](api/srfi/113.md#set-adjoin-1)
[`set-any?  `](api/srfi/113.md#set-any)
[`set!?                      `](api/scheme/cyclone/util.md#set)
[`set           `](api/srfi/113.md#set)
[`set?         `](api/srfi/113.md#set-1)
[`set=? `](api/srfi/113.md#set-2)
[`set<? `](api/srfi/113.md#set-3)
[`set>? `](api/srfi/113.md#set-4)
[`set<=?`](api/srfi/113.md#set-5)
[`set>=?`](api/srfi/113.md#set-6)
[`set->bag           `](api/srfi/113.md#set-bag)
[`set->bag!          `](api/srfi/113.md#set-bag-1)
[`set-box!`](api/srfi/111.md#set-box)
[`set-car!              `](api/primitives.md#set-car)
[`set-cdr!              `](api/primitives.md#set-cdr)
[`set-cell!?                `](api/scheme/cyclone/transforms.md#set-cell)
[`set-cell!->cell           `](api/scheme/cyclone/transforms.md#set-cell-cell)
[`set-cell!->value          `](api/scheme/cyclone/transforms.md#set-cell-value)
[`set-comparator`](api/srfi/113.md#set-comparator)
[`set-contains? `](api/srfi/113.md#set-contains) 
[`set-copy  `](api/srfi/113.md#set-copy)
[`set-count `](api/srfi/113.md#set-count)
[`set-delete-all  `](api/srfi/113.md#set-delete-all)
[`set-delete-all! `](api/srfi/113.md#set-delete-all-1)
[`set-delete      `](api/srfi/113.md#set-delete)
[`set-delete!     `](api/srfi/113.md#set-delete-1)
[`set-difference   `](api/srfi/113.md#set-difference)
[`set-difference!  `](api/srfi/113.md#set-difference-1)
[`set-disjoint?`](api/srfi/113.md#set-disjoint)
[`set-element-comparator`](api/srfi/113.md#set-element-comparator)
[`set-empty?   `](api/srfi/113.md#set-empty) 
[`set-every?`](api/srfi/113.md#set-every)
[`set!->exp                  `](api/scheme/cyclone/util.md#set-exp)
[`set-filter    `](api/srfi/113.md#set-filter)
[`set-filter!   `](api/srfi/113.md#set-filter-1)
[`set-find  `](api/srfi/113.md#set-find)
[`set-fold      `](api/srfi/113.md#set-fold)
[`set-for-each  `](api/srfi/113.md#set-for-each)
[`set-intersection `](api/srfi/113.md#set-intersection)
[`set-intersection!`](api/srfi/113.md#set-intersection-1)
[`set->list `](api/srfi/113.md#set-list)
[`set-map       `](api/srfi/113.md#set-map)
[`set-member            `](api/srfi/113.md#set-member)
[`set-partition `](api/srfi/113.md#set-partition)
[`set-partition!`](api/srfi/113.md#set-partition-1)
[`set-remove    `](api/srfi/113.md#set-remove)
[`set-remove!   `](api/srfi/113.md#set-remove-1)
[`set-replace     `](api/srfi/113.md#set-replace)
[`set-replace!    `](api/srfi/113.md#set-replace-1)
[`set-search!     `](api/srfi/113.md#set-search)
[`set-size  `](api/srfi/113.md#set-size)
[`set-unfold    `](api/srfi/113.md#set-unfold)
[`set-union        `](api/srfi/113.md#set-union)
[`set-union!       `](api/srfi/113.md#set-union-1)
[`setup-environment`](api/scheme/eval.md#setup-environment)
[`set!->var                  `](api/scheme/cyclone/util.md#set-var)
[`set-xor          `](api/srfi/113.md#set-xor)
[`set-xor!         `](api/srfi/113.md#set-xor-1)
[`seventh`](api/srfi/1.md#seventh)
[`shared-delay?`](api/cyclone/concurrent.md#shared-delay)
[`shared-delay`](api/cyclone/concurrent.md#shared-delay-1)
[`shared-promise?`](api/cyclone/concurrent.md#shared-promise)
[`shared-queue-add!`](api/cyclone/concurrent.md#shared-queue-add)
[`shared-queue`](api/cyclone/concurrent.md#shared-queue)
[`shared-queue?`](api/cyclone/concurrent.md#shared-queue)
[`shared-queue-capacity`](api/cyclone/concurrent.md#shared-queue-capacity)
[`shared-queue-clear!`](api/cyclone/concurrent.md#shared-queue-clear)
[`shared-queue-empty?`](api/cyclone/concurrent.md#shared-queue-empty)
[`shared-queue-remove!`](api/cyclone/concurrent.md#shared-queue-remove)
[`shared-queue-size`](api/cyclone/concurrent.md#shared-queue-size)
[`shared-queue-wait-count`](api/cyclone/concurrent.md#shared-queue-wait-count)
[`shutdown-method`](api/srfi/106.md#shutdown-method)
[`simple-lambda?`](api/scheme/cyclone/cps-optimizations.md#simple-lambda)
[`sin`](api/scheme/inexact.md#sin)
[`sixth`](api/srfi/1.md#sixth)
[`slot-set!`](api/scheme/base.md#slot-set)
[`socket-accept`](api/srfi/106.md#socket-accept)
[`socket?`](api/srfi/106.md#socket)
[`socket-close`](api/srfi/106.md#socket-close)
[`socket-domain`](api/srfi/106.md#socket-domain)
[`socket-input-port`](api/srfi/106.md#socket-input-port)
[`socket-merge-flags`](api/srfi/106.md#socket-merge-flags)
[`socket-output-port`](api/srfi/106.md#socket-output-port)
[`socket-purge-flags`](api/srfi/106.md#socket-purge-flags)
[`socket-recv`](api/srfi/106.md#socket-recv)
[`socket-send`](api/srfi/106.md#socket-send)
[`socket-shutdown`](api/srfi/106.md#socket-shutdown)
[`span`](api/srfi/1.md#span)
[`span!`](api/srfi/1.md#span-1)
[`split-at`](api/srfi/1.md#split-at)
[`split-at!`](api/srfi/1.md#split-at-1)
[`sqrt`](api/scheme/inexact.md#sqrt)
[`square`](api/scheme/base.md#square)
[`string?               `](api/primitives.md#string)
[`string`](api/scheme/base.md#string)
[`string<=?`](api/scheme/base.md#string-1)
[`string<?`](api/scheme/base.md#string-2)
[`string=?`](api/scheme/base.md#string-3)
[`string>=?`](api/scheme/base.md#string-4)
[`string>?`](api/scheme/base.md#string-5)
[`string-append         `](api/primitives.md#string-append)
[`string-ci<=?`](api/scheme/char.md#string-ci)
[`string-ci<?`](api/scheme/char.md#string-ci-1)
[`string-ci=?`](api/scheme/char.md#string-ci-2)
[`string-ci>=?`](api/scheme/char.md#string-ci-3)
[`string-ci>?`](api/scheme/char.md#string-ci-4)
[`string-ci-hash                `](api/srfi/128.md#string-ci-hash)
[`string-ci-hash`](api/srfi/69.md#string-ci-hash)
[`string-cmp            `](api/primitives.md#string-cmp)
[`string-copy`](api/scheme/base.md#string-copy)
[`string-copy!`](api/scheme/base.md#string-copy-1)
[`string-downcase`](api/scheme/char.md#string-downcase)
[`string-fill!`](api/scheme/base.md#string-fill)
[`string-foldcase`](api/scheme/char.md#string-foldcase)
[`string-for-each`](api/scheme/base.md#string-for-each)
[`string->generator`](api/srfi/121.md#string-generator)
[`string-hash                   `](api/srfi/128.md#string-hash)
[`string-hash`](api/srfi/69.md#string-hash)
[`string-join                `](api/scheme/cyclone/util.md#string-join)
[`string-length         `](api/primitives.md#string-length)
[`string->list`](api/scheme/base.md#string-list)
[`string-map`](api/scheme/base.md#string-map)
[`string->number        `](api/primitives.md#string-number)
[`string-ref            `](api/primitives.md#string-ref)
[`string-replace-all         `](api/scheme/cyclone/util.md#string-replace-all)
[`string-set!           `](api/primitives.md#string-set)
[`string-split               `](api/scheme/cyclone/util.md#string-split)
[`string->symbol        `](api/primitives.md#string-symbol)
[`string-upcase`](api/scheme/char.md#string-upcase)
[`string->utf8`](api/scheme/base.md#string-utf8)
[`string->vector`](api/scheme/base.md#string-vector)
[`substring             `](api/primitives.md#substring)
[`swap!`](api/cyclone/concurrent.md#swap)
[`symbol?               `](api/primitives.md#symbol)
[`symbol=?`](api/scheme/base.md#symbol)
[`symbol<?                  `](api/scheme/cyclone/transforms.md#symbol)
[`symbol-hash                   `](api/srfi/128.md#symbol-hash)
[`symbol->string        `](api/primitives.md#symbol-string)
[`syntax-error`](api/scheme/base.md#syntax-error)
[`system                `](api/primitives.md#system)

- - -
[`*trace-level*             `](api/scheme/cyclone/transforms.md#*trace-level)

- - -
[`tagged-list?               `](api/scheme/cyclone/util.md#tagged-list?)
[`take                       `](api/scheme/cyclone/util.md#take)
[`take`](api/srfi/1.md#take)
[`take!`](api/srfi/1.md#take-1)
[`take-right`](api/srfi/1.md#take-right)
[`take-while`](api/srfi/1.md#take-while)
[`take-while!`](api/srfi/1.md#take-while-1)
[`tan`](api/scheme/inexact.md#tan)
[`tenth`](api/srfi/1.md#tenth)
[`test`](api/cyclone/test.md#test)
[`test-assert`](api/cyclone/test.md#test-assert)
[`test-begin`](api/cyclone/test.md#test-begin)
[`test-end`](api/cyclone/test.md#test-end)
[`test-equal`](api/cyclone/test.md#test-equal)
[`test-error`](api/cyclone/test.md#test-error)
[`test-exit`](api/cyclone/test.md#test-exit)
[`test-failure-count`](api/cyclone/test.md#test-failure-count)
[`test-group`](api/cyclone/test.md#test-group)
[`test-not`](api/cyclone/test.md#test-not)
[`test-propagate-info`](api/cyclone/test.md#test-propagate-info)
[`test-run`](api/cyclone/test.md#test-run)
[`test-values`](api/cyclone/test.md#test-values)
[`third`](api/srfi/1.md#third)
[`thread?`](api/srfi/18.md#thread)
[`thread-join!`](api/srfi/18.md#thread-join)
[`thread-name`](api/srfi/18.md#thread-name)
[`thread-pool?`](api/cyclone/concurrent.md#thread-pool-1)
[`thread-pool-idling?`](api/cyclone/concurrent.md#thread-pool-idling)
[`thread-pool-idling-count`](api/cyclone/concurrent.md#thread-pool-idling-count)
[`thread-pool-push-task!`](api/cyclone/concurrent.md#thread-pool-push-task)
[`thread-pool-release!`](api/cyclone/concurrent.md#thread-pool-release)
[`thread-pool-size`](api/cyclone/concurrent.md#thread-pool-size)
[`thread-sleep!`](api/srfi/18.md#thread-sleep)
[`thread-specific`](api/srfi/18.md#thread-specific)
[`thread-specific-set!`](api/srfi/18.md#thread-specific-set)
[`thread-start!`](api/srfi/18.md#thread-start)
[`thread-terminate!`](api/srfi/18.md#thread-terminate)
[`thread-yield!`](api/srfi/18.md#thread-yield)
[`trace                     `](api/scheme/cyclone/transforms.md#trace)
[`trace:debug               `](api/scheme/cyclone/transforms.md#tracedebug)
[`trace:error               `](api/scheme/cyclone/transforms.md#traceerror)
[`trace:info                `](api/scheme/cyclone/transforms.md#traceinfo)
[`trace:warn                `](api/scheme/cyclone/transforms.md#tracewarn)
[`truncate`](api/scheme/base.md#truncate)
[`truncate/`](api/scheme/base.md#truncate-1)
[`truncate-quotient`](api/scheme/base.md#truncate-quotient)
[`truncate-remainder`](api/scheme/base.md#truncate-remainder)
[`type-slot-offset`](api/scheme/base.md#type-slot-offset)

- - -
[`unbox`](api/srfi/111.md#unbox) 
[`unfold`](api/srfi/1.md#unfold)
[`unfold-right`](api/srfi/1.md#unfold-right)
[`union                     `](api/scheme/cyclone/transforms.md#union)
[`unless`](api/scheme/base.md#unless)
[`unzip1`](api/srfi/1.md#unzip1)
[`unzip2`](api/srfi/1.md#unzip2)
[`unzip3`](api/srfi/1.md#unzip3)
[`unzip4`](api/srfi/1.md#unzip4)
[`unzip5`](api/srfi/1.md#unzip5)
[`utf8->string`](api/scheme/base.md#utf8-string)

- - -
[`*version*`](api/scheme/cyclone/common.md#version)
[`*version-banner*`](api/scheme/cyclone/common.md#version-banner)
[`*version-name*`](api/scheme/cyclone/common.md#version-name)
[`*version-number*`](api/scheme/cyclone/common.md#version-number)

- - -
[`values`](api/scheme/base.md#values)
[`vector-any`](api/srfi/133.md#vector-any)
[`vector?               `](api/primitives.md#vector)
[`vector`](api/scheme/base.md#vector)
[`vector=`](api/srfi/133.md#vector)
[`vector-append`](api/scheme/base.md#vector-append)
[`vector-append-subvectors`](api/srfi/133.md#vector-append-subvectors)
[`vector-binary-search`](api/srfi/133.md#vector-binary-search)
[`vector-concatenate`](api/srfi/133.md#vector-concatenate)
[`vector-copy`](api/scheme/base.md#vector-copy)
[`vector-copy!`](api/scheme/base.md#vector-copy-1)
[`vector-count`](api/srfi/133.md#vector-count)
[`vector-cumulate`](api/srfi/133.md#vector-cumulate)
[`vector-delete-neighbor-dups`](api/srfi/132.md#vector-delete-neighbor-dups)
[`vector-delete-neighbor-dups!`](api/srfi/132.md#vector-delete-neighbor-dups-1)
[`vector-empty?`](api/srfi/133.md#vector-empty)
[`vector-every`](api/srfi/133.md#vector-every)
[`vector-fill!`](api/scheme/base.md#vector-fill)
[`vector-find-median`](api/srfi/132.md#vector-find-median)
[`vector-find-median!`](api/srfi/132.md#vector-find-median-1)
[`vector-fold`](api/srfi/133.md#vector-fold)
[`vector-fold-right`](api/srfi/133.md#vector-fold-right)
[`vector-for-each`](api/scheme/base.md#vector-for-each)
[`vector->generator`](api/srfi/121.md#vector-generator)
[`vector-index`](api/srfi/133.md#vector-index)
[`vector-index-right`](api/srfi/133.md#vector-index-right)
[`vector-length         `](api/primitives.md#vector-length)
[`vector->list`](api/scheme/base.md#vector-list)
[`vector-map`](api/scheme/base.md#vector-map)
[`vector-map!`](api/srfi/133.md#vector-map)
[`vector-merge`](api/srfi/132.md#vector-merge)
[`vector-merge!`](api/srfi/132.md#vector-merge-1)
[`vector-partition`](api/srfi/133.md#vector-partition)
[`vector-ref            `](api/primitives.md#vector-ref)
[`vector-reverse!`](api/srfi/133.md#vector-reverse) 
[`vector-reverse-copy`](api/srfi/133.md#vector-reverse-copy)
[`vector-reverse-copy!`](api/srfi/133.md#vector-reverse-copy)
[`vector-select!`](api/srfi/132.md#vector-select)
[`vector-separate!`](api/srfi/132.md#vector-separate)
[`vector-set!           `](api/primitives.md#vector-set)
[`vector-skip`](api/srfi/133.md#vector-skip)
[`vector-skip-right`](api/srfi/133.md#vector-skip-right)
[`vector-sort`](api/srfi/132.md#vector-sort)
[`vector-sort!`](api/srfi/132.md#vector-sort-1)
[`vector-sorted?`](api/srfi/132.md#vector-sorted)
[`vector-stable-sort`](api/srfi/132.md#vector-stable-sort)
[`vector-stable-sort!`](api/srfi/132.md#vector-stable-sort)
[`vector->string`](api/scheme/base.md#vector-string)
[`vector-swap!`](api/srfi/133.md#vector-swap)
[`vector-unfold`](api/srfi/133.md#vector-unfold)
[`vector-unfold!`](api/srfi/133.md#vector-unfold)
[`vector-unfold-right`](api/srfi/133.md#vector-unfold-right)
[`vector-unfold-right!`](api/srfi/133.md#vector-unfold-right)

- - -
[`when`](api/scheme/base.md#when)
[`with-exception-handler`](api/scheme/base.md#with-exception-handler)
[`with-handler`](api/scheme/base.md#with-handler)
[`with-input-from-file`](api/scheme/file.md#with-input-from-file)
[`with-output-to-file`](api/scheme/file.md#with-output-to-file)
[`wrap-mutables             `](api/scheme/cyclone/transforms.md#wrap-mutables)
[`write`](api/scheme/write.md#write)
[`write-char`](api/scheme/base.md#write-char)
[`write-shared`](api/scheme/write.md#write-shared)
[`write-simple`](api/scheme/write.md#write-simple)
[`write-string`](api/scheme/base.md#write-string)

- - -
[`xcons`](api/srfi/1.md#xcons)

- - -
[`zero?`](api/scheme/base.md#zero)
[`zip`](api/srfi/1.md#zip)
