/**
 * @license
 * Copyright 2019 The Emscripten Authors
 * SPDX-License-Identifier: MIT
 */

// wasm2js.js - enough of a polyfill for the WebAssembly object so that we can load
// wasm2js code that way.

// Emit "var WebAssembly" if definitely using wasm2js. Otherwise, in MAYBE_WASM2JS
// mode, we can't use a "var" since it would prevent normal wasm from working.
/** @suppress{duplicate, const} */
var
WebAssembly = {
  // Note that we do not use closure quoting (this['buffer'], etc.) on these
  // functions, as they are just meant for internal use. In other words, this is
  // not a fully general polyfill.
  /** @constructor */
  Memory: function(opts) {
    this.buffer = new ArrayBuffer(opts['initial'] * 65536);
  },

  Module: function(binary) {
    // TODO: use the binary and info somehow - right now the wasm2js output is embedded in
    // the main JS
  },

  /** @constructor */
  Instance: function(module, info) {
    // TODO: use the module somehow - right now the wasm2js output is embedded in
    // the main JS
    // This will be replaced by the actual wasm2js code.
    this.exports = (
// EMSCRIPTEN_START_ASM
function instantiate(Db){function c(d){d.set=function(a,b){this[a]=b};d.get=function(a){return this[a]};return d}var e;var f=new ArrayBuffer(16);var g=new Int32Array(f);var h=new Float32Array(f);var i=new Float64Array(f);function j(k){return g[k]}function l(k,m){g[k]=m}function n(){return i[0]}function o(m){i[0]=m}function p(){throw new Error("abort")}function q(){return h[2]}function r(m){h[2]=m}function Bb(Cb){var s=new ArrayBuffer(16777216);var t=new Int8Array(s);var u=new Int16Array(s);var v=new Int32Array(s);var w=new Uint8Array(s);var x=new Uint16Array(s);var y=new Uint32Array(s);var z=new Float32Array(s);var A=new Float64Array(s);var B=Math.imul;var C=Math.fround;var D=Math.abs;var E=Math.clz32;var F=Math.min;var G=Math.max;var H=Math.floor;var I=Math.ceil;var J=Math.trunc;var K=Math.sqrt;var L=Cb.a;var M=L.a;var N=L.b;var O=L.c;var P=L.d;var Q=L.e;var R=L.f;var S=L.g;var T=L.h;var U=L.i;var V=L.j;var W=L.k;var X=L.l;var Y=L.m;var Z=L.n;var _=L.o;var $=L.p;var aa=L.q;var ba=L.r;var ca=L.s;var da=L.t;var ea=L.u;var fa=L.v;var ga=L.w;var ha=L.x;var ia=L.y;var ja=L.z;var ka=L.A;var la=L.B;var ma=L.C;var na=L.D;var oa=L.E;var pa=L.F;var qa=L.G;var ra=L.H;var sa=L.I;var ta=L.J;var ua=L.K;var va=L.L;var wa=L.M;var xa=L.N;var ya=L.O;var za=L.P;var Aa=L.Q;var Ba=L.R;var Ca=L.S;var Da=L.T;var Ea=L.U;var Fa=L.V;var Ga=L.W;var Ha=L.X;var Ia=L.Y;var Ja=L.Z;var Ka=L._;var La=L.$;var Ma=L.aa;var Na=L.ba;var Oa=L.ca;var Pa=L.da;var Qa=L.ea;var Ra=L.fa;var Sa=L.ga;var Ta=L.ha;var Ua=L.ia;var Va=L.ja;var Wa=L.ka;var Xa=L.la;var Ya=L.ma;var Za=L.oa;var _a=L.pa;var $a=L.qa;var ab=L.ra;var bb=L.sa;var cb=L.ta;var db=L.ua;var eb=L.va;var fb=L.wa;var gb=L.xa;var hb=L.ya;var ib=L.za;var jb=L.Aa;var kb=L.Ba;var lb=L.Ca;var mb=L.Da;var nb=L.Ea;var ob=L.Fa;var pb=L.Ga;var qb=L.Ha;var rb=L.Ia;var sb=L.Ja;var tb=L.Ka;var ub=516880;var vb=0;var wb=0;var xb=0;var yb=0;
// EMSCRIPTEN_START_FUNCS
function sFa(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,x=0,y=0,z=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,fa=0,ha=0,ia=0,ja=0,ka=0,ma=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0;_=ub-32|0;ub=_;v[a+64>>2]=v[b+312>>2];v[a+328>>2]=v[b+288>>2];h=v[a+8>>2];zb[v[v[h>>2]+8>>2]](h);h=v[a+8>>2];zb[v[v[h>>2]+12>>2]](h);v[a+48>>2]=0;v[a+52>>2]=0;A[a+344>>3]=-A[48091];f=A[48091];v[a+340>>2]=0;v[a+16>>2]=0;v[a+20>>2]=0;v[a+24>>2]=0;v[a+28>>2]=0;v[a+32>>2]=0;v[a+36>>2]=0;v[a+40>>2]=0;A[a+352>>3]=-f;t[_+31|0]=1;y=v[a+220>>2];h=v[a+216>>2];a:{if((y-h|0)<=0){i=h;h=y;break a}if((h|0)==(y|0)){i=y}else{while(1){j=v[y-4>>2];b:{if(!j){break b}i=v[j+4>>2];v[j+4>>2]=i-1;if(i){break b}zb[v[v[j>>2]+8>>2]](j);se(j)}y=y-8|0;if((y|0)!=(h|0)){continue}break}i=v[a+216>>2]}v[a+220>>2]=h}if((h|0)!=(i|0)){while(1){y=v[h-4>>2];c:{if(!y){break c}j=v[y+4>>2];v[y+4>>2]=j-1;if(j){break c}zb[v[v[y>>2]+8>>2]](y);se(y)}h=h-8|0;if((i|0)!=(h|0)){continue}break}v[a+220>>2]=i}t[a+276|0]=0;d:{e:{f:{g:{h:{i:{j:{k:{l:{if(c<0){a=Ub(16);v[111924]=0;i=N(2255,_+16|0,211322)|0;b=v[111924];v[111924]=0;if((b|0)==1){break l}v[a>>2]=371744;h=a+4|0;m:{n:{if(t[i+11|0]>=0){b=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=b;v[h+8>>2]=v[i+8>>2];break n}g=v[i+4>>2];b=v[i>>2];v[111924]=0;R(2167,h|0,b|0,g|0);b=v[111924];v[111924]=0;h=1;if((b|0)==1){break m}}v[a>>2]=373744;h=0;v[111924]=0;R(2152,a|0,373724,2256);b=v[111924];v[111924]=0;if((b|0)!=1){break k}}b=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!h){break f}break h}if(d<0){a=Ub(16);v[111924]=0;i=N(2255,_+16|0,211431)|0;b=v[111924];v[111924]=0;if((b|0)==1){break j}v[a>>2]=371744;h=a+4|0;o:{p:{if(t[i+11|0]>=0){b=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=b;v[h+8>>2]=v[i+8>>2];break p}g=v[i+4>>2];b=v[i>>2];v[111924]=0;R(2167,h|0,b|0,g|0);b=v[111924];v[111924]=0;h=1;if((b|0)==1){break o}}v[a>>2]=373744;h=0;v[111924]=0;R(2152,a|0,373724,2256);b=v[111924];v[111924]=0;if((b|0)!=1){break k}}b=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!h){break f}break h}if(e<0){a=Ub(16);v[111924]=0;i=N(2255,_+16|0,211380)|0;b=v[111924];v[111924]=0;if((b|0)==1){break i}v[a>>2]=371744;h=a+4|0;q:{r:{if(t[i+11|0]>=0){b=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=b;v[h+8>>2]=v[i+8>>2];break r}g=v[i+4>>2];b=v[i>>2];v[111924]=0;R(2167,h|0,b|0,g|0);b=v[111924];v[111924]=0;h=1;if((b|0)==1){break q}}v[a>>2]=373744;h=0;v[111924]=0;R(2152,a|0,373724,2256);b=v[111924];v[111924]=0;if((b|0)!=1){break k}}b=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!h){break f}break h}A[a+296>>3]=e;A[a+288>>3]=d;A[a+280>>3]=c;i=v[a+64>>2];if(!i){break d}h=v[i+4>>2];if((h|0)<4){break d}v[_+12>>2]=h;v[_+16>>2]=4;zb[v[v[i>>2]+8>>2]](i,_+16|0);j=0;i=0;y=0;if(v[b+40>>2]<=0){break g}h=0;while(1){l=h<<3;k=v[b+80>>2];c=A[48091];s:{if(!(A[l+k>>3]>-c)){break s}d=c;c=A[l+v[b+92>>2]>>3];if(!(d>c)){break s}if(A[53482]>=D(A[k+l>>3]-c)){y=y+1|0;break s}i=i+1|0}h=h+1|0;if((h|0)<v[b+40>>2]){continue}break}break g}b=M()|0;break h}p()}b=M()|0;break h}b=M()|0}ac(a);P(b|0);p()}if(v[b+184>>2]>0){h=0;while(1){k=h<<3;c=A[48091];j=!(A[k+v[b+224>>2]>>3]>-c)|!(c>A[k+v[b+236>>2]>>3])?j:j+1|0;h=h+1|0;if((h|0)<v[b+184>>2]){continue}break}}k=v[a+64>>2];Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],247071,7);pd(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],y);Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],253598,12);pd(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],i);Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],253558,14);pd(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],j);Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],42464,14);h=_+16|0;y=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];i=v[(v[v[y>>2]-12>>2]+y|0)+28>>2];v[h>>2]=i;v[i+4>>2]=v[i+4>>2]+1;v[111924]=0;i=N(1122,h|0,448956)|0;h=v[111924];v[111924]=0;if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break e}}b=M()|0;g=v[_+16>>2];a=v[g+4>>2]-1|0;v[g+4>>2]=a;if((a|0)==-1){zb[v[v[g>>2]+8>>2]](g)}}P(b|0);p()}j=v[_+16>>2];h=v[j+4>>2]-1|0;v[j+4>>2]=h;if((h|0)==-1){zb[v[v[j>>2]+8>>2]](j)}bc(y,i);$b(y);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,_+12|0)}t:{u:{if(v[a+308>>2]>=17){v[a+304>>2]=17;break u}v[a+304>>2]=17;c=A[a+320>>3]*17;v:{if(D(c)<2147483648){h=~~c;break v}h=-2147483648}h=(h|0)<=17?17:h;v[a+308>>2]=h;Uc(a+312|0,h);if(v[a+304>>2]<=0){break t}}i=v[a+312>>2];h=0;while(1){v[i+(h<<2)>>2]=0;h=h+1|0;if((h|0)<v[a+304>>2]){continue}break}}v[a+336>>2]=0;G=ub+-64|0;ub=G;w:{x:{y:{y=v[b+40>>2];if((y|0)>0){q=a+216|0;k=G+24|0;while(1){l=v[b+104>>2];h=y-1|0;j=h<<3;z:{if(A[l+j>>3]==0){break z}n=bd(24);i=v[b+184>>2];v[n+12>>2]=v[b+40>>2];v[n+8>>2]=i;v[n+4>>2]=94728;v[n+20>>2]=i;v[n+16>>2]=h;v[n>>2]=374416;v[111924]=0;v[G+56>>2]=n;r=S(2157,16)|0;i=v[111924];v[111924]=0;if((i|0)==1){a=M()|0;Gb(n);break w}v[r+12>>2]=n;v[r+4>>2]=0;v[r+8>>2]=0;v[r>>2]=374564;v[G+60>>2]=r;i=v[a+220>>2];A:{if((i|0)!=v[a+224>>2]){v[i+4>>2]=r;v[i>>2]=n;v[r+4>>2]=v[r+4>>2]+1;v[a+220>>2]=i+8;break A}v[111924]=0;O(2441,q|0,G+56|0);i=v[111924];v[111924]=0;if((i|0)==1){break y}l=v[b+104>>2]}c=A[j+l>>3];A[G+48>>3]=v[b+288>>2]==-1?-c:c;A[G+40>>3]=-A[j+v[b+92>>2]>>3];v[G+32>>2]=h;v[G+8>>2]=k;v[G+24>>2]=0;v[G+28>>2]=1072693248;v[G+12>>2]=1;v[G+16>>2]=1;A[G>>3]=-A[j+v[b+80>>2]>>3];i=v[v[b>>2]+40>>2];v[111924]=0;j=G+48|0;l=G+8|0;la(i|0,b|0,j|0,G+40|0,l|0,G|0,0);i=v[111924];v[111924]=0;if((i|0)==1){break y}v[G+8>>2]=0;v[G+12>>2]=0;v[G+48>>2]=0;v[G+52>>2]=0;i=v[v[b>>2]+224>>2];v[111924]=0;da(i|0,b|0,h|0,l|0,j|0,0);i=v[111924];v[111924]=0;if((i|0)==1){break y}v[G+8>>2]=0;v[G+12>>2]=0;i=v[v[b>>2]+236>>2];v[111924]=0;W(i|0,b|0,h|0,l|0,0);i=v[111924];v[111924]=0;if((i|0)==1){break y}v[a+336>>2]=v[a+336>>2]+1;j=v[G+60>>2];if(!j){break z}i=v[j+4>>2];v[j+4>>2]=i-1;if(i){break z}zb[v[v[j>>2]+8>>2]](j);se(j)}i=y>>>0>1;y=h;if(i){continue}break}}ub=G- -64|0;break x}a=M()|0;Sf(G+56|0);break w}j=a+68|0;k=v[b+184>>2];i=v[a+72>>2];h=v[a+68>>2];y=i-h>>3;B:{if((k|0)>(y|0)){v[_+16>>2]=0;v[_+20>>2]=0;fe(j,i,k-y|0,_+16|0);break B}if(k>>>0>y>>>0){Jd(j,k-y|0);break B}if(k>>>0>=y>>>0){break B}v[a+72>>2]=h+(k<<3)}j=a+80|0;k=v[b+40>>2];i=v[a+84>>2];h=v[a+80>>2];y=i-h>>3;C:{if((k|0)>(y|0)){v[_+16>>2]=0;v[_+20>>2]=0;fe(j,i,k-y|0,_+16|0);break C}if(k>>>0>y>>>0){Jd(j,k-y|0);break C}if(k>>>0>=y>>>0){break C}v[a+84>>2]=h+(k<<3)}j=a+92|0;k=v[b+40>>2];i=v[a+96>>2];h=v[a+92>>2];y=i-h>>3;D:{if((k|0)>(y|0)){v[_+16>>2]=0;v[_+20>>2]=0;fe(j,i,k-y|0,_+16|0);break D}if(k>>>0>y>>>0){Jd(j,k-y|0);break D}if(k>>>0>=y>>>0){break D}v[a+96>>2]=h+(k<<3)}j=a+104|0;k=v[b+184>>2];i=v[a+108>>2];h=v[a+104>>2];y=i-h>>3;E:{if((k|0)>(y|0)){v[_+16>>2]=0;v[_+20>>2]=0;fe(j,i,k-y|0,_+16|0);break E}if(k>>>0>y>>>0){Jd(j,k-y|0);break E}if(k>>>0>=y>>>0){break E}v[a+108>>2]=h+(k<<3)}j=v[a+124>>2];y=v[b+184>>2];F:{if((j|0)<(y|0)){i=(y|0)<0;c=A[a+136>>3]*+(y|0);G:{if(D(c)<2147483648){h=~~c;break G}h=-2147483648}if(!i){v[a+120>>2]=y}h=(h|0)>(y|0)?h:y;i=(h|0)<=1?1:h;if((i|0)==(j|0)){break F}v[a+124>>2]=i;h=a+128|0;if(v[a+120>>2]<=0){Gb(v[a+128>>2]);v[a+128>>2]=0;Mc(h,v[a+124>>2]);break F}Uc(h,i);break F}if((y|0)<0){v[a+120>>2]=0;break F}v[a+120>>2]=y}j=v[a+148>>2];y=v[b+40>>2];H:{if((j|0)<(y|0)){i=(y|0)<0;c=A[a+160>>3]*+(y|0);I:{if(D(c)<2147483648){h=~~c;break I}h=-2147483648}if(!i){v[a+144>>2]=y}h=(h|0)>(y|0)?h:y;i=(h|0)<=1?1:h;if((i|0)==(j|0)){break H}v[a+148>>2]=i;h=a+152|0;if(v[a+144>>2]<=0){Gb(v[a+152>>2]);v[a+152>>2]=0;Mc(h,v[a+148>>2]);break H}Uc(h,i);break H}if((y|0)<0){v[a+144>>2]=0;break H}v[a+144>>2]=y}j=v[a+172>>2];y=v[b+184>>2];J:{if((j|0)<(y|0)){i=(y|0)<0;c=A[a+184>>3]*+(y|0);K:{if(D(c)<2147483648){h=~~c;break K}h=-2147483648}if(!i){v[a+168>>2]=y}h=(h|0)>(y|0)?h:y;i=(h|0)<=1?1:h;if((i|0)==(j|0)){break J}v[a+172>>2]=i;h=a+176|0;if(v[a+168>>2]<=0){Gb(v[a+176>>2]);v[a+176>>2]=0;Mc(h,v[a+172>>2]);break J}Uc(h,i);break J}if((y|0)<0){v[a+168>>2]=0;break J}v[a+168>>2]=y}j=v[a+196>>2];y=v[b+40>>2];L:{if((j|0)<(y|0)){i=(y|0)<0;c=A[a+208>>3]*+(y|0);M:{if(D(c)<2147483648){h=~~c;break M}h=-2147483648}if(!i){v[a+192>>2]=y}h=(h|0)>(y|0)?h:y;i=(h|0)<=1?1:h;if((i|0)==(j|0)){break L}v[a+196>>2]=i;h=a+200|0;if(v[a+192>>2]<=0){Gb(v[a+200>>2]);v[a+200>>2]=0;Mc(h,v[a+196>>2]);break L}Uc(h,i);break L}if((y|0)<0){v[a+192>>2]=0;break L}v[a+192>>2]=y}y=v[b+40>>2];h=v[a+232>>2];i=v[a+228>>2];j=(h-i|0)/20|0;N:{if(y>>>0>j>>>0){Ny(a+228|0,y-j|0);break N}if(j>>>0<=y>>>0){break N}i=i+B(y,20)|0;if((i|0)!=(h|0)){while(1){h=h-20|0;zb[v[v[h>>2]>>2]](h)|0;if((h|0)!=(i|0)){continue}break}}v[a+232>>2]=i}y=v[b+184>>2];h=v[a+244>>2];i=v[a+240>>2];j=(h-i|0)/20|0;O:{if(y>>>0>j>>>0){Ny(a+240|0,y-j|0);break O}if(j>>>0<=y>>>0){break O}i=i+B(y,20)|0;if((i|0)!=(h|0)){while(1){h=h-20|0;zb[v[v[h>>2]>>2]](h)|0;if((h|0)!=(i|0)){continue}break}}v[a+244>>2]=i}y=v[b+40>>2];h=v[a+256>>2];i=v[a+252>>2];j=(h-i|0)/20|0;P:{if(y>>>0>j>>>0){Ny(a+252|0,y-j|0);break P}if(j>>>0<=y>>>0){break P}i=i+B(y,20)|0;if((i|0)!=(h|0)){while(1){h=h-20|0;zb[v[v[h>>2]>>2]](h)|0;if((h|0)!=(i|0)){continue}break}}v[a+256>>2]=i}y=v[b+184>>2];h=v[a+268>>2];i=v[a+264>>2];j=(h-i|0)/20|0;Q:{if(y>>>0>j>>>0){Ny(a+264|0,y-j|0);break Q}if(j>>>0<=y>>>0){break Q}i=i+B(y,20)|0;if((i|0)!=(h|0)){while(1){h=h-20|0;zb[v[v[h>>2]>>2]](h)|0;if((h|0)!=(i|0)){continue}break}}v[a+268>>2]=i}t[a+332|0]=g;if(v[b+40>>2]>0){i=v[a+200>>2];h=0;while(1){v[i+(h<<2)>>2]=h;h=h+1|0;if((h|0)<v[b+40>>2]){continue}break}}if(v[b+184>>2]>0){i=v[a+176>>2];h=0;while(1){v[i+(h<<2)>>2]=h;h=h+1|0;if((h|0)<v[b+184>>2]){continue}break}}j=0;l=0;J=ub-16|0;ub=J;d=A[a+288>>3];z=A[a+280>>3];K=A[48091]/5;R:{h=v[b+40>>2];if((h|0)<=0){break R}q=a+216|0;f=-K;S:{while(1){i=h;h=h-1|0;y=h<<3;F=A[y+v[b+80>>2]>>3];T:{U:{if(!(F==0|!(A[a+280>>3]>=D(F)))){v[J+8>>2]=0;v[J+12>>2]=0;break U}e=A[48091];c=-e;if(!(!(c<F)|!(f>F))){A[J+8>>3]=c;break U}if(!(e>F)|!(F>K)){break T}A[J+8>>3]=e}zb[v[v[b>>2]+200>>2]](b,h,J+8|0,0);j=j+1|0}F=A[y+v[b+92>>2]>>3];V:{W:{if(!(F==0|!(A[a+280>>3]>=D(F)))){v[J+8>>2]=0;v[J+12>>2]=0;break W}e=A[48091];c=-e;if(!(!(c<F)|!(f>F))){A[J+8>>3]=c;break W}if(!(e>F)|!(F>K)){break V}A[J+8>>3]=e}zb[v[v[b>>2]+212>>2]](b,h,J+8|0,0);j=j+1|0}X:{c=A[48091];if(!(!(A[y+v[b+80>>2]>>3]<=-c)|!(c<=A[y+v[b+92>>2]>>3]))){k=bd(56);v[111924]=0;r=Q(2442,k|0,b|0,h|0)|0;y=v[111924];v[111924]=0;if((y|0)==1){break X}v[111924]=0;v[J+8>>2]=r;y=S(2157,16)|0;k=v[111924];v[111924]=0;if((k|0)==1){a=M()|0;zb[v[v[r>>2]+4>>2]](r);break w}v[y+12>>2]=r;v[y+4>>2]=0;v[y+8>>2]=0;v[y>>2]=374952;v[J+12>>2]=y;k=v[a+220>>2];Y:{if((k|0)!=v[a+224>>2]){v[k+4>>2]=y;v[k>>2]=r;v[y+4>>2]=v[y+4>>2]+1;v[a+220>>2]=k+8;break Y}v[111924]=0;O(2441,q|0,J+8|0);y=v[111924];v[111924]=0;if((y|0)==1){break S}}y=v[a+200>>2];v[y+(h<<2)>>2]=v[(y+(v[b+40>>2]<<2)|0)-4>>2];y=v[v[b>>2]+56>>2];v[111924]=0;O(y|0,b|0,h|0);y=v[111924];v[111924]=0;if((y|0)==1){break S}y=v[a+312>>2];v[y+4>>2]=v[y+4>>2]+1;k=v[J+12>>2];Z:{if(!k){break Z}y=v[k+4>>2];v[k+4>>2]=y-1;if(y){break Z}zb[v[v[k>>2]+8>>2]](k);se(k)}l=l+1|0}if(i>>>0>1){continue}break R}break}a=M()|0;Gb(k);break w}a=M()|0;Sf(J+8|0);break w}y=0;_:{$:{if(v[b+184>>2]>0){c=d*.01;e=c<z?z:c;f=-K;k=0;while(1){x=k<<3;F=A[x+v[b+224>>2]>>3];aa:{ba:{if(!(F==0|!(A[a+280>>3]>=D(F)))){v[J+8>>2]=0;v[J+12>>2]=0;break ba}d=A[48091];c=-d;if(!(!(c<F)|!(f>F))){A[J+8>>3]=c;break ba}if(!(d>F)|!(F>K)){break aa}A[J+8>>3]=d}zb[v[v[b>>2]+164>>2]](b,k,J+8|0,0);y=y+1|0}z=A[x+v[b+236>>2]>>3];ca:{da:{if(!(z==0|!(A[a+280>>3]>=D(z)))){v[J+8>>2]=0;v[J+12>>2]=0;break da}d=A[48091];c=-d;if(!(!(c<z)|!(f>z))){A[J+8>>3]=c;break da}if(!(d>z)|!(z>K)){break ca}A[J+8>>3]=d}zb[v[v[b>>2]+176>>2]](b,k,J+8|0,0);y=y+1|0}ea:{if(!(A[53482]<D(F-z))){break ea}s=v[b+168>>2]+B(v[(x+v[b+172>>2]|0)+4>>2],24)|0;if(v[s+8>>2]<=0){break ea}d=D(F);c=D(z);c=c<d?d:c;c=c<1?1:c;Z=0;while(1){q=Z<<4;h=q+v[s>>2]|0;d=D(A[h>>3]);fa:{if(e>=D(c*d)){G=v[b+24>>2]+B(v[(v[b+28>>2]+(v[h+8>>2]<<3)|0)+4>>2],24)|0;n=v[G>>2];ga:{if(!n){break ga}h=0;r=v[G+8>>2];if((r|0)<=0){break ga}while(1){i=n+(h<<4)|0;if(v[i+8>>2]!=(k|0)){h=h+1|0;if((r|0)!=(h|0)){continue}break ga}break}r=r-1|0;v[G+8>>2]=r;if((h|0)>=(r|0)){break ga}r=n+(r<<4)|0;h=v[r+4>>2];v[i>>2]=v[r>>2];v[i+4>>2]=h;v[i+8>>2]=v[r+8>>2]}h=v[s+8>>2]-1|0;v[s+8>>2]=h;if((h|0)>(Z|0)){i=h<<4;h=v[s>>2];r=i+h|0;i=h+q|0;h=v[r+4>>2];v[i>>2]=v[r>>2];v[i+4>>2]=h;v[i+8>>2]=v[r+8>>2]}E=E+1|0;break fa}ha:{if(d>K){q=v[a+64>>2];if(!q){break ha}h=v[q+4>>2];if((h|0)<=0){break ha}v[J+4>>2]=h;v[J+8>>2]=1;i=J+8|0;zb[v[v[q>>2]+8>>2]](q,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],246851,41);qd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],d);r=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[r>>2]-12>>2]+r|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;ia:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break ia}}break $}q=v[J+8>>2];h=v[q+4>>2]-1|0;v[q+4>>2]=h;if((h|0)==-1){zb[v[v[q>>2]+8>>2]](q)}bc(r,i);$b(r);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,J+4|0);break ha}if(!(d<=e)){break ha}q=v[a+64>>2];if(!q){break ha}h=v[q+4>>2];if((h|0)<=0){break ha}v[J+4>>2]=h;v[J+8>>2]=1;i=J+8|0;zb[v[v[q>>2]+8>>2]](q,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],246808,42);qd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],d);r=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[r>>2]-12>>2]+r|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;ja:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break ja}}break $}q=v[J+8>>2];h=v[q+4>>2]-1|0;v[q+4>>2]=h;if((h|0)==-1){zb[v[v[q>>2]+8>>2]](q)}bc(r,i);$b(r);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,J+4|0)}Z=Z+1|0}if(v[s+8>>2]>(Z|0)){continue}break}}c=A[x+v[b+248>>2]>>3];z=v[b+288>>2]==-1?-c:c;ka:{la:{if(!(z==0|!(A[a+280>>3]>=D(c)))){v[J+8>>2]=0;v[J+12>>2]=0;break la}d=A[48091];c=-d;if(!(!(c<z)|!(f>z))){A[J+8>>3]=c;break la}if(!(d>z)|!(z>K)){break ka}A[J+8>>3]=d}zb[v[v[b>>2]+140>>2]](b,k,J+8|0,0);H=H+1|0}k=k+1|0;if((k|0)<v[b+184>>2]){continue}break}}ma:{if(((((j+l|0)+H|0)+y|0)+E|0)<=0){break ma}v[a+16>>2]=v[a+16>>2]+l;v[a+24>>2]=v[a+24>>2]+E;v[a+32>>2]=v[a+32>>2]+j;v[a+28>>2]=v[a+28>>2]+y;k=v[a+64>>2];if(!k){break ma}h=v[k+4>>2];if((h|0)<4){break ma}v[J+4>>2]=h;v[J+8>>2]=4;i=J+8|0;zb[v[v[k>>2]+8>>2]](k,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],249043,30);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],l);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253565,7);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],E);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253585,12);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],y);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253668,13);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],j);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253637,13);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],H);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],31731,23);y=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[y>>2]-12>>2]+y|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;na:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break na}}break $}j=v[J+8>>2];h=v[j+4>>2]-1|0;v[j+4>>2]=h;if((h|0)==-1){zb[v[v[j>>2]+8>>2]](j)}bc(y,i);$b(y);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,J+4|0)}ub=J+16|0;break _}a=M()|0;g=v[J+8>>2];b=v[g+4>>2]-1|0;v[g+4>>2]=b;if((b|0)==-1){zb[v[v[g>>2]+8>>2]](g)}break w}h=v[a+340>>2];j=!h;oa:{pa:{qa:{ra:{sa:{if(h|!w[_+31|0]){break sa}y=0;while(1){y=y+1|0;ta:{ua:{va:{wa:{xa:{j=v[a+64>>2];if(!j){break xa}h=v[j+4>>2];if((h|0)<5){break xa}v[_+12>>2]=h;v[_+16>>2]=5;i=_+16|0;zb[v[v[j>>2]+8>>2]](j,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],248834,6);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],y);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],202080,1);k=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[k>>2]-12>>2]+k|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break wa}}break oa}t[_+31|0]=0;break va}j=v[_+16>>2];h=v[j+4>>2]-1|0;v[j+4>>2]=h;if((h|0)==-1){zb[v[v[j>>2]+8>>2]](j)}bc(k,i);$b(k);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,_+12|0);h=v[a+340>>2];t[_+31|0]=0;if(h){break ua}}l=0;H=0;oa=0;fa=0;ka=0;pa=0;G=0;C=ub+-64|0;ub=C;ba=v[b+40>>2];j=ba-1|0;v[C+60>>2]=j;ya:{za:{Aa:{Ba:{Ca:{if((ba|0)<=0){break Ca}m=a+216|0;ca=C+40|0;while(1){i=0;k=0;E=0;c=0;d=0;x=v[b+24>>2]+B(v[(v[b+28>>2]+(j<<3)|0)+4>>2],24)|0;Da:{if(v[x+8>>2]<=0){break Da}while(1){h=v[x>>2]+(i<<4)|0;j=v[h+8>>2];f=A[h>>3];Ea:{if(D(f)>1/A[48091]){break Ea}q=v[a+64>>2];if(!q){break Ea}h=v[q+4>>2];if((h|0)<=0){break Ea}v[C+32>>2]=h;v[C+20>>2]=1;zb[v[v[q>>2]+8>>2]](q,C+20|0);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],246893,34);qd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],f);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],246599,8);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[C+60>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],365309,1);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,C+32|0)}Fa:{if(f>0){h=j<<3;e=A[48091];Ga:{if(A[h+v[b+224>>2]>>3]<=-e){E=E+1|0;break Ga}d=f*A[h+v[b+224>>2]>>3]+d}if(e<=A[h+v[b+236>>2]>>3]){k=k+1|0;break Fa}c=f*A[h+v[b+236>>2]>>3]+c;break Fa}if(!(f<0)){break Fa}h=j<<3;e=A[48091];Ha:{if(A[h+v[b+224>>2]>>3]<=-e){k=k+1|0;break Ha}c=f*A[h+v[b+224>>2]>>3]+c}if(e<=A[h+v[b+236>>2]>>3]){E=E+1|0;break Fa}d=f*A[h+v[b+236>>2]>>3]+d}i=i+1|0;h=v[x+8>>2];if((i|0)<(h|0)){continue}break}if(!((k|0)<2|(E|0)<2)){break Da}i=0;if((h|0)<=0){break Da}while(1){h=v[x>>2]+(i<<4)|0;j=v[h+8>>2];Ia:{Ja:{aa=A[h>>3];if(aa>0){L=0;$=A[48091];e=-$;F=A[v[b+80>>2]+(v[C+60>>2]<<3)>>3];Ka:{if(!(e<F)){break Ka}h=j<<3;if(!(e<A[h+v[b+224>>2]>>3])|(k|0)>1){break Ka}f=A[a+288>>3];z=D(F);K=D(c);Z=z>K;e=Z?z:K;if(!(f<D((F-c)/(e>1?e:1)))|!(A[53482]<D(F/(K>1?K:1)))){break Ka}ia=F;e=Z?z:K;F=e<1?1:e;e=ia/F-c/F;K=-f;z=A[h+v[b+236>>2]>>3];e=F*(A[a+280>>3]>=D(e)?0:e)/aa;f=z+e;La:{if(!k){break La}f=-$;if(!(z>=$)){break La}f=e}F=A[a+280>>3]>=D(f)?0:f;z=D(F);f=A[h+v[b+224>>2]>>3];e=D(f);e=e<z?z:e;L=(F-f)/(e>1?e:1)>K}sa=0;e=A[48091];z=A[v[b+92>>2]+(v[C+60>>2]<<3)>>3];Ma:{if(!(e>z)){break Ma}h=j<<3;if(!(e>A[h+v[b+236>>2]>>3])|(E|0)>1){break Ma}f=D(z);F=D(d);Z=f>F;e=Z?f:F;if(!(A[a+288>>3]<D((z-d)/(e>1?e:1)))|!(A[53482]<D(z/(F>1?F:1)))){break Ma}e=Z?f:F;F=e<1?1:e;e=z/F-d/F;z=A[a+280>>3]>=D(e)?0:e;e=A[h+v[b+224>>2]>>3];Na:{if(!E){f=e+F*z/aa;break Na}f=A[48091];if(!(e<=-f)){break Na}f=F*z/aa}F=A[a+280>>3]>=D(f)?0:f;z=D(F);f=A[h+v[b+236>>2]>>3];e=D(f);e=e<z?z:e;sa=A[a+288>>3]>=(F-f)/(e>1?e:1)}Oa:{if(!L){break Oa}e=A[48091];h=j<<3;if(w[a+332|0]?e<=A[h+v[b+236>>2]>>3]|sa:1){E=E+1|0;d=d-aa*A[h+v[b+224>>2]>>3];A[C+32>>3]=-e;zb[v[v[b>>2]+164>>2]](b,j,C+32|0,0);H=H+1|0;break Oa}oa=oa+1|0}if(!sa){break Ia}h=j<<3;e=A[48091];if(!(w[a+332|0]?A[h+v[b+224>>2]>>3]<=-e|L:1)){break Ja}k=k+1|0;c=c-aa*A[h+v[b+236>>2]>>3];A[C+32>>3]=e;zb[v[v[b>>2]+176>>2]](b,j,C+32|0,0);H=H+1|0;break Ia}if(!(aa<0)){break Ia}L=0;z=A[v[b+80>>2]+(v[C+60>>2]<<3)>>3];e=A[48091];Pa:{if(!(z>-e)){break Pa}h=j<<3;if(!(e>A[h+v[b+236>>2]>>3])|(k|0)>1){break Pa}f=D(z);F=D(c);Z=f>F;e=Z?f:F;if(!(A[a+288>>3]<D((z-c)/(e>1?e:1)))|!(A[53482]<D(z/(F>1?F:1)))){break Pa}e=Z?f:F;F=e<1?1:e;e=z/F-c/F;z=A[a+280>>3]>=D(e)?0:e;e=A[h+v[b+224>>2]>>3];Qa:{if(!k){f=e+F*z/aa;break Qa}f=A[48091];if(!(e<=-f)){break Qa}f=F*z/aa}F=A[a+280>>3]>=D(f)?0:f;z=D(F);f=A[h+v[b+236>>2]>>3];e=D(f);e=e<z?z:e;L=A[a+288>>3]>=(F-f)/(e>1?e:1)}sa=0;$=A[48091];e=$;F=A[v[b+92>>2]+(v[C+60>>2]<<3)>>3];Ra:{if(!(e>F)){break Ra}h=j<<3;if(!(A[h+v[b+224>>2]>>3]>-e)|(E|0)>1){break Ra}z=D(F);K=D(d);Z=z>K;e=Z?z:K;if(!(A[a+288>>3]<D((F-d)/(e>1?e:1)))){break Ra}f=A[53482];if(!(f<D(F/(K>1?K:1)))){break Ra}ia=F;e=Z?z:K;F=e<1?1:e;e=ia/F-d/F;K=-f;z=A[h+v[b+236>>2]>>3];e=F*(A[a+280>>3]>=D(e)?0:e)/aa;f=z+e;Sa:{if(!E){break Sa}f=-$;if(!(z>=$)){break Sa}f=e}F=A[a+280>>3]>=D(f)?0:f;z=D(F);f=A[h+v[b+224>>2]>>3];e=D(f);e=e<z?z:e;sa=(F-f)/(e>1?e:1)>K}Ta:{if(!L){break Ta}h=j<<3;e=A[48091];if(w[a+332|0]?A[h+v[b+224>>2]>>3]<=-e|sa:1){E=E+1|0;d=d-aa*A[h+v[b+236>>2]>>3];A[C+32>>3]=e;zb[v[v[b>>2]+176>>2]](b,j,C+32|0,0);H=H+1|0;break Ta}oa=oa+1|0}if(!sa){break Ia}e=A[48091];h=j<<3;if(!(w[a+332|0]?e<=A[h+v[b+236>>2]>>3]|L:1)){break Ja}k=k+1|0;c=c-aa*A[h+v[b+224>>2]>>3];A[C+32>>3]=-e;zb[v[v[b>>2]+164>>2]](b,j,C+32|0,0);H=H+1|0;break Ia}oa=oa+1|0}i=i+1|0;if((i|0)<v[x+8>>2]){continue}break}}Z=0;h=v[b+80>>2];j=v[C+60>>2];F=A[48091];if(!(E|!(A[h+(j<<3)>>3]>-F))){z=D(d);f=A[h+(j<<3)>>3];e=D(f);e=e<z?z:e;Z=-A[a+288>>3]<(d-f)/(e>1?e:1)}i=0;h=v[b+92>>2];if(!(k|!(F>A[h+(j<<3)>>3]))){z=D(c);f=A[h+(v[C+60>>2]<<3)>>3];e=D(f);e=e<z?z:e;i=A[a+288>>3]>=(c-f)/(e>1?e:1)}Ua:{if(!Z){break Ua}if(w[a+332|0]?F<=A[v[b+92>>2]+(v[C+60>>2]<<3)>>3]|i:1){h=v[C+60>>2];A[C+32>>3]=-F;zb[v[v[b>>2]+200>>2]](b,h,C+32|0,0);ka=ka+1|0;break Ua}pa=pa+1|0}Va:{if(!i){break Va}e=A[48091];if(w[a+332|0]?A[v[b+80>>2]+(v[C+60>>2]<<3)>>3]<=-e|Z:1){h=v[C+60>>2];A[C+32>>3]=e;zb[v[v[b>>2]+212>>2]](b,h,C+32|0,0);ka=ka+1|0;break Va}pa=pa+1|0}i=v[C+60>>2]<<3;h=v[b+92>>2];F=A[i+h>>3];ia=D(F);aa=A[i+v[b+80>>2]>>3];K=D(aa);e=K<ia?ia:K;Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{z=A[a+288>>3];f=-z;if(f>=(F-aa)/(e>1?e:1)){break cb}$=D(c);e=K<$?$:K;if(!k&f>=(c-aa)/(e>1?e:1)){break cb}K=D(d);e=K>ia?K:ia;if(!E&z<(d-F)/(e>1?e:1)){break cb}e=A[48091];if(!(!(aa<=-e)|!(e<=A[h+i>>3]))){i=bd(56);v[111924]=0;j=Q(2442,i|0,b|0,v[C+60>>2])|0;h=v[111924];v[111924]=0;db:{if((h|0)!=1){v[111924]=0;v[C+32>>2]=j;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[j>>2]+4>>2]](j);break Wa}v[i+12>>2]=j;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=374952;v[C+36>>2]=i;h=v[a+220>>2];eb:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=j;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break eb}v[111924]=0;O(2441,m|0,C+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break db}}j=v[x+8>>2];h=v[a+200>>2];i=v[C+60>>2];v[h+(i<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break db}h=v[a+312>>2];v[h+4>>2]=v[h+4>>2]+1;i=v[C+36>>2];fb:{if(!i){break fb}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break fb}zb[v[v[i>>2]+8>>2]](i);se(i)}l=l+1|0;fa=j+fa|0;break Xa}break Aa}break za}gb:{hb:{ib:{jb:{i=v[x+8>>2];switch(i|0){case 1:break gb;case 2:break ib;case 0:break jb;default:break hb}}Z=v[C+60>>2];j=Z<<3;c=A[a+288>>3];if(A[j+v[b+92>>2]>>3]<-c|c<A[j+v[b+80>>2]>>3]){break cb}i=bd(32);h=v[b+184>>2];L=v[b+40>>2];v[i+12>>2]=L;v[i+8>>2]=h;v[i+4>>2]=15223;v[i+16>>2]=Z;v[i>>2]=375268;v[i+20>>2]=L-1;c=A[j+v[b+104>>2]>>3];A[i+24>>3]=v[b+288>>2]==-1?-c:c;v[111924]=0;v[C+32>>2]=i;j=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Aa}v[j+12>>2]=i;v[j+4>>2]=0;v[j+8>>2]=0;v[j>>2]=375356;v[C+36>>2]=j;kb:{h=v[a+220>>2];lb:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=j;v[h>>2]=i;v[j+4>>2]=v[j+4>>2]+1;v[a+220>>2]=h+8;break lb}v[111924]=0;O(2441,m|0,C+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break kb}L=v[b+40>>2];Z=v[C+60>>2]}h=v[a+200>>2];v[h+(Z<<2)>>2]=v[(h+(L<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,Z|0);h=v[111924];v[111924]=0;if((h|0)==1){break kb}h=v[a+312>>2];v[h>>2]=v[h>>2]+1;i=v[C+36>>2];mb:{if(!i){break mb}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break mb}zb[v[v[i>>2]+8>>2]](i);se(i)}l=l+1|0;break Xa}break za}n=v[C+60>>2]<<3;h=n;F=A[h+v[b+80>>2]>>3];z=D(F);r=v[b+92>>2];f=A[r+h>>3];e=D(f);e=e<z?z:e;f=D((F-f)/(e>1?e:1));e=A[a+288>>3];if(!(f<=e)){break hb}L=0;k=ub-32|0;ub=k;i=v[b+224>>2];x=v[x>>2];j=v[x+8>>2];h=j<<3;$=A[i+h>>3];d=D($);q=v[b+236>>2];K=A[q+h>>3];c=D(K);c=c<d?d:c;nb:{ob:{pb:{qb:{rb:{if(e>=D(($-K)/(c>1?c:1))){break rb}o=i;i=v[x+24>>2];h=i<<3;f=A[o+h>>3];d=D(f);F=A[h+q>>3];c=D(F);c=c<d?d:c;if(e>=D((f-F)/(c>1?c:1))){break rb}ua=A[n+r>>3];sb:{tb:{ub:{vb:{wb:{xb:{aa=A[x>>3];e=A[x+16>>3];ta=aa*e;if(ta<0){d=A[48091];yb:{if(F>=d){z=-d;break yb}z=(ua-e*F)/aa}c=-d>=f?d:(ua-e*f)/aa;ia=d<=K?-d:(ua-aa*K)/e;A[k+24>>3]=ia;if(!($<=-d)){break xb}break wb}if(ta>0){d=A[48091];z=-d;if(!(z>=f)){z=(ua-e*f)/aa}c=d<=F?d:(ua-e*F)/aa;ia=-d;if(!($<=ia)){ia=(ua-aa*$)/e}A[k+24>>3]=ia;if(d<=K){break wb}d=(ua-aa*K)/e;break wb}a=Ub(16);v[111924]=0;i=N(2255,k|0,206760)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ob}v[a>>2]=371744;h=a+4|0;zb:{Ab:{if(t[i+11|0]>=0){b=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=b;v[h+8>>2]=v[i+8>>2];break Ab}g=v[i+4>>2];b=v[i>>2];v[111924]=0;R(2167,h|0,b|0,g|0);b=v[111924];v[111924]=0;g=1;if((b|0)==1){break zb}}v[a>>2]=371724;g=0;v[111924]=0;R(2152,a|0,371020,2256);b=v[111924];v[111924]=0;if((b|0)!=1){break vb}}j=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!g){break tb}ac(a);P(j|0);p()}d=(ua-aa*$)/e}A[k+16>>3]=d;Bb:{Cb:{ra=A[48091];Db:{if(-ra>=z&c>=ra){break Db}if(-ra>=ia&d>=ra){break Cb}Eb:{ra=z-$;z=A[53482];if(!(ra<z)){break Eb}ra=c-K;c=-z;if(!(ra>c)){break Eb}if(!(z>ia-f)|!(c<d-F)|D(aa)>D(e)){break Cb}break Db}c=A[53482];if(c>ia-f&-c<d-F){break Db}if(D(aa)>D(e)){break Cb}}z=K;c=$;K=aa;h=j;break Bb}z=F;c=f;F=K;f=$;K=e;e=aa;h=i;i=j}ra=ua/e;ia=-K/e;q=v[b+168>>2];r=v[b+172>>2];x=i<<3;J=q+B(v[(r+x|0)+4>>2],24)|0;j=v[J+8>>2];if((j|0)>0){s=q+B(v[(r+(h<<3)|0)+4>>2],24)|0;aa=-ra;while(1){q=v[J>>2]+(L<<4)|0;E=v[q+8>>2];if((E|0)!=v[C+60>>2]){va=A[q>>3];j=E<<3;$=A[j+v[b+92>>2]>>3];d=A[j+v[b+80>>2]>>3];if(d>-A[48091]){A[k>>3]=aa*va+d;zb[v[v[b>>2]+200>>2]](b,E,k,0);v[a+32>>2]=v[a+32>>2]+1}if($<A[48091]){A[k>>3]=aa*va+$;zb[v[v[b>>2]+212>>2]](b,E,k,0);v[a+32>>2]=v[a+32>>2]+1}d=ia*va;A[k>>3]=d;n=v[s>>2];Fb:{if(!n){break Fb}j=0;r=v[s+8>>2];if((r|0)<=0){break Fb}while(1){q=n+(j<<4)|0;if((E|0)!=v[q+8>>2]){j=j+1|0;if((r|0)!=(j|0)){continue}break Fb}break}A[k>>3]=d+A[q>>3];v[a+24>>2]=v[a+24>>2]+1}zb[v[v[b>>2]+264>>2]](b,E,h,k,0);j=v[J+8>>2]}L=L+1|0;if((L|0)<(j|0)){continue}break}}d=A[a+280>>3];$=A[x+v[b+248>>2]>>3];if(d<D($)){d=v[b+288>>2]==-1?-$:$;zb[v[v[a>>2]+72>>2]](a,ra*d);$=ia*d;d=A[v[b+248>>2]+(h<<3)>>3];A[k>>3]=$+(v[b+288>>2]==-1?-d:d);zb[v[v[b>>2]+140>>2]](b,h,k,0);d=A[a+280>>3]}ia=D(ua);aa=f*e;$=D(aa);$=$<ia?ia:$;ra=$<1?1:$;$=ua/ra-aa/ra;aa=D($)<=d?0:$;$=F*e;e=D($);e=e<ia?ia:e;ia=e<1?1:e;e=ua/ia-$/ia;$=D(e)<=d?0:e;Gb:{if(ta>0){e=A[48091];Hb:{if(F>=e){d=-e;break Hb}d=ia*$/K}A[k+24>>3]=d;if(!(-e>=f)){break Gb}break ub}if(ta<0){e=A[48091];d=-e;if(!(f<=d)){d=ra*aa/K}A[k+24>>3]=d;if(e<=F){break ub}e=ia*$/K;break ub}a=Ub(16);v[111924]=0;i=N(2255,k|0,206760)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ob}v[a>>2]=371744;h=a+4|0;Ib:{Jb:{if(t[i+11|0]>=0){b=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=b;v[h+8>>2]=v[i+8>>2];break Jb}g=v[i+4>>2];b=v[i>>2];v[111924]=0;R(2167,h|0,b|0,g|0);b=v[111924];v[111924]=0;g=1;if((b|0)==1){break Ib}}v[a>>2]=371724;g=0;v[111924]=0;R(2152,a|0,371020,2256);b=v[111924];v[111924]=0;if((b|0)!=1){break vb}}j=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!g){break tb}ac(a);P(j|0);p()}e=ra*aa/K;break ub}p()}A[k+16>>3]=e;f=d-c;d=A[a+280>>3];if(f>d){zb[v[v[b>>2]+164>>2]](b,h,k+24|0,0);v[a+28>>2]=v[a+28>>2]+1;d=A[a+280>>3]}if(-d>e-z){zb[v[v[b>>2]+176>>2]](b,h,k+16|0,0);v[a+28>>2]=v[a+28>>2]+1}j=bd(120);h=v[C+60>>2];v[111924]=0;q=gb(2457,j|0,b|0,h|0,i|0,+ua,+z,+c)|0;h=v[111924];v[111924]=0;if((h|0)==1){break qb}v[111924]=0;v[k>>2]=q;j=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break sb}j=M()|0;zb[v[v[q>>2]+4>>2]](q)}P(j|0);p()}v[j+12>>2]=q;v[j+4>>2]=0;v[j+8>>2]=0;v[j>>2]=376152;v[k+4>>2]=j;h=v[a+220>>2];Kb:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=j;v[h>>2]=q;v[j+4>>2]=v[j+4>>2]+1;v[a+220>>2]=h+8;break Kb}v[111924]=0;O(2441,a+216|0,k|0);h=v[111924];v[111924]=0;if((h|0)==1){break pb}}h=v[a+200>>2];j=v[C+60>>2];v[h+(j<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,j|0);h=v[111924];v[111924]=0;if((h|0)==1){break pb}h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];h=v[v[b>>2]+80>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break pb}v[a+16>>2]=v[a+16>>2]+1;v[a+20>>2]=v[a+20>>2]+1;v[a+24>>2]=v[a+24>>2]+2;h=v[a+312>>2];v[h+60>>2]=v[h+60>>2]+1;i=v[k+4>>2];if(!i){break rb}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break rb}zb[v[v[i>>2]+8>>2]](i);se(i)}ub=k+32|0;break nb}a=M()|0;Gb(j);P(a|0);p()}a=M()|0;Sf(k);P(a|0);p()}b=M()|0;ac(a);P(b|0);p()}break Xa}Lb:{if(k){break Lb}f=A[v[b+80>>2]+(v[C+60>>2]<<3)>>3];e=D(f);e=e<$?$:e;if(!(A[a+288>>3]>=D((c-f)/(e>1?e:1)))){break Lb}v[C+48>>2]=858993459;v[C+52>>2]=1072902963;v[C+40>>2]=0;h=(i|0)>0?i:0;v[C+32>>2]=h;h=(i|0)<=0?1:h;v[C+36>>2]=h;So(ca,h);h=v[x+8>>2];v[C+28>>2]=0;v[C+20>>2]=0;v[C+24>>2]=0;if(!h){v[C+16>>2]=0;v[C+8>>2]=0;v[C+12>>2]=0;break _a}v[111924]=0;O(2198,C+20|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break Ya}h=v[x+8>>2];v[C+16>>2]=0;v[C+8>>2]=0;v[C+12>>2]=0;if(!h){break _a}v[111924]=0;O(2198,C+8|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break Za}i=0;if(v[x+8>>2]<=0){break _a}while(1){Mb:{h=v[x>>2]+(i<<4)|0;f=A[h>>3];q=v[h+8>>2];h=q<<3;r=h+v[b+236>>2]|0;e=A[r>>3];d=D(e);k=h+v[b+224>>2]|0;z=A[k>>3];c=D(z);c=c<d?d:c;t[v[C+40>>2]+i|0]=!(A[a+280>>3]>=D((e-z)/(c>1?c:1)));h=i<<3;A[h+v[C+20>>2]>>3]=z;A[h+v[C+8>>2]>>3]=A[r>>3];j=f>0;h=v[v[b>>2]+(j?164:176)>>2];v[111924]=0;W(h|0,b|0,q|0,(j?r:k)|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Mb}i=i+1|0;if((i|0)<v[x+8>>2]){continue}break _a}break}a=M()|0;break Za}if(E){break Xa}e=A[v[b+92>>2]+(v[C+60>>2]<<3)>>3];c=D(e);c=c<K?K:c;if(!(A[a+288>>3]>=D((d-e)/(c>1?c:1)))){break Xa}v[C+48>>2]=858993459;v[C+52>>2]=1072902963;v[C+40>>2]=0;h=(i|0)>0?i:0;v[C+32>>2]=h;h=(i|0)<=0?1:h;v[C+36>>2]=h;So(ca,h);h=v[x+8>>2];v[C+28>>2]=0;v[C+20>>2]=0;v[C+24>>2]=0;if(!h){v[C+16>>2]=0;v[C+8>>2]=0;v[C+12>>2]=0;break bb}v[111924]=0;O(2198,C+20|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break $a}h=v[x+8>>2];v[C+16>>2]=0;v[C+8>>2]=0;v[C+12>>2]=0;if(!h){break bb}v[111924]=0;O(2198,C+8|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break ab}i=0;if(v[x+8>>2]<=0){break bb}while(1){Nb:{h=v[x>>2]+(i<<4)|0;f=A[h>>3];q=v[h+8>>2];h=q<<3;r=h+v[b+236>>2]|0;e=A[r>>3];d=D(e);k=h+v[b+224>>2]|0;z=A[k>>3];c=D(z);c=c<d?d:c;t[v[C+40>>2]+i|0]=!(A[a+280>>3]>=D((e-z)/(c>1?c:1)));h=i<<3;A[h+v[C+20>>2]>>3]=z;A[h+v[C+8>>2]>>3]=A[r>>3];j=f>0;h=v[v[b>>2]+(j?176:164)>>2];v[111924]=0;W(h|0,b|0,q|0,(j?k:r)|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Nb}i=i+1|0;if((i|0)<v[x+8>>2]){continue}break bb}break}a=M()|0;break ab}S_(a,b,x,C+60|0);break Xa}G=1;break Ba}v[111924]=0;i=S(2157,152)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break ab}v[111924]=0;j=ga(2443,i|0,b|0,v[C+60>>2],0,C+32|0,C+20|0,C+8|0)|0;h=v[111924];v[111924]=0;Ob:{if((h|0)!=1){v[111924]=0;v[C>>2]=j;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[j>>2]+4>>2]](j);break ab}v[i+12>>2]=j;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376548;v[C+4>>2]=i;h=v[a+220>>2];Pb:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=j;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break Pb}v[111924]=0;O(2441,m|0,C|0);h=v[111924];v[111924]=0;if((h|0)==1){break Ob}}j=v[x+8>>2];h=v[a+200>>2];i=v[C+60>>2];v[h+(i<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Ob}h=v[a+312>>2];v[h+12>>2]=v[h+12>>2]+1;i=v[C+4>>2];Qb:{if(!i){break Qb}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Qb}zb[v[v[i>>2]+8>>2]](i);se(i)}h=v[C+8>>2];if(h){v[C+12>>2]=h;Gb(h)}h=v[C+20>>2];if(h){v[C+24>>2]=h;Gb(h)}h=v[C+40>>2];if(h){Gb(h)}l=l+1|0;fa=j+fa|0;break Xa}a=M()|0;Gb(i);break ab}a=M()|0;Sf(C)}b=v[C+8>>2];if(!b){break $a}v[C+12>>2]=b;Gb(b)}b=v[C+20>>2];if(b){v[C+24>>2]=b;Gb(b)}b=v[C+40>>2];if(!b){break Wa}Gb(b);break w}v[111924]=0;i=S(2157,152)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break Za}v[111924]=0;j=ga(2443,i|0,b|0,v[C+60>>2],1,C+32|0,C+20|0,C+8|0)|0;h=v[111924];v[111924]=0;Rb:{if((h|0)!=1){v[111924]=0;v[C>>2]=j;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[j>>2]+4>>2]](j);break Za}v[i+12>>2]=j;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376548;v[C+4>>2]=i;h=v[a+220>>2];Sb:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=j;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break Sb}v[111924]=0;O(2441,m|0,C|0);h=v[111924];v[111924]=0;if((h|0)==1){break Rb}}j=v[x+8>>2];h=v[a+200>>2];i=v[C+60>>2];v[h+(i<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Rb}h=v[a+312>>2];v[h+12>>2]=v[h+12>>2]+1;i=v[C+4>>2];Tb:{if(!i){break Tb}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Tb}zb[v[v[i>>2]+8>>2]](i);se(i)}h=v[C+8>>2];if(h){v[C+12>>2]=h;Gb(h)}h=v[C+20>>2];if(h){v[C+24>>2]=h;Gb(h)}h=v[C+40>>2];if(h){Gb(h)}l=l+1|0;fa=j+fa|0;break Xa}a=M()|0;Gb(i);break Za}a=M()|0;Sf(C)}b=v[C+8>>2];if(!b){break Ya}v[C+12>>2]=b;Gb(b)}b=v[C+20>>2];if(b){v[C+24>>2]=b;Gb(b)}b=v[C+40>>2];if(!b){break Wa}Gb(b);break w}h=v[C+60>>2];j=h-1|0;v[C+60>>2]=j;if((h|0)>0){continue}break Ca}break}break w}if(((H+ka|0)+l|0)<=0){break Ba}v[a+16>>2]=v[a+16>>2]+l;v[a+24>>2]=v[a+24>>2]+fa;v[a+32>>2]=v[a+32>>2]+ka;v[a+28>>2]=v[a+28>>2]+H;v[a+36>>2]=v[a+36>>2]+oa;v[a+40>>2]=v[a+40>>2]+pa;j=v[a+64>>2];Ub:{if(!j){break Ub}h=v[j+4>>2];if((h|0)<4){break Ub}v[C+20>>2]=h;v[C+32>>2]=4;i=C+32|0;zb[v[v[j>>2]+8>>2]](j,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],248869,26);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],l);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253565,7);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],fa);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253585,12);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],H);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253668,13);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],ka);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],246767,18);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],oa);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253651,16);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],pa);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],59087,11);k=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[k>>2]-12>>2]+k|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;Vb:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break Vb}}a=M()|0;g=v[C+32>>2];b=v[g+4>>2]-1|0;v[g+4>>2]=b;if((b|0)==-1){zb[v[v[g>>2]+8>>2]](g)}break w}j=v[C+32>>2];h=v[j+4>>2]-1|0;v[j+4>>2]=h;if((h|0)==-1){zb[v[v[j>>2]+8>>2]](j)}bc(k,i);$b(k);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,C+20|0)}if(!(+(l|0)>A[a+56>>3]*+(ba|0))){break Ba}t[_+31|0]=1}ub=C- -64|0;h=G;break ya}a=M()|0;Gb(i);break w}a=M()|0;Sf(C+32|0);break w}v[a+340>>2]=h;Wb:{if(h){break Wb}ka=0;pa=0;G=0;ma=0;l=ub-80|0;ub=l;m=v[b+40>>2];Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{r=v[b+184>>2];cc:{if((r|0)>0){I=a+216|0;k=b+236|0;j=b+224|0;ba=l+44|0;ca=l- -64|0;J=l+52|0;i=r;while(1){n=1;q=i;i=i-1|0;ha=i<<3;f=A[ha+v[b+224>>2]>>3];d=D(f);e=A[ha+v[b+236>>2]>>3];c=D(e);c=c<d?d:c;d=(f-e)/(c>1?c:1);c=A[a+288>>3];if(d>c){break cc}dc:{ec:{qa=v[b+168>>2]+B(v[(ha+v[b+172>>2]|0)+4>>2],24)|0;x=v[qa+8>>2];if(!x){d=A[ha+v[b+248>>2]>>3];c=A[a+280>>3];fc:{gc:{if(d>c){h=k;if(!(e>=A[48091])){break gc}n=3;break cc}if(d<-c){h=j;if(!(f<=-A[48091])){break gc}n=3;break cc}h=j;d=A[48091];if(f>-d){break gc}h=k;c=0;if(!(d>A[ha+v[h>>2]>>3])){break fc}}c=A[ha+v[h>>2]>>3]}n=bd(24);v[111924]=0;x=na(2444,n|0,b|0,i|0,+c)|0;h=v[111924];v[111924]=0;hc:{ic:{jc:{kc:{if((h|0)!=1){v[111924]=0;v[l+48>>2]=x;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[x>>2]+4>>2]](x);break w}v[n+12>>2]=x;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=376944;v[l+52>>2]=n;v[111924]=0;n=S(2157,80)|0;h=v[111924];v[111924]=0;if((h|0)==1){break kc}v[111924]=0;x=xa(2445,n|0,b|0,a|0,i|0,+c,1)|0;h=v[111924];v[111924]=0;if((h|0)==1){break jc}v[111924]=0;v[l+72>>2]=x;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[x>>2]+4>>2]](x);break hc}v[n+12>>2]=x;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=377336;v[l+76>>2]=n;n=v[a+220>>2];lc:{if((n|0)!=v[a+224>>2]){v[n>>2]=v[l+48>>2];h=v[l+52>>2];v[n+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}h=n+8|0;v[a+220>>2]=h;break lc}v[111924]=0;O(2441,I|0,l+48|0);h=v[111924];v[111924]=0;if((h|0)==1){break ic}h=v[a+220>>2]}mc:{if(v[a+224>>2]!=(h|0)){v[h>>2]=v[l+72>>2];n=v[l+76>>2];v[h+4>>2]=n;if(n){v[n+4>>2]=v[n+4>>2]+1}v[a+220>>2]=h+8;break mc}v[111924]=0;O(2441,I|0,l+72|0);h=v[111924];v[111924]=0;if((h|0)==1){break ic}}h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];h=v[v[b>>2]+80>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break ic}h=v[a+312>>2];v[h+16>>2]=v[h+16>>2]+1;n=v[l+76>>2];nc:{if(!n){break nc}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break nc}zb[v[v[n>>2]+8>>2]](n);se(n)}n=v[l+52>>2];if(!n){break ec}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break ec}zb[v[v[n>>2]+8>>2]](n);se(n);break ec}a=M()|0;Gb(n);break w}a=M()|0;break hc}a=M()|0;Gb(n);break hc}a=M()|0;Sf(l+72|0)}break Zb}oc:{pc:{if(!(c<D(d))){break pc}fa=1;h=0;H=1;qc:{if((x|0)<=0){break qc}while(1){x=v[qa>>2]+(h<<4)|0;s=v[x+8>>2];c=A[x>>3];rc:{if(c>0){c=A[48091];x=s<<3;H=!(c>A[x+v[b+92>>2]>>3])&H;if(!(A[x+v[b+80>>2]>>3]>-c)){break rc}fa=0;break rc}if(!(c<0)){break rc}c=A[48091];x=s<<3;fa=!(c>A[x+v[b+92>>2]>>3])&fa;if(!(A[x+v[b+80>>2]>>3]>-c)){break rc}H=0}h=h+1|0;if((h|0)>=v[qa+8>>2]){break qc}if((H|fa)&1){continue}break}}d=A[ha+v[b+248>>2]>>3];c=A[a+280>>3];if(!(!(d>c)|!(H&1))){if(A[ha+v[k>>2]>>3]>=A[48091]){n=3;break cc}h=bd(24);c=A[ha+v[b+236>>2]>>3];v[111924]=0;H=na(2444,h|0,b|0,i|0,+c)|0;x=v[111924];v[111924]=0;sc:{if((x|0)!=1){v[111924]=0;v[l+48>>2]=H;x=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break bc}v[x+12>>2]=H;v[x+4>>2]=0;v[x+8>>2]=0;v[x>>2]=376944;v[l+52>>2]=x;h=v[a+220>>2];tc:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=x;v[h>>2]=H;v[x+4>>2]=v[x+4>>2]+1;v[a+220>>2]=h+8;break tc}v[111924]=0;O(2441,I|0,l+48|0);h=v[111924];v[111924]=0;if((h|0)==1){break sc}}x=v[v[b>>2]+164>>2];h=v[b+236>>2];v[111924]=0;W(x|0,b|0,i|0,h+ha|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break sc}x=v[l+52>>2];if(!x){break pc}h=v[x+4>>2];v[x+4>>2]=h-1;if(h){break pc}zb[v[v[x>>2]+8>>2]](x);se(x);break pc}break ac}break $b}if(d<-c&fa){if(A[ha+v[j>>2]>>3]<=-A[48091]){n=3;break cc}h=bd(24);c=A[ha+v[b+224>>2]>>3];v[111924]=0;H=na(2444,h|0,b|0,i|0,+c)|0;x=v[111924];v[111924]=0;uc:{if((x|0)!=1){v[111924]=0;v[l+48>>2]=H;x=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break bc}v[x+12>>2]=H;v[x+4>>2]=0;v[x+8>>2]=0;v[x>>2]=376944;v[l+52>>2]=x;h=v[a+220>>2];vc:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=x;v[h>>2]=H;v[x+4>>2]=v[x+4>>2]+1;v[a+220>>2]=h+8;break vc}v[111924]=0;O(2441,I|0,l+48|0);h=v[111924];v[111924]=0;if((h|0)==1){break uc}}x=v[v[b>>2]+176>>2];h=v[b+224>>2];v[111924]=0;W(x|0,b|0,i|0,h+ha|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break uc}x=v[l+52>>2];if(!x){break pc}h=v[x+4>>2];v[x+4>>2]=h-1;if(h){break pc}zb[v[v[x>>2]+8>>2]](x);se(x);break pc}break ac}break $b}if(!(c>=D(d))){break pc}C=0;C=fa&1?A[ha+v[j>>2]>>3]<=-A[48091]:C;if((C|H&1&A[48091]<=A[ha+v[k>>2]>>3])!=1){break pc}v[l+52>>2]=0;v[l+56>>2]=0;v[l+60>>2]=0;v[l+64>>2]=0;v[l+48>>2]=374312;h=v[qa+8>>2];yh(ca,h);L=0;v[l+60>>2]=0;v[l+56>>2]=h;H=v[l+64>>2];v[l+52>>2]=H;if((J|0)!=(qa|0)){s=v[qa+8>>2];if(s){h=v[qa>>2];if((s|0)!=1){x=s&-2;fa=0;while(1){if(A[h>>3]!=0){n=v[h+4>>2];v[H>>2]=v[h>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+8>>2];H=H+16|0;L=L+1|0}if(A[h+16>>3]!=0){n=v[h+20>>2];v[H>>2]=v[h+16>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+24>>2];H=H+16|0;L=L+1|0}h=h+32|0;fa=fa+2|0;if((x|0)!=(fa|0)){continue}break}}if(!(!(s&1)|A[h>>3]==0)){n=v[h+4>>2];v[H>>2]=v[h>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+8>>2];L=L+1|0}H=v[l+52>>2]}v[l+60>>2]=L}v[111924]=0;hL(H,L,l+16|0,0,1);h=v[111924];v[111924]=0;wc:{if((h|0)!=1){v[111924]=0;E=S(2157,120)|0;h=v[111924];v[111924]=0;if((h|0)!=1){v[l+32>>2]=0;v[l+36>>2]=0;v[l+40>>2]=0;v[l+44>>2]=0;v[111924]=0;v[l+28>>2]=374312;n=v[l+60>>2];O(2304,ba|0,n|0);h=v[111924];v[111924]=0;xc:{yc:{zc:{if((h|0)!=1){L=0;v[l+40>>2]=0;H=v[l+44>>2];v[l+32>>2]=H;v[l+36>>2]=n;s=v[l+60>>2];Ac:{if(!s){break Ac}h=v[l+52>>2];if((s|0)!=1){x=s&-2;fa=0;while(1){if(A[h>>3]!=0){n=v[h+4>>2];v[H>>2]=v[h>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+8>>2];H=H+16|0;L=L+1|0}if(A[h+16>>3]!=0){n=v[h+20>>2];v[H>>2]=v[h+16>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+24>>2];H=H+16|0;L=L+1|0}h=h+32|0;fa=fa+2|0;if((x|0)!=(fa|0)){continue}break}}if(!(s&1)|A[h>>3]==0){break Ac}n=v[h+4>>2];v[H>>2]=v[h>>2];v[H+4>>2]=n;v[H+8>>2]=v[h+8>>2];L=L+1|0}v[111924]=0;v[l+40>>2]=L;n=ea(2447,E|0,b|0,i|0,C|0,l+28|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break yc}v[111924]=0;v[l+72>>2]=n;x=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break zc}v[x+12>>2]=n;v[x+4>>2]=0;v[x+8>>2]=0;v[x>>2]=377736;v[l+28>>2]=374312;v[l+76>>2]=x;h=v[l+44>>2];if(h){Gb(h);v[l+44>>2]=0}n=v[a+220>>2];Bc:{Cc:{if((n|0)!=v[a+224>>2]){v[n>>2]=v[l+72>>2];h=v[l+76>>2];v[n+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=n+8;break Cc}v[111924]=0;O(2441,I|0,l+72|0);h=v[111924];v[111924]=0;if((h|0)==1){break Bc}}G=v[qa+8>>2]+G|0;h=v[l+60>>2];while(1){if((h|0)<=0){h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];h=v[v[b>>2]+80>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Bc}ja=v[qa+8>>2];Dc:{if((ja|0)<=0){break Dc}C=v[b+28>>2];E=v[b+24>>2];s=v[qa>>2];h=0;if((ja|0)!=1){x=ja&2147483646;sa=0;while(1){n=s+(h<<4)|0;ka=v[(E+B(v[(C+(v[n+24>>2]<<3)|0)+4>>2],24)|0)+8>>2]+(v[(E+B(v[(C+(v[n+8>>2]<<3)|0)+4>>2],24)|0)+8>>2]+ka|0)|0;h=h+2|0;sa=sa+2|0;if((x|0)!=(sa|0)){continue}break}}if(!(ja&1)){break Dc}ka=v[(E+B(v[(C+(v[(s+(h<<4)|0)+8>>2]<<3)|0)+4>>2],24)|0)+8>>2]+ka|0}h=v[a+312>>2];v[h+24>>2]=v[h+24>>2]+1;n=v[l+76>>2];Ec:{if(!n){break Ec}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break Ec}zb[v[v[n>>2]+8>>2]](n);se(n)}v[l+48>>2]=374312;h=v[l+64>>2];if(!h){break ec}Gb(h);break ec}n=v[a+200>>2];h=h-1|0;x=v[(v[l+52>>2]+(h<<4)|0)+8>>2];v[n+(x<<2)>>2]=v[(n+(v[b+40>>2]<<2)|0)-4>>2];n=v[v[b>>2]+56>>2];v[111924]=0;O(n|0,b|0,x|0);n=v[111924];v[111924]=0;if((n|0)!=1){continue}break}}a=M()|0;Sf(l+72|0);break wc}a=M()|0;break xc}a=M()|0;zb[v[v[n>>2]+4>>2]](n);v[l+28>>2]=374312;b=v[l+44>>2];if(!b){break wc}Gb(b);v[l+44>>2]=0;break wc}a=M()|0;v[l+28>>2]=374312;b=v[l+44>>2];if(!b){break xc}Gb(b);v[l+44>>2]=0;Gb(E);break wc}Gb(E);break wc}a=M()|0;break wc}a=M()|0}v[l+48>>2]=374312;b=v[l+64>>2];if(!b){break oc}Gb(b);break oc}F=A[ha+v[j>>2]>>3];e=D(F);d=A[ha+v[k>>2]>>3];c=D(d);c=c<e?e:c;z=A[a+288>>3];if(z>=D((F-d)/(c>1?c:1))){R_(a,b,i,1);n=v[qa+8>>2];h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];zb[v[v[b>>2]+80>>2]](b,i);h=v[a+312>>2];v[h+20>>2]=v[h+20>>2]+1;pa=pa+1|0;ka=n+ka|0;break dc}if(v[qa+8>>2]!=1){break dc}h=v[qa>>2];ja=v[h+8>>2];ta=A[h>>3];d=A[a+280>>3];if(d>=D(A[ha+v[b+248>>2]>>3])){A[l+48>>3]=-A[48091];e=A[48091];A[l+72>>3]=e;Fc:{if(d<ta){n=ja<<3;h=v[b+80>>2];if(!(!(A[n+h>>3]>-e)|!(e>A[ha+v[k>>2]>>3]))){A[l+48>>3]=A[h+n>>3]-ta*A[ha+v[b+236>>2]>>3]}d=A[48091];c=A[n+v[b+92>>2]>>3];if(!(d>c)|!(A[ha+v[j>>2]>>3]>-d)){break Fc}A[l+72>>3]=c-ta*A[ha+v[b+224>>2]>>3];break Fc}n=ja<<3;h=v[b+80>>2];c=A[n+h>>3];if(ta<-d){d=c;c=-e;if(!(!(d>c)|!(c<A[ha+v[j>>2]>>3]))){A[l+48>>3]=A[h+n>>3]-ta*A[ha+v[b+224>>2]>>3]}d=A[48091];c=A[n+v[b+92>>2]>>3];if(!(d>c)|!(d>A[ha+v[k>>2]>>3])){break Fc}A[l+72>>3]=c-ta*A[ha+v[b+236>>2]>>3];break Fc}A[l+48>>3]=c;A[l+72>>3]=A[n+v[b+92>>2]>>3]}c=A[a+280>>3];if(c>=D(A[l+48>>3])){v[l+48>>2]=0;v[l+52>>2]=0}if(c>=D(A[l+72>>3])){v[l+72>>2]=0;v[l+76>>2]=0}h=bd(88);v[111924]=0;x=ea(2448,h|0,b|0,a|0,i|0,ja|0)|0;n=v[111924];v[111924]=0;Gc:{Hc:{Ic:{Jc:{Kc:{if((n|0)!=1){v[111924]=0;v[l+16>>2]=x;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[x>>2]+4>>2]](x);break w}v[n+12>>2]=x;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=378152;v[l+20>>2]=n;h=v[a+220>>2];Lc:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=n;v[h>>2]=x;v[n+4>>2]=v[n+4>>2]+1;v[a+220>>2]=h+8;break Lc}v[111924]=0;O(2441,I|0,l+16|0);h=v[111924];v[111924]=0;if((h|0)==1){break Hc}}h=v[v[b>>2]+224>>2];v[111924]=0;da(h|0,b|0,ja|0,l+48|0,l+72|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Hc}h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];h=v[v[b>>2]+80>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Hc}h=v[a+312>>2];v[h+28>>2]=v[h+28>>2]+1;h=ja<<3;c=A[48091];if(!(!(A[h+v[b+80>>2]>>3]<=-c)|!(c<=A[h+v[b+92>>2]>>3]))){v[111924]=0;n=S(2157,56)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Kc}v[111924]=0;x=Q(2442,n|0,b|0,ja|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Jc}v[111924]=0;v[l+8>>2]=x;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;zb[v[v[x>>2]+4>>2]](x);break Gc}v[n+12>>2]=x;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=374952;v[l+12>>2]=n;h=v[a+220>>2];Mc:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=n;v[h>>2]=x;v[n+4>>2]=v[n+4>>2]+1;v[a+220>>2]=h+8;break Mc}v[111924]=0;O(2441,I|0,l+8|0);h=v[111924];v[111924]=0;if((h|0)==1){break Ic}}h=v[a+200>>2];v[h+(ja<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,ja|0);h=v[111924];v[111924]=0;if((h|0)==1){break Ic}h=v[a+312>>2];v[h+4>>2]=v[h+4>>2]+1;n=v[l+12>>2];Nc:{if(!n){break Nc}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break Nc}zb[v[v[n>>2]+8>>2]](n);se(n)}G=G+1|0}n=v[l+20>>2];Oc:{if(!n){break Oc}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break Oc}zb[v[v[n>>2]+8>>2]](n);se(n)}ka=ka+1|0;break ec}break ac}a=M()|0;break Gc}a=M()|0;Gb(n);break Gc}a=M()|0;Sf(l+8|0);break Gc}a=M()|0}Sf(l+16|0);break w}s=ja<<3;f=A[s+v[b+80>>2]>>3];e=D(f);d=A[s+v[b+92>>2]>>3];c=D(d);c=c<e?e:c;Pc:{Qc:{Rc:{Sc:{Tc:{Uc:{Vc:{Wc:{h=v[b+24>>2]+B(v[(s+v[b+28>>2]|0)+4>>2],24)|0;Xc:{if(!(z>=D((f-d)/(c>1?c:1)))|v[h+8>>2]!=2){break Xc}va=A[48091];if(!(F>-va|va>A[ha+v[k>>2]>>3])){break Xc}e=A[s+v[b+80>>2]>>3];Yc:{fa=v[h>>2];L=v[fa+8>>2];if((L|0)==(i|0)){L=v[fa+24>>2];fa=fa+16|0;break Yc}if(v[fa+24>>2]==(i|0)){break Yc}b=Ub(16);v[111924]=0;i=N(2255,l+48|0,207075)|0;a=v[111924];v[111924]=0;Zc:{if((a|0)!=1){v[b>>2]=371744;h=b+4|0;_c:{$c:{if(t[i+11|0]>=0){a=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=a;v[h+8>>2]=v[i+8>>2];break $c}g=v[i+4>>2];a=v[i>>2];v[111924]=0;R(2167,h|0,a|0,g|0);a=v[111924];v[111924]=0;H=1;if((a|0)==1){break _c}}v[b>>2]=371724;H=0;v[111924]=0;R(2152,b|0,371020,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break Tc}}a=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!H){break oc}break Zc}a=M()|0}break Yb}F=D(e);x=v[j>>2];z=A[x+ha>>3];d=ta*z;c=D(d);c=c<F?F:c;ia=c<1?1:c;c=e/ia-d/ia;f=A[a+280>>3];$=f>=D(c)?0:c;K=e;h=v[k>>2];e=A[h+ha>>3];d=ta*e;c=D(d);c=c<F?F:c;aa=c<1?1:c;c=K/aa-d/aa;f=f>=D(c)?0:c;C=h;h=L<<3;K=A[C+h>>3];F=A[h+x>>3];ad:{bd:{cd:{ra=A[fa>>3];c=ta*ra;if(c>0){A[l+72>>3]=e>=va?-va:aa*f/ra;d=A[48091];if(!(A[ha+v[j>>2]>>3]<=-d)){break cd}break ad}if(c<0){c=-va;if(!(c>=z)){c=ia*$/ra}A[l+72>>3]=c;d=A[48091];if(d<=A[ha+v[k>>2]>>3]){break ad}d=aa*f/ra;break ad}b=Ub(16);v[111924]=0;i=N(2255,l+48|0,206760)|0;a=v[111924];v[111924]=0;if((a|0)==1){break bd}v[b>>2]=371744;h=b+4|0;dd:{ed:{if(t[i+11|0]>=0){a=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=a;v[h+8>>2]=v[i+8>>2];break ed}g=v[i+4>>2];a=v[i>>2];v[111924]=0;R(2167,h|0,a|0,g|0);a=v[111924];v[111924]=0;H=1;if((a|0)==1){break dd}}v[b>>2]=371724;H=0;v[111924]=0;R(2152,b|0,371020,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break Tc}}a=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!H){break oc}break Yb}d=ia*$/ra;break ad}a=M()|0;break Yb}A[l+16>>3]=d;z=A[l+72>>3];f=D(z);e=A[h+v[j>>2]>>3];c=D(e);c=c<f?f:c;e=(z-e)/(c>1?c:1);c=A[a+280>>3];if(e>c){zb[v[v[b>>2]+164>>2]](b,L,l+72|0,0);d=A[l+16>>3];c=A[a+280>>3]}f=-c;c=A[h+v[k>>2]>>3];z=d-c;e=D(d);d=D(c);e=d<e?e:d;if(f>=z/(e>1?e:1)){zb[v[v[b>>2]+176>>2]](b,L,l+16|0,0);c=A[h+v[b+236>>2]>>3];d=D(c)}f=A[h+v[j>>2]>>3];e=D(f);d=d<e?e:d;if(A[a+288>>3]<(f-c)/(d>1?d:1)){break cc}h=bd(152);v[111924]=0;L=ib(2449,h|0,b|0,i|0,L|0,ja|0,+F,+K)|0;n=v[111924];v[111924]=0;fd:{if((n|0)!=1){v[111924]=0;v[l+48>>2]=L;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break _b}v[n+12>>2]=L;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=378564;v[l+52>>2]=n;h=v[a+220>>2];gd:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=n;v[h>>2]=L;v[n+4>>2]=v[n+4>>2]+1;v[a+220>>2]=h+8;break gd}v[111924]=0;O(2441,I|0,l+48|0);h=v[111924];v[111924]=0;if((h|0)==1){break Wc}}L=1;c=A[48091];L=!(A[ha+v[j>>2]>>3]>-c)|!(c>A[ha+v[k>>2]>>3])?L:2;break fd}break ac}A[l+8>>3]=-c;A[l>>3]=A[48091];h=v[v[b>>2]+188>>2];v[111924]=0;da(h|0,b|0,i|0,l+8|0,l|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Wc}h=v[a+312>>2];v[h+32>>2]=v[h+32>>2]+1;n=v[l+52>>2];hd:{if(!n){break hd}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break hd}zb[v[v[n>>2]+8>>2]](n);se(n)}ma=L+ma|0}z=A[48091];if(!(A[ha+v[j>>2]>>3]<=-z)|!(z<=A[ha+v[k>>2]>>3])){break dc}c=A[s+v[b+80>>2]>>3];f=D(c);h=v[b+92>>2];e=A[h+s>>3];d=D(e);d=d<f?f:d;if(!(A[a+288>>3]<D((c-e)/(d>1?d:1)))){break Uc}d=A[h+s>>3];if(z<=d&-z>=c){break dc}f=A[ha+v[b+248>>2]>>3]/ta;e=A[a+280>>3];if(!(f>e)){break Vc}c=d;if(!(z<=c)){break Uc}n=3;break cc}a=M()|0;break Zb}c=A[s+v[b+80>>2]>>3];if(f<-e){if(!(-z>=c)){break Uc}n=3;break cc}if(-z<c){break Uc}c=d;if(z>c){break Uc}b=Ub(16);v[111924]=0;i=N(2255,l+48|0,206550)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Sc}v[b>>2]=371744;h=b+4|0;id:{jd:{if(t[i+11|0]>=0){a=v[i+4>>2];v[h>>2]=v[i>>2];v[h+4>>2]=a;v[h+8>>2]=v[i+8>>2];break jd}g=v[i+4>>2];a=v[i>>2];v[111924]=0;R(2167,h|0,a|0,g|0);a=v[111924];v[111924]=0;H=1;if((a|0)==1){break id}}v[b>>2]=371724;H=0;v[111924]=0;R(2152,b|0,371020,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break Tc}}a=M()|0;if(t[i+11|0]<0){Gb(v[i>>2])}if(!H){break oc}break Pc}h=bd(72);v[111924]=0;L=Ja(2450,h|0,b|0,a|0,i|0,ja|0,+c)|0;n=v[111924];v[111924]=0;kd:{ld:{if((n|0)!=1){v[111924]=0;v[l+48>>2]=L;n=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break _b}v[n+12>>2]=L;v[n+4>>2]=0;v[n+8>>2]=0;v[n>>2]=378976;v[l+52>>2]=n;h=v[a+220>>2];md:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=n;v[h>>2]=L;v[n+4>>2]=v[n+4>>2]+1;v[a+220>>2]=h+8;break md}v[111924]=0;O(2441,I|0,l+48|0);h=v[111924];v[111924]=0;if((h|0)==1){break kd}}h=0;C=v[b+24>>2]+B(v[(s+v[b+28>>2]|0)+4>>2],24)|0;L=v[C+8>>2];if((L|0)>0){break ld}break Rc}break ac}while(1){s=v[C>>2]+(h<<4)|0;E=v[s+8>>2];if((E|0)!=(i|0)){x=v[b+248>>2];c=A[x+(E<<3)>>3];n=v[b+288>>2]==-1;d=n?-c:c;c=A[x+ha>>3];A[l+72>>3]=d-(n?-c:c)*A[s>>3]/ta;n=v[v[b>>2]+140>>2];v[111924]=0;W(n|0,b|0,E|0,l+72|0,0);n=v[111924];v[111924]=0;if((n|0)==1){break Qc}L=v[C+8>>2]}h=h+1|0;if((L|0)>(h|0)){continue}break}break Rc}break Qc}p()}a=M()|0;break Pc}h=v[a+200>>2];v[h+(ja<<2)>>2]=v[(h+(v[b+40>>2]<<2)|0)-4>>2];h=v[v[b>>2]+56>>2];v[111924]=0;O(h|0,b|0,ja|0);h=v[111924];v[111924]=0;nd:{if((h|0)==1){break nd}h=v[a+176>>2];v[h+(i<<2)>>2]=v[(h+(v[b+184>>2]<<2)|0)-4>>2];h=v[v[b>>2]+80>>2];v[111924]=0;O(h|0,b|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break nd}h=v[a+312>>2];v[h+36>>2]=v[h+36>>2]+1;n=v[l+52>>2];od:{if(!n){break od}h=v[n+4>>2];v[n+4>>2]=h-1;if(h){break od}zb[v[v[n>>2]+8>>2]](n);se(n)}ka=L+ka|0;pa=pa+1|0;G=G+1|0;break dc}}a=M()|0;break Zb}break Yb}break w}pa=pa+1|0}if((q|0)>1){continue}break}}j=G+pa|0;pd:{if((j|0)<=0){break pd}v[a+16>>2]=v[a+16>>2]+G;v[a+20>>2]=v[a+20>>2]+pa;v[a+24>>2]=v[a+24>>2]+ka;v[a+28>>2]=v[a+28>>2]+ma;k=v[a+64>>2];qd:{if(!k){break qd}h=v[k+4>>2];if((h|0)<4){break qd}v[l+72>>2]=h;v[l+48>>2]=4;i=l+48|0;zb[v[v[k>>2]+8>>2]](k,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],248933,29);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],G);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253565,7);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],pa);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253622,7);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],ka);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253585,12);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],ma);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],59142,11);q=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[q>>2]-12>>2]+q|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;rd:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break rd}}a=M()|0;g=v[l+48>>2];b=v[g+4>>2]-1|0;v[g+4>>2]=b;if((b|0)==-1){zb[v[v[g>>2]+8>>2]](g)}break w}k=v[l+48>>2];h=v[k+4>>2]-1|0;v[k+4>>2]=h;if((h|0)==-1){zb[v[v[k>>2]+8>>2]](k)}bc(q,i);$b(q);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,l+72|0)}if(!(+(j|0)>A[a+56>>3]*+(m+r|0))){break pd}t[_+31|0]=1}n=0}ub=l+80|0;h=n;break Xb}a=M()|0;zb[v[v[H>>2]+4>>2]](H);break w}a=M()|0;Gb(h);break w}a=M()|0;Sf(l+48|0);break w}a=M()|0;zb[v[v[L>>2]+4>>2]](L);break w}Sf(l+48|0);break w}ac(b);break w}v[a+340>>2]=h;if(h){break Wb}E=0;Z=0;H=0;s=ub-96|0;ub=s;q=v[b+40>>2];n=v[b+184>>2];v[s+88>>2]=858993459;v[s+92>>2]=1072902963;v[s+80>>2]=0;h=(n|0)>0?n:0;v[s+72>>2]=h;h=(n|0)<=0?1:h;v[s+76>>2]=h;So(s+80|0,h);h=v[b+40>>2];v[s+68>>2]=0;v[s+60>>2]=0;v[s+64>>2]=0;sd:{td:{ud:{vd:{if(!h){v[s+56>>2]=0;v[s+48>>2]=0;v[s+52>>2]=0;break vd}v[111924]=0;O(2198,s+60|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){k=M()|0;break td}h=v[b+40>>2];v[s+56>>2]=0;v[s+48>>2]=0;v[s+52>>2]=0;if(!h){break vd}v[111924]=0;O(2198,s+48|0,h|0);h=v[111924];v[111924]=0;if((h|0)!=1){break vd}k=M()|0;break ud}h=v[b+184>>2];v[s+44>>2]=0;v[s+36>>2]=0;v[s+40>>2]=0;wd:{xd:{yd:{if(!h){v[s+32>>2]=0;v[s+24>>2]=0;v[s+28>>2]=0;break yd}v[111924]=0;O(2198,s+36|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){k=M()|0;break wd}h=v[b+184>>2];v[s+32>>2]=0;v[s+24>>2]=0;v[s+28>>2]=0;if(!h){break yd}v[111924]=0;O(2198,s+24|0,h|0);h=v[111924];v[111924]=0;if((h|0)!=1){break yd}k=M()|0;break xd}zd:{i=v[b+40>>2];if((i|0)<=0){break zd}l=a+216|0;Ad:{Bd:{while(1){Cd:{h=i-1|0;k=h<<3;c=A[48091];Dd:{if(!(A[k+v[b+80>>2]>>3]<=-c&c<=A[k+v[b+92>>2]>>3])){c=-c;j=c>=A[k+v[b+80>>2]>>3];c=j?0:c;Ed:{if(j){break Ed}}A[k+v[s+60>>2]>>3]=c;c=A[48091];j=c<=A[k+v[b+92>>2]>>3];c=j?0:c;Fd:{if(j){break Fd}}A[k+v[s+48>>2]>>3]=c;break Dd}v[111924]=0;r=S(2157,56)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Ad}v[111924]=0;G=Q(2442,r|0,b|0,h|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Cd}v[111924]=0;v[s+16>>2]=G;r=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){k=M()|0;zb[v[v[G>>2]+4>>2]](G);break xd}v[r+12>>2]=G;v[r+4>>2]=0;v[r+8>>2]=0;v[r>>2]=374952;v[s+20>>2]=r;j=v[a+220>>2];Gd:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=r;v[j>>2]=G;v[r+4>>2]=v[r+4>>2]+1;v[a+220>>2]=j+8;break Gd}v[111924]=0;O(2441,l|0,s+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break Bd}}k=v[(v[b+24>>2]+B(v[(k+v[b+28>>2]|0)+4>>2],24)|0)+8>>2];j=v[a+200>>2];v[j+(h<<2)>>2]=v[(j+(v[b+40>>2]<<2)|0)-4>>2];j=v[v[b>>2]+56>>2];v[111924]=0;O(j|0,b|0,h|0);j=v[111924];v[111924]=0;if((j|0)==1){break Bd}j=v[a+312>>2];v[j+4>>2]=v[j+4>>2]+1;r=v[s+20>>2];Hd:{if(!r){break Hd}j=v[r+4>>2];v[r+4>>2]=j-1;if(j){break Hd}zb[v[v[r>>2]+8>>2]](r);se(r)}H=H+1|0;Z=k+Z|0}j=i>>>0>1;i=h;if(j){continue}break zd}break}k=M()|0;Gb(r);break xd}k=M()|0;Sf(s+16|0);break xd}k=M()|0;break xd}Id:{Jd:{Kd:{if(v[b+184>>2]<=0){break Kd}k=0;while(1){j=k<<3;h=v[b+168>>2]+B(v[(j+v[b+172>>2]|0)+4>>2],24)|0;Ld:{if(v[h+8>>2]!=1){break Ld}h=v[h>>2];c=A[h>>3];d=A[j+v[b+248>>2]>>3]/c;i=v[h+8>>2];Md:{if(c>0){Nd:{if(!(A[j+v[b+224>>2]>>3]<=-A[48091])){break Nd}h=v[s+48>>2]+(i<<3)|0;if(!(d<A[h>>3])){break Nd}A[h>>3]=d}if(!(A[48091]<=A[j+v[b+236>>2]>>3])){break Ld}i=v[s+60>>2]+(i<<3)|0;if(d>A[i>>3]){break Md}break Ld}if(!(c<0)){break Ld}Od:{if(!(A[j+v[b+224>>2]>>3]<=-A[48091])){break Od}h=v[s+60>>2]+(i<<3)|0;if(!(d>A[h>>3])){break Od}A[h>>3]=d}if(!(A[48091]<=A[j+v[b+236>>2]>>3])){break Ld}i=v[s+48>>2]+(i<<3)|0;if(!(d<A[i>>3])){break Ld}}A[i>>3]=d}h=v[b+184>>2];k=k+1|0;if((h|0)>(k|0)){continue}break}if((h|0)<=0){break Kd}while(1){l=E<<3;i=l+v[s+24>>2]|0;v[i>>2]=0;v[i+4>>2]=0;i=l+v[s+36>>2]|0;v[i>>2]=0;v[i+4>>2]=0;i=0;k=v[b+168>>2]+B(v[(l+v[b+172>>2]|0)+4>>2],24)|0;if(v[k+8>>2]>0){while(1){L=l+v[s+36>>2]|0;c=A[48091];if(!(A[L>>3]<=-c&c<=A[l+v[s+24>>2]>>3])){h=v[k>>2]+(i<<4)|0;j=v[h+8>>2];d=A[h>>3];Pd:{if(d>0){c=-c;j=j<<3;Qd:{if(c>=A[j+v[s+60>>2]>>3]){A[L>>3]=c;break Qd}h=l+v[s+36>>2]|0;A[h>>3]=d*A[j+v[s+60>>2]>>3]+A[h>>3]}c=A[48091];if(c<=A[j+v[s+48>>2]>>3]){A[l+v[s+24>>2]>>3]=c;break Pd}h=l+v[s+24>>2]|0;A[h>>3]=d*A[j+v[s+48>>2]>>3]+A[h>>3];break Pd}if(!(d<0)){break Pd}j=j<<3;Rd:{if(A[j+v[s+60>>2]>>3]<=-c){A[l+v[s+24>>2]>>3]=c;break Rd}h=l+v[s+24>>2]|0;A[h>>3]=d*A[j+v[s+60>>2]>>3]+A[h>>3]}c=A[48091];if(c<=A[j+v[s+48>>2]>>3]){A[l+v[s+36>>2]>>3]=-c;break Pd}h=l+v[s+36>>2]|0;A[h>>3]=d*A[j+v[s+48>>2]>>3]+A[h>>3]}i=i+1|0;if((i|0)<v[k+8>>2]){continue}}break}h=v[b+184>>2]}E=E+1|0;if((E|0)<(h|0)){continue}break}if((h|0)<=0){E=0;break Kd}r=a+216|0;E=0;while(1){i=h;h=h-1|0;x=h<<3;Sd:{if(v[(v[b+168>>2]+B(v[(x+v[b+172>>2]|0)+4>>2],24)|0)+8>>2]<2){break Sd}z=A[x+v[s+24>>2]>>3];e=D(z);f=A[x+v[s+36>>2]>>3];F=D(f);c=e>F?e:F;K=(z-f)/(c>1?c:1);c=A[a+296>>3];d=-c;if(K<=d){i=2;break Jd}K=A[x+v[b+248>>2]>>3];$=D(K);e=e<$?$:e;Td:{if(c<(K-z)/(e>1?e:1)){if(A[x+v[b+236>>2]>>3]>=A[48091]){i=3;j=v[a+64>>2];if(!j){break Jd}h=v[j+4>>2];if((h|0)<4){break Jd}v[s+12>>2]=h;v[s+16>>2]=4;h=v[v[j>>2]+8>>2];v[111924]=0;k=j;j=s+16|0;O(h|0,k|0,j|0);h=v[111924];v[111924]=0;if((h|0)!=1){k=v[a+64>>2];h=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,138341,10)|0;h=v[111924];v[111924]=0;Ud:{if((h|0)==1){break Ud}l=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];h=v[v[l>>2]-12>>2];v[111924]=0;h=v[(h+l|0)+28>>2];v[j>>2]=h;v[h+4>>2]=v[h+4>>2]+1;h=v[111924];v[111924]=0;if((h|0)==1){break Ud}v[111924]=0;j=N(1122,j|0,448956)|0;h=v[111924];v[111924]=0;Vd:{if((h|0)!=1){h=v[v[j>>2]+28>>2];v[111924]=0;j=N(h|0,j|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break Vd}}k=M()|0;b=v[s+16>>2];a=v[b+4>>2]-1|0;v[b+4>>2]=a;if((a|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break xd}k=v[s+16>>2];h=v[k+4>>2]-1|0;v[k+4>>2]=h;if((h|0)==-1){zb[v[v[k>>2]+8>>2]](k)}v[111924]=0;N(2270,l|0,j|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Ud}v[111924]=0;S(2271,l|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Ud}j=v[a+64>>2];h=v[v[j>>2]+8>>2];v[111924]=0;O(h|0,j|0,s+12|0);h=v[111924];v[111924]=0;if((h|0)!=1){break Jd}}k=M()|0;break xd}k=M()|0;break xd}v[111924]=0;l=S(2157,24)|0;j=v[111924];v[111924]=0;Wd:{Xd:{if((j|0)!=1){c=A[x+v[b+236>>2]>>3];v[111924]=0;G=na(2444,l|0,b|0,h|0,+c)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Xd}v[111924]=0;v[s+16>>2]=G;k=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){k=M()|0;zb[v[v[G>>2]+4>>2]](G);break xd}v[k+12>>2]=G;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=376944;v[s+20>>2]=k;j=v[a+220>>2];Yd:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=k;v[j>>2]=G;v[k+4>>2]=v[k+4>>2]+1;v[a+220>>2]=j+8;break Yd}v[111924]=0;O(2441,r|0,s+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break Wd}}k=v[v[b>>2]+164>>2];j=v[b+236>>2];v[111924]=0;W(k|0,b|0,h|0,j+x|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break Wd}j=v[a+312>>2];v[j+40>>2]=v[j+40>>2]+1;k=v[s+20>>2];if(!k){break Td}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break Td}zb[v[v[k>>2]+8>>2]](k);se(k);break Td}k=M()|0;break xd}k=M()|0;Gb(l);break xd}k=M()|0;Sf(s+16|0);break xd}Zd:{c=F<$?$:F;if(d>=(K-f)/(c>1?c:1)){if(A[x+v[b+224>>2]>>3]<=-A[48091]){i=3;j=v[a+64>>2];if(!j){break Jd}h=v[j+4>>2];if((h|0)<4){break Jd}v[s+12>>2]=h;v[s+16>>2]=4;h=v[v[j>>2]+8>>2];v[111924]=0;k=j;j=s+16|0;O(h|0,k|0,j|0);h=v[111924];v[111924]=0;if((h|0)==1){break Zd}k=v[a+64>>2];h=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,138341,10)|0;h=v[111924];v[111924]=0;_d:{if((h|0)==1){break _d}l=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];h=v[v[l>>2]-12>>2];v[111924]=0;h=v[(h+l|0)+28>>2];v[j>>2]=h;v[h+4>>2]=v[h+4>>2]+1;h=v[111924];v[111924]=0;if((h|0)==1){break _d}v[111924]=0;j=N(1122,j|0,448956)|0;h=v[111924];v[111924]=0;$d:{if((h|0)!=1){h=v[v[j>>2]+28>>2];v[111924]=0;j=N(h|0,j|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break $d}}k=M()|0;b=v[s+16>>2];a=v[b+4>>2]-1|0;v[b+4>>2]=a;if((a|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break xd}k=v[s+16>>2];h=v[k+4>>2]-1|0;v[k+4>>2]=h;if((h|0)==-1){zb[v[v[k>>2]+8>>2]](k)}v[111924]=0;N(2270,l|0,j|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break _d}v[111924]=0;S(2271,l|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break _d}j=v[a+64>>2];h=v[v[j>>2]+8>>2];v[111924]=0;O(h|0,j|0,s+12|0);h=v[111924];v[111924]=0;if((h|0)!=1){break Jd}}k=M()|0;break xd}v[111924]=0;l=S(2157,24)|0;j=v[111924];v[111924]=0;ae:{be:{if((j|0)!=1){c=A[x+v[b+224>>2]>>3];v[111924]=0;G=na(2444,l|0,b|0,h|0,+c)|0;j=v[111924];v[111924]=0;if((j|0)==1){break be}v[111924]=0;v[s+16>>2]=G;k=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){k=M()|0;zb[v[v[G>>2]+4>>2]](G);break xd}v[k+12>>2]=G;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=376944;v[s+20>>2]=k;j=v[a+220>>2];ce:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=k;v[j>>2]=G;v[k+4>>2]=v[k+4>>2]+1;v[a+220>>2]=j+8;break ce}v[111924]=0;O(2441,r|0,s+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break ae}}k=v[v[b>>2]+176>>2];j=v[b+224>>2];v[111924]=0;W(k|0,b|0,h|0,j+x|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break ae}j=v[a+312>>2];v[j+40>>2]=v[j+40>>2]+1;k=v[s+20>>2];if(!k){break Td}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break Td}zb[v[v[k>>2]+8>>2]](k);se(k);break Td}k=M()|0;break xd}k=M()|0;Gb(l);break xd}k=M()|0;Sf(s+16|0);break xd}de:{e=A[48091];if(!(e>A[x+v[b+236>>2]>>3])){break de}d=A[x+v[s+24>>2]>>3];c=D(d);c=c<$?$:c;if(!(A[a+296>>3]>=D((K-d)/(c>1?c:1)))){break de}v[111924]=0;l=S(2157,24)|0;j=v[111924];v[111924]=0;ee:{fe:{if((j|0)!=1){c=A[x+v[b+236>>2]>>3];v[111924]=0;G=na(2444,l|0,b|0,h|0,+c)|0;j=v[111924];v[111924]=0;if((j|0)==1){break fe}v[111924]=0;v[s+16>>2]=G;k=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){k=M()|0;zb[v[v[G>>2]+4>>2]](G);break xd}v[k+12>>2]=G;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=376944;v[s+20>>2]=k;j=v[a+220>>2];ge:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=k;v[j>>2]=G;v[k+4>>2]=v[k+4>>2]+1;v[a+220>>2]=j+8;break ge}v[111924]=0;O(2441,r|0,s+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break ee}}k=v[v[b>>2]+164>>2];j=v[b+236>>2];v[111924]=0;W(k|0,b|0,h|0,j+x|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break ee}j=v[a+312>>2];v[j+44>>2]=v[j+44>>2]+1;k=v[s+20>>2];if(!k){break Td}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break Td}zb[v[v[k>>2]+8>>2]](k);se(k);break Td}k=M()|0;break xd}k=M()|0;Gb(l);break xd}k=M()|0;Sf(s+16|0);break xd}if(!(A[x+v[b+224>>2]>>3]>-e)){break Td}d=A[x+v[s+36>>2]>>3];c=D(d);c=c<$?$:c;if(!(A[a+296>>3]>=D((K-d)/(c>1?c:1)))){break Td}v[111924]=0;l=S(2157,24)|0;j=v[111924];v[111924]=0;he:{ie:{if((j|0)!=1){c=A[x+v[b+224>>2]>>3];v[111924]=0;G=na(2444,l|0,b|0,h|0,+c)|0;j=v[111924];v[111924]=0;if((j|0)==1){break ie}v[111924]=0;v[s+16>>2]=G;k=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){k=M()|0;zb[v[v[G>>2]+4>>2]](G);break xd}v[k+12>>2]=G;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=376944;v[s+20>>2]=k;j=v[a+220>>2];je:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=k;v[j>>2]=G;v[k+4>>2]=v[k+4>>2]+1;v[a+220>>2]=j+8;break je}v[111924]=0;O(2441,r|0,s+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break he}}k=v[v[b>>2]+176>>2];j=v[b+224>>2];v[111924]=0;W(k|0,b|0,h|0,j+x|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break he}j=v[a+312>>2];v[j+44>>2]=v[j+44>>2]+1;k=v[s+20>>2];if(!k){break Td}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break Td}zb[v[v[k>>2]+8>>2]](k);se(k);break Td}k=M()|0;break xd}k=M()|0;Gb(l);break xd}k=M()|0;Sf(s+16|0);break xd}k=M()|0;break xd}f=A[x+v[b+224>>2]>>3];e=D(f);d=A[x+v[b+236>>2]>>3];c=D(d);c=c<e?e:c;if(!(A[a+288>>3]>=D((f-d)/(c>1?c:1)))){break Sd}v[111924]=0;W(2451,a|0,b|0,h|0,1);j=v[111924];v[111924]=0;if((j|0)==1){break Id}k=v[(v[b+168>>2]+B(v[(x+v[b+172>>2]|0)+4>>2],24)|0)+8>>2];j=v[a+176>>2];v[j+(h<<2)>>2]=v[(j+(v[b+184>>2]<<2)|0)-4>>2];j=v[v[b>>2]+80>>2];v[111924]=0;O(j|0,b|0,h|0);j=v[111924];v[111924]=0;if((j|0)==1){break Id}j=v[a+312>>2];v[j+20>>2]=v[j+20>>2]+1;Z=k+Z|0;E=E+1|0}if(i>>>0>1){continue}break}}i=0;k=E+H|0;if((k|0)<=0){break Jd}v[a+16>>2]=v[a+16>>2]+H;v[a+20>>2]=v[a+20>>2]+E;v[a+24>>2]=v[a+24>>2]+Z;ke:{j=v[a+64>>2];if(!j){break ke}h=v[j+4>>2];if((h|0)<4){break ke}v[s+12>>2]=h;v[s+16>>2]=4;h=v[v[j>>2]+8>>2];v[111924]=0;l=j;j=s+16|0;O(h|0,l|0,j|0);h=v[111924];v[111924]=0;if((h|0)!=1){l=v[a+64>>2];h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,249114,26)|0;h=v[111924];v[111924]=0;le:{if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,H|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,253565,7)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,E|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,253622,7)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,Z|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}h=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,38399,10)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}r=v[v[l+8>>2]+(v[l+4>>2]<<2)>>2];h=v[v[r>>2]-12>>2];v[111924]=0;h=v[(h+r|0)+28>>2];v[j>>2]=h;v[h+4>>2]=v[h+4>>2]+1;h=v[111924];v[111924]=0;if((h|0)==1){break le}v[111924]=0;j=N(1122,j|0,448956)|0;h=v[111924];v[111924]=0;me:{if((h|0)!=1){h=v[v[j>>2]+28>>2];v[111924]=0;j=N(h|0,j|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break me}}k=M()|0;b=v[s+16>>2];a=v[b+4>>2]-1|0;v[b+4>>2]=a;if((a|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break xd}l=v[s+16>>2];h=v[l+4>>2]-1|0;v[l+4>>2]=h;if((h|0)==-1){zb[v[v[l>>2]+8>>2]](l)}v[111924]=0;N(2270,r|0,j|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}v[111924]=0;S(2271,r|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break le}j=v[a+64>>2];h=v[v[j>>2]+8>>2];v[111924]=0;O(h|0,j|0,s+12|0);h=v[111924];v[111924]=0;if((h|0)!=1){break ke}}k=M()|0;break xd}k=M()|0;break xd}if(!(+(k|0)>A[a+56>>3]*+(n+q|0))){break Jd}t[_+31|0]=1}h=v[s+24>>2];if(h){v[s+28>>2]=h;Gb(h)}h=v[s+36>>2];if(h){v[s+40>>2]=h;Gb(h)}h=v[s+48>>2];if(h){v[s+52>>2]=h;Gb(h)}h=v[s+60>>2];if(h){v[s+64>>2]=h;Gb(h)}h=v[s+80>>2];if(h){Gb(h)}ub=s+96|0;h=i;break sd}k=M()|0}a=v[s+24>>2];if(!a){break wd}v[s+28>>2]=a;Gb(a)}a=v[s+36>>2];if(!a){break ud}v[s+40>>2]=a;Gb(a)}a=v[s+48>>2];if(!a){break td}v[s+52>>2]=a;Gb(a)}a=v[s+60>>2];if(a){v[s+64>>2]=a;Gb(a)}a=v[s+80>>2];if(a){Gb(a)}P(k|0);p()}v[a+340>>2]=h;if(h){break Wb}h=0;j=0;fa=0;oa=0;G=0;o=ub-304|0;ub=o;E=v[b+40>>2];ne:{oe:{pe:{qe:{re:{se:{te:{ue:{ve:{we:{xe:{ye:{ze:{Ae:{Be:{Ce:{l=Q_(a,b);De:{if(l){break De}l=0;v[o+280>>2]=0;k=v[b+40>>2];if((k|0)<=0){break De}while(1){i=v[b+24>>2]+B(v[(v[b+28>>2]+(l<<3)|0)+4>>2],24)|0;if(v[i+8>>2]==1){S_(a,b,i,o+280|0);k=v[b+40>>2];l=v[o+280>>2];h=h+1|0}l=l+1|0;v[o+280>>2]=l;if((k|0)>(l|0)){continue}break}l=0;Ee:{if((h|0)<=0){break Ee}q=v[a+64>>2];if(!q){break Ee}i=v[q+4>>2];if((i|0)<4){break Ee}v[o+256>>2]=i;v[o+280>>2]=4;i=o+280|0;zb[v[v[q>>2]+8>>2]](q,i);k=v[a+64>>2];Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],249141,56);pd(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],h);Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],253565,7);pd(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],h);Nb(v[v[k+8>>2]+(v[k+4>>2]<<2)>>2],38399,10);q=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];h=v[(v[v[q>>2]-12>>2]+q|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;Fe:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break Fe}}l=M()|0;b=v[o+280>>2];a=v[b+4>>2]-1|0;v[b+4>>2]=a;if((a|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break oe}k=v[o+280>>2];h=v[k+4>>2]-1|0;v[k+4>>2]=h;if((h|0)==-1){zb[v[v[k>>2]+8>>2]](k)}bc(q,i);$b(q);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,o+256|0);k=v[b+40>>2]}if((k|0)<2){break De}v[o+296>>2]=858993459;v[o+300>>2]=1072902963;v[o+288>>2]=0;v[o+284>>2]=k;v[o+280>>2]=k;Mc(o+288|0,k);i=v[b+40>>2];v[o+272>>2]=858993459;v[o+276>>2]=1072902963;v[o+264>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[o+256>>2]=h;h=(i|0)<=0?1:h;v[o+260>>2]=h;O(2265,o+264|0,h|0);h=v[111924];v[111924]=0;Ge:{if((h|0)!=1){h=v[b+40>>2];v[o+252>>2]=0;v[o+244>>2]=0;v[o+248>>2]=0;He:{Ie:{Je:{Ke:{if(h){v[111924]=0;O(2198,o+244|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break Ke}j=v[b+40>>2]}i=0;v[111924]=0;v[o+240>>2]=0;O(2265,o+240|0,j|0);h=v[111924];v[111924]=0;l=1;if((h|0)!=1){break He}l=T(371412)|0;if((vb|0)!=(Y(371412)|0)){break se}a=X(l|0)|0;Gb(v[o+240>>2]);v[o+240>>2]=0;g=Ub(16);v[111924]=0;b=N(2311,g|0,a|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Je}v[111924]=0;R(2152,b|0,371412,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break pe}l=M()|0;break Ie}l=M()|0;a=v[o+244>>2];if(!a){break re}v[o+248>>2]=a;Gb(a);break re}l=M()|0;ac(g)}v[111924]=0;V(1128);a=v[111924];v[111924]=0;if((a|0)!=1){break se}T(0)|0;md();break pe}h=v[o+240>>2];r=v[o+288>>2];v[r>>2]=0;n=v[o+244>>2];v[n>>2]=0;v[n+4>>2]=0;q=v[o+264>>2];j=v[b+40>>2];v[q>>2]=j;if((j|0)>1){while(1){k=l<<2;v[k+r>>2]=0;j=n+(l<<3)|0;v[j>>2]=0;v[j+4>>2]=0;v[k+q>>2]=0;v[h+(i<<2)>>2]=l;i=i+1|0;l=l+1|0;if((l|0)<v[b+40>>2]){continue}break}}Le:{Me:{Ne:{if(v[b+184>>2]>0){while(1){j=0;s=v[b+168>>2]+B(v[(v[b+172>>2]+(fa<<3)|0)+4>>2],24)|0;Oe:{if(v[s+8>>2]<=0){break Oe}Pe:{Qe:{while(1){k=v[s>>2]+(j<<4)|0;d=A[k>>3];n=v[k+8>>2];k=v[o+244>>2]+(n<<3)|0;c=A[k>>3];if(c==0){A[k>>3]=d;c=d}l=n<<2;J=v[a+228>>2]+B(v[l+v[o+288>>2]>>2],20)|0;x=v[J+12>>2];Re:{if((x|0)>=v[J+8>>2]){r=x+1|0;k=(r>>>0<=1?1:r)<<4;q=Qf(v[J+16>>2],k);if(!q){v[111924]=0;b=Q(2258,448052,248313,50)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Qe}v[111924]=0;b=N(2259,b|0,k|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Qe}v[111924]=0;b=Q(2258,b|0,49759,6)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Qe}v[111924]=0;S(2260,b|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Qe}i=Ub(16);v[111924]=0;j=N(2255,o+216|0,3686)|0;a=v[111924];v[111924]=0;if((a|0)==1){break Re}v[i>>2]=371744;g=i+4|0;Se:{Te:{if(t[j+11|0]>=0){a=v[j+4>>2];v[g>>2]=v[j>>2];v[g+4>>2]=a;v[g+8>>2]=v[j+8>>2];break Te}b=v[j+4>>2];a=v[j>>2];v[111924]=0;R(2167,g|0,a|0,b|0);a=v[111924];v[111924]=0;h=1;if((a|0)==1){break Se}}v[i>>2]=373292;h=0;v[111924]=0;R(2152,i|0,371412,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break pe}}l=M()|0;if(t[j+11|0]<0){Gb(v[j>>2])}if(!h){break se}ac(i);break se}v[J+12>>2]=x;v[J+8>>2]=r;v[J+4>>2]=q;v[J+16>>2]=q}c=d/c;if(c!=0){k=v[J+4>>2]+(x<<4)|0;A[k>>3]=c;v[k+8>>2]=n;v[J+12>>2]=x+1}l=l+v[o+288>>2]|0;k=v[o+264>>2]+(v[l>>2]<<2)|0;q=v[k>>2]-1|0;v[k>>2]=q;if(!q){v[h+(i<<2)>>2]=v[l>>2];i=i+1|0}j=j+1|0;l=v[s+8>>2];if((j|0)>=(l|0)){break Pe}continue}break}l=M()|0;ac(i);break se}l=M()|0;break se}if((l|0)<=0){break Oe}L=v[a+228>>2];H=0;while(1){q=B(v[v[o+288>>2]+(v[(v[s>>2]+(H<<4)|0)+8>>2]<<2)>>2],20);j=q+L|0;k=v[j+12>>2];if((k|0)>0){if((k|0)!=1){j=v[j+4>>2];v[111924]=0;ED(j,k,o+216|0,0,1);j=v[111924];v[111924]=0;if((j|0)==1){break Ne}L=v[a+228>>2]}k=v[h>>2];i=i-1|0;v[h>>2]=v[h+(i<<2)>>2];x=q+L|0;Ue:{if(v[x+12>>2]<=0){break Ue}z=A[a+280>>3];n=v[o+264>>2];q=v[o+288>>2];r=v[x+4>>2];v[q+(v[r+8>>2]<<2)>>2]=k;j=n+(k<<2)|0;v[j>>2]=v[j>>2]+1;if(v[x+12>>2]<2){break Ue}d=A[r>>3];l=1;while(1){j=r+(l<<4)|0;c=A[j>>3];f=D(c);e=D(d);e=e<f?f:e;if(z<D((c-d)/(e>1?e:1))){k=v[h>>2];i=i-1|0;v[h>>2]=v[h+(i<<2)>>2]}v[q+(v[j+8>>2]<<2)>>2]=k;j=n+(k<<2)|0;v[j>>2]=v[j>>2]+1;d=c;l=l+1|0;if((l|0)<v[x+12>>2]){continue}break}}v[x+12>>2]=0;l=v[s+8>>2]}H=H+1|0;if((H|0)<(l|0)){continue}break}}fa=fa+1|0;if((fa|0)<v[b+184>>2]){continue}break}h=v[o+240>>2]}Gb(h);v[o+240>>2]=0;i=v[b+40>>2];v[o+232>>2]=858993459;v[o+236>>2]=1072902963;v[o+224>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[o+216>>2]=h;h=(i|0)<=0?1:h;v[o+220>>2]=h;O(2392,o+224|0,h|0);h=v[111924];v[111924]=0;Ve:{if((h|0)!=1){Z=v[b+40>>2];We:{if((Z|0)<=0){break We}k=v[a+252>>2];j=0;l=0;if(Z>>>0>=8){i=Z&2147483640;h=0;while(1){v[(k+B(l,20)|0)+12>>2]=0;v[(k+B(l|1,20)|0)+12>>2]=0;v[(k+B(l|2,20)|0)+12>>2]=0;v[(k+B(l|3,20)|0)+12>>2]=0;v[(k+B(l|4,20)|0)+12>>2]=0;v[(k+B(l|5,20)|0)+12>>2]=0;v[(k+B(l|6,20)|0)+12>>2]=0;v[(k+B(l|7,20)|0)+12>>2]=0;l=l+8|0;h=h+8|0;if((i|0)!=(h|0)){continue}break}}h=Z&7;if(h){while(1){v[(k+B(l,20)|0)+12>>2]=0;l=l+1|0;j=j+1|0;if((h|0)!=(j|0)){continue}break}}if((Z|0)<=0){break We}k=0;while(1){t[v[o+224>>2]+k|0]=0;l=v[a+252>>2]+B(v[v[o+288>>2]+(k<<2)>>2],20)|0;j=v[l+12>>2];if((j|0)>=v[l+8>>2]){v[111924]=0;i=j+1|0;O(2313,l+16|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Me}v[l+12>>2]=j;v[l+8>>2]=i;v[l+4>>2]=v[l+16>>2];Z=v[b+40>>2]}k=k+1|0;if((Z|0)>(k|0)){continue}break}}v[111924]=0;v[o+212>>2]=0;O(2265,o+212|0,Z|0);h=v[111924];v[111924]=0;if((h|0)==1){break Le}if((Z|0)>0){Wb(v[o+212>>2],0,Z<<2)}k=v[b+40>>2];if((k|0)>0){break Ve}H=-1;j=-1;break Ge}l=M()|0;break se}x=v[b+28>>2];n=v[b+24>>2];r=v[a+252>>2];q=v[o+212>>2];i=0;j=-1;H=-1;while(1){s=r+B(i,20)|0;Xe:{if(v[s+12>>2]<2){break Xe}h=v[s+4>>2];if(v[(n+B(v[(x+(v[h+8>>2]<<3)|0)+4>>2],24)|0)+8>>2]==1){break Xe}H=(H|0)<0?i:H;l=1;while(1){v[q+(v[(h+(l<<4)|0)+8>>2]<<2)>>2]=-1;l=l+1|0;if((l|0)<v[s+12>>2]){continue}break}k=v[b+40>>2];j=i}i=i+1|0;if((k|0)>(i|0)){continue}break}break Ge}l=M()|0;break se}l=M()|0;break te}l=M()|0;break te}l=M()|0;break qe}Ye:{if((Z|0)<=0){break Ye}l=0;q=v[o+212>>2];k=0;if((Z|0)!=1){i=Z&2147483646;h=0;while(1){r=q+(k<<2)|0;if(v[r>>2]>=0){v[r>>2]=l;l=l+1|0}if(v[r+4>>2]>=0){v[r+4>>2]=l;l=l+1|0}k=k+2|0;h=h+2|0;if((i|0)!=(h|0)){continue}break}}if(!(Z&1)){break Ye}h=q+(k<<2)|0;if(v[h>>2]<0){break Ye}v[h>>2]=l}v[o+208>>2]=0;v[o+200>>2]=0;v[o+204>>2]=0;h=v[b+84>>2];i=v[b+80>>2];if((h|0)!=(i|0)){k=h-i|0;if((k|0)<0){v[111924]=0;U(2426,o+200|0);a=v[111924];v[111924]=0;if((a|0)!=1){break pe}break ve}v[111924]=0;l=S(2157,k|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ve}v[o+204>>2]=l;v[o+200>>2]=l;h=k+l|0;v[o+208>>2]=h;Kc(l,i,k);v[o+204>>2]=h}v[o+196>>2]=0;v[o+188>>2]=0;v[o+192>>2]=0;h=v[b+96>>2];i=v[b+92>>2];if((h|0)!=(i|0)){k=h-i|0;if((k|0)<0){v[111924]=0;U(2426,o+188|0);a=v[111924];v[111924]=0;if((a|0)!=1){break pe}break xe}v[111924]=0;l=S(2157,k|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break xe}v[o+192>>2]=l;v[o+188>>2]=l;h=k+l|0;v[o+196>>2]=h;Kc(l,i,k);v[o+192>>2]=h}Ze:{_e:{$e:{af:{bf:{cf:{k=v[b+40>>2];df:{if((k|0)<=0){break df}m=(Z|0)>0?Z:0;ba=(Z|0)<=0;I=ba?1:m;ca=Z&2147483644;ma=Z&3;ja=a+216|0;J=o+72|0;s=o+96|0;C=o+144|0;x=o+8|0;n=o+32|0;r=o+168|0;while(1){qa=B(oa,20);h=qa+v[a+252>>2]|0;i=v[h+12>>2];if(!((i|0)<2|v[(v[b+24>>2]+B(v[(v[b+28>>2]+(v[v[h+4>>2]+8>>2]<<3)|0)+4>>2],24)|0)+8>>2]==1)){h=v[a+312>>2];v[h+48>>2]=(i+v[h+48>>2]|0)-1;c=A[48091];i=v[(qa+v[a+252>>2]|0)+12>>2];v[o+176>>2]=858993459;v[o+180>>2]=1072902963;v[o+168>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[o+160>>2]=h;h=(i|0)<=0?1:h;v[o+164>>2]=h;O(2392,r|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break ye}ha=1;i=v[a+252>>2];h=qa+i|0;ef:{if(v[h+12>>2]<=0){break ef}k=h+4|0;e=-c;sa=-1;l=0;pa=-1;h=-1;while(1){k=v[(v[k>>2]+(l<<4)|0)+8>>2];q=k<<3;z=A[q+v[b+80>>2]>>3];f=A[q+v[b+92>>2]>>3];t[v[o+168>>2]+l|0]=z==f;ff:{if((h|0)==-1){h=k;e=z;c=f;break ff}i=v[o+244>>2];K=A[i+(h<<3)>>3]/A[i+q>>3];gf:{if(K>0){d=A[48091];F=-d;if(!(z<=F)){F=K*A[q+v[b+80>>2]>>3]}f=A[q+v[b+92>>2]>>3];if(f>=d){break gf}d=K*f;break gf}d=A[48091];hf:{if(f>=d){F=-d;break hf}F=K*A[q+v[b+92>>2]>>3]}f=A[q+v[b+80>>2]>>3];if(f<=-d){break gf}d=K*f}t[k+v[o+224>>2]|0]=1;i=c>d;c=i?d:c;sa=i?k:sa;i=e<F;e=i?F:e;pa=i?k:pa;i=v[a+252>>2]}q=i+qa|0;k=q+4|0;l=l+1|0;if((l|0)<v[q+12>>2]){continue}break}if((h|0)==-1){break ef}fa=h<<3;d=A[fa+v[b+92>>2]>>3];F=c<d?c:d;d=A[fa+v[b+80>>2]>>3];K=d<e?e:d;jf:{kf:{lf:{mf:{nf:{of:{pf:{qf:{rf:{if((j|0)==(oa|0)){v[o+152>>2]=858993459;v[o+156>>2]=1072902963;v[o+144>>2]=0;v[o+140>>2]=I;v[o+136>>2]=m;v[111924]=0;O(2265,C|0,I|0);i=v[111924];v[111924]=0;sf:{if((i|0)!=1){if(ba){break qf}k=0;ka=v[o+144>>2];qa=v[o+212>>2];l=0;L=0;if(Z>>>0>3){break sf}break rf}l=M()|0;break ze}while(1){q=l<<2;v[q+ka>>2]=v[q+qa>>2];i=q|4;v[i+ka>>2]=v[i+qa>>2];i=q|8;v[i+ka>>2]=v[i+qa>>2];i=q|12;v[i+ka>>2]=v[i+qa>>2];l=l+4|0;L=L+4|0;if((ca|0)!=(L|0)){continue}break}break rf}v[o+152>>2]=858993459;v[o+156>>2]=1072902963;v[o+144>>2]=0;v[o+136>>2]=0;v[o+140>>2]=1;v[111924]=0;O(2265,C|0,1);i=v[111924];v[111924]=0;tf:{uf:{vf:{wf:{xf:{yf:{zf:{Af:{Bf:{if((i|0)!=1){v[111924]=0;q=S(2157,160)|0;i=v[111924];v[111924]=0;if((i|0)==1){break Bf}l=v[a+252>>2];v[o+60>>2]=0;v[o+52>>2]=0;v[o+56>>2]=0;v[111924]=0;k=v[o+244>>2];i=v[o+248>>2];W(2347,o+52|0,k|0,i|0,i-k>>3);i=v[111924];v[111924]=0;if((i|0)==1){break vf}v[o+24>>2]=v[o+136>>2];v[o+32>>2]=0;i=v[o+140>>2];v[o+28>>2]=i;A[o+40>>3]=A[o+152>>3];v[111924]=0;O(2265,n|0,i|0);i=v[111924];v[111924]=0;if((i|0)==1){break vf}i=v[o+24>>2];if(i){Kc(v[o+32>>2],v[o+144>>2],i<<2)}v[o>>2]=v[o+160>>2];v[o+8>>2]=0;i=v[o+164>>2];v[o+4>>2]=i;A[o+16>>3]=A[o+176>>3];v[111924]=0;O(2392,x|0,i|0);i=v[111924];v[111924]=0;if((i|0)==1){break Af}i=v[o>>2];if(i){Kc(v[o+8>>2],v[o+168>>2],i)}v[111924]=0;z=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break zf}v[111924]=0;f=D(K);d=D(F);d=d<f?f:d;i=Ia(2453,q|0,b|0,h|0,pa|0,sa|0,l+qa|0,o+52|0,o+24|0,o|0,0,z>=D((K-F)/(d>1?d:1))|0,(H|0)==(oa|0)|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break zf}v[111924]=0;v[o+128>>2]=i;k=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){l=M()|0;zb[v[v[i>>2]+4>>2]](i);k=0;break yf}v[k+12>>2]=i;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=379380;v[o+132>>2]=k;h=v[o+8>>2];if(h){Gb(h);v[o+8>>2]=0}h=v[o+32>>2];if(h){Gb(h);v[o+32>>2]=0}h=v[o+52>>2];if(h){v[o+56>>2]=h;Gb(h)}i=v[a+220>>2];Cf:{if((i|0)!=v[a+224>>2]){v[i>>2]=v[o+128>>2];h=v[o+132>>2];v[i+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=i+8;break Cf}v[111924]=0;O(2441,ja|0,o+128|0);h=v[111924];v[111924]=0;if((h|0)==1){break wf}}i=v[o+132>>2];Df:{if(!i){break Df}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Df}zb[v[v[i>>2]+8>>2]](i);se(i)}h=v[o+144>>2];if(!h){break pf}Gb(h);break pf}l=M()|0;break ze}l=M()|0;break tf}l=M()|0;k=1;break xf}l=M()|0;k=1}a=v[o+8>>2];if(!a){break xf}Gb(a);v[o+8>>2]=0}a=v[o+32>>2];if(a){Gb(a);v[o+32>>2]=0}a=v[o+52>>2];if(a){v[o+56>>2]=a;Gb(a)}if(!k){break tf}break uf}l=M()|0;Sf(o+128|0);break tf}l=M()|0;a=v[o+52>>2];if(!a){break uf}v[o+56>>2]=a;Gb(a);Gb(q);break tf}Gb(q)}a=v[o+144>>2];if(!a){break ze}Gb(a);break ze}if(!ma){break qf}while(1){i=l<<2;v[i+ka>>2]=v[i+qa>>2];l=l+1|0;k=k+1|0;if((ma|0)!=(k|0)){continue}break}}v[111924]=0;q=S(2157,160)|0;i=v[111924];v[111924]=0;if((i|0)==1){l=M()|0;break Ae}l=v[a+252>>2];v[o+124>>2]=0;v[o+116>>2]=0;v[o+120>>2]=0;v[111924]=0;k=v[o+244>>2];i=v[o+248>>2];W(2347,o+116|0,k|0,i|0,i-k>>3);i=v[111924];v[111924]=0;if((i|0)==1){break Ce}v[o+88>>2]=v[o+136>>2];v[o+96>>2]=0;i=v[o+140>>2];v[o+92>>2]=i;A[o+104>>3]=A[o+152>>3];v[111924]=0;O(2265,s|0,i|0);i=v[111924];v[111924]=0;if((i|0)==1){break Ce}i=v[o+88>>2];if(i){Kc(v[o+96>>2],v[o+144>>2],i<<2)}v[o+64>>2]=v[o+160>>2];v[o+72>>2]=0;i=v[o+164>>2];v[o+68>>2]=i;A[o+80>>3]=A[o+176>>3];v[111924]=0;O(2392,J|0,i|0);i=v[111924];v[111924]=0;if((i|0)==1){break of}i=v[o+64>>2];if(i){Kc(v[o+72>>2],v[o+168>>2],i)}v[111924]=0;z=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break nf}v[111924]=0;f=D(K);d=D(F);d=d<f?f:d;i=Ia(2453,q|0,b|0,h|0,pa|0,sa|0,l+B(j,20)|0,o+116|0,o+88|0,o- -64|0,1,z>=D((K-F)/(d>1?d:1))|0,(j|0)==(H|0)|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break nf}v[111924]=0;v[o+128>>2]=i;k=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){l=M()|0;zb[v[v[i>>2]+4>>2]](i);h=0;break mf}v[k+12>>2]=i;v[k+4>>2]=0;v[k+8>>2]=0;v[k>>2]=379380;v[o+132>>2]=k;h=v[o+72>>2];if(h){Gb(h);v[o+72>>2]=0}h=v[o+96>>2];if(h){Gb(h);v[o+96>>2]=0}h=v[o+116>>2];if(h){v[o+120>>2]=h;Gb(h)}i=v[a+220>>2];Ef:{if((i|0)!=v[a+224>>2]){v[i>>2]=v[o+128>>2];h=v[o+132>>2];v[i+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=i+8;break Ef}v[111924]=0;O(2441,ja|0,o+128|0);h=v[111924];v[111924]=0;if((h|0)==1){break kf}}i=v[o+132>>2];Ff:{if(!i){break Ff}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Ff}zb[v[v[i>>2]+8>>2]](i);se(i)}h=v[o+144>>2];if(!h){break pf}Gb(h)}if(!(A[fa+v[b+80>>2]>>3]<e|A[fa+v[b+92>>2]>>3]>c)){break ef}d=D(F);c=D(K);c=c<d?d:c;if(!(-A[a+288>>3]>=(F-K)/(c>1?c:1))){break jf}Gb(v[o+212>>2]);ha=0;v[o+212>>2]=0;G=1;break ef}l=M()|0;h=1;break lf}l=M()|0;h=1}a=v[o+72>>2];if(!a){break lf}Gb(a);v[o+72>>2]=0}a=v[o+96>>2];if(a){Gb(a);v[o+96>>2]=0}a=v[o+116>>2];if(a){v[o+120>>2]=a;Gb(a)}if(!h){break Ae}break Be}l=M()|0;Sf(o+128|0);break Ae}A[fa+v[o+200>>2]>>3]=K;A[fa+v[o+188>>2]>>3]=F<K?K:F;G=1}h=v[o+168>>2];if(h){Gb(h)}if(!ha){l=1;break Ze}k=v[b+40>>2]}oa=oa+1|0;if((oa|0)<(k|0)){continue}break}if(!G){break df}h=v[v[b>>2]+220>>2];v[111924]=0;W(h|0,b|0,o+200|0,o+188|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break cf}k=v[b+40>>2]}i=0;v[111924]=0;v[o+160>>2]=0;O(2265,o+160|0,k|0);h=v[111924];v[111924]=0;if((h|0)==1){break af}h=0;if((k|0)<=0){break bf}n=v[b+28>>2];r=v[b+24>>2];q=v[o+160>>2];j=v[o+224>>2];l=0;while(1){G=q+(l<<2)|0;Gf:{if(w[j+l|0]){v[G>>2]=-1;h=h+1|0;i=v[(r+B(v[(n+(l<<3)|0)+4>>2],24)|0)+8>>2]+i|0;break Gf}v[G>>2]=0}l=l+1|0;if((l|0)!=(k|0)){continue}break}break bf}l=M()|0;break we}j=v[v[b>>2]+64>>2];v[111924]=0;O(j|0,b|0,v[o+160>>2]);j=v[111924];v[111924]=0;if((j|0)==1){break af}j=v[o+160>>2];if((k|0)>0){G=k&1;x=v[a+200>>2];l=0;if((k|0)!=1){n=k&2147483646;k=0;while(1){r=l<<2;q=v[r+j>>2];if((q|0)>=0){v[x+(q<<2)>>2]=v[r+x>>2]}r=(l|1)<<2;q=v[r+j>>2];if((q|0)>=0){v[x+(q<<2)>>2]=v[r+x>>2]}l=l+2|0;k=k+2|0;if((n|0)!=(k|0)){continue}break}}Hf:{if(!G){break Hf}k=l<<2;j=v[k+j>>2];if((j|0)<0){break Hf}v[x+(j<<2)>>2]=v[k+x>>2]}j=v[o+160>>2]}Gb(j);l=0;v[o+160>>2]=0;Gb(v[o+212>>2]);v[o+212>>2]=0;if((h+i|0)<=0){break Ze}v[a+16>>2]=v[a+16>>2]+h;v[a+24>>2]=v[a+24>>2]+i;k=v[a+64>>2];if(!k){break _e}j=v[k+4>>2];if((j|0)>=4){break $e}break _e}l=M()|0;break we}v[o+136>>2]=j;v[o+128>>2]=4;j=v[v[k>>2]+8>>2];v[111924]=0;O(j|0,k|0,o+128|0);j=v[111924];v[111924]=0;if((j|0)!=1){j=v[a+64>>2];v[111924]=0;k=N(2345,j|0,248896)|0;j=v[111924];v[111924]=0;If:{if((j|0)==1){break If}j=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];v[111924]=0;N(2359,j|0,h|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break If}v[111924]=0;k=N(2345,k|0,253565)|0;j=v[111924];v[111924]=0;if((j|0)==1){break If}j=v[v[k+8>>2]+(v[k+4>>2]<<2)>>2];v[111924]=0;N(2359,j|0,i|0)|0;i=v[111924];v[111924]=0;if((i|0)==1){break If}v[111924]=0;j=N(2345,k|0,38399)|0;i=v[111924];v[111924]=0;if((i|0)==1){break If}i=v[v[j+8>>2]+(v[j+4>>2]<<2)>>2];v[111924]=0;S(2260,i|0)|0;i=v[111924];v[111924]=0;if((i|0)==1){break If}j=v[a+64>>2];i=v[v[j>>2]+8>>2];v[111924]=0;O(i|0,j|0,o+136|0);i=v[111924];v[111924]=0;if((i|0)!=1){break _e}}l=M()|0;break we}l=M()|0;break we}if(!(+(h|0)>A[a+56>>3]*+(E|0))){break Ze}t[_+31|0]=1}h=v[o+188>>2];if(h){v[o+192>>2]=h;Gb(h)}h=v[o+200>>2];if(h){v[o+204>>2]=h;Gb(h)}h=v[o+224>>2];if(h){Gb(h)}h=v[o+244>>2];if(h){v[o+248>>2]=h;Gb(h)}h=v[o+264>>2];if(h){Gb(h)}h=v[o+288>>2];if(!h){break De}Gb(h)}ub=o+304|0;h=l;break ne}l=M()|0;a=v[o+116>>2];if(!a){break Be}v[o+120>>2]=a;Gb(a);Gb(q);break Ae}Gb(q)}a=v[o+144>>2];if(!a){break ze}Gb(a)}a=v[o+168>>2];if(!a){break we}Gb(a);break we}l=M()|0;break we}l=M()|0}a=v[o+188>>2];if(!a){break ue}v[o+192>>2]=a;Gb(a);break ue}l=M()|0}a=v[o+200>>2];if(!a){break te}v[o+204>>2]=a;Gb(a)}a=v[o+224>>2];if(!a){break se}Gb(a)}a=v[o+244>>2];if(!a){break re}v[o+248>>2]=a;Gb(a)}a=v[o+264>>2];if(!a){break qe}Gb(a)}a=v[o+288>>2];if(!a){break oe}Gb(a);P(l|0);p()}p()}P(l|0);p()}v[a+340>>2]=h;if(h){break Wb}k=0;l=0;m=ub-256|0;ub=m;Jf:{Kf:{Lf:{Mf:{Nf:{Of:{Pf:{Qf:{Rf:{Sf:{Tf:{Uf:{Vf:{j=Q_(a,b);Wf:{if(j){break Wf}j=0;h=v[b+184>>2];if((h|0)<2){break Wf}v[m+248>>2]=858993459;v[m+252>>2]=1072902963;v[m+240>>2]=0;v[m+236>>2]=h;v[m+232>>2]=h;Mc(m+240|0,h);i=v[b+184>>2];v[m+224>>2]=858993459;v[m+228>>2]=1072902963;v[m+216>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[m+208>>2]=h;h=(i|0)<=0?1:h;v[m+212>>2]=h;O(2265,m+216|0,h|0);h=v[111924];v[111924]=0;Xf:{Yf:{Zf:{_f:{$f:{ag:{bg:{cg:{dg:{if((h|0)!=1){h=v[b+184>>2];v[m+204>>2]=0;v[m+196>>2]=0;v[m+200>>2]=0;eg:{fg:{gg:{hg:{if(h){v[111924]=0;O(2198,m+196|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break hg}l=v[b+184>>2]}v[111924]=0;v[m+192>>2]=0;O(2265,m+192|0,l|0);h=v[111924];v[111924]=0;j=1;if((h|0)!=1){break eg}i=T(371412)|0;if((vb|0)!=(Y(371412)|0)){break Nf}a=X(i|0)|0;Gb(v[m+192>>2]);v[m+192>>2]=0;g=Ub(16);v[111924]=0;b=N(2311,g|0,a|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break gg}v[111924]=0;R(2152,b|0,371412,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break Kf}i=M()|0;break fg}i=M()|0;a=v[m+196>>2];if(!a){break Mf}v[m+200>>2]=a;Gb(a);break Mf}i=M()|0;ac(g)}v[111924]=0;V(1128);a=v[111924];v[111924]=0;if((a|0)!=1){break Nf}T(0)|0;md();break Kf}h=v[m+192>>2];r=v[m+240>>2];v[r>>2]=0;n=v[m+196>>2];v[n>>2]=0;v[n+4>>2]=0;q=v[m+216>>2];i=v[b+184>>2];v[q>>2]=i;if((i|0)>1){while(1){l=j<<2;v[l+r>>2]=0;i=n+(j<<3)|0;v[i>>2]=0;v[i+4>>2]=0;v[l+q>>2]=0;v[h+(k<<2)>>2]=j;k=k+1|0;j=j+1|0;if((j|0)<v[b+184>>2]){continue}break}}ig:{if(v[b+40>>2]>0){Z=0;while(1){l=0;x=v[b+24>>2]+B(v[(v[b+28>>2]+(Z<<3)|0)+4>>2],24)|0;jg:{if(v[x+8>>2]<=0){break jg}kg:{lg:{while(1){i=v[x>>2]+(l<<4)|0;d=A[i>>3];n=v[i+8>>2];i=v[m+196>>2]+(n<<3)|0;c=A[i>>3];if(c==0){A[i>>3]=d;c=d}j=n<<2;s=v[a+240>>2]+B(v[j+v[m+240>>2]>>2],20)|0;G=v[s+12>>2];mg:{if((G|0)>=v[s+8>>2]){r=G+1|0;i=(r>>>0<=1?1:r)<<4;q=Qf(v[s+16>>2],i);if(!q){v[111924]=0;b=Q(2258,448052,248313,50)|0;a=v[111924];v[111924]=0;if((a|0)==1){break lg}v[111924]=0;b=N(2259,b|0,i|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break lg}v[111924]=0;b=Q(2258,b|0,49759,6)|0;a=v[111924];v[111924]=0;if((a|0)==1){break lg}v[111924]=0;S(2260,b|0)|0;a=v[111924];v[111924]=0;if((a|0)==1){break lg}h=Ub(16);v[111924]=0;j=N(2255,m+168|0,3686)|0;a=v[111924];v[111924]=0;if((a|0)==1){break mg}v[h>>2]=371744;g=h+4|0;ng:{og:{if(t[j+11|0]>=0){a=v[j+4>>2];v[g>>2]=v[j>>2];v[g+4>>2]=a;v[g+8>>2]=v[j+8>>2];break og}b=v[j+4>>2];a=v[j>>2];v[111924]=0;R(2167,g|0,a|0,b|0);a=v[111924];v[111924]=0;E=1;if((a|0)==1){break ng}}v[h>>2]=373292;E=0;v[111924]=0;R(2152,h|0,371412,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break Kf}}i=M()|0;if(t[j+11|0]<0){Gb(v[j>>2])}if(!E){break Nf}ac(h);break Nf}v[s+12>>2]=G;v[s+8>>2]=r;v[s+4>>2]=q;v[s+16>>2]=q}c=d/c;if(c!=0){i=v[s+4>>2]+(G<<4)|0;A[i>>3]=c;v[i+8>>2]=n;v[s+12>>2]=G+1}j=j+v[m+240>>2]|0;i=v[m+216>>2]+(v[j>>2]<<2)|0;q=v[i>>2]-1|0;v[i>>2]=q;if(!q){v[h+(k<<2)>>2]=v[j>>2];k=k+1|0}j=v[x+8>>2];l=l+1|0;if((j|0)<=(l|0)){break kg}continue}break}i=M()|0;ac(h);break Nf}i=M()|0;break Nf}if((j|0)<=0){break jg}oa=v[a+240>>2];H=0;while(1){l=B(v[v[m+240>>2]+(v[(v[x>>2]+(H<<4)|0)+8>>2]<<2)>>2],20);i=l+oa|0;q=v[i+12>>2];if((q|0)>0){if((q|0)!=1){i=v[i+4>>2];v[111924]=0;ED(i,q,m+168|0,0,1);i=v[111924];v[111924]=0;if((i|0)==1){break ig}oa=v[a+240>>2]}i=v[h>>2];k=k-1|0;v[h>>2]=v[h+(k<<2)>>2];j=l+oa|0;G=j;pg:{if(v[j+12>>2]<=0){break pg}z=A[a+280>>3];n=v[m+216>>2];q=v[m+240>>2];r=v[j+4>>2];v[q+(v[r+8>>2]<<2)>>2]=i;j=n+(i<<2)|0;v[j>>2]=v[j>>2]+1;if(v[G+12>>2]<2){break pg}c=A[r>>3];j=1;while(1){l=r+(j<<4)|0;d=A[l>>3];f=D(d);e=D(c);e=e<f?f:e;if(z<D((d-c)/(e>1?e:1))){i=v[h>>2];k=k-1|0;v[h>>2]=v[h+(k<<2)>>2]}v[q+(v[l+8>>2]<<2)>>2]=i;l=n+(i<<2)|0;v[l>>2]=v[l>>2]+1;c=d;j=j+1|0;if((j|0)<v[G+12>>2]){continue}break}}v[G+12>>2]=0;j=v[x+8>>2]}H=H+1|0;if((H|0)<(j|0)){continue}break}}Z=Z+1|0;if((Z|0)<v[b+40>>2]){continue}break}h=v[m+192>>2]}Gb(h);v[m+192>>2]=0;i=v[b+184>>2];v[m+184>>2]=858993459;v[m+188>>2]=1072902963;v[m+176>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[m+168>>2]=h;h=(i|0)<=0?1:h;v[m+172>>2]=h;O(2392,m+176|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break Of}i=v[b+184>>2];v[m+160>>2]=858993459;v[m+164>>2]=1072902963;v[m+152>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[m+144>>2]=h;h=(i|0)<=0?1:h;v[m+148>>2]=h;O(2392,m+152|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break Qf}E=v[b+184>>2];qg:{if((E|0)<=0){break qg}i=v[a+264>>2];l=0;j=0;if(E>>>0>=8){h=E&2147483640;k=0;while(1){v[(i+B(j,20)|0)+12>>2]=0;v[(i+B(j|1,20)|0)+12>>2]=0;v[(i+B(j|2,20)|0)+12>>2]=0;v[(i+B(j|3,20)|0)+12>>2]=0;v[(i+B(j|4,20)|0)+12>>2]=0;v[(i+B(j|5,20)|0)+12>>2]=0;v[(i+B(j|6,20)|0)+12>>2]=0;v[(i+B(j|7,20)|0)+12>>2]=0;j=j+8|0;k=k+8|0;if((h|0)!=(k|0)){continue}break}}h=E&7;if(h){while(1){v[(i+B(j,20)|0)+12>>2]=0;j=j+1|0;l=l+1|0;if((h|0)!=(l|0)){continue}break}}if((E|0)<=0){break qg}j=0;while(1){t[v[m+176>>2]+j|0]=0;t[v[m+152>>2]+j|0]=0;l=v[a+264>>2]+B(v[v[m+240>>2]+(j<<2)>>2],20)|0;k=v[l+12>>2];if((k|0)>=v[l+8>>2]){v[111924]=0;i=k+1|0;O(2313,l+16|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break Sf}v[l+12>>2]=k;v[l+8>>2]=i;v[l+4>>2]=v[l+16>>2];E=v[b+184>>2]}j=j+1|0;if((E|0)>(j|0)){continue}break}}v[m+136>>2]=858993459;v[m+140>>2]=1072902963;L=0;v[m+128>>2]=0;v[m+120>>2]=0;v[m+124>>2]=1;v[111924]=0;O(2265,m+128|0,1);h=v[111924];v[111924]=0;if((h|0)==1){break Tf}i=v[b+184>>2];rg:{if((i|0)<=0){break rg}x=a+216|0;k=v[a+264>>2];r=m+80|0;q=m+104|0;H=0;while(1){n=B(H,20);h=n+k|0;sg:{if(v[h+12>>2]<2|v[(v[b+168>>2]+B(v[(v[b+172>>2]+(v[v[h+4>>2]+8>>2]<<3)|0)+4>>2],24)|0)+8>>2]==1){break sg}tg:{if(L){break tg}v[111924]=0;k=S(2157,96)|0;h=v[111924];v[111924]=0;ug:{vg:{wg:{xg:{yg:{if((h|0)!=1){v[m+96>>2]=v[m+120>>2];v[m+104>>2]=0;h=v[m+124>>2];v[m+100>>2]=h;A[m+112>>3]=A[m+136>>3];v[111924]=0;O(2265,q|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break wg}h=v[m+96>>2];if(h){Kc(v[m+104>>2],v[m+128>>2],h<<2);j=v[m+96>>2]}else{j=0}h=v[b+184>>2];v[k+12>>2]=v[b+40>>2];v[k+8>>2]=h;v[k+4>>2]=44101;v[k+16>>2]=0;v[k+20>>2]=0;v[k>>2]=379696;i=v[b+224>>2];A[k+24>>3]=A[i>>3];h=v[b+236>>2];A[k+32>>3]=A[h>>3];A[k+40>>3]=A[i>>3];c=A[h>>3];v[k+72>>2]=j;u[k+64>>1]=1;v[k+56>>2]=0;v[k+60>>2]=1072693248;A[k+48>>3]=c;h=v[m+100>>2];v[k+80>>2]=0;v[k+76>>2]=h;A[k+88>>3]=A[m+112>>3];v[111924]=0;O(2265,k+80|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break yg}h=v[k+72>>2];if(h){Kc(v[k+80>>2],v[m+104>>2],h<<2)}v[111924]=0;v[m+32>>2]=k;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break xg}v[i+12>>2]=k;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=379780;v[m+36>>2]=i;h=v[m+104>>2];if(h){Gb(h);v[m+104>>2]=0}i=v[a+220>>2];zg:{if((i|0)!=v[a+224>>2]){v[i>>2]=v[m+32>>2];h=v[m+36>>2];v[i+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=i+8;break zg}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break ug}}i=v[m+36>>2];Ag:{if(!i){break Ag}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Ag}zb[v[v[i>>2]+8>>2]](i);se(i)}k=v[a+264>>2];break tg}i=M()|0;break Uf}i=M()|0;v[k+4>>2]=0;v[k>>2]=374532;a=v[m+104>>2];if(!a){break vg}Gb(a);v[m+104>>2]=0;Gb(k);break Uf}i=M()|0;zb[v[v[k>>2]+4>>2]](k);a=v[m+104>>2];if(!a){break Uf}Gb(a);v[m+104>>2]=0;break Uf}i=M()|0}Gb(k);break Uf}i=M()|0;Sf(m+32|0);break Uf}L=1;h=v[(k+n|0)+12>>2]<=0;if(h){break sg}l=0;if(h){break sg}while(1){h=k+n|0;if(v[h+12>>2]>0){E=h+4|0;j=0;while(1){Bg:{if((j|0)==(l|0)){break Bg}i=v[m+176>>2];h=v[E>>2];s=v[(h+(l<<4)|0)+8>>2];if(w[i+s|0]){break Bg}G=v[(h+(j<<4)|0)+8>>2];if(w[G+i|0]){break Bg}h=v[m+196>>2];ba=s<<3;d=A[h+ba>>3];J=G<<3;c=A[J+h>>3];f=d/c;i=v[b+224>>2];Cg:{Dg:{h=v[b+248>>2];e=A[h+ba>>3]-A[h+J>>3]*d/c;if(A[a+280>>3]>=D(e)){c=A[i+ba>>3];v[111924]=0;d=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break Dg}e=c;c=D(c);c=c>0?c:0;if(!(d>=e/(c>1?c:1))){break Bg}d=A[ba+v[b+236>>2]>>3];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break Dg}e=-c;c=D(d);c=c>0?c:0;if(!(e<d/(c>1?c:1))){break Bg}c=A[J+v[b+224>>2]>>3];v[111924]=0;d=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break Dg}e=c;c=D(c);c=c>0?c:0;if(!(d>=e/(c>1?c:1))){break Bg}d=A[J+v[b+236>>2]>>3];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break Dg}e=-c;c=D(d);c=c>0?c:0;if(!(e<d/(c>1?c:1))){break Bg}v[111924]=0;ca=S(2157,96)|0;h=v[111924];v[111924]=0;Eg:{Fg:{Gg:{Hg:{Ig:{Jg:{Kg:{Lg:{Mg:{if((h|0)!=1){v[m+72>>2]=v[m+120>>2];v[m+80>>2]=0;h=v[m+124>>2];v[m+76>>2]=h;A[m+88>>3]=A[m+136>>3];v[111924]=0;O(2265,r|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break Kg}h=v[m+72>>2];if(h){Kc(v[m+80>>2],v[m+128>>2],h<<2);k=v[m+72>>2]}else{k=0}h=v[b+184>>2];v[ca+12>>2]=v[b+40>>2];v[ca+8>>2]=h;v[ca+4>>2]=44101;v[ca+20>>2]=G;v[ca+16>>2]=s;v[ca>>2]=379696;i=v[b+224>>2];A[ca+24>>3]=A[i+ba>>3];h=v[b+236>>2];A[ca+32>>3]=A[h+ba>>3];A[ca+40>>3]=A[i+J>>3];c=A[h+J>>3];v[ca+72>>2]=k;u[ca+64>>1]=0;A[ca+56>>3]=f;A[ca+48>>3]=c;h=v[m+76>>2];v[ca+80>>2]=0;v[ca+76>>2]=h;A[ca+88>>3]=A[m+88>>3];v[111924]=0;O(2265,ca+80|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break Mg}h=v[ca+72>>2];if(h){Kc(v[ca+80>>2],v[m+80>>2],h<<2)}v[111924]=0;v[m+32>>2]=ca;h=S(2157,16)|0;i=v[111924];v[111924]=0;if((i|0)==1){break Lg}v[h+12>>2]=ca;v[h+4>>2]=0;v[h+8>>2]=0;v[h>>2]=379780;v[m+36>>2]=h;h=v[m+80>>2];if(h){Gb(h);v[m+80>>2]=0}i=v[a+220>>2];Ng:{if((i|0)!=v[a+224>>2]){v[i>>2]=v[m+32>>2];h=v[m+36>>2];v[i+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=i+8;break Ng}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break Eg}}if(!(f>0)){break Gg}d=A[48091];c=-d;h=v[b+224>>2];if(!(c>=A[h+J>>3]|c>=A[h+ba>>3])){break Ig}A[m+64>>3]=-d;h=v[v[b>>2]+164>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Hg}break Eg}i=M()|0;break Uf}i=M()|0;v[ca+4>>2]=0;v[ca>>2]=374532;a=v[m+80>>2];if(!a){break Jg}Gb(a);v[m+80>>2]=0;Gb(ca);break Uf}i=M()|0;zb[v[v[ca>>2]+4>>2]](ca);a=v[m+80>>2];if(!a){break Uf}Gb(a);v[m+80>>2]=0;break Uf}i=M()|0}Gb(ca);break Uf}h=v[b+224>>2];A[m+64>>3]=f*A[h+ba>>3]+A[h+J>>3];h=v[v[b>>2]+164>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Hg}break Eg}c=A[48091];h=v[b+236>>2];if(c<=A[h+J>>3]|c<=A[h+ba>>3]){A[m+64>>3]=c;h=v[v[b>>2]+176>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Fg}break Eg}h=v[b+236>>2];A[m+64>>3]=f*A[h+ba>>3]+A[h+J>>3];h=v[v[b>>2]+176>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Fg}break Eg}if(!(f<0)){break Fg}Og:{c=A[48091];if(A[J+v[b+224>>2]>>3]<=-c|c<=A[ba+v[b+236>>2]>>3]){A[m+64>>3]=-c;h=v[v[b>>2]+164>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Og}break Eg}A[m+64>>3]=f*A[ba+v[b+236>>2]>>3]+A[J+v[b+224>>2]>>3];h=v[v[b>>2]+164>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Og}break Eg}c=A[48091];if(c<=A[J+v[b+236>>2]>>3]|A[ba+v[b+224>>2]>>3]<=-c){A[m+64>>3]=c;h=v[v[b>>2]+176>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Fg}break Eg}A[m+64>>3]=f*A[ba+v[b+224>>2]>>3]+A[J+v[b+236>>2]>>3];h=v[v[b>>2]+176>>2];v[111924]=0;W(h|0,b|0,G|0,m- -64|0,0);h=v[111924];v[111924]=0;if((h|0)!=1){break Fg}break Eg}t[s+v[m+176>>2]|0]=1;h=v[a+312>>2];v[h+56>>2]=v[h+56>>2]+1;i=v[m+36>>2];if(!i){break Bg}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Bg}zb[v[v[i>>2]+8>>2]](i);se(i);break Bg}i=M()|0;Sf(m+32|0);break Uf}d=A[48091];c=-d;if(c>=A[i+J>>3]){if(!(!(f>0)|!(e>0))){h=3;if(d<=A[ba+v[b+236>>2]>>3]){break Xf}v[111924]=0;k=S(2157,24)|0;h=v[111924];v[111924]=0;Pg:{Qg:{if((h|0)!=1){c=A[ba+v[b+236>>2]>>3];v[111924]=0;G=na(2444,k|0,b|0,s|0,+c)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Qg}v[111924]=0;v[m+32>>2]=G;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){i=M()|0;zb[v[v[G>>2]+4>>2]](G);break Uf}v[i+12>>2]=G;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376944;v[m+36>>2]=i;h=v[a+220>>2];Rg:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=G;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break Rg}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break Pg}}i=v[v[b>>2]+164>>2];h=v[b+236>>2];v[111924]=0;W(i|0,b|0,s|0,h+ba|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Pg}i=v[m+36>>2];if(!i){break Cg}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Cg}zb[v[v[i>>2]+8>>2]](i);se(i);break Cg}i=M()|0;break Uf}i=M()|0;Gb(k);break Uf}i=M()|0;Sf(m+32|0);break Uf}if(!(f<0)|!(e<0)){break Cg}h=3;if(c>=A[ba+v[b+224>>2]>>3]){break Xf}v[111924]=0;k=S(2157,24)|0;h=v[111924];v[111924]=0;Sg:{Tg:{if((h|0)!=1){c=A[ba+v[b+224>>2]>>3];v[111924]=0;G=na(2444,k|0,b|0,s|0,+c)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Tg}v[111924]=0;v[m+32>>2]=G;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){i=M()|0;zb[v[v[G>>2]+4>>2]](G);break Uf}v[i+12>>2]=G;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376944;v[m+36>>2]=i;h=v[a+220>>2];Ug:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=G;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break Ug}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break Sg}}i=v[v[b>>2]+176>>2];h=v[b+224>>2];v[111924]=0;W(i|0,b|0,s|0,h+ba|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Sg}i=v[m+36>>2];if(!i){break Cg}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Cg}zb[v[v[i>>2]+8>>2]](i);se(i);break Cg}i=M()|0;break Uf}i=M()|0;Gb(k);break Uf}i=M()|0;Sf(m+32|0);break Uf}i=v[b+236>>2];if(!(d<=A[i+J>>3])){break Cg}if(!(!(f<0)|!(e>0))){h=3;if(d<=A[i+ba>>3]){break Xf}v[111924]=0;k=S(2157,24)|0;h=v[111924];v[111924]=0;Vg:{Wg:{if((h|0)!=1){c=A[ba+v[b+236>>2]>>3];v[111924]=0;G=na(2444,k|0,b|0,s|0,+c)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Wg}v[111924]=0;v[m+32>>2]=G;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){i=M()|0;zb[v[v[G>>2]+4>>2]](G);break Uf}v[i+12>>2]=G;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376944;v[m+36>>2]=i;h=v[a+220>>2];Xg:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=G;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break Xg}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break Vg}}i=v[v[b>>2]+164>>2];h=v[b+236>>2];v[111924]=0;W(i|0,b|0,s|0,h+ba|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Vg}i=v[m+36>>2];if(!i){break Cg}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Cg}zb[v[v[i>>2]+8>>2]](i);se(i);break Cg}i=M()|0;break Uf}i=M()|0;Gb(k);break Uf}i=M()|0;Sf(m+32|0);break Uf}if(!(f>0)|!(e<0)){break Cg}h=3;if(A[ba+v[b+224>>2]>>3]<=-d){break Xf}v[111924]=0;k=S(2157,24)|0;h=v[111924];v[111924]=0;Yg:{Zg:{if((h|0)!=1){c=A[ba+v[b+224>>2]>>3];v[111924]=0;G=na(2444,k|0,b|0,s|0,+c)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Zg}v[111924]=0;v[m+32>>2]=G;i=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){i=M()|0;zb[v[v[G>>2]+4>>2]](G);break Uf}v[i+12>>2]=G;v[i+4>>2]=0;v[i+8>>2]=0;v[i>>2]=376944;v[m+36>>2]=i;h=v[a+220>>2];_g:{if((h|0)!=v[a+224>>2]){v[h+4>>2]=i;v[h>>2]=G;v[i+4>>2]=v[i+4>>2]+1;v[a+220>>2]=h+8;break _g}v[111924]=0;O(2441,x|0,m+32|0);h=v[111924];v[111924]=0;if((h|0)==1){break Yg}}i=v[v[b>>2]+176>>2];h=v[b+224>>2];v[111924]=0;W(i|0,b|0,s|0,h+ba|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Yg}i=v[m+36>>2];if(!i){break Cg}h=v[i+4>>2];v[i+4>>2]=h-1;if(h){break Cg}zb[v[v[i>>2]+8>>2]](i);se(i);break Cg}i=M()|0;break Uf}i=M()|0;Gb(k);break Uf}i=M()|0;Sf(m+32|0);break Uf}i=M()|0;break Uf}f=A[ba+v[b+224>>2]>>3];e=D(f);d=A[ba+v[b+236>>2]>>3];c=D(d);c=c<e?e:c;if(!(A[a+288>>3]>=D((f-d)/(c>1?c:1)))){break Bg}t[s+v[m+176>>2]|0]=1;t[s+v[m+152>>2]|0]=1;h=v[a+312>>2];v[h+52>>2]=v[h+52>>2]+1}k=v[a+264>>2];h=n+k|0;E=h+4|0;j=j+1|0;if((j|0)<v[h+12>>2]){continue}break}}l=l+1|0;if((l|0)<v[(k+n|0)+12>>2]){continue}break}}i=v[b+184>>2];H=H+1|0;if((i|0)>(H|0)){continue}break}j=0;if((i|0)<=0){break rg}while(1){if(w[v[m+152>>2]+j|0]){v[111924]=0;W(2451,a|0,b|0,j|0,0);h=v[111924];v[111924]=0;if((h|0)==1){break Vf}i=v[b+184>>2]}j=j+1|0;if((j|0)<(i|0)){continue}break}}Z=0;v[111924]=0;v[m+60>>2]=0;O(2265,m+60|0,i|0);h=v[111924];v[111924]=0;if((h|0)==1){break cg}E=0;if((i|0)<=0){break dg}q=v[b+172>>2];l=v[b+168>>2];k=v[m+60>>2];h=v[m+176>>2];j=0;while(1){r=k+(j<<2)|0;$g:{if(w[h+j|0]){v[r>>2]=-1;E=E+1|0;Z=v[(l+B(v[(q+(j<<3)|0)+4>>2],24)|0)+8>>2]+Z|0;break $g}v[r>>2]=0}j=j+1|0;if((j|0)!=(i|0)){continue}break}break dg}i=M()|0;break Nf}i=M()|0;break Lf}h=v[v[b>>2]+88>>2];v[111924]=0;O(h|0,b|0,v[m+60>>2]);h=v[111924];v[111924]=0;if((h|0)==1){break cg}ah:{if((i|0)<=0){break ah}n=v[a+176>>2];j=0;r=v[m+60>>2];if((i|0)!=1){q=i&2147483646;k=0;while(1){l=j<<2;h=v[l+r>>2];if((h|0)>=0){v[n+(h<<2)>>2]=v[l+n>>2]}l=(j|1)<<2;h=v[l+r>>2];if((h|0)>=0){v[n+(h<<2)>>2]=v[l+n>>2]}j=j+2|0;k=k+2|0;if((q|0)!=(k|0)){continue}break}}if(!(i&1)){break ah}j=j<<2;h=v[j+r>>2];if((h|0)<0){break ah}v[n+(h<<2)>>2]=v[j+n>>2]}v[m+48>>2]=858993459;v[m+52>>2]=1072902963;v[m+40>>2]=0;v[111924]=0;h=(i|0)>0?i:0;v[m+32>>2]=h;j=(i|0)<=0;h=j?1:h;v[m+36>>2]=h;O(2265,m+40|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break bg}bh:{if(j){break bh}fa=0;r=v[m+40>>2];q=v[m+60>>2];j=0;if(i>>>0>=4){k=i&2147483644;H=0;while(1){l=j<<2;v[l+r>>2]=v[l+q>>2];h=l|4;v[h+r>>2]=v[h+q>>2];h=l|8;v[h+r>>2]=v[h+q>>2];h=l|12;v[h+r>>2]=v[h+q>>2];j=j+4|0;H=H+4|0;if((k|0)!=(H|0)){continue}break}}k=i&3;if(!k){break bh}while(1){h=j<<2;v[h+r>>2]=v[h+q>>2];j=j+1|0;fa=fa+1|0;if((k|0)!=(fa|0)){continue}break}}if(L){break ag}break $f}i=M()|0;break Uf}i=M()|0;break Uf}v[111924]=0;k=S(2157,96)|0;h=v[111924];v[111924]=0;ch:{dh:{eh:{fh:{gh:{if((h|0)!=1){v[m+8>>2]=v[m+32>>2];v[m+16>>2]=0;h=v[m+36>>2];v[m+12>>2]=h;A[m+24>>3]=A[m+48>>3];v[111924]=0;O(2265,m+16|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break eh}l=0;h=v[m+8>>2];if(h){Kc(v[m+16>>2],v[m+40>>2],h<<2);l=v[m+8>>2]}h=v[b+184>>2];v[k+12>>2]=v[b+40>>2];v[k+8>>2]=h;v[k+4>>2]=44101;v[k+16>>2]=0;v[k+20>>2]=0;v[k>>2]=379696;j=v[b+224>>2];A[k+24>>3]=A[j>>3];h=v[b+236>>2];A[k+32>>3]=A[h>>3];A[k+40>>3]=A[j>>3];c=A[h>>3];v[k+72>>2]=l;u[k+64>>1]=256;v[k+56>>2]=0;v[k+60>>2]=1072693248;A[k+48>>3]=c;h=v[m+12>>2];v[k+80>>2]=0;v[k+76>>2]=h;A[k+88>>3]=A[m+24>>3];v[111924]=0;O(2265,k+80|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){break gh}h=v[k+72>>2];if(h){Kc(v[k+80>>2],v[m+16>>2],h<<2)}v[111924]=0;v[m+64>>2]=k;j=S(2157,16)|0;h=v[111924];v[111924]=0;if((h|0)==1){break fh}v[j+12>>2]=k;v[j+4>>2]=0;v[j+8>>2]=0;v[j>>2]=379780;v[m+68>>2]=j;h=v[m+16>>2];if(h){Gb(h);v[m+16>>2]=0}j=v[a+220>>2];hh:{if((j|0)!=v[a+224>>2]){v[j>>2]=v[m+64>>2];h=v[m+68>>2];v[j+4>>2]=h;if(h){v[h+4>>2]=v[h+4>>2]+1}v[a+220>>2]=j+8;break hh}v[111924]=0;O(2441,a+216|0,m- -64|0);h=v[111924];v[111924]=0;if((h|0)==1){break ch}}j=v[m+68>>2];if(!j){break $f}h=v[j+4>>2];v[j+4>>2]=h-1;if(h){break $f}zb[v[v[j>>2]+8>>2]](j);se(j);break $f}i=M()|0;break _f}i=M()|0;v[k+4>>2]=0;v[k>>2]=374532;a=v[m+16>>2];if(!a){break dh}Gb(a);v[m+16>>2]=0;Gb(k);break _f}i=M()|0;zb[v[v[k>>2]+4>>2]](k);a=v[m+16>>2];if(!a){break _f}Gb(a);v[m+16>>2]=0;break _f}i=M()|0}Gb(k);break _f}i=M()|0;Sf(m- -64|0);break _f}Gb(v[m+60>>2]);v[m+60>>2]=0;if((E|0)<=0){break Yf}v[a+20>>2]=v[a+20>>2]+E;v[a+24>>2]=v[a+24>>2]+Z;j=v[a+64>>2];if(!j){break Zf}h=v[j+4>>2];if((h|0)<4){break Zf}v[m+64>>2]=h;v[m+4>>2]=4;h=v[v[j>>2]+8>>2];v[111924]=0;O(h|0,j|0,m+4|0);h=v[111924];v[111924]=0;if((h|0)!=1){h=v[a+64>>2];v[111924]=0;j=N(2345,h|0,248963)|0;h=v[111924];v[111924]=0;ih:{if((h|0)==1){break ih}h=v[v[j+8>>2]+(v[j+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,E|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ih}v[111924]=0;j=N(2345,j|0,253622)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ih}h=v[v[j+8>>2]+(v[j+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,Z|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ih}v[111924]=0;j=N(2345,j|0,38399)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ih}h=v[v[j+8>>2]+(v[j+4>>2]<<2)>>2];v[111924]=0;S(2260,h|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break ih}j=v[a+64>>2];h=v[v[j>>2]+8>>2];v[111924]=0;O(h|0,j|0,m- -64|0);h=v[111924];v[111924]=0;if((h|0)!=1){break Zf}}i=M()|0;break _f}i=M()|0}a=v[m+40>>2];if(!a){break Uf}Gb(a);break Uf}if(!(+(E|0)>A[a+56>>3]*+(i|0))){break Yf}t[_+31|0]=1}h=v[m+40>>2];if(h){Gb(h)}h=0}j=h;h=v[m+128>>2];if(h){Gb(h)}h=v[m+152>>2];if(h){Gb(h)}h=v[m+176>>2];if(h){Gb(h)}h=v[m+196>>2];if(h){v[m+200>>2]=h;Gb(h)}h=v[m+216>>2];if(h){Gb(h)}h=v[m+240>>2];if(!h){break Wf}Gb(h)}ub=m+256|0;h=j;break Jf}i=M()|0}a=v[m+128>>2];if(!a){break Rf}Gb(a);break Rf}i=M()|0;break Rf}i=M()|0}a=v[m+152>>2];if(!a){break Pf}Gb(a);break Pf}i=M()|0}a=v[m+176>>2];if(!a){break Nf}Gb(a);break Nf}i=M()|0}a=v[m+196>>2];if(!a){break Mf}v[m+200>>2]=a;Gb(a)}a=v[m+216>>2];if(!a){break Lf}Gb(a)}a=v[m+240>>2];if(a){Gb(a)}P(i|0);p()}p()}v[a+340>>2]=h}if(w[_+31|0]){break ta}}m=ub-128|0;ub=m;h=v[b+184>>2];v[m+124>>2]=0;v[m+116>>2]=0;v[m+120>>2]=0;jh:{kh:{lh:{mh:{nh:{oh:{ph:{qh:{rh:{sh:{th:{uh:{vh:{if(!h){v[m+112>>2]=0;v[m+104>>2]=0;v[m+108>>2]=0;break vh}v[111924]=0;O(2198,m+116|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){E=M()|0;a=v[m+116>>2];if(!a){break lh}v[m+120>>2]=a;Gb(a);break lh}h=v[b+184>>2];v[m+112>>2]=0;v[m+104>>2]=0;v[m+108>>2]=0;if(!h){break vh}v[111924]=0;O(2198,m+104|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){E=M()|0;break mh}h=v[b+184>>2];v[m+100>>2]=0;v[m+92>>2]=0;v[m+96>>2]=0;if(!h){break uh}v[111924]=0;O(2198,m+92|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){E=M()|0;break nh}h=v[b+184>>2];v[m+88>>2]=0;v[m+80>>2]=0;v[m+84>>2]=0;if(!h){break th}v[111924]=0;O(2198,m+80|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){E=M()|0;break oh}h=v[b+184>>2];v[m+76>>2]=0;v[m+68>>2]=0;v[m+72>>2]=0;if(!h){break sh}v[111924]=0;O(2198,m+68|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){E=M()|0;break ph}h=v[b+184>>2];v[m+64>>2]=0;v[m+56>>2]=0;v[m+60>>2]=0;if(!h){break rh}v[111924]=0;O(2198,m+56|0,h|0);h=v[111924];v[111924]=0;if((h|0)!=1){break rh}E=M()|0;break qh}v[m+100>>2]=0;v[m+92>>2]=0;v[m+96>>2]=0}v[m+88>>2]=0;v[m+80>>2]=0;v[m+84>>2]=0}v[m+76>>2]=0;v[m+68>>2]=0;v[m+72>>2]=0}v[m+64>>2]=0;v[m+56>>2]=0;v[m+60>>2]=0}d=A[a+48>>3];f=A[a+288>>3];F=A[48091];e=F;v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;wh:{xh:{if((h|0)!=1){F=-c>1/f-e?1/A[a+288>>3]:e;j=v[b+184>>2];if((j|0)<=0){i=1;h=v[m+104>>2];e=d;K=e;f=e;break wh}ta=-F;E=v[m+56>>2];l=v[m+68>>2];i=1;f=d;K=d;e=d;while(1){k=j;j=j-1|0;n=j<<3;h=n+l|0;v[h>>2]=0;v[h+4>>2]=0;h=n+E|0;v[h>>2]=0;v[h+4>>2]=0;l=0;r=v[b+168>>2]+B(v[(n+v[b+172>>2]|0)+4>>2],24)|0;if(v[r+8>>2]>0){while(1){q=l<<4;h=q+v[r>>2]|0;aa=A[h>>3];$=A[v[b+80>>2]+(v[h+8>>2]<<3)>>3];z=A[48091];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break xh}yh:{zh:{Ah:{if(!(c<$+z)){break Ah}$=A[v[b+92>>2]+(v[(q+v[r>>2]|0)+8>>2]<<3)>>3];z=A[48091];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break xh}if(!(-c>$-z)){break Ah}h=n+v[m+68>>2]|0;A[h>>3]=A[h>>3]+1;E=m+56|0;break zh}$=A[v[b+80>>2]+(v[(q+v[r>>2]|0)+8>>2]<<3)>>3];z=A[48091];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break xh}if($+z>c){E=m+56|0;if(aa>0){break zh}E=m+68|0;if(aa<0){break zh}break yh}$=A[v[b+92>>2]+(v[(q+v[r>>2]|0)+8>>2]<<3)>>3];z=A[48091];v[111924]=0;c=A[53482];h=v[111924];v[111924]=0;if((h|0)==1){break xh}if(!(-c>$-z)){break yh}E=m+68|0;if(aa>0){break zh}E=m+56|0;if(!(aa<0)){break yh}}h=n+v[E>>2]|0;A[h>>3]=A[h>>3]+1}l=l+1|0;if((l|0)<v[r+8>>2]){continue}break}}c=A[n+v[b+236>>2]>>3];va=A[n+v[b+224>>2]>>3];ra=A[48091];v[111924]=0;ia=A[53482];h=v[111924];v[111924]=0;Bh:{if((h|0)!=1){aa=A[48091];v[111924]=0;z=A[53482];h=v[111924];v[111924]=0;if((h|0)!=1){break Bh}}E=M()|0;break qh}$=c>ta?ta:c;h=ia>va+ra;Ch:{if(!(-z<c-aa)){break Ch}c=F;z=A[n+v[b+224>>2]>>3];if(!(c<z)){break Ch}c=z}z=h?$:va;h=i&1;i=0;Dh:{if(!h){break Dh}$=A[a+288>>3];if(!($>z)|!(-$<c)){break Dh}h=n+v[m+116>>2]|0;v[h>>2]=0;v[h+4>>2]=0;i=1}h=v[m+104>>2];r=n+h|0;A[r>>3]=z;q=n+v[m+92>>2]|0;A[q>>3]=c;E=v[m+56>>2];aa=A[n+E>>3];l=v[m+68>>2];$=A[n+l>>3];Eh:{if(aa>$){break Eh}if($>aa){c=z;break Eh}c=(z+c)*.5}A[n+v[m+80>>2]>>3]=c;z=A[n+v[b+248>>2]>>3];f=z*c+f;K=z*A[q>>3]+K;e=z*A[r>>3]+e;if((k|0)>1){continue}break}break wh}E=M()|0;break qh}E=M()|0;break qh}E=0;v[m+52>>2]=0;v[m+44>>2]=0;v[m+48>>2]=0;Fh:{j=v[m+108>>2];if((j|0)!=(h|0)){k=j-h|0;if((k|0)<0){v[111924]=0;U(2426,m+44|0);a=v[111924];v[111924]=0;if((a|0)==1){break Fh}break kh}v[111924]=0;E=S(2157,k|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Fh}v[m+44>>2]=E;j=k+E|0;v[m+52>>2]=j;Kc(E,h,k);v[m+48>>2]=j}s=v[b+92>>2];x=v[b+80>>2];G=v[b+28>>2];n=v[b+24>>2];h=v[b+40>>2];F=A[a+288>>3];z=-F;while(1){Gh:{j=h;if((h|0)<=0){break Gh}h=h-1|0;ca=h<<3;k=n+B(v[(ca+G|0)+4>>2],24)|0;l=v[k+8>>2];Hh:{if((l|0)<=0){c=0;break Hh}r=l&1;J=v[k>>2];Ih:{if((l|0)==1){c=0;l=0;break Ih}q=l&2147483646;c=0;l=0;k=0;while(1){ba=J+(l<<4)|0;c=A[ba+16>>3]*A[(v[ba+24>>2]<<3)+E>>3]+(A[ba>>3]*A[(v[ba+8>>2]<<3)+E>>3]+c);l=l+2|0;k=k+2|0;if((q|0)!=(k|0)){continue}break}}if(!r){break Hh}k=J+(l<<4)|0;c=A[k>>3]*A[(v[k+8>>2]<<3)+E>>3]+c}if(!(z<c-A[x+ca>>3])){break Gh}if(F>c-A[s+ca>>3]){continue}}break}if(E){v[m+48>>2]=E;Gb(E)}E=0;if(!(!(A[a+344>>3]<e)|(j|0)>0)){A[a+344>>3]=e}v[m+40>>2]=0;v[m+32>>2]=0;v[m+36>>2]=0;Jh:{h=v[m+96>>2];j=v[m+92>>2];if((h|0)!=(j|0)){k=h-j|0;if((k|0)<0){v[111924]=0;U(2426,m+32|0);a=v[111924];v[111924]=0;if((a|0)!=1){break kh}break Jh}v[111924]=0;E=S(2157,k|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Jh}v[m+32>>2]=E;h=k+E|0;v[m+40>>2]=h;Kc(E,j,k);v[m+36>>2]=h}s=v[b+92>>2];x=v[b+80>>2];G=v[b+28>>2];n=v[b+24>>2];h=v[b+40>>2];z=A[a+288>>3];e=-z;while(1){Kh:{j=h;if((h|0)<=0){break Kh}h=h-1|0;ca=h<<3;k=n+B(v[(ca+G|0)+4>>2],24)|0;l=v[k+8>>2];Lh:{if((l|0)<=0){c=0;break Lh}r=l&1;J=v[k>>2];Mh:{if((l|0)==1){c=0;l=0;break Mh}q=l&2147483646;c=0;l=0;k=0;while(1){ba=J+(l<<4)|0;c=A[ba+16>>3]*A[(v[ba+24>>2]<<3)+E>>3]+(A[ba>>3]*A[(v[ba+8>>2]<<3)+E>>3]+c);l=l+2|0;k=k+2|0;if((q|0)!=(k|0)){continue}break}}if(!r){break Lh}k=J+(l<<4)|0;c=A[k>>3]*A[(v[k+8>>2]<<3)+E>>3]+c}if(!(e<c-A[x+ca>>3])){break Kh}if(z>c-A[s+ca>>3]){continue}}break}if(E){v[m+36>>2]=E;Gb(E)}if(!(!(A[a+344>>3]<K)|(j|0)>0)){A[a+344>>3]=K}Nh:{Oh:{if(!i){break Oh}E=0;v[m+28>>2]=0;v[m+20>>2]=0;v[m+24>>2]=0;h=v[m+120>>2];i=v[m+116>>2];if((h|0)!=(i|0)){j=h-i|0;if((j|0)<0){v[111924]=0;U(2426,m+20|0);a=v[111924];v[111924]=0;if((a|0)!=1){break kh}break Nh}v[111924]=0;E=S(2157,j|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Nh}v[m+20>>2]=E;h=j+E|0;v[m+28>>2]=h;Kc(E,i,j);v[m+24>>2]=h}x=v[b+92>>2];G=v[b+80>>2];n=v[b+28>>2];r=v[b+24>>2];h=v[b+40>>2];z=A[a+288>>3];e=-z;Ph:{while(1){i=h;Qh:{Rh:{if((h|0)>0){h=h-1|0;J=h<<3;j=r+B(v[(J+n|0)+4>>2],24)|0;k=v[j+8>>2];if((k|0)<=0){c=0;break Qh}q=k&1;s=v[j>>2];if((k|0)==1){c=0;l=0;break Rh}j=k&2147483646;c=0;l=0;k=0;while(1){ca=s+(l<<4)|0;c=A[ca+16>>3]*A[(v[ca+24>>2]<<3)+E>>3]+(A[ca>>3]*A[(v[ca+8>>2]<<3)+E>>3]+c);l=l+2|0;k=k+2|0;if((j|0)!=(k|0)){continue}break}break Rh}if(!E){break Ph}v[m+24>>2]=E;Gb(E);break Ph}if(!q){break Qh}j=s+(l<<4)|0;c=A[j>>3]*A[(v[j+8>>2]<<3)+E>>3]+c}if(e<c-A[G+J>>3]&z>c-A[x+J>>3]){continue}break}if(E){v[m+24>>2]=E;Gb(E);if((i|0)<=0){break Ph}break Oh}if((i|0)>0){break Oh}}if(!(d>A[a+344>>3])){break Oh}A[a+344>>3]=d}E=0;v[m+16>>2]=0;v[m+8>>2]=0;v[m+12>>2]=0;Sh:{h=v[m+84>>2];j=v[m+80>>2];if((h|0)!=(j|0)){i=h-j|0;if((i|0)<0){v[111924]=0;U(2426,m+8|0);a=v[111924];v[111924]=0;if((a|0)!=1){break kh}break Sh}v[111924]=0;E=S(2157,i|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Sh}Kc(E,j,i)}G=v[b+92>>2];n=v[b+80>>2];r=v[b+28>>2];q=v[b+24>>2];i=v[b+40>>2];e=A[a+288>>3];d=-e;while(1){Th:{h=i;if((h|0)<=0){break Th}i=h-1|0;s=i<<3;j=q+B(v[(s+r|0)+4>>2],24)|0;l=v[j+8>>2];Uh:{if((l|0)<=0){c=0;break Uh}k=l&1;x=v[j>>2];Vh:{if((l|0)==1){c=0;l=0;break Vh}j=l&2147483646;c=0;l=0;H=0;while(1){J=x+(l<<4)|0;c=A[J+16>>3]*A[(v[J+24>>2]<<3)+E>>3]+(A[J>>3]*A[(v[J+8>>2]<<3)+E>>3]+c);l=l+2|0;H=H+2|0;if((j|0)!=(H|0)){continue}break}}if(!k){break Uh}j=x+(l<<4)|0;c=A[j>>3]*A[(v[j+8>>2]<<3)+E>>3]+c}if(!(d<c-A[n+s>>3])){break Th}if(e>c-A[s+G>>3]){continue}}break}if(E){Gb(E)}if(!(!(A[a+344>>3]<f)|(h|0)>0)){A[a+344>>3]=f}h=v[m+56>>2];if(h){v[m+60>>2]=h;Gb(h)}h=v[m+68>>2];if(h){v[m+72>>2]=h;Gb(h)}h=v[m+80>>2];if(h){v[m+84>>2]=h;Gb(h)}h=v[m+92>>2];if(h){v[m+96>>2]=h;Gb(h)}h=v[m+104>>2];if(h){v[m+108>>2]=h;Gb(h)}h=v[m+116>>2];if(h){v[m+120>>2]=h;Gb(h)}ub=m+128|0;break jh}E=M()|0;a=v[m+8>>2];if(!a){break qh}v[m+12>>2]=a;Gb(a);break qh}E=M()|0;a=v[m+20>>2];if(!a){break qh}v[m+24>>2]=a;Gb(a);break qh}E=M()|0;a=v[m+32>>2];if(!a){break qh}v[m+36>>2]=a;Gb(a);break qh}E=M()|0;a=v[m+44>>2];if(!a){break qh}v[m+48>>2]=a;Gb(a)}a=v[m+56>>2];if(!a){break ph}v[m+60>>2]=a;Gb(a)}a=v[m+68>>2];if(!a){break oh}v[m+72>>2]=a;Gb(a)}a=v[m+80>>2];if(!a){break nh}v[m+84>>2]=a;Gb(a)}a=v[m+92>>2];if(!a){break mh}v[m+96>>2]=a;Gb(a)}a=v[m+104>>2];if(a){v[m+108>>2]=a;Gb(a)}a=v[m+116>>2];if(!a){break lh}v[m+120>>2]=a;Gb(a);P(E|0);p()}P(E|0);p()}p()}r=ub-16|0;ub=r;c=A[a+48>>3];Wh:{Xh:{Yh:{i=v[b+184>>2];Zh:{if((i|0)>0){l=b+224|0;k=b+236|0;while(1){h=i-1|0;q=h<<3;d=A[q+v[b+248>>2]>>3];_h:{$h:{if(d<0){j=l;if(!(A[q+v[j>>2]>>3]<=-A[48091])){break $h}break Zh}if(!(d>0)){break _h}j=k;if(A[q+v[j>>2]>>3]>=-A[48091]){break Zh}}c=d*A[q+v[j>>2]>>3]+c}j=i>>>0>1;i=h;if(j){continue}break}}d=A[53482];f=A[a+344>>3];e=A[48091];if(!(d<f+e)|!(-d>f-e)){break Zh}if(A[a+352>>3]<c){A[a+352>>3]=c}i=v[b+184>>2];if((i|0)<=0){break Zh}l=a+216|0;while(1){ai:{h=i;i=h-1|0;j=i<<3;c=A[j+v[b+248>>2]>>3];if(A[53482]>=D(c)){break ai}bi:{if(c<0){c=A[j+v[b+224>>2]>>3]+(A[a+344>>3]-A[a+352>>3])/c;A[r+8>>3]=c;if(!(-A[53482]>c-A[j+v[b+236>>2]>>3])){break ai}k=bd(40);d=A[j+v[b+236>>2]>>3];c=A[j+v[b+224>>2]>>3];j=v[b+184>>2];v[k+12>>2]=v[b+40>>2];v[k+8>>2]=j;v[k+4>>2]=59620;A[k+32>>3]=c;A[k+24>>3]=d;v[k+16>>2]=i;v[k>>2]=380096;v[111924]=0;v[r>>2]=k;q=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Yh}v[q+12>>2]=k;v[q+4>>2]=0;v[q+8>>2]=0;v[q>>2]=380180;v[r+4>>2]=q;j=v[a+220>>2];ci:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=q;v[j>>2]=k;v[q+4>>2]=v[q+4>>2]+1;v[a+220>>2]=j+8;break ci}v[111924]=0;O(2441,l|0,r|0);j=v[111924];v[111924]=0;if((j|0)==1){break bi}}j=v[v[b>>2]+176>>2];v[111924]=0;W(j|0,b|0,i|0,r+8|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break bi}k=v[r+4>>2];if(!k){break ai}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break ai}zb[v[v[k>>2]+8>>2]](k);se(k);break ai}if(!(c>0)){break ai}c=A[j+v[b+236>>2]>>3]+(A[a+344>>3]-A[a+352>>3])/c;A[r+8>>3]=c;if(!(A[53482]<c-A[j+v[b+224>>2]>>3])){break ai}k=bd(40);d=A[j+v[b+236>>2]>>3];c=A[j+v[b+224>>2]>>3];j=v[b+184>>2];v[k+12>>2]=v[b+40>>2];v[k+8>>2]=j;v[k+4>>2]=59620;A[k+32>>3]=c;A[k+24>>3]=d;v[k+16>>2]=i;v[k>>2]=380096;v[111924]=0;v[r>>2]=k;q=S(2157,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Yh}v[q+12>>2]=k;v[q+4>>2]=0;v[q+8>>2]=0;v[q>>2]=380180;v[r+4>>2]=q;di:{j=v[a+220>>2];ei:{if((j|0)!=v[a+224>>2]){v[j+4>>2]=q;v[j>>2]=k;v[q+4>>2]=v[q+4>>2]+1;v[a+220>>2]=j+8;break ei}v[111924]=0;O(2441,l|0,r|0);j=v[111924];v[111924]=0;if((j|0)==1){break di}}j=v[v[b>>2]+164>>2];v[111924]=0;W(j|0,b|0,i|0,r+8|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break di}k=v[r+4>>2];if(!k){break ai}j=v[k+4>>2];v[k+4>>2]=j-1;if(j){break ai}zb[v[v[k>>2]+8>>2]](k);se(k);break ai}break Xh}break Xh}if(h>>>0>1){continue}break}}ub=r+16|0;break Wh}a=M()|0;Gb(k);break w}a=M()|0;Sf(r);break w}if(v[a+340>>2]){break ra}sa=0;pa=0;G=0;I=ub+-64|0;ub=I;ba=v[b+184>>2];s=v[b+40>>2];v[I+60>>2]=0;v[I+52>>2]=0;v[I+56>>2]=0;fi:{gi:{hi:{ii:{ji:{if(!ba){v[I+48>>2]=0;v[I+40>>2]=0;v[I+44>>2]=0;break ji}v[111924]=0;O(2198,I+52|0,ba|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;b=v[I+52>>2];if(!b){break w}v[I+56>>2]=b;Gb(b);break w}h=v[b+184>>2];v[I+48>>2]=0;v[I+40>>2]=0;v[I+44>>2]=0;if(!h){break ji}v[111924]=0;O(2198,I+40|0,h|0);h=v[111924];v[111924]=0;if((h|0)==1){a=M()|0;break gi}h=v[b+184>>2];if((h|0)<=0){break ji}x=a+216|0;while(1){k=h;h=h-1|0;ma=h<<3;i=ma+v[I+52>>2]|0;v[i>>2]=0;v[i+4>>2]=0;i=ma+v[I+40>>2]|0;v[i>>2]=0;v[i+4>>2]=0;l=0;ki:{ja=v[b+168>>2]+B(v[(ma+v[b+172>>2]|0)+4>>2],24)|0;if(v[ja+8>>2]<2){break ki}li:{mi:{while(1){j=l<<4;i=j+v[ja>>2]|0;f=A[i>>3];e=A[v[b+80>>2]+(v[i+8>>2]<<3)>>3];d=A[48091];v[111924]=0;c=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break mi}ni:{oi:{pi:{if(!(c<e+d)){break pi}e=A[v[b+92>>2]+(v[(j+v[ja>>2]|0)+8>>2]<<3)>>3];d=A[48091];v[111924]=0;c=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break mi}if(!(-c>e-d)){break pi}i=ma+v[I+52>>2]|0;A[i>>3]=A[i>>3]+1;L=I+40|0;break oi}e=A[v[b+80>>2]+(v[(j+v[ja>>2]|0)+8>>2]<<3)>>3];d=A[48091];v[111924]=0;c=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break mi}if(e+d>c){L=I+40|0;if(f>0){break oi}L=I+52|0;if(f<0){break oi}break ni}e=A[v[b+92>>2]+(v[(j+v[ja>>2]|0)+8>>2]<<3)>>3];d=A[48091];v[111924]=0;c=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break mi}if(!(-c>e-d)){break ni}L=I+52|0;if(f>0){break oi}L=I+40|0;if(!(f<0)){break ni}}i=ma+v[L>>2]|0;A[i>>3]=A[i>>3]+1}l=l+1|0;i=v[ja+8>>2];if((l|0)<(i|0)){continue}break}if(A[ma+v[I+52>>2]>>3]!=1&A[ma+v[I+40>>2]>>3]!=1|(i|0)<=0){break ki}ia=A[ma+v[b+236>>2]>>3];aa=A[ma+v[b+224>>2]>>3];l=0;qi:{while(1){ri:{si:{r=l<<4;i=r+v[ja>>2]|0;q=v[i+8>>2];j=q<<3;$=A[j+v[b+80>>2]>>3];K=A[j+v[b+92>>2]>>3];if(A[a+288>>3]>=D($-K)){break si}F=A[i>>3];c=A[48091];v[111924]=0;z=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break qi}f=A[48091];v[111924]=0;e=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break qi}d=$+c;i=v[(v[b+24>>2]+B(v[(j+v[b+28>>2]|0)+4>>2],24)|0)+8>>2];c=2147483647;ti:{if((i|0)<3){break ti}c=3;if((i|0)==3){break ti}c=(i|0)==4?2:1}f=K-f;e=-e;j=0;ui:{if(!(d>z)){break ui}d=A[r+v[ja>>2]>>3];if(!(!(d>0)|!(A[ma+v[b+248>>2]>>3]<=0)|A[ma+v[I+40>>2]>>3]!=1)){j=1;if(c>=A[ma+v[I+52>>2]>>3]){break ui}}j=0;if(!(d<0)){break ui}j=0;if(!(A[ma+v[b+248>>2]>>3]>=0)){break ui}j=0;if(A[ma+v[I+52>>2]>>3]!=1){break ui}j=c>=A[ma+v[I+40>>2]>>3]}i=0;vi:{wi:{if(!(e>f)){break wi}d=A[r+v[ja>>2]>>3];if(!(!(d>0)|!(A[ma+v[b+248>>2]>>3]>=0)|A[ma+v[I+52>>2]>>3]!=1)){i=1;if(c>=A[ma+v[I+40>>2]>>3]){break vi}}i=0;if(!(d<0)){break wi}i=0;if(!(A[ma+v[b+248>>2]>>3]<=0)){break wi}i=0;if(A[ma+v[I+40>>2]>>3]!=1){break wi}i=c>=A[ma+v[I+52>>2]>>3]}if((j|i)!=1){break si}}v[I>>2]=0;v[I+4>>2]=0;v[111924]=0;v[I+32>>2]=0;v[I+36>>2]=0;P_(a,b,q,h,I,I+32|0);q=v[111924];v[111924]=0;xi:{yi:{zi:{if((q|0)!=1){if(!j){break yi}v[111924]=0;gL(a,b,$,F,A[I>>3],A[I+32>>3],I+24|0,I+16|0);j=v[111924];v[111924]=0;if((j|0)==1){break zi}c=A[I+24>>3];e=A[48091];if(!(c>-e)){break yi}d=A[a+288>>3];if(!(d<c-aa)){break yi}c=A[I+16>>3];if(!(c<e)|!(-d>c-ia)){break yi}oa=v[(r+v[ja>>2]|0)+8>>2];i=1;break xi}a=M()|0;break gi}a=M()|0;break gi}if(!i){break si}v[111924]=0;gL(a,b,K,F,A[I>>3],A[I+32>>3],I+24|0,I+16|0);i=v[111924];v[111924]=0;if((i|0)==1){break ri}c=A[I+24>>3];e=A[48091];if(!(c>-e)){break si}d=A[a+288>>3];if(!(d<c-aa)){break si}c=A[I+16>>3];if(!(c<e)|!(-d>c-ia)){break si}oa=v[(r+v[ja>>2]|0)+8>>2];i=0}if((oa|0)<0){break ki}ca=oa<<3;r=ca+v[(i?80:92)+b>>2]|0;c=0;E=v[b+24>>2]+B(v[(ca+v[b+28>>2]|0)+4>>2],24)|0;q=v[E>>2];Ai:{if(!q){break Ai}l=0;j=v[E+8>>2];if((j|0)<=0){break Ai}while(1){i=q+(l<<4)|0;if(v[i+8>>2]!=(h|0)){l=l+1|0;if((j|0)!=(l|0)){continue}break Ai}break}c=A[i>>3]}K=A[r>>3];v[111924]=0;j=S(2157,112)|0;i=v[111924];v[111924]=0;if((i|0)==1){break hi}v[111924]=0;l=Ja(2456,j|0,b|0,a|0,oa|0,h|0,+K)|0;i=v[111924];v[111924]=0;if((i|0)==1){break ii}v[111924]=0;v[I+32>>2]=l;j=S(2157,16)|0;i=v[111924];v[111924]=0;if((i|0)==1){a=M()|0;zb[v[v[l>>2]+4>>2]](l);break gi}v[j+12>>2]=l;v[j+4>>2]=0;v[j+8>>2]=0;v[j>>2]=380584;v[I+36>>2]=j;Bi:{Ci:{i=v[a+220>>2];Di:{if((i|0)!=v[a+224>>2]){v[i+4>>2]=j;v[i>>2]=l;v[j+4>>2]=v[j+4>>2]+1;v[a+220>>2]=i+8;break Di}v[111924]=0;O(2441,x|0,I+32|0);i=v[111924];v[111924]=0;if((i|0)==1){break Ci}}Ei:{l=v[ja+8>>2];if((l|0)>0){n=0;while(1){q=n<<4;j=v[(q+v[ja>>2]|0)+8>>2];if((j|0)!=(oa|0)){r=v[b+184>>2];l=0;v[I+8>>2]=0;v[I>>2]=0;v[I+4>>2]=0;Z=0;i=j;Fi:{if(!r){break Fi}Gi:{if(r>>>0>=536870912){v[111924]=0;U(2426,I|0);a=v[111924];v[111924]=0;if((a|0)==1){break Gi}p()}v[111924]=0;l=r<<3;Z=S(2157,l|0)|0;i=v[111924];v[111924]=0;if((i|0)!=1){i=Wb(Z,0,l);l=i+l|0;v[I+4>>2]=l;v[I>>2]=i;v[I+8>>2]=l;i=v[(q+v[ja>>2]|0)+8>>2];break Fi}a=M()|0;break li}a=M()|0;b=v[I>>2];if(!b){break li}v[I+4>>2]=b;Gb(b);break li}q=i<<3;i=v[b+24>>2]+B(v[(q+v[b+28>>2]|0)+4>>2],24)|0;F=A[q+v[b+80>>2]>>3];C=v[b+92>>2];z=A[q+C>>3];if((l|0)!=(Z|0)){Wb(Z,0,l-Z&-8)}l=v[i+8>>2];Hi:{if((l|0)<=0){break Hi}q=v[i>>2];ha=0;L=0;if(l>>>0>=4){i=l&2147483644;ka=0;while(1){r=q+(L<<4)|0;A[(v[r+8>>2]<<3)+Z>>3]=A[r>>3];A[(v[r+24>>2]<<3)+Z>>3]=A[r+16>>3];A[(v[r+40>>2]<<3)+Z>>3]=A[r+32>>3];A[(v[r+56>>2]<<3)+Z>>3]=A[r+48>>3];L=L+4|0;ka=ka+4|0;if((i|0)!=(ka|0)){continue}break}}l=l&3;if(!l){break Hi}while(1){i=q+(L<<4)|0;A[(v[i+8>>2]<<3)+Z>>3]=A[i>>3];L=L+1|0;ha=ha+1|0;if((l|0)!=(ha|0)){continue}break}}if(v[E+8>>2]>0){J=Z+ma|0;ka=0;while(1){Ii:{r=v[E>>2]+(ka<<4)|0;m=v[r+8>>2];if((m|0)==(h|0)){break Ii}Ji:{i=v[b+24>>2]+B(v[(v[b+28>>2]+(j<<3)|0)+4>>2],24)|0;q=v[i>>2];Ki:{if(!q){break Ki}l=0;i=v[i+8>>2];if((i|0)<=0){break Ki}while(1){if((m|0)==v[(q+(l<<4)|0)+8>>2]){break Ji}l=l+1|0;if((i|0)!=(l|0)){continue}break}}A[I+24>>3]=A[r>>3]*-A[J>>3]/c;i=v[v[b>>2]+264>>2];v[111924]=0;da(i|0,b|0,j|0,m|0,I+24|0,0);i=v[111924];v[111924]=0;if((i|0)!=1){break Ii}a=M()|0;Gb(Z);break li}A[I+24>>3]=A[(m<<3)+Z>>3]-A[J>>3]*A[r>>3]/c;i=v[v[b>>2]+264>>2];v[111924]=0;da(i|0,b|0,j|0,m|0,I+24|0,0);i=v[111924];v[111924]=0;if((i|0)!=1){break Ii}a=M()|0;Gb(Z);break li}ka=ka+1|0;if((ka|0)<v[E+8>>2]){continue}break}C=v[b+92>>2]}l=j<<3;f=A[C+l>>3];e=A[48091];v[111924]=0;d=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break Ei}Li:{if(!(-d>f-e)){break Li}A[I+24>>3]=z-K*A[Z+ma>>3]/c;i=v[v[b>>2]+212>>2];v[111924]=0;W(i|0,b|0,j|0,I+24|0,0);i=v[111924];v[111924]=0;if((i|0)!=1){break Li}a=M()|0;Gb(Z);break li}f=A[l+v[b+80>>2]>>3];e=A[48091];v[111924]=0;d=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break Ei}Mi:{Ni:{if(d<f+e){A[I+24>>3]=F-K*A[Z+ma>>3]/c;i=v[v[b>>2]+200>>2];v[111924]=0;W(i|0,b|0,j|0,I+24|0,0);i=v[111924];v[111924]=0;if((i|0)!=1){break Ni}a=M()|0;Gb(Z);break li}if(!Z){break Mi}}Gb(Z)}l=v[ja+8>>2]}n=n+1|0;if((n|0)<(l|0)){continue}break}}i=0;L=v[E+8>>2];if((L|0)>0){while(1){l=v[E>>2]+(i<<4)|0;q=v[l+8>>2];if((q|0)!=(h|0)){j=v[b+248>>2];A[I>>3]=A[j+(q<<3)>>3]-A[j+ma>>3]*A[l>>3]/c;j=v[v[b>>2]+152>>2];v[111924]=0;W(j|0,b|0,q|0,I|0,0);j=v[111924];v[111924]=0;if((j|0)==1){break Bi}L=v[E+8>>2]}i=i+1|0;if((L|0)>(i|0)){continue}break}}j=v[(v[b+168>>2]+B(v[(ma+v[b+172>>2]|0)+4>>2],24)|0)+8>>2];i=v[a+176>>2];v[i+(h<<2)>>2]=v[(i+(v[b+184>>2]<<2)|0)-4>>2];i=v[v[b>>2]+80>>2];v[111924]=0;O(i|0,b|0,h|0);i=v[111924];v[111924]=0;if((i|0)==1){break Ci}l=v[(v[b+24>>2]+B(v[(ca+v[b+28>>2]|0)+4>>2],24)|0)+8>>2];i=v[a+200>>2];v[i+(oa<<2)>>2]=v[(i+(v[b+40>>2]<<2)|0)-4>>2];i=v[v[b>>2]+56>>2];v[111924]=0;O(i|0,b|0,oa|0);i=v[111924];v[111924]=0;if((i|0)==1){break Ci}j=j+G|0;i=v[a+312>>2];v[i+64>>2]=v[i+64>>2]+1;q=v[I+36>>2];Oi:{if(!q){break Oi}i=v[q+4>>2];v[q+4>>2]=i-1;if(i){break Oi}zb[v[v[q>>2]+8>>2]](q);se(q)}sa=sa+1|0;pa=pa+1|0;G=j+l|0;break ki}a=M()|0;if(!Z){break li}Gb(Z);break li}a=M()|0;break li}a=M()|0;break li}l=l+1|0;if((l|0)<v[ja+8>>2]){continue}break ki}break}a=M()|0;break gi}a=M()|0;break gi}a=M()|0;break gi}Sf(I+32|0);break gi}if((k|0)>1){continue}break}}Pi:{j=pa+sa|0;Qi:{if((j|0)<=0){break Qi}v[a+16>>2]=v[a+16>>2]+pa;v[a+20>>2]=v[a+20>>2]+sa;v[a+24>>2]=v[a+24>>2]+G;Ri:{i=v[a+64>>2];if(!i){break Ri}h=v[i+4>>2];if((h|0)<4){break Ri}v[I+32>>2]=h;v[I>>2]=4;h=v[v[i>>2]+8>>2];v[111924]=0;O(h|0,i|0,I|0);h=v[111924];v[111924]=0;if((h|0)==1){break Pi}i=v[a+64>>2];h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,249074,39)|0;h=v[111924];v[111924]=0;Si:{if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,pa|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,253565,7)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,sa|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,253622,7)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;N(2359,h|0,G|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}h=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];v[111924]=0;Q(2258,h|0,38399,10)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}l=v[v[i+8>>2]+(v[i+4>>2]<<2)>>2];h=v[v[l>>2]-12>>2];v[111924]=0;h=v[(h+l|0)+28>>2];v[I>>2]=h;v[h+4>>2]=v[h+4>>2]+1;h=v[111924];v[111924]=0;if((h|0)==1){break Si}v[111924]=0;i=N(1122,I|0,448956)|0;h=v[111924];v[111924]=0;Ti:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break Ti}}a=M()|0;g=v[I>>2];b=v[g+4>>2]-1|0;v[g+4>>2]=b;if((b|0)==-1){zb[v[v[g>>2]+8>>2]](g)}break gi}k=v[I>>2];h=v[k+4>>2]-1|0;v[k+4>>2]=h;if((h|0)==-1){zb[v[v[k>>2]+8>>2]](k)}v[111924]=0;N(2270,l|0,i|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}v[111924]=0;S(2271,l|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break Si}i=v[a+64>>2];h=v[v[i>>2]+8>>2];v[111924]=0;O(h|0,i|0,I+32|0);h=v[111924];v[111924]=0;if((h|0)!=1){break Ri}}a=M()|0;break gi}if(!(+(j|0)>A[a+56>>3]*+(s+ba|0))){break Qi}t[_+31|0]=1}h=v[I+40>>2];if(h){v[I+44>>2]=h;Gb(h)}h=v[I+52>>2];if(h){v[I+56>>2]=h;Gb(h)}ub=I- -64|0;break fi}a=M()|0;break gi}a=M()|0;Gb(j);break gi}a=M()|0}b=v[I+40>>2];if(b){v[I+44>>2]=b;Gb(b)}b=v[I+52>>2];if(!b){break w}v[I+56>>2]=b;Gb(b);break w}h=0;v[a+340>>2]=0}h=!h;j=h;if(!w[_+31|0]){break sa}if(h){continue}break}}if(j){break qa}}h=v[a+64>>2];if(!h){break pa}b=v[h+4>>2];if((b|0)<3){break pa}v[_+12>>2]=b;v[_+16>>2]=3;g=_+16|0;zb[v[v[h>>2]+8>>2]](h,g);b=v[a+64>>2];Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],250434,19);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[a+340>>2]);i=v[v[b+8>>2]+(v[b+4>>2]<<2)>>2];b=v[(v[v[i>>2]-12>>2]+i|0)+28>>2];v[g>>2]=b;v[b+4>>2]=v[b+4>>2]+1;v[111924]=0;g=N(1122,g|0,448956)|0;b=v[111924];v[111924]=0;Ui:{if((b|0)!=1){b=v[v[g>>2]+28>>2];v[111924]=0;g=N(b|0,g|0,10)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break Ui}}break oa}h=v[_+16>>2];b=v[h+4>>2]-1|0;v[h+4>>2]=b;if((b|0)==-1){zb[v[v[h>>2]+8>>2]](h)}bc(i,g);$b(i);b=v[a+64>>2];zb[v[v[b>>2]+8>>2]](b,_+12|0);break pa}h=v[a+336>>2];v[a+20>>2]=v[a+20>>2]-h;v[a+24>>2]=v[a+24>>2]-h;y=0;h=v[a+64>>2];Vi:{if(!h){break Vi}i=v[h+4>>2];if((i|0)>=3){v[_+12>>2]=i;v[_+16>>2]=3;i=_+16|0;zb[v[v[h>>2]+8>>2]](h,i);h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],248849,19);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[a+16>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253565,7);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[a+20>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253611,10);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[a+24>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253573,11);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[a+28>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253668,13);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],v[a+32>>2]);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],59087,11);k=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[k>>2]-12>>2]+k|0)+28>>2];v[i>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;i=N(1122,i|0,448956)|0;h=v[111924];v[111924]=0;Wi:{if((h|0)!=1){h=v[v[i>>2]+28>>2];v[111924]=0;i=N(h|0,i|0,10)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break Wi}}break oa}j=v[_+16>>2];h=v[j+4>>2]-1|0;v[j+4>>2]=h;if((h|0)==-1){zb[v[v[j>>2]+8>>2]](j)}bc(k,i);$b(k);h=v[a+64>>2];zb[v[v[h>>2]+8>>2]](h,_+12|0);h=v[a+64>>2]}Xi:{if(g){if(!h){break Vi}g=v[h+4>>2];if((g|0)<4){break Xi}v[_+12>>2]=g;v[_+16>>2]=4;i=_+16|0;zb[v[v[h>>2]+8>>2]](h,i);g=v[a+64>>2];Nb(v[v[g+8>>2]+(v[g+4>>2]<<2)>>2],246750,16);pd(v[v[g+8>>2]+(v[g+4>>2]<<2)>>2],v[a+36>>2]);Nb(v[v[g+8>>2]+(v[g+4>>2]<<2)>>2],253651,16);pd(v[v[g+8>>2]+(v[g+4>>2]<<2)>>2],v[a+40>>2]);Nb(v[v[g+8>>2]+(v[g+4>>2]<<2)>>2],59087,11);j=v[v[g+8>>2]+(v[g+4>>2]<<2)>>2];g=v[(v[v[j>>2]-12>>2]+j|0)+28>>2];v[i>>2]=g;v[g+4>>2]=v[g+4>>2]+1;v[111924]=0;h=N(1122,i|0,448956)|0;g=v[111924];v[111924]=0;Yi:{if((g|0)!=1){g=v[v[h>>2]+28>>2];v[111924]=0;h=N(g|0,h|0,10)|0;g=v[111924];v[111924]=0;if((g|0)!=1){break Yi}}break oa}i=v[_+16>>2];g=v[i+4>>2]-1|0;v[i+4>>2]=g;if((g|0)==-1){zb[v[v[i>>2]+8>>2]](i)}bc(j,h);$b(j);g=v[a+64>>2];zb[v[v[g>>2]+8>>2]](g,_+12|0);h=v[a+64>>2]}if(!h){break Vi}}g=v[h+4>>2];if((g|0)>=3){v[_+12>>2]=g;v[_+16>>2]=3;zb[v[v[h>>2]+8>>2]](h,_+16|0);r=v[a+64>>2];Nb(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],247063,15);pd(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],v[b+40>>2]);Nb(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],246940,6);pd(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],v[b+184>>2]);Nb(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],246991,9);j=0;l=v[b+184>>2];Zi:{if((l|0)<=0){break Zi}i=v[b+172>>2];q=v[b+168>>2];h=0;if(l>>>0>=4){g=l&2147483644;while(1){k=i+(h<<3)|0;j=v[(q+B(v[k+28>>2],24)|0)+8>>2]+(v[(q+B(v[k+20>>2],24)|0)+8>>2]+(v[(q+B(v[k+12>>2],24)|0)+8>>2]+(v[(q+B(v[k+4>>2],24)|0)+8>>2]+j|0)|0)|0)|0;h=h+4|0;wa=wa+4|0;if((g|0)!=(wa|0)){continue}break}}g=l&3;if(!g){break Zi}while(1){j=v[(q+B(v[(i+(h<<3)|0)+4>>2],24)|0)+8>>2]+j|0;h=h+1|0;y=y+1|0;if((g|0)!=(y|0)){continue}break}}pd(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],j);Nb(v[v[r+8>>2]+(v[r+4>>2]<<2)>>2],38389,9);g=_+16|0;j=v[v[r+8>>2]+(v[r+4>>2]<<2)>>2];h=v[(v[v[j>>2]-12>>2]+j|0)+28>>2];v[g>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;h=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;_i:{if((g|0)!=1){g=v[v[h>>2]+28>>2];y=0;v[111924]=0;h=N(g|0,h|0,10)|0;g=v[111924];v[111924]=0;if((g|0)!=1){break _i}}break oa}i=v[_+16>>2];g=v[i+4>>2]-1|0;v[i+4>>2]=g;if((g|0)==-1){zb[v[v[i>>2]+8>>2]](i)}bc(j,h);$b(j);g=v[a+64>>2];zb[v[v[g>>2]+8>>2]](g,_+12|0);h=v[a+64>>2];if(!h){break Vi}}g=v[h+4>>2];if((g|0)<4){y=h;break Vi}v[_+12>>2]=g;v[_+16>>2]=4;zb[v[v[h>>2]+8>>2]](h,_+16|0);j=0;i=0;if(v[b+40>>2]>0){h=0;while(1){k=h<<3;g=v[b+80>>2];c=A[48091];$i:{if(!(A[k+g>>3]>-c)){break $i}d=c;c=A[k+v[b+92>>2]>>3];if(!(d>c)){break $i}if(A[53482]>=D(A[g+k>>3]-c)){y=y+1|0;break $i}i=i+1|0}h=h+1|0;if((h|0)<v[b+40>>2]){continue}break}}if(v[b+184>>2]>0){h=0;while(1){g=h<<3;c=A[48091];j=!(A[g+v[b+224>>2]>>3]>-c)|!(c>A[g+v[b+236>>2]>>3])?j:j+1|0;h=h+1|0;if((h|0)<v[b+184>>2]){continue}break}}h=v[a+64>>2];Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],247063,15);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],y);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253598,12);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],i);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],253558,14);pd(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],j);Nb(v[v[h+8>>2]+(v[h+4>>2]<<2)>>2],42464,14);g=_+16|0;j=v[v[h+8>>2]+(v[h+4>>2]<<2)>>2];h=v[(v[v[j>>2]-12>>2]+j|0)+28>>2];v[g>>2]=h;v[h+4>>2]=v[h+4>>2]+1;v[111924]=0;h=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;aj:{if((g|0)!=1){g=v[v[h>>2]+28>>2];v[111924]=0;h=N(g|0,h|0,10)|0;g=v[111924];v[111924]=0;if((g|0)!=1){break aj}}break oa}i=v[_+16>>2];g=v[i+4>>2]-1|0;v[i+4>>2]=g;if((g|0)==-1){zb[v[v[i>>2]+8>>2]](i)}bc(j,h);$b(j);g=v[a+64>>2];zb[v[v[g>>2]+8>>2]](g,_+12|0);y=v[a+64>>2]}if(!(v[b+184>>2]|v[b+40>>2])){bj:{if(!y){y=0;break bj}b=v[y+4>>2];if((b|0)<3){break bj}v[_+16>>2]=b;v[_+12>>2]=3;zb[v[v[y>>2]+8>>2]](y,_+12|0);b=cg(v[a+64>>2],42424);pe(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2]);b=v[a+64>>2];zb[v[v[b>>2]+8>>2]](b,_+16|0);y=v[a+64>>2]}v[a+340>>2]=4}cj:{if(!y){break cj}b=v[y+4>>2];if((b|0)<4){break cj}v[_+12>>2]=b;v[_+16>>2]=4;g=_+16|0;zb[v[v[y>>2]+8>>2]](y,g);b=v[a+64>>2];Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],318025,23);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],260074,12);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+4>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],260136,11);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+8>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],260087,16);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+12>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],260104,14);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+16>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264134,15);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+20>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264175,15);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+24>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],283570,34);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+28>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],283530,39);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+32>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],274240,54);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+36>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264150,24);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+40>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264198,19);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+44>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264191,26);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+48>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],260119,16);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+52>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],357714,27);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+56>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],357742,33);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+60>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],264012,23);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[v[a+312>>2]+64>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],263991,20);i=v[v[b+8>>2]+(v[b+4>>2]<<2)>>2];b=v[(v[v[i>>2]-12>>2]+i|0)+28>>2];v[g>>2]=b;v[b+4>>2]=v[b+4>>2]+1;v[111924]=0;g=N(1122,g|0,448956)|0;b=v[111924];v[111924]=0;dj:{if((b|0)!=1){b=v[v[g>>2]+28>>2];v[111924]=0;g=N(b|0,g|0,10)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break dj}}break oa}h=v[_+16>>2];b=v[h+4>>2]-1|0;v[h+4>>2]=b;if((b|0)==-1){zb[v[v[h>>2]+8>>2]](h)}bc(i,g);$b(i);b=v[a+64>>2];zb[v[v[b>>2]+8>>2]](b,_+12|0)}b=v[a+8>>2];+zb[v[v[b>>2]+16>>2]](b)}ub=_+32|0;return v[a+340>>2]}a=M()|0;g=v[_+16>>2];b=v[g+4>>2]-1|0;v[g+4>>2]=b;if((b|0)==-1){zb[v[v[g>>2]+8>>2]](g)}}P(a|0);p()}function vwa(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,u,x,y,z,C,E,G,J){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;u=u|0;x=x|0;y=y|0;z=z|0;C=C|0;E=E|0;G=G|0;J=J|0;var K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0;R=ub-672|0;ub=R;v[R+596>>2]=0;n=v[G>>2];o=v[E>>2];Fa=v[C>>2];p=v[y>>2];Ga=v[u>>2];Ha=v[r>>2];Ia=v[q>>2];ha=v[b+328>>2];a:{b:{if((d|0)<=0){m=2147483647;ra=2147483647;break b}ra=2147483647;l=0;m=2147483647;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break b}v[R+592>>2]=0;s=v[(l<<2)+c>>2];ga=v[s+16>>2];K=A[ga+8>>3];if(A[v[a+4>>2]+1280>>3]>=D(K-A[ga>>3])){A[ga>>3]=K}c:{d:{e:{f:{if(v[ga+176>>2]){break f}g=UC(a,s,v[ha>>2]);if((g|0)==1){break f}e=16389;break e}g=ar(a,s,R+592|0);e=16400;if((g|0)!=1){break e}if(v[R+592>>2]){v[R+596>>2]=1;break b}if(t[s+85|0]&1){break c}m=(m|0)==2147483647?w[ga+257|0]&64?l:2147483647:m;b=v[ga+256>>2];ra=(ra|0)==2147483647?b&65536?2147483647:l:ra;if(b&2048){break c}Y=0;g:{h:{i:{while(1){j:{if(rc(v[a+4>>2],v[a+24>>2],0)){break j}v[ga+256>>2]=v[ga+256>>2]|2048;g=Yt(a,s);e=16443;if((g|0)!=1){break e}b=R+592|0;g=Gp(a,s,b);e=16446;if((g|0)!=1){break e}if(v[R+592>>2]){break d}g=BX(a,s,G,b);e=16456;if((g|0)!=1){break e}if(v[R+592>>2]){break d}L=A[ga+8>>3];K=D(L);M=A[v[a+4>>2]+1296>>3];Q=A[ga>>3];N=Q-L;L=D(Q);k:{if(L<=1){L=1;if(K<=1){break k}L=K;break k}L=K<=L?L:K}if(M<N/L){break d}b=R+596|0;g=dv(a,s,A[ha+32>>3],v[ha+108>>2],b,u);e=16475;if((g|0)!=1){break e}if(v[R+596>>2]){break c}g=Fp(a,s,b,q);e=16480;if((g|0)!=1){break e}if(v[R+596>>2]){break c}$q(a,ga,1,R+624|0,R+616|0,R+612|0,R+608|0,R+604|0,R+600|0);M=A[ga+8>>3];K=D(M);b=v[a+4>>2];Q=A[b+1296>>3];U=A[R+624>>3];N=U-M;L=D(U);l:{if(L<=1){L=1;if(K<=1){break l}L=K;break l}L=K<=L?L:K}if(Q<N/L){break d}N=A[ga>>3];K=D(N);T=-Q;Q=A[R+616>>3];X=Q-N;L=D(Q);m:{if(L<=1){L=1;if(K<=1){break m}L=K;break m}L=K<=L?L:K}if(T>X/L){break d}n:{o:{p:{q:{r:{s:{K=A[b+1280>>3];t:{u:{v:{if(-K<=U-N){L=Q-M;if(K>=L){g=pc(a,s);if((g|0)==1){break s}e=16498;break e}Q=A[b+1272>>3];if(Q<=-N){break v}g=Li(a,s,-Q);e=16509;if((g|0)!=1){break e}if(!(w[ga+258|0]&2)){break u}break t}L=Q-M;Q=A[b+1272>>3]}if(!(K>=L)|M>=Q){break t}g=Ki(a,s,Q);e=16517;if((g|0)!=1){break e}if(w[ga+258|0]&2){break t}}v[G>>2]=v[G>>2]+1}if(!v[ga+248>>2]){L=A[ga+8>>3];K=D(L);M=A[v[a+4>>2]+1296>>3];Q=A[ga>>3];N=Q-L;L=D(Q);w:{if(L<=1){L=1;if(K<=1){break w}L=K;break w}L=K<=L?L:K}if(M<N/L){break d}g=pc(a,s);e=16535;if((g|0)!=1){break e}if(!(w[ga+258|0]&2)){break r}break j}b=v[s+16>>2];h=v[b+256>>2];x:{if(!(A[b+16>>3]>1e6?h&16:0)){if(!(h&32)|!(A[b+24>>3]<1e-5)){break x}}v[b+32>>2]=0;v[b+36>>2]=0;v[b+40>>2]=0;v[b+44>>2]=0;k=v[b+248>>2];y:{if((k|0)<=0){v[b+48>>2]=0;v[b+52>>2]=0;e=b- -64|0;v[e>>2]=0;v[e+4>>2]=0;v[b+56>>2]=0;v[b+60>>2]=0;i=h|128;K=0;break y}j=v[b+168>>2];x=v[b+172>>2];i=v[a+4>>2];N=A[i+1272>>3];M=0;K=0;g=k;while(1){e=g;g=g-1|0;L=A[x+(g<<3)>>3];Q=A[v[j+(g<<2)>>2]+(L>0?152:160)>>3];z:{if(Q>=N|N<=-Q){break z}U=L*Q;T=A[i+1368>>3];if(U>=T|T<=Q*-L){break z}L=U+K;A[b+32>>3]=L;Q=M;M=L-K;M=Q+(U-M+(K-(L-M)));A[b+40>>3]=M;K=L}if(e>>>0>1){continue}break}v[b+48>>2]=0;v[b+52>>2]=0;A[b+64>>3]=M+K;i=h|128;v[b+256>>2]=i;v[b+56>>2]=0;v[b+60>>2]=0;g=v[a+4>>2];N=A[g+1272>>3];M=0;K=0;while(1){e=k;k=e-1|0;L=A[x+(k<<3)>>3];Q=A[v[j+(k<<2)>>2]+(L>0?160:152)>>3];A:{if(Q>=N|N<=-Q){break A}U=L*Q;T=A[g+1368>>3];if(U>=T|T<=Q*-L){break A}L=U+K;A[b+48>>3]=L;Q=M;M=L-K;M=Q+(U-M+(K-(L-M)));A[b+56>>3]=M;K=L}if(e>>>0>1){continue}break}K=M+K}A[b+72>>3]=K;v[b+256>>2]=i|256}$q(a,b,1,R+648|0,R+640|0,R+668|0,R+664|0,R+660|0,R+636|0);V=v[b+248>>2];B:{if((V|0)<=0){L=0;_=0;e=0;break B}k=0;_=0;L=0;while(1){g=v[b+168>>2];e=v[g+(k<<2)>>2];h=v[e+376>>2]&192;Q=A[e+160>>3];U=A[e+152>>3];e=v[a+4>>2];i=v[b+172>>2];M=A[i+(k<<3)>>3];C:{if(M>=0){D:{if((h|0)==192){break D}ca=A[e+1280>>3];N=A[R+648>>3];T=A[b>>3];if(!(-ca<=M+N-T)){break D}K=A[R+640>>3];X=A[b+8>>3];if(!(ca>=K-M-X)){break D}K=K-X;N=T-N;E:{if((V|0)!=2){break E}h=1-k|0;aa=A[i+(h<<3)>>3];ia=A[e+1272>>3];if(!(v[R+660>>2]|ia<=-T)){N=T-M*U-aa*A[v[g+(h<<2)>>2]+(aa>0?152:160)>>3]}if(v[R+636>>2]|X>=ia){break E}K=M*Q-X+aa*A[v[g+(h<<2)>>2]+(aa>0?160:152)>>3]}N=K<=N?N:K;K=D(N);aa=D(M);if(A[e+1288>>3]>=D((N-M)/(K<=1?aa<=1?1:aa:K>=aa?K:aa))){break C}F:{G:{if(K<=ca){g=Ej(a,s,k);if((g|0)==1){break G}b=9233;break g}g=Ko(a,s,k,N);if((g|0)==1){break F}b=9238;break g}k=k-1|0}v[E>>2]=v[E>>2]+1;$q(a,b,1,R+648|0,R+640|0,R+668|0,R+664|0,R+660|0,R+636|0);g=v[a+4>>2];K=A[g+1272>>3];aa=A[b>>3];H:{if(K<=-aa){break H}U=N*U+(T-M*U);if(A[g+1280>>3]>=D(U-aa)){break H}g=Li(a,s,U);if((g|0)!=1){b=9250;break g}v[G>>2]=v[G>>2]+1;g=v[a+4>>2];K=A[g+1272>>3]}U=K;K=A[b+8>>3];if(U<=K){break C}M=N*Q+(X-M*Q);if(A[g+1280>>3]>=D(M-K)){break C}g=Ki(a,s,M);if((g|0)!=1){b=9259;break g}v[G>>2]=v[G>>2]+1;break C}K=A[e+1272>>3];I:{if(K<=-_){break I}if(K<=-U){_=-K;break I}_=M*U+_}if(K<=L){break C}if(K<=Q){L=K;break C}L=M*Q+L;break C}J:{if((h|0)==192){break J}ca=A[e+1280>>3];N=A[R+648>>3];aa=A[b>>3];if(!(-ca<=N-M-aa)){break J}K=A[R+640>>3];T=A[b+8>>3];if(!(ca>=M+K-T)){break J}K=T-K;N=N-aa;K:{if((V|0)!=2){break K}h=1-k|0;X=A[i+(h<<3)>>3];ia=A[e+1272>>3];ta=-aa;if(!(v[R+660>>2]|ia<=ta)){N=M*Q+ta+X*A[v[g+(h<<2)>>2]+(X>0?152:160)>>3]}if(v[R+636>>2]|T>=ia){break K}K=T-M*U-X*A[v[g+(h<<2)>>2]+(X>0?160:152)>>3]}N=K>=N?N:K;K=D(N);X=D(M);if(A[e+1288>>3]>=D((N-M)/(K<=1?X<=1?1:X:K>=X?K:X))){break C}L:{M:{if(K<=ca){g=Ej(a,s,k);if((g|0)==1){break M}b=9340;break g}g=Ko(a,s,k,N);if((g|0)==1){break L}b=9345;break g}k=k-1|0}v[E>>2]=v[E>>2]+1;$q(a,b,1,R+648|0,R+640|0,R+668|0,R+664|0,R+660|0,R+636|0);g=v[a+4>>2];K=A[g+1272>>3];X=A[b>>3];N:{if(K<=-X){break N}Q=N*Q+(aa-M*Q);if(A[g+1280>>3]>=D(Q-X)){break N}g=Li(a,s,Q);if((g|0)!=1){b=9357;break g}v[G>>2]=v[G>>2]+1;g=v[a+4>>2];K=A[g+1272>>3]}Q=K;K=A[b+8>>3];if(Q<=K){break C}M=N*U+(T-M*U);if(A[g+1280>>3]>=D(M-K)){break C}g=Ki(a,s,M);if((g|0)!=1){b=9366;break g}v[G>>2]=v[G>>2]+1;break C}K=A[e+1272>>3];O:{if(K<=-_){break O}if(K<=Q){_=-K;break O}_=M*Q+_}if(K<=L){break C}if(K<=-U){L=K;break C}L=M*U+L}k=k+1|0;V=v[b+248>>2];if((k|0)<(V|0)){continue}break}e=(V|0)>0}g=v[a+4>>2];K=A[g+1272>>3];Q=A[b>>3];h=K<=-Q;P:{if(!(v[R+668>>2]|K<=-A[R+648>>3]?h:1)){break P}M=A[R+640>>3];N=A[b+8>>3];i=N>=K;if(!(v[R+664>>2]|K<=M?i:1)){break P}if(!h){Q=_+(Q-A[R+648>>3]);K=D(Q);U=L-Q;Q=D(L);if(!(-A[g+1296>>3]>U/(Q<=1?K<=1?1:K:K<=Q?Q:K))){break P}}Q:{if(!i){L=L+(N-M);K=D(L);M=_-L;L=D(_);if(e&A[g+1296>>3]<M/(L<=1?K<=1?1:K:K<=L?L:K)){break Q}break P}if(!e){break P}}k=0;while(1){e=v[v[b+168>>2]+(k<<2)>>2];g=v[e+376>>2]&192;N=A[e+160>>3];Q=A[e+152>>3];R:{S:{U=A[v[b+172>>2]+(k<<3)>>3];if(U>=0){T:{if((g|0)==192){break T}g=v[a+4>>2];T=A[g+1280>>3];M=A[b>>3];if(-T>U+A[R+648>>3]-M){break T}K=0;L=A[b+8>>3];if(T<A[R+640>>3]-U-L){break T}Q=0;break R}M=N;g=Ej(a,s,k);if((g|0)==1){break S}b=9474;break g}U:{if((g|0)==192){break U}g=v[a+4>>2];T=A[g+1280>>3];M=A[b>>3];if(-T>A[R+648>>3]-U-M){break U}K=0;L=A[b+8>>3];if(T<U+A[R+640>>3]-L){break U}Q=0;break R}M=Q;Q=N;g=Ej(a,s,k);if((g|0)==1){break S}b=9500;break g}$q(a,b,0,R+648|0,R+640|0,R+668|0,R+664|0,R+660|0,R+636|0);k=k-1|0;K=U*Q;Q=U*M;g=v[a+4>>2];L=A[b+8>>3];M=A[b>>3]}N=A[g+1272>>3];U=L;V:{if(N<=-M){break V}U=D(M);X=A[g+1296>>3];T=M-K;M=T-M;K=D(T);W:{if(K<=1){K=1;if(U<=1){break W}K=U;break W}K=K>=U?K:U}U=L;if(D(M/K)<=X){break V}g=Li(a,s,T);if((g|0)!=1){b=9527;break g}v[G>>2]=v[G>>2]+1;g=v[a+4>>2];N=A[g+1272>>3];U=A[b+8>>3]}X:{if(N<=U){break X}K=D(U);N=A[g+1296>>3];M=L-Q;Q=M-U;L=D(M);Y:{if(L<=1){L=1;if(K<=1){break Y}L=K;break Y}L=K<=L?L:K}if(N>=D(Q/L)){break X}g=Ki(a,s,M);if((g|0)!=1){b=9534;break g}v[G>>2]=v[G>>2]+1}k=k+1|0;if((k|0)<v[b+248>>2]){continue}break}}if(!v[ha+92>>2]){break n}v[R+596>>2]=0;if(v[s+84>>2]&524544){break o}V=v[s+16>>2];k=v[V+248>>2];if((k|0)<3){break o}M=A[V+128>>3];if(M==1e99){nX(a,V);M=A[V+128>>3]}if(M>=A[v[a+4>>2]+1272>>3]){break o}v[V+256>>2]=v[V+256>>2]&-32769;g=Gp(a,s,R+596|0);if((g|0)!=1){e=11632;break h}if(v[R+596>>2]|!(w[V+257|0]&128)){break o}h=v[a+4>>2];ca=A[h+1272>>3];Q=A[V>>3];W=ca<=-Q;M=A[V+8>>3];if(!(W|ca<=M)){e=ub-48|0;ub=e;b=1;Z:{if(v[s+84>>2]&524544){break Z}g=v[s+16>>2];i=v[g+248>>2];if((i|0)<2){break Z}U=A[g>>3];N=A[h+1280>>3];if(!(U>N)){break Z}X=-N;T=A[g+8>>3];if(!(X>U-T)){break Z}k=v[g+168>>2];x=v[g+172>>2];K=1e99;M=1e99;h=i-1|0;g=h;Q=-1e99;while(1){_:{$:{j=v[k+(g<<2)>>2];switch(v[j+376>>2]>>>6&3){case 0:break _;case 3:break Z;default:break $}}if(!(A[j+128>>3]>=0)|!(A[j+136>>3]<=1)){break Z}}L=A[x+(g<<3)>>3];j=K==1e99|L<K;M=j?K:M==1e99?L:L<M?L:M;Q=Q==-1e99?L:L>Q?L:Q;K=j?L:K;j=(g|0)>0;g=g-1|0;if(j){continue}break}if(!(N<M+K-T)|(!(X<=K-U)|!(N>=Q-T))){break Z}aa:{while(1){b=Ko(a,s,h,1);if((b|0)==1){b=(h|0)<=0;h=h-1|0;if(!b){continue}break aa}break}Eb(150936,11508);v[e+32>>2]=b;Fb(276579,e+32|0);break Z}v[E>>2]=i+v[E>>2];b=Ki(a,s,1);if((b|0)!=1){Eb(150936,11513);v[e+16>>2]=b;Fb(276579,e+16|0);break Z}b=Li(a,s,1);if((b|0)!=1){Eb(150936,11514);v[e>>2]=b;Fb(276579,e);break Z}v[G>>2]=v[G>>2]+2;b=1}ub=e+48|0;g=b;if((b|0)==1){break o}e=11662;break h}e=11673;b=Ib(v[v[a>>2]+8>>2],k,4,150902,11673);v[R+668>>2]=b;if(!b){g=-1;break h}bx(b,393,V,k);mX(V,b,k);v[V+256>>2]=v[V+256>>2]&-4456449;Z=v[V+172>>2];fa=v[V+168>>2];Hb(v[v[a>>2]+8>>2],R+668|0,150902,11692);if((v[v[fa+4>>2]+376>>2]&192)==192){break o}K=A[v[a+4>>2]+1280>>3];ba:{if(!(K>=D(D(A[Z>>3])+-1))){break ba}if(!(M>=ca)&K>=M-H(M+K)){break o}if(W){break ba}if(K>=Q-H(Q+K)){break o}}aa=A[v[a+4>>2]+1296>>3];RJ(a,V,R+648|0,R+640|0,R+636|0,R+632|0,R+664|0,R+660|0);if(v[R+664>>2]|v[R+660>>2]){break o}j=-1;_=A[R+640>>3];K=A[R+648>>3];g=v[a+4>>2];U=A[g+1280>>3];L=A[Z>>3];T=W?M:Q;if(!(U>=D(L-T))){break q}e=1;if(-U>K){break q}while(1){ca:{N=A[Z+(e<<3)>>3];da:{if(U>=D(T-N)){if(!(A[v[fa+(e<<2)>>2]+128>>3]>.5)){break ca}e=0;N=L;break da}if((e|0)==(k|0)|(v[v[(fa+(e<<2)|0)-4>>2]+376>>2]&192)==192){break o}}b=U>=D(T+N)?0:e;if((b|0)==(k-1|0)|!b|(v[v[fa+(b<<2)>>2]+376>>2]&192)==192){break q}h=0;if((b|0)!=1){i=b&2147483646;x=0;while(1){j=v[fa+(h<<2)>>2];N=A[Z+(h<<3)>>3];S=h|1;O=v[fa+(S<<2)>>2];T=A[Z+(S<<3)>>3];K=K-A[j+128>>3]*N-A[O+128>>3]*T;_=_-A[j+136>>3]*N-A[O+136>>3]*T;h=h+2|0;x=x+2|0;if((i|0)!=(x|0)){continue}break}}if(b&1){i=v[fa+(h<<2)>>2];N=A[Z+(h<<3)>>3];K=K-A[i+128>>3]*N;_=_-A[i+136>>3]*N}j=b-1|0;N=A[Z+(b<<3)>>3];break p}e=e+1|0;if((k|0)!=(e|0)){continue}break}break o}if(w[ga+258|0]&2){break j}}v[y>>2]=v[y>>2]+1;break j}e=0;N=L}ea:{if(!(N-H(U+N)<=U)){K=M;break ea}N=aa+D(N);fa:{if(D(N)<0x8000000000000000){O=~~N>>>0;if(D(N)>=1){P=~~(N>0?F(H(N*2.3283064365386963e-10),4294967295):I((N-+(~~N>>>0>>>0))*2.3283064365386963e-10))>>>0}else{P=0}break fa}O=0;P=-2147483648}x=1;if(!e){b=v[fa>>2];N=A[b+136>>3];U=A[b+128>>3];ga:{if(L>0){_=_-N*L;K=K-U*L;break ga}_=_-U*L;K=K-N*L}e=1}h=k-1|0;ha:{if((h|0)>(e|0)){ia:{while(1){i=fa+(e<<2)|0;if((v[v[i>>2]+376>>2]&192)==192){break ia}S=Z+(e<<3)|0;L=A[S>>3];N=A[g+1280>>3];if(!(L-H(L+N)<=N)){x=0;break ia}L=aa+D(L);ja:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break ja}b=0;g=-2147483648}O=Kg(O,P,b,g);b=yb;P=b;if(!b&(O|0)==1){O=1;P=0;break ia}b=v[i>>2];N=A[b+128>>3];U=A[b+136>>3];L=A[S>>3];b=L>0;K=K-(b?N:U)*L;_=_-(b?U:N)*L;U=+(O>>>0)+ +(P|0)*4294967296;g=v[a+4>>2];N=A[g+1296>>3];ka:{if(M>=ca){i=0;L=Q-H(Q/U+N)*U;if(!(A[g+1280>>3]>=D(L))){break ka}L=U;break ka}i=0;L=M-H(M/U+N)*U;if(!(_<=L)){break ka}X=L-U;T=D(X);ia=K-X;X=D(K);la:{if(X<=1){X=1;if(T<=1){break la}X=T;break la}X=T<=X?X:T}i=ia/X>N}da=0;e=e+1|0;S=(j|0)==-1;b=0;ma:{if(W){break ma}T=D(L);X=D(_);b=0;if(!(-N>(_-L)/(X<=1?T<=1?1:T:T<=X?X:T))){break ma}b=L-U<=K}if(b|i?S:0){break ha}if((e|0)!=(h|0)){continue}break}e=h}g=v[a+4>>2]}N=A[g+1296>>3];L=+(O>>>0)+ +(P|0)*4294967296;if(!(M>=ca)){L=M-H(M/L+N)*L;da=1;break ha}da=1;U=Q-H(Q/L+N)*L;if(A[g+1280>>3]>=D(U)){break ha}L=U}X=D(_);ba=0;b=0;na:{if(!(D(A[R+640>>3])<1e9)){break na}b=0;if(!(X<1e9)){break na}b=0;if(!(D(A[R+648>>3])<1e9)){break na}b=D(K)<1e9}$=M>=ca;if(!($|!(L>=_))){T=L-(+(O>>>0)+ +(P|0)*4294967296);U=D(T);ia=K-T;T=D(K);oa:{if(T<=1){T=1;if(U<=1){break oa}T=U;break oa}T=U<=T?T:U}ba=ia/T>N}i=0;pa:{if(W){break pa}U=-N;N=D(L);if(!(U>(_-L)/(X<=1?N<=1?1:N:N<=X?X:N))){break pa}i=L-(+(O>>>0)+ +(P|0)*4294967296)<=K}qa:{if(!(b&(e|0)<(k|0))){K=M;break qa}ra:{if(!da){break ra}if((j|0)!=-1){K=M;break qa}if(i|ba){break ra}K=M;break qa}while(1){g=Ej(a,s,h);if((g|0)!=1){e=12e3;break h}b=(e|0)<(h|0);h=h-1|0;if(b){continue}break}v[E>>2]=v[E>>2]+(k-e|0);b=Z+(h<<3)|0;K=A[b>>3];g=Gp(a,s,R+596|0);if((g|0)!=1){e=12009;break h}if(v[R+596>>2]){break o}L=K/A[b>>3];K=aa+(+(O>>>0)+ +(P|0)*4294967296)/L;sa:{if(D(K)<0x8000000000000000){O=~~K>>>0;if(D(K)>=1){P=~~(K>0?F(H(K*2.3283064365386963e-10),4294967295):I((K-+(~~K>>>0>>>0))*2.3283064365386963e-10))>>>0}else{P=0}break sa}O=0;P=-2147483648}ta:{if(!$){g=Ki(a,s,H(A[V+8>>3]+A[v[a+4>>2]+1296>>3]));if((g|0)!=1){e=12025;break h}K=A[V+8>>3];break ta}K=L+-1;L=D(L);N=K/(L>1?L:1);L=A[v[a+4>>2]+1296>>3];K=M;if(!(N>L)){break ta}g=Li(a,s,I(A[V>>3]-L));if((g|0)!=1){e=12032;break h}Q=A[V>>3];K=M}x=1;v[G>>2]=v[G>>2]+1;k=v[V+248>>2];h=k-1|0}ua:{va:{i=(j|0)<0;wa:{if(i){e=h;break wa}if((O|0)!=1|P){e=h;break wa}g=-1;L=aa+D(A[Z+(h<<3)>>3]);xa:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){e=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}break xa}b=0;e=-2147483648}S=e;if((e|0)<0){e=1}else{e=b>>>0<2&(e|0)<=0}if(e){break va}if((h|0)<=(j|0)){break ea}e=-1;O=-1;P=-1;while(1){g=e;ba=fa+(h<<2)|0;if((v[v[ba>>2]+376>>2]&192)==192){break wa}L=A[Z+(h<<3)>>3];N=A[v[a+4>>2]+1280>>3];if(!(L-H(L+N)<=N)){x=0;b=O;S=P;break va}L=aa+D(L);ya:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){S=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{S=0}break ya}b=0;S=-2147483648}if((O&P)!=-1){b=Kg(O,P,b,S);S=yb}za:{if((b|0)!=1|S){O=b;P=S;break za}b=1;S=0;Aa:{Ba:{e=v[ba>>2];switch(v[e+376>>2]>>>6&3){case 3:break va;case 0:break Aa;default:break Ba}}if(!(A[e+128>>3]>=0)|!(A[e+136>>3]<=1)){break va}e=h;if((g|0)!=-1){break va}break za}e=h;if((g|0)!=-1){break va}}h=h-1|0;if((j|0)<(h|0)){continue}break}}h=O>>>0>1&(P|0)>=0|(P|0)>0;if(!(x&h&da)){b=O;S=P;g=e;break ua}h=1;b=O;S=P;g=e;x=1;L=A[(Z+(k<<3)|0)-8>>3];N=L;L=A[v[a+4>>2]+1280>>3];if(!(N-H(N+L)<=L)){break ea}break ua}h=b>>>0>1&(S|0)>=0|(S|0)>0}if(!x|(!h|i)){break ea}i=fa+(g<<2)|0;e=v[i>>2];h=v[e+376>>2]>>>6&3;if((h|0)==3){break ea}Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{P=Z+(g<<3)|0;L=A[P>>3];if(!(L>0)){break Ja}if(h){if(!(A[e+128>>3]>=0)|!(A[e+136>>3]<=1)){break Ja}}L=aa+L;Ka:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){h=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{h=0}break Ka}e=0;h=-2147483648}e=Kg(b,S,e,h);L=A[P>>3];h=yb;if((S|0)<=(h|0)&b>>>0<=e>>>0|(h|0)>(S|0)){break Ja}N=aa+L;La:{if(D(N)<0x8000000000000000){e=~~N>>>0;if(D(N)>=1){h=~~(N>0?F(H(N*2.3283064365386963e-10),4294967295):I((N-+(~~N>>>0>>>0))*2.3283064365386963e-10))>>>0}else{h=0}break La}e=0;h=-2147483648}e=_fb(e,h,b,S);x=yb;N=aa+($?Q:K);Ma:{if(D(N)<0x8000000000000000){h=~~N>>>0;if(D(N)>=1){i=~~(N>0?F(H(N*2.3283064365386963e-10),4294967295):I((N-+(~~N>>>0>>>0))*2.3283064365386963e-10))>>>0}else{i=0}break Ma}h=0;i=-2147483648}i=_fb(h,i,b,S);O=yb;Na:{if(!$){h=0;L=L-(+(e>>>0)+ +(x|0)*4294967296)+(e>>>0>i>>>0&(x|0)>=(O|0)|(x|0)>(O|0)?+(b>>>0)+ +(S|0)*4294967296:-0);if(!(A[v[a+4>>2]+1280>>3]>=D(L))){break Na}break Ha}L=L-(+(e>>>0)+ +(x|0)*4294967296);if(!(i|O)|(e>>>0<i>>>0&(x|0)<=(O|0)|(x|0)<(O|0))){break Na}L=L+(+(b>>>0)+ +(S|0)*4294967296)}if(A[v[a+4>>2]+1280>>3]>=D(L)){g=Ej(a,s,g);if((g|0)!=1){e=12192;break h}v[E>>2]=v[E>>2]+1;break Ia}g=Ko(a,s,g,L);if((g|0)!=1){e=12198;break h}v[E>>2]=v[E>>2]+1;break Ia}Oa:{if(L<0){break Oa}Pa:{e=v[i>>2];switch(v[e+376>>2]>>>6&3){case 0:break Ia;case 3:break Oa;default:break Pa}}if(!(A[e+128>>3]>=0)){break Oa}if(A[e+136>>3]<=1){break Ia}}L=aa+D(L);Qa:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Qa}e=0;g=-2147483648}b=Kg(b,S,e,g);S=yb}h=1;if($){break Ha}L=A[v[a+4>>2]+1296>>3];if(K-H(K+L)<=L){L=aa+K;Ra:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Ra}e=0;g=-2147483648}e=Kg(b,S,e,g);g=yb;if((S|0)<=(g|0)&b>>>0<=e>>>0|(g|0)>(S|0)){break Ha}}L=aa+D(A[P>>3]);Sa:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Sa}e=0;g=-2147483648}if((Kg(b,S,e,g)|0)==(b|0)&(S|0)==(yb|0)){break Ga}}if(W){break Ca}L=A[v[a+4>>2]+1296>>3];if(Q-H(Q+L)<=L){L=aa+Q;Ta:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Ta}e=0;g=-2147483648}e=Kg(b,S,e,g);g=yb;if((S|0)<=(g|0)&b>>>0<=e>>>0|(g|0)>(S|0)){break Ca}}L=aa+D(A[P>>3]);Ua:{if(D(L)<0x8000000000000000){e=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Ua}e=0;g=-2147483648}if((Kg(b,S,e,g)|0)==(b|0)&(S|0)==(yb|0)){break Fa}break Ca}if(W){break Ea}}L=+(b>>>0)+ +(S|0)*4294967296;L=I(Q/L-A[v[a+4>>2]+1296>>3])*L+aa;Va:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){e=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}break Va}b=0;e=-2147483648}L=+(b>>>0)+ +(e|0)*4294967296;g=Li(a,s,L);if((g|0)==1){break Da}e=12215;break h}L=+(b>>>0)+ +(S|0)*4294967296;L=H(K/L+A[v[a+4>>2]+1296>>3])*L+aa;Wa:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){e=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}break Wa}b=0;e=-2147483648}L=+(b>>>0)+ +(e|0)*4294967296;g=Ki(a,s,L);if((g|0)==1){break Da}e=12223;break h}v[G>>2]=v[G>>2]+1;e=j;Xa:{while(1){g=Ko(a,s,e,L);if((g|0)==1){b=(e|0)<=0;e=e-1|0;if(!b){continue}break Xa}break}e=12232;break h}v[E>>2]=(v[E>>2]+j|0)+1}if(!h){break ea}g=Gp(a,s,R+596|0);if((g|0)!=1){e=12240;break h}if(v[R+596>>2]){break o}K=A[V+8>>3];Q=A[V>>3];k=v[V+248>>2]}j=k-1|0;if((v[v[fa+(j<<2)>>2]+376>>2]&192)==192){break o}x=1;e=1;if((k|0)>0){L=A[v[a+4>>2]+1280>>3];g=j;while(1){Ya:{Za:{_a:{b=v[fa+(g<<2)>>2];switch(v[b+376>>2]>>>6&3){case 0:break Ya;case 3:break Za;default:break _a}}if(!(A[b+128>>3]>=0)){break Za}if(A[b+136>>3]<=1){break Ya}}x=0}N=A[Z+(g<<3)>>3];e=L>=N-H(L+N)?e:0;b=(g|0)>0;g=g-1|0;if(b){continue}break}}$a:{ab:{bb:{cb:{ba=M>=ca;db:{if(!ba){g=v[a+4>>2];L=A[g+1296>>3];if(!(L>=K-H(K+L))){break db}}if(W){break ab}g=v[a+4>>2];L=A[g+1296>>3];if(L>=Q-H(Q+L)){break ab}if(ba){break cb}}M=A[g+1280>>3];Q=H(K+M);if(e){g=Ki(a,s,Q);if((g|0)==1){break bb}e=12295;break h}eb:{if((k|0)<=0){break eb}X=K-Q;_=0;e=1;g=j;fb:{gb:while(1){k=g;while(1){N=A[Z+(k<<3)>>3];if(!(M>=N-H(M+N))){b=v[fa+(k<<2)>>2];U=A[b+136>>3];ca=A[b+128>>3];T=D(ca);if(!(T<=L|x|D(U)<=L)){break o}b=L>=T;N=b?N:-N;_=(N-H(M+N))*(b?U:ca)+_;if(M<_-X){break o}g=k-1|0;e=0;if(k){continue gb}break fb}b=(k|0)>0;k=k-1|0;if(b){continue}break}break}if(e&1){break eb}}while(1){M=A[Z+(j<<3)>>3];b=v[a+4>>2];L=A[b+1280>>3];Q=H(M+L);if(!(L>=M-Q)){hb:{M=A[b+1296>>3]>=D(A[v[fa+(j<<2)>>2]+128>>3])?Q:I(M-L);if(L>=D(M)){g=Ej(a,s,j);if((g|0)==1){break hb}e=12361;break h}g=Ko(a,s,j,M);if((g|0)==1){break hb}e=12367;break h}v[E>>2]=v[E>>2]+1}b=(j|0)>0;j=j-1|0;if(b){continue}break}Q=H(K+A[v[a+4>>2]+1280>>3])}g=Ki(a,s,Q);if((g|0)==1){break bb}e=12375;break h}if(e){g=Li(a,s,I(Q-A[g+1280>>3]));if((g|0)==1){break bb}e=12384;break h}N=A[g+1280>>3];U=-N;if(U>Q+-1){break o}K=H(Q+N);if((k|0)>0){T=Q-K;X=T+1;M=0;k=j;while(1){K=A[Z+(k<<3)>>3];if(N>=K-H(N+K)){break o}b=v[fa+(k<<2)>>2];_=A[b+136>>3];ca=A[b+128>>3];b=D(ca)<=L;if(!(D(_)<=L|b)){break o}K=b?K:-K;if(U>K+-1){break o}K=K-H(N+K);if(U>K-T){break o}M=K*(b?_:ca)+M;if(U<=M-X){break o}b=(k|0)<=0;k=k-1|0;if(!b){continue}break}while(1){L=A[Z+(j<<3)>>3];b=v[a+4>>2];K=A[b+1280>>3];M=H(L+K);if(!(K>=L-M)){ib:{L=A[b+1296>>3]>=D(A[v[fa+(j<<2)>>2]+128>>3])?M:I(L-K);if(K>=D(L)){g=Ej(a,s,j);if((g|0)==1){break ib}e=12466;break h}g=Ko(a,s,j,L);if((g|0)==1){break ib}e=12472;break h}v[E>>2]=v[E>>2]+1}b=(j|0)>0;j=j-1|0;if(b){continue}break}K=H(Q+A[v[a+4>>2]+1280>>3])}g=Li(a,s,K);if((g|0)==1){break bb}e=12480;break h}v[G>>2]=v[G>>2]+1;g=Gp(a,s,R+596|0);if((g|0)!=1){e=12486;break h}if(v[R+596>>2]){break o}k=v[V+248>>2];if((k|0)<=1){break o}Q=A[V>>3];K=A[V+8>>3];break $a}if(!e){break o}}L=A[v[a+4>>2]+1280>>3];if(!(ba|K-H(K+L)<=L)|!(W|L>=Q-H(Q+L))|L>=D(D(A[Z>>3])+-1)){break o}jb:{kb:{lb:{e=k-1|0;b=v[fa+(e<<2)>>2];switch(v[b+376>>2]>>>6&3){case 0:break jb;case 3:break kb;default:break lb}}if(!(A[b+128>>3]>=0)){break kb}if(A[b+136>>3]<=1){break jb}}if(L>=D(D(A[Z+(e<<3)>>3])+-1)){break o}}W=Z-16|0;while(1){L=A[v[a+4>>2]+1280>>3];g=k-1|0;if(L>=D(D(A[Z+(g<<3)>>3])+-1)){if(L>=D(D(A[W+(k<<3)>>3])+-1)){break o}}mb:{if(x){O=-1;P=-1;x=1;i=g;break mb}x=1;if((k|0)<=0){break o}i=-1;O=-1;P=-1;while(1){nb:{ob:{pb:{qb:{b=v[fa+(g<<2)>>2];switch(v[b+376>>2]>>>6&3){case 3:break ob;case 0:break pb;default:break qb}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break ob}}i=(i|0)==-1?g:i;break nb}L=aa+D(A[Z+(g<<3)>>3]);rb:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){e=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}break rb}b=0;e=-2147483648}x=0;if((O&P)==-1){O=b}else{O=Kg(O,P,b,e);e=yb}P=e;if(!e&(O|0)==1){break o}}b=(g|0)>0;g=g-1|0;if(b){continue}break}}if(!P&(O|0)==1|(i|0)==-1){break o}e=-1;if((i|0)>=0){$=i-1|0;j=-1;g=i;while(1){h=g;sb:{tb:{if(x){break tb}ub:{b=v[fa+(g<<2)>>2];switch(v[b+376>>2]>>>6&3){case 3:break sb;case 0:break tb;default:break ub}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break sb}}g=Z+(h<<3)|0;L=aa+D(A[g>>3]);vb:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){S=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{S=0}break vb}b=0;S=-2147483648}if((O&P)!=-1){b=Kg(O,P,b,S);S=yb}if((b|0)!=1|S){O=b;P=S;break sb}if((e|0)==-1){j=x?(h|0)==($|0)?i:j:j;e=h;break sb}if(!x|(h+1|0)!=(e|0)|(h+2|0)!=(j|0)){break o}L=aa+D(A[g>>3]);wb:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break wb}b=0;g=-2147483648}L=aa+D(A[Z+(e<<3)>>3]);xb:{if(D(L)<0x8000000000000000){k=~~L>>>0;if(D(L)>=1){S=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{S=0}break xb}k=0;S=-2147483648}e=j;O=Kg(k,S,b,g);b=yb;P=b;if(!b&(O|0)==1){break o}}g=h-1|0;if((h|0)>0){continue}break}}L=aa+(ba?Q:K);yb:{if(D(L)<0x8000000000000000){b=~~L>>>0;if(D(L)>=1){g=~~(L>0?F(H(L*2.3283064365386963e-10),4294967295):I((L-+(~~L>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break yb}b=0;g=-2147483648}i=_fb(b,g,O,P);h=yb;k=Z+(e<<3)|0;L=A[k>>3];zb:{if(L<0){M=L-aa;Ab:{if(D(M)<0x8000000000000000){b=~~M>>>0;if(D(M)>=1){g=~~(M>0?F(H(M*2.3283064365386963e-10),4294967295):I((M-+(~~M>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Ab}b=0;g=-2147483648}b=_fb(b,g,O,P);g=P+yb|0;b=b+O|0;g=b>>>0<O>>>0?g+1|0:g;break zb}M=aa+L;Bb:{if(D(M)<0x8000000000000000){b=~~M>>>0;if(D(M)>=1){g=~~(M>0?F(H(M*2.3283064365386963e-10),4294967295):I((M-+(~~M>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Bb}b=0;g=-2147483648}b=_fb(b,g,O,P);g=yb}j=b;b=g;Cb:{if(!ba){if(!!i&(h|0)>=0|(h|0)>0){g=Ki(a,s,K-(+(i>>>0)+ +(h|0)*4294967296));if((g|0)!=1){e=12707;break h}v[G>>2]=v[G>>2]+1;L=A[k>>3]}M=L-(+(j>>>0)+ +(b|0)*4294967296);if((b|0)<=(h|0)&i>>>0>=j>>>0|(b|0)<(h|0)){break Cb}M=M+(+(O>>>0)+ +(P|0)*4294967296);break Cb}if(!!i&(h|0)>=0|(h|0)>0){g=Li(a,s,Q-(+(i>>>0)+ +(h|0)*4294967296)+(+(O>>>0)+ +(P|0)*4294967296));if((g|0)!=1){e=12722;break h}v[G>>2]=v[G>>2]+1;L=A[k>>3]}M=L-(+(j>>>0)+ +(b|0)*4294967296);if(!(h|i)|((b|0)<=(h|0)&i>>>0>j>>>0|(b|0)<(h|0))){break Cb}M=M+(+(O>>>0)+ +(P|0)*4294967296)}Db:{if(A[v[a+4>>2]+1280>>3]>=D(M)){g=Ej(a,s,e);if((g|0)==1){break Db}e=12739;break h}g=Ko(a,s,e,M);if((g|0)==1){break Db}e=12744;break h}v[E>>2]=v[E>>2]+1;g=Gp(a,s,R+596|0);if((g|0)!=1){e=12749;break h}if(v[R+596>>2]){break o}Q=A[V>>3];K=A[V+8>>3];k=v[V+248>>2];if((k|0)>1){continue}break}}if(v[R+596>>2]){break c}}if(v[ha+88>>2]){e=v[a+4>>2];K=A[e+1280>>3];i=v[s+16>>2];Q=A[i>>3];Eb:{if(!(K>=D(Q-A[i+8>>3]))|!(K>=Q-H(Q+K))){break Eb}h=v[i+248>>2];if((h|0)<=0){break Eb}while(1){K=A[e+1280>>3];S=v[i+172>>2];O=v[i+168>>2];b=0;j=0;k=0;ba=0;while(1){L=A[S+(b<<3)>>3];if(!(K>=L-H(K+L))){break Eb}g=v[O+(b<<2)>>2];P=v[g+376>>2]>>>6&3;if((P|0)==3){break Eb}M=L;L=A[e+1296>>3];M=H(M+L);Fb:{if(D(M)<0x8000000000000000){x=~~M>>>0;break Fb}x=0}if(x&1){if(P){if(!(A[g+128>>3]>=0)|!(A[g+136>>3]<=1)){break Eb}}j=k?j:g;ba=k?g:ba;k=k+1|0}b=b+1|0;if((k|0)<3&h>>>0>b>>>0){continue}break}K=H(Q+L);Gb:{if(D(K)<0x8000000000000000){b=~~K>>>0;break Gb}b=0}b=b&1;e=0;Hb:{Ib:{Jb:{switch(k-1|0){case 0:g=Qc(a,j,b|e?1:0,R+648|0,R+640|0);if((g|0)!=1){b=11306;break i}if(!v[R+648>>2]){break Ib}v[R+596>>2]=1;break Eb;case 1:break Jb;default:break Eb}}b=!(b|e);g=Le(a,j,ba,1,b?-1:1,b?0:1,R+648|0,R+664|0,R+668|0);if((g|0)!=1){b=11336;break i}if(v[R+648>>2]){v[R+596>>2]=1;break Eb}b=r;if(v[R+668>>2]){break Hb}break Eb}b=q;if(!v[R+640>>2]){break Eb}}v[b>>2]=v[b>>2]+1;g=ar(a,s,R+648|0);if((g|0)!=1){b=11358;break i}if(v[R+648>>2]){v[R+596>>2]=1;break Eb}g=Gp(a,s,R+648|0);if((g|0)!=1){b=11368;break i}if(v[R+648>>2]){v[R+596>>2]=1;break Eb}e=v[a+4>>2];Q=A[i>>3];h=v[i+248>>2];if((h|0)>0){continue}break}}if(v[R+596>>2]){break c}}if(w[ga+257|0]&8){break j}b=Y>>>0<9;Y=Y+1|0;if(b){continue}}break}if(v[R+596>>2]){break c}Kb:{if(rc(v[a+4>>2],v[a+24>>2],0)){break Kb}Lb:{if(!v[ha+128>>2]){break Lb}b=v[q>>2];h=R+596|0;g=hX(a,s,h,q,u,z);e=16574;if((g|0)!=1){break e}if(v[R+596>>2]|v[q>>2]<=(b|0)){break Lb}g=ar(a,s,h);if((g|0)==1){break Lb}e=16579;break e}Mb:{b=v[R+596>>2];if(!(b|!v[ha+168>>2])){b=v[s+84>>2];Nb:{if(!(b&4194304)&(b&8404992)!=16384){break Nb}Q=A[ha+32>>3];ea=v[ha+108>>2];W=R+596|0;e=0;V=0;K=0;S=0;L=0;da=0;M=0;ba=0;fa=0;P=ub-464|0;ub=P;x=1;O=v[s+16>>2];Ob:{if(v[O+248>>2]<2){break Ob}g=v[O+256>>2];if(!(g&2097152)){b=Mi(a,O);if((b|0)!=1){Eb(150936,8076);v[P+432>>2]=b;Fb(276579,P+432|0);x=b;break Ob}Pb:{Qb:{$=v[O+168>>2];b=v[$>>2];switch(v[b+376>>2]>>>6&3){case 3:break Ob;case 0:break Pb;default:break Qb}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break Ob}}Y=v[O+172>>2];Z=v[O+248>>2];b=v[O+256>>2];if(!(b&64)){v[O+16>>2]=0;v[O+20>>2]=0;v[O+256>>2]=b|2032;Rb:{Sb:{Tb:{if(!Z){v[O+180>>2]=0;v[O+184>>2]=0;v[O+236>>2]=0;v[O+240>>2]=0;v[O+228>>2]=0;v[O+232>>2]=0;v[O+220>>2]=0;v[O+224>>2]=0;v[O+212>>2]=0;v[O+216>>2]=0;v[O+204>>2]=0;v[O+208>>2]=0;v[O+196>>2]=0;v[O+200>>2]=0;v[O+188>>2]=0;v[O+192>>2]=0;Wb(O+24|0,0,88);break Tb}A[O+24>>3]=D(A[Y>>3]);x=0;Wb(O+32|0,0,96);v[O+236>>2]=0;v[O+240>>2]=0;v[O+228>>2]=0;v[O+232>>2]=0;v[O+220>>2]=0;v[O+224>>2]=0;v[O+212>>2]=0;v[O+216>>2]=0;v[O+204>>2]=0;v[O+208>>2]=0;v[O+196>>2]=0;v[O+200>>2]=0;v[O+188>>2]=0;v[O+192>>2]=0;v[O+180>>2]=0;v[O+184>>2]=0;if((Z|0)>0){break Sb}}N=0;break Rb}while(1){Fo(a,O,v[v[O+168>>2]+(x<<2)>>2],A[v[O+172>>2]+(x<<3)>>3],0);x=x+1|0;if((x|0)<v[O+248>>2]){continue}break}L=A[O+80>>3]+A[O+88>>3];M=A[O+48>>3]+A[O+56>>3];K=A[O+32>>3]+A[O+40>>3];N=A[O+96>>3]+A[O+104>>3]}A[O+120>>3]=N;A[O+112>>3]=L;A[O+72>>3]=M;A[O+64>>3]=K}V=v[O+212>>2]?V:!v[O+228>>2];e=v[O+220>>2]?e:!v[O+204>>2];b=v[a+4>>2];ba=v[O+216>>2]?ba:!v[O+232>>2];K=A[O>>3];M=A[O+8>>3];L=A[b+1272>>3];S=v[O+224>>2]?S:!v[O+240>>2];x=L<=M;N=-K;Ub:{if(x&N>=L){break Ub}b=V|ba;if((b|e|S)!=1){break Ub}ja=v[u>>2];v[P+456>>2]=0;if(!(!b|w[O+257|0]&2)){Uq(a,O)}g=1;if(!(w[O+257|0]&4|(e|S)!=1)){Tq(a,O)}b=-1;j=Z-1|0;Vb:{if((Z|0)<=0){K=-1;break Vb}i=j;K=-1;while(1){h=g;g=0;Wb:{Xb:{Yb:{k=i;i=v[$+(k<<2)>>2];switch(v[i+376>>2]>>>6&3){case 3:break Wb;case 0:break Xb;default:break Yb}}if(!(A[i+128>>3]>=0)){break Wb}if(A[i+136>>3]<=1){break Xb}break Wb}M=A[Y+(k<<3)>>3];Zb:{if(M>0){M=M*A[i+136>>3];g=M>K;K=g?M:K;da=g?1:da;b=g?k:b;break Zb}M=D(M*A[i+128>>3]);g=M>K;K=g?M:K;da=g?0:da;b=g?k:b}g=h}i=k-1|0;if((k|0)>0){continue}break}}M=A[v[a+4>>2]+1280>>3];if(g|M>=D(K+-1)){break Ub}i=0;_b:{$b:{ac:{if(!((x^-1)&V&ba)|!(M>=D(A[O+80>>3]+A[O+88>>3]-(A[O+8>>3]-K)))|(Z|0)<=0){break ac}V=$+(b<<2)|0;g=j;while(1){bc:{cc:{dc:{ec:{h=v[$+(g<<2)>>2];k=v[h+376>>2];switch(k>>>6&3){case 0:break cc;case 3:break dc;default:break ec}}if(!(A[h+128>>3]>=0)){break dc}if(A[h+136>>3]<=1){break cc}}if((b|0)==(g|0)){break bc}k=v[V>>2];fc:{if(A[Y+(g<<3)>>3]>0){x=pj(a,k,da,h,1,A[h+128>>3],P+460|0,P+456|0);if((x|0)==1){break fc}g=8187;break $b}x=pj(a,k,da,h,0,A[h+136>>3],P+460|0,P+456|0);if((x|0)==1){break fc}g=8194;break $b}v[u>>2]=v[u>>2]+v[P+456>>2];i=i+1|0;if(!v[P+460>>2]){break bc}v[W>>2]=1;break ac}if(!(k&192)){break ac}}h=(g|0)>0;g=g-1|0;if(h){continue}break}}gc:{if(!(A[v[a+4>>2]+1280>>3]>=D(A[O+96>>3]+A[O+104>>3]-(A[O>>3]-K)))|((L<=N^-1)&e&S)!=1|(Z|0)<=0){break gc}h=$+(b<<2)|0;while(1){hc:{ic:{jc:{kc:{e=v[$+(j<<2)>>2];g=v[e+376>>2];switch(g>>>6&3){case 0:break ic;case 3:break jc;default:break kc}}if(!(A[e+128>>3]>=0)){break jc}if(A[e+136>>3]<=1){break ic}}if((b|0)==(j|0)){break hc}g=v[h>>2];lc:{if(A[Y+(j<<3)>>3]>0){x=pj(a,g,da,e,0,A[e+136>>3],P+460|0,P+456|0);if((x|0)==1){break lc}g=8228;break $b}x=pj(a,g,da,e,1,A[e+128>>3],P+460|0,P+456|0);if((x|0)==1){break lc}g=8235;break $b}v[u>>2]=v[u>>2]+v[P+456>>2];i=i+1|0;if(!v[P+460>>2]){break hc}v[W>>2]=1;break gc}if(!(g&192)){break gc}}e=(j|0)>0;j=j-1|0;if(e){continue}break}}x=1;if((i|0)<=0){break Ub}if(v[W>>2]){break Ob}if((ja|0)>=v[u>>2]){break Ub}g=8265;x=Fp(a,s,W,q);if((x|0)!=1){break $b}x=1;if(v[W>>2]){break Ob}g=8270;x=dv(a,s,Q,ea,W,u);if((x|0)!=1){break $b}x=1;if(v[W>>2]){break Ob}g=8275;x=Fp(a,s,W,q);if((x|0)==1){break _b}}Eb(150936,g);v[P+416>>2]=x;Fb(276579,P+416|0);break Ob}x=1;if(v[W>>2]){break Ob}}g=v[O+256>>2]|2097152;v[O+256>>2]=g}x=1;if(g&1048576){break Ob}v[O+256>>2]=g|1048576;x=Mi(a,O);if((x|0)!=1){Eb(150936,8295);v[P+400>>2]=x;Fb(276579,P+400|0);break Ob}i=v[O+172>>2];ba=v[O+168>>2];g=v[O+248>>2];b=v[O+256>>2];if(!(b&64)){v[O+16>>2]=0;v[O+20>>2]=0;v[O+256>>2]=b|2032;mc:{nc:{oc:{if(!g){v[O+180>>2]=0;v[O+184>>2]=0;v[O+236>>2]=0;v[O+240>>2]=0;v[O+228>>2]=0;v[O+232>>2]=0;v[O+220>>2]=0;v[O+224>>2]=0;v[O+212>>2]=0;v[O+216>>2]=0;v[O+204>>2]=0;v[O+208>>2]=0;v[O+196>>2]=0;v[O+200>>2]=0;v[O+188>>2]=0;v[O+192>>2]=0;Wb(O+24|0,0,88);break oc}A[O+24>>3]=D(A[i>>3]);x=0;Wb(O+32|0,0,96);v[O+236>>2]=0;v[O+240>>2]=0;v[O+228>>2]=0;v[O+232>>2]=0;v[O+220>>2]=0;v[O+224>>2]=0;v[O+212>>2]=0;v[O+216>>2]=0;v[O+204>>2]=0;v[O+208>>2]=0;v[O+196>>2]=0;v[O+200>>2]=0;v[O+188>>2]=0;v[O+192>>2]=0;v[O+180>>2]=0;v[O+184>>2]=0;if((g|0)>0){break nc}}M=0;L=0;N=0;K=0;break mc}while(1){Fo(a,O,v[v[O+168>>2]+(x<<2)>>2],A[v[O+172>>2]+(x<<3)>>3],0);x=x+1|0;if((x|0)<v[O+248>>2]){continue}break}L=A[O+80>>3]+A[O+88>>3];M=A[O+48>>3]+A[O+56>>3];N=A[O+96>>3]+A[O+104>>3];K=A[O+32>>3]+A[O+40>>3]}A[O+120>>3]=N;A[O+112>>3]=L;A[O+72>>3]=M;A[O+64>>3]=K}j=0;da=0;da=v[O+212>>2]?da:!v[O+228>>2];j=v[O+220>>2]?j:!v[O+204>>2];b=v[a+4>>2];ma=0;ma=v[O+216>>2]?ma:!v[O+232>>2];K=A[O>>3];M=A[O+8>>3];L=A[b+1272>>3];fa=v[O+224>>2]?fa:!v[O+240>>2];pc:{qc:{ka=L<=M;U=-K;rc:{if(ka&U>=L){break rc}h=da|ma;if((h|j|fa)!=1){break rc}Y=Ib(v[v[a>>2]+8>>2],g,4,150902,8328);v[P+456>>2]=Y;if(!Y){Eb(150936,8328);x=-1;v[P>>2]=-1;Fb(276579,P);break Ob}$=Ib(v[v[a>>2]+8>>2],g,8,150902,8329);v[P+452>>2]=$;sc:{tc:{if($){x=0;if((g|0)>0){break tc}V=0;S=0;e=0;break sc}Eb(150936,8329);x=-1;v[P+16>>2]=-1;Fb(276579,P+16|0);break Ob}e=0;S=0;V=0;while(1){uc:{vc:{wc:{xc:{b=v[(x<<2)+ba>>2];k=v[b+376>>2];switch(k>>>6&3){case 3:break vc;case 0:break wc;default:break xc}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break vc}}K=A[(x<<3)+i>>3];M=A[v[a+4>>2]+1280>>3];k=e+S|0;v[Y+(k<<2)>>2]=b;A[$+(k<<3)>>3]=K;V=(M>=D(D(K)+-1))+V|0;if(K>A[v[a+4>>2]+1280>>3]){e=e+1|0;break uc}S=S+1|0;break uc}if((k&192)==192){break sc}}x=x+1|0;if((x|0)!=(g|0)){continue}break}}yc:{if((S|0)<2&(e|0)<=1|(g|0)<=(V|0)){break yc}na=v[u>>2];if(!(!h|w[O+257|0]&2)){Uq(a,O)}if(!(w[O+257|0]&4|(j|fa)!=1)){Tq(a,O)}us($,Y,e+S|0);h=0;zc:{Ac:{Bc:{Cc:{Dc:{if(((ka^-1)&da)!=1|(e|0)<2){break Dc}M=A[O+8>>3]-(A[O+80>>3]+A[O+88>>3]);K=D(M);k=K<=1;T=A[$>>3]+A[$+8>>3];N=D(T);_=k?1:K;N=(T-M)/(N<=1?_:K<=N?N:K);T=A[v[a+4>>2]+1296>>3];if(!(N>T)){break Dc}h=2;b=1;Ec:{if(e>>>0<3){break Ec}X=_;b=0;while(1){k=$+(h<<3)|0;_=A[k-8>>3]+A[k>>3];N=D(_);if(!(T<(_-M)/(N<=1?X:K<=N?N:K))){break Ec}h=h+1|0;b=(h|0)>=(e|0);if((e|0)!=(h|0)){continue}break}h=e}x=Ti(a,Y,0,h,0,P+460|0,P+448|0);if((x|0)!=1){Eb(150936,8410);v[P+384>>2]=x;Fb(276579,P+384|0);break Ob}if(v[P+460>>2]){v[W>>2]=1}v[u>>2]=v[u>>2]+v[P+448>>2];if(h>>>0>999999){break Ac}x=v[W>>2];if(((x|0)!=0|b)&1){break Cc}b=8429;k=Oc(v[v[a>>2]+8>>2],Y,h,4,150902,8429);v[P+444>>2]=k;if(!k){x=-1;break Bc}V=1;Fc:{if((e|0)<=(h|0)){x=1;break Fc}b=h-2|0;T=K<=1?1:K;Z=h;while(1){X=A[$+(b<<3)>>3]+A[$+(Z<<3)>>3];N=D(X);Gc:{if(A[v[a+4>>2]+1296>>3]<(X-M)/(N<=1?T:K<=N?N:K)){v[(v[P+444>>2]+(b<<2)|0)+4>>2]=v[Y+(Z<<2)>>2];k=b+2|0;x=Ti(a,v[P+444>>2],0,k,0,P+460|0,P+448|0);if((x|0)!=1){b=8440;break Bc}if(v[P+460>>2]){x=1;v[W>>2]=1;break Fc}v[u>>2]=v[u>>2]+v[P+448>>2];h=h+k|0;if((h|0)>999999){x=0;break Fc}Z=Z+1|0;break Gc}b=b-1|0}x=1;if((b|0)<0){break Fc}if((e|0)>(Z|0)){continue}break}}Hb(v[v[a>>2]+8>>2],P+444|0,150902,8463);Z=0;if(!x){break zc}}x=v[W>>2]}V=0;Z=1;if(x){break zc}x=0;Hc:{Ic:{if(v[u>>2]>(na|0)){x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8472);v[P+352>>2]=x;Fb(276579,P+352|0);break Ob}if(v[W>>2]){break Ic}x=dv(a,s,Q,ea,W,u);if((x|0)!=1){Eb(150936,8477);v[P+336>>2]=x;Fb(276579,P+336|0);break Ob}if(v[W>>2]){break Ic}x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8482);v[P+320>>2]=x;Fb(276579,P+320|0);break Ob}if(v[W>>2]){break Ic}x=Mi(a,O);if((x|0)!=1){Eb(150936,8487);v[P+304>>2]=x;Fb(276579,P+304|0);break Ob}if(!(w[O+256|0]&64)){lJ(a,O)}i=v[O+172>>2];ba=v[O+168>>2];x=0;g=v[O+248>>2];Jc:{if((g|0)<=0){S=0;e=0;break Jc}e=0;S=0;while(1){Kc:{Lc:{Mc:{Nc:{b=v[(x<<2)+ba>>2];k=v[b+376>>2];switch(k>>>6&3){case 3:break Lc;case 0:break Mc;default:break Nc}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break Lc}}K=A[(x<<3)+i>>3];k=e+S|0;v[Y+(k<<2)>>2]=b;A[$+(k<<3)>>3]=K;if(K>A[v[a+4>>2]+1280>>3]){e=e+1|0;break Kc}S=S+1|0;break Kc}if((k&192)==192){break Jc}}x=x+1|0;if((x|0)!=(g|0)){continue}break}}na=v[u>>2];x=v[W>>2]}Oc:{Pc:{if(!(!x&(L<=U^-1)&fa)|(S|0)<2){break Pc}M=A[O>>3]-(A[O+96>>3]+A[O+104>>3]);K=D(M);la=e+S|0;qa=la-1|0;T=A[$+(qa<<3)>>3]+A[($+(la<<3)|0)-16>>3];N=D(T);N=(T-M)/(N<=1?K<=1?1:K:K<=N?N:K);T=-A[v[a+4>>2]+1296>>3];if(!(N<T)){break Oc}b=la-3|0;Qc:{if((e|0)>(b|0)){V=1;break Qc}X=K<=1?1:K;k=e-1|0;while(1){x=$+(b<<3)|0;_=A[x+8>>3]+A[x>>3];N=D(_);V=T>(_-M)/(N<=1?X:K<=N?N:K);if(!V){break Qc}x=(b|0)>(e|0);b=b-1|0;if(x){continue}break}b=k}ja=(Y+(b<<2)|0)+4|0;k=qa-b|0;x=Ti(a,ja,0,k,0,P+460|0,P+448|0);if((x|0)!=1){Eb(150936,8560);v[P+288>>2]=x;Fb(276579,P+288|0);break Ob}if(v[P+460>>2]){v[W>>2]=1}v[u>>2]=v[u>>2]+v[P+448>>2];h=h+k|0;if((h|0)>999999){break Ac}x=v[W>>2];if(V|x){break Pc}V=8579;k=Oc(v[v[a>>2]+8>>2],ja,k,4,150902,8579);v[P+444>>2]=k;if(!k){x=-1;break Hc}V=1;ja=b+2|0;Rc:{if((la|0)<=(ja|0)){x=1;break Rc}if((b|0)<(e|0)){x=1;break Rc}T=K<=1?1:K;k=b;while(1){X=A[$+(ja<<3)>>3]+A[$+(k<<3)>>3];N=D(X);Sc:{if(-A[v[a+4>>2]+1296>>3]>(X-M)/(N<=1?T:K<=N?N:K)){x=(ja-b<<2)-8|0;v[x+v[P+444>>2]>>2]=v[Y+(k<<2)>>2];sa=(qa-ja|0)+2|0;x=Ti(a,x+v[P+444>>2]|0,0,sa,0,P+460|0,P+448|0);if((x|0)!=1){V=8593;break Hc}if(v[P+460>>2]){x=1;v[W>>2]=1;break Rc}v[u>>2]=v[u>>2]+v[P+448>>2];h=h+sa|0;if((h|0)>999999){x=0;break Rc}k=k-1|0;break Sc}ja=ja+1|0}x=1;if((ja|0)>=(la|0)){break Rc}if((e|0)<=(k|0)){continue}break}}Hb(v[v[a>>2]+8>>2],P+444|0,150902,8616);if(!x){Z=0;break zc}x=v[W>>2]}V=0;if(!x){break Oc}break zc}if(v[u>>2]<=(na|0)){break zc}x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8625);v[P+256>>2]=x;Fb(276579,P+256|0);break Ob}if(v[W>>2]){break Ic}x=dv(a,s,Q,ea,W,u);if((x|0)!=1){Eb(150936,8630);v[P+240>>2]=x;Fb(276579,P+240|0);break Ob}if(v[W>>2]){break Ic}x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8635);v[P+224>>2]=x;Fb(276579,P+224|0);break Ob}if(v[W>>2]){break Ic}x=Mi(a,O);if((x|0)!=1){Eb(150936,8640);v[P+208>>2]=x;Fb(276579,P+208|0);break Ob}if(!(w[O+256|0]&64)){lJ(a,O)}i=v[O+172>>2];ba=v[O+168>>2];S=0;g=v[O+248>>2];if((g|0)<=0){e=0;break Ic}e=0;while(1){Tc:{Uc:{Vc:{Wc:{Xc:{Yc:{b=v[(S<<2)+ba>>2];k=v[b+376>>2];switch(k>>>6&3){case 3:break Wc;case 0:break Xc;default:break Yc}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break Wc}}K=A[(S<<3)+i>>3];k=e+V|0;v[Y+(k<<2)>>2]=b;A[$+(k<<3)>>3]=K;if(!(K>A[v[a+4>>2]+1280>>3])){break Vc}e=e+1|0;break Uc}if((k&192)!=192){break Uc}break Tc}V=V+1|0}S=S+1|0;if((S|0)!=(g|0)){continue}}break}S=V}na=v[u>>2];V=0;break zc}Eb(150936,V);v[P+272>>2]=x;Fb(276579,P+272|0);break Ob}Eb(150936,b);v[P+368>>2]=x;Fb(276579,P+368|0);break Ob}V=1;Z=0}if(!(!(!v[W>>2]&(ka^-1)&da&ma)|(S|0)<2)){b=Ib(v[v[a>>2]+8>>2],S,4,150902,8692);v[P+444>>2]=b;if(!b){Eb(150936,8692);x=-1;v[P+32>>2]=-1;Fb(276579,P+32|0);break Ob}dc(b,S<<2);M=A[O+8>>3]-(A[O+80>>3]+A[O+88>>3]);K=D(M);S=e+S|0;ja=S-1|0;T=-A[$+(ja<<3)>>3]-A[($+(S<<3)|0)-16>>3];N=D(T);N=(T-M)/(N<=1?K<=1?1:K:K<=N?N:K);T=A[v[a+4>>2]+1296>>3];Zc:{if(!(N>T)){break Zc}b=S-3|0;_c:{if((e|0)>(b|0)){da=1;break _c}X=K<=1?1:K;k=e-1|0;while(1){x=$+(b<<3)|0;_=-A[x+8>>3]-A[x>>3];N=D(_);da=T<(_-M)/(N<=1?X:K<=N?N:K);if(!da){break _c}x=(b|0)>(e|0);b=b-1|0;if(x){continue}break}b=k}ma=(Y+(b<<2)|0)+4|0;k=ja-b|0;x=Ti(a,ma,v[P+444>>2],k,0,P+460|0,P+448|0);if((x|0)!=1){Eb(150936,8720);v[P+192>>2]=x;Fb(276579,P+192|0);break Ob}if(v[P+460>>2]){v[W>>2]=1}v[u>>2]=v[u>>2]+v[P+448>>2];V=1;h=h+k|0;if(Z^1|(h|0)>999999){break Zc}V=0;if(v[W>>2]|da){break Zc}da=8739;k=Oc(v[v[a>>2]+8>>2],ma,k,4,150902,8739);v[P+440>>2]=k;if(!k){x=-1;break pc}da=b+2|0;$c:{if((b|0)<(e|0)|(S|0)<=(da|0)){break $c}T=K<=1?1:K;k=b;while(1){X=-A[$+(da<<3)>>3]-A[$+(k<<3)>>3];N=D(X);ad:{if(A[v[a+4>>2]+1296>>3]<(X-M)/(N<=1?T:K<=N?N:K)){x=(da-b<<2)-8|0;v[x+v[P+440>>2]>>2]=v[Y+(k<<2)>>2];Z=(ja-da|0)+2|0;x=Ti(a,x+v[P+440>>2]|0,v[P+444>>2],Z,0,P+460|0,P+448|0);if((x|0)!=1){da=8753;break pc}if(v[P+460>>2]){v[W>>2]=1;break $c}v[u>>2]=v[u>>2]+v[P+448>>2];h=h+Z|0;if((h|0)>999999){V=1;break $c}k=k-1|0;break ad}da=da+1|0}if((S|0)<=(da|0)){break $c}if((e|0)<=(k|0)){continue}break}}Hb(v[v[a>>2]+8>>2],P+440|0,150902,8776)}Hb(v[v[a>>2]+8>>2],P+444|0,150902,8780)}if(V){break yc}bd:{if(v[W>>2]|v[u>>2]<=(na|0)){break bd}x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8787);v[P+160>>2]=x;Fb(276579,P+160|0);break Ob}if(v[W>>2]){break bd}x=dv(a,s,Q,ea,W,u);if((x|0)!=1){Eb(150936,8792);v[P+144>>2]=x;Fb(276579,P+144|0);break Ob}if(v[W>>2]){break bd}x=Fp(a,s,W,q);if((x|0)!=1){Eb(150936,8797);v[P+128>>2]=x;Fb(276579,P+128|0);break Ob}if(v[W>>2]){break bd}x=Mi(a,O);if((x|0)!=1){Eb(150936,8802);v[P+112>>2]=x;Fb(276579,P+112|0);break Ob}if(!(w[O+256|0]&64)){lJ(a,O)}i=v[O+172>>2];ba=v[O+168>>2];e=0;g=v[O+248>>2];if((g|0)<=0){break bd}b=0;k=0;while(1){cd:{dd:{ed:{fd:{gd:{hd:{x=v[(e<<2)+ba>>2];S=v[x+376>>2];switch(S>>>6&3){case 3:break fd;case 0:break gd;default:break hd}}if(!(A[x+128>>3]>=0)|!(A[x+136>>3]<=1)){break fd}}K=A[(e<<3)+i>>3];S=b+k|0;v[Y+(S<<2)>>2]=x;A[$+(S<<3)>>3]=K;if(!(K>A[v[a+4>>2]+1280>>3])){break ed}b=b+1|0;break dd}if((S&192)!=192){break dd}break cd}k=k+1|0}e=e+1|0;if((g|0)!=(e|0)){continue}}break}e=b}if(!(!v[W>>2]&(L<=U^-1)&j&fa)|(e|0)<2){break yc}k=Ib(v[v[a>>2]+8>>2],e,4,150902,8852);v[P+444>>2]=k;if(!k){Eb(150936,8852);x=-1;v[P+48>>2]=-1;Fb(276579,P+48|0);break Ob}j=2;dc(k,e<<2);L=A[O>>3]-(A[O+96>>3]+A[O+104>>3]);K=D(L);x=K<=1;Q=-A[$>>3]-A[$+8>>3];M=D(Q);N=x?1:K;M=(Q-L)/(M<=1?N:K<=M?M:K);Q=-A[v[a+4>>2]+1296>>3];id:{if(!(M<Q)){break id}b=1;jd:{if(e>>>0<3){break jd}b=0;while(1){x=$+(j<<3)|0;U=-A[x-8>>3]-A[x>>3];M=D(U);if(!(Q>(U-L)/(M<=1?N:K<=M?M:K))){break jd}j=j+1|0;b=(j|0)>=(e|0);if((e|0)!=(j|0)){continue}break}j=e}x=Ti(a,Y,k,j,0,P+460|0,P+448|0);if((x|0)!=1){Eb(150936,8878);v[P+96>>2]=x;Fb(276579,P+96|0);break Ob}if(v[P+460>>2]){v[W>>2]=1}v[u>>2]=v[u>>2]+v[P+448>>2];k=h+j|0;if((v[W>>2]!=0|b)&1|(k|0)>999999){break id}b=8897;h=Oc(v[v[a>>2]+8>>2],Y,j,4,150902,8897);v[P+440>>2]=h;if(!h){x=-1;break qc}kd:{if((e|0)<=(j|0)){break kd}b=j-2|0;Q=K<=1?1:K;while(1){N=-A[$+(b<<3)>>3]-A[$+(j<<3)>>3];M=D(N);ld:{if(-A[v[a+4>>2]+1296>>3]>(N-L)/(M<=1?Q:K<=M?M:K)){v[((b<<2)+h|0)+4>>2]=v[v[P+456>>2]+(j<<2)>>2];h=v[P+440>>2];S=b+2|0;x=Ti(a,h,v[P+444>>2],S,0,P+460|0,P+448|0);if((x|0)!=1){b=8908;break qc}if(v[P+460>>2]){v[W>>2]=1;break kd}v[u>>2]=v[u>>2]+v[P+448>>2];k=k+S|0;if((k|0)>999999){break kd}j=j+1|0;break ld}b=b-1|0}if((b|0)<0){break kd}if((e|0)>(j|0)){continue}break}}Hb(v[v[a>>2]+8>>2],P+440|0,150902,8928)}Hb(v[v[a>>2]+8>>2],P+444|0,150902,8932)}Hb(v[v[a>>2]+8>>2],P+452|0,150902,8936);Hb(v[v[a>>2]+8>>2],P+456|0,150902,8937);x=1;if(v[W>>2]){break Ob}}j=0;Q=A[O+8>>3];md:{if((g|0)>0){x=1;k=0;h=0;while(1){nd:{od:{b=v[(j<<2)+ba>>2];switch(v[b+376>>2]>>>6&3){case 3:break Ob;case 0:break nd;default:break od}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break Ob}}L=A[v[a+4>>2]+1280>>3];K=A[(j<<3)+i>>3];pd:{if(L>=D(K+-1)){k=k+1|0;break pd}if(!(D(K+1)<=L)){break Ob}h=h+1|0}j=j+1|0;if((j|0)!=(g|0)){continue}break}M=+(k|0)+-1;K=+(h|0);break md}L=A[v[a+4>>2]+1280>>3];M=-1;K=0}K=D(Q-(1-K));if(!(D(A[O>>3]-M)<=L)){x=1;if(!(K<=L)){break Ob}}b=8972;e=Ib(v[v[a>>2]+8>>2],g,4,150902,8972);v[P+456>>2]=e;qd:{if(!e){x=-1;break qd}rd:{if((g|0)<=0){break rd}x=0;if((g|0)!=1){h=g&2147483646;b=0;while(1){j=K<=L;v[e+(x<<2)>>2]=!(j^A[(x<<3)+i>>3]>0);k=x|1;v[e+(k<<2)>>2]=!(j^A[(k<<3)+i>>3]>0);x=x+2|0;b=b+2|0;if((h|0)!=(b|0)){continue}break}}if(!(g&1)){break rd}v[e+(x<<2)>>2]=!(K<=L^A[(x<<3)+i>>3]>0)}b=8977;x=Ti(a,ba,e,g,A[v[a+4>>2]+1280>>3]>=D(A[O>>3]-A[O+8>>3]),P+460|0,P+452|0);if((x|0)!=1){break qd}if(v[P+460>>2]){v[W>>2]=1}v[u>>2]=v[u>>2]+v[P+452>>2];Hb(v[v[a>>2]+8>>2],P+456|0,150902,8983);x=1;break Ob}Eb(150936,b);v[P+64>>2]=x;Fb(276579,P- -64|0);break Ob}Eb(150936,b);v[P+80>>2]=x;Fb(276579,P+80|0);break Ob}Eb(150936,da);v[P+176>>2]=x;Fb(276579,P+176|0)}ub=P+464|0;g=x;e=16588;if((g|0)!=1){break e}if(v[R+596>>2]){break Mb}b=v[s+84>>2];if(v[ga+248>>2]|!(b&4194304)&(b&8404992)!=16384){break Nb}L=A[ga+8>>3];K=D(L);M=A[v[a+4>>2]+1296>>3];Q=A[ga>>3];N=Q-L;L=D(Q);sd:{if(L<=1){L=1;if(K<=1){break sd}L=K;break sd}L=K<=L?L:K}if(M<N/L){v[R+596>>2]=1;break Mb}g=pc(a,s);e=16603;if((g|0)!=1){break e}if(w[ga+258|0]&2){break Nb}v[y>>2]=v[y>>2]+1}b=v[R+596>>2]}if(b){break Mb}b=v[s+84>>2];if(!(!(b&4194304)&(b&8404992)!=16384)){Q=0;ja=0;fa=0;x=0;ma=0;qa=0;P=ub-1312|0;ub=P;b=1;e=v[s+16>>2];K=A[e>>3];L=A[e+8>>3];td:{if(!(A[v[a+4>>2]+1280>>3]>=D(K-L))){break td}ud:{vd:{wd:{g=v[e+248>>2];switch(g-1|0){case 1:break vd;case 0:break wd;default:break ud}}i=9583;xd:{L=A[v[a+4>>2]+1280>>3];M=K;K=A[v[e+172>>2]>>3];b=Qc(a,v[v[e+168>>2]>>2],BP(L*-.9+M/K,L*.9+A[e+8>>3]/K),P+256|0,P+1296|0);if((b|0)!=1){break xd}if(v[P+256>>2]){v[R+596>>2]=1;b=1;break td}if(v[P+1296>>2]){v[q>>2]=v[q>>2]+1}i=9594;b=pc(a,s);if((b|0)!=1){break xd}if(!(w[e+258|0]&2)){v[y>>2]=v[y>>2]+1}b=1;break td}Eb(150936,i);v[P+208>>2]=b;Fb(276579,P+208|0);Eb(150936,10610);v[P+192>>2]=b;Fb(276579,P+192|0);break td}g=9633;yd:{b=v[e+168>>2];h=v[b>>2];i=v[b+4>>2];b=v[e+172>>2];b=Le(a,h,i,A[b>>3],A[b+8>>3],L,P+256|0,P+1296|0,P+1308|0);if((b|0)!=1){break yd}if(v[P+256>>2]){v[R+596>>2]=1;b=1;break td}if(v[P+1308>>2]){v[r>>2]=v[r>>2]+1}zd:{if(!v[P+1296>>2]){break zd}g=9650;b=pc(a,s);if((b|0)!=1){break yd}if(w[e+258|0]&2){break zd}v[y>>2]=v[y>>2]+1}b=1;break td}Eb(150936,g);v[P+240>>2]=b;Fb(276579,P+240|0);Eb(150936,10615);v[P+224>>2]=b;Fb(276579,P+224|0);break td}Ad:{b=Bi(a);if(!g|(b|0)<(g|0)|!v[ha+124>>2]&(b|0)>(g|0)){break Ad}if((!v[ha+116>>2]|!v[ha+120>>2])&(b|0)==(g|0)){break Ad}h=v[e+168>>2];U=A[e+8>>3];i=v[e+248>>2];Bd:{if((i|0)<=0){_=1;break Bd}K=A[v[a+4>>2]+1280>>3];b=v[h>>2];j=v[b+376>>2]&1792;if((j|0)==1536){b=v[b+236>>2]}L=A[b>>3];if(D(L)<=K){break Ad}b=v[e+172>>2];M=A[b>>3];e=(j|0)==1536;_=M/(e?-L:L);U=U+(e?M:-0);e=1;if((i|0)==1){break Bd}while(1){j=v[h+(e<<2)>>2];Cd:{if((v[j+376>>2]&1792)==1536){L=A[v[j+236>>2]>>3];if(K>=D(L)){break Ad}M=-L*_;L=A[b+(e<<3)>>3];if(!(K>=D(M-L))){break Ad}U=U+L;break Cd}L=A[j>>3];if(K>=D(L)|!(K>=D(L*_-A[b+(e<<3)>>3]))){break Ad}}e=e+1|0;if((i|0)!=(e|0)){continue}break}}e=10387;b=Vk(a,s,1);Dd:{if((b|0)!=1){break Dd}e=10388;b=Zt(a,s,1);if((b|0)!=1){break Dd}e=0;Ed:{if((g|0)<=0){break Ed}while(1){b=Se(a,v[h+(e<<2)>>2],0);if((b|0)==1){e=e+1|0;if((g|0)!=(e|0)){continue}break Ed}break}e=10393;break Dd}e=10397;g=ub-16|0;ub=g;b=v[a+84>>2];A[b>>3]=A[b>>3]+U/_;b=eu(v[a+68>>2],v[v[a>>2]+4>>2],v[a+4>>2],v[a+24>>2],v[a+44>>2],v[a+48>>2],v[a+84>>2],v[a+28>>2],v[a+72>>2],v[a+40>>2],v[a+56>>2]);if((b|0)!=1){Eb(160249,1277);v[g>>2]=b;Fb(276579,g)}ub=g+16|0;if((b|0)==1){break Ad}}Eb(150936,e);v[P+176>>2]=b;Fb(276579,P+176|0);Eb(150936,10620);v[P+160>>2]=b;Fb(276579,P+160|0);break td}na=1;W=v[s+16>>2];g=v[W+248>>2];da=(g|0)==3?3:(g|0)==4?2:1;Fd:{if(!(w[s+84|0]&8)){break Fd}K=A[v[a+4>>2]+1272>>3];b=K<=-A[W>>3];qa=!b;da=qa+da|0;if(K<=A[W+8>>3]){break Fd}qa=b?1:2;da=da+1|0}la=v[W+172>>2];Y=v[W+168>>2];Gd:{Hd:{Id:{Jd:{Kd:{Ld:{if((g|0)<=0){V=-1;S=-1;j=-1;i=1;ba=1;k=0;break Ld}U=A[v[a+4>>2]+1272>>3];Z=2147483647;_=-1;k=0;ba=1;i=1;j=-1;S=-1;V=-1;b=0;while(1){h=k;T=A[la+(b<<3)>>3];K=D(T);_=K>_?K:_;U=K<U?K:U;if(A[ha+152>>3]<_/U){break Kd}e=i;$=v[Y+(b<<2)>>2];g=v[$+376>>2];k=g>>>6|0;i=0;ba=ba?A[v[a+4>>2]+1280>>3]>=D(K+-1):0;if(e){L=A[v[a+4>>2]+1280>>3];i=T-H(T+L)<=L}e=k&3;k=(e|0)!=3;Md:{Nd:{switch(e-1|0){case 2:fa=fa+1|0;S=b;break Md;case 1:ja=ja+1|0;break Md;case 0:break Nd;default:break Md}}ma=ma+1|0;V=b}na=k&na;Od:{Pd:{if(v[$+292>>2]<0){break Pd}L=A[$+136>>3];M=A[$+128>>3];O=od($,0)+nd($,0)|0;if((O|0)>(da|0)){break Pd}if(!(g&128)){if(!(A[v[a+4>>2]+1280>>3]>=D(K+-1))|(i&na)!=1){break Pd}}if($E(a,$)){break Pd}g=v[a+4>>2];N=A[g+1272>>3];Qd:{if(L>=N){break Qd}X=-M;if(X>=N){break Qd}N=A[g+1368>>3];if(N<=L|N<=X){break Kd}N=(L-M)*K}ka=(j|0)==-1;ea=ka|e>>>0>x>>>0;k=0;Rd:{if(ka|(e|0)!=(x|0)){break Rd}ea=(O|0)<(Z|0);if(h|(O|0)!=(Z|0)){break Rd}K=N-Q;L=A[g+1280>>3];ea=K>L;k=!ea&K>=-L}if(!(k|ea)){break Pd}mJ(a,W,$,T,P+256|0,P+1296|0,P+1292|0,P+1288|0,P+1284|0,P+1280|0);if(v[P+1292>>2]|v[P+1288>>2]){break Pd}X=A[$+136>>3];k=v[a+4>>2];K=A[k+1272>>3];M=A[$+128>>3];aa=-M;Sd:{if(T>0){L=K;if(!(aa>=K)){L=A[W+8>>3]-T*M}if(K<=X){M=-K;break Sd}M=A[W>>3]-T*X;break Sd}M=K<=aa?-K:A[W+8>>3]-T*M;if(K<=X){L=K;break Sd}L=A[W>>3]-T*X}g=0;T=A[P+256>>3];X=D(T);K=D(M);ka=K<=1;aa=A[k+1296>>3];Td:{if(aa<(M-T)/(ka?X<=1?1:X:K>=X?K:X)){break Td}ca=A[P+1296>>3];ia=D(ca);X=D(L);ta=X<=1?1:X;if(aa<(ca-L)/(ia<=1?ta:X<=ia?ia:X)){break Td}Ud:{if(v[P+1284>>2]){break Ud}ia=A[W+64>>3];ua=ia>=0?ia:-ia;T=T>=0?T:-T;ia=A[k+1280>>3];if(!(A[k+1360>>3]<=ua/(T>=ia?T:ia))){break Ud}Eo(W,$,P+256|0,1)}Vd:{if(v[P+1280>>2]){T=A[P+256>>3];break Vd}T=A[P+256>>3];ia=A[W+72>>3];ua=ia>=0?ia:-ia;ca=ca>=0?ca:-ca;ia=A[k+1280>>3];if(!(A[k+1360>>3]<=ua/(ca>=ia?ca:ia))){break Vd}ca=D(T);if(aa<(M-T)/(ka?ca<=1?1:ca:K>=ca?K:ca)){break Vd}Eo(W,$,P+1296|0,0)}ca=M-T;M=D(T);if(aa<ca/(ka?M<=1?1:M:K>=M?K:M)){break Td}M=A[P+1296>>3];K=D(M);g=!(aa<(M-L)/(K<=1?ta:K>=X?K:X))}if(g?0:v[ha+144>>2]){break Pd}$=!h;k=1;if(!($|g)){break Od}if(!((O|0)<=(qa|0)|g)|!(g&$|ea)){break Pd}Z=O;j=b;h=g;Q=N;x=e}k=h}b=b+1|0;g=v[W+248>>2];if((b|0)<(g|0)){continue}break}}Wd:{da=i&na;if((da|0)!=1){break Wd}K=A[W+8>>3];L=K;K=A[v[a+4>>2]+1296>>3];if(L-H(L+K)<=K){break Wd}v[R+596>>2]=1;b=1;break td}Xd:{if((g|0)<=0){break Xd}b=0;Z=0;h=0;e=0;while(1){Yd:{if((e|0)==(j|0)){break Yd}Zd:{K=A[v[W+172>>2]+(e<<3)>>3];O=v[a+4>>2];L=A[O+1280>>3];_d:{if(K>L){K=A[O+1272>>3];$=v[v[W+168>>2]+(e<<2)>>2];if(K<=A[$+136>>3]){Z=Z+1|0;if(!(K<=-A[$+128>>3])){break Yd}break Zd}if(K<=-A[$+128>>3]){break _d}break Yd}if(!(K<-L)){break Yd}K=A[O+1272>>3];$=v[v[W+168>>2]+(e<<2)>>2];if(K<=-A[$+128>>3]){Z=Z+1|0;if(K<=A[$+136>>3]){break Zd}break Yd}if(!(K<=A[$+136>>3])){break Yd}}h=h+1|0;break Yd}b=1;h=h+1|0}e=e+1|0;if((g|0)!=(e|0)){continue}break}if(b){if((Z|0)>1){break Kd}if((h|0)<=1){break Xd}break Kd}if((Z|0)<=0){break Xd}if((h|0)>0){break Kd}}if(!(!(da&!ja)&(x&-2)!=2|(j|0)<0)){e=1;$d:{ae:{be:{b=v[Y+(j<<2)>>2];switch(v[b+376>>2]>>>6&3){case 0:break Hd;case 3:break be;default:break ae}}U=A[b+128>>3];break $d}U=A[b+128>>3];if(!(U>=0)){break $d}if(A[b+136>>3]<=1){break Hd}}X=A[W+8>>3];L=A[la+(j<<3)>>3];M=X-L*U;N=A[b+136>>3];T=-L;Q=-U;K=A[v[a+4>>2]+1272>>3];ce:{if(L>0){M=K<=Q?K:M;if(K<=N){Q=-K;break ce}Q=T*N+A[W>>3];break ce}Q=K<=Q?-K:M;if(K<=N){M=K;break ce}M=T*N+A[W>>3]}e=Li(a,s,Q);if((e|0)!=1){Eb(150936,10084);v[P+96>>2]=e;Fb(276579,P+96|0);break Hd}e=Ki(a,s,M);if((e|0)!=1){Eb(150936,10085);v[P+80>>2]=e;Fb(276579,P+80|0);break Hd}e=Ej(a,s,j);if((e|0)!=1){Eb(150936,10086);v[P+64>>2]=e;Fb(276579,P- -64|0);break Hd}g=Ib(v[v[a>>2]+8>>2],v[W+248>>2],8,150902,10089);v[P+256>>2]=g;if(g){K=X/L;h=v[W+248>>2];de:{if((h|0)<=0){break de}i=v[W+172>>2];e=0;if((h|0)!=1){x=h&2147483646;ba=0;while(1){j=e<<3;A[j+g>>3]=-A[i+j>>3]/L;j=j|8;A[j+g>>3]=-A[i+j>>3]/L;e=e+2|0;ba=ba+2|0;if((x|0)!=(ba|0)){continue}break}}if(!(h&1)){break de}e=e<<3;A[e+g>>3]=-A[e+i>>3]/L}e=Hz(a,b,h,Y,g,K,P+1308|0,P+1296|0);if((e|0)!=1){Eb(150936,10104);v[P+48>>2]=e;Fb(276579,P+48|0);break Hd}Hb(v[v[a>>2]+8>>2],P+256|0,150902,10108);if(v[P+1308>>2]){e=1;v[R+596>>2]=1;break Hd}v[r>>2]=v[r>>2]+1;if(!k){break Kd}e=pc(a,s);if((e|0)!=1){Eb(150936,10124);v[P+32>>2]=e;Fb(276579,P+32|0);break Hd}if(w[W+258|0]&2){break Kd}v[y>>2]=v[y>>2]+1;b=1;break td}Eb(150936,10089);e=-1;v[P+16>>2]=-1;Fb(276579,P+16|0);break Hd}if((fa|0)==1){if(!i){break Kd}K=A[W+8>>3];L=K;e=v[a+4>>2];K=A[e+1296>>3];if(!(L-H(L+K)<=K)){break Kd}b=v[Y+(S<<2)>>2];K=A[e+1280>>3];e=la+(S<<3)|0;ee:{if(K>=D(D(A[e>>3])+-1)){g=10146;e=Ef(a,b,2,P+1308|0);if((e|0)!=1){break Jd}if(!v[P+1308>>2]){break ee}v[R+596>>2]=1;b=1;break td}if(v[v[a+4>>2]+1444>>2]){break ee}K=A[e>>3];v[P+128>>2]=v[b+208>>2];e=P+256|0;Jb(e,1024,89406,P+128|0);i=10171;h=P+1296|0;g=e;L=A[v[a+4>>2]+1272>>3];e=v[b+376>>2];g=Wd(a,h,g,-L,L,0,2,e&1,e>>>1&1);if((g|0)!=1){break Id}i=10174;g=id(a,v[P+1296>>2]);if((g|0)!=1){break Id}i=10190;g=Le(a,b,v[P+1296>>2],D(K),-1,0,P+1308|0,P+1292|0,P+1288|0);if((g|0)!=1){break Id}if(v[P+1308>>2]){e=1;v[R+596>>2]=1;i=10199;g=Dc(a,h);if((g|0)==1){break Hd}break Id}e=1;i=10205;g=Dc(a,P+1296|0);if((g|0)!=1){break Id}if(!v[P+1288>>2]){break Hd}v[r>>2]=v[r>>2]+1}v[W+256>>2]=v[W+256>>2]&-2064;b=1;break td}if(!i|(fa|ja|(ma|0)!=1|ba)){break Kd}b=v[a+4>>2];if(!(A[b+1280>>3]>=D(D(A[la+(V<<3)>>3])+-1))){break Kd}K=A[W+8>>3];L=K;K=A[b+1296>>3];if(!(L-H(L+K)<=K)){break Kd}g=10240;e=Ef(a,v[Y+(V<<2)>>2],2,P+1308|0);if((e|0)!=1){break Jd}if(!v[P+1308>>2]){break Kd}v[R+596>>2]=1}b=1;break td}Eb(150936,g);v[P+144>>2]=e;Fb(276579,P+144|0);break Gd}Eb(150936,i);v[P+112>>2]=g;Fb(276579,P+112|0);e=g}b=1;if((e|0)==1){break td}}Eb(150936,10623);v[P>>2]=e;Fb(276579,P);b=e}ub=P+1312|0;g=b;e=16615;if((b|0)!=1){break e}if(v[R+596>>2]){break Mb}}fe:{b=v[s+84>>2];if(!v[ha+96>>2]|!(b&4194304)&(b&8404992)!=16384){break fe}b=v[a+4>>2];if(v[b+1580>>2]){b=0}else{b=v[b+1216>>2]!=0}if(!b){break fe}k=0;e=0;i=ub-128|0;ub=i;x=1;ge:{if(!(w[s+84|0]&8)){break ge}j=v[s+16>>2];S=v[j+248>>2];if((S|0)<=0){break ge}g=-1;b=(S|0)>2;ia=A[v[a+4>>2]+1272>>3];fa=ia<=-A[j>>3];W=A[j+8>>3]>=ia;P=(b?(S|0)==3?3:(S|0)==4?2:1:2147483647)+(b&((fa^-1)&!W))|0;ta=-1;while(1){b=k<<3;K=D(A[b+v[j+172>>2]>>3]);ta=K>ta?K:ta;ia=K<ia?K:ia;if(A[ha+160>>3]<ta/ia){break ge}Z=1;he:{ie:{O=v[v[j+168>>2]+(k<<2)>>2];ba=v[O+376>>2]>>>6&3;if(ba>>>0<2&(g|0)>=0){break ie}je:{ke:{switch(ba|0){default:if(!(A[O+128>>3]>=0)|(S|0)<3){break je}if(A[O+136>>3]<=1){break ie}break je;case 3:break je;case 0:break ke}}if((S|0)>2){break ie}}if($E(a,O)){break ie}N=A[b+v[j+172>>2]>>3];X=A[O+136>>3];_=A[O+128>>3];K=A[O>>3];b=0;le:{if(fa){break le}me:{if(!(N>0)|K<-A[v[a+4>>2]+1280>>3]){break me}if((od(O,0)|0)!=1){break me}b=1;if((nd(O,0)|0)<=(P|0)){break le}}b=0;if(!(N<0)){break le}b=0;if(K>A[v[a+4>>2]+1280>>3]){break le}b=0;if((nd(O,0)|0)!=1){break le}b=(od(O,0)|0)<=(P|0)}S=0;ne:{oe:{if(W){break oe}pe:{if(!(N>0)|K>A[v[a+4>>2]+1280>>3]){break pe}if((nd(O,0)|0)!=1){break pe}S=1;if((od(O,0)|0)<=(P|0)){break ne}}S=0;if(!(N<0)){break oe}S=0;if(K<-A[v[a+4>>2]+1280>>3]){break oe}S=0;if((od(O,0)|0)!=1){break oe}S=(nd(O,0)|0)<=(P|0)}if((b|S)!=1){break ie}}mJ(a,j,O,N,i+120|0,i+112|0,i+92|0,i+88|0,i+84|0,i+80|0);qe:{re:{se:{if(!b){break se}T=A[j>>3];V=v[a+4>>2];U=A[V+1272>>3];Q=A[i+112>>3];L=A[i+120>>3];te:{if(N>0){K=-Q;if(!((Q>=0?Q:K)>=U)){K=(T-Q)/N}A[i+104>>3]=K;M=-L;if((L>=0?L:M)>=U){break te}M=(T-L)/N;break te}K=L;if(!((K>=0?K:-K)>=U)){K=(T-K)/N}A[i+104>>3]=K;if((Q>=0?Q:-Q)>=U){M=Q;break te}M=(T-Q)/N}A[i+96>>3]=M;if(-K>=U){break se}ua=A[V+1296>>3];za=-ua;ca=K-_;aa=D(_);Aa=aa<=1?1:aa;K=D(K);if(za>ca/(K<=1?Aa:K>=aa?K:aa)|M>=U){break se}ca=D(X);xa=ca<=1?1:ca;K=D(M);if(ua<(M-X)/(K<=1?xa:K>=ca?K:ca)){break se}Z=0;ue:{if(v[i+84>>2]){K=L;break ue}K=A[j+64>>3];Da=K>=0?K:-K;K=L>=0?L:-L;M=A[V+1280>>3];if(!(A[V+1360>>3]<=Da/(K>=M?K:M))){K=L;break ue}Eo(j,O,i+120|0,1);v[i+84>>2]=1;K=A[i+120>>3];Z=!(M>=D(L-K))}ve:{if(v[i+80>>2]){L=Q;break ve}L=A[j+72>>3];Da=L>=0?L:-L;L=Q>=0?Q:-Q;M=A[V+1280>>3];if(!(A[V+1360>>3]<=Da/(L>=M?L:M))){L=Q;break ve}Eo(j,O,i+112|0,0);L=A[i+112>>3];v[i+80>>2]=1;Z=!(M>=D(Q-L))|Z}if(Z){CV(a,T,N,K,L,i+104|0,i+96|0);Q=A[i+104>>3];M=D(Q);if(za>(Q-_)/(M<=1?Aa:M>=aa?M:aa)){break se}Q=A[i+96>>3];M=D(Q);if(ua<(Q-X)/(M<=1?xa:M>=ca?M:ca)){break se}}b=1;Z=0;h=k;if(ba>>>0>1){break he}M=T/N;Q=M;M=A[V+1280>>3];if(!(Q-H(Q+M)<=M)){break se}h=BV(a,j,k,N);if(!h&S){break re}Z=1;b=h?1:e;h=h?k:g;break he}Z=1;if(!S){break qe}V=v[a+4>>2];U=A[V+1272>>3];L=A[i+112>>3];K=A[i+120>>3]}Q=A[j+8>>3];we:{if(N>0){T=-L;if(!((L>=0?L:T)>=U)){T=(Q-L)/N}A[i+104>>3]=T;M=-K;if((K>=0?K:M)>=U){break we}M=(Q-K)/N;break we}T=(K>=0?K:-K)>=U?K:(Q-K)/N;A[i+104>>3]=T;if((L>=0?L:-L)>=U){M=L;break we}M=(Q-L)/N}A[i+96>>3]=M;Z=1;if(-T>=U){break qe}ca=T-_;aa=D(_);ua=aa<=1?1:aa;T=D(T);ca=ca/(T<=1?ua:T>=aa?T:aa);T=A[V+1296>>3];Aa=-T;if(ca<Aa|M>=U){break qe}ca=M-X;U=D(X);za=U<=1?1:U;M=D(M);if(T<ca/(M<=1?za:M>=U?M:U)){break qe}b=0;xe:{if(v[i+84>>2]){M=K;break xe}M=A[j+64>>3];xa=M>=0?M:-M;M=K>=0?K:-K;ca=A[V+1280>>3];if(!(A[V+1360>>3]<=xa/(M>=ca?M:ca))){M=K;break xe}Eo(j,O,i+120|0,1);M=A[i+120>>3];b=!(ca>=D(K-M))}ye:{if(v[i+80>>2]){K=L;break ye}K=A[j+72>>3];xa=K>=0?K:-K;K=L>=0?L:-L;ca=A[V+1280>>3];if(!(A[V+1360>>3]<=xa/(K>=ca?K:ca))){K=L;break ye}Eo(j,O,i+112|0,0);K=A[i+112>>3];b=!(ca>=D(L-K))|b}if(b){CV(a,Q,N,M,K,i+104|0,i+96|0);L=A[i+104>>3];K=D(L);if(Aa>(L-_)/(K<=1?ua:K>=aa?K:aa)){break qe}L=A[i+96>>3];K=D(L);if(T<(L-X)/(K<=1?za:K>=U?K:U)){break qe}}if(ba>>>0<=1){K=Q/N;L=K;K=A[V+1280>>3];if(!(L-H(L+K)<=K)){break qe}b=e;h=g;if(!BV(a,j,k,N)){break he}}Z=ba>>>0<2;b=0;h=k;break he}b=e;h=g;break he}b=e;h=g}if(Z){e=b;g=h;k=k+1|0;S=v[j+248>>2];if((k|0)<(S|0)){continue}}break}ze:{if((h|0)<0){break ze}L=A[v[j+172>>2]+(h<<3)>>3];P=v[v[j+168>>2]+(h<<2)>>2];x=-1;e=Ib(v[v[a>>2]+8>>2],v[j+248>>2]-1|0,4,150902,11023);v[i+120>>2]=e;if(!e){Eb(150936,11023);v[i>>2]=-1;Fb(276579,i);break ge}S=Ib(v[v[a>>2]+8>>2],v[j+248>>2]-1|0,8,150902,11024);v[i+112>>2]=S;if(!S){Eb(150936,11024);v[i+16>>2]=-1;Fb(276579,i+16|0);break ge}M=A[v[a+4>>2]+1280>>3];e=0;fa=v[j+248>>2];Ae:{if((fa|0)<=0){g=0;x=0;h=0;break Ae}x=0;V=0;k=0;g=0;while(1){if((h|0)!=(k|0)){ba=k<<2;v[v[i+120>>2]+(g<<2)>>2]=v[ba+v[j+168>>2]>>2];S=v[i+112>>2];W=S+(g<<3)|0;O=v[j+172>>2];K=-A[O+(k<<3)>>3]/A[O+(h<<3)>>3];A[W>>3]=K;Be:{Ce:{if(!(M>D(K))){O=v[a+4>>2];if(Z){K=H(K+.5+A[O+1280>>3]);A[W>>3]=K}Q=A[O+1280>>3];De:{if(Q<K){K=A[O+1272>>3];ba=v[ba+v[j+168>>2]>>2];if(K<=A[ba+136>>3]){x=x+1|0;if(!(K<=-A[ba+128>>3])){break Be}break Ce}if(K<=-A[ba+128>>3]){break De}break Be}if(!(-Q>K)){break Be}K=A[O+1272>>3];ba=v[ba+v[j+168>>2]>>2];if(K<=-A[ba+128>>3]){x=x+1|0;if(K<=A[ba+136>>3]){break Ce}break Be}if(!(K<=A[ba+136>>3])){break Be}}e=e+1|0;break Be}Hb(v[v[a>>2]+8>>2],i+112|0,150902,11053);Hb(v[v[a>>2]+8>>2],i+120|0,150902,11054);break ze}V=1;e=e+1|0}g=g+1|0}k=k+1|0;if((fa|0)!=(k|0)){continue}break}h=(V|0)!=0}K=A[j+(!b<<3)>>3]/L;K=Z?H(K+.5+A[v[a+4>>2]+1280>>3]):K;v[i+104>>2]=0;v[i+96>>2]=0;Ee:{Fe:{if(h&(x|0)==1&(e|0)==1){break Fe}if(h){break Ee}if(!x){break Fe}if(e){break Ee}}x=Hz(a,P,g,v[i+120>>2],S,K,i+104|0,i+96|0);if((x|0)!=1){Eb(150936,11121);v[i+64>>2]=x;Fb(276579,i- -64|0);break ge}if(v[i+104>>2]|!v[i+96>>2]|((v[P+376>>2]&192)!=64|(g|0)<=0)){break Ee}k=0;while(1){Ge:{b=v[v[i+120>>2]+(k<<2)>>2];if((v[b+376>>2]&192)!=128){break Ge}x=Ef(a,b,1,i+92|0);if((x|0)==1){break Ge}Eb(150936,11137);v[i+48>>2]=x;Fb(276579,i+48|0);break ge}k=k+1|0;if((k|0)!=(g|0)){continue}break}}Hb(v[v[a>>2]+8>>2],i+112|0,150902,11150);Hb(v[v[a>>2]+8>>2],i+120|0,150902,11151);if(v[i+104>>2]){x=1;v[R+596>>2]=1;break ge}if(!v[i+96>>2]){break ze}x=pc(a,s);if((x|0)!=1){Eb(150936,11164);v[i+32>>2]=x;Fb(276579,i+32|0);break ge}if(!(w[j+258|0]&2)){v[y>>2]=v[y>>2]+1}v[r>>2]=v[r>>2]+1}x=1}ub=i+128|0;g=x;if((g|0)==1){break fe}e=16621;break e}if(v[R+596>>2]){break Mb}b=v[s+84>>2];if(!(b&4194304)&(b&8404992)!=16384){break Mb}M=0;i=ub-16|0;ub=i;e=1;g=v[s+16>>2];He:{if(A[v[a+4>>2]+1280>>3]>=D(A[g>>3]-A[g+8>>3])){break He}b=v[g+248>>2];if(!b|(Bi(a)|0)!=(b|0)|!(v[s+84>>2]&3)){break He}h=v[a+4>>2];j=v[g+248>>2];Ie:{if((j|0)<=0){K=1;break Ie}L=A[h+1280>>3];K=L;S=v[g+168>>2];b=v[S>>2];x=v[b+376>>2]&1792;if((x|0)==1536){b=v[b+236>>2]}M=K;K=A[b>>3];if(M>=D(K)){break He}k=v[g+172>>2];Q=A[k>>3];b=(x|0)==1536;M=b?Q+0:0;K=Q/(b?-K:K);b=1;if((j|0)==1){break Ie}while(1){x=v[S+(b<<2)>>2];Je:{if((v[x+376>>2]&1792)==1536){Q=A[v[x+236>>2]>>3];if(L>=D(Q)){break He}N=-Q*K;Q=A[k+(b<<3)>>3];if(!(L>=D(N-Q))){break He}M=M+Q;break Je}Q=A[x>>3];if(L>=D(Q)|!(L>=D(Q*K-A[k+(b<<3)>>3]))){break He}}b=b+1|0;if((j|0)!=(b|0)){continue}break}}L=A[h+1272>>3];Q=A[g+8>>3];N=-A[g>>3];Ke:{if(K>0){if(!(!v[ha+116>>2]|L<=Q)){h=10514;b=AV(a,s,(Q-M)/K);if((b|0)!=1){break Ke}}b=v[ha+120>>2];if(!(!b|L<=N)){h=10526;b=wF(a,(A[g>>3]-M)/K);if((b|0)!=1){break Ke}b=v[ha+120>>2]}Le:{if(v[ha+116>>2]){if(L<=N|b){break Le}break He}if(!b|!(L<=Q)){break He}}h=10533;b=lp(a,s,0);if((b|0)!=1){break Ke}h=10534;b=os(a,s,0);if((b|0)!=1){break Ke}break He}if(!(!v[ha+120>>2]|L<=Q)){h=10548;b=wF(a,(Q-M)/K);if((b|0)!=1){break Ke}}e=v[ha+116>>2];if(!(!e|L<=N)){h=10560;b=AV(a,s,(A[g>>3]-M)/K);if((b|0)!=1){break Ke}e=v[ha+116>>2]}b=v[ha+120>>2];Me:{if(e){if(b){break Me}e=1;if(L<=Q){break Me}break He}e=1;if(!b|!(L<=N)){break He}}e=1;h=10567;b=lp(a,s,0);if((b|0)!=1){break Ke}h=10568;b=os(a,s,0);if((b|0)==1){break He}}Eb(150936,h);v[i>>2]=b;Fb(276579,i);e=b}ub=i+16|0;g=e;if((g|0)==1){break Mb}e=16627;break e}m=(m|0)==2147483647?w[ga+257|0]&64?l:2147483647:m;if((ra|0)!=2147483647){break Kb}ra=t[ga+258|0]&1?2147483647:l}if(v[R+596>>2]){break c}b=v[s+84>>2];Ne:{if(!(b&4194304)){if((b&8405e3)!=16392){break c}break Ne}if(!(b&8)){break c}}if(!(v[ha+100>>2]|v[ha+104>>2])){break c}b=v[a+4>>2];if(v[b+1580>>2]){b=0}else{b=v[b+1216>>2]!=0}if(!b){break c}g=v[ha+100>>2];j=v[ha+104>>2];S=R+596|0;M=0;e=0;k=ub-128|0;ub=k;K=A[v[a+4>>2]+1272>>3];b=v[s+16>>2];Q=A[b+8>>3];Oe:{if(!(K<=Q)){x=1;if(!(-A[b>>3]>=K)){break Oe}}Pe:{if(j){$q(a,b,0,k+104|0,k+96|0,k+92|0,k+88|0,k+84|0,k+80|0);Q=A[b+8>>3];K=A[v[a+4>>2]+1272>>3];break Pe}v[k+96>>2]=-1568170194;v[k+100>>2]=1417495214;v[k+104>>2]=-1568170194;v[k+108>>2]=1417495214;v[k+84>>2]=0;v[k+80>>2]=0}_=1;if(K<=Q){K=A[b>>3];A[k+96>>3]=-A[k+104>>3];v[k+80>>2]=v[k+84>>2];_=-1;Q=-K}V=v[b+172>>2];P=v[b+168>>2];O=v[b+248>>2];Qe:{Re:{Se:{Te:{Ue:{Ve:{if(!g){break Ve}b=0;We:{if((O|0)<=0){break We}while(1){g=v[P+(b<<2)>>2];if((nd(g,0)+od(g,0)|0)==1&(v[g+376>>2]&192)==192){break We}b=b+1|0;if((O|0)!=(b|0)){continue}break}break Ve}if((b|0)>=(O|0)){break Ve}g=Ib(v[v[a>>2]+8>>2],O,4,150902,14197);v[k+120>>2]=g;if(!g){Eb(150936,14197);x=-1;v[k+16>>2]=-1;Fb(276579,k+16|0);break Oe}h=Ib(v[v[a>>2]+8>>2],O,8,150902,14198);v[k+124>>2]=h;if(!h){Eb(150936,14198);x=-1;v[k+32>>2]=-1;Fb(276579,k+32|0);break Oe}i=Ib(v[v[a>>2]+8>>2],O,4,150902,14199);v[k+116>>2]=i;if(!i){break Ue}Xe:{if((O|0)<=0){break Xe}L=0;x=0;while(1){Z=x<<2;b=v[Z+P>>2];T=A[b>>3];N=A[b+136>>3];U=A[b+128>>3];K=_*A[V+(x<<3)>>3];Ye:{if(!((nd(b,0)+od(b,0)|0)!=1|(v[b+376>>2]&192)!=192)){b=v[a+4>>2];X=A[b+1280>>3];if(!(!(T<-X)|!(K>0))){if(A[b+1272>>3]<=-U){break Xe}v[i+Z>>2]=0;A[h+(e<<3)>>3]=T/K;v[g+(e<<2)>>2]=x;e=e+1|0;K=K*U;L=K+L;M=K+M;break Ye}if(!(!(T>X)|!(K<0))){if(N>=A[b+1272>>3]){break Xe}v[i+Z>>2]=1;A[h+(e<<3)>>3]=T/K;v[g+(e<<2)>>2]=x;e=e+1|0;K=K*N;L=K+L;M=K+M;break Ye}if(K>0){if(A[b+1272>>3]<=-U){break Xe}K=K*U;L=K+L;M=K+M;break Ye}if(N>=A[b+1272>>3]){break Xe}K=K*N;L=K+L;M=K+M;break Ye}T=A[v[a+4>>2]+1272>>3];if(T<=-U|N>=T){break Xe}if(K>0){L=K*U+L;M=K*N+M;break Ye}L=K*N+L;M=K*U+M}x=x+1|0;if((O|0)!=(x|0)){continue}break}if((e|0)<=0){break Xe}K=A[v[a+4>>2]+1280>>3];if(!(K<Q-M|K>=Q-L)){break Xe}uj(v[k+124>>2],v[k+120>>2],e);b=0;while(1){h=v[a+4>>2];K=A[h+1272>>3];i=v[v[k+120>>2]+(b<<2)>>2];x=i<<2;g=v[x+P>>2];N=A[g+128>>3];if(K<=-N){break Xe}U=A[g+136>>3];if(U>=K){break Xe}K=D(_*A[V+(i<<3)>>3]);Ze:{_e:{$e:{af:{bf:{cf:{if(!v[x+v[k+116>>2]>>2]){T=A[h+1280>>3];K=K*(U-N);if(!(T>=K-(Q-M))){break bf}x=Qc(a,g,U,S,k+76|0);if((x|0)==1){break cf}b=14366;break Qe}T=A[h+1280>>3];K=K*-(N-U);if(!(T>=K-(Q-M))){break af}x=Qc(a,g,N,S,k+76|0);if((x|0)==1){break cf}b=14361;break Qe}if(v[S>>2]){break Xe}if(v[k+76>>2]){break _e}break Ze}if(!(T>=Q-L)){break Ze}x=Qc(a,g,N,S,k+76|0);if((x|0)==1){break $e}b=14391;break Qe}if(!(T>=Q-L)){break Ze}x=Qc(a,g,U,S,k+76|0);if((x|0)==1){break $e}b=14386;break Qe}if(v[S>>2]){break Xe}if(!v[k+76>>2]){break Ze}}v[q>>2]=v[q>>2]+1}L=L+K;M=M+K;b=b+1|0;if((e|0)!=(b|0)){continue}break}}Hb(v[v[a>>2]+8>>2],k+116|0,150902,14414);Hb(v[v[a>>2]+8>>2],k+124|0,150902,14415);Hb(v[v[a>>2]+8>>2],k+120|0,150902,14416)}x=1;if(v[k+80>>2]|!j|(O|0)<=0){break Oe}i=1;e=0;h=-1;M=-A[v[a+4>>2]+1272>>3];K=M;b=0;while(1){x=v[P+(b<<2)>>2];N=_*A[V+(b<<3)>>3];L=A[x>>3]/N;if(!(L<-A[v[a+4>>2]+1280>>3])){break Se}df:{if(N>0){g=od(x,0);j=nd(x,0);break df}g=nd(x,0);j=od(x,0)}ef:{ff:{gf:{if(K<L){break gf}if(g|K!=L){break ff}if((i|0)>0){break gf}if((v[v[P+(h<<2)>>2]+376>>2]&192)==192|(v[x+376>>2]&192)!=192){break ff}}if((h|0)!=-1){x=1;M=K;if((e|0)>1){break Oe}}x=1;if((g|0)<=0){K=L;h=b;e=j;i=g;break ef}K=L;h=b;i=g;e=j;if((e|0)<=1){break ef}break Oe}x=1;if((j|0)>1){break Oe}if(!(L>M)){break ef}M=L}b=b+1|0;if((O|0)!=(b|0)){continue}break}if((h|0)==-1){break Se}if(i){break Oe}v[k+76>>2]=0;b=v[P+(h<<2)>>2];g=v[b+376>>2]&192;N=A[b+136>>3];U=A[b+128>>3];T=A[b>>3];e=v[a+4>>2];L=A[k+96>>3];hf:{K=_*A[V+(h<<3)>>3];if(K<0){jf:{if((g|0)==192){L=(L-Q)/-K;Q=A[e+1280>>3];break jf}aa=L-Q;L=aa/-K;Q=A[e+1280>>3];X=H(L+Q);if(L-X<=Q){break jf}if(!((X*K+aa)*M+T<=Q)){break Te}L=I(L-Q)}if(!(L-(N-U)<=Q)){break Te}K=U+L;if(!(D(K-N)<=Q)){break hf}g=14583;x=Qc(a,b,K,S,k+76|0);if((x|0)==1){break Te}break Re}kf:{if((g|0)==192){L=(L-Q)/K;Q=A[e+1280>>3];break kf}aa=L-Q;L=aa/K;Q=A[e+1280>>3];X=H(L+Q);if(L-X<=Q){break kf}if(!(-(aa-X*K)*M-T<=Q)){break Te}L=I(L-Q)}if(!(L-(N-U)<=Q)){break Te}K=N-L;if(D(K-U)<=Q){g=14620;x=Qc(a,b,K,S,k+76|0);if((x|0)==1){break Te}break Re}g=14625;x=df(a,b,K,0,S,k+76|0);if((x|0)!=1){break Re}break Te}g=14588;x=gf(a,b,K,0,S,k+76|0);if((x|0)==1){break Te}break Re}Eb(150936,14199);x=-1;v[k+48>>2]=-1;Fb(276579,k+48|0);break Oe}x=1;if(v[S>>2]){break Oe}if(!v[k+76>>2]){break Se}b=A[v[a+4>>2]+1280>>3]>=D(A[b+128>>3]-A[b+136>>3])?q:u;v[b>>2]=v[b>>2]+1;if((O|0)<=0){break Se}b=0;while(1){lf:{if((b|0)==(h|0)){break lf}e=v[P+(b<<2)>>2];mf:{if(_*A[V+(b<<3)>>3]<0){x=Qc(a,e,A[e+128>>3],S,k+76|0);if((x|0)==1){break mf}g=14660;break Re}x=Qc(a,e,A[e+136>>3],S,k+76|0);if((x|0)==1){break mf}g=14667;break Re}if(v[S>>2]){x=1;break Oe}if(!v[k+76>>2]){break lf}v[q>>2]=v[q>>2]+1}b=b+1|0;if((O|0)!=(b|0)){continue}break}}x=1;break Oe}Eb(150936,g);v[k>>2]=x;Fb(276579,k);break Oe}Eb(150936,b);v[k+64>>2]=x;Fb(276579,k- -64|0)}ub=k+128|0;g=x;e=16644;if((g|0)!=1){break e}if(v[ga+248>>2]){break c}L=A[ga>>3];K=A[ga+8>>3];Q=L-K;M=1;K=D(K);L=D(L);nf:{if(L<=1){if(K<=1){break nf}M=K;break nf}M=K<=L?L:K}if(A[v[a+4>>2]+1296>>3]<Q/M){v[R+596>>2]=1;break b}g=pc(a,s);e=16659;if((g|0)!=1){break e}if(w[ga+258|0]&2){break b}v[y>>2]=v[y>>2]+1;break b}Eb(150936,b);v[R+544>>2]=g;Fb(276579,R+544|0);e=16559;break e}Eb(150936,e);v[R+560>>2]=g;Fb(276579,R+560|0);e=16550;break e}Eb(150936,b);v[R+576>>2]=g;Fb(276579,R+576|0);e=16545}Eb(150936,e);v[R+528>>2]=g;Fb(276579,R+528|0);break a}v[R+596>>2]=1}l=l+1|0;if((l|0)>=(d|0)){break b}if(!v[R+596>>2]){continue}break}}of:{pf:{qf:{Ja=f&16;rf:{if(!(v[ha+80>>2]|v[ha+76>>2])|(v[R+596>>2]|!Ja)){break rf}if(rc(v[a+4>>2],v[a+24>>2],0)){break rf}if(!(!v[ha+80>>2]|(d|0)<=(m|0))){g=Bf(R+648|0,v[v[a>>2]+4>>2],d,394,395,396,a);if((g|0)!=1){Eb(150936,13316);v[R+512>>2]=g;Fb(276579,R+512|0);break of}i=Ib(v[v[a>>2]+8>>2],d,4,150902,13318);v[R+640>>2]=i;sf:{tf:{if(i){l=0;if((d|0)<=0){break sf}while(1){f=v[(l<<2)+c>>2];v[R+668>>2]=f;b=v[f+84>>2];uf:{if(b&256|v[f+88>>2]&2147483640|!((b&4194304)>>>22|(b&8404992)==16384)){break uf}if(!((l>>>0)%1e3|0)){if(rc(v[a+4>>2],v[a+24>>2],0)){break sf}}vf:{wf:{g=Mi(a,v[f+16>>2]);if((g|0)!=1){a=13342}else{k=v[f+32>>2]+(v[v[f+16>>2]+256>>2]<<14&-2147483648)|0;e=0;j=v[R+648>>2];xf:{yf:{while(1){b=sc(j,f);if(!b){break yf}g=i+(e<<2)|0;h=v[b+32>>2]+(v[v[b+16>>2]+256>>2]<<14&-2147483648)|0;if(h>>>0<k>>>0){v[g>>2]=f;k=h;g=R+668|0}v[g>>2]=b;e=e+1|0;f=v[R+668>>2];if((b|0)==(f|0)){f=b;break vf}g=si(j,b);if((g|0)==1){continue}break}a=13269;break xf}g=ee(j,f);if((g|0)==1){break wf}a=13278}Eb(150936,a);v[R+496>>2]=g;Fb(276579,R+496|0);a=13350}Eb(150936,a);v[R+480>>2]=g;Fb(276579,R+480|0);break of}if(!e){break uf}}j=v[f+16>>2];L=A[j+8>>3];M=A[j>>3];b=0;while(1){k=v[i+(b<<2)>>2];zf:{if(v[k+88>>2]&2147483640){break zf}K=A[v[a+4>>2]+1272>>3];h=v[k+16>>2];Q=A[v[j+172>>2]>>3]/A[v[h+172>>2]>>3];Af:{if(Q>0){N=A[h>>3];U=Q*N;M=K<=-N?M:M<=U?U:M;N=K;K=A[h+8>>3];if(N<=K){break Af}K=Q*K;L=K<=L?K:L;break Af}N=A[h+8>>3];U=Q*N;M=K<=N?M:M<=U?U:M;N=A[h>>3];if(K<=-N){break Af}K=Q*N;L=K<=L?K:L}g=bf(a,f,k);if((g|0)!=1){b=13439;break pf}g=pc(a,k);if((g|0)!=1){b=13443;break pf}if(w[h+258|0]&2){break zf}v[y>>2]=v[y>>2]+1}b=b+1|0;if((e|0)!=(b|0)){continue}break}K=D(M);Q=D(L);if(-A[v[a+4>>2]+1296>>3]>(L-M)/(Q<=1?K<=1?1:K:K<=Q?Q:K)){break tf}K=(L+M)*.5;b=L<M;g=Li(a,f,b?K:M);if((g|0)!=1){b=13463;break pf}g=Ki(a,f,b?K:L);if((g|0)!=1){b=13464;break pf}if(!(w[j+257|0]&64)){break uf}b=v[f+32>>2];m=(b|0)<(m|0)?b:m}l=l+1|0;if((l|0)!=(d|0)){continue}break}break sf}Eb(150936,13318);g=-1;v[R+448>>2]=-1;Fb(276579,R+448|0);break of}v[R+596>>2]=1}Hb(v[v[a>>2]+8>>2],R+640|0,150902,13478);cf(R+648|0)}if(!v[ha+76>>2]|(d|0)<=(m|0)){break rf}o=v[E>>2];n=v[G>>2];p=v[y>>2];e=16697;b=Ib(v[v[a>>2]+8>>2],d,4,150902,16697);v[R+636>>2]=b;if(!b){g=-1;break qf}s=0;V=-1;if((d|0)>0){b=0;while(1){e=s;g=v[(b<<2)+c>>2];f=v[g+84>>2];Bf:{Cf:{if(!(f&4194304)){if((f&8405248)==16384){break Cf}break Bf}if(f&256){break Bf}}v[v[R+636>>2]+(e<<2)>>2]=g;s=e+1|0}V=(b|0)==(m|0)?e:V;b=b+1|0;if((d|0)!=(b|0)){continue}break}}Df:{if(v[R+596>>2]|(s|0)<=(V|0)){break Df}x=V;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break Df}Ef:{Ff:{Ea=v[R+636>>2];b=x<<2;ga=Ea+b|0;la=v[ga>>2];if(!la){break Ff}Ma=v[v[v[b+c>>2]+16>>2]+256>>2];U=A[ha+8>>3];Y=v[la+16>>2];M=A[Y+8>>3];Q=A[Y>>3];N=A[v[a+4>>2]+1280>>3];g=Mi(a,Y);Gf:{if((g|0)!=1){Eb(150936,13538);v[R+416>>2]=g;Fb(276579,R+416|0);break Gf}b=v[Y+256>>2];Hf:{if(b&8192){O=v[Y+152>>2];P=v[Y+156>>2];W=v[Y+144>>2];sa=v[Y+148>>2];break Hf}O=0;P=0;v[Y+144>>2]=0;v[Y+148>>2]=0;v[Y+256>>2]=b|8192;v[Y+152>>2]=0;v[Y+156>>2]=0;W=0;sa=0;h=v[Y+248>>2];if((h|0)<=0){break Hf}i=v[Y+172>>2];j=v[Y+168>>2];b=0;while(1){g=v[j+(b<<2)>>2];e=B(v[g+288>>2],-1640531527)>>>26|0;f=e&31;if((e&63)>>>0>=32){e=0;f=-2147483648>>>f|0}else{e=-2147483648>>>f|0;f=((1<<f)-1&-2147483648)<<32-f}K=A[g+128>>3];T=A[g+136>>3];L=A[i+(b<<3)>>3];g=L>0;if(!(!(T>0&g)&(!(L<0)|!(K<0)))){k=e|sa;sa=k;W=f|W;v[Y+144>>2]=W;v[Y+148>>2]=k}if(g&K<0|L<0&T>0){e=e|P;P=e;O=f|O;v[Y+152>>2]=O;v[Y+156>>2]=e}b=b+1|0;if((h|0)!=(b|0)){continue}break}}Ba=Ib(v[v[a>>2]+8>>2],v[Y+248>>2],4,150902,13546);v[R+648>>2]=Ba;if(!Ba){Eb(150936,13546);g=-1;v[R+48>>2]=-1;Fb(276579,R+48|0);break Gf}b=Ib(v[v[a>>2]+8>>2],v[Y+248>>2],4,150902,13547);v[R+640>>2]=b;if(!b){Eb(150936,13547);g=-1;v[R+64>>2]=-1;Fb(276579,R- -64|0);break Gf}b=Ib(v[v[a>>2]+8>>2],v[Y+248>>2],4,150902,13548);v[R+668>>2]=b;if(!b){Eb(150936,13548);g=-1;v[R+80>>2]=-1;Fb(276579,R+80|0);break Gf}da=Ib(v[v[a>>2]+8>>2],v[Y+248>>2],4,150902,13549);v[R+664>>2]=da;if(!da){Eb(150936,13549);g=-1;v[R+96>>2]=-1;Fb(276579,R+96|0);break Gf}b=v[Y+256>>2];v[Y+256>>2]=b&-16385;If:{Ka=b&16384;ya=Ka?0:V;Jf:{if((ya|0)>=(x|0)){break Jf}na=N>=D(Q-M);K=A[Y+8>>3];_=A[Y>>3];La=v[Y+248>>2];Na=b&131072;while(1){if(v[R+596>>2]|!v[ga>>2]){break Jf}$=(ya<<2)+Ea|0;ka=v[$>>2];Kf:{if(!ka){break Kf}ea=v[ka+16>>2];if(!(Ka|w[ea+257|0]&64)|(w[ea+258|0]&2?Na:0)){break Kf}g=Mi(a,ea);if((g|0)!=1){Eb(150936,13614);v[R+400>>2]=g;Fb(276579,R+400|0);break Gf}b=v[ea+256>>2];Lf:{if(b&8192){f=v[ea+152>>2];i=v[ea+156>>2];b=v[ea+144>>2];S=v[ea+148>>2];break Lf}f=0;i=0;v[ea+144>>2]=0;v[ea+148>>2]=0;v[ea+256>>2]=b|8192;v[ea+152>>2]=0;v[ea+156>>2]=0;b=0;S=0;k=v[ea+248>>2];if((k|0)<=0){break Lf}l=v[ea+172>>2];m=v[ea+168>>2];g=0;while(1){j=v[m+(g<<2)>>2];e=B(v[j+288>>2],-1640531527)>>>26|0;h=e&31;if((e&63)>>>0>=32){e=0;h=-2147483648>>>h|0}else{e=-2147483648>>>h|0;h=((1<<h)-1&-2147483648)<<32-h}L=A[j+128>>3];Q=A[j+136>>3];M=A[l+(g<<3)>>3];j=M>0;if(!(!(Q>0&j)&(!(M<0)|!(L<0)))){z=e|S;S=z;b=b|h;v[ea+144>>2]=b;v[ea+148>>2]=S}if(j&L<0|M<0&Q>0){e=e|i;i=e;f=f|h;v[ea+152>>2]=f;v[ea+156>>2]=e}g=g+1|0;if((k|0)!=(g|0)){continue}break}}e=b|W;g=S|sa;ja=0;L=A[v[a+4>>2]+1280>>3];Q=-L;M=A[ea>>3];h=0;Mf:{if(!(Q<=_-M)){break Mf}h=0;if((b|0)!=(e|0)|(g|0)!=(S|0)){break Mf}h=(O|0)==(f|O)&(P|0)==(i|P)}ja=!(Q<=M-_)|((e|0)!=(W|0)|(g|0)!=(sa|0))?ja:(f|0)==(f|O)&(i|0)==(i|P);Z=0;Q=A[ea+8>>3];fa=0;Nf:{if(!(L>=K-Q)){break Nf}fa=0;if((e|0)!=(W|0)|(g|0)!=(sa|0)){break Nf}fa=(f|0)==(f|O)&(i|0)==(i|P)}Z=!(L>=Q-K)|((b|0)!=(e|0)|(g|0)!=(S|0))?Z:(O|0)==(f|O)&(P|0)==(i|P);Q=D(M-Q);va=Q<=L;wa=(va|na)&U>0;k=(f|0)==(W|0)&(i|0)==(sa|0)&((b|0)==(O|0)&(P|0)==(S|0));i=(b|0)==(W|0)&(S|0)==(sa|0)&((f|0)==(O|0)&(i|0)==(P|0));if(!(wa|(k|(i|(h|ja|fa|Z))))){break Kf}Of:{if(!wa){break Of}b=v[ea+248>>2];if((b|0)<=(La|0)){break Of}b=hc(v[v[a>>2]+8>>2],da,b,4,150902,13645);v[R+664>>2]=b;if(!b){Eb(150936,13645);g=-1;v[R+112>>2]=-1;Fb(276579,R+112|0);break Gf}La=v[ea+248>>2]}e=0;Oa=v[R+668>>2];da=v[R+664>>2];Pa=v[R+640>>2];g=0;j=0;qa=0;ma=0;z=0;ba=0;Ca=0;Pf:{Qf:while(1){S=h;b=Z;m=k;l=i;Rf:{Sf:while(1){h=(S|ja|fa|b)!=0;while(1){f=v[Y+248>>2];if((f|0)<=(e|0)&v[ea+248>>2]<=(g|0)){break Rf}if(!(wa|(h|(l|0)!=0|(m|0)!=0))){break Pf}Tf:{Uf:{Vf:{Wf:{if((e|0)>=(f|0)){break Wf}k=v[Y+168>>2];if(v[ea+248>>2]>(g|0)){Xf:{f=e<<2;i=v[v[f+k>>2]+288>>2];k=v[v[v[ea+168>>2]+(g<<2)>>2]+288>>2];switch(((i|0)<(k|0)?-1:(i|0)>(k|0))+1|0){case 1:break Vf;case 2:break Wf;case 0:break Xf;default:break Uf}}k=v[Y+168>>2]}M=A[v[Y+172>>2]+(e<<3)>>3];f=v[(e<<2)+k>>2];if(wa){v[(ba<<2)+Oa>>2]=e;qa=v[(v[f+376>>2]>>>4&12)+365592>>2]+qa|0;ba=ba+1|0}e=e+1|0;N=0;i=0;k=0;break Tf}N=A[v[ea+172>>2]+(g<<3)>>3];f=v[v[ea+168>>2]+(g<<2)>>2];if(wa){v[(z<<2)+da>>2]=g;z=z+1|0;j=v[(v[f+376>>2]>>>4&12)+365592>>2]+j|0}g=g+1|0;M=0;i=0;k=0;break Tf}N=A[v[ea+172>>2]+(g<<3)>>3];M=A[v[Y+172>>2]+(e<<3)>>3];f=v[f+v[Y+168>>2]>>2];if(wa){i=Ca<<2;v[i+Ba>>2]=e;v[i+Pa>>2]=g;Ca=Ca+1|0;ma=v[(v[f+376>>2]>>>4&12)+365592>>2]+ma|0}i=0;i=l?A[v[a+4>>2]+1280>>3]>=D(M-N):i;g=g+1|0;e=e+1|0;k=m?A[v[a+4>>2]+1280>>3]>=D(M+N):0;break Tf}Eb(150936,13750);f=0;Fb(257901,0);M=0;N=0;i=l;k=m}N=M-N;M=A[v[a+4>>2]+1280>>3];if(N>M){Z=0;h=A[f+128>>3]<-M;ja=h?0:ja;fa=h?0:fa;h=0;m=k;l=i;if(M<A[f+136>>3]){continue Qf}continue Sf}m=k;l=i;T=N;N=-M;if(!(T<N)){continue}break}break}l=N>A[f+128>>3];h=l?0:S;Z=l?0:b;if(!(M<A[f+136>>3])){continue}fa=0;ja=0;continue}break}if(l|m){L=A[Y>>3];Yf:{if(l){M=A[Y+8>>3];Q=A[ea+8>>3];Q=M<=Q?M:Q;M=A[ea>>3];L=L>=M?L:M;break Yf}M=A[Y+8>>3];Q=-A[ea>>3];Q=M<=Q?M:Q;M=-A[ea+8>>3];L=L>=M?L:M}M=D(L);N=D(Q);if(-A[v[a+4>>2]+1296>>3]>(Q-L)/(N<=1?M<=1?1:M:M<=N?N:M)){v[R+596>>2]=1;break Jf}b=v[Y+256>>2]&131072;e=b?ka:la;g=Li(a,e,L);if((g|0)!=1){Eb(150936,13854);v[R+256>>2]=g;Fb(276579,R+256|0);break Gf}g=Ki(a,e,Q);if((g|0)!=1){Eb(150936,13855);v[R+240>>2]=g;Fb(276579,R+240|0);break Gf}if(!(w[Y+258|0]&2)){_=A[Y>>3];K=A[Y+8>>3]}f=e;e=b?la:ka;g=bf(a,f,e);if((g|0)!=1){Eb(150936,13864);v[R+224>>2]=g;Fb(276579,R+224|0);break Gf}g=pc(a,e);if((g|0)!=1){Eb(150936,13868);v[R+208>>2]=g;Fb(276579,R+208|0);break Gf}v[((b?x:ya)<<2)+Ea>>2]=0;if(w[(b?Y:ea)+258|0]&2){break Kf}v[y>>2]=v[y>>2]+1;break Kf}Zf:{_f:{$f:{if(!ja){e=b;break $f}M=A[Y+8>>3];if(!(b|!na)){e=0;if(!(M>=A[v[a+4>>2]+1272>>3])){break $f}}L=D(M);e=v[a+4>>2];Q=A[e+1296>>3];N=A[ea>>3];T=N-M;M=D(N);ag:{if(M<=1){M=1;if(L<=1){break ag}M=L;break ag}M=L<=M?M:L}if(Q<T/M){v[R+596>>2]=1;break Jf}L=A[e+1272>>3];if(L<=-A[Y>>3]){break Zf}g=Li(a,la,-L);if((g|0)!=1){Eb(150936,13897);v[R+352>>2]=g;Fb(276579,R+352|0);break Gf}_=A[Y>>3];na=0;if(w[Y+258|0]&2){break Zf}g=bf(a,ka,la);if((g|0)==1){break _f}Eb(150936,13903);v[R+336>>2]=g;Fb(276579,R+336|0);break Gf}if(!S){S=0;b=e;break Zf}M=A[ea+8>>3];if(!(fa|!(L>=Q)|M>=A[v[a+4>>2]+1272>>3])){S=1;fa=0;b=e;va=1;break Zf}L=D(M);b=v[a+4>>2];Q=A[b+1296>>3];N=A[Y>>3];T=N-M;M=D(N);bg:{if(M<=1){M=1;if(L<=1){break bg}M=L;break bg}M=L<=M?M:L}if(Q<T/M){v[R+596>>2]=1;break Jf}S=1;L=A[b+1272>>3];if(L<=-A[ea>>3]){b=e;break Zf}g=Li(a,ka,-L);if((g|0)!=1){Eb(150936,13928);v[R+384>>2]=g;Fb(276579,R+384|0);break Gf}va=0;if(w[ea+258|0]&2){b=e;break Zf}b=e;g=bf(a,la,ka);if((g|0)==1){break _f}Eb(150936,13933);v[R+368>>2]=g;Fb(276579,R+368|0);break Gf}v[G>>2]=v[G>>2]+1}cg:{dg:{if(!b){break dg}M=A[Y>>3];if(!(!na|ja|A[v[a+4>>2]+1272>>3]<=-M)){break dg}L=D(M);b=v[a+4>>2];Q=-A[b+1296>>3];N=A[ea+8>>3];T=N-M;M=D(N);eg:{if(M<=1){M=1;if(L<=1){break eg}M=L;break eg}M=L<=M?M:L}if(Q>T/M){v[R+596>>2]=1;break Jf}L=A[b+1272>>3];if(L<=A[Y+8>>3]){break Pf}g=Ki(a,la,L);if((g|0)!=1){Eb(150936,13958);v[R+320>>2]=g;Fb(276579,R+320|0);break Gf}K=A[Y+8>>3];na=0;if(w[Y+258|0]&2){break Pf}g=bf(a,ka,la);if((g|0)==1){break cg}Eb(150936,13964);v[R+304>>2]=g;Fb(276579,R+304|0);break Gf}if(!fa){break Pf}M=A[ea>>3];if(!(!(!S&va)|A[v[a+4>>2]+1272>>3]<=-M)){va=1;break Pf}L=D(M);b=v[a+4>>2];Q=-A[b+1296>>3];N=A[Y+8>>3];T=N-M;M=D(N);fg:{if(M<=1){M=1;if(L<=1){break fg}M=L;break fg}M=L<=M?M:L}if(Q>T/M){v[R+596>>2]=1;break Jf}L=A[b+1272>>3];if(L<=A[ea+8>>3]){break Pf}g=Ki(a,ka,L);if((g|0)!=1){Eb(150936,13989);v[R+288>>2]=g;Fb(276579,R+288|0);break Gf}va=0;if(w[ea+258|0]&2){break Pf}g=bf(a,la,ka);if((g|0)==1){break cg}Eb(150936,13994);v[R+272>>2]=g;Fb(276579,R+272|0);break Gf}v[G>>2]=v[G>>2]+1}gg:{L=A[v[a+4>>2]+1272>>3];if(!(!(L<=-A[Y>>3])|!(L<=A[Y+8>>3]))){g=pc(a,la);if((g|0)!=1){Eb(150936,14006);v[R+192>>2]=g;Fb(276579,R+192|0);break Gf}v[ga>>2]=0;if(w[Y+258|0]&2){break Kf}g=bf(a,ka,la);if((g|0)==1){break gg}Eb(150936,14011);v[R+176>>2]=g;Fb(276579,R+176|0);break Gf}if(!(!(L<=-A[ea>>3])|!(L<=A[ea+8>>3]))){g=pc(a,ka);if((g|0)!=1){Eb(150936,14021);v[R+160>>2]=g;Fb(276579,R+160|0);break Gf}v[$>>2]=0;if(w[ea+258|0]&2){break Kf}g=bf(a,la,ka);if((g|0)!=1){Eb(150936,14026);v[R+144>>2]=g;Fb(276579,R+144|0);break Gf}v[y>>2]=v[y>>2]+1;break Kf}if(!wa){break Kf}v[R+660>>2]=0;hg:{if(!(!va|w[Y+258|0]&2|(j|0)>=(ma|0))){da=v[R+664>>2];g=VW(a,la,v[ka+16>>2],Ba,v[R+640>>2],v[R+668>>2],da,Ca,ma,qa,j,U,E,R+660|0,R+596|0);if((g|0)!=1){b=14049;break If}if(v[R+596>>2]){break Jf}g=ga;if(v[R+660>>2]){break hg}}if(!na|w[ea+258|0]&2|(ma|0)<=(qa|0)){break Kf}da=v[R+664>>2];g=VW(a,ka,v[la+16>>2],v[R+640>>2],Ba,da,v[R+668>>2],Ca,ma,j,qa,U,E,R+660|0,R+596|0);if((g|0)!=1){b=14067;break If}if(v[R+596>>2]){break Jf}g=$;if(!v[R+660>>2]){break Kf}}v[g>>2]=0;break Kf}v[y>>2]=v[y>>2]+1}ya=ya+1|0;if((ya|0)!=(x|0)){continue}break}}Hb(v[v[a>>2]+8>>2],R+664|0,150902,14084);Hb(v[v[a>>2]+8>>2],R+668|0,150902,14085);Hb(v[v[a>>2]+8>>2],R+640|0,150902,14086);Hb(v[v[a>>2]+8>>2],R+648|0,150902,14087);b=x-(Ma&16384?0:V)|0;pa=b+pa|0;oa=(b>>31)+oa|0;oa=b>>>0>pa>>>0?oa+1|0:oa;b=v[ha+68>>2];e=b>>31;if((oa|0)<=(e|0)&b>>>0>=pa>>>0|(e|0)>(oa|0)){break Ff}K=+(pa>>>0)+ +(oa|0)*4294967296;pa=0;oa=0;b=v[G>>2];e=v[y>>2];g=v[E>>2];if(A[ha+24>>3]>(+(b-n|0)*.5+ +(e-p|0)+ +(g-o|0)/10)/K){break Df}break Ef}Eb(150936,b);v[R+128>>2]=g;Fb(276579,R+128|0)}e=16727;break qf}b=n;g=o;e=p}x=x+1|0;if((x|0)>=(s|0)){n=b;o=g;p=e;break Df}p=e;o=g;n=b;if(!v[R+596>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],R+636|0,150902,16741)}ig:{if(v[R+596>>2]|(d|0)<=(ra|0)|(v[q>>2]!=(Ia|0)|v[r>>2]!=(Ha|0))){break ig}if(v[u>>2]!=(Ga|0)|v[y>>2]!=(p|0)|(v[C>>2]!=(Fa|0)|v[E>>2]!=(o|0))){break ig}if(!v[ha+96>>2]|v[G>>2]!=(n|0)){break ig}b=v[a+4>>2];if(v[b+1580>>2]){b=0}else{b=v[b+1216>>2]!=0}if(!b){break ig}if(rc(v[a+4>>2],v[a+24>>2],0)){break ig}e=0;m=0;da=0;g=ub-208|0;ub=g;f=fc(a);h=Lc(a);b=1;x=hd(a);jg:{if((x|0)==(f|0)){break jg}O=Ne(a);j=f-x|0;b=Oc(v[v[a>>2]+8>>2],h+(x<<2)|0,j,4,150902,14747);v[g+184>>2]=b;if(!b){Eb(150936,14747);b=-1;v[g>>2]=-1;Fb(276579,g);break jg}z=Ib(v[v[a>>2]+8>>2],j,8,150902,14750);v[g+204>>2]=z;if(!z){Eb(150936,14750);b=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);break jg}S=Ib(v[v[a>>2]+8>>2],j,8,150902,14751);v[g+200>>2]=S;if(!S){Eb(150936,14751);b=-1;v[g+32>>2]=-1;Fb(276579,g+32|0);break jg}P=Ib(v[v[a>>2]+8>>2],j,4,150902,14752);v[g+196>>2]=P;if(!P){Eb(150936,14752);b=-1;v[g+48>>2]=-1;Fb(276579,g+48|0);break jg}V=Ib(v[v[a>>2]+8>>2],j,4,150902,14753);v[g+192>>2]=V;if(!V){Eb(150936,14753);b=-1;v[g+64>>2]=-1;Fb(276579,g- -64|0);break jg}h=Ib(v[v[a>>2]+8>>2],O,4,150902,14754);v[g+188>>2]=h;if(!h){Eb(150936,14754);b=-1;v[g+80>>2]=-1;Fb(276579,g+80|0);break jg}Z=Ib(v[v[a>>2]+8>>2],O,4,150902,14755);v[g+180>>2]=Z;kg:{if(Z){lg:{if((j|0)<=0){break lg}if((f|0)!=(x+1|0)){i=j&2147483646;while(1){k=e<<3;l=v[b+(e<<2)>>2];A[k+z>>3]=A[l+128>>3];A[k+S>>3]=A[l+136>>3];k=e|1;l=k<<3;k=v[b+(k<<2)>>2];A[l+z>>3]=A[k+128>>3];A[l+S>>3]=A[k+136>>3];e=e+2|0;m=m+2|0;if((i|0)!=(m|0)){continue}break}}if(!(j&1)){break lg}i=e<<3;e=v[b+(e<<2)>>2];A[i+z>>3]=A[e+128>>3];A[i+S>>3]=A[e+136>>3]}k=f-O|0;e=j<<2;dc(P,e);dc(V,e);if((O|0)<=0){break kg}i=b+(k-x<<2)|0;f=v[a+4>>2];K=A[f+1280>>3];b=0;while(1){l=b<<2;e=v[l+i>>2];L=A[e+136>>3];M=A[e+128>>3];l=h+l|0;Q=A[e>>3];mg:{if(K>=D(Q)){Q=A[f+1272>>3];if(!(Q<=-M)){e=0;if(!(K>=M-H(M+K))){break mg}}e=1;if(L>=Q){break mg}e=K>=L-H(L+K);break mg}e=A[f+1272>>3]<=-M|K>=M-H(M+K);if(K<Q){break mg}e=K>=L-H(L+K)|L>=A[f+1272>>3]}v[l>>2]=e;b=b+1|0;if((O|0)!=(b|0)){continue}break}break kg}Eb(150936,14755);b=-1;v[g+96>>2]=-1;Fb(276579,g+96|0);break jg}if((d|0)>0){while(1){ga=(da<<2)+c|0;b=v[ga>>2];e=v[b+64>>2];ng:{og:{fa=v[b+56>>2];pg:{if((fa|0)<=0){if((e|0)<=0){break ng}h=v[b+16>>2];break pg}h=v[b+16>>2];if((e|0)<=0){break og}}e=v[h+248>>2];if((e|0)<=0){break ng}f=v[h+168>>2];b=0;i=v[g+188>>2];while(1){l=v[f+(b<<2)>>2];if((v[l+376>>2]&192)==192){v[i+(v[l+292>>2]-k<<2)>>2]=0;e=v[h+248>>2]}b=b+1|0;if((e|0)>(b|0)){continue}break}break ng}if(v[h+248>>2]<=0){break ng}U=A[h+8>>3];N=A[v[a+4>>2]+1272>>3];T=-A[h>>3];W=!(t[b+85|0]&1);f=-1;b=0;s=0;e=0;while(1){Q=A[v[h+172>>2]+(e<<3)>>3];l=v[v[h+168>>2]+(e<<2)>>2];i=v[l+376>>2];qg:{if((i&192)==192){break qg}if(!W){W=0;break qg}K=A[v[a+4>>2]+1280>>3];W=Q-H(Q+K)<=K}rg:{sg:{tg:{switch(i>>>6&3){case 0:break rg;case 3:break sg;default:break tg}}if(!(A[l+128>>3]>=0)){break sg}if(A[l+136>>3]<=1){break rg}}ug:{if(t[v[ga>>2]+85|0]&1){K=A[v[a+4>>2]+1272>>3];A[g+160>>3]=K;ba=1;v[g+148>>2]=1;v[g+144>>2]=1;A[g+168>>3]=-K;m=0;break ug}kJ(a,h,l,Q,g+168|0,g+160|0,g+156|0,g+152|0,g+148|0,g+144|0);ba=v[g+148>>2];vg:{if(ba){break vg}K=A[h+112>>3];M=K>=0?K:-K;K=A[g+168>>3];K=K>=0?K:-K;i=v[a+4>>2];L=A[i+1280>>3];if(!(M/(K>=L?K:L)>=A[i+1360>>3])){break vg}v[g+168>>2]=0;v[g+172>>2]=0;m=v[h+248>>2];if((m|0)<=0){break vg}oa=v[h+168>>2];i=0;M=0;while(1){pa=v[oa+(i<<2)>>2];if((pa|0)!=(l|0)){K=A[v[h+172>>2]+(i<<3)>>3];M=K*A[pa+(K>0?128:136)>>3]+M;A[g+168>>3]=M}i=i+1|0;if((m|0)!=(i|0)){continue}break}}m=0;if(v[g+144>>2]){break ug}m=1;K=A[h+120>>3];M=K>=0?K:-K;K=A[g+160>>3];K=K>=0?K:-K;i=v[a+4>>2];L=A[i+1280>>3];if(!(M/(K>=L?K:L)>=A[i+1360>>3])){break ug}v[g+160>>2]=0;v[g+164>>2]=0;oa=v[h+248>>2];if((oa|0)<=0){break ug}pa=v[h+168>>2];i=0;M=0;while(1){$=v[pa+(i<<2)>>2];if(($|0)!=(l|0)){K=A[v[h+172>>2]+(i<<3)>>3];M=K*A[$+(K>0?136:128)>>3]+M;A[g+160>>3]=M}i=i+1|0;if((oa|0)!=(i|0)){continue}break}}i=v[l+292>>2]-x|0;pa=i<<3;oa=pa+S|0;M=A[oa>>3];pa=z+pa|0;L=A[pa>>3];wg:{if(Q>0){K=L;xg:{if(N<=T){break xg}$=P+(i<<2)|0;v[$>>2]=fa+v[$>>2];K=A[v[a+4>>2]+1272>>3];if(ba){break xg}K=(A[h>>3]-A[g+168>>3])/Q}if(N<=U){break wg}i=V+(i<<2)|0;v[i>>2]=fa+v[i>>2];if(!m){M=-A[v[a+4>>2]+1272>>3];break wg}M=(A[h+8>>3]-A[g+160>>3])/Q;break wg}yg:{if(N<=T){break yg}m=V+(i<<2)|0;v[m>>2]=fa+v[m>>2];if(v[g+148>>2]){M=-A[v[a+4>>2]+1272>>3];break yg}M=(A[h>>3]-A[g+168>>3])/Q}if(N<=U){K=L;break wg}i=P+(i<<2)|0;v[i>>2]=fa+v[i>>2];if(v[g+144>>2]){K=A[v[a+4>>2]+1272>>3];break wg}K=(A[h+8>>3]-A[g+160>>3])/Q}zg:{if((v[l+376>>2]&192)==192){break zg}i=v[a+4>>2];Q=A[i+1272>>3];if(!(Q<=K)){K=I(K-A[i+1280>>3])}if(Q<=-M){break zg}M=H(M+A[i+1280>>3])}A[pa>>3]=K<=L?L:K;K=A[oa>>3];A[oa>>3]=K<=M?K:M;if((v[l+376>>2]&192)!=192){break rg}v[Z+(s<<2)>>2]=l;s=s+1|0;f=e;if(b){b=1}else{b=v[v[g+188>>2]+(v[l+292>>2]-k<<2)>>2]!=0}}e=e+1|0;if((e|0)<v[h+248>>2]){continue}break}if(!b){break ng}if(!((s|0)<=1&W)){if((s|0)<=0){break ng}i=0;e=v[g+188>>2];b=0;if(s>>>0>=4){h=s&2147483644;m=0;while(1){f=Z+(b<<2)|0;v[e+(v[v[f>>2]+292>>2]-k<<2)>>2]=0;v[e+(v[v[f+4>>2]+292>>2]-k<<2)>>2]=0;v[e+(v[v[f+8>>2]+292>>2]-k<<2)>>2]=0;v[e+(v[v[f+12>>2]+292>>2]-k<<2)>>2]=0;b=b+4|0;m=m+4|0;if((h|0)!=(m|0)){continue}break}}f=s&3;if(!f){break ng}while(1){v[e+(v[v[Z+(b<<2)>>2]+292>>2]-k<<2)>>2]=0;b=b+1|0;i=i+1|0;if((f|0)!=(i|0)){continue}break}break ng}e=v[v[h+168>>2]+(f<<2)>>2];b=v[e+292>>2]-k|0;K=A[v[a+4>>2]+1280>>3];L=A[v[h+172>>2]+(f<<3)>>3];if(!(K>=D(D(L)+-1))){v[v[g+188>>2]+(b<<2)>>2]=0;break ng}L=L*A[e>>3];if(!(!(L>=0)|N<=T)){f=v[g+188>>2]+(b<<2)|0;if(v[f>>2]){M=A[h>>3];e=K>=M-H(K+M)}else{e=0}v[f>>2]=e}if(!(L<=0)|N<=U){break ng}e=v[g+188>>2]+(b<<2)|0;if(v[e>>2]){L=A[h+8>>3];b=K>=L-H(K+L)}else{b=0}v[e>>2]=b}da=da+1|0;if((da|0)!=(d|0)){continue}break}}Ag:{if((j|0)>0){i=v[g+184>>2];h=0;while(1){b=v[a+4>>2];K=A[b+1280>>3];f=h<<2;e=v[f+i>>2];L=A[e>>3];M=-L;Bg:{if(K<M|!(K<L|K<A[e+136>>3])&A[b+1272>>3]<=-A[e+128>>3]){break Bg}if((od(e,0)|0)!=v[f+P>>2]){break Bg}l=h<<3;K=A[l+z>>3];if(A[v[a+4>>2]+1368>>3]<=-K|!(K<A[e+136>>3])){break Bg}b=df(a,e,K,0,g+168|0,g+160|0);if((b|0)!=1){h=15062;break Ag}b=l+S|0;K=A[b>>3];Q=A[e+136>>3];A[b>>3]=K<=Q?K:Q;if(!v[g+160>>2]){break Bg}v[u>>2]=v[u>>2]+1}b=v[a+4>>2];K=A[b+1280>>3];Cg:{if(K<L|!(K<M|K<-A[e+128>>3])&A[e+136>>3]>=A[b+1272>>3]){break Cg}if((nd(e,0)|0)!=v[f+V>>2]){break Cg}f=h<<3;K=A[f+S>>3];if(K>=A[v[a+4>>2]+1368>>3]|!(K>A[e+128>>3])){break Cg}b=gf(a,e,K,0,g+168|0,g+160|0);if((b|0)!=1){h=15091;break Ag}b=f+z|0;K=A[b>>3];L=A[e+128>>3];A[b>>3]=K>=L?K:L;if(!v[g+160>>2]){break Cg}v[u>>2]=v[u>>2]+1}h=h+1|0;if((j|0)!=(h|0)){continue}break}}b=1;Dg:{if((O|0)<=0){break Dg}h=k-x|0;i=v[g+188>>2]+(x<<2)|0;l=v[g+184>>2];while(1){Eg:{if(!v[i+(h-k<<2)>>2]){break Eg}e=h<<2;f=v[e+l>>2];if((od(f,0)|0)!=v[e+P>>2]){break Eg}if((nd(f,0)|0)!=v[e+V>>2]){break Eg}e=Ef(a,f,2,g+168|0);if((e|0)!=1){Eb(150936,15122);v[g+112>>2]=e;Fb(276579,g+112|0);b=e;break jg}if(!v[g+168>>2]){break Eg}v[R+596>>2]=1;break Dg}h=h+1|0;if((j|0)>(h|0)){continue}break}}Hb(v[v[a>>2]+8>>2],g+180|0,150902,15138);Hb(v[v[a>>2]+8>>2],g+188|0,150902,15139);Hb(v[v[a>>2]+8>>2],g+192|0,150902,15140);Hb(v[v[a>>2]+8>>2],g+196|0,150902,15141);Hb(v[v[a>>2]+8>>2],g+200|0,150902,15142);Hb(v[v[a>>2]+8>>2],g+204|0,150902,15143);Hb(v[v[a>>2]+8>>2],g+184|0,150902,15145);break jg}Eb(150936,h);v[g+128>>2]=b;Fb(276579,g+128|0)}ub=g+208|0;g=b;if((b|0)==1){break ig}Eb(150936,16755);v[R+16>>2]=b;Fb(276579,R+16|0);break a}b=v[R+596>>2];if(!(b|!Ja)){Fg:{if(!Hm(a)|(d|0)<=(ra|0)){break Fg}while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break Fg}Gg:{e=v[(ra<<2)+c>>2];if(t[e+85|0]&1){break Gg}b=v[e+16>>2];f=v[b+256>>2];if((f&67584)!=2048){break Gg}v[b+256>>2]=f|65536;f=v[e+84>>2];if(!(f&4194304)&(f&8404992)!=16384){break Gg}h=R+648|0;g=_J(a,e,h);f=16788;Hg:{if((g|0)!=1){break Hg}g=v[R+648>>2];if(!g){break Gg}g=mc(a,g);f=16792;if((g|0)!=1){break Hg}g=ec(a,h);f=16793;if((g|0)!=1){break Hg}v[C>>2]=v[C>>2]+1;v[b+256>>2]=v[b+256>>2]|131072;if(!(!v[ha+76>>2]|-A[v[a+4>>2]+1280>>3]>A[b>>3]-A[b+8>>3])&A[ha+8>>3]!=0){break Gg}g=pc(a,e);if((g|0)==1){break Gg}f=16809}Eb(150936,f);v[R>>2]=g;Fb(276579,R);break a}ra=ra+1|0;if((ra|0)!=(d|0)){continue}break}}b=v[R+596>>2]}Ig:{if(b){v[J>>2]=7;break Ig}Jg:{Kg:{if(v[q>>2]>(Ia|0)|v[r>>2]>(Ha|0)|(v[u>>2]>(Ga|0)|v[y>>2]>(p|0))){break Kg}if(v[C>>2]>(Fa|0)|v[E>>2]>(o|0)){break Kg}if(v[G>>2]<=(n|0)){break Jg}}v[J>>2]=17;break Ig}v[J>>2]=3}g=1;break a}Eb(150936,e);v[R+32>>2]=g;Fb(276579,R+32|0);break a}Eb(150936,b);v[R+464>>2]=g;Fb(276579,R+464|0)}Eb(150936,16681);v[R+432>>2]=g;Fb(276579,R+432|0)}ub=R+672|0;return g|0}function WHa(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,u=0,x=0,z=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,W=0,_=0,$=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0;g=ub-288|0;ub=g;v[g+168>>2]=0;v[g+172>>2]=-1;_=A[48091];t[a+808|0]=0;a:{b:{c:{d:{e:{if(!(v[v[a+868>>2]+40>>2]>0|v[v[a+864>>2]+40>>2]>0)){v[a+632>>2]=-3;d=Ub(16);v[111924]=0;b=N(2255,g+112|0,138666)|0;a=v[111924];v[111924]=0;if((a|0)==1){break d}v[d>>2]=371744;a=d+4|0;f:{g:{if(t[b+11|0]>=0){c=v[b+4>>2];v[a>>2]=v[b>>2];v[a+4>>2]=c;v[a+8>>2]=v[b+8>>2];break g}c=v[b+4>>2];e=v[b>>2];v[111924]=0;R(2167,a|0,e|0,c|0);a=v[111924];v[111924]=0;f=1;if((a|0)==1){break f}}v[d>>2]=373428;f=0;v[111924]=0;R(2152,d|0,373408,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}a=M()|0;if(t[b+11|0]<0){Gb(v[b>>2])}if(!f){break a}break c}h:{if(!v[a+380>>2]){v[a+632>>2]=-12;d=Ub(16);v[111924]=0;b=N(2255,g+112|0,138484)|0;a=v[111924];v[111924]=0;if((a|0)==1){break h}v[d>>2]=371744;a=d+4|0;i:{j:{if(t[b+11|0]>=0){c=v[b+4>>2];v[a>>2]=v[b>>2];v[a+4>>2]=c;v[a+8>>2]=v[b+8>>2];break j}c=v[b+4>>2];e=v[b>>2];v[111924]=0;R(2167,a|0,e|0,c|0);a=v[111924];v[111924]=0;f=1;if((a|0)==1){break i}}v[d>>2]=373428;f=0;v[111924]=0;R(2152,d|0,373408,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}a=M()|0;if(t[b+11|0]<0){Gb(v[b>>2])}if(!f){break a}break c}k:{if(!v[a+1360>>2]){v[a+632>>2]=-13;d=Ub(16);v[111924]=0;b=N(2255,g+112|0,138541)|0;a=v[111924];v[111924]=0;if((a|0)==1){break k}v[d>>2]=371744;a=d+4|0;l:{m:{if(t[b+11|0]>=0){c=v[b+4>>2];v[a>>2]=v[b>>2];v[a+4>>2]=c;v[a+8>>2]=v[b+8>>2];break m}c=v[b+4>>2];e=v[b>>2];v[111924]=0;R(2167,a|0,e|0,c|0);a=v[111924];v[111924]=0;f=1;if((a|0)==1){break l}}v[d>>2]=373428;f=0;v[111924]=0;R(2152,d|0,373408,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}a=M()|0;if(t[b+11|0]<0){Gb(v[b>>2])}if(!f){break a}break c}n:{if(!v[a+1364>>2]){v[a+632>>2]=-14;d=Ub(16);v[111924]=0;b=N(2255,g+112|0,138510)|0;a=v[111924];v[111924]=0;if((a|0)==1){break n}v[d>>2]=371744;a=d+4|0;o:{p:{if(t[b+11|0]>=0){c=v[b+4>>2];v[a>>2]=v[b>>2];v[a+4>>2]=c;v[a+8>>2]=v[b+8>>2];break p}c=v[b+4>>2];e=v[b>>2];v[111924]=0;R(2167,a|0,e|0,c|0);a=v[111924];v[111924]=0;f=1;if((a|0)==1){break o}}v[d>>2]=373428;f=0;v[111924]=0;R(2152,d|0,373408,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}a=M()|0;if(t[b+11|0]<0){Gb(v[b>>2])}if(!f){break a}break c}d=v[a+584>>2];zb[v[v[d>>2]+8>>2]](d);d=v[a+584>>2];zb[v[v[d>>2]+12>>2]](d);v[a+424>>2]=0;v[a+416>>2]=0;v[a+420>>2]=0;v[a+724>>2]=0;q:{r:{s:{if(w[a+728|0]){break s}d=v[a+1368>>2];t:{if(!d|v[a+632>>2]==-2){break t}c=v[a+324>>2];if(v[c+632>>2]|v[c+496>>2]!=-2){break t}zb[v[v[d>>2]+16>>2]](d,a)}zb[v[v[a>>2]+464>>2]](a);if(w[a+728|0]){break s}v[a+632>>2]=0;d=-15;a=v[a+496>>2]+2|0;if(a>>>0>=8){break r}d=v[(a<<2)+384580>>2];break r}o=a+320|0;if(!w[a+376|0]){v[a+564>>2]=v[a+1632>>2];v[a+324>>2]=a;hl(o);v[a+488>>2]=0;v[a+492>>2]=0;c=a+528|0;d=a+504|0;e=v[v[a+324>>2]+576>>2]==-1;v[a+556>>2]=e?c:d;v[a+552>>2]=e?d:c;Np(o);zb[v[v[a+320>>2]+20>>2]](o,d)}d=v[a+1360>>2];zb[v[v[d>>2]+24>>2]](d,v[a+568>>2]);d=v[a+1364>>2];zb[v[v[d>>2]+32>>2]](d,v[a+568>>2]);d=v[a+1632>>2];u:{if(!d){break u}c=v[d+4>>2];if((c|0)<5){break u}v[g+60>>2]=c;v[g+112>>2]=5;e=g+112|0;zb[v[v[d>>2]+8>>2]](d,e);d=v[a+1632>>2];Nb(v[v[d+8>>2]+(v[d+4>>2]<<2)>>2],250113,17);h=+zb[v[v[a>>2]+372>>2]](a);qd(v[v[d+8>>2]+(v[d+4>>2]<<2)>>2],h);c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];j=v[(v[v[c>>2]-12>>2]+c|0)+28>>2];v[e>>2]=j;v[j+4>>2]=v[j+4>>2]+1;v[111924]=0;e=N(1122,e|0,448956)|0;j=v[111924];v[111924]=0;v:{if((j|0)!=1){j=v[v[e>>2]+28>>2];v[111924]=0;i=N(j|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break v}}break b}j=g+112|0;e=v[j>>2];f=v[e+4>>2]-1|0;v[e+4>>2]=f;if((f|0)==-1){zb[v[v[e>>2]+8>>2]](e)}bc(c,i);$b(c);Nb(v[v[d+8>>2]+(v[d+4>>2]<<2)>>2],249908,17);h=+zb[v[v[a>>2]+428>>2]](a);qd(v[v[d+8>>2]+(v[d+4>>2]<<2)>>2],h);d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[(v[v[d>>2]-12>>2]+d|0)+28>>2];v[j>>2]=c;v[c+4>>2]=v[c+4>>2]+1;v[111924]=0;c=N(1122,j|0,448956)|0;e=v[111924];v[111924]=0;w:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;j=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break w}}a=M()|0;b=v[g+112>>2];d=v[b+4>>2]-1|0;v[b+4>>2]=d;if((d|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break a}c=v[g+112>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}bc(d,j);$b(d);d=v[a+1632>>2];zb[v[v[d>>2]+8>>2]](d,g+60|0)}if(v[a+496>>2]==3){if(v[a+632>>2]==1){v[a+632>>2]=0}v[a+496>>2]=0}v[a+632>>2]=-1;d=zb[v[v[a>>2]+404>>2]](a)|0;c=a+1324|0;v[c>>2]=0;v[c+4>>2]=0;c=a+1316|0;v[c>>2]=0;v[c+4>>2]=0;c=a+1308|0;v[c>>2]=0;v[c+4>>2]=0;v[a+1300>>2]=0;v[a+1304>>2]=0;v[a+1344>>2]=0;v[a+1348>>2]=0;c=a+1352|0;v[c>>2]=0;v[c+4>>2]=0;v[a+1616>>2]=0;v[a+1620>>2]=0;c=a+1624|0;v[c>>2]=0;v[c+4>>2]=0;la=a+168|0;ga=a+1440|0;ma=a+24|0;$=a+1420|0;ha=a+1480|0;ba=a+1460|0;na=a+504|0;ia=a+1300|0;E=v[a+568>>2];x=1;j=0;while(1){if(!(d&1)){ja=uL(g+112|0,na);v[a+1484>>2]=0;v[a+1464>>2]=0;v[a+756>>2]=0;v[a+748>>2]=0;v[a+740>>2]=0;v[a+732>>2]=0;t[a+648|0]=0;v[a+640>>2]=0;v[a+644>>2]=0;x:{y:{z:{A:{B:{C:{D:{if(v[a+568>>2]==-1){t[a+792|0]=0;v[a+784>>2]=0;v[a+788>>2]=-1;v[a+800>>2]=0;v[a+804>>2]=0;d=v[a+416>>2];c=v[v[a>>2]+428>>2];v[111924]=0;F=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[a>>2]+372>>2];v[111924]=0;G=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}h=A[a+696>>3];c=v[a+1360>>2];e=v[v[c>>2]+20>>2];v[111924]=0;oa(e|0,c|0,+h);c=v[111924];v[111924]=0;if((c|0)==1){break A}E:{if((z|0)>0){c=v[a+1364>>2];e=v[v[c>>2]+16>>2];l=A[a+688>>3];v[111924]=0;x=(l>x?x:l)*.01;oa(e|0,c|0,+x);c=v[111924];v[111924]=0;if((c|0)!=1){break E}break A}l=A[a+688>>3];c=v[a+1364>>2];e=v[v[c>>2]+16>>2];v[111924]=0;oa(e|0,c|0,+l);c=v[111924];v[111924]=0;x=1;if((c|0)==1){break A}}c=v[v[a>>2]+400>>2];k=0;v[111924]=0;R(c|0,a|0,1,0);c=v[111924];v[111924]=0;if((c|0)==1){break A}r=d-1|0;s=h*.01;q=0;F:{while(1){d=v[v[a>>2]+400>>2];v[111924]=0;R(d|0,a|0,0,0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1360>>2];c=v[v[d>>2]+40>>2];v[111924]=0;O(c|0,g+104|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}c=v[g+108>>2];d=v[g+104>>2];v[g+168>>2]=d;v[g+172>>2]=c;G:{if(!(v[a+428>>2]|(!v[a+784>>2]|d))){d=v[a+1632>>2];H:{if(!d){break H}c=v[d+4>>2];if((c|0)<5){break H}v[g+104>>2]=c;v[g+100>>2]=5;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,80562,36)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+180|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;I:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break I}}d=T(371012)|0;f=vb;c=v[g+180>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+180>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}c=v[a+788>>2];d=v[a+784>>2];v[g+168>>2]=d;v[g+172>>2]=c;t[a+792|0]=1;if((d|0)>0){v[111924]=0;c=v[g+172>>2];d=g+92|0;v[d>>2]=v[g+168>>2];v[d+4>>2]=c;v[d>>2]=1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;d=N(2341,la|0,d|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}h=A[a+800>>3];if(v[a+576>>2]==1){A[v[a+1248>>2]+(d<<3)>>3]=h;J:{if(!w[a+1554|0]){break J}f=v[a+1536>>2];c=d<<2;if(v[f+c>>2]){break J}e=v[a+1444>>2];if((e|0)>=v[a+1448>>2]){v[111924]=0;O(2363,ga|0,e+1|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}f=v[a+1536>>2];e=v[a+1444>>2]}v[a+1444>>2]=e+1;v[v[a+1452>>2]+(e<<2)>>2]=d;v[c+f>>2]=1}if(!w[a+1556|0]){break G}f=v[a+1484>>2];if((f|0)>=v[a+1488>>2]){v[111924]=0;O(2363,ha|0,f+1|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=v[a+1484>>2]}v[a+1484>>2]=f+1;v[v[a+1492>>2]+(f<<2)>>2]=d;break G}A[v[a+1236>>2]+(d<<3)>>3]=h;K:{if(!w[a+1553|0]){break K}f=v[a+1512>>2];c=d<<2;if(v[f+c>>2]){break K}e=v[a+1424>>2];if((e|0)>=v[a+1428>>2]){v[111924]=0;O(2363,$|0,e+1|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}f=v[a+1512>>2];e=v[a+1424>>2]}v[a+1424>>2]=e+1;v[v[a+1432>>2]+(e<<2)>>2]=d;v[c+f>>2]=1}if(!w[a+1556|0]){break G}f=v[a+1464>>2];if((f|0)>=v[a+1468>>2]){v[111924]=0;O(2363,ba|0,f+1|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=v[a+1464>>2]}v[a+1464>>2]=f+1;v[v[a+1472>>2]+(f<<2)>>2]=d;break G}v[111924]=0;c=v[g+172>>2];d=g+84|0;v[d>>2]=v[g+168>>2];v[d+4>>2]=c;v[d>>2]=-1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;d=N(2341,ma|0,d|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}h=A[a+800>>3];if(v[a+576>>2]==1){A[v[a+1236>>2]+(d<<3)>>3]=h;L:{if(!w[a+1553|0]){break L}f=v[a+1512>>2];c=d<<2;if(v[f+c>>2]){break L}e=v[a+1424>>2];if((e|0)>=v[a+1428>>2]){v[111924]=0;O(2363,$|0,e+1|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}f=v[a+1512>>2];e=v[a+1424>>2]}v[a+1424>>2]=e+1;v[v[a+1432>>2]+(e<<2)>>2]=d;v[c+f>>2]=1}if(!w[a+1556|0]){break G}f=v[a+1464>>2];if((f|0)>=v[a+1468>>2]){v[111924]=0;O(2363,ba|0,f+1|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=v[a+1464>>2]}v[a+1464>>2]=f+1;v[v[a+1472>>2]+(f<<2)>>2]=d;break G}A[v[a+1248>>2]+(d<<3)>>3]=h;M:{if(!w[a+1554|0]){break M}f=v[a+1536>>2];c=d<<2;if(v[f+c>>2]){break M}e=v[a+1444>>2];if((e|0)>=v[a+1448>>2]){v[111924]=0;O(2363,ga|0,e+1|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}f=v[a+1536>>2];e=v[a+1444>>2]}v[a+1444>>2]=e+1;v[v[a+1452>>2]+(e<<2)>>2]=d;v[c+f>>2]=1}if(!w[a+1556|0]){break G}f=v[a+1484>>2];if((f|0)>=v[a+1488>>2]){v[111924]=0;O(2363,ha|0,f+1|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=v[a+1484>>2]}v[a+1484>>2]=f+1;v[v[a+1492>>2]+(f<<2)>>2]=d;break G}t[a+792|0]=0}N:{if(v[g+168>>2]){break N}d=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}O:{if(!(h<=A[a+952>>3])|y[a+496>>2]>2){break O}A[g+104>>3]=s;if(v[a+428>>2]>0){d=v[v[a>>2]+460>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[111924]=0;U(2417,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1196>>2];c=v[a+1192>>2];P:{if(v[c+4>>2]==v[c>>2]){c=v[d>>2];d=v[d+4>>2];if((c|0)==(d|0)){break P}Wb(c,0,d-c&-8);break P}if(!w[a+384|0]){v[111924]=0;U(2343,o|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}}e=v[a+380>>2];f=v[v[e>>2]+48>>2];v[111924]=0;R(f|0,e|0,d|0,c|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[v[a>>2]+488>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1204>>2];c=v[a+1200>>2];Q:{if(v[c+4>>2]==v[c>>2]){c=v[d>>2];d=v[d+4>>2];if((c|0)==(d|0)){break Q}Wb(c,0,d-c&-8);break Q}if(!w[a+384|0]){v[111924]=0;U(2343,o|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}}e=v[a+380>>2];f=v[v[e>>2]+80>>2];v[111924]=0;R(f|0,e|0,d|0,c|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[a+864>>2];e=v[d+40>>2];if((e|0)>0){H=v[a+1204>>2];ca=v[d+28>>2];da=v[d+24>>2];ea=v[v[a+1208>>2]>>2];while(1){i=e-1|0;W=i<<3;d=da+B(v[(W+ca|0)+4>>2],24)|0;c=v[d+8>>2];if((c|0)<=0){h=0}else{C=v[H>>2];d=v[d>>2];l=0;R:{if(!(c&1)){h=0;f=c;break R}l=A[d>>3]*A[C+(v[d+8>>2]<<3)>>3];h=l+0;l=l-h+(h-h);d=d+16|0;m=h;f=c-1|0}if((c|0)!=1){while(1){I=A[d>>3]*A[C+(v[d+8>>2]<<3)>>3];u=h+I;J=u-h;K=A[d+16>>3]*A[C+(v[d+24>>2]<<3)>>3];m=u+K;L=m-u;l=l+(I-J+(h-(u-J)))+(K-L+(u-(m-L)));d=d+32|0;c=f-3|0;f=f-2|0;h=m;if(c>>>0<4294967294){continue}break}}h=m+l}A[ea+W>>3]=h;d=(e|0)>1;e=i;if(d){continue}break}}t[a+648|0]=0;v[a+640>>2]=0;v[a+644>>2]=0;d=v[a+1632>>2];S:{if(!d){break S}c=v[d+4>>2];if((c|0)<4){break S}v[g+100>>2]=c;v[g+80>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+80|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,d|0,254749,41)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[111924]=0;U(2418,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}v[111924]=0;U(2419,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1360>>2];c=v[v[d>>2]+16>>2];v[111924]=0;h=+aa(c|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(!(h>s)){break O}d=v[v[a>>2]+324>>2];v[111924]=0;d=N(d|0,a|0,g+104|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}if(d){break O}l=A[g+104>>3];if(s>l){A[g+104>>3]=s;l=s}d=v[a+1360>>2];c=v[v[d>>2]+20>>2];v[111924]=0;oa(c|0,d|0,+l);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];if(!d){break O}c=v[d+4>>2];if((c|0)<4){break O}v[g+100>>2]=c;v[g+80>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+80|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,247495,33)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1360>>2];e=v[v[c>>2]+16>>2];v[111924]=0;h=+aa(e|0,c|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+184|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;T:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break T}}d=T(371012)|0;f=vb;c=v[g+184>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+184>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}U:{if(!(v[a+428>>2]<=0|(q|0)>9)){d=v[a+1632>>2];V:{if(!d){break V}c=v[d+4>>2];if((c|0)<5){break V}v[g+104>>2]=c;v[g+100>>2]=5;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,78538,42)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+188|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;W:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break W}}d=T(371012)|0;f=vb;c=v[g+188>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+188>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[v[a>>2]+460>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(v[a+496>>2]<0){c=v[a+1632>>2];if(!c){break y}e=0;d=1;f=v[c+4>>2];if((f|0)<3){break F}v[g+104>>2]=f;v[g+100>>2]=3;f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250507,50)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];f=v[v[c>>2]-12>>2];v[111924]=0;i=g+192|0;f=v[(c+f|0)+28>>2];v[i>>2]=f;v[f+4>>2]=v[f+4>>2]+1;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;f=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;X:{if((i|0)!=1){i=v[v[f>>2]+28>>2];v[111924]=0;k=N(i|0,f|0,10)|0;f=v[111924];v[111924]=0;if((f|0)!=1){break X}}d=T(371012)|0;f=vb;c=v[g+192>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}f=v[g+192>>2];i=v[f+4>>2]-1|0;v[f+4>>2]=i;if((i|0)==-1){zb[v[v[f>>2]+8>>2]](f)}v[111924]=0;N(2270,c|0,k|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)!=1){break F}break A}d=v[a+1360>>2];c=v[v[d>>2]+40>>2];v[111924]=0;O(c|0,g+104|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}c=v[g+108>>2];d=v[g+104>>2];v[g+168>>2]=d;v[g+172>>2]=c;q=((d|0)!=0)+q|0;break U}d=v[g+168>>2]}if(d){break N}e=1;d=0;break F}d=v[a+600>>2];Y:{if(!((d|0)<0|(d|0)>v[a+416>>2])){d=v[a+1632>>2];Z:{if(!d){break Z}c=v[d+4>>2];if((c|0)<4){break Z}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,244489,35)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];e=v[a+600>>2];v[111924]=0;N(2359,c|0,e|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,137919,9)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+196|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;_:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break _}}d=T(371012)|0;f=vb;c=v[g+196>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+196>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-6;break Y}if(!(!b|!w[b|0])){d=v[a+1632>>2];$:{if(!d){break $}c=v[d+4>>2];if((c|0)<4){break $}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,93052,36)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+200|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;aa:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break aa}}d=T(371012)|0;f=vb;c=v[g+200>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+200>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-7;break Y}v[111924]=0;Q(2420,a|0,g+168|0,0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1360>>2];e=v[a+472>>2];c=v[a+468>>2];v[g+72>>2]=c;v[g+76>>2]=e;f=v[a+484>>2];i=v[v[d>>2]+44>>2];v[111924]=0;v[g+8>>2]=c;v[g+12>>2]=e;R(i|0,d|0,g+8|0,f|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+404>>2];v[111924]=0;d=S(d|0,a|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[a>>2]+536>>2];v[111924]=0;U(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}ba:{if(v[a+468>>2]){k=0;break ba}if((v[a+496>>2]&-2)==4){break ba}if((k|0)>=400){d=v[a+1632>>2];ca:{if(!d){break ca}c=v[d+4>>2];if((c|0)<4){break ca}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,247691,37)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,87591,18)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+204|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;da:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break da}}d=T(371012)|0;f=vb;c=v[g+204>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+204>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-8;d=1}k=k+1|0}if(v[a+484>>2]>=0){v[a+1304>>2]=v[a+1304>>2]+1}if(!((v[a+416>>2]-r|0)%1e4|v[a+496>>2]==5)){c=v[v[a>>2]+372>>2];v[111924]=0;h=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}ea:{if(!(A[a+952>>3]>=D(h-G))){break ea}c=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}if(!(A[a+952>>3]>=D(h-F))){break ea}c=v[a+1632>>2];if((n|0)<=9){fa:{if(!c){break fa}e=v[c+4>>2];if((e|0)<5){break fa}v[g+104>>2]=e;v[g+100>>2]=5;e=v[v[c>>2]+8>>2];v[111924]=0;O(e|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];e=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,e|0,207633,77)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;f=g+208|0;e=v[(c+e|0)+28>>2];v[f>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;e=N(1122,f|0,448956)|0;f=v[111924];v[111924]=0;ga:{if((f|0)!=1){f=v[v[e>>2]+28>>2];v[111924]=0;i=N(f|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break ga}}d=T(371012)|0;f=vb;c=v[g+208>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}e=v[g+208>>2];f=v[e+4>>2]-1|0;v[e+4>>2]=f;if((f|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,i|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];e=v[v[c>>2]+8>>2];v[111924]=0;O(e|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}}n=n+1|0;e=0;break F}ha:{if(!c){break ha}d=v[c+4>>2];if((d|0)<4){break ha}v[g+104>>2]=d;v[g+100>>2]=4;d=v[v[c>>2]+8>>2];v[111924]=0;O(d|0,c|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,207575,57)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+212|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;ia:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break ia}}d=T(371012)|0;f=vb;c=v[g+212>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+212>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-8;break Y}c=v[a+416>>2];e=v[v[a>>2]+428>>2];v[111924]=0;F=+aa(e|0,a|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}e=v[v[a>>2]+372>>2];v[111924]=0;G=+aa(e|0,a|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}r=c-1|0}if(!d){continue}}break}e=0;d=1}ja:{ka:{c=v[a+1632>>2];if(!c){break ka}f=v[c+4>>2];if((f|0)<5){break ka}v[g+104>>2]=f;v[g+100>>2]=5;f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250920,32)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+416>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251694,9)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[a>>2]+372>>2];v[111924]=0;h=+aa(f|0,a|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250454,9)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(f|0,a|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250872,11)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[a+952>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251417,11)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[(v[a+576>>2]==1?688:696)+a>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251406,10)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[(v[a+576>>2]==1?696:688)+a>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[v[f>>2]-12>>2];v[111924]=0;k=g+216|0;i=v[(f+i|0)+28>>2];v[k>>2]=i;v[i+4>>2]=v[i+4>>2]+1;i=v[111924];v[111924]=0;if((i|0)==1){break A}v[111924]=0;i=N(1122,k|0,448956)|0;k=v[111924];v[111924]=0;la:{if((k|0)!=1){k=v[v[i>>2]+28>>2];v[111924]=0;r=N(k|0,i|0,10)|0;i=v[111924];v[111924]=0;if((i|0)!=1){break la}}d=T(371012)|0;f=vb;c=v[g+216>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}i=v[g+216>>2];k=v[i+4>>2]-1|0;v[i+4>>2]=k;if((k|0)==-1){zb[v[v[i>>2]+8>>2]](i)}v[111924]=0;N(2270,f|0,r|0)|0;i=v[111924];v[111924]=0;if((i|0)==1){break A}v[111924]=0;S(2271,f|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250856,15)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;N(2421,f|0,d|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250490,16)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244557,2)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244093,1)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250558,17)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+632>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244557,2)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+632>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244093,1)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];f=v[v[c>>2]-12>>2];v[111924]=0;i=g+220|0;f=v[(c+f|0)+28>>2];v[i>>2]=f;v[f+4>>2]=v[f+4>>2]+1;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;f=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;ma:{if((i|0)!=1){i=v[v[f>>2]+28>>2];v[111924]=0;k=N(i|0,f|0,10)|0;f=v[111924];v[111924]=0;if((f|0)!=1){break ma}}d=T(371012)|0;f=vb;c=v[g+220>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}f=v[g+220>>2];i=v[f+4>>2]-1|0;v[f+4>>2]=i;if((i|0)==-1){zb[v[v[f>>2]+8>>2]](f)}v[111924]=0;N(2270,c|0,k|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=1;if(!d){break ja}d=1;break x}f=1;if(!d){break ja}d=1;break x}d=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(h<=A[a+952>>3]){d=v[v[a>>2]+432>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+452>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];na:{if(!d){break na}c=v[d+4>>2];if((c|0)<5){break na}v[g+104>>2]=c;v[g+100>>2]=5;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250768,16)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250454,9)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[a>>2]+428>>2];v[111924]=0;l=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,c|0,+l)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,251429,12)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];l=A[a+688>>3];v[111924]=0;Z(2412,c|0,+l)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;i=g+224|0;c=v[(c+d|0)+28>>2];v[i>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;oa:{if((i|0)!=1){i=v[v[c>>2]+28>>2];v[111924]=0;k=N(i|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break oa}}d=T(371012)|0;f=vb;c=v[g+224>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+224>>2];i=v[c+4>>2]-1|0;v[c+4>>2]=i;if((i|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,k|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}pa:{if(!e){break pa}d=v[v[a>>2]+428>>2];v[111924]=0;l=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(!(A[a+688>>3]>=h+l)){break pa}if(v[a+632>>2]==1){v[a+632>>2]=0}if(v[a+496>>2]!=3){break D}break C}if((z|0)>=3){l=A[a+1376>>3];qa:{ra:{if(l==0){break ra}h=A[a+1384>>3];if(h==0){break ra}m=A[a+1392>>3];if(m!=0){break qa}}v[111924]=0;tL(a);d=v[111924];v[111924]=0;if((d|0)==1){break A}m=A[a+1392>>3];h=A[a+1384>>3];l=A[a+1376>>3]}h=h<l?l:h;if((h>m?h:m)>=1e9){d=v[a+1632>>2];c=v[d+4>>2];e=v[v[d+8>>2]+(c<<2)>>2];f=v[e>>2]-12|0;v[(v[f>>2]+e|0)+8>>2]=0;e=e+v[f>>2]|0;v[e+4>>2]=v[e+4>>2]&-261|256;if((c|0)>=3){v[g+104>>2]=c;v[g+100>>2]=3;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,211954,60)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250162,15)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1376>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250146,15)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1384>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250131,14)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1392>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,244093,1)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+228|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;sa:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break sa}}d=T(371012)|0;f=vb;c=v[g+228>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+228>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}if(v[a+632>>2]==1){v[a+632>>2]=0}if(v[a+496>>2]!=3){break D}break C}v[a+632>>2]=-8;c=Ub(16);v[111924]=0;e=N(2255,g+60|0,102090)|0;d=v[111924];v[111924]=0;ta:{if((d|0)!=1){v[c>>2]=371744;d=c+4|0;ua:{va:{if(t[g+71|0]>=0){f=v[e+4>>2];v[d>>2]=v[e>>2];v[d+4>>2]=f;v[d+8>>2]=v[e+8>>2];break va}f=v[e>>2];v[111924]=0;R(2167,d|0,f|0,v[g+64>>2]);d=v[111924];v[111924]=0;n=1;if((d|0)==1){break ua}}v[c>>2]=373428;n=0;v[111924]=0;R(2152,c|0,373408,2256);d=v[111924];v[111924]=0;if((d|0)!=1){break e}}d=T(371012)|0;f=vb;if(t[g+71|0]<0){Gb(v[e>>2])}if(n){break ta}break z}d=T(371012)|0;f=vb}ac(c);break z}z=z+1|0}v[111924]=0;O(2423,a|0,1);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+464>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+568>>2];c=v[a+1360>>2];e=v[v[c>>2]+24>>2];v[111924]=0;O(e|0,c|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+568>>2];c=v[a+1364>>2];e=v[v[c>>2]+32>>2];v[111924]=0;O(e|0,c|0,d|0);c=v[111924];v[111924]=0;d=0;if((c|0)!=1){break x}break A}v[a+776>>2]=0;v[a+780>>2]=0;t[a+772|0]=0;v[a+768>>2]=-1;d=v[a+416>>2];c=v[v[a>>2]+428>>2];v[111924]=0;F=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[a>>2]+372>>2];v[111924]=0;G=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}h=A[a+688>>3];c=v[a+1360>>2];e=v[v[c>>2]+20>>2];v[111924]=0;oa(e|0,c|0,+h);c=v[111924];v[111924]=0;if((c|0)==1){break A}wa:{if((z|0)>0){c=v[a+1364>>2];e=v[v[c>>2]+16>>2];l=A[a+696>>3];v[111924]=0;x=(l>x?x:l)*.01;oa(e|0,c|0,+x);c=v[111924];v[111924]=0;if((c|0)!=1){break wa}break A}l=A[a+696>>3];c=v[a+1364>>2];e=v[v[c>>2]+16>>2];v[111924]=0;oa(e|0,c|0,+l);c=v[111924];v[111924]=0;x=1;if((c|0)==1){break A}}c=v[v[a>>2]+400>>2];r=0;v[111924]=0;R(c|0,a|0,1,0);c=v[111924];v[111924]=0;if((c|0)==1){break A}q=d-1|0;s=h*.01;C=0;xa:{while(1){d=v[v[a>>2]+400>>2];v[111924]=0;R(d|0,a|0,0,0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1360>>2];c=v[v[d>>2]+32>>2];v[111924]=0;c=S(c|0,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}ya:{za:{if((c|0)>=0){break za}d=v[a+768>>2];if(v[a+428>>2]|(d|0)<0){break za}c=v[a+1632>>2];Aa:{if(!c){break Aa}e=v[c+4>>2];if((e|0)<5){break Aa}v[g+104>>2]=e;v[g+100>>2]=5;d=v[v[c>>2]+8>>2];v[111924]=0;O(d|0,c|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,80657,36)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+232|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Ba:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Ba}}d=T(371012)|0;f=vb;c=v[g+232>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+232>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+768>>2]}t[a+772|0]=1;A[v[a+1236>>2]+(d<<3)>>3]=A[a+776>>3];if(!w[a+1552|0]){c=d;break ya}f=v[a+1512>>2];if(!v[f+(d<<2)>>2]){e=v[a+1424>>2];if((e|0)>=v[a+1428>>2]){v[111924]=0;O(2363,$|0,e+1|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=v[a+1512>>2];e=v[a+1424>>2]}v[a+1424>>2]=e+1;v[v[a+1432>>2]+(e<<2)>>2]=d;v[(v[a+768>>2]<<2)+f>>2]=1}if(!w[a+1555|0]){c=d;break ya}c=v[a+768>>2];f=v[a+1464>>2];if((f|0)>=v[a+1468>>2]){v[111924]=0;O(2363,ba|0,f+1|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}f=v[a+1464>>2]}v[a+1464>>2]=f+1;v[v[a+1472>>2]+(f<<2)>>2]=c;c=d;break ya}t[a+772|0]=0}Ca:{if((c|0)>=0){break Ca}d=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}Da:{if(!(h<=A[a+952>>3])|y[a+496>>2]>2){break Da}A[g+104>>3]=s;if(v[a+428>>2]>0){d=v[v[a>>2]+460>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[111924]=0;U(2417,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1196>>2];e=v[a+1192>>2];Ea:{if(v[e+4>>2]==v[e>>2]){e=v[d>>2];d=v[d+4>>2];if((e|0)==(d|0)){break Ea}Wb(e,0,d-e&-8);break Ea}if(!w[a+384|0]){v[111924]=0;U(2343,o|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}}f=v[a+380>>2];i=v[v[f>>2]+48>>2];v[111924]=0;R(i|0,f|0,d|0,e|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[v[a>>2]+492>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1204>>2];e=v[a+1200>>2];Fa:{if(v[e+4>>2]==v[e>>2]){e=v[d>>2];d=v[d+4>>2];if((e|0)==(d|0)){break Fa}Wb(e,0,d-e&-8);break Fa}if(!w[a+384|0]){v[111924]=0;U(2343,o|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}}f=v[a+380>>2];i=v[v[f>>2]+80>>2];v[111924]=0;R(i|0,f|0,d|0,e|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[a+864>>2];e=v[d+40>>2];if((e|0)>0){ca=v[a+1204>>2];da=v[d+28>>2];ea=v[d+24>>2];W=v[v[a+1208>>2]>>2];while(1){k=e-1|0;ka=k<<3;d=ea+B(v[(ka+da|0)+4>>2],24)|0;i=v[d+8>>2];if((i|0)<=0){h=0}else{H=v[ca>>2];d=v[d>>2];l=0;Ga:{if(!(i&1)){h=0;f=i;break Ga}l=A[d>>3]*A[H+(v[d+8>>2]<<3)>>3];h=l+0;l=l-h+(h-h);d=d+16|0;m=h;f=i-1|0}if((i|0)!=1){while(1){I=A[d>>3]*A[H+(v[d+8>>2]<<3)>>3];u=h+I;J=u-h;K=A[d+16>>3]*A[H+(v[d+24>>2]<<3)>>3];m=u+K;L=m-u;l=l+(I-J+(h-(u-J)))+(K-L+(u-(m-L)));d=d+32|0;i=f-3|0;f=f-2|0;h=m;if(i>>>0<4294967294){continue}break}}h=m+l}A[W+ka>>3]=h;d=(e|0)>1;e=k;if(d){continue}break}}t[a+648|0]=0;v[a+640>>2]=0;v[a+644>>2]=0;d=v[a+1632>>2];Ha:{if(!d){break Ha}e=v[d+4>>2];if((e|0)<4){break Ha}v[g+100>>2]=e;v[g+80>>2]=4;e=v[v[d>>2]+8>>2];v[111924]=0;O(e|0,d|0,g+80|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,d|0,254749,41)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];e=v[v[d>>2]+8>>2];v[111924]=0;O(e|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[111924]=0;U(2424,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1360>>2];e=v[v[d>>2]+16>>2];v[111924]=0;h=+aa(e|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(!(h>s)){break Da}d=v[v[a>>2]+324>>2];v[111924]=0;d=N(d|0,a|0,g+104|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}if(d){break Da}l=A[g+104>>3];if(s>l){A[g+104>>3]=s;l=s}d=v[a+1360>>2];e=v[v[d>>2]+20>>2];v[111924]=0;oa(e|0,d|0,+l);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];if(!d){break Da}e=v[d+4>>2];if((e|0)<4){break Da}v[g+100>>2]=e;v[g+80>>2]=4;e=v[v[d>>2]+8>>2];v[111924]=0;O(e|0,d|0,g+80|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];e=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,e|0,247495,33)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}e=v[a+1360>>2];f=v[v[e>>2]+16>>2];v[111924]=0;h=+aa(f|0,e|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}e=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,e|0,+h)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];e=v[v[d>>2]-12>>2];v[111924]=0;f=g+236|0;e=v[(d+e|0)+28>>2];v[f>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;e=N(1122,f|0,448956)|0;f=v[111924];v[111924]=0;Ia:{if((f|0)!=1){f=v[v[e>>2]+28>>2];v[111924]=0;i=N(f|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Ia}}d=T(371012)|0;f=vb;c=v[g+236>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}e=v[g+236>>2];f=v[e+4>>2]-1|0;v[e+4>>2]=f;if((f|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,d|0,i|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];e=v[v[d>>2]+8>>2];v[111924]=0;O(e|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}if(!(v[a+428>>2]<=0|(C|0)>9)){d=v[a+1632>>2];Ja:{if(!d){break Ja}c=v[d+4>>2];if((c|0)<5){break Ja}v[g+104>>2]=c;v[g+100>>2]=5;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,78581,42)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+240|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Ka:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Ka}}d=T(371012)|0;f=vb;c=v[g+240>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+240>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}d=v[v[a>>2]+460>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}if(v[a+496>>2]<0){c=v[a+1632>>2];if(!c){break y}e=0;d=1;f=v[c+4>>2];if((f|0)<3){break xa}v[g+104>>2]=f;v[g+100>>2]=3;f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250507,50)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];f=v[v[c>>2]-12>>2];v[111924]=0;i=g+244|0;f=v[(c+f|0)+28>>2];v[i>>2]=f;v[f+4>>2]=v[f+4>>2]+1;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;f=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;La:{if((i|0)!=1){i=v[v[f>>2]+28>>2];v[111924]=0;k=N(i|0,f|0,10)|0;f=v[111924];v[111924]=0;if((f|0)!=1){break La}}d=T(371012)|0;f=vb;c=v[g+244>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}f=v[g+244>>2];i=v[f+4>>2]-1|0;v[f+4>>2]=i;if((i|0)==-1){zb[v[v[f>>2]+8>>2]](f)}v[111924]=0;N(2270,c|0,k|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)!=1){break xa}break A}d=v[a+1360>>2];c=v[v[d>>2]+32>>2];v[111924]=0;c=S(c|0,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}C=((c^-1)>>>31|0)+C|0}d=0;if((c|0)>=0){break Ca}e=1;break xa}d=v[a+600>>2];Ma:{if(!((d|0)<0|(d|0)>v[a+416>>2])){d=v[a+1632>>2];Na:{if(!d){break Na}c=v[d+4>>2];if((c|0)<4){break Na}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,244489,35)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];e=v[a+600>>2];v[111924]=0;N(2359,c|0,e|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,137919,9)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+248|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Oa:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Oa}}d=T(371012)|0;f=vb;c=v[g+248>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+248>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-6;break Ma}if(!(!b|!w[b|0])){d=v[a+1632>>2];Pa:{if(!d){break Pa}c=v[d+4>>2];if((c|0)<4){break Pa}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,93052,36)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+252|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Qa:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Qa}}d=T(371012)|0;f=vb;c=v[g+252>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+252>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-7;break Ma}v[111924]=0;Q(2425,a|0,c|0,0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}f=v[a+484>>2];d=v[a+1360>>2];e=v[a+480>>2];c=v[a+476>>2];v[g+48>>2]=c;v[g+52>>2]=e;i=v[v[d>>2]+36>>2];v[111924]=0;v[g+16>>2]=c;v[g+20>>2]=e;R(i|0,d|0,f|0,g+16|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+404>>2];v[111924]=0;d=S(d|0,a|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[v[a>>2]+536>>2];v[111924]=0;U(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}Ra:{if(v[a+484>>2]>=0){r=0;break Ra}if((v[a+496>>2]&-2)==4){break Ra}if((r|0)>=400){d=v[a+1632>>2];Sa:{if(!d){break Sa}c=v[d+4>>2];if((c|0)<4){break Sa}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,87536,54)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+256|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Ta:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Ta}}d=T(371012)|0;f=vb;c=v[g+256>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+256>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-8;d=1}r=r+1|0}if(v[a+468>>2]){v[ia>>2]=v[ia>>2]+1}if(!((v[a+416>>2]-q|0)%1e4|v[a+496>>2]==5)){c=v[v[a>>2]+372>>2];v[111924]=0;h=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}Ua:{if(!(A[a+952>>3]>=D(h-G))){break Ua}c=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}if(!(A[a+952>>3]>=D(h-F))){break Ua}c=v[a+1632>>2];if((n|0)<=9){Va:{if(!c){break Va}e=v[c+4>>2];if((e|0)<5){break Va}v[g+104>>2]=e;v[g+100>>2]=5;e=v[v[c>>2]+8>>2];v[111924]=0;O(e|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];e=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,e|0,207711,78)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;f=g+260|0;e=v[(c+e|0)+28>>2];v[f>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;e=N(1122,f|0,448956)|0;f=v[111924];v[111924]=0;Wa:{if((f|0)!=1){f=v[v[e>>2]+28>>2];v[111924]=0;i=N(f|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Wa}}d=T(371012)|0;f=vb;c=v[g+260>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}e=v[g+260>>2];f=v[e+4>>2]-1|0;v[e+4>>2]=f;if((f|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,i|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];e=v[v[c>>2]+8>>2];v[111924]=0;O(e|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}}n=n+1|0;e=0;break xa}Xa:{if(!c){break Xa}d=v[c+4>>2];if((d|0)<4){break Xa}v[g+104>>2]=d;v[g+100>>2]=4;d=v[v[c>>2]+8>>2];v[111924]=0;O(d|0,c|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,87480,55)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+264|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Ya:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;f=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Ya}}d=T(371012)|0;f=vb;c=v[g+264>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}c=v[g+264>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,f|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}}v[a+632>>2]=-8;break Ma}c=v[a+416>>2];e=v[v[a>>2]+428>>2];v[111924]=0;F=+aa(e|0,a|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}e=v[v[a>>2]+372>>2];v[111924]=0;G=+aa(e|0,a|0);e=v[111924];v[111924]=0;if((e|0)==1){break A}q=c-1|0}if(!d){continue}}break}e=0;d=1}Za:{_a:{c=v[a+1632>>2];if(!c){break _a}f=v[c+4>>2];if((f|0)<5){break _a}v[g+104>>2]=f;v[g+100>>2]=5;f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+100|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250953,32)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+416>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251694,9)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[a>>2]+372>>2];v[111924]=0;h=+aa(f|0,a|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250454,9)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(f|0,a|0);f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250872,11)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[a+952>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251417,11)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[(v[a+576>>2]==1?688:696)+a>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,251406,10)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];h=A[(v[a+576>>2]==1?696:688)+a>>3];v[111924]=0;Z(2412,f|0,+h)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[v[f>>2]-12>>2];v[111924]=0;k=g+268|0;i=v[(f+i|0)+28>>2];v[k>>2]=i;v[i+4>>2]=v[i+4>>2]+1;i=v[111924];v[111924]=0;if((i|0)==1){break A}v[111924]=0;i=N(1122,k|0,448956)|0;k=v[111924];v[111924]=0;$a:{if((k|0)!=1){k=v[v[i>>2]+28>>2];v[111924]=0;r=N(k|0,i|0,10)|0;i=v[111924];v[111924]=0;if((i|0)!=1){break $a}}d=T(371012)|0;f=vb;c=v[g+268>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}i=v[g+268>>2];k=v[i+4>>2]-1|0;v[i+4>>2]=k;if((k|0)==-1){zb[v[v[i>>2]+8>>2]](i)}v[111924]=0;N(2270,f|0,r|0)|0;i=v[111924];v[111924]=0;if((i|0)==1){break A}v[111924]=0;S(2271,f|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250840,15)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;N(2421,f|0,d|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250490,16)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244557,2)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+496>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244093,1)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,250558,17)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+632>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244557,2)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];i=v[a+632>>2];v[111924]=0;N(2359,f|0,i|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}f=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];v[111924]=0;Q(2258,f|0,244093,1)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}c=v[v[c+8>>2]+(v[c+4>>2]<<2)>>2];f=v[v[c>>2]-12>>2];v[111924]=0;i=g+272|0;f=v[(c+f|0)+28>>2];v[i>>2]=f;v[f+4>>2]=v[f+4>>2]+1;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;f=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;ab:{if((i|0)!=1){i=v[v[f>>2]+28>>2];v[111924]=0;k=N(i|0,f|0,10)|0;f=v[111924];v[111924]=0;if((f|0)!=1){break ab}}d=T(371012)|0;f=vb;c=v[g+272>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}break z}f=v[g+272>>2];i=v[f+4>>2]-1|0;v[f+4>>2]=i;if((i|0)==-1){zb[v[v[f>>2]+8>>2]](f)}v[111924]=0;N(2270,c|0,k|0)|0;f=v[111924];v[111924]=0;if((f|0)==1){break A}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break A}c=v[a+1632>>2];f=v[v[c>>2]+8>>2];v[111924]=0;O(f|0,c|0,g+104|0);c=v[111924];v[111924]=0;if((c|0)==1){break A}f=1;if(!d){break Za}d=1;break x}f=1;if(!d){break Za}d=1;break x}d=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}bb:{cb:{db:{if(h<_){d=v[v[a>>2]+428>>2];c=0;v[111924]=0;l=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)!=1){break db}break A}c=j+1|0;if((j|0)>=400){v[a+632>>2]=-8;j=Ub(16);v[111924]=0;i=N(2255,g+36|0,103196)|0;d=v[111924];v[111924]=0;eb:{if((d|0)!=1){v[j>>2]=371744;d=j+4|0;fb:{gb:{if(t[g+47|0]>=0){e=v[i+4>>2];v[d>>2]=v[i>>2];v[d+4>>2]=e;v[d+8>>2]=v[i+8>>2];break gb}e=v[i>>2];v[111924]=0;R(2167,d|0,e|0,v[g+40>>2]);d=v[111924];v[111924]=0;e=1;if((d|0)==1){break fb}}v[j>>2]=373428;e=0;v[111924]=0;R(2152,j|0,373408,2256);d=v[111924];v[111924]=0;if((d|0)!=1){break e}}d=T(371012)|0;f=vb;if(t[g+47|0]<0){Gb(v[i>>2])}if(e){break eb}break bb}d=T(371012)|0;f=vb}ac(j);break bb}d=v[a+1632>>2];hb:{if(!d){break hb}j=v[d+4>>2];if((j|0)<5){break hb}v[g+104>>2]=j;v[g+100>>2]=5;j=v[v[d>>2]+8>>2];v[111924]=0;O(j|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break cb}d=v[a+1632>>2];j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,j|0,250768,16)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[a>>2]+452>>2];v[111924]=0;h=+aa(j|0,a|0);j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,j|0,+h)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,j|0,250454,9)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(j|0,a|0);j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,j|0,+h)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,j|0,251442,12)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+696>>3];v[111924]=0;Z(2412,j|0,+h)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,j|0,250418,15)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}j=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;N(2359,j|0,c|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];j=v[v[d>>2]-12>>2];v[111924]=0;i=g+276|0;j=v[(d+j|0)+28>>2];v[i>>2]=j;v[j+4>>2]=v[j+4>>2]+1;j=v[111924];v[111924]=0;if((j|0)==1){break cb}v[111924]=0;j=N(1122,i|0,448956)|0;i=v[111924];v[111924]=0;ib:{if((i|0)!=1){i=v[v[j>>2]+28>>2];v[111924]=0;k=N(i|0,j|0,10)|0;j=v[111924];v[111924]=0;if((j|0)!=1){break ib}}d=T(371012)|0;f=vb;e=v[g+276>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}break bb}j=v[g+276>>2];i=v[j+4>>2]-1|0;v[j+4>>2]=i;if((i|0)==-1){zb[v[v[j>>2]+8>>2]](j)}v[111924]=0;N(2270,d|0,k|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break cb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break cb}d=v[a+1632>>2];j=v[v[d>>2]+8>>2];v[111924]=0;O(j|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break cb}}l=_}_=l;d=v[v[a>>2]+428>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){j=c;break A}if(A[a+952>>3]>=h){d=v[v[a>>2]+432>>2];j=0;v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+452>>2];v[111924]=0;h=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break B}jb:{kb:{lb:{d=v[a+1632>>2];mb:{nb:{if(!d){break nb}c=v[d+4>>2];if((c|0)<5){break nb}v[g+104>>2]=c;v[g+100>>2]=5;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break mb}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250768,16)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250454,9)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[a>>2]+428>>2];v[111924]=0;l=+aa(c|0,a|0);c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Z(2412,c|0,+l)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,251442,12)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];l=A[a+696>>3];v[111924]=0;Z(2412,c|0,+l)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;j=g+280|0;c=v[(c+d|0)+28>>2];v[j>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break mb}v[111924]=0;c=N(1122,j|0,448956)|0;j=v[111924];v[111924]=0;ob:{if((j|0)!=1){j=v[v[c>>2]+28>>2];v[111924]=0;i=N(j|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break ob}}d=T(371012)|0;f=vb;c=v[g+280>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}j=0;break z}c=v[g+280>>2];j=v[c+4>>2]-1|0;v[c+4>>2]=j;if((j|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,i|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break mb}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)==1){break mb}}pb:{if(!e){break pb}d=v[v[a>>2]+428>>2];v[111924]=0;l=+aa(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break B}if(!(A[a+696>>3]>=h+l)){break pb}if(v[a+632>>2]==1){v[a+632>>2]=0}j=0;if(v[a+496>>2]==3){break C}break D}if((z|0)<3){break jb}l=A[a+1376>>3];qb:{rb:{if(l==0){break rb}h=A[a+1384>>3];if(h==0){break rb}m=A[a+1392>>3];if(m!=0){break qb}}v[111924]=0;tL(a);d=v[111924];v[111924]=0;if((d|0)==1){break B}m=A[a+1392>>3];h=A[a+1384>>3];l=A[a+1376>>3]}h=h<l?l:h;if(!((h>m?h:m)>=1e9)){break kb}d=v[a+1632>>2];c=v[d+4>>2];e=v[v[d+8>>2]+(c<<2)>>2];j=v[e>>2]-12|0;v[(v[j>>2]+e|0)+8>>2]=0;e=e+v[j>>2]|0;v[e+4>>2]=v[e+4>>2]&-261|256;if((c|0)<3){break lb}v[g+104>>2]=c;v[g+100>>2]=3;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break mb}d=v[a+1632>>2];c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,211954,60)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250162,15)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1376>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250146,15)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1384>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,250131,14)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+1392>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,244093,1)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];c=v[v[d>>2]-12>>2];v[111924]=0;e=g+284|0;c=v[(c+d|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break mb}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;sb:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;j=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break sb}}d=T(371012)|0;f=vb;c=v[g+284>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}j=0;break z}c=v[g+284>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,d|0,j|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break mb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break mb}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)!=1){break lb}}d=T(371012)|0;f=vb;j=0;break z}if(v[a+632>>2]==1){v[a+632>>2]=0}j=0;if(v[a+496>>2]!=3){break D}break C}v[a+632>>2]=-8;c=Ub(16);v[111924]=0;e=N(2255,g+24|0,102090)|0;d=v[111924];v[111924]=0;tb:{if((d|0)!=1){v[c>>2]=371744;d=c+4|0;ub:{vb:{if(t[g+35|0]>=0){j=v[e+4>>2];v[d>>2]=v[e>>2];v[d+4>>2]=j;v[d+8>>2]=v[e+8>>2];break vb}j=v[e>>2];v[111924]=0;R(2167,d|0,j|0,v[g+28>>2]);d=v[111924];v[111924]=0;n=1;if((d|0)==1){break ub}}v[c>>2]=373428;n=0;v[111924]=0;R(2152,c|0,373408,2256);d=v[111924];v[111924]=0;if((d|0)!=1){break e}}d=T(371012)|0;f=vb;if(t[g+35|0]<0){Gb(v[e>>2])}j=0;if(n){break tb}break z}d=T(371012)|0;f=vb}ac(c);j=0;break z}z=z+1|0;c=0}j=c;v[111924]=0;O(2423,a|0,-1);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[v[a>>2]+464>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+568>>2];c=v[a+1360>>2];e=v[v[c>>2]+24>>2];v[111924]=0;O(e|0,c|0,d|0);d=v[111924];v[111924]=0;if((d|0)==1){break A}d=v[a+568>>2];c=v[a+1364>>2];e=v[v[c>>2]+32>>2];v[111924]=0;O(e|0,c|0,d|0);c=v[111924];v[111924]=0;d=0;if((c|0)!=1){break x}break A}d=T(371012)|0;f=vb}j=c;break z}v[a+496>>2]=3}v[a+632>>2]=1;f=0;d=0;break x}j=0}d=T(371012)|0;f=vb}wb:{xb:{if((Y(371012)|0)!=(f|0)){break xb}d=X(d|0)|0;yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{if(!(v[a+632>>2]!=-4|fa)){Gb:{E=v[a+568>>2];if((E|0)==-1){A[a+688>>3]=A[a+688>>3]*.01;d=v[a+1632>>2];if(!d){break Gb}c=v[d+4>>2];if((c|0)<4){break Gb}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break Db}d=v[a+1632>>2];v[111924]=0;d=N(2345,d|0,248629)|0;c=v[111924];v[111924]=0;Hb:{if((c|0)==1){break Hb}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+688>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Hb}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;S(2260,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Hb}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)!=1){break Gb}}d=M()|0;break yb}A[a+696>>3]=A[a+696>>3]*.01;d=v[a+1632>>2];if(!d){break Gb}c=v[d+4>>2];if((c|0)<4){break Gb}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break Cb}d=v[a+1632>>2];v[111924]=0;d=N(2345,d|0,248629)|0;c=v[111924];v[111924]=0;Ib:{if((c|0)==1){break Ib}c=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];h=A[a+696>>3];v[111924]=0;Z(2412,c|0,+h)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ib}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;S(2260,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Ib}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)!=1){break Gb}}d=M()|0;break yb}d=v[a+416>>2];c=v[v[a>>2]+348>>2];v[111924]=0;O(c|0,a|0,ja|0);c=v[111924];v[111924]=0;if((c|0)==1){break Eb}v[a+416>>2]=d;d=v[v[a>>2]+464>>2];v[111924]=0;U(d|0,a|0);d=v[111924];v[111924]=0;if((d|0)!=1){d=v[a+568>>2];c=v[a+1364>>2];e=v[v[c>>2]+32>>2];v[111924]=0;O(e|0,c|0,d|0);d=v[111924];v[111924]=0;if((d|0)!=1){break Fb}}d=T(371012)|0;if((vb|0)!=(f|0)){break yb}b=X(d|0)|0;Jb:{d=v[a+1632>>2];if(!d){break Jb}c=v[d+4>>2];if((c|0)<4){break Jb}v[g+104>>2]=c;v[g+100>>2]=4;c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+100|0);d=v[111924];v[111924]=0;if((d|0)==1){break Bb}d=v[a+1632>>2];v[111924]=0;d=N(2345,d|0,56551)|0;c=v[111924];v[111924]=0;Kb:{if((c|0)==1){break Kb}d=v[v[d+8>>2]+(v[d+4>>2]<<2)>>2];v[111924]=0;S(2260,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Kb}d=v[a+1632>>2];c=v[v[d>>2]+8>>2];v[111924]=0;O(c|0,d|0,g+104|0);d=v[111924];v[111924]=0;if((d|0)!=1){break Jb}}d=M()|0;break zb}d=((E|0)==-1?688:696)+a|0;A[d>>3]=A[d>>3]*100;d=v[a+568>>2];a=v[a+1364>>2];c=v[v[a>>2]+32>>2];v[111924]=0;O(c|0,a|0,d|0);a=v[111924];v[111924]=0;Lb:{if((a|0)!=1){c=Ub(16);v[c>>2]=371744;a=c+4|0;Mb:{if(t[b+15|0]>=0){d=v[b+8>>2];v[a>>2]=v[b+4>>2];v[a+4>>2]=d;v[a+8>>2]=v[b+12>>2];break Mb}d=v[b+8>>2];b=v[b+4>>2];v[111924]=0;R(2167,a|0,b|0,d|0);a=v[111924];v[111924]=0;if((a|0)==1){break Lb}}v[111924]=0;R(2152,c|0,371012,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}d=M()|0;break zb}d=M()|0;ac(c);break zb}Nb:{Ob:{if(fa){b=((E|0)==-1?688:696)+a|0;A[b>>3]=A[b>>3]*100;b=v[a+568>>2];a=v[a+1364>>2];c=v[v[a>>2]+32>>2];v[111924]=0;O(c|0,a|0,b|0);a=v[111924];v[111924]=0;if((a|0)==1){break Ab}a=Ub(16);v[a>>2]=371744;b=a+4|0;if(t[d+15|0]>=0){c=v[d+8>>2];v[b>>2]=v[d+4>>2];v[b+4>>2]=c;v[b+8>>2]=v[d+12>>2];break Ob}c=v[d+8>>2];d=v[d+4>>2];v[111924]=0;R(2167,b|0,d|0,c|0);b=v[111924];v[111924]=0;if((b|0)!=1){break Ob}d=M()|0;ac(a);break yb}a=Ub(16);v[a>>2]=371744;b=a+4|0;if(t[d+15|0]>=0){c=v[d+8>>2];v[b>>2]=v[d+4>>2];v[b+4>>2]=c;v[b+8>>2]=v[d+12>>2];break Ob}c=v[d+8>>2];d=v[d+4>>2];v[111924]=0;R(2167,b|0,d|0,c|0);b=v[111924];v[111924]=0;if((b|0)==1){break Nb}}v[111924]=0;R(2152,a|0,371012,2256);a=v[111924];v[111924]=0;if((a|0)==1){break Ab}break e}d=M()|0;ac(a);break yb}v[a+1300>>2]=0;v[a+1304>>2]=0;v[a+724>>2]=0;v[a+632>>2]=-1;v[111924]=0;V(1128);c=v[111924];v[111924]=0;f=1;fa=1;n=0;d=0;if((c|0)!=1){break x}d=M()|0;break xb}d=M()|0;break yb}d=M()|0;break yb}d=M()|0;break yb}d=M()|0;break zb}d=M()|0;break yb}v[111924]=0;V(1128);a=v[111924];v[111924]=0;if((a|0)==1){break wb}}v[111924]=0;V(1128);a=v[111924];v[111924]=0;if((a|0)==1){break wb}}Vy(ja);P(d|0);p()}T(0)|0;md();p()}f=1;d=1}c=v[g+144>>2];if(c){Gb(c);v[g+144>>2]=0}c=v[g+120>>2];if(c){Gb(c)}if(f){continue}}break}if(fa){b=((E|0)==-1?688:696)+a|0;A[b>>3]=A[b>>3]*100;b=v[a+1364>>2];zb[v[v[b>>2]+32>>2]](b,v[a+568>>2])}b=v[a+584>>2];+zb[v[v[b>>2]+16>>2]](b);b=v[a+584>>2];A[a+592>>3]=+zb[v[v[b>>2]+24>>2]](b)+A[a+592>>3];if(v[a+632>>2]==-1){v[a+632>>2]=-15;d=Ub(16);v[111924]=0;b=N(2255,g+112|0,127931)|0;a=v[111924];v[111924]=0;if((a|0)==1){break q}v[d>>2]=371744;a=d+4|0;Pb:{Qb:{if(t[b+11|0]>=0){c=v[b+4>>2];v[a>>2]=v[b>>2];v[a+4>>2]=c;v[a+8>>2]=v[b+8>>2];break Qb}c=v[b+4>>2];e=v[b>>2];v[111924]=0;R(2167,a|0,e|0,c|0);a=v[111924];v[111924]=0;f=1;if((a|0)==1){break Pb}}v[d>>2]=373428;f=0;v[111924]=0;R(2152,d|0,373408,2256);a=v[111924];v[111924]=0;if((a|0)!=1){break e}}a=M()|0;if(t[b+11|0]<0){Gb(v[b>>2])}if(!f){break a}break c}b=v[a+1632>>2];Rb:{if(!b){break Rb}d=v[b+4>>2];if((d|0)<5){break Rb}v[g+104>>2]=d;v[g+112>>2]=5;zb[v[v[b>>2]+8>>2]](b,g+112|0);b=v[a+1632>>2];Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],200871,25);f=v[a+632>>2];Sb:{if(f+15>>>0<12){break Sb}Tb:{switch(f+2|0){default:f=-15;break Sb;case 0:case 1:case 3:break Sb;case 2:break Tb}}f=-15;d=v[a+496>>2]+2|0;if(d>>>0>=8){break Sb}f=v[(d<<2)+384580>>2]}pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],f);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],200897,8);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[a+416>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],201e3,8);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[a+1300>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],200954,8);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[a+1304>>2]);Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],200906,8);pd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],v[a+1320>>2]);Ub:{Vb:{Wb:{b=v[a+632>>2];if(b+15>>>0<11){break Wb}Xb:{switch(b+2|0){case 0:case 1:case 3:break Wb;case 2:break Xb;default:break Ub}}if(v[a+496>>2]==3){break Vb}break Ub}if((b|0)!=1){break Ub}}b=v[a+1632>>2];Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],201009,11);h=+zb[v[v[a>>2]+372>>2]](a);qd(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],h)}b=v[a+1632>>2];Nb(v[v[b+8>>2]+(v[b+4>>2]<<2)>>2],244093,1);c=g+112|0;b=v[v[b+8>>2]+(v[b+4>>2]<<2)>>2];d=v[(v[v[b>>2]-12>>2]+b|0)+28>>2];v[c>>2]=d;v[d+4>>2]=v[d+4>>2]+1;v[111924]=0;d=N(1122,c|0,448956)|0;c=v[111924];v[111924]=0;Yb:{if((c|0)!=1){c=v[v[d>>2]+28>>2];v[111924]=0;e=N(c|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break Yb}}break b}d=v[g+112>>2];c=v[d+4>>2]-1|0;v[d+4>>2]=c;if((c|0)==-1){zb[v[v[d>>2]+8>>2]](d)}bc(b,e);$b(b);b=v[a+1632>>2];zb[v[v[b>>2]+8>>2]](b,g+104|0)}v[a+1308>>2]=v[(v[a+576>>2]==1?1304:1300)+a>>2];zb[v[v[a>>2]+400>>2]](a,1,0);e=ub-96|0;ub=e;Zb:{_b:{$b:{ac:{bc:{cc:{c=a;b=v[c+600>>2];if((b|0)<0|(b|0)>v[c+416>>2]){break cc}v[c+620>>2]=v[c+620>>2]+1;if(A[48091]<=A[c+608>>3]){break bc}dc:{if(v[c+620>>2]>=200){a=v[c+616>>2];if((a|0)>0){break dc}}a=v[c+584>>2];h=+zb[v[v[a>>2]+24>>2]](a);l=A[c+608>>3];if(h>=l){break cc}v[c+616>>2]=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break bc}v[c+616>>2]=a-1;break bc}if(!v[c+580>>2]){break bc}ec:{switch(v[c+632>>2]){case 0:if(v[c+496>>2]!=3){break bc}break;case 1:break ec;default:break bc}}f=v[c+536>>2];n=v[c+512>>2];v[e+48>>2]=0;v[e+52>>2]=-1;a=v[c+1632>>2];fc:{if(!a){break fc}b=v[a+4>>2];if((b|0)<4){break fc}v[e+8>>2]=b;v[e+28>>2]=4;b=e+28|0;zb[v[v[a>>2]+8>>2]](a,b);a=v[c+1632>>2];Nb(v[v[a+8>>2]+(v[a+4>>2]<<2)>>2],103964,31);a=v[v[a+8>>2]+(v[a+4>>2]<<2)>>2];d=v[(v[v[a>>2]-12>>2]+a|0)+28>>2];v[b>>2]=d;v[d+4>>2]=v[d+4>>2]+1;v[111924]=0;b=N(1122,b|0,448956)|0;d=v[111924];v[111924]=0;gc:{if((d|0)!=1){d=v[v[b>>2]+28>>2];v[111924]=0;j=N(d|0,b|0,10)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break gc}}break $b}b=v[e+28>>2];d=v[b+4>>2]-1|0;v[b+4>>2]=d;if((d|0)==-1){zb[v[v[b>>2]+8>>2]](b)}bc(a,j);$b(a);a=v[c+1632>>2];zb[v[v[a>>2]+8>>2]](a,e+8|0)}hc:{ic:{jc:{kc:{lc:{if(v[c+576>>2]==1){LD(c,-1);zb[v[v[c>>2]+464>>2]](c);t[c+792|0]=0;a=v[c+1364>>2];zb[v[v[a>>2]+32>>2]](a,v[c+568>>2]);if(v[c+580>>2]==1){a=v[c+184>>2];i=v[c+40>>2];j=Hy(e+28|0,i);v[111924]=0;k=N(2375,e+8|0,a|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break jc}if((i|0)<=0){break ic}d=0;while(1){mc:{nc:{oc:{switch(v[n+(d<<2)>>2]+4|0){case 0:case 2:break oc;default:break nc}}h=A[v[v[c+1204>>2]>>2]+(d<<3)>>3];v[111924]=0;l=A[53482];b=v[111924];v[111924]=0;if((b|0)==1){break mc}m=h;h=D(h);h=h>0?h:0;if(!(D(m/(h>1?h:1))<=l)){break nc}b=v[j+4>>2];if((b|0)>=v[j+8>>2]){v[111924]=0;O(2363,j|0,b+1|0);b=v[111924];v[111924]=0;if((b|0)==1){break mc}b=v[j+4>>2]}v[j+4>>2]=b+1;v[v[j+12>>2]+(b<<2)>>2]=d}d=d+1|0;if((i|0)!=(d|0)){continue}break ic}break}break ac}j=Hy(e+28|0,v[v[c+868>>2]+40>>2]);if(v[c+184>>2]<=0){break lc}a=0;while(1){pc:{qc:{rc:{switch(v[f+(a<<2)>>2]+4|0){case 0:case 2:break rc;default:break qc}}b=a<<3;h=A[b+v[c+248>>2]>>3];l=A[b+v[v[c+1208>>2]>>2]>>3];v[111924]=0;m=A[53482];b=v[111924];v[111924]=0;if((b|0)==1){break pc}l=h-l;h=D(l);h=h>0?h:0;if(!(D(l/(h>1?h:1))<=m)){break qc}k=v[j+4>>2];if((k|0)>=v[j+8>>2]){v[111924]=0;O(2363,j|0,k+1|0);b=v[111924];v[111924]=0;if((b|0)==1){break pc}k=v[j+4>>2]}v[j+4>>2]=k+1;v[v[j+12>>2]+(k<<2)>>2]=a}a=a+1|0;if((a|0)<v[c+184>>2]){continue}break lc}break}break kc}d=c+536|0;LD(c,1);zb[v[v[c>>2]+464>>2]](c);t[c+772|0]=0;a=v[c+1364>>2];zb[v[v[a>>2]+32>>2]](a,v[c+568>>2]);i=v[c+1640>>2];n=v[c+184>>2];sc:{tc:{if(v[c+580>>2]==1){f=Hy(e+28|0,v[v[c+868>>2]+40>>2]);if(v[v[c+868>>2]+40>>2]<=0){break tc}j=c+512|0;o=c+24|0;z=c+168|0;a=0;while(1){uc:{r=a<<3;k=r+v[c+336>>2]|0;b=v[k>>2];k=v[k+4>>2];v[e+48>>2]=b;v[e+52>>2]=k;vc:{wc:{if(b&-2147483648){v[111924]=0;k=N(2341,o|0,e+48|0)|0;q=v[111924];v[111924]=0;b=j;if((q|0)!=1){break wc}break sc}if((i|0)!=(n|0)){break vc}v[111924]=0;k=e+48|0;q=v[k+4>>2];b=e+8|0;v[b>>2]=v[k>>2];v[b+4>>2]=q;v[b>>2]=1;q=v[111924];v[111924]=0;if((q|0)==1){break uc}v[111924]=0;b=N(2341,z|0,b|0)|0;q=v[111924];v[111924]=0;if((q|0)==1){break uc}if(v[v[c+1648>>2]+(b<<2)>>2]==1){break vc}v[111924]=0;k=N(2341,c+(v[e+48>>2]>0?168:24)|0,k|0)|0;q=v[111924];v[111924]=0;b=d;if((q|0)==1){break sc}}if((v[v[b>>2]+(k<<2)>>2]&-3)!=-4){break vc}h=A[r+v[v[c+1196>>2]>>2]>>3];v[111924]=0;l=A[53482];b=v[111924];v[111924]=0;if((b|0)==1){break sc}m=h;h=D(h);h=h>0?h:0;if(!(D(m/(h>1?h:1))<=l)){break vc}b=v[f+4>>2];if((b|0)>=v[f+8>>2]){v[111924]=0;O(2363,f|0,b+1|0);b=v[111924];v[111924]=0;if((b|0)==1){break sc}b=v[f+4>>2]}v[f+4>>2]=b+1;v[v[f+12>>2]+(b<<2)>>2]=a}a=a+1|0;if((a|0)<v[v[c+868>>2]+40>>2]){continue}break tc}break}break sc}j=Hy(e+28|0,v[v[c+868>>2]+40>>2]);xc:{if(v[v[c+868>>2]+40>>2]>0){f=c+168|0;a=0;while(1){k=a<<3;o=k+v[c+336>>2]|0;b=v[o>>2];o=v[o+4>>2];v[e+48>>2]=b;v[e+52>>2]=o;yc:{if(b&-2147483648){break yc}if((i|0)==(n|0)){v[111924]=0;o=v[e+52>>2];b=e+8|0;v[b>>2]=v[e+48>>2];v[b+4>>2]=o;v[b>>2]=1;o=v[111924];v[111924]=0;if((o|0)==1){break xc}v[111924]=0;b=N(2341,f|0,b|0)|0;o=v[111924];v[111924]=0;if((o|0)==1){break xc}if(!v[v[c+1648>>2]+(b<<2)>>2]){break yc}}if((v[v[d>>2]+(a<<2)>>2]&-3)!=-4){break yc}h=A[k+v[v[c+1196>>2]>>2]>>3];v[111924]=0;l=A[53482];b=v[111924];v[111924]=0;zc:{if((b|0)==1){break zc}m=h;h=D(h);h=h>0?h:0;if(!(l>=D(m/(h>1?h:1)))){break yc}b=v[j+4>>2];if((b|0)>=v[j+8>>2]){v[111924]=0;O(2363,j|0,b+1|0);b=v[111924];v[111924]=0;if((b|0)==1){break zc}b=v[j+4>>2]}v[j+4>>2]=b+1;v[v[j+12>>2]+(b<<2)>>2]=a;break yc}break xc}a=a+1|0;if((a|0)<v[v[c+868>>2]+40>>2]){continue}break}}Ac:{a=v[j+4>>2];Bc:{if((a|0)<=0){break Bc}k=0;while(1){d=a-1|0;f=d<<2;b=v[f+v[j+12>>2]>>2];v[111924]=0;i=Q(2425,c|0,b|0,1)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ac}b=v[v[c>>2]+536>>2];v[111924]=0;U(b|0,c|0);b=v[111924];v[111924]=0;if((b|0)==1){break Ac}b=0;Cc:{if(!i){break Cc}b=v[j+4>>2]-1|0;v[j+4>>2]=b;i=f;f=v[j+12>>2];v[i+f>>2]=v[f+(b<<2)>>2];k=k+1|0;f=v[c+600>>2];b=0;if((f|0)<0){break Cc}b=(f|0)<=v[c+416>>2]}v[c+620>>2]=v[c+620>>2]+1;if(!(A[48091]<=A[c+608>>3])){Dc:{Ec:{if(v[c+620>>2]>=200){f=v[c+616>>2];if((f|0)>0){break Ec}}f=v[c+584>>2];i=v[v[f>>2]+24>>2];v[111924]=0;h=+aa(i|0,f|0);f=v[111924];v[111924]=0;if((f|0)==1){break Ac}l=A[c+608>>3];if(l<=h){v[c+1312>>2]=v[c+1312>>2]+k;break Bc}f=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break Dc}f=f-1|0}v[c+616>>2]=f}f=a>>>0<2;a=d;if(!(b|f)){continue}v[c+1312>>2]=v[c+1312>>2]+k;if(b|!k){break Bc}k=0;a=v[j+4>>2];if((a|0)>0){continue}break}}Lf(j);break hc}}a=M()|0;break _b}Fc:{a=v[f+4>>2];Gc:{if((a|0)<=0){break Gc}k=0;while(1){d=a-1|0;j=d<<2;b=v[j+v[f+12>>2]>>2];v[111924]=0;i=Q(2425,c|0,b|0,1)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Fc}b=v[v[c>>2]+536>>2];v[111924]=0;U(b|0,c|0);b=v[111924];v[111924]=0;if((b|0)==1){break Fc}b=0;Hc:{if(!i){break Hc}b=v[f+4>>2]-1|0;v[f+4>>2]=b;i=j;j=v[f+12>>2];v[i+j>>2]=v[j+(b<<2)>>2];k=k+1|0;j=v[c+600>>2];b=0;if((j|0)<0){break Hc}b=(j|0)<=v[c+416>>2]}v[c+620>>2]=v[c+620>>2]+1;if(!(A[48091]<=A[c+608>>3])){Ic:{Jc:{if(v[c+620>>2]>=200){j=v[c+616>>2];if((j|0)>0){break Jc}}j=v[c+584>>2];i=v[v[j>>2]+24>>2];v[111924]=0;h=+aa(i|0,j|0);j=v[111924];v[111924]=0;if((j|0)==1){break Fc}l=A[c+608>>3];if(l<=h){v[c+1312>>2]=v[c+1312>>2]+k;break Gc}j=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break Ic}j=j-1|0}v[c+616>>2]=j}j=a>>>0<2;a=d;if(!(b|j)){continue}v[c+1312>>2]=v[c+1312>>2]+k;if(b|!k){break Gc}k=0;a=v[f+4>>2];if((a|0)>0){continue}break}}Lf(f);break hc}}a=M()|0;Lf(f);break a}Kc:{a=v[j+4>>2];Lc:{if((a|0)<=0){break Lc}k=0;while(1){d=a-1|0;f=d<<2;b=v[f+v[j+12>>2]>>2];Mc:{if(v[c+576>>2]==-1){b=v[c+28>>2]+(b<<3)|0;i=v[b>>2];b=v[b+4>>2];v[111924]=0;v[e+8>>2]=i;v[e+12>>2]=b;b=v[e+12>>2];v[e+88>>2]=v[e+8>>2];v[e+92>>2]=b;v[e+88>>2]=-1;b=v[111924];v[111924]=0;if((b|0)==1){break Kc}n=-1;b=v[e+92>>2];break Mc}b=v[c+172>>2]+(b<<3)|0;i=v[b>>2];b=v[b+4>>2];v[111924]=0;v[e+8>>2]=i;v[e+12>>2]=b;b=v[e+12>>2];v[e+80>>2]=v[e+8>>2];v[e+84>>2]=b;v[e+80>>2]=1;b=v[111924];v[111924]=0;if((b|0)==1){break Kc}n=1;b=v[e+84>>2]}v[111924]=0;v[e+48>>2]=n;v[e+52>>2]=b;i=Q(2420,c|0,e+48|0,1)|0;b=v[111924];v[111924]=0;if((b|0)==1){break kc}b=v[v[c>>2]+536>>2];v[111924]=0;U(b|0,c|0);b=v[111924];v[111924]=0;if((b|0)==1){break kc}b=0;Nc:{if(!i){break Nc}b=v[j+4>>2]-1|0;v[j+4>>2]=b;i=f;f=v[j+12>>2];v[i+f>>2]=v[f+(b<<2)>>2];k=k+1|0;f=v[c+600>>2];b=0;if((f|0)<0){break Nc}b=(f|0)<=v[c+416>>2]}v[c+620>>2]=v[c+620>>2]+1;Oc:{if(A[48091]<=A[c+608>>3]){break Oc}Pc:{Qc:{if(v[c+620>>2]>=200){f=v[c+616>>2];if((f|0)>0){break Qc}}f=v[c+584>>2];i=v[v[f>>2]+24>>2];v[111924]=0;h=+aa(i|0,f|0);f=v[111924];v[111924]=0;if((f|0)==1){break kc}l=A[c+608>>3];if(l<=h){v[c+1312>>2]=v[c+1312>>2]+k;break Lc}f=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break Pc}f=f-1|0}v[c+616>>2]=f}f=a>>>0<2;a=d;if(!(b|f)){continue}v[c+1312>>2]=v[c+1312>>2]+k;if(b|!k){break Lc}k=0;a=v[j+4>>2];if((a|0)>0){continue}break}}Lf(j);break hc}}a=M()|0;break _b}a=M()|0;break _b}if(!((a|0)!=v[c+1640>>2]|(a|0)<=0)){d=0;while(1){Rc:{Sc:{b=d<<2;switch(v[b+f>>2]+4|0){case 0:case 2:break Sc;default:break Rc}}i=d<<3;h=A[i+v[c+248>>2]>>3];l=A[i+v[v[c+1208>>2]>>2]>>3];v[111924]=0;m=A[53482];i=v[111924];v[111924]=0;if((i|0)==1){break ac}l=h-l;h=D(l);h=h>0?h:0;if(v[b+v[c+1648>>2]>>2]|!(D(l/(h>1?h:1))<=m)){break Rc}b=v[k+4>>2];if((b|0)>=v[k+8>>2]){v[111924]=0;O(2363,k|0,b+1|0);b=v[111924];v[111924]=0;if((b|0)==1){break ac}b=v[k+4>>2]}v[k+4>>2]=b+1;v[v[k+12>>2]+(b<<2)>>2]=d}d=d+1|0;if((a|0)!=(d|0)){continue}break}}while(1){Tc:{f=0;d=0;Uc:{Vc:{b=v[j+4>>2];if((b|0)>0){while(1){i=b-1|0;o=i<<2;a=v[o+v[j+12>>2]>>2];Wc:{if(v[c+576>>2]==-1){a=v[c+172>>2]+(a<<3)|0;d=v[a>>2];a=v[a+4>>2];v[111924]=0;v[e+88>>2]=d;v[e+92>>2]=a;d=v[e+92>>2];a=e- -64|0;v[a>>2]=v[e+88>>2];v[a+4>>2]=d;v[a>>2]=1;a=v[111924];v[111924]=0;if((a|0)==1){break ac}n=1;a=v[e+68>>2];break Wc}a=v[c+28>>2]+(a<<3)|0;d=v[a>>2];a=v[a+4>>2];v[111924]=0;v[e+88>>2]=d;v[e+92>>2]=a;a=v[e+92>>2];v[e+56>>2]=v[e+88>>2];v[e+60>>2]=a;v[e+56>>2]=-1;a=v[111924];v[111924]=0;if((a|0)==1){break ac}n=-1;a=v[e+60>>2]}v[111924]=0;v[e+48>>2]=n;v[e+52>>2]=a;a=Q(2420,c|0,e+48|0,1)|0;d=v[111924];v[111924]=0;if((d|0)==1){break ac}d=v[v[c>>2]+536>>2];v[111924]=0;U(d|0,c|0);d=v[111924];v[111924]=0;if((d|0)==1){break ac}d=0;Xc:{if(!a){break Xc}a=v[j+4>>2]-1|0;v[j+4>>2]=a;d=v[j+12>>2];v[d+o>>2]=v[d+(a<<2)>>2];f=f+1|0;a=v[c+600>>2];d=0;if((a|0)<0){break Xc}d=(a|0)<=v[c+416>>2]}v[c+620>>2]=v[c+620>>2]+1;Yc:{if(A[48091]<=A[c+608>>3]){break Yc}Zc:{_c:{if(v[c+620>>2]>=200){a=v[c+616>>2];if((a|0)>0){break _c}}a=v[c+584>>2];n=v[v[a>>2]+24>>2];v[111924]=0;h=+aa(n|0,a|0);a=v[111924];v[111924]=0;if((a|0)==1){break ac}l=A[c+608>>3];if(l<=h){break Vc}a=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break Zc}a=a-1|0}v[c+616>>2]=a}a=b>>>0<2;b=i;if(!(a|d)){continue}break}}b=v[k+4>>2];if(d|(b|0)<=0){break Uc}while(1){i=b-1|0;o=i<<2;a=v[o+v[k+12>>2]>>2];$c:{if(v[c+576>>2]==-1){a=v[c+28>>2]+(a<<3)|0;d=v[a>>2];a=v[a+4>>2];v[111924]=0;v[e+88>>2]=d;v[e+92>>2]=a;a=v[e+92>>2];v[e+80>>2]=v[e+88>>2];v[e+84>>2]=a;v[e+80>>2]=-1;a=v[111924];v[111924]=0;if((a|0)==1){break ac}n=-1;a=v[e+84>>2];break $c}a=v[c+172>>2]+(a<<3)|0;d=v[a>>2];a=v[a+4>>2];v[111924]=0;v[e+88>>2]=d;v[e+92>>2]=a;a=v[e+92>>2];v[e+72>>2]=v[e+88>>2];v[e+76>>2]=a;v[e+72>>2]=1;a=v[111924];v[111924]=0;if((a|0)==1){break ac}n=1;a=v[e+76>>2]}v[111924]=0;v[e+48>>2]=n;v[e+52>>2]=a;a=Q(2420,c|0,e+48|0,1)|0;d=v[111924];v[111924]=0;if((d|0)==1){break ac}d=v[v[c>>2]+536>>2];v[111924]=0;U(d|0,c|0);d=v[111924];v[111924]=0;if((d|0)==1){break ac}d=0;ad:{if(!a){break ad}a=v[k+4>>2]-1|0;v[k+4>>2]=a;d=v[k+12>>2];v[d+o>>2]=v[d+(a<<2)>>2];f=f+1|0;a=v[c+600>>2];d=0;if((a|0)<0){break ad}d=(a|0)<=v[c+416>>2]}v[c+620>>2]=v[c+620>>2]+1;bd:{if(A[48091]<=A[c+608>>3]){break bd}cd:{dd:{if(v[c+620>>2]>=200){a=v[c+616>>2];if((a|0)>0){break dd}}a=v[c+584>>2];n=v[v[a>>2]+24>>2];v[111924]=0;h=+aa(n|0,a|0);a=v[111924];v[111924]=0;if((a|0)==1){break ac}l=A[c+608>>3];if(l<=h){break Vc}a=!((l-h)*.01/((h+A[c+592>>3])/+v[c+620>>2]+1e-6)<32)<<5;break cd}a=a-1|0}v[c+616>>2]=a}a=b>>>0<2;b=i;if(!(a|d)){continue}break}break Uc}v[c+1312>>2]=v[c+1312>>2]+f;break Tc}v[c+1312>>2]=v[c+1312>>2]+f;if(!f){break Tc}if(!d){continue}}break}Lf(k);Lf(j)}a=v[c+1632>>2];ed:{if(!a){break ed}b=v[a+4>>2];if((b|0)<3){break ed}v[e+4>>2]=b;v[e+28>>2]=3;b=e+28|0;zb[v[v[a>>2]+8>>2]](a,b);a=v[c+1632>>2];Nb(v[v[a+8>>2]+(v[a+4>>2]<<2)>>2],244525,34);pd(v[v[a+8>>2]+(v[a+4>>2]<<2)>>2],v[c+1312>>2]);Nb(v[v[a+8>>2]+(v[a+4>>2]<<2)>>2],221949,8);a=v[v[a+8>>2]+(v[a+4>>2]<<2)>>2];d=v[(v[v[a>>2]-12>>2]+a|0)+28>>2];v[b>>2]=d;v[d+4>>2]=v[d+4>>2]+1;v[111924]=0;b=N(1122,b|0,448956)|0;d=v[111924];v[111924]=0;fd:{if((d|0)!=1){d=v[v[b>>2]+28>>2];v[111924]=0;j=N(d|0,b|0,10)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break fd}}break $b}b=v[e+28>>2];d=v[b+4>>2]-1|0;v[b+4>>2]=d;if((d|0)==-1){zb[v[v[b>>2]+8>>2]](b)}bc(a,j);$b(a);a=v[c+1632>>2];zb[v[v[a>>2]+8>>2]](a,e+4|0)}if(v[c+496>>2]==3){break bc}v[c+496>>2]=3}ub=e+96|0;break Zb}a=M()|0;Lf(k);break _b}a=M()|0;b=v[e+28>>2];d=v[b+4>>2]-1|0;v[b+4>>2]=d;if((d|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break a}Lf(j);break a}d=v[c+632>>2];if(d+15>>>0<12){break r}gd:{switch(d+2|0){default:d=-15;break r;case 0:case 1:case 3:break r;case 2:break gd}}d=-15;a=v[c+496>>2]+2|0;if(a>>>0>=8){break r}d=v[(a<<2)+384580>>2]}ub=g+288|0;return d|0}a=M()|0;break c}break d}break d}break d}p()}a=M()|0}ac(d);break a}a=M()|0;b=v[g+112>>2];d=v[b+4>>2]-1|0;v[b+4>>2]=d;if((d|0)==-1){zb[v[v[b>>2]+8>>2]](b)}}P(a|0);p()}function Me(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,z=0,C=0,E=0,G=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,vb=0,wb=0,xb=0,Ab=0,Bb=0,Cb=0;u=ub-352|0;ub=u;h=1;b=v[a+4>>2];a:{if(v[b>>2]==10){break a}d=v[a+24>>2];if(v[d+896>>2]-11>>>0<=3){jc(a,296809,0);break a}if(!TE(b,d)){Eb(157826,2660);Fb(287275,0);h=-11;break a}b:{if((hd(a)|0)<0){if((ke(a)|0)<0){break b}}if(tc(a,92798)){break b}jc(a,287150,0)}v[v[a+24>>2]+1380>>2]=0;c:{b=v[a+4>>2];if(v[b>>2]!=1|v[v[a+36>>2]+12>>2]<=0|!v[b+1476>>2]){break c}c=v[b+340>>2];if(c){break c}j=ub-16|0;ub=j;d=1;d:{if((c|0)>0){ic(a,3,0,327010,0);break d}z=WE(b,17981);if(!z){Eb(147650,1055);d=0;Fb(205393,0);break d}n=ub-1488|0;ub=n;l=v[a+4>>2];f=v[v[v[a+36>>2]+4>>2]>>2];h=v[f+44>>2];C=Ib(v[v[v[l+4>>2]>>2]+8>>2],h,4,147666,5612);v[n+1464>>2]=C;e:{f:{if(C){if((h|0)>0){while(1){g:{i=q<<2;b=Gf(i+C|0);c=5619;h:{if((b|0)!=1){break h}C=v[n+1464>>2];i=i+C|0;b=$z(v[l+4>>2],v[i>>2],1,1,1,1,1,1,1,1,1,1,1,n+1484|0);c=5623;if((b|0)!=1){break h}b=v[v[v[l+4>>2]+28>>2]+32>>2];v[n+404>>2]=q;v[n+400>>2]=b;b=n+416|0;Jb(b,1024,139565,n+400|0);b=Tz(v[i>>2],b);if((b|0)==1){break g}c=5626}Eb(147700,c);v[n+384>>2]=b;Fb(276579,n+384|0);break e}q=q+1|0;if((h|0)!=(q|0)){continue}break}}b=gd(v[l+4>>2],n+1460|0,n+1444|0,0,0,0,0);if((b|0)!=1){Eb(147700,5632);v[n+368>>2]=b;Fb(276579,n+368|0);break e}k=Fm(v[l+4>>2]);c=ef(v[l+4>>2]);N=Ib(v[v[v[l+4>>2]>>2]+8>>2],v[n+1444>>2],4,147666,5637);v[n+1452>>2]=N;if(!N){Eb(147700,5637);b=-1;v[n+16>>2]=-1;Fb(276579,n+16|0);break e}R=Ib(v[v[v[l+4>>2]>>2]+8>>2],c,4,147666,5638);v[n+1448>>2]=R;if(!R){Eb(147700,5638);b=-1;v[n+32>>2]=-1;Fb(276579,n+32|0);break e}Ln(f,v[n+1460>>2],N,v[n+1444>>2]);Ap(f,k,R,c);K=Ib(v[v[v[l+4>>2]>>2]+8>>2],h,4,147666,5645);v[n+1456>>2]=K;if(!K){break f}q=0;if((h|0)>0){while(1){b=q<<2;b=Ic(b+K|0,v[v[v[b+C>>2]>>2]+4>>2],v[n+1444>>2]);if((b|0)!=1){Eb(147700,5649);v[n+352>>2]=b;Fb(276579,n+352|0);break e}q=q+1|0;if((h|0)!=(q|0)){continue}break}}if((c|0)>0){while(1){i:{b=m<<2;f=v[b+R>>2];if((f|0)<0){break i}f=f<<2;p=v[f+K>>2];i=v[f+C>>2];g=v[l+4>>2];f=v[b+k>>2];b=Al(g,f,n+1476|0,n+1472|0);j:{if((b|0)!=1){Eb(147700,5480);v[n+336>>2]=b;Fb(276579,n+336|0);break j}J=Ib(v[v[g>>2]+8>>2],v[n+1476>>2],4,147666,5481);v[n+1480>>2]=J;if(!J){Eb(147700,5481);b=-1;v[n+80>>2]=-1;Fb(276579,n+80|0);break j}b=Bl(g,f,J,v[n+1476>>2],n+1472|0);if((b|0)==1){q=0;if(v[n+1476>>2]>0){while(1){k:{t=J+(q<<2)|0;if(cd(p,v[t>>2])){break k}b=v[t>>2];O=v[b+376>>2];ka=n+1468|0;b=Wd(i,ka,v[b+208>>2],A[b+128>>3],A[b+136>>3],A[b>>3],O>>>6&3,O&1,O>>>1&1);s=5499;l:{if((b|0)!=1){break l}b=id(i,v[n+1468>>2]);s=5502;if((b|0)!=1){break l}b=Md(p,v[t>>2],v[n+1468>>2]);s=5505;if((b|0)!=1){break l}b=Dc(i,ka);if((b|0)==1){break k}s=5508}Eb(147700,s);v[n+304>>2]=b;Fb(276579,n+304|0);break j}q=q+1|0;if((q|0)<v[n+1476>>2]){continue}break}}Hb(v[v[g>>2]+8>>2],n+1480|0,147666,5513);$=n+1484|0;q=v[f+12>>2];Z=v[f+8>>2];b=v[f+84>>2];ta=b&1;Q=b>>>1&1;V=b>>>2&1;ka=b>>>3&1;t=v[f+88>>2];s=1;m:{if(t&2){break m}s=0;if(!(b&262144)){break m}s=!(t&4)}b=zl(g,i,f,$,q,p,0,Z,ta,Q,V,ka,s,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1,1,n+1472|0);if((b|0)!=1){Eb(147700,5520);v[n+288>>2]=b;Fb(276579,n+288|0);break j}if(!v[n+1472>>2]){Eb(147700,5525);v[n+96>>2]=v[f+8>>2];Fb(341166,n+96|0);b=0;break j}b=mc(i,v[n+1484>>2]);if((b|0)!=1){Eb(147700,5530);v[n+272>>2]=b;Fb(276579,n+272|0);break j}b=ec(i,n+1484|0);if((b|0)==1){break i}Eb(147700,5531);v[n+256>>2]=b;Fb(276579,n+256|0);break j}Eb(147700,5483);v[n+320>>2]=b;Fb(276579,n+320|0)}Eb(147700,5659);v[n+64>>2]=b;Fb(276579,n- -64|0);break e}m=m+1|0;if((m|0)!=(c|0)){continue}break}}p=v[l+4>>2];q=v[n+1460>>2];m=v[n+1444>>2];g=ub-32|0;ub=g;b=1;n:{if((c|0)>0){while(1){o:{i=c;c=c-1|0;f=c<<2;if(v[f+R>>2]<0){break o}f=v[f+k>>2];if(w[f+86|0]&8){break o}f=pc(p,f);if((f|0)==1){break o}Eb(147700,5561);v[g+16>>2]=f;Fb(276579,g+16|0);b=f;break n}if(i>>>0>1){continue}break}}if(!N|!q|(v[v[p+4>>2]>>2]!=1|(m|0)<=0)){break n}while(1){p:{c=m;m=c-1|0;b=m<<2;if(v[b+N>>2]<0){break p}b=v[b+q>>2];if(w[b+376|0]&8){break p}b=t5(p,b,g+28|0);if((b|0)==1){break p}Eb(147700,5573);v[g>>2]=b;Fb(276579,g);break n}b=1;if(c>>>0>1){continue}break}}ub=g+32|0;if((b|0)!=1){Eb(147700,5664);v[n+240>>2]=b;Fb(276579,n+240|0);break e}b=yx(v[l+4>>2],C,h);if((b|0)!=1){Eb(147700,5667);v[n+224>>2]=b;Fb(276579,n+224|0);break e}v[z+304>>2]=1;b=Rc(v[l+4>>2],110285,1);if((b|0)!=1){Eb(147700,5675);v[n+208>>2]=b;Fb(276579,n+208|0);break e}b=Uf(v[l+4>>2],3,1);if((b|0)!=1){Eb(147700,5678);v[n+192>>2]=b;Fb(276579,n+192|0);break e}b=qc(v[l+4>>2],57524,0);if((b|0)!=1){Eb(147700,5679);v[n+176>>2]=b;Fb(276579,n+176|0);break e}b=qc(v[l+4>>2],13361,0);if((b|0)!=1){Eb(147700,5680);v[n+160>>2]=b;Fb(276579,n+160|0);break e}b=qc(v[l+4>>2],70815,1);if((b|0)!=1){Eb(147700,5681);v[n+144>>2]=b;Fb(276579,n+144|0);break e}b=Rc(v[l+4>>2],65939,1);if((b|0)!=1){Eb(147700,5684);v[n+128>>2]=b;Fb(276579,n+128|0);break e}b=Rc(v[l+4>>2],65960,1);if((b|0)==1){if((h|0)>0){while(1){b=h-1|0;Bc(K+(b<<2)|0);c=h>>>0>1;h=b;if(c){continue}break}}Hb(v[v[v[l+4>>2]>>2]+8>>2],n+1456|0,147666,5693);Hb(v[v[v[l+4>>2]>>2]+8>>2],n+1448|0,147666,5694);Hb(v[v[v[l+4>>2]>>2]+8>>2],n+1452|0,147666,5695);Hb(v[v[v[l+4>>2]>>2]+8>>2],n+1464|0,147666,5696);b=1;break e}Eb(147700,5685);v[n+112>>2]=b;Fb(276579,n+112|0);break e}Eb(147700,5612);b=-1;v[n>>2]=-1;Fb(276579,n);break e}Eb(147700,5645);b=-1;v[n+48>>2]=-1;Fb(276579,n+48|0)}ub=n+1488|0;if((b|0)==1){break d}Eb(147650,1063);v[j>>2]=b;Fb(276579,j);d=b}ub=j+16|0;h=d;if((d|0)==1){break c}Eb(157826,2680);v[u+304>>2]=d;Fb(276579,u+304|0);break a}Ec(v[v[a+24>>2]+792>>2],v[a+4>>2]);Ec(v[v[a+24>>2]+796>>2],v[a+4>>2]);if(v[v[a+4>>2]+1156>>2]){Laa(v[a+8>>2])}v[v[a+24>>2]+1364>>2]=0;h=T5(a);if((h|0)!=1){Eb(157826,2693);v[u+288>>2]=h;Fb(276579,u+288|0);break a}v[u+348>>2]=v[v[a+24>>2]+1368>>2];q:{r:{s:{t:{u:{v:{while(1){w:{if(!v[u+348>>2]){break w}b=v[a+104>>2];Sa=v[b+16>>2];gb=v[b+20>>2];Ta=v[b+24>>2];hb=v[b+28>>2];ib=jH(b);b=v[a+104>>2];Ua=v[b>>2];jb=v[b+4>>2];b=v[a+104>>2];Va=v[b+8>>2];kb=v[b+12>>2];b=v[a+104>>2];Wa=v[b+104>>2];lb=v[b+108>>2];d=v[a+24>>2];b=v[d+168>>2];f=v[d+172>>2];c=v[d+1144>>2];x:{if(v[d+1368>>2]){v[u+280>>2]=b;v[u+284>>2]=f;v[u+272>>2]=c;ic(a,3,0,255745,u+272|0);break x}v[u+256>>2]=v[d+1168>>2];v[u+248>>2]=b;v[u+252>>2]=f;v[u+240>>2]=c;ic(a,3,0,266067,u+240|0)}ic(a,3,0,365309,0);b=0;d=ub-32|0;ub=d;v[v[a+64>>2]+20>>2]=0;h=1;y:{if(v[v[a+64>>2]+16>>2]){break y}z:{A:{h=gd(a,d+28|0,d+24|0,0,0,0,0);if((h|0)==1){if(v[d+24>>2]<=0){break z}break A}Eb(150744,2384);v[d+16>>2]=h;Fb(276579,d+16|0);break y}while(1){h=iw(v[v[d+28>>2]+(b<<2)>>2],v[a+4>>2],v[a+64>>2],0,0);if((h|0)==1){b=b+1|0;if((b|0)<v[d+24>>2]){continue}break z}break}Eb(150744,2388);v[d>>2]=h;Fb(276579,d);break y}A[v[a+64>>2]>>3]=0;h=1;v[v[a+64>>2]+16>>2]=1}ub=d+32|0;if((h|0)!=1){Eb(157826,2725);v[u+224>>2]=h;Fb(276579,u+224|0);break a}Aa=1;h=R4(a,1);if((h|0)==1){break w}Eb(157826,2727);v[u+208>>2]=h;Fb(276579,u+208|0);break a}v[u+348>>2]=0;h=v[a+24>>2];v[h+1368>>2]=0;B:{C:{D:{E:{b=v[a+4>>2];switch(v[b>>2]-1|0){case 9:break B;case 8:break C;case 6:break D;case 0:case 2:case 4:break E;default:break t}}h=Ok(a);if((h|0)!=1){Eb(157826,2740);v[u+192>>2]=h;Fb(276579,u+192|0);break a}b=v[a+4>>2];d=v[b>>2];Xa=(d|0)==10?1:Xa;F:{switch(d-5|0){case 0:case 5:if(!v[b+1580>>2]){break B}h=Q4(a);if((h|0)==1){break B}Eb(157826,2749);v[u+176>>2]=h;Fb(276579,u+176|0);break a;default:break F}}if(rc(b,v[a+24>>2],0)){break B}b=v[a+4>>2]}G:{if(!v[b+1580>>2]){break G}h=Q4(a);if((h|0)==1){break G}Eb(157826,2763);v[u+160>>2]=h;Fb(276579,u+160|0);break a}h=U4(a,0);if((h|0)!=1){Eb(157826,2767);v[u+144>>2]=h;Fb(276579,u+144|0);break a}yd(v[a+16>>2],v[v[a+4>>2]+800>>2],3,365309,0);h=v[a+24>>2]}v[h+1208>>2]=0;v[h+392>>2]=0;v[h+396>>2]=0;if(Aa){b=v[a+104>>2];d=b;c=v[b+16>>2];b=gb+v[b+20>>2]|0;c=c+Sa|0;b=c>>>0<Sa>>>0?b+1|0:b;v[d+16>>2]=c;v[d+20>>2]=b;b=v[a+104>>2];d=b;c=v[b+24>>2];b=hb+v[b+28>>2]|0;c=c+Ta|0;b=c>>>0<Ta>>>0?b+1|0:b;v[d+24>>2]=c;v[d+28>>2]=b;ux(v[v[a+104>>2]+32>>2],ib);b=v[a+104>>2];d=b;c=v[b>>2];b=jb+v[b+4>>2]|0;c=c+Ua|0;b=c>>>0<Ua>>>0?b+1|0:b;v[d>>2]=c;v[d+4>>2]=b;b=v[a+104>>2];d=b;c=v[b+8>>2];b=kb+v[b+12>>2]|0;c=c+Va|0;b=c>>>0<Va>>>0?b+1|0:b;v[d+8>>2]=c;v[d+12>>2]=b;b=v[a+104>>2];d=b;c=v[b+104>>2];b=lb+v[b+108>>2]|0;c=c+Wa|0;b=c>>>0<Wa>>>0?b+1|0:b;v[d+104>>2]=c;v[d+108>>2]=b}Ea=v[a>>2];p=v[Ea+4>>2];R=v[a+16>>2];d=v[a+24>>2];O=v[a+28>>2];l=v[a+84>>2];J=v[a+68>>2];n=v[a+40>>2];f=v[a+56>>2];W=v[a+64>>2];S=v[a+88>>2];X=v[a+92>>2];xa=v[a+104>>2];mb=v[a+108>>2];L=v[a+52>>2];ba=v[a+76>>2];nb=v[a+100>>2];N=v[a+44>>2];C=v[a+48>>2];ca=v[a+80>>2];b=0;e=ub-1296|0;ub=e;g=v[a+4>>2];E=A[g+1424>>3];k=v[a+72>>2];if(v[k+160>>2]==1){o=A[g+1408>>3];E=o>=E?E:o}H:{if(v[g+176>>2]|v[g+1580>>2]){break H}c=v[g+1396>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break H}c=v[g+920>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break H}b=1;if(v[d+1368>>2]){break H}b=0;c=v[l+92>>2];if(!(+v[d+1168>>2]>E*+(c-v[l+108>>2]|0))){break H}b=1;if(v[d+1144>>2]==1){break H}b=+(c|0)<=(1-A[g+1432>>3])*+v[d+1172>>2]}v[u+348>>2]=b;b=v[g+696>>2];I:{if((b|0)<=0){Ba=17976931348623157e292;break I}Ba=+(b|0);c=v[d+1152>>2];if((c|0)<=0){break I}o=A[g+704>>3];if(c>>>0>=8){h=c&2147483640;b=0;while(1){Ba=Ba*o*o*o*o*o*o*o*o;b=b+8|0;if((h|0)!=(b|0)){continue}break}}c=c&7;if(!c){break I}b=0;while(1){Ba=Ba*o;b=b+1|0;if((c|0)!=(b|0)){continue}break}}v[d+896>>2]=0;v[e+1220>>2]=0;v[e+1224>>2]=0;v[e+1172>>2]=0;v[e+1176>>2]=0;J:{K:{L:{M:{if(rc(g,d,1)){break M}ob=d+200|0;pb=d+184|0;while(1){if(v[u+348>>2]){break M}v[e+1168>>2]=0;N:{O:{while(1){h=ub+-64|0;ub=h;E=A[g+1112>>3];P:{if(-A[g+1280>>3]>E+-1){m=v[v[Ea+12>>2]+12>>2];i=v[v[Ea+8>>2]+12>>2];q=v[Ea+4>>2];K=v[q+4104>>2];b=v[Ea>>2];c=K+v[b+4104>>2]|0;b=v[b+4108>>2]+v[q+4108>>2]|0;b=c>>>0<K>>>0?b+1|0:b;i=c+i|0;b=i>>>0<c>>>0?b+1|0:b;c=i;i=i+m|0;c=c>>>0>i>>>0?b+1|0:b;o=+(i>>>0)+ +(c|0)*4294967296;if(!v[d+1360>>2]){T=E;E=A[g+856>>3];if(!(o>=T*E*1024*1024)){break P}b=v[g+800>>2];c=v[d+168>>2];i=v[d+172>>2];A[h+16>>3]=E;A[h+8>>3]=o*9.5367431640625e-7;v[h>>2]=c;v[h+4>>2]=i;yd(R,b,4,359311,h);v[d+1360>>2]=1;v[g+88>>2]=0;break P}T=E*.5;E=A[g+856>>3];if(!(o<T*E*1024*1024)){break P}b=v[g+800>>2];c=v[d+168>>2];i=v[d+172>>2];A[h+48>>3]=E;A[h+40>>3]=o*9.5367431640625e-7;v[h+32>>2]=c;v[h+36>>2]=i;yd(R,b,4,359375,h+32|0);v[d+1360>>2]=0;v[g+88>>2]=0;break P}v[d+1360>>2]=0}ub=h- -64|0;Na=TE(g,d);j=Na;h=0;i=ub-32|0;ub=i;Q:{R:{if((j|0)==v[v[k+4>>2]+8>>2]){break R}K=ub-16|0;ub=K;m=k+4|0;S:{if((j|0)!=v[v[m>>2]+8>>2]){c=zd(32,154139,114);v[K+12>>2]=c;if(!c){Eb(154173,114);Fb(276543,0);Eb(154173,236);b=-1;v[K>>2]=-1;Fb(276579,K);break S}v[c+12>>2]=0;v[c+16>>2]=0;v[c>>2]=0;v[c+4>>2]=0;v[c+8>>2]=j;t=c+20|0;b=t;v[b>>2]=0;v[b+4>>2]=0;v[c+28>>2]=0;b=N7(c,g,v[v[m>>2]+24>>2]);ka=(b|0)==1;q=v[m>>2];T:{if((b|0)!=1|v[q+24>>2]<=0){break T}while(1){b=M7(c,g,v[v[q+12>>2]+(h<<2)>>2]);ka=(b|0)==1;q=v[m>>2];if((b|0)!=1){break T}h=h+1|0;if((h|0)<v[q+24>>2]){continue}break}}if(!ka){kc(c+12|0,154139,134);kc(c+16|0,154139,135);kc(t,154139,136);Zb(K+12|0,154139,137);break S}kc(q+12|0,154139,134);kc(v[m>>2]+16|0,154139,135);kc(v[m>>2]+20|0,154139,136);Zb(m,154139,137);v[m>>2]=c}b=1}ub=K+16|0;if((b|0)!=1){Eb(159113,5122);v[i+16>>2]=b;Fb(276579,i+16|0);break Q}b=v[d+168>>2];c=v[d+172>>2];if(!b&(c|0)<=0|(c|0)<0){break R}h=v[g+800>>2];v[i+8>>2]=v[j>>2];v[i>>2]=b;v[i+4>>2]=c;yd(R,h,5,306589,i)}b=1}ub=i+32|0;if((b|0)!=1){Eb(157874,4935);v[e+1152>>2]=b;Fb(276579,e+1152|0);break J}b=v[e+1220>>2];if(!b){b=I7(Na,g,e+1220|0);if((b|0)!=1){break O}b=v[e+1220>>2]}v[e+1220>>2]=0;v[e+1224>>2]=b;Ec(v[d+856>>2],g);b=Et(e+1224|0,p,g,R,d,l,O,J,k,n,f,L,ba,N,C,ca,e+1180|0,0,0);if((b|0)!=1){Eb(157874,4956);v[e+1120>>2]=b;Fb(276579,e+1120|0);break J}if(v[e+1180>>2]){r=v[d+292>>2];b=v[d+288>>2]+1|0;r=b?r:r+1|0;v[d+288>>2]=b;v[d+292>>2]=r}Hc(v[d+856>>2],g);if(v[e+1180>>2]){continue}break}h=v[e+1224>>2];if(!h){break M}c=x[h+40>>1];b=v[d+172>>2];i=v[d+168>>2]+1|0;b=i?b:b+1|0;v[d+168>>2]=i;v[d+172>>2]=b;b=v[d+212>>2];i=v[d+208>>2]+1|0;b=i?b:b+1|0;v[d+208>>2]=i;v[d+212>>2]=b;b=v[d+1212>>2];v[d+1212>>2]=(b|0)>(c|0)?b:c;b=v[d+1216>>2];v[d+1216>>2]=(b|0)>(c|0)?b:c;if(-A[g+1280>>3]<=A[h+8>>3]-A[d+760>>3]){r=v[d+276>>2];b=v[d+272>>2]+1|0;r=b?r:r+1|0;v[d+272>>2]=b;v[d+276>>2]=r}b=e+1184|0;v[b+24>>2]=262144;v[b+28>>2]=0;b=qx(b,v[e+1224>>2]);if((b|0)!=1){Eb(157874,4990);v[e+1088>>2]=b;Fb(276579,e+1088|0);break J}b=vp(e+1184|0,g,0,0,0,N);if((b|0)!=1){Eb(157874,4991);v[e+1072>>2]=b;Fb(276579,e+1072|0);break J}v[e+1180>>2]=0;v[e+1176>>2]=0;v[e+1172>>2]=0;v[u+348>>2]=0;v[e+1244>>2]=0;v[e+1164>>2]=0;ua=v[k+12>>2];ea=x[ua+40>>1];v[W+12>>2]=0;v[W+8>>2]=0;v[L+68>>2]=0;v[L+72>>2]=0;v[L+76>>2]=0;v[L+80>>2]=0;v[L+84>>2]=0;v[L+88>>2]=-2147483648;U:{V:{W:{b=v[g+952>>2];if((b|0)!=-1&(b|0)<(ea|0)){break W}c=v[g+932>>2];if((c|0)<=0){break W}b=0;if(!((ea>>>0)%(c>>>0)|0)){break V}break U}b=0;if(v[g+932>>2]|ea){break U}}o=xs(f,g,l);E=o-A[J+40>>3];o=-A[g+1280>>3];h=E<o;c=v[g+1580>>2];b=h&!c;if(!c|!h){break U}b=1;c=v[ua+44>>2]&536870911;h=!c;X:{if(h?x[ua+40>>1]:0){break X}E=A[g+1528>>3];if(o<=E+-1){break X}b=v[v[n+20>>2]>>2];Y:{if(h){if(v[v[b>>2]+68>>2]<=0){break Y}b=0;if(!(o<=A[n+40>>3]-E)){break Y}break X}if(v[v[b+(c<<2)>>2]+52>>2]>=v[g+1568>>2]){break Y}b=0;if(v[g+1564>>2]>(v[ua+44>>2]>>>29|0)){break X}}b=1}b=(b|0)!=0}v[k+196>>2]=b;Y=0;v[e+1272>>2]=0;v[e+1276>>2]=1;v[d+1200>>2]=0;v[d+1204>>2]=0;v[e+1256>>2]=1;v[e+1260>>2]=1;v[e+1252>>2]=1;v[e+1248>>2]=1;Oa=0;Z:{_:{if(v[e+1180>>2]|!(v[e+1252>>2]|(v[e+1260>>2]|v[e+1256>>2]))|v[e+1272>>2]>=10){break _}Ya=!ea;q=1;m=0;ka=0;while(1){if(v[u+348>>2]){break _}b=0;v[e+1172>>2]=0;v[e+1268>>2]=0;v[e+1240>>2]=0;v[e+1264>>2]=0;v[e+1280>>2]=-1;v[e+1284>>2]=-1;v[e+1236>>2]=0;v[e+1232>>2]=0;$:{aa:{ba:{ca:{da:{while(1){Y=1;if(v[e+1180>>2]){break ca}h=v[e+1260>>2];ma=v[e+1252>>2];M=v[e+1256>>2];ea:{if(h|(ma|M)){break ea}c=v[e+1284>>2];i=v[d+1036>>2];if((y[e+1280>>2]<y[d+1032>>2]&(c|0)<=(i|0)|(c|0)<(i|0))&(b|0)!=0){break ea}if(!v[e+1232>>2]){break da}}v[e+1256>>2]=0;v[e+1260>>2]=0;v[e+1252>>2]=0;b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,e+1180|0);if((b|0)!=1){Eb(157874,4193);v[e+1056>>2]=b;Fb(276579,e+1056|0);break K}$=m;P=e+1280|0;V=e+1276|0;Za=e+1272|0;ha=e+1248|0;va=e+1252|0;_a=e+1264|0;Fa=e+1232|0;Ca=e+1256|0;Z=e+1260|0;U=e+1176|0;K=e+1172|0;ya=e+1164|0;t=e+1240|0;la=e+1244|0;$a=e+1236|0;E=0;z=0;j=ub-1184|0;ub=j;i=e+1180|0;fa:{if(!v[i>>2]){b=1;if(v[U>>2]){break fa}c=v[d+496>>2];r=v[d+500>>2];m=v[d+432>>2];Q=v[d+436>>2];qa=v[f+468>>2];ga:{b=v[P+4>>2];z=v[d+1036>>2];ha:{if((v[_a>>2]?y[P>>2]<y[d+1032>>2]&(b|0)<=(z|0)|(b|0)<(z|0):0)|v[Fa>>2]){z=1;b=NE(p,g,d,k,v[k+160>>2]-1|0,0,v[ha>>2],4,i,U);if((b|0)!=1){Eb(157874,3757);v[j+1104>>2]=b;Fb(276579,j+1104|0);break fa}z=v[i>>2]?z:v[k+180>>2]<=(ea|0);v[i>>2]=z;b=v[d+1036>>2];v[P>>2]=v[d+1032>>2];v[P+4>>2]=b;if(!ma){b=z;z=v[d+436>>2];if(!(b|((Q|0)>=(z|0)&m>>>0>=y[d+432>>2]|(z|0)<(Q|0)))){break ha}break ga}if(z){break ga}break ha}if(!ma){break ga}}b=NE(p,g,d,k,v[k+160>>2]-1|0,0,v[ha>>2],1,i,U);if((b|0)==1){break ga}Eb(157874,3770);v[j+1088>>2]=b;Fb(276579,j+1088|0);break fa}z=v[d+496>>2];P=v[d+500>>2];v[ha>>2]=0;v[i>>2]=v[i>>2]?1:v[k+180>>2]<=(ea|0);ia:{ja:{ka:{la:{ma:{if(!M){if(!qa){break ma}b=(c|0)!=(z|0)|(r|0)!=(P|0);M=b|!v[f+468>>2];s=m>>>0<y[d+432>>2];m=v[d+436>>2];if(s&(Q|0)<=(m|0)|(m|0)>(Q|0)){break la}h=b|(h|0)!=0;break ia}M=1;b=v[d+436>>2];if(m>>>0<y[d+432>>2]&(Q|0)<=(b|0)|(b|0)>(Q|0)){break ja}h=(c|0)!=(z|0)|(r|0)!=(P|0)|(h|0)!=0;break ia}M=0;b=v[d+436>>2];if(m>>>0<y[d+432>>2]&(Q|0)<=(b|0)|(b|0)>(Q|0)){break ka}h=(c|0)!=(z|0)|(r|0)!=(P|0)|(h|0)!=0;break ia}if(M){break ja}}if(!v[f+468>>2]|!v[f+472>>2]|(v[g+176>>2]|v[f+320>>2]!=v[l+112>>2])){break ja}if(!v[f+500>>2]){break ja}b=Nr(ua,g,d,k,l,O,f);if((b|0)!=1){Eb(157874,3795);v[j+1072>>2]=b;Fb(276579,j+1072|0);break fa}if(!v[k+196>>2]){break ja}b=yz(g,d,k,f,L);if((b|0)!=1){Eb(157874,3802);v[j+1056>>2]=b;Fb(276579,j+1056|0);break fa}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1|ea){break ja}ZF(l,g,d,f)}b=0;v[W+12>>2]=0;v[W+8>>2]=0;h=1;if(v[g+208>>2]<=0){break ia}while(1){m=v[v[g+52>>2]+(b<<2)>>2];v[m+48>>2]=-1;v[m+52>>2]=-1;b=b+1|0;if((b|0)<v[g+208>>2]){continue}break}}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,i);if((b|0)!=1){Eb(157874,3815);v[j+1040>>2]=b;Fb(276579,j+1040|0);break fa}z=(c|0)!=(z|0)|(r|0)!=(P|0)}if(v[U>>2]){b=1;break fa}na:{if(v[i>>2]|v[k+28>>2]){break na}b=Sr(g,d,l,J,k,f,0,v[V>>2],0,va,K);if((b|0)!=1){Eb(157874,3829);v[j+1024>>2]=b;Fb(276579,j+1024|0);break fa}v[V>>2]=1024;if(rc(g,d,0)){v[k+196>>2]=0;b=Bm(j+1152|0,p,g,d,k,1,A[ua+16>>3]);if((b|0)!=1){Eb(157874,3845);v[j+1008>>2]=b;Fb(276579,j+1008|0);break fa}v[ya>>2]=1;break fa}if(v[f+532>>2]){v[k+196>>2]=0;v[f+532>>2]=0}if(!v[va>>2]){break na}v[Ca>>2]=M;v[Z>>2]=h;b=1;break fa}v[Fa>>2]=0;oa:{if(v[i>>2]|!h){break oa}v[L+68>>2]=0;v[L+72>>2]=0;v[L+76>>2]=0;v[L+80>>2]=0;v[L+84>>2]=0;v[L+88>>2]=-2147483648;b=j3(g,d,k,l,O,ea,1,i,va,Ca,Z,Fa);if((b|0)!=1){Eb(157874,3875);v[j+992>>2]=b;Fb(276579,j+992|0);break fa}v[i>>2]=v[i>>2]?1:v[k+180>>2]<=(ea|0);b=ME(p,g,d,l,O,k,n,f,W,X,L,C,N,ca,!ea,i,va,Ca,Z);if((b|0)!=1){Eb(157874,3884);v[j+976>>2]=b;Fb(276579,j+976|0);break fa}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,i);if((b|0)==1){break oa}Eb(157874,3887);v[j+960>>2]=b;Fb(276579,j+960|0);break fa}pa:{if(!v[k+196>>2]|(v[i>>2]|!M)){break pa}v[t>>2]=0;v[K>>2]=0;P=v[d+8>>2];ab=v[d+12>>2];ha=v[d+1e3>>2];qb=v[d+1004>>2];ya=v[d+960>>2];rb=v[d+964>>2];ma=v[d+976>>2];sb=v[d+980>>2];U=v[d+936>>2];bb=v[d+940>>2];qa:{ra:{sa:{ta:{ua:{if(!$){v[i>>2]=0;v[t>>2]=0;b=hN(p,g,d,l,O,k,n,f,S,X,xa,L,C,N,ca,z,i);va:{if((b|0)!=1){Eb(157874,1480);v[j+928>>2]=b;Fb(276579,j+928|0);break va}wa:{xa:{ya:{if(v[i>>2]){break ya}Q=ub-16|0;ub=Q;b=v[k+20>>2];za:{if(!b){m=1;break za}z=v[b+40>>2];Aa:{Ba:{V=v[k+104>>2]==v[d+920>>2]&v[k+108>>2]==v[d+924>>2];if(V){break Ba}m=v[b+24>>2];r=v[m+8>>2];Ca:{if((z&983040)==524288){b=3646;c=v[m+36>>2];m=MA(f,p,g,l,C,r,c>>>28&1,c>>>29&1,c>>>30&1,c>>>31|0);if((m|0)==1){break Ca}break Aa}b=3654;c=v[m+36>>2];m=v[m+40>>2];m=MA(f,p,g,l,C,r,c>>>30&1,c>>>31|0,m&1,m>>>1&1);if((m|0)!=1){break Aa}}if(!v[f+472>>2]|!v[f+492>>2]){break Ba}m=1;break za}M=z&65535;b=0;if(v[f+476>>2]){b=v[k+76>>2];b=v[b+(v[k+176>>2]<<2)>>2]==v[b+(M<<2)>>2]}v[f+476>>2]=b;if(v[f+480>>2]){c=v[k+76>>2];c=v[c+(v[k+176>>2]<<2)>>2]==v[c+(M<<2)>>2]}else{c=0}v[f+480>>2]=c;if(v[f+484>>2]){c=v[k+72>>2];c=v[c+(v[k+176>>2]<<2)>>2]==v[c+(M<<2)>>2]}else{c=0}v[f+484>>2]=c;if(v[f+488>>2]){c=v[k+72>>2];c=v[c+(v[k+176>>2]<<2)>>2]==v[c+(M<<2)>>2]}else{c=0}v[f+488>>2]=c;if(V){m=1;break za}c=v[k+12>>2];if(x[c+40>>1]<=M>>>0){m=1;break za}while(1){if(!b){m=1;break za}m=1;b=1;z=v[v[v[k+8>>2]+(M<<2)>>2]+36>>2];if(z){b=!(v[z>>2]&1073741823)}v[f+480>>2]=b;v[f+476>>2]=b;M=M+1|0;if(M>>>0<x[c+40>>1]){continue}break}break za}Eb(159113,b);v[Q>>2]=m;Fb(276579,Q)}ub=Q+16|0;b=m;if((b|0)!=1){Eb(157874,1486);v[j+912>>2]=b;Fb(276579,j+912|0);break va}c=0;Q=0;m=v[k+12>>2];b=x[m+40>>1];if(!b){c=v[d+8>>2];Q=v[d+12>>2];E=vc(v[d+792>>2]);b=x[v[k+12>>2]+40>>1]}b=(b?936:944)+g|0;b=al(f,g,R,p,d,C,N,l,v[b>>2],v[b+4>>2],1,1,0,t);if((b|0)!=1){Eb(157874,1500);v[j+896>>2]=b;Fb(276579,j+896|0);break va}if(!(x[m+40>>1]|(v[d+1032>>2]|v[d+1036>>2])!=0)){A[d+648>>3]=vc(v[d+792>>2])-E}b=aq(p,g,d,l,J,k,f,v[t>>2]);if((b|0)!=1){Eb(157874,1511);v[j+880>>2]=b;Fb(276579,j+880|0);break va}if(v[t>>2]){break ya}if(!(((v[f+468>>2]?v[f+420>>2]:0)|0)==5|((v[f+468>>2]?v[f+420>>2]:0)|0)==6)){z=j+1152|0;v[z+24>>2]=8388608;v[z+28>>2]=0;M=1522;b=qx(z,v[k+12>>2]);if((b|0)!=1){break xa}M=1523;b=vp(z,g,0,0,0,N);if((b|0)!=1){break xa}}M=1527;b=i3(g,d,l,k,f,1,!v[g+524>>2]);if((b|0)!=1){break xa}if(!(((v[f+468>>2]?v[f+420>>2]:0)|0)==1|((v[f+468>>2]?v[f+420>>2]:0)|0)==3)){if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=4){break ya}}if(!v[f+500>>2]|(v[g+176>>2]|v[f+320>>2]!=v[l+112>>2])){break ya}M=1535;b=Nr(m,g,d,k,l,O,f);if((b|0)!=1){break xa}if(x[m+40>>1]|(v[d+1032>>2]|v[d+1036>>2])){break ya}b=v[d+8>>2];m=v[d+12>>2]-((c>>>0>b>>>0)+Q|0)|0;b=b-c|0;v[d+24>>2]=b;v[d+28>>2]=m;Da:{if(v[g+1172>>2]){b=Z9(f,g,j+1120|0);if((b|0)!=1){break wa}E=A[j+1120>>3];break Da}E=xk(f,g,l);A[j+1120>>3]=E}A[d+552>>3]=gg(l,O,g,E)}b=v[d+936>>2];c=b-U|0;b=v[d+1052>>2]+(v[d+940>>2]-((b>>>0<U>>>0)+bb|0)|0)|0;m=c;c=v[d+1048>>2]+c|0;b=m>>>0>c>>>0?b+1|0:b;v[d+1048>>2]=c;v[d+1052>>2]=b;b=v[d+8>>2];c=b-P|0;r=v[d+100>>2]+(v[d+12>>2]-((b>>>0<P>>>0)+ab|0)|0)|0;b=c+v[d+96>>2]|0;r=b>>>0<c>>>0?r+1|0:r;v[d+96>>2]=b;v[d+100>>2]=r;if(v[t>>2]|(v[i>>2]|v[k+160>>2]!=1)){break ta}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1&((v[f+468>>2]?v[f+420>>2]:0)|0)!=3){break ta}if(rc(g,d,0)){break ta}c=v[J+16>>2];Q=v[J+20>>2];m=3004;z=j+1120|0;b=SE(z,p,g,d,l,J,k,f);if((b|0)!=1){break ua}m=3028;b=du(J,p,g,R,d,O,l,k,n,f,C,N,z,0,0,1,1,((v[f+468>>2]?v[f+420>>2]:0)|0)!=3,j+1152|0);if((b|0)!=1){break ua}Ea:{if(!v[j+1152>>2]){break Ea}b=v[d+324>>2];m=v[d+320>>2]+1|0;b=m?b:b+1|0;v[d+320>>2]=m;v[d+324>>2]=b;if(v[J+16>>2]!=(c|0)|v[J+20>>2]!=(Q|0)){b=v[d+356>>2];c=v[d+352>>2]+1|0;b=c?b:b+1|0;v[d+352>>2]=c;v[d+356>>2]=b;on(v[g+4>>2])}if(!v[g+1580>>2]){break Ea}m=3045;b=v[k+12>>2];b=vn(n,g,p,v[k+12>>2],524288,f,v[f+468>>2]?v[f+420>>2]:0,(b|0)==v[k>>2],1,A[b+8>>3],v[k+168>>2]);if((b|0)!=1){break ua}}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=3){break ta}v[K>>2]=1;break ta}Eb(157874,M);v[j+864>>2]=b;Fb(276579,j+864|0);break va}Eb(157874,1547);v[j+848>>2]=b;Fb(276579,j+848|0)}Eb(157874,2980);v[j+832>>2]=b;Fb(276579,j+832|0);break sa}b=Rr(p,g,X,xa,d,l,O,k,n,f,L,C,N,ca,0,0,i);if((b|0)==1){break ta}Eb(157874,3057);v[j+944>>2]=b;Fb(276579,j+944|0);break sa}Eb(157874,m);v[j+816>>2]=b;Fb(276579,j+816|0);break sa}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,i);if((b|0)!=1){Eb(157874,3062);v[j+800>>2]=b;Fb(276579,j+800|0);break sa}Fa:{Ga:{Ha:{Ia:{if(v[i>>2]|v[t>>2]){break Ia}qa=v[d+496>>2];tb=v[d+500>>2];vb=v[l+112>>2];wb=v[X+36>>2];Da=v[d+424>>2];xb=v[d+428>>2];Ga=v[d+432>>2];Ab=v[d+436>>2];ra=v[k+12>>2];aa=x[ra+40>>1];E=A[ra+8>>3];o=Or(k,g);b=v[g+(aa?1708:1712)>>2];M=(b|0)==-1?2147483647:b;z=v[d+1144>>2];if(!(aa|(z|0)<2)){b=v[g+1716>>2];M=(b|0)<0?M:(b|0)>(M|0)?M:b}Ja:{if(q){break Ja}b=v[g+1720>>2];if((b|0)<0){break Ja}b=b+v[d+1204>>2]|0;M=(b|0)>(M|0)?M:b}T=A[J+40>>3];c=v[g+1704>>2];na=A[g+1632>>3];Ka=A[g+1280>>3];m=v[g+(aa?1724:1728)>>2];b=al(f,g,R,p,d,C,N,l,v[g+936>>2],v[g+940>>2],0,1,0,t);if((b|0)!=1){Eb(157874,2357);v[j+784>>2]=b;Fb(276579,j+784|0);break Ha}b=aq(p,g,d,l,J,k,f,v[t>>2]);if((b|0)!=1){Eb(157874,2362);v[j+768>>2]=b;Fb(276579,j+768|0);break Ha}Ha=(m|0)==-1?2147483647:m;b=v[l+112>>2];v[j+1120>>2]=1;v[j+1140>>2]=b;cb=(c|0)==-1|(c|0)>=(z|0);v[j+1148>>2]=cb;Q=0;v[j+1144>>2]=0;v[i>>2]=0;v[K>>2]=((v[f+468>>2]?v[f+420>>2]:0)|0)==3;v[f+504>>2]=0;Ka:{if(v[i>>2]){break Ka}sa=(E-o)/(T-o);db=Ka>=sa-na;wa=!aa;Bb=Ha-2|0;Cb=Ha-1|0;m=2147483647;E=-17976931348623157e292;z=0;while(1){if(v[K>>2]|v[t>>2]){break Ka}eb=v[j+1144>>2];r=v[j+1120>>2];b=v[j+1148>>2];if(!(r|b|eb)){break Ka}fa=0;c=0;if(r){La:{while(1){La=0;Ia=0;_=ub-48|0;ub=_;b=v[k+160>>2];if((b|0)>0){La=v[(v[k+8>>2]+(b<<2)|0)-4>>2]}r=j+1148|0;Ma=j+1140|0;v[Ma>>2]=v[l+112>>2];v[t>>2]=0;v[la>>2]=0;Ma:{Na:{s=v[t>>2];Oa:{if(!(((v[f+468>>2]?v[f+420>>2]:0)|0)==1|((v[f+468>>2]?v[f+420>>2]:0)|0)==2)){b=0;if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=4){break Oa}}b=1;if(v[f+320>>2]!=v[l+112>>2]){break Oa}b=v[g+176>>2]!=0}Pa:{Qa:{if(s|!b){break Qa}while(1){if(rc(g,d,0)){if(!(Tc(v[g+4>>2])-Gd(v[g+4>>2])<=A[g+1280>>3])){rh(R,295346,0)}b=1;break Pa}c=Sr(g,d,l,J,k,f,0,128,0,_+20|0,_+40|0);if((c|0)!=1){V=2104;break Na}za=0;Pa=0;oa=ub-48|0;ub=oa;b=1;Ra:{if(v[l+112>>2]==v[f+320>>2]){break Ra}fb=v[k+160>>2]==1;b=v[g+(fb?1460:1456)>>2];o=A[g+1448>>3];v[S+44>>2]=v[S+44>>2]+1;Ec(v[S>>2],g);c=v[l+92>>2]<=0;o=o*+(b|0);Sa:{if(D(o)<2147483648){V=~~o;break Sa}V=-2147483648}Ta:{if(c|(V|0)<=0){break Ta}while(1){da=v[v[l+68>>2]+(za<<2)>>2];Ua:{if((v[da+376>>2]&1792)!=512){break Ua}G=v[da+176>>2];if(v[G+224>>2]>=0){break Ua}Va:{Wa:{Xa:{Ya:{T=A[da+152>>3];o=A[g+1280>>3];if(!(T>o)){na=A[da+160>>3];if(!(na<-o)){break Ya}}G=ub-16|0;ub=G;if(!v[S+60>>2]){v[S+52>>2]=v[S+52>>2]+1}Za:{_a:{$a:{b=v[S+36>>2];if((b|0)>=v[S+32>>2]){b=Id(g,b+1|0);s=95;c=Sc(v[S+12>>2],b,4,158457,95);v[S+12>>2]=c;if(!c){break $a}s=96;c=Sc(v[S+16>>2],b,8,158457,96);v[S+16>>2]=c;if(!c){break $a}s=97;c=Sc(v[S+20>>2],b,8,158457,97);v[S+20>>2]=c;if(!c){break $a}v[S+32>>2]=b}v[da+320>>2]=v[da+320>>2]+1;b=v[S+36>>2];v[v[S+12>>2]+(b<<2)>>2]=da;c=b<<3;A[c+v[S+16>>2]>>3]=A[da+152>>3];A[c+v[S+20>>2]>>3]=A[da+160>>3];c=1;v[S+36>>2]=b+1;if(A[da+152>>3]>A[g+1280>>3]){s=297;b=Zj(da,p,g,d,f,L,C,0);if((b|0)!=1){break _a}break Za}s=301;b=Yj(da,p,g,d,f,L,C,0);if((b|0)==1){break Za}break _a}Eb(158491,s);Fb(276543,0);b=-1;s=277}Eb(158491,s);v[G>>2]=b;Fb(276579,G);c=b}ub=G+16|0;b=c;if((b|0)==1){break Va}c=331;break Xa}pa=T;T=A[da>>3];na=T>=0?pa:na;if(o>=D(na)){break Wa}b=fG(S,p,g,C,f,da,na*-T,v[k+160>>2]==1);if((b|0)==1){break Va}c=345}Eb(158491,c);v[oa+16>>2]=b;Fb(276579,oa+16|0);Eb(158491,423);v[oa>>2]=b;Fb(276579,oa);break Ra}if(v[G+212>>2]<=0){break Ua}ab:{if(((v[f+468>>2]?v[f+420>>2]:0)|0)==2){o=0;ja=0;ta=v[d+924>>2];c=ta;s=v[G+188>>2];b=v[d+920>>2];bb:{if((c|0)<=(s|0)&b>>>0<=y[G+184>>2]|(c|0)<(s|0)){o=A[G+88>>3];break bb}s=v[G+216>>2];cb:{if((s|0)<=0){break cb}Qa=s&1;ga=v[G+172>>2];ia=v[G+168>>2];db:{if((s|0)==1){c=0;break db}Ra=s&2147483646;c=0;while(1){Ja=c|1;o=A[ga+(Ja<<3)>>3]*A[v[ia+(Ja<<2)>>2]+96>>3]+(A[ga+(c<<3)>>3]*A[v[ia+(c<<2)>>2]+96>>3]+o);c=c+2|0;ja=ja+2|0;if((Ra|0)!=(ja|0)){continue}break}}if(!Qa){break cb}o=A[ga+(c<<3)>>3]*A[v[ia+(c<<2)>>2]+96>>3]+o}eb:{if(v[G+220>>2]<=0){break eb}c=v[G+212>>2];if((c|0)<=(s|0)){break eb}ga=s+1|0;ja=v[G+168>>2];if(c-s&1){ia=v[ja+(s<<2)>>2];if(v[ia+232>>2]>=0){o=A[v[G+172>>2]+(s<<3)>>3]*A[ia+96>>3]+o}s=s+1|0}if((c|0)==(ga|0)){break eb}while(1){ga=v[ja+(s<<2)>>2];if(v[ga+232>>2]>=0){o=A[v[G+172>>2]+(s<<3)>>3]*A[ga+96>>3]+o}ga=s+1|0;ia=v[ja+(ga<<2)>>2];if(v[ia+232>>2]>=0){o=A[v[G+172>>2]+(ga<<3)>>3]*A[ia+96>>3]+o}s=s+2|0;if((c|0)!=(s|0)){continue}break}}v[G+184>>2]=b;v[G+188>>2]=ta;A[G+88>>3]=o}T=-(o*A[G+(o>0?16:8)>>3]);break ab}ja=0;na=A[g+1280>>3];T=A[G+8>>3];Ka=A[G+16>>3];pa=A[g+1272>>3];fb:{if(na>=D(T-Ka)){break fb}ta=v[d+924>>2];c=ta;s=v[G+180>>2];b=v[d+920>>2];gb:{if((c|0)<=(s|0)&b>>>0<=y[G+176>>2]|(c|0)<(s|0)){o=A[G+80>>3];break gb}o=A[G>>3];s=v[G+216>>2];hb:{if((s|0)<=0){break hb}Qa=s&1;ga=v[G+172>>2];ia=v[G+168>>2];ib:{if((s|0)==1){c=0;break ib}Ra=s&2147483646;c=0;while(1){Ja=c|1;o=o-A[ga+(c<<3)>>3]*A[v[ia+(c<<2)>>2]+80>>3]-A[ga+(Ja<<3)>>3]*A[v[ia+(Ja<<2)>>2]+80>>3];c=c+2|0;ja=ja+2|0;if((Ra|0)!=(ja|0)){continue}break}}if(!Qa){break hb}o=o-A[ga+(c<<3)>>3]*A[v[ia+(c<<2)>>2]+80>>3]}jb:{if(v[G+220>>2]<=0){break jb}c=v[G+212>>2];if((c|0)<=(s|0)){break jb}ga=s+1|0;ja=v[G+168>>2];if(c-s&1){ia=v[ja+(s<<2)>>2];if(v[ia+232>>2]>=0){o=o-A[v[G+172>>2]+(s<<3)>>3]*A[ia+80>>3]}s=s+1|0}if((c|0)==(ga|0)){break jb}while(1){ga=v[ja+(s<<2)>>2];if(v[ga+232>>2]>=0){o=o-A[v[G+172>>2]+(s<<3)>>3]*A[ga+80>>3]}ga=s+1|0;ia=v[ja+(ga<<2)>>2];if(v[ia+232>>2]>=0){o=o-A[v[G+172>>2]+(ga<<3)>>3]*A[ia+80>>3]}s=s+2|0;if((c|0)!=(s|0)){continue}break}}v[G+176>>2]=b;v[G+180>>2]=ta;A[G+80>>3]=o}if(T<-na){pa=-D(o);if(na<Ka){break fb}o=-o}pa=o}T=pa}if(T>A[g+1280>>3]){break Ua}b=fG(S,p,g,C,f,da,-T/+(v[G+212>>2]+1|0),fb);if((b|0)==1){break Va}Eb(158491,464);v[oa+32>>2]=b;Fb(276579,oa+32|0);break Ra}v[S+48>>2]=v[S+48>>2]+1;Pa=Pa+1|0}za=za+1|0;if((za|0)>=v[l+92>>2]){break Ta}if((V|0)>(Pa|0)){continue}break}}Hc(v[S>>2],g);b=1}ub=oa+48|0;c=b;if((b|0)!=1){V=2110;break Na}v[Ma>>2]=v[l+112>>2];T3(g);s=0;c=0;b=v[g+(wa?1460:1456)>>2];if((b|0)!=2147483647){c=(b|0)<((v[S+36>>2]+v[S+28>>2]|0)-v[S+40>>2]|0)}kb:{if(c|v[g+176>>2]<=0){break kb}V=2125;c=u7(v[v[g+24>>2]>>2],g,l,f,S,_+24|0,_+16|0,_+36|0);if((c|0)!=1){break Na}c=0;b=v[g+(wa?1460:1456)>>2];if((b|0)!=2147483647){c=(b|0)<((v[S+36>>2]+v[S+28>>2]|0)-v[S+40>>2]|0)}b=1;v[la>>2]=v[_+36>>2]==1|v[la>>2]!=0;s=v[_+16>>2];bo(La,d,g,k,l,O,A[_+24>>3]);s=(s|0)!=0;if(c|v[g+176>>2]<2){break kb}while(1){c=u7(v[v[g+24>>2]+(b<<2)>>2],g,l,f,S,_+24|0,_+16|0,_+36|0);if((c|0)!=1){break Na}c=0;G=v[g+(wa?1460:1456)>>2];if((G|0)!=2147483647){c=(G|0)<((v[S+36>>2]+v[S+28>>2]|0)-v[S+40>>2]|0)}v[la>>2]=v[_+36>>2]==1|v[la>>2]!=0;G=v[_+16>>2];bo(La,d,g,k,l,O,A[_+24>>3]);s=s?G?s:0:s;b=b+1|0;if((b|0)>=v[g+176>>2]){break kb}if(!c){continue}break}}c=gP(S,p,g,d,C,l,k,f);if((c|0)!=1){V=2147;break Na}c=v[f+468>>2];V=c?v[l+112>>2]!=v[Ma>>2]:1;v[r>>2]=!c|v[r>>2]!=0;c=al(f,g,R,p,d,C,N,l,-1,-1,0,1,0,t);if((c|0)!=1){V=2157;break Na}da=0;G=ub-48|0;ub=G;b=1;lb:{mb:{if(v[S+36>>2]<=0){break mb}while(1){oa=da<<2;ja=v[oa+v[S+12>>2]>>2];za=da<<3;c=Zj(ja,p,g,d,f,L,C,A[za+v[S+16>>2]>>3]);if((c|0)!=1){Eb(158491,598);v[G+32>>2]=c;Fb(276579,G+32|0);b=c;break lb}c=Yj(ja,p,g,d,f,L,C,A[za+v[S+20>>2]>>3]);if((c|0)!=1){Eb(158491,599);v[G+16>>2]=c;Fb(276579,G+16|0);b=c;break lb}c=kl(oa+v[S+12>>2]|0,p,g,C,f);if((c|0)==1){da=da+1|0;if((da|0)>=v[S+36>>2]){break mb}continue}break}Eb(158491,600);v[G>>2]=c;Fb(276579,G);b=c;break lb}v[S+36>>2]=0;v[S+40>>2]=0}ub=G+48|0;c=b;if((b|0)!=1){V=2163;break Na}c=Rr(p,g,X,xa,d,l,O,k,n,f,L,C,N,ca,0,0,_+44|0);if((c|0)!=1){V=2170;break Na}b=1;nb:{if(V){break nb}b=1;if(!v[f+468>>2]){break nb}b=v[l+112>>2]!=v[Ma>>2]}v[r>>2]=!(v[r>>2]?0:v[f+468>>2]);if(s){v[la>>2]=1;b=0}c=al(f,g,R,p,d,C,N,l,-1,-1,0,0,0,t);if((c|0)!=1){V=2186;break Na}c=aq(p,g,d,l,J,k,f,v[t>>2]);if((c|0)!=1){V=2191;break Na}v[d+1200>>2]=v[d+1200>>2]+1;Ia=Ia+1|0;ob:{pb:{qb:{if(b&wa){b=v[g+800>>2];if(b>>>0<=4){if((b|0)!=4|((Ia>>>0)%100|0)!=1){break qb}}c=cB(g,R,d,1);if((c|0)==1){break qb}V=2203;break Na}if(!b){break pb}}if(((v[f+468>>2]?v[f+420>>2]:0)|0)==1|((v[f+468>>2]?v[f+420>>2]:0)|0)==2){break ob}if(((v[f+468>>2]?v[f+420>>2]:0)|0)==4){break ob}}s=v[t>>2];break Qa}s=v[t>>2];if(s|!(-A[g+1280>>3]>A[La+8>>3]-A[J+40>>3])){break Qa}if((Ia|0)!=2147483647){continue}break}}b=1;if(!(v[f+468>>2]?v[f+420>>2]:0)|(v[la>>2]|s)){break Pa}b=((v[f+468>>2]?v[f+420>>2]:0)|0)==7|(Ia|0)==2147483647}v[la>>2]=b;c=1;v[f+500>>2]=!b;break Ma}Eb(157874,V);v[_>>2]=c;Fb(276579,_)}ub=_+48|0;b=c;if((b|0)!=1){Eb(157874,2387);v[j+752>>2]=b;Fb(276579,j+752|0);break Ha}rb:{sb:{if(!(!v[f+500>>2]|(v[t>>2]|v[la>>2]))){b=Nr(ra,g,d,k,l,O,f);if((b|0)!=1){Eb(157874,2397);v[j+736>>2]=b;Fb(276579,j+736|0);break Ha}b=yz(g,d,k,f,L);if((b|0)!=1){Eb(157874,2402);v[j+720>>2]=b;Fb(276579,j+720|0);break Ha}if(aa){break rb}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1){break sb}ZF(l,g,d,f);break sb}if(aa){break rb}}if(y[g+800>>2]<4){break rb}b=cB(g,R,d,1);if((b|0)==1){break rb}Eb(157874,2415);v[j+704>>2]=b;Fb(276579,j+704|0);break Ha}c=0;tb:{ub:{vb:{if(v[t>>2]|!(-A[g+1280>>3]>A[ra+8>>3]-A[J+40>>3])){break vb}r=v[d+496>>2];G=v[d+500>>2];V=v[d+432>>2];s=v[d+436>>2];b=NE(p,g,d,k,v[k+160>>2]-1|0,0,0,2,i,j+1136|0);if((b|0)!=1){m=2433;break ub}wb:{if((r|0)==v[d+496>>2]&(G|0)==v[d+500>>2]){break wb}b=Rr(p,g,X,xa,d,l,O,k,n,f,L,C,N,ca,0,0,i);if((b|0)==1){break wb}m=2442;break ub}if(v[i>>2]|v[K>>2]){break vb}if(!v[f+468>>2]){xb:{if(aa){break xb}b=yn(f,p,g,l,C);if((b|0)!=1){m=2455;break ub}b=aaa(f,p,g,d,C,N);if((b|0)==1){break xb}m=2456;break ub}b=al(f,g,R,p,d,C,N,l,v[g+936>>2],v[g+940>>2],0,1,0,t);if((b|0)!=1){m=2461;break ub}b=aq(p,g,d,l,J,k,f,v[t>>2]);if((b|0)!=1){m=2466;break ub}c=1;v[va>>2]=1;break vb}r=v[d+436>>2];if((s|0)>=(r|0)&V>>>0>=y[d+432>>2]|(r|0)<(s|0)){break vb}v[va>>2]=1;if(!v[f+472>>2]|v[f+320>>2]!=v[l+112>>2]|(v[g+176>>2]|!v[f+500>>2])){break vb}b=Nr(ra,g,d,k,l,O,f);if((b|0)!=1){m=2484;break ub}b=yz(g,d,k,f,L);if((b|0)!=1){Eb(157874,2489);v[j+688>>2]=b;Fb(276579,j+688|0);break Ha}if(!aa){if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1){break vb}ZF(l,g,d,f)}}yb:{if(!(v[i>>2]|v[K>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=1)){b=Sr(g,d,l,J,k,f,0,2,0,j+1136|0,K);if((b|0)!=1){break yb}v[t>>2]=v[t>>2]?1:v[f+532>>2]!=0}if(c){break tb}c=0;break La}Eb(157874,2505);v[j+656>>2]=b;Fb(276579,j+656|0);break Ha}Eb(157874,m);v[j+672>>2]=b;Fb(276579,j+672|0);break Ha}if(!v[t>>2]){continue}break}c=1}b=v[j+1148>>2]}v[j+1120>>2]=c;if(!(!b|v[d+1204>>2]>=(M|0)|(Q|0)>=(Ha|0))){fa=!v[i>>2]}c=0;c=fa|!eb?c:!v[i>>2];v[j+1144>>2]=c;b=c|fa;v[j+1148>>2]=b;zb:{if((b|0)!=1){break zb}Ab:{Bb:{if(v[K>>2]|(v[i>>2]|!cb)){break Bb}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1&((v[f+468>>2]?v[f+420>>2]:0)|0)!=3|-A[g+1280>>3]<=A[ra+8>>3]-A[J+40>>3]){break Bb}if(aa){break Ab}if(!rc(g,d,0)){break Ab}}v[j+1144>>2]=0;v[j+1148>>2]=0;break zb}V=v[d+496>>2];G=v[d+500>>2];r=v[d+424>>2];s=v[d+428>>2];v[j+1148>>2]=0;b=!v[g+(wa?1736:1732)>>2];v[j+1136>>2]=b;Cb:{if(b|c){break Cb}b=eN(xa,p,g,d,C,N,f,X,0,wa,aa,j+1136|0,i);if((b|0)==1){break Cb}Eb(157874,2563);v[j+640>>2]=b;Fb(276579,j+640|0);break Ha}Db:{Eb:{Fb:{if(v[i>>2]){break Fb}Gb:{if(!v[f+472>>2]|(v[t>>2]|v[j+1136>>2])){break Gb}b=gN(p,g,R,d,C,N,l,J,k,f,X,aa,sa,db,c,j+1144|0,j+1136|0,i,t,j+1148|0,j+1120|0);if((b|0)!=1){Eb(157874,2583);v[j+624>>2]=b;Fb(276579,j+624|0);break Ha}if(v[i>>2]){break Fb}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1&((v[f+468>>2]?v[f+420>>2]:0)|0)!=3|(!v[f+472>>2]|(v[t>>2]|v[j+1136>>2]))){break Gb}if((Q|0)<(Cb|0)){break Gb}b=v[j+1144>>2];if(!b){break Gb}b=gN(p,g,R,d,C,N,l,J,k,f,X,aa,sa,db,b,j+1144|0,j+1136|0,i,t,j+1148|0,j+1120|0);if((b|0)==1){break Gb}Eb(157874,2593);v[j+608>>2]=b;Fb(276579,j+608|0);break Ha}if(v[i>>2]){break Fb}if(!v[t>>2]){Hb:{if(!v[f+472>>2]|(v[j+1136>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=1)){break Hb}b=eN(xa,p,g,d,C,N,f,X,0,wa,aa,j+1136|0,i);if((b|0)==1){break Hb}Eb(157874,2602);v[j+592>>2]=b;Fb(276579,j+592|0);break Ha}if(v[i>>2]){break Fb}}Ib:{if(v[X+12>>2]|v[j+1136>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=1){break Ib}b=eN(mb,p,g,d,C,N,f,X,1,wa,aa,j+1136|0,i);if((b|0)==1){break Ib}Eb(157874,2617);v[j+576>>2]=b;Fb(276579,j+576|0);break Ha}if(v[i>>2]|v[t>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)==2){break Fb}if(((v[f+468>>2]?v[f+420>>2]:0)|0)==4|((v[f+468>>2]?v[f+420>>2]:0)|0)==5){break Fb}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=6){break Eb}}b=Ez(X,p,g,C,N,f);if((b|0)==1){break Db}Eb(157874,2642);v[j+416>>2]=b;Fb(276579,j+416|0);break Ha}b=Fz(X,p,g,d,l,O,k,n,f,L,C,N,ca,wa,i);if((b|0)!=1){Eb(157874,2648);v[j+560>>2]=b;Fb(276579,j+560|0);break Ha}if(v[i>>2]){break Db}fa=1;c=1;Jb:{if(v[j+1120>>2]){break Jb}c=1;if(!v[f+468>>2]){break Jb}c=v[l+112>>2]!=v[j+1140>>2]}v[j+1120>>2]=c;fa=v[j+1148>>2]?fa:!v[f+468>>2];v[j+1148>>2]=fa;Kb:{if((r|0)==v[d+424>>2]&(s|0)==v[d+428>>2]){break Kb}v[va>>2]=1;if(aa){break Kb}b=yn(f,p,g,l,C);if((b|0)!=1){Eb(157874,2665);v[j+544>>2]=b;Fb(276579,j+544|0);break Ha}b=aaa(f,p,g,d,C,N);if((b|0)==1){break Kb}Eb(157874,2666);v[j+528>>2]=b;Fb(276579,j+528|0);break Ha}Lb:{if((V|0)==v[d+496>>2]&(G|0)==v[d+500>>2]){break Lb}b=Rr(p,g,X,xa,d,l,O,k,n,f,L,C,N,ca,0,0,i);if((b|0)==1){break Lb}Eb(157874,2676);v[j+512>>2]=b;Fb(276579,j+512|0);break Ha}if(v[i>>2]){break Db}b=al(f,g,R,p,d,C,N,l,v[g+936>>2],v[g+940>>2],0,1,0,t);if((b|0)!=1){Eb(157874,2686);v[j+496>>2]=b;Fb(276579,j+496|0);break Ha}b=aq(p,g,d,l,J,k,f,v[t>>2]);if((b|0)!=1){Eb(157874,2691);v[j+480>>2]=b;Fb(276579,j+480|0);break Ha}if(v[t>>2]){break Db}Mb:{if(!(c^1|fa)|(r|0)==v[d+424>>2]&(s|0)==v[d+428>>2]|(v[i>>2]|v[f+320>>2]!=v[l+112>>2])){break Mb}if(v[g+176>>2]|!v[f+500>>2]){break Mb}b=Nr(ra,g,d,k,l,O,f);if((b|0)!=1){Eb(157874,2704);v[j+464>>2]=b;Fb(276579,j+464|0);break Ha}b=yz(g,d,k,f,L);if((b|0)!=1){Eb(157874,2709);v[j+448>>2]=b;Fb(276579,j+448|0);break Ha}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=1|aa){break Mb}ZF(l,g,d,f)}Nb:{Ob:{Pb:{if(((v[f+468>>2]?v[f+420>>2]:0)|0)==1){b=xx(L,g,d,f,0,0,0,j+1132|0,0,0);if((b|0)==1){o=xk(f,g,l);b=v[j+1132>>2];if((z|0)!=1){break Ob}pa=o-E;E=D(E);T=D(o);if(!(pa/(T<=1?E<=1?1:E:E<=T?T:E)<=1e-4)){break Ob}T=+(m|0);E=o;m=b;if(+(b|0)>=T*(+(Q|0)*-.1+.9)){break Pb}break Ob}Eb(157874,2728);v[j+432>>2]=b;Fb(276579,j+432|0);break Ha}o=E;b=m;if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=(z|0)){break Ob}}o=E;b=m;Q=Q+1|0;break Nb}v[f+504>>2]=0;Q=0}z=v[f+468>>2]?v[f+420>>2]:0;if((Q|0)>=(Bb|0)){v[f+504>>2]=1}m=b;E=o}v[d+1204>>2]=v[d+1204>>2]+1}if(!v[i>>2]){continue}break}}if(!((Q|0)<(Ha|0)|aa)){b=v[g+800>>2];v[j+400>>2]=Ha;yd(R,b,5,349646,j+400|0)}Qb:{if(v[t>>2]){break Qb}b=i3(g,d,l,k,f,0,v[g+524>>2]);if((b|0)==1){break Qb}Eb(157874,2785);v[j+384>>2]=b;Fb(276579,j+384|0);break Ha}Rb:{Sb:{if(v[i>>2]){bo(ra,d,g,k,l,O,A[g+1272>>3]);break Sb}if(v[t>>2]){break Rb}Tb:{if(!v[f+500>>2]){break Tb}b=Nr(ra,g,d,k,l,O,f);if((b|0)==1){break Tb}Eb(157874,2800);v[j+368>>2]=b;Fb(276579,j+368|0);break Ha}b=yz(g,d,k,f,L);if((b|0)!=1){Eb(157874,2804);v[j+352>>2]=b;Fb(276579,j+352|0);break Ha}Ub:{if(((v[f+468>>2]?v[f+420>>2]:0)|0)==5|((v[f+468>>2]?v[f+420>>2]:0)|0)==6){break Ub}b=j+1152|0;v[b+24>>2]=16777216;v[b+28>>2]=0;b=qx(b,ra);if((b|0)!=1){Eb(157874,2810);v[j+320>>2]=b;Fb(276579,j+320|0);break Ha}b=vp(j+1152|0,g,0,0,0,N);if((b|0)==1){break Ub}Eb(157874,2811);v[j+304>>2]=b;Fb(276579,j+304|0);break Ha}if(v[g+1172>>2]|!aa|(!v[f+500>>2]|v[f+320>>2]!=v[l+112>>2])){break Sb}if(v[g+176>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=2&((v[f+468>>2]?v[f+420>>2]:0)|0)!=4){break Sb}b=XR(ba,nb,p,g,d,l,O,k,n,f,L,C,ca);if((b|0)!=1){Eb(157874,2821);v[j+288>>2]=b;Fb(276579,j+288|0);break Ha}v[i>>2]=1}if(v[t>>2]){break Rb}v[K>>2]=((v[f+468>>2]?v[f+420>>2]:0)|0)==3}v[f+504>>2]=0;Vb:{if((qa|0)!=v[d+496>>2]|(tb|0)!=v[d+500>>2]|v[X+36>>2]!=(wb|0)|v[l+112>>2]!=(vb|0)){break Vb}if((Ga|0)!=v[d+432>>2]|(Ab|0)!=v[d+436>>2]){break Vb}if((Da|0)==v[d+424>>2]&(xb|0)==v[d+428>>2]){break Ia}}v[Z>>2]=1;fN(g,W)}if(!v[la>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=4&((v[f+468>>2]?v[f+420>>2]:0)|0)!=5){break Fa}if(v[i>>2]){break Fa}o=A[f+72>>3];E=A[v[v[v[f+168>>2]>>2]+20>>2]+192>>3];v[f+472>>2]=0;A[f+72>>3]=E;b=al(f,g,R,p,d,C,N,l,-1,-1,0,0,0,t);if((b|0)==1){break Ga}Eb(157874,3125);v[j+256>>2]=b;Fb(276579,j+256|0);break sa}Eb(157874,3094);v[j+272>>2]=b;Fb(276579,j+272|0);break sa}A[f+72>>3]=o;if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=2){break Fa}v[i>>2]=1}m=v[d+936>>2];c=m-U|0;K=v[d+1032>>2];b=c+K|0;V=v[d+940>>2];U=V-((m>>>0<U>>>0)+bb|0)|0;r=U+v[d+1036>>2]|0;v[d+1032>>2]=b;v[d+1036>>2]=b>>>0<K>>>0?r+1|0:r;b=v[d+8>>2];K=b-P|0;Q=v[d+88>>2];z=K+Q|0;qa=v[d+12>>2]-((b>>>0<P>>>0)+ab|0)|0;b=qa+v[d+92>>2]|0;v[d+88>>2]=z;v[d+92>>2]=z>>>0<Q>>>0?b+1|0:b;Da=v[d+1040>>2];Ga=v[d+1044>>2];s=v[d+1e3>>2];M=v[d+1004>>2];G=v[d+960>>2];aa=v[d+964>>2];z=v[d+976>>2];_=v[d+980>>2];r=rb+sb|0;Q=ma+ya|0;b=qb+(Q>>>0<ma>>>0?r+1|0:r)|0;Q=Q+ha|0;b=(_-((Q>>>0<ha>>>0?b+1|0:b)+(z>>>0<Q>>>0)|0)|0)+aa|0;P=z-Q|0;z=G+P|0;b=(P>>>0>z>>>0?b+1|0:b)+M|0;ta=z;z=s+z|0;r=(ta>>>0>z>>>0?b+1|0:b)+Ga|0;b=z+Da|0;r=b>>>0<z>>>0?r+1|0:r;v[d+1040>>2]=b;v[d+1044>>2]=r;if(!x[v[k+12>>2]+40>>1]){b=U+v[d+948>>2]|0;s=c;c=c+v[d+944>>2]|0;b=s>>>0>c>>>0?b+1|0:b;v[d+944>>2]=c;v[d+948>>2]=b;c=qa+v[d+20>>2]|0;b=K+v[d+16>>2]|0;c=b>>>0<K>>>0?c+1|0:c;v[d+16>>2]=b;v[d+20>>2]=c}v[_a>>2]=1;v[Ca>>2]=0;v[i>>2]=v[i>>2]?1:v[k+180>>2]<=(ea|0);if(!v[t>>2]){break qa}if(!ka){break ra}Eb(157874,3917);b=v[d+168>>2];c=v[d+172>>2];h=v[d+940>>2];v[j+232>>2]=v[d+936>>2];v[j+236>>2]=h;v[j+224>>2]=b;v[j+228>>2]=c;Fb(277107,j+224|0);b=-6;break fa}Eb(157874,3900);v[j+240>>2]=b;Fb(276579,j+240|0);break fa}v[k+196>>2]=0;b=v[Za>>2]+1|0;v[Za>>2]=b;c=v[g+800>>2];K=v[d+168>>2];z=v[d+172>>2];v[j+208>>2]=b;v[j+200>>2]=m;v[j+204>>2]=V;v[j+192>>2]=K;v[j+196>>2]=z;yd(R,c,ea?5:4,358460,j+192|0)}if(!(((v[f+468>>2]?v[f+420>>2]:0)|0)!=6&((v[f+468>>2]?v[f+420>>2]:0)|0)!=5)){v[k+196>>2]=0;v[$a>>2]=1;m=v[g+800>>2];b=v[d+168>>2];K=v[d+172>>2];c=v[f+468>>2]?v[f+420>>2]:0;z=v[d+940>>2];v[j+176>>2]=v[d+936>>2];v[j+180>>2]=z;v[j+160>>2]=b;v[j+164>>2]=K;v[j+168>>2]=(c|0)==6?117337:80684;yd(R,m,ea?5:4,300338,j+160|0)}if(((v[f+468>>2]?v[f+420>>2]:0)|0)==3){b=v[g+800>>2];c=v[d+168>>2];m=v[d+172>>2];K=v[d+940>>2];v[j+152>>2]=v[d+936>>2];v[j+156>>2]=K;v[j+144>>2]=c;v[j+148>>2]=m;yd(R,b,5,357664,j+144|0)}Wb:{if(!(v[g+1172>>2]|v[la>>2])|(v[i>>2]|v[t>>2])){break Wb}if(!(A[ua+8>>3]<A[J+40>>3])|((v[f+468>>2]?v[f+420>>2]:0)|0)!=2){break Wb}if(!(v[L+96>>2]|v[l+108>>2]<=0)){Eb(157874,3952);b=v[d+168>>2];c=v[d+172>>2];h=v[d+936>>2];i=v[d+940>>2];m=v[g+1172>>2];K=v[la>>2];v[j+104>>2]=v[l+108>>2];v[j+100>>2]=K;v[j+96>>2]=m;v[j+88>>2]=h;v[j+92>>2]=i;v[j+80>>2]=b;v[j+84>>2]=c;Fb(262761,j+80|0);Eb(157874,3954);b=v[d+172>>2];v[j+64>>2]=v[d+168>>2];v[j+68>>2]=b;Fb(357776,j- -64|0);b=-6;break fa}v[k+196>>2]=0;v[$a>>2]=1;b=v[g+800>>2];c=v[d+168>>2];m=v[d+172>>2];K=v[d+936>>2];t=v[d+940>>2];z=v[g+1172>>2];Q=v[la>>2];v[j+136>>2]=v[L+96>>2];v[j+132>>2]=Q;v[j+128>>2]=z;v[j+120>>2]=K;v[j+124>>2]=t;v[j+112>>2]=c;v[j+116>>2]=m;yd(R,b,5,300418,j+112|0)}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,i);if((b|0)==1){break pa}Eb(157874,3971);v[j+48>>2]=b;Fb(276579,j+48|0);break fa}v[Z>>2]=v[Z>>2]?v[Fa>>2]!=0:0;if(!h){b=1;break fa}b=1;if(v[i>>2]){break fa}b=j3(g,d,k,l,O,ea,0,i,va,Ca,Z,Fa);if((b|0)!=1){Eb(157874,3985);v[j+32>>2]=b;Fb(276579,j+32|0);break fa}v[i>>2]=v[i>>2]?1:v[k+180>>2]<=(ea|0);b=1;c=ME(p,g,d,l,O,k,n,f,W,X,L,C,N,ca,!ea,i,va,Ca,Z);if((c|0)!=1){Eb(157874,3994);v[j+16>>2]=c;Fb(276579,j+16|0);b=c;break fa}c=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,i);if((c|0)==1){break fa}Eb(157874,3998);v[j>>2]=c;Fb(276579,j);b=c}ub=j+1184|0;if((b|0)!=1){Eb(157874,4202);v[e+1040>>2]=b;Fb(276579,e+1040|0);break K}if(v[e+1164>>2]){break ba}b=v[e+1264>>2];m=$|b;if(!v[e+1240>>2]){continue}break}if(v[e+1180>>2]){break ca}}Y=v[k+180>>2]<=(ea|0)}v[e+1180>>2]=Y;if(v[k+148>>2]){break aa}q=1;q=v[e+1252>>2]?q:v[v[k+12>>2]+40>>2]>>>22&1;v[e+1252>>2]=q;if(v[g+208>>2]<=0){break $}c=v[e+1260>>2];if(!c){Y=0;while(1){Xb:{c=v[v[g+52>>2]+(Y<<2)>>2];c=v[c+48>>2]==v[d+208>>2]&v[c+52>>2]==v[d+212>>2];Y=Y+1|0;if((Y|0)>=v[g+208>>2]){break Xb}if(c){continue}}break}c=!c}v[e+1260>>2]=c;break $}IG(f,g);break M}q=0;v[e+1260>>2]=0;v[e+1252>>2]=0}Yb:{ma=v[e+1176>>2];if(ma){break Yb}if(v[e+1180>>2]){if((v[v[k+4>>2]+24>>2]+(v[k+156>>2]+v[k+148>>2]|0)|0)<=0){break Yb}}Zb:{if(!(ea|Oa)){Oa=1;b=Sr(g,d,l,J,k,f,0,28,v[e+1180>>2],e+1268|0,e+1172|0);if((b|0)==1){break Zb}Eb(157874,4228);v[e+1008>>2]=b;Fb(276579,e+1008|0);break K}if(!(b|v[W+8>>2])){break Zb}b=Sr(g,d,l,J,k,f,0,4,v[e+1180>>2],e+1268|0,e+1172|0);if((b|0)==1){break Zb}Eb(157874,4234);v[e+1024>>2]=b;Fb(276579,e+1024|0);break K}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,e+1180|0);if((b|0)==1){break Yb}Eb(157874,4239);v[e+992>>2]=b;Fb(276579,e+992|0);break K}if(v[f+532>>2]){if(ka){Eb(157874,4247);b=v[d+168>>2];c=v[d+172>>2];f=v[d+940>>2];v[e+984>>2]=v[d+936>>2];v[e+988>>2]=f;v[e+976>>2]=b;v[e+980>>2]=c;Fb(277107,e+976|0);b=-6;break K}v[k+196>>2]=0;v[f+532>>2]=0;b=v[e+1272>>2]+1|0;v[e+1272>>2]=b;c=v[g+800>>2];h=v[d+168>>2];i=v[d+172>>2];K=v[d+936>>2];j=v[d+940>>2];v[e+960>>2]=b;v[e+952>>2]=K;v[e+956>>2]=j;v[e+944>>2]=h;v[e+948>>2]=i;yd(R,c,5,358460,e+944|0)}qa=v[e+1244>>2];_b:{if(v[e+1180>>2]|!qa|((v[f+468>>2]?v[f+420>>2]:0)|0)==1){break _b}v[k+196>>2]=0;if(rc(g,d,0)){break _b}if(ka){Eb(157874,4270);b=v[d+168>>2];c=v[d+172>>2];f=v[d+940>>2];v[e+936>>2]=v[d+936>>2];v[e+940>>2]=f;v[e+928>>2]=b;v[e+932>>2]=c;Fb(277107,e+928|0);b=-6;break K}b=v[e+1272>>2]+1|0;v[e+1272>>2]=b;c=v[g+800>>2];h=v[d+168>>2];i=v[d+172>>2];K=v[d+936>>2];j=v[d+940>>2];v[e+912>>2]=b;v[e+904>>2]=K;v[e+908>>2]=j;v[e+896>>2]=h;v[e+900>>2]=i;yd(R,c,5,358460,e+896|0)}$b:{if(v[e+1180>>2]|!v[e+1268>>2]){break $b}q=1;v[e+1256>>2]=1;v[e+1252>>2]=1;v[e+1260>>2]=1;b=0;v[W+12>>2]=0;v[W+8>>2]=0;if(v[g+208>>2]<=0){break $b}while(1){c=v[v[g+52>>2]+(b<<2)>>2];v[c+48>>2]=-1;v[c+52>>2]=-1;b=b+1|0;if((b|0)<v[g+208>>2]){continue}break}}ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{b=v[u+348>>2];ic:{if(b|ea){b=(b|0)!=0;break ic}b=0;if(v[g+176>>2]|v[g+1580>>2]){break ic}c=v[g+1396>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break ic}c=v[g+920>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break ic}if(v[d+1368>>2]){break hc}c=v[l+92>>2];if(!(+v[d+1168>>2]>A[g+1416>>3]*+(c-v[l+108>>2]|0))){break ic}if(v[d+1144>>2]==1){break hc}b=+(c|0)<=(1-A[g+1432>>3])*+v[d+1172>>2]}v[u+348>>2]=b;Y=0;if(ma){z=0;break ac}if(b){z=0;break ac}if(v[e+1180>>2]){z=0;break ac}if(v[e+1260>>2]){z=0;break ac}if(v[e+1256>>2]){z=0;break ac}z=0;if(q){break ac}Ga=v[e+1236>>2];b=0;v[e+1288>>2]=0;if(!v[W+8>>2]|!v[W+12>>2]){break gc}if(v[k+196>>2]){b=A[W>>3]-xk(f,g,l)>A[g+1280>>3]}else{b=1}h=v[g+184>>2];if(!b|(h|0)<=0){break gc}i=v[g+36>>2];b=0;while(1){c=v[i+(b<<2)>>2];if(!(v[c+256>>2]|(v[c+464>>2]<=0?v[c+672>>2]:0))){q=5;b=v[g+800>>2];if(!(v[d+1388>>2]|(b|0)!=4)){v[d+1388>>2]=1;q=4}v[e+880>>2]=v[c+192>>2];yd(R,b,q,276996,e+880|0);b=0;break gc}b=b+1|0;if((h|0)!=(b|0)){continue}break}v[X+44>>2]=1;break fc}v[u+348>>2]=1;Y=0;z=0;break ac}b=!b;if(b&!v[k+196>>2]){break ec}v[X+44>>2]=1;M=0;K=0;if(b){break dc}}M=0;b=Az(e+1288|0,p,g,d,J,k,W);K=1;if((b|0)==1){break dc}Eb(157874,3383);v[e+864>>2]=b;Fb(276579,e+864|0);break cc}E=xs(f,g,l);T=A[v[k+12>>2]+8>>3];o=D(T);sa=A[g+1296>>3];v[X+44>>2]=1;pa=-sa;T=E-T;E=D(E);jc:{if(E<=1){E=1;if(o<=1){break jc}E=o;break jc}E=o<=E?E:o}M=pa>T/E;K=0}Da=0;ya=0;V=0;q=0;if(v[g+184>>2]>0){kc:{while(1){lc:{if(K){h=v[v[g+36>>2]+(q<<2)>>2];r=v[e+1288>>2];$=0;fa=0;ha=0;P=ub-48|0;ub=P;U=e+1292|0;v[U>>2]=4;mc:{nc:{j=v[d+928>>2];t=v[d+932>>2];if((j|0)!=v[h+424>>2]|(t|0)!=v[h+428>>2]|(v[h+136>>2]!=v[d+424>>2]|v[h+140>>2]!=v[d+428>>2])|(v[h+160>>2]!=v[d+168>>2]|v[h+164>>2]!=v[d+172>>2])){break nc}oc:{b=v[h+176>>2];switch(b-11|0){case 0:case 3:break nc;default:break oc}}if(!Mb(v[h+192>>2],92798)){break nc}if((b|0)==5){v[U>>2]=5}ha=(b|0)==5;s=v[h+512>>2];$=v[h+572>>2];b=s-$|0;i=b;break mc}fa=1;s=v[h+512>>2];b=s;i=v[h+508>>2]}pc:{if((i|0)<=0){c=1;if(v[h+672>>2]|!fa){break pc}}v[h+424>>2]=j;v[h+428>>2]=t;c=v[d+428>>2];v[h+136>>2]=v[d+424>>2];v[h+140>>2]=c;c=v[d+168>>2];j=v[d+172>>2];v[h+572>>2]=s;v[h+160>>2]=c;v[h+164>>2]=j;$=v[h+344>>2]+($<<2)|0;s=v[X+12>>2];Z=v[d+456>>2];G=v[d+460>>2];j=v[d+448>>2];aa=v[d+452>>2];Q=v[d+440>>2];_=v[d+444>>2];t=v[d+432>>2];fa=v[d+436>>2];da=v[d+1224>>2];c=v[h+452>>2];qc:{rc:{if(!c){if(!(v[h+24>>2]|v[h+28>>2])){break rc}break qc}if((c|0)<=0){break qc}if(_fb(v[h+24>>2],v[h+28>>2],c,0)|yb){break qc}}b=i}v[h+660>>2]=v[h+660>>2]+1;Ec(v[h+384>>2],g);c=zb[v[h+256>>2]](v[g+4>>2],r,h,$,i,b,Y,U)|0;if((c|0)!=1){Eb(147935,3274);v[P+32>>2]=c;Fb(276579,P+32|0);break pc}Hc(v[h+384>>2],g);c=dl(h,p,g,d);if((c|0)!=1){Eb(147935,3281);v[P+16>>2]=c;Fb(276579,P+16|0);break pc}r=v[h+28>>2];b=v[h+24>>2]+1|0;r=b?r:r+1|0;v[h+24>>2]=b;v[h+28>>2]=r;if(v[U>>2]==7){b=v[h+60>>2];c=v[h+56>>2]+1|0;b=c?b:b+1|0;v[h+56>>2]=c;v[h+60>>2]=b}b=v[X+12>>2]-s|0;i=b;c=b+v[h+64>>2]|0;b=v[h+68>>2]+(b>>31)|0;v[h+64>>2]=c;v[h+68>>2]=c>>>0<i>>>0?b+1|0:b;r=v[h+84>>2];b=v[d+1224>>2]-da|0;b=(b|0)>0?b:0;c=b;b=b+v[h+80>>2]|0;r=c>>>0>b>>>0?r+1|0:r;v[h+80>>2]=b;v[h+84>>2]=r;$=v[U>>2];sc:{if(($|0)!=13){b=G+aa|0;c=j+Z|0;b=c>>>0<j>>>0?b+1|0:b;Z=c;c=b;s=v[h+88>>2];r=v[h+92>>2];G=v[d+440>>2];i=v[d+432>>2];b=_+fa|0;j=t+Q|0;b=v[d+444>>2]+(v[d+436>>2]-((j>>>0<t>>>0?b+1|0:b)+(i>>>0<j>>>0)|0)|0)|0;t=i-j|0;i=t+G|0;r=(t>>>0>i>>>0?b+1|0:b)+r|0;b=i;i=i+s|0;b=(b>>>0>i>>>0?r+1|0:r)+c|0;c=i+Z|0;b=c>>>0<i>>>0?b+1|0:b;j=c;c=b;t=v[d+456>>2];i=t+v[d+448>>2]|0;b=v[d+452>>2]+v[d+460>>2]|0;b=i>>>0<t>>>0?b+1|0:b;v[h+88>>2]=j-i;v[h+92>>2]=c-((i>>>0>j>>>0)+b|0);break sc}b=v[k+148>>2];i=b;c=b+v[h+96>>2]|0;b=v[h+100>>2]+(b>>31)|0;v[h+96>>2]=c;v[h+100>>2]=c>>>0<i>>>0?b+1|0:b}v[h+176>>2]=$;tc:{b=v[U>>2];if(b>>>0<=14){c=1;if(1<<b&28080){break tc}}Eb(147935,3315);b=v[h+192>>2];v[P+4>>2]=v[U>>2];v[P>>2]=b;Fb(311597,P);c=-10;break pc}if(!ha|(b|0)!=4){break pc}v[U>>2]=5}ub=P+48|0;b=c;if((b|0)==1){break lc}Eb(157874,3396);v[e+800>>2]=b;Fb(276579,e+800|0);break cc}i=v[v[g+36>>2]+(q<<2)>>2];if(v[k+196>>2]){b=0;fa=0;ha=0;P=ub-48|0;ub=P;U=e+1292|0;v[U>>2]=4;uc:{if(!v[i+252>>2]){b=1;break uc}vc:{wc:{j=v[d+920>>2];t=v[d+924>>2];if((j|0)!=v[i+416>>2]|(t|0)!=v[i+420>>2]|(v[i+120>>2]!=v[d+424>>2]|v[i+124>>2]!=v[d+428>>2])|(v[i+144>>2]!=v[d+168>>2]|v[i+148>>2]!=v[d+172>>2])){break wc}xc:{switch(v[i+168>>2]-4|0){default:v[U>>2]=5;ha=1;break;case 7:break wc;case 0:break xc}}$=v[i+512>>2];b=v[i+572>>2];h=$-b|0;c=h;break vc}fa=1;$=v[i+512>>2];h=$;c=v[i+508>>2]}yc:{if((c|0)<=0){b=1;if(v[i+672>>2]|!fa){break uc}v[i+416>>2]=j;v[i+420>>2]=t;b=v[d+428>>2];v[i+120>>2]=v[d+424>>2];v[i+124>>2]=b;b=v[d+168>>2];j=v[d+172>>2];v[i+572>>2]=$;v[i+144>>2]=b;v[i+148>>2]=j;b=0;break yc}v[i+416>>2]=j;v[i+420>>2]=t;j=v[d+428>>2];v[i+120>>2]=v[d+424>>2];v[i+124>>2]=j;j=v[d+168>>2];t=v[d+172>>2];v[i+572>>2]=$;v[i+144>>2]=j;v[i+148>>2]=t;b=v[i+344>>2]+(b<<2)|0}$=v[X+12>>2];Z=v[d+456>>2];s=v[d+460>>2];j=v[d+448>>2];G=v[d+452>>2];Q=v[d+440>>2];aa=v[d+444>>2];t=v[d+432>>2];_=v[d+436>>2];fa=v[d+1224>>2];r=v[i+452>>2];zc:{Ac:{if(!r){if(!(v[i+8>>2]|v[i+12>>2])){break Ac}break zc}if((r|0)<=0){break zc}if(_fb(v[i+8>>2],v[i+12>>2],r,0)|yb){break zc}}h=c}v[i+660>>2]=v[i+660>>2]+1;Ec(v[i+376>>2],g);b=zb[v[i+252>>2]](v[g+4>>2],i,b,c,h,Y,U)|0;if((b|0)!=1){Eb(147935,3454);v[P+32>>2]=b;Fb(276579,P+32|0);break uc}Hc(v[i+376>>2],g);b=dl(i,p,g,d);if((b|0)!=1){Eb(147935,3461);v[P+16>>2]=b;Fb(276579,P+16|0);break uc}b=v[U>>2];v[i+168>>2]=b;r=v[i+12>>2];c=v[i+8>>2]+1|0;r=c?r:r+1|0;v[i+8>>2]=c;v[i+12>>2]=r;if((b|0)==7){b=v[i+60>>2];c=v[i+56>>2]+1|0;b=c?b:b+1|0;v[i+56>>2]=c;v[i+60>>2]=b}b=v[X+12>>2]-$|0;h=b;c=b+v[i+64>>2]|0;b=v[i+68>>2]+(b>>31)|0;v[i+64>>2]=c;v[i+68>>2]=c>>>0<h>>>0?b+1|0:b;r=v[i+84>>2];b=v[d+1224>>2]-fa|0;b=(b|0)>0?b:0;c=b;b=b+v[i+80>>2]|0;r=c>>>0>b>>>0?r+1|0:r;v[i+80>>2]=b;v[i+84>>2]=r;h=v[U>>2];if((h|0)!=13){b=s+G|0;c=j+Z|0;b=c>>>0<j>>>0?b+1|0:b;$=c;c=b;s=v[i+88>>2];r=v[i+92>>2];G=v[d+440>>2];j=v[d+432>>2];b=aa+_|0;Z=t;t=t+Q|0;b=v[d+444>>2]+(v[d+436>>2]-((Z>>>0>t>>>0?b+1|0:b)+(j>>>0<t>>>0)|0)|0)|0;Z=j-t|0;j=G+Z|0;r=(Z>>>0>j>>>0?b+1|0:b)+r|0;b=j+s|0;c=(b>>>0<j>>>0?r+1|0:r)+c|0;j=b;b=b+$|0;c=j>>>0>b>>>0?c+1|0:c;t=b;Z=v[d+456>>2];j=Z+v[d+448>>2]|0;b=v[d+452>>2]+v[d+460>>2]|0;b=j>>>0<Z>>>0?b+1|0:b;v[i+88>>2]=t-j;v[i+92>>2]=c-((j>>>0>t>>>0)+b|0);Bc:{if(h>>>0<=14){b=1;if(1<<h&19888){break Bc}}Eb(147935,3494);b=v[i+192>>2];v[P+4>>2]=v[U>>2];v[P>>2]=b;Fb(311696,P);b=-10;break uc}if(!((h|0)==4&ha)){break uc}v[U>>2]=5;break uc}b=v[k+148>>2];h=b;c=b+v[i+96>>2]|0;b=v[i+100>>2]+(b>>31)|0;v[i+96>>2]=c;v[i+100>>2]=c>>>0<h>>>0?b+1|0:b;b=1}ub=P+48|0;if((b|0)==1){break lc}Eb(157874,3406);v[e+848>>2]=b;Fb(276579,e+848|0);break cc}P=e+1292|0;$=0;fa=0;ha=0;U=ub+-64|0;ub=U;Cc:{Dc:{if(!v[g+796>>2]){break Dc}c=1;if(v[L+96>>2]<=0){break Dc}v[P>>2]=5;break Cc}v[P>>2]=4;if(!v[i+260>>2]){c=1;break Cc}Ec:{Fc:{Gc:{if(v[i+128>>2]!=v[d+424>>2]|v[i+132>>2]!=v[d+428>>2]|Ga|(v[i+152>>2]!=v[d+168>>2]|v[i+156>>2]!=v[d+172>>2])){break Gc}Hc:{switch(v[i+172>>2]-5|0){case 0:v[P>>2]=5;$=1;break;case 6:case 9:break Gc;default:break Hc}}s=v[i+512>>2];fa=v[i+572>>2];h=s-fa|0;b=h;break Fc}ha=1;s=v[i+512>>2];h=s;b=v[i+508>>2]}if((b|0)<=0){c=1;if(v[i+672>>2]|!ha){break Ec}}c=v[d+428>>2];v[i+128>>2]=v[d+424>>2];v[i+132>>2]=c;c=v[d+168>>2];j=v[d+172>>2];v[i+572>>2]=s;v[i+152>>2]=c;v[i+156>>2]=j;r=v[i+344>>2]+(fa<<2)|0;Z=v[d+456>>2];ha=v[d+460>>2];j=v[d+448>>2];s=v[d+452>>2];Q=v[d+440>>2];G=v[d+444>>2];t=v[d+432>>2];aa=v[d+436>>2];c=v[i+452>>2];Ic:{Jc:{if(!c){if(!(v[i+16>>2]|v[i+20>>2])){break Jc}break Ic}if((c|0)<=0){break Ic}if(_fb(v[i+16>>2],v[i+20>>2],c,0)|yb){break Ic}}h=b}v[i+660>>2]=v[i+660>>2]+1;Ec(v[i+380>>2],g);c=zb[v[i+260>>2]](v[g+4>>2],i,r,b,h,Y,M,P)|0;if((c|0)!=1){Eb(147935,3663);v[U+48>>2]=c;Fb(276579,U+48|0);break Cc}Hc(v[i+380>>2],g);c=dl(i,p,g,d);if((c|0)!=1){Eb(147935,3670);v[U+32>>2]=c;Fb(276579,U+32|0);break Cc}Kc:{Lc:{h=v[P>>2];Mc:{if((h|0)==1){if(!M){Eb(147935,3677);v[U>>2]=v[i+192>>2];Fb(286764,U);v[i+172>>2]=v[P>>2];c=-10;break Cc}h=5;v[P>>2]=5;break Mc}r=v[i+20>>2];b=v[i+16>>2]+1|0;r=b?r:r+1|0;v[i+16>>2]=b;v[i+20>>2]=r;Nc:{switch(h-7|0){case 6:break Lc;case 0:break Nc;default:break Mc}}c=v[i+60>>2];b=v[i+56>>2]+1|0;c=b?c:c+1|0;v[i+56>>2]=b;v[i+60>>2]=c;h=7}b=s+ha|0;c=j+Z|0;b=c>>>0<j>>>0?b+1|0:b;Z=c;j=b;ha=v[i+88>>2];s=v[i+92>>2];_=v[d+440>>2];fa=v[d+444>>2];b=v[d+432>>2];da=v[d+436>>2];r=G+aa|0;c=t+Q|0;r=c>>>0<t>>>0?r+1|0:r;t=b-c|0;b=(da-((b>>>0<c>>>0)+r|0)|0)+fa|0;c=t;t=t+_|0;c=(c>>>0>t>>>0?b+1|0:b)+s|0;b=t;t=t+ha|0;b=(b>>>0>t>>>0?c+1|0:c)+j|0;c=t+Z|0;b=c>>>0<t>>>0?b+1|0:b;j=c;t=v[d+456>>2];c=t+v[d+448>>2]|0;r=v[d+452>>2]+v[d+460>>2]|0;r=c>>>0<t>>>0?r+1|0:r;v[i+88>>2]=j-c;v[i+92>>2]=b-((c>>>0>j>>>0)+r|0);break Kc}b=v[k+148>>2];h=b;c=b+v[i+96>>2]|0;b=v[i+100>>2]+(b>>31)|0;v[i+96>>2]=c;v[i+100>>2]=c>>>0<h>>>0?b+1|0:b;h=13}v[i+172>>2]=h;Oc:{b=v[P>>2];if(b>>>0<=14){c=1;if(1<<b&27826){break Oc}}Eb(147935,3717);b=v[i+192>>2];v[U+20>>2]=v[P>>2];v[U+16>>2]=b;Fb(311502,U+16|0);c=-10;break Cc}if(!$|(b|0)!=4){break Cc}v[P>>2]=5;break Cc}if(!M){break Cc}v[P>>2]=5}ub=U- -64|0;b=c;if((b|0)!=1){Eb(157874,3411);v[e+832>>2]=b;Fb(276579,e+832|0);break cc}if(!v[X+12>>2]){break lc}Eb(157874,3414);v[e+816>>2]=v[v[v[g+36>>2]+(q<<2)>>2]+192>>2];Fb(260318,e+816|0);b=-10;break cc}b=0;Pc:{Qc:{Rc:{Sc:{Tc:{Uc:{Vc:{switch(v[e+1292>>2]-1|0){case 10:v[W+12>>2]=0;v[W+8>>2]=0;Y=1;if(v[g+208>>2]<=0){break Uc}while(1){c=v[v[g+52>>2]+(b<<2)>>2];v[c+48>>2]=-1;v[c+52>>2]=-1;b=b+1|0;if((b|0)<v[g+208>>2]){continue}break};break Uc;case 9:v[W+12>>2]=0;v[W+8>>2]=0;Y=1;if(v[g+208>>2]<=0){break Uc}while(1){c=v[v[g+52>>2]+(b<<2)>>2];v[c+48>>2]=-1;v[c+52>>2]=-1;b=b+1|0;if((b|0)<v[g+208>>2]){continue}break};break Uc;case 7:v[W+12>>2]=0;v[W+8>>2]=0;Y=1;if(v[g+208>>2]<=0){break Tc}while(1){c=v[v[g+52>>2]+(b<<2)>>2];v[c+48>>2]=-1;v[c+52>>2]=-1;b=b+1|0;if((b|0)<v[g+208>>2]){continue}break};break Tc;case 12:c=v[d+180>>2];b=v[d+176>>2]+1|0;c=b?c:c+1|0;v[d+176>>2]=b;v[d+180>>2]=c;b=v[d+220>>2];c=v[d+216>>2]+1|0;b=c?b:b+1|0;v[d+216>>2]=c;v[d+220>>2]=b;Y=1;z=1;break Sc;case 13:Y=1;v[k+196>>2]=1;V=1;b=1;break Qc;case 0:case 4:Y=1;break Rc;default:Eb(157874,3508);b=v[e+1292>>2];v[e+740>>2]=v[v[v[g+36>>2]+(q<<2)>>2]+192>>2];v[e+736>>2]=b;Fb(307139,e+736|0);b=-10;break cc;case 3:break Rc;case 6:break Vc}}Y=1;v[e+1180>>2]=1;break Sc}Da=1}ya=1;V=1}b=1}if(!v[k+196>>2]){break Pc}}if(((v[f+468>>2]?v[f+420>>2]:0)|0)!=4){break Pc}Y=1;v[e+1180>>2]=1;v[e+1260>>2]=ya;v[e+1252>>2]=0;v[e+1256>>2]=0;break kc}if(!b){q=q+1|0;if((q|0)<v[g+184>>2]){continue}}break}v[e+1260>>2]=ya;v[e+1256>>2]=V;v[e+1252>>2]=Da}}if(!K){break bc}b=Qg(e+1288|0,p,J);if((b|0)==1){break bc}Eb(157874,3544);v[e+784>>2]=b;Fb(276579,e+784|0)}Eb(157874,4314);v[e+720>>2]=b;Fb(276579,e+720|0);break K}v[X+44>>2]=0;b=ME(p,g,d,l,O,k,n,f,W,X,L,C,N,ca,Ya,e+1180|0,e+1252|0,e+1256|0,e+1260|0);if((b|0)!=1){Eb(157874,4327);v[e+768>>2]=b;Fb(276579,e+768|0);break K}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,e+1180|0);if((b|0)!=1){Eb(157874,4330);v[e+752>>2]=b;Fb(276579,e+752|0);break K}l3(g,d,k,ea,e+1180|0,e+1252|0,e+1260|0)}Wc:{Xc:{Yc:{if(qa){if(Y){break Yc}Y=0;if(ma|v[e+1180>>2]){q=0;break Xc}q=0;if(v[u+348>>2]){break Xc}c=v[J+16>>2];h=v[J+20>>2];Zc:{_c:{if(!v[W+8>>2]|!v[W+12>>2]){break _c}if(v[k+196>>2]){if(!(A[W>>3]-xk(f,g,l)>A[g+1280>>3])){break _c}}b=Az(e+1228|0,p,g,d,J,k,W);if((b|0)!=1){c=4354;break L}b=bP(J,p,g,R,d,O,l,k,n,f,C,N,v[e+1228>>2],1,1,1,e+1288|0);if((b|0)!=1){c=4358;break L}b=Qg(e+1228|0,p,J);if((b|0)!=1){c=4360;break L}if(!v[e+1288>>2]){break Zc}b=v[d+332>>2];i=v[d+328>>2]+1|0;b=i?b:b+1|0;v[d+328>>2]=i;v[d+332>>2]=b;if((c|0)==v[J+16>>2]&(h|0)==v[J+20>>2]){break Zc}c=v[d+364>>2];b=v[d+360>>2]+1|0;c=b?c:c+1|0;v[d+360>>2]=b;v[d+364>>2]=c;on(v[g+4>>2]);break Zc}b=vw(e+1292|0,p,g,d,l,J,k,f,0);if((b|0)!=1){Eb(157874,4375);v[e+688>>2]=b;Fb(276579,e+688|0);break K}b=du(J,p,g,R,d,O,l,k,n,f,C,N,e+1292|0,0,0,1,1,1,e+1288|0);if((b|0)!=1){Eb(157874,4377);v[e+672>>2]=b;Fb(276579,e+672|0);break K}if(!v[e+1288>>2]){break Zc}r=v[d+324>>2];b=v[d+320>>2]+1|0;r=b?r:r+1|0;v[d+320>>2]=b;v[d+324>>2]=r;if((c|0)==v[J+16>>2]&(h|0)==v[J+20>>2]){break Zc}b=v[d+356>>2];c=v[d+352>>2]+1|0;b=c?b:b+1|0;v[d+352>>2]=c;v[d+356>>2]=b;on(v[g+4>>2])}Y=1;break Yc}if(Y){break Yc}Y=0;q=0;break Xc}q=0;if(ma|v[e+1180>>2]){break Xc}if(v[u+348>>2]){b=1;break Wc}$c:{if(!(!v[e+1172>>2]|v[L+68>>2]>0)){if(v[L+96>>2]<=0){break Xc}if(!v[e+1260>>2]){break $c}break Xc}if(v[e+1260>>2]){break Xc}}if(z|(v[e+1256>>2]|v[e+1252>>2])){break Xc}v[e+1292>>2]=1;v[e+1288>>2]=0;ad:{bd:{if(v[k+196>>2]){b=xx(L,g,d,f,0,0,0,e+1288|0,0,0);if((b|0)!=1){Eb(157874,4415);v[e+656>>2]=b;Fb(276579,e+656|0);break K}if(v[e+1288>>2]>0){break bd}}if(v[L+68>>2]<=0){break ad}}o=A[J+40>>3];if(!(v[L+60>>2]<v[L+88>>2]|v[e+1288>>2]<=0)){b=Cca(p,g,d,l,O,k,n,f,X,L,C,o,0,e+1292|0);if((b|0)==1){break ad}Eb(157874,4433);v[e+624>>2]=b;Fb(276579,e+624|0);break K}b=Bca(p,g,d,l,O,k,n,f,X,L,C,o,e+1292|0);if((b|0)==1){break ad}Eb(157874,4446);v[e+640>>2]=b;Fb(276579,e+640|0);break K}b=v[e+1292>>2];if((b&-3)==1){b=CH(p,g,d,l,O,k,n,f,L,C,A[J+40>>3],1,e+1292|0);if((b|0)!=1){break Z}b=v[e+1292>>2]}cd:{dd:{ed:{if((b|0)==13){b=v[d+884>>2];if(v[d+1384>>2]|!b|(v[b+376>>2]&192)!=192){break ed}E=A[g+1272>>3];o=A[b+152>>3];c=E<=-o;T=E;E=A[b+160>>3];if(!(c|T<=E)){break ed}c=v[g+800>>2];b=v[b+208>>2];A[e+592>>3]=E;A[e+584>>3]=o;v[e+576>>2]=b;yd(R,c,3,327892,e+576|0);v[d+1384>>2]=1;b=v[e+1292>>2]}fd:{gd:{hd:{id:{jd:{kd:{ld:{switch(b-1|0){case 12:break ed;case 6:break hd;case 0:case 2:break id;case 7:break jd;case 9:break kd;case 10:break ld;default:break fd}}if(v[e+1288>>2]<=0){break kd}Eb(157874,4487);Fb(286006,0);b=-10;break K}v[e+1256>>2]=1;v[e+1252>>2]=1;v[e+1260>>2]=1;fN(g,W);break dd}v[e+1260>>2]=1;v[e+1256>>2]=1;fN(g,W);break dd}if(v[l+108>>2]|v[g+176>>2]){break gd}}v[e+1180>>2]=1;break dd}md:{if(!(((v[f+468>>2]?v[f+420>>2]:0)|0)==6|((v[f+468>>2]?v[f+420>>2]:0)|0)==5)){if(!rc(g,d,0)){break md}}b=Bm(e+1228|0,p,g,d,k,1,A[ua+16>>3]);if((b|0)==1){break dd}Eb(157874,4550);v[e+544>>2]=b;Fb(276579,e+544|0);break K}if(qa){Eb(157874,4561);Fb(362729,0);b=-10;break K}if(ka){Eb(157874,4568);Fb(362624,0);b=-10;break K}q=5;b=v[g+800>>2];if(!(v[k+232>>2]|(b|0)!=4)){v[k+232>>2]=1;q=4}c=v[d+168>>2];h=v[d+172>>2];i=v[d+940>>2];v[e+568>>2]=v[d+936>>2];v[e+572>>2]=i;v[e+560>>2]=c;v[e+564>>2]=h;yd(R,b,q,348825,e+560|0);v[k+196>>2]=1;v[e+1256>>2]=1;q=1;break cd}Eb(157874,4595);v[e+528>>2]=v[e+1292>>2];Fb(360285,e+528|0);b=-10;break K}c=v[d+180>>2];b=v[d+176>>2]+1|0;c=b?c:c+1|0;v[d+176>>2]=b;v[d+180>>2]=c;b=v[d+220>>2];c=v[d+216>>2]+1|0;b=c?b:b+1|0;v[d+216>>2]=c;v[d+220>>2]=b}q=0}b=ME(p,g,d,l,O,k,n,f,W,X,L,C,N,ca,Ya,e+1180|0,e+1252|0,e+1256|0,e+1260|0);if((b|0)!=1){Eb(157874,4608);v[e+512>>2]=b;Fb(276579,e+512|0);break K}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,e+1180|0);if((b|0)!=1){Eb(157874,4611);v[e+496>>2]=b;Fb(276579,e+496|0);break K}l3(g,d,k,ea,e+1180|0,e+1252|0,e+1260|0)}b=v[u+348>>2];nd:{if(b|ea){b=(b|0)!=0;break nd}b=0;if(v[g+176>>2]|v[g+1580>>2]){break nd}c=v[g+1396>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break nd}c=v[g+920>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break nd}if(v[d+1368>>2]){b=1;break Wc}c=v[l+92>>2];if(!(+v[d+1168>>2]>A[g+1416>>3]*+(c-v[l+108>>2]|0))){break nd}b=1;if(v[d+1144>>2]==1){break nd}b=+(c|0)<=(1-A[g+1432>>3])*+v[d+1172>>2]}}ka=q;v[u+348>>2]=b;if(!(v[e+1252>>2]|(v[e+1260>>2]|v[e+1256>>2]))|(ma|v[e+1180>>2])){break _}q=0;if(v[e+1272>>2]<=9){continue}break}}b=zH(ba,p,g,d,l,O,k,n,f,L,C,ca);if((b|0)!=1){Eb(157874,4629);v[e+480>>2]=b;Fb(276579,e+480|0);break K}if(v[e+1272>>2]>=10){Eb(157874,4634);b=v[d+168>>2];c=v[d+172>>2];f=v[d+940>>2];v[e+72>>2]=v[d+936>>2];v[e+76>>2]=f;v[e+64>>2]=b;v[e+68>>2]=c;Fb(278093,e- -64|0);b=-6;break K}E=A[g+1424>>3];if(!ea){o=A[g+1408>>3];E=o>=E?E:o}b=1;od:{if(v[u+348>>2]){break od}if(v[g+176>>2]){b=0;break od}if(v[g+1580>>2]){b=0;break od}c=v[g+1396>>2];if(!((c|0)==-1|(c|0)>=v[d+1144>>2])){b=0;break od}c=v[g+920>>2];if(!((c|0)==-1|(c|0)>=v[d+1144>>2])){b=0;break od}if(v[d+1368>>2]){break od}b=0;c=v[l+92>>2];if(!(+v[d+1168>>2]>E*+(c-v[l+108>>2]|0))){break od}b=1;if(v[d+1144>>2]==1){break od}b=+(c|0)<=(1-A[g+1432>>3])*+v[d+1172>>2]}v[u+348>>2]=b;b=v[e+1180>>2];pd:{qd:{rd:{if(!ea){if(b){break rd}if(v[e+1172>>2]){break N}if(v[e+1176>>2]){break pd}m=0;E=0;c=v[k+196>>2];if(c){if(v[l+92>>2]>0){while(1){b=v[v[l+68>>2]+(m<<2)>>2];sd:{if(c){if((v[b+376>>2]&1792)==512){h=v[b+176>>2];if(v[h+224>>2]<0){A[b+24>>3]=0;break sd}A[b+24>>3]=A[h+72>>3];break sd}A[b+24>>3]=ae(b);break sd}A[b+24>>3]=Cr(b)}m=m+1|0;if((m|0)<v[l+92>>2]){continue}break}}v[f+496>>2]=v[f+500>>2];td:{if(!v[f+468>>2]){v[f+56>>2]=-1568170194;v[f+60>>2]=1417495214;A[f+64>>3]=1e99;break td}A[f+56>>3]=A[f>>3];if(v[f+356>>2]>0){A[f+64>>3]=-A[g+1272>>3];break td}if(v[f+436>>2]){A[f+64>>3]=A[f+8>>3];break td}i=v[l+68>>2];h=v[l+92>>2];v[f+8>>2]=0;v[f+12>>2]=0;if((h|0)>0){b=0;while(1){c=v[i+(b<<2)>>2];ud:{if((v[c+376>>2]&1792)!=256){break ud}o=A[c>>3];sa=A[g+1280>>3];vd:{if(o>sa){T=A[c+152>>3];if(!(A[g+1272>>3]<=-T)){break vd}}if(!(o<-sa)){break ud}T=A[c+160>>3];if(T>=A[g+1272>>3]){break ud}}E=o*T+E;A[f+8>>3]=E}b=b+1|0;if((h|0)!=(b|0)){continue}break}}v[f+436>>2]=1;A[f+16>>3]=E;A[f+64>>3]=E}h=v[l+68>>2];c=v[l+104>>2]+(v[l+100>>2]+v[l+96>>2]|0)|0;b=0;A[d+752>>3]=v[f+468>>2]?A[f>>3]:1e99;wd:{if((c|0)<=0){break wd}while(1){i=h+(b<<2)|0;m=v[i>>2];if((v[m+376>>2]&192)==192){break wd}o=dh(m);A[d+752>>3]=LM(v[i>>2],d,g,o)+A[d+752>>3];b=b+1|0;if((c|0)!=(b|0)){continue}break}}}b=v[e+1180>>2]}if(!b){break qd}}bo(ua,d,g,k,l,O,A[g+1272>>3]);v[e+1172>>2]=0;Y=1;break N}if(v[e+1172>>2]){break N}}if(v[f+356>>2]|((v[f+468>>2]?v[f+420>>2]:0)|0)!=1){break N}b=xx(L,g,d,f,0,0,0,e+1292|0,0,0);if((b|0)==1){o=xk(f,g,l);V9(v[d>>2],+v[e+1292>>2],o);break N}Eb(157874,4674);v[e+464>>2]=b;Fb(276579,e+464|0);break K}Eb(157874,4457);v[e+608>>2]=b;Fb(276579,e+608|0);break K}Eb(157874,4945);v[e+1136>>2]=b;Fb(276579,e+1136|0);break J}IG(f,g);if(v[e+1164>>2]){break M}xd:{yd:{b=v[e+1176>>2];if(!(b|v[u+348>>2])){t=v[k+148>>2];m=v[e+1224>>2];M=0;E=0;i=ub-128|0;ub=i;c=v[d+888>>2];zd:{if(!(v[c>>2]|v[c+4>>2])|(v[m+40>>2]&983040)==65536){break zd}q=Pc(v[c+12>>2],m);ka=201056;b=v[m+36>>2];if(!(!b|!(v[b>>2]&1073741823))){b=v[b+4>>2];ka=w[b+28|0]&4?201420:201056;M=v[b+24>>2];E=A[b>>3]}Ad:{if(v[g+1900>>2]){o=bk(v[g+4>>2],A[m+8>>3]);break Ad}o=A[m+8>>3]}K=v[c>>2];if(!K){break zd}T=o;Bd:{if(v[c+32>>2]){o=vc(v[d+792>>2])*100;if(D(o)<0x8000000000000000){h=~~o>>>0;if(D(o)>=1){j=~~(o>0?F(H(o*2.3283064365386963e-10),4294967295):I((o-+(~~o>>>0>>>0))*2.3283064365386963e-10))>>>0}else{j=0}K=v[c>>2];break Bd}h=0;j=-2147483648;K=v[c>>2];break Bd}b=v[c+20>>2];j=b;h=v[c+16>>2];z=h+1|0;b=z?b:b+1|0;v[c+16>>2]=z;v[c+20>>2]=b}z=v[c+8>>2];b=Zfb(h,j,36e4,0);v[i+112>>2]=b;b=h-Yfb(b,yb,36e4,0)|0;h=(b|0)/6e3|0;v[i+116>>2]=h;b=b-B(h,6e3)|0;h=(b<<16>>16)/100|0;v[i+120>>2]=h<<16>>16;v[i+124>>2]=b-B(h,100)<<16>>16;Rb(z,K,249235,i+112|0);b=x[m+40>>1];h=v[c>>2];K=v[c+8>>2];Cd:{if(M){j=v[M+208>>2];o=A[M+152>>3];sa=A[M+160>>3];z=v[d+172>>2];v[i+96>>2]=v[d+168>>2];v[i+100>>2]=z;A[i+88>>3]=T;A[i+80>>3]=E;v[i+72>>2]=ka;A[i- -64>>3]=sa;A[i+56>>3]=o;v[i+48>>2]=j;v[i+44>>2]=b;v[i+40>>2]=m;v[i+36>>2]=q;v[i+32>>2]=q;Rb(K,h,295159,i+32|0);break Cd}j=v[d+172>>2];v[i+24>>2]=v[d+168>>2];v[i+28>>2]=j;A[i+16>>3]=T;v[i+12>>2]=b;v[i+8>>2]=m;v[i+4>>2]=q;v[i>>2]=q;Rb(K,h,295241,i)}fw(c,d,m,2)}ub=i+128|0;Dd:{if(!Y){Ed:{Fd:{m=v[e+1172>>2];if(m){Gd:{Hd:{Id:{if(!v[W+8>>2]|!v[W+12>>2]){break Id}if(v[k+196>>2]){if(!(A[W>>3]-xk(f,g,l)>A[g+1280>>3])){break Id}}b=Az(e+1292|0,p,g,d,J,k,W);if((b|0)==1){break Hd}c=5031;break Gd}if(v[k+196>>2]){b=SE(e+1292|0,p,g,d,l,J,k,f);if((b|0)==1){break Hd}c=5035;break Gd}b=zz(e+1292|0,p,g,d,l,J,k,f,0);if((b|0)==1){break Hd}c=5039;break Gd}b=Dw(v[g+4>>2],v[e+1292>>2],e+1280|0,0,0);c=5041;if((b|0)!=1){break Gd}b=Qg(e+1292|0,p,J);if((b|0)==1){break Fd}c=5043}Eb(157874,c);v[e+336>>2]=b;Fb(276579,e+336|0);break J}v[e+1280>>2]=1;break Ed}if(!v[e+1280>>2]){break Dd}}b=k3(p,g,R,d,O,l,J,W,k,n,f,C,N,0);if((b|0)!=1){Eb(157874,5052);v[e+320>>2]=b;Fb(276579,e+320|0);break J}b=$o(p,g,d,l,O,J,k,n,f,L,C,ba,ca,e+1180|0);if((b|0)!=1){Eb(157874,5055);v[e+304>>2]=b;Fb(276579,e+304|0);break J}b=v[d+196>>2];c=v[d+192>>2]+1|0;b=c?b:b+1|0;v[d+192>>2]=c;v[d+196>>2]=b;b=e+1184|0;v[b+24>>2]=524288;v[b+28>>2]=0;b=qx(b,v[e+1224>>2]);if((b|0)!=1){Eb(157874,5062);v[e+272>>2]=b;Fb(276579,e+272|0);break J}b=vp(e+1184|0,g,0,0,0,N);if((b|0)!=1){Eb(157874,5063);v[e+256>>2]=b;Fb(276579,e+256|0);break J}if(!v[g+1580>>2]){break Dd}b=v[e+1224>>2];b=vn(n,g,p,v[e+1224>>2],524288,f,v[f+468>>2]?v[f+420>>2]:0,(b|0)==v[k>>2],(b|0)==v[k+12>>2],A[b+8>>3],v[k+168>>2]);if((b|0)==1){break Dd}Eb(157874,5070);v[e+240>>2]=b;Fb(276579,e+240|0);break J}m=v[e+1172>>2];b=(t|0)<=0;if(b?m:0){break Dd}Jd:{if(b){ut(v[d+888>>2],g,d,v[e+1224>>2],1);b=e+1184|0;v[b+24>>2]=1048576;v[b+28>>2]=0;Kd:{Ld:{Md:{if(v[k+28>>2]){if(v[k+200>>2]){break Md}break Ld}if(!v[k+196>>2]){break Ld}}b=pb;if(((v[f+468>>2]?v[f+420>>2]:0)|0)==4){break Kd}}b=ob}r=v[b+4>>2];c=v[b>>2]+1|0;r=c?r:r+1|0;v[b>>2]=c;v[b+4>>2]=r;Nd:{if(!v[g+1580>>2]){break Nd}b=v[e+1224>>2];b=vn(n,g,p,v[e+1224>>2],1048576,f,v[f+468>>2]?v[f+420>>2]:0,(b|0)==v[k>>2],(b|0)==v[k+12>>2],A[b+8>>3],v[k+168>>2]);if((b|0)==1){break Nd}Eb(157874,5100);v[e+432>>2]=b;Fb(276579,e+432|0);break J}b=v[d+884>>2];if(!b){break Jd}b=wt(b,p,g,d,v[d+900>>2],A[d+656>>3],1);if((b|0)==1){break Jd}Eb(157874,5106);v[e+416>>2]=b;Fb(276579,e+416|0);break J}b=e+1184|0;v[b+24>>2]=2097152;v[b+28>>2]=0;if(!v[g+1580>>2]){break Jd}b=v[e+1224>>2];b=vn(n,g,p,v[e+1224>>2],2097152,f,v[f+468>>2]?v[f+420>>2]:0,(b|0)==v[k>>2],(b|0)==v[k+12>>2],A[b+8>>3],v[k+168>>2]);if((b|0)==1){break Jd}Eb(157874,5122);v[e+384>>2]=b;Fb(276579,e+384|0);break J}b=qx(e+1184|0,v[e+1224>>2]);if((b|0)!=1){Eb(157874,5125);v[e+368>>2]=b;Fb(276579,e+368|0);break J}b=vp(e+1184|0,g,0,0,0,N);if((b|0)==1){break Dd}Eb(157874,5126);v[e+352>>2]=b;Fb(276579,e+352|0);break J}if(!(!(A[v[e+1224>>2]+8>>3]<A[J+40>>3])|(v[e+1180>>2]|m|(t|0)>0))){while(1){v[e+1280>>2]=1;Od:{if(!v[L+96>>2]){if(v[l+108>>2]<=0){break Od}Eb(157874,5154);Fb(300275,0);break Od}b=CH(p,g,d,l,O,k,n,f,L,C,A[J+40>>3],0,e+1280|0);if((b|0)!=1){break yd}}if(v[e+1280>>2]==10){continue}break}}b=I7(Na,g,e+1220|0);if((b|0)!=1){Eb(157874,5171);v[e+208>>2]=b;Fb(276579,e+208|0);break J}c=v[v[k+4>>2]+24>>2]+(v[k+156>>2]+v[k+148>>2]|0)|0;b=rc(g,d,0);Pd:{if(Oa){break Pd}h=v[e+1180>>2];if(b|(h|0)!=0&(c|0)<=0){break Pd}b=Sr(g,d,l,J,k,f,v[e+1220>>2],24,h,e+1168|0,e+1172|0);if((b|0)!=1){Eb(157874,5180);v[e+192>>2]=b;Fb(276579,e+192|0);break J}b=rc(g,d,0);v[e+1164>>2]=b}if(!b&(c|0)==(v[v[k+4>>2]+24>>2]+(v[k+156>>2]+v[k+148>>2]|0)|0)){break xd}v[e+1220>>2]=0;break xd}if(!(b|Y)){b=k3(p,g,R,d,O,l,J,W,k,n,f,C,N,1);if((b|0)!=1){Eb(157874,5201);v[e+176>>2]=b;Fb(276579,e+176|0);break J}if(!v[g+1580>>2]){break xd}b=v[e+1224>>2];b=vn(n,g,p,v[e+1224>>2],524288,f,v[f+468>>2]?v[f+420>>2]:0,(b|0)==v[k>>2],(b|0)==v[k+12>>2],A[b+8>>3],v[k+168>>2]);if((b|0)==1){break xd}Eb(157874,5208);v[e+160>>2]=b;Fb(276579,e+160|0);break J}if(!b){break xd}v[e+1280>>2]=0;b=Et(e+1280|0,p,g,R,d,l,O,J,k,n,f,L,ba,N,C,ca,e+1180|0,1,0);if((b|0)==1){break xd}Eb(157874,5218);v[e+144>>2]=b;Fb(276579,e+144|0);break J}Eb(157874,5160);v[e+224>>2]=b;Fb(276579,e+224|0);break J}i=v[ba+272>>2];m=v[ba+276>>2];q=v[ba+216>>2];K=v[ba+220>>2];j=v[ba+160>>2];t=v[ba+104>>2];h=t+v[ba+56>>2]|0;c=v[ba+60>>2]+v[ba+108>>2]|0;b=v[ba+164>>2]+(h>>>0<t>>>0?c+1|0:c)|0;c=h+j|0;r=(c>>>0<h>>>0?b+1|0:b)+K|0;b=c;c=c+q|0;b=(b>>>0>c>>>0?r+1|0:r)+m|0;h=c;c=c+i|0;b=h>>>0>c>>>0?b+1|0:b;Qd:{if(v[g+1580>>2]|(v[g+176>>2]|!(+(c>>>0)+ +(b|0)*4294967296>=Ba))){break Qd}h=v[g+1396>>2];m=(h|0)!=-1;i=h;h=v[d+1144>>2];if(m&(i|0)<(h|0)){break Qd}i=v[g+920>>2];if((i|0)!=-1&(i|0)<(h|0)){break Qd}i=v[g+800>>2];m=v[d+168>>2];q=v[d+172>>2];v[e+128>>2]=c;v[e+132>>2]=b;v[e+120>>2]=m;v[e+124>>2]=q;v[e+112>>2]=h;yd(R,i,4,264218,e+112|0);v[u+348>>2]=1;v[d+1152>>2]=v[d+1152>>2]+1}b=1;Rd:{if(v[u+348>>2]){break Rd}b=0;if(!v[d+1368>>2]|(v[v[k+4>>2]+24>>2]+(v[k+156>>2]+v[k+148>>2]|0)|0)<=0|(v[g+176>>2]|v[g+1580>>2])){break Rd}c=v[g+1396>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break Rd}b=1;c=v[g+920>>2];if((c|0)==-1){break Rd}b=(c|0)>=v[d+1144>>2]}v[u+348>>2]=b;Sd:{Td:{Ud:{if(v[g+176>>2]|v[g+1580>>2]){break Ud}c=v[g+1396>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break Ud}c=v[g+920>>2];if((c|0)!=-1&(c|0)<v[d+1144>>2]){break Ud}h=v[g+924>>2];m=h>>31;if((h|0)!=v[d+168>>2]|(m|0)!=v[d+172>>2]){break Ud}i=v[d+1144>>2];c=i;q=v[d+208>>2];K=q-c|0;c=v[d+212>>2]-((c>>31)+(c>>>0>q>>>0)|0)|0;q=K+1|0;c=q?c:c+1|0;if((h|0)!=(q|0)|(c|0)!=(m|0)){break Ud}b=v[g+800>>2];v[e+104>>2]=h;v[e+108>>2]=m;v[e+96>>2]=i;yd(R,b,4,354581,e+96|0);v[u+348>>2]=1;break Td}if(!b){break Sd}}if(v[d+896>>2]){break Sd}b=v[g+920>>2];if((b|0)<0|(b|0)>=v[d+1144>>2]){break Sd}v[u+348>>2]=0;v[d+896>>2]=10}b=cB(g,R,d,!(v[e+1168>>2]|x[v[e+1224>>2]+40>>1])&(Y|0)!=0);if((b|0)!=1){Eb(157874,5257);v[e+80>>2]=b;Fb(276579,e+80|0);break J}if(!rc(g,d,1)){continue}break}}if(rc(g,d,1)){o=A[g+1272>>3];Qr(d,g,l,O,o,-o)}b=tw(k,n,p,g,d,N,C,f,A[J+40>>3]);if((b|0)!=1){Eb(157874,5277);v[e+32>>2]=b;Fb(276579,e+32|0);break J}Vd:{b=v[k+12>>2];if(!b|(v[k+156>>2]+v[k+148>>2]|0)!=(0-v[v[k+4>>2]+24>>2]|0)|!(-A[g+1280>>3]<=A[b+8>>3]-A[J+40>>3])){break Vd}Wd:{if(!v[g+1580>>2]){break Wd}c=b;b=v[e+1224>>2];i=(b|0)==v[k>>2];h=b;b=v[k+12>>2];b=vn(n,g,p,c,1048576,f,v[f+468>>2]?v[f+420>>2]:0,i,(h|0)==(b|0),A[b+8>>3],v[k+168>>2]);if((b|0)==1){break Wd}Eb(157874,5292);v[e+16>>2]=b;Fb(276579,e+16|0);break J}v[e+1224>>2]=0;b=Et(e+1224|0,p,g,R,d,l,O,J,k,n,f,L,ba,N,C,ca,e+1180|0,0,0);if((b|0)==1){break Vd}Eb(157874,5297);v[e>>2]=b;Fb(276579,e);break J}b=1;if((v[k+156>>2]+v[k+148>>2]|0)!=(0-v[v[k+4>>2]+24>>2]|0)){break J}c=v[k+160>>2];if(v[(v[k+8>>2]+(c<<2)|0)-4>>2]?(c|0)>0:0){break J}v[u+348>>2]=0;Xd:{if(!v[e+1172>>2]){o=Tc(v[g+4>>2]);if(!(A[g+1272>>3]<=-o)){break Xd}}if(v[J+76>>2]>0){v[d+896>>2]=13;break J}v[d+896>>2]=14;break J}Yd:{if(!(v[J+8>>2]|v[J+12>>2])){v[d+896>>2]=12;break Yd}v[d+896>>2]=11}break J}Eb(157874,c);v[e+704>>2]=b;Fb(276579,e+704|0)}Eb(157874,4996);v[e+48>>2]=b;Fb(276579,e+48|0)}ub=e+1296|0;h=b;if((b|0)!=1){Eb(157826,2792);v[u+128>>2]=b;Fb(276579,u+128|0);break a}b=v[a+72>>2];if((v[b+156>>2]+v[b+148>>2]|0)!=(0-v[v[b+4>>2]+24>>2]|0)){break B}d=v[b+160>>2];if(v[(v[b+8>>2]+(d<<2)|0)-4>>2]?(d|0)>0:0){break B}v[v[a+4>>2]>>2]=10}b=v[a+4>>2];if(!v[u+348>>2]){break v}if(!rc(b,v[a+24>>2],1)){continue}break}b=v[a+4>>2]}if(!v[b+1580>>2]|v[b>>2]==5){break u}if(!rc(b,v[a+24>>2],1)){break u}b=v[a+72>>2];d=v[b+4>>2];if((v[d+24>>2]+(v[b+156>>2]+v[b+148>>2]|0)|0)<=0){break u}if(u+320|0){v[u+320>>2]=v[d+12>>2]}if(u+336|0){v[u+336>>2]=v[v[v[a+72>>2]+4>>2]+24>>2]}if(u+344|0){v[u+344>>2]=v[v[a+72>>2]+32>>2]}if(u+332|0){v[u+332>>2]=v[v[a+72>>2]+148>>2]}if(u+340|0){v[u+340>>2]=v[v[a+72>>2]+36>>2]}if(u+328|0){v[u+328>>2]=v[v[a+72>>2]+156>>2]}b=2848;d=v[a+40>>2];f=v[a+4>>2];i=v[a+56>>2];g=v[v[a>>2]+4>>2];p=v[u+320>>2];l=v[u+344>>2];n=v[u+332>>2];C=v[u+340>>2];q=v[u+328>>2];c=0;m=ub-16|0;ub=m;Zd:{_d:{$d:{N=v[u+336>>2];if((N|0)>0){while(1){h=v[p+(c<<2)>>2];h=Ij(d,f,i,g,h,6,0,A[h+8>>3]);if((h|0)!=1){break $d}c=c+1|0;if((N|0)!=(c|0)){continue}break}}c=0;if((n|0)>0){while(1){h=v[l+(c<<2)>>2];h=Ij(d,f,i,g,h,6,0,A[h+8>>3]);j=6517;if((h|0)!=1){break _d}c=c+1|0;if((n|0)!=(c|0)){continue}break}}c=0;if((q|0)<=0){h=1;break Zd}while(1){h=v[C+(c<<2)>>2];h=Ij(d,f,i,g,h,6,0,A[h+8>>3]);if((h|0)==1){h=1;c=c+1|0;if((q|0)!=(c|0)){continue}break Zd}break}j=6524;break _d}j=6510}Eb(145817,j);v[m>>2]=h;Fb(276579,m)}ub=m+16|0;if((h|0)==1){break u}Eb(157826,b);v[u+112>>2]=h;Fb(276579,u+112|0);break a}h=v[a+4>>2];if(v[h+1156>>2]){Kaa(v[a+8>>2]);h=v[a+4>>2]}ae:{if(!v[h+1580>>2]){break ae}b=v[a+68>>2];R=v[b+76>>2];if((R|0)>0){N=v[h+1572>>2];be:{ce:{d=v[v[b+48>>2]>>2];switch(v[d+112>>2]){case 0:case 6:break be;default:break ce}}h=uw(d,h,v[a+24>>2],v[a+28>>2],v[a+84>>2],u+344|0);if((h|0)!=1){break q}}b=v[d+16>>2];de:{ee:{c=v[d+20>>2];if((c|0)>0){b=1}else{b=!!b&(c|0)>=0}fe:{if(!(b|(v[d+32>>2]?v[d+120>>2]==1:0))){g=v[a+4>>2];if(!v[g+1604>>2]){break de}h=v[a+24>>2];break fe}h=v[a+24>>2];g=v[a+4>>2];if(!v[g+1604>>2]){break ee}}f=v[a+40>>2];b=v[a+28>>2];K=v[b+68>>2];p=v[b+92>>2];C=0;n=0;i=ub+-64|0;ub=i;m=1;c=v[v[a>>2]+4>>2];b=Vr(i+52|0,c,g,h,v[a+32>>2],d);ge:{if((b|0)!=1){Eb(145817,5376);v[i+48>>2]=b;Fb(276579,i+48|0);m=b;break ge}v[(v[f>>2]+(v[f+128>>2]<<2)|0)-4>>2]=v[i+52>>2];if(!v[g+1604>>2]){break ge}l=Ib(v[g+12>>2],p,4,145783,4845);v[i+60>>2]=l;b=4845;he:{if(!l){break he}M=Ib(v[g+12>>2],p,8,145783,4846);v[i+56>>2]=M;b=4846;if(!M){break he}b=0;ie:{if((p|0)<=0){m=0;break ie}m=0;while(1){je:{ke:{le:{q=b<<2;e=v[q+K>>2];j=v[e+376>>2]>>>6&3;switch(j|0){case 3:break je;case 0:break le;default:break ke}}m=m+1|0}v[l+q>>2]=e;l=v[i+60>>2];o=Pg(d,g,h,v[q+l>>2]);M=v[i+56>>2];A[M+(C<<3)>>3]=o;C=C+1|0;n=(j-1>>>0<2)+n|0}b=b+1|0;if((p|0)!=(b|0)){continue}break}}me:{ne:{oe:{if(!v[f+12>>2]){h=1326;b=Tb(c,10,4,145783,1326);v[f+12>>2]=b;if(!b){break ne}v[f+144>>2]=0;v[f+148>>2]=10;v[b>>2]=0;v[v[f+12>>2]+4>>2]=0;v[v[f+12>>2]+8>>2]=0;v[v[f+12>>2]+12>>2]=0;v[v[f+12>>2]+16>>2]=0;v[v[f+12>>2]+20>>2]=0;v[v[f+12>>2]+24>>2]=0;v[v[f+12>>2]+28>>2]=0;v[v[f+12>>2]+32>>2]=0;v[v[f+12>>2]+36>>2]=0;break oe}if(v[f+148>>2]>9){break oe}p=Id(g,11);h=1337;b=gc(c,v[f+12>>2],v[f+148>>2],p,4,145783,1337);v[f+12>>2]=b;if(!b){break ne}d=v[f+148>>2];pe:{if((d|0)>=(p|0)){break pe}b=d;q=p-b&3;if(q){h=0;while(1){v[v[f+12>>2]+(b<<2)>>2]=0;b=b+1|0;h=h+1|0;if((q|0)!=(h|0)){continue}break}}if(d-p>>>0>4294967292){break pe}while(1){d=b<<2;v[d+v[f+12>>2]>>2]=0;v[(d+v[f+12>>2]|0)+4>>2]=0;v[(d+v[f+12>>2]|0)+8>>2]=0;v[(d+v[f+12>>2]|0)+12>>2]=0;b=b+4|0;if((p|0)!=(b|0)){continue}break}}v[f+148>>2]=p}d=v[f+144>>2];h=d<<2;q=v[h+v[f+12>>2]>>2];qe:{if(!q){b=Vb(c,48,145783,3270);v[h+v[f+12>>2]>>2]=b;if(!b){Eb(145817,3270);Fb(276543,0);break me}q=v[v[f+12>>2]+(d<<2)>>2];b=(n<<1)+m|0;d=Tb(c,b,4,145783,3273);v[q>>2]=d;if(!d){Eb(145817,3273);Fb(276543,0);break me}d=Tb(c,b,8,145783,3274);v[q+4>>2]=d;if(!d){Eb(145817,3274);Fb(276543,0);break me}d=Tb(c,b,4,145783,3275);v[q+8>>2]=d;if(!d){Eb(145817,3275);Fb(276543,0);break me}v[q+44>>2]=0;v[q+40>>2]=b;break qe}d=v[q+40>>2];b=(n<<1)+m|0;if((d|0)>=(b|0)){break qe}d=gc(c,v[q>>2],d,b,4,145783,3289);v[q>>2]=d;if(!d){Eb(145817,3289);Fb(276543,0);break me}d=gc(c,v[q+4>>2],v[q+40>>2],b,8,145783,3291);v[q+4>>2]=d;if(!d){Eb(145817,3291);Fb(276543,0);break me}d=gc(c,v[q+8>>2],v[q+40>>2],b,4,145783,3293);v[q+8>>2]=d;if(!d){Eb(145817,3293);Fb(276543,0);break me}v[q+40>>2]=b}v[q+16>>2]=0;v[q+20>>2]=1072693248;A[q+24>>3]=A[g+1272>>3];v[q+32>>2]=2;v[q+36>>2]=0;m=1;re:{if((C|0)<=0){h=0;break re}b=0;h=0;while(1){c=(b<<2)+l|0;d=v[c>>2];p=v[d+376>>2]&192;if((p|0)!=192){se:{if(!p){v[v[q>>2]+(h<<2)>>2]=d;d=A[g+1280>>3]>=D(A[(b<<3)+M>>3]+-1);A[v[q+4>>2]+(h<<3)>>3]=d?0:1;c=h;p=1;break se}v[v[q>>2]+(h<<2)>>2]=d;E=A[g+1280>>3];o=A[(b<<3)+M>>3];d=v[c>>2];T=A[d+136>>3];if(E>=D(o-T)){A[v[q+4>>2]+(h<<3)>>3]=T+-1;d=1;c=h;p=1;break se}T=A[d+128>>3];if(E>=D(o-T)){A[v[q+4>>2]+(h<<3)>>3]=T+1;d=0;c=h;p=1;break se}o=I(o+-.5+E);A[v[q+4>>2]+(h<<3)>>3]=o+-1;v[v[q+8>>2]+(h<<2)>>2]=1;c=h+1|0;v[v[q>>2]+(c<<2)>>2]=d;A[v[q+4>>2]+(c<<3)>>3]=o+1;d=0;p=2}v[v[q+8>>2]+(c<<2)>>2]=d;h=h+p|0}b=b+1|0;if((C|0)!=(b|0)){continue}break}}v[q+44>>2]=h;v[f+144>>2]=v[f+144>>2]+1;Hb(v[g+12>>2],i+56|0,145783,4878);Hb(v[g+12>>2],i+60|0,145783,4879);break ge}Eb(145817,h);Fb(276543,0);Eb(145817,3264);v[i+32>>2]=-1;Fb(276579,i+32|0)}b=4875}Eb(145817,b);m=-1;v[i+16>>2]=-1;Fb(276579,i+16|0);Eb(145817,5382);v[i>>2]=-1;Fb(276579,i)}ub=i- -64|0;h=m;if((h|0)==1){break de}Eb(157826,2887);v[u+96>>2]=h;Fb(276579,u+96|0);break a}b=v[a+28>>2];h=V6(v[a+40>>2],g,h,v[a+32>>2],v[v[a>>2]+4>>2],d,1,u+320|0,v[b+68>>2],v[b+92>>2],v[h+1348>>2]);if((h|0)!=1){break r}}b=(N|0)==-1?2147483647:(N|0)<=1?1:N;d=(b|0)>(R|0)?R:b;if(d>>>0>=2){Aa=1;while(1){te:{ue:{b=v[v[v[a+68>>2]+48>>2]+(Aa<<2)>>2];switch(v[b+112>>2]){case 0:case 6:break te;default:break ue}}h=uw(b,v[a+4>>2],v[a+24>>2],v[a+28>>2],v[a+84>>2],u+344|0);if((h|0)!=1){break q}}c=v[b+16>>2];f=v[b+20>>2];if((f|0)<0){c=1}else{c=!c&(f|0)<=0}if(!(!v[b+32>>2]|v[b+120>>2]!=1?c:0)){c=v[a+24>>2];h=b;b=v[a+28>>2];h=V6(v[a+40>>2],v[a+4>>2],c,v[a+32>>2],v[v[a>>2]+4>>2],h,0,u+320|0,v[b+68>>2],v[b+92>>2],v[c+1348>>2]);if((h|0)!=1){break r}}Aa=Aa+1|0;if((d|0)!=(Aa|0)){continue}break}}h=v[a+4>>2]}g=!v[h+1608>>2];if(g){break ae}d=v[a+40>>2];i=v[v[a>>2]+4>>2];b=v[a+28>>2];m=v[b+68>>2];c=v[b+92>>2];f=ub-16|0;ub=f;b=1;ve:{if(g){break ve}we:{if(v[(v[d+8>>2]+(v[d+128>>2]<<2)|0)-4>>2]){break we}h=Tb(i,c,4,145783,6645);v[(v[d+8>>2]+(v[d+128>>2]<<2)|0)-4>>2]=h;xe:{if(h){h=0;if((c|0)<=0){break ve}break xe}Eb(145817,6645);Fb(276543,0);b=-1;break ve}while(1){b=_A(v[(v[d+8>>2]+(v[d+128>>2]<<2)|0)-4>>2]+(h<<2)|0,i);if((b|0)==1){h=h+1|0;if((c|0)!=(h|0)){continue}break we}break}Eb(145817,6649);v[f>>2]=b;Fb(276579,f);break ve}b=1;if((c|0)<=0){break ve}h=0;while(1){b=v[m+(h<<2)>>2];i=v[b+200>>2];if(v[i+292>>2]>=0){b=v[b+288>>2]<<2;Fs(v[b+v[(v[d+8>>2]+(v[d+128>>2]<<2)|0)-4>>2]>>2]);Es(v[b+v[(v[d+8>>2]+(v[d+128>>2]<<2)|0)-4>>2]>>2],v[i+268>>2],0)}b=1;h=h+1|0;if((c|0)!=(h|0)){continue}break}}ub=f+16|0;h=b;if((b|0)!=1){break s}h=v[a+4>>2]}Hc(v[v[a+24>>2]+792>>2],h);Hc(v[v[a+24>>2]+796>>2],v[a+4>>2]);ye:{b=v[a+4>>2];if(!v[b+1580>>2]|!v[b+1576>>2]){break ye}b=2922;h=re(a,117257,u+320|0);if((h|0)==1){o=Te(a);o=A[u+320>>3]-o;o=o<=0?0:o;A[u+320>>3]=o;b=2927;h=Xe(a,117257,o);if((h|0)==1){break ye}}Eb(157826,b);v[u+32>>2]=h;Fb(276579,u+32|0);break a}h=1;if(Xa){break a}a=T4(a);if((a|0)==1){break a}Eb(157826,2933);v[u+16>>2]=a;Fb(276579,u+16|0);h=a;break a}Eb(157826,2817);v[u>>2]=v[v[a+4>>2]>>2];Fb(314097,u);h=-8;break a}Eb(157826,2908);v[u+48>>2]=h;Fb(276579,u+48|0);break a}Eb(157826,2897);v[u+64>>2]=h;Fb(276579,u- -64|0);break a}Eb(157826,2878);v[u+80>>2]=h;Fb(276579,u+80|0)}ub=u+352|0;return h}function KCa(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,z,B,C,E,F,G,H,I){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;z=z|0;B=B|0;C=C|0;E=E|0;F=F|0;G=G|0;H=H|0;I=I|0;var J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0;k=ub-272|0;ub=k;v[k+256>>2]=0;Aa=v[H>>2];Ba=v[G>>2];Ca=v[E>>2];Da=v[C>>2];xa=v[z>>2];ya=v[q>>2];oa=v[b+328>>2];a:{b:{c:{d:{if((d|0)<=0){p=2147483647;break d}Ea=!e|((g|0)>0|(h|0)>0|(j|0)>0|(n|0)>0);Fa=f&4;ua=f&8;Ga=f&31;Ha=f>>>0>15;p=2147483647;n=0;while(1){if(!rc(v[a+4>>2],v[a+24>>2],0)){T=v[(n<<2)+c>>2];la=v[T+16>>2];e:{f:{g:{if(!(v[q>>2]>(ya|0)|Ea)&v[z>>2]<=(xa|0)){break g}b=Ky(a,T,k+256|0);if((b|0)!=1){Eb(154649,12601);v[k+240>>2]=b;Fb(276579,k+240|0);break a}if(v[k+256>>2]){break c}if(e){break g}b=x[la+80>>1]&-32;break f}b=x[la+80>>1];if((b&31)>>>0>=f>>>0){break e}}u[la+80>>1]=b&65504|Ga;ga=v[z>>2];i=v[q>>2];b=it(a,T,k+256|0);if((b|0)!=1){Eb(154649,12620);v[k+224>>2]=b;Fb(276579,k+224|0);break a}if(v[k+256>>2]){break c}h:{if(!ua){break h}V=A[oa+152>>3];v[k+256>>2]=0;X=v[T+16>>2];if(w[X+81|0]&2){break h}K=v[X+28>>2];if(!K){break h}i:{b=it(a,T,k+256|0);g=11302;j:{if((b|0)!=1){break j}if(v[k+256>>2]){break c}tm(X);b=Hv(a,v[v[T+12>>2]+328>>2],X,0,1);g=11315;if((b|0)!=1){break j}h=v[X+40>>2];fa=Ib(v[v[a>>2]+8>>2],K,4,154615,11320);v[k+268>>2]=fa;b=-1;g=11320;if(!fa){break j}ba=Ib(v[v[a>>2]+8>>2],K,8,154615,11321);v[k+264>>2]=ba;g=11321;if(!ba){break j}dc(ba,K<<3);ca=Ib(v[v[a>>2]+8>>2],h,8,154615,11323);v[k+260>>2]=ca;g=11323;if(!ca){break j}dc(ca,h<<3);k:{if((K|0)<=0|(h|0)>=(K|0)){break k}l=v[X+4>>2];m=v[X+16>>2];O=0;S=0;b=0;g=0;while(1){j=v[m+(b<<2)>>2];l:{if((j|0)==(g|0)){g=g+1|0;break l}o=l+(b<<3)|0;h=v[o>>2];o=v[o+4>>2];J=S+o|0;r=O;O=h+O|0;S=r>>>0>O>>>0?J+1|0:J;j=ca+(j<<3)|0;if(v[j>>2]|v[j+4>>2]){break l}v[j>>2]=h;v[j+4>>2]=o}b=b+1|0;if((K|0)!=(b|0)){continue}break}if(!O&(S|0)<=0|(S|0)<0){break k}Z=v[X+56>>2];ma=v[X+60>>2];s=0;m=0;r=0;M=0;U=ub-224|0;ub=U;aa=k+256|0;v[aa>>2]=0;b=1;o=v[T+16>>2];m:{if(w[o+81|0]&2){break m}h=v[o+28>>2];if(!h){break m}g=it(a,T,aa);if((g|0)!=1){Eb(154649,10996);v[U+192>>2]=g;Fb(276579,U+192|0);b=g;break m}if(v[aa>>2]){break m}tm(o);g=Hv(a,v[v[T+12>>2]+328>>2],o,0,1);if((g|0)!=1){Eb(154649,11009);v[U+176>>2]=g;Fb(276579,U+176|0);b=g;break m}g=v[o+40>>2];if((g|0)==(h|0)){break m}_=Ib(v[v[a>>2]+8>>2],h,4,154615,11017);v[U+220>>2]=_;if(!_){Eb(154649,11017);b=-1;v[U>>2]=-1;Fb(276579,U);break m}W=Ib(v[v[a>>2]+8>>2],h,4,154615,11018);v[U+216>>2]=W;if(!W){Eb(154649,11018);b=-1;v[U+16>>2]=-1;Fb(276579,U+16|0);break m}F=je(v[v[a>>2]+8>>2],h,8,154615,11019);v[U+208>>2]=F;if(!F){Eb(154649,11019);b=-1;v[U+32>>2]=-1;Fb(276579,U+32|0);break m}N=Ib(v[v[a>>2]+8>>2],h,4,154615,11020);v[U+204>>2]=N;if(!N){Eb(154649,11020);b=-1;v[U+48>>2]=-1;Fb(276579,U+48|0);break m}L=Ib(v[v[a>>2]+8>>2],g,8,154615,11021);v[U+212>>2]=L;if(!L){Eb(154649,11021);b=-1;v[U+64>>2]=-1;Fb(276579,U- -64|0);break m}P=je(v[v[a>>2]+8>>2],g,4,154615,11022);v[U+200>>2]=P;n:{if(P){o:{if((h|0)<=0){break o}g=v[o+16>>2];l=0;while(1){p:{if(v[g+(l<<2)>>2]==(s|0)){B=v[o+4>>2]+(l<<3)|0;J=v[B+4>>2];j=L+(s<<3)|0;v[j>>2]=v[B>>2];v[j+4>>2]=J;s=s+1|0;break p}j=v[o+4>>2]+(l<<3)|0;B=v[j>>2];J=M+v[j+4>>2]|0;j=r;r=r+B|0;M=j>>>0>r>>>0?J+1|0:J}l=l+1|0;if((h|0)!=(l|0)){continue}break}if(!r&(M|0)<=0|(M|0)<0|(h|0)<=0){break o}ia=s<<2;g=v[o+56>>2];B=g-r|0;Y=v[o+60>>2]-((g>>>0<r>>>0)+M|0)|0;s=v[o+16>>2];g=0;while(1){r=g<<2;j=P+(v[r+s>>2]<<2)|0;if(v[j>>2]){g=g+1|0}else{v[j>>2]=1;j=g+1|0;l=j;if((h|0)>(l|0)){while(1){M=l<<2;q:{if(v[r+s>>2]!=v[M+s>>2]){break q}J=v[o+4>>2];Q=J+(g<<3)|0;R=v[Q>>2];ea=J;J=l<<3;$=ea+J|0;da=v[$>>2];Q=v[Q+4>>2];$=v[$+4>>2];if((Q|0)<=($|0)&R>>>0<=da>>>0|(Q|0)<($|0)){break q}Q=m<<2;v[Q+_>>2]=v[M+v[o>>2]>>2];s=v[o+16>>2];M=v[r+s>>2];R=L+(M<<3)|0;$=v[R>>2];J=J+v[o+4>>2]|0;da=v[J>>2];ha=$-da|0;J=v[R+4>>2]-(v[J+4>>2]+($>>>0<da>>>0)|0)|0;R=F+(m<<3)|0;v[R>>2]=ha;v[R+4>>2]=J;v[N+Q>>2]=M;m=m+1|0}l=l+1|0;if((h|0)!=(l|0)){continue}break}}g=j}if((h|0)!=(g|0)){continue}break}if((m|0)<=0){break o}if((m|0)>=2){r:{g=m-1|0;if(m>>>0<=25){N8(F,_,N,0,g);break r}HP(F,_,N,0,g,1)}}o=m;l=0;while(1){F=l;h=l<<2;g=Fd(a,v[h+_>>2],W);if((g|0)!=1){Eb(154649,11084);v[U+160>>2]=g;Fb(276579,U+160|0);b=g;break m}da=v[U+204>>2];h=da+h|0;g=v[h>>2];ha=v[U+208>>2];j=ha+(F<<3)|0;N=v[j>>2];P=v[j+4>>2];$=v[U+200>>2];dc($,ia);v[$+(v[h>>2]<<2)>>2]=1;l=F+1|0;s:{if((m|0)<=(l|0)){break s}r=-1;M=-1;s=1;R=l<<2;j=v[R+da>>2];ja=$+(j<<2)|0;t:{if(v[ja>>2]){h=l;break t}h=l;J=ha+(h<<3)|0;L=v[J>>2];Q=v[J+4>>2];J=P+Q|0;ea=L+N|0;J=ea>>>0<N>>>0?J+1|0:J;if((Y|0)>=(J|0)&B>>>0>=ea>>>0|(J|0)<(Y|0)){break t}v[ja>>2]=1;R=Fd(a,v[R+_>>2],W+4|0);if((R|0)!=1){break n}if((o|0)==2){h=m;g=j;s=o;r=N;M=P;break t}s=2;g=j;r=N;M=P;h=F+2|0;F=v[da+(h<<2)>>2];R=$+(F<<2)|0;if(v[R>>2]){break t}while(1){g=F;r=L;J=ha+(h<<3)|0;L=v[J>>2];F=r+L|0;M=Q;Q=v[J+4>>2];J=M+Q|0;J=F>>>0<L>>>0?J+1|0:J;if((J|0)<=(Y|0)&B>>>0>=F>>>0|(J|0)<(Y|0)){g=j;r=N;M=P;break t}v[R>>2]=1;R=Fd(a,v[_+(h<<2)>>2],(s<<2)+W|0);if((R|0)!=1){break n}s=s+1|0;if((s|0)!=(o|0)){j=g;N=r;P=M;h=h+1|0;F=v[da+(h<<2)>>2];R=$+(F<<2)|0;if(!v[R>>2]){continue}break t}break}h=m;s=o}if(s>>>0<2){break s}j=Ti(a,W,0,s,0,aa,U+196|0);if((j|0)!=1){Eb(154649,11111);v[U+128>>2]=j;Fb(276579,U+128|0);b=j;break m}if(v[aa>>2]){break o}v[z>>2]=v[z>>2]+v[U+196>>2];j=v[U+200>>2];v[j+(g<<2)>>2]=0;F=h+1|0;if((F|0)>=(m|0)){break s}h=v[U+204>>2];while(1){g=F<<2;if(v[j+(v[g+h>>2]<<2)>>2]){break s}N=v[U+208>>2]+(F<<3)|0;L=v[N>>2];J=M+v[N+4>>2]|0;N=r+L|0;J=N>>>0<r>>>0?J+1|0:J;if((Y|0)>=(J|0)&B>>>0>=N>>>0|(J|0)<(Y|0)){break s}g=Fd(a,v[g+_>>2],((s<<2)+W|0)-4|0);if((g|0)!=1){Eb(154649,11122);v[U+112>>2]=g;Fb(276579,U+112|0);b=g;break m}W=v[U+216>>2];g=Ti(a,W,0,s,0,aa,U+196|0);if((g|0)!=1){Eb(154649,11124);v[U+96>>2]=g;Fb(276579,U+96|0);b=g;break m}if(v[aa>>2]){break o}v[z>>2]=v[z>>2]+v[U+196>>2];F=F+1|0;if((F|0)!=(m|0)){continue}break}}o=o-1|0;if((l|0)!=(m|0)){continue}break}}Hb(v[v[a>>2]+8>>2],U+200|0,154615,11136);Hb(v[v[a>>2]+8>>2],U+212|0,154615,11137);Hb(v[v[a>>2]+8>>2],U+204|0,154615,11138);Hb(v[v[a>>2]+8>>2],U+208|0,154615,11139);Hb(v[v[a>>2]+8>>2],U+216|0,154615,11140);Hb(v[v[a>>2]+8>>2],U+220|0,154615,11141);break m}Eb(154649,11022);b=-1;v[U+80>>2]=-1;Fb(276579,U+80|0);break m}Eb(154649,11101);v[U+144>>2]=R;Fb(276579,U+144|0);b=R}ub=U+224|0;g=11365;if((b|0)!=1){break j}if(v[k+256>>2]){break i}h=v[X+4>>2];j=0;b=K;while(1){g=b-1|0;m=g<<3;o=m+h|0;s=g<<2;B=ca+(v[s+v[X+16>>2]>>2]<<3)|0;l=v[B>>2];F=y[o>>2]>l>>>0;o=v[o+4>>2];r=v[B+4>>2];if(F&(o|0)>=(r|0)|(o|0)>(r|0)){v[fa+(j<<2)>>2]=v[s+v[X>>2]>>2];h=v[X+4>>2];o=m+h|0;m=v[o>>2];o=v[o+4>>2]-((l>>>0>m>>>0)+r|0)|0;l=m-l|0;m=ba+(j<<3)|0;v[m>>2]=l;v[m+4>>2]=o;j=j+1|0}l=b>>>0>1;b=g;if(l){continue}break}if((j|0)<2){break k}b=c_(a,fa,ba,j,Z-O|0,ma-((O>>>0>Z>>>0)+S|0)|0,0,V,k+256|0,z);g=11387;if((b|0)!=1){break j}if(v[k+256>>2]){break i}}b=c_(a,v[X>>2],v[X+4>>2],K,v[X+56>>2],v[X+60>>2],1,V,k+256|0,z);if((b|0)==1){break i}g=11395}Eb(154649,g);v[k+208>>2]=b;Fb(276579,k+208|0);Eb(154649,12627);v[k+192>>2]=b;Fb(276579,k+192|0);break a}Hb(v[v[a>>2]+8>>2],k+260|0,154615,11399);Hb(v[v[a>>2]+8>>2],k+264|0,154615,11400);Hb(v[v[a>>2]+8>>2],k+268|0,154615,11401);u[X+80>>1]=x[X+80>>1]|512;if(v[k+256>>2]){break c}}u:{if(Ha){break u}b=LK(a,T,k+256|0,k+252|0,q,ua);if((b|0)!=1){Eb(154649,12635);v[k+176>>2]=b;Fb(276579,k+176|0);break a}if(v[k+256>>2]){break c}if(!v[k+252>>2]){break u}v[C>>2]=v[C>>2]+1;break e}if(!(v[q>>2]<=(i|0)&(ga|0)>=v[z>>2])){b=Ky(a,T,k+256|0);if((b|0)!=1){Eb(154649,12649);v[k+160>>2]=b;Fb(276579,k+160|0);break a}if(v[k+256>>2]){break c}i=v[q>>2]}v:{if(t[T+85|0]&1){break v}b=v[la+68>>2];g=v[la+60>>2];if((b|0)<=(g|0)&y[la+64>>2]<=y[la+56>>2]|(b|0)<(g|0)){b=$e(a,T);if((b|0)==1){break e}Eb(154649,12663);v[k+144>>2]=b;Fb(276579,k+144|0);break a}a_(v[T+16>>2],G,H);w:{if(!Fa|!v[oa+112>>2]){break w}Z=0;W=ub-256|0;ub=W;F=v[T+16>>2];g=k+256|0;v[g>>2]=0;j=1;b=it(a,T,g);x:{if((b|0)!=1){Eb(154649,9444);v[W+240>>2]=b;Fb(276579,W+240|0);j=b;break x}if(v[g>>2]){break x}y:{z:{m=v[T+16>>2];l=v[m+28>>2];A:{if(!l){b=pc(a,T);if((b|0)==1){break z}Eb(154649,9316);v[W+160>>2]=b;Fb(276579,W+160|0);break A}tm(m);b=v[m+56>>2];o=v[m+60>>2];B:{C:{if((l|0)<=0){break C}r=v[m+4>>2];s=v[m>>2];h=0;while(1){g=r+(h<<3)|0;B=y[g>>2]>b>>>0;g=v[g+4>>2];if(B&(g|0)>=(o|0)|(g|0)>(o|0)){g=Qc(a,v[s+(h<<2)>>2],0,W+252|0,W+248|0);if((g|0)!=1){Eb(154649,9333);v[W+192>>2]=g;Fb(276579,W+192|0);b=g;break A}if(v[W+248>>2]){v[q>>2]=v[q>>2]+1}h=h+1|0;if((l|0)!=(h|0)){continue}break B}break}if(!h){break C}if((h|0)==(l|0)){break B}while(1){l=h-1|0;g=lk(a,T,l);if((g|0)!=1){Eb(154649,9356);v[W+224>>2]=g;Fb(276579,W+224|0);b=g;break A}v[G>>2]=v[G>>2]+1;g=h>>>0>1;h=l;if(g){continue}break}tm(m)}if(A[v[a+4>>2]+1368>>3]<=+(b>>>0)+ +(o|0)*4294967296){break y}g=b>>>0<y[m+64>>2];b=v[m+68>>2];if(g&(o|0)<=(b|0)|(b|0)>(o|0)){break y}b=pc(a,T);if((b|0)==1){break z}Eb(154649,9370);v[W+208>>2]=b;Fb(276579,W+208|0);break A}b=pc(a,T);if((b|0)==1){break z}Eb(154649,9347);v[W+176>>2]=b;Fb(276579,W+176|0)}j=b;Eb(154649,9452);v[W+144>>2]=j;Fb(276579,W+144|0);break x}v[C>>2]=v[C>>2]+1}g=v[T+84>>2];if(g&524288){break x}D:{if(!(A[v[a+4>>2]+1368>>3]<=+y[F+56>>2]+ +v[F+60>>2]*4294967296)){s=v[T+16>>2];R=v[s+4>>2];K=v[s+28>>2];h=K-2|0;aa=R+(h<<3)|0;o=aa;l=K-1|0;_=R+(l<<3)|0;r=_;b=v[r>>2];m=v[o>>2]+b|0;L=v[r+4>>2];J=L+v[o+4>>2]|0;E:{F:{G:{H:{I:{J:{K:{r=v[s+56>>2];o=r>>>0<m>>>0;J=b>>>0>m>>>0?J+1|0:J;M=v[s+60>>2];m=M;if(o&(J|0)>=(m|0)|(m|0)<(J|0)){b=8488;l=W+252|0;h=jf(a,l,v[T+8>>2],K,v[s>>2],1,g&1,g>>>1&1,g>>>2&1,g>>>3&1,g>>>4&1,g>>>7&1,g>>>8&1,g>>>9&1,g>>>10&1,g>>>11&1);L:{if((h|0)!=1){break L}b=8490;h=mc(a,v[W+252>>2]);if((h|0)!=1){break L}b=8491;h=ec(a,l);if((h|0)!=1){break L}v[E>>2]=v[E>>2]+1;b=8494;h=pc(a,T);if((h|0)==1){break K}}Eb(154649,b);v[W+48>>2]=h;Fb(276579,W+48|0);j=h;break D}O=v[s+64>>2];g=O-b|0;S=v[s+68>>2];m=S-((b>>>0>O>>>0)+L|0)|0;if((m|0)<=(M|0)&g>>>0<=r>>>0|(m|0)<(M|0)){b=Ay(a,T,C,E);if((b|0)==1){break E}Eb(154649,8503);v[W+128>>2]=b;Fb(276579,W+128|0);j=b;break D}g=S-((r>>>0>O>>>0)+M|0)|0;B=g;Y=v[R+4>>2];J=Y+v[R+12>>2]|0;N=O-r|0;o=v[R>>2];P=v[R+8>>2];m=o+P|0;J=m>>>0<P>>>0?J+1|0:J;if(N>>>0>m>>>0&(J|0)<=(g|0)|(g|0)>(J|0)){break E}g=0;M:{N:{if((K|0)<=0){break N}while(1){m=R+(g<<3)|0;P=v[m>>2];J=L+v[m+4>>2]|0;m=b+P|0;J=m>>>0<b>>>0?J+1|0:J;if((M|0)>=(J|0)&m>>>0<=r>>>0|(J|0)<(M|0)){break N}g=g+1|0;if((K|0)!=(g|0)){continue}break}L=0;Q=0;g=K;b=g;break M}L=0;Q=0;if((M|0)<0){b=g;break M}if((g|0)>=(K|0)){b=g;break M}b=g;while(1){m=R+(b<<3)|0;P=v[m>>2];J=Q+v[m+4>>2]|0;m=L;L=L+P|0;J=m>>>0>L>>>0?J+1|0:J;Q=J;b=b+1|0;if((K|0)<=(b|0)){break M}if((J|0)<=(M|0)&r>>>0>=L>>>0|(J|0)<(M|0)){continue}break}}U=v[G>>2];O:{if(r>>>0<L>>>0&(M|0)<=(Q|0)|(M|0)<(Q|0)){if((b|0)==(K|0)){b=g^-1;h=b+K|0;J=(K>>31)-1|0;l=b>>>0>h>>>0?J+1|0:J;if(g){b=0;while(1){o=R+(b<<3)|0;m=v[o>>2];B=v[o+4>>2];r=B;if(h>>>0<m>>>0&(l|0)<=(r|0)|(l|0)<(r|0)){v[o>>2]=h;v[o+4>>2]=l;M=b<<2;V=A[v[M+v[s>>2]>>2]+152>>3];o=h-m|0;N=v[s+64>>2];r=o+N|0;m=l-((h>>>0<m>>>0)+B|0)|0;J=m+v[s+68>>2]|0;v[s+64>>2]=r;v[s+68>>2]=r>>>0<N>>>0?J+1|0:J;if(V>.5){J=m+v[s+76>>2]|0;m=o+v[s+72>>2]|0;J=m>>>0<o>>>0?J+1|0:J;v[s+72>>2]=m;v[s+76>>2]=J}m=v[s+8>>2];if(m){m=v[m+M>>2];v[m+8>>2]=h;v[m+12>>2]=l}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}b=b+1|0;if((g|0)!=(b|0)){continue}break}}if((g|0)<(K|0)){while(1){m=R+(g<<3)|0;b=v[m>>2];o=v[m+4>>2];r=o;if((o|0)>=0&b>>>0>=2|(o|0)>0){v[m>>2]=1;v[m+4>>2]=0;B=g<<2;V=A[v[B+v[s>>2]>>2]+152>>3];m=1-b|0;M=v[s+64>>2];o=m+M|0;b=0-((b>>>0>1)+r|0)|0;J=b+v[s+68>>2]|0;v[s+64>>2]=o;v[s+68>>2]=o>>>0<M>>>0?J+1|0:J;if(V>.5){J=b+v[s+76>>2]|0;b=m+v[s+72>>2]|0;J=b>>>0<m>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+B>>2];v[b+8>>2]=1;v[b+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}g=g+1|0;if((K|0)!=(g|0)){continue}break}}v[s+56>>2]=h;v[s+60>>2]=l;break E}P=b-g|0;P:{if((P|0)<=0){L=0;Q=0;break P}b=K-P|0;b=(b|0)<(l|0)?b:l;m=K-b|0;X=m&3;Q:{if(b-K>>>0>4294967292){L=0;Q=0;b=l;break Q}ba=R-24|0;ca=R-16|0;$=R-8|0;fa=m&-4;L=0;Q=0;b=l;while(1){m=b<<3;J=m+ba|0;da=v[J>>2];ha=v[J+4>>2];J=m+ca|0;ga=v[J>>2];ma=v[J+4>>2];J=m+$|0;ia=v[J>>2];ja=v[J+4>>2];m=m+R|0;ea=v[m>>2];J=Q+v[m+4>>2]|0;m=L+ea|0;J=(m>>>0<L>>>0?J+1|0:J)+ja|0;L=m;m=m+ia|0;J=(L>>>0>m>>>0?J+1|0:J)+ma|0;L=m;m=m+ga|0;J=(L>>>0>m>>>0?J+1|0:J)+ha|0;L=m+da|0;Q=L>>>0<m>>>0?J+1|0:J;b=b-4|0;Z=Z+4|0;if((fa|0)!=(Z|0)){continue}break}}if(!X){break P}m=0;while(1){J=R+(b<<3)|0;Z=v[J>>2];J=Q+v[J+4>>2]|0;Q=L;L=L+Z|0;Q=Q>>>0>L>>>0?J+1|0:J;b=b-1|0;m=m+1|0;if((X|0)!=(m|0)){continue}break}}if((M|0)>=(Q|0)&r>>>0>=L>>>0|(M|0)>(Q|0)){break O}h=P-1|0;o=h>>31;if(g){b=0;while(1){m=R+(b<<3)|0;l=v[m>>2];B=v[m+4>>2];r=B;if(h>>>0<l>>>0&(o|0)<=(r|0)|(o|0)<(r|0)){v[m>>2]=h;v[m+4>>2]=o;M=b<<2;V=A[v[M+v[s>>2]>>2]+152>>3];m=h-l|0;N=v[s+64>>2];r=m+N|0;l=o-((h>>>0<l>>>0)+B|0)|0;J=l+v[s+68>>2]|0;v[s+64>>2]=r;v[s+68>>2]=r>>>0<N>>>0?J+1|0:J;if(V>.5){J=l+v[s+76>>2]|0;l=m+v[s+72>>2]|0;J=l>>>0<m>>>0?J+1|0:J;v[s+72>>2]=l;v[s+76>>2]=J}l=v[s+8>>2];if(l){l=v[l+M>>2];v[l+8>>2]=h;v[l+12>>2]=o}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}b=b+1|0;if((g|0)!=(b|0)){continue}break}}if((g|0)<(K|0)){while(1){l=R+(g<<3)|0;b=v[l>>2];m=v[l+4>>2];r=m;if((m|0)>=0&b>>>0>=2|(m|0)>0){v[l>>2]=1;v[l+4>>2]=0;B=g<<2;V=A[v[B+v[s>>2]>>2]+152>>3];l=1-b|0;M=v[s+64>>2];m=l+M|0;b=0-((b>>>0>1)+r|0)|0;J=b+v[s+68>>2]|0;v[s+64>>2]=m;v[s+68>>2]=m>>>0<M>>>0?J+1|0:J;if(V>.5){J=b+v[s+76>>2]|0;b=l+v[s+72>>2]|0;J=b>>>0<l>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+B>>2];v[b+8>>2]=1;v[b+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}g=g+1|0;if((K|0)!=(g|0)){continue}break}}v[s+56>>2]=h;v[s+60>>2]=o;break E}b=R+(g<<3)|0;M=b-8|0;L=v[M>>2];m=K-g|0;r=(K>>31)-(g>>>0>K>>>0)|0;M=v[M+4>>2];if(L>>>0<=m>>>0&(r|0)>=(M|0)|(r|0)>(M|0)){M=v[b>>2];b=v[b+4>>2];if((b|0)<0){b=1}else{b=M>>>0<2&(b|0)<=0}if(b){break O}}if(g){b=0;while(1){l=R+(b<<3)|0;h=v[l>>2];B=v[l+4>>2];o=B;if(m>>>0<h>>>0&(r|0)<=(o|0)|(o|0)>(r|0)){v[l>>2]=m;v[l+4>>2]=r;M=b<<2;V=A[v[M+v[s>>2]>>2]+152>>3];l=m-h|0;N=v[s+64>>2];o=l+N|0;h=r-((h>>>0>m>>>0)+B|0)|0;J=h+v[s+68>>2]|0;v[s+64>>2]=o;v[s+68>>2]=o>>>0<N>>>0?J+1|0:J;if(V>.5){J=h+v[s+76>>2]|0;h=l+v[s+72>>2]|0;J=h>>>0<l>>>0?J+1|0:J;v[s+72>>2]=h;v[s+76>>2]=J}h=v[s+8>>2];if(h){h=v[h+M>>2];v[h+8>>2]=m;v[h+12>>2]=r}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}b=b+1|0;if((g|0)!=(b|0)){continue}break}}if((g|0)<(K|0)){while(1){h=R+(g<<3)|0;b=v[h>>2];l=v[h+4>>2];o=l;if((l|0)>=0&b>>>0>=2|(l|0)>0){v[h>>2]=1;v[h+4>>2]=0;B=g<<2;V=A[v[B+v[s>>2]>>2]+152>>3];h=1-b|0;M=v[s+64>>2];l=h+M|0;b=0-((b>>>0>1)+o|0)|0;J=b+v[s+68>>2]|0;v[s+64>>2]=l;v[s+68>>2]=l>>>0<M>>>0?J+1|0:J;if(V>.5){J=b+v[s+76>>2]|0;b=h+v[s+72>>2]|0;J=b>>>0<h>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+B>>2];v[b+8>>2]=1;v[b+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}g=g+1|0;if((K|0)!=(g|0)){continue}break}}v[s+56>>2]=m;v[s+60>>2]=r;break E}R:{if(o>>>0<=N>>>0&(B|0)>=(Y|0)|(B|0)>(Y|0)){r=0;M=0;g=0;b=U;break R}m=v[s>>2];g=0;r=0;M=0;b=R;while(1){v[b>>2]=N;v[b+4>>2]=B;L=g<<2;V=A[v[L+m>>2]+152>>3];b=N-o|0;P=v[s+64>>2];O=b+P|0;Q=B-((o>>>0>N>>>0)+Y|0)|0;J=Q+v[s+68>>2]|0;J=O>>>0<P>>>0?J+1|0:J;S=J;v[s+64>>2]=O;v[s+68>>2]=J;if(V>.5){J=Q+v[s+76>>2]|0;P=b;b=b+v[s+72>>2]|0;J=P>>>0>b>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+L>>2];v[b+8>>2]=N;v[b+12>>2]=B}J=Y+(M-((r>>>0<N>>>0)+B|0)|0)|0;r=o+(r-N|0)|0;M=r>>>0<o>>>0?J+1|0:J;u[s+80>>1]=x[s+80>>1]&65472;g=g+1|0;b=R+(g<<3)|0;o=v[b>>2];Y=v[b+4>>2];L=Y;if(N>>>0<o>>>0&(B|0)<=(L|0)|(B|0)<(L|0)){continue}break}b=v[G>>2]}b=b+g|0;v[G>>2]=b;S:{if((g|0)>=(K|0)){break S}while(1){m=R+(g<<3)|0;if((N|0)!=v[m>>2]|(B|0)!=v[m+4>>2]){break S}g=g+1|0;if((K|0)!=(g|0)){continue}break}break F}if((g|0)>=(l|0)){if((g|0)!=(l|0)){break F}b=lk(a,T,l);if((b|0)==1){break F}Eb(154649,8746);v[W+112>>2]=b;Fb(276579,W+112|0);j=b;break D}L=v[aa>>2];m=v[_>>2];P=L+m|0;o=v[aa+4>>2];Q=v[_+4>>2];J=o+Q|0;J=m>>>0>P>>>0?J+1|0:J;if(N>>>0<=P>>>0&(J|0)>=(B|0)|(B|0)<(J|0)){if(!g|(L>>>0<2&(o|0)<=0|(o|0)<0)){break I}l=0;T:{while(1){m=R+(l<<3)|0;b=v[m>>2];o=v[m+4>>2];r=o;if(b>>>0<3&(o|0)<=0|(o|0)<0){break T}v[m>>2]=2;v[m+4>>2]=0;B=l<<2;V=A[v[B+v[s>>2]>>2]+152>>3];m=2-b|0;M=v[s+64>>2];o=m+M|0;b=0-((b>>>0>2)+r|0)|0;J=b+v[s+68>>2]|0;v[s+64>>2]=o;v[s+68>>2]=o>>>0<M>>>0?J+1|0:J;if(V>.5){J=b+v[s+76>>2]|0;b=m+v[s+72>>2]|0;J=b>>>0<m>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+B>>2];v[b+8>>2]=2;v[b+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;l=l+1|0;if((l|0)!=(g|0)){continue}break}l=g}b=g;while(1){o=R+(b<<3)|0;m=v[o>>2];r=v[o+4>>2];B=r;if((r|0)>=0&m>>>0>=2|(r|0)>0){v[o>>2]=1;v[o+4>>2]=0;M=b<<2;V=A[v[M+v[s>>2]>>2]+152>>3];o=1-m|0;N=v[s+64>>2];r=o+N|0;m=0-((m>>>0>1)+B|0)|0;J=m+v[s+68>>2]|0;v[s+64>>2]=r;v[s+68>>2]=r>>>0<N>>>0?J+1|0:J;if(V>.5){J=m+v[s+76>>2]|0;m=o+v[s+72>>2]|0;J=m>>>0<o>>>0?J+1|0:J;v[s+72>>2]=m;v[s+76>>2]=J}m=v[s+8>>2];if(m){m=v[m+M>>2];v[m+8>>2]=1;v[m+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;l=l+1|0}b=b+1|0;if((K|0)!=(b|0)){continue}break}v[G>>2]=v[G>>2]+l;b=(h-g|0)+(g<<1)|0;v[s+56>>2]=b;v[s+60>>2]=b>>31;break H}P=R+(g<<3)|0;J=P;o=v[J>>2];L=N-m|0;Y=v[J+4>>2];J=Y;X=B-((m>>>0>N>>>0)+Q|0)|0;m=X;U:{if((J|0)<=(m|0)&o>>>0<=L>>>0|(m|0)>(J|0)){m=g;break U}Q=v[s>>2];b=P;m=g;while(1){v[b>>2]=L;v[b+4>>2]=X;Z=m<<2;V=A[v[Z+Q>>2]+152>>3];b=L-o|0;S=v[s+64>>2];O=b+S|0;ba=X-((o>>>0>L>>>0)+Y|0)|0;J=ba+v[s+68>>2]|0;J=O>>>0<S>>>0?J+1|0:J;S=J;v[s+64>>2]=O;v[s+68>>2]=J;if(V>.5){J=ba+v[s+76>>2]|0;ea=b;b=b+v[s+72>>2]|0;J=ea>>>0>b>>>0?J+1|0:J;v[s+72>>2]=b;v[s+76>>2]=J}b=v[s+8>>2];if(b){b=v[b+Z>>2];v[b+8>>2]=L;v[b+12>>2]=X}J=Y+(M-((r>>>0<L>>>0)+X|0)|0)|0;r=o+(r-L|0)|0;M=r>>>0<o>>>0?J+1|0:J;u[s+80>>1]=x[s+80>>1]&65472;m=m+1|0;b=R+(m<<3)|0;o=v[b>>2];Y=v[b+4>>2];J=Y;if(L>>>0<o>>>0&(X|0)<=(J|0)|(J|0)>(X|0)){continue}break}b=v[G>>2]}Z=(m-g|0)+b|0;v[G>>2]=Z;while(1){b=m;m=b+1|0;J=R+(b<<3)|0;o=v[J>>2];Q=v[J+4>>2];if((L|0)==(o|0)&(X|0)==(Q|0)){continue}break}V:{if(!b){break V}O=0;S=0;if((b|0)>=(K|0)){break V}m=b;while(1){L=R+(m<<3)|0;Y=v[L>>2];J=S+v[L+4>>2]|0;L=O;O=O+Y|0;S=L>>>0>O>>>0?J+1|0:J;m=m+1|0;if((K|0)>(m|0)){continue}break}}if(N>>>0>O>>>0&(B|0)>=(S|0)|(B|0)>(S|0)){break G}m=h;W:{if((K|0)<=1){break W}g=h;while(1){m=R+(g<<3)|0;if(v[m>>2]!=v[m+8>>2]|v[m+4>>2]!=v[m+12>>2]){m=g;break W}m=-1;o=(g|0)>0;g=g-1|0;if(o){continue}break}}if((b|0)>=(m|0)){break I}g=v[aa>>2];J=v[aa+4>>2]<<1|g>>>31;if(g<<1>>>0>N>>>0&(J|0)>=(B|0)|(B|0)<(J|0)){if((b|0)>=(h|0)){break I}m=v[_+4>>2];g=v[_>>2];J=m<<1|g>>>31;if(N>>>0<g<<1>>>0&(B|0)<=(J|0)|(B|0)<(J|0)){break I}while(1){o=R+(b<<3)|0;L=v[o>>2];J=m+v[o+4>>2]|0;o=g+L|0;J=o>>>0<g>>>0?J+1|0:J;if((J|0)>=(B|0)&o>>>0>=N>>>0|(B|0)<(J|0)){b=b+1|0;if((h|0)>(b|0)){continue}break I}break}if(!(N&1)){if((b|0)>(h|0)){break I}m=(B&1)<<31|N>>>1;g=B>>1;while(1){o=R+(b<<3)|0;l=v[o>>2];o=v[o+4>>2];if(l>>>0>m>>>0&(o|0)>=(g|0)|(g|0)<(o|0)){Xm(s,b,m,g);v[G>>2]=v[G>>2]+1;J=o+(M-((m>>>0>r>>>0)+g|0)|0)|0;r=l+(r-m|0)|0;M=r>>>0<l>>>0?J+1|0:J}l=(b|0)<(h|0);b=b+1|0;if(l){continue}break}break I}if(b){g=0;while(1){o=R+(g<<3)|0;m=v[o>>2];Xm(s,g,m<<1,v[o+4>>2]<<1|m>>>31);g=g+1|0;if(g>>>0<b>>>0){continue}break}}J=M<<1|r>>>31;r=r<<1;M=J;if((b|0)<=(h|0)){while(1){m=R+(b<<3)|0;g=v[m>>2];m=v[m+4>>2];Xm(s,b,N,B);o=M-((r>>>0<N>>>0)+B|0)|0;J=m<<1|g>>>31;g=g<<1;r=g+(r-N|0)|0;J=o+J|0;M=g>>>0>r>>>0?J+1|0:J;g=(b|0)<(h|0);b=b+1|0;if(g){continue}break}}b=v[_>>2];Xm(s,l,b<<1,v[_+4>>2]<<1|b>>>31);break J}g=R+(K<<3)|0;$=g-32|0;ba=g-24|0;da=g-40|0;o=0;m=0;while(1){X:{Y:{switch(o-1|0){default:l=v[_>>2];g=l+v[aa>>2]|0;J=v[aa+4>>2]+v[_+4>>2]|0;J=g>>>0<l>>>0?J+1|0:J;break X;case 0:l=v[_>>2];g=l+v[ba>>2]|0;J=v[ba+4>>2]+v[_+4>>2]|0;J=g>>>0<l>>>0?J+1|0:J;break X;case 1:l=v[_>>2];g=l+v[$>>2]|0;J=v[$+4>>2]+v[_+4>>2]|0;l=g>>>0<l>>>0?J+1|0:J;J=v[ba+4>>2]+v[aa+4>>2]|0;L=v[aa>>2];m=L+v[ba>>2]|0;P=m;J=m>>>0<L>>>0?J+1|0:J;m=g>>>0<m>>>0&(J|0)>=(l|0)|(l|0)<(J|0);g=m?g:P;J=m?l:J;break X;case 2:break Y}}L=v[aa>>2];Q=v[aa+4>>2];l=v[_>>2];P=v[_+4>>2];if(m){m=1;J=P+v[da+4>>2]|0;g=l+v[da>>2]|0;l=g>>>0<l>>>0?J+1|0:J;J=Q+v[ba+4>>2]|0;P=L;L=L+v[ba>>2]|0;J=P>>>0>L>>>0?J+1|0:J;P=L;L=g>>>0<L>>>0&(l|0)<=(J|0)|(l|0)<(J|0);g=L?g:P;J=L?l:J;break X}m=0;J=P+v[$+4>>2]|0;g=l+v[$>>2]|0;O=g>>>0<l>>>0?J+1|0:J;S=v[ba>>2];J=P+Q|0;l=l+L|0;J=v[ba+4>>2]+(l>>>0<L>>>0?J+1|0:J)|0;P=l;l=l+S|0;J=P>>>0>l>>>0?J+1|0:J;P=l;l=g>>>0<l>>>0&(J|0)>=(O|0)|(J|0)>(O|0);g=l?g:P;J=l?O:J}l=g;P=J;while(1){S=R+(h<<3)|0;g=S;L=v[g>>2];Y=v[g+4>>2];g=Y;if((g|0)<=(P|0)&l>>>0>=L>>>0|(g|0)<(P|0)){J=g<<1|L>>>31;Z:{if(L<<1>>>0>N>>>0&(J|0)>=(B|0)|(B|0)<(J|0)){g=b;break Z}g=R+(b<<3)|0;O=v[g>>2];S=v[g+4>>2];J=Y+S|0;g=L+O|0;J=g>>>0<L>>>0?J+1|0:J;if((J|0)<=(B|0)&g>>>0<=N>>>0|(B|0)>(J|0)){g=b;break Z}Q=N-L|0;ca=B-((L>>>0>N>>>0)+Y|0)|0;ga=v[s>>2];ma=v[s+4>>2];g=b;while(1){J=ma+(g<<3)|0;Z=v[J>>2];fa=v[J+4>>2];v[J>>2]=Q;v[J+4>>2]=ca;ia=g<<2;V=A[v[ia+ga>>2]+152>>3];ea=ca-((Q>>>0<Z>>>0)+fa|0)|0;J=ea+v[s+68>>2]|0;X=Q-Z|0;ja=v[s+64>>2];ha=X+ja|0;v[s+64>>2]=ha;v[s+68>>2]=ha>>>0<ja>>>0?J+1|0:J;if(V>.5){J=ea+v[s+76>>2]|0;ea=X;X=X+v[s+72>>2]|0;J=ea>>>0>X>>>0?J+1|0:J;v[s+72>>2]=X;v[s+76>>2]=J}J=v[s+8>>2];if(J){J=v[J+ia>>2];v[J+8>>2]=Q;v[J+12>>2]=ca}J=S+(M-((r>>>0<Q>>>0)+ca|0)|0)|0;r=O+(r-Q|0)|0;M=r>>>0<O>>>0?J+1|0:J;u[s+80>>1]=x[s+80>>1]&(Q>>>0>Z>>>0&(ca|0)>=(fa|0)|(ca|0)>(fa|0)?-576:-64);g=g+1|0;J=R+(g<<3)|0;O=v[J>>2];S=v[J+4>>2];J=Y+S|0;Z=L+O|0;J=Z>>>0<L>>>0?J+1|0:J;if(N>>>0<Z>>>0&(B|0)<=(J|0)|(B|0)<(J|0)){continue}break}Z=v[G>>2]}Z=(g-b|0)+Z|0;v[G>>2]=Z;while(1){b=g;g=b+1|0;O=R+(b<<3)|0;Q=v[O>>2];J=Y+v[O+4>>2]|0;O=L+Q|0;J=O>>>0<L>>>0?J+1|0:J;if((N|0)==(O|0)&(B|0)==(J|0)){continue}break}g=(h>>31&h)-1|0;while(1){_:{if((h|0)<=0){h=g;break _}L=h<<3;h=h-1|0;O=R+(h<<3)|0;L=L+R|0;if(v[O>>2]==v[L>>2]&v[O+4>>2]==v[L+4>>2]){continue}}break}if((b|0)<(h|0)){continue}break I}break}if((b|0)>=(h|0)){break I}J=P<<1|l>>>31;X=N>>>0<l<<1>>>0&(B|0)<=(J|0)|(B|0)<(J|0);$:{if(X){g=b;break $}g=R+(b<<3)|0;L=v[g>>2];Q=v[g+4>>2];J=P+Q|0;g=l+L|0;J=g>>>0<l>>>0?J+1|0:J;if((J|0)<=(B|0)&g>>>0<=N>>>0|(B|0)>(J|0)){g=b;break $}O=N-l|0;Y=B-((l>>>0>N>>>0)+P|0)|0;g=b;while(1){Xm(s,g,O,Y);J=Q+(M-((r>>>0<O>>>0)+Y|0)|0)|0;r=L+(r-O|0)|0;M=r>>>0<L>>>0?J+1|0:J;g=g+1|0;J=R+(g<<3)|0;L=v[J>>2];Q=v[J+4>>2];J=P+Q|0;Z=l+L|0;J=Z>>>0<l>>>0?J+1|0:J;if(N>>>0<Z>>>0&(B|0)<=(J|0)|(B|0)<(J|0)){continue}break}Z=v[G>>2]}Z=(g-b|0)+Z|0;v[G>>2]=Z;while(1){b=g;g=b+1|0;L=R+(b<<3)|0;O=v[L>>2];J=P+v[L+4>>2]|0;L=l+O|0;J=L>>>0<l>>>0?J+1|0:J;if((L|0)==(N|0)&(B|0)==(J|0)){continue}break}if((b|0)>=(h|0)){break I}g=v[S>>2];J=v[S+4>>2]<<1|g>>>31;if(g<<1>>>0>N>>>0&(J|0)>=(B|0)|(B|0)<(J|0)){L=0;Q=0;o=h+1|0;aa:{if((K|0)<=(o|0)){break aa}g=K+(h^-1)|0;O=g&3;ba:{if((K-h|0)-2>>>0<3){g=o;break ba}P=R+24|0;S=R+16|0;Y=R+8|0;Z=g&-4;m=0;g=o;while(1){l=g<<3;J=l+P|0;X=v[J>>2];_=v[J+4>>2];J=l+S|0;aa=v[J>>2];ba=v[J+4>>2];J=l+Y|0;ca=v[J>>2];$=v[J+4>>2];l=l+R|0;fa=v[l>>2];J=Q+v[l+4>>2]|0;l=L+fa|0;J=(l>>>0<L>>>0?J+1|0:J)+$|0;L=l;l=l+ca|0;J=(L>>>0>l>>>0?J+1|0:J)+ba|0;L=l;l=l+aa|0;J=(L>>>0>l>>>0?J+1|0:J)+_|0;L=l+X|0;Q=L>>>0<l>>>0?J+1|0:J;g=g+4|0;m=m+4|0;if((Z|0)!=(m|0)){continue}break}}if(!O){break aa}l=0;while(1){m=R+(g<<3)|0;P=v[m>>2];J=Q+v[m+4>>2]|0;m=L;L=L+P|0;Q=m>>>0>L>>>0?J+1|0:J;g=g+1|0;l=l+1|0;if((O|0)!=(l|0)){continue}break}}J=Q<<1|L>>>31;if(N>>>0<L<<1>>>0&(B|0)<=(J|0)|(B|0)<(J|0)){break I}while(1){g=R+(b<<3)|0;l=v[g>>2];J=Q+v[g+4>>2]|0;g=l+L|0;J=g>>>0<L>>>0?J+1|0:J;if((J|0)>=(B|0)&g>>>0>=N>>>0|(B|0)<(J|0)){b=b+1|0;if((h|0)>(b|0)){continue}break I}break}if(!(N&1)){if((b|0)>(h|0)){break I}m=(B&1)<<31|N>>>1;g=B>>1;while(1){o=R+(b<<3)|0;l=v[o>>2];o=v[o+4>>2];if(l>>>0>m>>>0&(o|0)>=(g|0)|(g|0)<(o|0)){Xm(s,b,m,g);v[G>>2]=v[G>>2]+1;J=o+(M-((m>>>0>r>>>0)+g|0)|0)|0;r=l+(r-m|0)|0;M=r>>>0<l>>>0?J+1|0:J}l=(b|0)<(h|0);b=b+1|0;if(l){continue}break}break I}g=0;if((b|0)>0){while(1){m=R+(g<<3)|0;l=v[m>>2];Xm(s,g,l<<1,v[m+4>>2]<<1|l>>>31);g=g+1|0;if((g|0)<(b|0)){continue}break}}J=M<<1|r>>>31;r=r<<1;M=J;if((b|0)<=(h|0)){while(1){l=R+(b<<3)|0;g=v[l>>2];l=v[l+4>>2];Xm(s,b,N,B);m=M-((r>>>0<N>>>0)+B|0)|0;J=l<<1|g>>>31;g=g<<1;r=g+(r-N|0)|0;J=m+J|0;M=g>>>0>r>>>0?J+1|0:J;g=(b|0)<(h|0);b=b+1|0;if(g){continue}break}}if((o|0)>=(K|0)){break J}while(1){g=R+(o<<3)|0;b=v[g>>2];Xm(s,o,b<<1,v[g+4>>2]<<1|b>>>31);o=o+1|0;if((K|0)!=(o|0)){continue}break}break J}if(X){break I}o=o+1|0;if((o|0)!=4){continue}break}break I}v[C>>2]=v[C>>2]+1;break E}v[G>>2]=K+v[G>>2];b=v[s+56>>2];J=v[s+60>>2]<<1|b>>>31;v[s+56>>2]=b<<1;v[s+60>>2]=J;v[H>>2]=v[H>>2]+1}if(!r&(M|0)<=0|(M|0)<0){break H}b=v[s+56>>2];g=v[s+60>>2]-((r>>>0>b>>>0)+M|0)|0;b=b-r|0;v[s+56>>2]=b;v[s+60>>2]=g;v[H>>2]=v[H>>2]+1}if((U|0)>=v[G>>2]){break E}a_(v[T+16>>2],G,H);break E}if((b|0)==(g|0)){while(1){b=lk(a,T,g);if((b|0)!=1){Eb(154649,8869);v[W+96>>2]=b;Fb(276579,W+96|0);j=b;break D}v[G>>2]=v[G>>2]+1;b=(g|0)<(l|0);l=l-1|0;if(b){continue}break}b=Ay(a,T,C,E);if((b|0)==1){break E}Eb(154649,8881);v[W+80>>2]=b;Fb(276579,W+80|0);j=b;break D}ca:{if(o>>>0>1&(Q|0)>=0|(Q|0)>0){break ca}h=K-b|0;J=(K>>31)-(b>>>0>K>>>0)|0;o=v[P+4>>2];if(h>>>0<y[P>>2]&(J|0)<=(o|0)|(J|0)<(o|0)){break ca}if(!g){break E}m=v[R>>2];o=v[R+4>>2];h=h+1|0;J=h?J:J+1|0;if((h|0)!=(m|0)|(o|0)!=(J|0)){break E}}da:{if((b|0)>=(K|0)){h=l;break da}while(1){m=R+(l<<3)|0;h=v[m>>2];o=v[m+4>>2];r=o;if((o|0)>=0&h>>>0>=2|(o|0)>0){v[m>>2]=1;v[m+4>>2]=0;B=l<<2;V=A[v[B+v[s>>2]>>2]+152>>3];m=1-h|0;M=v[s+64>>2];o=m+M|0;h=0-((h>>>0>1)+r|0)|0;J=h+v[s+68>>2]|0;v[s+64>>2]=o;v[s+68>>2]=o>>>0<M>>>0?J+1|0:J;if(V>.5){J=h+v[s+76>>2]|0;h=m+v[s+72>>2]|0;J=h>>>0<m>>>0?J+1|0:J;v[s+72>>2]=h;v[s+76>>2]=J}h=v[s+8>>2];if(h){h=v[h+B>>2];v[h+8>>2]=1;v[h+12>>2]=0}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}m=(b|0)<(l|0);h=l-1|0;l=h;if(m){continue}break}}r=b;l=K-b|0;b=(K>>31)-(b>>>0>K>>>0)|0;ea:{if((g|0)>(h|0)){o=h;break ea}while(1){o=R+(h<<3)|0;m=v[o>>2];M=v[o+4>>2];B=M;if(l>>>0<m>>>0&(b|0)<=(B|0)|(b|0)<(B|0)){v[o>>2]=l;v[o+4>>2]=b;N=h<<2;V=A[v[N+v[s>>2]>>2]+152>>3];o=l-m|0;L=v[s+64>>2];B=o+L|0;m=b-((l>>>0<m>>>0)+M|0)|0;J=m+v[s+68>>2]|0;v[s+64>>2]=B;v[s+68>>2]=B>>>0<L>>>0?J+1|0:J;if(V>.5){J=m+v[s+76>>2]|0;m=o+v[s+72>>2]|0;J=m>>>0<o>>>0?J+1|0:J;v[s+72>>2]=m;v[s+76>>2]=J}m=v[s+8>>2];if(m){m=v[m+N>>2];v[m+8>>2]=l;v[m+12>>2]=b}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}m=(g|0)<(h|0);o=h-1|0;h=o;if(m){continue}break}}h=l+1|0;m=h?b:b+1|0;if((o|0)>=0){while(1){M=R+(o<<3)|0;B=v[M>>2];L=v[M+4>>2];if(h>>>0<B>>>0&(m|0)<=(L|0)|(m|0)<(L|0)){v[M>>2]=h;v[M+4>>2]=m;O=o<<2;V=A[v[O+v[s>>2]>>2]+152>>3];M=h-B|0;P=v[s+64>>2];N=M+P|0;B=m-((h>>>0<B>>>0)+L|0)|0;J=B+v[s+68>>2]|0;v[s+64>>2]=N;v[s+68>>2]=N>>>0<P>>>0?J+1|0:J;if(V>.5){J=B+v[s+76>>2]|0;B=M+v[s+72>>2]|0;J=B>>>0<M>>>0?J+1|0:J;v[s+72>>2]=B;v[s+76>>2]=J}B=v[s+8>>2];if(B){B=v[B+O>>2];v[B+8>>2]=h;v[B+12>>2]=m}u[s+80>>1]=x[s+80>>1]&65472;v[G>>2]=v[G>>2]+1}B=(o|0)>0;o=o-1|0;if(B){continue}break}}h=Yfb(h,m,g-1|0,0-!g|0);m=yb;J=0-(g>>>0>r>>>0)|0;g=(r-g|0)+1|0;J=g?J:J+1|0;g=Yfb(g,J,l,b);b=g+h|0;J=yb+m|0;J=b>>>0<g>>>0?J+1|0:J;g=v[s+60>>2];if(y[s+56>>2]<=b>>>0&(J|0)>=(g|0)|(g|0)<(J|0)){break E}v[s+56>>2]=b;v[s+60>>2]=J;v[H>>2]=v[H>>2]+1;break E}b=Ay(a,T,C,E);if((b|0)==1){break E}Eb(154649,8748);v[W+64>>2]=b;Fb(276579,W- -64|0);j=b;break D}if(w[T+86|0]&8){break x}h=0;r=0;M=0;L=ub-1200|0;ub=L;o=v[T+16>>2];b=o;B=v[b+56>>2];O=v[b+60>>2];R=v[b+4>>2];S=v[b>>2];fa:{ga:{ha:{g=v[b+28>>2];if((g|0)<=0){break ha}while(1){b=R+(h<<3)|0;l=v[b>>2];J=M+v[b+4>>2]|0;b=l+r|0;J=b>>>0<r>>>0?J+1|0:J;if(b>>>0>B>>>0&(J|0)>=(O|0)|(J|0)>(O|0)){break ha}r=b;M=J;h=h+1|0;if((g|0)!=(h|0)){continue}break}s=g-1|0;h=g;break ga}s=g-1|0;if((s|0)==(h|0)){b=1;g=Ay(a,T,C,E);if((g|0)==1){break fa}Eb(154649,8209);v[L>>2]=g;Fb(276579,L);b=g;break fa}if((h|0)>=(s|0)){break ga}b=1;g=yZ(a,T,r,M,h,G,H,E);if((g|0)!=1){Eb(154649,8218);v[L+32>>2]=g;Fb(276579,L+32|0);b=g;break fa}if((v[o+28>>2]-1|0)!=(h|0)){break fa}g=Ay(a,T,C,E);if((g|0)==1){break fa}Eb(154649,8224);v[L+16>>2]=g;Fb(276579,L+16|0);b=g;break fa}b=1;Y=v[v[T+12>>2]+328>>2];l=Hv(a,Y,o,1,0);if((l|0)!=1){Eb(154649,8243);v[L+144>>2]=l;Fb(276579,L+144|0);b=l;break fa}Q=v[o+12>>2];if(v[Q+(h<<2)>>2]>=(h|0)){break fa}r=0;M=0;l=0;ia:{if((g|0)<=0){break ia}N=0;P=0;b=0;while(1){J=R+(l<<3)|0;m=v[J>>2];K=v[J+4>>2];if(v[Q+(l<<2)>>2]==(b|0)){J=K+P|0;N=m+N|0;J=N>>>0<m>>>0?J+1|0:J;P=J;if(B>>>0<N>>>0&(O|0)<=(J|0)|(J|0)>(O|0)){break ia}b=b+1|0}J=K+M|0;r=m+r|0;M=r>>>0<m>>>0?J+1|0:J;l=l+1|0;if((g|0)!=(l|0)){continue}break}l=g}ja:{if(!(!v[Y+108>>2]|(g|0)!=(l|0))){r=v[o+36>>2];m=Ib(v[v[a>>2]+8>>2],(g-r|0)+1|0,4,154615,8294);v[L+1196>>2]=m;if(!m){break ja}if((r|0)>0){s=g&2147483646;M=g&1;l=0;while(1){ka:{if((g|0)<=0){break ka}h=0;o=0;b=0;if((g|0)!=1){while(1){N=h<<2;if(v[N+Q>>2]==(l|0)){v[m+(o<<2)>>2]=v[N+S>>2];o=o+1|0}N=(h|1)<<2;if(v[N+Q>>2]==(l|0)){v[m+(o<<2)>>2]=v[N+S>>2];o=o+1|0}h=h+2|0;b=b+2|0;if((s|0)!=(b|0)){continue}break}}la:{if(!M){break la}b=h<<2;if(v[b+Q>>2]!=(l|0)){break la}v[m+(o<<2)>>2]=v[b+S>>2];o=o+1|0}if((o|0)<2){break ka}b=v[T+8>>2];v[L+112>>2]=l;v[L+104>>2]=B;v[L+108>>2]=O;v[L+96>>2]=b;b=L+160|0;Jb(b,1024,139900,L+96|0);ma:{N=L+1192|0;h=b;b=v[T+84>>2];b=jf(a,N,h,o,m,1,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);h=8319;na:{if((b|0)!=1){break na}b=mc(a,v[L+1192>>2]);h=8322;if((b|0)!=1){break na}b=ec(a,N);if((b|0)==1){break ma}h=8323}Eb(154649,h);v[L+80>>2]=b;Fb(276579,L+80|0);break fa}v[E>>2]=v[E>>2]+1}l=l+1|0;if((r|0)!=(l|0)){continue}break}}b=$e(a,T);if((b|0)!=1){Eb(154649,8329);v[L+64>>2]=b;Fb(276579,L- -64|0);break fa}v[C>>2]=v[C>>2]+1;Hb(v[v[a>>2]+8>>2],L+1196|0,154615,8332);b=1;break fa}b=1;if((l|0)>=(s|0)|h>>>0>=l>>>0){break fa}g=yZ(a,T,r,M,l,G,H,E);if((g|0)==1){break fa}Eb(154649,8340);v[L+128>>2]=g;Fb(276579,L+128|0);b=g;break fa}Eb(154649,8294);b=-1;v[L+48>>2]=-1;Fb(276579,L+48|0)}ub=L+1200|0;if((b|0)!=1){Eb(154649,9465);v[W+16>>2]=b;Fb(276579,W+16|0);j=b;break x}if(w[T+86|0]&8){break x}}s=v[F+4>>2];l=v[F+28>>2];j=l-1|0;b=s+(j<<3)|0;r=v[b>>2];b=v[b+4>>2];M=b;g=r>>>0>1&(b|0)>=0|(b|0)>0;oa:{if(r>>>0<2&(b|0)<=0|(b|0)<0|(l|0)<2){break oa}h=l-2|0;while(1){b=s+(h<<3)|0;r=Kg(r,M,v[b>>2],v[b+4>>2]);b=yb;M=b;g=r>>>0>1&(b|0)>=0|(b|0)>0;if(!h){break oa}h=h-1|0;if(r>>>0>1&(b|0)>=0|(b|0)>0){continue}break}}if(g){if((l|0)>0){N=v[F+4>>2];L=v[F>>2];while(1){b=j<<3;h=b+N|0;g=v[h>>2];o=v[h+4>>2];b=b+s|0;b=Zfb(v[b>>2],v[b+4>>2],r,M);v[h>>2]=b;m=yb;v[h+4>>2]=m;O=j<<2;V=A[v[O+L>>2]+152>>3];Q=m-((b>>>0<g>>>0)+o|0)|0;J=Q+v[F+68>>2]|0;h=b-g|0;P=v[F+64>>2];B=h+P|0;v[F+64>>2]=B;v[F+68>>2]=B>>>0<P>>>0?J+1|0:J;if(V>.5){J=Q+v[F+76>>2]|0;B=h;h=h+v[F+72>>2]|0;J=B>>>0>h>>>0?J+1|0:J;v[F+72>>2]=h;v[F+76>>2]=J}h=v[F+8>>2];if(h){h=v[h+O>>2];v[h+8>>2]=b;v[h+12>>2]=m}u[F+80>>1]=x[F+80>>1]&(b>>>0>g>>>0&(m|0)>=(o|0)|(m|0)>(o|0)?-576:-64);b=(j|0)>0;j=j-1|0;if(b){continue}break}}v[G>>2]=l+v[G>>2];v[F+56>>2]=Zfb(v[F+56>>2],v[F+60>>2],r,M);v[F+60>>2]=yb;v[H>>2]=v[H>>2]+1}while(1){O=v[F+4>>2];s=v[F+28>>2];b=s-1|0;L=O+(b<<3)|0;g=L;N=v[g>>2];g=v[g+4>>2];P=g;pa:{if((N|0)!=1|g){break pa}g=(O+(s<<3)|0)-16|0;if(v[g>>2]!=1|v[g+4>>2]){break pa}j=1;break x}r=v[F+56>>2];M=v[F+60>>2];j=0;while(1){h=j;j=h+1|0;g=O+(h<<3)|0;if((r|0)==v[g>>2]&(M|0)==v[g+4>>2]){continue}break}j=1;if((b|0)==(h|0)){break x}qa:{ra:{sa:{ta:{if((h|0)>=(s|0)){N=-1;P=-1;L=0;Q=0;break ta}B=s-2|0;ua:{va:{wa:{if((N|0)!=1|P){if((b|0)>(h|0)){break wa}r=v[F+56>>2];M=v[F+60>>2];L=_fb(r,M,N,P);Q=yb;break ta}N=-1;P=-1;g=b;if((b|0)<=(h|0)){break ua}m=O+(B<<3)|0;g=m;r=v[g>>2];M=v[g+4>>2];o=b;break va}m=O+(B<<3)|0;g=m;r=v[g>>2];M=v[g+4>>2];o=-1;if((N&P)==-1){N=-1;P=-1;break va}r=Kg(N,P,r,M);M=yb}l=-1;xa:{if((r|0)!=1|M){g=o;N=r;P=M;break xa}l=b;g=B;if((o|0)==-1){break xa}if((b|0)!=(o|0)|(s|0)!=-1){break x}l=-1;g=-1;N=Kg(v[L>>2],v[L+4>>2],v[m>>2],v[m+4>>2]);m=yb;P=m;if(!m&(N|0)==1){break x}}if((h|0)>=(B|0)){break ua}j=s-3|0;while(1){m=j;B=O+(m<<3)|0;j=B;r=v[j>>2];M=v[j+4>>2];o=g;if((N&P)!=-1){r=Kg(N,P,r,M);M=yb}ya:{if((r|0)!=1|M){N=r;P=M;break ya}g=m;if((o|0)==-1){break ya}j=1;if((o|0)!=(g+1|0)|(g+2|0)!=(l|0)){break x}g=l;o=O+(o<<3)|0;N=Kg(v[o>>2],v[o+4>>2],v[B>>2],v[B+4>>2]);o=yb;P=o;if(!o&(N|0)==1){break x}}j=m-1|0;if((h|0)<(m|0)){continue}break}}r=v[F+56>>2];M=v[F+60>>2];L=_fb(r,M,N,P);Q=yb;if((g|0)!=-1){break sa}}g=M-((r>>>0<L>>>0)+Q|0)|0;m=g;b=r-L|0;v[F+56>>2]=b;v[F+60>>2]=g;v[H>>2]=v[H>>2]+1;if(!h){break ra}B=v[F+4>>2];M=v[F>>2];j=0;while(1){l=B+(j<<3)|0;g=v[l>>2];o=v[l+4>>2];v[l>>2]=b;v[l+4>>2]=m;L=j<<2;V=A[v[L+M>>2]+152>>3];S=m-((b>>>0<g>>>0)+o|0)|0;J=S+v[F+68>>2]|0;l=b-g|0;Q=v[F+64>>2];r=l+Q|0;v[F+64>>2]=r;v[F+68>>2]=r>>>0<Q>>>0?J+1|0:J;if(V>.5){J=S+v[F+76>>2]|0;r=l;l=l+v[F+72>>2]|0;J=r>>>0>l>>>0?J+1|0:J;v[F+72>>2]=l;v[F+76>>2]=J}l=v[F+8>>2];if(l){l=v[l+L>>2];v[l+8>>2]=b;v[l+12>>2]=m}u[F+80>>1]=x[F+80>>1]&(b>>>0>g>>>0&(m|0)>=(o|0)|(m|0)>(o|0)?-576:-64);j=j+1|0;if((j|0)!=(h|0)){continue}break}break ra}l=O+(g<<3)|0;j=v[l>>2];B=v[l+4>>2];l=_fb(j,B,N,P);J=yb;S=L>>>0<l>>>0&(Q|0)<=(J|0)|(J|0)>(Q|0);o=j-l|0;m=(S?N:0)+o|0;J=(B-((j>>>0<l>>>0)+J|0)|0)+(S?P:0)|0;J=m>>>0<o>>>0?J+1|0:J;B=J;if(h){j=1;if(!(m|J)){break x}}if(!!L&(Q|0)>=0|(Q|0)>0){j=M-((r>>>0<L>>>0)+Q|0)|0;M=j;l=r-L|0;v[F+56>>2]=l;v[F+60>>2]=j;v[H>>2]=v[H>>2]+1;if(h){S=v[F+4>>2];R=v[F>>2];j=0;while(1){r=S+(j<<3)|0;o=v[r>>2];L=v[r+4>>2];v[r>>2]=l;v[r+4>>2]=M;K=j<<2;V=A[v[K+R>>2]+152>>3];Z=M-((l>>>0<o>>>0)+L|0)|0;J=Z+v[F+68>>2]|0;r=l-o|0;Y=v[F+64>>2];Q=r+Y|0;v[F+64>>2]=Q;v[F+68>>2]=Q>>>0<Y>>>0?J+1|0:J;if(V>.5){J=Z+v[F+76>>2]|0;Y=r;r=r+v[F+72>>2]|0;J=Y>>>0>r>>>0?J+1|0:J;v[F+72>>2]=r;v[F+76>>2]=J}r=v[F+8>>2];if(r){r=v[r+K>>2];v[r+8>>2]=l;v[r+12>>2]=M}u[F+80>>1]=x[F+80>>1]&((L|0)<=(M|0)&l>>>0>o>>>0|(L|0)<(M|0)?-576:-64);j=j+1|0;if((j|0)!=(h|0)){continue}break}}v[G>>2]=v[G>>2]+h}if(!(m|B)){h=1;j=lk(a,T,g);if((j|0)==1){break qa}Eb(154649,9674);v[W>>2]=j;Fb(276579,W);break x}Xm(F,g,m,B);h=1}b=s}g=v[G>>2]+h|0;v[G>>2]=g;if((b|0)>0){B=v[F+4>>2];M=v[F>>2];h=b;while(1){l=h-1|0;g=l<<3;m=g+B|0;j=v[m>>2];r=v[m+4>>2];g=g+O|0;g=Zfb(v[g>>2],v[g+4>>2],N,P);v[m>>2]=g;o=yb;v[m+4>>2]=o;L=l<<2;V=A[v[L+M>>2]+152>>3];S=o-((g>>>0<j>>>0)+r|0)|0;J=S+v[F+68>>2]|0;m=g-j|0;Q=v[F+64>>2];s=m+Q|0;v[F+64>>2]=s;v[F+68>>2]=s>>>0<Q>>>0?J+1|0:J;if(V>.5){J=S+v[F+76>>2]|0;s=m;m=m+v[F+72>>2]|0;J=s>>>0>m>>>0?J+1|0:J;v[F+72>>2]=m;v[F+76>>2]=J}m=v[F+8>>2];if(m){m=v[m+L>>2];v[m+8>>2]=g;v[m+12>>2]=o}u[F+80>>1]=x[F+80>>1]&(g>>>0>j>>>0&(o|0)>=(r|0)|(o|0)>(r|0)?-576:-64);g=h>>>0>1;h=l;if(g){continue}break}g=v[G>>2]}v[G>>2]=b+g;v[F+56>>2]=Zfb(v[F+56>>2],v[F+60>>2],N,P);v[F+60>>2]=yb;j=1;v[H>>2]=v[H>>2]+1;if((b|0)>1){continue}break}break x}Eb(154649,9460);v[W+32>>2]=j;Fb(276579,W+32|0)}ub=W+256|0;b=j;if((b|0)!=1){Eb(154649,12673);v[k+128>>2]=b;Fb(276579,k+128|0);break a}if(v[k+256>>2]){break c}if(w[T+86|0]&8){break e}if(v[q>>2]<=(i|0)){break w}b=Ky(a,T,k+256|0);if((b|0)!=1){Eb(154649,12683);v[k+112>>2]=b;Fb(276579,k+112|0);break a}if(v[k+256>>2]){break c}}F=0;B=0;K=ub-1888|0;ub=K;W=v[v[T+12>>2]+328>>2];o=v[T+16>>2];l=1;ba=k+256|0;b=it(a,T,ba);za:{if((b|0)!=1){Eb(154649,10403);v[K+752>>2]=b;Fb(276579,K+752|0);l=b;break za}if(v[ba>>2]){break za}ha=f&4;Aa:{if(!ha){break Aa}while(1){tm(o);Ba:{if(v[o+28>>2]<=0){break Ba}O=v[o+56>>2];S=v[o+60>>2];N=v[o+64>>2];P=v[o+68>>2];s=v[o+4>>2];b=0;while(1){i=s+(b<<3)|0;h=i;g=v[h>>2];j=N-g|0;m=v[h+4>>2];h=P-(m+(g>>>0>N>>>0)|0)|0;if((S|0)<=(h|0)&j>>>0>=O>>>0|(h|0)>(S|0)){break Ba}h=N-O|0;v[i>>2]=h;j=P-((N>>>0<O>>>0)+S|0)|0;v[i+4>>2]=j;M=b<<2;V=A[v[M+v[o>>2]>>2]+152>>3];i=h-g|0;L=v[o+64>>2];N=i+L|0;r=j-((g>>>0>h>>>0)+m|0)|0;J=r+v[o+68>>2]|0;J=L>>>0>N>>>0?J+1|0:J;P=J;v[o+64>>2]=N;v[o+68>>2]=J;if(V>.5){J=r+v[o+76>>2]|0;L=i+v[o+72>>2]|0;J=L>>>0<i>>>0?J+1|0:J;v[o+72>>2]=L;v[o+76>>2]=J}L=v[o+8>>2];if(L){M=v[L+M>>2];v[M+8>>2]=h;v[M+12>>2]=j}J=r+v[o+60>>2]|0;O=i+v[o+56>>2]|0;J=O>>>0<i>>>0?J+1|0:J;S=J;v[o+56>>2]=O;v[o+60>>2]=J;u[o+80>>1]=x[o+80>>1]&(g>>>0<h>>>0&(j|0)>=(m|0)|(j|0)>(m|0)?-576:-64);v[G>>2]=v[G>>2]+1;v[H>>2]=v[H>>2]+1;b=b+1|0;if((b|0)<v[o+28>>2]){continue}break}}if(w[o+80|0]&32){break Aa}b=v[o+68>>2];g=v[o+60>>2];if(y[o+64>>2]>y[o+56>>2]&(b|0)>=(g|0)|(b|0)>(g|0)){continue}break}}s=v[o+60>>2];b=s;g=v[o+68>>2];h=v[o+56>>2];if((b|0)>=(g|0)&h>>>0>=y[o+64>>2]|(b|0)>(g|0)){break za}Ca:{Da:{i=v[o+28>>2];if((i|0)<=0){b=0;break Da}m=o+4|0;R=v[o+4>>2];g=0;Ea:{while(1){j=R+(g<<3)|0;b=v[j>>2];l=v[j+4>>2];if((h|0)!=(b|0)|(s|0)!=(l|0)){break Ea}g=g+1|0;if((i|0)!=(g|0)){continue}break}b=i;break Da}if(!(f&12)){b=g;break Ca}J=l+v[j+12>>2]|0;l=b;b=b+v[j+8>>2]|0;J=l>>>0>b>>>0?J+1|0:J;if((J|0)<=(s|0)&b>>>0<=h>>>0|(s|0)>(J|0)){b=g;break Ca}$=i-4|0;_=R+($<<3)|0;S=i-1|0;aa=R+(S<<3)|0;O=i-2|0;Y=R+(O<<3)|0;Z=(R+(i<<3)|0)-8|0;P=i-3|0;U=R+(P<<3)|0;L=0;Q=0;while(1){Fa:{Ga:{switch(B|0){case 0:r=v[aa>>2];M=v[aa+4>>2];j=S;break Fa;case 1:r=v[Y>>2];M=v[Y+4>>2];j=O;break Fa;case 2:J=v[Y+4>>2]+v[Z+4>>2]|0;b=v[U>>2];M=b;r=v[Z>>2];l=r+v[Y>>2]|0;j=v[U+4>>2];J=l>>>0<r>>>0?J+1|0:J;F=b>>>0<l>>>0&(j|0)<=(J|0)|(j|0)<(J|0);b=F;r=b?M:l;M=b?j:J;j=b?P:O;break Fa;default:break Ga}}if(F){J=v[Y+4>>2]+v[Z+4>>2]|0;b=v[_>>2];F=b;r=v[Z>>2];l=r+v[Y>>2]|0;j=v[_+4>>2];J=l>>>0<r>>>0?J+1|0:J;b=b>>>0<l>>>0&(j|0)<=(J|0)|(j|0)<(J|0);r=b?F:l;M=b?j:J;F=1;j=b?$:O;break Fa}r=v[U>>2];M=v[U+4>>2];F=0;j=P}if((j|0)<=(g|0)){b=g;break Ca}l=h-L|0;Q=s-((h>>>0<L>>>0)+Q|0)|0;b=g;Ha:{while(1){L=R+(b<<3)|0;N=v[L>>2];J=v[L+4>>2];X=J;J=J<<1|N>>>31;if((s|0)>=(J|0)&h>>>0>=N<<1>>>0|(s|0)>(J|0)){break Ha}J=M+X|0;ca=r+N|0;J=ca>>>0<N>>>0?J+1|0:J;if((s|0)>=(J|0)&h>>>0>=ca>>>0|(s|0)>(J|0)){break Ha}v[L>>2]=l;v[L+4>>2]=Q;fa=b<<2;V=A[v[fa+v[o>>2]>>2]+152>>3];ga=Q-((l>>>0<N>>>0)+X|0)|0;J=ga+v[o+68>>2]|0;L=l-N|0;da=v[o+64>>2];ca=L+da|0;v[o+64>>2]=ca;v[o+68>>2]=ca>>>0<da>>>0?J+1|0:J;if(V>.5){J=ga+v[o+76>>2]|0;ea=L;L=L+v[o+72>>2]|0;J=ea>>>0>L>>>0?J+1|0:J;v[o+72>>2]=L;v[o+76>>2]=J}L=v[o+8>>2];if(L){L=v[L+fa>>2];v[L+8>>2]=l;v[L+12>>2]=Q}u[o+80>>1]=x[o+80>>1]&(l>>>0>N>>>0&(Q|0)>=(X|0)|(Q|0)>(X|0)?-576:-64);b=b+1|0;if((j|0)!=(b|0)){continue}break}b=j}v[G>>2]=v[G>>2]+(b-g|0);Ia:{if((b|0)>=(i|0)){break Ia}while(1){g=R+(b<<3)|0;l=v[g>>2];J=M+v[g+4>>2]|0;g=l+r|0;J=g>>>0<r>>>0?J+1|0:J;if((g|0)!=(h|0)|(s|0)!=(J|0)){break Ia}b=b+1|0;if((i|0)!=(b|0)){continue}break}b=i}Ja:{if((j|0)!=(b+1|0)){break Ja}l=R+(b<<3)|0;g=v[l>>2];l=v[l+4>>2];if(g>>>0<=r>>>0&(M|0)>=(l|0)|(l|0)<(M|0)){break Ja}Ka:{switch(B|0){case 1:N=v[Z>>2];J=l+M|0;l=g;g=g+r|0;J=v[Z+4>>2]+(l>>>0>g>>>0?J+1|0:J)|0;l=g;g=g+N|0;J=l>>>0>g>>>0?J+1|0:J;if((s|0)>=(J|0)&g>>>0<=h>>>0|(s|0)>(J|0)){break Ja}break;case 0:break Ka;default:break Ja}}Xm(o,b,h-r|0,s-((h>>>0<r>>>0)+M|0)|0);break Ca}if((b|0)>=(j|0)){break Ca}L=r;Q=M;g=b;B=B+1|0;if((B|0)!=4){continue}break}break Ca}m=o+4|0}La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{if(!(f&8)){break Ta}i=v[o+28>>2];Ua:{Va:{Wa:{Xa:{if(!v[W+108>>2]){break Xa}j=i-b|0;r=j;if((b|0)<=0|(r|0)>1e3|(i|0)<2){break Xa}h=v[o+56>>2];j=v[o+60>>2];g=j;l=0-(b>>>0>i>>>0)|0;if(r>>>0>h>>>0&(g|0)<=(l|0)|(g|0)<(l|0)){break Xa}l=v[m>>2];g=b-1|0;s=l+(g<<3)|0;if((h|0)!=v[s>>2]|(j|0)!=v[s+4>>2]){break Xa}if((b|0)==(i|0)){break Wa}h=l+(b<<3)|0;j=v[h>>2];if(!v[h+4>>2]&(j|0)==1){break Va}}if((i|0)>=1001){if(!(w[o+80|0]&64)|v[o+36>>2]>1e3){break Ta}}b=Ib(v[v[a>>2]+8>>2],v[o+28>>2],8,154615,10680);v[K+1880>>2]=b;if(b){break Ua}Eb(154649,10680);l=-1;v[K+416>>2]=-1;Fb(276579,K+416|0);break za}g=b;b=v[T+84>>2];l=jf(a,K+1872|0,v[T+8>>2],g,v[o>>2],1,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);if((l|0)!=1){Eb(154649,10597);v[K+592>>2]=l;Fb(276579,K+592|0);break za}l=mc(a,v[K+1872>>2]);if((l|0)!=1){Eb(154649,10599);v[K+576>>2]=l;Fb(276579,K+576|0);break za}l=ec(a,K+1872|0);if((l|0)!=1){Eb(154649,10600);v[K+560>>2]=l;Fb(276579,K+560|0);break za}v[E>>2]=v[E>>2]+1;l=pc(a,T);if((l|0)!=1){Eb(154649,10604);v[K+544>>2]=l;Fb(276579,K+544|0);break za}l=1;v[C>>2]=v[C>>2]+1;break za}s=Ib(v[v[a>>2]+8>>2],r,4,154615,10613);v[K+1848>>2]=s;if(!s){Eb(154649,10613);l=-1;v[K+608>>2]=-1;Fb(276579,K+608|0);break za}l=Kz(a,v[o>>2]+(b<<2)|0,r,s,K+1836|0);if((l|0)!=1){Eb(154649,10616);v[K+736>>2]=l;Fb(276579,K+736|0);break za}m=Ib(v[v[a>>2]+8>>2],(i-v[K+1836>>2]|0)+1|0,4,154615,10628);v[K+1880>>2]=m;if(!m){break Sa}j=b&3;if(j){h=0;while(1){l=g<<2;v[l+m>>2]=v[l+v[o>>2]>>2];g=g-1|0;h=h+1|0;if((j|0)!=(h|0)){continue}break}}if(b>>>0>=4){while(1){h=g<<2;v[h+m>>2]=v[h+v[o>>2]>>2];j=h-4|0;v[j+m>>2]=v[j+v[o>>2]>>2];h=h-8|0;v[h+m>>2]=v[h+v[o>>2]>>2];h=g-3|0;j=h<<2;v[j+m>>2]=v[j+v[o>>2]>>2];g=g-4|0;if(h){continue}break}}if(v[K+1836>>2]>0){g=b+1|0;B=b<<2;F=B+m|0;M=i+(b^-1)|0;j=0;while(1){i=b;Ya:{if((j|0)>=(r|0)){break Ya}h=j;if(r-h&1){h=h<<2;if((j|0)==v[h+s>>2]){v[F>>2]=v[B+(h+v[o>>2]|0)>>2];i=g}h=j+1|0}if((j|0)==(M|0)){break Ya}while(1){l=h<<2;if(v[l+s>>2]==(j|0)){v[m+(i<<2)>>2]=v[B+(l+v[o>>2]|0)>>2];i=i+1|0}l=h+1<<2;if(v[l+s>>2]==(j|0)){v[m+(i<<2)>>2]=v[B+(l+v[o>>2]|0)>>2];i=i+1|0}h=h+2|0;if((r|0)>(h|0)){continue}break}}h=v[T+8>>2];l=v[o+56>>2];N=v[o+60>>2];v[K+720>>2]=j;v[K+712>>2]=l;v[K+716>>2]=N;v[K+704>>2]=h;h=K+768|0;Jb(h,1024,139900,K+704|0);l=h;h=v[T+84>>2];l=jf(a,K+1872|0,l,i,m,1,h&1,h>>>1&1,h>>>2&1,h>>>3&1,h>>>4&1,h>>>7&1,h>>>8&1,h>>>9&1,h>>>10&1,h>>>11&1);if((l|0)!=1){Eb(154649,10656);v[K+688>>2]=l;Fb(276579,K+688|0);break za}l=mc(a,v[K+1872>>2]);if((l|0)!=1){Eb(154649,10659);v[K+672>>2]=l;Fb(276579,K+672|0);break za}l=ec(a,K+1872|0);if((l|0)!=1){Eb(154649,10660);v[K+656>>2]=l;Fb(276579,K+656|0);break za}v[E>>2]=v[E>>2]+1;j=j+1|0;if((j|0)<v[K+1836>>2]){continue}break}}l=pc(a,T);if((l|0)!=1){Eb(154649,10665);v[K+640>>2]=l;Fb(276579,K+640|0);break za}l=1;v[C>>2]=v[C>>2]+1;Hb(v[v[a>>2]+8>>2],K+1880|0,154615,10668);Hb(v[v[a>>2]+8>>2],K+1848|0,154615,10669);break za}b=Ib(v[v[a>>2]+8>>2],v[o+28>>2],8,154615,10681);v[K+1872>>2]=b;if(!b){Eb(154649,10681);l=-1;v[K+432>>2]=-1;Fb(276579,K+432|0);break za}b=Ib(v[v[a>>2]+8>>2],v[o+28>>2],4,154615,10682);v[K+1848>>2]=b;if(!b){break Ra}while(1){tm(o);l=Hv(a,W,o,1,0);if((l|0)!=1){Eb(154649,10697);v[K+528>>2]=l;Fb(276579,K+528|0);break za}i=v[o+12>>2];b=v[o+28>>2];g=b-1|0;Za:{if(v[i+(g<<2)>>2]==(g|0)){break Za}_a:{if((b|0)<=0){break _a}l=b&1;j=v[K+1880>>2];$a:{if(!g){r=0;M=0;b=0;F=0;break $a}s=b&2147483646;r=0;M=0;b=0;F=0;h=0;while(1){if(v[i+(b<<2)>>2]==(F|0)){B=v[m>>2]+(b<<3)|0;g=v[B>>2];B=v[B+4>>2];N=j+(F<<3)|0;v[N>>2]=g;v[N+4>>2]=B;J=B+M|0;r=g+r|0;M=r>>>0<g>>>0?J+1|0:J;F=F+1|0}g=b|1;if(v[i+(g<<2)>>2]==(F|0)){B=v[m>>2]+(g<<3)|0;g=v[B>>2];B=v[B+4>>2];N=j+(F<<3)|0;v[N>>2]=g;v[N+4>>2]=B;J=B+M|0;r=g+r|0;M=r>>>0<g>>>0?J+1|0:J;F=F+1|0}b=b+2|0;h=h+2|0;if((s|0)!=(h|0)){continue}break}}if(!(!l|v[i+(b<<2)>>2]!=(F|0))){g=v[m>>2]+(b<<3)|0;b=v[g>>2];g=v[g+4>>2];h=j+(F<<3)|0;v[h>>2]=b;v[h+4>>2]=g;F=F+1|0;J=g+M|0;r=b+r|0;M=r>>>0<b>>>0?J+1|0:J}g=0;i=0;if((F|0)<=0){break _a}while(1){N=v[o+56>>2];h=v[K+1880>>2]+(g<<3)|0;j=v[h>>2];s=r-j|0;b=N-s|0;l=b;B=M-(v[h+4>>2]+(j>>>0>r>>>0)|0)|0;h=v[o+60>>2]-(B+(s>>>0>N>>>0)|0)|0;L=h;ab:{if(!b&(h|0)<=0|(h|0)<0){break ab}h=v[o+28>>2];if((h|0)<=(g|0)){v[o+56>>2]=s;v[o+60>>2]=B;v[H>>2]=v[H>>2]+1;break ab}O=v[o+12>>2];j=0;J=v[K+1848>>2];P=v[K+1872>>2];b=g;while(1){if(v[O+(b<<2)>>2]==(g|0)){Q=v[o+4>>2]+(b<<3)|0;h=v[Q>>2];N=h-l|0;h=v[Q+4>>2]-((h>>>0<l>>>0)+L|0)|0;Q=P+(j<<3)|0;S=N;N=!!N&(h|0)>=0|(h|0)>0;v[Q>>2]=N?S:0;v[Q+4>>2]=N?h:0;v[J+(j<<2)>>2]=b;j=j+1|0;h=v[o+28>>2]}b=b+1|0;if((h|0)>(b|0)){continue}break}bb:{if((j|0)>=2){b=v[K+1872>>2]+(j<<3)|0;h=b-8|0;l=b-16|0;N=v[l>>2];b=v[h>>2]+N|0;J=v[h+4>>2]+v[l+4>>2]|0;J=b>>>0<N>>>0?J+1|0:J;l=b>>>0<=s>>>0&(B|0)>=(J|0)|(B|0)>(J|0);if(l&!v[W+108>>2]){break ab}v[o+56>>2]=s;v[o+60>>2]=B;v[H>>2]=v[H>>2]+1;break bb}v[o+56>>2]=s;v[o+60>>2]=B;v[H>>2]=v[H>>2]+1;b=(j|0)!=1;l=0;j=1;if(b){break ab}}Q=v[o+4>>2];S=v[o>>2];b=0;R=v[K+1872>>2];Y=v[K+1848>>2];while(1){J=v[Y+(b<<2)>>2];B=Q+(J<<3)|0;s=v[B>>2];L=v[B+4>>2];O=R+(b<<3)|0;N=O;h=v[N>>2];N=v[N+4>>2];v[B>>2]=h;v[B+4>>2]=N;Z=J<<2;V=A[v[Z+S>>2]+152>>3];X=N-((h>>>0<s>>>0)+L|0)|0;J=X+v[o+68>>2]|0;B=h-s|0;U=v[o+64>>2];P=B+U|0;v[o+64>>2]=P;v[o+68>>2]=P>>>0<U>>>0?J+1|0:J;if(V>.5){J=X+v[o+76>>2]|0;P=B;B=B+v[o+72>>2]|0;J=P>>>0>B>>>0?J+1|0:J;v[o+72>>2]=B;v[o+76>>2]=J}B=v[o+8>>2];if(B){B=v[B+Z>>2];v[B+8>>2]=h;v[B+12>>2]=N}u[o+80>>1]=x[o+80>>1]&((L|0)<=(N|0)&h>>>0>s>>>0|(L|0)<(N|0)?-576:-64);h=1;v[G>>2]=v[G>>2]+1;h=i?h:!(v[O>>2]|v[O+4>>2]);i=h;b=b+1|0;if((j|0)!=(b|0)){continue}break}if(l){i=10832;b=Ib(v[v[a>>2]+8>>2],j,4,154615,10832);v[K+1868>>2]=b;cb:{db:{if(!b){l=-1;break db}b=0;if((j|0)!=1){s=j&2147483646;i=0;while(1){l=b<<2;v[l+v[K+1868>>2]>>2]=v[v[o>>2]+(v[l+v[K+1848>>2]>>2]<<2)>>2];l=l|4;v[l+v[K+1868>>2]>>2]=v[v[o>>2]+(v[l+v[K+1848>>2]>>2]<<2)>>2];b=b+2|0;i=i+2|0;if((s|0)!=(i|0)){continue}break}}if(j&1){b=b<<2;v[b+v[K+1868>>2]>>2]=v[v[o>>2]+(v[b+v[K+1848>>2]>>2]<<2)>>2]}b=v[T+8>>2];i=v[o+56>>2];l=v[o+60>>2];v[K+512>>2]=g;v[K+504>>2]=i;v[K+508>>2]=l;v[K+496>>2]=b;b=K+768|0;Jb(b,1024,139900,K+496|0);i=b;b=v[T+84>>2];l=jf(a,K+1836|0,i,j,v[K+1868>>2],1,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);if((l|0)!=1){i=10841;break db}l=mc(a,v[K+1836>>2]);if((l|0)!=1){i=10844;break db}l=ec(a,K+1836|0);if((l|0)==1){break cb}i=10845}Eb(154649,i);v[K+480>>2]=l;Fb(276579,K+480|0);break za}Hb(v[v[a>>2]+8>>2],K+1868|0,154615,10846);v[E>>2]=v[E>>2]+1}i=h}g=g+1|0;if((F|0)!=(g|0)){continue}break}if(!i){break _a}i=ub-16|0;ub=i;h=1;j=v[T+16>>2];b=v[j+28>>2];eb:{if((b|0)<=0){break eb}while(1){fb:{g=b-1|0;h=v[j+4>>2]+(g<<3)|0;if(v[h>>2]|v[h+4>>2]){break fb}h=lk(a,T,g);if((h|0)==1){break fb}Eb(154649,6546);v[i>>2]=h;Fb(276579,i);break eb}h=1;l=b>>>0>1;b=g;if(l){continue}break}}ub=i+16|0;l=h;if((h|0)==1){break _a}Eb(154649,10854);v[K+464>>2]=h;Fb(276579,K+464|0);break za}if(w[o+80|0]&32){break Za}b=v[o+68>>2];g=v[o+60>>2];if(y[o+64>>2]>y[o+56>>2]&(b|0)>=(g|0)|(b|0)>(g|0)){continue}}break}Hb(v[v[a>>2]+8>>2],K+1848|0,154615,10860);Hb(v[v[a>>2]+8>>2],K+1872|0,154615,10861);Hb(v[v[a>>2]+8>>2],K+1880|0,154615,10862);l=1;b=v[o+68>>2];g=v[o+60>>2];if((b|0)<=(g|0)&y[o+64>>2]<=y[o+56>>2]|(b|0)<(g|0)){break za}}if(!(f&16)){break Oa}s=v[T+16>>2];b=v[s+28>>2];if(!(w[s+80|0]&64)&(b|0)>1e3|v[s+36>>2]>1e3){break Oa}tm(s);if(!(w[s+80|0]&64)&(b|0)>1e3){break Oa}b=fc(a);g=Ne(a);ca=Lc(a);r=v[v[T+12>>2]+328>>2];b=b-g|0;h=(b|0)>=1e4?1e4:b;v[K+1860>>2]=h;$=Ib(v[v[a>>2]+8>>2],b,4,154615,9877);v[K+768>>2]=$;if(!$){Eb(154649,9877);l=-1;v[K+16>>2]=-1;Fb(276579,K+16|0);break La}fa=Ib(v[v[a>>2]+8>>2],b,4,154615,9878);v[K+772>>2]=fa;if(!fa){Eb(154649,9878);l=-1;v[K+32>>2]=-1;Fb(276579,K+32|0);break La}g=v[r+36>>2];if((g|0)<(b|0)){v[r+36>>2]=b;i=gc(v[v[a>>2]+4>>2],v[r>>2],g,v[r+36>>2],4,154615,9894);v[r>>2]=i;if(!i){Eb(154649,9894);l=-1;v[K+48>>2]=-1;Fb(276579,K+48|0);break La}dc(i+(g<<2)|0,v[r+36>>2]-g<<2)}g=v[r+40>>2];if((g|0)<(b|0)){v[r+40>>2]=b;i=gc(v[v[a>>2]+4>>2],v[r+4>>2],g,v[r+40>>2],4,154615,9902);v[r+4>>2]=i;if(!i){Eb(154649,9902);l=-1;v[K+64>>2]=-1;Fb(276579,K- -64|0);break La}dc(i+(g<<2)|0,v[r+40>>2]-g<<2)}g=v[r+44>>2];if((g|0)<(b|0)){v[r+44>>2]=b;i=gc(v[v[a>>2]+4>>2],v[r+8>>2],g,v[r+44>>2],8,154615,9910);v[r+8>>2]=i;if(!i){Eb(154649,9910);l=-1;v[K+80>>2]=-1;Fb(276579,K+80|0);break La}dc(i+(g<<3)|0,v[r+44>>2]-g<<3)}g=v[r+48>>2];if((g|0)<(b|0)){v[r+48>>2]=b;i=gc(v[v[a>>2]+4>>2],v[r+12>>2],g,v[r+48>>2],8,154615,9918);v[r+12>>2]=i;if(!i){Eb(154649,9918);l=-1;v[K+96>>2]=-1;Fb(276579,K+96|0);break La}dc(i+(g<<3)|0,v[r+48>>2]-g<<3)}ga=v[r>>2];v[K+1880>>2]=ga;ma=v[r+4>>2];v[K+1884>>2]=ma;ia=v[r+8>>2];v[K+1872>>2]=ia;ja=v[r+12>>2];v[K+1876>>2]=ja;g=Ib(v[v[a>>2]+8>>2],h,4,154615,9938);v[K+1868>>2]=g;if(!g){Eb(154649,9938);l=-1;v[K+112>>2]=-1;Fb(276579,K+112|0);break La}h=Ib(v[v[a>>2]+8>>2],h,4,154615,9939);v[K+1864>>2]=h;if(!h){Eb(154649,9939);l=-1;v[K+128>>2]=-1;Fb(276579,K+128|0);break La}v[g>>2]=-1;v[h>>2]=-1;v[K+1836>>2]=0;v[K+1840>>2]=0;v[K+1856>>2]=1;g=v[r+52>>2];if((g|0)<(b|0)){v[r+52>>2]=b;h=gc(v[v[a>>2]+4>>2],v[r+16>>2],g,v[r+52>>2],4,154615,9959);v[r+16>>2]=h;if(!h){Eb(154649,9959);l=-1;v[K+144>>2]=-1;Fb(276579,K+144|0);break La}dc(h+(g<<2)|0,v[r+52>>2]-g<<2)}g=v[r+56>>2];if((g|0)<(b|0)){v[r+56>>2]=b;h=gc(v[v[a>>2]+4>>2],v[r+20>>2],g,v[r+56>>2],4,154615,9967);v[r+20>>2]=h;if(!h){Eb(154649,9967);l=-1;v[K+160>>2]=-1;Fb(276579,K+160|0);break La}dc(h+(g<<2)|0,v[r+56>>2]-g<<2)}v[K+1848>>2]=v[r+16>>2];v[K+1852>>2]=v[r+20>>2];X=Ib(v[v[a>>2]+8>>2],v[s+28>>2],4,154615,9983);v[K+1804>>2]=X;if(!X){Eb(154649,9983);l=-1;v[K+176>>2]=-1;Fb(276579,K+176|0);break La}M=b<<1;Y=Ib(v[v[a>>2]+8>>2],M,4,154615,9984);v[K+1812>>2]=Y;if(!Y){Eb(154649,9984);l=-1;v[K+192>>2]=-1;Fb(276579,K+192|0);break La}_=Ib(v[v[a>>2]+8>>2],v[s+28>>2],4,154615,9985);v[K+1808>>2]=_;if(!_){Eb(154649,9985);l=-1;v[K+208>>2]=-1;Fb(276579,K+208|0);break La}Z=Ib(v[v[a>>2]+8>>2],M,4,154615,9986);v[K+1816>>2]=Z;if(!Z){Eb(154649,9986);l=-1;v[K+224>>2]=-1;Fb(276579,K+224|0);break La}B=Ib(v[v[a>>2]+8>>2],M,4,154615,9987);v[K+1824>>2]=B;if(!B){Eb(154649,9987);l=-1;v[K+240>>2]=-1;Fb(276579,K+240|0);break La}b=Ib(v[v[a>>2]+8>>2],M,4,154615,9988);v[K+1820>>2]=b;if(!b){Eb(154649,9988);l=-1;v[K+256>>2]=-1;Fb(276579,K+256|0);break La}v[K+1844>>2]=0;i=0;m=0;gb:{if(v[s+28>>2]<=0){break gb}while(1){g=i<<2;v[K+1800>>2]=v[g+v[s>>2]>>2];h=v[s+4>>2]+(i<<3)|0;b=v[h>>2];N=v[h+4>>2];v[K+1796>>2]=1;l=gj(K+1800|0,K+1796|0);if((l|0)!=1){b=10010;break Ma}j=!v[K+1796>>2];l=v[K+1800>>2];F=v[l+292>>2];h=v[(K+1872|0)+(j<<2)>>2]+(F<<3)|0;L=v[h>>2];J=N+v[h+4>>2]|0;L=b+L|0;J=L>>>0<b>>>0?J+1|0:J;v[h>>2]=L;v[h+4>>2]=J;v[g+X>>2]=j;v[g+_>>2]=F;h=v[l+292>>2];F=h<<2;g=!v[K+1796>>2];j=g<<2;if(!v[F+v[j+(K+1880|0)>>2]>>2]){l=m<<2;v[l+Y>>2]=g;v[l+Z>>2]=h;m=m+1|0}l=zZ(a,K+768|0,K+1836|0,K+1880|0,K+1872|0,K+1868|0,K+1864|0,K+1860|0,K+1856|0,h,g,i,b,N,K+1844|0);if((l|0)!=1){b=10042;break Ma}v[F+v[j+(K+1848|0)>>2]>>2]=1;l=v[K+1820>>2];v[l>>2]=g;v[B>>2]=h;g=v[v[K+1800>>2]+252>>2];hb:{ib:{if(!g){j=1;F=v[K+1844>>2];break ib}j=1;F=v[K+1844>>2];g=g+(v[K+1796>>2]<<2)|0;O=v[g+8>>2];if(F|(O|0)<=0){break ib}J=v[g>>2];W=0;jb:{while(1){h=v[J+(W<<2)>>2];g=v[h+8>>2];if(!((g|0)>50|(g|0)<=0)){P=v[h+4>>2];Q=v[h>>2];while(1){h=g;g=g-1|0;L=g<<2;F=v[L+Q>>2];kb:{if((F|0)==v[K+1800>>2]){break kb}F=v[F+292>>2];if((F|0)==-1){break kb}R=F<<2;L=v[L+P>>2];S=L<<2;U=R+v[S+(K+1848|0)>>2]|0;if(v[U>>2]){break kb}if(!v[R+v[S+(K+1880|0)>>2]>>2]){l=m<<2;v[l+Y>>2]=L;v[l+Z>>2]=F;m=m+1|0}l=zZ(a,K+768|0,K+1836|0,K+1880|0,K+1872|0,K+1868|0,K+1864|0,K+1860|0,K+1856|0,F,L,i,b,N,K+1844|0);if((l|0)!=1){b=10095;break Ma}v[U>>2]=1;l=v[K+1820>>2];S=j<<2;v[l+S>>2]=L;v[B+S>>2]=F;j=j+1|0;F=v[K+1844>>2];if(F){break jb}}if(h>>>0>1){continue}break}}W=W+1|0;if((O|0)!=(W|0)){continue}break}F=0}if((j|0)<=0){break hb}}while(1){b=j-1|0;g=b<<2;v[v[(K+1848|0)+(v[g+l>>2]<<2)>>2]+(v[g+B>>2]<<2)>>2]=0;g=j>>>0>1;j=b;if(g){continue}break}}i=i+1|0;if((i|0)>=v[s+28>>2]){break gb}if(!F){continue}break}}Hb(v[v[a>>2]+8>>2],K+1820|0,154615,10110);l=Hv(a,r,s,1,0);if((l|0)!=1){Eb(154649,10114);v[K+384>>2]=l;Fb(276579,K+384|0);break La}l=v[s+28>>2];b=v[r+60>>2];if((l|0)>(b|0)){v[r+60>>2]=l;g=gc(v[v[a>>2]+4>>2],v[r+24>>2],b,v[r+60>>2],4,154615,10127);v[r+24>>2]=g;if(!g){Eb(154649,10127);l=-1;v[K+272>>2]=-1;Fb(276579,K+272|0);break La}dc(g+(b<<2)|0,v[r+60>>2]-b<<2);l=v[s+28>>2]}j=v[r+24>>2];if((l|0)<=0){L=0;Q=0;break Pa}h=v[s+12>>2];g=0;L=0;Q=0;b=0;while(1){F=v[h+(g<<2)>>2];N=j+(F<<2)|0;if(!v[N>>2]){l=v[s+4>>2]+(g<<3)|0;O=v[l>>2];l=v[l+4>>2];v[N>>2]=1;v[B+(b<<2)>>2]=F;J=l+Q|0;l=L;L=L+O|0;Q=l>>>0>L>>>0?J+1|0:J;l=v[s+28>>2];b=b+1|0}g=g+1|0;if((l|0)>(g|0)){continue}break}break Qa}Eb(154649,10628);l=-1;v[K+624>>2]=-1;Fb(276579,K+624|0);break za}Eb(154649,10682);l=-1;v[K+448>>2]=-1;Fb(276579,K+448|0);break za}if((b|0)<=0){break Pa}Wb(j,0,b<<2);l=v[s+28>>2]}b=v[r+64>>2];if((b|0)<(l|0)){v[r+64>>2]=l;g=gc(v[v[a>>2]+4>>2],v[r+28>>2],b,v[r+64>>2],4,154615,10171);v[r+28>>2]=g;if(!g){Eb(154649,10171);l=-1;v[K+288>>2]=-1;Fb(276579,K+288|0);break La}dc(g+(b<<2)|0,v[r+64>>2]-b<<2)}U=v[r+28>>2];W=Ib(v[v[a>>2]+8>>2],M,4,154615,10187);v[K+1832>>2]=W;if(!W){Eb(154649,10187);l=-1;v[K+304>>2]=-1;Fb(276579,K+304|0);break La}aa=Ib(v[v[a>>2]+8>>2],M,8,154615,10188);v[K+1828>>2]=aa;if(!aa){break Na}N=0;P=0;b=v[s+60>>2];S=b;O=v[s+56>>2];lb:{if(!O&(b|0)<=0|(b|0)<0){R=0;break lb}ea=v[K+1836>>2];mb:{if((ea|0)<=0){R=0;break mb}sa=B-8|0;va=B-4|0;R=0;F=0;while(1){S=v[s+60>>2];b=S;O=v[s+56>>2];if((b|0)<=(P|0)&O>>>0<=N>>>0|(b|0)<(P|0)){break mb}h=v[$+(F<<2)>>2];qa=h<<2;pa=qa+ga|0;g=v[pa>>2];nb:{if(!g){break nb}J=P+Q|0;b=L+N|0;J=b>>>0<L>>>0?J+1|0:J;h=ia+(h<<3)|0;l=v[h>>2];r=b-l|0;b=J-(v[h+4>>2]+(b>>>0<l>>>0)|0)|0;if((S|0)<=(b|0)&r>>>0>=O>>>0|(b|0)>(S|0)){break nb}h=v[K+1864>>2];da=v[K+1868>>2];while(1){b=g<<2;v[U+(v[b+da>>2]<<2)>>2]=1;g=v[b+h>>2];if(g){continue}break}l=v[s+28>>2];ob:{if((l|0)<=0){b=0;r=N;M=P;break ob}Ia=v[s+12>>2];g=0;r=N;M=P;b=0;while(1){J=g<<2;if(!v[J+U>>2]){J=v[J+Ia>>2];za=j+(J<<2)|0;if(!v[za>>2]){ta=v[s+4>>2]+(g<<3)|0;l=v[ta>>2];ta=v[ta+4>>2];v[za>>2]=1;v[B+(b<<2)>>2]=J;J=M+ta|0;r=l+r|0;M=r>>>0<l>>>0?J+1|0:J;b=b+1|0}if((M|0)>=(S|0)&r>>>0>=O>>>0|(M|0)>(S|0)){break ob}l=v[s+28>>2]}g=g+1|0;if((l|0)>(g|0)){continue}break}}pb:{qb:{if(r>>>0<O>>>0&(M|0)<=(S|0)|(M|0)<(S|0)){g=v[ca+qa>>2];v[K+1800>>2]=g;l=Fd(a,g,K+1800|0);if((l|0)!=1){break qb}g=v[s+56>>2];O=v[s+60>>2];v[W+(R<<2)>>2]=v[K+1800>>2];J=aa+(R<<3)|0;l=g-r|0;v[J>>2]=l;g=O-((g>>>0<r>>>0)+M|0)|0;v[J+4>>2]=g;R=R+1|0;J=g+P|0;g=N;N=l+N|0;P=g>>>0>N>>>0?J+1|0:J}g=v[pa>>2];if(!g){break pb}while(1){g=g<<2;v[U+(v[g+da>>2]<<2)>>2]=0;g=v[g+h>>2];if(g){continue}break}break pb}Eb(154649,10250);v[K+368>>2]=l;Fb(276579,K+368|0);break La}if((b|0)<=0){break nb}l=0;g=b;h=b&3;if(h){while(1){g=g-1|0;v[j+(v[B+(g<<2)>>2]<<2)>>2]=0;l=l+1|0;if((h|0)!=(l|0)){continue}break}}if(b>>>0<4){break nb}while(1){b=g<<2;v[j+(v[b+va>>2]<<2)>>2]=0;v[j+(v[b+sa>>2]<<2)>>2]=0;b=g-3|0;v[j+(v[B+(b<<2)>>2]<<2)>>2]=0;g=g-4|0;v[j+(v[B+(g<<2)>>2]<<2)>>2]=0;if(b>>>0>1){continue}break}}F=F+1|0;if((ea|0)!=(F|0)){continue}break}O=v[s+56>>2];S=v[s+60>>2]}if((P|0)>=(S|0)&N>>>0>=O>>>0|(P|0)>(S|0)){break lb}da=v[K+1840>>2];if((da|0)<=0){break lb}ga=B-8|0;ia=B-4|0;l=0;while(1){O=v[s+60>>2];b=O;g=v[s+56>>2];if((b|0)<=(P|0)&g>>>0<=N>>>0|(b|0)<(P|0)){break lb}r=v[fa+(l<<2)>>2];ea=r<<2;sa=ea+ma|0;h=v[sa>>2];rb:{if(!h){break rb}J=P+Q|0;b=L+N|0;J=b>>>0<L>>>0?J+1|0:J;r=(r<<3)+ja|0;F=v[r>>2];M=b-F|0;b=J-(v[r+4>>2]+(b>>>0<F>>>0)|0)|0;if((O|0)<=(b|0)&g>>>0<=M>>>0|(b|0)>(O|0)){break rb}S=v[K+1864>>2];$=v[K+1868>>2];while(1){b=h<<2;v[U+(v[b+$>>2]<<2)>>2]=1;h=v[b+S>>2];if(h){continue}break}F=v[s+28>>2];sb:{if((F|0)<=0){b=0;r=N;M=P;break sb}va=v[s+12>>2];h=0;r=N;M=P;b=0;while(1){J=h<<2;if(!v[J+U>>2]){J=v[J+va>>2];qa=j+(J<<2)|0;if(!v[qa>>2]){pa=v[s+4>>2]+(h<<3)|0;F=v[pa>>2];pa=v[pa+4>>2];v[qa>>2]=1;v[B+(b<<2)>>2]=J;J=M+pa|0;r=r+F|0;M=r>>>0<F>>>0?J+1|0:J;b=b+1|0}if(g>>>0<=r>>>0&(M|0)>=(O|0)|(M|0)>(O|0)){break sb}F=v[s+28>>2]}h=h+1|0;if((F|0)>(h|0)){continue}break}}if((M|0)<=(O|0)&g>>>0>r>>>0|(M|0)<(O|0)){v[W+(R<<2)>>2]=v[ca+ea>>2];F=aa+(R<<3)|0;h=g-r|0;v[F>>2]=h;g=O-((g>>>0<r>>>0)+M|0)|0;v[F+4>>2]=g;R=R+1|0;J=g+P|0;g=N;N=h+N|0;P=g>>>0>N>>>0?J+1|0:J}h=v[sa>>2];if(h){while(1){g=h<<2;v[U+(v[g+$>>2]<<2)>>2]=0;h=v[g+S>>2];if(h){continue}break}}if((b|0)<=0){break rb}g=0;h=b;r=b&3;if(r){while(1){h=h-1|0;v[j+(v[B+(h<<2)>>2]<<2)>>2]=0;g=g+1|0;if((r|0)!=(g|0)){continue}break}}if(b>>>0<4){break rb}while(1){b=h<<2;v[j+(v[b+ia>>2]<<2)>>2]=0;v[j+(v[b+ga>>2]<<2)>>2]=0;b=h-3|0;v[j+(v[B+(b<<2)>>2]<<2)>>2]=0;h=h-4|0;v[j+(v[B+(h<<2)>>2]<<2)>>2]=0;if(b>>>0>1){continue}break}}l=l+1|0;if((da|0)!=(l|0)){continue}break}}tb:{if((i|0)<=0){break tb}b=i;if(b&1){b=b-1|0;g=b<<2;g=v[(K+1872|0)+(v[g+X>>2]<<2)>>2]+(v[g+_>>2]<<3)|0;v[g>>2]=0;v[g+4>>2]=0}if((i|0)==1){break tb}while(1){i=K+1872|0;g=b-1|0;h=g<<2;h=v[i+(v[h+X>>2]<<2)>>2]+(v[h+_>>2]<<3)|0;v[h>>2]=0;v[h+4>>2]=0;b=b-2|0;h=b<<2;h=v[i+(v[h+X>>2]<<2)>>2]+(v[h+_>>2]<<3)|0;v[h>>2]=0;v[h+4>>2]=0;if(g>>>0>1){continue}break}}ub:{if((m|0)<=0){break ub}b=m;if(b&1){b=b-1|0;g=b<<2;h=v[g+Y>>2]<<2;g=v[g+Z>>2];i=v[h+(K+1872|0)>>2]+(g<<3)|0;v[i>>2]=0;v[i+4>>2]=0;v[v[h+(K+1880|0)>>2]+(g<<2)>>2]=0}if((m|0)==1){break ub}while(1){g=b-1|0;h=g<<2;i=v[h+Y>>2]<<2;j=K+1872|0;h=v[h+Z>>2];l=v[i+j>>2]+(h<<3)|0;v[l>>2]=0;v[l+4>>2]=0;v[v[i+(K+1880|0)>>2]+(h<<2)>>2]=0;b=b-2|0;h=b<<2;i=v[h+Y>>2]<<2;h=v[h+Z>>2];j=v[i+j>>2]+(h<<3)|0;v[j>>2]=0;v[j+4>>2]=0;v[v[i+(K+1880|0)>>2]+(h<<2)>>2]=0;if(g>>>0>1){continue}break}}b=0;vb:{if((R|0)>0){wb:{while(1){g=aa+(b<<3)|0;l=Fy(a,T,v[W+(b<<2)>>2],v[g>>2],v[g+4>>2]);if((l|0)==1){b=b+1|0;if((R|0)!=(b|0)){continue}break wb}break}Eb(154649,10289);v[K+352>>2]=l;Fb(276579,K+352|0);break La}v[G>>2]=v[G>>2]+R;l=it(a,T,ba);if((l|0)==1){break vb}Eb(154649,10296);v[K+336>>2]=l;Fb(276579,K+336|0);break La}v[G>>2]=v[G>>2]+R}Hb(v[v[a>>2]+8>>2],K+1828|0,154615,10300);Hb(v[v[a>>2]+8>>2],K+1832|0,154615,10301);Hb(v[v[a>>2]+8>>2],K+1824|0,154615,10302);Hb(v[v[a>>2]+8>>2],K+1816|0,154615,10303);Hb(v[v[a>>2]+8>>2],K+1808|0,154615,10304);Hb(v[v[a>>2]+8>>2],K+1812|0,154615,10305);Hb(v[v[a>>2]+8>>2],K+1804|0,154615,10306);Hb(v[v[a>>2]+8>>2],K+1864|0,154615,10307);Hb(v[v[a>>2]+8>>2],K+1868|0,154615,10308);Hb(v[v[a>>2]+8>>2],K+772|0,154615,10309);Hb(v[v[a>>2]+8>>2],K+768|0,154615,10310)}l=1;if(!ha){break za}b=v[o+68>>2];g=v[o+60>>2];if((b|0)<=(g|0)&y[o+64>>2]<=y[o+56>>2]|(b|0)<(g|0)){break za}tm(o);i=v[o+28>>2];if((i|0)<2){break za}r=v[o+4>>2];b=(r+(i<<3)|0)-8|0;j=v[b>>2];F=v[b+4>>2];b=0;while(1){g=v[o+56>>2];m=v[o+60>>2];B=r+(b<<3)|0;s=B;h=v[s>>2];s=v[s+4>>2];J=F+s|0;M=h+j|0;J=M>>>0<j>>>0?J+1|0:J;if(g>>>0<M>>>0&(m|0)<=(J|0)|(m|0)<(J|0)){if(g>>>0>h>>>0&(m|0)>=(s|0)|(m|0)>(s|0)){v[B>>2]=g;v[B+4>>2]=m;M=b<<2;V=A[v[M+v[o>>2]>>2]+152>>3];i=g-h|0;N=v[o+64>>2];B=i+N|0;h=m-((g>>>0<h>>>0)+s|0)|0;J=h+v[o+68>>2]|0;v[o+64>>2]=B;v[o+68>>2]=B>>>0<N>>>0?J+1|0:J;if(V>.5){J=h+v[o+76>>2]|0;h=i+v[o+72>>2]|0;J=h>>>0<i>>>0?J+1|0:J;v[o+72>>2]=h;v[o+76>>2]=J}h=v[o+8>>2];if(h){h=v[h+M>>2];v[h+8>>2]=g;v[h+12>>2]=m}u[o+80>>1]=x[o+80>>1]&64960|32;v[G>>2]=v[G>>2]+1;i=v[o+28>>2]}b=b+1|0;if((b|0)<(i-1|0)){continue}}break}if((i|0)<2){break za}b=v[o+56>>2];m=i-1|0;j=r+(m<<3)|0;h=v[j>>2];r=(r+(i<<3)|0)-16|0;s=v[r>>2];i=h+s|0;j=v[j+4>>2];J=j+v[r+4>>2]|0;g=v[o+60>>2];J=i>>>0<s>>>0?J+1|0:J;if((g|0)>=(J|0)&b>>>0>=i>>>0|(g|0)>(J|0)|((g|0)<=(j|0)&b>>>0<=h>>>0|(g|0)<(j|0))){break za}Xm(o,m,b,g);u[o+80>>1]=x[o+80>>1]|32;v[G>>2]=v[G>>2]+1;break za}Eb(154649,10188);l=-1;v[K+320>>2]=-1;Fb(276579,K+320|0);break La}Eb(154649,b);v[K+400>>2]=l;Fb(276579,K+400|0)}Eb(154649,10873);v[K>>2]=l;Fb(276579,K)}ub=K+1888|0;b=l;if((b|0)!=1){Eb(154649,12690);v[k+96>>2]=b;Fb(276579,k+96|0);break a}if(v[k+256>>2]){break c}b=v[T+84>>2];if(!(b&4194304)&(b&8404992)!=16384){break v}xb:{if(!v[oa+128>>2]){break xb}g=!ua;b=v[a+4>>2];if(v[b+1580>>2]){b=0}else{b=v[b+1216>>2]!=0}if(g|!b){break xb}i=0;b=ub-128|0;ub=b;g=1;yb:{if(!(w[T+84|0]&8)){break yb}j=v[T+16>>2];l=v[j>>2];h=v[j+28>>2];m=Ib(v[v[a>>2]+8>>2],h,8,154615,6778);v[b+124>>2]=m;if(!m){Eb(154649,6778);g=-1;v[b>>2]=-1;Fb(276579,b);break yb}o=Ib(v[v[a>>2]+8>>2],h,4,154615,6779);v[b+112>>2]=o;if(!o){Eb(154649,6779);g=-1;v[b+16>>2]=-1;Fb(276579,b+16|0);break yb}r=Ib(v[v[a>>2]+8>>2],h,4,154615,6780);v[b+120>>2]=r;if(!r){Eb(154649,6780);g=-1;v[b+32>>2]=-1;Fb(276579,b+32|0);break yb}s=Ib(v[v[a>>2]+8>>2],h,4,154615,6781);v[b+116>>2]=s;zb:{if(s){Ab:{if((h|0)>0){while(1){B=i<<2;g=v[B+l>>2];v[b+104>>2]=g;if((od(g,0)|0)>0){break Ab}if((nd(v[b+104>>2],0)|0)>1){break Ab}v[b+100>>2]=0;g=gj(b+104|0,b+100|0);if((g|0)!=1){Eb(154649,6809);v[b+80>>2]=g;Fb(276579,b+80|0);break yb}V=A[v[b+104>>2]>>3];A[m+(i<<3)>>3]=v[b+100>>2]?V:-V;v[o+B>>2]=i;i=i+1|0;if((h|0)!=(i|0)){continue}break}}h=6831;g=J$(a,v[j+28>>2],v[j+4>>2],m,v[j+56>>2],v[j+60>>2],o,r,s,b+92|0,b+88|0,b+104|0,b+84|0);if((g|0)!=1){break zb}if(!v[b+84>>2]){break Ab}h=0;i=v[b+92>>2];if((i|0)>0){while(1){g=gf(a,v[l+(v[r+(h<<2)>>2]<<2)>>2],1,1,b+100|0,b+96|0);if((g|0)!=1){h=6845;break zb}v[z>>2]=v[z>>2]+1;h=h+1|0;if((i|0)!=(h|0)){continue}break}}h=0;i=v[b+88>>2];if((i|0)>0){while(1){g=df(a,v[l+(v[s+(h<<2)>>2]<<2)>>2],0,1,b+100|0,b+96|0);if((g|0)!=1){h=6858;break zb}v[z>>2]=v[z>>2]+1;h=h+1|0;if((i|0)!=(h|0)){continue}break}}h=6864;g=pc(a,T);if((g|0)!=1){break zb}v[C>>2]=v[C>>2]+1;v[k+252>>2]=1}Hb(v[v[a>>2]+8>>2],b+116|0,154615,6870);Hb(v[v[a>>2]+8>>2],b+120|0,154615,6871);Hb(v[v[a>>2]+8>>2],b+112|0,154615,6872);Hb(v[v[a>>2]+8>>2],b+124|0,154615,6873);g=1;break yb}Eb(154649,6781);g=-1;v[b+48>>2]=-1;Fb(276579,b+48|0);break yb}Eb(154649,h);v[b+64>>2]=g;Fb(276579,b- -64|0)}ub=b+128|0;b=g;if((b|0)!=1){Eb(154649,12701);v[k+80>>2]=b;Fb(276579,k+80|0);break a}if(v[k+252>>2]){break e}}ra=0;l=ub-16|0;ub=l;g=1;i=v[T+16>>2];j=v[i+28>>2];Bb:{if(!j|(Bi(a)|0)!=(j|0)|!(v[T+84>>2]&3)){break Bb}Cb:{if((j|0)<=0){V=1;break Cb}ka=A[v[a+4>>2]+1280>>3];V=ka;m=v[i>>2];b=v[m>>2];h=v[b+376>>2]&1792;if((h|0)==1536){b=v[b+236>>2]}na=V;V=A[b>>3];b=na>=D(V);if(b){break Bb}g=v[i+4>>2];na=+y[g>>2]+ +v[g+4>>2]*4294967296;g=(h|0)==1536;ra=g?na:0;V=na/(g?-V:V);h=1;if(b|(j|0)==1){break Cb}while(1){g=1;b=v[m+(h<<2)>>2];o=(v[b+376>>2]&1792)!=1536;if(!o){b=v[b+236>>2]}wa=A[b>>3];if(ka>=D(wa)){break Bb}b=v[i+4>>2]+(h<<3)|0;na=+y[b>>2]+ +v[b+4>>2]*4294967296;Db:{if(!o){if(!(ka>=D(-wa*V-na))){break Bb}ra=ra+na;break Db}if(!(ka>=D(wa*V-na))){break Bb}}h=h+1|0;if((j|0)>(h|0)){continue}break}}ka=A[v[a+4>>2]+1280>>3];Eb:{if(!(!(ka<V)|!v[oa+136>>2])){h=6984;b=lp(a,T,0);if((b|0)!=1){break Eb}h=6985;b=os(a,T,0);if((b|0)!=1){break Eb}ka=A[v[a+4>>2]+1296>>3]*100;V=(ka<=1e-4?ka:1e-4)+(+y[i+56>>2]+ +v[i+60>>2]*4294967296-ra)/V;if(V<A[v[a+68>>2]+40>>3]){g=1;h=7004;b=ON(a,V);if((b|0)!=1){break Eb}break Bb}g=1;h=7011;b=Zt(a,T,0);if((b|0)!=1){break Eb}h=7012;b=cA(a,T,0);if((b|0)!=1){break Eb}break Bb}g=1;if(!(-ka>V)|!v[oa+140>>2]){break Bb}h=7020;b=lp(a,T,0);if((b|0)!=1){break Eb}h=7021;b=os(a,T,0);if((b|0)!=1){break Eb}h=7028;b=wF(a,(+y[i+56>>2]+ +v[i+60>>2]*4294967296-ra)/V);if((b|0)==1){break Bb}}Eb(154649,h);v[l>>2]=b;Fb(276579,l);g=b}ub=l+16|0;b=g;if((b|0)==1){break v}Eb(154649,12707);v[k+64>>2]=b;Fb(276579,k- -64|0);break a}if((p|0)!=2147483647){break e}p=(x[la+80>>1]&31)==16?2147483647:n}n=n+1|0;if((n|0)!=(d|0)){continue}}break}if(v[k+256>>2]){break c}}if(!(f&8)|!v[oa+124>>2]){break c}h=11522;b=Bf(k+268|0,v[v[a>>2]+4>>2],(d|0)<=500?500:d,356,357,358,a);if((b|0)!=1){break b}Fb:{if((d|0)<=0){break Fb}g=d;while(1){i=g;g=g-1|0;h=v[(g<<2)+c>>2];b=v[h+84>>2];Gb:{Hb:{if(!(b&4194304)){if((b&8405248)==16384){break Hb}break Gb}if(b&256){break Gb}}Ib:{Jb:{Kb:{b=v[h+16>>2];if(!v[b+28>>2]){if(v[b+60>>2]<0){break Kb}b=pc(a,h);if((b|0)==1){break Ib}h=11547;break b}e=sc(v[k+268>>2],h);if(e){j=v[e+16>>2];l=v[j+56>>2];m=v[b+60>>2];j=v[j+60>>2];if(l>>>0<=y[b+56>>2]&(m|0)>=(j|0)|(j|0)<(m|0)){j=h;h=e;break Jb}b=si(v[k+268>>2],e);if((b|0)!=1){h=11587;break b}j=e;b=ee(v[k+268>>2],h);if((b|0)==1){break Jb}h=11588;break b}b=ee(v[k+268>>2],h);if((b|0)==1){break Gb}h=11608;break b}v[k+256>>2]=1;break Fb}b=bf(a,h,j);if((b|0)!=1){h=11597;break b}b=pc(a,j);if((b|0)==1){break Ib}h=11600;break b}v[C>>2]=v[C>>2]+1}if(i>>>0>1){continue}break}}cf(k+268|0)}n=1;e=v[C>>2];if(!((Da|0)!=(e|0)|v[H>>2]!=(Aa|0)|v[G>>2]!=(Ba|0))){n=v[E>>2]!=(Ca|0)}Lb:{Mb:{b=v[k+256>>2];if(!(b|(d|0)<=(p|0))){if(!(f&16)|!v[oa+120>>2]){break Mb}l=d;N=l>>31;i=v[H>>2];d=v[G>>2];S=p>>31;P=S;O=p;r=0;M=0;while(1){Nb:{if(rc(v[a+4>>2],v[a+24>>2],0)){break Nb}Ob:{Pb:{E=v[(O<<2)+c>>2];b=v[E+84>>2];Qb:{if(!(b&4194304)){if((b&8405248)!=16384){break Pb}break Qb}if(b&256){break Pb}}m=v[E+16>>2];J=x[m+80>>1];tm(m);Rb:{Sb:{if(!(v[m+56>>2]|v[m+60>>2])){break Sb}s=(x[m+80>>1]&31)==16?p:0;b=s>>31;if((b|0)>=(S|0)&s>>>0>=O>>>0|(b|0)>(S|0)){break Sb}while(1){F=v[(s<<2)+c>>2];b=v[F+84>>2];Tb:{Ub:{if(!(b&4194304)){if((b&8405248)==16384){break Ub}break Tb}if(b&256){break Tb}}o=v[F+16>>2];if(w[o+80|0]&16?w[m+80|0]&16:0){break Tb}tm(o);f=v[o+60>>2];B=f;b=v[o+56>>2];if(!(B|b)){break Tb}h=v[m+28>>2];j=v[o+28>>2];g=(h|0)<=(j|0);f=(h|0)>=(j|0);L=(h|0)<(j|0)?h:j;if((L|0)>0){V=(+y[m+56>>2]+ +v[m+60>>2]*4294967296)/(+(b>>>0)+ +(B|0)*4294967296);h=h-1|0;b=j-1|0;B=L-1|0;while(1){Vb:{if((b|0)>(h|0)){if(!g){break Tb}g=1;f=0;break Vb}if((b|0)>=(h|0)){break Vb}if(!f){break Tb}g=0;f=1}j=f;Wb:{if(v[v[m>>2]+(h<<2)>>2]==v[v[o>>2]+(b<<2)>>2]){Xb:{Yb:{if(!j){break Yb}f=v[m+4>>2]+(h<<3)|0;Q=v[o+4>>2]+(b<<3)|0;if(!(-A[v[a+4>>2]+1280>>3]>(+y[f>>2]+ +v[f+4>>2]*4294967296)/V-(+y[Q>>2]+ +v[Q+4>>2]*4294967296))){break Yb}if(!g){break Tb}g=1;f=0;break Xb}if(!g){g=0;f=j;break Xb}f=v[m+4>>2]+(h<<3)|0;L=v[o+4>>2]+(b<<3)|0;L=A[v[a+4>>2]+1280>>3]<(+y[f>>2]+ +v[f+4>>2]*4294967296)/V-(+y[L>>2]+ +v[L+4>>2]*4294967296);f=L?1:j;g=!L;if(j){break Xb}if(L){break Tb}}B=B-1|0;b=b-1|0;h=h-1|0;break Wb}if(j?g:0){break Tb}Zb:{if(g){b=b-1|0;g=1;break Zb}h=h-1|0;g=0}}if((B|0)>=0){continue}break}}_b:{if(f){b=bf(a,E,F);if((b|0)!=1){h=11798;break Rb}b=pc(a,F);if((b|0)==1){break _b}h=11800;break Rb}if(!g){break Tb}b=bf(a,F,E);if((b|0)!=1){h=11809;break Rb}b=pc(a,E);if((b|0)!=1){h=11811;break Rb}v[C>>2]=v[C>>2]+1;break Sb}v[C>>2]=v[C>>2]+1}s=s+1|0;if((O|0)!=(s|0)){continue}break}}b=J&16;f=b?p:0;g=O-f|0;J=M+(S-((f>>>0>O>>>0)+(b?P:0)|0)|0)|0;b=r;r=g+r|0;J=b>>>0>r>>>0?J+1|0:J;M=J;if(r>>>0<200001&(J|0)<=0|(J|0)<0){break Pb}f=v[H>>2];V=+(r>>>0)+ +(J|0)*4294967296;r=0;M=0;g=v[C>>2];$b:{if((g|0)!=(e|0)){h=v[G>>2];n=1;b=f;break $b}j=v[G>>2];if((f|0)==(i|0)){h=d;b=i;if((j|0)==(h|0)){break $b}}h=j;n=1;b=f}if((+(b-i|0)*.5+ +(g-e|0)+ +(h-d|0)/10)/V<1e-6){break Nb}break Ob}Eb(154649,h);v[k+16>>2]=b;Fb(276579,k+16|0);Eb(154649,12744);v[k>>2]=b;Fb(276579,k);break a}b=i;h=d;g=e}J=S;O=O+1|0;J=O?J:J+1|0;S=J;if((N|0)<=(J|0)&l>>>0<=O>>>0|(J|0)>(N|0)){break Nb}e=g;d=h;i=b;if(!v[k+256>>2]){continue}}break}b=v[k+256>>2]}if(!b){break Mb}v[I>>2]=7;break Lb}if(!(!(v[q>>2]>(ya|0)|n)&v[z>>2]<=(xa|0))){v[I>>2]=17;break Lb}v[I>>2]=3}b=1;break a}Eb(154649,h);v[k+48>>2]=b;Fb(276579,k+48|0);Eb(154649,12719);v[k+32>>2]=b;Fb(276579,k+32|0)}ub=k+272|0;return b|0}function Tda(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,x=0,y=0,z=0,C=0,E=0,F=0,G=0,H=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0;j=ub-784|0;ub=j;v[j+568>>2]=0;v[j+564>>2]=0;g=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+344>>2]:0;h=1;i=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;a:{if((i|0)>2e6|(fc(a)|0)!=(i|0)){break a}R=v[b+144>>2];if(!(v[b+184>>2]|v[R+88>>2])){v[f>>2]=2;break a}r=+(i|0)/(+(g|0)+1e-9);if(r<.01|r>100){break a}b:{c:{d:{e:{f:{u=v[R+4>>2];if((u|0)==-1){v[f>>2]=3;i=v[R+40>>2];v[R>>2]=0;v[R+4>>2]=0;v[R+92>>2]=0;h=ug(a,j+596|0,j+588|0);if((h|0)!=1){Eb(157734,4296);v[j+560>>2]=h;Fb(276579,j+560|0);break b}h=xl(a,j+592|0,j+584|0);if((h|0)!=1){Eb(157734,4297);v[j+544>>2]=h;Fb(276579,j+544|0);break b}Wb(j+600|0,0,132);sa=j+752|0;h=sa;v[h>>2]=0;v[h+4>>2]=0;ta=j+744|0;h=ta;v[h>>2]=0;v[h+4>>2]=0;v[j+736>>2]=0;v[j+740>>2]=0;v[j+760>>2]=i;g=870;g:{h:{i:{j:{h=ug(a,j+780|0,j+776|0);if((h|0)!=1){break j}g=874;i=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;k=vd(v[j+776>>2],1,157700,874);v[j+600>>2]=k;h=-1;if(!k){break j}g=875;k=vd(v[j+776>>2],8,157700,875);v[j+604>>2]=k;if(!k){break j}g=876;k=vd(v[j+776>>2],8,157700,876);v[j+608>>2]=k;if(!k){break j}g=877;u=vd(v[j+776>>2],4,157700,877);v[j+620>>2]=u;if(!u){break j}s=v[j+608>>2];H=v[j+600>>2];if(v[j+776>>2]>0){z=v[j+604>>2];ka=+(i|0)*.1;i=0;while(1){r=0;h=v[v[j+780>>2]+(i<<2)>>2];if(v[h+232>>2]>=0){r=A[h+80>>3]}l=i+H|0;t[l|0]=0;g=i<<3;F=g+z|0;v[F>>2]=0;v[F+4>>2]=0;n=g+s|0;v[n>>2]=0;v[n+4>>2]=0;k:{if(w[h+273|0]&16){break k}o=v[h+220>>2];if(!o){break k}M=+(o|0);if(M>ka){break k}L=v[h+188>>2];x=A[L>>3];P=x>=0?x:-x;da=A[h>>3];la=A[h+16>>3];ma=A[h+8>>3];l:{m:{n:{if((o|0)<=0){y=0;q=0;h=0;m=0;k=0;p=0;g=0;break n}C=v[h+180>>2];E=v[a+4>>2];qa=A[E+1280>>3];g=0;p=0;k=0;m=0;h=0;q=0;y=0;while(1){x=A[L+(g<<3)>>3];if(!(qa>=D((x>=0?x:-x)-P))){break n}G=x<0;J=x>0;o:{p:{switch((v[v[v[C+(g<<2)>>2]+164>>2]+376>>2]>>>6&3)-1|0){default:y=y+1|0;break o;case 0:q=q+1|0;break o;case 1:h=h+1|0;break o;case 2:break p}}m=m+1|0}p=p|G;k=k|J;g=g+1|0;if((o|0)!=(g|0)){continue}break}break m}if((g|0)!=(o|0)){break l}E=v[a+4>>2]}x=A[E+1272>>3];if(!(x<=-(ma-da))){t[l|0]=w[l|0]|1;x=A[v[a+4>>2]+1272>>3]}if(!(la-da>=x)){t[l|0]=w[l|0]|2}A[F>>3]=1/P;v[u+(v[j+624>>2]<<2)>>2]=i;v[j+624>>2]=v[j+624>>2]+1}if(!(w[l|0]&3)){break k}if(A[v[a+4>>2]+1280>>3]>=D(A[F>>3]+-1)){A[n>>3]=A[n>>3]+1e3}if(k&p&1){A[n>>3]=A[n>>3]+500}da=M*10/(M+10);q:{r:{if((m|0)==(o|0)){P=A[n>>3];M=1e3;break r}P=A[n>>3];M=500;if((o|0)==(h+q|0)){break r}x=(o|0)==(y|0)?P+100:P;break q}x=P+M}x=da+x;A[n>>3]=x;if((w[l|0]&3)==3){A[n>>3]=x+50}r=r==1e99?0:r;r=r>=0?r:-r;Y=r<=Y?Y:r}i=i+1|0;if((i|0)<v[j+776>>2]){continue}break}}h=v[j+624>>2];if(!(!(A[v[a+4>>2]+1280>>3]<Y)|(h|0)<=0)){k=v[j+780>>2];g=0;while(1){x=0;i=v[u+(g<<2)>>2];m=v[k+(i<<2)>>2];s:{if(v[m+232>>2]>=0){P=0;x=A[m+80>>3];if(x==1e99){break s}}P=x;t:{switch(w[i+H|0]-2|0){case 1:P=P>=0?P:-P;break s;case 0:break t;default:break s}}P=-P}i=s+(i<<3)|0;A[i>>3]=A[i>>3]+(P/Y+1);g=g+1|0;if((h|0)!=(g|0)){continue}break}}ax(v[j+620>>2],1956,s,h);if(!v[j+624>>2]){break g}N=v[j+620>>2];F=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+196>>2]:0;g=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+344>>2]:0;i=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;h=vd(i,4,157700,2098);v[j+636>>2]=h;k=2098;u:{if(!h){break u}h=vd(i,4,157700,2099);v[j+640>>2]=h;k=2099;if(!h){break u}h=vd(i,4,157700,2100);v[j+660>>2]=h;k=2100;if(!h){break u}h=vd(g,4,157700,2101);v[j+664>>2]=h;k=2101;if(!h){break u}h=vd(i,4,157700,2102);v[j+716>>2]=h;k=2102;if(!h){break u}U=v[j+664>>2];m=v[j+660>>2];n=v[j+640>>2];o=v[j+636>>2];J=Ib(v[v[a>>2]+8>>2],g,4,157700,2109);v[j+780>>2]=J;k=2109;if(!J){break u}h=Ib(v[v[a>>2]+8>>2],g,4,157700,2110);v[j+776>>2]=h;k=2110;if(!h){break u}K=Ib(v[v[a>>2]+8>>2],i,4,157700,2111);v[j+772>>2]=K;k=2111;if(!K){break u}k=i<<2;dc(o,k);dc(n,k);if((i|0)>0){Wb(m,255,k)}if((g|0)>0){Wb(U,255,g<<2)}m=0;if(v[j+624>>2]<=0){E=0;o=0;r=0;break h}C=0;o=0;E=0;G=0;while(1){v:{s=v[F+(v[N+(G<<2)>>2]<<2)>>2];i=v[s+232>>2];w:{if(v[v[j+664>>2]+(i<<2)>>2]!=-1){break w}p=i+v[j+600>>2]|0;k=w[p|0];if(k&32|!(k&3)){break w}l=v[j+652>>2];z=v[j+644>>2];i=k;n=i;x:{y=v[s+220>>2];if((y|0)>0){H=v[j+660>>2];L=v[j+640>>2];Q=v[j+636>>2];q=v[s+188>>2];V=v[s+180>>2];g=0;while(1){if(!((i|n)&255)){break x}u=v[v[V+(g<<2)>>2]+224>>2]<<2;S=v[u+H>>2];y:{if((S|0)==(z|0)){z:{if(!v[u+Q>>2]){break z}if(A[q+(g<<3)>>3]>0){i=i&254;n=n&253;break z}i=i&253;n=n&254}if(!v[u+L>>2]){break y}if(A[q+(g<<3)>>3]>0){i=i&253;n=n&254;break y}i=i&254;n=n&253;break y}u=(S|0)==-1;n=u?n:0;i=u?i:0}g=g+1|0;if((y|0)!=(g|0)){continue}break}}q=0;A:{if(n&255){break A}if(!(i&255)){break x}if(!l){n=i;q=1;break A}h=v[(z<<2)+l>>2];n=h?i|16:i;q=!h}if(v[j+656>>2]==(z|0)){h=z<<1;h=(h|0)>(z|0)?h:z+1|0;v[j+656>>2]=h;l=Sc(l,h,4,157700,1449);v[j+652>>2]=l;if(!l){break v}z=v[j+644>>2]}L=0;v[(z<<2)+l>>2]=0;v[j+644>>2]=v[j+644>>2]+1;u=0;B:while(1){C:{if(!q){break C}h=v[j+640>>2];i=v[j+636>>2];D:{if(!u){break D}k=v[j+600>>2];g=0;if((u|0)!=1){q=u&-2;z=0;while(1){p=J+(g<<2)|0;y=k+v[v[p>>2]+232>>2]|0;l=w[y|0];t[y|0]=l&243|(l&4?8:4);p=k+v[v[p+4>>2]+232>>2]|0;l=w[p|0];t[p|0]=l&243|(l&4?8:4);g=g+2|0;z=z+2|0;if((q|0)!=(z|0)){continue}break}}if(!(u&1)){break D}k=k+v[v[J+(g<<2)>>2]+232>>2]|0;g=w[k|0];t[k|0]=g&243|(g&4?8:4)}if((L|0)<=0){break C}g=0;if((L|0)!=1){k=L&2147483646;p=0;while(1){l=K+(g<<2)|0;q=v[l>>2]<<2;y=q+i|0;H=v[y>>2];q=h+q|0;v[y>>2]=v[q>>2];v[q>>2]=H;l=v[l+4>>2]<<2;q=l+i|0;y=v[q>>2];l=h+l|0;v[q>>2]=v[l>>2];v[l>>2]=y;g=g+2|0;p=p+2|0;if((k|0)!=(p|0)){continue}break}}if(!(L&1)){break C}k=i;i=v[K+(g<<2)>>2]<<2;g=k+i|0;k=v[g>>2];h=h+i|0;v[g>>2]=v[h>>2];v[h>>2]=k}h=v[j+644>>2]-1|0;l=v[j+716>>2];q=v[j+664>>2];p=v[j+660>>2];y=v[j+640>>2];H=v[j+636>>2];z=v[s+232>>2];g=z+v[j+600>>2]|0;if((w[g|0]&3)!=3){v[v[j+652>>2]+(h<<2)>>2]=1}k=4;i=-1;E:{F:{G:{H:{switch((n&239)-1|0){default:r=v[s+232>>2]<0?0:A[s+80>>3];if(A[v[a+4>>2]+1280>>3]>=D(r)|r==1e99){break G}if(r>0){break F}break;case 0:break E;case 1:break H}}i=1;k=8;break E}i=1;k=8;r=A[s>>3];if(A[s+16>>3]-r<0|!(A[s+8>>3]-r>0)){break E}}k=4;i=-1}O=w[g|0]|k;k=n&16;t[g|0]=O|k;v[(z<<2)+q>>2]=h;n=v[s+220>>2];if((n|0)>0){q=v[s+188>>2];z=v[s+180>>2];g=0;r=+((k?0-i|0:i)|0);while(1){i=v[v[z+(g<<2)>>2]+224>>2];k=i<<2;Q=k+p|0;if(v[Q>>2]==-1){v[Q>>2]=h;v[l+(v[j+720>>2]<<2)>>2]=i;v[j+720>>2]=v[j+720>>2]+1;v[K+(L<<2)>>2]=i;L=L+1|0}v[k+(A[q+(g<<3)>>3]*r>0?H:y)>>2]=1;g=g+1|0;if((n|0)!=(g|0)){continue}break}}v[J+(u<<2)>>2]=s;l=o+1|0;p=u+1|0;i=v[j+716>>2];k=v[j+644>>2];Z=v[j+640>>2];fa=v[j+636>>2];$=v[j+608>>2];H=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+188>>2]:0;g=v[j+720>>2];if((g|0)>0){_=i-4|0;Q=k-1|0;while(1){h=v[_+(g<<2)>>2];g=g-1|0;v[j+720>>2]=g;h=h<<2;I:{if(v[h+Z>>2]?v[h+fa>>2]:0){break I}h=v[h+H>>2];ha=v[h+216>>2];if((ha|0)<=0){break I}ga=v[h+168>>2];P=0;s=0;n=0;z=0;q=0;while(1){h=v[ga+(z<<2)>>2];V=v[h+232>>2];J:{if(v[v[j+664>>2]+(V<<2)>>2]!=-1){break J}aa=V+v[j+600>>2]|0;y=w[aa|0];if(y&32|!(y&3)){break J}S=v[j+652>>2];k=y;i=k;K:{L:{M:{ba=v[h+220>>2];if((ba|0)>0){ea=v[j+660>>2];X=v[j+640>>2];ia=v[j+636>>2];T=v[h+188>>2];ja=v[h+180>>2];g=0;while(1){if(!((i|k)&255)){break M}O=v[v[ja+(g<<2)>>2]+224>>2]<<2;ca=v[O+ea>>2];N:{if((ca|0)==(Q|0)){O:{if(!v[O+ia>>2]){break O}if(A[T+(g<<3)>>3]>0){k=k&254;i=i&253;break O}k=k&253;i=i&254}if(!v[O+X>>2]){break N}if(A[T+(g<<3)>>3]>0){k=k&253;i=i&254;break N}k=k&254;i=i&253;break N}O=(ca|0)==-1;i=O?i:0;k=O?k:0}g=g+1|0;if((ba|0)!=(g|0)){continue}break}}g=0;if(i&255){break K}if(!(k&255)){break M}if(S){break L}i=k;g=1;break K}t[aa|0]=y|32;break J}g=v[S+(Q<<2)>>2];i=g?k|16:k;g=!g}r=A[$+(V<<3)>>3];r=i&16?r*.75:r;if(!(r>P)){break J}P=r;q=g;n=i;s=h}z=z+1|0;if((ha|0)!=(z|0)){continue}break}if(s){o=l;u=p;continue B}g=v[j+720>>2]}if((g|0)>0){continue}break}}break}h=v[j+776>>2];v[(h+(v[j+644>>2]<<2)|0)-4>>2]=p;E=E+L|0;C=(p|0)<(C|0)?C:p;if(!(u>>>0<2|+(p|0)<+(C|0)*.5)){o=l;break w}l=v[j+644>>2]-1|0;g=0;L=v[j+664>>2];q=v[j+660>>2];p=v[j+640>>2];s=v[j+636>>2];Q=v[j+600>>2];k=0;while(1){i=g;g=v[J+(g<<2)>>2];n=v[g+232>>2];y=n+Q|0;t[y|0]=w[y|0]&227;v[L+(n<<2)>>2]=-1;y=v[g+220>>2];P:{if((y|0)<=0){break P}H=v[g+180>>2];g=0;if((y|0)!=1){V=y&2147483646;n=0;while(1){S=H+(g<<2)|0;z=v[v[S>>2]+224>>2]<<2;T=z+q|0;O=v[T>>2];v[T>>2]=-1;v[s+z>>2]=0;v[p+z>>2]=0;z=v[v[S+4>>2]+224>>2]<<2;S=z+q|0;T=v[S>>2];v[S>>2]=-1;v[s+z>>2]=0;v[p+z>>2]=0;k=(((l|0)==(O|0))+k|0)+((l|0)==(T|0))|0;g=g+2|0;n=n+2|0;if((V|0)!=(n|0)){continue}break}}if(!(y&1)){break P}g=v[v[H+(g<<2)>>2]+224>>2]<<2;n=g+q|0;y=v[n>>2];v[n>>2]=-1;v[g+s>>2]=0;v[g+p>>2]=0;k=((l|0)==(y|0))+k|0}g=i+1|0;if((i|0)!=(u|0)){continue}break}v[j+644>>2]=v[j+644>>2]-1;E=E-k|0;o=o-u|0;break w}t[p|0]=k|32}G=G+1|0;if((G|0)<v[j+624>>2]){continue}break i}break}Eb(157734,1449);v[j+528>>2]=-1;Fb(276579,j+528|0);k=2155}Eb(157734,k);h=-1;v[j+192>>2]=-1;Fb(276579,j+192|0);Eb(157734,4356);v[j+176>>2]=-1;Fb(276579,j+176|0);break b}Eb(157734,g);v[j+32>>2]=h;Fb(276579,j+32|0);Eb(157734,4343);v[j+16>>2]=h;Fb(276579,j+16|0);break b}r=+(C|0)*.5}y=v[j+644>>2];if((y|0)>0){while(1){i=m<<2;if(r>+v[i+h>>2]){u=0;g=0;l=0;k=v[j+624>>2];Q:{if((k|0)<=0){break Q}while(1){R:{n=v[N+(g<<2)>>2]<<2;if(v[n+U>>2]==(m|0)){v[J+(u<<2)>>2]=v[n+F>>2];u=u+1|0;h=v[j+776>>2];if((u|0)==v[i+h>>2]){break R}}g=g+1|0;if((k|0)!=(g|0)){continue}}break}if((u|0)<=0){u=0;break Q}L=v[j+664>>2];i=v[j+660>>2];n=v[j+640>>2];q=v[j+636>>2];C=v[j+600>>2];k=0;while(1){g=v[J+(l<<2)>>2];p=v[g+232>>2];s=p+C|0;t[s|0]=w[s|0]&227;v[L+(p<<2)>>2]=-1;p=v[g+220>>2];S:{if((p|0)<=0){break S}H=v[g+180>>2];g=0;if((p|0)!=1){G=p&2147483646;s=0;while(1){K=H+(g<<2)|0;z=v[v[K>>2]+224>>2]<<2;Q=z+i|0;V=v[Q>>2];v[Q>>2]=-1;v[q+z>>2]=0;v[n+z>>2]=0;z=v[v[K+4>>2]+224>>2]<<2;K=z+i|0;Q=v[K>>2];v[K>>2]=-1;v[q+z>>2]=0;v[n+z>>2]=0;k=(((m|0)==(V|0))+k|0)+((m|0)==(Q|0))|0;g=g+2|0;s=s+2|0;if((G|0)!=(s|0)){continue}break}}if(!(p&1)){break S}g=v[v[H+(g<<2)>>2]+224>>2]<<2;p=g+i|0;s=v[p>>2];v[p>>2]=-1;v[g+q>>2]=0;v[g+n>>2]=0;k=((m|0)==(s|0))+k|0}l=l+1|0;if((u|0)!=(l|0)){continue}break}l=k}T:{if((y-1|0)==(m|0)){y=v[j+644>>2]-1|0;v[j+644>>2]=y;break T}v[j+648>>2]=v[j+648>>2]+1;y=v[j+644>>2]}E=E-l|0;o=o-u|0}m=m+1|0;if((y|0)>(m|0)){continue}break}}Hb(v[v[a>>2]+8>>2],j+772|0,157700,2233);h=j+776|0;Hb(v[v[a>>2]+8>>2],h,157700,2234);g=j+780|0;Hb(v[v[a>>2]+8>>2],g,157700,2235);if(!o|+(E|0)/+(o|0)>100){break g}J=v[j+600>>2];Q=v[j+660>>2];i=v[j+644>>2];k=v[j+648>>2];o=v[j+760>>2];h=ug(a,g,h);if((h|0)!=1){Eb(157734,1095);v[j+512>>2]=h;Fb(276579,j+512|0);break c}h=vd(v[j+776>>2],1,157700,1098);v[j+612>>2]=h;if(!h){Eb(157734,1098);h=-1;v[j+224>>2]=-1;Fb(276579,j+224|0);break c}h=vd(v[j+776>>2],8,157700,1099);v[j+616>>2]=h;if(!h){Eb(157734,1099);h=-1;v[j+240>>2]=-1;Fb(276579,j+240|0);break c}H=vd(v[j+776>>2],4,157700,1100);v[j+628>>2]=H;if(!H){Eb(157734,1100);h=-1;v[j+256>>2]=-1;Fb(276579,j+256|0);break c}F=v[j+616>>2];E=v[j+612>>2];C=Ib(v[v[a>>2]+8>>2],i,4,157700,1108);v[j+772>>2]=C;if(!C){Eb(157734,1108);h=-1;v[j+272>>2]=-1;Fb(276579,j+272|0);break c}s=Ib(v[v[a>>2]+8>>2],v[j+776>>2],4,157700,1109);v[j+768>>2]=s;if(!s){Eb(157734,1109);h=-1;v[j+288>>2]=-1;Fb(276579,j+288|0);break c}U:{V:{W:{X:{Y:{Z:{switch(o|0){case 1:L=1;if(v[j+776>>2]>0){break Y}da=0;break U;case 0:case 2:break Z;default:break d}}L=2;if(v[j+776>>2]<=0){break X}}V=i<<2;ya=+((i-k|0)+3|0);za=+(L|0);i=0;da=0;la=0;ma=0;_:while(1){h=i;while(1){g=v[v[j+780>>2]+(h<<2)>>2];n=h+E|0;t[n|0]=0;q=F+(h<<3)|0;v[q>>2]=0;v[q+4>>2]=0;$:{aa:{ba:{if(w[g+273|0]&16){i=h;break ba}y=v[g+220>>2];if(!y){i=h;break ba}k=n;if(w[h+J|0]&12){i=h;break ba}ca:{while(1){qa=0;qa=v[g+232>>2]>=0?A[g+80>>3]:qa;S=v[g+188>>2];T=v[g+180>>2];x=A[g+8>>3];M=A[g+16>>3];r=A[g>>3];dc(C,V);g=0;s=v[j+768>>2];K=s+(h<<2)|0;v[K>>2]=0;ua=-(x-r);x=A[v[a+4>>2]+1272>>3];m=!(ua>=x);ra=M-r;N=x<=ra?m:m|2;ka=0;Y=0;r=0;z=0;u=0;l=0;m=0;p=0;if((y|0)>0){while(1){x=A[S+(g<<3)>>3];P=x>=0?x:-x;G=v[Q+(v[v[T+(g<<2)>>2]+224>>2]<<2)>>2];da:{if((G|0)>=0){M=x;ea:{if(r==0){break ea}M=r;if(A[v[a+4>>2]+1280>>3]>=D(r-x)){break ea}M=17976931348623157e292}fa:{if(Y==0){Y=P;break fa}if(A[v[a+4>>2]+1280>>3]>=D(Y-P)){break fa}Y=17976931348623157e292}U=C+(G<<2)|0;O=v[U>>2];G=O+1|0;v[U>>2]=G;Z=v[K>>2];v[K>>2]=(G|0)<(Z|0)?Z:G;G=x>0;p=G+p|0;m=!G+m|0;z=!O+z|0;if(v[U>>2]<2){r=M;break da}t[k|0]=w[k|0]|64;r=M;break da}ka=P>ka?P:ka;G=x>0;l=G+l|0;u=!G+u|0}g=g+1|0;if((y|0)!=(g|0)){continue}break}}if(!N){i=h;break ba}g=m+p|0;if((g|0)<=0){i=h;break ba}t[k|0]=N|w[k|0];v[H+(v[j+632>>2]<<2)>>2]=h;v[j+632>>2]=v[j+632>>2]+1;P=+(g|0);M=+(z|0);x=P/M-za;x=2-(x>=0?x:-x);x=(x<=0?0:x)*1e3+1;A[q>>3]=x;g=w[k|0];if(!(m|!(g&2)|((u|0)<=0|l))){x=x+1e3;A[q>>3]=x;g=w[k|0]}x=M*2e3/ya+(g&1?p?x:(l|0)>0?u?x:x+1e3:x:x);A[q>>3]=x;g=v[a+4>>2];M=A[g+1280>>3];y=M>=D((r>=0?r:-r)+-1);x=y?x+500:x;z=r!=0&r!=17976931348623157e292;x=z?x+250:x;if(y|z){A[q>>3]=x;M=A[g+1280>>3]}if(M>=D(Y+-1)){x=x+100;A[q>>3]=x}r=+(((l|0)>(u|0)?l:u)|0)*10/(+(l+u|0)+1)+(+(((m|0)<(p|0)?p:m)|0)*20/(P<=1?1:P)+(!(ka>0)|A[g+1280>>3]>=D(ka+-1)?x:x+100));A[q>>3]=r;if(!(!(w[k|0]&2)|-A[g+1280>>3]>ra)){r=r+10;A[q>>3]=r}x=A[g+1272>>3];if((x<=ra|0)!=(x<=ua|0)){r=r+10;A[q>>3]=r}x=qa==1e99?0:qa;x=x>=0?x:-x;da=x<=da?da:x;if(!o){break ca}m=h+1|0;if((m|0)>=v[j+776>>2]){break U}g=v[v[j+780>>2]+(m<<2)>>2];k=m+E|0;t[k|0]=0;q=F+(m<<3)|0;v[q>>2]=0;v[q+4>>2]=0;if(w[g+273|0]&16){break $}y=v[g+220>>2];if(!y){break aa}h=m;if(!(w[J+h|0]&12)){continue}break}i=h;break ba}if(w[n|0]&64){ma=ma+r;break ba}la=la+r}i=i+1|0;if((i|0)<v[j+776>>2]){continue _}if(o){break U}p=2;h=la>ma;if(!h){break V}i=v[j+632>>2];if((i|0)>0){break W}p=1;break V}i=h+2|0;if((i|0)<v[j+776>>2]){continue _}break U}h=h+2|0;if((h|0)<v[j+776>>2]){continue}break}break}break U}da=0;if(o){break U}p=2;break V}p=h?1:2;g=0;while(1){h=v[H+(g<<2)>>2];if(!(!(w[h+E|0]&64)|v[(h<<2)+s>>2]>(L|0))){h=F+(h<<3)|0;A[h>>3]=A[h>>3]+-1e3}g=g+1|0;if((i|0)!=(g|0)){continue}break}}v[j+760>>2]=p}h=v[j+632>>2];if(!(!(A[v[a+4>>2]+1280>>3]<da)|(h|0)<=0)){k=v[j+780>>2];g=0;while(1){P=0;i=v[H+(g<<2)>>2];m=v[k+(i<<2)>>2];ga:{if(v[m+232>>2]>=0){x=0;P=A[m+80>>3];if(P==1e99){break ga}}x=P;ha:{switch(w[i+E|0]-2|0){case 1:x=x>=0?x:-x;break ga;case 0:break ha;default:break ga}}x=-x}i=F+(i<<3)|0;A[i>>3]=A[i>>3]+(x>=0?x:0)/da;g=g+1|0;if((h|0)!=(g|0)){continue}break}}ax(v[j+628>>2],1956,F,h);i=j+768|0;Hb(v[v[a>>2]+8>>2],i,157700,1431);h=j+772|0;Hb(v[v[a>>2]+8>>2],h,157700,1432);o=v[j+632>>2];if(!o){break g}l=v[j+660>>2];q=v[j+612>>2];H=v[j+628>>2];g=2288;h=ug(a,j+780|0,h);if((h|0)!=1){break e}g=2289;h=xl(a,j+776|0,i);if((h|0)!=1){break e}g=2292;i=vd(v[j+768>>2],4,157700,2292);v[j+668>>2]=i;h=-1;if(!i){break e}g=2293;k=vd(v[j+772>>2],4,157700,2293);v[j+672>>2]=k;if(!k){break e}g=0;m=v[j+668>>2];if(v[j+768>>2]>0){while(1){v[m+(g<<2)>>2]=-1;g=g+1|0;if((g|0)<v[j+768>>2]){continue}break}}g=0;if(v[j+772>>2]>0){while(1){v[k+(g<<2)>>2]=-1;g=g+1|0;if((g|0)<v[j+772>>2]){continue}break}}n=0;if((o|0)>0){while(1){ia:{ja:{u=v[H+(n<<2)>>2];z=u<<2;p=v[z+v[j+780>>2]>>2];y=v[p+220>>2];ka:{if((y|0)<=0){break ka}F=v[p+180>>2];g=0;s=0;h=0;while(1){i=v[v[F+(g<<2)>>2]+224>>2]<<2;la:{if(v[i+l>>2]==-1){break la}if(v[i+m>>2]>=0){h=h+1|0;break la}s=s+1|0}g=g+1|0;if((y|0)!=(g|0)){continue}break}if(!s){break ka}if(s<<1>(h|0)){break ja}}h=q+u|0;t[h|0]=w[h|0]|32;break ia}i=v[j+744>>2];g=v[j+724>>2];if((g|0)==v[j+748>>2]){h=g<<1;h=(g|0)<(h|0)?h:g+1|0;v[j+748>>2]=h;g=2378;i=Sc(i,h,4,157700,2378);v[j+744>>2]=i;if(!i){h=-1;break e}g=v[j+724>>2]}v[(g<<2)+i>>2]=p;v[k+z>>2]=g;i=q+u|0;h=w[i|0];t[i|0]=h|(h&2?8:4);g=0;while(1){h=v[v[F+(g<<2)>>2]+224>>2]<<2;ma:{if(v[h+l>>2]<0){break ma}h=h+m|0;if(v[h>>2]!=-1){break ma}v[h>>2]=v[j+724>>2]}g=g+1|0;if((y|0)!=(g|0)){continue}break}v[j+724>>2]=v[j+724>>2]+1}n=n+1|0;if((o|0)!=(n|0)){continue}break}}o=0;L=0;l=ub-224|0;ub=l;p=j+600|0;V=v[p+160>>2];X=v[p+116>>2];ia=v[p+68>>2];K=v[p+64>>2];N=v[p+24>>2];S=v[p+20>>2];h=v[p+124>>2];T=v[p+52>>2];ja=v[p>>2];F=v[p+44>>2];n=ug(a,l+212|0,l+204|0);na:{if((n|0)!=1){Eb(157734,2749);v[l+176>>2]=n;Fb(276579,l+176|0);break na}n=xl(a,l+208|0,l+200|0);if((n|0)!=1){Eb(157734,2750);v[l+160>>2]=n;Fb(276579,l+160|0);break na}i=vd(v[l+204>>2],4,157700,2753);v[p+76>>2]=i;if(!i){Eb(157734,2753);n=-1;v[l>>2]=-1;Fb(276579,l);break na}i=vd(v[l+200>>2],4,157700,2754);v[p+152>>2]=i;if(!i){Eb(157734,2754);n=-1;v[l+16>>2]=-1;Fb(276579,l+16|0);break na}i=vd(h,4,157700,2755);v[p+156>>2]=i;if(!i){Eb(157734,2755);n=-1;v[l+32>>2]=-1;Fb(276579,l+32|0);break na}ca=h<<2;dc(i,ca);O=v[p+152>>2];H=v[p+76>>2];s=Ib(v[v[a>>2]+8>>2],h,4,157700,2761);v[l+196>>2]=s;if(!s){Eb(157734,2761);n=-1;v[l+48>>2]=-1;Fb(276579,l+48|0);break na}h=Ib(v[v[a>>2]+8>>2],F,4,157700,2762);v[l+192>>2]=h;if(!h){Eb(157734,2762);n=-1;v[l+64>>2]=-1;Fb(276579,l- -64|0);break na}h=Ib(v[v[a>>2]+8>>2],F,8,157700,2763);v[l+188>>2]=h;if(!h){Eb(157734,2763);n=-1;v[l+80>>2]=-1;Fb(276579,l+80|0);break na}h=Ib(v[v[a>>2]+8>>2],F,4,157700,2764);v[l+184>>2]=h;if(!h){Eb(157734,2764);n=-1;v[l+96>>2]=-1;Fb(276579,l+96|0);break na}h=Ib(v[v[a>>2]+8>>2],v[l+204>>2],4,157700,2765);v[l+216>>2]=h;if(h){n=0;if(v[l+204>>2]>0){while(1){v[H+(n<<2)>>2]=-1;n=n+1|0;if((n|0)<v[l+204>>2]){continue}break}}n=0;if(v[l+200>>2]>0){while(1){v[O+(n<<2)>>2]=0;n=n+1|0;if((n|0)<v[l+200>>2]){continue}break}}n=1;oa:{if((N|0)<=0){break oa}if((F|0)==1){while(1){h=v[S+(o<<2)>>2]<<2;pa:{if(v[h+K>>2]==-1){break pa}h=h+H|0;if(v[h>>2]>=0){break pa}i=h;h=v[p+128>>2];v[i>>2]=h;v[p+128>>2]=h+1}o=o+1|0;if((N|0)!=(o|0)){continue}break}break oa}na=F&2147483644;Z=F&3;W=F>>>0<4;while(1){k=v[S+(L<<2)>>2];m=k<<2;q=v[m+K>>2];qa:{if((q|0)==-1){break qa}h=m+H|0;if(v[h>>2]>=0){break qa}i=h;h=v[p+128>>2];v[i>>2]=h;v[p+128>>2]=h+1;dc(s,ca);h=v[m+v[l+212>>2]>>2];g=v[h+180>>2];fa=v[h+220>>2];ra:{if((fa|0)<=0){y=0;z=0;break ra}i=v[h+188>>2];z=0;k=w[k+ja|0];o=k&8?1:-1;k=k&16?0-o|0:o;r=+((v[T+(q<<2)>>2]==-1?0-k|0:k)|0);s=v[l+196>>2];y=0;o=0;while(1){k=v[ia+(v[v[(o<<2)+g>>2]+224>>2]<<2)>>2];sa:{if((k|0)>=0){ta:{if((V|0)!=2){if(!(A[i+(o<<3)>>3]*r>0)){break ta}}k=(k<<2)+s|0;v[k>>2]=v[k>>2]+1;break sa}k=(k<<2)+s|0;v[k>>2]=v[k>>2]-1;break sa}ua:{if((V|0)!=2){if(!(A[i+(o<<3)>>3]*r>0)){break ua}}z=z+1|0;break sa}y=y+1|0}o=o+1|0;if((fa|0)!=(o|0)){continue}break}}oa=(F|0)<=0;if(!oa){h=0;i=v[l+184>>2];g=v[l+188>>2];k=v[l+192>>2];o=0;u=0;if(!W){while(1){E=o<<2;v[E+k>>2]=0;C=g+(o<<3)|0;v[C>>2]=0;v[C+4>>2]=0;v[i+E>>2]=0;E=o|1;C=E<<2;v[C+k>>2]=0;E=g+(E<<3)|0;v[E>>2]=0;v[E+4>>2]=0;v[i+C>>2]=0;E=o|2;C=E<<2;v[C+k>>2]=0;E=g+(E<<3)|0;v[E>>2]=0;v[E+4>>2]=0;v[i+C>>2]=0;E=o|3;C=E<<2;v[C+k>>2]=0;E=g+(E<<3)|0;v[E>>2]=0;v[E+4>>2]=0;v[i+C>>2]=0;o=o+4|0;u=u+4|0;if((na|0)!=(u|0)){continue}break}}if(Z){while(1){u=o<<2;v[u+k>>2]=0;E=g+(o<<3)|0;v[E>>2]=0;v[E+4>>2]=0;v[i+u>>2]=0;o=o+1|0;h=h+1|0;if((Z|0)!=(h|0)){continue}break}}h=v[m+v[l+212>>2]>>2];g=v[h+180>>2]}i=v[h+220>>2];h=0;v[p+120>>2]=0;if((i|0)>0){m=v[p+152>>2];o=v[p+144>>2];u=v[p+116>>2];E=v[p+68>>2];C=v[p+60>>2];while(1){k=v[E+(v[v[(h<<2)+g>>2]+224>>2]<<2)>>2];va:{if((k|0)==-1){break va}k=v[o+(k<<2)>>2];G=v[k+220>>2];if((G|0)<=0){break va}J=v[k+180>>2];k=0;while(1){U=v[v[J+(k<<2)>>2]+224>>2];Q=U<<2;$=v[Q+C>>2];wa:{if(($|0)==-1|(q|0)==($|0)){break wa}Q=m+Q|0;if(v[Q>>2]){break wa}v[Q>>2]=1;v[u+(v[p+120>>2]<<2)>>2]=U;v[p+120>>2]=v[p+120>>2]+1}k=k+1|0;if((G|0)!=(k|0)){continue}break}}h=h+1|0;if((i|0)!=(h|0)){continue}break}}pa=v[l+216>>2];dc(pa,v[l+204>>2]<<2);if(v[p+120>>2]>0){Aa=y+z|0;E=0;while(1){h=v[X+(E<<2)>>2]<<2;v[h+O>>2]=0;h=v[h+v[l+208>>2]>>2];va=v[h+216>>2];if((va|0)>0){Ba=v[h+168>>2];U=0;while(1){wa=(U<<2)+Ba|0;h=v[wa>>2];i=v[h+232>>2]<<2;g=i+pa|0;xa:{if(v[g>>2]){break xa}v[g>>2]=1;$=v[i+K>>2];if(($|0)==-1|v[i+H>>2]>=0){break xa}Q=v[p+156>>2];_=v[p+68>>2];i=v[p+64>>2];g=v[p+52>>2];k=v[p>>2];ha=v[p+160>>2];s=v[l+196>>2];J=Ib(v[v[a>>2]+8>>2],v[p+124>>2],4,157700,2555);v[l+220>>2]=J;ya:{za:{Aa:{if(J){G=v[h+220>>2];o=v[h+232>>2];g=v[g+(v[i+(o<<2)>>2]<<2)>>2];ga=v[h+188>>2];aa=v[h+180>>2];m=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;if((G|0)<=0){C=0;r=0;break ya}ba=k+o|0;h=0;if((ha|0)==1){break Aa}q=0;u=0;o=0;while(1){i=v[_+(v[v[aa+(o<<2)>>2]+224>>2]<<2)>>2];Ba:{if((i|0)==-1){k=h;h=A[ga+(o<<3)>>3]>0;i=h?-1:1;C=h?1:-1;h=w[ba|0];i=h&4?i:C;i=h&16?0-i|0:i;h=k+((i|0)>0)|0;q=((i|0)<=0)+q|0;break Ba}k=i<<2;if(!v[k+s>>2]){break Ba}C=k+Q|0;k=v[C>>2];if(!k){v[J+(u<<2)>>2]=i;u=u+1|0;k=v[C>>2]}v[C>>2]=k+1}o=o+1|0;if((G|0)!=(o|0)){continue}break}i=h;h=1;break za}Eb(157734,2555);n=-1;v[l+144>>2]=-1;Fb(276579,l+144|0);Eb(157734,2928);v[l+128>>2]=-1;Fb(276579,l+128|0);break na}i=0;q=0;u=0;o=0;while(1){k=A[ga+(o<<3)>>3]>0;C=k?-1:1;ea=k?1:-1;k=w[ba|0];C=k&4?C:ea;C=k&16?0-C|0:C;ea=v[_+(v[v[aa+(o<<2)>>2]+224>>2]<<2)>>2];Ca:{if((ea|0)!=-1){xa=ea<<2;k=v[xa+s>>2];if(!k){break Ca}k=(B(k,C)|0)<=0?-1:1;Da:{if(!g){g=k;break Da}if((g|0)!=(k|0)){break za}}h=Q+xa|0;k=v[h>>2];if(!k){v[J+(u<<2)>>2]=ea;u=u+1|0;k=v[h>>2]}v[h>>2]=k+C;break Ca}i=((C|0)>0)+i|0;q=((C|0)<=0)+q|0}o=o+1|0;h=(G|0)<=(o|0);if((o|0)!=(G|0)){continue}break}}C=0;x=0;o=0;r=0;if((u|0)<=0){break ya}while(1){_=v[J+(o<<2)>>2]<<2;ga=v[_+s>>2];k=ga>>31;aa=Q+_|0;ba=v[aa>>2];_=ba>>31;r=+((k^ga)-k|0);M=+((_^ba)-_|0);Ea:{if(r>M){r=M/r;break Ea}r=r/M}v[aa>>2]=0;x=x+r;o=o+1|0;if((u|0)!=(o|0)){continue}break}r=0;if(!(x>0&h)){break ya}r=+(m|0);r=r+r+1;x=x-(x*((ha|0)==1?-2:-4)+ +(G+fa-((q+Aa|0)+i)|0))/r;Fa:{if((g|0)==-1){i=i-y|0;h=i>>31;o=(h^i)-h|0;i=q-z|0;h=i>>31;k=(h^i)-h|0;break Fa}k=q-y|0;h=k>>31;k=(h^k)-h|0;i=i-z|0;h=i>>31;o=(h^i)-h|0}C=(g|0)==-1;r=x+(1-+(k+o|0)/r);r=r>=1e-6?r:1e-6}Hb(v[v[a>>2]+8>>2],l+220|0,157700,2704);h=v[l+188>>2]+($<<3)|0;if(!(r>A[h>>3])){break xa}i=$<<2;v[i+v[l+192>>2]>>2]=v[wa>>2];A[h>>3]=r;v[i+v[l+184>>2]>>2]=C}U=U+1|0;if((va|0)!=(U|0)){continue}break}}E=E+1|0;if((E|0)<v[p+120>>2]){continue}break}}if(oa){break qa}o=0;i=v[l+184>>2];g=v[l+192>>2];while(1){h=o<<2;k=v[h+g>>2];if(k){v[H+(v[k+232>>2]<<2)>>2]=v[p+128>>2]-1;v[h+T>>2]=v[h+i>>2]?-1:1}o=o+1|0;if((F|0)!=(o|0)){continue}break}}L=L+1|0;if((N|0)!=(L|0)){continue}break}}Hb(v[v[a>>2]+8>>2],l+216|0,157700,2976);Hb(v[v[a>>2]+8>>2],l+184|0,157700,2977);Hb(v[v[a>>2]+8>>2],l+188|0,157700,2978);Hb(v[v[a>>2]+8>>2],l+192|0,157700,2979);Hb(v[v[a>>2]+8>>2],l+196|0,157700,2980);break na}Eb(157734,2765);n=-1;v[l+112>>2]=-1;Fb(276579,l+112|0)}ub=l+224|0;h=n;if((h|0)!=1){Eb(157734,4390);v[j+496>>2]=h;Fb(276579,j+496|0);break b}i=v[j+644>>2];if((i|0)>0){g=0;h=v[j+652>>2];while(1){k=h+(g<<2)|0;if(!v[k>>2]){v[k>>2]=1;i=v[j+644>>2]}g=g+1|0;if((i|0)>(g|0)){continue}break}}p=0;y=0;k=ub-128|0;ub=k;L=v[j+744>>2];l=v[j+728>>2];q=v[j+724>>2];s=v[j+652>>2];g=v[j+644>>2];H=v[j+676>>2];J=v[j+672>>2];z=v[j+668>>2];u=v[j+664>>2];E=v[j+660>>2];n=v[j+624>>2];F=v[j+620>>2];h=ug(a,k+124|0,k+120|0);Ga:{if((h|0)!=1){Eb(157734,3481);v[k+80>>2]=h;Fb(276579,k+80|0);break Ga}i=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;m=Ib(v[v[a>>2]+8>>2],g,4,157700,3488);v[k+116>>2]=m;if(!m){Eb(157734,3488);h=-1;v[k>>2]=-1;Fb(276579,k);break Ga}h=Ib(v[v[a>>2]+8>>2],g,4,157700,3489);v[k+112>>2]=h;if(!h){Eb(157734,3489);h=-1;v[k+16>>2]=-1;Fb(276579,k+16|0);break Ga}o=Ib(v[v[a>>2]+8>>2],g,4,157700,3490);v[k+108>>2]=o;if(!o){Eb(157734,3490);h=-1;v[k+32>>2]=-1;Fb(276579,k+32|0);break Ga}C=(g|0)>(q|0)?g:q;C=Ib(v[v[a>>2]+8>>2],(l|0)<(C|0)?C:l,4,157700,3491);v[k+104>>2]=C;if(!C){Eb(157734,3491);h=-1;v[k+48>>2]=-1;Fb(276579,k+48|0);break Ga}C=g<<2;dc(m,C);dc(h,C);Ha:{if((n|0)<=0){break Ha}h=0;if((n|0)!=1){G=n&2147483646;while(1){K=F+(h<<2)|0;N=v[u+(v[K>>2]<<2)>>2];if((N|0)>=0){N=m+(N<<2)|0;v[N>>2]=v[N>>2]+1}K=v[u+(v[K+4>>2]<<2)>>2];if((K|0)>=0){K=m+(K<<2)|0;v[K>>2]=v[K>>2]+1}h=h+2|0;p=p+2|0;if((G|0)!=(p|0)){continue}break}}if(!(n&1)){break Ha}h=v[u+(v[F+(h<<2)>>2]<<2)>>2];if((h|0)<0){break Ha}h=m+(h<<2)|0;v[h>>2]=v[h>>2]+1}if((q|0)>0){G=g&2147483646;K=g&1;while(1){h=v[v[L+(y<<2)>>2]+232>>2];dc(o,C);h=v[v[k+124>>2]+(h<<2)>>2];m=v[h+220>>2];if((m|0)>0){p=v[h+180>>2];h=0;o=v[k+108>>2];while(1){N=v[v[p+(h<<2)>>2]+224>>2]<<2;U=v[N+E>>2];if(!((U|0)<0|v[z+N>>2]!=(y|0))){v[(U<<2)+o>>2]=1}h=h+1|0;if((m|0)!=(h|0)){continue}break}}Ia:{if((g|0)<=0){break Ia}h=0;p=v[k+112>>2];o=v[k+108>>2];m=0;if((g|0)!=1){while(1){N=h<<2;if(v[N+o>>2]){N=p+N|0;v[N>>2]=v[N>>2]+1}N=(h|1)<<2;if(v[N+o>>2]){N=p+N|0;v[N>>2]=v[N>>2]+1}h=h+2|0;m=m+2|0;if((G|0)!=(m|0)){continue}break}}if(!K){break Ia}h=h<<2;if(!v[h+o>>2]){break Ia}h=h+p|0;v[h>>2]=v[h>>2]+1}y=y+1|0;if((q|0)!=(y|0)){continue}break}}Ja:{if((g|0)<=0){o=0;break Ja}p=0;y=v[k+116>>2];h=0;m=0;if(g>>>0>=4){C=g&2147483644;G=0;while(1){o=y+(m<<2)|0;K=v[o>>2];h=(h|0)>(K|0)?h:K;K=v[o+4>>2];h=(h|0)>(K|0)?h:K;K=v[o+8>>2];h=(h|0)>(K|0)?h:K;o=v[o+12>>2];h=(h|0)>(o|0)?h:o;m=m+4|0;G=G+4|0;if((C|0)!=(G|0)){continue}break}}o=g&3;if(o){while(1){C=v[y+(m<<2)>>2];h=(h|0)>(C|0)?h:C;m=m+1|0;p=p+1|0;if((o|0)!=(p|0)){continue}break}}r=+(h|0)*.5;Ka:{if(D(r)<2147483648){h=~~r;break Ka}h=-2147483648}if((g|0)<=0){o=0;break Ja}y=(h|0)<=3?3:h;o=0;p=v[k+104>>2];C=v[k+112>>2];G=v[k+116>>2];h=0;while(1){m=h<<2;La:{if(!((y|0)>v[m+G>>2]|v[m+C>>2]<=0)){v[m+p>>2]=o;v[s+(o<<2)>>2]=v[m+s>>2];o=o+1|0;break La}v[m+p>>2]=-1}h=h+1|0;if((g|0)!=(h|0)){continue}break}}if((g|0)>(o|0)){h=3597;p=Ib(v[v[a>>2]+8>>2],q,4,157700,3597);v[k+100>>2]=p;Ma:{Na:{if(!p){break Na}h=3598;s=Ib(v[v[a>>2]+8>>2],l,4,157700,3598);v[k+96>>2]=s;if(!s){break Na}dc(p,q<<2);dc(s,l<<2);if((i|0)<=0){break Ma}m=v[k+104>>2];h=0;while(1){g=h<<2;y=g+E|0;C=v[y>>2];Oa:{if((C|0)<0){break Oa}G=y;y=v[m+(C<<2)>>2];v[G>>2]=y;g=g+z|0;if((y|0)==-1){v[g>>2]=-1;break Oa}g=v[g>>2];if((g|0)<0){break Oa}v[p+(g<<2)>>2]=1}h=h+1|0;if((i|0)!=(h|0)){continue}break}break Ma}Eb(157734,h);h=-1;v[k+64>>2]=-1;Fb(276579,k- -64|0);break Ga}if((n|0)>0){m=v[k+104>>2];h=0;while(1){g=v[F+(h<<2)>>2]<<2;y=g+u|0;E=v[y>>2];Pa:{if((E|0)<0){break Pa}G=y;y=v[m+(E<<2)>>2];v[G>>2]=y;g=g+H|0;if((y|0)==-1){v[g>>2]=-1;break Pa}v[s+(v[g>>2]<<2)>>2]=1}h=h+1|0;if((n|0)!=(h|0)){continue}break}}v[j+644>>2]=o;h=0;if((q|0)>0){m=0;while(1){g=m<<2;o=g+L|0;y=g+v[k+104>>2]|0;Qa:{if(v[g+p>>2]){v[y>>2]=h;o=v[o>>2];v[L+(h<<2)>>2]=o;g=h;h=g+1|0;break Qa}g=-1;v[y>>2]=-1;o=v[o>>2]}v[J+(v[o+232>>2]<<2)>>2]=g;m=m+1|0;if((q|0)!=(m|0)){continue}break}}if((h|0)<(q|0)){Ra:{if((i|0)<=0){break Ra}m=0;g=v[k+104>>2];if((i|0)!=1){q=i&2147483646;p=0;while(1){o=z+(m<<2)|0;y=v[o>>2];if((y|0)>=0){v[o>>2]=v[g+(y<<2)>>2]}y=v[o+4>>2];if((y|0)>=0){v[o+4>>2]=v[g+(y<<2)>>2]}m=m+2|0;p=p+2|0;if((q|0)!=(p|0)){continue}break}}if(!(i&1)){break Ra}i=z+(m<<2)|0;m=v[i>>2];if((m|0)<0){break Ra}v[i>>2]=v[g+(m<<2)>>2]}v[j+724>>2]=h}Sa:{if((l|0)<=0){h=0;break Sa}p=l&1;i=v[k+104>>2];Ta:{if((l|0)==1){m=0;h=0;break Ta}y=l&2147483646;m=0;h=0;o=0;while(1){g=m<<2;q=v[g+s>>2];v[g+i>>2]=q?h:-1;z=g|4;g=v[z+s>>2];h=((q|0)!=0)+h|0;v[i+z>>2]=g?h:-1;h=h+((g|0)!=0)|0;m=m+2|0;o=o+2|0;if((y|0)!=(o|0)){continue}break}}if(!p){break Sa}m=m<<2;g=v[m+s>>2];v[i+m>>2]=g?h:-1;h=((g|0)!=0)+h|0}if((h|0)<(l|0)){Ua:{if((n|0)<=0){break Ua}m=0;i=v[k+104>>2];if((n|0)!=1){g=n&2147483646;o=0;while(1){l=F+(m<<2)|0;q=v[l>>2]<<2;if(v[q+u>>2]>=0){q=q+H|0;v[q>>2]=v[i+(v[q>>2]<<2)>>2]}l=v[l+4>>2]<<2;if(v[l+u>>2]>=0){l=l+H|0;v[l>>2]=v[i+(v[l>>2]<<2)>>2]}m=m+2|0;o=o+2|0;if((g|0)!=(o|0)){continue}break}}if(!(n&1)){break Ua}g=v[F+(m<<2)>>2]<<2;if(v[g+u>>2]<0){break Ua}g=g+H|0;v[g>>2]=v[i+(v[g>>2]<<2)>>2]}v[j+728>>2]=h}Hb(v[v[a>>2]+8>>2],k+96|0,157700,3741);Hb(v[v[a>>2]+8>>2],k+100|0,157700,3742)}v[j+648>>2]=0;Hb(v[v[a>>2]+8>>2],k+104|0,157700,3749);Hb(v[v[a>>2]+8>>2],k+108|0,157700,3750);Hb(v[v[a>>2]+8>>2],k+112|0,157700,3751);Hb(v[v[a>>2]+8>>2],k+116|0,157700,3752);h=1}ub=k+128|0;if((h|0)!=1){Eb(157734,4400);v[j+480>>2]=h;Fb(276579,j+480|0);break b}r=A[R+56>>3];la=A[R- -64>>3];o=0;k=0;m=ub-224|0;ub=m;N=v[j+760>>2];ha=v[j+744>>2];z=v[j+644>>2];g=v[j+728>>2];U=v[j+660>>2];Q=v[j+668>>2];n=v[j+724>>2];v[R+92>>2]=1;h=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;i=vd(n,4,157700,3807);v[j+684>>2]=i;Va:{if(!i){Eb(157734,3807);l=-1;v[m>>2]=-1;Fb(276579,m);break Va}i=vd(n,4,157700,3808);v[j+688>>2]=i;if(!i){Eb(157734,3808);l=-1;v[m+16>>2]=-1;Fb(276579,m+16|0);break Va}i=vd(h,4,157700,3809);v[j+692>>2]=i;if(!i){Eb(157734,3809);l=-1;v[m+32>>2]=-1;Fb(276579,m+32|0);break Va}i=vd(h,4,157700,3810);v[j+696>>2]=i;if(!i){Eb(157734,3810);l=-1;v[m+48>>2]=-1;Fb(276579,m+48|0);break Va}i=vd(g,4,157700,3811);v[j+700>>2]=i;if(!i){Eb(157734,3811);l=-1;v[m+64>>2]=-1;Fb(276579,m- -64|0);break Va}i=vd(g,4,157700,3812);v[j+704>>2]=i;if(!i){Eb(157734,3812);l=-1;v[m+80>>2]=-1;Fb(276579,m+80|0);break Va}i=vd(n,4,157700,3813);v[j+708>>2]=i;if(!i){Eb(157734,3813);l=-1;v[m+96>>2]=-1;Fb(276579,m+96|0);break Va}q=vd(n,4,157700,3814);v[j+712>>2]=q;if(!q){Eb(157734,3814);l=-1;v[m+112>>2]=-1;Fb(276579,m+112|0);break Va}v[j+680>>2]=n;p=v[j+708>>2];y=v[j+704>>2];F=v[j+700>>2];V=v[j+688>>2];S=v[j+684>>2];Wa:{if((h|0)<=0){break Wa}l=v[j+696>>2];u=v[j+692>>2];if(h>>>0>=4){H=h&2147483644;i=0;while(1){s=o<<2;v[s+u>>2]=-2;v[l+s>>2]=-2;L=s|4;v[L+u>>2]=-2;v[l+L>>2]=-2;L=s|8;v[L+u>>2]=-2;v[l+L>>2]=-2;s=s|12;v[s+u>>2]=-2;v[l+s>>2]=-2;o=o+4|0;i=i+4|0;if((H|0)!=(i|0)){continue}break}}h=h&3;if(!h){break Wa}while(1){i=o<<2;v[i+u>>2]=-2;v[i+l>>2]=-2;o=o+1|0;k=k+1|0;if((h|0)!=(k|0)){continue}break}}Xa:{if((g|0)<=0){break Xa}i=0;o=0;if(g>>>0>=4){k=g&2147483644;l=0;while(1){h=o<<2;v[h+F>>2]=-1;v[h+y>>2]=-1;u=h|4;v[u+F>>2]=-1;v[u+y>>2]=-1;u=h|8;v[u+F>>2]=-1;v[u+y>>2]=-1;h=h|12;v[h+F>>2]=-1;v[h+y>>2]=-1;o=o+4|0;l=l+4|0;if((k|0)!=(l|0)){continue}break}}h=g&3;if(!h){break Xa}while(1){k=o<<2;v[k+F>>2]=-1;v[k+y>>2]=-1;o=o+1|0;i=i+1|0;if((h|0)!=(i|0)){continue}break}}Ya:{if((n|0)<=0){break Ya}i=0;o=0;if(n>>>0>=4){k=n&2147483644;l=0;while(1){h=o<<2;v[h+p>>2]=-1;v[h+q>>2]=-1;u=h|4;v[u+p>>2]=-1;v[q+u>>2]=-1;u=h|8;v[u+p>>2]=-1;v[q+u>>2]=-1;h=h|12;v[h+p>>2]=-1;v[h+q>>2]=-1;o=o+4|0;l=l+4|0;if((k|0)!=(l|0)){continue}break}}h=n&3;if(!h){break Ya}while(1){k=o<<2;v[k+p>>2]=-1;v[k+q>>2]=-1;o=o+1|0;i=i+1|0;if((h|0)!=(i|0)){continue}break}}h=Ib(v[v[a>>2]+8>>2],g,8,157700,3846);v[m+220>>2]=h;if(!h){Eb(157734,3846);l=-1;v[m+128>>2]=-1;Fb(276579,m+128|0);break Va}i=Ib(v[v[a>>2]+8>>2],g,8,157700,3847);v[m+216>>2]=i;if(!i){Eb(157734,3847);l=-1;v[m+144>>2]=-1;Fb(276579,m+144|0);break Va}G=Ib(v[v[a>>2]+8>>2],z,4,157700,3848);v[m+212>>2]=G;if(!G){Eb(157734,3848);l=-1;v[m+160>>2]=-1;Fb(276579,m+160|0);break Va}C=Ib(v[v[a>>2]+8>>2],z,4,157700,3849);v[m+208>>2]=C;if(!C){Eb(157734,3849);l=-1;v[m+176>>2]=-1;Fb(276579,m+176|0);break Va}k=Ib(v[v[a>>2]+8>>2],g,4,157700,3850);v[m+204>>2]=k;if(!k){Eb(157734,3850);l=-1;v[m+192>>2]=-1;Fb(276579,m+192|0);break Va}k=h;h=g<<3;dc(k,h);dc(i,h);v[j+736>>2]=0;v[j+740>>2]=0;ma=+(n|0)*r;l=1;Za:{if((n|0)<=0){r=0;break Za}T=z<<2;s=0;while(1){H=s<<2;h=H+ha|0;i=v[h>>2];O=v[i+180>>2];K=v[i+220>>2];dc(G,T);dc(C,T);_a:{$a:{ab:{i=(K|0)<=0;if(i){break ab}o=0;C=v[m+208>>2];L=0;while(1){g=v[v[O+(o<<2)>>2]+224>>2]<<2;bb:{if(v[g+Q>>2]<0){break bb}g=v[g+U>>2]<<2;k=g+G|0;v[k>>2]=v[k>>2]+1;g=g+C|0;if(v[g>>2]){break bb}v[g>>2]=1;L=L+1|0}o=o+1|0;if((K|0)!=(o|0)){continue}break}if(!L){break ab}h=-1;Y=0;if(!i){break $a}da=0;ka=0;i=-1;r=0;x=0;break _a}v[h>>2]=0;v[H+S>>2]=-1;v[H+V>>2]=-1;s=s+1|0;if((n|0)>(s|0)){continue}r=A[j+736>>3];break Za}u=0;Z=v[m+204>>2];fa=v[m+216>>2];$=v[m+220>>2];E=0;da=0;ka=0;while(1){i=v[O+(E<<2)>>2];J=v[i+224>>2]<<2;if(v[J+Q>>2]>=0){ga=v[J+U>>2];_=v[j+696>>2];aa=J+v[j+692>>2]|0;k=v[aa>>2];cb:{if((k|0)>=-1){i=v[J+_>>2];break cb}k=-1;ba=v[i+216>>2];db:{if((ba|0)<=0){i=-1;break db}ea=v[j+676>>2];X=v[j+664>>2];ia=v[j+652>>2];ja=v[j+600>>2];ca=v[i+172>>2];na=v[i+168>>2];o=0;i=-1;while(1){W=v[v[na+(o<<2)>>2]+232>>2];oa=W<<2;g=v[oa+ea>>2];eb:{if((g|0)<0){break eb}W=w[W+ja|0];pa=W&4?-1:1;W=W&16?0-pa|0:pa;if(A[ca+(o<<3)>>3]*+((v[ia+(v[X+oa>>2]<<2)>>2]==-1?0-W|0:W)|0)>0){k=g;if((i|0)<0){break eb}break db}i=g;if((k|0)>=0){break db}}o=o+1|0;if((ba|0)!=(o|0)){continue}break}}v[aa>>2]=k;v[J+_>>2]=i}r=1/+v[G+(ga<<2)>>2];if((k|0)>=0){g=k<<3;o=g+$|0;x=A[o>>3];if(!(x!=0|A[g+fa>>3]!=0)){v[Z+(u<<2)>>2]=k;u=u+1|0}A[o>>3]=r+x;ka=ka+r}if((i|0)>=0){g=i<<3;o=g+fa|0;x=A[o>>3];if(!(A[g+$>>3]!=0|x!=0)){v[Z+(u<<2)>>2]=i;u=u+1|0}A[o>>3]=r+x;da=da+r}Y=Y+((i&k)<0?-0:r)}E=E+1|0;if((K|0)!=(E|0)){continue}break}if((u|0)<=0){r=0;i=-1;x=0;break _a}i=-1;x=0;o=0;E=v[m+216>>2];J=v[m+220>>2];K=v[m+204>>2];r=0;if((N|0)==1){while(1){g=v[K+(o<<2)>>2];O=g<<3;k=O+J|0;M=A[k>>3];O=E+O|0;P=A[O>>3];fb:{if(M>=P){if(!(r<M)){break fb}h=g;r=M;break fb}if(!(x<P)){break fb}i=g;x=P}v[k>>2]=0;v[k+4>>2]=0;v[O>>2]=0;v[O+4>>2]=0;o=o+1|0;if((u|0)!=(o|0)){continue}break}break _a}while(1){g=h;k=v[K+(o<<2)>>2];h=k<<3;O=h+J|0;Z=h+E|0;M=A[O>>3]+A[Z>>3];gb:{if(M>r){i=g;x=r;r=M;g=k;break gb}if(!(x<M)){break gb}i=k;x=M}h=g;v[O>>2]=0;v[O+4>>2]=0;v[Z>>2]=0;v[Z+4>>2]=0;o=o+1|0;if((u|0)!=(o|0)){continue}break}}g=(N|0)==2;M=(g?Y:ka)-r;r=+(L|0);M=M/r;h=M>la?-1:h;v[H+S>>2]=h;r=((g?Y:da)-x)/r;i=r>la?-1:i;v[H+V>>2]=i;if((h|0)!=-1){h=F+(h<<2)|0;v[p+H>>2]=v[h>>2];v[h>>2]=s}if((i|0)!=-1){h=y+(i<<2)|0;v[q+H>>2]=v[h>>2];v[h>>2]=s}r=(M+r)*.5+A[j+736>>3];A[j+736>>3]=r;if(r>ma){break Za}s=s+1|0;if((n|0)>(s|0)){continue}break}}v[R+92>>2]=(n|0)>0&(z|0)>0&r<=ma;Hb(v[v[a>>2]+8>>2],m+204|0,157700,4095);Hb(v[v[a>>2]+8>>2],m+208|0,157700,4096);Hb(v[v[a>>2]+8>>2],m+212|0,157700,4097);Hb(v[v[a>>2]+8>>2],m+216|0,157700,4098);Hb(v[v[a>>2]+8>>2],m+220|0,157700,4099)}ub=m+224|0;h=l;if((h|0)!=1){Eb(157734,4403);v[j+464>>2]=h;Fb(276579,j+464|0);break b}if(!v[R+92>>2]){break g}p=0;q=ub-144|0;ub=q;k=1;s=j+600|0;z=v[s+44>>2];hb:{if(!z){break hb}F=v[s+24>>2];if(!F){break hb}g=v[s+128>>2];if(!g){break hb}U=v[s+160>>2];H=v[s+68>>2];m=v[s+76>>2];n=v[s+20>>2];l=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+196>>2]:0;o=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+188>>2]:0;h=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;C=Ib(v[v[a>>2]+8>>2],F,4,157700,3157);v[q+140>>2]=C;if(!C){Eb(157734,3157);k=-1;v[q>>2]=-1;Fb(276579,q);break hb}L=Ib(v[v[a>>2]+8>>2],F,4,157700,3158);v[q+136>>2]=L;if(!L){Eb(157734,3158);k=-1;v[q+16>>2]=-1;Fb(276579,q+16|0);break hb}k=Ib(v[v[a>>2]+8>>2],g,4,157700,3159);v[q+132>>2]=k;if(!k){Eb(157734,3159);k=-1;v[q+32>>2]=-1;Fb(276579,q+32|0);break hb}u=Ib(v[v[a>>2]+8>>2],g,4,157700,3160);v[q+128>>2]=u;if(!u){Eb(157734,3160);k=-1;v[q+48>>2]=-1;Fb(276579,q+48|0);break hb}i=Ib(v[v[a>>2]+8>>2],g,4,157700,3161);v[q+124>>2]=i;if(!i){Eb(157734,3161);k=-1;v[q+64>>2]=-1;Fb(276579,q- -64|0);break hb}E=Ib(v[v[a>>2]+8>>2],h,4,157700,3162);v[q+120>>2]=E;ib:{if(E){jb:{if((F|0)<=0){break jb}i=0;if((F|0)!=1){G=F&2147483646;while(1){h=i<<2;y=v[h+n>>2];v[h+C>>2]=y;v[h+L>>2]=v[m+(y<<2)>>2];h=h|4;y=v[h+n>>2];v[h+C>>2]=y;v[h+L>>2]=v[m+(y<<2)>>2];i=i+2|0;p=p+2|0;if((G|0)!=(p|0)){continue}break}}if(!(F&1)){break jb}h=i<<2;i=v[h+n>>2];v[h+C>>2]=i;v[h+L>>2]=v[m+(i<<2)>>2]}nf(L,C,F);kb:{if((g|0)<=0){break kb}n=0;m=0;if(g>>>0>=4){p=g&2147483644;h=0;while(1){i=m<<2;v[i+k>>2]=0;v[i+u>>2]=0;y=i|4;v[y+k>>2]=0;v[u+y>>2]=0;y=i|8;v[y+k>>2]=0;v[u+y>>2]=0;i=i|12;v[i+k>>2]=0;v[i+u>>2]=0;m=m+4|0;h=h+4|0;if((p|0)!=(h|0)){continue}break}}h=g&3;if(!h){break kb}while(1){i=m<<2;v[i+k>>2]=0;v[i+u>>2]=0;m=m+1|0;n=n+1|0;if((h|0)!=(n|0)){continue}break}}r=I(+(z|0)*.8-A[v[a+4>>2]+1280>>3]);lb:{if(D(r)<2147483648){h=~~r;break lb}h=-2147483648}y=0;mb:{if((F|0)<=0){break mb}while(1){if(v[L+(y<<2)>>2]>=0){break mb}y=y+1|0;if((F|0)!=(y|0)){continue}break}break ib}if((y|0)>=(F|0)){break ib}Q=h<<((U|0)==2);V=E-4|0;k=1;p=0;u=0;z=0;while(1){h=y<<2;if(v[h+L>>2]==(z|0)){h=v[l+(v[h+C>>2]<<2)>>2];S=v[h+220>>2];if((S|0)>0){T=v[h+180>>2];n=0;O=v[q+124>>2];J=v[q+128>>2];K=v[q+132>>2];while(1){nb:{ob:{pb:{i=v[T+(n<<2)>>2];Z=v[i+224>>2];G=Z<<2;h=G+H|0;switch(v[h>>2]+2|0){case 1:break ob;case 0:break pb;default:break nb}}v[h>>2]=-1;break nb}N=v[s+96>>2];fa=G+v[s+92>>2]|0;h=v[fa>>2];qb:{if((h|0)>=-1){i=v[G+N>>2];break qb}h=-1;$=v[i+216>>2];rb:{if(($|0)<=0){i=-1;break rb}_=v[s+76>>2];ha=v[s+64>>2];ga=v[s+52>>2];aa=v[s>>2];ba=v[i+172>>2];ea=v[i+168>>2];m=0;i=-1;while(1){X=v[v[ea+(m<<2)>>2]+232>>2];ia=X<<2;g=v[ia+_>>2];sb:{if((g|0)<0){break sb}X=w[X+aa|0];ja=X&4?-1:1;X=X&16?0-ja|0:ja;if(A[ba+(m<<3)>>3]*+((v[ga+(v[ha+ia>>2]<<2)>>2]==-1?0-X|0:X)|0)>0){h=g;if((i|0)<0){break sb}break rb}i=g;if((h|0)>=0){break rb}}m=m+1|0;if(($|0)!=(m|0)){continue}break}}v[fa>>2]=h;v[G+N>>2]=i}g=h;h=(U|0)==2&(h|0)==(z|0);m=h?i:g;if((m|0)<0){break nb}i=h?z:i;if((i|0)<0){break nb}v[E+(u<<2)>>2]=Z;tb:{if((m|0)!=(z|0)){h=m<<2;i=h+K|0;g=v[i>>2]+1|0;v[i>>2]=g;h=v[h+J>>2];break tb}g=i<<2;m=g+J|0;h=v[m>>2]+1|0;v[m>>2]=h;g=v[g+K>>2];m=i}u=u+1|0;if((g+h|0)!=1){break nb}v[O+(p<<2)>>2]=m;p=p+1|0}n=n+1|0;if((S|0)!=(n|0)){continue}break}}y=y+1|0;if((F|0)>(y|0)){continue}}ub:{vb:{O=(p|0)<=0;wb:{if(O){G=0;break wb}N=0;G=1;J=v[q+132>>2];Z=v[q+124>>2];xb:{while(1){yb:{K=v[Z+(N<<2)>>2];fa=K<<2;zb:{if((Q|0)>v[fa+J>>2]){break zb}h=Pda(s,K,z,q+116|0);if((h|0)!=1){break yb}if((u|0)<=0){break zb}S=v[s+96>>2];$=v[s+92>>2];_=v[s+76>>2];ha=v[s+64>>2];ga=v[s+52>>2];aa=v[s>>2];n=0;ba=v[q+116>>2];while(1){ea=E+(n<<2)|0;X=v[ea>>2]<<2;i=v[X+o>>2];T=v[i+224>>2]<<2;ia=T+$|0;h=v[ia>>2];Ab:{if((h|0)>=-1){g=v[T+S>>2];break Ab}h=-1;ja=v[i+216>>2];Bb:{if((ja|0)<=0){g=-1;break Bb}ca=v[i+172>>2];na=v[i+168>>2];m=0;g=-1;while(1){W=v[v[na+(m<<2)>>2]+232>>2];oa=W<<2;i=v[oa+_>>2];Cb:{if((i|0)<0){break Cb}W=w[W+aa|0];pa=W&4?-1:1;W=W&16?0-pa|0:pa;if(A[ca+(m<<3)>>3]*+((v[ga+(v[ha+oa>>2]<<2)>>2]==-1?0-W|0:W)|0)>0){h=i;if((g|0)<0){break Cb}break Bb}g=i;if((h|0)>=0){break Bb}}m=m+1|0;if((ja|0)!=(m|0)){continue}break}}v[ia>>2]=h;v[T+S>>2]=g}if(!(!((U|0)==2&(g|0)==(K|0))&(h|0)!=(K|0))){v[H+X>>2]=ba;v[ea>>2]=v[V+(u<<2)>>2];u=u-1|0;n=n-1|0}n=n+1|0;if((n|0)<(u|0)){continue}break}}Db:{if((Q|0)>v[fa+v[q+128>>2]>>2]){break Db}h=Pda(s,z,K,q+116|0);if((h|0)!=1){break vb}if((u|0)<=0){break Db}G=v[s+96>>2];T=v[s+92>>2];fa=v[s+76>>2];$=v[s+64>>2];_=v[s+52>>2];ha=v[s>>2];n=0;ga=v[q+116>>2];while(1){aa=E+(n<<2)|0;ba=v[aa>>2]<<2;h=v[ba+o>>2];S=v[h+224>>2]<<2;ea=S+T|0;Eb:{if(v[ea>>2]>=-1){i=v[G+S>>2];break Eb}g=-1;X=v[h+216>>2];Fb:{if((X|0)<=0){i=-1;break Fb}ia=v[h+172>>2];ja=v[h+168>>2];m=0;i=-1;while(1){ca=v[v[ja+(m<<2)>>2]+232>>2];na=ca<<2;h=v[na+fa>>2];Gb:{if((h|0)<0){break Gb}ca=w[ca+ha|0];W=ca&4?-1:1;ca=ca&16?0-W|0:W;if(A[ia+(m<<3)>>3]*+((v[_+(v[$+na>>2]<<2)>>2]==-1?0-ca|0:ca)|0)>0){g=h;if((i|0)<0){break Gb}break Fb}i=h;if((g|0)>=0){break Fb}}m=m+1|0;if((X|0)!=(m|0)){continue}break}}v[ea>>2]=g;v[G+S>>2]=i}if((i|0)==(K|0)){v[H+ba>>2]=ga;v[aa>>2]=v[V+(u<<2)>>2];u=u-1|0;n=n-1|0}n=n+1|0;if((n|0)<(u|0)){continue}break}}N=N+1|0;G=(N|0)<(p|0);if((p|0)!=(N|0)){continue}break xb}break}Eb(157734,3334);v[q+112>>2]=h;Fb(276579,q+112|0);k=h;break hb}if(O){break wb}h=0;i=v[q+128>>2];m=0;if(p>>>0>=4){K=p&2147483644;n=0;while(1){g=m<<2;v[g+J>>2]=0;v[g+i>>2]=0;N=g|4;v[N+J>>2]=0;v[i+N>>2]=0;N=g|8;v[N+J>>2]=0;v[i+N>>2]=0;g=g|12;v[g+J>>2]=0;v[g+i>>2]=0;m=m+4|0;n=n+4|0;if((K|0)!=(n|0)){continue}break}}g=p&3;if(!g){break wb}while(1){n=m<<2;v[n+J>>2]=0;v[i+n>>2]=0;m=m+1|0;h=h+1|0;if((g|0)!=(h|0)){continue}break}}Hb:{if((u|0)<=0){break Hb}g=0;m=0;if(u>>>0>=4){n=u&2147483644;h=0;while(1){i=E+(m<<2)|0;v[H+(v[i>>2]<<2)>>2]=-2;v[H+(v[i+4>>2]<<2)>>2]=-2;v[H+(v[i+8>>2]<<2)>>2]=-2;v[H+(v[i+12>>2]<<2)>>2]=-2;m=m+4|0;h=h+4|0;if((n|0)!=(h|0)){continue}break}}h=u&3;if(!h){break Hb}while(1){v[H+(v[E+(m<<2)>>2]<<2)>>2]=-2;m=m+1|0;g=g+1|0;if((h|0)!=(g|0)){continue}break}}p=0;u=0;if(!G){break ub}break hb}Eb(157734,3371);v[q+96>>2]=h;Fb(276579,q+96|0);k=h;if(G){break hb}}z=z+1|0;if((y|0)<(F|0)){continue}break}break ib}Eb(157734,3162);k=-1;v[q+80>>2]=-1;Fb(276579,q+80|0);break hb}Hb(v[v[a>>2]+8>>2],q+120|0,157700,3428);Hb(v[v[a>>2]+8>>2],q+124|0,157700,3429);Hb(v[v[a>>2]+8>>2],q+128|0,157700,3430);Hb(v[v[a>>2]+8>>2],q+132|0,157700,3431);Hb(v[v[a>>2]+8>>2],q+136|0,157700,3432);Hb(v[v[a>>2]+8>>2],q+140|0,157700,3433);k=1}ub=q+144|0;h=k;if((h|0)!=1){Eb(157734,4424);v[j+448>>2]=h;Fb(276579,j+448|0);break b}s=Ib(v[v[a>>2]+8>>2],v[j+728>>2],4,157700,4433);v[j+780>>2]=s;if(!s){Eb(157734,4433);h=-1;v[j+352>>2]=-1;Fb(276579,j+352|0);break b}u=Ib(v[v[a>>2]+8>>2],v[j+728>>2],4,157700,4434);v[j+772>>2]=u;if(!u){Eb(157734,4434);h=-1;v[j+368>>2]=-1;Fb(276579,j+368|0);break b}h=Ib(v[v[a>>2]+8>>2],v[j+724>>2],4,157700,4435);v[j+768>>2]=h;if(!h){Eb(157734,4435);h=-1;v[j+384>>2]=-1;Fb(276579,j+384|0);break b}dc(s,v[j+728>>2]<<2);h=Ib(v[v[a>>2]+8>>2],v[j+728>>2],4,157700,4439);v[j+776>>2]=h;if(!h){break f}g=0;Ib:{if(v[j+728>>2]<=0){break Ib}while(1){v[h+(g<<2)>>2]=-1;g=g+1|0;i=v[j+728>>2];if((g|0)<(i|0)){continue}break}y=0;if((i|0)<=0){break Ib}k=3;m=0;while(1){Jb:{if(v[s+(m<<2)>>2]==2){break Jb}o=v[j+768>>2];i=ub-16|0;ub=i;F=v[j+712>>2];H=v[j+708>>2];z=v[j+704>>2];L=v[j+700>>2];E=v[j+688>>2];C=v[j+684>>2];h=v[j+728>>2];v[j+580>>2]=0;v[j+576>>2]=0;n=Ib(v[v[a>>2]+8>>2],h,4,157700,4144);v[i+12>>2]=n;Kb:{if(!n){Eb(157734,4144);v[i>>2]=-1;Fb(276579,i);h=-1;break Kb}v[n>>2]=m;v[s+(m<<2)>>2]=1;G=n-4|0;h=1;while(1){g=v[G+(h<<2)>>2];l=g<<2;v[l+s>>2]=2;v[u+(v[j+580>>2]<<2)>>2]=g;v[j+580>>2]=v[j+580>>2]+1;h=h-1|0;g=v[l+L>>2];if((g|0)!=-1){while(1){J=g<<2;q=v[J+E>>2];Lb:{if((q|0)!=-1){p=s+(q<<2)|0;if(v[p>>2]==2){break Lb}v[o+(v[j+576>>2]<<2)>>2]=g;v[j+576>>2]=v[j+576>>2]+1;if(v[p>>2]){break Lb}v[n+(h<<2)>>2]=q;v[p>>2]=1;h=h+1|0;break Lb}v[o+(v[j+576>>2]<<2)>>2]=g;v[j+576>>2]=v[j+576>>2]+1}g=v[H+J>>2];if((g|0)!=-1){continue}break}}g=v[l+z>>2];if((g|0)!=-1){while(1){p=g<<2;l=v[p+C>>2];Mb:{if((l|0)!=-1){q=s+(l<<2)|0;if(v[q>>2]==2){break Mb}v[o+(v[j+576>>2]<<2)>>2]=g;v[j+576>>2]=v[j+576>>2]+1;if(v[q>>2]){break Mb}v[n+(h<<2)>>2]=l;v[q>>2]=1;h=h+1|0;break Mb}v[o+(v[j+576>>2]<<2)>>2]=g;v[j+576>>2]=v[j+576>>2]+1}g=v[p+F>>2];if((g|0)!=-1){continue}break}}if((h|0)>0){continue}break}Hb(v[v[a>>2]+8>>2],i+12|0,157700,4234);h=1}ub=i+16|0;if((h|0)!=1){Eb(157734,4455);v[j+432>>2]=h;Fb(276579,j+432|0);break b}i=v[j+580>>2];if((i|0)<(k|0)){break Jb}l=v[j+576>>2];if((l|0)<3){break Jb}Nb:{Ob:{Pb:{Qb:{if(v[R+4>>2]!=(y|0)){break Qb}z=4472;h=y<<1;y=(h|0)>(y|0)?h:y+1|0;h=Sc(v[R>>2],y,4,157700,4472);v[R>>2]=h;if(h){break Qb}h=-1;break Pb}g=ub-16|0;ub=g;h=Vb(v[v[a>>2]+4>>2],52,157700,311);v[j+572>>2]=h;Rb:{if(!h){Eb(157734,311);v[g>>2]=-1;Fb(276579,g);h=-1;break Rb}v[h>>2]=0;v[v[j+572>>2]+4>>2]=0;v[v[j+572>>2]+8>>2]=0;v[v[j+572>>2]+12>>2]=0;v[v[j+572>>2]+16>>2]=0;v[v[j+572>>2]+20>>2]=0;v[v[j+572>>2]+24>>2]=0;v[v[j+572>>2]+28>>2]=0;h=v[j+572>>2];v[h+32>>2]=0;v[h+36>>2]=0;v[h+40>>2]=0;v[h+44>>2]=0;h=1}ub=g+16|0;if((h|0)!=1){z=4477;break Pb}n=v[j+572>>2];o=v[j+776>>2];h=i;K=v[j+768>>2];p=0;q=0;i=ub-288|0;ub=i;J=v[j+760>>2];N=v[j+744>>2];E=v[j+676>>2];C=v[j+664>>2];L=v[j+660>>2];U=v[j+652>>2];H=v[j+624>>2];G=v[j+620>>2];Q=v[j+612>>2];V=v[j+604>>2];S=v[j+600>>2];g=v[j+644>>2];z=Ib(v[v[a>>2]+8>>2],g,8,157700,431);v[i+284>>2]=z;Sb:{if(!z){Eb(157734,431);g=-1;v[i>>2]=-1;Fb(276579,i);break Sb}F=Ib(v[v[a>>2]+8>>2],g,4,157700,432);v[i+264>>2]=F;if(!F){Eb(157734,432);g=-1;v[i+16>>2]=-1;Fb(276579,i+16|0);break Sb}dc(z,g<<3);if((g|0)>0){Wb(F,255,g<<2)}g=ug(a,i+280|0,i+272|0);if((g|0)!=1){Eb(157734,442);v[i+256>>2]=g;Fb(276579,i+256|0);break Sb}Tb:{g=xl(a,i+276|0,i+268|0);if((g|0)==1){Ub:{if((h|0)<=0){break Ub}g=0;if(h>>>0>=4){T=h&2147483644;while(1){v[o+(v[u+(g<<2)>>2]<<2)>>2]=g;O=g|1;v[o+(v[u+(O<<2)>>2]<<2)>>2]=O;O=g|2;v[o+(v[u+(O<<2)>>2]<<2)>>2]=O;O=g|3;v[o+(v[u+(O<<2)>>2]<<2)>>2]=O;g=g+4|0;q=q+4|0;if((T|0)!=(q|0)){continue}break}}q=h&3;if(!q){break Ub}while(1){v[o+(v[u+(g<<2)>>2]<<2)>>2]=g;g=g+1|0;p=p+1|0;if((q|0)!=(p|0)){continue}break}}p=0;if((H|0)>0){g=0;while(1){q=v[G+(g<<2)>>2]<<2;T=v[q+E>>2];Vb:{if((T|v[o+(T<<2)>>2])<0){break Vb}q=F+(v[q+C>>2]<<2)|0;if(v[q>>2]!=-1){break Vb}v[q>>2]=p;p=p+1|0}g=g+1|0;if((H|0)!=(g|0)){continue}break}}v[n+44>>2]=p;v[n+40>>2]=0;v[n+36>>2]=l;v[n+32>>2]=h;v[n+48>>2]=J;g=Tb(v[v[a>>2]+4>>2],v[n+32>>2],4,157700,487);v[n>>2]=g;if(!g){Eb(157734,487);g=-1;v[i+32>>2]=-1;Fb(276579,i+32|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+32>>2],4,157700,488);v[n+4>>2]=g;if(!g){Eb(157734,488);g=-1;v[i+48>>2]=-1;Fb(276579,i+48|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+32>>2],4,157700,489);v[n+8>>2]=g;Wb:{Xb:{if(g){p=0;if(v[n+32>>2]>0){while(1){g=Tb(v[v[a>>2]+4>>2],v[n+44>>2],4,157700,492);l=p<<2;v[l+v[n>>2]>>2]=g;if(!g){Eb(157734,492);g=-1;v[i+80>>2]=-1;Fb(276579,i+80|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+44>>2],8,157700,493);v[l+v[n+4>>2]>>2]=g;if(!g){Eb(157734,493);g=-1;v[i+96>>2]=-1;Fb(276579,i+96|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+44>>2],4,157700,494);v[l+v[n+8>>2]>>2]=g;if(!g){break Xb}g=0;if(v[n+44>>2]>0){while(1){q=g<<2;v[q+v[l+v[n>>2]>>2]>>2]=0;J=v[l+v[n+4>>2]>>2]+(g<<3)|0;v[J>>2]=0;v[J+4>>2]=0;v[q+v[l+v[n+8>>2]>>2]>>2]=0;g=g+1|0;if((g|0)<v[n+44>>2]){continue}break}}p=p+1|0;if((p|0)<v[n+32>>2]){continue}break}}g=Tb(v[v[a>>2]+4>>2],v[n+36>>2],4,157700,503);v[n+12>>2]=g;if(!g){Eb(157734,503);g=-1;v[i+128>>2]=-1;Fb(276579,i+128|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+36>>2],8,157700,504);v[n+16>>2]=g;if(!g){Eb(157734,504);g=-1;v[i+144>>2]=-1;Fb(276579,i+144|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+36>>2],4,157700,505);v[n+20>>2]=g;if(!g){Eb(157734,505);g=-1;v[i+160>>2]=-1;Fb(276579,i+160|0);break Sb}g=Tb(v[v[a>>2]+4>>2],v[n+36>>2],4,157700,506);v[n+24>>2]=g;if(!g){Eb(157734,506);g=-1;v[i+176>>2]=-1;Fb(276579,i+176|0);break Sb}g=vd(v[i+268>>2],4,157700,507);v[n+28>>2]=g;if(!g){break Wb}p=v[n+36>>2];if((p|0)>0){l=v[n+24>>2];q=v[n+20>>2];g=0;while(1){p=g<<2;v[p+q>>2]=-1;v[l+p>>2]=-1;g=g+1|0;p=v[n+36>>2];if((g|0)<(p|0)){continue}break}}dc(v[n+12>>2],p<<2);dc(v[n+16>>2],v[n+36>>2]<<3);dc(v[n+28>>2],v[n+44>>2]<<2);p=0;if((H|0)>0){while(1){l=v[G+(p<<2)>>2];g=l<<2;q=v[g+E>>2];Yb:{if((q|0)<0){break Yb}J=v[o+(q<<2)>>2];if((J|0)<0){break Yb}T=v[g+C>>2]<<2;q=v[T+F>>2];O=v[g+v[i+280>>2]>>2];v[O+228>>2]=v[O+228>>2]+1;O=q<<2;J=J<<2;v[O+v[J+v[n>>2]>>2]>>2]=v[g+v[i+280>>2]>>2];r=A[V+(l<<3)>>3];g=l+S|0;r=w[g|0]&4?-r:r;A[v[J+v[n+4>>2]>>2]+(q<<3)>>3]=v[T+U>>2]==-1?-r:r;v[O+v[J+v[n+8>>2]>>2]>>2]=w[g|0]>>>4&1}p=p+1|0;if((H|0)!=(p|0)){continue}break}}if(v[n+36>>2]<=0){break Tb}p=0;while(1){q=p<<2;H=v[q+K>>2]<<2;l=v[H+N>>2];E=p<<3;g=E+v[n+16>>2]|0;v[g>>2]=0;v[g+4>>2]=1072693248;Zb:{if(l){U=v[l+232>>2];v[l+228>>2]=v[l+228>>2]+1;v[q+v[n+12>>2]>>2]=l;C=v[l+188>>2];G=v[l+180>>2];g=0;J=v[l+220>>2];V=(J|0)<=0;_b:{if(V){break _b}while(1){$b:{l=v[L+(v[v[G+(g<<2)>>2]+224>>2]<<2)>>2];if((l|0)<0){break $b}r=A[z+(l<<3)>>3];if(r==0){break $b}A[E+v[n+16>>2]>>3]=r/A[C+(g<<3)>>3];break _b}g=g+1|0;if((J|0)!=(g|0)){continue}break}}l=E+v[n+16>>2]|0;r=A[l>>3];r=r>=0?r:-r;A[l>>3]=r;if(w[Q+U|0]&4){A[l>>3]=-r}g=0;if(V){break Zb}while(1){E=v[L+(v[v[G+(g<<2)>>2]+224>>2]<<2)>>2];ac:{if((E|0)<0){break ac}E=z+(E<<3)|0;if(A[E>>3]!=0){break ac}A[E>>3]=A[l>>3]*A[C+(g<<3)>>3]}g=g+1|0;if((J|0)!=(g|0)){continue}break}break Zb}v[q+v[n+12>>2]>>2]=0;v[n+40>>2]=v[n+40>>2]+1}g=v[H+v[j+684>>2]>>2];if((g|0)>=0){v[q+v[n+20>>2]>>2]=v[o+(g<<2)>>2]}g=v[H+v[j+688>>2]>>2];if((g|0)>=0){v[q+v[n+24>>2]>>2]=v[o+(g<<2)>>2]}p=p+1|0;if((p|0)<v[n+36>>2]){continue}break}break Tb}Eb(157734,489);g=-1;v[i+64>>2]=-1;Fb(276579,i- -64|0);break Sb}Eb(157734,494);g=-1;v[i+112>>2]=-1;Fb(276579,i+112|0);break Sb}Eb(157734,507);g=-1;v[i+192>>2]=-1;Fb(276579,i+192|0);break Sb}Eb(157734,443);v[i+240>>2]=g;Fb(276579,i+240|0);break Sb}if(v[i+268>>2]>0){q=v[n+28>>2];l=0;while(1){p=l<<2;g=v[p+L>>2];if((g|0)<0){g=-1}else{g=v[F+(g<<2)>>2]}v[p+q>>2]=g;l=l+1|0;if((l|0)<v[i+268>>2]){continue}break}}g=1;bc:{if((h|0)<=0){break bc}p=0;l=0;if(h>>>0>=4){H=h&2147483644;q=0;while(1){F=u+(l<<2)|0;v[o+(v[F>>2]<<2)>>2]=-1;v[o+(v[F+4>>2]<<2)>>2]=-1;v[o+(v[F+8>>2]<<2)>>2]=-1;v[o+(v[F+12>>2]<<2)>>2]=-1;l=l+4|0;q=q+4|0;if((H|0)!=(q|0)){continue}break}}h=h&3;if(!h){break bc}while(1){v[o+(v[u+(l<<2)>>2]<<2)>>2]=-1;l=l+1|0;p=p+1|0;if((h|0)!=(p|0)){continue}break}}Hb(v[v[a>>2]+8>>2],i+264|0,157700,667);Hb(v[v[a>>2]+8>>2],i+284|0,157700,668)}ub=i+288|0;h=g;if((g|0)!=1){z=4480;break Pb}h=v[R+4>>2];if((h|0)<=0){v[v[R>>2]+(h<<2)>>2]=n;h=h+1|0;break Nb}i=v[n+32>>2];g=h;cc:{while(1){z=v[R>>2];o=z+(g<<2)|0;l=v[o-4>>2];if((i|0)<=v[l+32>>2]){break cc}v[o>>2]=l;o=(g|0)>1;g=g-1|0;if(o){continue}break}z=v[R>>2];g=0}v[(g<<2)+z>>2]=n;i=h+1|0;v[R+4>>2]=i;if((h|0)<3){break Jb}g=v[R>>2];n=v[v[g+(h<<2)>>2]+32>>2];k=(k|0)>(n|0)?k:n;if((h|0)==3){break Jb}h=Sda(a,(g+(i<<2)|0)-4|0);if((h|0)==1){break Ob}z=4498}Eb(157734,z);v[j+416>>2]=h;Fb(276579,j+416|0);break b}h=v[R+4>>2]-1|0}v[R+4>>2]=h}m=m+1|0;if((m|0)<v[j+728>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],j+776|0,157700,4510);Hb(v[v[a>>2]+8>>2],j+768|0,157700,4511);Hb(v[v[a>>2]+8>>2],j+772|0,157700,4512);Hb(v[v[a>>2]+8>>2],j+780|0,157700,4513)}kc(j+684|0,157700,4517);kc(j+688|0,157700,4518);kc(j+692|0,157700,4519);kc(j+696|0,157700,4520);kc(j+700|0,157700,4521);kc(j+704|0,157700,4522);kc(j+708|0,157700,4523);kc(j+712|0,157700,4524);kc(j+756|0,157700,4525);kc(sa,157700,4526);kc(ta,157700,4527);kc(j+676|0,157700,4528);kc(j+672|0,157700,4529);kc(j+668|0,157700,4530);kc(j+716|0,157700,4531);kc(j+664|0,157700,4532);kc(j+660|0,157700,4533);kc(j+652|0,157700,4534);kc(j+640|0,157700,4535);kc(j+636|0,157700,4536);kc(j+628|0,157700,4537);kc(j+620|0,157700,4538);kc(j+616|0,157700,4539);kc(j+612|0,157700,4540);kc(j+608|0,157700,4541);h=j+600|0;kc(h|4,157700,4542);kc(h,157700,4543);u=v[R+4>>2]}h=1;if(!v[R+92>>2]|(u|0)<=0){break a}C=v[R>>2];v[f>>2]=3;v[R+88>>2]=0;if(v[j+564>>2]){break a}y=0;while(1){n=v[C+(y<<2)>>2];dc:{if(+v[n+36>>2]/+v[n+32>>2]>100){break dc}ec:{fc:{gc:{hc:{if(v[R+76>>2]){h=Rda(a,b,R,c,d,e,n,0,j+568|0,j+564|0);i=6750;if((h|0)!=1){break hc}if(v[j+564>>2]){break fc}}k=v[R+8>>2];m=v[R+92>>2];g=5276;i=vg(v[v[a>>2]+8>>2],20,157700,5276);v[j+768>>2]=i;h=-1;ic:{if(!i){break ic}g=5277;i=Ib(v[v[a>>2]+8>>2],v[n+32>>2],4,157700,5277);v[v[j+768>>2]>>2]=i;if(!i){break ic}g=5278;i=Ib(v[v[a>>2]+8>>2],v[n+32>>2],4,157700,5278);v[v[j+768>>2]+4>>2]=i;if(!i){break ic}g=5279;i=Ib(v[v[a>>2]+8>>2],v[n+32>>2],4,157700,5279);v[v[j+768>>2]+8>>2]=i;if(!i){break ic}g=5280;q=k<<((m|0)!=1);i=Ib(v[v[a>>2]+8>>2],q+1|0,4,157700,5280);k=v[j+768>>2];v[k+12>>2]=i;if(!i){break ic}v[k+16>>2]=0;m=v[n+32>>2];jc:{if((m|0)<=0){break jc}i=v[k>>2];k=0;g=0;if(m>>>0>=8){o=m&2147483640;p=0;while(1){v[i+(g<<2)>>2]=g;l=g|1;v[i+(l<<2)>>2]=l;l=g|2;v[i+(l<<2)>>2]=l;l=g|3;v[i+(l<<2)>>2]=l;l=g|4;v[i+(l<<2)>>2]=l;l=g|5;v[i+(l<<2)>>2]=l;l=g|6;v[i+(l<<2)>>2]=l;l=g|7;v[i+(l<<2)>>2]=l;g=g+8|0;p=p+8|0;if((o|0)!=(p|0)){continue}break}}m=m&7;if(!m){break jc}while(1){v[i+(g<<2)>>2]=g;g=g+1|0;k=k+1|0;if((m|0)!=(k|0)){continue}break}}L=v[n+4>>2];E=v[n>>2];F=v[n+44>>2];o=vg(v[v[a>>2]+8>>2],8,157700,4926);v[j+776>>2]=o;kc:{lc:{mc:{nc:{oc:{if(!o){Eb(157734,4926);v[j+80>>2]=-1;Fb(276579,j+80|0);break oc}i=v[n+36>>2];i=Bf(j+780|0,v[v[a>>2]+4>>2],(i|0)<=500?500:i,1957,1958,1959,n);if((i|0)!=1){Eb(157734,4934);v[j+160>>2]=i;Fb(276579,j+160|0);g=5287;h=i;break ic}i=Ib(v[v[a>>2]+8>>2],v[n+36>>2],16,157700,4937);v[o+4>>2]=i;if(i){H=o+4|0;if(v[n+36>>2]<=0){cf(j+780|0);s=0;break mc}k=0;s=0;while(1){l=k<<2;p=v[l+v[n+12>>2]>>2];g=v[l+v[n+20>>2]>>2];i=l+v[n+24>>2]|0;pc:{if((g|0)<=v[i>>2]){v[j+600>>2]=g;m=v[i>>2];v[j+604>>2]=m;break pc}v[j+604>>2]=g;i=v[i>>2];v[j+600>>2]=i;m=g;g=i}qc:{if((g|0)==-1|(m|0)==-1){break qc}rc:{if(p){x=0;r=KF(a,p);M=r>=0?r:0;i=v[l+v[n+12>>2]>>2];if(v[i+232>>2]>=0){x=A[i+80>>3]}P=hs(a,i);r=A[v[n+16>>2]+(k<<3)>>3];r=(r>=0?r:-r)/P;r=r*M+(x>=0?-x:x)/r;break rc}r=A[v[a+4>>2]+1272>>3]}A[j+608>>3]=r;i=sc(v[j+780>>2],j+600|0);if(i){r=A[j+608>>3];x=A[i+8>>3];A[i+8>>3]=r<=x?r:x;break qc}g=v[j+604>>2];i=v[H>>2]+(s<<4)|0;v[i>>2]=v[j+600>>2];v[i+4>>2]=g;g=v[j+612>>2];v[i+8>>2]=v[j+608>>2];v[i+12>>2]=g;i=ee(v[j+780>>2],i);if((i|0)!=1){break nc}s=s+1|0}k=k+1|0;if((k|0)<v[n+36>>2]){continue}break}cf(j+780|0);if((s|0)<=0){break mc}z=v[H>>2];Y=A[v[a+4>>2]+1272>>3];sc:{if((s|0)==1){g=0;M=-1;r=1;break sc}i=s&2147483646;g=0;M=-1;r=1;k=0;while(1){m=z+(g<<4)|0;x=A[m+8>>3];M=x>=M?M:x;P=A[m+24>>3];M=P>=M?M:P;r=x>=Y?r:r>=x?r:x;r=P>=Y?r:r>=P?r:P;g=g+2|0;k=k+2|0;if((i|0)!=(k|0)){continue}break}}if(s&1){x=A[(z+(g<<4)|0)+8>>3];M=x>=M?M:x;r=x>=Y?r:r>=x?r:x}k=ws(o,s,2,1960,0);if((k|0)!=1){break lc}l=0;while(1){G=l<<4;i=G+z|0;tc:{uc:{vc:{if((F|0)>0){m=v[i+4>>2];g=v[i>>2]<<2;J=g+L|0;K=v[g+E>>2];g=0;p=1;while(1){wc:{k=v[K+(g<<2)>>2];if(k){if(!(A[v[a+4>>2]+1280>>3]>=D(A[k+(A[v[J>>2]+(g<<3)>>3]>0?16:8)>>3]-A[k>>3]))){break wc}}g=g+1|0;p=(F|0)>(g|0);if((g|0)!=(F|0)){continue}}break}g=m<<2;J=g+L|0;K=v[g+E>>2];g=0;m=1;xc:{while(1){k=v[K+(g<<2)>>2];if(k){x=A[v[a+4>>2]+1280>>3];if(!(x>=D(A[k+(A[v[J>>2]+(g<<3)>>3]>0?16:8)>>3]-A[k>>3]))){break xc}}g=g+1|0;m=(F|0)>(g|0);if((g|0)!=(F|0)){continue}break}x=A[v[a+4>>2]+1280>>3]}g=i+8|0;k=m&p;P=A[i+8>>3];if(!(P>x)){break vc}x=r;if(!(k&1)){break uc}break tc}P=A[i+8>>3];if(!(P>A[v[a+4>>2]+1280>>3])){break tc}g=i+8|0;x=r;break uc}x=M;if(!(k&1)){break tc}}A[g>>3]=P+x}i=op(v[o>>2],G+v[o+4>>2]|0);if((i|0)==1){l=l+1|0;if((s|0)==(l|0)){break kc}continue}break}Eb(157734,5182);v[j+112>>2]=i;Fb(276579,j+112|0);g=5287;h=i;break ic}Eb(157734,4937);v[j+96>>2]=-1;Fb(276579,j+96|0)}g=5287;break ic}Eb(157734,5065);v[j+144>>2]=i;Fb(276579,j+144|0);g=5287;h=i;break ic}k=ws(o,s,2,1960,0);if((k|0)==1){break kc}}Eb(157734,5100);v[j+128>>2]=k;Fb(276579,j+128|0);g=5287;h=k;break ic}s=v[n+32>>2];g=(q|0)<(s|0);i=v[o>>2];if(v[i+20>>2]){i=v[v[i+16>>2]>>2]}else{i=0}yc:{if(!i|(q|0)>=(s|0)){break yc}while(1){g=mu(v[o>>2]);i=v[g+4>>2];k=v[g>>2];g=v[v[j+768>>2]>>2];p=(k<<2)+g|0;m=v[p>>2];if((k|0)!=(m|0)){while(1){k=v[g+(m<<2)>>2];v[p>>2]=k;p=g+(k<<2)|0;m=v[p>>2];if((m|0)!=(k|0)){continue}break}}p=g+(i<<2)|0;m=v[p>>2];if((m|0)!=(i|0)){while(1){i=v[g+(m<<2)>>2];v[p>>2]=i;p=g+(i<<2)|0;m=v[p>>2];if((m|0)!=(i|0)){continue}break}}if((i|0)!=(k|0)){v[g+(((i|0)<(k|0)?k:i)<<2)>>2]=(i|0)>(k|0)?k:i;s=s-1|0}g=(q|0)<(s|0);i=v[o>>2];if(v[i+20>>2]){i=v[v[i+16>>2]>>2]}else{i=0}if(!i){break yc}if(g){continue}break}}zc:{if(!g|v[n+32>>2]<2|(q|0)>=(s|0)){break zc}i=v[v[j+768>>2]>>2];m=1;while(1){g=m;k=i+(g<<2)|0;p=v[k>>2];Ac:{if((g|0)!=(p|0)){while(1){g=v[i+(p<<2)>>2];v[k>>2]=g;k=i+(g<<2)|0;p=v[k>>2];if((p|0)!=(g|0)){continue}break}if(!g){break Ac}}v[i+(((g|0)>0?g:0)<<2)>>2]=g>>31&g;s=s-1|0}m=m+1|0;if((m|0)>=v[n+32>>2]){break zc}if((q|0)<(s|0)){continue}break}}g=5348;s=Ib(v[v[a>>2]+8>>2],q,4,157700,5348);v[j+772>>2]=s;if(!s){break ic}dc(s,q<<2);l=v[j+768>>2];k=v[n+32>>2];if((k|0)>0){m=v[l+4>>2];i=v[l>>2];h=0;while(1){Bc:{Cc:{q=h<<2;k=q+i|0;p=v[k>>2];if((p|0)!=(h|0)){while(1){g=v[i+(p<<2)>>2];v[k>>2]=g;F=g<<2;k=F+i|0;p=v[k>>2];if((g|0)!=(p|0)){continue}break}if((g|0)!=(h|0)){break Cc}}g=v[l+16>>2];v[l+16>>2]=g+1;break Bc}g=v[m+F>>2]}v[m+q>>2]=g;g=s+(g<<2)|0;v[g>>2]=v[g>>2]+1;h=h+1|0;k=v[n+32>>2];if((h|0)<(k|0)){continue}break}}g=0;h=v[l+12>>2];i=0;m=v[l+16>>2];if((m|0)>0){while(1){k=g<<2;v[k+h>>2]=i;i=v[k+s>>2]+i|0;g=g+1|0;m=v[l+16>>2];if((g|0)<(m|0)){continue}break}k=v[n+32>>2]}v[h+(m<<2)>>2]=k;dc(s,v[l+16>>2]<<2);if(v[n+32>>2]>0){h=v[j+768>>2];i=v[h+8>>2];k=v[h+12>>2];m=v[h+4>>2];g=0;while(1){l=v[m+(g<<2)>>2]<<2;h=l+s|0;v[(i+(v[k+l>>2]<<2)|0)+(v[h>>2]<<2)>>2]=g;v[h>>2]=v[h>>2]+1;g=g+1|0;if((g|0)<v[n+32>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],j+772|0,157700,5395);nu(o);Hb(v[v[a>>2]+8>>2],H,157700,5200);Hb(v[v[a>>2]+8>>2],j+776|0,157700,5201);h=Rda(a,b,R,c,d,e,n,v[j+768>>2],j+568|0,j+564|0);if((h|0)==1){break gc}i=6763;break hc}Eb(157734,g);v[j+64>>2]=h;Fb(276579,j- -64|0);i=6757}Eb(157734,i);v[j+48>>2]=h;Fb(276579,j+48|0);break a}Hb(v[v[a>>2]+8>>2],v[j+768>>2]+12|0,157700,5413);Hb(v[v[a>>2]+8>>2],v[j+768>>2]+8|0,157700,5414);Hb(v[v[a>>2]+8>>2],v[j+768>>2]+4|0,157700,5415);Hb(v[v[a>>2]+8>>2],v[j+768>>2],157700,5416);Hb(v[v[a>>2]+8>>2],j+768|0,157700,5417);if(!v[j+564>>2]){break ec}}v[f>>2]=7;h=1;v[R+88>>2]=1;break a}if(v[j+568>>2]<=0){break dc}v[f>>2]=8;v[R+88>>2]=1}h=1;y=y+1|0;if((y|0)<(u|0)){continue}break}break a}Eb(157734,4439);h=-1;v[j+400>>2]=-1;Fb(276579,j+400|0);break b}Eb(157734,g);v[j+336>>2]=h;Fb(276579,j+336|0);Eb(157734,4385);v[j+320>>2]=h;Fb(276579,j+320|0);break b}Eb(157734,1124);v[j+304>>2]=o;Fb(285563,j+304|0);h=-9}Eb(157734,4373);v[j+208>>2]=h;Fb(276579,j+208|0)}Eb(157734,6695);v[j>>2]=h;Fb(276579,j)}ub=j+784|0;return h}function Vfb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,x=0,y=0,z=0,B=0;d=ub-288|0;ub=d;Wb(d+12|0,0,136);v[d+140>>2]=268435456;v[d+8>>2]=1;xK(15,d+8|0,d+148|0);ub=d+288|0;l=ub-16|0;ub=l;v[l+12>>2]=0;n=547;p=l+12|0;d=Gf(p);a:{b:{if((d|0)!=1){break b}n=553;d=eo(v[l+12>>2]);if((d|0)!=1){break b}o=1;n=559;e=v[l+12>>2];g=ub-1568|0;ub=g;v[g+512>>2]=-1254536155;v[g+516>>2]=1413965963;v[g+504>>2]=-1254536155;v[g+508>>2]=1413965963;c:{d:{e:{f:{g:{d=a;if((d|0)>=3){if(Mb(v[b+8>>2],165654)){break g}b=v[b+4>>2];c=173;a=Qb(e,60734,109759,g+524|0,0,0,0);h:{if((a|0)!=1){break h}c=177;a=fs(e,118368,213686,0,0,365319);if((a|0)!=1){break h}W5(e);Kb(e,0,365309,0);U5(e);Kb(e,0,365309,0);i:{if(Xw(22246)){v[g+80>>2]=22246;Kb(e,0,308593,g+80|0);Kb(e,0,363938,0);c=191;a=Gw(e,22246);if((a|0)!=1){break h}c=192;a=zF(e,0,0,1);if((a|0)!=1){break h}Kb(e,0,365309,0);break i}v[g+64>>2]=22246;Kb(e,0,262621,g- -64|0)}c=201;a=z5(e,118368,g+1564|0);if((a|0)!=1){break h}a=v[g+1564>>2];if(w[a|0]){K5(e,a)}j:{k:{a=Pb(b);if(a>>>0<4){break k}if(Mb((a+b|0)-3|0,91096)){break k}a=63138;break j}a=91094}v[g+48>>2]=b;b=g+528|0;Jb(b,1024,a,g+48|0);v[g+32>>2]=b;Kb(e,0,307703,g+32|0);Kb(e,0,363953,0);c=216;a=dO(e,b,91097);if((a|0)!=1){break h}Kb(e,0,275996,0);Kb(e,0,363952,0);c=221;a=Me(e);if((a|0)!=1){break h}c=223;a=Bd(e,60734,g+524|0);if((a|0)!=1){break h}if(v[g+524>>2]){Kb(e,0,267142,0);Kb(e,0,363955,0);c=229;a=Kt(e,0);if((a|0)!=1){break h}}c=232;a=0;b=ub-176|0;ub=b;i=ub-16|0;ub=i;l:{m:{d=v[v[e+4>>2]>>2];if(d-2>>>0>=11){if((d|0)!=1){break m}d=v[v[e+28>>2]+60>>2];break l}d=v[v[e+84>>2]+60>>2];break l}Eb(160249,989);v[i>>2]=v[v[e+4>>2]>>2];Fb(314097,i);d=0}ub=i+16|0;n:{if(!d){Eb(71685,1429);Fb(326860,0);break n}t[v[d>>2]+v[d+4>>2]|0]=46;t[(v[d>>2]+v[d+4>>2]|0)+1|0]=115;t[(v[d>>2]+v[d+4>>2]|0)+2|0]=111;t[(v[d>>2]+v[d+4>>2]|0)+3|0]=108;t[(v[d>>2]+v[d+4>>2]|0)+4|0]=0;o:{f=Kf(v[d>>2],7448);p:{if(!f){Eb(71685,1442);v[b>>2]=v[d>>2];Fb(278351,b);t[v[d>>2]+v[d+4>>2]|0]=0;break p}t[v[d>>2]+v[d+4>>2]|0]=0;a=js(e,f);if((a|0)!=1){Eb(71685,1450);v[b+160>>2]=a;Fb(276579,b+160|0);break n}a=0;Kb(e,f,365308,0);v[b+144>>2]=v[d+44>>2];Kb(e,f,302394,b+144|0);if(v[d+44>>2]>0){i=d+8|0;while(1){v[b+128>>2]=v[i+(a<<2)>>2];Kb(e,f,302409,b+128|0);a=a+1|0;if((a|0)<v[d+44>>2]){continue}break}}h=Yc(e);q:{if(!(v[v[e+4>>2]>>2]==10?v[d+64>>2]:0)){a=v[d+60>>2];i=d+60|0;break q}a=v[d+60>>2];k=v[v[e+24>>2]+1380>>2];j=k?0:a;k=!k;i=d+60|0}v[b+116>>2]=j;v[b+112>>2]=a;Kb(e,f,302406,b+112|0);a=v[d+52>>2];v[b+96>>2]=a;v[b+100>>2]=h?a:0;Kb(e,f,302406,b+96|0);if(!(!k|v[i>>2]<=0)){j=0;while(1){a=v[v[d+56>>2]+(j<<2)>>2];if(w[a+85|0]&16){a=v[a+20>>2]}v[b+172>>2]=a;a=v[b+172>>2];if(a){k=v[v[e+28>>2]+156>>2];m=oJ(a);m=(k|0)==1?m:-m}else{m=0}A[b+64>>3]=m;Kb(e,f,279634,b- -64|0);j=j+1|0;if((j|0)<v[i>>2]){continue}break}}if(!(!h|v[d+52>>2]<=0)){a=0;while(1){A[b+48>>3]=Ob(e,Yc(e),v[v[d+48>>2]+(a<<2)>>2]);Kb(e,f,279634,b+48|0);a=a+1|0;if((a|0)<v[d+52>>2]){continue}break}}a=0;d=v[v[e+4>>2]>>2];d=!d|(d|0)==13?a:v[v[e+24>>2]+896>>2];if(d>>>0>=15){break o}a=1;if(!(31743>>>d&1)){break o}v[b+32>>2]=v[(d<<2)+369024>>2];Kb(e,f,302362,b+32|0);if(!Df(f)){break n}Eb(71685,1554);Fb(278465,0)}a=-3;break n}Eb(71685,1546);a=0;d=v[v[e+4>>2]>>2];v[b+16>>2]=!d|(d|0)==13?a:v[v[e+24>>2]+896>>2];Fb(314213,b+16|0);Df(f);a=-9}ub=b+176|0;if((a|0)==1){break d}}Eb(153888,c);v[g+16>>2]=a;Fb(276579,g+16|0);Eb(153888,272);v[g>>2]=a;Fb(276579,g);break c}if((d|0)==2){break g}break f}x=d-2|0;c=1;while(1){f=(c<<2)+b|0;a=v[f>>2];r:{s:{if(!Mb(a,93674)){c=c+1|0;if((d|0)>(c|0)){q=v[(c<<2)+b>>2];break r}Un(244825);break s}if(!Mb(a,71344)){y=1;break r}if(!Mb(a,7567)){r=1;break r}if(!Mb(a,84042)){r=1;break r}if(!Mb(a,62014)){c=c+1|0;if((d|0)>(c|0)){j=v[(c<<2)+b>>2];break r}Un(244587);break s}if(!Mb(a,107754)){c=c+1|0;if((d|0)>(c|0)){i=v[(c<<2)+b>>2];break r}Un(244867);break s}if(!Mb(a,160583)){c=c+1|0;if((d|0)>(c|0)){s=1;a=d6(e,v[(c<<2)+b>>2]);if((a|0)==1){break r}Eb(153888,332);v[g+448>>2]=a;Fb(276579,g+448|0);break c}Un(245009);break s}t:{if(!Mb(a,160972)){c=c+1|0;if((d|0)>(c|0)){a=(c<<2)+b|0;f=Kf(v[a>>2],69756);if(!f){break t}u:{if(v[f+76>>2]<0){a=v[f>>2]}else{a=v[f>>2]}if(!(a>>>4&1)){while(1){a=g+528|0;wh(a,1024,f);if(w[g+528|0]){a=d6(e,a);if((a|0)!=1){break u}}if(v[f+76>>2]<0){a=v[f>>2]}else{a=v[f>>2]}if(!(a>>>4&1)){continue}break}}hh(f);s=1;break r}Eb(153888,364);v[g+480>>2]=a;Fb(276579,g+480|0);hh(f);break c}Un(245051);break s}if(!Mb(a,69755)){v:{c=c+1|0;if((d|0)<=(c|0)){break v}a=v[(c<<2)+b>>2];if(t[a|0]-48>>>0>9){break v}z=1;B=vD(a);break r}Un(67867);break s}if(!Mb(a,74363)){if((c|0)>=(x|0)){Un(200367);u=1;c=c+2|0;break r}h=v[f+8>>2];k=v[f+4>>2];c=c+2|0;break r}v[g+496>>2]=a;qe(307115,g+496|0);break s}v[g+464>>2]=v[a>>2];qe(309631,g+464|0);$h(v[a>>2])}u=1}c=c+1|0;if((d|0)>(c|0)){continue}break}if(!(!s|!i)){Un(244913);break e}if(u){break e}if(y){IF(e,1)}c=(i|0)!=0;if(!q){break f}K5(e,q)}W5(e);Kb(e,0,365309,0);U5(e);Kb(e,0,365309,0);if(r){a=ub-32|0;ub=a;Rb(v[e+16>>2],0,250808,0);b=v[e+16>>2];v[a+24>>2]=0;v[a+16>>2]=19;v[a+20>>2]=0;Rb(b,0,301221,a+16|0);b=v[e+16>>2];v[a>>2]=165789;Rb(b,0,63122,a);ub=a+32|0;Kb(e,0,365309,0);a=1;break c}w:{x:{y:{if(j){if(!Xw(j)){break y}v[g+432>>2]=j;Kb(e,0,308593,g+432|0);a=Gw(e,j);if((a|0)==1){break w}Eb(153888,56);v[g+416>>2]=a;Fb(276579,g+416|0);Eb(153888,459);v[g+400>>2]=a;Fb(276579,g+400|0);break c}if(Xw(22246)){break x}j=22246}v[g+336>>2]=j;Kb(e,0,262621,g+336|0);break w}v[g+384>>2]=22246;Kb(e,0,308593,g+384|0);a=Gw(e,22246);if((a|0)==1){break w}Eb(153888,56);v[g+368>>2]=a;Fb(276579,g+368|0);Eb(153888,463);v[g+352>>2]=a;Fb(276579,g+352|0);break c}z:{if(!z){break z}a=qc(e,21724,B);if((a|0)==1){break z}Eb(153888,471);v[g+320>>2]=a;Fb(276579,g+320|0);break c}A:{B:{C:{if(c){D:{j=!k|!h;if(j){break D}a=g+528|0;if(Sk(e,k,g+512|0,a)){if(Sk(e,h,g+504|0,a)){break D}}v[g+292>>2]=h;v[g+288>>2]=k;qe(268579,g+288|0);a=0;break c}v[g+528>>2]=0;Kb(e,0,365309,0);v[g+272>>2]=i;Kb(e,0,307703,g+272|0);Kb(e,0,316964,0);Kb(e,0,365309,0);d=293549;E:{F:{G:{H:{I:{a=dO(e,i,0);switch(a+11|0){case 7:break E;case 0:break F;case 12:break G;case 9:break I;default:break H}}d=309762;break E}Eb(153888,99);v[g+144>>2]=a;Fb(276579,g+144|0);break B}Kb(e,0,275996,0);Kb(e,0,363952,0);a=Me(e);if((a|0)!=1){Eb(153888,110);v[g+256>>2]=a;Fb(276579,g+256|0);break B}a=Bd(e,90448,g+528|0);if((a|0)!=1){Eb(153888,116);v[g+240>>2]=a;Fb(276579,g+240|0);break B}if(v[g+528>>2]){Kb(e,0,318233,0);Kb(e,0,363932,0);a=Yc(e);if(!a){Kb(e,0,287303,0);break C}d=131;i=g+1564|0;a=ql(e,i,a);J:{if((a|0)!=1){break J}d=132;b=ub+-64|0;ub=b;a=1;K:{L:{M:{N:{O:{c=v[g+1564>>2];switch(v[c+112>>2]){case 2:case 3:case 4:case 5:break O;case 0:break K;case 6:case 7:break M;case 1:break N;default:break L}}a=QE(c,v[e+4>>2],v[e+84>>2]);if((a|0)==1){break N}Eb(153705,1197);v[b+48>>2]=a;Fb(276579,b+48|0);Eb(153705,2510);v[b+32>>2]=a;Fb(276579,b+32|0);break K}a=uw(c,v[e+4>>2],v[e+24>>2],v[e+28>>2],v[e+84>>2],b+60|0);if((a|0)==1){break K}Eb(153705,2517);v[b+16>>2]=a;Fb(276579,b+16|0);break K}Eb(153705,2522);Fb(329057,0);a=-8;break K}Eb(153705,2527);v[b>>2]=v[c+112>>2];Fb(313931,b);a=0}ub=b- -64|0;if((a|0)!=1){break J}d=133;a=Mt(e,v[g+1564>>2],0,0);if((a|0)!=1){break J}d=134;a=Zc(e,i);if((a|0)==1){break C}}Eb(153888,d);v[g+224>>2]=a;Fb(276579,g+224|0);break B}Kb(e,0,318269,0);Kb(e,0,363929,0);a=Qz(e,0,0);if((a|0)==1){break C}Eb(153888,142);v[g+208>>2]=a;Fb(276579,g+208|0);break B}d=287459}v[g+176>>2]=i;Kb(e,0,d,g+176|0);break A}Kb(e,0,365309,0);a=1;j=ub-16|0;ub=j;i=249;c=ub-3216|0;ub=c;d=v[v[e+12>>2]>>2];P:{if(!d){Eb(146413,5077);Fb(293491,0);b=-11;break P}Q:{if(zc(d,22251)){break Q}b=xc(e,c+3212|0,0,696,0,22251,35319,1,0);if((b|0)!=1){Eb(146413,5086);v[c+3184>>2]=b;Fb(276579,c+3184|0);break P}b=yc(e,d,v[c+3212>>2]);if((b|0)!=1){Eb(146413,5087);v[c+3168>>2]=b;Fb(276579,c+3168|0);break P}b=wc(e,c+3212|0);if((b|0)==1){break Q}Eb(146413,5088);v[c+3152>>2]=b;Fb(276579,c+3152|0);break P}if((Wf(d,22251,c+3212|0)|0)!=1){Eb(146413,5092);Fb(292144,0);b=-11;break P}R:{if(zc(v[c+3212>>2],17981)){break R}b=xc(e,c+3200|0,0,848,0,17981,49498,0,0);if((b|0)!=1){Eb(146413,5102);v[c+3136>>2]=b;Fb(276579,c+3136|0);break P}b=yc(e,v[c+3212>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5103);v[c+3120>>2]=b;Fb(276579,c+3120|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break R}Eb(146413,5104);v[c+3104>>2]=b;Fb(276579,c+3104|0);break P}S:{if(zc(v[c+3212>>2],138893)){break S}b=xc(e,c+3200|0,0,849,0,138893,119006,0,0);if((b|0)!=1){Eb(146413,5113);v[c+3088>>2]=b;Fb(276579,c+3088|0);break P}b=yc(e,v[c+3212>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5114);v[c+3072>>2]=b;Fb(276579,c+3072|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break S}Eb(146413,5115);v[c+3056>>2]=b;Fb(276579,c+3056|0);break P}T:{if(zc(v[c+3212>>2],110791)){break T}b=xc(e,c+3200|0,0,850,0,110791,118972,0,0);if((b|0)!=1){Eb(146413,5124);v[c+3040>>2]=b;Fb(276579,c+3040|0);break P}b=yc(e,v[c+3212>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5125);v[c+3024>>2]=b;Fb(276579,c+3024|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break T}Eb(146413,5126);v[c+3008>>2]=b;Fb(276579,c+3008|0);break P}U:{if(zc(v[c+3212>>2],110787)){break U}b=xc(e,c+3200|0,0,851,0,110787,118926,0,0);if((b|0)!=1){Eb(146413,5135);v[c+2992>>2]=b;Fb(276579,c+2992|0);break P}b=yc(e,v[c+3212>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5136);v[c+2976>>2]=b;Fb(276579,c+2976|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break U}Eb(146413,5137);v[c+2960>>2]=b;Fb(276579,c+2960|0);break P}V:{if(zc(v[c+3212>>2],104936)){break V}b=xc(e,c+3204|0,0,696,0,104936,51203,1,0);if((b|0)!=1){Eb(146413,5146);v[c+2944>>2]=b;Fb(276579,c+2944|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5147);v[c+2928>>2]=b;Fb(276579,c+2928|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break V}Eb(146413,5148);v[c+2912>>2]=b;Fb(276579,c+2912|0);break P}if((Wf(v[c+3212>>2],104936,c+3204|0)|0)!=1){Eb(146413,5152);Fb(292470,0);b=-11;break P}b=v[e+4>>2];f=v[b+92>>2];h=v[b+272>>2];if((h|0)>0){d=0;while(1){W:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]+72>>2])){break W}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b+72>>2],v[b+76>>2],1,0);if((b|0)!=1){Eb(146413,5166);v[c+2896>>2]=b;Fb(276579,c+2896|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5167);v[c+2880>>2]=b;Fb(276579,c+2880|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break W}Eb(146413,5168);v[c+2864>>2]=b;Fb(276579,c+2864|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}X:{if(zc(v[c+3204>>2],2640)){break X}b=xc(e,c+3200|0,0,852,0,2640,121131,0,0);if((b|0)!=1){Eb(146413,5178);v[c+2848>>2]=b;Fb(276579,c+2848|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5179);v[c+2832>>2]=b;Fb(276579,c+2832|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break X}Eb(146413,5180);v[c+2816>>2]=b;Fb(276579,c+2816|0);break P}Y:{if(zc(v[c+3204>>2],77969)){break Y}b=xc(e,c+3200|0,0,853,0,77969,226442,0,0);if((b|0)!=1){Eb(146413,5190);v[c+2800>>2]=b;Fb(276579,c+2800|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5191);v[c+2784>>2]=b;Fb(276579,c+2784|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Y}Eb(146413,5192);v[c+2768>>2]=b;Fb(276579,c+2768|0);break P}Z:{if(zc(v[c+3212>>2],22717)){break Z}b=xc(e,c+3204|0,0,696,0,22717,35612,1,0);if((b|0)!=1){Eb(146413,5201);v[c+2752>>2]=b;Fb(276579,c+2752|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5202);v[c+2736>>2]=b;Fb(276579,c+2736|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Z}Eb(146413,5203);v[c+2720>>2]=b;Fb(276579,c+2720|0);break P}if((Wf(v[c+3212>>2],22717,c+3204|0)|0)!=1){Eb(146413,5207);Fb(292168,0);b=-11;break P}f=v[v[e+4>>2]+192>>2];h=HO(e);if((f|0)>0){d=0;while(1){_:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break _}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5221);v[c+2704>>2]=b;Fb(276579,c+2704|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5222);v[c+2688>>2]=b;Fb(276579,c+2688|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break _}Eb(146413,5223);v[c+2672>>2]=b;Fb(276579,c+2672|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}$:{if(zc(v[c+3212>>2],31331)){break $}b=xc(e,c+3204|0,0,696,0,31331,35507,1,0);if((b|0)!=1){Eb(146413,5233);v[c+2656>>2]=b;Fb(276579,c+2656|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5234);v[c+2640>>2]=b;Fb(276579,c+2640|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break $}Eb(146413,5235);v[c+2624>>2]=b;Fb(276579,c+2624|0);break P}if((Wf(v[c+3212>>2],31331,c+3204|0)|0)!=1){Eb(146413,5239);Fb(292197,0);b=-11;break P}b=v[e+4>>2];f=v[b+28>>2];h=v[b+184>>2];if((h|0)>0){d=0;while(1){aa:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]+192>>2])){break aa}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b+192>>2],v[b+196>>2],1,0);if((b|0)!=1){Eb(146413,5253);v[c+2608>>2]=b;Fb(276579,c+2608|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5254);v[c+2592>>2]=b;Fb(276579,c+2592|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break aa}Eb(146413,5255);v[c+2576>>2]=b;Fb(276579,c+2576|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}ba:{if(zc(v[c+3212>>2],77979)){break ba}b=xc(e,c+3204|0,0,696,0,77979,34163,1,0);if((b|0)!=1){Eb(146413,5265);v[c+2560>>2]=b;Fb(276579,c+2560|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5266);v[c+2544>>2]=b;Fb(276579,c+2544|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ba}Eb(146413,5267);v[c+2528>>2]=b;Fb(276579,c+2528|0);break P}if((Wf(v[c+3212>>2],77979,c+3204|0)|0)!=1){Eb(146413,5271);Fb(292289,0);b=-11;break P}f=v[v[e+4>>2]+224>>2];h=xO(e);if((f|0)>0){d=0;while(1){ca:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break ca}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5285);v[c+2512>>2]=b;Fb(276579,c+2512|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5286);v[c+2496>>2]=b;Fb(276579,c+2496|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ca}Eb(146413,5287);v[c+2480>>2]=b;Fb(276579,c+2480|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}da:{if(zc(v[c+3212>>2],5555)){break da}b=xc(e,c+3204|0,0,696,0,5555,42353,1,0);if((b|0)!=1){Eb(146413,5297);v[c+2464>>2]=b;Fb(276579,c+2464|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5298);v[c+2448>>2]=b;Fb(276579,c+2448|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break da}Eb(146413,5299);v[c+2432>>2]=b;Fb(276579,c+2432|0);break P}if((Wf(v[c+3212>>2],5555,c+3204|0)|0)!=1){Eb(146413,5303);Fb(292092,0);b=-11;break P}b=v[e+4>>2];f=v[b+96>>2];h=v[b+280>>2];if((h|0)>0){d=0;while(1){ea:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break ea}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5317);v[c+2416>>2]=b;Fb(276579,c+2416|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5318);v[c+2400>>2]=b;Fb(276579,c+2400|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ea}Eb(146413,5319);v[c+2384>>2]=b;Fb(276579,c+2384|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}fa:{if(zc(v[c+3212>>2],81543)){break fa}b=xc(e,c+3204|0,0,696,0,81543,81498,1,0);if((b|0)!=1){Eb(146413,5328);v[c+2368>>2]=b;Fb(276579,c+2368|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5329);v[c+2352>>2]=b;Fb(276579,c+2352|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break fa}Eb(146413,5330);v[c+2336>>2]=b;Fb(276579,c+2336|0);break P}ga:{if(zc(v[c+3212>>2],63198)){break ga}b=xc(e,c+3204|0,0,696,0,63198,35748,1,0);if((b|0)!=1){Eb(146413,5338);v[c+2320>>2]=b;Fb(276579,c+2320|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5339);v[c+2304>>2]=b;Fb(276579,c+2304|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ga}Eb(146413,5340);v[c+2288>>2]=b;Fb(276579,c+2288|0);break P}ha:{if(zc(v[c+3212>>2],61074)){break ha}b=xc(e,c+3204|0,0,696,0,61074,61045,1,0);if((b|0)!=1){Eb(146413,5349);v[c+2272>>2]=b;Fb(276579,c+2272|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5350);v[c+2256>>2]=b;Fb(276579,c+2256|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ha}Eb(146413,5351);v[c+2240>>2]=b;Fb(276579,c+2240|0);break P}if((Wf(v[c+3212>>2],61074,c+3204|0)|0)!=1){Eb(146413,5355);Fb(292258,0);b=-11;break P}b=v[e+4>>2];f=v[b+72>>2];h=v[b+240>>2];if((h|0)>0){d=0;while(1){ia:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]+24>>2])){break ia}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b+24>>2],v[b+28>>2],1,0);if((b|0)!=1){Eb(146413,5369);v[c+2224>>2]=b;Fb(276579,c+2224|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5370);v[c+2208>>2]=b;Fb(276579,c+2208|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ia}Eb(146413,5371);v[c+2192>>2]=b;Fb(276579,c+2192|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}b=xI(e,v[c+3204>>2],c+3208|0);if((b|0)!=1){Eb(146413,5376);v[c+2176>>2]=b;Fb(276579,c+2176|0);break P}ja:{if(zc(v[c+3208>>2],110705)){break ja}b=xc(e,c+3200|0,0,854,0,110705,200441,0,0);if((b|0)!=1){Eb(146413,5384);v[c+2160>>2]=b;Fb(276579,c+2160|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5385);v[c+2144>>2]=b;Fb(276579,c+2144|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ja}Eb(146413,5386);v[c+2128>>2]=b;Fb(276579,c+2128|0);break P}ka:{if(zc(v[c+3208>>2],17981)){break ka}b=xc(e,c+3200|0,0,855,0,17981,249341,0,0);if((b|0)!=1){Eb(146413,5394);v[c+2112>>2]=b;Fb(276579,c+2112|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5395);v[c+2096>>2]=b;Fb(276579,c+2096|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ka}Eb(146413,5396);v[c+2080>>2]=b;Fb(276579,c+2080|0);break P}la:{if(zc(v[c+3208>>2],9357)){break la}b=xc(e,c+3200|0,0,856,0,9357,199421,0,0);if((b|0)!=1){Eb(146413,5404);v[c+2064>>2]=b;Fb(276579,c+2064|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5405);v[c+2048>>2]=b;Fb(276579,c+2048|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break la}Eb(146413,5406);v[c+2032>>2]=b;Fb(276579,c+2032|0);break P}ma:{if(zc(v[c+3208>>2],106845)){break ma}b=xc(e,c+3200|0,0,857,0,106845,60955,0,0);if((b|0)!=1){Eb(146413,5414);v[c+2016>>2]=b;Fb(276579,c+2016|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5415);v[c+2e3>>2]=b;Fb(276579,c+2e3|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ma}Eb(146413,5416);v[c+1984>>2]=b;Fb(276579,c+1984|0);break P}na:{if(zc(v[c+3212>>2],32049)){break na}b=xc(e,c+3204|0,0,696,0,32049,31986,1,0);if((b|0)!=1){Eb(146413,5425);v[c+1968>>2]=b;Fb(276579,c+1968|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5426);v[c+1952>>2]=b;Fb(276579,c+1952|0);break P}b=xc(e,c+3200|0,0,858,0,110275,134531,0,0);if((b|0)!=1){Eb(146413,5431);v[c+1936>>2]=b;Fb(276579,c+1936|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5432);v[c+1920>>2]=b;Fb(276579,c+1920|0);break P}b=wc(e,c+3200|0);if((b|0)!=1){Eb(146413,5433);v[c+1904>>2]=b;Fb(276579,c+1904|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break na}Eb(146413,5435);v[c+1888>>2]=b;Fb(276579,c+1888|0);break P}oa:{if(zc(v[c+3212>>2],72852)){break oa}b=xc(e,c+3204|0,0,696,0,72852,40062,1,0);if((b|0)!=1){Eb(146413,5444);v[c+1872>>2]=b;Fb(276579,c+1872|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5445);v[c+1856>>2]=b;Fb(276579,c+1856|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break oa}Eb(146413,5446);v[c+1840>>2]=b;Fb(276579,c+1840|0);break P}pa:{if(zc(v[c+3212>>2],72529)){break pa}b=xc(e,c+3204|0,0,696,0,72529,80110,1,0);if((b|0)!=1){Eb(146413,5455);v[c+1824>>2]=b;Fb(276579,c+1824|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5456);v[c+1808>>2]=b;Fb(276579,c+1808|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break pa}Eb(146413,5457);v[c+1792>>2]=b;Fb(276579,c+1792|0);break P}qa:{if(zc(v[c+3212>>2],3730)){break qa}b=xc(e,c+3204|0,0,696,0,3730,16081,1,0);if((b|0)!=1){Eb(146413,5466);v[c+1776>>2]=b;Fb(276579,c+1776|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5467);v[c+1760>>2]=b;Fb(276579,c+1760|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break qa}Eb(146413,5468);v[c+1744>>2]=b;Fb(276579,c+1744|0);break P}ra:{if(zc(v[c+3212>>2],140320)){break ra}b=xc(e,c+3204|0,0,696,0,140320,106521,1,0);if((b|0)!=1){Eb(146413,5477);v[c+1728>>2]=b;Fb(276579,c+1728|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5478);v[c+1712>>2]=b;Fb(276579,c+1712|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ra}Eb(146413,5479);v[c+1696>>2]=b;Fb(276579,c+1696|0);break P}sa:{if(zc(v[c+3212>>2],65812)){break sa}b=xc(e,c+3204|0,0,696,0,65812,35679,1,0);if((b|0)!=1){Eb(146413,5487);v[c+1680>>2]=b;Fb(276579,c+1680|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5488);v[c+1664>>2]=b;Fb(276579,c+1664|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break sa}Eb(146413,5489);v[c+1648>>2]=b;Fb(276579,c+1648|0);break P}ta:{if(zc(v[c+3212>>2],94755)){break ta}b=xc(e,c+3204|0,0,696,0,94755,56682,1,0);if((b|0)!=1){Eb(146413,5498);v[c+1632>>2]=b;Fb(276579,c+1632|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5499);v[c+1616>>2]=b;Fb(276579,c+1616|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ta}Eb(146413,5500);v[c+1600>>2]=b;Fb(276579,c+1600|0);break P}if((Wf(v[c+3212>>2],94755,c+3204|0)|0)!=1){Eb(146413,5504);Fb(292356,0);b=-11;break P}f=v[v[e+4>>2]+312>>2];h=kq(e);if((f|0)>0){d=0;while(1){ua:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break ua}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5518);v[c+1584>>2]=b;Fb(276579,c+1584|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5519);v[c+1568>>2]=b;Fb(276579,c+1568|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break ua}Eb(146413,5520);v[c+1552>>2]=b;Fb(276579,c+1552|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}va:{if(zc(v[c+3212>>2],77992)){break va}b=xc(e,c+3204|0,0,696,0,77992,34256,1,0);if((b|0)!=1){Eb(146413,5530);v[c+1536>>2]=b;Fb(276579,c+1536|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5531);v[c+1520>>2]=b;Fb(276579,c+1520|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break va}Eb(146413,5532);v[c+1504>>2]=b;Fb(276579,c+1504|0);break P}if((Wf(v[c+3212>>2],77992,c+3204|0)|0)!=1){Eb(146413,5536);Fb(292322,0);b=-11;break P}b=v[e+4>>2];f=v[b+84>>2];h=v[b+264>>2];if((h|0)>0){d=0;while(1){wa:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break wa}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5550);v[c+1488>>2]=b;Fb(276579,c+1488|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5551);v[c+1472>>2]=b;Fb(276579,c+1472|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break wa}Eb(146413,5552);v[c+1456>>2]=b;Fb(276579,c+1456|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}xa:{if(zc(v[c+3212>>2],61130)){break xa}b=xc(e,c+3204|0,0,696,0,61130,49682,1,0);if((b|0)!=1){Eb(146413,5562);v[c+1440>>2]=b;Fb(276579,c+1440|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5563);v[c+1424>>2]=b;Fb(276579,c+1424|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break xa}Eb(146413,5564);v[c+1408>>2]=b;Fb(276579,c+1408|0);break P}ya:{if(zc(v[c+3212>>2],92232)){break ya}b=xc(e,c+3204|0,0,696,0,92232,80516,1,0);if((b|0)!=1){Eb(146413,5573);v[c+1392>>2]=b;Fb(276579,c+1392|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5574);v[c+1376>>2]=b;Fb(276579,c+1376|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break ya}Eb(146413,5575);v[c+1360>>2]=b;Fb(276579,c+1360|0);break P}za:{if(zc(v[c+3212>>2],100591)){break za}b=xc(e,c+3204|0,0,696,0,100591,99823,1,0);if((b|0)!=1){Eb(146413,5584);v[c+1344>>2]=b;Fb(276579,c+1344|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5585);v[c+1328>>2]=b;Fb(276579,c+1328|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break za}Eb(146413,5586);v[c+1312>>2]=b;Fb(276579,c+1312|0);break P}if((Wf(v[c+3212>>2],100591,c+3204|0)|0)!=1){Eb(146413,5590);Fb(292408,0);b=-11;break P}f=v[v[e+4>>2]+200>>2];h=yF(e);if((f|0)>0){d=0;while(1){Aa:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break Aa}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5603);v[c+1296>>2]=b;Fb(276579,c+1296|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5604);v[c+1280>>2]=b;Fb(276579,c+1280|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Aa}Eb(146413,5605);v[c+1264>>2]=b;Fb(276579,c+1264|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}b=xI(e,v[c+3204>>2],c+3208|0);if((b|0)!=1){Eb(146413,5610);v[c+1248>>2]=b;Fb(276579,c+1248|0);break P}Ba:{if(zc(v[c+3208>>2],110705)){break Ba}b=xc(e,c+3200|0,0,859,0,110705,200470,0,0);if((b|0)!=1){Eb(146413,5618);v[c+1232>>2]=b;Fb(276579,c+1232|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5619);v[c+1216>>2]=b;Fb(276579,c+1216|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ba}Eb(146413,5620);v[c+1200>>2]=b;Fb(276579,c+1200|0);break P}Ca:{if(zc(v[c+3208>>2],17981)){break Ca}b=xc(e,c+3200|0,0,860,0,17981,199490,0,0);if((b|0)!=1){Eb(146413,5628);v[c+1184>>2]=b;Fb(276579,c+1184|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5629);v[c+1168>>2]=b;Fb(276579,c+1168|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ca}Eb(146413,5630);v[c+1152>>2]=b;Fb(276579,c+1152|0);break P}Da:{if(zc(v[c+3208>>2],9357)){break Da}b=xc(e,c+3200|0,0,861,0,9357,199444,0,0);if((b|0)!=1){Eb(146413,5638);v[c+1136>>2]=b;Fb(276579,c+1136|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5639);v[c+1120>>2]=b;Fb(276579,c+1120|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Da}Eb(146413,5640);v[c+1104>>2]=b;Fb(276579,c+1104|0);break P}Ea:{if(zc(v[c+3208>>2],106845)){break Ea}b=xc(e,c+3200|0,0,862,0,106845,100107,0,0);if((b|0)!=1){Eb(146413,5648);v[c+1088>>2]=b;Fb(276579,c+1088|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5649);v[c+1072>>2]=b;Fb(276579,c+1072|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ea}Eb(146413,5650);v[c+1056>>2]=b;Fb(276579,c+1056|0);break P}Fa:{if(zc(v[c+3212>>2],105188)){break Fa}b=xc(e,c+3204|0,0,696,0,105188,52587,1,0);if((b|0)!=1){Eb(146413,5659);v[c+1040>>2]=b;Fb(276579,c+1040|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5660);v[c+1024>>2]=b;Fb(276579,c+1024|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Fa}Eb(146413,5661);v[c+1008>>2]=b;Fb(276579,c+1008|0);break P}if((Wf(v[c+3212>>2],105188,c+3204|0)|0)!=1){Eb(146413,5665);Fb(292528,0);b=-11;break P}f=v[v[e+4>>2]+172>>2];h=eO(e);if((f|0)>0){d=0;while(1){Ga:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break Ga}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5679);v[c+992>>2]=b;Fb(276579,c+992|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5680);v[c+976>>2]=b;Fb(276579,c+976|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ga}Eb(146413,5681);v[c+960>>2]=b;Fb(276579,c+960|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}Ha:{if(zc(v[c+3212>>2],101292)){break Ha}b=xc(e,c+3204|0,0,696,0,101292,82770,1,0);if((b|0)!=1){Eb(146413,5691);v[c+944>>2]=b;Fb(276579,c+944|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5692);v[c+928>>2]=b;Fb(276579,c+928|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Ha}Eb(146413,5693);v[c+912>>2]=b;Fb(276579,c+912|0);break P}Ia:{if(zc(v[c+3212>>2],105139)){break Ia}b=xc(e,c+3204|0,0,696,0,105139,36026,1,0);if((b|0)!=1){Eb(146413,5702);v[c+896>>2]=b;Fb(276579,c+896|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5703);v[c+880>>2]=b;Fb(276579,c+880|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Ia}Eb(146413,5704);v[c+864>>2]=b;Fb(276579,c+864|0);break P}if((Wf(v[c+3212>>2],105139,c+3204|0)|0)!=1){Eb(146413,5708);Fb(292500,0);b=-11;break P}b=v[e+4>>2];f=v[b+20>>2];h=v[b+164>>2];if((h|0)>0){d=0;while(1){Ja:{b=f+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]>>2])){break Ja}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b>>2],v[b+4>>2],1,0);if((b|0)!=1){Eb(146413,5722);v[c+848>>2]=b;Fb(276579,c+848|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5723);v[c+832>>2]=b;Fb(276579,c+832|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ja}Eb(146413,5724);v[c+816>>2]=b;Fb(276579,c+816|0);break P}d=d+1|0;if((h|0)!=(d|0)){continue}break}}Ka:{if(zc(v[c+3212>>2],101211)){break Ka}b=xc(e,c+3204|0,0,696,0,101211,34417,1,0);if((b|0)!=1){Eb(146413,5733);v[c+800>>2]=b;Fb(276579,c+800|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5734);v[c+784>>2]=b;Fb(276579,c+784|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Ka}Eb(146413,5735);v[c+768>>2]=b;Fb(276579,c+768|0);break P}if((Wf(v[c+3212>>2],101211,c+3204|0)|0)!=1){Eb(146413,5739);Fb(292439,0);b=-11;break P}f=v[v[e+4>>2]+216>>2];h=uF(e);if((f|0)>0){d=0;while(1){La:{b=h+(d<<2)|0;if(zc(v[c+3204>>2],v[v[b>>2]+104>>2])){break La}b=v[b>>2];b=xc(e,c+3200|0,0,696,0,v[b+104>>2],v[b+108>>2],1,0);if((b|0)!=1){Eb(146413,5752);v[c+752>>2]=b;Fb(276579,c+752|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5753);v[c+736>>2]=b;Fb(276579,c+736|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break La}Eb(146413,5754);v[c+720>>2]=b;Fb(276579,c+720|0);break P}d=d+1|0;if((f|0)!=(d|0)){continue}break}}b=xI(e,v[c+3204>>2],c+3208|0);if((b|0)!=1){Eb(146413,5759);v[c+704>>2]=b;Fb(276579,c+704|0);break P}Ma:{if(zc(v[c+3208>>2],110705)){break Ma}b=xc(e,c+3200|0,0,863,0,110705,200499,0,0);if((b|0)!=1){Eb(146413,5767);v[c+688>>2]=b;Fb(276579,c+688|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5768);v[c+672>>2]=b;Fb(276579,c+672|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ma}Eb(146413,5769);v[c+656>>2]=b;Fb(276579,c+656|0);break P}Na:{if(zc(v[c+3208>>2],17981)){break Na}b=xc(e,c+3200|0,0,864,0,17981,199528,0,0);if((b|0)!=1){Eb(146413,5777);v[c+640>>2]=b;Fb(276579,c+640|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5778);v[c+624>>2]=b;Fb(276579,c+624|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Na}Eb(146413,5779);v[c+608>>2]=b;Fb(276579,c+608|0);break P}Oa:{if(zc(v[c+3208>>2],9357)){break Oa}b=xc(e,c+3200|0,0,865,0,9357,199467,0,0);if((b|0)!=1){Eb(146413,5787);v[c+592>>2]=b;Fb(276579,c+592|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5788);v[c+576>>2]=b;Fb(276579,c+576|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Oa}Eb(146413,5789);v[c+560>>2]=b;Fb(276579,c+560|0);break P}Pa:{if(zc(v[c+3208>>2],106845)){break Pa}b=xc(e,c+3200|0,0,866,0,106845,81161,0,0);if((b|0)!=1){Eb(146413,5797);v[c+544>>2]=b;Fb(276579,c+544|0);break P}b=yc(e,v[c+3208>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5798);v[c+528>>2]=b;Fb(276579,c+528|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Pa}Eb(146413,5799);v[c+512>>2]=b;Fb(276579,c+512|0);break P}Qa:{if(zc(v[c+3212>>2],103122)){break Qa}b=xc(e,c+3204|0,0,696,0,103122,48977,1,0);if((b|0)!=1){Eb(146413,5807);v[c+496>>2]=b;Fb(276579,c+496|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5808);v[c+480>>2]=b;Fb(276579,c+480|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Qa}Eb(146413,5809);v[c+464>>2]=b;Fb(276579,c+464|0);break P}Ra:{if(zc(v[c+3212>>2],92477)){break Ra}b=xc(e,c+3204|0,0,696,0,92477,7767,1,0);if((b|0)!=1){Eb(146413,5817);v[c+448>>2]=b;Fb(276579,c+448|0);break P}b=yc(e,v[c+3212>>2],v[c+3204>>2]);if((b|0)!=1){Eb(146413,5818);v[c+432>>2]=b;Fb(276579,c+432|0);break P}b=wc(e,c+3204|0);if((b|0)==1){break Ra}Eb(146413,5819);v[c+416>>2]=b;Fb(276579,c+416|0);break P}b=xI(e,v[c+3212>>2],c+3204|0);if((b|0)!=1){Eb(146413,5823);v[c+400>>2]=b;Fb(276579,c+400|0);break P}b=v[v[e+4>>2]+8>>2];f=v[b+4>>2];h=v[b+8>>2];if((h|0)>0){d=0;while(1){k=f+(d<<2)|0;b=v[v[k>>2]+40>>2];b=Sd(b,Pb(b)+1|0,1,146379,5835);v[c+3196>>2]=b;if(!b){Eb(146413,5835);Fb(276543,0);b=-1;break P}b=yka(e,v[c+3212>>2],v[k>>2],b);if((b|0)!=1){Eb(146413,5836);v[c+384>>2]=b;Fb(276579,c+384|0);break P}Zb(c+3196|0,146379,5837);d=d+1|0;if((h|0)!=(d|0)){continue}break}}Sa:{if(zc(v[c+3204>>2],66667)){break Sa}b=xc(e,c+3200|0,0,867,0,66667,33646,0,0);if((b|0)!=1){Eb(146413,5845);v[c+368>>2]=b;Fb(276579,c+368|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5846);v[c+352>>2]=b;Fb(276579,c+352|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Sa}Eb(146413,5847);v[c+336>>2]=b;Fb(276579,c+336|0);break P}Ta:{if(zc(v[c+3204>>2],66261)){break Ta}b=xc(e,c+3200|0,0,868,0,66261,97762,0,0);if((b|0)!=1){Eb(146413,5854);v[c+320>>2]=b;Fb(276579,c+320|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5855);v[c+304>>2]=b;Fb(276579,c+304|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ta}Eb(146413,5856);v[c+288>>2]=b;Fb(276579,c+288|0);break P}Ua:{if(zc(v[c+3204>>2],72946)){break Ua}b=xc(e,c+3200|0,0,869,0,72946,43123,0,0);if((b|0)!=1){Eb(146413,5863);v[c+272>>2]=b;Fb(276579,c+272|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5864);v[c+256>>2]=b;Fb(276579,c+256|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ua}Eb(146413,5865);v[c+240>>2]=b;Fb(276579,c+240|0);break P}Va:{if(zc(v[c+3204>>2],2943)){break Va}b=xc(e,c+3200|0,0,870,0,2943,43068,0,0);if((b|0)!=1){Eb(146413,5872);v[c+224>>2]=b;Fb(276579,c+224|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5873);v[c+208>>2]=b;Fb(276579,c+208|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Va}Eb(146413,5874);v[c+192>>2]=b;Fb(276579,c+192|0);break P}Wa:{if(zc(v[c+3204>>2],72772)){break Wa}b=xc(e,c+3200|0,0,871,0,72772,164924,0,0);if((b|0)!=1){Eb(146413,5881);v[c+176>>2]=b;Fb(276579,c+176|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5882);v[c+160>>2]=b;Fb(276579,c+160|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Wa}Eb(146413,5883);v[c+144>>2]=b;Fb(276579,c+144|0);break P}Xa:{if(zc(v[c+3204>>2],3361)){break Xa}b=xc(e,c+3200|0,0,872,0,3361,9304,0,0);if((b|0)!=1){Eb(146413,5890);v[c+128>>2]=b;Fb(276579,c+128|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5891);v[c+112>>2]=b;Fb(276579,c+112|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Xa}Eb(146413,5892);v[c+96>>2]=b;Fb(276579,c+96|0);break P}Ya:{if(zc(v[c+3204>>2],61130)){break Ya}b=xc(e,c+3200|0,0,873,0,61130,2973,0,0);if((b|0)!=1){Eb(146413,5899);v[c+80>>2]=b;Fb(276579,c+80|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5900);v[c+64>>2]=b;Fb(276579,c- -64|0);break P}b=wc(e,c+3200|0);if((b|0)==1){break Ya}Eb(146413,5901);v[c+48>>2]=b;Fb(276579,c+48|0);break P}b=1;if(zc(v[c+3204>>2],93703)){break P}b=xc(e,c+3200|0,0,874,0,93703,126159,0,0);if((b|0)!=1){Eb(146413,5908);v[c+32>>2]=b;Fb(276579,c+32|0);break P}b=yc(e,v[c+3204>>2],v[c+3200>>2]);if((b|0)!=1){Eb(146413,5909);v[c+16>>2]=b;Fb(276579,c+16|0);break P}b=1;d=wc(e,c+3200|0);if((d|0)==1){break P}Eb(146413,5910);v[c>>2]=d;Fb(276579,c);b=d}ub=c+3216|0;Za:{_a:{if((b|0)!=1){break _a}i=250;b=ub-1616|0;ub=b;c=v[v[e+12>>2]>>2];$a:{if(!c){Eb(146413,5959);Fb(293491,0);d=-11;break $a}ab:{if(zc(c,6226)){break ab}d=xc(e,b+1612|0,0,696,0,6226,35298,1,0);if((d|0)!=1){Eb(146413,5968);v[b+1584>>2]=d;Fb(276579,b+1584|0);break $a}d=yc(e,c,v[b+1612>>2]);if((d|0)!=1){Eb(146413,5969);v[b+1568>>2]=d;Fb(276579,b+1568|0);break $a}d=wc(e,b+1612|0);if((d|0)==1){break ab}Eb(146413,5970);v[b+1552>>2]=d;Fb(276579,b+1552|0);break $a}if((Wf(c,6226,b+1612|0)|0)!=1){Eb(146413,5974);Fb(292120,0);d=-11;break $a}bb:{if(zc(v[b+1612>>2],104936)){break bb}d=xc(e,b+1608|0,0,696,0,104936,51168,1,0);if((d|0)!=1){Eb(146413,5984);v[b+1536>>2]=d;Fb(276579,b+1536|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,5985);v[b+1520>>2]=d;Fb(276579,b+1520|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break bb}Eb(146413,5986);v[b+1504>>2]=d;Fb(276579,b+1504|0);break $a}if((Wf(v[b+1612>>2],104936,b+1608|0)|0)!=1){Eb(146413,5990);Fb(292470,0);d=-11;break $a}d=v[e+4>>2];f=v[d+92>>2];h=v[d+272>>2];if((h|0)>0){c=0;while(1){cb:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]+72>>2])){break cb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d+72>>2],v[d+76>>2],1,0);if((d|0)!=1){Eb(146413,6004);v[b+1488>>2]=d;Fb(276579,b+1488|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6005);v[b+1472>>2]=d;Fb(276579,b+1472|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break cb}Eb(146413,6006);v[b+1456>>2]=d;Fb(276579,b+1456|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}db:{if(zc(v[b+1612>>2],22717)){break db}d=xc(e,b+1608|0,0,696,0,22717,35575,1,0);if((d|0)!=1){Eb(146413,6016);v[b+1440>>2]=d;Fb(276579,b+1440|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6017);v[b+1424>>2]=d;Fb(276579,b+1424|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break db}Eb(146413,6018);v[b+1408>>2]=d;Fb(276579,b+1408|0);break $a}if((Wf(v[b+1612>>2],22717,b+1608|0)|0)!=1){Eb(146413,6022);Fb(292168,0);d=-11;break $a}f=v[v[e+4>>2]+192>>2];h=HO(e);if((f|0)>0){c=0;while(1){eb:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break eb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6036);v[b+1392>>2]=d;Fb(276579,b+1392|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6037);v[b+1376>>2]=d;Fb(276579,b+1376|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break eb}Eb(146413,6038);v[b+1360>>2]=d;Fb(276579,b+1360|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}fb:{if(zc(v[b+1612>>2],31331)){break fb}d=xc(e,b+1608|0,0,696,0,31331,35468,1,0);if((d|0)!=1){Eb(146413,6048);v[b+1344>>2]=d;Fb(276579,b+1344|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6049);v[b+1328>>2]=d;Fb(276579,b+1328|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break fb}Eb(146413,6050);v[b+1312>>2]=d;Fb(276579,b+1312|0);break $a}if((Wf(v[b+1612>>2],31331,b+1608|0)|0)!=1){Eb(146413,6054);Fb(292197,0);d=-11;break $a}d=v[e+4>>2];f=v[d+28>>2];h=v[d+184>>2];if((h|0)>0){c=0;while(1){gb:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]+192>>2])){break gb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d+192>>2],v[d+196>>2],1,0);if((d|0)!=1){Eb(146413,6068);v[b+1296>>2]=d;Fb(276579,b+1296|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6069);v[b+1280>>2]=d;Fb(276579,b+1280|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break gb}Eb(146413,6070);v[b+1264>>2]=d;Fb(276579,b+1264|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}hb:{if(zc(v[b+1612>>2],77979)){break hb}d=xc(e,b+1608|0,0,696,0,77979,34130,1,0);if((d|0)!=1){Eb(146413,6080);v[b+1248>>2]=d;Fb(276579,b+1248|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6081);v[b+1232>>2]=d;Fb(276579,b+1232|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break hb}Eb(146413,6082);v[b+1216>>2]=d;Fb(276579,b+1216|0);break $a}if((Wf(v[b+1612>>2],77979,b+1608|0)|0)!=1){Eb(146413,6086);Fb(292289,0);d=-11;break $a}f=v[v[e+4>>2]+224>>2];h=xO(e);if((f|0)>0){c=0;while(1){ib:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break ib}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6100);v[b+1200>>2]=d;Fb(276579,b+1200|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6101);v[b+1184>>2]=d;Fb(276579,b+1184|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break ib}Eb(146413,6102);v[b+1168>>2]=d;Fb(276579,b+1168|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}jb:{if(zc(v[b+1612>>2],5555)){break jb}d=xc(e,b+1608|0,0,696,0,5555,42318,1,0);if((d|0)!=1){Eb(146413,6112);v[b+1152>>2]=d;Fb(276579,b+1152|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6113);v[b+1136>>2]=d;Fb(276579,b+1136|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break jb}Eb(146413,6114);v[b+1120>>2]=d;Fb(276579,b+1120|0);break $a}if((Wf(v[b+1612>>2],5555,b+1608|0)|0)!=1){Eb(146413,6118);Fb(292092,0);d=-11;break $a}d=v[e+4>>2];f=v[d+96>>2];h=v[d+280>>2];if((h|0)>0){c=0;while(1){kb:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break kb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6132);v[b+1104>>2]=d;Fb(276579,b+1104|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6133);v[b+1088>>2]=d;Fb(276579,b+1088|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break kb}Eb(146413,6134);v[b+1072>>2]=d;Fb(276579,b+1072|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}lb:{if(zc(v[b+1612>>2],61074)){break lb}d=xc(e,b+1608|0,0,696,0,61074,61008,1,0);if((d|0)!=1){Eb(146413,6144);v[b+1056>>2]=d;Fb(276579,b+1056|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6145);v[b+1040>>2]=d;Fb(276579,b+1040|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break lb}Eb(146413,6146);v[b+1024>>2]=d;Fb(276579,b+1024|0);break $a}if((Wf(v[b+1612>>2],61074,b+1608|0)|0)!=1){Eb(146413,6150);Fb(292258,0);d=-11;break $a}d=v[e+4>>2];f=v[d+72>>2];h=v[d+240>>2];if((h|0)>0){c=0;while(1){mb:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]+24>>2])){break mb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d+24>>2],v[d+28>>2],1,0);if((d|0)!=1){Eb(146413,6164);v[b+1008>>2]=d;Fb(276579,b+1008|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6165);v[b+992>>2]=d;Fb(276579,b+992|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break mb}Eb(146413,6166);v[b+976>>2]=d;Fb(276579,b+976|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}nb:{if(zc(v[b+1612>>2],32049)){break nb}d=xc(e,b+1608|0,0,696,0,32049,31919,1,0);if((d|0)!=1){Eb(146413,6176);v[b+960>>2]=d;Fb(276579,b+960|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6177);v[b+944>>2]=d;Fb(276579,b+944|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break nb}Eb(146413,6179);v[b+928>>2]=d;Fb(276579,b+928|0);break $a}ob:{if(zc(v[b+1612>>2],72852)){break ob}d=xc(e,b+1608|0,0,696,0,72852,40012,1,0);if((d|0)!=1){Eb(146413,6188);v[b+912>>2]=d;Fb(276579,b+912|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6189);v[b+896>>2]=d;Fb(276579,b+896|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break ob}Eb(146413,6190);v[b+880>>2]=d;Fb(276579,b+880|0);break $a}pb:{if(zc(v[b+1612>>2],72529)){break pb}d=xc(e,b+1608|0,0,696,0,72529,39959,1,0);if((d|0)!=1){Eb(146413,6199);v[b+864>>2]=d;Fb(276579,b+864|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6200);v[b+848>>2]=d;Fb(276579,b+848|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break pb}Eb(146413,6201);v[b+832>>2]=d;Fb(276579,b+832|0);break $a}qb:{if(zc(v[b+1612>>2],3730)){break qb}d=xc(e,b+1608|0,0,696,0,3730,16044,1,0);if((d|0)!=1){Eb(146413,6210);v[b+816>>2]=d;Fb(276579,b+816|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6211);v[b+800>>2]=d;Fb(276579,b+800|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break qb}Eb(146413,6212);v[b+784>>2]=d;Fb(276579,b+784|0);break $a}rb:{if(zc(v[b+1612>>2],140320)){break rb}d=xc(e,b+1608|0,0,696,0,140320,106482,1,0);if((d|0)!=1){Eb(146413,6221);v[b+768>>2]=d;Fb(276579,b+768|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6222);v[b+752>>2]=d;Fb(276579,b+752|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break rb}Eb(146413,6223);v[b+736>>2]=d;Fb(276579,b+736|0);break $a}sb:{if(zc(v[b+1612>>2],94755)){break sb}d=xc(e,b+1608|0,0,696,0,94755,56641,1,0);if((d|0)!=1){Eb(146413,6232);v[b+720>>2]=d;Fb(276579,b+720|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6233);v[b+704>>2]=d;Fb(276579,b+704|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break sb}Eb(146413,6234);v[b+688>>2]=d;Fb(276579,b+688|0);break $a}if((Wf(v[b+1612>>2],94755,b+1608|0)|0)!=1){Eb(146413,6238);Fb(292356,0);d=-11;break $a}f=v[v[e+4>>2]+312>>2];h=kq(e);if((f|0)>0){c=0;while(1){tb:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break tb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6252);v[b+672>>2]=d;Fb(276579,b+672|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6253);v[b+656>>2]=d;Fb(276579,b+656|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break tb}Eb(146413,6254);v[b+640>>2]=d;Fb(276579,b+640|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}ub:{if(zc(v[b+1612>>2],77992)){break ub}d=xc(e,b+1608|0,0,696,0,77992,34222,1,0);if((d|0)!=1){Eb(146413,6264);v[b+624>>2]=d;Fb(276579,b+624|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6265);v[b+608>>2]=d;Fb(276579,b+608|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break ub}Eb(146413,6266);v[b+592>>2]=d;Fb(276579,b+592|0);break $a}if((Wf(v[b+1612>>2],77992,b+1608|0)|0)!=1){Eb(146413,6270);Fb(292322,0);d=-11;break $a}d=v[e+4>>2];f=v[d+84>>2];h=v[d+264>>2];if((h|0)>0){c=0;while(1){vb:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break vb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6284);v[b+576>>2]=d;Fb(276579,b+576|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6285);v[b+560>>2]=d;Fb(276579,b+560|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break vb}Eb(146413,6286);v[b+544>>2]=d;Fb(276579,b+544|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}wb:{if(zc(v[b+1612>>2],61130)){break wb}d=xc(e,b+1608|0,0,696,0,61130,49646,1,0);if((d|0)!=1){Eb(146413,6296);v[b+528>>2]=d;Fb(276579,b+528|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6297);v[b+512>>2]=d;Fb(276579,b+512|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break wb}Eb(146413,6298);v[b+496>>2]=d;Fb(276579,b+496|0);break $a}xb:{if(zc(v[b+1612>>2],100591)){break xb}d=xc(e,b+1608|0,0,696,0,100591,99793,1,0);if((d|0)!=1){Eb(146413,6307);v[b+480>>2]=d;Fb(276579,b+480|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6308);v[b+464>>2]=d;Fb(276579,b+464|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break xb}Eb(146413,6309);v[b+448>>2]=d;Fb(276579,b+448|0);break $a}if((Wf(v[b+1612>>2],100591,b+1608|0)|0)!=1){Eb(146413,6313);Fb(292408,0);d=-11;break $a}f=v[v[e+4>>2]+200>>2];h=yF(e);if((f|0)>0){c=0;while(1){yb:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break yb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6326);v[b+432>>2]=d;Fb(276579,b+432|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6327);v[b+416>>2]=d;Fb(276579,b+416|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break yb}Eb(146413,6328);v[b+400>>2]=d;Fb(276579,b+400|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}zb:{if(zc(v[b+1612>>2],105188)){break zb}d=xc(e,b+1608|0,0,696,0,105188,52550,1,0);if((d|0)!=1){Eb(146413,6338);v[b+384>>2]=d;Fb(276579,b+384|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6339);v[b+368>>2]=d;Fb(276579,b+368|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break zb}Eb(146413,6340);v[b+352>>2]=d;Fb(276579,b+352|0);break $a}if((Wf(v[b+1612>>2],105188,b+1608|0)|0)!=1){Eb(146413,6344);Fb(292528,0);d=-11;break $a}f=v[v[e+4>>2]+172>>2];h=eO(e);if((f|0)>0){c=0;while(1){Ab:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break Ab}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6358);v[b+336>>2]=d;Fb(276579,b+336|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6359);v[b+320>>2]=d;Fb(276579,b+320|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break Ab}Eb(146413,6360);v[b+304>>2]=d;Fb(276579,b+304|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}Bb:{if(zc(v[b+1612>>2],101292)){break Bb}d=xc(e,b+1608|0,0,696,0,101292,82728,1,0);if((d|0)!=1){Eb(146413,6370);v[b+288>>2]=d;Fb(276579,b+288|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6371);v[b+272>>2]=d;Fb(276579,b+272|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break Bb}Eb(146413,6372);v[b+256>>2]=d;Fb(276579,b+256|0);break $a}Cb:{if(zc(v[b+1612>>2],105139)){break Cb}d=xc(e,b+1608|0,0,696,0,105139,35986,1,0);if((d|0)!=1){Eb(146413,6381);v[b+240>>2]=d;Fb(276579,b+240|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6382);v[b+224>>2]=d;Fb(276579,b+224|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break Cb}Eb(146413,6383);v[b+208>>2]=d;Fb(276579,b+208|0);break $a}if((Wf(v[b+1612>>2],105139,b+1608|0)|0)!=1){Eb(146413,6387);Fb(292500,0);d=-11;break $a}d=v[e+4>>2];f=v[d+20>>2];h=v[d+164>>2];if((h|0)>0){c=0;while(1){Db:{d=f+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]>>2])){break Db}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d>>2],v[d+4>>2],1,0);if((d|0)!=1){Eb(146413,6401);v[b+192>>2]=d;Fb(276579,b+192|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6402);v[b+176>>2]=d;Fb(276579,b+176|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break Db}Eb(146413,6403);v[b+160>>2]=d;Fb(276579,b+160|0);break $a}c=c+1|0;if((h|0)!=(c|0)){continue}break}}Eb:{if(zc(v[b+1612>>2],101211)){break Eb}d=xc(e,b+1608|0,0,696,0,101211,34383,1,0);if((d|0)!=1){Eb(146413,6412);v[b+144>>2]=d;Fb(276579,b+144|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6413);v[b+128>>2]=d;Fb(276579,b+128|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break Eb}Eb(146413,6414);v[b+112>>2]=d;Fb(276579,b+112|0);break $a}if((Wf(v[b+1612>>2],101211,b+1608|0)|0)!=1){Eb(146413,6418);Fb(292439,0);d=-11;break $a}f=v[v[e+4>>2]+216>>2];h=uF(e);if((f|0)>0){c=0;while(1){Fb:{d=h+(c<<2)|0;if(zc(v[b+1608>>2],v[v[d>>2]+104>>2])){break Fb}d=v[d>>2];d=xc(e,b+1604|0,0,696,0,v[d+104>>2],v[d+108>>2],1,0);if((d|0)!=1){Eb(146413,6431);v[b+96>>2]=d;Fb(276579,b+96|0);break $a}d=yc(e,v[b+1608>>2],v[b+1604>>2]);if((d|0)!=1){Eb(146413,6432);v[b+80>>2]=d;Fb(276579,b+80|0);break $a}d=wc(e,b+1604|0);if((d|0)==1){break Fb}Eb(146413,6433);v[b+64>>2]=d;Fb(276579,b- -64|0);break $a}c=c+1|0;if((f|0)!=(c|0)){continue}break}}Gb:{if(zc(v[b+1612>>2],103122)){break Gb}d=xc(e,b+1608|0,0,696,0,103122,48944,1,0);if((d|0)!=1){Eb(146413,6442);v[b+48>>2]=d;Fb(276579,b+48|0);break $a}d=yc(e,v[b+1612>>2],v[b+1608>>2]);if((d|0)!=1){Eb(146413,6443);v[b+32>>2]=d;Fb(276579,b+32|0);break $a}d=wc(e,b+1608|0);if((d|0)==1){break Gb}Eb(146413,6444);v[b+16>>2]=d;Fb(276579,b+16|0);break $a}d=1;c=v[v[e+4>>2]+8>>2];f=v[c+8>>2];if((f|0)<=0){break $a}h=v[c+4>>2];c=0;while(1){k=h+(c<<2)|0;d=v[v[k>>2]+40>>2];d=Sd(d,Pb(d)+1|0,1,146379,6457);v[b+1600>>2]=d;if(!d){Eb(146413,6457);Fb(276543,0);d=-1;break $a}d=xka(e,v[b+1612>>2],v[k>>2],d);if((d|0)!=1){Eb(146413,6458);v[b>>2]=d;Fb(276579,b);break $a}Zb(b+1600|0,146379,6459);d=1;c=c+1|0;if((f|0)!=(c|0)){continue}break}}ub=b+1616|0;b=d;if((b|0)!=1){break _a}i=252;f=v[e+4>>2];d=ub-32|0;ub=d;c=v[e+12>>2];t[v[c+12>>2]]=0;v[c+20>>2]=0;b=v[c>>2];v[d+28>>2]=b;Hb:{if(b){while(1){b=zb[v[b+4>>2]](v[f+4>>2],b,c,d+28|0)|0;if((b|0)!=1){Eb(155345,951);v[d+16>>2]=b;Fb(276579,d+16|0);Eb(155345,402);v[d>>2]=b;Fb(276579,d);break Hb}b=v[c+12>>2];if(!w[b+v[c+20>>2]|0]){t[b|0]=0;v[c+20>>2]=0}b=v[d+28>>2];if(b){continue}break}}b=1}ub=d+32|0;d=1;if((b|0)==1){break Za}}Eb(155296,i);v[j>>2]=b;Fb(276579,j);d=b}ub=j+16|0;if((d|0)==1){break c}Eb(153888,505);v[g+304>>2]=d;Fb(276579,g+304|0);a=d;break c}Kb(e,0,267142,0);Kb(e,0,363955,0);a=Kt(e,0);if((a|0)==1){break A}Eb(153888,152);v[g+192>>2]=a;Fb(276579,g+192|0)}Eb(153888,494);v[g+128>>2]=a;Fb(276579,g+128|0);break c}a=1;if(j){break c}b=J4(e,A[g+512>>3],A[g+504>>3],A[v[e+4>>2]+1296>>3]);if((b|0)==1){break c}Eb(153888,499);v[g+160>>2]=b;Fb(276579,g+160|0);a=b;break c}v[g+112>>2]=v[b>>2];qe(355437,g+112|0);v[g+96>>2]=v[b>>2];qe(305002,g+96|0);a=v[107065];Ib:{if(!((a|0)>=0&(!a|v[108970]!=(a&1073741823)))){Jb:{if(v[107066]==10){break Jb}a=v[107051];if((a|0)==v[107050]){break Jb}v[107051]=a+1;t[a|0]=10;break Ib}wv(428184,10);break Ib}a=v[107065];v[107065]=a?a:1073741823;Kb:{Lb:{if(v[107066]==10){break Lb}a=v[107051];if((a|0)==v[107050]){break Lb}v[107051]=a+1;t[a|0]=10;break Kb}wv(428184,10)}v[107065]=0}}a=1}ub=g+1568|0;d=a;if((d|0)!=1){break b}n=564;d=ne(p);if((d|0)==1){break a}}Eb(153888,n);v[l>>2]=d;Fb(276579,l);o=d}ub=l+16|0;if((o|0)!=1){a=ub-16|0;ub=a;v[a>>2]=o;Fb(252477,a);b=o+18|0;if(b>>>0<=19){b=v[(b<<2)+367552>>2]}else{b=126516}Fb(b,0);Fb(365309,0);ub=a+16|0;a=-1}else{a=0}return a|0}function QL(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,u=0,x=0,y=0;c=v[a+16>>2];d=v[c+4>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+8>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+12>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+16>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+20>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+24>>2];zb[v[v[d>>2]+8>>2]](d);d=v[c+28>>2];zb[v[v[d>>2]+8>>2]](d);Wb(c+40|0,0,256);v[a+9096>>2]=0;t[a+9393|0]=0;t[a+9394|0]=0;t[a+9232|0]=w[a+9232|0]&240;t[a+9313|0]=w[a+9313|0]&240;c=v[a+20>>2];a:{if(w[c+4|0]){if(!(v[108579]<0|v[108549]>0)){v[c+88>>2]=0}if(!(v[108563]<2|v[108533]>2)){v[c+24>>2]=2}if(!(v[108564]<=0|v[108534]>1)){v[c+28>>2]=1}t[a+865|0]=w[c+5|0];f=ub-192|0;ub=f;t[f+191|0]=0;b=v[a+16>>2];v[b+272>>2]=-3;b=v[b+4>>2];zb[v[v[b>>2]+12>>2]](b);v[a+9092>>2]=0;v[a+9100>>2]=0;h=v[a+20>>2];if(v[h+20>>2]==-1){t[a+680|0]=0;v[a+672>>2]=0;v[a+676>>2]=0;m=a+32|0;zb[v[v[a+32>>2]+148>>2]](m,a+280|0,0);b:{if(v[a+320>>2]!=-1){break b}i=v[a+280>>2];d=v[a+284>>2]-i>>3;if((d|0)<=0){break b}c=0;h=0;if(d>>>0>=4){k=d&2147483644;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break b}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}zb[v[v[a+32>>2]+468>>2]](m);c:{if(v[a+320>>2]==1){break c}i=v[a+280>>2];d=v[a+284>>2]-i>>3;d:{if((d|0)<=0){break d}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break d}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}i=v[a+136>>2];d=v[a+140>>2]-i>>3;if((d|0)<=0){break c}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break c}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}v[a+320>>2]=1;zb[v[v[a+32>>2]+468>>2]](m);h=v[a+20>>2]}t[a+864|0]=1;v[a+872>>2]=v[h+116>>2];i=a+8420|0;b=v[a+216>>2];d=v[a+8424>>2];e=v[a+8420>>2];c=d-e>>3;e:{if((b|0)>(c|0)){v[f+160>>2]=0;v[f+164>>2]=0;fe(i,d,b-c|0,f+160|0);break e}if(b>>>0>c>>>0){Jd(i,b-c|0);break e}if(b>>>0>=c>>>0){break e}v[a+8424>>2]=e+(b<<3)}v[f+176>>2]=858993459;v[f+180>>2]=1072902963;v[f+168>>2]=0;v[f+160>>2]=0;v[f+164>>2]=1;k=f+168|0;Mc(k,1);v[111924]=0;v[f+152>>2]=858993459;v[f+156>>2]=1072902963;v[f+144>>2]=0;v[f+136>>2]=0;v[f+140>>2]=1;q=f+144|0;O(2282,q|0,1);b=v[111924];v[111924]=0;f:{g:{h:{i:{j:{k:{l:{m:{n:{if((b|0)!=1){v[111924]=0;m=a+32|0;x=a+1696|0;da(2495,a|0,m|0,x|0,1,1);b=v[111924];v[111924]=0;o:{if((b|0)==1){break o}s=a+280|0;if(v[a+600>>2]==1){break n}p:{q:{r:{s:{t:{b=v[a+664>>2];if(b+15>>>0<11){break t}switch(b+2|0){case 2:break s;case 0:case 1:case 3:break t;default:break q}}if((b|0)>0){break n}c=b+15|0;if(c>>>0>16){break q}if(1<<c&91871){break r}if((c|0)==5){break n}if((c|0)!=8){break q}break p}if(v[a+528>>2]-3>>>0>=3){break q}break n}c=b+15|0;if(c>>>0>16){break q}if(!(1<<c&91647)){if((c|0)!=9){break q}break p}if((b|0)==-5){break p}}j=a+352|0;u:{v:{w:{x:{y:{z:{A:{if(v[a+284>>2]!=v[a+280>>2]){if(!w[a+416|0]){v[111924]=0;U(2343,j|0);b=v[111924];v[111924]=0;if((b|0)==1){break o}}b=v[a+412>>2];c=v[v[b>>2]+48>>2];v[111924]=0;R(c|0,b|0,i|0,s|0);b=v[111924];v[111924]=0;if((b|0)==1){break o}d=v[a+8424>>2];h=v[a+8420>>2];break A}d=v[a+8424>>2];h=v[a+8420>>2];if((d|0)==(h|0)){v[f+120>>2]=0;v[f+112>>2]=0;v[f+116>>2]=0;break z}Wb(h,0,d-h&-8)}v[f+120>>2]=0;v[f+112>>2]=0;v[f+116>>2]=0;if((d|0)==(h|0)){break z}c=d-h|0;if((c|0)<0){break w}v[111924]=0;b=S(2157,c|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break y}v[f+116>>2]=b;v[f+112>>2]=b;d=b+c|0;v[f+120>>2]=d;Kc(b,h,c);v[f+116>>2]=d}v[111924]=0;l=Mp(m,f+112|0);b=v[111924];v[111924]=0;B:{if((b|0)!=1){C:{b=v[f+112>>2];if(b){v[f+116>>2]=b;Gb(b)}v[a+868>>2]=50;D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{if(!(l<.1|l>.9)){v[f+108>>2]=0;v[f+100>>2]=0;v[f+104>>2]=0;b=v[a+8424>>2];d=v[a+8420>>2];if((b|0)!=(d|0)){c=b-d|0;if((c|0)<0){break x}v[111924]=0;b=S(2157,c|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break B}v[f+104>>2]=b;v[f+100>>2]=b;e=b+c|0;v[f+108>>2]=e;Kc(b,d,c);v[f+104>>2]=e}v[111924]=0;c=N(2496,a|0,f+100|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break D}b=v[f+100>>2];if(b){v[f+104>>2]=b;Gb(b)}if(c){break V}}e=1;while(1){v[111924]=0;da(2495,a|0,m|0,x|0,0,0);b=v[111924];v[111924]=0;if((b|0)==1){break O}if(v[a+600>>2]==1){break n}W:{X:{c=v[a+664>>2];d=c+15|0;h=d>>>0>16;if(h){break X}Y:{if(!(1<<d&92159)){b=c;if((d|0)==11){break W}if((d|0)!=15){break X}g=v[a+528>>2];if(g-3>>>0>=3){break Y}break n}if((c|0)>0){break n}b=c;if(d>>>0<12){break W}Z:{switch(b+2|0){case 0:case 1:break W;case 2:break Z;default:break X}}g=v[a+528>>2]}b=-15;g=g+2|0;if(g>>>0>=8){break W}b=v[(g<<2)+384580>>2];break W}b=-15}if((b|0)==-10|e>>>0>=21){break n}_:{if(h){break _}b=1<<d;if(!(b&91903)){if((d|0)==8){break p}break _}if(h){break _}if(!(b&91647)){if((d|0)!=9){break _}break p}if((c|0)==-5){break p}}$:{aa:{ba:{ca:{da:{if(v[a+284>>2]==v[a+280>>2]){d=v[a+8424>>2];h=v[a+8420>>2];if((d|0)==(h|0)){v[f+120>>2]=0;v[f+112>>2]=0;v[f+116>>2]=0;break ca}Wb(h,0,d-h&-8);break da}if(!w[a+416|0]){v[111924]=0;U(2343,j|0);b=v[111924];v[111924]=0;if((b|0)==1){break O}}b=v[a+412>>2];c=v[v[b>>2]+48>>2];v[111924]=0;R(c|0,b|0,i|0,s|0);b=v[111924];v[111924]=0;if((b|0)==1){break O}d=v[a+8424>>2];h=v[a+8420>>2]}v[f+120>>2]=0;v[f+112>>2]=0;v[f+116>>2]=0;if((d|0)==(h|0)){break ca}c=d-h|0;if((c|0)<0){break w}v[111924]=0;b=S(2157,c|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break ba}v[f+116>>2]=b;v[f+112>>2]=b;d=b+c|0;v[f+120>>2]=d;Kc(b,h,c);v[f+116>>2]=d}v[111924]=0;l=Mp(m,f+112|0);b=v[111924];v[111924]=0;if((b|0)==1){break C}b=v[f+112>>2];if(b){v[f+116>>2]=b;Gb(b)}v[a+868>>2]=50;e=e+1|0;if(l<.1|l>.9){continue}v[f+108>>2]=0;v[f+100>>2]=0;v[f+104>>2]=0;b=v[a+8424>>2];d=v[a+8420>>2];if((b|0)==(d|0)){break $}c=b-d|0;if((c|0)>=0){break aa}break x}a=M()|0;break h}v[111924]=0;b=S(2157,c|0)|0;h=v[111924];v[111924]=0;if((h|0)==1){break U}v[f+104>>2]=b;v[f+100>>2]=b;h=b+c|0;v[f+108>>2]=h;Kc(b,d,c);v[f+104>>2]=h}v[111924]=0;c=N(2496,a|0,f+100|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break D}b=v[f+100>>2];if(b){v[f+104>>2]=b;Gb(b)}if(!c){continue}break}}t[a+864|0]=0;if(!w[a+9392|0]){break P}d=v[f+164>>2];c=v[v[a+4552>>2]+40>>2];if((d|0)>=(c|0)){break R}e=(c|0)<0;l=A[f+176>>3]*+(c|0);if(!(D(l)<2147483648)){break T}b=~~l;break S}a=M()|0;break h}b=-2147483648}if(!e){v[f+160>>2]=c}b=(b|0)>(c|0)?b:c;b=(b|0)<=1?1:b;if((b|0)==(d|0)){break Q}v[f+164>>2]=b;if(v[f+160>>2]<=0){Gb(v[f+168>>2]);v[f+168>>2]=0;v[111924]=0;O(2282,k|0,v[f+164>>2]);b=v[111924];v[111924]=0;if((b|0)==1){break j}break Q}v[111924]=0;O(2497,k|0,b|0);b=v[111924];v[111924]=0;if((b|0)==1){break j}break Q}if((c|0)<0){v[f+160>>2]=0;break Q}v[f+160>>2]=c}d=v[f+140>>2];c=v[v[a+4552>>2]+184>>2];ea:{if((d|0)<(c|0)){e=(c|0)<0;l=A[f+152>>3]*+(c|0);fa:{if(D(l)<2147483648){b=~~l;break fa}b=-2147483648}if(!e){v[f+136>>2]=c}b=(b|0)>(c|0)?b:c;b=(b|0)<=1?1:b;if((b|0)==(d|0)){break ea}v[f+140>>2]=b;if(v[f+136>>2]<=0){Gb(v[f+144>>2]);v[f+144>>2]=0;v[111924]=0;O(2282,q|0,v[f+140>>2]);b=v[111924];v[111924]=0;if((b|0)==1){break j}break ea}v[111924]=0;O(2497,q|0,b|0);b=v[111924];v[111924]=0;if((b|0)==1){break j}break ea}if((c|0)<0){v[f+136>>2]=0;break ea}v[f+136>>2]=c}v[111924]=0;ea(2498,m|0,v[f+168>>2],v[f+144>>2],v[f+160>>2],v[f+136>>2])|0;b=v[111924];v[111924]=0;if((b|0)==1){break j}}b=v[a+16>>2];v[b+176>>2]=v[b+176>>2]+1;v[a+9016>>2]=0;v[a+9024>>2]=0;v[a+9e3>>2]=0;v[a+9020>>2]=v[a+448>>2];ga:{k=v[a+8>>2];ha:{if((k|0)<3){break ha}v[a+8>>2]=3;b=v[v[a+12>>2]+12>>2];v[111924]=0;Q(2258,b|0,201243,48)|0;b=v[111924];v[111924]=0;ia:{ja:{if((b|0)==1){break ja}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;d=f+124|0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;ka:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;h=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break ka}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}d=f+124|0;c=v[d>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,h|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ja}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;la:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;h=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break la}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}d=f+124|0;c=v[d>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,h|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ja}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,b|0,201096,48)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ja}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;ma:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;e=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break ma}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];d=v[c+4>>2]-1|0;v[c+4>>2]=d;if((d|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,e|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break ja}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break ia}}a=M()|0;break h}v[a+8>>2]=k;if((k|0)==3){break ha}v[a+8>>2]=4;b=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,b|0,204708,48)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ga}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;d=f+124|0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break ga}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;na:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;e=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break na}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];d=v[c+4>>2]-1|0;v[c+4>>2]=d;if((d|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,e|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break ga}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break ga}v[a+8>>2]=k}b=v[v[a+20>>2]+128>>2];if((b|0)<(k|0)){v[a+8>>2]=b}v[111924]=0;U(2499,a|0);b=v[111924];v[111924]=0;oa:{if((b|0)==1){break oa}v[111924]=0;O(2500,a|0,f+191|0);b=v[111924];v[111924]=0;if((b|0)==1){break oa}t[a+9392|0]=0;e=w[v[a+20>>2]+7|0];pa:{h=w[f+191|0];if(!h){break pa}i=v[a+8>>2];qa:{if((i|0)<=2){v[v[a+16>>2]+272>>2]=-11;break qa}v[a+8>>2]=3;b=v[v[a+12>>2]+12>>2];v[111924]=0;Q(2258,b|0,201292,48)|0;b=v[111924];v[111924]=0;ra:{sa:{if((b|0)==1){break sa}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;d=f+124|0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break sa}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;ta:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;g=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break ta}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];d=v[c+4>>2]-1|0;v[c+4>>2]=d;if((d|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,g|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break sa}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)!=1){break ra}}a=M()|0;break h}v[a+8>>2]=i;b=w[f+191|0];v[v[a+16>>2]+272>>2]=-11;if(!b){break pa}}h=0;q=1;c=0;break F}q=(h|0)!=0;d=(e|0)!=0;y=a+7600|0;i=a+5936|0;h=0;b=0;ua:{va:{while(1){o=v[v[a+16>>2]+120>>2];v[a+9092>>2]=1;wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{n=v[a+8>>2];if((n|0)>=4){v[a+8>>2]=4;c=v[v[a+12>>2]+16>>2];e=v[v[c>>2]-12>>2];v[111924]=0;g=f+124|0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;Da:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;r=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Da}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}g=f+124|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,r|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,201070,25)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;Ea:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;r=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Ea}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}g=f+124|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,r|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,208130,25)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;Fa:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;r=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Fa}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}g=f+124|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,r|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,201070,25)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;Ga:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;r=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Ga}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}g=f+124|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,r|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;Ha:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;j=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break Ha}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}e=v[f+124>>2];g=v[e+4>>2]-1|0;v[e+4>>2]=g;if((g|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,j|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break Ca}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ca}v[a+8>>2]=n}t[a+9392|0]=b&1;v[111924]=0;j=!h;da(2495,a|0,m|0,x|0,j|0,j|0);b=v[111924];v[111924]=0;if((b|0)==1){break E}l=A[v[a+20>>2]+200>>3];v[111924]=0;b=Z(2501,a|0,+l)|0;c=v[111924];v[111924]=0;if((c|0)==1){break E}t[f+191|0]=b;e=v[a+16>>2];v[e+176>>2]=v[e+176>>2]+1;Ia:{Ja:{Ka:{La:{Ma:{Na:{c=v[a+664>>2];b=c;g=b+15>>>0<11;Oa:{Pa:{if(g){break Pa}Qa:{switch(b+4|0){case 4:g=v[a+528>>2];b=g+2|0;if(b>>>0<8){b=v[(b<<2)+384580>>2]}else{b=-15}v[e+272>>2]=b;b=w[a+9392|0];t[a+9392|0]=0;b=(b|0)!=0;break Oa;case 0:break Ja;case 2:case 3:case 5:break Pa;default:break Qa}}b=-15}v[e+272>>2]=b;b=w[a+9392|0];t[a+9392|0]=0;b=(b|0)!=0;if(g){break Na}Ra:{switch(c+2|0){case 0:case 1:case 3:break Na;case 2:break Ra;default:break La}}g=v[a+528>>2]}if((g|0)!=3){break Ma}break wa}if((c|0)==1){break wa}if(c){break Ia}g=v[a+528>>2]}if((g|0)!=4){break Ka}break Ba}if(c){break Ka}if(v[a+528>>2]==4){break Ba}}d=v[a+8>>2];break Aa}v[e+272>>2]=-4;t[a+9392|0]=0}d=v[a+8>>2];break za}a=M()|0;break h}c=0;d=v[a+8>>2];if((d|0)<4){break Aa}v[a+8>>2]=4;b=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,b|0,208071,26)|0;b=v[111924];v[111924]=0;Sa:{if((b|0)==1){break Sa}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;e=f+124|0;c=v[(b+c|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break Sa}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Ta:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;i=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Ta}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,i|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Sa}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Sa}v[a+8>>2]=d;c=v[a+664>>2];break Aa}a=M()|0;break h}if(v[a+528>>2]!=5|c){break za}if((d|0)<4){break xa}v[a+8>>2]=4;b=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,b|0,208043,27)|0;b=v[111924];v[111924]=0;Ua:{if((b|0)==1){break Ua}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;e=f+124|0;c=v[(b+c|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break Ua}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Va:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;i=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Va}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,i|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Ua}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ua}v[a+8>>2]=d;break ya}a=M()|0;break h}if((d|0)<4){break xa}}v[a+8>>2]=4;b=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,b|0,250594,24)|0;b=v[111924];v[111924]=0;Wa:{if((b|0)==1){break Wa}c=v[a+664>>2];Xa:{if(c+15>>>0<12){break Xa}Ya:{switch(c+2|0){default:c=-15;break Xa;case 0:case 1:case 3:break Xa;case 2:break Ya}}c=-15;b=v[a+528>>2]+2|0;if(b>>>0>=8){break Xa}c=v[(b<<2)+384580>>2]}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;N(2359,b|0,c|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Wa}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;e=f+124|0;c=v[(b+c|0)+28>>2];v[e>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break Wa}v[111924]=0;c=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Za:{if((e|0)!=1){e=v[v[c>>2]+28>>2];v[111924]=0;i=N(e|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break Za}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];e=v[c+4>>2]-1|0;v[c+4>>2]=e;if((e|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,i|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Wa}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Wa}v[a+8>>2]=d;break xa}a=M()|0;break h}c=0;q=1;break F}_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{if((o|0)==v[e+120>>2]){c=1;i=v[a+8>>2];if((i|0)>0){v[a+8>>2]=1;b=v[v[a+12>>2]+4>>2];v[111924]=0;Q(2258,b|0,208688,65)|0;b=v[111924];v[111924]=0;if((b|0)==1){break mb}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];d=v[v[b>>2]-12>>2];v[111924]=0;e=f+124|0;d=v[(b+d|0)+28>>2];v[e>>2]=d;v[d+4>>2]=v[d+4>>2]+1;d=v[111924];v[111924]=0;if((d|0)==1){break mb}v[111924]=0;d=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;nb:{if((e|0)!=1){e=v[v[d>>2]+28>>2];v[111924]=0;g=N(e|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break nb}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}d=v[f+124>>2];e=v[d+4>>2]-1|0;v[d+4>>2]=e;if((e|0)==-1){zb[v[v[d>>2]+8>>2]](d)}v[111924]=0;N(2270,b|0,g|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break mb}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break mb}v[a+8>>2]=i}t[f+191|0]=1;break F}v[111924]=0;da(2502,a|0,m|0,k|0,j|0,j|0);c=v[111924];v[111924]=0;if((c|0)==1){break E}c=v[a+72>>2];v[f+132>>2]=0;v[f+124>>2]=0;v[f+128>>2]=0;ob:{if(!c){break ob}v[111924]=0;O(2198,f+124|0,c|0);c=v[111924];v[111924]=0;if((c|0)!=1){break ob}a=M()|0;break G}c=v[a+216>>2];v[f+96>>2]=0;v[f+88>>2]=0;v[f+92>>2]=0;pb:{if(!c){break pb}v[111924]=0;O(2198,f+88|0,c|0);c=v[111924];v[111924]=0;if((c|0)!=1){break pb}a=M()|0;break H}v[111924]=0;N(2503,m|0,f+124|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break I}v[111924]=0;N(2504,m|0,f+88|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break I}qb:{if(!h){v[111924]=0;U(2505,a|0);c=v[111924];v[111924]=0;if((c|0)!=1){break qb}break I}if(w[v[a+20>>2]+6|0]){v[111924]=0;O(2506,a|0,0);c=v[111924];v[111924]=0;if((c|0)==1){break I}break qb}v[111924]=0;O(2507,a|0,0);c=v[111924];v[111924]=0;if((c|0)==1){break I}}v[a+9092>>2]=2;rb:{o=v[a+8>>2];if((o|0)>=4){v[a+8>>2]=4;c=v[v[a+12>>2]+16>>2];e=v[v[c>>2]-12>>2];v[111924]=0;g=f+76|0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;sb:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;n=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break sb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=f+76|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,n|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,201070,25)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;tb:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;n=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break tb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=f+76|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,n|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,208098,31)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;ub:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;n=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break ub}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=f+76|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,n|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,c|0,201070,25)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;vb:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;n=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break vb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=f+76|0;e=v[g>>2];j=v[e+4>>2]-1|0;v[e+4>>2]=j;if((j|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,n|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}c=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[c>>2]-12>>2];v[111924]=0;e=v[(c+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;wb:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;j=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break wb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}e=v[f+76>>2];g=v[e+4>>2]-1|0;v[e+4>>2]=g;if((g|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,c|0,j|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break rb}v[111924]=0;S(2271,c|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break rb}v[a+8>>2]=o}c=1;if(d&1){break db}v[111924]=0;da(2495,a|0,i|0,y|0,1,1);d=v[111924];v[111924]=0;if((d|0)==1){break I}j=v[a+8>>2];if((j|0)>=4){v[a+8>>2]=4;d=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,d|0,247588,10)|0;d=v[111924];v[111924]=0;if((d|0)==1){break lb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;N(2359,d|0,h|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break lb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,d|0,251755,17)|0;d=v[111924];v[111924]=0;if((d|0)==1){break lb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[(v[v[d>>2]-12>>2]+d|0)+8>>2]=10;d=v[v[a+5936>>2]+372>>2];v[111924]=0;l=+aa(d|0,i|0);d=v[111924];v[111924]=0;if((d|0)==1){break lb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Z(2412,d|0,+l)|0;d=v[111924];v[111924]=0;if((d|0)==1){break lb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];e=v[v[d>>2]-12>>2];v[111924]=0;g=f+76|0;e=v[(d+e|0)+28>>2];v[g>>2]=e;v[e+4>>2]=v[e+4>>2]+1;e=v[111924];v[111924]=0;if((e|0)==1){break lb}v[111924]=0;e=N(1122,g|0,448956)|0;g=v[111924];v[111924]=0;xb:{if((g|0)!=1){g=v[v[e>>2]+28>>2];v[111924]=0;o=N(g|0,e|0,10)|0;e=v[111924];v[111924]=0;if((e|0)!=1){break xb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}e=v[f+76>>2];g=v[e+4>>2]-1|0;v[e+4>>2]=g;if((g|0)==-1){zb[v[v[e>>2]+8>>2]](e)}v[111924]=0;N(2270,d|0,o|0)|0;e=v[111924];v[111924]=0;if((e|0)==1){break lb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break lb}v[a+8>>2]=j}d=v[v[i>>2]+372>>2];v[111924]=0;l=+aa(d|0,i|0);d=v[111924];v[111924]=0;if((d|0)==1){break I}d=v[a+6568>>2];yb:{if(!(l>-1e-20)){e=0;if(d){break ib}e=v[a+6432>>2];if((e&-2)==4){break yb}c=0;if(!w[f+191|0]){break hb}break fb}if(d+15>>>0<12){break jb}zb:{switch(d+2|0){case 0:case 1:case 3:break jb;case 2:break zb;default:break kb}}e=v[a+6432>>2]}d=-15;e=e+2|0;if(e>>>0>=8){break jb}d=v[(e<<2)+384580>>2];break jb}a=M()|0;break H}a=M()|0;break h}a=M()|0;break H}d=-15}v[v[a+16>>2]+276>>2]=d;d=v[v[a+5936>>2]+372>>2];v[111924]=0;l=+aa(d|0,i|0);d=v[111924];v[111924]=0;if((d|0)==1){break I}A[v[a+16>>2]+280>>3]=l;e=0;d=v[a+6568>>2];Ab:{if(d){break Ab}Bb:{Cb:{Db:{switch(v[a+6432>>2]-4|0){case 0:o=v[a+8>>2];if((o|0)<4){break Bb}v[a+8>>2]=4;d=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,d|0,207824,32)|0;d=v[111924];v[111924]=0;Eb:{Fb:{if((d|0)==1){break Fb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];g=v[v[d>>2]-12>>2];v[111924]=0;j=f+76|0;g=v[(d+g|0)+28>>2];v[j>>2]=g;v[g+4>>2]=v[g+4>>2]+1;g=v[111924];v[111924]=0;if((g|0)==1){break Fb}v[111924]=0;g=N(1122,j|0,448956)|0;j=v[111924];v[111924]=0;Gb:{if((j|0)!=1){j=v[v[g>>2]+28>>2];v[111924]=0;n=N(j|0,g|0,10)|0;g=v[111924];v[111924]=0;if((g|0)!=1){break Gb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=v[f+76>>2];j=v[g+4>>2]-1|0;v[g+4>>2]=j;if((j|0)==-1){zb[v[v[g>>2]+8>>2]](g)}v[111924]=0;N(2270,d|0,n|0)|0;g=v[111924];v[111924]=0;if((g|0)==1){break Fb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break Eb}}a=M()|0;break H}v[a+8>>2]=o;d=v[a+6568>>2];if(d|v[a+6432>>2]!=5){break Cb}break;case 1:break Db;default:break Bb}}o=v[a+8>>2];if((o|0)<4){break Bb}v[a+8>>2]=4;d=v[v[a+12>>2]+16>>2];v[111924]=0;Q(2258,d|0,207790,33)|0;d=v[111924];v[111924]=0;if((d|0)==1){break cb}d=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];g=v[v[d>>2]-12>>2];v[111924]=0;j=f+76|0;g=v[(d+g|0)+28>>2];v[j>>2]=g;v[g+4>>2]=v[g+4>>2]+1;g=v[111924];v[111924]=0;if((g|0)==1){break cb}v[111924]=0;g=N(1122,j|0,448956)|0;j=v[111924];v[111924]=0;Hb:{if((j|0)!=1){j=v[v[g>>2]+28>>2];v[111924]=0;n=N(j|0,g|0,10)|0;g=v[111924];v[111924]=0;if((g|0)!=1){break Hb}}a=M()|0;b=v[f+76>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break H}g=v[f+76>>2];j=v[g+4>>2]-1|0;v[g+4>>2]=j;if((j|0)==-1){zb[v[v[g>>2]+8>>2]](g)}v[111924]=0;N(2270,d|0,n|0)|0;g=v[111924];v[111924]=0;if((g|0)==1){break cb}v[111924]=0;S(2271,d|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break cb}v[a+8>>2]=o;d=v[a+6568>>2]}if(d){break Ab}}e=(v[a+6432>>2]&-2)==4;d=0}t[f+191|0]=1}if(w[f+191|0]|e){break gb}}c=v[a+6120>>2];v[f+84>>2]=0;v[f+76>>2]=0;v[f+80>>2]=0;Ib:{if(!c){break Ib}v[111924]=0;O(2198,f+76|0,c|0);c=v[111924];v[111924]=0;if((c|0)!=1){break Ib}a=M()|0;break J}v[111924]=0;N(2508,i|0,f+76|0)|0;c=v[111924];v[111924]=0;Jb:{if((c|0)!=1){c=v[a+5976>>2];v[f+72>>2]=0;v[f+64>>2]=0;v[f+68>>2]=0;Kb:{if(!c){break Kb}v[111924]=0;O(2198,f- -64|0,c|0);c=v[111924];v[111924]=0;if((c|0)!=1){break Kb}a=M()|0;break K}v[111924]=0;N(2503,i|0,f- -64|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Jb}c=v[v[i>>2]+372>>2];v[111924]=0;l=+aa(c|0,i|0);c=v[111924];v[111924]=0;if((c|0)==1){break Jb}v[f+60>>2]=0;v[f+52>>2]=0;v[f+56>>2]=0;Lb:{Mb:{c=v[f+128>>2];e=v[f+124>>2];if((c|0)!=(e|0)){d=c-e|0;if((d|0)<0){v[111924]=0;U(2426,f+52|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+52>>2];if(!b){break K}v[f+56>>2]=b;Gb(b);break K}v[111924]=0;c=S(2157,d|0)|0;g=v[111924];v[111924]=0;if((g|0)==1){break Mb}v[f+56>>2]=c;v[f+52>>2]=c;g=c+d|0;v[f+60>>2]=g;Kc(c,e,d);v[f+56>>2]=g}v[f+48>>2]=0;v[f+40>>2]=0;v[f+44>>2]=0;c=v[f+92>>2];e=v[f+88>>2];if((c|0)!=(e|0)){break Lb}break $a}a=M()|0;break K}d=c-e|0;if((d|0)<0){v[111924]=0;U(2426,f+40|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+40>>2];if(!b){break L}v[f+44>>2]=b;Gb(b);break L}v[111924]=0;c=S(2157,d|0)|0;g=v[111924];v[111924]=0;if((g|0)!=1){v[f+44>>2]=c;v[f+40>>2]=c;g=c+d|0;v[f+48>>2]=g;Kc(c,e,d);v[f+44>>2]=g;break $a}a=M()|0;break L}a=M()|0;break J}a=M()|0;break K}if(d){break eb}c=e}if(c){break db}d=0;if((v[a+6432>>2]&-2)!=4){break _a}break db}d=0;if(!e){break _a}}d=v[a+216>>2];v[f+84>>2]=0;v[f+76>>2]=0;v[f+80>>2]=0;Nb:{if(!d){break Nb}v[111924]=0;O(2198,f+76|0,d|0);d=v[111924];v[111924]=0;if((d|0)!=1){break Nb}a=M()|0;break ab}v[111924]=0;N(2508,m|0,f+76|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break bb}v[f+12>>2]=0;v[f+4>>2]=0;v[f+8>>2]=0;Ob:{d=v[f+80>>2];g=v[f+76>>2];if((d|0)!=(g|0)){e=d-g|0;if((e|0)<0){v[111924]=0;U(2426,f+4|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+4>>2];if(!b){break ab}v[f+8>>2]=b;Gb(b);break ab}v[111924]=0;d=S(2157,e|0)|0;j=v[111924];v[111924]=0;if((j|0)==1){break Ob}v[f+8>>2]=d;v[f+4>>2]=d;j=d+e|0;v[f+12>>2]=j;Kc(d,g,e);v[f+8>>2]=j}v[111924]=0;R(2509,a|0,f+4|0,1);d=v[111924];v[111924]=0;Pb:{Qb:{if((d|0)!=1){d=v[f+4>>2];if(d){v[f+8>>2]=d;Gb(d)}d=v[a+8952>>2];e=v[a+8956>>2];if(!((d|0)<=0&(e|0)<=0)){t[f+191|0]=0}if(d|e){break Qb}t[f+191|0]=1;break Pb}a=M()|0;b=v[f+4>>2];if(!b){break ab}v[f+8>>2]=b;Gb(b);break ab}if(w[f+191|0]){break Pb}v[111924]=0;O(2510,a|0,0);d=v[111924];v[111924]=0;if((d|0)==1){break bb}}d=v[f+76>>2];if(d){v[f+80>>2]=d;Gb(d)}d=c;break _a}a=M()|0;break ab}a=M()|0;break H}a=M()|0}b=v[f+76>>2];if(!b){break H}v[f+80>>2]=b;Gb(b);break H}v[f+36>>2]=0;v[f+28>>2]=0;v[f+32>>2]=0;Rb:{c=v[f+80>>2];e=v[f+76>>2];if((c|0)==(e|0)){break Rb}d=c-e|0;if((d|0)<0){v[111924]=0;U(2426,f+28|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+28>>2];if(!b){break M}v[f+32>>2]=b;Gb(b);break M}v[111924]=0;c=S(2157,d|0)|0;g=v[111924];v[111924]=0;if((g|0)!=1){v[f+32>>2]=c;v[f+28>>2]=c;g=c+d|0;v[f+36>>2]=g;Kc(c,e,d);v[f+32>>2]=g;break Rb}a=M()|0;break M}v[f+24>>2]=0;v[f+16>>2]=0;v[f+20>>2]=0;c=v[f+68>>2];e=v[f+64>>2];if((c|0)!=(e|0)){d=c-e|0;if((d|0)<0){v[111924]=0;U(2426,f+16|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+16>>2];if(!b){break N}v[f+20>>2]=b;Gb(b);break N}v[111924]=0;c=S(2157,d|0)|0;g=v[111924];v[111924]=0;if((g|0)==1){break ua}v[f+20>>2]=c;v[f+16>>2]=c;g=c+d|0;v[f+24>>2]=g;Kc(c,e,d);v[f+20>>2]=g}v[111924]=0;fb(2511,a|0,+l,f+52|0,f+40|0,f+28|0,f+16|0);c=v[111924];v[111924]=0;if((c|0)==1){break va}c=v[f+16>>2];if(c){v[f+20>>2]=c;Gb(c)}c=v[f+28>>2];if(c){v[f+32>>2]=c;Gb(c)}c=v[f+40>>2];if(c){v[f+44>>2]=c;Gb(c)}c=v[f+52>>2];if(c){v[f+56>>2]=c;Gb(c)}c=v[f+64>>2];if(c){v[f+68>>2]=c;Gb(c)}c=v[f+76>>2];if(c){v[f+80>>2]=c;Gb(c)}d=0}v[a+9016>>2]=v[a+9016>>2]+1;c=v[f+88>>2];if(c){v[f+92>>2]=c;Gb(c)}c=v[f+124>>2];if(c){v[f+128>>2]=c;Gb(c)}h=h+1|0;if(!w[f+191|0]){continue}break}c=0;h=1;break F}a=M()|0;b=v[f+16>>2];if(!b){break N}v[f+20>>2]=b;Gb(b);break N}a=M()|0;break N}a=M()|0;break h}a=M()|0;break h}a=M()|0;break h}b=v[f+28>>2];if(!b){break M}v[f+32>>2]=b;Gb(b)}b=v[f+40>>2];if(!b){break L}v[f+44>>2]=b;Gb(b)}b=v[f+52>>2];if(!b){break K}v[f+56>>2]=b;Gb(b)}b=v[f+64>>2];if(!b){break J}v[f+68>>2]=b;Gb(b)}b=v[f+76>>2];if(!b){break H}v[f+80>>2]=b;Gb(b);break H}a=M()|0}b=v[f+88>>2];if(!b){break G}v[f+92>>2]=b;Gb(b)}b=v[f+124>>2];if(!b){break h}v[f+128>>2]=b;Gb(b);break h}v[a+8>>2]=k;Sb:{Tb:{Ub:{if((k|0)>=3){v[a+8>>2]=3;b=v[v[a+12>>2]+12>>2];v[111924]=0;Q(2258,b|0,201145,48)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ub}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];d=v[v[b>>2]-12>>2];v[111924]=0;e=f+124|0;d=v[(b+d|0)+28>>2];v[e>>2]=d;v[d+4>>2]=v[d+4>>2]+1;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;d=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Vb:{if((e|0)!=1){e=v[v[d>>2]+28>>2];v[111924]=0;g=N(e|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break Vb}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}e=f+124|0;d=v[e>>2];i=v[d+4>>2]-1|0;v[d+4>>2]=i;if((i|0)==-1){zb[v[v[d>>2]+8>>2]](d)}v[111924]=0;N(2270,b|0,g|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ub}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];d=v[v[b>>2]-12>>2];v[111924]=0;d=v[(b+d|0)+28>>2];v[e>>2]=d;v[d+4>>2]=v[d+4>>2]+1;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;d=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Wb:{if((e|0)!=1){e=v[v[d>>2]+28>>2];v[111924]=0;g=N(e|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break Wb}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}e=f+124|0;d=v[e>>2];i=v[d+4>>2]-1|0;v[d+4>>2]=i;if((i|0)==-1){zb[v[v[d>>2]+8>>2]](d)}v[111924]=0;N(2270,b|0,g|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ub}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];v[111924]=0;Q(2258,b|0,201194,48)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ub}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];d=v[v[b>>2]-12>>2];v[111924]=0;d=v[(b+d|0)+28>>2];v[e>>2]=d;v[d+4>>2]=v[d+4>>2]+1;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;d=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;Xb:{if((e|0)!=1){e=v[v[d>>2]+28>>2];v[111924]=0;i=N(e|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break Xb}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}d=v[f+124>>2];e=v[d+4>>2]-1|0;v[d+4>>2]=e;if((e|0)==-1){zb[v[v[d>>2]+8>>2]](d)}v[111924]=0;N(2270,b|0,i|0)|0;d=v[111924];v[111924]=0;if((d|0)==1){break Ub}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Ub}v[a+8>>2]=k}Yb:{Zb:{if(!q){if(!(!h&c)){break Zb}break Yb}if(!h){break Yb}}Gb(v[a+8608>>2]);v[a+8608>>2]=0;Gb(v[a+8968>>2]);v[a+8968>>2]=0}Gb(v[a+8964>>2]);v[a+8964>>2]=0;Gb(v[a+8960>>2]);v[a+8960>>2]=0;Gb(v[a+8596>>2]);v[a+8596>>2]=0;Gb(v[a+8592>>2]);v[a+8592>>2]=0;v[111924]=0;U(2512,a|0);b=v[111924];v[111924]=0;if((b|0)==1){break Sb}b=v[a+16>>2];v[b+192>>2]=v[a+9012>>2];v[b+196>>2]=v[a+216>>2];v[111924]=0;R(2513,m|0,0,1);b=v[111924];v[111924]=0;if((b|0)==1){break Sb}_b:{$b:{ac:{bc:{if(q){e=v[a+8>>2];if((e|0)>=3){v[a+8>>2]=3;b=v[v[a+12>>2]+12>>2];v[111924]=0;Q(2258,b|0,201341,48)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Tb}b=v[v[a+12>>2]+(v[a+8>>2]<<2)>>2];c=v[v[b>>2]-12>>2];v[111924]=0;d=f+124|0;c=v[(b+c|0)+28>>2];v[d>>2]=c;v[c+4>>2]=v[c+4>>2]+1;c=v[111924];v[111924]=0;if((c|0)==1){break Tb}v[111924]=0;c=N(1122,d|0,448956)|0;d=v[111924];v[111924]=0;cc:{if((d|0)!=1){d=v[v[c>>2]+28>>2];v[111924]=0;h=N(d|0,c|0,10)|0;c=v[111924];v[111924]=0;if((c|0)!=1){break cc}}a=M()|0;b=v[f+124>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}break h}c=v[f+124>>2];d=v[c+4>>2]-1|0;v[c+4>>2]=d;if((d|0)==-1){zb[v[v[c>>2]+8>>2]](c)}v[111924]=0;N(2270,b|0,h|0)|0;c=v[111924];v[111924]=0;if((c|0)==1){break Tb}v[111924]=0;S(2271,b|0)|0;b=v[111924];v[111924]=0;if((b|0)==1){break Tb}v[a+8>>2]=e}b=v[a+4552>>2];v[111924]=0;R(2350,m|0,b|0,1);b=v[111924];v[111924]=0;if((b|0)==1){break Sb}Gb(v[a+4552>>2]);t[a+4572|0]=1;v[a+4552>>2]=m;if(v[v[a+20>>2]+20>>2]!=-1){break _b}v[111924]=0;b=f+124|0;O(2514,b|0,s|0);c=v[111924];v[111924]=0;dc:{if((c|0)!=1){t[a+680|0]=0;v[a+672>>2]=0;v[a+676>>2]=0;c=v[v[a+32>>2]+148>>2];v[111924]=0;R(c|0,m|0,b|0,0);b=v[111924];v[111924]=0;if((b|0)==1){break dc}ec:{if(v[a+320>>2]!=-1){break ec}i=v[a+280>>2];d=v[a+284>>2]-i>>3;if((d|0)<=0){break ec}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break ec}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}b=v[v[m>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)==1){break dc}b=a+320|0;c=v[f+124>>2];if(c){v[f+128>>2]=c;Gb(c)}if(v[a+320>>2]==-1){break bc}k=v[a+280>>2];i=v[a+284>>2]-k>>3;fc:{if((i|0)<=0){break fc}c=0;h=0;if(i>>>0>=4){g=i&2147483644;e=0;while(1){d=k+(h<<3)|0;A[d>>3]=-A[d>>3];A[d+8>>3]=-A[d+8>>3];A[d+16>>3]=-A[d+16>>3];A[d+24>>3]=-A[d+24>>3];h=h+4|0;e=e+4|0;if((g|0)!=(e|0)){continue}break}}d=i&3;if(!d){break fc}while(1){e=k+(h<<3)|0;A[e>>3]=-A[e>>3];h=h+1|0;c=c+1|0;if((d|0)!=(c|0)){continue}break}}k=v[a+136>>2];i=v[a+140>>2]-k>>3;if((i|0)<=0){break bc}c=0;h=0;if(i>>>0>=4){g=i&2147483644;e=0;while(1){d=k+(h<<3)|0;A[d>>3]=-A[d>>3];A[d+8>>3]=-A[d+8>>3];A[d+16>>3]=-A[d+16>>3];A[d+24>>3]=-A[d+24>>3];h=h+4|0;e=e+4|0;if((g|0)!=(e|0)){continue}break}}d=i&3;if(!d){break bc}while(1){e=k+(h<<3)|0;A[e>>3]=-A[e>>3];h=h+1|0;c=c+1|0;if((d|0)!=(c|0)){continue}break}break bc}a=M()|0;break h}a=M()|0;b=v[f+124>>2];if(!b){break h}v[f+128>>2]=b;Gb(b);break h}b=v[a+4552>>2];zb[v[v[b>>2]>>2]](b)|0;Gb(v[a+4552>>2]);t[a+4572|0]=1;v[a+4552>>2]=m;if(v[v[a+20>>2]+20>>2]!=-1){break _b}v[111924]=0;b=f+124|0;O(2514,b|0,s|0);c=v[111924];v[111924]=0;if((c|0)==1){break ac}t[a+680|0]=0;v[a+672>>2]=0;v[a+676>>2]=0;c=v[v[a+32>>2]+148>>2];v[111924]=0;R(c|0,m|0,b|0,0);b=v[111924];v[111924]=0;if((b|0)==1){break $b}gc:{if(v[a+320>>2]!=-1){break gc}i=v[a+280>>2];d=v[a+284>>2]-i>>3;if((d|0)<=0){break gc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break gc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}b=v[v[m>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)==1){break $b}b=a+320|0;c=v[f+124>>2];if(c){v[f+128>>2]=c;Gb(c)}if(v[a+320>>2]==-1){break bc}k=v[a+280>>2];i=v[a+284>>2]-k>>3;hc:{if((i|0)<=0){break hc}c=0;h=0;if(i>>>0>=4){g=i&2147483644;e=0;while(1){d=k+(h<<3)|0;A[d>>3]=-A[d>>3];A[d+8>>3]=-A[d+8>>3];A[d+16>>3]=-A[d+16>>3];A[d+24>>3]=-A[d+24>>3];h=h+4|0;e=e+4|0;if((g|0)!=(e|0)){continue}break}}d=i&3;if(!d){break hc}while(1){e=k+(h<<3)|0;A[e>>3]=-A[e>>3];h=h+1|0;c=c+1|0;if((d|0)!=(c|0)){continue}break}}k=v[a+136>>2];i=v[a+140>>2]-k>>3;if((i|0)<=0){break bc}c=0;h=0;if(i>>>0>=4){g=i&2147483644;e=0;while(1){d=k+(h<<3)|0;A[d>>3]=-A[d>>3];A[d+8>>3]=-A[d+8>>3];A[d+16>>3]=-A[d+16>>3];A[d+24>>3]=-A[d+24>>3];h=h+4|0;e=e+4|0;if((g|0)!=(e|0)){continue}break}}d=i&3;if(!d){break bc}while(1){e=k+(h<<3)|0;A[e>>3]=-A[e>>3];h=h+1|0;c=c+1|0;if((d|0)!=(c|0)){continue}break}}v[b>>2]=-1;b=v[v[m>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)!=1){break _b}break Sb}a=M()|0;break h}a=M()|0;b=v[f+124>>2];if(!b){break h}v[f+128>>2]=b;Gb(b);break h}v[111924]=0;R(2515,a|0,q|0,0);b=v[111924];v[111924]=0;if((b|0)==1){break Sb}b=v[v[a+16>>2]+4>>2];c=v[v[b>>2]+16>>2];v[111924]=0;+aa(c|0,b|0);b=v[111924];v[111924]=0;if((b|0)==1){break Sb}break i}a=M()|0;break h}a=M()|0;break h}a=M()|0;break h}a=M()|0;break h}a=M()|0;b=v[f+100>>2];if(!b){break h}v[f+104>>2]=b;Gb(b);break h}}a=M()|0;b=v[f+112>>2];if(!b){break h}v[f+116>>2]=b;Gb(b);break h}a=M()|0;break h}a=M()|0;break h}v[111924]=0;U(2426,f+100|0);a=v[111924];v[111924]=0;if((a|0)!=1){break v}a=M()|0;b=v[f+100>>2];if(!b){break h}v[f+104>>2]=b;Gb(b);break h}v[111924]=0;U(2426,f+112|0);a=v[111924];v[111924]=0;if((a|0)==1){break u}}p()}a=M()|0;b=v[f+112>>2];if(!b){break h}v[f+116>>2]=b;Gb(b);break h}if(!w[a+4572|0]){b=v[a+4556>>2];v[111924]=0;R(2350,m|0,b|0,1);b=v[111924];v[111924]=0;if((b|0)==1){break j}Gb(v[a+4556>>2]);t[a+4572|0]=1;v[a+4556>>2]=m}ic:{if(v[v[a+20>>2]+20>>2]!=-1){break ic}v[111924]=0;b=f+124|0;O(2514,b|0,s|0);c=v[111924];v[111924]=0;jc:{if((c|0)!=1){t[a+680|0]=0;v[a+672>>2]=0;v[a+676>>2]=0;c=v[v[a+32>>2]+148>>2];v[111924]=0;R(c|0,m|0,b|0,0);b=v[111924];v[111924]=0;if((b|0)==1){break jc}kc:{if(v[a+320>>2]!=-1){break kc}i=v[a+280>>2];d=v[a+284>>2]-i>>3;if((d|0)<=0){break kc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break kc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}b=v[v[m>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)==1){break jc}b=v[f+124>>2];if(b){v[f+128>>2]=b;Gb(b)}lc:{if(v[a+320>>2]==-1){break lc}i=v[a+280>>2];d=v[a+284>>2]-i>>3;mc:{if((d|0)<=0){break mc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break mc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}i=v[a+136>>2];d=v[a+140>>2]-i>>3;if((d|0)<=0){break lc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break lc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}v[a+320>>2]=-1;b=v[v[a+32>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)!=1){break ic}break j}a=M()|0;break h}a=M()|0;b=v[f+124>>2];if(!b){break h}v[f+128>>2]=b;Gb(b);break h}v[111924]=0;R(2515,a|0,0,0);b=v[111924];v[111924]=0;if((b|0)!=1){break m}break j}a=M()|0;break h}a=M()|0;break g}if(v[v[a+20>>2]+20>>2]==-1){v[111924]=0;b=f+124|0;O(2514,b|0,s|0);c=v[111924];v[111924]=0;if((c|0)==1){break l}t[a+680|0]=0;v[a+672>>2]=0;v[a+676>>2]=0;c=v[v[a+32>>2]+148>>2];v[111924]=0;R(c|0,m|0,b|0,0);b=v[111924];v[111924]=0;if((b|0)==1){break k}nc:{if(v[a+320>>2]!=-1){break nc}i=v[a+280>>2];d=v[a+284>>2]-i>>3;if((d|0)<=0){break nc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break nc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}b=v[v[m>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)==1){break k}b=v[f+124>>2];if(b){v[f+128>>2]=b;Gb(b)}oc:{if(v[a+320>>2]==-1){break oc}i=v[a+280>>2];d=v[a+284>>2]-i>>3;pc:{if((d|0)<=0){break pc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break pc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}i=v[a+136>>2];d=v[a+140>>2]-i>>3;if((d|0)<=0){break oc}c=0;h=0;if(d>>>0>=4){k=d&2147483644;e=0;while(1){b=i+(h<<3)|0;A[b>>3]=-A[b>>3];A[b+8>>3]=-A[b+8>>3];A[b+16>>3]=-A[b+16>>3];A[b+24>>3]=-A[b+24>>3];h=h+4|0;e=e+4|0;if((k|0)!=(e|0)){continue}break}}b=d&3;if(!b){break oc}while(1){d=i+(h<<3)|0;A[d>>3]=-A[d>>3];h=h+1|0;c=c+1|0;if((b|0)!=(c|0)){continue}break}}v[a+320>>2]=-1;b=v[v[a+32>>2]+468>>2];v[111924]=0;U(b|0,m|0);b=v[111924];v[111924]=0;if((b|0)==1){break j}}t[a+864|0]=0;if(!(v[a+664>>2]|(v[a+528>>2]&-2)!=4)){t[a+9392|0]=0}v[111924]=0;da(2495,a|0,m|0,x|0,1,0);b=v[111924];v[111924]=0;if((b|0)==1){break j}v[111924]=0;U(2512,a|0);b=v[111924];v[111924]=0;if((b|0)==1){break j}}v[111924]=0;O(2516,a|0,1);b=v[111924];v[111924]=0;if((b|0)==1){break j}b=v[v[a+16>>2]+4>>2];c=v[v[b>>2]+16>>2];v[111924]=0;+aa(c|0,b|0);b=v[111924];v[111924]=0;if((b|0)==1){break j}break i}a=M()|0;break h}a=M()|0;b=v[f+124>>2];if(!b){break h}v[f+128>>2]=b;Gb(b);break h}a=M()|0;break h}b=v[f+144>>2];if(b){Gb(b)}b=v[f+168>>2];if(b){Gb(b)}ub=f+192|0;break f}b=v[f+144>>2];if(!b){break g}Gb(b)}b=v[f+168>>2];if(b){Gb(b)}P(a|0);p()}break a}qc:{rc:{switch(v[c+88>>2]){case 1:l=-A[53482];e=!(l<A[c+144>>3]+-1e-9);c=v[a+20>>2];if(e|!(l<A[c+152>>3]+-1e-9)){break qc}break;case 0:break rc;default:break qc}}l=A[c+144>>3];u=A[54411];sc:{if(!(l<u)){break sc}l=u;c=v[a+8>>2];if((c|0)<=0){break sc}v[a+8>>2]=1;Nb(v[v[a+12>>2]+4>>2],246608,67);qd(v[v[a+12>>2]+(v[a+8>>2]<<2)>>2],A[54411]);Nb(v[v[a+12>>2]+(v[a+8>>2]<<2)>>2],291553,22);v[a+8>>2]=c;l=A[54411]}c=a+32|0;c0(c,l);l=A[v[a+20>>2]+152>>3];u=A[54412];tc:{if(!(l<u)){break tc}l=u;d=v[a+8>>2];if((d|0)<=0){break tc}v[a+8>>2]=1;Nb(v[v[a+12>>2]+4>>2],246676,66);qd(v[v[a+12>>2]+(v[a+8>>2]<<2)>>2],A[54412]);Nb(v[v[a+12>>2]+(v[a+8>>2]<<2)>>2],291553,22);v[a+8>>2]=d;l=A[54412]}b0(c,l);t[a+865|0]=w[v[a+20>>2]+5|0];t[a+9232|0]=w[a+9232|0]&240;v[a+9396>>2]=v[a+9396>>2]+1;c=v[v[a+16>>2]+4>>2];zb[v[v[c>>2]+12>>2]](c);uc:{if(!w[v[a+20>>2]+13|0]){break uc}e=v[a+4552>>2];c=w[e+304|0];d=v[a+4564>>2];if(d){if(c){break uc}c=v[a+9396>>2];if((c|0)>=11&+v[a+9400>>2]>+(c|0)*.1){break uc}zb[v[v[d>>2]+48>>2]](d,e,1);t[a+4573|0]=w[v[a+4552>>2]+304|0];Uj(a+352|0);c=a+32|0;zb[v[v[a+32>>2]+468>>2]](c);zb[v[v[a+32>>2]+464>>2]](c);break uc}if(!c){break uc}c=a+32|0;KK(c);Uj(a+352|0);zb[v[v[a+32>>2]+468>>2]](c);zb[v[v[a+32>>2]+464>>2]](c);t[a+4573|0]=0;v[a+9400>>2]=v[a+9400>>2]+1}v[a+9100>>2]=0;vc:{wc:{if(w[a+9392|0]){break wc}c=v[a+20>>2];l=A[c+192>>3];if(A[c+208>>3]!=-l){break wc}e=1;if(l==A[c+216>>3]){break vc}}e=0}gt(a,e,b);if(w[a+416|0]){b=v[a+412>>2];l=+zb[v[v[b>>2]+28>>2]](b,0)}else{l=A[48091]}b=v[a+16>>2];A[b+288>>3]=l;b=v[b+4>>2];+zb[v[v[b>>2]+16>>2]](b);break a}if(!v[c+80>>2]){I0(a)}b=ub-16|0;ub=b;e=b+12|0;c=Nb(448052,246109,48);d=v[(v[v[c>>2]-12>>2]+c|0)+28>>2];v[e>>2]=d;v[d+4>>2]=v[d+4>>2]+1;v[111924]=0;d=N(1122,e|0,448956)|0;e=v[111924];v[111924]=0;xc:{if((e|0)!=1){e=v[v[d>>2]+28>>2];v[111924]=0;f=N(e|0,d|0,10)|0;d=v[111924];v[111924]=0;if((d|0)!=1){break xc}}c=M()|0;a=v[b+12>>2];b=v[a+4>>2]-1|0;v[a+4>>2]=b;if((b|0)==-1){zb[v[v[a>>2]+8>>2]](a)}P(c|0);p()}d=v[b+12>>2];e=v[d+4>>2]-1|0;v[d+4>>2]=e;if((e|0)==-1){zb[v[v[d>>2]+8>>2]](d)}bc(c,f);$b(c);ub=b+16|0}c=v[a+8>>2];if((c|0)>=3){v[a+8>>2]=3;Nb(v[v[a+12>>2]+12>>2],365309,1);d=v[a+9096>>2];b=v[v[a+12>>2]+12>>2];Nb(b,253028,22);yc:{zc:{switch(d+15|0){case 0:Nb(b,162921,19);break yc;case 1:Nb(b,163168,29);break yc;case 2:Nb(b,163198,24);break yc;case 3:Nb(b,163136,31);break yc;case 4:Nb(b,162415,23);break yc;case 7:Nb(b,162121,25);break yc;case 8:Nb(b,163025,36);break yc;case 9:Nb(b,162941,41);break yc;case 10:Nb(b,162983,41);break yc;case 12:Nb(b,138567,17);break yc;case 13:Nb(b,69313,16);break yc;case 11:Nb(b,69295,17);break yc;case 16:Nb(b,162067,27);break yc;case 17:Nb(b,163062,29);break yc;case 18:Nb(b,162332,30);break yc;case 19:Nb(b,163092,43);break yc;case 20:Nb(b,161914,52);break yc;default:break zc}}Nb(b,74384,7)}Nb(b,365309,1);d=v[b>>2]-12|0;v[(b+v[d>>2]|0)+8>>2]=2;d=b+v[d>>2]|0;v[d+4>>2]=v[d+4>>2]&-261|4;e=Nb(b,252810,22);d=v[v[a+16>>2]+4>>2];Nb(pd(Nb(Nb(qd(e,+zb[v[v[d>>2]+24>>2]](d)),365309,1),253142,22),v[v[a+16>>2]+120>>2]),365309,1);d=v[b>>2]-12|0;v[(b+v[d>>2]|0)+8>>2]=8;d=b+v[d>>2]|0;v[d+4>>2]=v[d+4>>2]&-261|256;b=Nb(b,252909,22);Ac:{Bc:{switch(v[a+9096>>2]-2|0){case 0:d=v[a+20>>2];l=A[d+192>>3]*+v[d+20>>2];break Ac;case 1:d=v[a+20>>2];l=-A[d+192>>3]*+v[d+20>>2];break Ac;default:break Bc}}d=w[a+9393|0];e=w[a+9394|0];l=0;if(!(d|e)){break Ac}if(!(!e|d)){um(a+9152|0,a+9240|0);t[a+9393|0]=1}l=A[a+9224>>3]}Nb(qd(b,l),365309,1);Nb(v[v[a+12>>2]+(v[a+8>>2]<<2)>>2],365309,1);v[a+8>>2]=c}return v[a+9096>>2]}function WS(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,x=0,y=0,z=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;q=ub-1456|0;ub=q;h=v[b+84>>2];a:{b:{if(v[h+160>>2]){if(!d){break b}x=1;v[d>>2]=1;break a}c:{d:{if(!v[h+240>>2]){break d}if((hd(a)|0)<2){break d}d=v[h+156>>2];e:{e=v[h+224>>2];if((v[e+468>>2]>0?e:0)|v[h+148>>2]){x=Kn(a,h);if((x|0)==1){break e}Eb(144166,6355);v[q+368>>2]=x;Fb(276579,q+368|0);break a}x=Kn(a,h);if((x|0)==1){break e}Eb(144166,6359);v[q+352>>2]=x;Fb(276579,q+352|0);break a}if(v[h+12>>2]){break c}if((ke(a)+jj(a)|0)<2){break c}x=Ofa(a,h);if((x|0)!=1){Eb(144166,6365);v[q+336>>2]=x;Fb(276579,q+336|0);break a}v[h+316>>2]=0;v[h+240>>2]=0;v[h+156>>2]=d;x=Kn(a,h);if((x|0)==1){break c}Eb(144166,6370);v[q+320>>2]=x;Fb(276579,q+320|0);break a}x=Kn(a,h);if((x|0)==1){break c}Eb(144166,6375);v[q+304>>2]=x;Fb(276579,q+304|0);break a}x=1;if(v[h+12>>2]<=0){break a}f:{g:{h:{i:{if(!v[h+156>>2]){if(!v[h+316>>2]){break a}X=h+96|0;if(!v[h+96>>2]){break i}break g}X=h+96|0;if(v[h+96>>2]){break h}}v[h+156>>2]=0;break g}v[h+160>>2]=1;d=Tb(v[v[a>>2]+4>>2],v[h+12>>2],4,144132,6394);v[h+176>>2]=d;if(!d){Eb(144166,6394);x=-1;v[q+64>>2]=-1;Fb(276579,q- -64|0);break a}if(!v[h+4>>2]|(!v[h+200>>2]|!v[h+12>>2])){break f}z=v[h+56>>2];if((z|0)<=0){break f}K=v[h+68>>2];C=v[h+64>>2];E=v[h+8>>2];u=v[h>>2];H=v[h+20>>2];j:{k:{while(1){l:{v[q+1436>>2]=1;d=2147483647;g=2147483647;I=k<<2;s=I+K|0;m=v[s>>2];o=m;n=k+1|0;p=K+(n<<2)|0;i=v[p>>2];m:{if((i|0)>(m|0)){while(1){v[q+384>>2]=0;v[q+1416>>2]=0;e=e3(v[H+(v[C+(o<<2)>>2]<<2)>>2],E,u,q+384|0,q+1416|0);if((e|0)!=1){Eb(144166,4980);v[q+288>>2]=e;Fb(276579,q+288|0);x=e;break j}e=v[q+384>>2];if(!e){break m}f=v[q+1416>>2];if((d|0)==2147483647){d=e;g=f;if(!f){break m}}if((d|0)!=(e|0)|(f|0)!=(g|0)){break m}d=e;g=f;o=o+1|0;if((o|0)<v[p>>2]){continue}break}}e=Ib(v[v[a>>2]+8>>2],d,4,144132,5020);v[q+1428>>2]=e;n:{if(e){i=i-m|0;p=i+1|0;e=0;if((d|0)<=0){break n}while(1){o:{f=Ib(v[v[a>>2]+8>>2],p,4,144132,5023);v[v[q+1428>>2]+(e<<2)>>2]=f;if(!f){break o}e=e+1|0;if((e|0)!=(d|0)){continue}break n}break}Eb(144166,5023);x=-1;v[q+112>>2]=-1;Fb(276579,q+112|0);break j}Eb(144166,5020);x=-1;v[q+96>>2]=-1;Fb(276579,q+96|0);break j}l=Ib(v[v[a>>2]+8>>2],p,4,144132,5027);v[q+1424>>2]=l;if(!l){break l}p:{if((i|0)<0){break p}e=i+2|0;j=0;o=0;if(i>>>0>=7){r=p&-8;m=0;while(1){f=l+(o<<2)|0;v[f>>2]=e;v[f+4>>2]=e;v[f+8>>2]=e;v[f+12>>2]=e;v[f+16>>2]=e;v[f+20>>2]=e;v[f+24>>2]=e;v[f+28>>2]=e;o=o+8|0;m=m+8|0;if((r|0)!=(m|0)){continue}break}}f=p&7;if(!f){break p}while(1){v[l+(o<<2)>>2]=e;o=o+1|0;j=j+1|0;if((f|0)!=(j|0)){continue}break}}e=je(v[v[a>>2]+8>>2],u,4,144132,5032);v[q+1420>>2]=e;if(!e){Eb(144166,5032);x=-1;v[q+144>>2]=-1;Fb(276579,q+144|0);break j}e=je(v[v[a>>2]+8>>2],d,1,144132,5035);v[q+1440>>2]=e;if(!e){Eb(144166,5035);x=-1;v[q+160>>2]=-1;Fb(276579,q+160|0);break j}e=Mfa(a,E,u,H,C+(v[s>>2]<<2)|0,d,i,v[q+1428>>2],v[q+1424>>2],v[q+1420>>2],0,e,q+1436|0,0);if((e|0)!=1){Eb(144166,5040);v[q+272>>2]=e;Fb(276579,q+272|0);x=e;break j}if(v[q+1436>>2]){e=Ib(v[v[a>>2]+8>>2],g,4,144132,5046);v[q+1452>>2]=e;if(!e){Eb(144166,5046);x=-1;v[q+176>>2]=-1;Fb(276579,q+176|0);break j}e=Ib(v[v[a>>2]+8>>2],g,4,144132,5047);v[q+1448>>2]=e;if(!e){break k}e=0;o=0;if((d|0)>0){while(1){if(w[v[q+1440>>2]+e|0]){f=Ib(v[v[a>>2]+8>>2],p,4,144132,5054);m=o<<2;v[m+v[q+1452>>2]>>2]=f;if(!f){Eb(144166,5054);x=-1;v[q+256>>2]=-1;Fb(276579,q+256|0);break j}v[m+v[q+1448>>2]>>2]=v[m+v[q+1452>>2]>>2];o=o+1|0}e=e+1|0;if((e|0)!=(d|0)){continue}break}}v[q+1432>>2]=0;e=c3(a,q+1452|0,d,p,E,v[q+1428>>2],v[q+1424>>2],v[q+1420>>2],v[q+1440>>2],q+1432|0,0,0,0,0);if((e|0)!=1){Eb(144166,5063);v[q+240>>2]=e;Fb(276579,q+240|0);x=e;break j}if(!v[q+1432>>2]){v[q+224>>2]=k;Jb(q+384|0,1024,139071,q+224|0);q:{D=v[q+1428>>2];G=v[q+1452>>2];k=0;e=0;m=0;i=ub-48|0;ub=i;l=Ib(v[v[a>>2]+8>>2],(g|0)>(p|0)?g:p,4,144132,4851);v[i+36>>2]=l;r:{s:{t:{if(l){o=2147483647;u:{if((g|0)<=0){break u}if((p|0)<=0){if(g>>>0>=8){m=g&2147483640;while(1){f=l+(k<<2)|0;v[f>>2]=2147483647;v[f+4>>2]=2147483647;v[f+8>>2]=2147483647;v[f+12>>2]=2147483647;v[f+16>>2]=2147483647;v[f+20>>2]=2147483647;v[f+24>>2]=2147483647;v[f+28>>2]=2147483647;k=k+8|0;e=e+8|0;if((m|0)!=(e|0)){continue}break}}e=g&7;if(!e){break u}s=0;while(1){v[l+(k<<2)>>2]=2147483647;k=k+1|0;s=s+1|0;if((e|0)!=(s|0)){continue}break}break u}L=p&2147483646;y=p&1;s=2147483647;while(1){e=m<<2;k=e+l|0;v[k>>2]=2147483647;F=v[e+D>>2];e=2147483647;j=0;r=0;if((p|0)!=1){while(1){J=F+(j<<2)|0;f=v[J>>2];if((f|0)<(e|0)){v[k>>2]=f;e=f}M=(f|0)<(s|0);s=M?f:s;f=v[J+4>>2];if((f|0)<(e|0)){v[k>>2]=f;e=f}J=(f|0)<(s|0);o=J?m:M?m:o;s=J?f:s;j=j+2|0;r=r+2|0;if((L|0)!=(r|0)){continue}break}}if(y){f=e;e=v[F+(j<<2)>>2];if((f|0)>(e|0)){v[k>>2]=e}f=e;e=(e|0)<(s|0);s=e?f:s;o=e?m:o}m=m+1|0;if((m|0)!=(g|0)){continue}break}}Jj(l,G,g);f=Ib(v[v[a>>2]+8>>2],p,4,144132,4879);v[i+40>>2]=f;if(!f){break t}v:{if((p|0)<=0){break v}e=v[D+(o<<2)>>2];j=0;k=0;if(p>>>0>=4){s=p&2147483644;o=0;while(1){m=k<<2;v[m+l>>2]=v[e+m>>2];v[f+m>>2]=k;r=k|1;m=r<<2;v[m+l>>2]=v[e+m>>2];v[f+m>>2]=r;r=k|2;m=r<<2;v[m+l>>2]=v[e+m>>2];v[f+m>>2]=r;r=k|3;m=r<<2;v[m+l>>2]=v[e+m>>2];v[f+m>>2]=r;k=k+4|0;o=o+4|0;if((s|0)!=(o|0)){continue}break}}o=p&3;if(!o){break v}while(1){m=k<<2;v[m+l>>2]=v[e+m>>2];v[f+m>>2]=k;k=k+1|0;j=j+1|0;if((o|0)!=(j|0)){continue}break}}e=v[G>>2];if((p|0)>=2){w:{k=p-1|0;if(p>>>0<=25){yG(l,f,e,0,k);break w}fQ(l,f,e,0,k,1)}}k=Ib(v[v[a>>2]+8>>2],p,4,144132,4890);v[i+44>>2]=k;if(!k){break s}if(!((g|0)<2|(p|0)<=0)){F=p&2147483644;s=p&3;L=p&2147483646;y=p&1;D=p-1|0;m=1;while(1){l=G+(m<<2)|0;e=0;o=0;if(D){while(1){j=e<<2;v[j+k>>2]=v[v[l>>2]+(v[f+j>>2]<<2)>>2];j=j|4;v[j+k>>2]=v[v[l>>2]+(v[f+j>>2]<<2)>>2];e=e+2|0;o=o+2|0;if((L|0)!=(o|0)){continue}break}}if(y){e=e<<2;v[e+k>>2]=v[v[l>>2]+(v[e+f>>2]<<2)>>2]}o=0;e=0;r=0;if(D>>>0>=3){while(1){j=e<<2;v[j+v[l>>2]>>2]=v[j+k>>2];J=j|4;v[J+v[l>>2]>>2]=v[k+J>>2];J=j|8;v[J+v[l>>2]>>2]=v[k+J>>2];j=j|12;v[j+v[l>>2]>>2]=v[j+k>>2];e=e+4|0;r=r+4|0;if((F|0)!=(r|0)){continue}break}}if(s){while(1){j=e<<2;v[j+v[l>>2]>>2]=v[j+k>>2];e=e+1|0;o=o+1|0;if((s|0)!=(o|0)){continue}break}}m=m+1|0;if((m|0)!=(g|0)){continue}break}}Hb(v[v[a>>2]+8>>2],i+44|0,144132,4899);Hb(v[v[a>>2]+8>>2],i+40|0,144132,4900);Hb(v[v[a>>2]+8>>2],i+36|0,144132,4901);e=1;break r}Eb(144166,4851);v[i>>2]=-1;Fb(276579,i);e=-1;break r}Eb(144166,4879);v[i+16>>2]=-1;Fb(276579,i+16|0);e=-1;break r}Eb(144166,4890);v[i+32>>2]=-1;Fb(276579,i+32|0);e=-1}ub=i+48|0;x:{if((e|0)!=1){x=e;a=5074;break x}e=jC(a,q+1444|0,q+384|0,v[q+1452>>2],0,g,p,v[h+232>>2],0,0,0,v[h+164>>2],1,0,1,1,0,0,0,0,0);if((e|0)!=1){x=e;a=5078;break x}e=mc(a,v[q+1444>>2]);if((e|0)==1){break q}x=e;a=5080}Eb(144166,a);v[q+208>>2]=x;Fb(276579,q+208|0);break j}e=v[q+1444>>2];f=v[h+184>>2];v[h+184>>2]=f+1;v[v[h+176>>2]+(f<<2)>>2]=e;v[h+216>>2]=v[h+216>>2]+1;e=I+v[h+76>>2]|0;v[e>>2]=v[e>>2]|1}if((g|0)>0){while(1){e=g-1|0;Hb(v[v[a>>2]+8>>2],v[q+1448>>2]+(e<<2)|0,144132,5092);f=g>>>0>1;g=e;if(f){continue}break}}Hb(v[v[a>>2]+8>>2],q+1448|0,144132,5094);Hb(v[v[a>>2]+8>>2],q+1452|0,144132,5095)}Hb(v[v[a>>2]+8>>2],q+1440|0,144132,5098);Hb(v[v[a>>2]+8>>2],q+1420|0,144132,5099);Hb(v[v[a>>2]+8>>2],q+1424|0,144132,5100);if((d|0)>0){while(1){e=d-1|0;Hb(v[v[a>>2]+8>>2],v[q+1428>>2]+(e<<2)|0,144132,5103);g=d>>>0>1;d=e;if(g){continue}break}}Hb(v[v[a>>2]+8>>2],q+1428|0,144132,5105)}k=n;if((z|0)!=(k|0)){continue}break f}break}Eb(144166,5027);x=-1;v[q+128>>2]=-1;Fb(276579,q+128|0);break j}Eb(144166,5047);x=-1;v[q+192>>2]=-1;Fb(276579,q+192|0)}Eb(144166,6398);v[q+80>>2]=x;Fb(276579,q+80|0);break a}v[h+160>>2]=1}if(v[h+56>>2]==v[h+216>>2]){v[h+240>>2]=0}if(rc(v[a+4>>2],v[a+24>>2],0)){if(v[h+184>>2]){break a}_b(v[v[a>>2]+4>>2],h+176|0,v[h+12>>2]<<2,144132,6411);break a}y:{if(!v[h+156>>2]|(!v[h+204>>2]|v[h+60>>2]>=v[h+56>>2])){break y}v[h+192>>2]=v[h+12>>2];d=Tb(v[v[a>>2]+4>>2],v[h+192>>2],4,144132,6420);v[h+180>>2]=d;if(!d){Eb(144166,6420);x=-1;v[q+32>>2]=-1;Fb(276579,q+32|0);break a}G=0;j=ub-1440|0;ub=j;e=1;z:{if(!v[h+12>>2]){break z}if((ef(a)|0)>v[h+228>>2]){break z}d=Ib(v[v[a>>2]+8>>2],v[h+12>>2],4,144132,4344);v[j+1432>>2]=d;if(!d){Eb(144166,4344);e=-1;v[j>>2]=-1;Fb(276579,j);break z}d=Ib(v[v[a>>2]+8>>2],v[h+12>>2],4,144132,4347);v[j+1428>>2]=d;A:{B:{if(d){e=0;if(v[h+12>>2]<=0){break A}break B}Eb(144166,4347);e=-1;v[j+16>>2]=-1;Fb(276579,j+16|0);break z}while(1){C:{g=Ib(v[v[a>>2]+8>>2],v[h>>2],4,144132,4350);v[d+(e<<2)>>2]=g;if(!g){break C}e=e+1|0;if((e|0)<v[h+12>>2]){continue}break A}break}Eb(144166,4350);e=-1;v[j+32>>2]=-1;Fb(276579,j+32|0);break z}d=Ib(v[v[a>>2]+8>>2],v[h>>2],4,144132,4352);v[j+1424>>2]=d;if(!d){Eb(144166,4352);e=-1;v[j+48>>2]=-1;Fb(276579,j+48|0);break z}g=je(v[v[a>>2]+8>>2],v[h>>2],4,144132,4354);v[j+1420>>2]=g;D:{E:{F:{G:{H:{if(g){d=v[h>>2];if((d|0)>0){f=v[h+72>>2];e=0;while(1){k=v[f+(e<<2)>>2];if((k|0)>=0){d=g+(k<<2)|0;v[d>>2]=v[d>>2]+1;d=v[h>>2]}e=e+1|0;if((e|0)<(d|0)){continue}break}}I:{if(v[h+56>>2]>0){while(1){v[j+1404>>2]=0;v[j+1400>>2]=0;v[j+1380>>2]=0;v[j+1376>>2]=0;v[j+1372>>2]=0;E=G<<2;J:{if(v[E+v[h+76>>2]>>2]){break J}n=E+v[h+68>>2]|0;k=n;m=v[k+4>>2];o=v[k>>2];K=m-o|0;f=K;J=(f|0)<=0;if(!J){d=0;g=v[j+1432>>2];e=0;if(o-m>>>0<=4294967288){m=f&2147483640;f=0;while(1){v[g+(e<<2)>>2]=e;o=e|1;v[g+(o<<2)>>2]=o;o=e|2;v[g+(o<<2)>>2]=o;o=e|3;v[g+(o<<2)>>2]=o;o=e|4;v[g+(o<<2)>>2]=o;o=e|5;v[g+(o<<2)>>2]=o;o=e|6;v[g+(o<<2)>>2]=o;o=e|7;v[g+(o<<2)>>2]=o;e=e+8|0;f=f+8|0;if((m|0)!=(f|0)){continue}break}}f=K&7;if(f){while(1){v[g+(e<<2)>>2]=e;e=e+1|0;d=d+1|0;if((f|0)!=(d|0)){continue}break}}f=v[k+4>>2]-v[n>>2]|0}p=v[h+64>>2];g=v[h>>2];i=v[h+20>>2];e=Ib(v[v[a>>2]+8>>2],f,4,144132,3273);v[j+336>>2]=e;if(!e){break G}d=0;k=f;K:{L:{if((f|0)>0){while(1){m=d<<2;e=e3(v[i+(v[m+(p+(v[n>>2]<<2)|0)>>2]<<2)>>2],v[h+8>>2],g,e+m|0,j+1436|0);if((e|0)!=1){break L}o=v[h+236>>2];e=v[j+336>>2];m=m+e|0;l=v[m>>2];M:{if(!l){v[m>>2]=o?g:0;k=k-1|0;break M}if(o){break M}v[m>>2]=0-l}d=d+1|0;if((f|0)!=(d|0)){continue}break}}nf(e,v[j+1432>>2],f);Hb(v[v[a>>2]+8>>2],j+336|0,144132,3300);if((k|0)<2){break J}d=k>>>1|0;e=Ib(v[v[a>>2]+8>>2],d,4,144132,4458);v[j+1396>>2]=e;if(e){break K}Eb(144166,4458);e=-1;v[j+112>>2]=-1;Fb(276579,j+112|0);break z}Eb(144166,3282);v[j+320>>2]=e;Fb(276579,j+320|0);break D}r=je(v[v[a>>2]+8>>2],K,1,144132,4459);v[j+1368>>2]=r;if(!r){Eb(144166,4459);e=-1;v[j+128>>2]=-1;Fb(276579,j+128|0);break z}M=v[j+1432>>2];i=j+1416|0;C=j+1412|0;Q=j+1408|0;s=j+1392|0;H=j+1388|0;u=j+1396|0;e=ub-160|0;ub=e;m=v[h+68>>2];D=v[h+64>>2];N=v[h+20>>2];g=v[h>>2];l=j+1384|0;v[l>>2]=0;f=g6(a,e+156|0,g);N:{if((f|0)!=1){Eb(144166,3376);v[e+128>>2]=f;Fb(276579,e+128|0);break N}f=g6(a,e+152|0,g);if((f|0)!=1){Eb(144166,3377);v[e+112>>2]=f;Fb(276579,e+112|0);break N}n=Ib(v[v[a>>2]+8>>2],g,4,144132,3378);v[e+148>>2]=n;O:{if(n){if((g|0)>0){Wb(n,255,g<<2)}if((k|0)>0){F=m+(G<<2)|0;z=(g|0)<=0;p=0;while(1){P:{if(z){break P}I=M+(p<<2)|0;L=v[N+(v[(D+(v[F>>2]<<2)|0)+(v[I>>2]<<2)>>2]<<2)>>2];f=0;o=-1;while(1){y=v[L+(f<<2)>>2];Q:{if((y|0)<=(f|0)){break Q}m=wn(v[e+156>>2],f);y=wn(v[e+156>>2],y);if((m|0)==(y|0)){if((o|0)<0){o=wn(v[e+152>>2],m)}v[n+(m<<2)>>2]=p;break Q}O=n+(m<<2)|0;if(v[O>>2]==(p|0)){break P}R=n+(y<<2)|0;if(v[R>>2]==(p|0)){break P}m=wn(v[e+152>>2],m);if((wn(v[e+152>>2],y)|0)==(m|0)){break P}v[O>>2]=p;v[R>>2]=p;o=(o|0)<0?m:o}f=f+1|0;if((g|0)!=(f|0)){continue}break}if((o|0)==-1){break P}f=v[l>>2];R:{if((f|0)<(d|0)){m=v[u>>2];break R}d=td(a,f+1|0);m=hc(v[v[a>>2]+8>>2],v[u>>2],d,4,144132,3456);v[u>>2]=m;if(!m){break O}f=v[l>>2]}v[(f<<2)+m>>2]=v[(D+(v[F>>2]<<2)|0)+(v[I>>2]<<2)>>2];v[l>>2]=v[l>>2]+1;t[r+v[I>>2]|0]=1;f=0;if(z){break P}while(1){I=v[L+(f<<2)>>2];S:{if((I|0)<=(f|0)){break S}m=wn(v[e+156>>2],f);I=wn(v[e+156>>2],I);if((m|0)==(I|0)){break S}y=wn(v[e+152>>2],m);O=wn(v[e+152>>2],I);if((y|0)!=(O|0)){mG(v[e+152>>2],o,y,1);mG(v[e+152>>2],o,O,1)}mG(v[e+156>>2],m,I,0)}f=f+1|0;if((g|0)!=(f|0)){continue}break}}p=p+1|0;if((k|0)!=(p|0)){continue}break}}d=Tb(v[v[a>>2]+4>>2],g,4,144132,3504);v[i>>2]=d;if(!d){Eb(144166,3504);f=-1;v[e+16>>2]=-1;Fb(276579,e+16|0);break N}d=Ib(v[v[a>>2]+8>>2],g,4,144132,3505);v[e+140>>2]=d;if(!d){Eb(144166,3505);f=-1;v[e+32>>2]=-1;Fb(276579,e+32|0);break N}k=Ib(v[v[a>>2]+8>>2],g,4,144132,3506);v[e+144>>2]=k;T:{U:{if(k){f=0;if((g|0)<=0){break U}while(1){n=f<<2;m=wn(v[e+156>>2],f);v[n+d>>2]=m;v[k+n>>2]=wn(v[e+152>>2],m);m=v[i>>2];v[n+m>>2]=f;f=f+1|0;if((g|0)!=(f|0)){continue}break}break T}Eb(144166,3506);f=-1;v[e+48>>2]=-1;Fb(276579,e+48|0);break N}m=v[i>>2]}bx(m,1779,e+140|0,g);v[s>>2]=v[v[e+156>>2]+12>>2];v[H>>2]=v[v[e+152>>2]+12>>2];d=Tb(v[v[a>>2]+4>>2],v[s>>2]+1|0,4,144132,3531);v[C>>2]=d;if(!d){Eb(144166,3531);f=-1;v[e+64>>2]=-1;Fb(276579,e- -64|0);break N}n=Tb(v[v[a>>2]+4>>2],v[H>>2]+1|0,4,144132,3532);v[Q>>2]=n;if(!n){Eb(144166,3532);f=-1;v[e+80>>2]=-1;Fb(276579,e+80|0);break N}o=v[C>>2];v[o>>2]=0;v[n>>2]=0;f=1;d=1;k=1;if((g|0)>=2){l=v[i>>2];p=v[e+144>>2];i=v[e+140>>2];m=1;while(1){u=l+(m<<2)|0;r=v[u>>2]<<2;u=v[u-4>>2]<<2;if(v[r+i>>2]!=v[u+i>>2]){v[o+(d<<2)>>2]=m;if(v[p+r>>2]>v[p+u>>2]){v[n+(k<<2)>>2]=d;k=k+1|0}d=d+1|0}m=m+1|0;if((g|0)!=(m|0)){continue}break}}v[n+(k<<2)>>2]=v[s>>2];v[o+(d<<2)>>2]=g;Hb(v[v[a>>2]+8>>2],e+144|0,144132,3569);Hb(v[v[a>>2]+8>>2],e+140|0,144132,3570);Hb(v[v[a>>2]+8>>2],e+148|0,144132,3571);f6(a,e+152|0);f6(a,e+156|0);break N}Eb(144166,3378);f=-1;v[e>>2]=-1;Fb(276579,e);break N}Eb(144166,3456);f=-1;v[e+96>>2]=-1;Fb(276579,e+96|0)}ub=e+160|0;e=f;if((e|0)!=1){Eb(144166,4463);v[j+304>>2]=e;Fb(276579,j+304|0);break z}D=v[j+1384>>2];if(!D){Hb(v[v[a>>2]+8>>2],j+1368|0,144132,4482);Hb(v[v[a>>2]+8>>2],j+1396|0,144132,4483);break J}V:{if(!(v[h+212>>2]|v[h+208>>2])){m=v[j+1388>>2];break V}m=v[j+1388>>2];d=Ib(v[v[a>>2]+8>>2],m,4,144132,4492);v[j+1404>>2]=d;if(!d){Eb(144166,4492);e=-1;v[j+272>>2]=-1;Fb(276579,j+272|0);break z}d=Ib(v[v[a>>2]+8>>2],m,4,144132,4493);v[j+1400>>2]=d;if(!d){break H}if((m|0)<=0){break V}f=0;g=v[j+1404>>2];e=0;if(m>>>0>=4){o=m&2147483644;n=0;while(1){k=e<<2;v[k+g>>2]=-1;v[d+k>>2]=-1;p=k|4;v[p+g>>2]=-1;v[d+p>>2]=-1;p=k|8;v[p+g>>2]=-1;v[d+p>>2]=-1;k=k|12;v[k+g>>2]=-1;v[d+k>>2]=-1;e=e+4|0;n=n+4|0;if((o|0)!=(n|0)){continue}break}}k=m&3;if(!k){break V}while(1){n=e<<2;v[n+g>>2]=-1;v[d+n>>2]=-1;e=e+1|0;f=f+1|0;if((k|0)!=(f|0)){continue}break}}I=v[h+8>>2];L=v[j+1416>>2];H=v[j+1412>>2];F=v[j+1408>>2];d=v[E+v[j+1420>>2]>>2];r=0;u=0;o=0;C=0;if(!((m|0)<=0)){Y=+(d|0)*.7;g=v[F>>2];f=v[H+(g<<2)>>2];while(1){d=g;n=f;C=C+1|0;g=v[F+(C<<2)>>2];f=v[H+(g<<2)>>2];W:{if((f-n|0)<2){break W}z=H+(d<<2)|0;s=0;X:{Y:{if((d|0)>=(g|0)){e=d;break Y}p=v[z>>2];k=0;while(1){i=p;e=d;d=e+1|0;p=v[H+(d<<2)>>2];l=p-i|0;Z:{if((k|0)<=0){k=l;if((k|0)<3){break Y}break Z}if((k|0)!=(l|0)){break Y}}_:{$:{aa:{e=v[I+(v[L+(i<<2)>>2]<<2)>>2];switch(v[e+376>>2]>>>6&3){case 3:break _;case 0:break $;default:break aa}}if(!(A[e+128>>3]>=0)|!(A[e+136>>3]<=1)){break _}}s=s+1|0}if((d|0)!=(g|0)){continue}break}break X}if((e|0)!=(g|0)){break W}}r=r+1|0;d=v[z+4>>2]-n|0;if(d<<1>=(s|0)){o=1;break W}if(!(d<<3<(s|0)|(s|0)>99)){o=1;break W}if(!(+(s|0)*+(d|0)>=Y)&(B(d,3)|0)<(s|0)){break W}u=1}if((m|0)!=(C|0)){continue}break}}ba:{ca:{da:{d=(r|0)>1?o?r:0:0;M=(r|0)==1?u?r:d:d;if((M|0)!=1){if((m|0)>0){break da}I=0;break ca}d=0;if(J){break ba}while(1){v[j+160>>2]=G;v[j+164>>2]=d;e=j+336|0;Jb(e,1024,139266,j+160|0);e=ZB(a,j+1436|0,e,v[v[h+20>>2]+(v[(v[h+64>>2]+(v[E+v[h+68>>2]>>2]<<2)|0)+(d<<2)>>2]<<2)>>2],v[h+8>>2],v[h>>2],v[h+164>>2]);if((e|0)!=1){d=4523;break E}e=mc(a,v[j+1436>>2]);if((e|0)!=1){d=4524;break E}e=v[j+1436>>2];g=v[h+184>>2];v[h+184>>2]=g+1;v[v[h+176>>2]+(g<<2)>>2]=e;v[h+196>>2]=v[h+196>>2]+1;e=E+v[h+76>>2]|0;if(!v[e>>2]){v[e>>2]=1;v[h+60>>2]=v[h+60>>2]+1}d=d+1|0;if((K|0)!=(d|0)){continue}break}break ba}J=(D|0)==(K|0);o=0;I=0;while(1){v[j+336>>2]=0;z=v[j+1408>>2];p=o;o=p+1|0;u=v[z+(o<<2)>>2];C=v[j+1412>>2];s=p<<2;e=v[s+z>>2];f=v[C+(e<<2)>>2];ea:{fa:{ga:{if((v[C+(u<<2)>>2]-f|0)>=2){d=-1;if((e|0)<(u|0)){break ga}e=0;break fa}d=v[j+1404>>2];if(!d){break ea}v[d+s>>2]=-1;break ea}k=0;r=v[j+1416>>2];n=0;ha:{while(1){g=d;i=f;d=e;e=e+1|0;f=v[C+(e<<2)>>2];l=f-i|0;ia:{if((n|0)<=0){n=l;if((l|0)>=3){break ia}break ha}if((l|0)!=(n|0)){break ha}d=g}ja:{ka:{la:{g=v[v[h+8>>2]+(v[r+(i<<2)>>2]<<2)>>2];switch(v[g+376>>2]>>>6&3){case 3:break ja;case 0:break ka;default:break la}}if(!(A[g+128>>3]>=0)|!(A[g+136>>3]<=1)){break ja}}k=k+1|0}if((e|0)!=(u|0)){continue}break}e=0;if((M|0)<=0|(k|0)<=0){break fa}Q=v[j+1396>>2];L=v[j+1416>>2];H=j+1436|0;F=j+332|0;N=j+1380|0;O=j+1376|0;R=j+1372|0;f=0;r=0;i=ub-1248|0;ub=i;v[i+192>>2]=0;v[i+188>>2]=0;v[j+336>>2]=0;g=je(v[v[a>>2]+8>>2],v[h>>2],1,144132,3631);v[i+216>>2]=g;ma:{if(!g){Eb(144166,3631);f=-1;v[i>>2]=-1;Fb(276579,i);break ma}g=Ib(v[v[a>>2]+8>>2],k,4,144132,3634);v[i+212>>2]=g;na:{oa:{if(g){if((k|0)<=0){break na}break oa}Eb(144166,3634);f=-1;v[i+16>>2]=-1;Fb(276579,i+16|0);break ma}while(1){pa:{g=Ib(v[v[a>>2]+8>>2],n,4,144132,3637);v[v[i+212>>2]+(f<<2)>>2]=g;if(!g){break pa}f=f+1|0;if((k|0)!=(f|0)){continue}break na}break}Eb(144166,3637);f=-1;v[i+32>>2]=-1;Fb(276579,i+32|0);break ma}u=Ib(v[v[a>>2]+8>>2],n,4,144132,3641);v[i+208>>2]=u;if(u){qa:{if((n|0)<=0){break qa}f=n+1|0;g=0;if(n>>>0>=8){y=n&2147483640;while(1){l=(g<<2)+u|0;v[l>>2]=f;v[l+4>>2]=f;v[l+8>>2]=f;v[l+12>>2]=f;v[l+16>>2]=f;v[l+20>>2]=f;v[l+24>>2]=f;v[l+28>>2]=f;g=g+8|0;r=r+8|0;if((y|0)!=(r|0)){continue}break}}l=n&7;if(!l){break qa}while(1){v[(g<<2)+u>>2]=f;g=g+1|0;e=e+1|0;if((l|0)!=(e|0)){continue}break}}e=je(v[v[a>>2]+8>>2],v[h>>2],4,144132,3646);v[i+204>>2]=e;if(!e){Eb(144166,3646);f=-1;v[i+64>>2]=-1;Fb(276579,i- -64|0);break ma}l=z+(p<<2)|0;r=v[l>>2];f=v[l+4>>2];if((r|0)<(f|0)){e=(n|0)<=1?1:n;T=e&2147483644;z=e&3;S=(n|0)<4;while(1){ra:{sa:{ta:{ua:{y=L+(v[C+(r<<2)>>2]<<2)|0;e=v[v[h+8>>2]+(v[y>>2]<<2)>>2];switch(v[e+376>>2]>>>6&3){case 3:break ra;case 0:break ta;default:break ua}}if(!(A[e+128>>3]>=0)|!(A[e+136>>3]<=1)){break ra}if((n|0)>0){break sa}break ra}if((n|0)<=0){break ra}}g=0;f=0;e=0;if(!S){while(1){u=y+(f<<2)|0;t[v[i+216>>2]+v[u>>2]|0]=1;t[v[i+216>>2]+v[u+4>>2]|0]=1;t[v[i+216>>2]+v[u+8>>2]|0]=1;t[v[i+216>>2]+v[u+12>>2]|0]=1;f=f+4|0;e=e+4|0;if((T|0)!=(e|0)){continue}break}}if(z){while(1){t[v[i+216>>2]+v[y+(f<<2)>>2]|0]=1;f=f+1|0;g=g+1|0;if((z|0)!=(g|0)){continue}break}}f=v[l+4>>2]}r=r+1|0;if((r|0)<(f|0)){continue}break}u=v[i+208>>2];e=v[i+204>>2]}f=Mfa(a,v[h+8>>2],v[h>>2],v[h+20>>2],Q,k,D,v[i+212>>2],u,e,i+188|0,0,i+196|0,v[i+216>>2]);if((f|0)!=1){Eb(144166,3687);v[i+176>>2]=f;Fb(276579,i+176|0);break ma}if(!v[i+196>>2]){Hb(v[v[a>>2]+8>>2],i+204|0,144132,3694);Hb(v[v[a>>2]+8>>2],i+208|0,144132,3695);f=1;if((k|0)>0){while(1){e=k-1|0;Hb(v[v[a>>2]+8>>2],v[i+212>>2]+(e<<2)|0,144132,3698);g=k>>>0>1;k=e;if(g){continue}break}}Hb(v[v[a>>2]+8>>2],i+212|0,144132,3700);Hb(v[v[a>>2]+8>>2],i+216|0,144132,3701);break ma}va:{if(!H){break va}e=(v[i+188>>2]<<2)-4|0;v[H>>2]=v[v[v[i+212>>2]>>2]+(v[e+v[i+208>>2]>>2]<0?4:e)>>2];if(!F){break va}v[F>>2]=-1;e=v[l>>2];r=v[l+4>>2];if((e|0)>=(r|0)){break va}u=(n|0)<=1?1:n;g=-1;while(1){if((g|0)>=0){break va}wa:{xa:{ya:{za:{z=L+(v[C+(e<<2)>>2]<<2)|0;f=v[v[h+8>>2]+(v[z>>2]<<2)>>2];switch(v[f+376>>2]>>>6&3){case 3:break wa;case 0:break ya;default:break za}}if(!(A[f+128>>3]>=0)|!(A[f+136>>3]<=1)){break wa}if((n|0)>0){break xa}break wa}if((n|0)<=0){break wa}}y=v[H>>2];f=0;while(1){if((y|0)!=v[z+(f<<2)>>2]){f=f+1|0;if((u|0)!=(f|0)){continue}break wa}break}v[F>>2]=e;r=v[l+4>>2];g=e}e=e+1|0;if((r|0)>(e|0)){continue}break}}e=Ib(v[v[a>>2]+8>>2],k,4,144132,3757);v[i+220>>2]=e;Aa:{Ba:{if(e){f=0;if((k|0)<=0){break Aa}break Ba}Eb(144166,3757);f=-1;v[i+80>>2]=-1;Fb(276579,i+80|0);break ma}while(1){Ca:{g=Ib(v[v[a>>2]+8>>2],v[i+188>>2],4,144132,3760);v[e+(f<<2)>>2]=g;if(!g){break Ca}f=f+1|0;if((k|0)!=(f|0)){continue}break Aa}break}Eb(144166,3760);f=-1;v[i+96>>2]=-1;Fb(276579,i+96|0);break ma}f=c3(a,i+220|0,k,v[i+188>>2],v[h+8>>2],v[i+212>>2],v[i+208>>2],v[i+204>>2],0,i+192|0,1,N,O,R);if((f|0)!=1){Eb(144166,3766);v[i+160>>2]=f;Fb(276579,i+160|0);break ma}v[i+148>>2]=v[h+216>>2];v[i+144>>2]=p;e=i+224|0;Jb(e,1024,139972,i+144|0);f=jC(a,i+200|0,e,v[i+220>>2],0,k,v[i+188>>2],0,J,0,0,v[h+164>>2],1,0,1,1,0,0,0,0,0);if((f|0)!=1){Eb(144166,3775);v[i+128>>2]=f;Fb(276579,i+128|0);break ma}f=mc(a,v[i+200>>2]);if((f|0)!=1){Eb(144166,3777);v[i+112>>2]=f;Fb(276579,i+112|0);break ma}v[j+336>>2]=1;e=v[i+200>>2];g=v[h+184>>2];v[h+184>>2]=g+1;v[v[h+176>>2]+(g<<2)>>2]=e;v[h+216>>2]=v[h+216>>2]+1;Da:{if((k|0)>0){g=k-1|0;e=g;while(1){f=e;Hb(v[v[a>>2]+8>>2],v[i+220>>2]+(e<<2)|0,144132,3785);e=e-1|0;if(f){continue}break}Hb(v[v[a>>2]+8>>2],i+220|0,144132,3786);Hb(v[v[a>>2]+8>>2],i+204|0,144132,3787);Hb(v[v[a>>2]+8>>2],i+208|0,144132,3788);if((k|0)<=0){break Da}while(1){e=g;Hb(v[v[a>>2]+8>>2],v[i+212>>2]+(e<<2)|0,144132,3790);g=e-1|0;if(e){continue}break}break Da}Hb(v[v[a>>2]+8>>2],i+220|0,144132,3786);Hb(v[v[a>>2]+8>>2],i+204|0,144132,3787);Hb(v[v[a>>2]+8>>2],i+208|0,144132,3788)}Hb(v[v[a>>2]+8>>2],i+212|0,144132,3791);Hb(v[v[a>>2]+8>>2],i+216|0,144132,3792);f=1;break ma}Eb(144166,3641);f=-1;v[i+48>>2]=-1;Fb(276579,i+48|0)}ub=i+1248|0;e=f;if((e|0)==1){e=v[j+336>>2];if(!e){break fa}if(v[h+212>>2]|v[h+208>>2]){v[s+v[j+1404>>2]>>2]=v[j+332>>2];v[s+v[j+1400>>2]>>2]=v[j+1436>>2]}g=E+v[h+76>>2]|0;if(v[g>>2]){break fa}v[g>>2]=1;v[h+60>>2]=v[h+60>>2]+1;break fa}Eb(144166,4644);v[j+256>>2]=e;Fb(276579,j+256|0);break z}e=0;d=g}if(!(e|!v[h+212>>2])){k=v[j+1416>>2];g=v[j+1412>>2];if(v[h+208>>2]){v[s+v[j+1404>>2]>>2]=d;v[s+v[j+1400>>2]>>2]=v[k+(v[g+(d<<2)>>2]<<2)>>2]}f=d;i=j+1380|0;p=j+1376|0;d=j+1372|0;e=ub-1120|0;ub=e;u=v[h+168>>2];Ea:{if(u){Fa:{if(!v[d>>2]){v[p>>2]=0;d=Tb(v[v[a>>2]+4>>2],v[d>>2],4,144132,3830);v[i>>2]=d;if(d){break Fa}Eb(144166,3830);n=-1;v[e+32>>2]=-1;Fb(276579,e+32|0);break Ea}d=gc(v[v[a>>2]+4>>2],v[i>>2],v[p>>2],v[d>>2],4,144132,3838);v[i>>2]=d;if(d){break Fa}Eb(144166,3838);n=-1;v[e+48>>2]=-1;Fb(276579,e+48|0);break Ea}v[(v[p>>2]<<2)+d>>2]=v[k+(v[g+(f<<2)>>2]<<2)>>2];p=p+4|0}n=1;l=g+(f<<2)|0;d=v[l>>2];g=d+1|0;if((g|0)>=v[l+4>>2]){break Ea}while(1){v[e+72>>2]=0;v[e+76>>2]=-1074790400;v[e+64>>2]=0;v[e+68>>2]=1072693248;n=v[k+(d<<2)>>2]<<2;d=v[h+8>>2];n=v[n+d>>2];v[e+84>>2]=n;s=v[k+(g<<2)>>2];d=v[d+(s<<2)>>2];v[e+88>>2]=d;if(u){v[v[i>>2]+(v[p>>2]<<2)>>2]=s;p=p+4|0}n=v[n+208>>2];v[e+20>>2]=v[d+208>>2];v[e+16>>2]=n;d=e+96|0;Jb(d,1024,62296,e+16|0);Ga:{Ha:{n=d;d=v[h+164>>2];n=kd(a,e+92|0,n,2,e+84|0,e- -64|0,0,A[v[a+4>>2]+1272>>3],d,d,1,0,1,0,0,0,0,0);Ia:{if((n|0)!=1){d=3862;break Ia}n=mc(a,v[e+92>>2]);if((n|0)!=1){d=3864;break Ia}d=v[h+188>>2];if((d|0)<v[h+192>>2]){n=v[h+180>>2];break Ga}s=td(a,d+1|0);d=3879;n=gc(v[v[a>>2]+4>>2],v[h+180>>2],v[h+192>>2],s,4,144132,3879);v[h+180>>2]=n;if(n){break Ha}n=-1}Eb(144166,d);v[e>>2]=n;Fb(276579,e);break Ea}v[h+192>>2]=s;d=v[h+188>>2]}v[(d<<2)+n>>2]=v[e+92>>2];n=1;v[h+188>>2]=d+1;d=g;g=d+1|0;if((g|0)<v[l+4>>2]){continue}break}}ub=e+1120|0;e=n;if((e|0)!=1){Eb(144166,4694);v[j+240>>2]=e;Fb(276579,j+240|0);break z}Ja:{Ka:{La:{d=v[v[h+8>>2]+(v[v[j+1416>>2]+(v[v[j+1412>>2]+(f<<2)>>2]<<2)>>2]<<2)>>2];switch(v[d+376>>2]>>>6&3){case 0:break Ja;case 3:break Ka;default:break La}}if(!(A[d+128>>3]>=0)){break Ka}if(A[d+136>>3]<=1){break Ja}}I=1}d=E+v[h+76>>2]|0;if(v[d>>2]){break ea}v[d>>2]=1;v[h+60>>2]=v[h+60>>2]+1;break ea}if(!v[h+208>>2]|e){break ea}v[s+v[j+1404>>2]>>2]=-1}if((m|0)!=(o|0)){continue}break}}Ma:{if(!v[E+v[h+76>>2]>>2]|(!v[h+208>>2]|(D|0)>=(K|0))){break Ma}O=v[j+1412>>2];J=v[j+1416>>2];R=v[j+1404>>2];T=v[j+1400>>2];S=v[h+168>>2];f=j+1380|0;k=j+1376|0;i=j+1372|0;g=0;o=0;e=ub-1264|0;ub=e;v[e+1240>>2]=0;v[e+1244>>2]=-1074790400;v[e+1232>>2]=0;v[e+1236>>2]=1072693248;v[e+1212>>2]=1;v[e+1216>>2]=1;v[j+336>>2]=0;C=Ib(v[v[a>>2]+12>>2],v[h>>2],1,144132,3938);v[e+1256>>2]=C;Na:{if(!C){Eb(144166,3938);d=-1;v[e>>2]=-1;Fb(276579,e);break Na}n=je(v[v[a>>2]+8>>2],v[h>>2],1,144132,3939);v[e+1228>>2]=n;if(!n){Eb(144166,3939);d=-1;v[e+16>>2]=-1;Fb(276579,e+16|0);break Na}d=Ib(v[v[a>>2]+8>>2],v[h>>2],4,144132,3940);v[e+1220>>2]=d;if(!d){Eb(144166,3940);d=-1;v[e+32>>2]=-1;Fb(276579,e+32|0);break Na}d=Ib(v[v[a>>2]+8>>2],v[h>>2],4,144132,3941);v[e+1224>>2]=d;if(!d){Eb(144166,3941);d=-1;v[e+48>>2]=-1;Fb(276579,e+48|0);break Na}Oa:{if(!(v[f>>2]?f:0)){v[e+1260>>2]=0;break Oa}Pa:{d=Ic(e+1260|0,v[v[a>>2]+4>>2],v[i>>2]);if((d|0)==1){if(v[k>>2]<=0){break Oa}break Pa}Eb(144166,3954);v[e+160>>2]=d;Fb(276579,e+160|0);break Na}while(1){d=Ge(v[e+1260>>2],v[v[f>>2]+(g<<2)>>2],g);if((d|0)==1){g=g+1|0;if((g|0)<v[k>>2]){continue}break Oa}break}Eb(144166,3962);v[e+144>>2]=d;Fb(276579,e+144|0);break Na}Qa:{Ra:{if((m|0)<=0){break Ra}H=-1;g=0;while(1){d=o<<2;p=v[d+R>>2];Sa:{if((p|0)<0){break Sa}l=v[d+T>>2];if(w[l+n|0]){break Sa}s=O+(p<<2)|0;if(v[h>>2]==(v[s+4>>2]-v[s>>2]|0)){break Sa}d=v[e+1260>>2];Ta:{if(!d){break Ta}if(!f|!cd(d,l)){break Ta}d=v[f>>2];if(!d|v[i>>2]<=0|v[k>>2]<=0){break Ta}if((l|0)!=v[d>>2]){break Sa}}d=v[s>>2];if((d|0)<v[s+4>>2]){while(1){t[C+v[J+(d<<2)>>2]|0]=1;d=d+1|0;if((d|0)<v[s+4>>2]){continue}break}n=v[e+1228>>2]}M=v[h+20>>2];U=v[h+24>>2];Q=v[h+64>>2];u=v[h+68>>2];d=g<<2;L=v[d+(e+1220|0)>>2];V=e+1212|0;r=V+d|0;p=ub-32|0;ub=p;d=v[h>>2];F=je(v[v[a>>2]+8>>2],d,1,144183,344);v[p+28>>2]=F;Ua:{if(!F){Eb(144217,344);v[p>>2]=-1;Fb(276579,p);d=-1;break Ua}D=je(v[v[a>>2]+8>>2],d,4,144183,345);v[p+24>>2]=D;if(!D){Eb(144217,345);v[p+16>>2]=-1;Fb(276579,p+16|0);d=-1;break Ua}v[L>>2]=l;v[D>>2]=l;d=1;v[r>>2]=1;t[l+F|0]=1;if(n){t[l+n|0]=1}z=u+(G<<2)|0;u=v[z+4>>2];if((u|0)>v[z>>2]){y=0;while(1){l=v[z>>2];Va:{if((u|0)<=(l|0)){break Va}N=v[D+(y<<2)>>2]<<2;if(!M){N=N+U|0;while(1){u=v[v[N>>2]+(v[Q+(l<<2)>>2]<<2)>>2];P=u+F|0;Wa:{if(w[P|0]){break Wa}v[D+(d<<2)>>2]=u;t[P|0]=1;d=d+1|0;if(w[u+C|0]){break Wa}P=v[r>>2];v[r>>2]=P+1;v[L+(P<<2)>>2]=u;if(!n){break Wa}t[n+u|0]=1}l=l+1|0;u=v[z+4>>2];if((l|0)<(u|0)){continue}break}break Va}while(1){u=v[N+v[M+(v[Q+(l<<2)>>2]<<2)>>2]>>2];P=u+F|0;Xa:{if(w[P|0]){break Xa}v[D+(d<<2)>>2]=u;t[P|0]=1;d=d+1|0;if(w[u+C|0]){break Xa}P=v[r>>2];v[r>>2]=P+1;v[L+(P<<2)>>2]=u;if(!n){break Xa}t[n+u|0]=1}l=l+1|0;u=v[z+4>>2];if((l|0)<(u|0)){continue}break}}y=y+1|0;if((y|0)<(d|0)){continue}break}}Hb(v[v[a>>2]+8>>2],p+24|0,144183,395);Hb(v[v[a>>2]+8>>2],p+28|0,144183,396);d=1}ub=p+32|0;if((d|0)!=1){break Qa}p=1-g|0;d=v[r>>2]>v[V+(p<<2)>>2];g=d?p:g;H=d?o:H;d=v[s>>2];if((d|0)>=v[s+4>>2]){break Sa}while(1){t[C+v[J+(d<<2)>>2]|0]=0;d=d+1|0;if((d|0)<v[s+4>>2]){continue}break}}o=o+1|0;if((o|0)!=(m|0)){continue}break}if((H|0)<0){break Ra}d=1-g<<2;o=v[d+(e+1220|0)>>2];v[e+1248>>2]=v[v[h+8>>2]+(v[o>>2]<<2)>>2];l=d+(e+1212|0)|0;d=v[l>>2];v[j+336>>2]=d-1;if((d|0)>=2){g=1;while(1){d=v[v[h+8>>2]+(v[o+(g<<2)>>2]<<2)>>2];v[e+1252>>2]=d;d=v[d+208>>2];n=v[v[e+1248>>2]+208>>2];v[e+112>>2]=G;v[e+116>>2]=n;v[e+120>>2]=d;d=e+176|0;Jb(d,1024,62358,e+112|0);Ya:{Za:{n=d;d=v[h+164>>2];d=kd(a,e+1208|0,n,2,e+1248|0,e+1232|0,0,A[v[a+4>>2]+1272>>3],d,d,1,0,1,0,0,0,0,0);_a:{if((d|0)!=1){n=4050;break _a}d=mc(a,v[e+1208>>2]);if((d|0)!=1){n=4052;break _a}d=v[h+188>>2];if((d|0)<v[h+192>>2]){p=v[h+180>>2];break Ya}d=td(a,d+1|0);n=4067;p=gc(v[v[a>>2]+4>>2],v[h+180>>2],v[h+192>>2],d,4,144132,4067);v[h+180>>2]=p;if(p){break Za}d=-1}Eb(144166,n);v[e+96>>2]=d;Fb(276579,e+96|0);break Na}v[h+192>>2]=d;d=v[h+188>>2]}v[(d<<2)+p>>2]=v[e+1208>>2];v[h+188>>2]=d+1;g=g+1|0;if((g|0)<v[l>>2]){continue}break}}if(!S){break Ra}d=v[o>>2];g=v[i>>2];$a:{if(!g){v[i>>2]=1;v[k>>2]=0;g=Tb(v[v[a>>2]+4>>2],v[i>>2],4,144132,4089);v[f>>2]=g;if(!g){Eb(144166,4089);d=-1;v[e+64>>2]=-1;Fb(276579,e- -64|0);break Na}f=v[k>>2];v[k>>2]=f+1;g=g+(f<<2)|0;break $a}if((d|0)==v[v[f>>2]>>2]){break Ra}v[i>>2]=g+1;v[k>>2]=v[k>>2]+1;g=gc(v[v[a>>2]+4>>2],v[f>>2],v[k>>2],v[i>>2],4,144132,4114);v[f>>2]=g;if(!g){Eb(144166,4114);d=-1;v[e+80>>2]=-1;Fb(276579,e+80|0);break Na}f=v[i>>2];if((f|0)<2){break $a}Ee(g+4|0,g,(f<<2)-4|0)}v[g>>2]=d}Hb(v[v[a>>2]+8>>2],e+1224|0,144132,4128);Hb(v[v[a>>2]+8>>2],e+1220|0,144132,4129);if(v[e+1260>>2]){Bc(e+1260|0)}Hb(v[v[a>>2]+8>>2],e+1228|0,144132,4132);Hb(v[v[a>>2]+12>>2],e+1256|0,144132,4133);d=1;break Na}Eb(144166,4008);v[e+128>>2]=d;Fb(276579,e+128|0)}ub=e+1264|0;e=d;if((e|0)==1){break Ma}Eb(144166,4735);v[j+224>>2]=e;Fb(276579,j+224|0);break z}d=v[j+1376>>2];if(I|(!v[h+168>>2]|(d|0)<=0)){break ba}g=v[j+1428>>2];f=v[j+1424>>2];e=Lfa(a,v[h+20>>2],g,v[h+12>>2],v[h+8>>2],f,v[h>>2],v[j+1380>>2],d);if((e|0)!=1){break I}d=0;if((K|0)<=0){break ba}while(1){ab:{if(w[v[j+1368>>2]+d|0]){break ab}v[j+192>>2]=G;v[j+196>>2]=d;e=j+336|0;Jb(e,1024,139266,j+192|0);e=ZB(a,j+1436|0,e,v[g+(v[(v[h+64>>2]+(v[E+v[h+68>>2]>>2]<<2)|0)+(d<<2)>>2]<<2)>>2],f,v[h>>2],v[h+164>>2]);if((e|0)!=1){d=4769;break F}e=mc(a,v[j+1436>>2]);if((e|0)!=1){d=4770;break F}e=v[j+1436>>2];k=v[h+184>>2];v[h+184>>2]=k+1;v[v[h+176>>2]+(k<<2)>>2]=e;v[h+196>>2]=v[h+196>>2]+1;e=E+v[h+76>>2]|0;if(v[e>>2]){break ab}v[e>>2]=1;v[h+60>>2]=v[h+60>>2]+1}d=d+1|0;if((K|0)!=(d|0)){continue}break}}_b(v[v[a>>2]+4>>2],j+1380|0,v[j+1372>>2]<<2,144132,4787);lc(v[v[a>>2]+8>>2],j+1400|0);lc(v[v[a>>2]+8>>2],j+1404|0);_b(v[v[a>>2]+4>>2],j+1408|0,(m<<2)+4|0,144132,4791);_b(v[v[a>>2]+4>>2],j+1412|0,(v[j+1392>>2]<<2)+4|0,144132,4792);_b(v[v[a>>2]+4>>2],j+1416|0,v[h>>2]<<2,144132,4793);lc(v[v[a>>2]+8>>2],j+1368|0);lc(v[v[a>>2]+8>>2],j+1396|0)}G=G+1|0;if((G|0)<v[h+56>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],j+1420|0,144132,4804);Hb(v[v[a>>2]+8>>2],j+1424|0,144132,4806);e=1;d=v[h+12>>2];if((d|0)>0){f=v[j+1428>>2];while(1){g=d-1|0;Hb(v[v[a>>2]+8>>2],f+(g<<2)|0,144132,4809);k=d>>>0>1;d=g;if(k){continue}break}}Hb(v[v[a>>2]+8>>2],j+1428|0,144132,4811);Hb(v[v[a>>2]+8>>2],j+1432|0,144132,4812);break z}Eb(144166,4754);v[j+208>>2]=e;Fb(276579,j+208|0);break z}Eb(144166,4354);e=-1;v[j+64>>2]=-1;Fb(276579,j- -64|0);break z}Eb(144166,4493);e=-1;v[j+288>>2]=-1;Fb(276579,j+288|0);break z}Eb(144166,3273);e=-1;v[j+96>>2]=-1;Fb(276579,j+96|0);break D}Eb(144166,d);v[j+176>>2]=e;Fb(276579,j+176|0);break z}Eb(144166,d);v[j+144>>2]=e;Fb(276579,j+144|0);break z}Eb(144166,4401);v[j+80>>2]=e;Fb(276579,j+80|0)}ub=j+1440|0;if((e|0)==1){break y}Eb(144166,6422);v[q+48>>2]=e;Fb(276579,q+48|0);x=e;break a}bb:{if(!v[h+316>>2]){break bb}p=c;g=0;i=ub-1360|0;ub=i;v[i+284>>2]=0;v[i+280>>2]=0;v[i+264>>2]=0;d=v[h+340>>2];s=v[h+48>>2];c=v[h+44>>2];e=v[h+40>>2];m=v[h+36>>2];E=v[h+12>>2];O=v[h+24>>2];I=v[h>>2];G=v[h+8>>2];H=v[h+32>>2];cb:{if((H|0)!=-1){break cb}if((I|0)<=0){H=0;break cb}if((E|0)<=0){H=0;break cb}H=0;while(1){f=g<<2;k=f+G|0;n=v[f+O>>2];f=0;while(1){db:{if(v[n+(f<<2)>>2]==(g|0)){break db}H=H+1|0;eb:{switch((v[v[k>>2]+376>>2]>>>6&3)-1|0){case 2:s=s+1|0;break db;case 1:c=c+1|0;break db;case 0:e=e+1|0;break db;default:break eb}}m=m+1|0}f=f+1|0;if((E|0)!=(f|0)){continue}break}g=g+1|0;if((I|0)!=(g|0)){continue}break}}V=v[h+364>>2];k=v[h+336>>2];n=v[h+332>>2];F=v[h+56>>2];P=v[h+72>>2];J=v[h+76>>2];U=v[h+68>>2];R=v[h+64>>2];v[h+48>>2]=s;v[h+44>>2]=c;v[h+40>>2]=e;v[h+36>>2]=m;f=1;T=Lc(a);K=fc(a);g=m;m=d&(m|0)>0;o=m?g:0;g=d>>>1&(o|0)<(e|0);o=g?e:o;e=d>>>2&(o|0)<(c|0);l=d>>>3|0;d=e?c:o;c=l&(d|0)<(s|0);fb:{if(!(c?s:d)){break fb}z=1;gb:{S=c?3:e?2:g?1:m?0:3;hb:{if(S|(n&-2)!=2&(k|0)!=2){break hb}c=tc(a,140352);if(!c){break hb}k=v[c+464>>2];if(!k){break hb}l=v[c+332>>2];g=5308;f=Im(a,i+284|0,K);if((f|0)!=1){break gb}m=0;if((k|0)<=0){z=0;break hb}while(1){c=v[l+(m<<2)>>2];ib:{if((vi(c)|0)==2){break ib}n=Bj(c);e=0;d=wg(c);if((d|0)<=0){break ib}while(1){c=e;e=e+1|0;c=v[v[n+(c<<2)>>2]+292>>2];jb:{if((c|0)<0){break jb}g=e;if((d|0)<=(e|0)){break jb}while(1){kb:{o=v[v[n+(g<<2)>>2]+292>>2];if((o|0)<0){break kb}f=$k(v[i+284>>2],c,o);if((f|0)!=1){g=5369;break gb}f=$k(v[i+284>>2],o,c);if((f|0)==1){break kb}g=5370;break gb}g=g+1|0;if((d|0)!=(g|0)){continue}break}}if((d|0)!=(e|0)){continue}break}}z=0;m=m+1|0;if((k|0)!=(m|0)){continue}break}}D=Ib(v[v[a>>2]+8>>2],E,1,144132,6160);v[i+260>>2]=D;if(!D){Eb(144166,6160);f=-1;v[i>>2]=-1;Fb(276579,i);break fb}c=Ib(v[v[a>>2]+8>>2],I,4,144132,6161);v[i+276>>2]=c;if(!c){Eb(144166,6161);f=-1;v[i+16>>2]=-1;Fb(276579,i+16|0);break fb}c=Ib(v[v[a>>2]+8>>2],I,4,144132,6162);v[i+272>>2]=c;if(!c){Eb(144166,6162);f=-1;v[i+32>>2]=-1;Fb(276579,i+32|0);break fb}lb:{if(z){break lb}c=je(v[v[a>>2]+8>>2],I,1,144132,6166);v[i+264>>2]=c;if(!c){Eb(144166,6166);f=-1;v[i+176>>2]=-1;Fb(276579,i+176|0);break fb}mb:{f=Ic(i+280|0,v[v[a>>2]+4>>2],K);if((f|0)==1){g=0;if((K|0)<=0){break lb}break mb}Eb(144166,6167);v[i+208>>2]=f;Fb(276579,i+208|0);break fb}while(1){f=Ge(v[i+280>>2],v[T+(g<<2)>>2],g);if((f|0)==1){g=g+1|0;if((K|0)!=(g|0)){continue}break lb}break}Eb(144166,6171);v[i+192>>2]=f;Fb(276579,i+192|0);break fb}if(p){v[p>>2]=0}nb:{if((E|0)<=0){break nb}g=0;f=0;if(E>>>0>=8){d=E&2147483640;l=0;while(1){c=f+D|0;t[c|0]=1;t[c+1|0]=1;t[c+2|0]=1;t[c+3|0]=1;t[c+4|0]=1;t[c+5|0]=1;t[c+6|0]=1;t[c+7|0]=1;f=f+8|0;l=l+8|0;if((d|0)!=(l|0)){continue}break}}c=E&7;if(!c){break nb}while(1){t[f+D|0]=1;f=f+1|0;g=g+1|0;if((c|0)!=(g|0)){continue}break}}c=Ib(v[v[a>>2]+8>>2],F,4,144132,6185);v[i+256>>2]=c;ob:{pb:{if(c){if((F|0)<=0){break ob}Wb(c,0,F<<2);Z=E&2147483646;_=E&1;while(1){c=W<<2;qb:{if(v[c+J>>2]){break qb}L=c+U|0;f=v[L>>2];g=v[L+4>>2];if((f|0)<(g|0)){while(1){t[D+v[R+(f<<2)>>2]|0]=0;f=f+1|0;g=v[L+4>>2];if((f|0)<(g|0)){continue}break}f=v[L>>2]}C=(E-g|0)+f|0;rb:{if((E|0)<=(C|0)){break rb}o=v[i+272>>2];s=v[i+276>>2];while(1){f=f3(a,I,O,D,s,o,i+268|0,R,U,P,J,H);if((f|0)!=1){Eb(144166,6209);v[i+160>>2]=f;Fb(276579,i+160|0);break fb}sb:{if(V){o=v[i+272>>2];s=v[i+276>>2];break sb}f=0;o=v[i+272>>2];s=v[i+276>>2];c=v[i+268>>2];if((c|0)<=0){break sb}while(1){if((S|0)!=(v[v[G+(v[(v[(f<<2)+o>>2]<<2)+s>>2]<<2)>>2]+376>>2]>>>6&3)){break rb}f=f+1|0;if((c|0)!=(f|0)){continue}break}}M=v[i+268>>2];j=v[i+280>>2];f=v[i+284>>2];tb:{ub:{vb:{wb:{if(z){N=v[h+336>>2];r=v[h+332>>2];Q=v[i+264>>2];break wb}l=0;xb:{if((K|0)<=0){break xb}while(1){yb:{c=l<<2;g=v[c+v[f+12>>2]>>2];if(!g){g=Vb(v[v[a>>2]+4>>2],24,144132,5153);if(!g){break yb}c=v[c+T>>2];v[g+20>>2]=1;v[g>>2]=c}v[g+12>>2]=-1;v[g+16>>2]=-1;v[g+4>>2]=-1;v[g+8>>2]=0;v[v[f+12>>2]+(l<<2)>>2]=g;l=l+1|0;if((K|0)!=(l|0)){continue}break xb}break}Eb(144166,5153);f=-1;v[i+144>>2]=-1;Fb(276579,i+144|0);Eb(144166,6233);v[i+128>>2]=-1;Fb(276579,i+128|0);break fb}if((M|0)>0){d=v[o>>2];c=0;while(1){k=c;c=c+1|0;n=(c<<2)+o|0;e=v[n>>2];zb:{if((e|0)<=(d|0)){d=e;break zb}e=e-d|0;g=d;l=0;while(1){d=Pc(j,v[G+(v[(g<<2)+s>>2]<<2)>>2]);d=v[v[f+12>>2]+(d<<2)>>2];v[d+16>>2]=l;v[d+12>>2]=e;v[d+4>>2]=k;l=l+1|0;d=v[n>>2];g=g+1|0;if((d|0)>(g|0)){continue}break}}if((c|0)!=(M|0)){continue}break}}c=0;if((K|0)>0){while(1){e=c<<2;k=v[e+v[f+4>>2]>>2];d=0;n=v[e+v[f+12>>2]>>2];m=v[n+4>>2];Ab:{if((m|0)==-1){break Ab}g=0;if(v[e+v[f+20>>2]>>2]<=0){break Ab}while(1){e=v[v[f+12>>2]+(v[k+(g<<2)>>2]<<2)>>2];if(v[e+20>>2]){d=((m|0)==v[e+4>>2])+d|0}g=g+1|0;if((g|0)<v[v[f+20>>2]+(c<<2)>>2]){continue}break}}v[n+8>>2]=d;c=c+1|0;if((K|0)!=(c|0)){continue}break}}N=v[h+336>>2];r=v[h+332>>2];Q=v[i+264>>2];M=v[i+268>>2];j=v[i+280>>2];f=v[i+284>>2];if(z){break wb}if(r>>>0<=1){break vb}Bb:{if((K|0)<=0){k=0;m=0;u=0;break Bb}k=0;m=0;u=0;g=0;c=0;while(1){d=g<<2;Cb:{if((S|0)!=(v[v[d+T>>2]+376>>2]>>>6&3)){break Cb}e=v[d+v[f+12>>2]>>2];if(v[e+4>>2]==-1){break Cb}if((r|0)==2){d=v[e+8>>2]}else{d=v[v[f+20>>2]+(g<<2)>>2]}if((d|0)<=(c|0)){break Cb}m=v[e+16>>2];k=v[e+4>>2];u=1;c=d}g=g+1|0;if((K|0)!=(g|0)){continue}break}}d=(k<<2)+o|0;e=Pc(j,v[G+(v[((v[d>>2]<<2)+s|0)+(m<<2)>>2]<<2)>>2]);if(!u){break ub}e=e<<2;n=v[e+v[f+20>>2]>>2];if((n|0)<=0){break ub}c=0;j=0;l=v[d+4>>2]-v[d>>2]|0;if((l|0)<=0){break tb}e=v[e+v[f+4>>2]>>2];while(1){Db:{if((j|0)==(m|0)){break Db}u=v[G+(v[((v[d>>2]<<2)+s|0)+(j<<2)>>2]<<2)>>2];g=0;while(1){r=v[v[f+12>>2]+(v[e+(g<<2)>>2]<<2)>>2];if(!((u|0)!=v[r>>2]|!v[r+20>>2])){t[j+Q|0]=1;c=c+1|0;break Db}g=g+1|0;if((n|0)!=(g|0)){continue}break}}j=j+1|0;if((l|0)!=(j|0)){continue}break}break tb}if((r&-2)==2|r>>>0>1|(N|0)==2){break rb}}c=-2147483648;k=0;m=0;u=0;d=0;n=-2147483648;if((M|0)>0){while(1){y=(d<<2)+o|0;g=v[y>>2];Eb:{if((S|0)!=(v[v[G+(v[(g<<2)+s>>2]<<2)>>2]+376>>2]>>>6&3)){break Eb}Fb:{Gb:{switch(N|0){case 0:c=g-v[y+4>>2]|0;break Fb;case 1:c=v[y+4>>2]-g|0;break Fb;default:break Gb}}Hb:{if(!r){while(1){e=v[v[G+(v[(g<<2)+s>>2]<<2)>>2]+292>>2];if((e|0)!=-1){break Hb}g=g+1|0;if((g|0)<v[y+4>>2]){continue}break Eb}}l=v[y+4>>2];while(1){l=l-1|0;e=v[v[G+(v[(l<<2)+s>>2]<<2)>>2]+292>>2];if((e|0)!=-1){break Hb}if((g|0)<(l|0)){continue}break}break Eb}e=v[v[v[f+12>>2]+(e<<2)>>2]+8>>2];c=(e|0)>0?e:c}if((n|0)>=(c|0)){break Eb}u=1;m=r?v[y+4>>2]+(v[y>>2]^-1)|0:0;k=d;n=c}d=d+1|0;if((M|0)!=(d|0)){continue}break}}if(z){break ub}d=(k<<2)+o|0;e=Pc(j,v[G+(v[((v[d>>2]<<2)+s|0)+(m<<2)>>2]<<2)>>2]);if(!u|(N|0)!=2){break ub}e=e<<2;n=v[e+v[f+20>>2]>>2];if((n|0)<=0){break ub}c=0;j=0;l=v[d+4>>2]-v[d>>2]|0;if((l|0)<=0){break tb}e=v[e+v[f+4>>2]>>2];while(1){Ib:{if((j|0)==(m|0)){break Ib}u=v[G+(v[((v[d>>2]<<2)+s|0)+(j<<2)>>2]<<2)>>2];g=0;while(1){r=v[v[f+12>>2]+(v[e+(g<<2)>>2]<<2)>>2];if(!((u|0)!=v[r>>2]|!v[r+20>>2])){t[j+Q|0]=1;c=c+1|0;break Ib}g=g+1|0;if((n|0)!=(g|0)){continue}break}}j=j+1|0;if((l|0)!=(j|0)){continue}break}break tb}c=0;if(!u){break rb}}u=v[i+284>>2];d=(k<<2)+o|0;e=v[d+4>>2]-v[d>>2]|0;f=1;Jb:{Kb:{Lb:{Mb:{Nb:{if(!v[h+360>>2]){if((v[h+332>>2]&-2)!=2){n=1;if(v[h+336>>2]!=2){break Nb}}f=v[h+356>>2]}n=!f;c=f?e+(c^-1)|0:0;if((c|0)<=0){break Nb}g=v[h+324>>2];if(!g){v[h+328>>2]=c<<1;l=5646;c=Tb(v[v[a>>2]+4>>2],v[h+328>>2],4,144132,5646);v[h+320>>2]=c;if(c){break Nb}break Mb}f=c+g|0;g=v[h+328>>2];if((f|0)<=(g|0)){break Nb}c=td(a,g+(c<<1)|0);l=5654;g=gc(v[v[a>>2]+4>>2],v[h+320>>2],v[h+328>>2],c,4,144132,5654);v[h+320>>2]=g;if(!g){break Mb}v[h+328>>2]=c}f=v[h+348>>2];Ob:{if(f){g=v[h+344>>2];break Ob}c=v[h+12>>2];g=v[h>>2];v[h+352>>2]=(c|0)<(g|0)?c:g;l=5662;g=Tb(v[v[a>>2]+4>>2],v[h+352>>2],4,144132,5662);v[h+344>>2]=g;if(!g){break Mb}f=v[h+348>>2]}k=m<<2;r=k+((v[d>>2]<<2)+s|0)|0;c=v[r>>2];l=v[G+(c<<2)>>2];v[i+296>>2]=0;v[i+300>>2]=1072693248;v[i+288>>2]=0;v[i+292>>2]=-1074790400;v[i+312>>2]=l;v[h+348>>2]=f+1;v[(f<<2)+g>>2]=c;Pb:{if((e|0)<=0){j=0;break Pb}g=v[d>>2];if(z){j=0;l=0;if(n&1){break Pb}while(1){if((l|0)!=(m|0)){c=v[(g<<2)+s>>2];v[i+316>>2]=v[G+(c<<2)>>2];f=v[r>>2];v[i+100>>2]=c;v[i+96>>2]=f;c=i+320|0;Jb(c,1024,139930,i+96|0);f=kd(a,i+1356|0,c,2,i+312|0,i+288|0,-A[v[a+4>>2]+1272>>3],0,0,1,1,1,1,0,0,0,0,0);if((f|0)!=1){l=5731;break Lb}f=mc(a,v[i+1356>>2]);if((f|0)!=1){l=5733;break Lb}c=v[i+1356>>2];f=v[h+324>>2];v[h+324>>2]=f+1;v[v[h+320>>2]+(f<<2)>>2]=c}g=g+1|0;l=l+1|0;if((e|0)!=(l|0)){continue}break}break Pb}j=0;l=0;c=0;if(n&1){while(1){Qb:{if((l|0)==(m|0)){break Qb}n=(g<<2)+s|0;c=v[G+(v[n>>2]<<2)>>2];v[i+316>>2]=c;r=l+Q|0;if(!w[r|0]){break Qb}if(A[c+160>>3]>.5){f=Mf(a,c,0);if((f|0)!=1){l=5703;break Lb}v[v[v[u+12>>2]+(v[n>>2]<<2)>>2]+20>>2]=0;j=j+1|0}t[r|0]=0}g=g+1|0;l=l+1|0;if((e|0)!=(l|0)){continue}break Pb}}while(1){Rb:{if((c|0)==(m|0)){break Rb}n=(g<<2)+s|0;l=v[n>>2];f=v[G+(l<<2)>>2];v[i+316>>2]=f;y=c+Q|0;if(w[y|0]){if(A[f+160>>3]>.5){f=Mf(a,f,0);if((f|0)!=1){l=5703;break Lb}v[v[v[u+12>>2]+(v[n>>2]<<2)>>2]+20>>2]=0;j=j+1|0}t[y|0]=0;break Rb}f=v[r>>2];v[i+116>>2]=l;v[i+112>>2]=f;f=i+320|0;Jb(f,1024,139930,i+112|0);f=kd(a,i+1356|0,f,2,i+312|0,i+288|0,-A[v[a+4>>2]+1272>>3],0,0,1,1,1,1,0,0,0,0,0);if((f|0)!=1){l=5721;break Lb}f=mc(a,v[i+1356>>2]);if((f|0)!=1){l=5723;break Lb}f=v[i+1356>>2];n=v[h+324>>2];v[h+324>>2]=n+1;v[v[h+320>>2]+(n<<2)>>2]=f}g=g+1|0;c=c+1|0;if((e|0)!=(c|0)){continue}break}}c=v[i+256>>2]+(v[v[h+72>>2]+(v[k+((v[d>>2]<<2)+s|0)>>2]<<2)>>2]<<2)|0;v[c>>2]=v[c>>2]+1;if(p){v[p>>2]=v[p>>2]+j}if((E|0)<=0){break Jb}c=v[k+((v[d>>2]<<2)+s|0)>>2];d=O+(c<<2)|0;f=0;g=0;if((E|0)==1){break Kb}while(1){e=f+D|0;if(!(w[e|0]|(c|0)==v[v[d>>2]+(f<<2)>>2])){t[e|0]=1;C=C+1|0}e=f|1;k=e+D|0;if(!(w[k|0]|(c|0)==v[v[d>>2]+(e<<2)>>2])){t[k|0]=1;C=C+1|0}f=f+2|0;g=g+2|0;if((Z|0)!=(g|0)){continue}break}break Kb}f=-1}Eb(144166,l);v[i+80>>2]=f;Fb(276579,i+80|0);Eb(144166,6262);v[i+64>>2]=f;Fb(276579,i- -64|0);break fb}if(!_){break Jb}e=f+D|0;if(w[e|0]|(c|0)==v[v[d>>2]+(f<<2)>>2]){break Jb}t[e|0]=1;C=C+1|0}if((C|0)<(E|0)){continue}break}}f=v[L>>2];if((f|0)>=v[L+4>>2]){break qb}while(1){t[D+v[R+(f<<2)>>2]|0]=1;f=f+1|0;if((f|0)<v[L+4>>2]){continue}break}}W=W+1|0;if((F|0)!=(W|0)){continue}break}break pb}Eb(144166,6185);f=-1;v[i+48>>2]=-1;Fb(276579,i+48|0);break fb}if((F|0)<=0){break ob}f=0;c=v[i+256>>2];if((F|0)!=1){d=F&2147483646;l=0;while(1){e=f<<2;if(v[e+c>>2]>0){e=e+J|0;v[e>>2]=v[e>>2]|4}e=(f|1)<<2;if(v[e+c>>2]>0){e=e+J|0;v[e>>2]=v[e>>2]|4}f=f+2|0;l=l+2|0;if((d|0)!=(l|0)){continue}break}}if(!(F&1)){break ob}d=c;c=f<<2;if(v[d+c>>2]<=0){break ob}c=c+J|0;v[c>>2]=v[c>>2]|4}Hb(v[v[a>>2]+8>>2],i+256|0,144132,6294);Sb:{if(!z){Bc(i+280|0);Hb(v[v[a>>2]+8>>2],i+264|0,144132,6299);Hb(v[v[a>>2]+8>>2],i+272|0,144132,6301);Hb(v[v[a>>2]+8>>2],i+276|0,144132,6302);e=i+284|0;c=0;d=ub-16|0;ub=d;if((K|0)>0){while(1){g=v[v[v[e>>2]+12>>2]+(c<<2)>>2];v[d+12>>2]=g;if(g){Lb(v[v[a>>2]+4>>2],d+12|0,24,144132,5407)}c=c+1|0;if((K|0)!=(c|0)){continue}break}}no(e);ub=d+16|0;break Sb}Hb(v[v[a>>2]+8>>2],i+272|0,144132,6301);Hb(v[v[a>>2]+8>>2],i+276|0,144132,6302)}Hb(v[v[a>>2]+8>>2],i+260|0,144132,6308);f=1;break fb}Eb(144166,g);v[i+240>>2]=f;Fb(276579,i+240|0);Eb(144166,6156);v[i+224>>2]=f;Fb(276579,i+224|0)}ub=i+1360|0;if((f|0)==1){break bb}Eb(144166,6427);v[q+16>>2]=f;Fb(276579,q+16|0);x=f;break a}if(rc(v[a+4>>2],v[a+24>>2],0)|!v[h+156>>2]|v[h+240>>2]){break a}if(!v[X>>2]|v[h+12>>2]<=0){break b}Tb:{if(!v[h+168>>2]){break Tb}s=v[h+64>>2];u=v[h+68>>2];m=v[h+56>>2];g=0;e=0;n=0;j=0;o=0;d=ub-1168|0;ub=d;v[d+1164>>2]=0;v[d+1160>>2]=0;c=v[b+84>>2];Ub:{if(!v[c+4>>2]){g=1;break Ub}p=v[c+164>>2];x=v[c>>2];k=v[c+8>>2];b=v[c+12>>2];i=v[c+20>>2];Vb:{if(!(t[c+340|0]&1)|v[c+348>>2]<=0){break Vb}n=Ib(v[v[a>>2]+8>>2],b,4,144132,5468);v[d+1164>>2]=n;Wb:{Xb:{if(n){if((b|0)<=0){break Wb}break Xb}Eb(144166,5468);g=-1;v[d+64>>2]=-1;Fb(276579,d- -64|0);break Ub}while(1){Yb:{e=Ib(v[v[a>>2]+8>>2],x,4,144132,5471);v[(g<<2)+n>>2]=e;if(!e){break Yb}g=g+1|0;if((g|0)!=(b|0)){continue}break Wb}break}Eb(144166,5471);g=-1;v[d+80>>2]=-1;Fb(276579,d+80|0);break Ub}e=Ib(v[v[a>>2]+8>>2],x,4,144132,5473);v[d+1160>>2]=e;if(e){Zb:{if((x|0)<=0){break Zb}g=0;if(x>>>0>=4){l=x&2147483644;while(1){f=g<<2;v[f+e>>2]=v[f+k>>2];r=f|4;v[r+e>>2]=v[k+r>>2];r=f|8;v[r+e>>2]=v[k+r>>2];f=f|12;v[f+e>>2]=v[f+k>>2];g=g+4|0;j=j+4|0;if((l|0)!=(j|0)){continue}break}}f=x&3;if(!f){break Zb}while(1){l=g<<2;v[l+e>>2]=v[k+l>>2];g=g+1|0;o=o+1|0;if((f|0)!=(o|0)){continue}break}}g=Lfa(a,i,n,b,k,e,x,v[c+344>>2],v[c+348>>2]);if((g|0)==1){break Vb}Eb(144166,5479);v[d+112>>2]=g;Fb(276579,d+112|0);break Ub}Eb(144166,5473);g=-1;v[d+96>>2]=-1;Fb(276579,d+96|0);break Ub}_b:{if((m|0)!=-1){if((m|0)<=0){break _b}f=0;while(1){l=f<<2;g=v[l+v[c+76>>2]>>2];$b:{if(g&3|(v[c+340>>2]&14?g&4:0)){break $b}j=l+u|0;o=v[j>>2];if((o|0)>=v[j+4>>2]){break $b}while(1){g=v[s+(o<<2)>>2];v[d+52>>2]=g;v[d+48>>2]=f;r=d+128|0;Jb(r,1024,139234,d+48|0);ac:{bc:{cc:{if(!(!(t[c+340|0]&1)|v[c+348>>2]<=0)){g=ZB(a,d+1156|0,r,v[(g<<2)+n>>2],e,x,p);if((g|0)==1){break cc}b=5545;break bc}g=ZB(a,d+1156|0,d+128|0,v[i+(g<<2)>>2],k,x,p);if((g|0)==1){break cc}b=5550;break bc}g=l+v[c+76>>2]|0;v[g>>2]=v[g>>2]|1;g=mc(a,v[d+1156>>2]);if((g|0)==1){break ac}b=5553}Eb(144166,b);v[d+32>>2]=g;Fb(276579,d+32|0);break Ub}g=v[d+1156>>2];r=v[c+184>>2];v[c+184>>2]=r+1;v[v[c+176>>2]+(r<<2)>>2]=g;v[c+196>>2]=v[c+196>>2]+1;o=o+1|0;if((o|0)<v[j+4>>2]){continue}break}}f=f+1|0;if((m|0)!=(f|0)){continue}break}break _b}if(v[c+12>>2]<=0){break _b}f=0;while(1){v[d+16>>2]=f;e=d+128|0;Jb(e,1024,139214,d+16|0);dc:{g=ZB(a,d+1156|0,e,v[i+(f<<2)>>2],k,x,p);if((g|0)!=1){b=5498}else{g=mc(a,v[d+1156>>2]);if((g|0)==1){break dc}b=5500}Eb(144166,b);v[d>>2]=g;Fb(276579,d);break Ub}e=v[d+1156>>2];g=v[c+184>>2];v[c+184>>2]=g+1;v[v[c+176>>2]+(g<<2)>>2]=e;v[c+196>>2]=v[c+196>>2]+1;f=f+1|0;if((f|0)<v[c+12>>2]){continue}break}}g=1;if(!(t[c+340|0]&1)|v[c+348>>2]<=0){break Ub}Hb(v[v[a>>2]+8>>2],d+1160|0,144132,5568);if((b|0)>0){while(1){c=b-1|0;Hb(v[v[a>>2]+8>>2],(c<<2)+n|0,144132,5571);e=b>>>0>1;b=c;if(e){continue}break}}Hb(v[v[a>>2]+8>>2],d+1164|0,144132,5573)}ub=d+1168|0;x=g;if((g|0)==1){break Tb}Eb(144166,6443);v[q>>2]=g;Fb(276579,q);break a}if(v[h+184>>2]){break b}_b(v[v[a>>2]+4>>2],h+176|0,v[h+12>>2]<<2,144132,6448)}x=1}ub=q+1456|0;return x}function kTa(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,x=0,z=0,B=0,C=0,E=0,G=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0;x=ub-160|0;ub=x;v[x+152>>2]=0;v[x+144>>2]=0;i=1;v[c>>2]=1;o=v[b+144>>2];a:{if(rc(v[a+4>>2],v[a+24>>2],0)){break a}f=v[o+12>>2];if((f|0)>=0&(e|0)>(f|0)){break a}f=v[b+164>>2];b:{if(!e){e=v[o+8>>2];if((e|0)<0|(e|0)>(f|0)){break b}break a}if((e|0)<=0){break b}e=v[o+4>>2];if((e|0)<0){break b}if((e|0)<=(f|0)){break a}}if(v[v[a+72>>2]+204>>2]){e=v[a+56>>2];if(v[e+468>>2]){e=v[e+420>>2]}else{e=0}}else{e=0}if((e|0)!=1){break a}if(R=(Ne(a)|0)>0,S=0,T=v[o+76>>2],T?R:S){break a}if(!Ch(a)){break a}c:{if(!(v[o+180>>2]|v[o+184>>2])|!(v[o+144>>2]|v[o+148>>2])){break c}ic(a,3,0,324500,0);e=Rc(a,160720,0);if((e|0)!=1){Eb(151867,4368);v[x+128>>2]=e;Fb(276579,x+128|0);i=e;break a}e=Rc(a,160916,0);if((e|0)==1){break c}Eb(151867,4369);v[x+112>>2]=e;Fb(276579,x+112|0);i=e;break a}v[o+80>>2]=d;d=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+320>>2]:0;e=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+344>>2]:0;if((d|0)<6|(e|0)<6){break a}d:{if(!v[o+16>>2]){break d}i=e>>>0>136;h=A[v[a+24>>2]+648>>3];if(!(i|!(h<=.05))&d>>>0<144){break d}if(!(!(h<=.15)|(!(h>.05)|i))){if(d>>>0<144){break d}}i=e-137>>>0>195;if(!i&d>>>0<144|!(d>>>0<656|i)&d>>>0<1291){break d}if(!(!(h>.15)|e-334>>>0>540|(!(h<=.25)|d>>>0<2615))){if(d>>>0<5142){break d}}i=e-876|0;f=i>>>0<801;k=f&h<=.05;if(!(!k|d>>>0<144)&d>>>0<266|(k&d>>>0>265&d>>>0<655|f&h>.05&h<=.15)){break d}if(!(!(h>.15)|i>>>0>800|(!(h<=.25)|d>>>0<1292))){if(d>>>0<2614){break d}}e=e>>>0>8146;i=e&h>.75&h<=6.25;if(i&d>>>0>655&d>>>0<1291|i&d>>>0>1291&d>>>0<2614){break d}i=1;if(!(e&h>6.25)){break a}}v[c>>2]=3;j=Vb(v[v[a>>2]+4>>2],96,151833,4425);v[x+156>>2]=j;if(!j){Eb(151867,4425);i=-1;v[x>>2]=-1;Fb(276579,x);break a}v[j+24>>2]=0;v[j+28>>2]=0;v[j>>2]=0;v[j+92>>2]=o;v[j+88>>2]=b;v[j+84>>2]=a;v[j+80>>2]=0;t[j+72|0]=32;v[j+32>>2]=0;v[j+36>>2]=0;v[j+40>>2]=0;v[j+44>>2]=0;v[j+48>>2]=0;v[j+52>>2]=0;v[j+56>>2]=0;v[j+60>>2]=0;d=j- -64|0;v[d>>2]=0;v[d+4>>2]=0;i=Rt(a,86615,j+72|0);if((i|0)!=1){Eb(151867,4447);v[x+96>>2]=i;Fb(276579,x+96|0);break a}f=ub-2208|0;ub=f;d=xl(a,f+2204|0,f+1148|0);e:{if((d|0)!=1){Eb(151867,1092);v[f+1136>>2]=d;Fb(276579,f+1136|0);break e}d=ug(a,f+2200|0,f+1144|0);if((d|0)!=1){Eb(151867,1093);v[f+1120>>2]=d;Fb(276579,f+1120|0);break e}v[j+4>>2]=0;v[j+8>>2]=0;e=v[f+1144>>2];v[j+12>>2]=e;d=v[f+1148>>2];v[j+20>>2]=e;v[j+16>>2]=d;if(v[o+180>>2]|v[o+184>>2]){e=e+1|0;v[j+20>>2]=e}v[j+76>>2]=v[o+176>>2];d=Gf(j);if((d|0)!=1){Eb(151867,1112);v[f+1104>>2]=d;Fb(276579,f+1104|0);break e}g=v[j>>2];d=eo(g);if((d|0)!=1){Eb(151867,1114);v[f+1088>>2]=d;Fb(276579,f+1088|0);break e}f:{if(!v[o+172>>2]){break f}p=609;g:{d=Vb(v[v[g>>2]+4>>2],4,151833,609);if(!d){d=-1;break g}v[d>>2]=j;p=616;d=uh(g,f+1152|0,28346,28257,-1e6,-1e6,100,0,1885,1886,1887,1888,d);if((d|0)!=1){break g}v[v[f+1152>>2]+204>>2]=1889;break f}Eb(151867,p);v[f+1072>>2]=d;Fb(276579,f+1072|0);Eb(151867,1119);v[f+1056>>2]=d;Fb(276579,f+1056|0);break e}v[f+1040>>2]=v[v[a+28>>2]+32>>2];d=f+1152|0;Jb(d,1024,225418,f+1040|0);d=tk(g,d,0,0,0,0,0,0,0);if((d|0)!=1){Eb(151867,1123);v[f+1024>>2]=d;Fb(276579,f+1024|0);break e}v[v[g+24>>2]+1136>>2]=v[v[a+24>>2]+1136>>2]+1;d=Qk(g,-1);if((d|0)!=1){Eb(151867,1125);v[f+1008>>2]=d;Fb(276579,f+1008|0);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2],4,151833,1128);v[j+24>>2]=d;if(!d){Eb(151867,1128);d=-1;v[f>>2]=-1;Fb(276579,f);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2],4,151833,1129);v[j+32>>2]=d;if(!d){Eb(151867,1129);d=-1;v[f+16>>2]=-1;Fb(276579,f+16|0);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2],4,151833,1130);v[j+40>>2]=d;if(!d){Eb(151867,1130);d=-1;v[f+32>>2]=-1;Fb(276579,f+32|0);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2],4,151833,1131);v[j+44>>2]=d;if(!d){Eb(151867,1131);d=-1;v[f+48>>2]=-1;Fb(276579,f+48|0);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2],4,151833,1132);v[j+48>>2]=d;if(!d){Eb(151867,1132);d=-1;v[f+64>>2]=-1;Fb(276579,f- -64|0);break e}d=Tb(v[v[a>>2]+4>>2],e,4,151833,1133);v[j+52>>2]=d;if(!d){Eb(151867,1133);d=-1;v[f+80>>2]=-1;Fb(276579,f+80|0);break e}d=Tb(v[v[a>>2]+4>>2],e,4,151833,1134);v[j+56>>2]=d;if(!d){Eb(151867,1134);d=-1;v[f+96>>2]=-1;Fb(276579,f+96|0);break e}d=Tb(v[v[a>>2]+4>>2],v[f+1148>>2]<<1,4,151833,1135);v[j+60>>2]=d;if(!d){Eb(151867,1135);d=-1;v[f+112>>2]=-1;Fb(276579,f+112|0);break e}d=Tb(v[v[a>>2]+4>>2],e,8,151833,1136);v[j+64>>2]=d;if(!d){Eb(151867,1136);d=-1;v[f+128>>2]=-1;Fb(276579,f+128|0);break e}z=Tb(v[v[a>>2]+4>>2],e,8,151833,1137);v[j+68>>2]=z;if(!z){Eb(151867,1137);d=-1;v[f+144>>2]=-1;Fb(276579,f+144|0);break e}E=v[j+64>>2];M=Ib(v[v[a>>2]+8>>2],v[f+1148>>2],8,151833,1142);v[f+2196>>2]=M;if(!M){Eb(151867,1142);d=-1;v[f+160>>2]=-1;Fb(276579,f+160|0);break e}u=Ib(v[v[a>>2]+8>>2],v[f+1148>>2],8,151833,1143);v[f+2192>>2]=u;if(!u){Eb(151867,1143);d=-1;v[f+176>>2]=-1;Fb(276579,f+176|0);break e}L=Ib(v[v[a>>2]+8>>2],v[f+1148>>2],8,151833,1144);v[f+2188>>2]=L;h:{i:{if(L){if(v[f+1144>>2]>0){break i}k=2147483647;break h}Eb(151867,1144);d=-1;v[f+192>>2]=-1;Fb(276579,f+192|0);break e}k=2147483647;e=0;while(1){d=v[v[f+2200>>2]+(e<<2)>>2];h=A[d+8>>3]-A[d>>3];i=e<<3;m=i+E|0;if(w[d+273|0]&4){h=I(h-A[v[a+4>>2]+1296>>3])}A[m>>3]=h;h=A[d+16>>3]-A[d>>3];p=i+z|0;i=p;if(w[d+273|0]&4){h=H(h+A[v[a+4>>2]+1296>>3])}A[i>>3]=h;i=v[d+272>>2];j:{if(i&4096|(v[o+80>>2]?0:i&2048)){break j}k:{if(v[o+64>>2]){break k}C=v[o+68>>2];if((C|0)<=0){break k}if((C|0)<v[d+264>>2]){break j}}if((((i&-536870912)==1610612736?v[d+172>>2]:0)|0)==(b|0)?v[o+72>>2]:0){break j}l=sn(a,d);i=v[a+4>>2];h=A[i+1272>>3];if(!(h<=D(A[m>>3]))){if(v[o+64>>2]){q=A[d+8>>3];h=D(q);B=A[i+1296>>3];q=l-q;l=D(l);l:{if(l<=1){l=1;if(h<=1){break l}l=h;break l}l=h<=l?l:h}if(!(B>=D(q/l))){break j}}d=v[d+220>>2];k=(d|0)<(k|0)?d:k;n=(d|0)>(n|0)?d:n;break j}if(h<=A[p>>3]){break j}if(v[o+64>>2]){q=A[d+16>>3];h=D(q);B=A[i+1296>>3];q=l-q;l=D(l);m:{if(l<=1){l=1;if(h<=1){break m}l=h;break m}l=h<=l?l:h}if(!(B>=D(q/l))){break j}}d=v[d+220>>2];k=(d|0)<(k|0)?d:k;n=(d|0)>(n|0)?d:n}e=e+1|0;if((e|0)<v[f+1144>>2]){continue}break}}n:{if(!v[o+180>>2]){break n}h=Tc(a);A[z+(v[j+12>>2]<<3)>>3]=h;o:{if(Tc(a)>=A[v[a+4>>2]+1272>>3]){break o}if((Bi(a)|0)<=(n|0)){break o}n=Bi(a)}if(Tc(a)>=A[v[a+4>>2]+1272>>3]){break n}if((Bi(a)|0)>=(k|0)){break n}k=Bi(a)}p:{if(!v[o+184>>2]){break p}d=rl(a);h=Gd(a);e=E+(v[j+12>>2]<<3)|0;if(d){h=I(h-A[v[a+4>>2]+1296>>3])}A[e>>3]=h;h=Gd(a);q:{if(A[v[a+4>>2]+1272>>3]<=-h){break q}if((Bi(a)|0)<=(n|0)){break q}n=Bi(a)}h=Gd(a);if(A[v[a+4>>2]+1272>>3]<=-h){break p}if((Bi(a)|0)>=(k|0)){break p}k=Bi(a)}if(v[f+1148>>2]>0){while(1){m=r<<2;s=v[m+v[f+2204>>2]>>2];e=v[s+164>>2];p=r<<3;d=p+L|0;A[d>>3]=v[s+224>>2]>=0?A[s+72>>3]:0;G=p+M|0;h=A[e+128>>3];A[G>>3]=h;r:{if(v[o+80>>2]){i=v[a+4>>2];l=A[e+152>>3];if(A[i+1280>>3]<l-h){A[G>>3]=l}C=p+u|0;h=A[e+136>>3];A[C>>3]=h;l=A[e+160>>3];if(!(-A[i+1280>>3]>l-h)){break r}A[C>>3]=l;break r}A[p+u>>3]=A[e+136>>3]}e=m+v[j+40>>2]|0;v[e>>2]=0;v[m+v[j+44>>2]>>2]=0;v[m+v[j+48>>2]>>2]=0;s:{if(t[s+253|0]&1){h=A[d>>3];l=h;e=v[a+4>>2];h=A[e+1296>>3];t:{if(!v[o+100>>2]|l-H(l+h)<=h|v[f+1148>>2]<v[o+112>>2]){break t}h=If(v[o>>2],0,1);e=v[a+4>>2];if(!(A[o+104>>3]>=h)){break t}l=A[p+u>>3];B=A[e+1272>>3];h=A[G>>3];q=-h;u:{if(!(l>=B|B<=q)){q=l;l=A[d>>3];h=q-l<l-h?q:h;break u}h=q>=B?l:h}A[d>>3]=h}h=A[d>>3];l=h;h=A[e+1296>>3];if(!v[o+84>>2]|l-H(l+h)<=h|v[f+1148>>2]<v[o+96>>2]){break s}if(!(If(v[o>>2],0,1)<=A[o+88>>3])){break s}v[m+v[j+40>>2]>>2]=2;break s}v[e>>2]=1}v:{w:{C=v[j+40>>2];i=v[m+C>>2];if(i){e=v[a+4>>2];break w}O=p+u|0;q=A[O>>3];h=D(q);e=v[a+4>>2];B=A[e+1296>>3];l=A[d>>3];J=l-q;l=D(l);x:{if(l<=1){l=1;if(h<=1){break x}l=h;break x}l=h<=l?l:h}if(!(B>=D(J/l))){break w}sS(a,o,j,s,q,-1,E,z,G,O,d);v[m+v[j+44>>2]>>2]=1;v[m+v[j+40>>2]>>2]=3;break v}h=A[e+1272>>3];l=A[G>>3];q=-l;if(!(h<=q)){if(!(A[e+1280>>3]>=D(l))){sS(a,o,j,s,q,1,E,z,G,p+u|0,d);v[m+v[j+48>>2]>>2]=1;C=v[j+40>>2];i=v[m+C>>2]}if(i|!(A[v[a+4>>2]+1280>>3]>=D(A[d>>3]))){break v}v[m+C>>2]=4;break v}l=h;e=p+u|0;h=A[e>>3];if(l<=h){break v}sS(a,o,j,s,h,-1,E,z,G,e,d);v[m+v[j+44>>2]>>2]=1;e=m+v[j+40>>2]|0;if(v[e>>2]|!(A[v[a+4>>2]+1280>>3]>=D(A[d>>3]))){break v}v[e>>2]=4}r=r+1|0;if((r|0)<v[f+1148>>2]){continue}break}}l=v[o+116>>2]?A[v[a+4>>2]+1272>>3]:.999;y:{z:{A:{B:{C:{if(v[f+1144>>2]<=0){m=0;break C}B=-.99/+(n-k|0);m=0;p=0;while(1){i=p<<2;e=v[i+v[f+2200>>2]>>2];v[i+v[j+52>>2]>>2]=0;v[i+v[j+56>>2]>>2]=0;d=v[e+272>>2];D:{if(d&4096|(v[o+80>>2]?0:d&2048)){break D}E:{if(v[o+64>>2]){break E}r=v[o+68>>2];if((r|0)<=0){break E}if((r|0)<v[e+264>>2]){break D}}if((((d&-536870912)==1610612736?v[e+172>>2]:0)|0)==(b|0)?v[o+72>>2]:0){break D}d=v[a+4>>2];r=p<<3;h=A[r+E>>3];r=r+z|0;if(A[d+1280>>3]>=D(h-A[r>>3])){h=-A[o+128>>3];if(v[o+136>>2]){h=((k|0)!=(n|0)?B*+(n-v[e+220>>2]|0)+1:1)*h}v[f+992>>2]=p;d=f+1152|0;Jb(d,1024,140121,f+992|0);d=Wd(g,i+v[j+52>>2]|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1466);v[f+976>>2]=d;Fb(276579,f+976|0);break e}d=id(g,v[i+v[j+52>>2]>>2]);if((d|0)!=1){Eb(151867,1467);v[f+960>>2]=d;Fb(276579,f+960|0);break e}v[f+944>>2]=p;d=f+1152|0;Jb(d,1024,140087,f+944|0);d=Wd(g,i+v[j+56>>2]|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1476);v[f+928>>2]=d;Fb(276579,f+928|0);break e}d=id(g,v[i+v[j+56>>2]>>2]);if((d|0)==1){m=m+2|0;break D}Eb(151867,1477);v[f+912>>2]=d;Fb(276579,f+912|0);break e}F:{if(A[d+1272>>3]<=-h){break F}J=sn(a,e)-A[e+8>>3];G:{if(D(sn(a,e))<=1){h=1;q=D(A[e+8>>3]);if(q<=1){break G}h=q;break G}q=D(sn(a,e));h=D(A[e+8>>3]);if(!(q>=h)){break G}h=D(sn(a,e))}d=v[a+4>>2];H:{if(A[d+1296>>3]>=D(J/h)){q=-A[o+128>>3];h=q;if(!v[o+136>>2]){break H}h=((k|0)!=(n|0)?B*+(n-v[e+220>>2]|0)+1:1)*q;break H}if(v[o+64>>2]){break F}h=0}v[f+896>>2]=p;d=f+1152|0;Jb(d,1024,139456,f+896|0);d=Wd(g,i+v[j+52>>2]|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1507);v[f+880>>2]=d;Fb(276579,f+880|0);break e}d=id(g,v[i+v[j+52>>2]>>2]);if((d|0)!=1){break B}m=m+1|0;d=v[a+4>>2]}if(A[r>>3]>=A[d+1272>>3]){break D}J=sn(a,e)-A[e+16>>3];I:{if(D(sn(a,e))<=1){h=1;q=D(A[e+16>>3]);if(q<=1){break I}h=q;break I}q=D(sn(a,e));h=D(A[e+16>>3]);if(!(q>=h)){break I}h=D(sn(a,e))}J:{if(A[v[a+4>>2]+1296>>3]>=D(J/h)){q=-A[o+128>>3];h=q;if(!v[o+136>>2]){break J}h=((k|0)!=(n|0)?B*+(n-v[e+220>>2]|0)+1:1)*q;break J}if(v[o+64>>2]){break D}h=0}v[f+848>>2]=p;d=f+1152|0;Jb(d,1024,139448,f+848|0);d=Wd(g,i+v[j+56>>2]|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1537);v[f+832>>2]=d;Fb(276579,f+832|0);break e}d=id(g,v[i+v[j+56>>2]>>2]);if((d|0)!=1){break A}m=m+1|0}p=p+1|0;if((p|0)<v[f+1144>>2]){continue}break}}v[j+8>>2]=v[j+8>>2]+m;d=v[o+180>>2];if(d|v[o+184>>2]){e=0;i=v[j+12>>2]<<2;v[i+v[j+52>>2]>>2]=0;v[i+v[j+56>>2]>>2]=0;h=-A[o+128>>3];if(v[o+136>>2]){d=Bi(a);if((k|0)!=(n|0)){q=-.99/+(n-k|0)*+(n-d|0)+1}else{q=1}h=q*h;d=v[o+180>>2]}K:{if(!d|A[z+(v[j+12>>2]<<3)>>3]>=A[v[a+4>>2]+1272>>3]){break K}d=f+1152|0;Jb(d,1024,160713,0);e=1;d=Wd(g,v[j+56>>2]+(v[j+12>>2]<<2)|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1571);v[f+800>>2]=d;Fb(276579,f+800|0);break e}d=id(g,v[v[j+56>>2]+(v[j+12>>2]<<2)>>2]);if((d|0)==1){break K}Eb(151867,1572);v[f+784>>2]=d;Fb(276579,f+784|0);break e}if(!(!v[o+184>>2]|A[v[a+4>>2]+1272>>3]<=-A[E+(v[j+12>>2]<<3)>>3])){d=f+1152|0;Jb(d,1024,160909,0);d=Wd(g,v[j+52>>2]+(v[j+12>>2]<<2)|0,d,0,l,h,3,1,0);if((d|0)!=1){Eb(151867,1585);v[f+768>>2]=d;Fb(276579,f+768|0);break e}d=id(g,v[v[j+52>>2]+(v[j+12>>2]<<2)>>2]);if((d|0)!=1){Eb(151867,1586);v[f+752>>2]=d;Fb(276579,f+752|0);break e}e=e+1|0}v[j+8>>2]=e+v[j+8>>2]}L:{if(v[f+1148>>2]<=0){m=0;r=0;break L}r=0;m=0;e=0;while(1){i=e<<2;v[i+v[j+60>>2]>>2]=0;v[i+v[j+24>>2]>>2]=0;v[i+v[j+32>>2]>>2]=0;M:{if(v[i+v[j+40>>2]>>2]){break M}h=0;h=v[o+120>>2]?h:A[L+(e<<3)>>3];v[f+736>>2]=e;d=f+1152|0;Jb(d,1024,140055,f+736|0);q=A[o+56>>3];d=Wd(g,i+v[j+24>>2]|0,d,-q,q,h,1,1,0);if((d|0)!=1){Eb(151867,1619);v[f+720>>2]=d;Fb(276579,f+720|0);break e}d=id(g,v[i+v[j+24>>2]>>2]);if((d|0)!=1){Eb(151867,1620);v[f+704>>2]=d;Fb(276579,f+704|0);break e}v[f+688>>2]=e;d=f+1152|0;Jb(d,1024,139790,f+688|0);N:{h=A[v[a+4>>2]+1272>>3];k=e<<3;if(!(!(h<=-A[k+M>>3])|!(h<=A[k+u>>3]))){d=Wd(g,i+v[j+32>>2]|0,d,0,0,0,3,1,0);if((d|0)==1){break N}Eb(151867,1629);v[f+672>>2]=d;Fb(276579,f+672|0);break e}d=Wd(g,i+v[j+32>>2]|0,f+1152|0,0,.999,0,3,1,0);if((d|0)==1){break N}Eb(151867,1635);v[f+656>>2]=d;Fb(276579,f+656|0);break e}d=id(g,v[i+v[j+32>>2]>>2]);if((d|0)!=1){Eb(151867,1637);v[f+640>>2]=d;Fb(276579,f+640|0);break e}r=r+2|0;if(A[k+u>>3]>=A[v[a+4>>2]+1272>>3]){break M}v[f+624>>2]=e;d=f+1152|0;Jb(d,1024,140014,f+624|0);d=Wd(g,i+v[j+60>>2]|0,d,0,l,0,3,1,0);if((d|0)!=1){Eb(151867,1645);v[f+608>>2]=d;Fb(276579,f+608|0);break e}d=id(g,v[i+v[j+60>>2]>>2]);if((d|0)!=1){break z}m=m+1|0}e=e+1|0;if((e|0)<v[f+1148>>2]){continue}break}}d=j+28|0;h=A[o+56>>3];l=-h;O:{if(v[o+120>>2]){d=Wd(g,d,161171,l,h,0,1,1,0);if((d|0)==1){break O}Eb(151867,1658);v[f+576>>2]=d;Fb(276579,f+576|0);break e}d=Wd(g,d,161171,l,h,-1,1,1,0);if((d|0)==1){break O}Eb(151867,1663);v[f+560>>2]=d;Fb(276579,f+560|0);break e}d=id(g,v[j+28>>2]);if((d|0)!=1){Eb(151867,1665);v[f+544>>2]=d;Fb(276579,f+544|0);break e}d=Wd(g,j+36|0,161146,0,.99,0,3,1,0);if((d|0)!=1){Eb(151867,1669);v[f+528>>2]=d;Fb(276579,f+528|0);break e}d=id(g,v[j+36>>2]);if((d|0)!=1){Eb(151867,1670);v[f+512>>2]=d;Fb(276579,f+512|0);break e}v[j+8>>2]=(v[j+8>>2]+(m+r|0)|0)+2;n=Ib(v[v[a>>2]+8>>2],v[j+8>>2],8,151833,1674);v[f+2180>>2]=n;if(!n){Eb(151867,1674);d=-1;v[f+208>>2]=-1;Fb(276579,f+208|0);break e}r=Ib(v[v[a>>2]+8>>2],v[j+8>>2],4,151833,1675);v[f+2184>>2]=r;P:{Q:{if(r){m=0;e=v[f+1148>>2];if((e|0)>0){break Q}C=0;break P}Eb(151867,1675);d=-1;v[f+224>>2]=-1;Fb(276579,f+224|0);break e}C=0;k=0;while(1){R:{S:{T:{U:{i=k<<2;switch(v[i+v[j+40>>2]>>2]){case 1:case 2:break T;case 0:break U;default:break R}}h=v[i+v[j+44>>2]>>2]?-1:1;d=v[i+v[f+2204>>2]>>2];V:{if(v[d+216>>2]<=0){e=0;break V}n=v[d+172>>2];p=v[d+168>>2];l=-h;e=0;d=0;while(1){u=v[p+(d<<2)>>2];s=v[u+272>>2];W:{if(s&4096|(v[o+80>>2]?0:s&2048)){break W}u=v[u+232>>2]<<2;s=v[u+v[j+52>>2]>>2];if(s){v[(e<<2)+r>>2]=s;A[v[f+2180>>2]+(e<<3)>>3]=A[n+(d<<3)>>3]*l;e=e+1|0}u=v[u+v[j+56>>2]>>2];if(!u){break W}v[(e<<2)+r>>2]=u;A[v[f+2180>>2]+(e<<3)>>3]=h*A[n+(d<<3)>>3];e=e+1|0}d=d+1|0;if((d|0)<v[v[i+v[f+2204>>2]>>2]+216>>2]){continue}break}}d=v[i+v[j+60>>2]>>2];if(d){v[(e<<2)+r>>2]=d;d=v[f+2180>>2]+(e<<3)|0;v[d>>2]=0;v[d+4>>2]=1072693248;r=v[f+2184>>2];e=e+1|0}v[(e<<2)+r>>2]=v[i+v[j+24>>2]>>2];n=v[f+2180>>2];d=n+(e<<3)|0;v[d>>2]=0;v[d+4>>2]=-1074790400;r=v[f+2184>>2];d=e+1|0;v[r+(d<<2)>>2]=v[i+v[j+32>>2]>>2];d=(d<<3)+n|0;v[d>>2]=0;v[d+4>>2]=-1074790400;d=e+2|0;X:{if(!(v[o+180>>2]|v[o+184>>2])|A[v[a+4>>2]+1280>>3]>=D(A[v[i+v[f+2204>>2]>>2]>>3])){break X}p=v[j+12>>2]<<2;u=v[p+v[j+52>>2]>>2];if(u){v[(d<<2)+r>>2]=u;A[(d<<3)+n>>3]=A[v[i+v[f+2204>>2]>>2]>>3]*-h;d=e+3|0}e=v[p+v[j+56>>2]>>2];if(!e){break X}v[(d<<2)+r>>2]=e;A[(d<<3)+n>>3]=h*A[v[i+v[f+2204>>2]>>2]>>3];d=d+1|0}v[f+432>>2]=k;e=f+1152|0;Jb(e,1024,140055,f+432|0);d=kd(g,f+2176|0,e,d,r,n,0,0,1,1,1,1,1,0,0,0,0,0);if((d|0)!=1){Eb(151867,1776);v[f+416>>2]=d;Fb(276579,f+416|0);break e}d=mc(g,v[f+2176>>2]);if((d|0)!=1){Eb(151867,1777);v[f+400>>2]=d;Fb(276579,f+400|0);break e}d=ec(g,f+2176|0);if((d|0)==1){break S}Eb(151867,1778);v[f+384>>2]=d;Fb(276579,f+384|0);break e}h=v[i+v[j+44>>2]>>2]?-1:1;p=v[i+v[f+2204>>2]>>2];Y:{if(v[p+216>>2]<=0){e=0;break Y}u=v[p+172>>2];s=v[p+168>>2];l=-h;e=0;d=0;while(1){p=v[s+(d<<2)>>2];G=v[p+272>>2];Z:{if(G&4096|(v[o+80>>2]?0:G&2048)){break Z}p=v[p+232>>2]<<2;G=v[p+v[j+52>>2]>>2];if(G){v[(e<<2)+r>>2]=G;n=v[f+2180>>2];A[n+(e<<3)>>3]=A[u+(d<<3)>>3]*l;e=e+1|0}p=v[p+v[j+56>>2]>>2];if(!p){break Z}v[(e<<2)+r>>2]=p;n=v[f+2180>>2];A[n+(e<<3)>>3]=h*A[u+(d<<3)>>3];e=e+1|0}d=d+1|0;p=v[i+v[f+2204>>2]>>2];if((d|0)<v[p+216>>2]){continue}break}}_:{if(!(v[o+180>>2]|v[o+184>>2])|A[v[a+4>>2]+1280>>3]>=D(A[p>>3])){break _}d=v[j+12>>2]<<2;p=v[d+v[j+52>>2]>>2];if(p){v[(e<<2)+r>>2]=p;n=v[f+2180>>2];A[n+(e<<3)>>3]=A[v[i+v[f+2204>>2]>>2]>>3]*-h;e=e+1|0}d=v[d+v[j+56>>2]>>2];if(!d){break _}v[v[f+2184>>2]+(e<<2)>>2]=d;A[(e<<3)+n>>3]=h*A[v[i+v[f+2204>>2]>>2]>>3];e=e+1|0}v[f+496>>2]=k;Jb(f+1152|0,1024,139375,f+496|0);h=A[v[g+4>>2]+1272>>3];r=v[f+2184>>2];l=A[v[a+4>>2]+1272>>3];d=k<<3;d=kd(g,f+2176|0,f+1152|0,e,r,n,0,!(l<=-A[d+v[f+2196>>2]>>3])|!(l<=A[d+v[f+2192>>2]>>3])?h:0,1,1,1,1,1,0,0,0,0,0);if((d|0)!=1){Eb(151867,1861);v[f+480>>2]=d;Fb(276579,f+480|0);break e}d=mc(g,v[f+2176>>2]);if((d|0)!=1){Eb(151867,1862);v[f+464>>2]=d;Fb(276579,f+464|0);break e}d=ec(g,f+2176|0);if((d|0)!=1){break y}}C=C+1|0}e=v[f+1148>>2];k=k+1|0;if((e|0)>(k|0)){continue}break}}v[j+4>>2]=v[j+4>>2]+C;k=v[f+1144>>2];if((k|0)>0){d=0;while(1){i=d<<2;r=v[v[i+v[f+2200>>2]>>2]+272>>2];$:{if(r&4096|(v[o+80>>2]?0:r&2048)){break $}r=v[i+v[j+52>>2]>>2];aa:{if(!r){break aa}h=A[E+(d<<3)>>3];if(A[v[a+4>>2]+1280>>3]>=D(h)){break aa}v[v[f+2184>>2]+(m<<2)>>2]=r;A[(m<<3)+n>>3]=-h;m=m+1|0}i=v[i+v[j+56>>2]>>2];if(!i){break $}h=A[z+(d<<3)>>3];if(A[v[a+4>>2]+1280>>3]>=D(h)){break $}v[v[f+2184>>2]+(m<<2)>>2]=i;A[(m<<3)+n>>3]=h;m=m+1|0}d=d+1|0;if((k|0)!=(d|0)){continue}break}}ba:{if(!(v[o+180>>2]|v[o+184>>2])){break ba}d=v[j+12>>2];i=d<<2;k=v[i+v[j+52>>2]>>2];ca:{if(!k){break ca}h=A[E+(d<<3)>>3];if(A[v[a+4>>2]+1280>>3]>=D(h)){break ca}v[v[f+2184>>2]+(m<<2)>>2]=k;A[(m<<3)+n>>3]=-h;m=m+1|0}i=v[i+v[j+56>>2]>>2];if(!i){break ba}h=A[z+(d<<3)>>3];if(A[v[a+4>>2]+1280>>3]>=D(h)){break ba}v[v[f+2184>>2]+(m<<2)>>2]=i;A[(m<<3)+n>>3]=h;m=m+1|0}if((e|0)>0){d=0;while(1){i=v[v[j+60>>2]+(d<<2)>>2];da:{if(!i){break da}h=A[v[f+2192>>2]+(d<<3)>>3];if(A[v[a+4>>2]+1280>>3]>=D(h)){break da}v[v[f+2184>>2]+(m<<2)>>2]=i;A[(m<<3)+n>>3]=h;m=m+1|0}d=d+1|0;if((e|0)!=(d|0)){continue}break}}d=v[f+2184>>2];v[d+(m<<2)>>2]=v[j+28>>2];e=(m<<3)+n|0;v[e>>2]=0;v[e+4>>2]=-1074790400;e=m+1|0;v[d+(e<<2)>>2]=v[j+36>>2];e=(e<<3)+n|0;v[e>>2]=0;v[e+4>>2]=-1074790400;d=kd(g,f+2176|0,161171,m+2|0,d,n,0,0,1,1,1,1,1,0,0,0,0,0);if((d|0)!=1){Eb(151867,1952);v[f+368>>2]=d;Fb(276579,f+368|0);break e}d=mc(g,v[f+2176>>2]);if((d|0)!=1){Eb(151867,1953);v[f+352>>2]=d;Fb(276579,f+352|0);break e}d=ec(g,f+2176|0);if((d|0)!=1){Eb(151867,1954);v[f+336>>2]=d;Fb(276579,f+336|0);break e}v[j+4>>2]=v[j+4>>2]+1;ea:{if(!v[o+160>>2]){break ea}k=Yc(a);if(!k){break ea}e=0;p=v[f+1148>>2];if((p|0)>0){d=0;while(1){i=d<<2;if(v[i+v[j+24>>2]>>2]){h=Ob(a,k,v[v[i+v[f+2204>>2]>>2]+164>>2]);v[v[f+2184>>2]+(e<<2)>>2]=v[i+v[j+24>>2]>>2];A[v[f+2180>>2]+(e<<3)>>3]=h;p=v[f+1148>>2];e=e+1|0}d=d+1|0;if((p|0)>(d|0)){continue}break}}d=v[f+2184>>2];v[d+(e<<2)>>2]=v[j+28>>2];i=v[f+2180>>2];k=i+(e<<3)|0;v[k>>2]=0;v[k+4>>2]=-1074790400;d=kd(g,f+2176|0,80813,e+1|0,d,i,-.001,.001,1,1,1,1,1,0,0,0,0,0);if((d|0)!=1){Eb(151867,1985);v[f+320>>2]=d;Fb(276579,f+320|0);break e}d=mc(g,v[f+2176>>2]);if((d|0)!=1){Eb(151867,1986);v[f+304>>2]=d;Fb(276579,f+304|0);break e}d=ec(g,f+2176|0);if((d|0)!=1){Eb(151867,1987);v[f+288>>2]=d;Fb(276579,f+288|0);break e}v[j+4>>2]=v[j+4>>2]+1}if(v[o+168>>2]){e=0;i=v[f+1148>>2];if((i|0)>0){d=0;while(1){k=v[v[j+24>>2]+(d<<2)>>2];if(k){v[v[f+2184>>2]+(e<<2)>>2]=k;A[v[f+2180>>2]+(e<<3)>>3]=A[v[f+2188>>2]+(d<<3)>>3];e=e+1|0}d=d+1|0;if((i|0)!=(d|0)){continue}break}}d=v[f+2184>>2];v[d+(e<<2)>>2]=v[j+28>>2];i=v[f+2180>>2];k=i+(e<<3)|0;v[k>>2]=0;v[k+4>>2]=-1074790400;d=kd(g,f+2176|0,15239,e+1|0,d,i,.05,A[v[g+4>>2]+1272>>3],1,1,1,1,1,0,0,0,0,0);if((d|0)!=1){Eb(151867,2012);v[f+272>>2]=d;Fb(276579,f+272|0);break e}d=mc(g,v[f+2176>>2]);if((d|0)!=1){Eb(151867,2013);v[f+256>>2]=d;Fb(276579,f+256|0);break e}d=ec(g,f+2176|0);if((d|0)!=1){Eb(151867,2014);v[f+240>>2]=d;Fb(276579,f+240|0);break e}v[j+4>>2]=v[j+4>>2]+1}Hb(v[v[a>>2]+8>>2],f+2184|0,151833,2022);Hb(v[v[a>>2]+8>>2],f+2180|0,151833,2023);Hb(v[v[a>>2]+8>>2],f+2188|0,151833,2025);Hb(v[v[a>>2]+8>>2],f+2196|0,151833,2026);Hb(v[v[a>>2]+8>>2],f+2192|0,151833,2027);d=1;break e}Eb(151867,1508);v[f+864>>2]=d;Fb(276579,f+864|0);break e}Eb(151867,1538);v[f+816>>2]=d;Fb(276579,f+816|0);break e}Eb(151867,1646);v[f+592>>2]=d;Fb(276579,f+592|0);break e}Eb(151867,1863);v[f+448>>2]=d;Fb(276579,f+448|0)}ub=f+2208|0;i=d;if((d|0)!=1){Eb(151867,4450);v[x+80>>2]=d;Fb(276579,x+80|0);break a}e=v[j>>2];f=ub-16|0;ub=f;fa:{ga:{if(!(v[o+168>>2]|v[o+172>>2])){k=2066;i=Yi(e,.05);if((i|0)!=1){break ga}}k=2070;i=Rc(e,140470,0);if((i|0)!=1){break ga}k=2075;i=Xe(e,143764,1);if((i|0)!=1){break ga}k=2078;i=qc(e,89750,1e3);if((i|0)!=1){break ga}ha:{if(v[o+192>>2]){k=2088;i=qc(e,92013,5);if((i|0)!=1){break ga}k=2089;i=qc(e,70575,1e3);if((i|0)!=1){break ga}k=2090;i=qc(e,110341,2);if((i|0)==1){break ha}break ga}k=2094;i=qc(e,92013,0);if((i|0)!=1){break ga}}ia:{if(v[o+188>>2]){k=2104;i=Bh(e);if((i|0)==1){break ia}break ga}if(ed(e,70765)){break ia}k=2112;i=qc(e,70765,-1);if((i|0)!=1){break ga}}if(!ed(e,44217)){k=2124;i=qc(e,44217,1e4);if((i|0)!=1){break ga}}if(!v[o+188>>2]){d=1;break fa}if(!ed(e,71162)){k=2132;i=qc(e,71162,3);if((i|0)!=1){break ga}}if(!ed(e,71187)){k=2136;i=qc(e,71187,1);if((i|0)!=1){break ga}}if(!ed(e,71218)){k=2140;i=qc(e,71218,1);if((i|0)!=1){break ga}}if(!ed(e,70588)){k=2144;i=qc(e,70588,1);if((i|0)!=1){break ga}}d=1;k=2159;i=Uf(e,2,1);if((i|0)!=1){break ga}k=2169;i=Wg(e,2,1);if((i|0)==1){break fa}}Eb(151867,k);v[f>>2]=i;Fb(276579,f);d=i}ub=f+16|0;i=d;if((d|0)!=1){Eb(151867,4453);v[x+64>>2]=d;Fb(276579,x- -64|0);break a}ja:{if(rc(v[a+4>>2],v[a+24>>2],0)){break ja}f=ub-368|0;ub=f;e=1;r=x+148|0;v[r>>2]=1;n=v[j>>2];d=tj(a,r);ka:{if((d|0)!=1){Eb(151867,2466);v[f+336>>2]=d;Fb(276579,f+336|0);e=d;break ka}if(!v[r>>2]){break ka}e=re(a,117257,f+360|0);if((e|0)!=1){Eb(151867,2475);v[f+320>>2]=e;Fb(276579,f+320|0);break ka}la:{h=A[f+360>>3];l=A[o+24>>3];if(h>l){A[f+360>>3]=l;h=l}if(h>=A[v[a+4>>2]+1272>>3]){break la}h=Te(a);h=A[f+360>>3]-h;A[f+360>>3]=h;if(h>0){e=Xe(n,117257,h);if((e|0)==1){break la}Eb(151867,2484);v[f+304>>2]=e;Fb(276579,f+304|0);break ka}v[r>>2]=0;e=1;break ka}e=re(a,3546,f+352|0);if((e|0)!=1){Eb(151867,2495);v[f+288>>2]=e;Fb(276579,f+288|0);break ka}ma:{h=A[f+352>>3];l=A[o+32>>3];if(h>l){A[f+352>>3]=l;h=l}if(h>=A[v[a+4>>2]+1272>>3]){break ma}h=A[f+352>>3];d=v[a>>2];i=v[v[d+12>>2]+12>>2];k=v[v[d+8>>2]+12>>2];m=v[d>>2];d=v[d+4>>2];g=v[d+4096>>2];e=v[m+4096>>2]+g|0;d=v[m+4100>>2]+v[d+4100>>2]|0;d=e>>>0<g>>>0?d+1|0:d;m=e;e=e+k|0;d=m>>>0>e>>>0?d+1|0:d;k=e;e=e+i|0;d=k>>>0>e>>>0?d+1|0:d;A[f+352>>3]=h-(+(e>>>0)+ +(d|0)*4294967296)*9.5367431640625e-7;d=v[a+24>>2];h=A[f+352>>3]-(+y[d+512>>2]+ +v[d+516>>2]*4294967296)*9.5367431640625e-7;A[f+352>>3]=h;if(h>0){e=Xe(n,3546,h);if((e|0)==1){break ma}Eb(151867,2506);v[f+272>>2]=e;Fb(276579,f+272|0);break ka}e=1;v[r>>2]=1;break ka}d=-1;g=2147483647;e=v[o+40>>2];i=v[o+44>>2];k=i;na:{if((i|0)<0){break na}i=v[o+48>>2];m=v[o+52>>2];if((m|0)<0){break na}p=i;s=e;g=v[a+24>>2];d=v[g+8>>2];u=d;z=d>>>0<e>>>0;e=v[g+12>>2];d=e;g=z&(k|0)>=(d|0)|(d|0)<(k|0);d=g?s:u;s=d;i=d>>>0>i>>>0;e=g?k:e;d=e;i=i&(m|0)<=(d|0)|(d|0)>(m|0);d=i?p:s;g=i?m:e}e=_d(n,56040,d,g);if((e|0)!=1){Eb(151867,2527);v[f+256>>2]=e;Fb(276579,f+256|0);break ka}oa:{if(!v[o+196>>2]){break oa}e=Ui(n);if((e|0)!=1){Eb(151867,2532);v[f+240>>2]=e;Fb(276579,f+240|0);break ka}i=0;g=ub-160|0;ub=g;k=gd(a,g+156|0,g+132|0,0,0,0,0);pa:{if((k|0)!=1){Eb(151867,2218);v[g+112>>2]=k;Fb(276579,g+112|0);break pa}k=ug(a,g+152|0,g+128|0);if((k|0)!=1){Eb(151867,2221);v[g+96>>2]=k;Fb(276579,g+96|0);break pa}k=xl(a,g+148|0,g+124|0);if((k|0)!=1){Eb(151867,2222);v[g+80>>2]=k;Fb(276579,g+80|0);break pa}E=Ib(v[v[a>>2]+8>>2],v[g+128>>2],4,151833,2226);v[g+136>>2]=E;if(!E){Eb(151867,2226);k=-1;v[g>>2]=-1;Fb(276579,g);break pa}u=Ib(v[v[a>>2]+8>>2],v[g+128>>2],8,151833,2227);v[g+144>>2]=u;if(!u){Eb(151867,2227);k=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);break pa}d=Ib(v[v[a>>2]+8>>2],v[g+124>>2],8,151833,2228);v[g+140>>2]=d;if(!d){Eb(151867,2228);k=-1;v[g+32>>2]=-1;Fb(276579,g+32|0);break pa}k=NF(a,E);if((k|0)==1){if(v[g+128>>2]>0){while(1){qa:{d=v[E+(i<<2)>>2];ra:{if((d|0)>=0){d=v[v[g+148>>2]+(d<<2)>>2];if((v[v[d+164>>2]+376>>2]&192)==192){break qa}h=v[d+224>>2]<0?0:A[d+72>>3];h=h-H(h+A[v[a+4>>2]+1296>>3]);if(!(h>=.005)){break qa}if(h<=.995){break ra}break qa}d=v[v[g+152>>2]+((d^-1)<<2)>>2];if((v[d+272>>2]&5120)!=1024){break qa}h=A[d+16>>3];if(h>=A[v[a+4>>2]+1272>>3]){h=A[d+8>>3]}h=h-sn(a,d);h=h-H(h+A[v[a+4>>2]+1296>>3]);if(!(h>=.005)|!(h<=.995)){break qa}}k=Xz(a,i,u,0,0);d=2294;sa:{if((k|0)!=1){break sa}p=v[g+140>>2];dc(p,v[g+124>>2]<<3);k=Ed(v[j>>2],g+116|0,0);d=2300;if((k|0)!=1){break sa}z=0;l=0;e=v[g+128>>2];if((e|0)>0){while(1){G=z<<3;h=A[G+u>>3];d=v[a+4>>2];B=A[d+1280>>3];J=h-H(h+B);h=D(J);if(!(h<=A[d+1296>>3])){k=z<<2;e=v[k+v[g+152>>2]>>2];q=A[e+16>>3];ta:{ua:{va:{wa:{if(!(B>=D(A[e+8>>3]-q))){switch(v[e+272>>2]>>>1&3){case 0:break ua;case 2:break va;default:break wa}}if(!(J<0)){break va}break ua}if(q>=A[d+1272>>3]){break ua}}k=Wc(v[j>>2],v[g+116>>2],v[k+v[j+56>>2]>>2],h);d=68;if((k|0)==1){break ta}d=2359;break sa}k=Wc(v[j>>2],v[g+116>>2],v[k+v[j+52>>2]>>2],h);d=2353;if((k|0)!=1){break sa}h=-h;d=64}C=v[e+220>>2];xa:{if((C|0)<=0){break xa}s=v[e+188>>2];e=v[e+180>>2];k=0;if((C|0)!=1){M=C&2147483646;m=0;while(1){L=p+(v[v[e+(k<<2)>>2]+224>>2]<<3)|0;A[L>>3]=h*A[s+(k<<3)>>3]+A[L>>3];L=k|1;O=p+(v[v[e+(L<<2)>>2]+224>>2]<<3)|0;A[O>>3]=h*A[s+(L<<3)>>3]+A[O>>3];k=k+2|0;m=m+2|0;if((M|0)!=(m|0)){continue}break}}if(!(C&1)){break xa}e=p+(v[v[e+(k<<2)>>2]+224>>2]<<3)|0;A[e>>3]=h*A[s+(k<<3)>>3]+A[e>>3]}l=h*A[G+v[d+j>>2]>>3]+l;e=v[g+128>>2]}z=z+1|0;if((z|0)<(e|0)){continue}break}}e=0;if(v[g+124>>2]>0){while(1){ya:{m=e<<2;if(v[m+v[j+40>>2]>>2]){break ya}z=p+(e<<3)|0;d=v[a+4>>2];q=H(A[z>>3]+A[d+1280>>3]);h=A[d+1296>>3];if(!(h>=D(q))){k=Wc(v[j>>2],v[g+116>>2],v[m+v[j+24>>2]>>2],v[m+v[j+44>>2]>>2]?-q:q);d=2406;if((k|0)!=1){break sa}h=A[v[a+4>>2]+1296>>3]}B=h;q=A[z>>3];h=q-H(q+h);if(B>=D(h)){break ya}k=Wc(v[j>>2],v[g+116>>2],v[m+v[j+32>>2]>>2],h);if((k|0)==1){break ya}d=2411;break sa}e=e+1|0;if((e|0)<v[g+124>>2]){continue}break}}d=v[a+4>>2];q=H(l+A[d+1280>>3]);h=A[d+1296>>3];if(!(h>=D(q))){k=Wc(v[j>>2],v[g+116>>2],v[j+28>>2],q);d=2417;if((k|0)!=1){break sa}h=A[v[a+4>>2]+1296>>3]}za:{q=h;h=l-H(l+h);if(q>=D(h)){break za}k=Wc(v[j>>2],v[g+116>>2],v[j+36>>2],h);if((k|0)==1){break za}d=2421;break sa}k=Tg(v[j>>2],g+116|0,0,0,1,1,1,g+120|0);if((k|0)==1){break qa}d=2424}Eb(151867,d);v[g+48>>2]=k;Fb(276579,g+48|0);break pa}i=i+1|0;if((i|0)<v[g+128>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],g+140|0,151833,2431);Hb(v[v[a>>2]+8>>2],g+144|0,151833,2432);Hb(v[v[a>>2]+8>>2],g+136|0,151833,2433);k=1;break pa}Eb(151867,2231);v[g+64>>2]=k;Fb(276579,g- -64|0)}ub=g+160|0;e=k;if((e|0)==1){break oa}Eb(151867,2533);v[f+224>>2]=e;Fb(276579,f+224|0);break ka}Aa:{if(v[o+192>>2]){break Aa}e=Rc(n,103062,0);if((e|0)==1){break Aa}Eb(151867,2541);v[f+208>>2]=e;Fb(276579,f+208|0);break ka}Ba:{Ca:{if(!v[o+164>>2]){e=1;d=Me(n);if((d|0)!=1){v[f+32>>2]=d;jc(a,315552,f+32|0);v[r>>2]=0;break ka}i=0;d=v[v[n+4>>2]>>2];i=!d|(d|0)==13?i:v[v[n+24>>2]+896>>2];Da:{if(!v[o+192>>2]){break Da}d=Kt(n,0);if((d|0)==1){break Da}Eb(151867,2570);v[f+16>>2]=d;Fb(276579,f+16|0);e=d;break ka}if((i&-3)==12){v[r>>2]=0;break ka}Ea:{switch(i-1|0){case 4:v[r>>2]=0;break ka;case 0:v[r>>2]=0;break ka;case 1:case 10:break ka;default:break Ea}}Eb(151867,2601);v[f>>2]=i;Fb(343521,f);break Ca}e=qc(n,89901,1);if((e|0)!=1){Eb(151867,2610);v[f+192>>2]=e;Fb(276579,f+192|0);break ka}d=Me(n);e=qc(n,89901,-1);if((e|0)!=1){Eb(151867,2612);v[f+176>>2]=e;Fb(276579,f+176|0);break ka}e=1;if((d|0)!=1){v[f+160>>2]=d;jc(a,315552,f+160|0);v[r>>2]=0;break ka}i=0;d=v[v[n+4>>2]>>2];i=!d|(d|0)==13?i:v[v[n+24>>2]+896>>2];if(!(i>>>0>14|!(1<<i&20582))){Fa:{if(!v[o+192>>2]){break Fa}e=Kt(n,0);if((e|0)==1){break Fa}Eb(151867,2638);v[f+144>>2]=e;Fb(276579,f+144|0);break ka}v[r>>2]=0;e=1;break ka}if((i&-3)!=9){Eb(151867,2648);v[f+128>>2]=i;Fb(343521,f+128|0);break Ca}if((i|0)!=9){break ka}e=_d(n,55503,1e3,0);if((e|0)!=1){Eb(151867,2658);v[f+112>>2]=e;Fb(276579,f+112|0);break ka}d=Me(n);e=_d(n,55503,-1,-1);if((e|0)!=1){Eb(151867,2660);v[f+96>>2]=e;Fb(276579,f+96|0);break ka}e=1;if((d|0)!=1){v[f+80>>2]=d;jc(a,315552,f+80|0);v[r>>2]=0;break ka}i=0;d=v[v[n+4>>2]>>2];i=!d|(d|0)==13?i:v[v[n+24>>2]+896>>2];Ga:{if(!v[o+192>>2]){break Ga}d=Kt(n,0);if((d|0)==1){break Ga}Eb(151867,2685);v[f+64>>2]=d;Fb(276579,f- -64|0);e=d;break ka}if(i>>>0<=11){d=1<<i;if(d&98){break Ba}if(d&2068){break ka}}Eb(151867,2699);v[f+48>>2]=i;Fb(343521,f+48|0)}e=0;break ka}v[r>>2]=0}ub=f+368|0;i=e;if((e|0)!=1){Eb(151867,4458);v[x+48>>2]=e;Fb(276579,x+48|0);break a}if(!v[x+148>>2]){break ja}if(rc(v[a+4>>2],v[a+24>>2],0)){break ja}g=ub-1536|0;ub=g;v[g+448>>2]=0;d=v[j>>2];E=x+144|0;v[E>>2]=0;v[x+152>>2]=0;e=1;Ha:{if(v[v[d+4>>2]>>2]-9>>>0>1){break Ha}G=Pd(d);if(!G){break Ha}O=Wh(d);e=gd(a,g+420|0,g+408|0,0,0,0,0);if((e|0)!=1){Eb(151867,4061);v[g+400>>2]=e;Fb(276579,g+400|0);break Ha}e=v[j+20>>2];r=Ib(v[v[a>>2]+8>>2],v[g+408>>2],8,151833,4067);v[g+428>>2]=r;if(!r){Eb(151867,4067);e=-1;v[g>>2]=-1;Fb(276579,g);break Ha}d=Ib(v[v[a>>2]+8>>2],v[g+408>>2],8,151833,4068);v[g+444>>2]=d;if(!d){Eb(151867,4068);e=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);break Ha}i=Ib(v[v[a>>2]+8>>2],v[g+408>>2],4,151833,4069);v[g+436>>2]=i;if(!i){Eb(151867,4069);e=-1;v[g+32>>2]=-1;Fb(276579,g+32|0);break Ha}i=Ib(v[v[a>>2]+8>>2],v[g+408>>2],8,151833,4070);v[g+432>>2]=i;if(!i){Eb(151867,4070);e=-1;v[g+48>>2]=-1;Fb(276579,g+48|0);break Ha}e=Ib(v[v[a>>2]+8>>2],e,8,151833,4071);v[g+440>>2]=e;if(!e){Eb(151867,4071);e=-1;v[g+64>>2]=-1;Fb(276579,g- -64|0);break Ha}e=Ib(v[v[a>>2]+8>>2],G<<1,4,151833,4072);v[g+424>>2]=e;if(!e){Eb(151867,4072);e=-1;v[g+80>>2]=-1;Fb(276579,g+80|0);break Ha}Ia:{Ja:{if(!(v[o+144>>2]|v[o+148>>2])){break Ja}e=Jq(a,g+448|0);if((e|0)!=1){Eb(151867,4076);v[g+384>>2]=e;Fb(276579,g+384|0);break Ha}if(!v[o+144>>2]|!v[o+152>>2]){break Ja}e=Ib(v[v[a>>2]+8>>2],v[g+408>>2],4,151833,4082);v[g+416>>2]=e;if(!e){Eb(151867,4082);e=-1;v[g+352>>2]=-1;Fb(276579,g+352|0);break Ha}e=Ib(v[v[a>>2]+8>>2],v[g+408>>2],4,151833,4083);v[g+452>>2]=e;if(e){break Ia}Eb(151867,4083);e=-1;v[g+368>>2]=-1;Fb(276579,g+368|0);break Ha}v[g+452>>2]=0;v[g+416>>2]=0}e=v[g+408>>2];if((e|0)>0){f=v[g+420>>2];i=0;while(1){h=0;k=v[f+(i<<2)>>2];Ka:{if((v[k+376>>2]&1792)!=512){break Ka}k=v[k+176>>2];if(v[k+224>>2]<0){break Ka}h=A[k+72>>3]}A[d+(i<<3)>>3]=h;i=i+1|0;if((e|0)!=(i|0)){continue}break}}v[g+412>>2]=0;La:{if((G|0)<=0){break La}k=0;while(1){n=v[O+(k<<2)>>2];Ma:{if(!v[o+144>>2]){break Ma}z=v[g+424>>2];u=v[g+452>>2];C=v[g+416>>2];s=v[g+440>>2];M=v[g+436>>2];L=v[g+448>>2];v[E>>2]=0;p=v[j>>2];Na:{e=ug(a,g+480|0,g+472|0);if((e|0)!=1){Eb(151867,3537);v[g+336>>2]=e;Fb(276579,g+336|0);break Na}h=A[o+56>>3];Oa:{if(D(h)<0x8000000000000000){d=~~h>>>0;if(D(h)>=1){f=~~(h>0?F(H(h*2.3283064365386963e-10),4294967295):I((h-+(~~h>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break Oa}d=0;f=-2147483648}m=d;Pa:{Qa:{Ra:{Sa:{e=gd(a,g+476|0,g+468|0,0,0,0,0);if((e|0)==1){if(v[g+472>>2]>0){i=0;while(1){d=s+(i<<3)|0;v[d>>2]=0;v[d+4>>2]=0;e=i<<2;P=v[e+v[j+52>>2]>>2];Ta:{if(!P){break Ta}h=Ob(p,n,P);h=h-H(h+A[v[a+4>>2]+1280>>3]);if(!(h>A[v[p+4>>2]+1296>>3])){break Ta}A[d>>3]=-h}e=v[e+v[j+56>>2]>>2];Ua:{if(!e){break Ua}h=Ob(p,n,e);e=v[a+4>>2];q=h-H(h+A[e+1280>>3]);h=A[d>>3];B=q-(h>=0?h:-h);l=D(h);h=D(q);Va:{Wa:{if(h<=1){h=1;if(!(l<=1)){break Wa}break Va}if(h>=l){break Va}}h=l}if(!(A[e+1296>>3]<B/h)){break Ua}A[d>>3]=q}i=i+1|0;if((i|0)<v[g+472>>2]){continue}break}}i=v[o+80>>2];e=v[g+468>>2];if(!(!v[o+152>>2]|(e|0)<=0)){P=i?-2:-1;i=0;while(1){d=i<<2;e=v[v[v[d+v[g+476>>2]>>2]+176>>2]+224>>2];Xa:{if((e|0)<0){break Xa}v[d+C>>2]=P;N=d+u|0;v[N>>2]=0;d=e<<2;if(v[d+v[j+40>>2]>>2]-1>>>0<2){break Xa}Ya:{Za:{e=v[d+v[j+60>>2]>>2];if(!e){e=v[j+44>>2];break Za}h=Ob(p,n,e);e=v[j+44>>2];if(!(A[v[p+4>>2]+1288>>3]<h)){break Za}if(v[d+e>>2]){break Xa}break Ya}if(!v[d+e>>2]){break Xa}}v[N>>2]=1}e=v[g+468>>2];i=i+1|0;if((e|0)>(i|0)){continue}break}i=v[o+80>>2]}v[g+496>>2]=0;v[g+500>>2]=-1074790400;v[g+488>>2]=0;v[g+492>>2]=-1074790400;e=gB(a,L,s,0,-1,0,i,2,e,g+484|0);if((e|0)!=1){Eb(151867,3644);v[g+304>>2]=e;Fb(276579,g+304|0);break Na}if(!v[g+484>>2]){break Ma}e=eB(a,0,.9999,v[o+80>>2],0,C,u,9e-4,.9991,1,L,r,g+496|0,M,g+460|0,g+488|0,g+464|0,g+508|0,g+484|0);if((e|0)!=1){Eb(151867,3651);v[g+288>>2]=e;Fb(276579,g+288|0);break Na}if(!v[g+484>>2]|!(v[g+508>>2]|!v[o+156>>2]?A[g+488>>3]>A[v[a+4>>2]+(v[v[a+72>>2]+160>>2]==1?1664:1656)>>3]:1)){break Ma}d=v[a+24>>2];e=v[d+936>>2];d=v[d+940>>2];v[g+280>>2]=v[x+152>>2];v[g+272>>2]=e;v[g+276>>2]=d;d=g+512|0;Jb(d,1024,7631,g+272|0);e=rj(a,g+456|0,b,d,-A[v[a+4>>2]+1272>>3],A[g+496>>3],v[g+508>>2],0,v[o+140>>2]);d=3665;if((e|0)!=1){break Qa}d=v[g+456>>2];v[d+272>>2]=v[d+272>>2]|32;i=0;if(v[g+460>>2]>0){break Sa}break Ra}Eb(151867,3546);v[g+320>>2]=e;Fb(276579,g+320|0);break Na}while(1){e=Xc(a,v[g+456>>2],v[v[g+476>>2]+(v[M+(i<<2)>>2]<<2)>>2],A[r+(i<<3)>>3]);if((e|0)==1){i=i+1|0;if((i|0)<v[g+460>>2]){continue}break Ra}break}d=3671;break Qa}d=v[g+456>>2];v[d+268>>2]=v[g+464>>2];if(v[o+192>>2]){e=Wz(a,d);d=3684;if((e|0)!=1){break Qa}d=v[g+456>>2]}e=v[a+4>>2];h=-A[e+1280>>3];l=A[e+1288>>3];e=m+1|0;f=e?f:f+1|0;e=pO(a,d,h,l,e,f,1e4,g+484|0);d=3690;if((e|0)!=1){break Qa}if(v[g+484>>2]){e=fg(a,v[g+456>>2]);d=3695;if((e|0)!=1){break Qa}_a:{if(v[g+508>>2]){break _a}e=Hj(a,v[g+456>>2]);if((e|0)==1){break _a}d=3701;break Qa}$a:{ab:{bb:{if(sj(a,0,v[g+456>>2])){i=0;e=v[g+412>>2];if((e|0)<=0){break bb}while(1){d=z+(i<<2)|0;l=D(gx(v[g+456>>2],v[d>>2])+-1);h=A[v[a+4>>2]+1280>>3];if(l<=h&-h<=A[g+496>>3]-A[v[d>>2]+16>>3]){break bb}i=i+1|0;if((e|0)!=(i|0)){continue}break}break ab}e=jd(a,g+456|0);if((e|0)==1){break Ma}d=3711;break Qa}if((e|0)>(i|0)){break $a}}d=v[g+456>>2];v[z+(e<<2)>>2]=d;v[g+412>>2]=e+1;if(v[o+192>>2]){e=Wz(a,d);d=3743;if((e|0)!=1){break Qa}d=v[g+456>>2]}e=Cd(a,d,0,E);if((e|0)==1){break Pa}d=3746;break Qa}e=jd(a,g+456|0);if((e|0)==1){break Ma}d=3753;break Qa}e=jd(a,g+456|0);if((e|0)==1){break Ma}d=3763}Eb(151867,d);v[g+256>>2]=e;Fb(276579,g+256|0);break Na}v[x+152>>2]=v[x+152>>2]+1;break Ma}Eb(151867,4111);v[g+240>>2]=e;Fb(276579,g+240|0);break Ha}cb:{if(!v[o+148>>2]){break cb}z=v[g+424>>2];u=v[g+440>>2];C=v[g+436>>2];s=v[g+448>>2];v[E>>2]=0;p=v[j>>2];db:{e=ug(a,g+480|0,g+472|0);if((e|0)!=1){Eb(151867,3825);v[g+224>>2]=e;Fb(276579,g+224|0);break db}h=A[o+56>>3];eb:{if(D(h)<0x8000000000000000){d=~~h>>>0;if(D(h)>=1){f=~~(h>0?F(H(h*2.3283064365386963e-10),4294967295):I((h-+(~~h>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break eb}d=0;f=-2147483648}m=d;fb:{gb:{hb:{ib:{e=gd(a,g+476|0,g+468|0,0,0,0,0);if((e|0)==1){if(v[g+472>>2]>0){i=0;while(1){d=u+(i<<3)|0;v[d>>2]=0;v[d+4>>2]=0;e=i<<2;M=v[e+v[j+52>>2]>>2];jb:{if(!M){break jb}h=Ob(p,n,M);h=h-H(h+A[v[a+4>>2]+1280>>3]);if(!(h>A[v[p+4>>2]+1296>>3])){break jb}A[d>>3]=-h}e=v[e+v[j+56>>2]>>2];kb:{if(!e){break kb}h=Ob(p,n,e);e=v[a+4>>2];q=h-H(h+A[e+1280>>3]);h=A[d>>3];B=q-(h>=0?h:-h);l=D(h);h=D(q);lb:{mb:{if(h<=1){h=1;if(!(l<=1)){break mb}break lb}if(h>=l){break lb}}h=l}if(!(A[e+1296>>3]<B/h)){break kb}A[d>>3]=q}i=i+1|0;if((i|0)<v[g+472>>2]){continue}break}}v[g+496>>2]=0;v[g+500>>2]=-1074790400;v[g+488>>2]=0;v[g+492>>2]=-1074790400;e=gB(a,s,u,0,-1,0,v[o+80>>2],1,v[g+468>>2],g+484|0);if((e|0)!=1){Eb(151867,3876);v[g+192>>2]=e;Fb(276579,g+192|0);break db}if(!v[g+484>>2]){break cb}e=xba(a,v[o+80>>2],9e-4,.9991,s,r,g+496|0,C,g+460|0,g+488|0,g+464|0,g+508|0,g+484|0);if((e|0)!=1){Eb(151867,3882);v[g+176>>2]=e;Fb(276579,g+176|0);break db}if(!v[g+484>>2]|!(v[g+508>>2]|!v[o+156>>2]?A[g+488>>3]>A[v[a+4>>2]+(v[v[a+72>>2]+160>>2]==1?1664:1656)>>3]:1)){break cb}d=v[a+24>>2];e=v[d+936>>2];d=v[d+940>>2];v[g+168>>2]=v[x+152>>2];v[g+160>>2]=e;v[g+164>>2]=d;d=g+512|0;Jb(d,1024,7631,g+160|0);e=rj(a,g+456|0,b,d,-A[v[a+4>>2]+1272>>3],A[g+496>>3],v[g+508>>2],0,v[o+140>>2]);d=3896;if((e|0)!=1){break gb}d=v[g+456>>2];v[d+272>>2]=v[d+272>>2]|32;i=0;if(v[g+460>>2]>0){break ib}break hb}Eb(151867,3834);v[g+208>>2]=e;Fb(276579,g+208|0);break db}while(1){e=Xc(a,v[g+456>>2],v[v[g+476>>2]+(v[C+(i<<2)>>2]<<2)>>2],A[r+(i<<3)>>3]);if((e|0)==1){i=i+1|0;if((i|0)<v[g+460>>2]){continue}break hb}break}d=3902;break gb}d=v[g+456>>2];v[d+268>>2]=v[g+464>>2];if(v[o+192>>2]){e=Wz(a,d);d=3915;if((e|0)!=1){break gb}d=v[g+456>>2]}e=d;d=v[a+4>>2];h=-A[d+1280>>3];l=A[d+1288>>3];d=f;f=m+1|0;d=f?d:d+1|0;e=pO(a,e,h,l,f,d,1e4,g+484|0);d=3921;if((e|0)!=1){break gb}if(v[g+484>>2]){e=fg(a,v[g+456>>2]);d=3926;if((e|0)!=1){break gb}nb:{if(v[g+508>>2]){break nb}e=Hj(a,v[g+456>>2]);if((e|0)==1){break nb}d=3932;break gb}ob:{pb:{qb:{if(sj(a,0,v[g+456>>2])){i=0;e=v[g+412>>2];if((e|0)<=0){break qb}while(1){d=z+(i<<2)|0;l=D(gx(v[g+456>>2],v[d>>2])+-1);h=A[v[a+4>>2]+1280>>3];if(l<=h&-h<=A[g+496>>3]-A[v[d>>2]+16>>3]){break qb}i=i+1|0;if((e|0)!=(i|0)){continue}break}break pb}e=jd(a,g+456|0);if((e|0)==1){break cb}d=3942;break gb}if((e|0)>(i|0)){break ob}}d=v[g+456>>2];v[z+(e<<2)>>2]=d;v[g+412>>2]=e+1;if(v[o+192>>2]){e=Wz(a,d);d=3974;if((e|0)!=1){break gb}d=v[g+456>>2]}e=Cd(a,d,0,E);if((e|0)==1){break fb}d=3977;break gb}e=jd(a,g+456|0);if((e|0)==1){break cb}d=3984;break gb}e=jd(a,g+456|0);if((e|0)==1){break cb}d=3994}Eb(151867,d);v[g+144>>2]=e;Fb(276579,g+144|0);break db}v[x+152>>2]=v[x+152>>2]+1;break cb}Eb(151867,4117);v[g+128>>2]=e;Fb(276579,g+128|0);break Ha}rb:{if(v[o+144>>2]|v[o+148>>2]){break rb}u=v[g+436>>2];C=v[g+432>>2];z=v[g+444>>2];M=v[g+424>>2];l=0;m=0;B=0;p=0;e=ub-1168|0;ub=e;v[e+116>>2]=0;i=gd(a,e+120|0,e+112|0,0,0,0,0);sb:{if((i|0)!=1){Eb(151867,3304);v[e+96>>2]=i;Fb(276579,e+96|0);break sb}v[e+140>>2]=0;v[e+128>>2]=0;v[e+132>>2]=0;v[e+136>>2]=0;v[E>>2]=0;v[e+124>>2]=1;i=JH(a,j,o,n,1,r,e+128|0,e+140|0,e+136|0,e+116|0,e+124|0);if((i|0)!=1){Eb(151867,3313);v[e+80>>2]=i;Fb(276579,e+80|0);break sb}if(v[e+124>>2]){d=(v[e+140>>2]|v[e+136>>2])!=0}else{i=1;d=JH(a,j,o,n,0,r,e+128|0,e+140|0,e+136|0,e+116|0,e+124|0);if((d|0)!=1){Eb(151867,3320);v[e+64>>2]=d;Fb(276579,e- -64|0);i=d;break sb}if(!v[e+124>>2]){break sb}d=(v[e+140>>2]|v[e+136>>2])!=0}i=1;f=v[e+112>>2];tb:{if((f|0)<=0){break tb}L=f&3;ub:{if(f>>>0<4){n=0;break ub}P=f&2147483644;n=0;while(1){s=n<<3;N=s|24;h=A[N+r>>3]*A[z+N>>3];N=s|16;q=A[N+r>>3]*A[z+N>>3];N=s|8;l=h+(q+(A[N+r>>3]*A[z+N>>3]+(A[r+s>>3]*A[s+z>>3]+l)));n=n+4|0;p=p+4|0;if((P|0)!=(p|0)){continue}break}}if(!L){break tb}while(1){p=n<<3;l=A[p+r>>3]*A[p+z>>3]+l;n=n+1|0;m=m+1|0;if((L|0)!=(m|0)){continue}break}}q=A[e+128>>3];h=D(q);p=v[a+4>>2];J=l-q;l=D(l);if(!(A[p+1296>>3]<J/(l<=1?h<=1?1:h:h<=l?l:h))){break sb}vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{m=w[j+72|0];switch(m-100|0){case 1:break zb;case 9:break Ab;case 15:break Bb;case 0:break Cb;default:break xb}}if((f|0)>0){break yb}break wb}if((f|0)<=0){break wb}h=0;m=0;n=0;l=0;while(1){s=m<<3;B=A[s+r>>3];J=D(B);if(!(J<=A[p+1280>>3])){Q=A[s+z>>3];v[u+(n<<2)>>2]=m;A[C+(n<<3)>>3]=B;l=B*Q+l;n=n+1|0;h=h+J}m=m+1|0;if((f|0)!=(m|0)){continue}break}break vb}if((f|0)<=0){break wb}h=0;m=0;n=0;l=0;while(1){s=m<<3;B=A[s+r>>3];J=D(B);if(!(J<=A[p+1280>>3])){Q=A[s+z>>3];v[u+(n<<2)>>2]=m;A[C+(n<<3)>>3]=B;l=B*Q+l;n=n+1|0;h=h<J?J:h}m=m+1|0;if((f|0)!=(m|0)){continue}break}break vb}if((f|0)<=0){n=0;l=0;h=0;break vb}l=0;m=0;n=0;while(1){s=m<<3;h=A[s+r>>3];if(!(A[p+1280>>3]>=D(h))){J=A[s+z>>3];v[u+(n<<2)>>2]=m;A[C+(n<<3)>>3]=h;n=n+1|0;B=h*h+B;l=h*J+l}m=m+1|0;if((f|0)!=(m|0)){continue}break}h=K(B);break vb}l=0;m=0;n=0;while(1){s=m<<3;h=A[s+r>>3];if(!(A[p+1280>>3]>=D(h))){B=A[s+z>>3];v[u+(n<<2)>>2]=m;A[C+(n<<3)>>3]=h;n=n+1|0;l=h*B+l}m=m+1|0;if((f|0)!=(m|0)){continue}break}h=(n|0)>0?1:0;break vb}Eb(151867,727);v[e+16>>2]=m<<24>>24;Fb(361075,e+16|0);Eb(151867,3387);i=-9;v[e>>2]=-9;Fb(276579,e);break sb}n=0;l=0;h=0}if(!(A[p+1280>>3]<h)){break sb}f=A[v[a+4>>2]+(v[v[a+72>>2]+160>>2]==1?1664:1656)>>3]<(l-q)/h;if(!(d|!v[o+156>>2]?f:1)){break sb}i=v[a+24>>2];m=v[i+936>>2];i=v[i+940>>2];v[e+56>>2]=v[x+152>>2];v[e+48>>2]=m;v[e+52>>2]=i;i=e+144|0;Jb(i,1024,7631,e+48|0);m=3402;Db:{i=rj(a,e+108|0,b,i,-A[v[a+4>>2]+1272>>3],q,d,0,v[o+140>>2]);if((i|0)!=1){break Db}i=v[e+108>>2];v[i+272>>2]=v[i+272>>2]|32;m=0;Eb:{if((n|0)<=0){break Eb}while(1){i=Xc(a,v[e+108>>2],v[v[e+120>>2]+(v[u+(m<<2)>>2]<<2)>>2],A[C+(m<<3)>>3]);if((i|0)==1){m=m+1|0;if((m|0)!=(n|0)){continue}break Eb}break}m=3407;break Db}i=v[e+108>>2];v[i+268>>2]=v[e+116>>2];m=3413;i=fg(a,i);if((i|0)!=1){break Db}if(!d){m=3421;i=Hj(a,v[e+108>>2]);if((i|0)!=1){break Db}}Fb:{Gb:{if(f){m=0;n=v[g+412>>2];Hb:{if((n|0)<=0){break Hb}while(1){d=M+(m<<2)|0;l=D(gx(v[e+108>>2],v[d>>2])+-1);h=A[v[a+4>>2]+1280>>3];if(!(!(l<=h)|!(-h<=q-A[v[d>>2]+16>>3]))){n=v[g+412>>2];break Hb}n=v[g+412>>2];m=m+1|0;if((n|0)>(m|0)){continue}break}}if((m|0)<(n|0)){break Gb}d=v[e+108>>2];v[M+(n<<2)>>2]=d;v[g+412>>2]=n+1;if(v[o+192>>2]){m=3455;i=Wz(a,d);if((i|0)!=1){break Db}d=v[e+108>>2]}m=3458;i=Cd(a,d,0,E);if((i|0)!=1){break Db}v[x+152>>2]=v[x+152>>2]+1;break Fb}m=3471;i=jd(a,e+108|0);if((i|0)==1){break Fb}break Db}m=3465;i=jd(a,e+108|0);if((i|0)!=1){break Db}}i=1;break sb}Eb(151867,m);v[e+32>>2]=i;Fb(276579,e+32|0)}ub=e+1168|0;e=i;if((e|0)==1){break rb}Eb(151867,4123);v[g+112>>2]=e;Fb(276579,g+112|0);break Ha}k=k+1|0;if((G|0)!=(k|0)){continue}break}d=v[g+412>>2];if((d|0)<=0){break La}i=0;f=v[g+424>>2];while(1){e=jd(a,f+(i<<2)|0);if((e|0)==1){i=i+1|0;if((d|0)!=(i|0)){continue}break La}break}Eb(151867,4135);v[g+96>>2]=e;Fb(276579,g+96|0);break Ha}if(v[o+144>>2]|v[o+148>>2]){Dn(a,g+448|0)}lc(v[v[a>>2]+8>>2],g+416|0);lc(v[v[a>>2]+8>>2],g+452|0);Hb(v[v[a>>2]+8>>2],g+424|0,151833,4145);Hb(v[v[a>>2]+8>>2],g+440|0,151833,4146);Hb(v[v[a>>2]+8>>2],g+432|0,151833,4147);Hb(v[v[a>>2]+8>>2],g+436|0,151833,4148);Hb(v[v[a>>2]+8>>2],g+444|0,151833,4149);Hb(v[v[a>>2]+8>>2],g+428|0,151833,4150);e=1}ub=g+1536|0;i=e;if((e|0)==1){break ja}Eb(151867,4463);v[x+32>>2]=e;Fb(276579,x+32|0);break a}d=ub-160|0;ub=d;f=v[b+144>>2];e=v[j>>2];Ib:{Jb:{Kb:{Lb:{b=v[j+16>>2];if(b){i=0;while(1){k=i<<2;if(!v[k+v[j+40>>2]>>2]){b=Dc(e,k+v[j+24>>2]|0);if((b|0)!=1){Eb(151867,4186);v[d+144>>2]=b;Fb(276579,d+144|0);break Ib}b=Dc(e,k+v[j+32>>2]|0);if((b|0)!=1){break Lb}b=v[j+16>>2]}i=i+1|0;if(i>>>0<b>>>0){continue}break}}b=Dc(e,j+28|0);if((b|0)!=1){Eb(151867,4190);v[d+112>>2]=b;Fb(276579,d+112|0);break Ib}Mb:{Nb:{b=Dc(e,j+36|0);if((b|0)==1){if(v[j+12>>2]){break Nb}b=0;break Mb}Eb(151867,4191);v[d+96>>2]=b;Fb(276579,d+96|0);break Ib}i=0;while(1){Ob:{k=i<<2;b=k+v[j+52>>2]|0;if(!v[b>>2]){break Ob}b=Dc(e,b);if((b|0)==1){break Ob}Eb(151867,4197);v[d+80>>2]=b;Fb(276579,d+80|0);break Ib}Pb:{b=k+v[j+56>>2]|0;if(!v[b>>2]){break Pb}b=Dc(e,b);if((b|0)==1){break Pb}Eb(151867,4201);v[d+64>>2]=b;Fb(276579,d- -64|0);break Ib}b=v[j+12>>2];i=i+1|0;if(b>>>0>i>>>0){continue}break}}Qb:{if(!(v[f+180>>2]|v[f+184>>2])){break Qb}i=v[j+56>>2]+(b<<2)|0;if(v[i>>2]){b=Dc(e,i);if((b|0)!=1){break Kb}b=v[j+12>>2]}b=v[j+52>>2]+(b<<2)|0;if(!v[b>>2]){break Qb}b=Dc(e,b);if((b|0)==1){break Qb}Eb(151867,4213);v[d+32>>2]=b;Fb(276579,d+32|0);break Ib}b=v[j+16>>2];if(b){i=0;while(1){f=v[j+60>>2]+(i<<2)|0;if(v[f>>2]){b=Dc(e,f);if((b|0)!=1){break Jb}b=v[j+16>>2]}i=i+1|0;if(i>>>0<b>>>0){continue}break}}b=ne(j);if((b|0)!=1){Eb(151867,4225);v[d>>2]=b;Fb(276579,d);break Ib}Lb(v[v[a>>2]+4>>2],j+68|0,v[j+20>>2]<<3,151833,4227);Lb(v[v[a>>2]+4>>2],j- -64|0,v[j+20>>2]<<3,151833,4228);Lb(v[v[a>>2]+4>>2],j+60|0,v[j+16>>2]<<3,151833,4229);Lb(v[v[a>>2]+4>>2],j+56|0,v[j+20>>2]<<2,151833,4230);Lb(v[v[a>>2]+4>>2],j+52|0,v[j+20>>2]<<2,151833,4231);Lb(v[v[a>>2]+4>>2],j+48|0,v[j+16>>2]<<2,151833,4232);Lb(v[v[a>>2]+4>>2],j+44|0,v[j+16>>2]<<2,151833,4233);Lb(v[v[a>>2]+4>>2],j+40|0,v[j+16>>2]<<2,151833,4234);Lb(v[v[a>>2]+4>>2],j+32|0,v[j+16>>2]<<2,151833,4235);Lb(v[v[a>>2]+4>>2],j+24|0,v[j+16>>2]<<2,151833,4236);b=1;break Ib}Eb(151867,4187);v[d+128>>2]=b;Fb(276579,d+128|0);break Ib}Eb(151867,4209);v[d+48>>2]=b;Fb(276579,d+48|0);break Ib}Eb(151867,4221);v[d+16>>2]=b;Fb(276579,d+16|0)}ub=d+160|0;i=b;if((i|0)!=1){Eb(151867,4467);v[x+16>>2]=i;Fb(276579,x+16|0);break a}Lb(v[v[a>>2]+4>>2],x+156|0,96,151833,4468);if(v[x+144>>2]){v[c>>2]=7;i=1;break a}i=1;if(!v[x+152>>2]){break a}v[c>>2]=8}ub=x+160|0;return i|0}function Gf(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=ub-192|0;ub=f;b=zd(120,154376,241);v[a>>2]=b;a:{b:{if(!b){Eb(154410,241);Fb(276543,0);b=-1;break b}dc(b,120);e=ub-16|0;ub=e;d=ub-1120|0;ub=d;c=v[a>>2];b=zd(56,158987,307);v[c+16>>2]=b;c:{if(!b){v[d>>2]=159021;v[d+4>>2]=307;b=d+96|0;Ni(b,1024,252186,d);t[d+1119|0]=0;c=v[106956];if(c){zb[c|0](v[107088],0,b)}Fb(276543,0);b=-1;break c}v[b>>2]=1533;v[v[c+16>>2]+4>>2]=1534;v[v[c+16>>2]+8>>2]=1535;v[v[c+16>>2]+12>>2]=0;v[v[c+16>>2]+16>>2]=0;v[v[c+16>>2]+28>>2]=0;v[v[c+16>>2]+32>>2]=0;v[v[c+16>>2]+36>>2]=0;b=v[c+16>>2];v[b+48>>2]=0;v[b+52>>2]=1;v[b+40>>2]=0;v[b+44>>2]=0;v[b+24>>2]=0;v[b+20>>2]=0;b=vd(1024,1,158987,327);v[v[c+16>>2]+28>>2]=b;if(!b){v[d+16>>2]=159021;v[d+20>>2]=327;b=d+96|0;Ni(b,1024,252186,d+16|0);t[d+1119|0]=0;c=v[106956];if(c){zb[c|0](v[107088],0,b)}Fb(276543,0);b=-1;break c}b=vd(1024,1,158987,328);v[v[c+16>>2]+32>>2]=b;if(!b){v[d+32>>2]=159021;v[d+36>>2]=328;b=d+96|0;Ni(b,1024,252186,d+32|0);t[d+1119|0]=0;c=v[106956];if(c){zb[c|0](v[107088],0,b)}Fb(276543,0);b=-1;break c}b=1;g=vd(1024,1,158987,329);v[v[c+16>>2]+36>>2]=g;if(!g){v[d+48>>2]=159021;v[d+52>>2]=329;b=d+96|0;Ni(b,1024,252186,d+48|0);t[d+1119|0]=0;c=v[106956];if(c){zb[c|0](v[107088],0,b)}Fb(276543,0);b=-1;break c}t[v[v[c+16>>2]+28>>2]]=0;t[v[v[c+16>>2]+32>>2]]=0;t[v[v[c+16>>2]+36>>2]]=0}ub=d+1120|0;if((b|0)!=1){Eb(146516,92);v[e>>2]=b;Fb(276579,e)}ub=e+16|0;if((b|0)!=1){Eb(154410,247);v[f+176>>2]=b;Fb(276579,f+176|0);break b}b=49;d=v[a>>2];c=zd(16,153243,49);v[d>>2]=c;d:{e:{if(!c){break e}b=52;c=Vja(52);v[v[d>>2]>>2]=c;if(!c){break e}b=53;c=Vja(53);v[v[d>>2]+4>>2]=c;if(!c){break e}b=56;c=hda(0,56);v[v[d>>2]+8>>2]=c;if(!c){break e}b=57;c=hda(1,57);v[v[d>>2]+12>>2]=c;d=1;if(c){break d}}Eb(153277,b);Fb(276543,0);d=-1}b=d;if((b|0)!=1){Eb(154410,249);v[f+160>>2]=b;Fb(276579,f+160|0);break b}b=v[a>>2];d=b;g=v[b+16>>2];e=v[v[b>>2]>>2];c=ub-4528|0;ub=c;h=zd(1936,146888,1110);v[b+4>>2]=h;f:{if(!h){Eb(146922,1110);Fb(276543,0);b=-1;break f}v[h+4>>2]=b;v[h>>2]=0;v[v[d+4>>2]+12>>2]=v[v[b>>2]+8>>2];v[v[d+4>>2]+16>>2]=v[v[b>>2]+12>>2];h=ub-16|0;ub=h;i=v[d+4>>2];b=zd(16,146842,1433);v[i+8>>2]=b;g:{if(!b){Eb(146876,1433);Fb(276543,0);b=-1;break g}b=Bf(b,e,2048,2095,1824,1825,0);if((b|0)!=1){Eb(146876,1436);v[h>>2]=b;Fb(276579,h);break g}v[v[i+8>>2]+4>>2]=0;b=v[i+8>>2];v[b+8>>2]=0;v[b+12>>2]=0;b=1}ub=h+16|0;if((b|0)!=1){Eb(146922,1117);v[c+4512>>2]=b;Fb(276579,c+4512|0);break f}v[v[d+4>>2]+20>>2]=0;b=v[d+4>>2];v[b+24>>2]=0;v[b+164>>2]=0;v[b+168>>2]=0;b=v[d+4>>2];v[b+364>>2]=0;v[b+368>>2]=0;v[b+180>>2]=0;v[b+172>>2]=0;v[b+176>>2]=0;v[b+28>>2]=0;v[v[d+4>>2]+32>>2]=0;v[v[d+4>>2]+36>>2]=0;v[v[d+4>>2]+40>>2]=0;b=v[d+4>>2];v[b+44>>2]=0;v[b+184>>2]=0;v[b+188>>2]=0;b=v[d+4>>2];v[b+372>>2]=0;v[b+376>>2]=0;v[b+192>>2]=0;v[b+196>>2]=0;v[b+144>>2]=0;b=v[d+4>>2];v[b+456>>2]=0;v[b+460>>2]=0;v[b+344>>2]=0;v[b+336>>2]=0;v[b+340>>2]=0;v[b+148>>2]=0;v[v[d+4>>2]+48>>2]=0;b=v[d+4>>2];v[b+380>>2]=0;v[b+384>>2]=0;v[b+200>>2]=0;v[b+204>>2]=0;v[b+52>>2]=0;b=v[d+4>>2];v[b+388>>2]=0;v[b+392>>2]=0;v[b+208>>2]=0;v[b+212>>2]=0;v[b+56>>2]=0;b=v[d+4>>2];v[b+396>>2]=0;v[b+400>>2]=0;v[b+216>>2]=0;v[b+220>>2]=0;v[b+64>>2]=0;v[v[d+4>>2]+68>>2]=0;b=v[d+4>>2];v[b+416>>2]=0;v[b+408>>2]=0;v[b+412>>2]=0;v[b+232>>2]=0;v[b+236>>2]=0;v[b+136>>2]=0;b=v[d+4>>2];v[b+140>>2]=0;v[b+320>>2]=0;v[b+324>>2]=0;b=v[d+4>>2];v[b+1840>>2]=0;v[b+328>>2]=0;v[b+332>>2]=0;v[v[d+4>>2]+60>>2]=0;b=v[d+4>>2];v[b+404>>2]=0;v[b+224>>2]=0;v[b+228>>2]=0;v[b+72>>2]=0;b=v[d+4>>2];v[b+420>>2]=0;v[b+424>>2]=0;v[b+240>>2]=0;v[b+244>>2]=0;v[b+76>>2]=0;b=v[d+4>>2];v[b+428>>2]=0;v[b+432>>2]=0;v[b+248>>2]=0;v[b+252>>2]=0;v[b+80>>2]=0;b=v[d+4>>2];v[b+84>>2]=0;v[b+256>>2]=0;v[b+260>>2]=0;b=v[d+4>>2];v[b+88>>2]=0;v[b+264>>2]=0;v[b+268>>2]=0;v[v[d+4>>2]+92>>2]=0;b=v[d+4>>2];v[b+436>>2]=0;v[b+440>>2]=0;v[b+272>>2]=0;v[b+276>>2]=0;v[b+152>>2]=0;b=v[d+4>>2];v[b+356>>2]=0;v[b+360>>2]=0;v[b+96>>2]=0;b=v[d+4>>2];v[b+100>>2]=0;v[b+280>>2]=0;v[b+284>>2]=0;b=v[d+4>>2];v[b+444>>2]=0;v[b+288>>2]=0;v[b+292>>2]=0;v[b+104>>2]=0;b=v[d+4>>2];v[b+108>>2]=0;v[b+296>>2]=0;v[b+300>>2]=0;v[v[d+4>>2]+112>>2]=0;v[v[d+4>>2]+116>>2]=0;v[v[d+4>>2]+120>>2]=0;v[v[d+4>>2]+124>>2]=0;v[v[d+4>>2]+128>>2]=0;b=v[d+4>>2];v[b+448>>2]=0;v[b+304>>2]=0;v[b+308>>2]=0;v[b+132>>2]=0;b=v[d+4>>2];v[b+464>>2]=0;v[b+468>>2]=0;v[b+452>>2]=0;v[b+312>>2]=0;v[b+316>>2]=0;v[b+156>>2]=0;v[v[d+4>>2]+160>>2]=0;b=v[d+4>>2];v[b+1880>>2]=0;v[b+348>>2]=0;v[b+352>>2]=0;v[v[d+4>>2]+1884>>2]=0;v[v[d+4>>2]+1108>>2]=0;b=v[d+4>>2];v[b+1376>>2]=-1568170194;v[b+1380>>2]=1417495214;v[b+1104>>2]=0;v[b+1236>>2]=0;b=v[d+4>>2];v[b+928>>2]=0;b=F7(v[b+8>>2],g,e,140426,215461,b+472|0,1,112,69758);if((b|0)!=1){Eb(146922,3039);v[c+4496>>2]=b;Fb(276579,c+4496|0);Eb(146922,1251);v[c+4480>>2]=b;Fb(276579,c+4480|0);break f}b=v[d+4>>2];b=lP(v[b+8>>2],e,143959,77545,b+480|0,1,.167,0,1,0,0);if((b|0)!=1){Eb(146922,3016);v[c+4464>>2]=b;Fb(276579,c+4464|0);Eb(146922,1256);v[c+4448>>2]=b;Fb(276579,c+4448|0);break f}b=v[d+4>>2];b=G7(v[b+8>>2],e,3855,191914,b+488|0,0,0,0);if((b|0)!=1){Eb(146922,2944);v[c+4432>>2]=b;Fb(276579,c+4432|0);Eb(146922,1261);v[c+4416>>2]=b;Fb(276579,c+4416|0);break f}b=v[d+4>>2];b=lP(v[b+8>>2],e,72324,120883,b+496|0,0,.2,0,.5,0,0);if((b|0)!=1){Eb(146922,3016);v[c+4400>>2]=b;Fb(276579,c+4400|0);Eb(146922,1266);v[c+4384>>2]=b;Fb(276579,c+4384|0);break f}b=v[d+4>>2];b=Kd(b,e,91106,85136,b+504|0,0,.75,0,1,0,0);if((b|0)!=1){Eb(146922,1271);v[c+4368>>2]=b;Fb(276579,c+4368|0);break f}b=v[d+4>>2];b=Kd(b,e,105539,111236,b+512|0,0,.5,0,1,0,0);if((b|0)!=1){Eb(146922,1276);v[c+4352>>2]=b;Fb(276579,c+4352|0);break f}b=v[d+4>>2];b=ml(b,g,e,108460,232881,b+520|0,0,115,44974);if((b|0)!=1){Eb(146922,1281);v[c+4336>>2]=b;Fb(276579,c+4336|0);break f}b=v[d+4>>2];b=Vc(b,e,113792,179523,b+524|0,0,1,0);if((b|0)!=1){Eb(146922,1286);v[c+4320>>2]=b;Fb(276579,c+4320|0);break f}b=v[d+4>>2];b=Vc(b,e,8643,187747,b+528|0,0,1,0);if((b|0)!=1){Eb(146922,1291);v[c+4304>>2]=b;Fb(276579,c+4304|0);break f}b=v[d+4>>2];b=Vc(b,e,85647,229753,b+532|0,1,0,0);if((b|0)!=1){Eb(146922,1296);v[c+4288>>2]=b;Fb(276579,c+4288|0);break f}b=v[d+4>>2];b=ml(b,g,e,132881,141861,b+473|0,1,97,94968);if((b|0)!=1){Eb(146922,1301);v[c+4272>>2]=b;Fb(276579,c+4272|0);break f}b=v[d+4>>2];b=Vc(b,e,90411,166720,b+536|0,1,1,0);if((b|0)!=1){Eb(146922,1306);v[c+4256>>2]=b;Fb(276579,c+4256|0);break f}b=v[d+4>>2];b=Vc(b,e,90658,242058,b+540|0,1,1,0);if((b|0)!=1){Eb(146922,1311);v[c+4240>>2]=b;Fb(276579,c+4240|0);break f}b=v[d+4>>2];b=Vc(b,e,114636,242314,b+544|0,1,0,0);if((b|0)!=1){Eb(146922,1316);v[c+4224>>2]=b;Fb(276579,c+4224|0);break f}b=v[d+4>>2];b=Vc(b,e,120592,192735,b+1868|0,1,0,0);if((b|0)!=1){Eb(146922,1323);v[c+4208>>2]=b;Fb(276579,c+4208|0);break f}b=v[d+4>>2];b=Vc(b,e,120554,192698,b+592|0,0,1,0);if((b|0)!=1){Eb(146922,1330);v[c+4192>>2]=b;Fb(276579,c+4192|0);break f}b=v[d+4>>2];b=Vc(b,e,47194,188561,b+596|0,1,1,0);if((b|0)!=1){Eb(146922,1335);v[c+4176>>2]=b;Fb(276579,c+4176|0);break f}b=v[d+4>>2];b=Vc(b,e,24629,48110,b+784|0,1,1,0);if((b|0)!=1){Eb(146922,1340);v[c+4160>>2]=b;Fb(276579,c+4160|0);break f}b=v[d+4>>2];b=Vc(b,e,71971,191257,b+600|0,0,1,0);if((b|0)!=1){Eb(146922,1345);v[c+4144>>2]=b;Fb(276579,c+4144|0);break f}b=v[d+4>>2];b=ml(b,g,e,72590,213354,b+604|0,0,98,160957);if((b|0)!=1){Eb(146922,1350);v[c+4128>>2]=b;Fb(276579,c+4128|0);break f}b=v[d+4>>2];b=ml(b,g,e,72779,213227,b+605|0,0,98,160957);if((b|0)!=1){Eb(146922,1355);v[c+4112>>2]=b;Fb(276579,c+4112|0);break f}b=v[d+4>>2];b=Vc(b,e,160790,191303,b+608|0,0,1,0);if((b|0)!=1){Eb(146922,1360);v[c+4096>>2]=b;Fb(276579,c+4096|0);break f}b=v[d+4>>2];b=Vc(b,e,74337,191207,b+612|0,0,1,0);if((b|0)!=1){Eb(146922,1365);v[c+4080>>2]=b;Fb(276579,c+4080|0);break f}b=v[d+4>>2];b=Kd(b,e,142865,14618,b+552|0,1,.15,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1370);v[c+4064>>2]=b;Fb(276579,c+4064|0);break f}b=v[d+4>>2];b=fd(b,e,36233,14682,b+560|0,1,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1375);v[c+4048>>2]=b;Fb(276579,c+4048|0);break f}b=v[d+4>>2];b=fd(b,e,37421,217105,b+564|0,1,2,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1380);v[c+4032>>2]=b;Fb(276579,c+4032|0);break f}b=v[d+4>>2];b=fd(b,e,40349,217431,b+568|0,1,10,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1385);v[c+4016>>2]=b;Fb(276579,c+4016|0);break f}b=v[d+4>>2];b=fd(b,e,44807,236031,b+572|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1390);v[c+4e3>>2]=b;Fb(276579,c+4e3|0);break f}b=v[d+4>>2];b=fd(b,e,32994,215211,b+576|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1395);v[c+3984>>2]=b;Fb(276579,c+3984|0);break f}b=v[d+4>>2];b=fd(b,e,44785,223122,b+588|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1400);v[c+3968>>2]=b;Fb(276579,c+3968|0);break f}b=v[d+4>>2];b=fd(b,e,32839,221958,b+580|0,1,10,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1405);v[c+3952>>2]=b;Fb(276579,c+3952|0);break f}b=v[d+4>>2];b=fd(b,e,108e3,236766,b+584|0,1,1e4,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1410);v[c+3936>>2]=b;Fb(276579,c+3936|0);break f}b=v[d+4>>2];b=Vc(b,e,3833,191876,b+620|0,0,0,0);if((b|0)!=1){Eb(146922,1415);v[c+3920>>2]=b;Fb(276579,c+3920|0);break f}b=v[d+4>>2];b=Vc(b,e,106174,106255,b+616|0,1,1,0);if((b|0)!=1){Eb(146922,1420);v[c+3904>>2]=b;Fb(276579,c+3904|0);break f}b=v[d+4>>2];b=Vc(b,e,93523,166977,b+624|0,1,1,0);if((b|0)!=1){Eb(146922,1425);v[c+3888>>2]=b;Fb(276579,c+3888|0);break f}b=v[d+4>>2];b=Vc(b,e,93620,180933,b+628|0,1,0,0);if((b|0)!=1){Eb(146922,1430);v[c+3872>>2]=b;Fb(276579,c+3872|0);break f}b=v[d+4>>2];b=Vc(b,e,113625,171858,b+632|0,1,1,0);if((b|0)!=1){Eb(146922,1435);v[c+3856>>2]=b;Fb(276579,c+3856|0);break f}b=v[d+4>>2];b=Vc(b,e,72019,181832,b+636|0,1,1,0);if((b|0)!=1){Eb(146922,1440);v[c+3840>>2]=b;Fb(276579,c+3840|0);break f}b=v[d+4>>2];b=Vc(b,e,113379,189956,b+640|0,1,1,0);if((b|0)!=1){Eb(146922,1445);v[c+3824>>2]=b;Fb(276579,c+3824|0);break f}b=v[d+4>>2];b=Vc(b,e,142078,183386,b+644|0,1,1,0);if((b|0)!=1){Eb(146922,1450);v[c+3808>>2]=b;Fb(276579,c+3808|0);break f}b=v[d+4>>2];b=Vc(b,e,119613,177111,b+648|0,1,1,0);if((b|0)!=1){Eb(146922,1455);v[c+3792>>2]=b;Fb(276579,c+3792|0);break f}b=v[d+4>>2];b=Kd(b,e,143889,140984,b+656|0,1,1,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1460);v[c+3776>>2]=b;Fb(276579,c+3776|0);break f}b=v[d+4>>2];b=Kd(b,e,143918,140804,b+664|0,1,1,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1465);v[c+3760>>2]=b;Fb(276579,c+3760|0);break f}b=v[d+4>>2];b=Kd(b,e,143839,140870,b+672|0,1,0,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1470);v[c+3744>>2]=b;Fb(276579,c+3744|0);break f}b=v[d+4>>2];b=Kd(b,e,143863,140926,b+680|0,1,0,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1475);v[c+3728>>2]=b;Fb(276579,c+3728|0);break f}b=v[d+4>>2];b=Kd(b,e,143941,50187,b+688|0,1,.98,1e-6,1,0,0);if((b|0)!=1){Eb(146922,1480);v[c+3712>>2]=b;Fb(276579,c+3712|0);break f}b=v[d+4>>2];b=fd(b,e,86296,221850,b+696|0,0,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1485);v[c+3696>>2]=b;Fb(276579,c+3696|0);break f}b=v[d+4>>2];b=Kd(b,e,142786,10156,b+704|0,0,1.5,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1490);v[c+3680>>2]=b;Fb(276579,c+3680|0);break f}b=v[d+4>>2];b=Vc(b,e,138868,192065,b+712|0,1,0,0);if((b|0)!=1){Eb(146922,1495);v[c+3664>>2]=b;Fb(276579,c+3664|0);break f}b=v[d+4>>2];b=fd(b,e,59039,241091,b+716|0,1,250,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1500);v[c+3648>>2]=b;Fb(276579,c+3648|0);break f}b=v[d+4>>2];b=Vc(b,e,22534,226159,b+720|0,1,1,0);if((b|0)!=1){Eb(146922,1505);v[c+3632>>2]=b;Fb(276579,c+3632|0);break f}b=v[d+4>>2];b=Kd(b,e,20524,22624,b+728|0,0,0,0,1,0,0);if((b|0)!=1){Eb(146922,1510);v[c+3616>>2]=b;Fb(276579,c+3616|0);break f}b=v[d+4>>2];b=Kd(b,e,21123,97015,b+736|0,0,1,0,1,0,0);if((b|0)!=1){Eb(146922,1515);v[c+3600>>2]=b;Fb(276579,c+3600|0);break f}b=v[d+4>>2];b=Kd(b,e,108719,16487,b+776|0,1,.05,0,1,0,0);if((b|0)!=1){Eb(146922,1519);v[c+3584>>2]=b;Fb(276579,c+3584|0);break f}b=v[d+4>>2];b=Kd(b,e,107805,81907,b+744|0,1,.001,0,1,0,0);if((b|0)!=1){Eb(146922,1523);v[c+3568>>2]=b;Fb(276579,c+3568|0);break f}b=v[d+4>>2];b=Kd(b,e,95539,81767,b+752|0,1,.1,0,1,0,0);if((b|0)!=1){Eb(146922,1527);v[c+3552>>2]=b;Fb(276579,c+3552|0);break f}b=v[d+4>>2];b=Kd(b,e,96175,81841,b+760|0,1,1,0,1,0,0);if((b|0)!=1){Eb(146922,1531);v[c+3536>>2]=b;Fb(276579,c+3536|0);break f}b=v[d+4>>2];b=Vc(b,e,48087,48159,b+768|0,0,0,0);if((b|0)!=1){Eb(146922,1536);v[c+3520>>2]=b;Fb(276579,c+3520|0);break f}b=v[d+4>>2];b=fd(b,e,19062,222073,b+788|0,1,0,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1543);v[c+3504>>2]=b;Fb(276579,c+3504|0);break f}b=v[d+4>>2];b=fd(b,e,122800,234922,b+792|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1548);v[c+3488>>2]=b;Fb(276579,c+3488|0);break f}b=v[d+4>>2];b=Vc(b,e,37644,192628,b+796|0,1,0,0);if((b|0)!=1){Eb(146922,1553);v[c+3472>>2]=b;Fb(276579,c+3472|0);break f}b=v[d+4>>2];b=fd(b,e,92013,7810,b+800|0,0,4,0,5,0,0);if((b|0)!=1){Eb(146922,1562);v[c+3456>>2]=b;Fb(276579,c+3456|0);break f}b=v[d+4>>2];b=fd(b,e,96445,116981,b+804|0,0,143,0,2147483647,2112,0);if((b|0)!=1){Eb(146922,1567);v[c+3440>>2]=b;Fb(276579,c+3440|0);break f}b=v[d+4>>2];b=fd(b,e,70575,50973,b+808|0,0,100,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1572);v[c+3424>>2]=b;Fb(276579,c+3424|0);break f}b=v[d+4>>2];b=fd(b,e,70032,235804,b+812|0,0,15,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1577);v[c+3408>>2]=b;Fb(276579,c+3408|0);break f}b=v[d+4>>2];b=Vc(b,e,74233,175189,b+816|0,0,0,0);if((b|0)!=1){Eb(146922,1582);v[c+3392>>2]=b;Fb(276579,c+3392|0);break f}b=v[d+4>>2];b=Vc(b,e,43992,170421,b+820|0,0,0,0);if((b|0)!=1){Eb(146922,1587);v[c+3376>>2]=b;Fb(276579,c+3376|0);break f}b=v[d+4>>2];b=Vc(b,e,32726,182487,b+824|0,0,1,0);if((b|0)!=1){Eb(146922,1592);v[c+3360>>2]=b;Fb(276579,c+3360|0);break f}b=v[d+4>>2];b=Vc(b,e,72975,176359,b+828|0,1,0,0);if((b|0)!=1){Eb(146922,1598);v[c+3344>>2]=b;Fb(276579,c+3344|0);break f}b=v[d+4>>2];b=Vc(b,e,136023,170639,b+832|0,0,0,0);if((b|0)!=1){Eb(146922,1605);v[c+3328>>2]=b;Fb(276579,c+3328|0);break f}b=v[d+4>>2];b=Vc(b,e,122096,186145,b+836|0,0,0,0);if((b|0)!=1){Eb(146922,1610);v[c+3312>>2]=b;Fb(276579,c+3312|0);break f}b=v[d+4>>2];b=Vc(b,e,67982,174945,b+840|0,0,0,0);if((b|0)!=1){Eb(146922,1615);v[c+3296>>2]=b;Fb(276579,c+3296|0);break f}b=v[d+4>>2];b=Kd(b,e,117257,74460,b+848|0,0,1e20,0,1e20,2113,0);if((b|0)!=1){Eb(146922,1622);v[c+3280>>2]=b;Fb(276579,c+3280|0);break f}b=v[d+4>>2];b=ww(b,e,56040,216888,b+880|0,0,-1,-1,-1,-1,-1,2147483647,2113);if((b|0)!=1){Eb(146922,1627);v[c+3264>>2]=b;Fb(276579,c+3264|0);break f}b=v[d+4>>2];b=ww(b,e,55521,216938,b+888|0,0,-1,-1,-1,-1,-1,2147483647,2113);if((b|0)!=1){Eb(146922,1632);v[c+3248>>2]=b;Fb(276579,c+3248|0);break f}b=v[d+4>>2];b=ww(b,e,55503,218954,b+896|0,0,-1,-1,-1,-1,-1,2147483647,2113);if((b|0)!=1){Eb(146922,1637);v[c+3232>>2]=b;Fb(276579,c+3232|0);break f}b=v[d+4>>2];b=Kd(b,e,3546,246026,b+856|0,0,8796093022207,0,8796093022207,2113,0);if((b|0)!=1){Eb(146922,1642);v[c+3216>>2]=b;Fb(276579,c+3216|0);break f}b=v[d+4>>2];b=Kd(b,e,73451,42526,b+864|0,0,0,0,17976931348623157e292,2113,0);if((b|0)!=1){Eb(146922,1647);v[c+3200>>2]=b;Fb(276579,c+3200|0);break f}b=v[d+4>>2];b=Kd(b,e,73357,111397,b+872|0,0,0,0,17976931348623157e292,2113,0);if((b|0)!=1){Eb(146922,1652);v[c+3184>>2]=b;Fb(276579,c+3184|0);break f}b=v[d+4>>2];b=fd(b,e,38760,218517,b+904|0,0,-1,-1,2147483647,2113,0);if((b|0)!=1){Eb(146922,1657);v[c+3168>>2]=b;Fb(276579,c+3168|0);break f}b=v[d+4>>2];b=fd(b,e,89901,219747,b+908|0,0,-1,-1,2147483647,2113,0);if((b|0)!=1){Eb(146922,1662);v[c+3152>>2]=b;Fb(276579,c+3152|0);break f}b=v[d+4>>2];b=fd(b,e,89750,122649,b+912|0,0,100,1,2147483647,2113,0);if((b|0)!=1){Eb(146922,1667);v[c+3136>>2]=b;Fb(276579,c+3136|0);break f}b=v[d+4>>2];b=fd(b,e,90430,88465,b+916|0,0,10,0,2147483647,2113,0);if((b|0)!=1){Eb(146922,1672);v[c+3120>>2]=b;Fb(276579,c+3120|0);break f}b=v[d+4>>2];b=fd(b,e,28505,219994,b+920|0,0,-1,-1,2147483647,2113,0);if((b|0)!=1){Eb(146922,1677);v[c+3104>>2]=b;Fb(276579,c+3104|0);break f}b=v[d+4>>2];b=fd(b,e,54824,214479,b+924|0,0,-1,-1,2147483647,2113,0);if((b|0)!=1){Eb(146922,1683);v[c+3088>>2]=b;Fb(276579,c+3088|0);break f}b=v[d+4>>2];b=fd(b,e,70306,241639,b+932|0,0,1,-1,65534,0,0);if((b|0)!=1){Eb(146922,1690);v[c+3072>>2]=b;Fb(276579,c+3072|0);break f}b=v[d+4>>2];b=ww(b,e,87325,218822,b+936|0,1,-1,-1,-1,-1,-1,2147483647,0);if((b|0)!=1){Eb(146922,1695);v[c+3056>>2]=b;Fb(276579,c+3056|0);break f}b=v[d+4>>2];b=ww(b,e,87310,218765,b+944|0,1,-1,-1,-1,-1,-1,2147483647,0);if((b|0)!=1){Eb(146922,1700);v[c+3040>>2]=b;Fb(276579,c+3040|0);break f}b=v[d+4>>2];b=fd(b,e,95937,221126,b+952|0,0,-1,-1,65534,0,0);if((b|0)!=1){Eb(146922,1705);v[c+3024>>2]=b;Fb(276579,c+3024|0);break f}b=v[d+4>>2];b=ml(b,g,e,87336,225704,b+956|0,0,115,142299);if((b|0)!=1){Eb(146922,1710);v[c+3008>>2]=b;Fb(276579,c+3008|0);break f}b=v[d+4>>2];b=ml(b,g,e,87353,225542,b+957|0,0,115,142299);if((b|0)!=1){Eb(146922,1715);v[c+2992>>2]=b;Fb(276579,c+2992|0);break f}b=v[d+4>>2];b=ml(b,g,e,105160,233586,b+958|0,0,108,128447);if((b|0)!=1){Eb(146922,1720);v[c+2976>>2]=b;Fb(276579,c+2976|0);break f}b=v[d+4>>2];b=Vc(b,e,72565,181963,b+960|0,1,1,0);if((b|0)!=1){Eb(146922,1725);v[c+2960>>2]=b;Fb(276579,c+2960|0);break f}b=v[d+4>>2];b=Vc(b,e,114542,196880,b+964|0,1,0,0);if((b|0)!=1){Eb(146922,1730);v[c+2944>>2]=b;Fb(276579,c+2944|0);break f}b=v[d+4>>2];b=Vc(b,e,35834,182782,b+968|0,1,0,0);if((b|0)!=1){Eb(146922,1735);v[c+2928>>2]=b;Fb(276579,c+2928|0);break f}b=v[d+4>>2];b=fd(b,e,19047,233474,b+972|0,1,10,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1740);v[c+2912>>2]=b;Fb(276579,c+2912|0);break f}b=v[d+4>>2];b=fd(b,e,19009,233368,b+976|0,1,10,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1745);v[c+2896>>2]=b;Fb(276579,c+2896|0);break f}b=v[d+4>>2];b=Vc(b,e,44055,182724,b+980|0,1,0,0);if((b|0)!=1){Eb(146922,1750);v[c+2880>>2]=b;Fb(276579,c+2880|0);break f}b=v[d+4>>2];b=Vc(b,e,12862,182610,b+984|0,1,0,0);if((b|0)!=1){Eb(146922,1755);v[c+2864>>2]=b;Fb(276579,c+2864|0);break f}b=v[d+4>>2];b=Vc(b,e,24292,182673,b+988|0,1,1,0);if((b|0)!=1){Eb(146922,1760);v[c+2848>>2]=b;Fb(276579,c+2848|0);break f}b=v[d+4>>2];b=Vc(b,e,12226,182554,b+992|0,1,1,0);if((b|0)!=1){Eb(146922,1765);v[c+2832>>2]=b;Fb(276579,c+2832|0);break f}b=v[d+4>>2];b=Vc(b,e,2955,166809,b+996|0,1,1,0);if((b|0)!=1){Eb(146922,1770);v[c+2816>>2]=b;Fb(276579,c+2816|0);break f}b=v[d+4>>2];b=Kd(b,e,18522,220536,b+1e3|0,1,-1,-1,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1775);v[c+2800>>2]=b;Fb(276579,c+2800|0);break f}b=v[d+4>>2];b=Kd(b,e,1303,79258,b+1008|0,1,.01,1e-4,.9999,0,0);if((b|0)!=1){Eb(146922,1780);v[c+2784>>2]=b;Fb(276579,c+2784|0);break f}b=v[d+4>>2];b=Vc(b,e,61673,176260,b+1016|0,1,1,0);if((b|0)!=1){Eb(146922,1785);v[c+2768>>2]=b;Fb(276579,c+2768|0);break f}b=v[d+4>>2];b=Vc(b,e,61690,176163,b+1020|0,1,1,0);if((b|0)!=1){Eb(146922,1790);v[c+2752>>2]=b;Fb(276579,c+2752|0);break f}b=v[d+4>>2];b=Vc(b,e,61558,193119,b+1024|0,1,1,0);if((b|0)!=1){Eb(146922,1795);v[c+2736>>2]=b;Fb(276579,c+2736|0);break f}b=v[d+4>>2];b=fd(b,e,72859,7364,b+1028|0,1,1,0,1,0,0);if((b|0)!=1){Eb(146922,1800);v[c+2720>>2]=b;Fb(276579,c+2720|0);break f}b=v[d+4>>2];b=fd(b,e,103331,234613,b+1032|0,1,1,0,2,0,0);if((b|0)!=1){Eb(146922,1805);v[c+2704>>2]=b;Fb(276579,c+2704|0);break f}b=v[d+4>>2];b=Vc(b,e,99698,191450,b+1036|0,1,1,0);if((b|0)!=1){Eb(146922,1810);v[c+2688>>2]=b;Fb(276579,c+2688|0);break f}b=v[d+4>>2];b=Vc(b,e,74188,191615,b+1040|0,1,0,0);if((b|0)!=1){Eb(146922,1815);v[c+2672>>2]=b;Fb(276579,c+2672|0);break f}b=v[d+4>>2];b=Vc(b,e,4538,123430,b+1044|0,1,1,0);if((b|0)!=1){Eb(146922,1820);v[c+2656>>2]=b;Fb(276579,c+2656|0);break f}b=v[d+4>>2];b=fd(b,e,56967,241238,b+1048|0,1,2,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,1825);v[c+2640>>2]=b;Fb(276579,c+2640|0);break f}b=v[d+4>>2];b=Vc(b,e,142e3,180144,b+1052|0,1,0,0);if((b|0)!=1){Eb(146922,1830);v[c+2624>>2]=b;Fb(276579,c+2624|0);break f}b=v[d+4>>2];b=Vc(b,e,103163,183285,b+1056|0,1,1,0);if((b|0)!=1){Eb(146922,1835);v[c+2608>>2]=b;Fb(276579,c+2608|0);break f}b=v[d+4>>2];b=fd(b,e,106667,226757,b+1060|0,1,2,0,2,0,0);if((b|0)!=1){Eb(146922,1840);v[c+2592>>2]=b;Fb(276579,c+2592|0);break f}b=v[d+4>>2];b=Kd(b,e,97478,228959,b+1064|0,1,1.2,-1,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1845);v[c+2576>>2]=b;Fb(276579,c+2576|0);break f}b=v[d+4>>2];b=fd(b,e,60419,241341,b+1072|0,1,0,0,64,0,0);if((b|0)!=1){Eb(146922,1850);v[c+2560>>2]=b;Fb(276579,c+2560|0);break f}b=v[d+4>>2];b=Kd(b,e,143022,238590,b+1080|0,1,-1,-1,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,1855);v[c+2544>>2]=b;Fb(276579,c+2544|0);break f}b=v[d+4>>2];b=fd(b,e,84782,109318,b+1088|0,1,1e3,1,2147483647,0,0);if((b|0)!=1){Eb(146922,1860);v[c+2528>>2]=b;Fb(276579,c+2528|0);break f}b=v[d+4>>2];b=fd(b,e,103924,226680,b+1092|0,1,3,0,3,0,0);if((b|0)!=1){Eb(146922,1866);v[c+2512>>2]=b;Fb(276579,c+2512|0);break f}b=v[d+4>>2];b=fd(b,e,92257,226921,b+1096|0,1,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1872);v[c+2496>>2]=b;Fb(276579,c+2496|0);break f}b=v[d+4>>2];b=Vc(b,e,45069,186559,b+1100|0,0,0,0);if((b|0)!=1){Eb(146922,1877);v[c+2480>>2]=b;Fb(276579,c+2480|0);break f}b=v[d+4>>2];b=Dz(b,e,66297,2568,b+1108|0,0,365319);if((b|0)!=1){Eb(146922,1884);v[c+2464>>2]=b;Fb(276579,c+2464|0);break f}b=v[d+4>>2];b=Vc(b,e,120542,197033,b+1104|0,0,0,0);if((b|0)!=1){Eb(146922,1889);v[c+2448>>2]=b;Fb(276579,c+2448|0);break f}b=v[d+4>>2];b=Kd(b,e,143764,126219,b+1112|0,0,.8,0,1,0,0);if((b|0)!=1){Eb(146922,1896);v[c+2432>>2]=b;Fb(276579,c+2432|0);break f}b=v[d+4>>2];b=Kd(b,e,142641,24068,b+1120|0,1,1.2,1,10,2114,0);if((b|0)!=1){Eb(146922,1901);v[c+2416>>2]=b;Fb(276579,c+2416|0);break f}b=v[d+4>>2];b=fd(b,e,18043,24123,b+1144|0,1,4,0,2147483647,2115,0);if((b|0)!=1){Eb(146922,1906);v[c+2400>>2]=b;Fb(276579,c+2400|0);break f}b=v[d+4>>2];b=Kd(b,e,142680,5345,b+1128|0,1,2,1,10,0,0);if((b|0)!=1){Eb(146922,1911);v[c+2384>>2]=b;Fb(276579,c+2384|0);break f}b=v[d+4>>2];b=fd(b,e,18084,5382,b+1148|0,1,65536,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1916);v[c+2368>>2]=b;Fb(276579,c+2368|0);break f}b=v[d+4>>2];b=Kd(b,e,142661,5281,b+1136|0,1,2,1,10,0,0);if((b|0)!=1){Eb(146922,1921);v[c+2352>>2]=b;Fb(276579,c+2352|0);break f}b=v[d+4>>2];b=fd(b,e,18064,5318,b+1152|0,1,256,0,2147483647,0,0);if((b|0)!=1){Eb(146922,1926);v[c+2336>>2]=b;Fb(276579,c+2336|0);break f}b=v[d+4>>2];b=Vc(b,e,140470,195600,b+1156|0,0,1,0);if((b|0)!=1){Eb(146922,1933);v[c+2320>>2]=b;Fb(276579,c+2320|0);break f}b=v[d+4>>2];b=Vc(b,e,119650,174495,b+1160|0,0,1,0);if((b|0)!=1){Eb(146922,1938);v[c+2304>>2]=b;Fb(276579,c+2304|0);break f}b=v[d+4>>2];b=Vc(b,e,119632,169774,b+1164|0,0,1,0);if((b|0)!=1){Eb(146922,1943);v[c+2288>>2]=b;Fb(276579,c+2288|0);break f}b=v[d+4>>2];b=Vc(b,e,51481,52878,b+1168|0,0,0,0);if((b|0)!=1){Eb(146922,1948);v[c+2272>>2]=b;Fb(276579,c+2272|0);break f}b=v[d+4>>2];v[b+1172>>2]=0;b=Vc(b,e,22779,242391,b+1176|0,0,1,0);if((b|0)!=1){Eb(146922,1963);v[c+2256>>2]=b;Fb(276579,c+2256|0);break f}b=v[d+4>>2];b=Vc(b,e,43832,131649,b+1180|0,0,0,0);if((b|0)!=1){Eb(146922,1969);v[c+2240>>2]=b;Fb(276579,c+2240|0);break f}b=v[d+4>>2];b=Vc(b,e,74880,119195,b+1184|0,0,1,0);if((b|0)!=1){Eb(146922,1974);v[c+2224>>2]=b;Fb(276579,c+2224|0);break f}b=v[d+4>>2];b=Vc(b,e,87622,190157,b+1188|0,0,1,0);if((b|0)!=1){Eb(146922,1979);v[c+2208>>2]=b;Fb(276579,c+2208|0);break f}b=v[d+4>>2];b=Vc(b,e,7904,175737,b+1192|0,0,1,0);if((b|0)!=1){Eb(146922,1984);v[c+2192>>2]=b;Fb(276579,c+2192|0);break f}b=v[d+4>>2];b=Vc(b,e,43851,197798,b+1196|0,0,1,0);if((b|0)!=1){Eb(146922,1989);v[c+2176>>2]=b;Fb(276579,c+2176|0);break f}b=v[d+4>>2];b=Vc(b,e,105567,197960,b+1200|0,0,1,0);if((b|0)!=1){Eb(146922,1994);v[c+2160>>2]=b;Fb(276579,c+2160|0);break f}b=v[d+4>>2];b=Vc(b,e,92789,184631,b+1204|0,0,1,0);if((b|0)!=1){Eb(146922,1999);v[c+2144>>2]=b;Fb(276579,c+2144|0);break f}b=v[d+4>>2];b=Vc(b,e,114517,185294,b+1208|0,0,0,0);if((b|0)!=1){Eb(146922,2004);v[c+2128>>2]=b;Fb(276579,c+2128|0);break f}b=v[d+4>>2];b=Vc(b,e,90448,177394,b+1212|0,0,1,0);if((b|0)!=1){Eb(146922,2009);v[c+2112>>2]=b;Fb(276579,c+2112|0);break f}b=v[d+4>>2];b=Vc(b,e,60203,182415,b+1216|0,0,1,0);if((b|0)!=1){Eb(146922,2014);v[c+2096>>2]=b;Fb(276579,c+2096|0);break f}b=v[d+4>>2];b=Vc(b,e,60180,182345,b+1220|0,0,1,0);if((b|0)!=1){Eb(146922,2019);v[c+2080>>2]=b;Fb(276579,c+2080|0);break f}b=v[d+4>>2];b=Vc(b,e,94647,176987,b+1240|0,0,1,0);if((b|0)!=1){Eb(146922,2024);v[c+2064>>2]=b;Fb(276579,c+2064|0);break f}b=v[d+4>>2];b=Vc(b,e,32790,177335,b+1244|0,0,0,0);if((b|0)!=1){Eb(146922,2029);v[c+2048>>2]=b;Fb(276579,c+2048|0);break f}b=v[d+4>>2];b=Kd(b,e,111166,49998,b+1224|0,0,1e99,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2035);v[c+2032>>2]=b;Fb(276579,c+2032|0);break f}b=v[d+4>>2];b=fd(b,e,3458,208233,b+1232|0,0,7,0,7,2116,0);if((b|0)!=1){Eb(146922,2052);v[c+2016>>2]=b;Fb(276579,c+2016|0);break f}b=v[d+4>>2];b=fd(b,e,21724,138166,b+1248|0,0,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2059);v[c+2e3>>2]=b;Fb(276579,c+2e3|0);break f}b=v[d+4>>2];b=fd(b,e,138059,228873,b+1252|0,0,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2065);v[c+1984>>2]=b;Fb(276579,c+1984|0);break f}b=v[d+4>>2];b=Vc(b,e,33197,198751,b+1260|0,1,1,0);if((b|0)!=1){Eb(146922,2071);v[c+1968>>2]=b;Fb(276579,c+1968|0);break f}b=v[d+4>>2];b=Vc(b,e,36967,198821,b+1264|0,1,0,0);if((b|0)!=1){Eb(146922,2077);v[c+1952>>2]=b;Fb(276579,c+1952|0);break f}b=v[d+4>>2];b=fd(b,e,138038,215631,b+1256|0,0,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2083);v[c+1936>>2]=b;Fb(276579,c+1936|0);break f}b=v[d+4>>2];b=ml(b,g,e,92110,237103,b+1268|0,0,104,96839);if((b|0)!=1){Eb(146922,2090);v[c+1920>>2]=b;Fb(276579,c+1920|0);break f}b=v[d+4>>2];b=Kd(b,e,2680,2742,b+1272|0,0,1e20,1e10,1e98,2117,0);if((b|0)!=1){Eb(146922,2097);v[c+1904>>2]=b;Fb(276579,c+1904|0);break f}b=v[d+4>>2];b=Kd(b,e,74936,73738,b+1280|0,0,1e-9,1e-20,.001,0,0);if((b|0)!=1){Eb(146922,2102);v[c+1888>>2]=b;Fb(276579,c+1888|0);break f}b=v[d+4>>2];b=Kd(b,e,74916,73676,b+1288|0,0,1e-6,9999999999999999e-33,.001,0,0);if((b|0)!=1){Eb(146922,2107);v[c+1872>>2]=b;Fb(276579,c+1872|0);break f}b=v[d+4>>2];b=Kd(b,e,89610,29281,b+1296|0,0,1e-6,9999999999999999e-33,.001,2118,0);if((b|0)!=1){Eb(146922,2112);v[c+1856>>2]=b;Fb(276579,c+1856|0);break f}b=v[d+4>>2];b=Kd(b,e,143331,75074,b+1304|0,0,1,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2117);v[c+1840>>2]=b;Fb(276579,c+1840|0);break f}b=v[d+4>>2];b=Kd(b,e,63554,66357,b+1312|0,0,1,1e-6,1,2119,0);if((b|0)!=1){Eb(146922,2122);v[c+1824>>2]=b;Fb(276579,c+1824|0);break f}b=v[d+4>>2];b=Kd(b,e,89589,76136,b+1320|0,0,1e-7,9999999999999999e-33,.001,2120,0);if((b|0)!=1){Eb(146922,2127);v[c+1808>>2]=b;Fb(276579,c+1808|0);break f}b=v[d+4>>2];b=Kd(b,e,89462,87429,b+1328|0,1,1e-10,9999999999999999e-33,.001,2121,0);if((b|0)!=1){Eb(146922,2132);v[c+1792>>2]=b;Fb(276579,c+1792|0);break f}b=v[d+4>>2];b=Kd(b,e,37940,59427,b+1336|0,1,.05,9999999999999999e-33,1e98,0,0);if((b|0)!=1){Eb(146922,2137);v[c+1776>>2]=b;Fb(276579,c+1776|0);break f}b=v[d+4>>2];b=Kd(b,e,37888,49925,b+1344|0,1,.1,9999999999999999e-33,1,0,0);if((b|0)!=1){Eb(146922,2142);v[c+1760>>2]=b;Fb(276579,c+1760|0);break f}b=v[d+4>>2];b=Kd(b,e,161031,49851,b+1352|0,1,1e-4,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2147);v[c+1744>>2]=b;Fb(276579,c+1744|0);break f}b=v[d+4>>2];b=Kd(b,e,143779,113835,b+1360|0,1,1e7,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2152);v[c+1728>>2]=b;Fb(276579,c+1728|0);break f}b=v[d+4>>2];b=Kd(b,e,92451,228662,b+1368|0,1,1e15,0,1e98,0,0);if((b|0)!=1){Eb(146922,2157);v[c+1712>>2]=b;Fb(276579,c+1712|0);break f}b=v[d+4>>2];b=fd(b,e,57482,234104,b+1392|0,0,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2164);v[c+1696>>2]=b;Fb(276579,c+1696|0);break f}b=v[d+4>>2];b=Kd(b,e,142699,129765,b+1384|0,1,8e-4,0,1,0,0);if((b|0)!=1){Eb(146922,2169);v[c+1680>>2]=b;Fb(276579,c+1680|0);break f}b=v[d+4>>2];b=fd(b,e,28482,237645,b+1396|0,0,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2174);v[c+1664>>2]=b;Fb(276579,c+1664|0);break f}b=v[d+4>>2];b=Kd(b,e,142806,80283,b+1408|0,1,.025,0,1,0,0);if((b|0)!=1){Eb(146922,2179);v[c+1648>>2]=b;Fb(276579,c+1648|0);break f}b=v[d+4>>2];b=Kd(b,e,143978,38317,b+1400|0,1,2,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2184);v[c+1632>>2]=b;Fb(276579,c+1632|0);break f}b=v[d+4>>2];b=Kd(b,e,142736,101382,b+1416|0,1,.1,0,1,0,0);if((b|0)!=1){Eb(146922,2189);v[c+1616>>2]=b;Fb(276579,c+1616|0);break f}b=v[d+4>>2];b=Kd(b,e,142761,101496,b+1424|0,1,1,0,1,0,0);if((b|0)!=1){Eb(146922,2194);v[c+1600>>2]=b;Fb(276579,c+1600|0);break f}b=v[d+4>>2];b=Kd(b,e,136084,10061,b+1432|0,1,.1,0,1,0,0);if((b|0)!=1){Eb(146922,2199);v[c+1584>>2]=b;Fb(276579,c+1584|0);break f}b=v[d+4>>2];b=Vc(b,e,65960,180046,b+1440|0,1,0,0);if((b|0)!=1){Eb(146922,2204);v[c+1568>>2]=b;Fb(276579,c+1568|0);break f}b=v[d+4>>2];b=Vc(b,e,65939,180098,b+1444|0,1,0,0);if((b|0)!=1){Eb(146922,2209);v[c+1552>>2]=b;Fb(276579,c+1552|0);break f}b=v[d+4>>2];b=fd(b,e,36253,129709,b+1456|0,0,100,1,2147483647,0,0);if((b|0)!=1){Eb(146922,2216);v[c+1536>>2]=b;Fb(276579,c+1536|0);break f}b=v[d+4>>2];b=fd(b,e,12822,123503,b+1460|0,0,2e3,1,2147483647,0,0);if((b|0)!=1){Eb(146922,2221);v[c+1520>>2]=b;Fb(276579,c+1520|0);break f}b=v[d+4>>2];b=Kd(b,e,142719,130329,b+1448|0,0,2,1,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2226);v[c+1504>>2]=b;Fb(276579,c+1504|0);break f}b=v[d+4>>2];b=Vc(b,e,36881,185507,b+1464|0,0,0,0);if((b|0)!=1){Eb(146922,2231);v[c+1488>>2]=b;Fb(276579,c+1488|0);break f}b=v[d+4>>2];b=Vc(b,e,12842,185382,b+1468|0,0,0,0);if((b|0)!=1){Eb(146922,2236);v[c+1472>>2]=b;Fb(276579,c+1472|0);break f}b=v[d+4>>2];b=Vc(b,e,44946,177752,b+1472|0,0,0,0);if((b|0)!=1){Eb(146922,2243);v[c+1456>>2]=b;Fb(276579,c+1456|0);break f}b=v[d+4>>2];b=Vc(b,e,35909,193322,b+1476|0,0,0,0);if((b|0)!=1){Eb(146922,2248);v[c+1440>>2]=b;Fb(276579,c+1440|0);break f}b=v[d+4>>2];b=fd(b,e,122422,228771,b+1480|0,0,1e4,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2253);v[c+1424>>2]=b;Fb(276579,c+1424|0);break f}b=v[d+4>>2];b=Vc(b,e,50088,50118,b+1484|0,0,0,0);if((b|0)!=1){Eb(146922,2258);v[c+1408>>2]=b;Fb(276579,c+1408|0);break f}b=v[d+4>>2];b=Kd(b,e,89723,210613,b+1488|0,0,1e-6,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2265);v[c+1392>>2]=b;Fb(276579,c+1392|0);break f}b=v[d+4>>2];b=Vc(b,e,90010,179109,b+1496|0,0,1,0);if((b|0)!=1){Eb(146922,2270);v[c+1376>>2]=b;Fb(276579,c+1376|0);break f}b=v[d+4>>2];b=Vc(b,e,35889,176101,b+1500|0,0,1,0);if((b|0)!=1){Eb(146922,2275);v[c+1360>>2]=b;Fb(276579,c+1360|0);break f}b=v[d+4>>2];b=fd(b,e,57524,240173,b+1504|0,0,100,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2282);v[c+1344>>2]=b;Fb(276579,c+1344|0);break f}b=v[d+4>>2];b=fd(b,e,13361,239384,b+1508|0,0,1e3,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2287);v[c+1328>>2]=b;Fb(276579,c+1328|0);break f}b=v[d+4>>2];b=Vc(b,e,106591,29063,b+1512|0,0,1,0);if((b|0)!=1){Eb(146922,2292);v[c+1312>>2]=b;Fb(276579,c+1312|0);break f}b=v[d+4>>2];b=Vc(b,e,120570,190896,b+1580|0,0,0,2122);if((b|0)!=1){Eb(146922,2299);v[c+1296>>2]=b;Fb(276579,c+1296|0);break f}b=v[d+4>>2];b=fd(b,e,55999,56292,b+1560|0,1,2147483647,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2304);v[c+1280>>2]=b;Fb(276579,c+1280|0);break f}b=v[d+4>>2];b=fd(b,e,55938,96679,b+1556|0,1,2147483647,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2309);v[c+1264>>2]=b;Fb(276579,c+1264|0);break f}b=v[d+4>>2];b=Vc(b,e,54048,204817,b+1600|0,0,1,0);if((b|0)!=1){Eb(146922,2314);v[c+1248>>2]=b;Fb(276579,c+1248|0);break f}b=v[d+4>>2];b=Vc(b,e,89874,96612,b+1604|0,1,0,0);if((b|0)!=1){Eb(146922,2319);v[c+1232>>2]=b;Fb(276579,c+1232|0);break f}b=v[d+4>>2];b=Vc(b,e,3508,4405,b+1608|0,1,0,0);if((b|0)!=1){Eb(146922,2324);v[c+1216>>2]=b;Fb(276579,c+1216|0);break f}b=v[d+4>>2];b=Vc(b,e,8692,246497,b+1612|0,1,0,0);if((b|0)!=1){Eb(146922,2329);v[c+1200>>2]=b;Fb(276579,c+1200|0);break f}b=v[d+4>>2];b=fd(b,e,72608,211049,b+1564|0,1,1,1,5,0,0);if((b|0)!=1){Eb(146922,2334);v[c+1184>>2]=b;Fb(276579,c+1184|0);break f}b=v[d+4>>2];b=fd(b,e,106849,164861,b+1568|0,1,1,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2339);v[c+1168>>2]=b;Fb(276579,c+1168|0);break f}b=v[d+4>>2];b=fd(b,e,43903,230760,b+1572|0,1,2147483647,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2344);v[c+1152>>2]=b;Fb(276579,c+1152|0);break f}b=v[d+4>>2];b=Kd(b,e,164206,210533,b+1528|0,1,.8,-1,1,0,0);if((b|0)!=1){Eb(146922,2349);v[c+1136>>2]=b;Fb(276579,c+1136|0);break f}b=v[d+4>>2];b=Kd(b,e,90346,39474,b+1520|0,1,-1,-1,1,0,0);if((b|0)!=1){Eb(146922,2354);v[c+1120>>2]=b;Fb(276579,c+1120|0);break f}b=v[d+4>>2];b=Kd(b,e,5700,209583,b+1536|0,1,-1,-1,1,0,0);if((b|0)!=1){Eb(146922,2359);v[c+1104>>2]=b;Fb(276579,c+1104|0);break f}b=v[d+4>>2];b=Vc(b,e,18951,210782,b+1576|0,1,0,0);if((b|0)!=1){Eb(146922,2364);v[c+1088>>2]=b;Fb(276579,c+1088|0);break f}b=v[d+4>>2];b=Vc(b,e,67344,122115,b+1596|0,1,1,0);if((b|0)!=1){Eb(146922,2369);v[c+1072>>2]=b;Fb(276579,c+1072|0);break f}b=v[d+4>>2];b=Vc(b,e,18156,104585,b+1592|0,1,1,0);if((b|0)!=1){Eb(146922,2374);v[c+1056>>2]=b;Fb(276579,c+1056|0);break f}b=v[d+4>>2];b=Vc(b,e,67611,133117,b+1584|0,1,1,0);if((b|0)!=1){Eb(146922,2379);v[c+1040>>2]=b;Fb(276579,c+1040|0);break f}b=v[d+4>>2];b=fd(b,e,9885,43389,b+1548|0,1,3,1,2147483647,0,0);if((b|0)!=1){Eb(146922,2384);v[c+1024>>2]=b;Fb(276579,c+1024|0);break f}b=v[d+4>>2];b=Vc(b,e,71917,41129,b+1588|0,1,0,0);if((b|0)!=1){Eb(146922,2389);v[c+1008>>2]=b;Fb(276579,c+1008|0);break f}b=v[d+4>>2];b=Vc(b,e,41921,125895,b+1620|0,1,1,0);if((b|0)!=1){Eb(146922,2393);v[c+992>>2]=b;Fb(276579,c+992|0);break f}b=v[d+4>>2];b=ml(b,g,e,77676,79837,b+1544|0,1,100,65911);if((b|0)!=1){Eb(146922,2397);v[c+976>>2]=b;Fb(276579,c+976|0);break f}b=v[d+4>>2];b=Vc(b,e,26137,123555,b+1616|0,1,0,0);if((b|0)!=1){Eb(146922,2402);v[c+960>>2]=b;Fb(276579,c+960|0);break f}b=v[d+4>>2];b=fd(b,e,122476,79787,b+1552|0,1,0,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2407);v[c+944>>2]=b;Fb(276579,c+944|0);break f}b=v[d+4>>2];b=Kd(b,e,8987,224597,b+1624|0,0,1,0,1,0,0);if((b|0)!=1){Eb(146922,2414);v[c+928>>2]=b;Fb(276579,c+928|0);break f}b=v[d+4>>2];b=Kd(b,e,9011,224407,b+1632|0,0,0,0,1,0,0);if((b|0)!=1){Eb(146922,2419);v[c+912>>2]=b;Fb(276579,c+912|0);break f}b=v[d+4>>2];b=Kd(b,e,73955,27500,b+1640|0,0,1e4,1,1e98,0,0);if((b|0)!=1){Eb(146922,2424);v[c+896>>2]=b;Fb(276579,c+896|0);break f}b=v[d+4>>2];b=Kd(b,e,73086,71443,b+1648|0,0,10,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2429);v[c+880>>2]=b;Fb(276579,c+880|0);break f}b=v[d+4>>2];b=Kd(b,e,5167,164742,b+1656|0,0,1e-4,0,1e98,0,0);if((b|0)!=1){Eb(146922,2434);v[c+864>>2]=b;Fb(276579,c+864|0);break f}b=v[d+4>>2];b=Kd(b,e,12131,124715,b+1664|0,0,1e-4,0,1e98,0,0);if((b|0)!=1){Eb(146922,2439);v[c+848>>2]=b;Fb(276579,c+848|0);break f}b=v[d+4>>2];b=Kd(b,e,10602,237408,b+1688|0,0,.8,0,1,0,0);if((b|0)!=1){Eb(146922,2444);v[c+832>>2]=b;Fb(276579,c+832|0);break f}b=v[d+4>>2];b=ml(b,g,e,140405,234752,b+1696|0,1,101,138828);if((b|0)!=1){Eb(146922,2449);v[c+816>>2]=b;Fb(276579,c+816|0);break f}b=v[d+4>>2];b=ml(b,g,e,86615,234837,b+1697|0,1,101,128322);if((b|0)!=1){Eb(146922,2454);v[c+800>>2]=b;Fb(276579,c+800|0);break f}b=v[d+4>>2];b=ml(b,g,e,9934,215345,b+1698|0,1,97,71341);if((b|0)!=1){Eb(146922,2459);v[c+784>>2]=b;Fb(276579,c+784|0);break f}b=v[d+4>>2];b=ml(b,g,e,73058,215403,b+1699|0,1,97,71341);if((b|0)!=1){Eb(146922,2464);v[c+768>>2]=b;Fb(276579,c+768|0);break f}b=v[d+4>>2];b=Vc(b,e,92168,167159,b+1700|0,1,1,0);if((b|0)!=1){Eb(146922,2469);v[c+752>>2]=b;Fb(276579,c+752|0);break f}b=v[d+4>>2];b=fd(b,e,38466,240472,b+1704|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2474);v[c+736>>2]=b;Fb(276579,c+736|0);break f}b=v[d+4>>2];b=fd(b,e,57503,239972,b+1708|0,0,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2479);v[c+720>>2]=b;Fb(276579,c+720|0);break f}b=v[d+4>>2];b=fd(b,e,13336,239159,b+1712|0,0,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2484);v[c+704>>2]=b;Fb(276579,c+704|0);break f}b=v[d+4>>2];b=fd(b,e,74429,238315,b+1716|0,1,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2489);v[c+688>>2]=b;Fb(276579,c+688|0);break f}b=v[d+4>>2];b=fd(b,e,58469,228044,b+1720|0,1,1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2494);v[c+672>>2]=b;Fb(276579,c+672|0);break f}b=v[d+4>>2];b=fd(b,e,58251,228157,b+1724|0,0,1,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2499);v[c+656>>2]=b;Fb(276579,c+656|0);break f}b=v[d+4>>2];b=fd(b,e,13492,228297,b+1728|0,0,10,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2504);v[c+640>>2]=b;Fb(276579,c+640|0);break f}b=v[d+4>>2];b=fd(b,e,25825,229211,b+1732|0,0,100,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2509);v[c+624>>2]=b;Fb(276579,c+624|0);break f}b=v[d+4>>2];b=fd(b,e,12245,229295,b+1736|0,0,2e3,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2514);v[c+608>>2]=b;Fb(276579,c+608|0);break f}b=v[d+4>>2];b=fd(b,e,19024,27833,b+1740|0,1,80,-1,2147483647,0,0);if((b|0)!=1){Eb(146922,2519);v[c+592>>2]=b;Fb(276579,c+592|0);break f}b=v[d+4>>2];b=fd(b,e,70165,215101,b+1744|0,0,10,-1,65534,0,0);if((b|0)!=1){Eb(146922,2524);v[c+576>>2]=b;Fb(276579,c+576|0);break f}b=v[d+4>>2];b=fd(b,e,126033,210458,b+1748|0,0,1,0,1,0,0);if((b|0)!=1){Eb(146922,2531);v[c+560>>2]=b;Fb(276579,c+560|0);break f}b=v[d+4>>2];b=fd(b,e,60376,109702,b+1752|0,0,1,0,64,0,0);if((b|0)!=1){Eb(146922,2536);v[c+544>>2]=b;Fb(276579,c+544|0);break f}b=v[d+4>>2];b=fd(b,e,60355,109645,b+1756|0,0,8,0,64,0,0);if((b|0)!=1){Eb(146922,2541);v[c+528>>2]=b;Fb(276579,c+528|0);break f}b=v[d+4>>2];b=Vc(b,e,60228,176805,b+1760|0,0,1,0);if((b|0)!=1){Eb(146922,2548);v[c+512>>2]=b;Fb(276579,c+512|0);break f}b=v[d+4>>2];b=Vc(b,e,92084,176742,b+1764|0,0,1,0);if((b|0)!=1){Eb(146922,2553);v[c+496>>2]=b;Fb(276579,c+496|0);break f}b=v[d+4>>2];b=Vc(b,e,59656,175116,b+1768|0,0,1,0);if((b|0)!=1){Eb(146922,2558);v[c+480>>2]=b;Fb(276579,c+480|0);break f}b=v[d+4>>2];b=Vc(b,e,114574,170703,b+1772|0,0,1,0);if((b|0)!=1){Eb(146922,2563);v[c+464>>2]=b;Fb(276579,c+464|0);break f}b=v[d+4>>2];b=fd(b,e,137989,79565,b+1776|0,0,5131912,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2568);v[c+448>>2]=b;Fb(276579,c+448|0);break f}b=v[d+4>>2];b=Kd(b,e,18131,60486,b+1784|0,0,10,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2573);v[c+432>>2]=b;Fb(276579,c+432|0);break f}b=v[d+4>>2];b=Kd(b,e,6713,60430,b+1792|0,0,10,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2578);v[c+416>>2]=b;Fb(276579,c+416|0);break f}b=v[d+4>>2];b=Kd(b,e,63527,137929,b+1800|0,0,1.5,1,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2583);v[c+400>>2]=b;Fb(276579,c+400|0);break f}b=v[d+4>>2];b=Kd(b,e,33308,79418,b+1808|0,0,.001,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2588);v[c+384>>2]=b;Fb(276579,c+384|0);break f}b=v[d+4>>2];b=fd(b,e,43558,79638,b+1816|0,0,3,0,1e3,0,0);if((b|0)!=1){Eb(146922,2593);v[c+368>>2]=b;Fb(276579,c+368|0);break f}b=v[d+4>>2];b=fd(b,e,5600,5721,b+1824|0,1,7,0,100,0,0);if((b|0)!=1){Eb(146922,2598);v[c+352>>2]=b;Fb(276579,c+352|0);break f}b=v[d+4>>2];b=Kd(b,e,5630,138898,b+1832|0,0,10,0,17976931348623157e292,0,0);if((b|0)!=1){Eb(146922,2603);v[c+336>>2]=b;Fb(276579,c+336|0);break f}b=v[d+4>>2];b=fd(b,e,43363,178886,b+1820|0,0,10,0,2147483647,0,0);if((b|0)!=1){Eb(146922,2608);v[c+320>>2]=b;Fb(276579,c+320|0);break f}b=v[d+4>>2];b=Dz(b,e,6199,35070,b+1840|0,0,365319);if((b|0)!=1){Eb(146922,2613);v[c+304>>2]=b;Fb(276579,c+304|0);break f}b=v[d+4>>2];b=fd(b,e,116069,235970,b+1844|0,0,2,1,2,0,0);if((b|0)!=1){Eb(146922,2621);v[c+288>>2]=b;Fb(276579,c+288|0);break f}b=v[d+4>>2];b=Vc(b,e,136939,192679,b+1848|0,0,1,0);if((b|0)!=1){Eb(146922,2626);v[c+272>>2]=b;Fb(276579,c+272|0);break f}b=v[d+4>>2];b=Vc(b,e,105132,185885,b+1852|0,0,0,0);if((b|0)!=1){Eb(146922,2631);v[c+256>>2]=b;Fb(276579,c+256|0);break f}b=v[d+4>>2];b=Vc(b,e,93917,212943,b+1856|0,0,0,0);if((b|0)!=1){Eb(146922,2636);v[c+240>>2]=b;Fb(276579,c+240|0);break f}b=v[d+4>>2];b=Vc(b,e,103062,192271,b+1860|0,0,1,2123);if((b|0)!=1){Eb(146922,2641);v[c+224>>2]=b;Fb(276579,c+224|0);break f}b=v[d+4>>2];b=Vc(b,e,92435,191822,b+1864|0,0,0,0);if((b|0)!=1){Eb(146922,2646);v[c+208>>2]=b;Fb(276579,c+208|0);break f}b=v[d+4>>2];b=Dz(b,e,117563,135652,b+1880|0,0,211952);if((b|0)!=1){Eb(146922,2653);v[c+192>>2]=b;Fb(276579,c+192|0);break f}b=v[d+4>>2];b=Dz(b,e,117513,135573,b+1884|0,0,211952);if((b|0)!=1){Eb(146922,2658);v[c+176>>2]=b;Fb(276579,c+176|0);break f}b=v[d+4>>2];b=Vc(b,e,117215,178961,b+1888|0,0,1,0);if((b|0)!=1){Eb(146922,2663);v[c+160>>2]=b;Fb(276579,c+160|0);break f}b=v[d+4>>2];b=Vc(b,e,43542,188812,b+1892|0,0,0,0);if((b|0)!=1){Eb(146922,2668);v[c+144>>2]=b;Fb(276579,c+144|0);break f}b=v[d+4>>2];b=Vc(b,e,160895,188766,b+1896|0,0,0,0);if((b|0)!=1){Eb(146922,2673);v[c+128>>2]=b;Fb(276579,c+128|0);break f}b=v[d+4>>2];b=Vc(b,e,74732,184062,b+1900|0,0,1,0);if((b|0)!=1){Eb(146922,2678);v[c+112>>2]=b;Fb(276579,c+112|0);break f}b=v[d+4>>2];b=Vc(b,e,33100,181307,b+1904|0,0,1,0);if((b|0)!=1){Eb(146922,2685);v[c+96>>2]=b;Fb(276579,c+96|0);break f}b=v[d+4>>2];b=Vc(b,e,33287,183439,b+1908|0,0,1,0);if((b|0)!=1){Eb(146922,2690);v[c+80>>2]=b;Fb(276579,c+80|0);break f}b=v[d+4>>2];b=Vc(b,e,44070,194855,b+1912|0,0,0,0);if((b|0)!=1){Eb(146922,2695);v[c+64>>2]=b;Fb(276579,c- -64|0);break f}b=v[d+4>>2];b=Vc(b,e,24772,194799,b+1916|0,0,0,0);if((b|0)!=1){Eb(146922,2700);v[c+48>>2]=b;Fb(276579,c+48|0);break f}b=v[d+4>>2];b=Vc(b,e,33085,196689,b+1920|0,0,0,0);if((b|0)!=1){Eb(146922,2707);v[c+32>>2]=b;Fb(276579,c+32|0);break f}b=v[d+4>>2];b=Vc(b,e,38016,189589,b+1924|0,0,0,0);if((b|0)!=1){Eb(146922,2712);v[c+16>>2]=b;Fb(276579,c+16|0);break f}b=1;d=v[d+4>>2];d=fd(d,e,22063,181354,d+1928|0,0,0,0,1073741823,0,0);if((d|0)==1){break f}Eb(146922,2717);v[c>>2]=d;Fb(276579,c);b=d}ub=c+4528|0;if((b|0)!=1){Eb(154410,250);v[f+144>>2]=b;Fb(276579,f+144|0);break b}d=v[a>>2];b=zd(144,145585,97);v[d+8>>2]=b;h:{if(!b){Eb(145619,97);Fb(276543,0);b=-1;break h}v[b+140>>2]=0;b=1}if((b|0)!=1){Eb(154410,251);v[f+128>>2]=b;Fb(276579,f+128|0);break b}b=v[a>>2];d=zd(28,155311,348);v[b+12>>2]=d;i:{if(!d){Eb(155345,348);Fb(276543,0);b=-1;break i}v[d>>2]=0;v[v[b+12>>2]+4>>2]=0;d=v[b+12>>2];v[d+8>>2]=d+4;d=v[b+12>>2];v[d+24>>2]=-1;v[d+16>>2]=1024;d=vd(1024,1,155311,354);v[v[b+12>>2]+12>>2]=d;if(!d){Eb(155345,354);Fb(276543,0);b=-1;break i}b=v[b+12>>2];t[v[b+12>>2]]=0;v[b+20>>2]=0;b=1}if((b|0)!=1){Eb(154410,252);v[f+112>>2]=b;Fb(276579,f+112|0);break b}b=Rd(v[a>>2]+20|0,0);if((b|0)!=1){Eb(154410,253);v[f+96>>2]=b;Fb(276579,f+96|0);break b}d=v[a>>2];b=zd(80,158553,74);v[d+112>>2]=b;j:{if(!b){Eb(158587,74);Fb(276543,0);b=-1;break j}v[b+16>>2]=0;v[b+4>>2]=1;v[b+8>>2]=0;b=v[d+112>>2];v[b>>2]=1;v[b+28>>2]=0;b=1}if((b|0)!=1){Eb(154410,254);v[f+80>>2]=b;Fb(276579,f+80|0);break b}c=ub-16|0;ub=c;e=40;d=ub-16|0;ub=d;g=v[a>>2];b=KO(g,d+12|0,4811,3,4,5,6);if((b|0)!=1){Eb(144726,346);v[d>>2]=b;Fb(276579,d)}ub=d+16|0;k:{l:{if((b|0)!=1){break l}e=41;d=ub-16|0;ub=d;b=KO(g,d+12|0,202302,7,8,9,10);if((b|0)!=1){Eb(160475,384);v[d>>2]=b;Fb(276579,d)}ub=d+16|0;if((b|0)!=1){break l}e=42;d=ub-16|0;ub=d;b=KO(g,d+12|0,160962,11,12,13,14);if((b|0)!=1){Eb(160338,371);v[d>>2]=b;Fb(276579,d)}ub=d+16|0;d=1;if((b|0)==1){break k}}Eb(148123,e);v[c>>2]=b;Fb(276579,c);d=b}ub=c+16|0;b=d;if((b|0)!=1){Eb(154410,257);v[f+64>>2]=b;Fb(276579,f- -64|0);break b}b=v[a>>2];Ec(v[b+20>>2],v[b+4>>2]);c=ub-32|0;ub=c;e=v[v[a>>2]+4>>2];m:{if(Cz(e,65836)){Eb(151646,3439);Fb(342217,0);b=-9;break m}b=1;d=eH(c+28|0,e,65836,161257,0,0,2091,0);if((d|0)!=1){Eb(151646,3444);v[c+16>>2]=d;Fb(276579,c+16|0);b=d;break m}d=UE(e,v[c+28>>2]);if((d|0)==1){break m}Eb(151646,3445);v[c>>2]=d;Fb(276579,c);b=d}ub=c+32|0;if((b|0)!=1){Eb(154410,261);v[f+48>>2]=b;Fb(276579,f+48|0);break b}n:{if(!Mb(371760,166262)){break n}b=nN(v[v[a>>2]+4>>2],371760,432656);if((b|0)==1){break n}Eb(154410,265);v[f+32>>2]=b;Fb(276579,f+32|0);break b}if(!Mb(203451,166262)){b=1;break a}b=1;d=nN(v[v[a>>2]+4>>2],203451,242534);if((d|0)==1){break a}Eb(154410,269);v[f+16>>2]=d;Fb(276579,f+16|0);b=d}Eb(154410,298);v[f>>2]=b;Fb(276579,f);ne(a)}ub=f+192|0;return b}function pU(){var a=0,b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a=ub-16|0;ub=a;a:{if(Xa(a+12|0,a+8|0)|0){break a}b=Td((v[a+12>>2]<<2)+4|0);v[108930]=b;if(!b){break a}b=Td(v[a+8>>2]);if(b){v[v[108930]+(v[a+12>>2]<<2)>>2]=0;if(!(Wa(v[108930],b|0)|0)){break a}}v[108930]=0}ub=a+16|0;if(!w[448745]){c=v[100201];b=ub-16|0;ub=b;a=mD(448392);v[a+40>>2]=448448;v[a+32>>2]=c;v[a>>2]=406820;t[a+52|0]=0;v[a+48>>2]=-1;d=b+12|0;g=v[a+4>>2];v[d>>2]=g;v[g+4>>2]=v[g+4>>2]+1;g=v[v[a>>2]+8>>2];v[111924]=0;O(g|0,a|0,d|0);g=v[111924];v[111924]=0;b:{if((g|0)!=1){a=v[d>>2];d=v[a+4>>2]-1|0;v[a+4>>2]=d;if((d|0)==-1){zb[v[v[a>>2]+8>>2]](a)}ub=b+16|0;break b}d=M()|0;b=v[b+12>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}qm(a);P(d|0);p()}v[111929]=406692;v[111929]=405148;a=447716;v[111927]=404680;v[111929]=404700;v[111928]=0;v[111924]=0;O(3449,447716,448392);b=v[111924];v[111924]=0;c:{d:{if((b|0)==1){break d}g=v[100202];vY(448456,g,448504);dK(447884,448456);i=v[100200];vY(448512,i,448560);dK(448052,448512);dK(448220,v[(v[v[112013]-12>>2]+448052|0)+24>>2]);v[(v[v[111927]-12>>2]+447708|0)+72>>2]=447884;a=v[v[112013]-12>>2]+448052|0;v[a+4>>2]=v[a+4>>2]|8192;v[(v[v[112013]-12>>2]+448052|0)+72>>2]=447884;b=ub-16|0;ub=b;a=OY(448568);v[a+40>>2]=448624;v[a+32>>2]=c;v[a>>2]=407024;t[a+52|0]=0;v[a+48>>2]=-1;c=b+12|0;d=v[a+4>>2];v[c>>2]=d;v[d+4>>2]=v[d+4>>2]+1;d=v[v[a>>2]+8>>2];v[111924]=0;O(d|0,a|0,c|0);d=v[111924];v[111924]=0;e:{if((d|0)!=1){a=v[c>>2];c=v[a+4>>2]-1|0;v[a+4>>2]=c;if((c|0)==-1){zb[v[v[a>>2]+8>>2]](a)}ub=b+16|0;break e}d=M()|0;b=v[b+12>>2];c=v[b+4>>2]-1|0;v[b+4>>2]=c;if((c|0)==-1){zb[v[v[b>>2]+8>>2]](b)}wy(a);P(d|0);p()}v[111951]=406692;v[111951]=405584;a=447804;v[111949]=404928;v[111951]=404948;v[111950]=0;v[111924]=0;O(3450,447804,448568);b=v[111924];v[111924]=0;if((b|0)==1){break d}uY(448632,g,448680);cK(447968,448632);uY(448688,i,448736);cK(448136,448688);cK(448304,v[(v[v[112034]-12>>2]+448136|0)+24>>2]);v[(v[v[111949]-12>>2]+447796|0)+72>>2]=447968;a=v[v[112034]-12>>2]+448136|0;v[a+4>>2]=v[a+4>>2]|8192;v[(v[v[112034]-12>>2]+448136|0)+72>>2]=447968;break c}b=M()|0;Fh(a);P(b|0);p()}t[448745]=1}k=ub-16|0;ub=k;g=w[431032];while(1){if(!(g&1)){Wb(428632,0,2400);t[431032]=1;g=1}b=(e<<2)+428368|0;if(!v[b>>2]){f:{if(!e){a=428624;break f}a=bd(2408);g=w[431032]}v[b>>2]=a;b=a+8|0;c=a+1208|0;i=0;while(1){d=B(i,12);v[(d+c|0)+8>>2]=0;v[(b+d|0)+8>>2]=0;f=d+12|0;v[(f+c|0)+8>>2]=0;v[(b+f|0)+8>>2]=0;f=d+24|0;v[(f+c|0)+8>>2]=0;v[(b+f|0)+8>>2]=0;f=d+36|0;v[(f+c|0)+8>>2]=0;v[(b+f|0)+8>>2]=0;d=d+48|0;v[(d+c|0)+8>>2]=0;v[(b+d|0)+8>>2]=0;i=i+5|0;if((i|0)!=100){continue}break}v[a>>2]=0;v[a+4>>2]=0}e=e+1|0;if((e|0)!=64){continue}break}if(!(t[431440]&1)){v[107759]=0;a=128;while(1){b=v[107759];v[107759]=b+1;v[(b<<2)+431040>>2]=a;b=v[107759];v[107759]=b+1;c=(b<<2)+431040|0;b=B(a+1>>>1|0,3);v[c>>2]=b;c=v[107759];v[107759]=c+1;b=B(b+1>>>1|0,3);v[(c<<2)+431040>>2]=b;c=a>>>0<636291451;a=B(b+1>>>1|0,3);if(c){continue}break}t[431440]=1}Hu(Nja(0,k+12|0));a=v[107091];if(a){g=zb[a|0]()|0}else{g=0}d=0;a=w[431440];if(!(a&1)){v[107759]=0;a=128;while(1){b=v[107759];v[107759]=b+1;v[(b<<2)+431040>>2]=a;b=v[107759];v[107759]=b+1;c=(b<<2)+431040|0;b=B(a+1>>>1|0,3);v[c>>2]=b;c=v[107759];v[107759]=c+1;b=B(b+1>>>1|0,3);v[(c<<2)+431040>>2]=b;c=a>>>0<636291451;a=B(b+1>>>1|0,3);if(c){continue}break}t[431440]=1;a=1}f=v[107759];g:{if(!f){break g}if(!(a&1)){v[107759]=0;a=128;while(1){b=v[107759];v[107759]=b+1;v[(b<<2)+431040>>2]=a;b=v[107759];v[107759]=b+1;c=(b<<2)+431040|0;b=B(a+1>>>1|0,3);v[c>>2]=b;c=v[107759];v[107759]=c+1;b=B(b+1>>>1|0,3);v[(c<<2)+431040>>2]=b;c=a>>>0<636291451;a=B(b+1>>>1|0,3);if(c){continue}break}t[431440]=1}if(!(t[431032]&1)){Wb(428632,0,2400);t[431032]=1}c=(g<<2)+428368|0;b=v[c>>2];if(!b){if(g){b=bd(2408)}else{b=428624}v[c>>2]=b;a=b+8|0;i=b+1208|0;while(1){e=B(d,12);v[(e+i|0)+8>>2]=0;v[(a+e|0)+8>>2]=0;h=e+12|0;v[(h+i|0)+8>>2]=0;v[(a+h|0)+8>>2]=0;h=e+24|0;v[(h+i|0)+8>>2]=0;v[(a+h|0)+8>>2]=0;h=e+36|0;v[(h+i|0)+8>>2]=0;v[(a+h|0)+8>>2]=0;e=e+48|0;v[(e+i|0)+8>>2]=0;v[(a+e|0)+8>>2]=0;d=d+5|0;if((d|0)!=100){continue}break}v[b>>2]=0;v[b+4>>2]=0}l=f>>>0<=1?1:f;m=b+8|0;e=0;h:{if(!g){while(1){a=B(e,12)+m|0;i=a;a=v[a+8>>2];if(a){f=v[(e<<2)+431040>>2];while(1){b=v[a+8>>2];Gb(a);if(!(t[431032]&1)){Wb(428632,0,2400);t[431032]=1}a=v[c>>2];i:{if(a){d=v[a+4>>2];break i}v[c>>2]=428624;d=0;while(1){a=B(d,12);v[(a+429832|0)+8>>2]=0;v[(a+428632|0)+8>>2]=0;h=a+12|0;v[(h+429832|0)+8>>2]=0;v[(h+428632|0)+8>>2]=0;h=a+24|0;v[(h+429832|0)+8>>2]=0;v[(h+428632|0)+8>>2]=0;h=a+36|0;v[(h+429832|0)+8>>2]=0;v[(h+428632|0)+8>>2]=0;a=a+48|0;v[(a+429832|0)+8>>2]=0;v[(a+428632|0)+8>>2]=0;d=d+5|0;if((d|0)!=100){continue}break}v[107156]=0;v[107157]=0;a=428624;d=0}v[a+4>>2]=d-f;a=b;if(a){continue}break}}v[i+8>>2]=0;e=e+1|0;if((l|0)!=(e|0)){continue}break h}}while(1){a=B(e,12)+m|0;n=a;a=v[a+8>>2];if(a){o=v[(e<<2)+431040>>2];while(1){i=v[a+8>>2];Gb(a);if(!(t[431032]&1)){Wb(428632,0,2400);t[431032]=1}b=v[c>>2];j:{if(b){a=v[b+4>>2];break j}b=bd(2408);v[c>>2]=b;a=b+8|0;f=b+1208|0;d=0;while(1){h=B(d,12);v[(h+f|0)+8>>2]=0;v[(a+h|0)+8>>2]=0;j=h+12|0;v[(j+f|0)+8>>2]=0;v[(a+j|0)+8>>2]=0;j=h+24|0;v[(j+f|0)+8>>2]=0;v[(a+j|0)+8>>2]=0;j=h+36|0;v[(j+f|0)+8>>2]=0;v[(a+j|0)+8>>2]=0;h=h+48|0;v[(h+f|0)+8>>2]=0;v[(a+h|0)+8>>2]=0;d=d+5|0;if((d|0)!=100){continue}break}v[b>>2]=0;v[b+4>>2]=0;a=0}v[b+4>>2]=a-o;a=i;if(a){continue}break}}v[n+8>>2]=0;e=e+1|0;if((l|0)!=(e|0)){continue}break}}a=w[431032];if(!(a&1)){Wb(428632,0,2400);t[431032]=1;a=1}b=v[c>>2];k:{if(!b){if(g){b=bd(2408)}else{b=428624}v[c>>2]=b;a=b+8|0;i=b+1208|0;d=0;while(1){e=B(d,12);v[(e+i|0)+8>>2]=0;v[(a+e|0)+8>>2]=0;f=e+12|0;v[(f+i|0)+8>>2]=0;v[(a+f|0)+8>>2]=0;f=e+24|0;v[(f+i|0)+8>>2]=0;v[(a+f|0)+8>>2]=0;f=e+36|0;v[(f+i|0)+8>>2]=0;v[(a+f|0)+8>>2]=0;e=e+48|0;v[(e+i|0)+8>>2]=0;v[(a+e|0)+8>>2]=0;d=d+5|0;if((d|0)!=100){continue}break}v[b>>2]=0;v[b+4>>2]=0;a=w[431032];break k}if(v[b>>2]){break g}}if(!(a&1)){Wb(428632,0,2400);t[431032]=1}if(g){Gb(b)}v[c>>2]=0}v[107090]=1112;v[106957]=64;v[107091]=1113;ub=k+16|0;g=ub-32|0;ub=g;b=w[427848];v[111924]=0;c=Ma(3314)|0;a=vb;d=v[111924];v[111924]=0;l:{m:{n:{if((d|0)==1){break n}if(b){v[107864]=c;v[107865]=a;t[427848]=0}Qx();if(!(t[431476]&1)){v[107867]=0;v[107868]=0;v[107866]=431468;t[431476]=1}o:{if(v[107868]){break o}c=v[107867];p:{if(!c){b=431468;a=431468;break p}while(1){a=c;b=v[a+16>>2];if(b>>>0>=2){b=a;c=v[a>>2];if(c){continue}break p}if(b){break o}c=v[a+4>>2];if(c){continue}break}b=a+4|0}c=bd(20);v[c+8>>2]=a;v[c>>2]=0;v[c+4>>2]=0;v[c+16>>2]=1;v[b>>2]=c;a=v[v[107866]>>2];if(a){v[107866]=a;c=v[b>>2]}OB(v[107867],c);v[107868]=v[107868]+1}if(!(t[431492]&1)){v[107871]=0;v[107872]=0;v[107870]=431484;t[431492]=1}q:{if(v[107872]){break q}b=v[107871];r:{s:{if(!b){d=431484;a=431484;break s}c=b;while(1){a=c;c=v[a+16>>2];if(c>>>0>=2){d=a;c=v[a>>2];if(c){continue}break s}if(c){break r}c=v[a+4>>2];if(c){continue}break}d=a+4|0}b=bd(20);v[b+8>>2]=a;v[b>>2]=0;v[b+4>>2]=0;v[b+16>>2]=1;v[d>>2]=b;a=v[v[107870]>>2];if(a){v[107870]=a;b=v[d>>2]}OB(v[107871],b);v[107872]=v[107872]+1;b=v[107871]}t:{if(!b){c=431484;a=431484;break t}while(1){a=b;b=v[a+16>>2];if(b>>>0>=3){c=a;b=v[a>>2];if(b){continue}break t}if((b|0)==2){break q}b=v[a+4>>2];if(b){continue}break}c=a+4|0}b=bd(20);v[b+8>>2]=a;v[b>>2]=0;v[b+4>>2]=0;v[b+16>>2]=2;v[c>>2]=b;a=v[v[107870]>>2];if(a){v[107870]=a;b=v[c>>2]}OB(v[107871],b);v[107872]=v[107872]+1}a=g;v[a+20>>2]=0;v[a+24>>2]=0;v[a>>2]=32;v[a+4>>2]=1;v[a+8>>2]=1;v[a+12>>2]=1;v[111924]=0;v[a+16>>2]=1;b=N(1114,4,a+28|0)|0;c=v[111924];v[111924]=0;u:{if((c|0)!=1){v:{v[a+24>>2]=b;a=v[a+28>>2];v[g+20>>2]=a>>>2;v[b>>2]=0;v[b>>2]=v[106961];v[b>>2]=v[107874];v[111924]=0;S(1115,2)|0;c=v[111924];v[111924]=0;if((c|0)==1){break v}if(!(t[432636]&1)){v[108158]=0;v[108156]=0;v[108157]=0;t[432636]=1}if(a>>>0>=4){v[111924]=0;U(1117,b|0);a=v[111924];v[111924]=0;if((a|0)==1){break u}}ub=g+32|0;break m}}a=M()|0;w:{if(!v[g+20>>2]){break w}b=v[g+24>>2];v[111924]=0;U(1117,b|0);b=v[111924];v[111924]=0;if((b|0)!=1){break w}break n}break l}T(0)|0;md();p()}T(0)|0;md();p()}v[107089]=v[Qx()>>2];a=v[107090];x:{if(!a){break x}if(!(zb[a|0]()|0)){break x}zb[v[Qx()>>2]](1,146,71535,243073,209791)}v[Qx()>>2]=1133;if(!(t[433284]&1)){t[433284]=1;Wb(432864,0,400);t[432867]=7;t[432863]=0;a=w[101191]|w[101192]<<8|(w[101193]<<16|w[101194]<<24);t[432856]=a;t[432857]=a>>>8;t[432858]=a>>>16;t[432859]=a>>>24;a=w[101194]|w[101195]<<8|(w[101196]<<16|w[101197]<<24);t[432859]=a;t[432860]=a>>>8;t[432861]=a>>>16;t[432862]=a>>>24;v[111924]=0;Q(2384,433060,170146,70)|0;a=v[111924];v[111924]=0;y:{z:{if((a|0)==1){break z}t[433264]=0;A:{if(t[432879]<0){v[108218]=7;a=v[108217];break A}t[432879]=7;a=432868}t[a+7|0]=0;b=w[42754]|w[42755]<<8|(w[42756]<<16|w[42757]<<24);t[a+3|0]=b;t[a+4|0]=b>>>8;t[a+5|0]=b>>>16;t[a+6|0]=b>>>24;b=w[42751]|w[42752]<<8|(w[42753]<<16|w[42754]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433072,183935,66)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433265]=0;v[111924]=0;Q(2384,432880,106332,11)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433084,186454,104)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433266]=0;B:{if(t[432903]<0){v[108224]=6;a=v[108223];break B}t[432903]=6;a=432892}t[a+6|0]=0;b=w[142832]|w[142833]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[142828]|w[142829]<<8|(w[142830]<<16|w[142831]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433096,168073,72)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433267]=1;v[111924]=0;Q(2384,432904,6364,24)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433108,195284,68)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433268]=0;v[111924]=0;Q(2384,432916,85782,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433120,172966,49)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433269]=0;v[111924]=0;Q(2384,432928,92591,11)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433132,167389,82)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433270]=0;v[111924]=0;Q(2384,432940,91002,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433144,167294,94)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433271]=0;v[111924]=0;Q(2384,432952,103182,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433156,168209,65)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433272]=0;C:{if(t[432975]<0){v[108242]=6;a=v[108241];break C}t[432975]=6;a=432964}t[a+6|0]=0;b=w[142222]|w[142223]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[142218]|w[142219]<<8|(w[142220]<<16|w[142221]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433168,168146,62)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433273]=1;v[111924]=0;Q(2384,432976,103252,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433180,177181,64)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433274]=1;D:{if(t[432999]<0){v[108248]=10;a=v[108247];break D}t[432999]=10;a=432988}t[a+10|0]=0;b=w[72233]|w[72234]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[72229]|w[72230]<<8|(w[72231]<<16|w[72232]<<24);c=w[72225]|w[72226]<<8|(w[72227]<<16|w[72228]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433192,181235,71)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433275]=0;v[111924]=0;Q(2384,433e3,37828,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433204,179235,47)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433276]=0;v[111924]=0;Q(2384,433012,103234,17)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433216,191664,34)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433277]=1;v[111924]=0;Q(2384,433024,83395,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}v[111924]=0;Q(2384,433228,180793,53)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433278]=0;E:{if(t[433047]<0){v[108260]=9;a=v[108259];break E}t[433047]=9;a=433036}t[a+9|0]=0;t[a+8|0]=w[5523];b=w[5519]|w[5520]<<8|(w[5521]<<16|w[5522]<<24);c=w[5515]|w[5516]<<8|(w[5517]<<16|w[5518]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433240,170283,85)|0;a=v[111924];v[111924]=0;if((a|0)==1){break z}t[433279]=0;F:{if(t[433059]<0){v[108263]=10;a=v[108262];break F}t[433059]=10;a=433048}t[a+10|0]=0;b=w[142024]|w[142025]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[142020]|w[142021]<<8|(w[142022]<<16|w[142023]<<24);c=w[142016]|w[142017]<<8|(w[142018]<<16|w[142019]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433252,75943,60)|0;a=v[111924];v[111924]=0;if((a|0)!=1){break y}}a=M()|0;if(t[433263]<0){Gb(v[108313])}if(t[433251]<0){Gb(v[108310])}if(t[433239]<0){Gb(v[108307])}if(t[433227]<0){Gb(v[108304])}if(t[433215]<0){Gb(v[108301])}if(t[433203]<0){Gb(v[108298])}if(t[433191]<0){Gb(v[108295])}if(t[433179]<0){Gb(v[108292])}if(t[433167]<0){Gb(v[108289])}if(t[433155]<0){Gb(v[108286])}if(t[433143]<0){Gb(v[108283])}if(t[433131]<0){Gb(v[108280])}if(t[433119]<0){Gb(v[108277])}if(t[433107]<0){Gb(v[108274])}if(t[433095]<0){Gb(v[108271])}if(t[433083]<0){Gb(v[108268])}if(t[433071]<0){Gb(v[108265])}if(t[433059]<0){Gb(v[108262])}if(t[433047]<0){Gb(v[108259])}if(t[433035]<0){Gb(v[108256])}if(t[433023]<0){Gb(v[108253])}if(t[433011]<0){Gb(v[108250])}if(t[432999]<0){Gb(v[108247])}if(t[432987]<0){Gb(v[108244])}if(t[432975]<0){Gb(v[108241])}if(t[432963]<0){Gb(v[108238])}if(t[432951]<0){Gb(v[108235])}if(t[432939]<0){Gb(v[108232])}if(t[432927]<0){Gb(v[108229])}if(t[432915]<0){Gb(v[108226])}if(t[432903]<0){Gb(v[108223])}if(t[432891]<0){Gb(v[108220])}if(t[432879]<0){Gb(v[108217])}if(t[432867]<0){Gb(v[108214])}break l}t[433280]=0}if(!(t[434368]&1)){t[434368]=1;Wb(433296,0,712);v[108322]=1936351855;v[108323]=1702063717;t[433299]=8;v[111924]=0;Q(2384,433648,234183,46)|0;a=v[111924];v[111924]=0;G:{H:{if((a|0)==1){break H}v[108562]=1;v[108532]=-1;v[108502]=1;v[111924]=0;Q(2384,433300,80501,14)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433660,229122,88)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108563]=2;v[108533]=0;v[108503]=0;I:{if(t[433323]<0){v[108329]=9;a=v[108328];break I}t[433323]=9;a=433312}t[a+9|0]=0;t[a+8|0]=w[87608];b=w[87604]|w[87605]<<8|(w[87606]<<16|w[87607]<<24);c=w[87600]|w[87601]<<8|(w[87602]<<16|w[87603]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433672,231201,40)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108564]=1;v[108534]=0;v[108504]=1;v[111924]=0;Q(2384,433324,116198,18)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433684,235145,61)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108565]=1;v[108535]=0;v[108505]=1;v[111924]=0;Q(2384,433336,6760,17)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433696,227043,67)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108566]=2147483647;v[108536]=0;v[108506]=0;J:{if(t[433359]<0){v[108338]=9;a=v[108337];break J}t[433359]=9;a=433348}t[a+9|0]=0;t[a+8|0]=w[18488];b=w[18484]|w[18485]<<8|(w[18486]<<16|w[18487]<<24);c=w[18480]|w[18481]<<8|(w[18482]<<16|w[18483]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433708,221094,31)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108567]=2147483647;v[108537]=-1;v[108507]=-1;K:{if(t[433371]<0){v[108341]=8;a=v[108340];break K}t[433371]=8;a=433360}t[a+8|0]=0;t[a|0]=114;t[a+1|0]=101;t[a+2|0]=102;t[a+3|0]=108;t[a+4|0]=105;t[a+5|0]=109;t[a+6|0]=105;t[a+7|0]=116;v[111924]=0;Q(2384,433720,221061,32)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108568]=2147483647;v[108538]=-1;v[108508]=-1;v[111924]=0;Q(2384,433372,18865,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433732,221052,41)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108569]=2147483647;v[108539]=-1;v[108509]=-1;v[111924]=0;Q(2384,433384,69802,11)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433744,4936,17)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108570]=2147483647;v[108540]=1;v[108510]=200;L:{if(t[433407]<0){v[108350]=9;a=v[108349];break L}t[433407]=9;a=433396}t[a+9|0]=0;t[a+8|0]=w[1623];b=w[1619]|w[1620]<<8|(w[1621]<<16|w[1622]<<24);c=w[1615]|w[1616]<<8|(w[1617]<<16|w[1618]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433756,230483,83)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108571]=5;v[108541]=0;v[108511]=3;M:{if(t[433419]<0){v[108353]=10;a=v[108352];break M}t[433419]=10;a=433408}t[a+10|0]=0;b=w[67659]|w[67660]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[67655]|w[67656]<<8|(w[67657]<<16|w[67658]<<24);c=w[67651]|w[67652]<<8|(w[67653]<<16|w[67654]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433768,231242,56)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108572]=3;v[108542]=0;v[108512]=3;N:{if(t[433431]<0){v[108356]=6;a=v[108355];break N}t[433431]=6;a=433420}t[a+6|0]=0;b=w[67565]|w[67566]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[67561]|w[67562]<<8|(w[67563]<<16|w[67564]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433780,230135,143)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108573]=6;v[108543]=0;v[108513]=2;O:{if(t[433443]<0){v[108359]=7;a=v[108358];break O}t[433443]=7;a=433432}t[a+7|0]=0;b=w[66657]|w[66658]<<8|(w[66659]<<16|w[66660]<<24);t[a+3|0]=b;t[a+4|0]=b>>>8;t[a+5|0]=b>>>16;t[a+6|0]=b>>>24;b=w[66654]|w[66655]<<8|(w[66656]<<16|w[66657]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433792,225449,92)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108574]=3;v[108544]=0;v[108514]=0;P:{if(t[433455]<0){v[108362]=6;a=v[108361];break P}t[433455]=6;a=433444}t[a+6|0]=0;b=w[68790]|w[68791]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[68786]|w[68787]<<8|(w[68788]<<16|w[68789]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433804,226575,89)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108575]=5;v[108545]=0;v[108515]=0;v[111924]=0;Q(2384,433456,66632,11)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433816,232725,77)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108576]=3;v[108546]=0;v[108516]=3;Q:{if(t[433479]<0){v[108368]=8;a=v[108367];break Q}t[433479]=8;a=433468}t[a+8|0]=0;t[a|0]=115;t[a+1|0]=121;t[a+2|0]=110;t[a+3|0]=99;t[a+4|0]=109;t[a+5|0]=111;t[a+6|0]=100;t[a+7|0]=101;v[111924]=0;Q(2384,433828,231110,90)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108577]=2;v[108547]=0;v[108517]=0;R:{if(t[433491]<0){v[108371]=8;a=v[108370];break R}t[433491]=8;a=433480}t[a+8|0]=0;t[a|0]=114;t[a+1|0]=101;t[a+2|0]=97;t[a+3|0]=100;t[a+4|0]=109;t[a+5|0]=111;t[a+6|0]=100;t[a+7|0]=101;v[111924]=0;Q(2384,433840,231299,60)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108578]=1;v[108548]=0;v[108518]=0;S:{if(t[433503]<0){v[108374]=9;a=v[108373];break S}t[433503]=9;a=433492}t[a+9|0]=0;t[a+8|0]=w[126031];b=w[126027]|w[126028]<<8|(w[126029]<<16|w[126030]<<24);c=w[126023]|w[126024]<<8|(w[126025]<<16|w[126026]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433852,234315,101)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108579]=2;v[108549]=0;v[108519]=1;T:{if(t[433515]<0){v[108377]=9;a=v[108376];break T}t[433515]=9;a=433504}t[a+9|0]=0;t[a+8|0]=w[126021];b=w[126017]|w[126018]<<8|(w[126019]<<16|w[126020]<<24);c=w[126013]|w[126014]<<8|(w[126015]<<16|w[126016]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433864,231367,103)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108580]=2;v[108550]=0;v[108520]=1;U:{if(t[433527]<0){v[108380]=5;a=v[108379];break U}t[433527]=5;a=433516}t[a+5|0]=0;t[a+4|0]=w[67379];b=w[67375]|w[67376]<<8|(w[67377]<<16|w[67378]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,433876,232803,77)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108581]=2;v[108551]=0;v[108521]=1;v[111924]=0;Q(2384,433528,105147,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433888,221496,61)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108582]=2;v[108552]=0;v[108522]=1;v[111924]=0;Q(2384,433540,44115,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433900,79e3,89)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108583]=2147483647;v[108553]=0;v[108523]=2;v[111924]=0;Q(2384,433552,56987,17)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433912,103582,71)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108584]=2147483647;v[108554]=0;v[108524]=50;v[111924]=0;Q(2384,433564,103945,18)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433924,231591,79)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108585]=2;v[108555]=0;v[108525]=0;v[111924]=0;Q(2384,433576,18441,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433936,135074,92)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108586]=2147483647;v[108556]=1;v[108526]=100;v[111924]=0;Q(2384,433588,24752,19)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433948,6417,103)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108587]=2147483647;v[108557]=1;v[108527]=500;v[111924]=0;Q(2384,433600,69795,18)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433960,210108,78)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108588]=2147483647;v[108558]=1;v[108528]=50;v[111924]=0;Q(2384,433612,1608,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433972,211163,113)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108589]=5;v[108559]=1;v[108529]=0;v[111924]=0;Q(2384,433624,142027,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[111924]=0;Q(2384,433984,227772,114)|0;a=v[111924];v[111924]=0;if((a|0)==1){break H}v[108590]=3;v[108560]=-1;v[108530]=-1;V:{if(t[433647]<0){v[108410]=9;a=v[108409];break V}t[433647]=9;a=433636}t[a+9|0]=0;t[a+8|0]=w[67379];b=w[67375]|w[67376]<<8|(w[67377]<<16|w[67378]<<24);c=w[67371]|w[67372]<<8|(w[67373]<<16|w[67374]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,433996,235877,92)|0;a=v[111924];v[111924]=0;if((a|0)!=1){break G}}a=M()|0;if(t[434007]<0){Gb(v[108499])}if(t[433995]<0){Gb(v[108496])}if(t[433983]<0){Gb(v[108493])}if(t[433971]<0){Gb(v[108490])}if(t[433959]<0){Gb(v[108487])}if(t[433947]<0){Gb(v[108484])}if(t[433935]<0){Gb(v[108481])}if(t[433923]<0){Gb(v[108478])}if(t[433911]<0){Gb(v[108475])}if(t[433899]<0){Gb(v[108472])}if(t[433887]<0){Gb(v[108469])}if(t[433875]<0){Gb(v[108466])}if(t[433863]<0){Gb(v[108463])}if(t[433851]<0){Gb(v[108460])}if(t[433839]<0){Gb(v[108457])}if(t[433827]<0){Gb(v[108454])}if(t[433815]<0){Gb(v[108451])}if(t[433803]<0){Gb(v[108448])}if(t[433791]<0){Gb(v[108445])}if(t[433779]<0){Gb(v[108442])}if(t[433767]<0){Gb(v[108439])}if(t[433755]<0){Gb(v[108436])}if(t[433743]<0){Gb(v[108433])}if(t[433731]<0){Gb(v[108430])}if(t[433719]<0){Gb(v[108427])}if(t[433707]<0){Gb(v[108424])}if(t[433695]<0){Gb(v[108421])}if(t[433683]<0){Gb(v[108418])}if(t[433671]<0){Gb(v[108415])}if(t[433659]<0){Gb(v[108412])}if(t[433647]<0){Gb(v[108409])}if(t[433635]<0){Gb(v[108406])}if(t[433623]<0){Gb(v[108403])}if(t[433611]<0){Gb(v[108400])}if(t[433599]<0){Gb(v[108397])}if(t[433587]<0){Gb(v[108394])}if(t[433575]<0){Gb(v[108391])}if(t[433563]<0){Gb(v[108388])}if(t[433551]<0){Gb(v[108385])}if(t[433539]<0){Gb(v[108382])}if(t[433527]<0){Gb(v[108379])}if(t[433515]<0){Gb(v[108376])}if(t[433503]<0){Gb(v[108373])}if(t[433491]<0){Gb(v[108370])}if(t[433479]<0){Gb(v[108367])}if(t[433467]<0){Gb(v[108364])}if(t[433455]<0){Gb(v[108361])}if(t[433443]<0){Gb(v[108358])}if(t[433431]<0){Gb(v[108355])}if(t[433419]<0){Gb(v[108352])}if(t[433407]<0){Gb(v[108349])}if(t[433395]<0){Gb(v[108346])}if(t[433383]<0){Gb(v[108343])}if(t[433371]<0){Gb(v[108340])}if(t[433359]<0){Gb(v[108337])}if(t[433347]<0){Gb(v[108334])}if(t[433335]<0){Gb(v[108331])}if(t[433323]<0){Gb(v[108328])}if(t[433311]<0){Gb(v[108325])}if(t[433299]<0){Gb(v[108322])}break l}v[108591]=2;v[108561]=0;v[108531]=1}if(!(t[435624]&1)){t[435624]=1;Wb(434384,0,616);t[434387]=7;t[434383]=0;a=w[89619]|w[89620]<<8|(w[89621]<<16|w[89622]<<24);t[434376]=a;t[434377]=a>>>8;t[434378]=a>>>16;t[434379]=a>>>24;a=w[89622]|w[89623]<<8|(w[89624]<<16|w[89625]<<24);t[434379]=a;t[434380]=a>>>8;t[434381]=a>>>16;t[434382]=a>>>24;v[111924]=0;Q(2384,434688,127495,28)|0;a=v[111924];v[111924]=0;W:{X:{if((a|0)==1){break X}v[108854]=0;v[108855]=1072693248;v[108802]=0;v[108803]=0;v[108750]=-1598689907;v[108751]=1051772663;Y:{if(t[434399]<0){v[108598]=6;a=v[108597];break Y}t[434399]=6;a=434388}t[a+6|0]=0;b=w[89508]|w[89509]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[89504]|w[89505]<<8|(w[89506]<<16|w[89507]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,434700,127468,26)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108856]=0;v[108857]=1072693248;v[108804]=0;v[108805]=0;v[108752]=-1598689907;v[108753]=1051772663;v[111924]=0;Q(2384,434400,73601,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434712,127819,22)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108858]=0;v[108859]=1072693248;v[108806]=0;v[108807]=0;v[108754]=-1747416644;v[108755]=1016910514;v[111924]=0;Q(2384,434412,78624,21)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434724,78963,36)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108860]=0;v[108861]=1072693248;v[108808]=0;v[108809]=0;v[108756]=210911779;v[108757]=1002937505;v[111924]=0;Q(2384,434424,113820,14)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434736,79207,50)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108862]=0;v[108863]=1072693248;v[108810]=0;v[108811]=0;v[108758]=-1747416644;v[108759]=1016910514;v[111924]=0;Q(2384,434436,10588,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434748,78957,42)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108864]=0;v[108865]=1072693248;v[108812]=0;v[108813]=0;v[108760]=-640172613;v[108761]=1037794527;Z:{if(t[434459]<0){v[108613]=5;a=v[108612];break Z}t[434459]=5;a=434448}t[a+5|0]=0;t[a+4|0]=w[3416];b=w[3412]|w[3413]<<8|(w[3414]<<16|w[3415]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,434760,132187,18)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108866]=630506365;v[108867]=1420970413;v[108814]=536870912;v[108815]=1107468383;v[108762]=630506365;v[108763]=1420970413;_:{if(t[434471]<0){v[108616]=9;a=v[108615];break _}t[434471]=9;a=434460}t[a+9|0]=0;t[a+8|0]=w[19007];b=w[19003]|w[19004]<<8|(w[19005]<<16|w[19006]<<24);c=w[18999]|w[19e3]<<8|(w[19001]<<16|w[19002]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,434772,59634,21)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108868]=630506365;v[108869]=1420970413;v[108816]=0;v[108817]=0;v[108764]=630506365;v[108765]=1420970413;v[111924]=0;Q(2384,434472,66040,14)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434784,111850,30)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108870]=630506365;v[108871]=1420970413;v[108818]=630506365;v[108819]=-726513235;v[108766]=630506365;v[108767]=-726513235;v[111924]=0;Q(2384,434484,67298,14)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434796,111881,30)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108872]=630506365;v[108873]=1420970413;v[108820]=630506365;v[108821]=-726513235;v[108768]=630506365;v[108769]=1420970413;$:{if(t[434507]<0){v[108625]=9;a=v[108624];break $}t[434507]=9;a=434496}t[a+9|0]=0;t[a+8|0]=w[89558];b=w[89554]|w[89555]<<8|(w[89556]<<16|w[89557]<<24);c=w[89550]|w[89551]<<8|(w[89552]<<16|w[89553]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,434808,15871,86)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108874]=0;v[108875]=1072693248;v[108822]=-2127697391;v[108823]=1030854553;v[108770]=-400107883;v[108771]=1041313291;aa:{if(t[434519]<0){v[108628]=8;a=v[108627];break aa}t[434519]=8;a=434508}t[a+8|0]=0;t[a|0]=102;t[a+1|0]=112;t[a+2|0]=111;t[a+3|0]=112;t[a+4|0]=116;t[a+5|0]=116;t[a+6|0]=111;t[a+7|0]=108;v[111924]=0;Q(2384,434820,15958,85)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108876]=0;v[108877]=1072693248;v[108824]=-2127697391;v[108825]=1030854553;v[108772]=-400107883;v[108773]=1041313291;v[111924]=0;Q(2384,434520,68908,12)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434832,31496,55)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108878]=630506365;v[108879]=1420970413;v[108826]=0;v[108827]=1072693248;v[108774]=740819601;v[108775]=1159760682;ba:{if(t[434543]<0){v[108634]=10;a=v[108633];break ba}t[434543]=10;a=434532}t[a+10|0]=0;b=w[92353]|w[92354]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[92349]|w[92350]<<8|(w[92351]<<16|w[92352]<<24);c=w[92345]|w[92346]<<8|(w[92347]<<16|w[92348]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,434844,240791,105)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108880]=-1717986918;v[108881]=1069128089;v[108828]=0;v[108829]=0;v[108776]=-316718722;v[108777]=1062207486;ca:{if(t[434555]<0){v[108637]=10;a=v[108636];break ca}t[434555]=10;a=434544}t[a+10|0]=0;b=w[92254]|w[92255]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[92250]|w[92251]<<8|(w[92252]<<16|w[92253]<<24);c=w[92246]|w[92247]<<8|(w[92248]<<16|w[92249]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,434856,240791,105)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108882]=630506365;v[108883]=1420970413;v[108830]=0;v[108831]=1076101120;v[108778]=0;v[108779]=1083179008;v[111924]=0;Q(2384,434556,132168,18)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434868,233735,96)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108884]=0;v[108885]=1072693248;v[108832]=0;v[108833]=0;v[108780]=858993459;v[108781]=1071854387;v[111924]=0;Q(2384,434568,97494,21)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434880,126047,111)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108886]=630506365;v[108887]=1420970413;v[108834]=0;v[108835]=0;v[108782]=858993459;v[108783]=1072902963;v[111924]=0;Q(2384,434580,70540,11)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434892,76964,61)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108888]=630506365;v[108889]=1420970413;v[108836]=0;v[108837]=1072693248;v[108784]=858993459;v[108785]=1072902963;da:{if(t[434603]<0){v[108649]=6;a=v[108648];break da}t[434603]=6;a=434592}t[a+6|0]=0;b=w[136106]|w[136107]<<8;t[a+4|0]=b;t[a+5|0]=b>>>8;b=w[136102]|w[136103]<<8|(w[136104]<<16|w[136105]<<24);t[a|0]=b;t[a+1|0]=b>>>8;t[a+2|0]=b>>>16;t[a+3|0]=b>>>24;v[111924]=0;Q(2384,434904,83260,71)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108890]=0;v[108891]=1072693248;v[108838]=0;v[108839]=0;v[108786]=-350469331;v[108787]=1058682594;v[111924]=0;Q(2384,434604,1340,15)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434916,5981,96)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108892]=0;v[108893]=1079574528;v[108840]=0;v[108841]=1072693248;v[108788]=0;v[108789]=1076101120;v[111924]=0;Q(2384,434616,91183,17)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434928,78646,97)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108894]=0;v[108895]=1079574528;v[108842]=0;v[108843]=1072693248;v[108790]=0;v[108791]=1075052544;v[111924]=0;Q(2384,434628,64019,16)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434940,78176,80)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108896]=0;v[108897]=1076101120;v[108844]=0;v[108845]=1072693248;v[108792]=0;v[108793]=1073217536;v[111924]=0;Q(2384,434640,4907,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434952,222851,102)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108898]=630506365;v[108899]=1420970413;v[108846]=0;v[108847]=1072693248;v[108794]=0;v[108795]=1083129856;ea:{if(t[434663]<0){v[108664]=10;a=v[108663];break ea}t[434663]=10;a=434652}t[a+10|0]=0;b=w[22205]|w[22206]<<8;t[a+8|0]=b;t[a+9|0]=b>>>8;b=w[22201]|w[22202]<<8|(w[22203]<<16|w[22204]<<24);c=w[22197]|w[22198]<<8|(w[22199]<<16|w[22200]<<24);t[a|0]=c;t[a+1|0]=c>>>8;t[a+2|0]=c>>>16;t[a+3|0]=c>>>24;t[a+4|0]=b;t[a+5|0]=b>>>8;t[a+6|0]=b>>>16;t[a+7|0]=b>>>24;v[111924]=0;Q(2384,434964,135895,27)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108900]=630506365;v[108901]=1420970413;v[108848]=630506365;v[108849]=-726513235;v[108796]=0;v[108797]=0;v[111924]=0;Q(2384,434664,1319,13)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434976,79336,47)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[108902]=1223206686;v[108903]=1072693038;v[108850]=-350469331;v[108851]=1058682594;v[108798]=1202590843;v[108799]=1065646817;v[111924]=0;Q(2384,434676,142584,23)|0;a=v[111924];v[111924]=0;if((a|0)==1){break X}v[111924]=0;Q(2384,434988,100367,132)|0;a=v[111924];v[111924]=0;if((a|0)!=1){break W}}a=M()|0;if(t[434999]<0){Gb(v[108747])}if(t[434987]<0){Gb(v[108744])}if(t[434975]<0){Gb(v[108741])}if(t[434963]<0){Gb(v[108738])}if(t[434951]<0){Gb(v[108735])}if(t[434939]<0){Gb(v[108732])}if(t[434927]<0){Gb(v[108729])}if(t[434915]<0){Gb(v[108726])}if(t[434903]<0){Gb(v[108723])}if(t[434891]<0){Gb(v[108720])}if(t[434879]<0){Gb(v[108717])}if(t[434867]<0){Gb(v[108714])}if(t[434855]<0){Gb(v[108711])}if(t[434843]<0){Gb(v[108708])}if(t[434831]<0){Gb(v[108705])}if(t[434819]<0){Gb(v[108702])}if(t[434807]<0){Gb(v[108699])}if(t[434795]<0){Gb(v[108696])}if(t[434783]<0){Gb(v[108693])}if(t[434771]<0){Gb(v[108690])}if(t[434759]<0){Gb(v[108687])}if(t[434747]<0){Gb(v[108684])}if(t[434735]<0){Gb(v[108681])}if(t[434723]<0){Gb(v[108678])}if(t[434711]<0){Gb(v[108675])}if(t[434699]<0){Gb(v[108672])}if(t[434687]<0){Gb(v[108669])}if(t[434675]<0){Gb(v[108666])}if(t[434663]<0){Gb(v[108663])}if(t[434651]<0){Gb(v[108660])}if(t[434639]<0){Gb(v[108657])}if(t[434627]<0){Gb(v[108654])}if(t[434615]<0){Gb(v[108651])}if(t[434603]<0){Gb(v[108648])}if(t[434591]<0){Gb(v[108645])}if(t[434579]<0){Gb(v[108642])}if(t[434567]<0){Gb(v[108639])}if(t[434555]<0){Gb(v[108636])}if(t[434543]<0){Gb(v[108633])}if(t[434531]<0){Gb(v[108630])}if(t[434519]<0){Gb(v[108627])}if(t[434507]<0){Gb(v[108624])}if(t[434495]<0){Gb(v[108621])}if(t[434483]<0){Gb(v[108618])}if(t[434471]<0){Gb(v[108615])}if(t[434459]<0){Gb(v[108612])}if(t[434447]<0){Gb(v[108609])}if(t[434435]<0){Gb(v[108606])}if(t[434423]<0){Gb(v[108603])}if(t[434411]<0){Gb(v[108600])}if(t[434399]<0){Gb(v[108597])}if(t[434387]<0){Gb(v[108594])}break l}v[108904]=0;v[108905]=1072693248;v[108852]=0;v[108853]=0;v[108800]=0;v[108801]=1072693248}t[432742]=32;u[216370]=14952;v[108184]=1935755380;v[108182]=694510638;v[108183]=1766284064;v[108180]=2019912816;v[108181]=1651079726;v[108178]=1852402802;v[108179]=1869817888;v[108176]=1953854569;v[108177]=1698832485;v[108174]=543519605;v[108175]=1953721929;v[108172]=543450480;v[108173]=1512076385;v[108170]=1701060722;v[108171]=1869374838;v[108168]=1394632558;v[108169]=1702259823;v[108166]=1919381362;v[108167]=1768779105;v[108164]=1701734732;v[108165]=1344303713;t[432743]=w[202082];t[432744]=w[202083];t[432745]=w[202084];t[432746]=w[202085];t[432747]=w[202086];t[432748]=w[202087];t[432749]=w[202088];a=w[202089];t[432751]=93;t[432750]=a;Wb(432752,0,104);v[108927]=rv(2);v[108988]=435756;v[108970]=42;return}P(a|0);p()}function sfb(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,u,y,z,C,E,F,G,H){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;u=u|0;y=y|0;z=z|0;C=C|0;E=E|0;F=F|0;G=G|0;H=H|0;var I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0;g=ub-432|0;ub=g;m=v[G>>2];n=v[F>>2];o=v[E>>2];p=v[z>>2];s=v[u>>2];y=v[r>>2];ka=v[q>>2];j=v[b+328>>2];b=v[j+4>>2];a:{if((b|0)>0){I=v[j>>2];while(1){f=b;b:{b=b-1|0;i=v[I+(b<<2)>>2];if(!(t[i+40|0]&1)|!v[i+36>>2]){break b}l=v[i+12>>2];if(!l){break b}e=v[i>>2];if(w[e+86|0]&8){break b}J=v[i+8>>2];c:{d:{e:{if(Mb(v[v[e+12>>2]+192>>2],132048)){Eb(159617,5210);Fb(256182,0);e=0;break e}e=x[v[e+16>>2]+48>>1]>>>4&1}if(e){break d}e=v[i>>2];f:{if(Mb(v[v[e+12>>2]+192>>2],132048)){Eb(159617,5234);Fb(256182,0);h=-9;break f}Ix(v[e+16>>2]);h=1}if((h|0)==1){break d}a=4132;break c}e=nj(v[i>>2]);k=el(v[i>>2]);if((e|0)<=0){break b}if((e|0)==(l|0)){while(1){if((l|0)<=0){break b}l=l-1|0;h=l<<2;if(v[h+J>>2]==v[h+k>>2]){continue}break}}g:{if(v[i+28>>2]>=(e|0)){break g}h=ng(a,i+20|0,4,i+28|0,e);if((h|0)==1){break g}a=4177;break c}Ld(v[i+20>>2],k,e<<2);v[i+24>>2]=e;while(1){if((e|0)<=0){break b}e=e-1|0;h=v[v[i+20>>2]+(e<<2)>>2];v[h+320>>2]=v[h+320>>2]+1;continue}}Eb(152876,a);v[g+352>>2]=h;Fb(276579,g+352|0);Eb(152876,8441);v[g+336>>2]=h;Fb(276579,g+336|0);break a}if((f|0)>1){continue}break}}v[g+400>>2]=0;h:{if((d|0)<=0){break h}k=2147483647;l=0;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break h}i:{j:{k:{l:{P=v[(l<<2)+c>>2];_=v[P+16>>2];b=v[_+16>>2];if(w[b+86|0]&8){b=v[P+84>>2];m:{if(!(b&4194304)&(b&8404992)!=16384){break m}b=v[_+40>>2];if((b|0)<=0){break m}f=v[_+28>>2];while(1){e=b-1|0;h=v[f+(e<<2)>>2];if(t[h+40|0]&1){h=Vk(a,v[h>>2],v[P+84>>2]>>>3&1);if((h|0)!=1){break l}}h=b>>>0>1;b=e;if(h){continue}break}}h=pc(a,P);if((h|0)==1){break j}f=8478;break k}h=iC(a,b,v[_+20>>2],g+416|0,g+368|0);f=8484;if((h|0)!=1){break k}b=v[_+16>>2];n:{o:{switch(v[_+20>>2]){case 1:b=of(b);break n;case 2:b=bh(b);break n;case 3:b=wg(b);break n;default:Eb(152876,544);Fb(285412,0);h=-9;f=8490;break k;case 0:break o}}b=Re(b)}v[g+412>>2]=b;e=Ib(v[v[a>>2]+8>>2],b,4,152842,8493);v[g+428>>2]=e;h=-1;f=8493;if(!e){break k}e=Ib(v[v[a>>2]+8>>2],b,8,152842,8494);v[g+424>>2]=e;f=8494;if(!e){break k}e=Ib(v[v[a>>2]+8>>2],b,4,152842,8495);v[g+408>>2]=e;f=8495;if(!e){break k}e=Ib(v[v[a>>2]+8>>2],b,8,152842,8496);v[g+404>>2]=e;f=8496;if(!e){break k}e=Ib(v[v[a>>2]+8>>2],b,4,152842,8497);v[g+392>>2]=e;f=8497;if(!e){break k}e=Ib(v[v[a>>2]+8>>2],b,8,152842,8498);v[g+388>>2]=e;f=8498;if(!e){break k}b=Ib(v[v[a>>2]+8>>2],b,4,152842,8499);v[g+384>>2]=b;f=8499;if(!b){break k}h=lm(v[_+16>>2],v[_+20>>2],v[g+428>>2],v[g+424>>2],g+412|0);f=8502;if((h|0)!=1){break k}Ao(P,v[g+428>>2],v[g+424>>2],v[g+412>>2],v[g+408>>2],v[g+404>>2],g+396|0,v[g+392>>2],v[g+388>>2],v[g+384>>2],g+380|0);W=A[g+416>>3];$=A[g+368>>3];fa=v[g+392>>2];Y=v[g+388>>2];V=v[g+384>>2];J=v[g+380>>2];e=0;b=0;M=0;I=ub-272|0;ub=I;i=v[P+16>>2];yQ(v[i+28>>2],v[i+32>>2],v[i+36>>2],584,v[i+40>>2]);U=v[i+36>>2];K=v[i+32>>2];ga=v[i+28>>2];O=v[i+40>>2];X=O+J|0;Q=Tb(v[v[a>>2]+4>>2],X,4,152842,4346);p:{if(!Q){Eb(152876,4346);f=-1;v[I>>2]=-1;Fb(276579,I);break p}N=Tb(v[v[a>>2]+4>>2],X,8,152842,4347);if(!N){Eb(152876,4347);f=-1;v[I+16>>2]=-1;Fb(276579,I+16|0);break p}q:{r:{R=Tb(v[v[a>>2]+4>>2],X,4,152842,4348);if(R){L=(J|0)>0;f=(O|0)>0;s:{if((O|0)<=0|(J|0)<=0){break s}la=-W;while(1){f=e<<2;h=f+ga|0;L=v[h>>2];t:{u:{if(!(t[L+40|0]&1)){t[i+64|0]=w[i+64|0]&221|2;break u}S=v[L>>2];if(!S){t[i+64|0]=w[i+64|0]&221|2;break u}if(w[S+86|0]&8){T=A[K+(e<<3)>>3];f=hC(a,P,L,v[f+U>>2]?-T:T,A[i>>3],A[i+8>>3]);if((f|0)!=1){Eb(152876,4384);v[I+256>>2]=f;Fb(276579,I+256|0);break p}t[i+64|0]=w[i+64|0]&221|2;break u}L=v[og(S)+288>>2];S=M<<2;Z=v[S+fa>>2];aa=v[Z+288>>2];if((L|0)<(aa|0)){h=v[h>>2];v[h+36>>2]=v[h+36>>2]-1;T=A[K+(e<<3)>>3];f=hC(a,P,h,v[f+U>>2]?-T:T,A[i>>3],A[i+8>>3]);if((f|0)!=1){Eb(152876,4217);v[I+144>>2]=f;Fb(276579,I+144|0);Eb(152876,4410);v[I+128>>2]=f;Fb(276579,I+128|0);break p}t[i+64|0]=w[i+64|0]&209|2;break u}if((L|0)>(aa|0)){h=b<<2;f=Ac(v[j+20>>2],Z);v[h+Q>>2]=f;T=A[Y+(M<<3)>>3];A[N+(b<<3)>>3]=T;h=h+R|0;v[h>>2]=v[S+V>>2];v[f+36>>2]=v[f+36>>2]+1;f=mU(a,P,f,v[h>>2]?-T:T,W,$);if((f|0)!=1){Eb(152876,4245);v[I+176>>2]=f;Fb(276579,I+176|0);Eb(152876,4427);v[I+160>>2]=f;Fb(276579,I+160|0);break p}t[i+64|0]=w[i+64|0]&193|2;b=b+1|0;M=M+1|0;break t}L=b<<2;Z=L+Q|0;v[Z>>2]=v[h>>2];ha=N+(b<<3)|0;ea=M<<3;h=ea+Y|0;A[ha>>3]=A[h>>3];ia=L+R|0;ja=S+V|0;aa=v[ja>>2];v[ia>>2]=aa;f=f+U|0;L=v[f>>2];v:{w:{if((aa|0)==(L|0)){if(!(A[v[a+4>>2]+1280>>3]>=D(A[K+(e<<3)>>3]-A[N+ea>>3]))){break w}}if(v[R+S>>2]==(L|0)|A[v[a+4>>2]+1280>>3]>=D(A[K+(e<<3)>>3]+A[N+ea>>3])){break v}}t[i+64|0]=w[i+64|0]&223;aa=v[ja>>2];L=v[f>>2]}T=A[K+(e<<3)>>3];x:{if((L|0)==(aa|0)){if(T<0){f=1;if(A[h>>3]>0){break x}}if(T>0){f=1;if(A[h>>3]<0){break x}}f=0;break x}if(T<0){f=1;if(A[h>>3]<0){break x}}f=0;if(!(T>0)){break x}f=A[h>>3]>0}h=f;S=1;ba=A[v[a+4>>2]+1272>>3];ca=A[i>>3];if(!(ba<=-ca^ba<=la|ca<0&W>0)){S=W<0&ca>0}da=A[i+8>>3];y:{z:{if(da>=ba^$>=ba|da<0&$>0){f=v[Z>>2];break z}f=v[Z>>2];if($<0&da>0|(h|S)){break z}if(v[f+24>>2]<=0){break y}}f=hC(a,P,f,L?-T:T,ca,da);if((f|0)!=1){Eb(152876,4217);v[I+240>>2]=f;Fb(276579,I+240|0);Eb(152876,4469);v[I+224>>2]=f;Fb(276579,I+224|0);break p}T=A[ha>>3];f=mU(a,P,v[Z>>2],v[ia>>2]?-T:T,W,$);if((f|0)!=1){Eb(152876,4245);v[I+208>>2]=f;Fb(276579,I+208|0);Eb(152876,4471);v[I+192>>2]=f;Fb(276579,I+192|0);break p}t[i+64|0]=w[i+64|0]&193|2}b=b+1|0;M=M+1|0}e=e+1|0}L=(J|0)>(M|0);f=(e|0)<(O|0);if((e|0)>=(O|0)){break s}if(L){continue}break}}if(!f){break r}if((e|0)>=(O|0)){break q}while(1){A:{h=e<<2;f=v[h+ga>>2];if(!v[f>>2]){M=221;break A}v[f+36>>2]=v[f+36>>2]-1;M=209;T=A[K+(e<<3)>>3];f=hC(a,P,f,v[h+U>>2]?-T:T,A[i>>3],A[i+8>>3]);if((f|0)==1){break A}Eb(152876,4217);v[I+80>>2]=f;Fb(276579,I+80|0);Eb(152876,4520);v[I+64>>2]=f;Fb(276579,I- -64|0);break p}t[i+64|0]=w[i+64|0]&M|2;e=e+1|0;if((O|0)!=(e|0)){continue}break}break q}Eb(152876,4348);f=-1;v[I+32>>2]=-1;Fb(276579,I+32|0);break p}if(!((J|0)>(M|0)&L)){break q}e=(b+J|0)-M|0;while(1){h=b<<2;J=M<<2;f=Ac(v[j+20>>2],v[J+fa>>2]);v[h+Q>>2]=f;T=A[Y+(M<<3)>>3];A[N+(b<<3)>>3]=T;h=h+R|0;v[h>>2]=v[J+V>>2];v[f+36>>2]=v[f+36>>2]+1;f=mU(a,P,f,v[h>>2]?-T:T,W,$);if((f|0)!=1){Eb(152876,4245);v[I+112>>2]=f;Fb(276579,I+112|0);Eb(152876,4543);v[I+96>>2]=f;Fb(276579,I+96|0);break p}t[i+64|0]=w[i+64|0]&193|2;M=M+1|0;b=b+1|0;if((e|0)!=(b|0)){continue}break}b=e}Lb(v[v[a>>2]+4>>2],i+32|0,v[i+44>>2]<<3,152842,4556);Lb(v[v[a>>2]+4>>2],i+36|0,v[i+44>>2]<<2,152842,4557);Lb(v[v[a>>2]+4>>2],i+28|0,v[i+44>>2]<<2,152842,4558);T=A[v[a+4>>2]+1280>>3];if(!(T>=D(A[i>>3]-W)&T>=D(A[i+8>>3]-$))){A[i+8>>3]=$;A[i>>3]=W;t[i+64|0]=w[i+64|0]&223}v[i+44>>2]=X;v[i+40>>2]=b;v[i+36>>2]=R;v[i+32>>2]=N;v[i+28>>2]=Q;e=v[i+24>>2];f=$la(v[i+16>>2],v[i+20>>2],i+24|0);if((f|0)!=1){Eb(152876,4575);v[I+48>>2]=f;Fb(276579,I+48|0);break p}b=v[i+24>>2]-b|0;v[i+24>>2]=b;if((b|0)!=(e|0)){t[i+64|0]=w[i+64|0]&193|2}yQ(v[i+28>>2],v[i+32>>2],v[i+36>>2],584,v[i+40>>2]);f=1}ub=I+272|0;h=f;f=8513;if((h|0)!=1){break k}b=v[P+84>>2];B:{if(b&256){break B}C:{Y=w[_+64|0]&2;if(!Y){break C}if(rc(v[a+4>>2],v[a+24>>2],0)){break C}i=ub-1280|0;ub=i;e=1;D:{if(t[P+85|0]&1){break D}I=v[P+16>>2];if(v[I+20>>2]!=3){break D}U=v[I+40>>2];J=v[I+28>>2];if(vi(v[I+16>>2])|U-4>>>0<4294967294|v[I+24>>2]!=1){break D}b=v[J>>2];f=v[b+24>>2];if((f|0)<=0){f=v[b+12>>2]}b=v[J+4>>2];h=v[b+24>>2];E:{if((h|0)>0){if((f|0)==(h|0)){break E}break D}if(v[b+12>>2]!=(f|0)){break D}}N=Ib(v[v[a>>2]+8>>2],f,4,152842,7223);v[i+1276>>2]=N;if(!N){Eb(152876,7223);e=-1;v[i>>2]=-1;Fb(276579,i);break D}R=Ib(v[v[a>>2]+8>>2],f,4,152842,7224);v[i+1268>>2]=R;if(!R){Eb(152876,7224);e=-1;v[i+16>>2]=-1;Fb(276579,i+16|0);break D}M=f<<2;dc(R,M);O=Ib(v[v[a>>2]+8>>2],f,4,152842,7226);v[i+1272>>2]=O;if(!O){Eb(152876,7226);e=-1;v[i+32>>2]=-1;Fb(276579,i+32|0);break D}dc(O,M);L=Ib(v[v[a>>2]+8>>2],f,4,152842,7229);v[i+1264>>2]=L;if(!L){Eb(152876,7229);e=-1;v[i+48>>2]=-1;Fb(276579,i+48|0);break D}K=Ib(v[v[a>>2]+8>>2],f,4,152842,7230);v[i+1260>>2]=K;if(!K){Eb(152876,7230);e=-1;v[i+64>>2]=-1;Fb(276579,i- -64|0);break D}dc(K,M);V=(J+(U<<2)|0)-4|0;b=v[V>>2];e=Jt(a,f,v[(v[b+24>>2]>0?20:8)+b>>2],L,K);if((e|0)!=1){Eb(152876,7240);v[i+176>>2]=e;Fb(276579,i+176|0);break D}zA(L,K,359,f);b=f-1|0;F:{G:{if((f|0)>0){h=b;while(1){Q=h<<2;e=v[Q+L>>2];if(A[e+128>>3]>.5|A[e+136>>3]<.5){break F}X=N+Q|0;S=v[K+Q>>2];if(S){e=v[e+236>>2]}v[X>>2]=e;e=Q+v[(i+1268|0)+(S<<2)>>2]|0;v[e>>2]=v[e>>2]+1;e=(h|0)>0;h=h-1|0;if(e){continue}break}if((U|0)<2){break G}}h=U-2|0;while(1){v[i+192>>2]=-1;e=v[v[J+(h<<2)>>2]+(v[v[V>>2]+24>>2]>0?20:8)>>2];dc(K,M);L=v[i+1264>>2];K=v[i+1260>>2];e=Jt(a,f,e,L,K);if((e|0)!=1){Eb(152876,7298);v[i+160>>2]=e;Fb(276579,i+160|0);break D}zA(L,K,359,f);e=b;if((f|0)>0){while(1){X=e<<2;Q=v[X+L>>2];if(A[Q+128>>3]>.5|A[Q+136>>3]<.5){break F}if(!Pf(N,359,Q,f,i+192|0)){break F}Q=v[(i+1268|0)+(v[K+X>>2]<<2)>>2]+(v[i+192>>2]<<2)|0;v[Q>>2]=v[Q>>2]+1;Q=(e|0)>0;e=e-1|0;if(Q){continue}break}}e=(h|0)>0;h=h-1|0;if(e){continue}break}}H:{I:{if((f|0)<=0){L=0;h=0;M=0;break I}Q=f&1;J:{if(!b){L=0;h=0;M=0;J=0;e=b;break J}V=O-4|0;X=f&2147483646;L=0;h=0;M=0;J=0;e=b;K=0;while(1){K:{L:{M:{N:{O:{S=e<<2;switch(v[S+O>>2]){case 0:break M;case 1:break N;case 2:break O;default:break L}}M=M+1|0;break K}h=h+1|0;break K}L=L+1|0;break K}J=J+1|0}P:{Q:{switch(v[S+V>>2]){case 2:M=M+1|0;break P;case 1:h=h+1|0;break P;case 0:L=L+1|0;break P;default:break Q}}J=J+1|0}e=e-2|0;K=K+2|0;if((X|0)!=(K|0)){continue}break}}R:{if(!Q){break R}S:{switch(v[O+(e<<2)>>2]){case 2:M=M+1|0;break R;case 1:h=h+1|0;break R;case 0:L=L+1|0;break R;default:break S}}J=J+1|0}e=b>>31&b;K=e+1|0;if(f-e&1){T:{U:{switch(v[R+(b<<2)>>2]){case 2:M=M+1|0;break T;case 1:h=h+1|0;break T;case 0:L=L+1|0;break T;default:break U}}J=J+1|0}e=f-2|0}else{e=b}if((f|0)!=(K|0)){K=R-4|0;while(1){V:{W:{X:{Y:{Z:{Q=e<<2;switch(v[Q+R>>2]){case 0:break X;case 1:break Y;case 2:break Z;default:break W}}M=M+1|0;break V}h=h+1|0;break V}L=L+1|0;break V}J=J+1|0}_:{$:{switch(v[K+Q>>2]){case 2:M=M+1|0;break _;case 1:h=h+1|0;break _;case 0:L=L+1|0;break _;default:break $}}J=J+1|0}Q=(e|0)>1;e=e-2|0;if(Q){continue}break}}if(J){break H}}aa:{ba:{if(!((U|0)!=2|(b|0)!=(M|0)|((h|0)!=2|(L|0)!=1))){h=7388;J=Ib(v[v[a>>2]+8>>2],v[I+24>>2]+2|0,4,152842,7388);v[i+1224>>2]=J;e=-1;ca:{da:{if(!J){break da}h=7389;J=Ib(v[v[a>>2]+8>>2],v[I+24>>2]+2|0,8,152842,7389);v[i+1216>>2]=J;if(!J){break da}h=7392;e=lm(v[I+16>>2],v[I+20>>2],v[i+1224>>2],J,i+1256|0);if((e|0)==1){break ca}}Eb(152876,h);v[i+80>>2]=e;Fb(276579,i+80|0);break D}v[i+1252>>2]=0;Ao(P,v[i+1224>>2],v[i+1216>>2],v[i+1256>>2],i+1252|0,i+192|0,i+1248|0,0,0,0,0);Hb(v[v[a>>2]+8>>2],i+1216|0,152842,7409);Hb(v[v[a>>2]+8>>2],i+1224|0,152842,7410);if((f|0)!=2){break H}e=1;if(v[O+4>>2]==2){break ba}e=0;f=v[O>>2];if((f|0)==2){break ba}while(1){if(v[R+(b<<2)>>2]==2){if((f|0)==2){e=b;break ba}h=v[N+(b<<2)>>2];break aa}h=0;e=(b|0)>0;b=b-1|0;if(e){continue}break}break aa}if((f|0)!=2|(U|0)!=3|((M|0)!=2|(h|0)!=2)){break H}if(L){break H}h=7500;f=Ib(v[v[a>>2]+8>>2],v[I+24>>2]+3|0,4,152842,7500);v[i+1256>>2]=f;e=-1;ea:{fa:{if(!f){break fa}h=7501;f=Ib(v[v[a>>2]+8>>2],v[I+24>>2]+3|0,8,152842,7501);v[i+1252>>2]=f;if(!f){break fa}h=7504;e=lm(v[I+16>>2],v[I+20>>2],v[i+1256>>2],f,i+1248|0);if((e|0)!=1){break fa}h=0;v[i+1244>>2]=0;Ao(P,v[i+1256>>2],v[i+1252>>2],v[i+1248>>2],i+1244|0,i+1224|0,i+1240|0,0,0,0,0);Hb(v[v[a>>2]+8>>2],i+1252|0,152842,7521);Hb(v[v[a>>2]+8>>2],i+1256|0,152842,7522);v[i+1216>>2]=0;v[i+1220>>2]=0;if(v[O+4>>2]==1){h=v[v[N+4>>2]+236>>2];v[i+1216>>2]=h}ga:{ha:{if(v[O>>2]==1){f=v[N>>2];e=f+236|0;if(h){break ha}h=v[f+236>>2];v[i+1216>>2]=h}while(1){e=b<<2;if(v[e+R>>2]==1){e=e+N|0;if(h){break ha}h=v[e>>2];v[i+1216>>2]=h}e=(b|0)>0;b=b-1|0;if(e){continue}break}break ga}v[i+1220>>2]=v[e>>2]}b=v[v[i+1244>>2]+208>>2];v[i+144>>2]=v[P+8>>2];v[i+148>>2]=b;b=i+192|0;Jb(b,1024,62282,i+144|0);h=7556;f=i+1236|0;e=uo(a,f,b,v[i+1244>>2],2,i+1216|0,1,1,1,1,1,0,0,0,0,0);if((e|0)!=1){break fa}h=7557;e=mc(a,v[i+1236>>2]);if((e|0)!=1){break fa}h=7559;e=ec(a,f);if((e|0)!=1){break fa}h=7562;e=pc(a,v[I+16>>2]);if((e|0)!=1){break fa}h=7563;e=pc(a,P);if((e|0)==1){break ea}}Eb(152876,h);v[i+128>>2]=e;Fb(276579,i+128|0);break D}v[z>>2]=v[z>>2]+2;break H}h=v[v[N+(e<<2)>>2]+236>>2]}M=7446;ia:{e=Le(a,v[i+1252>>2],h,1,1,1,i+1240|0,i+1244|0,i+1236|0);if((e|0)!=1){break ia}if(v[i+1240>>2]){v[g+400>>2]=1;break H}if(v[i+1236>>2]){v[r>>2]=v[r>>2]+1}M=7459;e=pc(a,v[I+16>>2]);if((e|0)!=1){break ia}M=7460;e=pc(a,P);if((e|0)!=1){break ia}v[z>>2]=v[z>>2]+2;break H}Eb(152876,M);v[i+112>>2]=e;Fb(276579,i+112|0);break D}if(!(w[P+86|0]&8)){break F}e=_la(a,P,j,z);if((e|0)==1){break F}Eb(152876,7573);v[i+96>>2]=e;Fb(276579,i+96|0);break D}Hb(v[v[a>>2]+8>>2],i+1260|0,152842,7578);Hb(v[v[a>>2]+8>>2],i+1264|0,152842,7579);Hb(v[v[a>>2]+8>>2],i+1272|0,152842,7580);Hb(v[v[a>>2]+8>>2],i+1268|0,152842,7581);Hb(v[v[a>>2]+8>>2],i+1276|0,152842,7582);e=1}ub=i+1280|0;h=e;if((e|0)==1){break C}f=8529;break k}k=(k|0)==2147483647?Y?l:2147483647:k;b=v[P+84>>2];e=b&8404992;h=b&4194304;f=0;if(!h&((e|0)!=16384|(f|0)!=0)){break B}if(w[_+64|0]&2){J=0;I=ub-1472|0;ub=I;U=v[P+16>>2];b=v[U+16>>2];ja:{ka:{la:{ma:{if(!v[U+40>>2]){f=v[b+88>>2];h=f;v[b+84>>2]=v[b+84>>2];v[b+88>>2]=h&-2147483641|((h>>>3|0)-1&268435455)<<3;e=pc(a,P);if((e|0)!=1){Eb(152876,7092);v[I>>2]=e;Fb(276579,I);break ja}v[z>>2]=v[z>>2]+1;break ma}na:{oa:{switch(v[U+20>>2]){case 1:of(b);break na;case 2:bh(b);break na;case 3:wg(b);break na;default:Eb(152876,544);Fb(285412,0);Eb(152876,7099);e=-9;v[I+16>>2]=-9;Fb(276579,I+16|0);break ja;case 0:break oa}}Re(b)}pa:{qa:{ra:{sa:{ta:{switch(v[U+20>>2]){case 0:e=Zla(a,P,z,C);if((e|0)==1){break pa}Eb(152876,7105);v[I+48>>2]=e;Fb(276579,I+48|0);break ja;case 1:N=v[P+16>>2];Q=v[N+28>>2];R=v[N+40>>2];if((R|0)==1){if(!v[N+24>>2]){break pa}h=v[N+16>>2];b=v[Q>>2];i=v[b+24>>2];ua:{if((i|0)>0){b=b+20|0;break ua}i=v[b+12>>2];b=b+8|0}O=v[b>>2];W=A[v[a+4>>2]+1272>>3];v[I+96>>2]=v[h+8>>2];b=I+432|0;Jb(b,1024,138472,I+96|0);e=b;$=+(i|0);b=v[h+84>>2];e=kd(a,I+408|0,e,0,0,0,$,W,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);f=6163;if((e|0)!=1){break qa}b=v[N+16>>2];va:{wa:{switch(v[N+20>>2]){case 1:b=of(b);break va;case 2:b=bh(b);break va;case 3:b=wg(b);break va;case 0:break wa;default:break ra}}b=Re(b)}v[I+424>>2]=b;K=v[N+24>>2];v[I+412>>2]=K;L=Ib(v[v[a>>2]+8>>2],b,4,152842,6172);v[I+1464>>2]=L;e=-1;f=6172;if(!L){break qa}b=Ib(v[v[a>>2]+8>>2],b,8,152842,6173);v[I+428>>2]=b;f=6173;if(!b){break qa}M=Ib(v[v[a>>2]+8>>2],K,4,152842,6174);v[I+420>>2]=M;f=6174;if(!M){break qa}K=Ib(v[v[a>>2]+8>>2],K,8,152842,6175);v[I+416>>2]=K;f=6175;if(!K){break qa}e=lm(v[N+16>>2],v[N+20>>2],L,b,I+424|0);f=6178;if((e|0)!=1){break qa}Ao(P,L,b,v[I+424>>2],M,K,I+412|0,0,0,0,0);xa:{ya:{za:{if(v[I+412>>2]>0){while(1){e=wd(a,v[I+408>>2],v[M+(J<<2)>>2],$);if((e|0)!=1){break za}J=J+1|0;if((J|0)<v[I+412>>2]){continue}break}}J=0;if((i|0)<=0){break xa}break ya}f=6189;break qa}while(1){e=wd(a,v[I+408>>2],v[O+(J<<2)>>2],1);if((e|0)==1){J=J+1|0;if((J|0)!=(i|0)){continue}break xa}break}f=6195;break qa}e=mc(a,v[I+408>>2]);f=6199;if((e|0)!=1){break qa}e=ec(a,I+408|0);f=6207;if((e|0)!=1){break qa}v[C>>2]=v[C>>2]+1;e=pc(a,h);f=6211;if((e|0)!=1){break qa}e=pc(a,P);f=6212;if((e|0)!=1){break qa}v[z>>2]=v[z>>2]+2;Hb(v[v[a>>2]+8>>2],I+416|0,152842,6216);Hb(v[v[a>>2]+8>>2],I+420|0,152842,6217);Hb(v[v[a>>2]+8>>2],I+428|0,152842,6218);Hb(v[v[a>>2]+8>>2],I+1464|0,152842,6219);break pa}Aa:{L=R-1|0;e=Q+(L<<2)|0;f=v[e>>2];b=v[f+24>>2];if((b|0)>0){O=Oc(v[v[a>>2]+8>>2],v[v[e>>2]+20>>2],b,4,152842,6233);v[I+1468>>2]=O;if(O){break Aa}Eb(152876,6233);e=-1;v[I+112>>2]=-1;Fb(276579,I+112|0);break ka}b=v[f+12>>2];O=Oc(v[v[a>>2]+8>>2],v[v[e>>2]+8>>2],b,4,152842,6239);v[I+1468>>2]=O;if(O){break Aa}Eb(152876,6239);e=-1;v[I+288>>2]=-1;Fb(276579,I+288|0);break ka}Ba:{Ca:{if((R|0)<2){i=b;f=i;h=i;break Ca}M=R-2|0;f=b;i=b;while(1){e=v[Q+(M<<2)>>2];K=v[e+24>>2];Da:{if((K|0)>0){e=e+20|0;break Da}K=v[e+12>>2];e=e+8|0}if((b|0)<=0|(K|0)<=0){break Ba}h=(f|0)>(K|0);i=h?i:(i|0)<(K|0)?K:i;f=h?K:f;Y=v[e>>2];e=0;J=0;h=0;while(1){V=v[(e<<2)+O>>2];X=v[V+288>>2];S=v[v[Y+(J<<2)>>2]+288>>2];Ea:{if((X|0)<(S|0)){e=e+1|0;break Ea}if((S|0)<(X|0)){J=J+1|0;break Ea}if((e|0)>(h|0)){v[(h<<2)+O>>2]=V}J=J+1|0;e=e+1|0;h=h+1|0}if((J|0)<(K|0)&(b|0)>(e|0)){continue}break}if(!h|(M|0)<=0){break Ca}M=M-1|0;b=h;if((b+1|0)>=(f|0)){continue}break}}if((h|0)<=0){break Ba}Fa:{if(v[N+24>>2]){break Fa}J=0;while(1){e=Qc(a,v[(J<<2)+O>>2],1,I+432|0,I+1464|0);if((e|0)!=1){J=6374;break la}if(v[I+432>>2]){v[g+400>>2]=1;break Ba}if(v[I+1464>>2]){v[q>>2]=v[q>>2]+1}J=J+1|0;if((J|0)!=(h|0)){continue}break}if((f|0)!=(h|0)){break Fa}J=6391;e=pc(a,v[N+16>>2]);if((e|0)!=1){break la}J=6392;e=pc(a,P);if((e|0)!=1){break la}v[z>>2]=v[z>>2]+2;break Ba}if((f|0)!=(i|0)|(h+1|0)!=(f|0)){break Ba}W=A[v[a+4>>2]+1272>>3];M=v[N+16>>2];v[I+272>>2]=v[M+8>>2];b=I+432|0;Jb(b,1024,138472,I+272|0);e=b;b=v[M+84>>2];e=kd(a,I+1464|0,e,0,0,0,1,W,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);if((e|0)!=1){break sa}if((R|0)>0){while(1){Ga:{b=L;e=v[Q+(b<<2)>>2];i=v[e+24>>2];Ha:{if((i|0)>0){e=e+20|0;break Ha}i=v[e+12>>2];if((i|0)<=0){break Ga}e=e+8|0}f=v[e>>2];K=0;J=0;while(1){e=v[f+(J<<2)>>2];Ia:{if(v[v[(K<<2)+O>>2]+288>>2]>v[e+288>>2]){e=wd(a,v[I+1464>>2],e,1);if((e|0)==1){break Ia}Eb(152876,6461);v[I+240>>2]=e;Fb(276579,I+240|0);break ka}K=K+1|0}J=J+1|0;if((J|0)<(i|0)&(h|0)>(K|0)){continue}break}if((i|0)<=(J|0)){break Ga}while(1){e=wd(a,v[I+1464>>2],v[f+(J<<2)>>2],1);if((e|0)==1){J=J+1|0;if((J|0)!=(i|0)){continue}break Ga}break}Eb(152876,6478);v[I+224>>2]=e;Fb(276579,I+224|0);break ka}L=b-1|0;if((b|0)>0){continue}break}}if(v[N+24>>2]>0){W=+(R|0);J=0;Ja:{Ka:{La:{while(1){e=wd(a,v[I+1464>>2],v[(J<<2)+O>>2],W);if((e|0)==1){J=J+1|0;if((J|0)!=(h|0)){continue}break La}break}J=6500;break Ka}J=6504;K=I+420|0;e=$la(v[N+16>>2],v[N+20>>2],K);if((e|0)!=1){break Ka}J=6508;b=v[I+420>>2];f=Ib(v[v[a>>2]+8>>2],b,4,152842,6508);v[I+428>>2]=f;e=-1;if(!f){break Ka}J=6509;i=Ib(v[v[a>>2]+8>>2],b,8,152842,6509);v[I+424>>2]=i;if(!i){break Ka}J=6510;L=Ib(v[v[a>>2]+8>>2],b,4,152842,6510);v[I+416>>2]=L;if(!L){break Ka}J=6511;b=Ib(v[v[a>>2]+8>>2],b,8,152842,6511);v[I+412>>2]=b;if(!b){break Ka}J=6514;e=lm(v[N+16>>2],v[N+20>>2],f,i,K);if((e|0)!=1){break Ka}J=0;Ao(P,f,i,v[I+420>>2],L,b,I+408|0,0,0,0,0);W=+(B(h,R)+1|0);Ma:{if(v[I+408>>2]<=0){break Ma}while(1){e=wd(a,v[I+1464>>2],v[L+(J<<2)>>2],W);if((e|0)==1){J=J+1|0;if((J|0)<v[I+408>>2]){continue}break Ma}break}J=6530;break Ka}J=6534;e=Ph(a,v[I+1464>>2],W);if((e|0)==1){break Ja}}Eb(152876,J);v[I+144>>2]=e;Fb(276579,I+144|0);break ka}Hb(v[v[a>>2]+8>>2],I+412|0,152842,6537);Hb(v[v[a>>2]+8>>2],I+416|0,152842,6538);Hb(v[v[a>>2]+8>>2],I+424|0,152842,6539);Hb(v[v[a>>2]+8>>2],I+428|0,152842,6540)}e=mc(a,v[I+1464>>2]);if((e|0)!=1){Eb(152876,6544);v[I+208>>2]=e;Fb(276579,I+208|0);break ka}e=ec(a,I+1464|0);if((e|0)!=1){Eb(152876,6552);v[I+192>>2]=e;Fb(276579,I+192|0);break ka}v[C>>2]=v[C>>2]+1;e=pc(a,M);if((e|0)!=1){Eb(152876,6556);v[I+176>>2]=e;Fb(276579,I+176|0);break ka}e=pc(a,P);if((e|0)!=1){Eb(152876,6557);v[I+160>>2]=e;Fb(276579,I+160|0);break ka}v[z>>2]=v[z>>2]+2}Hb(v[v[a>>2]+8>>2],I+1468|0,152842,6563);break pa;default:Eb(152876,7125);Fb(285412,0);e=-9;break ja;case 2:break pa;case 3:break ta}}f=v[P+16>>2];Q=v[f+40>>2];V=v[f+28>>2];Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{R=vi(v[f+16>>2]);switch(R|0){case 2:break Pa;case 0:case 1:break Ta;default:break Sa}}if((Q|0)==1|v[f+24>>2]>0){break Pa}Ua:{L=Q-1|0;e=V+(L<<2)|0;h=v[e>>2];b=v[h+24>>2];if((b|0)>0){O=Oc(v[v[a>>2]+8>>2],v[v[e>>2]+20>>2],b,4,152842,6678);v[I+1468>>2]=O;if(O){break Ua}Eb(152876,6678);e=-1;v[I+336>>2]=-1;Fb(276579,I+336|0);break Na}b=v[h+12>>2];O=Oc(v[v[a>>2]+8>>2],v[v[e>>2]+8>>2],b,4,152842,6684);v[I+1468>>2]=O;if(O){break Ua}Eb(152876,6684);e=-1;v[I+400>>2]=-1;Fb(276579,I+400|0);break Na}Va:{if((Q|0)<2){M=b;i=b;h=i;break Va}N=Q-2|0;i=b;M=i;while(1){e=v[V+(N<<2)>>2];K=v[e+24>>2];Wa:{if((K|0)>0){e=e+20|0;break Wa}K=v[e+12>>2];e=e+8|0}if((b|0)<=0|(K|0)<=0){break Qa}h=(i|0)>(K|0);M=h?M:(K|0)>(M|0)?K:M;i=h?K:i;Y=v[e>>2];e=0;J=0;h=0;while(1){X=v[(e<<2)+O>>2];S=v[X+288>>2];Z=v[v[Y+(J<<2)>>2]+288>>2];Xa:{if((S|0)<(Z|0)){e=e+1|0;break Xa}if((S|0)>(Z|0)){J=J+1|0;break Xa}if((e|0)>(h|0)){v[(h<<2)+O>>2]=X}J=J+1|0;e=e+1|0;h=h+1|0}if((J|0)<(K|0)&(b|0)>(e|0)){continue}break}if(!h|(N|0)<=0){break Va}N=N-1|0;b=h;if(!R|(b+1|0)>=(i|0)){continue}break}}if((h|0)<=0){break Qa}X=h+1|0;b=(i|0)==(M|0)&(X|0)==(i|0);if(!(b|!R)&(h|0)!=(i|0)){break Qa}v[I+1464>>2]=0;W=1;e=v[a+4>>2];W=R?-A[e+1272>>3]:W;J=(h|0)==(i|0);$=J?0:1;Ya:{if(!(A[e+1280>>3]>=W-$)){f=v[f+16>>2];N=0;break Ya}N=1;f=v[f+16>>2];if(!b&(h|0)!=(i|0)){N=0;break Ya}v[I+384>>2]=v[f+8>>2];b=I+432|0;Jb(b,1024,138472,I+384|0);K=6852;e=b;b=v[f+84>>2];e=kd(a,I+1464|0,e,0,0,0,W,$,b&1,b>>>1&1,b>>>2&1,b>>>3&1,b>>>4&1,b>>>7&1,b>>>8&1,b>>>9&1,b>>>10&1,b>>>11&1);if((e|0)!=1){break Oa}}Y=J&!R;M=0;if((Q|0)<=0){break Ra}e=L;while(1){b=e;e=v[V+(e<<2)>>2];i=v[e+24>>2];Za:{if((i|0)>0){J=e+20|0;break Za}i=v[e+12>>2];J=e+8|0}_a:{$a:{ab:{bb:{if(!(Y&(i|0)>(X|0))){if((i|0)<=0){break $a}Q=v[J>>2];K=0;J=0;cb:{if(N){while(1){db:{e=v[Q+(J<<2)>>2];if(v[v[(K<<2)+O>>2]+288>>2]<=v[e+288>>2]){K=K+1|0;break db}e=wd(a,v[I+1464>>2],e,1);if((e|0)==1){break db}K=6922;break Oa}J=J+1|0;e=(J|0)<(i|0);if((h|0)<=(K|0)){break cb}if((i|0)>(J|0)){continue}break cb}}while(1){e=v[Q+(J<<2)>>2];eb:{if(v[v[(K<<2)+O>>2]+288>>2]>v[e+288>>2]){if(!Y){break eb}e=Qc(a,e,0,I+428|0,I+424|0);if((e|0)!=1){K=6927;break Oa}if(v[I+428>>2]){v[g+400>>2]=1;break Qa}if(!v[I+424>>2]){break eb}v[q>>2]=v[q>>2]+1;break eb}K=K+1|0}J=J+1|0;e=(J|0)<(i|0);if((h|0)<=(K|0)){break cb}if((i|0)>(J|0)){continue}break}}if(!e|(i|0)<=(J|0)){break $a}if(N){while(1){e=wd(a,v[I+1464>>2],v[Q+(J<<2)>>2],1);K=6956;if((e|0)!=1){break bb}J=J+1|0;if((J|0)!=(i|0)){continue}break $a}}if(!Y){break $a}while(1){e=Qc(a,v[Q+(J<<2)>>2],0,I+428|0,I+424|0);K=6961;if((e|0)!=1){break bb}if(v[I+428>>2]){break _a}if(v[I+424>>2]){v[q>>2]=v[q>>2]+1}J=J+1|0;if((J|0)!=(i|0)){continue}break}break $a}e=Qc(a,og(v[e>>2]),0,I+428|0,I+424|0);if((e|0)==1){break ab}K=6890}Eb(152876,K);v[I+368>>2]=e;Fb(276579,I+368|0);break Na}if(v[I+428>>2]){break _a}if(!v[I+424>>2]){break $a}v[q>>2]=v[q>>2]+1}e=b-1|0;if((b|0)>0){continue}break Ra}break}v[g+400>>2]=1;break Qa}Eb(152876,6624);Fb(285833,0);e=-9;break Na}fb:{gb:{if(!R){while(1){e=Qc(a,v[(M<<2)+O>>2],1,I+428|0,I+424|0);if((e|0)!=1){K=6984;break Oa}if(v[I+428>>2]){break fb}if(v[I+424>>2]){v[q>>2]=v[q>>2]+1}M=M+1|0;if((M|0)!=(h|0)){continue}break gb}}W=+(L|0);while(1){e=wd(a,v[I+1464>>2],v[(M<<2)+O>>2],W);if((e|0)!=1){K=6997;break Oa}M=M+1|0;if((M|0)!=(h|0)){continue}break}}if((R|0)==1){K=7007;e=Oh(a,v[I+1464>>2],$+ +(B(h,L)|0));if((e|0)!=1){break Oa}}hb:{if(N){K=7013;e=mc(a,v[I+1464>>2]);if((e|0)!=1){break Oa}K=7021;e=ec(a,I+1464|0);if((e|0)!=1){break Oa}v[C>>2]=v[C>>2]+1;break hb}if(!Y){break Qa}}K=7031;e=pc(a,f);if((e|0)!=1){break Oa}K=7032;e=pc(a,P);if((e|0)!=1){break Oa}v[z>>2]=v[z>>2]+2;break Qa}v[g+400>>2]=1}Hb(v[v[a>>2]+8>>2],I+1468|0,152842,7039)}if(w[P+86|0]&8){break pa}e=Zla(a,P,z,C);if((e|0)==1){break pa}Eb(152876,7116);v[I+320>>2]=e;Fb(276579,I+320|0);break ja}Eb(152876,K);v[I+352>>2]=e;Fb(276579,I+352|0)}Eb(152876,7113);v[I+304>>2]=e;Fb(276579,I+304|0);break ja}Eb(152876,6418);v[I+256>>2]=e;Fb(276579,I+256|0);break ka}Eb(152876,544);Fb(285412,0);e=-9;f=6166}Eb(152876,f);v[I+80>>2]=e;Fb(276579,I+80|0);break ka}ib:{if(!(w[P+86|0]&8)){break ib}e=_la(a,P,j,z);if((e|0)==1){break ib}Eb(152876,7134);v[I+32>>2]=e;Fb(276579,I+32|0);break ja}t[U+64|0]=w[U+64|0]|32}e=1;break ja}Eb(152876,J);v[I+128>>2]=e;Fb(276579,I+128|0)}Eb(152876,7108);v[I+64>>2]=e;Fb(276579,I- -64|0)}ub=I+1472|0;h=e;f=8539;if((e|0)!=1){break k}b=v[P+84>>2];if(v[g+400>>2]){break B}h=b&4194304;f=0;e=b&8404992}if(!(f|h)&((e|0)!=16384|(f|0)!=0)){break B}while(1){jb:{if(w[_+64|0]&8){break jb}if(rc(v[a+4>>2],v[a+24>>2],0)){break jb}t[_+64|0]=w[_+64|0]|8;I=ub-1264|0;ub=I;R=g+400|0;v[R>>2]=0;b=1;U=v[P+16>>2];e=w[U+64|0];kb:{if(e&16){break kb}t[U+64|0]=e|16;b=v[U+16>>2];lb:{mb:{switch(v[U+20>>2]){case 1:b=of(b);break lb;case 2:b=bh(b);break lb;case 3:b=wg(b);break lb;default:Eb(152876,544);Fb(285412,0);Eb(152876,4673);b=-9;v[I>>2]=-9;Fb(276579,I);break kb;case 0:break mb}}b=Re(b)}v[I+1256>>2]=b;e=Ib(v[v[a>>2]+8>>2],b,4,152842,4677);v[I+1260>>2]=e;if(!e){Eb(152876,4677);b=-1;v[I+16>>2]=-1;Fb(276579,I+16|0);break kb}K=Ib(v[v[a>>2]+8>>2],b,4,152842,4678);v[I+1252>>2]=K;if(!K){Eb(152876,4678);b=-1;v[I+32>>2]=-1;Fb(276579,I+32|0);break kb}b=lm(v[U+16>>2],v[U+20>>2],e,0,I+1256|0);if((b|0)!=1){Eb(152876,4681);v[I+176>>2]=b;Fb(276579,I+176|0);break kb}Ao(P,e,0,v[I+1256>>2],K,0,I+1248|0,0,0,0,I+1244|0);N=v[I+1244>>2];b=1;nb:{ob:{while(1){if((N|0)<=0){break ob}N=N-1|0;e=v[v[U+28>>2]+(N<<2)>>2];Q=og(v[e>>2]);h=v[e+24>>2];pb:{qb:{if((h|0)>0){e=e+20|0}else{h=v[e+12>>2];if((h|0)<=0){break qb}e=e+8|0}X=v[e>>2];while(1){f=h;h=h-1|0;L=v[X+(h<<2)>>2];e=v[L+376>>2];rb:{if(v[L+292>>2]<0){if((e&1792)!=1536|v[v[L+236>>2]+292>>2]<0){break rb}}Y=1;V=(e&1792)!=1536;if(!V){Y=0;L=v[L+236>>2]}i=v[I+1248>>2];if((i|0)<=0){break rb}while(1){M=i;i=i-1|0;J=v[K+(i<<2)>>2];e=v[J+376>>2];sb:{if(v[J+292>>2]<0){if((e&1792)!=1536|v[v[J+236>>2]+292>>2]<0){break sb}}tb:{ub:{S=(e&1792)!=1536;vb:{if(!S){O=0;J=v[J+236>>2];e=(L|0)==(J|0);if(!(V&e)){break ub}v[I+1228>>2]=Q;e=v[L+236>>2];break vb}e=(J|0)==(L|0);O=1;if((J|0)!=(L|0)|V){break ub}v[I+1228>>2]=Q;e=L}v[I+1232>>2]=e;J=4779;O=I+1228|0;e=Ti(a,O,0,2,0,R,I+1240|0);wb:{if((e|0)!=1){break wb}J=23;if(v[R>>2]){break tb}v[u>>2]=v[u>>2]+v[I+1240>>2];e=v[v[I+1232>>2]+208>>2];J=v[v[I+1228>>2]+208>>2];v[I+64>>2]=v[P+8>>2];v[I+68>>2]=J;v[I+72>>2]=e;e=I+192|0;Jb(e,1024,62329,I- -64|0);J=4790;S=I+1236|0;Z=e;e=v[P+84>>2];e=jf(a,S,Z,2,O,1,e&1,e>>>1&1,e>>>2&1,0,e>>>4&1,e>>>7&1,e>>>8&1,e>>>9&1,e>>>10&1,e>>>11&1);if((e|0)!=1){break wb}J=4792;e=mc(a,v[I+1236>>2]);if((e|0)!=1){break wb}J=4796;e=ec(a,S);if((e|0)==1){break sb}}Eb(152876,J);v[I+48>>2]=e;Fb(276579,I+48|0);b=e;J=1;break tb}if(e){break sb}if(!wi(L,Y,J,O,1)){break sb}v[I+1228>>2]=Q;if(!S){J=v[J+236>>2]}v[I+1232>>2]=J;O=4822;S=I+1228|0;e=Ti(a,S,0,2,0,R,I+1240|0);xb:{if((e|0)!=1){break xb}J=23;if(v[R>>2]){break tb}v[u>>2]=v[u>>2]+v[I+1240>>2];e=v[v[I+1232>>2]+208>>2];J=v[v[I+1228>>2]+208>>2];v[I+96>>2]=v[P+8>>2];v[I+100>>2]=J;v[I+104>>2]=e;e=I+192|0;Jb(e,1024,62329,I+96|0);O=4833;Z=I+1236|0;J=e;e=v[P+84>>2];e=jf(a,Z,J,2,S,1,e&1,e>>>1&1,e>>>2&1,0,e>>>4&1,e>>>7&1,e>>>8&1,e>>>9&1,e>>>10&1,e>>>11&1);if((e|0)!=1){break xb}O=4835;e=mc(a,v[I+1236>>2]);if((e|0)!=1){break xb}O=4839;e=ec(a,Z);J=0;if((e|0)==1){break tb}}Eb(152876,O);v[I+80>>2]=e;Fb(276579,I+80|0);b=e;J=1}switch(J|0){case 17:break rb;case 0:case 20:break sb;default:break pb}}if(M>>>0>1){continue}break}}if((f|0)>1){continue}break}}J=0}if(!J){continue}break}if((J|0)==23){break nb}break kb}M=v[I+1244>>2];while(1){if((M|0)<2){break nb}f=v[U+28>>2];e=v[(f+(M<<2)|0)-8>>2];M=M-1|0;h=v[f+(M<<2)>>2];Y=og(v[h>>2]);X=og(v[e>>2]);f=v[h+24>>2];if((f|0)>0){h=h+20|0}else{f=v[h+12>>2];h=h+8|0}S=v[h>>2];h=v[e+24>>2];if((h|0)>0){e=e+20|0}else{h=v[e+12>>2];e=e+8|0}Q=0;yb:{if((f|0)<=0|(h|0)<=0){break yb}Z=v[e>>2];zb:{while(1){Ab:{L=f;f=f-1|0;N=v[S+(f<<2)>>2];e=v[N+376>>2];Bb:{if(v[N+292>>2]<0){if((e&1792)!=1536|v[v[N+236>>2]+292>>2]<0){break Bb}}O=1;if((e&1792)==1536){N=v[N+236>>2];O=0}i=h;while(1){K=i;i=i-1|0;J=v[Z+(i<<2)>>2];V=v[J+376>>2];Cb:{if(v[J+292>>2]<0){if((V&1792)!=1536|v[v[J+236>>2]+292>>2]<0){break Cb}}e=1;V=(V&1792)!=1536;if(!V){J=v[J+236>>2];e=0}aa=(J|0)==(N|0);if(!(aa&(e|0)!=(O|0))){if(aa|!wi(N,O,J,e,1)){break Cb}v[I+1228>>2]=Y;if(!V){J=v[J+236>>2]}v[I+1232>>2]=J;J=Ti(a,I+1228|0,0,2,0,R,I+1240|0);if((J|0)!=1){e=4992;b=J;break Ab}if(v[R>>2]){Q=23;break yb}v[u>>2]=v[u>>2]+v[I+1240>>2];e=v[v[I+1232>>2]+208>>2];J=v[v[I+1228>>2]+208>>2];v[I+160>>2]=v[P+8>>2];v[I+164>>2]=J;v[I+168>>2]=e;e=I+192|0;Jb(e,1024,62329,I+160|0);J=e;e=v[P+84>>2];J=jf(a,I+1236|0,J,2,I+1228|0,1,e&1,e>>>1&1,e>>>2&1,0,e>>>4&1,e>>>7&1,e>>>8&1,e>>>9&1,e>>>10&1,e>>>11&1);if((J|0)!=1){e=5003;b=J;break Ab}J=mc(a,v[I+1236>>2]);if((J|0)!=1){e=5005;b=J;break Ab}J=ec(a,I+1236|0);if((J|0)==1){break Cb}e=5009;b=J;break Ab}v[I+1232>>2]=X;v[I+1228>>2]=Y;J=Ti(a,I+1228|0,0,2,0,R,I+1240|0);Db:{if((J|0)!=1){e=4948;break Db}if(v[R>>2]){Q=23;break yb}v[u>>2]=v[u>>2]+v[I+1240>>2];e=v[v[I+1232>>2]+208>>2];J=v[v[I+1228>>2]+208>>2];v[I+128>>2]=v[P+8>>2];v[I+132>>2]=J;v[I+136>>2]=e;e=I+192|0;Jb(e,1024,62329,I+128|0);J=e;e=v[P+84>>2];J=jf(a,I+1236|0,J,2,I+1228|0,1,e&1,e>>>1&1,e>>>2&1,0,e>>>4&1,e>>>7&1,e>>>8&1,e>>>9&1,e>>>10&1,e>>>11&1);if((J|0)!=1){e=4959;break Db}J=mc(a,v[I+1236>>2]);if((J|0)!=1){e=4961;break Db}J=ec(a,I+1236|0);if((J|0)==1){break Cb}e=4965}b=J;Eb(152876,e);v[I+112>>2]=b;Fb(276579,I+112|0);break zb}if((K|0)>1){continue}break}}if((L|0)>1){continue}break yb}break}Eb(152876,e);v[I+144>>2]=b;Fb(276579,I+144|0)}Q=1}if(!Q){continue}break}if((Q|0)!=23){break kb}}Hb(v[v[a>>2]+8>>2],I+1252|0,152842,5017);Hb(v[v[a>>2]+8>>2],I+1260|0,152842,5018);b=1}ub=I+1264|0;h=b;f=8558;if((b|0)!=1){break k}if(v[g+400>>2]){break jb}b=ub-16|0;ub=b;v[g+400>>2]=0;f=v[P+16>>2];Eb:{if(w[v[f+16>>2]+86|0]&8){e=$e(a,P);if((e|0)!=1){Eb(152876,5048);v[b>>2]=e;Fb(276579,b);break Eb}v[z>>2]=v[z>>2]+1}e=1;h=w[f+64|0];if(h&4){break Eb}t[f+64|0]=h|4}ub=b+16|0;h=e;f=8563;if((e|0)!=1){break k}if(!v[g+400>>2]){continue}}break}b=v[P+84>>2]}if(!(!(b&4194304)&(b&8404992)!=16384)){t[_+64|0]=w[_+64|0]&253}Hb(v[v[a>>2]+8>>2],g+384|0,152842,8577);Hb(v[v[a>>2]+8>>2],g+388|0,152842,8578);Hb(v[v[a>>2]+8>>2],g+392|0,152842,8579);Hb(v[v[a>>2]+8>>2],g+404|0,152842,8580);Hb(v[v[a>>2]+8>>2],g+408|0,152842,8581);Hb(v[v[a>>2]+8>>2],g+424|0,152842,8582);Hb(v[v[a>>2]+8>>2],g+428|0,152842,8583);break i}Eb(152876,5100);v[g+320>>2]=h;Fb(276579,g+320|0);f=8476}Eb(152876,f);v[g+304>>2]=h;Fb(276579,g+304|0);break a}v[z>>2]=v[z>>2]+1}l=l+1|0;if((l|0)>=(d|0)){break h}if(!v[g+400>>2]){continue}break}}Fb:{Gb:{b=v[j+4>>2];if((b|0)>0){I=v[j>>2];while(1){f=b;b=b-1|0;i=v[I+(b<<2)>>2];Hb:{if(!(t[i+40|0]&1)){break Hb}e=v[i+12>>2];if(!e){c=og(v[i>>2]);h=pc(a,v[i>>2]);if((h|0)!=1){Eb(152876,5162);v[g+80>>2]=h;Fb(276579,g+80|0);break Fb}v[z>>2]=v[z>>2]+1;h=$x(a,i);if((h|0)!=1){Eb(152876,5165);v[g+64>>2]=h;Fb(276579,g- -64|0);break Fb}h=ec(a,i);if((h|0)!=1){Eb(152876,5168);v[g+48>>2]=h;Fb(276579,g+48|0);break Fb}v[i+36>>2]=0;Ib:{if(v[i+4>>2]){break Ib}h=si(v[j+12>>2],i);if((h|0)==1){break Ib}Eb(152876,5175);v[g+32>>2]=h;Fb(276579,g+32|0);break Fb}h=vj(v[j+20>>2],c);if((h|0)==1){break Hb}Eb(152876,5178);v[g+16>>2]=h;Fb(276579,g+16|0);break Fb}c=v[i>>2];Jb:{Kb:{Lb:{if(!v[i+36>>2]){if(!c){break Hb}h=$x(a,i);if((h|0)!=1){Eb(152876,5203);v[g+208>>2]=h;Fb(276579,g+208|0);break Fb}Mb:{if((v[og(v[i>>2])+376>>2]>>>8&7)-1>>>0<=1){d=sk(a);if((d|0)>0){v[g+428>>2]=0;v[g+424>>2]=0;k=5231;c=es(a);h=Oc(v[v[a>>2]+8>>2],c,d,4,152842,5231);v[g+368>>2]=h;if(!h){h=-1;break Gb}c=d;if((c|0)>0){while(1){e=c;c=e-1|0;J=h+(c<<2)|0;k=v[J>>2];while(1){Nb:{l=260198;C=12257;Ob:{switch(v[k+376>>2]>>>8&7){case 0:k=v[k+200>>2];if(k){continue}l=300085;C=12228;default:Eb(150790,C);k=0;Fb(l,0);break Nb;case 5:if(v[k+192>>2]!=1){break Nb}k=v[v[k+188>>2]>>2];continue;case 4:k=v[k+192>>2];continue;case 1:case 2:case 3:break Nb;case 6:break Ob}}k=v[k+236>>2];continue}break}v[J>>2]=k;if((e|0)>1){continue}break}}e=d;while(1){c=d;d=c-1|0;l=d<<2;h=v[l+v[g+368>>2]>>2];Pb:{if((v[h+376>>2]&1792)!=1280){break Pb}k=v[g+428>>2];if(!k){k=5245;h=Ib(v[v[a>>2]+8>>2],fc(a),4,152842,5245);v[g+428>>2]=h;if(!h){h=-1;break Gb}k=5246;h=Ib(v[v[a>>2]+8>>2],fc(a),8,152842,5246);v[g+424>>2]=h;if(!h){h=-1;break Gb}k=v[g+428>>2];h=v[l+v[g+368>>2]>>2]}v[k>>2]=h;h=v[g+424>>2];v[h>>2]=0;v[h+4>>2]=1072693248;v[g+412>>2]=1;v[g+416>>2]=0;v[g+420>>2]=0;h=mf(a,v[g+428>>2],h,g+412|0,fc(a),g+416|0,g+408|0);if((h|0)!=1){k=5257;break Gb}h=v[g+412>>2];if(!h){h=v[g+368>>2];e=e-1|0;v[h+l>>2]=v[h+(e<<2)>>2];break Pb}v[l+v[g+368>>2]>>2]=v[v[g+428>>2]>>2];if((h|0)<2){break Pb}h=-1;k=5273;l=hc(v[v[a>>2]+8>>2],v[g+368>>2],(v[g+412>>2]+e|0)-1|0,4,152842,5273);v[g+368>>2]=l;if(!l){break Gb}k=v[g+412>>2];if((k|0)<2){break Pb}h=1;l=k-1|0;C=l&1;if((k|0)!=2){l=l&-2;k=0;while(1){J=e<<2;L=h<<2;v[J+v[g+368>>2]>>2]=v[L+v[g+428>>2]>>2];v[(J+v[g+368>>2]|0)+4>>2]=v[(L+v[g+428>>2]|0)+4>>2];h=h+2|0;e=e+2|0;k=k+2|0;if((l|0)!=(k|0)){continue}break}}if(!C){break Pb}v[v[g+368>>2]+(e<<2)>>2]=v[v[g+428>>2]+(h<<2)>>2];e=e+1|0}if((c|0)>1){continue}break}if(v[g+428>>2]){Hb(v[v[a>>2]+8>>2],g+428|0,152842,5289);Hb(v[v[a>>2]+8>>2],g+424|0,152842,5290)}Dd(v[g+368>>2],65,e);c=Pf(v[g+368>>2],65,og(v[i>>2]),e,g+404|0);Hb(v[v[a>>2]+8>>2],g+368|0,152842,5298);if(c){break Mb}}h=pc(a,v[i>>2]);if((h|0)==1){break Mb}Eb(152876,5303);v[g+176>>2]=h;Fb(276579,g+176|0);break Fb}c=v[i>>2];if(w[c+86|0]&8){break Jb}h=lp(a,c,0);if((h|0)!=1){break Lb}e=v[i>>2];break Kb}e=v[i>>2];if(!(w[e+86|0]&8)){break Kb}break Jb}if(w[c+86|0]&8){c=og(c);h=$x(a,i);if((h|0)!=1){Eb(152876,5347);v[g+288>>2]=h;Fb(276579,g+288|0);break Fb}h=ec(a,i);if((h|0)!=1){Eb(152876,5350);v[g+272>>2]=h;Fb(276579,g+272|0);break Fb}v[i+36>>2]=0;Qb:{if(v[i+4>>2]){break Qb}h=si(v[j+12>>2],i);if((h|0)==1){break Qb}Eb(152876,5357);v[g+256>>2]=h;Fb(276579,g+256|0);break Fb}h=vj(v[j+20>>2],c);if((h|0)==1){break Hb}Eb(152876,5360);v[g+240>>2]=h;Fb(276579,g+240|0);break Fb}if(!v[i+24>>2]){break Hb}c=v[i+8>>2];Rb:{while(1){if((e|0)<=0){break Rb}e=e-1|0;h=Dc(a,c+(e<<2)|0);if((h|0)==1){continue}break}Eb(152876,5375);v[g+224>>2]=h;Fb(276579,g+224|0);break Fb}c=v[i+8>>2];v[i+8>>2]=v[i+20>>2];d=v[i+24>>2];e=v[i+28>>2];v[i+28>>2]=v[i+16>>2];v[i+24>>2]=0;v[i+20>>2]=c;v[i+12>>2]=d;v[i+16>>2]=e;break Hb}Eb(152876,5313);v[g+192>>2]=h;Fb(276579,g+192|0);break Fb}h=Vk(a,e,1);if((h|0)==1){break Jb}Eb(152876,5318);v[g+160>>2]=h;Fb(276579,g+160|0);break Fb}Sb:{if(v[i+4>>2]){break Sb}h=si(v[j+12>>2],i);if((h|0)==1){break Sb}Eb(152876,5325);v[g+144>>2]=h;Fb(276579,g+144|0);break Fb}h=vj(v[j+20>>2],og(v[i>>2]));if((h|0)!=1){Eb(152876,5328);v[g+128>>2]=h;Fb(276579,g+128|0);break Fb}h=ec(a,i);if((h|0)!=1){Eb(152876,5330);v[g+112>>2]=h;Fb(276579,g+112|0);break Fb}v[z>>2]=v[z>>2]+1}if((f|0)>1){continue}break}}Tb:{if(v[g+400>>2]){v[H>>2]=7;break Tb}Ub:{Vb:{if(v[q>>2]>(ka|0)|v[r>>2]>(y|0)|(v[u>>2]>(s|0)|v[z>>2]>(p|0))){break Vb}if(v[E>>2]>(o|0)|v[F>>2]>(n|0)){break Vb}if(v[G>>2]<=(m|0)){break Ub}}v[H>>2]=17;break Tb}v[H>>2]=3}h=1;break a}Eb(152876,k);v[g+96>>2]=h;Fb(276579,g+96|0)}Eb(152876,8587);v[g>>2]=h;Fb(276579,g)}ub=g+432|0;return h|0}function eo(a){var b=0,c=0,d=0,e=0,f=0,g=0;g=ub-16|0;ub=g;e=42;b=zka(a);a:{b:{if((b|0)!=1){break b}e=44;b=eV(a);if((b|0)!=1){break b}e=45;b=hZ(a);if((b|0)!=1){break b}e=46;b=Bia(a);if((b|0)!=1){break b}e=47;b=Zfa(a);if((b|0)!=1){break b}e=48;b=yfa(a);if((b|0)!=1){break b}e=49;b=$ea(a);if((b|0)!=1){break b}e=50;b=gca(a);if((b|0)!=1){break b}e=51;b=m9(a);if((b|0)!=1){break b}e=52;c=ub-16|0;ub=c;b=U7(a,1);if((b|0)!=1){Eb(148465,2692);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=53;b=E6(a);if((b|0)!=1){break b}e=54;b=u3(a);if((b|0)!=1){break b}e=55;b=n2(a);if((b|0)!=1){break b}e=56;b=Y$(a);if((b|0)!=1){break b}e=57;b=p$(a);if((b|0)!=1){break b}e=58;b=zV(a);if((b|0)!=1){break b}e=59;b=mV(a);if((b|0)!=1){break b}e=60;b=FU(a);if((b|0)!=1){break b}e=61;b=wU(a);if((b|0)!=1){break b}e=62;b=qU(a);if((b|0)!=1){break b}e=63;b=ema(a);if((b|0)!=1){break b}e=64;b=Yla(a);if((b|0)!=1){break b}e=65;b=Lla(a);if((b|0)!=1){break b}e=66;b=sla(a);if((b|0)!=1){break b}e=67;b=nla(a);if((b|0)!=1){break b}e=68;b=fla(a);if((b|0)!=1){break b}e=69;b=bla(a);if((b|0)!=1){break b}e=70;b=Tka(a);if((b|0)!=1){break b}e=71;b=daa(a);if((b|0)!=1){break b}e=74;b=cfa(a);if((b|0)!=1){break b}e=75;b=ifa(a);if((b|0)!=1){break b}e=76;c=ub-16|0;ub=c;d=229;b=Ig(a,c+12|0,68659,38887,90675,0);c:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1867;v[v[c+12>>2]+20>>2]=1868;b=1;break c}Eb(153657,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=77;c=ub-16|0;ub=c;d=2541;b=Ig(a,c+12|0,68678,23781,91693,0);d:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1850;v[v[c+12>>2]+20>>2]=1851;b=1;break d}Eb(153981,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=80;b=X1(a);if((b|0)!=1){break b}e=82;b=kfa(a);if((b|0)!=1){break b}e=83;b=Vea(a);if((b|0)!=1){break b}e=84;b=wea(a);if((b|0)!=1){break b}e=85;b=Sea(a);if((b|0)!=1){break b}e=86;b=Afa(a);if((b|0)!=1){break b}e=87;b=Efa(a);if((b|0)!=1){break b}e=88;b=Ffa(a);if((b|0)!=1){break b}e=89;c=ub-16|0;ub=c;d=457;b=Ig(a,c+12|0,68538,23166,37670,0);e:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1872;v[v[c+12>>2]+20>>2]=1873;b=1;break e}Eb(147745,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=90;b=Lea(a);if((b|0)!=1){break b}e=91;b=Eea(a);if((b|0)!=1){break b}e=92;b=Cfa(a);if((b|0)!=1){break b}e=93;b=Nea(a);if((b|0)!=1){break b}e=94;b=Gfa(a);if((b|0)!=1){break b}e=95;b=Bfa(a);if((b|0)!=1){break b}e=96;c=ub-16|0;ub=c;d=389;b=Ig(a,c+12|0,68730,39671,142230,0);f:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1812;v[v[c+12>>2]+20>>2]=1813;b=1;break f}Eb(160102,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=97;c=ub-16|0;ub=c;d=259;b=Ig(a,c+12|0,68518,46819,6226,0);g:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1817;v[v[c+12>>2]+20>>2]=1818;b=1;break g}Eb(144874,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=98;c=ub-16|0;ub=c;d=204;b=Ig(a,c+12|0,68528,38920,8863,0);h:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1845;v[v[c+12>>2]+20>>2]=1846;b=1;break h}Eb(145518,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=99;b=Pea(a);if((b|0)!=1){break b}e=100;b=Qea(a);if((b|0)!=1){break b}e=101;c=ub-16|0;ub=c;d=384;b=Ig(a,c+12|0,68689,23026,105800,0);i:{if((b|0)==1){v[v[c+12>>2]+12>>2]=1798;v[v[c+12>>2]+24>>2]=1799;b=1;break i}Eb(157334,d);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=103;b=Vga(a);if((b|0)!=1){break b}e=104;b=Uga(a);if((b|0)!=1){break b}e=105;b=Tga(a);if((b|0)!=1){break b}e=106;c=ub-16|0;ub=c;b=qj(a,c+12|0,105623,31421,-12e3,0,16,1658,0);if((b|0)!=1){Eb(157282,629);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=107;b=Qga(a);if((b|0)!=1){break b}e=108;b=Oga(a);if((b|0)!=1){break b}e=109;b=Mga(a);if((b|0)!=1){break b}e=110;d=ub-16|0;ub=d;c=1;f=366;b=qj(a,d+12|0,61270,64516,-1e4,-1,8,1677,0);j:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1678;break j}Eb(149084,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=111;d=ub-16|0;ub=d;c=1;f=204;b=qj(a,d+12|0,3878,53703,7e6,-1,4,1679,0);k:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1680;break k}Eb(144409,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=115;b=Iga(a);if((b|0)!=1){break b}e=116;c=ub-16|0;ub=c;b=qj(a,c+12|0,160662,30582,-9e6,0,16,1684,0);if((b|0)!=1){Eb(160150,701);v[c>>2]=b;Fb(276579,c)}ub=c+16|0;if((b|0)!=1){break b}e=117;d=ub-16|0;ub=d;c=1;f=212;b=qj(a,d+12|0,93218,59154,9e6,-1,4,1699,0);l:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1700;break l}Eb(154554,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=118;b=zga(a);if((b|0)!=1){break b}e=119;b=Fga(a);if((b|0)!=1){break b}e=120;b=Cga(a);if((b|0)!=1){break b}e=121;d=ub-16|0;ub=d;c=1;f=506;b=qj(a,d+12|0,105021,51800,-100,0,16,1697,0);m:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1698;break m}Eb(156866,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=122;b=$ga(a);if((b|0)!=1){break b}e=123;d=ub-16|0;ub=d;c=1;f=146;b=iq(a,d+12|0,8471,97553,-1e4,-1e6,1624,1625,0);n:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1626;break n}Eb(145251,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=124;d=ub-16|0;ub=d;c=1;f=140;b=iq(a,d+12|0,48321,97534,0,1e5,1627,1628,0);o:{if((b|0)==1){v[v[d+12>>2]+8>>2]=1629;break o}Eb(148621,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=125;b=Zga(a);if((b|0)!=1){break b}e=126;b=Yga(a);if((b|0)!=1){break b}e=127;b=Xga(a);if((b|0)!=1){break b}e=128;b=Wga(a);if((b|0)!=1){break b}e=129;b=xV(a);if((b|0)!=1){break b}e=130;d=ub-208|0;ub=d;f=Vb(v[v[a>>2]+4>>2],88,159224,693);p:{if(!f){Eb(159258,693);b=-1;v[d>>2]=-1;Fb(276579,d);break p}v[f+80>>2]=0;v[f>>2]=0;v[f+44>>2]=0;v[f+48>>2]=0;b=gq(f+40|0);if((b|0)!=1){Eb(159258,698);v[d+192>>2]=b;Fb(276579,d+192|0);break p}v[d+204>>2]=0;b=bm(a,d+204|0,128312,161500,0,f);if((b|0)!=1){Eb(159258,703);v[d+176>>2]=b;Fb(276579,d+176|0);break p}v[v[d+204>>2]+84>>2]=20;v[v[d+204>>2]+88>>2]=21;v[v[d+204>>2]+104>>2]=22;b=Qb(a,128258,191036,f+4|0,0,1,0);if((b|0)!=1){Eb(159258,715);v[d+112>>2]=b;Fb(276579,d+112|0);break p}b=Qb(a,202685,191699,f+12|0,0,0,0);if((b|0)!=1){Eb(159258,719);v[d+96>>2]=b;Fb(276579,d+96|0);break p}b=Qb(a,84487,191381,f+8|0,0,0,0);if((b|0)!=1){Eb(159258,723);v[d+80>>2]=b;Fb(276579,d+80|0);break p}b=Xb(a,28632,215816,f+16|0,0,-1,-1,2147483647,0,0);if((b|0)!=1){Eb(159258,727);v[d+64>>2]=b;Fb(276579,d- -64|0);break p}b=Yb(a,112685,128283,f+24|0,0,0,0,1,0,0);if((b|0)!=1){Eb(159258,731);v[d+48>>2]=b;Fb(276579,d+48|0);break p}b=1;c=Yb(a,84425,84540,f+32|0,0,0,0,1,0,0);if((c|0)!=1){Eb(159258,735);v[d+32>>2]=c;Fb(276579,d+32|0);b=c;break p}c=Xb(a,84457,84512,f+76|0,0,65e3,0,65e3,0,0);if((c|0)==1){break p}Eb(159258,739);v[d+16>>2]=c;Fb(276579,d+16|0);b=c}ub=d+208|0;if((b|0)!=1){break b}e=131;b=YU(a);if((b|0)!=1){break b}e=132;b=vU(a);if((b|0)!=1){break b}e=133;b=dma(a);if((b|0)!=1){break b}e=134;b=Kla(a);if((b|0)!=1){break b}e=135;d=ub-704|0;ub=d;b=Vb(v[v[a>>2]+4>>2],12,159680,6205);q:{if(!b){Eb(159714,6205);c=-1;v[d>>2]=-1;Fb(276579,d);break q}c=Vb(v[v[a>>2]+4>>2],152,159680,6206);v[b>>2]=c;if(!c){Eb(159714,6206);c=-1;v[d+16>>2]=-1;Fb(276579,d+16|0);break q}c=Vb(v[v[a>>2]+4>>2],64,159680,6207);v[b+4>>2]=c;if(!c){Eb(159714,6207);c=-1;v[d+32>>2]=-1;Fb(276579,d+32|0);break q}v[c+52>>2]=0;v[b+8>>2]=0;v[v[b>>2]+116>>2]=0;c=bm(a,d+700|0,138971,44903,0,b);if((c|0)!=1){Eb(159714,6214);v[d+688>>2]=c;Fb(276579,d+688|0);break q}v[v[d+700>>2]+80>>2]=42;v[v[d+700>>2]+84>>2]=43;v[v[d+700>>2]+88>>2]=44;v[v[d+700>>2]+92>>2]=45;v[v[d+700>>2]+100>>2]=46;v[v[d+700>>2]+104>>2]=47;c=Qb(a,42107,193518,v[b>>2]+56|0,1,0,0);if((c|0)!=1){Eb(159714,6230);v[d+576>>2]=c;Fb(276579,d+576|0);break q}c=Xb(a,6935,221558,v[b>>2]+60|0,1,0,0,2,0,0);if((c|0)!=1){Eb(159714,6234);v[d+560>>2]=c;Fb(276579,d+560|0);break q}c=Xb(a,42237,162617,v[b>>2]+16|0,1,1,0,2147483647,0,0);if((c|0)!=1){Eb(159714,6238);v[d+544>>2]=c;Fb(276579,d+544|0);break q}c=Xb(a,42067,162461,v[b>>2]+20|0,1,0,0,2147483647,0,0);if((c|0)!=1){Eb(159714,6242);v[d+528>>2]=c;Fb(276579,d+528|0);break q}c=Xb(a,60140,162766,v[b>>2]+24|0,1,1,0,2147483647,0,0);if((c|0)!=1){Eb(159714,6246);v[d+512>>2]=c;Fb(276579,d+512|0);break q}c=ce(a,122770,135367,v[b>>2],1,10,0,0,0,-1,2147483647);if((c|0)!=1){Eb(159714,6250);v[d+496>>2]=c;Fb(276579,d+496|0);break q}c=ce(a,160757,135282,v[b>>2]+8|0,1,10,0,0,0,-1,2147483647);if((c|0)!=1){Eb(159714,6254);v[d+480>>2]=c;Fb(276579,d+480|0);break q}c=Xb(a,95566,210731,v[b>>2]+28|0,1,2,1,2147483647,0,0);if((c|0)!=1){Eb(159714,6257);v[d+464>>2]=c;Fb(276579,d+464|0);break q}c=Qb(a,77026,193570,v[b>>2]+40|0,1,1,0);if((c|0)!=1){Eb(159714,6261);v[d+448>>2]=c;Fb(276579,d+448|0);break q}c=Qb(a,39761,193895,v[b>>2]+44|0,1,0,0);if((c|0)!=1){Eb(159714,6265);v[d+432>>2]=c;Fb(276579,d+432|0);break q}c=Qb(a,58963,175040,v[b>>2]+48|0,1,0,0);if((c|0)!=1){Eb(159714,6269);v[d+416>>2]=c;Fb(276579,d+416|0);break q}c=Qb(a,60104,193251,v[b>>2]+52|0,1,0,0);if((c|0)!=1){Eb(159714,6273);v[d+400>>2]=c;Fb(276579,d+400|0);break q}c=Qb(a,41949,194149,v[b>>2]- -64|0,1,0,0);if((c|0)!=1){Eb(159714,6277);v[d+384>>2]=c;Fb(276579,d+384|0);break q}c=Qb(a,135496,210753,v[b>>2]+68|0,1,1,0);if((c|0)!=1){Eb(159714,6281);v[d+368>>2]=c;Fb(276579,d+368|0);break q}c=Xb(a,59784,209721,v[b>>2]+32|0,1,4,1,2147483647,0,0);if((c|0)!=1){Eb(159714,6284);v[d+352>>2]=c;Fb(276579,d+352|0);break q}c=Xb(a,59748,209647,v[b>>2]+36|0,1,2,0,2147483647,0,0);if((c|0)!=1){Eb(159714,6287);v[d+336>>2]=c;Fb(276579,d+336|0);break q}c=Qb(a,46142,190666,v[b>>2]+72|0,1,1,0);if((c|0)!=1){Eb(159714,6291);v[d+320>>2]=c;Fb(276579,d+320|0);break q}c=Qb(a,90619,181071,v[b>>2]+76|0,1,1,0);if((c|0)!=1){Eb(159714,6295);v[d+304>>2]=c;Fb(276579,d+304|0);break q}c=Qb(a,74283,209012,v[b>>2]+80|0,1,0,0);if((c|0)!=1){Eb(159714,6299);v[d+288>>2]=c;Fb(276579,d+288|0);break q}c=Qb(a,114759,196037,v[b>>2]+84|0,1,0,0);if((c|0)!=1){Eb(159714,6303);v[d+272>>2]=c;Fb(276579,d+272|0);break q}c=Qb(a,114661,196107,v[b>>2]+88|0,1,0,0);if((c|0)!=1){Eb(159714,6307);v[d+256>>2]=c;Fb(276579,d+256|0);break q}c=Qb(a,110911,110949,v[b>>2]+92|0,1,0,0);if((c|0)!=1){Eb(159714,6311);v[d+240>>2]=c;Fb(276579,d+240|0);break q}c=Qb(a,113712,189431,v[b>>2]+96|0,1,1,0);if((c|0)!=1){Eb(159714,6315);v[d+224>>2]=c;Fb(276579,d+224|0);break q}c=Qb(a,161176,168428,v[b>>2]+100|0,1,1,0);if((c|0)!=1){Eb(159714,6319);v[d+208>>2]=c;Fb(276579,d+208|0);break q}c=Qb(a,59002,193171,v[b>>2]+104|0,1,0,0);if((c|0)!=1){Eb(159714,6323);v[d+192>>2]=c;Fb(276579,d+192|0);break q}c=Qb(a,60066,194238,v[b>>2]+108|0,1,0,0);if((c|0)!=1){Eb(159714,6327);v[d+176>>2]=c;Fb(276579,d+176|0);break q}c=Qb(a,31843,175594,v[b>>2]+112|0,1,0,0);if((c|0)!=1){Eb(159714,6331);v[d+160>>2]=c;Fb(276579,d+160|0);break q}c=Xb(a,58078,215712,v[b>>2]+120|0,1,0,-1,2147483647,0,0);if((c|0)!=1){Eb(159714,6335);v[d+144>>2]=c;Fb(276579,d+144|0);break q}c=Ff(a,77214,92031,v[b>>2]+124|0,1,97,161332);if((c|0)!=1){Eb(159714,6339);v[d+128>>2]=c;Fb(276579,d+128|0);break q}c=Ff(a,77129,44858,v[b>>2]+125|0,1,120,5929);if((c|0)!=1){Eb(159714,6343);v[d+112>>2]=c;Fb(276579,d+112|0);break q}c=Ff(a,77171,101746,v[b>>2]+126|0,1,100,68921);if((c|0)!=1){Eb(159714,6347);v[d+96>>2]=c;Fb(276579,d+96|0);break q}c=Yb(a,20646,81263,v[b>>2]+128|0,1,.8,0,17976931348623157e292,0,0);if((c|0)!=1){Eb(159714,6351);v[d+80>>2]=c;Fb(276579,d+80|0);break q}c=Yb(a,63906,236658,v[b>>2]+136|0,1,-1,-1,17976931348623157e292,0,0);if((c|0)!=1){Eb(159714,6355);v[d+64>>2]=c;Fb(276579,d- -64|0);break q}c=1;b=Qb(a,85306,184900,v[b>>2]+144|0,1,0,0);if((b|0)==1){break q}Eb(159714,6359);v[d+48>>2]=b;Fb(276579,d+48|0);c=b}ub=d+704|0;b=c;if((b|0)!=1){break b}e=136;b=Cka(a);if((b|0)!=1){break b}e=137;b=Aka(a);if((b|0)!=1){break b}e=138;b=uka(a);if((b|0)!=1){break b}e=139;b=hka(a);if((b|0)!=1){break b}e=140;b=dka(a);if((b|0)!=1){break b}e=141;b=Tja(a);if((b|0)!=1){break b}e=142;b=Fja(a);if((b|0)!=1){break b}e=143;b=wka(a);if((b|0)!=1){break b}e=144;d=ub-400|0;ub=d;f=Vb(v[v[a>>2]+4>>2],160,158350,1517);r:{if(!f){Eb(158384,1517);b=-1;v[d>>2]=-1;Fb(276579,d);break r}v[f+148>>2]=0;v[f+16>>2]=0;v[f+8>>2]=0;v[f+12>>2]=0;v[f+140>>2]=-1;v[f+144>>2]=0;v[f+108>>2]=0;b=U9(f+108|0);if((b|0)!=1){Eb(158384,1530);v[d+384>>2]=b;Fb(276579,d+384|0);break r}v[d+396>>2]=0;b=Fe(a,d+396|0,114504,122501,904,f);if((b|0)!=1){Eb(158384,1536);v[d+368>>2]=b;Fb(276579,d+368|0);break r}b=Ze(a,56028,21832,202905,0,0,0,0,905,7,4e4,500,1);if((b|0)!=1){Eb(158384,1542);v[d+352>>2]=b;Fb(276579,d+352|0);break r}b=Ze(a,140446,16412,140461,0,0,0,0,906,6,4e4,550,1);if((b|0)!=1){Eb(158384,1545);v[d+336>>2]=b;Fb(276579,d+336|0);break r}v[v[d+396>>2]+8>>2]=0;v[v[d+396>>2]+12>>2]=907;v[v[d+396>>2]+16>>2]=908;v[v[d+396>>2]+20>>2]=909;v[v[d+396>>2]+24>>2]=910;v[v[d+396>>2]+28>>2]=911;b=Qb(a,136866,176573,f+4|0,0,0,0);if((b|0)!=1){Eb(158384,1557);v[d+224>>2]=b;Fb(276579,d+224|0);break r}b=Qb(a,125990,171575,f+84|0,0,0,0);if((b|0)!=1){Eb(158384,1560);v[d+208>>2]=b;Fb(276579,d+208|0);break r}b=fs(a,117402,46882,f+8|0,0,211952);if((b|0)!=1){Eb(158384,1563);v[d+192>>2]=b;Fb(276579,d+192|0);break r}b=fs(a,117455,46955,f+12|0,0,211952);if((b|0)!=1){Eb(158384,1566);v[d+176>>2]=b;Fb(276579,d+176|0);break r}b=fs(a,117428,47028,f+16|0,0,211952);if((b|0)!=1){Eb(158384,1569);v[d+160>>2]=b;Fb(276579,d+160|0);break r}b=ce(a,22172,39713,f+48|0,0,50,0,1,0,-1,2147483647);if((b|0)!=1){Eb(158384,1572);v[d+144>>2]=b;Fb(276579,d+144|0);break r}b=Qb(a,94453,185166,f- -64|0,0,0,0);if((b|0)!=1){Eb(158384,1574);v[d+128>>2]=b;Fb(276579,d+128|0);break r}b=Ff(a,128722,202967,f+44|0,0,114,65429);if((b|0)!=1){Eb(158384,1577);v[d+112>>2]=b;Fb(276579,d+112|0);break r}b=Qb(a,93131,188169,f+68|0,0,0,0);if((b|0)!=1){Eb(158384,1580);v[d+96>>2]=b;Fb(276579,d+96|0);break r}b=Qb(a,202561,185091,f+72|0,0,0,0);if((b|0)!=1){Eb(158384,1584);v[d+80>>2]=b;Fb(276579,d+80|0);break r}b=Qb(a,202312,185221,f+76|0,0,0,0);if((b|0)!=1){Eb(158384,1588);v[d+64>>2]=b;Fb(276579,d- -64|0);break r}b=Yb(a,111031,88152,f+24|0,0,1e99,-17976931348623157e292,17976931348623157e292,0,0);if((b|0)!=1){Eb(158384,1591);v[d+48>>2]=b;Fb(276579,d+48|0);break r}b=1;c=Ff(a,115917,40518,f,0,110,14156);if((c|0)!=1){Eb(158384,1595);v[d+32>>2]=c;Fb(276579,d+32|0);b=c;break r}c=Qb(a,46852,173846,f+80|0,0,1,0);if((c|0)==1){break r}Eb(158384,1599);v[d+16>>2]=c;Fb(276579,d+16|0);b=c}ub=d+400|0;if((b|0)!=1){break b}e=145;b=vja(a);if((b|0)!=1){break b}e=146;b=kja(a);if((b|0)!=1){break b}e=147;b=Dja(a);if((b|0)!=1){break b}e=148;b=Cja(a);if((b|0)!=1){break b}e=149;b=Aja(a);if((b|0)!=1){break b}e=150;b=yja(a);if((b|0)!=1){break b}e=151;b=wja(a);if((b|0)!=1){break b}e=152;b=uja(a);if((b|0)!=1){break b}e=153;b=sja(a);if((b|0)!=1){break b}e=154;b=rja(a);if((b|0)!=1){break b}e=155;b=oja(a);if((b|0)!=1){break b}e=156;b=mja(a);if((b|0)!=1){break b}e=157;b=lja(a);if((b|0)!=1){break b}e=158;d=ub-336|0;ub=d;v[d+332>>2]=0;f=Vb(v[v[a>>2]+4>>2],208,154231,2796);s:{if(!f){Eb(154265,2796);b=-1;v[d>>2]=-1;Fb(276579,d);break s}dc(f,208);b=le(a,d+332|0,92373,49587,76,-10,-1,0,-1,24,1,1247,f);if((b|0)!=1){Eb(154265,2805);v[d+320>>2]=b;Fb(276579,d+320|0);break s}v[v[d+332>>2]+36>>2]=1248;v[v[d+332>>2]+40>>2]=1249;v[v[d+332>>2]+44>>2]=1250;v[v[d+332>>2]+48>>2]=1251;v[v[d+332>>2]+52>>2]=1252;b=Qb(a,31459,109186,f+164|0,1,0,0);if((b|0)!=1){Eb(154265,2818);v[d+224>>2]=b;Fb(276579,d+224|0);break s}b=Qb(a,67313,99293,f+188|0,1,1,0);if((b|0)!=1){Eb(154265,2822);v[d+208>>2]=b;Fb(276579,d+208|0);break s}b=Qb(a,48733,122854,f+192|0,0,0,0);if((b|0)!=1){Eb(154265,2826);v[d+192>>2]=b;Fb(276579,d+192|0);break s}b=Qb(a,34474,53762,f+196|0,0,0,0);if((b|0)!=1){Eb(154265,2830);v[d+176>>2]=b;Fb(276579,d+176|0);break s}b=Qb(a,36502,51929,f+200|0,0,0,0);if((b|0)!=1){Eb(154265,2834);v[d+160>>2]=b;Fb(276579,d+160|0);break s}b=Xb(a,91885,103864,f+120|0,0,0,0,4,0,0);if((b|0)!=1){Eb(154265,2838);v[d+144>>2]=b;Fb(276579,d+144|0);break s}b=Xb(a,91981,203177,f+124|0,0,0,0,1,0,0);if((b|0)!=1){Eb(154265,2842);v[d+128>>2]=b;Fb(276579,d+128|0);break s}b=Xb(a,111058,136569,f+128|0,0,10,0,2147483647,0,0);if((b|0)!=1){Eb(154265,2846);v[d+112>>2]=b;Fb(276579,d+112|0);break s}b=Xb(a,44155,233872,f+132|0,0,25,0,2147483647,0,0);if((b|0)!=1){Eb(154265,2850);v[d+96>>2]=b;Fb(276579,d+96|0);break s}b=Xb(a,96239,117156,f+140|0,0,0,0,1,0,0);if((b|0)!=1){Eb(154265,2854);v[d+80>>2]=b;Fb(276579,d+80|0);break s}b=Xb(a,45164,203074,f+144|0,0,50,-1,2147483647,0,0);if((b|0)!=1){Eb(154265,2858);v[d+64>>2]=b;Fb(276579,d- -64|0);break s}b=Yb(a,73399,103766,f+88|0,0,5,0,100,0,0);if((b|0)!=1){Eb(154265,2862);v[d+48>>2]=b;Fb(276579,d+48|0);break s}b=1;c=Yb(a,94351,73614,f+96|0,0,1,.1,A[v[a+4>>2]+1272>>3],0,0);if((c|0)!=1){Eb(154265,2866);v[d+32>>2]=c;Fb(276579,d+32|0);b=c;break s}c=Yb(a,94699,77448,f+104|0,0,0,0,1,0,0);if((c|0)==1){break s}Eb(154265,2870);v[d+16>>2]=c;Fb(276579,d+16|0);b=c}ub=d+336|0;if((b|0)!=1){break b}e=159;b=gja(a);if((b|0)!=1){break b}e=160;b=eja(a);if((b|0)!=1){break b}e=161;b=aja(a);if((b|0)!=1){break b}e=162;b=$ia(a);if((b|0)!=1){break b}e=163;b=_ia(a);if((b|0)!=1){break b}e=164;b=Xia(a);if((b|0)!=1){break b}e=165;b=Aha(a);if((b|0)!=1){break b}e=166;b=Wia(a);if((b|0)!=1){break b}e=167;b=Uia(a);if((b|0)!=1){break b}e=168;b=Tia(a);if((b|0)!=1){break b}e=169;b=Ria(a);if((b|0)!=1){break b}e=170;b=Qia(a);if((b|0)!=1){break b}e=171;b=Mia(a);if((b|0)!=1){break b}e=172;b=Oia(a);if((b|0)!=1){break b}e=173;b=Lia(a);if((b|0)!=1){break b}e=174;b=Cia(a);if((b|0)!=1){break b}e=175;b=Hia(a);if((b|0)!=1){break b}e=176;b=Gia(a);if((b|0)!=1){break b}e=177;b=Eia(a);if((b|0)!=1){break b}e=178;b=yia(a);if((b|0)!=1){break b}e=179;b=wia(a);if((b|0)!=1){break b}e=180;b=ria(a);if((b|0)!=1){break b}e=181;b=qia(a);if((b|0)!=1){break b}e=182;b=nia(a);if((b|0)!=1){break b}e=183;b=hia(a);if((b|0)!=1){break b}e=184;b=gia(a);if((b|0)!=1){break b}e=185;b=eia(a);if((b|0)!=1){break b}e=186;b=cia(a);if((b|0)!=1){break b}e=187;b=fia(a);if((b|0)!=1){break b}e=188;d=ub-256|0;ub=d;c=zd(104,150118,1293);t:{if(!c){Eb(150152,1293);b=-1;v[d>>2]=-1;Fb(276579,d);break t}v[d+252>>2]=0;b=le(a,d+252|0,65915,75804,76,-20,-1,0,-1,24,1,1422,c);if((b|0)!=1){Eb(150152,1300);v[d+240>>2]=b;Fb(276579,d+240|0);break t}v[v[d+252>>2]+36>>2]=1423;v[v[d+252>>2]+40>>2]=1424;v[v[d+252>>2]+44>>2]=1425;v[c+4>>2]=0;b=fs(a,117582,120638,c+4|0,0,211952);if((b|0)!=1){Eb(150152,1316);v[d+176>>2]=b;Fb(276579,d+176|0);break t}b=Qb(a,19898,253308,c+84|0,0,1,0);if((b|0)!=1){Eb(150152,1322);v[d+160>>2]=b;Fb(276579,d+160|0);break t}b=Qb(a,63778,180265,c+88|0,0,0,0);if((b|0)!=1){Eb(150152,1327);v[d+144>>2]=b;Fb(276579,d+144|0);break t}b=Qb(a,6128,180211,c+92|0,0,1,0);if((b|0)!=1){Eb(150152,1332);v[d+128>>2]=b;Fb(276579,d+128|0);break t}b=Qb(a,36897,180353,c+96|0,0,0,0);if((b|0)!=1){Eb(150152,1337);v[d+112>>2]=b;Fb(276579,d+112|0);break t}b=Yb(a,161604,46779,c+40|0,1,2,0,100,0,0);if((b|0)!=1){Eb(150152,1340);v[d+96>>2]=b;Fb(276579,d+96|0);break t}b=Xb(a,47526,56095,c+72|0,0,500,0,2147483647,0,0);if((b|0)!=1){Eb(150152,1344);v[d+80>>2]=b;Fb(276579,d+80|0);break t}b=Xb(a,54435,88034,c+76|0,1,5e3,0,2147483647,0,0);if((b|0)!=1){Eb(150152,1348);v[d+64>>2]=b;Fb(276579,d- -64|0);break t}b=Xb(a,55146,87827,c+80|0,1,50,0,2147483647,0,0);if((b|0)!=1){Eb(150152,1352);v[d+48>>2]=b;Fb(276579,d+48|0);break t}b=Yb(a,10973,88374,c+48|0,0,.1,0,1,0,0);if((b|0)!=1){Eb(150152,1356);v[d+32>>2]=b;Fb(276579,d+32|0);break t}b=1;c=Yb(a,113146,133610,c+56|0,0,.3,0,1,0,0);if((c|0)==1){break t}Eb(150152,1360);v[d+16>>2]=c;Fb(276579,d+16|0);b=c}ub=d+256|0;if((b|0)!=1){break b}e=189;b=bia(a);if((b|0)!=1){break b}e=190;b=aia(a);if((b|0)!=1){break b}e=191;b=$ha(a);if((b|0)!=1){break b}e=192;b=Zha(a);if((b|0)!=1){break b}e=193;b=Vha(a);if((b|0)!=1){break b}e=194;b=Tha(a);if((b|0)!=1){break b}e=195;b=Rha(a);if((b|0)!=1){break b}e=196;d=ub-16|0;ub=d;c=1;f=258;b=le(a,d+12|0,93218,38961,116,1e4,0,0,-1,257,0,1484,0);u:{if((b|0)==1){v[v[d+12>>2]+32>>2]=1485;break u}Eb(154504,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=197;d=ub-16|0;ub=d;c=1;f=267;b=le(a,d+12|0,82580,208819,112,39990,0,0,0,1,0,1486,0);v:{if((b|0)==1){v[v[d+12>>2]+32>>2]=1487;break v}Eb(152598,f);v[d>>2]=b;Fb(276579,d);c=b}ub=d+16|0;b=c;if((b|0)!=1){break b}e=198;b=Nha(a);if((b|0)!=1){break b}e=199;b=Mha(a);if((b|0)!=1){break b}e=200;b=Jha(a);if((b|0)!=1){break b}e=201;b=Gha(a);if((b|0)!=1){break b}e=202;b=Cha(a);if((b|0)!=1){break b}e=203;b=Bha(a);if((b|0)!=1){break b}e=204;b=zha(a);if((b|0)!=1){break b}e=205;b=wga(a);if((b|0)!=1){break b}e=206;b=sga(a);if((b|0)!=1){break b}e=207;b=jga(a);if((b|0)!=1){break b}e=208;d=ub-224|0;ub=d;v[d+220>>2]=0;b=Vb(v[v[a>>2]+4>>2],160,147125,733);w:{if(!b){Eb(147159,733);c=-1;v[d>>2]=-1;Fb(276579,d);break w}dc(b,160);c=io(a,d+220|0,22772,113598,-11e5,-1,1,4,1719,b);if((c|0)!=1){Eb(147159,738);v[d+208>>2]=c;Fb(276579,d+208|0);break w}v[v[d+220>>2]+44>>2]=1720;v[v[d+220>>2]+64>>2]=1721;v[v[d+220>>2]+68>>2]=1722;c=Yb(a,143356,127655,b+112|0,1,.01,0,1,0,0);if((c|0)!=1){Eb(147159,747);v[d+144>>2]=c;Fb(276579,d+144|0);break w}c=Yb(a,143386,127842,b+120|0,1,.01,0,1,0,0);if((c|0)!=1){Eb(147159,751);v[d+128>>2]=c;Fb(276579,d+128|0);break w}c=Yb(a,142305,64545,b+128|0,1,.2,0,A[v[a+4>>2]+1272>>3],0,0);if((c|0)!=1){Eb(147159,755);v[d+112>>2]=c;Fb(276579,d+112|0);break w}c=Yb(a,142509,64612,b+136|0,1,.02,0,A[v[a+4>>2]+1272>>3],0,0);if((c|0)!=1){Eb(147159,759);v[d+96>>2]=c;Fb(276579,d+96|0);break w}c=Qb(a,24600,191e3,b+144|0,0,1,0);if((c|0)!=1){Eb(147159,763);v[d+80>>2]=c;Fb(276579,d+80|0);break w}c=Xb(a,18344,19320,b+52|0,1,500,0,2147483647,0,0);if((c|0)!=1){Eb(147159,767);v[d+64>>2]=c;Fb(276579,d- -64|0);break w}c=Yb(a,18919,19277,b+56|0,1,0,0,17976931348623157e292,0,0);if((c|0)!=1){Eb(147159,771);v[d+48>>2]=c;Fb(276579,d+48|0);break w}c=Xb(a,91918,66308,b- -64|0,1,0,0,5,0,0);if((c|0)!=1){Eb(147159,775);v[d+32>>2]=c;Fb(276579,d+32|0);break w}c=1;b=Yb(a,63321,123341,b+152|0,1,2,0,17976931348623157e292,0,0);if((b|0)==1){break w}Eb(147159,779);v[d+16>>2]=b;Fb(276579,d+16|0);c=b}ub=d+224|0;b=c;if((b|0)!=1){break b}e=209;b=cga(a);if((b|0)!=1){break b}e=210;b=_fa(a);if((b|0)!=1){break b}e=211;b=Tfa(a);if((b|0)!=1){break b}e=212;b=Rfa(a);if((b|0)!=1){break b}e=213;d=ub-656|0;ub=d;v[d+652>>2]=0;b=Vb(v[v[a>>2]+4>>2],368,144132,7373);x:{if(!b){Eb(144166,7373);c=-1;v[d>>2]=-1;Fb(276579,d);break x}v[b+8>>2]=0;v[b+12>>2]=-1;v[b>>2]=0;v[b+4>>2]=0;v[b+16>>2]=0;v[b+20>>2]=0;v[b+60>>2]=0;v[b+64>>2]=0;v[b+52>>2]=0;v[b+56>>2]=-1;v[b+88>>2]=0;v[b+92>>2]=-1074790400;v[b+224>>2]=0;v[b+96>>2]=0;v[b+240>>2]=0;v[b+216>>2]=0;v[b+220>>2]=0;v[b+156>>2]=0;v[b+160>>2]=0;v[b+132>>2]=0;v[b+136>>2]=-1;v[b+176>>2]=0;v[b+180>>2]=0;v[b+24>>2]=0;v[b+28>>2]=0;v[b+68>>2]=0;v[b+72>>2]=0;v[b+76>>2]=0;v[b+80>>2]=-1;v[b+184>>2]=0;v[b+188>>2]=0;v[b+192>>2]=0;v[b+196>>2]=0;v[b+272>>2]=0;v[b+276>>2]=0;v[b+264>>2]=0;v[b+268>>2]=0;v[b+256>>2]=0;v[b+260>>2]=0;v[b+248>>2]=0;v[b+252>>2]=0;v[b+32>>2]=-1;v[b+300>>2]=0;v[b+292>>2]=0;v[b+296>>2]=0;v[b+36>>2]=0;v[b+40>>2]=0;v[b+44>>2]=0;v[b+48>>2]=0;v[b+304>>2]=-1;v[b+308>>2]=-1;v[b+352>>2]=0;v[b+344>>2]=0;v[b+348>>2]=0;v[b+312>>2]=0;v[b+316>>2]=0;v[b+244>>2]=0;v[b+320>>2]=0;v[b+324>>2]=0;v[b+328>>2]=0;c=Fe(a,b+244|0,3499,99044,1764,0);if((c|0)!=1){Eb(144166,7445);v[d+640>>2]=c;Fb(276579,d+640|0);break x}c=io(a,d+652|0,3499,3475,-1e6,1,0,1,1765,b);if((c|0)!=1){Eb(144166,7450);v[d+624>>2]=c;Fb(276579,d+624|0);break x}v[v[d+652>>2]+44>>2]=1766;v[v[d+652>>2]+52>>2]=1767;v[v[d+652>>2]+56>>2]=1768;v[v[d+652>>2]+60>>2]=1769;v[v[d+652>>2]+80>>2]=1770;c=Nt(a,v[d+652>>2],1771,-1e7,16);if((c|0)!=1){Eb(144166,7458);v[d+528>>2]=c;Fb(276579,d+528|0);break x}c=Vb(v[v[a>>2]+4>>2],4,144132,7461);if(!c){Eb(144166,7461);c=-1;v[d+16>>2]=-1;Fb(276579,d+16|0);break x}v[c>>2]=b;c=Fg(a,98998,60900,1,0,1772,1773,c,7001,9);if((c|0)!=1){Eb(144166,7465);v[d+512>>2]=c;Fb(276579,d+512|0);break x}c=Xb(a,34325,216403,b+100|0,1,1500,0,2147483647,0,0);if((c|0)!=1){Eb(144166,7471);v[d+496>>2]=c;Fb(276579,d+496|0);break x}c=Qb(a,53583,179183,b+104|0,1,0,0);if((c|0)!=1){Eb(144166,7476);v[d+480>>2]=c;Fb(276579,d+480|0);break x}c=Qb(a,36632,188977,b+108|0,1,0,0);if((c|0)!=1){Eb(144166,7481);v[d+464>>2]=c;Fb(276579,d+464|0);break x}c=Qb(a,40194,179953,b+144|0,1,0,0);if((c|0)!=1){Eb(144166,7486);v[d+448>>2]=c;Fb(276579,d+448|0);break x}c=Qb(a,72799,194914,b+164|0,1,1,0);if((c|0)!=1){Eb(144166,7492);v[d+432>>2]=c;Fb(276579,d+432|0);break x}c=Qb(a,45715,176462,b+168|0,1,0,0);if((c|0)!=1){Eb(144166,7497);v[d+416>>2]=c;Fb(276579,d+416|0);break x}c=Qb(a,50793,173554,b+200|0,1,1,0);if((c|0)!=1){Eb(144166,7502);v[d+400>>2]=c;Fb(276579,d+400|0);break x}c=Qb(a,37310,174081,b+204|0,1,1,0);if((c|0)!=1){Eb(144166,7507);v[d+384>>2]=c;Fb(276579,d+384|0);break x}c=Qb(a,61278,171086,b+208|0,1,1,0);if((c|0)!=1){Eb(144166,7512);v[d+368>>2]=c;Fb(276579,d+368|0);break x}c=Xb(a,102896,232322,b+172|0,1,2,0,2,0,0);if((c|0)!=1){Eb(144166,7517);v[d+352>>2]=c;Fb(276579,d+352|0);break x}c=Xb(a,102969,230567,b+288|0,1,2,0,2,0,0);if((c|0)!=1){Eb(144166,7523);v[d+336>>2]=c;Fb(276579,d+336|0);break x}c=Qb(a,99489,182213,b+280|0,1,0,0);if((c|0)!=1){Eb(144166,7528);v[d+320>>2]=c;Fb(276579,d+320|0);break x}c=Xb(a,9959,225845,b+284|0,1,0,0,0,0,0);if((c|0)!=1){Eb(144166,7533);v[d+304>>2]=c;Fb(276579,d+304|0);break x}c=Qb(a,53543,166868,b+112|0,1,1,0);if((c|0)!=1){Eb(144166,7538);v[d+288>>2]=c;Fb(276579,d+288|0);break x}c=Yb(a,132129,210034,b+120|0,1,.5,0,1,0,0);if((c|0)!=1){Eb(144166,7543);v[d+272>>2]=c;Fb(276579,d+272|0);break x}c=Qb(a,1569,177996,b+140|0,1,0,0);if((c|0)!=1){Eb(144166,7548);v[d+256>>2]=c;Fb(276579,d+256|0);break x}c=Xb(a,71404,134741,b+228|0,1,5e5,0,2147483647,0,0);if((c|0)!=1){Eb(144166,7553);v[d+240>>2]=c;Fb(276579,d+240|0);break x}c=Qb(a,72039,50830,b+232|0,1,1,0);if((c|0)!=1){Eb(144166,7558);v[d+224>>2]=c;Fb(276579,d+224|0);break x}c=Qb(a,61311,190755,b+212|0,1,0,0);if((c|0)!=1){Eb(144166,7563);v[d+208>>2]=c;Fb(276579,d+208|0);break x}c=Xb(a,118047,226274,b+336|0,1,1,0,2,0,0);if((c|0)!=1){Eb(144166,7568);v[d+192>>2]=c;Fb(276579,d+192|0);break x}c=Xb(a,117980,230287,b+332|0,1,0,0,3,0,0);if((c|0)!=1){Eb(144166,7573);v[d+176>>2]=c;Fb(276579,d+176|0);break x}c=Xb(a,115937,37053,b+340|0,1,14,1,15,0,0);if((c|0)!=1){Eb(144166,7579);v[d+160>>2]=c;Fb(276579,d+160|0);break x}c=Qb(a,25878,185923,b+356|0,1,1,0);if((c|0)!=1){Eb(144166,7584);v[d+144>>2]=c;Fb(276579,d+144|0);break x}c=Qb(a,26527,194106,b+360|0,1,1,0);if((c|0)!=1){Eb(144166,7589);v[d+128>>2]=c;Fb(276579,d+128|0);break x}c=Qb(a,31363,173449,b+364|0,1,1,0);if((c|0)!=1){Eb(144166,7594);v[d+112>>2]=c;Fb(276579,d+112|0);break x}c=Qb(a,36123,184116,b+148|0,1,0,0);if((c|0)!=1){Eb(144166,7599);v[d+96>>2]=c;Fb(276579,d+96|0);break x}c=Qb(a,3418,190853,b+152|0,1,1,0);if((c|0)!=1){Eb(144166,7604);v[d+80>>2]=c;Fb(276579,d+80|0);break x}c=1;b=Qb(a,24222,178086,b+236|0,1,1,0);if((b|0)!=1){Eb(144166,7609);v[d+64>>2]=b;Fb(276579,d- -64|0);c=b}}ub=d+656|0;b=c;if((b|0)!=1){break b}e=214;b=Kfa(a);if((b|0)!=1){break b}e=215;b=vea(a);if((b|0)!=1){break b}e=216;b=tea(a);if((b|0)!=1){break b}e=217;b=pea(a);if((b|0)!=1){break b}e=218;b=oea(a);if((b|0)!=1){break b}e=219;d=ub-96|0;ub=d;b=Vb(v[v[a>>2]+4>>2],56,154769,844);y:{if(!b){Eb(154803,844);c=-1;v[d>>2]=-1;Fb(276579,d);break y}dc(b,56);c=mi(a,d+92|0,94494,84599,0,-1,1,0,1,1910,0,b);if((c|0)!=1){Eb(154803,853);v[d+80>>2]=c;Fb(276579,d+80|0);break y}v[v[d+92>>2]+116>>2]=1911;v[v[d+92>>2]+132>>2]=1912;c=Xb(a,95242,240543,b+48|0,0,-1,-1,2147483647,0,0);if((c|0)!=1){Eb(154803,863);v[d+32>>2]=c;Fb(276579,d+32|0);break y}c=1;b=Xb(a,18376,19320,b+44|0,1,250,0,2147483647,0,0);if((b|0)==1){break y}Eb(154803,867);v[d+16>>2]=b;Fb(276579,d+16|0);c=b}ub=d+96|0;b=c;if((b|0)!=1){break b}e=220;b=kea(a);if((b|0)!=1){break b}e=221;b=hea(a);if((b|0)!=1){break b}e=222;c=ub-80|0;ub=c;d=a;a=Vb(v[v[a>>2]+4>>2],44,158889,996);z:{if(!a){Eb(158923,996);b=-1;v[c>>2]=-1;Fb(276579,c);break z}dc(a,44);b=mi(d,c+76|0,122090,64436,0,-1,1,0,0,1921,0,a);if((b|0)!=1){Eb(158923,1005);v[c+64>>2]=b;Fb(276579,c- -64|0);break z}v[v[c+76>>2]+116>>2]=1922;b=1;v[v[c+76>>2]+132>>2]=1923;a=Xb(d,18411,19320,a+40|0,1,1e3,0,2147483647,0,0);if((a|0)==1){break z}Eb(158923,1016);v[c+16>>2]=a;Fb(276579,c+16|0);b=a}ub=c+80|0;if((b|0)!=1){break b}e=223;b=aea(d);if((b|0)!=1){break b}e=224;b=_da(d);if((b|0)!=1){break b}e=225;b=Xda(d);if((b|0)!=1){break b}e=226;b=Wda(d);if((b|0)!=1){break b}e=227;b=Uda(d);if((b|0)!=1){break b}e=228;b=Oda(d);if((b|0)!=1){break b}e=229;b=Mda(d);if((b|0)!=1){break b}e=230;b=Kda(d);if((b|0)!=1){break b}e=231;b=Fda(d);if((b|0)!=1){break b}e=232;b=Eda(d);if((b|0)!=1){break b}e=233;b=uda(d);if((b|0)!=1){break b}e=234;b=Ija(d);if((b|0)!=1){break b}e=235;b=ida(d);if((b|0)!=1){break b}e=236;b=nka(d);if((b|0)!=1){break b}e=237;f=ub-16|0;ub=f;c=767;a=zd(8,151881,767);A:{B:{if(!a){b=-1;break B}v[a>>2]=0;c=771;b=qs(d,73078,1,a);if((b|0)!=1){break B}c=773;a=zd(8,151881,773);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=0;c=778;b=qs(d,17976,0,a);if((b|0)!=1){break B}c=780;a=zd(8,151881,780);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=1;c=785;b=qs(d,66256,0,a);if((b|0)!=1){break B}c=787;a=zd(8,151881,787);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=2;c=792;b=qs(d,72941,0,a);if((b|0)!=1){break B}c=794;a=zd(8,151881,794);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=3;c=799;b=qs(d,61707,0,a);if((b|0)!=1){break B}c=801;a=zd(8,151881,801);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=4;c=806;b=qs(d,72767,0,a);if((b|0)!=1){break B}c=808;a=zd(8,151881,808);if(!a){b=-1;break B}v[a>>2]=1;v[a+4>>2]=5;c=813;b=qs(d,94741,0,a);if((b|0)!=1){break B}c=815;b=-1;a=zd(8,151881,815);if(!a){break B}v[a>>2]=1;v[a+4>>2]=6;c=820;b=qs(d,66662,0,a);a=1;if((b|0)==1){break A}}Eb(151915,c);v[f>>2]=b;Fb(276579,f);a=b}ub=f+16|0;b=a;if((b|0)!=1){break b}e=238;b=mda(d);if((b|0)!=1){break b}e=239;b=Kka(d);if((b|0)!=1){break b}e=240;c=ub-16|0;ub=c;b=Ei(d,c+12|0,61554,83921,7e4,913,0);C:{if((b|0)!=1){Eb(149181,509);v[c>>2]=b;Fb(276579,c);break C}a=v[c+12>>2];v[a+72>>2]=914;v[a+64>>2]=915;v[a+44>>2]=916;v[a+32>>2]=917;v[a+20>>2]=0;v[a+16>>2]=918;v[a+80>>2]=919;v[a+68>>2]=920;v[a+76>>2]=921;v[a+92>>2]=922;v[a+88>>2]=923;v[a+84>>2]=924;v[a+56>>2]=0;v[a+60>>2]=0;v[a+52>>2]=925}ub=c+16|0;if((b|0)!=1){break b}e=241;c=ub-16|0;ub=c;b=Ei(d,c+12|0,38433,83967,92e3,1057,0);D:{if((b|0)!=1){Eb(157235,1412);v[c>>2]=b;Fb(276579,c);break D}a=v[c+12>>2];v[a+72>>2]=1058;v[a+64>>2]=1059;v[a+44>>2]=1060;v[a+32>>2]=1061;v[a+20>>2]=0;v[a+16>>2]=1062;v[a+80>>2]=1063;v[a+76>>2]=1064;v[a+68>>2]=1065;v[a+88>>2]=1066;v[a+84>>2]=1067;v[a+56>>2]=0;v[a+60>>2]=0;v[a+52>>2]=1068}ub=c+16|0;if((b|0)!=1){break b}e=242;c=ub-16|0;ub=c;b=Ei(d,c+12|0,4155,243209,81e3,926,0);E:{if((b|0)!=1){Eb(144465,665);v[c>>2]=b;Fb(276579,c);break E}a=v[c+12>>2];v[a+72>>2]=927;v[a+64>>2]=928;v[a+44>>2]=929;v[a+32>>2]=930;v[a+28>>2]=931;v[a+24>>2]=932;v[a+20>>2]=0;v[a+16>>2]=933;v[a+80>>2]=934;v[a+76>>2]=935;v[a+68>>2]=936;v[a+92>>2]=937;v[a+88>>2]=938;v[a+84>>2]=939;v[a+56>>2]=0;v[a+60>>2]=0;v[a+52>>2]=940}ub=c+16|0;if((b|0)!=1){break b}e=243;c=ub-16|0;ub=c;b=Ei(d,c+12|0,71376,83746,85e3,941,0);F:{if((b|0)!=1){Eb(151034,491);v[c>>2]=b;Fb(276579,c);break F}a=v[c+12>>2];v[a+72>>2]=942;v[a+64>>2]=943;v[a+44>>2]=944;v[a+32>>2]=945;v[a+28>>2]=946;v[a+24>>2]=947;v[a+20>>2]=0;v[a+16>>2]=948;v[a+80>>2]=949;v[a+76>>2]=950;v[a+68>>2]=951;v[a+88>>2]=952;v[a+84>>2]=953;v[a+56>>2]=0;v[a+60>>2]=0;v[a+52>>2]=954}ub=c+16|0;if((b|0)!=1){break b}e=244;b=fka(d);if((b|0)!=1){break b}e=245;b=eka(d);if((b|0)!=1){break b}e=246;b=_ja(d);if((b|0)!=1){break b}e=247;c=ub-16|0;ub=c;b=Ei(d,c+12|0,66030,83614,56e3,989,0);G:{if((b|0)!=1){Eb(145065,3152);v[c>>2]=b;Fb(276579,c);break G}a=v[c+12>>2];v[a+72>>2]=990;v[a+64>>2]=991;v[a+44>>2]=992;v[a+40>>2]=993;v[a+32>>2]=994;v[a+28>>2]=975;v[a+24>>2]=976;v[a+20>>2]=0;v[a+16>>2]=995;v[a+80>>2]=996;v[a+76>>2]=997;v[a+68>>2]=998;v[a+92>>2]=982;v[a+88>>2]=999;v[a+84>>2]=1e3;v[a+56>>2]=0;v[a+60>>2]=0;v[a+52>>2]=1001;v[a+36>>2]=988}ub=c+16|0;if((b|0)!=1){break b}e=248;c=ub-16|0;ub=c;b=Ei(d,c+12|0,84692,83969,91e3,1041,0);H:{if((b|0)!=1){Eb(157235,1387);v[c>>2]=b;Fb(276579,c);break H}a=v[c+12>>2];v[a+72>>2]=1042;v[a+64>>2]=1043;v[a+44>>2]=1044;v[a+32>>2]=1045;v[a+20>>2]=0;v[a+16>>2]=1046;v[a+80>>2]=1047;v[a+76>>2]=1048;v[a+68>>2]=1049;v[a+88>>2]=1050;v[a+84>>2]=1051;v[a+60>>2]=1052;v[a+56>>2]=1053;v[a+52>>2]=1054}ub=c+16|0;if((b|0)!=1){break b}e=249;c=ub-16|0;ub=c;b=Ei(d,c+12|0,86292,17768,4e4,1022,0);I:{if((b|0)!=1){Eb(152932,1058);v[c>>2]=b;Fb(276579,c);break I}a=v[c+12>>2];v[a+72>>2]=1023;v[a+64>>2]=1024;v[a+40>>2]=1025;v[a+36>>2]=1026;v[a+32>>2]=1027;v[a+28>>2]=1028;v[a+24>>2]=1029;v[a+20>>2]=0;v[a+16>>2]=1030;v[a+80>>2]=1031;v[a+76>>2]=1032;v[a+68>>2]=1033;v[a+92>>2]=1034;v[a+88>>2]=1035;v[a+84>>2]=1036;v[a+60>>2]=1037;v[a+56>>2]=1038;v[a+52>>2]=1039}ub=c+16|0;if((b|0)!=1){break b}e=250;c=ub-16|0;ub=c;b=Ei(d,c+12|0,92473,111221,1e4,1071,0);J:{if((b|0)!=1){Eb(158178,252);v[c>>2]=b;Fb(276579,c);break J}a=v[c+12>>2];v[a+80>>2]=1072;v[a+64>>2]=1073;v[a+40>>2]=1074;v[a+36>>2]=1075;v[a+28>>2]=1076;v[a+24>>2]=1077;v[a+20>>2]=0;v[a+16>>2]=1078;v[a+92>>2]=1079;v[a+88>>2]=1080;v[a+84>>2]=1081;v[a+60>>2]=1082;v[a+56>>2]=1083;v[a+52>>2]=1084}ub=c+16|0;if((b|0)!=1){break b}e=251;c=ub-16|0;ub=c;b=Ei(d,c+12|0,69177,83985,0,1085,0);K:{if((b|0)!=1){Eb(150698,371);v[c>>2]=b;Fb(276579,c);break K}a=v[c+12>>2];v[a+80>>2]=1086;v[a+64>>2]=1087;v[a+40>>2]=1088;v[a+36>>2]=1089;v[a+32>>2]=1090;v[a+28>>2]=1091;v[a+24>>2]=1092;v[a+20>>2]=0;v[a+16>>2]=1093;v[a+92>>2]=1094;v[a+88>>2]=1095;v[a+84>>2]=1096;v[a+60>>2]=1097;v[a+56>>2]=1098;v[a+52>>2]=1099}ub=c+16|0;if((b|0)!=1){break b}e=252;c=ub-16|0;ub=c;b=Ei(d,c+12|0,6692,241988,0,1100,0);L:{if((b|0)!=1){Eb(144973,203);v[c>>2]=b;Fb(276579,c);break L}a=v[c+12>>2];v[a+80>>2]=1101;v[a+40>>2]=1102;v[a+36>>2]=1103;v[a+28>>2]=1104;v[a+24>>2]=1105;v[a+20>>2]=0;v[a+16>>2]=1106;v[a+88>>2]=1107;v[a+84>>2]=1108;v[a+60>>2]=1109;v[a+56>>2]=1110;v[a+52>>2]=1111}ub=c+16|0;if((b|0)!=1){break b}e=253;c=ub-16|0;ub=c;b=Bo(d,c+12|0,17981,41494,0,0,1560,1561,0);M:{if((b|0)!=1){Eb(146311,620);v[c>>2]=b;Fb(276579,c);break M}a=v[c+12>>2];v[a+72>>2]=1562;v[a+68>>2]=1563;v[a+64>>2]=0;v[a+60>>2]=1564;v[a+56>>2]=0;v[a+52>>2]=1565;v[a+28>>2]=1566;v[a+32>>2]=1567}ub=c+16|0;if((b|0)!=1){break b}e=254;b=uha(d);if((b|0)!=1){break b}e=255;b=qha(d);if((b|0)!=1){break b}e=256;b=xha(d);if((b|0)!=1){break b}e=257;b=pha(d);if((b|0)!=1){break b}e=258;b=nha(d);if((b|0)!=1){break b}e=259;c=ub-16|0;ub=c;b=Bo(d,c+12|0,16213,41451,20,20,1585,1586,0);N:{if((b|0)!=1){Eb(146205,1282);v[c>>2]=b;Fb(276579,c);break N}a=v[c+12>>2];v[a+72>>2]=1587;v[a+68>>2]=1588;v[a+64>>2]=0;v[a+60>>2]=1589;v[a+52>>2]=0;v[a+56>>2]=0;v[a+28>>2]=1590;v[a+32>>2]=1591}ub=c+16|0;if((b|0)!=1){break b}e=260;b=eha(d);if((b|0)!=1){break b}e=265;b=bha(d);a=1;if((b|0)==1){break a}}Eb(148071,e);v[g>>2]=b;Fb(276579,g);a=b}ub=g+16|0;return a}function Jda(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,z=0,C=0,E=0,G=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0;X=ub-48|0;ub=X;g=1;v[e>>2]=1;j=v[b+144>>2];l=v[b+164>>2];a:{b:{if(!d){i=v[j+112>>2];if((i|0)<0|(i|0)>(l|0)){break b}break a}if((d|0)<=0){break b}i=v[j+108>>2];if((i|0)<0){break b}if((i|0)<=(l|0)){break a}}if((hd(a)|0)<3){break a}c:{if(v[j+40>>2]){break c}if((hd(a)|0)>=5){break c}break a}d:{e:{f:{if(c){g=gd(a,X+44|0,X+40|0,0,0,0,0);if((g|0)!=1){break e}if(v[X+40>>2]<=0){break f}g=0;while(1){m=Ob(a,c,v[v[X+44>>2]+(g<<2)>>2]);w=m;m=A[v[a+4>>2]+1296>>3];L=!(w-H(w+m)<=m)+L|0;g=g+1|0;if((g|0)<v[X+40>>2]){continue}break}break f}L=Ch(a)}if((L|0)<3){g=1;break a}if(!(v[j+40>>2]|L>>>0>4)){g=1;break a}if((v[v[a+24>>2]+1232>>2]+v[v[a+80>>2]+24>>2]|0)<3){g=1;break a}g:{if(v[j+132>>2]<0){break g}g=v[a+92>>2];if(g){g=v[g+32>>2]}else{g=0}if((g|0)<v[j+132>>2]){break g}g=1;break a}l=v[j+140>>2];n=v[j+136>>2];i=v[a+72>>2];g=v[i+160>>2];if((g|0)<=0){g=0}else{g=v[(v[i+8>>2]+(g<<2)|0)-4>>2]}if((n|0)!=v[g>>2]|v[g+4>>2]!=(l|0)){v[j+128>>2]=0;i=v[a+72>>2];g=v[i+160>>2];if((g|0)<=0){i=0}else{i=v[(v[i+8>>2]+(g<<2)|0)-4>>2]}g=v[i+4>>2];v[j+136>>2]=v[i>>2];v[j+140>>2]=g;break d}if(v[j+128>>2]<=v[j+124>>2]){break d}g=1;break a}Eb(158781,3544);v[X+32>>2]=g;Fb(276579,X+32|0);break a}v[e>>2]=3;v[j+8>>2]=v[j+4>>2];v[j+64>>2]=v[(d?56:60)+j>>2];h:{if(v[j+16>>2]){na=b;h=ub-480|0;ub=h;v[h+476>>2]=1;v[h+400>>2]=1;o=a;b=gd(a,h+464|0,0,h+388|0,h+384|0,h+380|0,0);i:{if((b|0)!=1){Eb(158781,3043);v[h+352>>2]=b;Fb(276579,h+352|0);break i}i=v[h+380>>2]+(v[h+388>>2]+v[h+384>>2]|0)|0;a=Ib(v[v[o>>2]+8>>2],i,4,158747,3052);v[h+460>>2]=a;j:{if(a){a=v[h+388>>2];k:{if((a|0)<=0){break k}b=0;if(a>>>0>=4){g=a&2147483644;while(1){l=b<<2;v[l+v[h+460>>2]>>2]=v[l+v[h+464>>2]>>2];d=l|4;v[d+v[h+460>>2]>>2]=v[d+v[h+464>>2]>>2];d=l|8;v[d+v[h+460>>2]>>2]=v[d+v[h+464>>2]>>2];d=l|12;v[d+v[h+460>>2]>>2]=v[d+v[h+464>>2]>>2];b=b+4|0;C=C+4|0;if((g|0)!=(C|0)){continue}break}}g=a&3;if(!g){break k}while(1){d=b<<2;v[d+v[h+460>>2]>>2]=v[d+v[h+464>>2]>>2];b=b+1|0;N=N+1|0;if((g|0)!=(N|0)){continue}break}}if((a|0)<(i|0)){b=a;while(1){l:{m:{n:{d=v[v[h+464>>2]+(b<<2)>>2];switch(v[d+376>>2]>>>6&3){case 3:break l;case 0:break m;default:break n}}if(!(A[d+128>>3]>=0)|!(A[d+136>>3]<=1)){break l}}v[v[h+460>>2]+(a<<2)>>2]=d;a=a+1|0}b=b+1|0;if((i|0)>(b|0)){continue}break}}b=v[v[o>>2]+8>>2];if(!a){Hb(b,h+460|0,158747,3066);b=1;break i}T=a<<1;U=Ib(b,T,8,158747,3071);v[h+472>>2]=U;if(!U){Eb(158781,3071);b=-1;v[h+16>>2]=-1;Fb(276579,h+16|0);break i}b=0;o:{p:{q:{switch(v[j+68>>2]){case 1:while(1){A[U+(b<<3)>>3]=Ob(o,c,v[v[h+460>>2]+(b<<2)>>2]);b=b+1|0;if((b|0)!=(a|0)){continue}break};us(U,v[h+460>>2],a);break p;case 2:while(1){A[U+(b<<3)>>3]=Ob(o,c,v[v[h+460>>2]+(b<<2)>>2]);b=b+1|0;if((b|0)!=(a|0)){continue}break};po(U,v[h+460>>2],a);break p;case 3:while(1){w=Ob(o,c,v[v[h+460>>2]+(b<<2)>>2]);m=1-w;A[U+(b<<3)>>3]=m<=w?m:w;b=b+1|0;if((b|0)!=(a|0)){continue}break};us(U,v[h+460>>2],a);break p;case 0:break p;case 4:break q;default:break o}}while(1){w=Ob(o,c,v[v[h+460>>2]+(b<<2)>>2]);m=1-w;A[U+(b<<3)>>3]=m<=w?m:w;b=b+1|0;if((b|0)!=(a|0)){continue}break}po(U,v[h+460>>2],a)}b=Ib(v[v[o>>2]+8>>2],i,4,158747,3131);v[j+44>>2]=b;if(!b){Eb(158781,3131);b=-1;v[h+32>>2]=-1;Fb(276579,h+32|0);break i}g=a<<2;Y=Ib(v[v[o>>2]+8>>2],g,4,158747,3132);v[h+468>>2]=Y;if(!Y){Eb(158781,3132);b=-1;v[h+48>>2]=-1;Fb(276579,h+48|0);break i}ka=j+44|0;dc(Y,a<<4);b=0;while(1){d=v[v[h+460>>2]+(b<<2)>>2];v[v[ka>>2]+(v[d+292>>2]<<2)>>2]=b;A[U+(b<<3)>>3]=Ob(o,c,d);b=b+1|0;if((b|0)!=(a|0)){continue}break}break j}Eb(158781,3124);Fb(284511,0);b=-9;break i}Eb(158781,3052);b=-1;v[h>>2]=-1;Fb(276579,h);break i}if((a|0)>0){b=a;while(1){A[U+(b<<3)>>3]=1-A[U+(b-a<<3)>>3];b=b+1|0;if(T>>>0>b>>>0){continue}break}}v[h+440>>2]=0;v[h+428>>2]=g;J=B(a,400);v[h+424>>2]=J;b=Ib(v[v[o>>2]+8>>2],v[h+428>>2],4,158747,3170);v[h+432>>2]=b;if(!b){Eb(158781,3170);b=-1;v[h+64>>2]=-1;Fb(276579,h- -64|0);break i}b=Ib(v[v[o>>2]+8>>2],v[h+428>>2],4,158747,3171);v[h+436>>2]=b;if(!b){Eb(158781,3171);b=-1;v[h+80>>2]=-1;Fb(276579,h+80|0);break i}b=Ib(v[v[o>>2]+8>>2],J,4,158747,3172);v[h+448>>2]=b;if(!b){Eb(158781,3172);b=-1;v[h+96>>2]=-1;Fb(276579,h+96|0);break i}b=Ib(v[v[o>>2]+8>>2],J,4,158747,3173);v[h+444>>2]=b;if(!b){Eb(158781,3173);b=-1;v[h+112>>2]=-1;Fb(276579,h+112|0);break i}d=Ib(v[v[o>>2]+8>>2],v[h+428>>2],8,158747,3174);v[h+416>>2]=d;if(!d){Eb(158781,3174);b=-1;v[h+128>>2]=-1;Fb(276579,h+128|0);break i}b=Ib(v[v[o>>2]+8>>2],v[h+428>>2],4,158747,3175);v[h+412>>2]=b;if(!b){Eb(158781,3175);b=-1;v[h+144>>2]=-1;Fb(276579,h+144|0);break i}b=Ib(v[v[o>>2]+8>>2],v[h+428>>2],4,158747,3176);v[h+408>>2]=b;if(!b){Eb(158781,3176);b=-1;v[h+160>>2]=-1;Fb(276579,h+160|0);break i}b=Ib(v[v[o>>2]+8>>2],v[h+428>>2],4,158747,3177);v[h+404>>2]=b;if(b){if(J){l=v[h+444>>2];i=v[h+448>>2];while(1){g=x<<2;v[g+i>>2]=-1;v[g+l>>2]=-1;b=g|4;v[b+i>>2]=-1;v[b+l>>2]=-1;b=g|8;v[b+i>>2]=-1;v[b+l>>2]=-1;b=g|12;v[b+i>>2]=-1;v[b+l>>2]=-1;x=x+4|0;if((J|0)!=(x|0)){continue}break}}v[h+420>>2]=0;v[h+452>>2]=-1;v[h+456>>2]=0;r:{if(!T){break r}q=B(a,3);N=0;while(1){z=N<<2;v[z+v[h+432>>2]>>2]=k;v[z+v[h+436>>2]>>2]=0;s=a>>>0>N>>>0;W=N-(s?0:a)|0;m=A[U+(W<<3)>>3];w=m;m=A[v[o+4>>2]+1296>>3];s:{if(w-H(w+m)<=m){break s}l=v[h+460>>2];i=W<<2;b=v[v[l+i>>2]+252>>2];if(!b){break s}g=s<<2;r=v[(g+b|0)+8>>2];if(!r){break s}x=h+428|0;G=h+424|0;K=h+400|0;P=0;E=ub-16|0;ub=E;b=v[v[i+l>>2]+252>>2];if(b){l=v[b+g>>2]}else{l=0}t:{if(!r){J=1;break t}i=B(a,3);g=a<<1;u=U+(W<<3)|0;n=N<<2;while(1){b=v[l+(P<<2)>>2];L=v[b+8>>2];if(L){t=v[b+4>>2];O=v[b>>2];S=0;while(1){b=S<<2;M=v[v[j+44>>2]+(v[v[b+O>>2]+292>>2]<<2)>>2];u:{if((M|0)==(W|0)){break u}ha=A[U+(M<<3)>>3];fa=A[v[o+4>>2]+1296>>3];if(ha-H(ha+fa)<=fa){break u}b=v[b+t>>2];m=A[u>>3];w=+v[j>>2];v:{w:{if(s){m=1-m;if(b){m=m-ha;b=g;break v}m=ha+-1+m;break w}m=m+-1+1;if(b){m=m-ha;b=g;break v}m=ha+-1+m}b=i}p=v[x+16>>2];J=p+(v[h+420>>2]<<2)|0;m=I(w*m-fa);x:{if(D(m)<2147483648){Z=~~m;break x}Z=-2147483648}v[J>>2]=(Z|0)>0?Z:0;v[v[x+20>>2]+(v[h+420>>2]<<2)>>2]=b+M;b=h;h=b;M=v[b+420>>2];J=v[p+(M<<2)>>2];if(J>>>0<y[x+24>>2]){v[x+24>>2]=J;M=v[b+420>>2];J=v[p+(M<<2)>>2]}if(y[x+28>>2]<J>>>0){v[x+28>>2]=J;M=v[h+420>>2]}b=M+1|0;v[h+420>>2]=b;y:{if((b|0)!=v[G>>2]){break y}J=pB(o,G,x,K);if((J|0)!=1){Eb(158781,2949);v[E>>2]=J;Fb(276579,E);break t}if(v[K>>2]){break y}J=1;break t}b=n+v[x+8>>2]|0;v[b>>2]=v[b>>2]+1;v[h+476>>2]=0}S=S+1|0;if((L|0)!=(S|0)){continue}break}}J=1;P=P+1|0;if((r|0)!=(P|0)){continue}break}}ub=E+16|0;b=J;if((b|0)!=1){Eb(158781,3227);v[h+336>>2]=b;Fb(276579,h+336|0);break i}if(!v[h+400>>2]){break r}}z:{if(!v[j+32>>2]){break z}b=v[h+436>>2];if(!v[b+z>>2]){break z}i=v[h+420>>2];g=i<<2;v[g+v[h+448>>2]>>2]=(s?q:a)+N;g=g+v[h+444>>2]|0;v[g>>2]=0;A:{if(!v[h+452>>2]){break A}v[h+452>>2]=0;g=v[g>>2];if(g>>>0<=y[h+456>>2]){break A}v[h+456>>2]=g}g=i+1|0;v[h+420>>2]=g;if((g|0)==v[h+424>>2]){b=pB(o,h+424|0,h+428|0,h+400|0);if((b|0)!=1){Eb(158781,3261);v[h+320>>2]=b;Fb(276579,h+320|0);break i}if(!v[h+400>>2]){break r}b=v[h+436>>2]}b=b+z|0;v[b>>2]=v[b>>2]+1}g=v[h+420>>2];b=g<<2;v[b+v[h+448>>2]>>2]=-1;v[b+v[h+444>>2]>>2]=-1;k=g+1|0;v[h+420>>2]=k;if(v[h+424>>2]==(k|0)){b=pB(o,h+424|0,h+428|0,h+400|0);if((b|0)!=1){Eb(158781,3275);v[h+304>>2]=b;Fb(276579,h+304|0);break i}if(!v[h+400>>2]){break r}}N=N+1|0;if((T|0)!=(N|0)){continue}break}if(v[h+476>>2]){break r}C=0;while(1){N=v[h+432>>2];l=C+T<<2;v[N+l>>2]=k;b=v[h+436>>2];v[l+b>>2]=0;J=C<<2;x=v[J+N>>2];if(x>>>0<v[b+J>>2]+x>>>0){while(1){i=v[h+448>>2];g=k<<2;q=i+g|0;n=i;i=x<<2;v[q>>2]=v[n+i>>2]-T;n=g;g=v[h+444>>2];v[n+g>>2]=v[g+i>>2];k=k+1|0;if((k|0)==v[h+424>>2]){b=pB(o,h+424|0,h+428|0,h+400|0);if((b|0)!=1){Eb(158781,3304);v[h+288>>2]=b;Fb(276579,h+288|0);break i}if(!v[h+400>>2]){break r}N=v[h+432>>2];b=v[h+436>>2]}g=b+l|0;v[g>>2]=v[g>>2]+1;x=x+1|0;if(x>>>0<v[b+J>>2]+v[N+J>>2]>>>0){continue}break}}b=k<<2;v[b+v[h+448>>2]>>2]=-1;v[b+v[h+444>>2]>>2]=-1;k=k+1|0;if((k|0)==v[h+424>>2]){b=pB(o,h+424|0,h+428|0,h+400|0);if((b|0)!=1){Eb(158781,3320);v[h+272>>2]=b;Fb(276579,h+272|0);break i}if(!v[h+400>>2]){break r}}C=C+1|0;if((T|0)!=(C|0)){continue}break}v[h+440>>2]=k;v[h+420>>2]=k;m=A[v[o+4>>2]+1280>>3];i=v[j+84>>2];g=v[j+80>>2];b=Ib(v[v[o>>2]+8>>2],T,4,158747,3355);v[h+392>>2]=b;m=I(+(a>>>0)*.02*+(g|0)+ +(i|0)-m);B:{if(m<4294967296&m>=0){J=~~m>>>0;break B}J=0}if(!b){Eb(158781,3355);b=-1;v[h+192>>2]=-1;Fb(276579,h+192|0);break i}b=Ib(v[v[o>>2]+8>>2],T,4,158747,3356);v[h+396>>2]=b;if(!b){Eb(158781,3356);b=-1;v[h+208>>2]=-1;Fb(276579,h+208|0);break i}C=v[j+72>>2];i=T>>>0<=C>>>0;m=+v[j>>2]*.5;C:{if(m<0x10000000000000000&m>=0){g=~~m>>>0;if(D(m)>=1){b=~~(m>0?F(H(m*2.3283064365386963e-10),4294967295):I((m-+(~~m>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break C}g=0;b=0}t=g;L=b;D:{if(!J|i){break D}Z=T&-4;W=T&2;S=0;while(1){if(y[j+64>>2]<=v[j+4>>2]-v[j+8>>2]>>>0){break D}if(rc(v[o+4>>2],v[o+24>>2],0)){break D}E:{g=C<<2;b=v[h+448>>2]+(v[g+v[h+432>>2]>>2]<<2)|0;if(v[b>>2]==-1|v[b+4>>2]==-1|(v[j+20>>2]?0:v[g+Y>>2])){break E}x=C+T|0;i=v[h+404>>2];g=v[h+408>>2];b=v[h+412>>2];F:{if(v[j+24>>2]){u=d;O=b;q=g;n=i;k=0;M=0;if(v[h+428>>2]){while(1){b=u+(k<<3)|0;v[b>>2]=-1;v[b+4>>2]=0;b=k<<2;v[b+n>>2]=-1;v[b+O>>2]=-1;k=k+1|0;if(k>>>0<y[h+428>>2]){continue}break}}v[q>>2]=C;b=C<<2;v[b+n>>2]=0;v[b+O>>2]=-1;b=u+(C<<3)|0;v[b>>2]=0;v[b+4>>2]=0;i=1;while(1){G:{if(!i){break G}z=v[q>>2];if((z|0)==(x|0)){break G}i=i-1|0;b=v[q+(i<<2)>>2];v[q>>2]=b;g=0;v[n+(b<<2)>>2]=0;r=z<<2;v[r+n>>2]=-1;s=v[q>>2];H:{if(!i){b=0;break H}b=u+(s<<3)|0;l=v[b>>2];P=v[b+4>>2];d=0;while(1){k=v[q+(d<<2)>>2];E=d|1;if(E>>>0>=i>>>0){b=d}else{b=v[q+(E<<2)>>2];p=u+(b<<3)|0;G=v[p>>2];f=b;b=u+(k<<3)|0;K=v[b>>2];p=v[p+4>>2];b=v[b+4>>2];b=(p|0)==(b|0)&G>>>0<K>>>0|b>>>0>p>>>0;k=b?f:k;b=b?E:d}d=u+(k<<3)|0;p=v[d>>2];d=v[d+4>>2];if((d|0)==(P|0)&l>>>0<=p>>>0|d>>>0>P>>>0){b=g;break H}v[q+(g<<2)>>2]=k;v[n+(k<<2)>>2]=g;g=b;d=b<<1;if(i>>>0>d>>>0){continue}break}}v[q+(b<<2)>>2]=s;v[n+(s<<2)>>2]=b;P=u+(z<<3)|0;b=P;d=v[b>>2];b=v[b+4>>2];if((L|0)==(b|0)&d>>>0>=t>>>0|b>>>0>L>>>0){continue}G=v[h+448>>2];g=v[r+v[h+432>>2]>>2];b=v[G+(g<<2)>>2];if((b|0)==-1){continue}while(1){p=b<<2;I:{if(v[p+Y>>2]){break I}d=v[v[h+444>>2]+(g<<2)>>2];r=d+v[P>>2]|0;E=v[P+4>>2];K=u+(b<<3)|0;l=v[K>>2];E=d>>>0>r>>>0?E+1|0:E;d=v[K+4>>2];if((E|0)==(d|0)&l>>>0<=r>>>0|d>>>0<E>>>0){break I}v[p+O>>2]=z;v[K>>2]=r;v[K+4>>2]=E;J:{K:{L:{M:{N:{l=n+p|0;d=v[l>>2];if((d|0)==-1){d=q+(i<<2)|0;v[d>>2]=b;v[l>>2]=i;s=v[d>>2];if(!i){break N}b=u+(s<<3)|0;l=v[b>>2];E=v[b+4>>2];d=i;while(1){b=d>>>1|0;r=v[q+(b<<2)>>2];p=u+(r<<3)|0;K=v[p>>2];p=v[p+4>>2];if((p|0)==(E|0)&l>>>0>=K>>>0|p>>>0<E>>>0){b=d;break K}v[q+(d<<2)>>2]=r;v[n+(r<<2)>>2]=d;p=d>>>0>1;d=b;if(p){continue}break}break K}s=v[q+(d<<2)>>2];if(!d){break M}b=u+(s<<3)|0;l=v[b>>2];E=v[b+4>>2];while(1){b=d>>>1|0;r=v[q+(b<<2)>>2];p=u+(r<<3)|0;K=v[p>>2];p=v[p+4>>2];if((p|0)==(E|0)&l>>>0>=K>>>0|p>>>0<E>>>0){b=d;break L}v[q+(d<<2)>>2]=r;v[n+(r<<2)>>2]=d;p=d>>>0>1;d=b;if(p){continue}break}break L}b=0;break K}b=0}v[q+(b<<2)>>2]=s;v[n+(s<<2)>>2]=b;break J}v[q+(b<<2)>>2]=s;v[n+(s<<2)>>2]=b;i=i+1|0}M=M+1|0}g=g+1|0;b=v[G+(g<<2)>>2];if((b|0)!=-1){continue}break}continue}break}break F}u=d;O=b;q=g;n=i;k=0;M=0;if(v[h+428>>2]){while(1){b=u+(k<<3)|0;v[b>>2]=-1;v[b+4>>2]=0;b=k<<2;v[b+n>>2]=-1;v[b+O>>2]=-1;k=k+1|0;if(k>>>0<y[h+428>>2]){continue}break}}v[q>>2]=C;b=C<<2;v[b+n>>2]=0;v[b+O>>2]=-1;b=u+(C<<3)|0;v[b>>2]=0;v[b+4>>2]=0;i=1;while(1){O:{if(!i){break O}z=v[q>>2];if((z|0)==(x|0)){break O}i=i-1|0;b=v[q+(i<<2)>>2];v[q>>2]=b;d=0;v[n+(b<<2)>>2]=0;r=z<<2;v[r+n>>2]=-1;s=v[q>>2];P:{if(!i){g=0;break P}b=u+(s<<3)|0;l=v[b>>2];P=v[b+4>>2];b=0;while(1){k=v[q+(b<<2)>>2];E=b|1;if(i>>>0>E>>>0){g=v[q+(E<<2)>>2];p=u+(g<<3)|0;G=v[p>>2];f=g;g=u+(k<<3)|0;K=v[g>>2];p=v[p+4>>2];g=v[g+4>>2];g=(p|0)==(g|0)&G>>>0<K>>>0|g>>>0>p>>>0;k=g?f:k;b=g?E:b}g=b;b=u+(k<<3)|0;p=v[b>>2];b=v[b+4>>2];if((b|0)==(P|0)&l>>>0<=p>>>0|b>>>0>P>>>0){g=d;break P}v[q+(d<<2)>>2]=k;v[n+(k<<2)>>2]=d;d=g;b=g<<1;if(i>>>0>b>>>0){continue}break}}v[q+(g<<2)>>2]=s;v[n+(s<<2)>>2]=g;P=u+(z<<3)|0;b=P;d=v[b>>2];b=v[b+4>>2];if((L|0)==(b|0)&d>>>0>=t>>>0|b>>>0>L>>>0){continue}G=v[h+448>>2];k=v[r+v[h+432>>2]>>2];g=v[G+(k<<2)>>2];if((g|0)==-1){continue}K=v[h+444>>2];while(1){b=v[K+(k<<2)>>2];p=b+v[P>>2]|0;r=v[P+4>>2];l=u+(g<<3)|0;d=v[l>>2];r=b>>>0>p>>>0?r+1|0:r;b=v[l+4>>2];if((r|0)==(b|0)&d>>>0>p>>>0|b>>>0>r>>>0){b=g<<2;v[b+O>>2]=z;v[l>>2]=p;v[l+4>>2]=r;Q:{R:{S:{T:{U:{d=b+n|0;b=v[d>>2];if((b|0)==-1){b=q+(i<<2)|0;v[b>>2]=g;v[d>>2]=i;s=v[b>>2];if(!i){break U}b=u+(s<<3)|0;g=v[b>>2];E=v[b+4>>2];b=i;while(1){d=b>>>1|0;r=v[q+(d<<2)>>2];l=u+(r<<3)|0;p=v[l>>2];l=v[l+4>>2];if((l|0)==(E|0)&g>>>0>=p>>>0|l>>>0<E>>>0){d=b;break R}v[q+(b<<2)>>2]=r;v[n+(r<<2)>>2]=b;l=b>>>0>1;b=d;if(l){continue}break}break R}s=v[q+(b<<2)>>2];if(!b){break T}d=u+(s<<3)|0;g=v[d>>2];E=v[d+4>>2];while(1){d=b>>>1|0;r=v[q+(d<<2)>>2];l=u+(r<<3)|0;p=v[l>>2];l=v[l+4>>2];if((l|0)==(E|0)&g>>>0>=p>>>0|l>>>0<E>>>0){d=b;break S}v[q+(b<<2)>>2]=r;v[n+(r<<2)>>2]=b;l=b>>>0>1;b=d;if(l){continue}break}break S}d=0;break R}d=0}v[q+(d<<2)>>2]=s;v[n+(s<<2)>>2]=d;break Q}v[q+(d<<2)>>2]=s;v[n+(s<<2)>>2]=d;i=i+1|0}M=M+1|0}k=k+1|0;g=v[G+(k<<2)>>2];if((g|0)!=-1){continue}break}continue}break}}S=S+1|0;d=v[h+416>>2];g=d+(x<<3)|0;b=v[g>>2];g=v[g+4>>2];if(!g&(b|0)==-1|((g|0)==(L|0)&b>>>0>=t>>>0|g>>>0>L>>>0)){break E}k=0;l=v[h+396>>2];O=v[h+392>>2];b=0;N=0;if(T>>>0>=4){while(1){i=b<<2;v[i+O>>2]=-1;v[i+l>>2]=0;g=i|4;v[g+O>>2]=-1;v[g+l>>2]=0;g=i|8;v[g+O>>2]=-1;v[g+l>>2]=0;g=i|12;v[g+O>>2]=-1;v[g+l>>2]=0;b=b+4|0;N=N+4|0;if((Z|0)!=(N|0)){continue}break}}if(W){while(1){g=b<<2;v[g+O>>2]=-1;v[g+l>>2]=0;b=b+1|0;k=k+1|0;if((W|0)!=(k|0)){continue}break}}N=1;v[h+400>>2]=1;v[h+376>>2]=0;while(1){k=v[h+412>>2];i=x<<2;g=v[k+i>>2];V:{if(N){b=x-T|0;v[O+(b<<2)>>2]=g;b=oB(o,O,v[h+396>>2],Y,b,C,a,h+376|0,v[j+36>>2],v[j+24>>2],h+400|0);if((b|0)==1){k=v[h+412>>2];break V}Eb(158781,3435);v[h+256>>2]=b;Fb(276579,h+256|0);break i}v[i+O>>2]=g-T;b=oB(o,O,v[h+396>>2],Y,x,C,a,h+376|0,v[j+36>>2],v[j+24>>2],h+400|0);if((b|0)==1){break V}Eb(158781,3450);v[h+240>>2]=b;Fb(276579,h+240|0);break i}b=v[h+400>>2];x=v[i+k>>2];if((x|0)!=(C|0)){N=N^1;if(b){continue}}break}if(!b){break E}v[h+364>>2]=1;v[h+368>>2]=0;v[h+372>>2]=h+428;b=Ida(o,na,c,v[h+460>>2],a,C,O,v[h+376>>2],Y,v[h+472>>2],j,h+364|0,e);if((b|0)==1){break E}Eb(158781,3463);v[h+224>>2]=b;Fb(276579,h+224|0);break i}C=C+1|0;if(T>>>0<=C>>>0){break D}if(J>>>0>S>>>0){continue}break}}Hb(v[v[o>>2]+8>>2],h+396|0,158747,3468);Hb(v[v[o>>2]+8>>2],h+392|0,158747,3469);if(v[j+68>>2]){break r}v[j+72>>2]=(C|0)!=(T|0)?C:0}Hb(v[v[o>>2]+8>>2],h+404|0,158747,3484);Hb(v[v[o>>2]+8>>2],h+408|0,158747,3485);Hb(v[v[o>>2]+8>>2],h+412|0,158747,3486);Hb(v[v[o>>2]+8>>2],h+416|0,158747,3487);Hb(v[v[o>>2]+8>>2],h+444|0,158747,3488);Hb(v[v[o>>2]+8>>2],h+448|0,158747,3489);Hb(v[v[o>>2]+8>>2],h+436|0,158747,3490);Hb(v[v[o>>2]+8>>2],h+432|0,158747,3491);Hb(v[v[o>>2]+8>>2],h+468|0,158747,3492);Hb(v[v[o>>2]+8>>2],ka,158747,3493);Hb(v[v[o>>2]+8>>2],h+460|0,158747,3494);Hb(v[v[o>>2]+8>>2],h+472|0,158747,3495);b=1;break i}Eb(158781,3177);b=-1;v[h+176>>2]=-1;Fb(276579,h+176|0)}ub=h+480|0;g=b;if((b|0)==1){break h}Eb(158781,3603);v[X+16>>2]=b;Fb(276579,X+16|0);break a}na=b;O=c;f=ub-720|0;ub=f;i=a;a=gd(a,f+716|0,0,f+572|0,f+568|0,f+564|0,0);W:{if((a|0)!=1){Eb(158781,2311);v[f+528>>2]=a;Fb(276579,f+528|0);break W}g=v[f+564>>2]+(v[f+572>>2]+v[f+568>>2]|0)|0;a=Ib(v[v[i>>2]+8>>2],g,4,158747,2320);v[f+712>>2]=a;X:{if(a){c=v[f+572>>2];Y:{if((c|0)<=0){break Y}a=0;if(c>>>0>=4){d=c&2147483644;while(1){l=a<<2;v[l+v[f+712>>2]>>2]=v[l+v[f+716>>2]>>2];b=l|4;v[b+v[f+712>>2]>>2]=v[b+v[f+716>>2]>>2];b=l|8;v[b+v[f+712>>2]>>2]=v[b+v[f+716>>2]>>2];b=l|12;v[b+v[f+712>>2]>>2]=v[b+v[f+716>>2]>>2];a=a+4|0;k=k+4|0;if((d|0)!=(k|0)){continue}break}}d=c&3;if(!d){break Y}while(1){b=a<<2;v[b+v[f+712>>2]>>2]=v[b+v[f+716>>2]>>2];a=a+1|0;t=t+1|0;if((d|0)!=(t|0)){continue}break}}if((c|0)<(g|0)){a=c;while(1){Z:{_:{$:{b=v[v[f+716>>2]+(a<<2)>>2];switch(v[b+376>>2]>>>6&3){case 3:break Z;case 0:break _;default:break $}}if(!(A[b+128>>3]>=0)|!(A[b+136>>3]<=1)){break Z}}v[v[f+712>>2]+(c<<2)>>2]=b;c=c+1|0}a=a+1|0;if((g|0)>(a|0)){continue}break}}a=v[v[i>>2]+8>>2];aa:{ba:{ca:{da:{if(!c){Hb(a,f+712|0,158747,2334);break da}$=c<<1;R=Ib(a,$,8,158747,2339);v[f+708>>2]=R;if(!R){Eb(158781,2339);a=-1;v[f+16>>2]=-1;Fb(276579,f+16|0);break W}a=0;ea:{fa:{switch(v[j+68>>2]){case 1:while(1){A[R+(a<<3)>>3]=Ob(i,O,v[v[f+712>>2]+(a<<2)>>2]);a=a+1|0;if((c|0)!=(a|0)){continue}break};us(R,v[f+712>>2],c);break ea;case 2:while(1){A[R+(a<<3)>>3]=Ob(i,O,v[v[f+712>>2]+(a<<2)>>2]);a=a+1|0;if((c|0)!=(a|0)){continue}break};po(R,v[f+712>>2],c);break ea;case 3:while(1){w=Ob(i,O,v[v[f+712>>2]+(a<<2)>>2]);m=1-w;A[R+(a<<3)>>3]=m<=w?m:w;a=a+1|0;if((c|0)!=(a|0)){continue}break};us(R,v[f+712>>2],c);break ea;case 0:break ea;case 4:break fa;default:break ca}}while(1){w=Ob(i,O,v[v[f+712>>2]+(a<<2)>>2]);m=1-w;A[R+(a<<3)>>3]=m<=w?m:w;a=a+1|0;if((c|0)!=(a|0)){continue}break}po(R,v[f+712>>2],c)}a=Ib(v[v[i>>2]+8>>2],g,4,158747,2399);v[j+44>>2]=a;if(!a){break X}oa=j+44|0;a=0;while(1){b=v[v[f+712>>2]+(a<<2)>>2];v[v[oa>>2]+(v[b+292>>2]<<2)>>2]=a;A[R+(a<<3)>>3]=Ob(i,O,b);a=a+1|0;if((c|0)!=(a|0)){continue}break}if((c|0)>0){a=c;while(1){A[R+(a<<3)>>3]=1-A[R+(a-c<<3)>>3];a=a+1|0;if($>>>0>a>>>0){continue}break}}a=-1;v[f+628>>2]=-1;v[f+624>>2]=$;b=B(c,200);v[f+700>>2]=b;v[f+676>>2]=b;v[f+672>>2]=b;b=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2427);v[f+636>>2]=b;if(!b){Eb(158781,2427);v[f+48>>2]=-1;Fb(276579,f+48|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2428);v[f+648>>2]=a;if(!a){Eb(158781,2428);a=-1;v[f+64>>2]=-1;Fb(276579,f- -64|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2429);v[f+652>>2]=a;if(!a){Eb(158781,2429);a=-1;v[f+80>>2]=-1;Fb(276579,f+80|0);break W}b=v[f+672>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2430);v[f+656>>2]=a;if(!a){Eb(158781,2430);a=-1;v[f+96>>2]=-1;Fb(276579,f+96|0);break W}b=v[f+676>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2431);v[f+660>>2]=a;if(!a){Eb(158781,2431);a=-1;v[f+112>>2]=-1;Fb(276579,f+112|0);break W}b=v[f+672>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2432);v[f+664>>2]=a;if(!a){Eb(158781,2432);a=-1;v[f+128>>2]=-1;Fb(276579,f+128|0);break W}b=v[f+676>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2433);v[f+668>>2]=a;if(!a){Eb(158781,2433);a=-1;v[f+144>>2]=-1;Fb(276579,f+144|0);break W}ba=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2435);v[f+612>>2]=ba;if(!ba){Eb(158781,2435);a=-1;v[f+160>>2]=-1;Fb(276579,f+160|0);break W}aa=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2436);v[f+608>>2]=aa;if(!aa){Eb(158781,2436);a=-1;v[f+176>>2]=-1;Fb(276579,f+176|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2437);v[f+680>>2]=a;if(!a){Eb(158781,2437);a=-1;v[f+192>>2]=-1;Fb(276579,f+192|0);break W}b=v[f+700>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2438);v[f+684>>2]=a;if(!a){Eb(158781,2438);a=-1;v[f+208>>2]=-1;Fb(276579,f+208|0);break W}b=v[f+700>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2439);v[f+688>>2]=a;if(!a){Eb(158781,2439);a=-1;v[f+224>>2]=-1;Fb(276579,f+224|0);break W}b=v[f+700>>2];a=v[f+628>>2];a=Ib(v[v[i>>2]+8>>2],a>>>0>b>>>0?b:a,4,158747,2440);v[f+692>>2]=a;if(!a){Eb(158781,2440);a=-1;v[f+240>>2]=-1;Fb(276579,f+240|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2441);v[f+696>>2]=a;if(!a){Eb(158781,2441);a=-1;v[f+256>>2]=-1;Fb(276579,f+256|0);break W}ga=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2442);v[f+600>>2]=ga;if(!ga){Eb(158781,2442);a=-1;v[f+272>>2]=-1;Fb(276579,f+272|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2444);v[f+596>>2]=a;if(!a){Eb(158781,2444);a=-1;v[f+288>>2]=-1;Fb(276579,f+288|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2445);v[f+592>>2]=a;if(!a){Eb(158781,2445);a=-1;v[f+304>>2]=-1;Fb(276579,f+304|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2446);v[f+588>>2]=a;if(!a){Eb(158781,2446);a=-1;v[f+320>>2]=-1;Fb(276579,f+320|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2447);v[f+584>>2]=a;if(!a){Eb(158781,2447);a=-1;v[f+336>>2]=-1;Fb(276579,f+336|0);break W}a=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2448);v[f+580>>2]=a;if(!a){Eb(158781,2448);a=-1;v[f+352>>2]=-1;Fb(276579,f+352|0);break W}C=Ib(v[v[i>>2]+8>>2],v[f+624>>2],4,158747,2449);v[f+576>>2]=C;if(!C){Eb(158781,2449);a=-1;v[f+368>>2]=-1;Fb(276579,f+368|0);break W}da=Ib(v[v[i>>2]+8>>2],$,4,158747,2451);v[f+704>>2]=da;if(!da){Eb(158781,2451);a=-1;v[f+384>>2]=-1;Fb(276579,f+384|0);break W}dc(da,c<<3);a=v[f+624>>2];m=A[v[i+4>>2]+1280>>3];w=I(+v[j+88>>2]*.01*+(a>>>0)+ +v[j+92>>2]-m);ga:{if(w<4294967296&w>=0){b=~~w>>>0;break ga}b=0}v[j+96>>2]=b;m=I(+(c>>>0)*.02*+v[j+80>>2]+ +v[j+84>>2]-m);ha:{if(m<4294967296&m>=0){J=~~m>>>0;break ha}J=0}L=v[j+72>>2];ia:{ja:{if(!J|a>>>0<=L>>>0){break ja}ka=$&-4;pa=$&2;while(1){if(y[j+64>>2]<=v[j+4>>2]-v[j+8>>2]>>>0){break ja}if(rc(v[i+4>>2],v[i+24>>2],0)){break ja}l=L<<2;ka:{if(v[j+20>>2]?0:v[l+da>>2]){break ka}m=A[R+(L<<3)>>3];w=m;m=A[v[i+4>>2]+1296>>3];if(w-H(w+m)<=m){break ka}a=v[f+712>>2];d=v[v[a+((L>>>0)%(c>>>0)<<2)>>2]+252>>2];la:{if(!d){k=0;b=0;break la}k=v[d+8>>2];b=v[d+12>>2]}if((b|0)==(0-k|0)){break ka}ma:{if(c>>>0>L>>>0){if(!v[v[a+l>>2]+252>>2]){break ka}if(v[d+12>>2]){break ma}break ka}if(!d|!v[d+8>>2]){break ka}}if(v[f+624>>2]){b=0;g=v[f+680>>2];d=v[f+652>>2];a=v[f+648>>2];while(1){t=b<<2;v[t+a>>2]=-1;v[d+t>>2]=-1;v[g+t>>2]=-1;v[t+ga>>2]=0;v[t+C>>2]=0;b=b+1|0;if(b>>>0<y[f+624>>2]){continue}break}}T=T+1|0;N=0;v[f+632>>2]=0;v[f+640>>2]=0;v[f+644>>2]=0;v[f+620>>2]=0;b=1;v[l+ga>>2]=1;v[l+v[f+636>>2]>>2]=0;a=v[f+696>>2];v[a>>2]=0;v[f+616>>2]=1;v[ba>>2]=L;v[(a+(v[f+632>>2]<<2)|0)+4>>2]=0;a=v[f+632>>2];while(1){v[f+560>>2]=1;U=v[f+712>>2];g=f+616|0;d=a;_=f+560|0;a=0;la=0;Q=ub-128|0;ub=Q;v[f+604>>2]=0;v[Q+112>>2]=0;l=b;na:{oa:{pa:{qa:{ra:{if(!b){b=v[g+80>>2];break ra}W=g+52|0;P=g+60|0;E=g+44|0;x=g+56|0;Y=g+48|0;S=g+40|0;z=d-1|0;ia=d+1|0;s=v[g+8>>2]>>>1|0;Z=0-s|0;b=v[g+80>>2];while(1){t=v[ba+(la<<2)>>2];n=t<<2;v[n+v[g+32>>2]>>2]=v[g+24>>2];v[n+v[g+36>>2]>>2]=v[g+28>>2];r=ia<<2;v[n+v[g+64>>2]>>2]=v[r+b>>2]+a;sa:{if(!v[j+32>>2]){break sa}n=t+(s>>>0>t>>>0?s:Z)|0;b=n<<2;a=b+ga|0;if(!v[a>>2]){if(y[f+604>>2]>y[j+96>>2]){break sa}v[g>>2]=v[g>>2]+1;v[b+v[g+20>>2]>>2]=ia;v[a>>2]=1;v[aa+(v[f+604>>2]<<2)>>2]=n;v[f+604>>2]=v[f+604>>2]+1;if(!v[a>>2]){break sa}}a=v[b+v[g+20>>2]>>2];if(!((a|0)==(ia|0)|(a|0)==(z|0))&(a|0)!=(d|0)){break sa}a=Gda(i,g,t,n,d,0,Q+112|0,_);if((a|0)!=1){Eb(158781,2182);v[Q+96>>2]=a;Fb(276579,Q+96|0);break na}if(!v[_>>2]){break qa}}ta:{if(!(v[g+16>>2]|!v[j+76>>2])){k=1618;ja=Ib(v[v[i>>2]+8>>2],v[g+8>>2],4,158747,1618);v[Q+124>>2]=ja;a=-1;if(!ja){break oa}dc(ja,v[g+8>>2]<<2);V=0;ma=v[g+8>>2]>>>1|0;G=t-ma|0;n=t>>>0<ma>>>0;K=n?t:G;b=v[v[U+(K<<2)>>2]+252>>2];ua:{if(!b){break ua}b=b+(n<<2)|0;p=v[b+8>>2];if(!p){break ua}h=ja+(ma<<2)|0;o=v[b>>2];ea=0;while(1){b=v[o+(ea<<2)>>2];q=v[b+8>>2];if(q){M=v[b+4>>2];u=v[b>>2];n=v[j+44>>2];k=0;while(1){b=k<<2;ca=v[(v[v[b+u>>2]+292>>2]<<2)+n>>2];va:{if((ca|0)==(K|0)){break va}m=A[R+(ca<<3)>>3];w=m;m=A[v[i+4>>2]+1296>>3];if(w-H(w+m)<=m){break va}wa:{if(v[b+M>>2]==1){b=ja+(ca<<2)|0;if(!v[b>>2]){break wa}break va}b=h+(ca<<2)|0;if(v[b>>2]){break va}}v[b>>2]=1;V=V+1|0}k=k+1|0;if((q|0)!=(k|0)){continue}break}}ea=ea+1|0;if((p|0)!=(ea|0)){continue}break}}k=1700;o=Ib(v[v[i>>2]+8>>2],V,4,158747,1700);v[Q+120>>2]=o;if(!o){break oa}k=1701;n=Ib(v[v[i>>2]+8>>2],V,8,158747,1701);v[Q+116>>2]=n;if(!n){break oa}k=0;b=0;a=v[g+8>>2];if(a){while(1){if(v[ja+(k<<2)>>2]){v[o+(b<<2)>>2]=k;w=A[R+(k<<3)>>3];m=1-w;A[n+(b<<3)>>3]=m<=w?m:w;b=b+1|0;a=v[g+8>>2]}k=k+1|0;if(k>>>0<a>>>0){continue}break}}ai(n,o,V);Hb(v[v[i>>2]+8>>2],Q+116|0,158747,1722);xa:{if(!V|y[f+604>>2]>y[j+96>>2]){break xa}M=R+(t<<3)|0;u=R+(G<<3)|0;b=0;while(1){q=v[o+(b<<2)>>2];v[g>>2]=v[g>>2]+1;a=q<<2;v[a+v[g+20>>2]>>2]=ia;v[a+ga>>2]=1;v[aa+(v[f+604>>2]<<2)>>2]=q;v[f+604>>2]=v[f+604>>2]+1;v[v[g+40>>2]+(v[g+24>>2]<<2)>>2]=q;n=v[g+48>>2]+(v[g+24>>2]<<2)|0;a=v[j+116>>2];w=+v[j>>2];if(t>>>0<ma>>>0){m=1-A[M>>3]}else{m=A[u>>3]+-1+1}m=I(w*(m-A[R+(q<<3)>>3])-A[v[i+4>>2]+1296>>3]);ya:{if(D(m)<2147483648){q=~~m;break ya}q=-2147483648}v[n>>2]=(a|0)>(q|0)?a:q;a=v[g+24>>2]+1|0;v[g+24>>2]=a;v[g+4>>2]=v[g+4>>2]+1;za:{if((a|0)==v[g+56>>2]){a=zx(i,g,x,S,Y,0,0,_);if((a|0)!=1){k=1763;break oa}if(!v[_>>2]){break xa}b=b+1|0;if(V>>>0>b>>>0){break za}break xa}b=b+1|0;if(V>>>0<=b>>>0){break xa}}if(y[f+604>>2]<=y[j+96>>2]){continue}break}}Hb(v[v[i>>2]+8>>2],Q+120|0,158747,1771);Hb(v[v[i>>2]+8>>2],Q+124|0,158747,1772);break ta}ca=v[g+8>>2]>>>1|0;n=t-ca|0;b=t>>>0<ca>>>0;a=v[v[U+((b?t:n)<<2)>>2]+252>>2];if(!a){break ta}a=a+(b<<2)|0;K=v[a+8>>2];if(!K){break ta}p=R+(t<<3)|0;h=R+(n<<3)|0;o=v[a>>2];V=0;while(1){a=v[o+(V<<2)>>2];q=v[a+8>>2];if(q){M=v[a+4>>2];u=v[a>>2];k=0;while(1){b=k<<2;a=v[v[j+44>>2]+(v[v[b+u>>2]+292>>2]<<2)>>2];m=A[R+(a<<3)>>3];fa=A[v[i+4>>2]+1296>>3];Aa:{if(m-H(m+fa)<=fa){break Aa}a=a+(v[b+M>>2]?0:ca)|0;G=a<<2;n=G+ga|0;Ba:{if(v[n>>2]){b=v[g+20>>2];break Ba}if(y[f+604>>2]>y[j+96>>2]){break Aa}v[g>>2]=v[g>>2]+1;b=v[g+20>>2];v[G+b>>2]=ia;v[n>>2]=1;v[aa+(v[f+604>>2]<<2)>>2]=a;v[f+604>>2]=v[f+604>>2]+1;if(!v[n>>2]){break Aa}}b=v[b+G>>2];if(!((b|0)==(z|0)|(b|0)==(ia|0))&(b|0)!=(d|0)){break Aa}b=t;n=v[j+116>>2];w=+v[j>>2];if(b>>>0<ca>>>0){m=1-A[p>>3]}else{m=A[h>>3]+-1+1}m=I(w*(m-A[R+(a<<3)>>3])-fa);Ca:{if(D(m)<2147483648){G=~~m;break Ca}G=-2147483648}a=Gda(i,g,b,a,d,(n|0)>(G|0)?n:G,Q+112|0,_);if((a|0)!=1){break pa}if(!v[_>>2]){break qa}}k=k+1|0;if((q|0)!=(k|0)){continue}break}}V=V+1|0;if((K|0)!=(V|0)){continue}break}}a=1;if(!v[_>>2]){break na}v[v[g+40>>2]+(v[g+24>>2]<<2)>>2]=-1;b=v[g+24>>2]+1|0;v[g+24>>2]=b;if((b|0)==v[g+56>>2]){b=zx(i,g,x,S,Y,0,0,_);if((b|0)!=1){Eb(158781,2214);v[Q+16>>2]=b;Fb(276579,Q+16|0);a=b;break na}if(!v[_>>2]){break na}}v[v[g+44>>2]+(v[g+28>>2]<<2)>>2]=-1;b=v[g+28>>2]+1|0;v[g+28>>2]=b;if((b|0)==v[g+60>>2]){b=zx(i,g,P,E,W,0,0,_);if((b|0)!=1){Eb(158781,2224);v[Q>>2]=b;Fb(276579,Q);a=b;break na}if(!v[_>>2]){break na}}a=v[Q+112>>2];t=a<<2;b=v[g+80>>2];n=r+b|0;v[t+(v[g+68>>2]+(v[n>>2]<<2)|0)>>2]=0;v[t+(v[g+72>>2]+(v[n>>2]<<2)|0)>>2]=0;la=la+1|0;if((l|0)!=(la|0)){continue}break}}b=(d<<2)+b|0;v[b+8>>2]=v[b+4>>2]+a}a=1;break na}Eb(158781,1553);v[Q+48>>2]=a;Fb(276579,Q+48|0);Eb(158781,2197);v[Q+32>>2]=a;Fb(276579,Q+32|0);break na}Eb(158781,k);v[Q+80>>2]=a;Fb(276579,Q+80|0);Eb(158781,2192);v[Q+64>>2]=a;Fb(276579,Q- -64|0)}ub=Q+128|0;if((a|0)!=1){Eb(158781,2534);v[f+512>>2]=a;Fb(276579,f+512|0);break W}if(!v[f+560>>2]){break ia}a=v[f+632>>2];Da:{if(!a|!v[j+40>>2]&(a|0)==1){break Da}a=v[f+696>>2]+(a<<2)|0;x=v[a+4>>2];if(x>>>0>=y[a+8>>2]){break Da}Z=0;b=v[j+104>>2];a=N-v[j+100>>2]|0;b=(a|0)>(b|0)?b:a;a=(v[j+8>>2]+v[j+64>>2]|0)-v[j+4>>2]|0;q=(a|0)>(b|0)?b:a;if(!q){break Da}while(1){if(rc(v[i+4>>2],v[i+24>>2],0)){break Da}a=v[j>>2];S=x<<2;g=v[S+v[f+684>>2]>>2];P=v[f+580>>2];p=P;W=v[f+596>>2];E=v[f+592>>2];l=v[f+588>>2];if(v[f+624>>2]){b=a<<1;a=0;while(1){d=a<<2;v[d+p>>2]=B(b,v[f+616>>2]);v[d+l>>2]=-1;v[d+E>>2]=0;a=a+1|0;if(a>>>0<y[f+624>>2]){continue}break}}v[p+(g<<2)>>2]=0;v[W>>2]=g;h=v[f+660>>2];M=v[f+652>>2];a=0;V=0;while(1){b=a;u=v[W+(b<<2)>>2];d=u<<2;a=v[d+M>>2];z=v[h+(a<<2)>>2];if((z|0)>=0){n=d+p|0;t=v[f+668>>2];while(1){d=v[t+(a<<2)>>2]+v[n>>2]|0;o=z<<2;g=o+p|0;Ea:{if(d>>>0>=y[g>>2]){break Ea}v[g>>2]=d;v[l+o>>2]=u;d=o+E|0;if(v[d>>2]){break Ea}V=V+1|0;v[W+(V<<2)>>2]=z;v[d>>2]=1}a=a+1|0;z=v[h+(a<<2)>>2];if((z|0)>=0){continue}break}}a=b+1|0;if((b|0)<(V|0)){continue}break}a=0;if(v[f+616>>2]){while(1){v[(a<<2)+C>>2]=0;a=a+1|0;if(a>>>0<y[f+616>>2]){continue}break}}s=f+616|0;M=v[l+(L<<2)>>2];G=v[S+v[f+684>>2]>>2];Fa:{if((M|0)==(G|0)){z=v[s+44>>2];ea=v[s+36>>2];break Fa}u=v[s+80>>2];K=u+4|0;n=v[s+20>>2];z=v[s+44>>2];ea=v[s+36>>2];p=v[s+40>>2];t=v[s+32>>2];while(1){r=M<<2;a=v[r+t>>2];b=v[p+(a<<2)>>2];if((b|0)>=0){while(1){v[(b<<2)+C>>2]=1;a=a+1|0;b=v[p+(a<<2)>>2];if((b|0)>=0){continue}break}}a=v[r+ea>>2];b=v[(a<<2)+z>>2];if((b|0)>=0){while(1){v[(b<<2)+C>>2]=1;a=a+1|0;b=v[(a<<2)+z>>2];if((b|0)>=0){continue}break}}g=n+r|0;b=v[g>>2]<<2;a=v[b+u>>2];if(a>>>0<y[b+K>>2]){h=v[s+72>>2];d=v[s+68>>2];while(1){o=a<<2;b=o+d|0;if(v[b>>2]==(M|0)){v[(v[h+o>>2]<<2)+C>>2]=1}if(v[h+o>>2]==(M|0)){v[(v[b>>2]<<2)+C>>2]=1}a=a+1|0;if(a>>>0<y[K+(v[g>>2]<<2)>>2]){continue}break}}M=v[l+r>>2];if((G|0)!=(M|0)){continue}break}}a=v[(G<<2)+ea>>2];b=v[(a<<2)+z>>2];if((b|0)>=0){while(1){v[(b<<2)+C>>2]=1;a=a+1|0;b=v[(a<<2)+z>>2];if((b|0)>=0){continue}break}}Ga:{C=v[f+576>>2];b=v[S+v[f+688>>2]>>2];if(v[C+(b<<2)>>2]){break Ga}a=v[j>>2];G=v[f+584>>2];g=0;h=0;r=ub-32|0;ub=r;K=Ib(v[v[i>>2]+8>>2],v[s+8>>2],4,158747,1996);v[r+28>>2]=K;Ha:{if(!K){Eb(158781,1996);v[r>>2]=-1;Fb(276579,r);a=-1;break Ha}z=Ib(v[v[i>>2]+8>>2],v[s+8>>2],4,158747,1997);v[r+24>>2]=z;if(z){if(v[s+8>>2]){a=a<<1;while(1){d=g<<2;v[d+P>>2]=B(a,v[s>>2]);v[d+K>>2]=-1;v[d+G>>2]=-1;v[d+z>>2]=-1;v[d+E>>2]=0;g=g+1|0;if(g>>>0<y[s+8>>2]){continue}break}}v[P+(b<<2)>>2]=0;v[W>>2]=b;o=v[s+44>>2];M=v[s+36>>2];a=0;while(1){d=a;u=v[W+(a<<2)>>2];g=u<<2;b=v[g+M>>2];a=v[o+(b<<2)>>2];if((a|0)>=0){n=g+P|0;while(1){p=a<<2;Ia:{if(v[p+C>>2]?(a|0)!=(L|0):0){break Ia}g=v[v[s+52>>2]+(b<<2)>>2]+v[n>>2]|0;t=p+P|0;if(g>>>0>=y[t>>2]){break Ia}v[t>>2]=g;v[p+K>>2]=u;g=p+E|0;if(v[g>>2]){break Ia}h=h+1|0;v[W+(h<<2)>>2]=a;v[g>>2]=1}b=b+1|0;a=v[o+(b<<2)>>2];if((a|0)>=0){continue}break}}a=d+1|0;if((d|0)<(h|0)){continue}break}v[z>>2]=L;b=K+(L<<2)|0;k=v[b>>2];Ja:{if((k|0)<0){break Ja}g=1;t=0;while(1){a=g;v[z+(a<<2)>>2]=k;d=t;t=d+1|0;g=a+1|0;b=K+(v[b>>2]<<2)|0;k=v[b>>2];if((k|0)>=0){continue}break}if(!a){break Ja}u=z-8|0;n=a&3;Ka:{if(!n){b=g;break Ka}t=0;while(1){b=a;v[G+(v[z+(b<<2)>>2]<<2)>>2]=v[u+(g<<2)>>2];a=b-1|0;g=b;t=t+1|0;if((n|0)!=(t|0)){continue}break}}if(d>>>0<3){break Ja}while(1){d=a<<2;v[G+(v[d+z>>2]<<2)>>2]=v[u+(b<<2)>>2];b=d-4|0;v[G+(v[b+z>>2]<<2)>>2]=v[d+u>>2];d=d-8|0;v[G+(v[d+z>>2]<<2)>>2]=v[b+u>>2];b=a-3|0;v[G+(v[z+(b<<2)>>2]<<2)>>2]=v[d+u>>2];a=a-4|0;if(a){continue}break}}Hb(v[v[i>>2]+8>>2],r+24|0,158747,2072);Hb(v[v[i>>2]+8>>2],r+28|0,158747,2073);a=1;break Ha}Eb(158781,1997);v[r+16>>2]=-1;Fb(276579,r+16|0);a=-1}ub=r+32|0;if((a|0)!=1){Eb(158781,2590);v[f+496>>2]=a;Fb(276579,f+496|0);break W}if(v[G+(v[S+v[f+688>>2]>>2]<<2)>>2]<0){break Ga}a=Ib(v[v[i>>2]+8>>2],$,4,158747,2597);v[f+552>>2]=a;if(!a){Eb(158781,2597);a=-1;v[f+400>>2]=-1;Fb(276579,f+400|0);break W}n=Ib(v[v[i>>2]+8>>2],$,4,158747,2598);v[f+548>>2]=n;if(!n){break ba}La:{if(!$){break La}t=0;g=v[f+552>>2];a=0;k=0;if($>>>0>=4){while(1){d=a<<2;v[d+g>>2]=-1;v[d+n>>2]=0;b=d|4;v[b+g>>2]=-1;v[b+n>>2]=0;b=d|8;v[b+g>>2]=-1;v[b+n>>2]=0;b=d|12;v[b+g>>2]=-1;v[b+n>>2]=0;a=a+4|0;k=k+4|0;if((ka|0)!=(k|0)){continue}break}}if(!pa){break La}while(1){b=a<<2;v[b+g>>2]=-1;v[b+n>>2]=0;a=a+1|0;t=t+1|0;if((pa|0)!=(t|0)){continue}break}}v[f+560>>2]=1;v[f+556>>2]=0;a=v[S+v[f+688>>2]>>2];b=L;Ma:{if((a|0)!=(b|0)){while(1){d=a<<2;g=d+G|0;b=v[f+552>>2];v[d+b>>2]=v[g>>2];a=oB(i,b,v[f+548>>2],da,a,v[S+v[f+688>>2]>>2],c,f+556|0,v[j+36>>2],v[j+24>>2],f+560|0);if((a|0)!=1){Eb(158781,2621);v[f+480>>2]=a;Fb(276579,f+480|0);break W}d=v[f+560>>2];a=v[g>>2];if((L|0)!=(a|0)?d:0){continue}break}b=a;if(!d){break Ma}}while(1){if(v[S+v[f+684>>2]>>2]!=(b|0)){d=b<<2;g=d+l|0;a=v[f+552>>2];v[d+a>>2]=v[g>>2];a=oB(i,a,v[f+548>>2],da,b,v[S+v[f+688>>2]>>2],c,f+556|0,v[j+36>>2],v[j+24>>2],f+560|0);if((a|0)!=1){Eb(158781,2637);v[f+464>>2]=a;Fb(276579,f+464|0);break W}b=v[g>>2];if(v[f+560>>2]){continue}break Ma}break}d=v[f+552>>2];a=v[S+v[f+688>>2]>>2];v[d+(b<<2)>>2]=a;a=oB(i,d,v[f+548>>2],da,b,a,c,f+556|0,v[j+36>>2],v[j+24>>2],f+560|0);if((a|0)!=1){Eb(158781,2651);v[f+448>>2]=a;Fb(276579,f+448|0);break W}if(!v[f+560>>2]){break Ma}v[f+544>>2]=0;v[f+536>>2]=0;a=v[f+688>>2];v[f+540>>2]=f+616;b=v[j+4>>2];a=Ida(i,na,O,v[f+712>>2],c,v[a+S>>2],v[f+552>>2],v[f+556>>2],da,R,j,f+536|0,e);if((a|0)!=1){break aa}a=b>>>0<y[j+4>>2];N=a+N|0;Z=a+Z|0}Hb(v[v[i>>2]+8>>2],f+548|0,158747,2677);Hb(v[v[i>>2]+8>>2],f+552|0,158747,2678);switch(v[e>>2]-7|0){case 0:case 3:break Da;default:break Ga}}x=x+1|0;if(x>>>0>=y[(v[f+696>>2]+(v[f+632>>2]<<2)|0)+8>>2]){break Da}if(q>>>0>Z>>>0){continue}break}}Na:{switch(v[e>>2]-7|0){case 0:case 3:break ka;default:break Na}}v[f+632>>2]=v[f+632>>2]+1;b=v[f+604>>2];if(!b){break ka}k=0;a=0;if(b>>>0>=4){g=b&-4;x=0;while(1){l=a<<2;v[l+ba>>2]=v[l+aa>>2];d=l|4;v[d+ba>>2]=v[d+aa>>2];d=l|8;v[d+ba>>2]=v[d+aa>>2];d=l|12;v[d+ba>>2]=v[d+aa>>2];a=a+4|0;x=x+4|0;if((g|0)!=(x|0)){continue}break}}g=b&3;if(g){while(1){d=a<<2;v[d+ba>>2]=v[d+aa>>2];a=a+1|0;k=k+1|0;if((g|0)!=(k|0)){continue}break}}if(rc(v[i+4>>2],v[i+24>>2],0)){break ka}a=v[f+632>>2];if(y[j+100>>2]<=N>>>0|a>>>0>=y[j+120>>2]){break ka}if(y[j+64>>2]>v[j+4>>2]-v[j+8>>2]>>>0){continue}break}}L=L+1|0;if(L>>>0>=y[f+624>>2]){break ja}if(J>>>0>T>>>0){continue}break}}if(v[j+68>>2]){break ia}if(v[f+624>>2]==(L|0)){v[j+72>>2]=0;break ia}v[j+72>>2]=L}Hb(v[v[i>>2]+8>>2],f+704|0,158747,2714);Hb(v[v[i>>2]+8>>2],f+576|0,158747,2716);Hb(v[v[i>>2]+8>>2],f+580|0,158747,2717);Hb(v[v[i>>2]+8>>2],f+584|0,158747,2718);Hb(v[v[i>>2]+8>>2],f+588|0,158747,2719);Hb(v[v[i>>2]+8>>2],f+592|0,158747,2720);Hb(v[v[i>>2]+8>>2],f+596|0,158747,2721);Hb(v[v[i>>2]+8>>2],f+600|0,158747,2723);Hb(v[v[i>>2]+8>>2],f+696|0,158747,2724);Hb(v[v[i>>2]+8>>2],f+692|0,158747,2725);Hb(v[v[i>>2]+8>>2],f+688|0,158747,2726);Hb(v[v[i>>2]+8>>2],f+684|0,158747,2727);Hb(v[v[i>>2]+8>>2],f+680|0,158747,2728);Hb(v[v[i>>2]+8>>2],f+608|0,158747,2729);Hb(v[v[i>>2]+8>>2],f+612|0,158747,2730);Hb(v[v[i>>2]+8>>2],f+668|0,158747,2732);Hb(v[v[i>>2]+8>>2],f+664|0,158747,2733);Hb(v[v[i>>2]+8>>2],f+660|0,158747,2734);Hb(v[v[i>>2]+8>>2],f+656|0,158747,2735);Hb(v[v[i>>2]+8>>2],f+652|0,158747,2736);Hb(v[v[i>>2]+8>>2],f+648|0,158747,2737);Hb(v[v[i>>2]+8>>2],f+636|0,158747,2738);Hb(v[v[i>>2]+8>>2],oa,158747,2740);Hb(v[v[i>>2]+8>>2],f+712|0,158747,2741);Hb(v[v[i>>2]+8>>2],f+708|0,158747,2742)}a=1;break W}Eb(158781,2392);Fb(284511,0);a=-9;break W}Eb(158781,2598);a=-1;v[f+416>>2]=-1;Fb(276579,f+416|0);break W}Eb(158781,2667);v[f+432>>2]=a;Fb(276579,f+432|0);break W}Eb(158781,2320);a=-1;v[f>>2]=-1;Fb(276579,f);break W}Eb(158781,2399);a=-1;v[f+32>>2]=-1;Fb(276579,f+32|0)}ub=f+720|0;g=a;if((a|0)==1){break h}Eb(158781,3608);v[X>>2]=a;Fb(276579,X);break a}if(v[j+4>>2]!=v[j+8>>2]){v[j+128>>2]=0;g=1;break a}g=1;v[j+128>>2]=v[j+128>>2]+1}ub=X+48|0;return g}function d0a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,x=0,z=0,C=0,E=0,G=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;f=ub-3360|0;ub=f;d=1;E=v[b+60>>2];v[e>>2]=1;v[f+1300>>2]=0;v[f+1308>>2]=0;v[f+1288>>2]=0;v[f+1268>>2]=0;v[f+1264>>2]=0;v[f+1260>>2]=0;v[f+1256>>2]=0;v[f+1296>>2]=0;v[f+1284>>2]=0;v[f+1280>>2]=0;v[f+1292>>2]=0;v[f+1248>>2]=0;v[f+1252>>2]=0;v[f+1276>>2]=0;v[f+1272>>2]=0;N=A[E+40>>3];O=v[E>>2];T=v[E+4>>2];W=c&1;a:{if(!(W&v[E+24>>2]!=1)&(!(c&24)|v[E+24>>2]<=0)){break a}b:{if(v[E+60>>2]){if(!v[v[a+4>>2]+1440>>2]){v[f+1072>>2]=89079;jc(a,333042,f+1072|0);break a}_z(a,f+1304|0,f+1212|0,1);if(!v[f+1212>>2]){break a}i=v[v[f+1304>>2]>>2];d=v[a+28>>2];g=v[d+140>>2];h=v[d+84>>2];z=v[d+92>>2];Q=v[d+68>>2];break b}_z(a,f+1304|0,f+1212|0,0);if(!v[f+1212>>2]){break a}i=v[v[f+1304>>2]>>2];g=ef(a);h=Fm(a);z=fc(a);Q=Lc(a)}p=v[i+44>>2];c:{d:{if(!g|!z|(p|0)<2){break d}d=re(a,3546,f+1240|0);if((d|0)!=1){Eb(153318,1146);v[f+1056>>2]=d;Fb(276579,f+1056|0);break a}d=Bd(a,7904,f+1224|0);if((d|0)!=1){Eb(153318,1147);v[f+1040>>2]=d;Fb(276579,f+1040|0);break a}if(v[f+1224>>2]){l=A[f+1240>>3];d=v[a+24>>2];m=v[d+512>>2];n=v[d+516>>2];d=v[a>>2];k=v[v[d+12>>2]+12>>2];t=v[v[d+8>>2]+12>>2];q=v[d>>2];d=v[d+4>>2];o=v[d+4096>>2];j=v[q+4096>>2]+o|0;d=v[q+4100>>2]+v[d+4100>>2]|0;d=j>>>0<o>>>0?d+1|0:d;M=j;j=j+t|0;d=M>>>0>j>>>0?d+1|0:d;M=j;j=k+j|0;d=(M>>>0>j>>>0?d+1|0:d)+n|0;n=j;j=m+j|0;d=n>>>0>j>>>0?d+1|0:d;if((+(j>>>0)+ +(d|0)*4294967296)*9.5367431640625e-7*+(p|0)>=l){break d}}d=Hg(a,122422,f+1216|0);if((d|0)!=1){Eb(153318,1155);v[f+1024>>2]=d;Fb(276579,f+1024|0);break a}e:{if(ed(a,122422)){break e}d=qc(a,122422,0);if((d|0)==1){break e}Eb(153318,1158);v[f+1008>>2]=d;Fb(276579,f+1008|0);break a}d=Bd(a,50088,f+1220|0);if((d|0)!=1){Eb(153318,1160);v[f+992>>2]=d;Fb(276579,f+992|0);break a}f:{if(ed(a,50088)){break f}d=Rc(a,50088,1);if((d|0)==1){break f}Eb(153318,1163);v[f+976>>2]=d;Fb(276579,f+976|0);break a}j=Oc(v[v[a>>2]+8>>2],h,g,4,153284,1167);v[f+1288>>2]=j;if(!j){Eb(153318,1167);d=-1;v[f+64>>2]=-1;Fb(276579,f- -64|0);break a}u=Ib(v[v[a>>2]+8>>2],z,4,153284,1169);v[f+1268>>2]=u;if(!u){Eb(153318,1169);d=-1;v[f+80>>2]=-1;Fb(276579,f+80|0);break a}x=Ib(v[v[a>>2]+8>>2],g,4,153284,1170);v[f+1264>>2]=x;if(!x){Eb(153318,1170);d=-1;v[f+96>>2]=-1;Fb(276579,f+96|0);break a}d=Ib(v[v[a>>2]+8>>2],p+1|0,4,153284,1171);v[f+1260>>2]=d;if(!d){Eb(153318,1171);d=-1;v[f+112>>2]=-1;Fb(276579,f+112|0);break a}Ap(i,h,x,g);Ln(i,Q,u,z);Jj(x,j,g);g:{h:{if(!(!v[E+56>>2]|v[x>>2]!=-2)){d=vO(a,f+1300|0,p,v[E+60>>2],v[i+76>>2]);if((d|0)!=1){Eb(153318,1183);v[f+960>>2]=d;Fb(276579,f+960|0);break a}d=j;R=v[v[i+36>>2]>>2];t=ub-80|0;ub=t;m=v[f+1300>>2];p=Ku(m,Q,u,z);i:{if((p|0)!=1){Eb(153318,590);v[t+64>>2]=p;Fb(276579,t- -64|0);break i}p=Ju(m,d,x,g);if((p|0)!=1){Eb(153318,591);v[t+48>>2]=p;Fb(276579,t+48|0);break i}n=d;k=ub+-64|0;ub=k;d=fc(a);h=v[v[a+28>>2]+92>>2];p=fc(a);K=((h|0)>(p|0)?h:p)<<1;q=Ib(v[v[a>>2]+8>>2],K,4,151328,574);v[k+56>>2]=q;j:{if(!q){Eb(151362,574);h=-1;v[k>>2]=-1;Fb(276579,k);break j}r=Ib(v[v[a>>2]+8>>2],K,4,151328,575);v[k+60>>2]=r;if(!r){Eb(151362,575);h=-1;v[k+16>>2]=-1;Fb(276579,k+16|0);break j}if(v[m+72>>2]){j=v[v[a+28>>2]+68>>2]}else{j=Lc(a)}Ln(m,j,q,d);h=0;k:{if((d|0)<=0){break k}while(1){p=v[(h<<2)+q>>2];if((p|0)==-1){h=h+1|0;if((d|0)!=(h|0)){continue}break k}break}v[k+44>>2]=p}l:{if((R|0)>0){while(1){V=n+(S<<2)|0;h=Zz(a,m,v[V>>2],r,q,K,k+48|0,k+52|0,k+40|0);if((h|0)!=1){d=595;break l}if(!v[k+40>>2]){h=0;d=596;break l}q=v[k+56>>2];r=v[k+60>>2];Jj(q,r,v[k+48>>2]);m:{o=v[k+48>>2];if(!o){h=Ju(m,V,k+44|0,1);if((h|0)==1){break m}d=602;break l}if(v[((o<<2)+q|0)-4>>2]==-1){$=$+1|0;break m}C=0;i=0;p=v[q>>2];n:{if((p|0)!=-1){break n}d=(o|0)<=1?1:o;h=d-1|0;while(1){if((h|0)==(i|0)){p=v[(d<<2)+q>>2];i=d;break n}i=i+1|0;p=v[(i<<2)+q>>2];if((p|0)==-1){continue}break}}X=i<<2;Y=X+q|0;M=-1;d=i;h=d;while(1){h=h+1|0;if((o|0)<=(h|0)){p=M;h=d+1|0;j=((h|0)<(o|0)?o:h)-d|0;M=(j|0)>(C|0);p=M?d:p;if((p|0)>(i|0)){Wb(Y,255,p-i<<2)}d=664;h=Ku(m,r+X|0,Y,p-i|0);if((h|0)!=1){break l}h=p+(M?j:C)|0;if((h|0)<(o|0)){Wb((h<<2)+q|0,255,o-h<<2)}i=h<<2;h=Ku(m,i+r|0,i+q|0,o-h|0);if((h|0)!=1){break l}h=Ju(m,V,(p<<2)+q|0,1);if((h|0)==1){break m}d=667;break l}j=v[(h<<2)+q>>2];if((j|0)==(p|0)){continue}Z=h-d|0;p=(Z|0)>(C|0);C=p?Z:C;M=p?d:M;p=j;d=h;continue}}S=S+1|0;if((R|0)!=(S|0)){continue}break}}Hb(v[v[a>>2]+8>>2],k+60|0,151328,674);Hb(v[v[a>>2]+8>>2],k+56|0,151328,675);h=1;break j}Eb(151362,d);v[k+32>>2]=h;Fb(276579,k+32|0)}ub=k- -64|0;p=h;if((h|0)!=1){Eb(153318,596);v[t+32>>2]=h;Fb(276579,t+32|0);break i}p=tO(a,m,n,g);if((p|0)!=1){Eb(153318,598);v[t+16>>2]=p;Fb(276579,t+16|0);break i}p=Wt(a,m);if((p|0)!=1){Eb(153318,600);v[t>>2]=p;Fb(276579,t);break i}Ap(m,n,x,g);Ln(m,Q,u,z);Jj(x,n,g);p=1}ub=t+80|0;d=p;if((d|0)==1){break h}Eb(153318,1185);v[f+944>>2]=d;Fb(276579,f+944|0);break a}d=Wt(a,i);if((d|0)==1){break g}Eb(153318,1198);v[f+928>>2]=d;Fb(276579,f+928|0);break a}i=v[f+1300>>2]}p=v[i+44>>2];d=qc(a,122422,v[f+1216>>2]);if((d|0)!=1){Eb(153318,1203);v[f+912>>2]=d;Fb(276579,f+912|0);break a}d=Rc(a,50088,v[f+1220>>2]);if((d|0)!=1){Eb(153318,1204);v[f+896>>2]=d;Fb(276579,f+896|0);break a}if(v[v[i+36>>2]>>2]){break d}t=v[v[i+32>>2]>>2];if(!t){break d}v[e>>2]=3;d=Gka(i,v[f+1260>>2],p+1|0);if((d|0)!=1){Eb(153318,1227);v[f+880>>2]=d;Fb(276579,f+880|0);break a}K=v[f+1288>>2];M=v[f+1260>>2];i=ub-1184|0;ub=i;n=f+1228|0;v[n>>2]=1;m=f+1308|0;d=Vb(v[v[a>>2]+4>>2],16,153284,267);v[m>>2]=d;o:{p:{q:{r:{if(!d){Eb(153318,267);v[i+16>>2]=-1;Fb(276579,i+16|0);break r}v[i+128>>2]=v[v[a+28>>2]+32>>2];d=i+144|0;Jb(d,1024,63138,i+128|0);d=Sd(d,Pb(d)+1|0,1,153284,272);v[v[m>>2]+4>>2]=d;if(!d){Eb(153318,272);v[i+32>>2]=-1;Fb(276579,i+32|0);break r}d=Tb(v[v[a>>2]+4>>2],p,48,153284,276);v[v[m>>2]+8>>2]=d;if(d){break q}Eb(153318,276);v[i+48>>2]=-1;Fb(276579,i+48|0)}d=-1;h=525;break p}v[v[m>>2]>>2]=a;v[v[m>>2]+12>>2]=0;h=529;d=Ic(i+136|0,v[v[a>>2]+4>>2],g);if((d|0)!=1){break p}s:{t:{if((p|0)<=0){break t}if((p|0)!=1){k=p&2147483646;h=0;while(1){g=v[m>>2];j=v[g+12>>2];d=v[g+8>>2]+B(j,48)|0;v[d+12>>2]=0;v[d+16>>2]=0;v[d+4>>2]=0;v[d>>2]=g;v[d+40>>2]=0;v[d+44>>2]=0;v[d+8>>2]=j;v[d+20>>2]=0;v[d+24>>2]=0;v[d+28>>2]=0;v[d+32>>2]=0;v[g+12>>2]=j+1;g=v[m>>2];j=v[g+12>>2];d=v[g+8>>2]+B(j,48)|0;v[d+12>>2]=0;v[d+16>>2]=0;v[d+4>>2]=0;v[d>>2]=g;v[d+40>>2]=0;v[d+44>>2]=0;v[d+8>>2]=j;v[d+20>>2]=0;v[d+24>>2]=0;v[d+28>>2]=0;v[d+32>>2]=0;v[g+12>>2]=j+1;h=h+2|0;if((k|0)!=(h|0)){continue}break}}if(p&1){g=v[m>>2];h=v[g+12>>2];d=v[g+8>>2]+B(h,48)|0;v[d+12>>2]=0;v[d+16>>2]=0;v[d+4>>2]=0;v[d>>2]=g;v[d+40>>2]=0;v[d+44>>2]=0;v[d+8>>2]=h;v[d+20>>2]=0;v[d+24>>2]=0;v[d+28>>2]=0;v[d+32>>2]=0;v[g+12>>2]=h+1}if((p|0)<=0){break t}while(1){g=v[v[m>>2]+8>>2];d=Ic(i+140|0,v[v[a>>2]+4>>2],fc(a));if((d|0)!=1){h=542;break p}d=B(L,48);L=L+1|0;x=v[M+(L<<2)>>2];r=v[i+136>>2];C=v[i+140>>2];g=d+g|0;q=v[g>>2];k=v[q>>2];v[n>>2]=1;u:{h=g+4|0;d=Gf(h);j=330;v:{if((d|0)!=1){break v}d=eo(v[h>>2]);j=332;if((d|0)!=1){break v}d=re(k,2680,i+1176|0);j=335;if((d|0)!=1){break v}d=Xe(v[h>>2],2680,A[i+1176>>3]);j=336;if((d|0)!=1){break v}d=Xh(k,v[h>>2]);j=338;if((d|0)!=1){break v}d=Bh(v[h>>2]);j=341;if((d|0)!=1){break v}d=Wg(v[h>>2],3,1);j=344;if((d|0)!=1){break v}d=Uf(v[h>>2],2,1);j=347;if((d|0)!=1){break v}d=qc(v[h>>2],3458,0);j=350;if((d|0)!=1){break v}d=Rc(v[h>>2],140470,0);j=353;if((d|0)!=1){break v}d=qc(v[h>>2],92013,0);j=361;if((d|0)!=1){break v}d=Rc(v[h>>2],103062,0);if((d|0)==1){break u}j=362}Eb(153318,j);v[i+112>>2]=d;Fb(276579,i+112|0);h=462;break s}w:{x:{if(v[h>>2]){d=v[q+4>>2];v[i+100>>2]=v[g+8>>2];v[i+96>>2]=d;d=i+144|0;Jb(d,1024,139628,i+96|0);j=v[g+4>>2];v[n>>2]=1;v[i+1176>>2]=0;y:{z:{d=CO(k,j,C,r,0,d);o=395;A:{if((d|0)!=1){break A}q=0;if((x|0)<=0){break z}R=K+(_<<2)|0;while(1){u=v[R+(q<<2)>>2];d=v[u+84>>2];S=i+1176|0;d=zl(k,j,u,S,v[u+12>>2],C,r,0,d&1,d>>>1&1,d>>>2&1,d>>>3&1,d>>>4&1,0,0,d>>>9&1,d>>>10&1,0,0,n);o=416;if((d|0)!=1){break A}d=v[n>>2];if(!d){break y}u=v[i+1176>>2];if(!u){break y}d=mc(j,u);o=422;if((d|0)!=1){break A}d=ec(j,S);if((d|0)==1){q=q+1|0;if((x|0)==(q|0)){break z}continue}break}o=423}Eb(153318,o);v[i+80>>2]=d;Fb(276579,i+80|0);h=469;break s}d=v[n>>2]}if(!d){d=ne(h);if((d|0)==1){break x}h=473;break s}h=481;d=v[v[g+4>>2]+28>>2];j=v[d+68>>2];o=v[d+92>>2];d=Ib(v[v[k>>2]+8>>2],o,4,153284,481);v[g+12>>2]=d;if(!d){d=-1;break s}v[g+16>>2]=o;B:{if((o|0)<=0){break B}q=0;d=0;if(o>>>0>=4){C=o&2147483644;r=0;while(1){h=d<<2;v[h+v[g+12>>2]>>2]=v[h+j>>2];u=h|4;v[u+v[g+12>>2]>>2]=v[j+u>>2];u=h|8;v[u+v[g+12>>2]>>2]=v[j+u>>2];h=h|12;v[h+v[g+12>>2]>>2]=v[h+j>>2];d=d+4|0;r=r+4|0;if((C|0)!=(r|0)){continue}break}}h=o&3;if(!h){break B}while(1){o=d<<2;v[o+v[g+12>>2]>>2]=v[j+o>>2];d=d+1|0;q=q+1|0;if((h|0)!=(q|0)){continue}break}}d=v[v[g+4>>2]+28>>2];A[g+40>>3]=+(v[d+96>>2]+(v[d+92>>2]+v[d+100>>2]|0)|0)/+((fc(k)+ke(k)|0)+hd(k)|0);break w}v[n>>2]=0;break w}v[h>>2]=0}Bc(i+140|0);if(!v[n>>2]){break t}_=x+_|0;if((p|0)!=(L|0)){continue}break}}Bc(i+136|0);g=1;if(v[n>>2]){break o}h=563;d=lia(m,p);g=1;if((d|0)==1){break o}break p}Eb(153318,h);v[i+64>>2]=d;Fb(276579,i- -64|0);h=549}Eb(153318,h);v[i>>2]=d;Fb(276579,i);g=d}ub=i+1184|0;d=g;if((d|0)!=1){Eb(153318,1230);v[f+864>>2]=d;Fb(276579,f+864|0);break a}if(!v[f+1228>>2]){break d}h=Ib(v[v[a>>2]+8>>2],t,8,153284,1238);v[f+1284>>2]=h;if(!h){Eb(153318,1238);d=-1;v[f+128>>2]=-1;Fb(276579,f+128|0);break a}j=Ib(v[v[a>>2]+8>>2],v[v[f+1308>>2]+12>>2],8,153284,1239);v[f+1280>>2]=j;C:{D:{E:{F:{if(j){G:{if((t|0)<=0){break G}i=0;g=0;if(t>>>0>=8){m=t&2147483640;while(1){d=(g<<3)+h|0;v[d+4>>2]=0;v[d+12>>2]=0;v[d+20>>2]=0;v[d+28>>2]=0;v[d+36>>2]=0;v[d+44>>2]=0;v[d+52>>2]=0;v[d+60>>2]=0;g=g+8|0;s=s+8|0;if((m|0)!=(s|0)){continue}break}}d=t&7;if(!d){break G}while(1){v[((g<<3)+h|0)+4>>2]=0;g=g+1|0;i=i+1|0;if((d|0)!=(i|0)){continue}break}}d=0;if(v[v[f+1308>>2]+12>>2]>0){while(1){v[(j+(d<<3)|0)+4>>2]=0;d=d+1|0;if((d|0)<v[v[f+1308>>2]+12>>2]){continue}break}}i=Ib(v[v[a>>2]+8>>2],B(t,v[v[f+1308>>2]+12>>2]),4,153284,1248);v[f+1256>>2]=i;if(!i){Eb(153318,1248);d=-1;v[f+160>>2]=-1;Fb(276579,f+160|0);break a}j=Ib(v[v[a>>2]+8>>2],t,4,153284,1249);v[f+1296>>2]=j;if(!j){break F}if((z|0)>0){m=v[f+1268>>2];d=0;g=0;while(1){n=d<<2;if(v[n+m>>2]==-1){v[j+(g<<2)>>2]=v[n+Q>>2];n=g<<3;v[(n+h|0)+4>>2]=i+(B(v[v[f+1308>>2]+12>>2],g)<<2);h=v[f+1284>>2];v[n+h>>2]=0;g=g+1|0}d=d+1|0;if((z|0)!=(d|0)){continue}break}}if((t|0)>0){k=0;g=v[f+1308>>2];while(1){if(v[g+12>>2]>0){n=v[v[j+(k<<2)>>2]+208>>2];m=(k<<3)+h|0;d=0;i=0;while(1){if(af(v[(v[g+8>>2]+B(d,48)|0)+4>>2],n)){v[v[m+4>>2]+(i<<2)>>2]=d;i=i+1|0;v[m>>2]=i}d=d+1|0;g=v[f+1308>>2];if((d|0)<v[g+12>>2]){continue}break}}k=k+1|0;if((t|0)!=(k|0)){continue}break}}d=mia(a,f+1232|0);if((d|0)!=1){Eb(153318,1284);v[f+848>>2]=d;Fb(276579,f+848|0);break a}if(A[f+1232>>3]<=0){break d}i=Ib(v[v[a>>2]+8>>2],t,4,153284,1292);v[f+1252>>2]=i;if(!i){break E}H:{if((t|0)<=0){break H}h=0;d=0;if(t>>>0>=8){j=t&2147483640;s=0;while(1){g=i+(d<<2)|0;v[g>>2]=1;v[g+4>>2]=1;v[g+8>>2]=1;v[g+12>>2]=1;v[g+16>>2]=1;v[g+20>>2]=1;v[g+24>>2]=1;v[g+28>>2]=1;d=d+8|0;s=s+8|0;if((j|0)!=(s|0)){continue}break}}g=t&7;if(!g){break H}while(1){v[i+(d<<2)>>2]=1;d=d+1|0;h=h+1|0;if((g|0)!=(h|0)){continue}break}}if(v[v[f+1308>>2]+12>>2]<=0){break C}i=v[f+1280>>2];j=(t|0)<=0;k=0;while(1){d=k<<3;g=Ib(v[v[a>>2]+8>>2],t,4,153284,1299);v[(d+i|0)+4>>2]=g;if(!g){Eb(153318,1299);d=-1;v[f+208>>2]=-1;Fb(276579,f+208|0);break a}i=v[f+1280>>2];h=d+i|0;v[h>>2]=0;if(!j){d=0;m=v[f+1296>>2];n=B(k,48);g=0;while(1){s=d<<2;if(af(v[(n+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[v[s+m>>2]+208>>2])){v[s+v[f+1252>>2]>>2]=0;v[v[h+4>>2]+(g<<2)>>2]=d;g=g+1|0;v[h>>2]=g}d=d+1|0;if((t|0)!=(d|0)){continue}break}}k=k+1|0;d=v[v[f+1308>>2]+12>>2];if((k|0)<(d|0)){continue}break}break D}Eb(153318,1239);d=-1;v[f+144>>2]=-1;Fb(276579,f+144|0);break a}Eb(153318,1249);d=-1;v[f+176>>2]=-1;Fb(276579,f+176|0);break a}Eb(153318,1292);d=-1;v[f+192>>2]=-1;Fb(276579,f+192|0);break a}if((d|0)<=0){break C}g=p-1|0;d=0;m=v[f+1280>>2];while(1){h=m+(d<<3)|0;i=Ib(v[v[a>>2]+8>>2],B(g,v[h>>2]),4,153284,1323);j=B(d,48);v[(j+v[v[f+1308>>2]+8>>2]|0)+20>>2]=i;if(!i){Eb(153318,1323);d=-1;v[f+224>>2]=-1;Fb(276579,f+224|0);break a}i=Ib(v[v[a>>2]+8>>2],B(g,v[h>>2]),4,153284,1324);v[(j+v[v[f+1308>>2]+8>>2]|0)+24>>2]=i;if(!i){Eb(153318,1324);d=-1;v[f+240>>2]=-1;Fb(276579,f+240|0);break a}h=Ib(v[v[a>>2]+8>>2],B(g,v[h>>2]),4,153284,1325);v[(j+v[v[f+1308>>2]+8>>2]|0)+28>>2]=h;if(h){d=d+1|0;if((d|0)>=v[v[f+1308>>2]+12>>2]){break C}continue}break}Eb(153318,1325);d=-1;v[f+256>>2]=-1;Fb(276579,f+256|0);break a}d=Ib(v[v[a>>2]+8>>2],3,4,153284,1328);v[f+1292>>2]=d;if(!d){Eb(153318,1328);d=-1;v[f+272>>2]=-1;Fb(276579,f+272|0);break a}d=Ib(v[v[a>>2]+8>>2],3,8,153284,1329);v[f+1248>>2]=d;if(!d){Eb(153318,1329);d=-1;v[f+288>>2]=-1;Fb(276579,f+288|0);break a}v[d+16>>2]=0;v[d+20>>2]=-1074790400;v[d+8>>2]=0;v[d+12>>2]=1072693248;v[d>>2]=0;v[d+4>>2]=1072693248;i=0;n=v[v[f+1308>>2]+12>>2];if((n|0)>0){q=v[f+1284>>2];o=v[f+1280>>2];g=0;while(1){d=o+(g<<3)|0;L=v[d>>2];if((L|0)>0){x=v[d+4>>2];k=0;while(1){h=q+(v[x+(k<<2)>>2]<<3)|0;d=v[h>>2];I:{if((d|0)<=0){break I}j=d&3;m=v[h+4>>2];s=0;J:{if(d>>>0<4){d=0;break J}r=d&2147483644;d=0;h=0;while(1){M=i;i=m+(d<<2)|0;i=(((M+(v[i>>2]!=(g|0))|0)+(v[i+4>>2]!=(g|0))|0)+(v[i+8>>2]!=(g|0))|0)+(v[i+12>>2]!=(g|0))|0;d=d+4|0;h=h+4|0;if((r|0)!=(h|0)){continue}break}}if(!j){break I}while(1){i=(v[m+(d<<2)>>2]!=(g|0))+i|0;d=d+1|0;s=s+1|0;if((j|0)!=(s|0)){continue}break}}k=k+1|0;if((L|0)!=(k|0)){continue}break}}g=g+1|0;if((n|0)!=(g|0)){continue}break}}d=Ib(v[v[a>>2]+8>>2],i,64,153284,1349);v[f+1276>>2]=d;if(!d){Eb(153318,1349);d=-1;v[f+304>>2]=-1;Fb(276579,f+304|0);break a}d=Bf(f+1272|0,v[v[a>>2]+4>>2],1,1403,1404,1405,a);if((d|0)!=1){break c}K:{d=v[f+1308>>2];if(v[d+12>>2]<=0){break K}x=c&24;k=0;s=0;while(1){c=B(s,48);h=Lc(v[(c+v[d+8>>2]|0)+4>>2]);g=0;i=fc(v[(c+v[v[f+1308>>2]+8>>2]|0)+4>>2]);if((i|0)>0){while(1){d=Se(v[(c+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[h+(g<<2)>>2],0);if((d|0)!=1){Eb(153318,1366);v[f+816>>2]=d;Fb(276579,f+816|0);break a}g=g+1|0;if((i|0)!=(g|0)){continue}break}}L:{n=v[f+1280>>2]+(s<<3)|0;d=v[n>>2];if((d|0)>0){q=0;r=v[f+1284>>2];while(1){o=v[v[n+4>>2]+(q<<2)>>2];L=r+(o<<3)|0;if(v[L>>2]>0){h=0;while(1){j=v[v[L+4>>2]+(h<<2)>>2];if((j|0)!=(s|0)){g=v[f+1276>>2]+(k<<6)|0;v[g+8>>2]=o;v[g+4>>2]=j;v[g>>2]=s;m=v[f+1296>>2]+(o<<2)|0;v[g+24>>2]=af(v[(c+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[v[m>>2]+208>>2]);d=v[(c+v[v[f+1308>>2]+8>>2]|0)+32>>2];v[f+800>>2]=v[v[m>>2]+208>>2];v[f+804>>2]=j;C=f+2336|0;Jb(C,1024,139686,f+800|0);i=d<<2;v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+20>>2]>>2]=0;d=c+v[v[f+1308>>2]+8>>2]|0;d=Nf(v[d+4>>2],i+v[d+20>>2]|0,C,0,A[v[a+4>>2]+1272>>3],1,3);if((d|0)!=1){Eb(153318,1397);v[f+784>>2]=d;Fb(276579,f+784|0);break a}d=c+v[v[f+1308>>2]+8>>2]|0;d=id(v[d+4>>2],v[i+v[d+20>>2]>>2]);if((d|0)!=1){Eb(153318,1398);v[f+768>>2]=d;Fb(276579,f+768|0);break a}v[g+32>>2]=0;v[g+36>>2]=1072693248;v[g+40>>2]=v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+20>>2]>>2];d=v[v[m>>2]+208>>2];v[f+756>>2]=j;v[f+752>>2]=d;d=f+2336|0;Jb(d,1024,139728,f+752|0);v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+24>>2]>>2]=0;C=c+v[v[f+1308>>2]+8>>2]|0;d=Nf(v[C+4>>2],i+v[C+24>>2]|0,d,0,A[v[a+4>>2]+1272>>3],1,3);if((d|0)!=1){Eb(153318,1408);v[f+736>>2]=d;Fb(276579,f+736|0);break a}d=c+v[v[f+1308>>2]+8>>2]|0;d=id(v[d+4>>2],v[i+v[d+24>>2]>>2]);if((d|0)!=1){Eb(153318,1409);v[f+720>>2]=d;Fb(276579,f+720|0);break a}v[g+48>>2]=0;v[g+52>>2]=1072693248;v[g+56>>2]=v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+24>>2]>>2];v[v[f+1292>>2]>>2]=v[g+24>>2];d=v[f+1292>>2];v[d+4>>2]=v[g+40>>2];v[d+8>>2]=v[g+56>>2];d=v[v[m>>2]+208>>2];v[f+708>>2]=j;v[f+704>>2]=d;Jb(f+2336|0,1024,139707,f+704|0);v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+28>>2]>>2]=0;if(W){d=v[g+24>>2];l=A[d+176>>3];l=w[d+377|0]&7?l-A[v[d+236>>2]+184>>3]:l;d=c+v[v[f+1308>>2]+8>>2]|0;l=l>=0?l:0;d=Zg(v[d+4>>2],i+v[d+28>>2]|0,f+2336|0,3,v[f+1292>>2],v[f+1248>>2],l,l);if((d|0)!=1){Eb(153318,1434);v[f+688>>2]=d;Fb(276579,f+688|0);break a}A[g+16>>3]=l}if(x){d=v[m>>2];M:{if((v[d+376>>2]&1792)==512){d=v[d+176>>2];l=0;if(v[d+224>>2]<0){break M}l=A[d+72>>3];break M}l=ae(d)}d=c+v[v[f+1308>>2]+8>>2]|0;l=(v[v[g+24>>2]+376>>2]&192)!=192?I(l+-.5+A[v[a+4>>2]+1280>>3]):l;d=Zg(v[d+4>>2],i+v[d+28>>2]|0,f+2336|0,3,v[f+1292>>2],v[f+1248>>2],l,l);if((d|0)!=1){Eb(153318,1450);v[f+672>>2]=d;Fb(276579,f+672|0);break a}A[g+16>>3]=l}d=c+v[v[f+1308>>2]+8>>2]|0;d=mc(v[d+4>>2],v[i+v[d+28>>2]>>2]);if((d|0)!=1){Eb(153318,1456);v[f+656>>2]=d;Fb(276579,f+656|0);break a}v[g+60>>2]=v[i+v[(c+v[v[f+1308>>2]+8>>2]|0)+28>>2]>>2];d=c+v[v[f+1308>>2]+8>>2]|0;v[d+32>>2]=v[d+32>>2]+1;d=J9(v[f+1272>>2],g);if((d|0)!=1){break L}k=k+1|0}h=h+1|0;if((h|0)<v[L>>2]){continue}break}d=v[n>>2]}q=q+1|0;if((q|0)<(d|0)){continue}break}}s=s+1|0;d=v[f+1308>>2];if((s|0)<v[d+12>>2]){continue}break K}break}Eb(153318,1463);v[f+640>>2]=d;Fb(276579,f+640|0);break a}N:{if((z|0)<=0){G=-17976931348623157e292;break N}i=z&3;h=0;O:{if(z>>>0<4){G=-17976931348623157e292;d=0;break O}j=z&2147483644;d=0;G=-17976931348623157e292;g=0;while(1){c=(d<<2)+Q|0;l=D(A[v[c+12>>2]>>3]);J=D(A[v[c+8>>2]>>3]);P=D(A[v[c+4>>2]>>3]);U=D(A[v[c>>2]>>3]);G=G<U?U:G;G=G<P?P:G;G=G<J?J:G;G=l>G?l:G;d=d+4|0;g=g+4|0;if((j|0)!=(g|0)){continue}break}}if(!i){break N}while(1){l=D(A[v[(d<<2)+Q>>2]>>3]);G=l>G?l:G;d=d+1|0;h=h+1|0;if((i|0)!=(h|0)){continue}break}}d=mia(a,f+1232|0);if((d|0)!=1){Eb(153318,1493);v[f+624>>2]=d;Fb(276579,f+624|0);break a}if(A[f+1232>>3]<=0){break d}i=0;Jb(f+1312|0,1024,211952,0);P:{if(v[E+20>>2]<=0){break P}while(1){L=1;j=i+1|0;d=v[f+1308>>2];q=0;while(1){Q:{C=(L|0)!=0&v[E+16>>2]>(q|0);if(!C){break Q}L=1;q=q+1|0;if(v[d+12>>2]<=0){break Q}s=0;M=v[f+1280>>2];h=0;R:{S:while(1){x=M+(h<<3)|0;c=v[x>>2];if((c|0)>0){k=0;K=v[f+1284>>2];g=B(h,48);while(1){o=v[v[x+4>>2]+(k<<2)>>2];r=K+(o<<3)|0;if(v[r>>2]>0){c=0;while(1){T:{d=v[v[r+4>>2]+(c<<2)>>2];if((d|0)==(h|0)){break T}v[f+1152>>2]=o;v[f+1148>>2]=d;v[f+1144>>2]=h;m=sc(v[f+1272>>2],f+1144|0);u=v[m+60>>2];v[f+1088>>2]=o;v[f+1084>>2]=h;v[f+1080>>2]=d;l=A[sc(v[f+1272>>2],f+1080|0)+16>>3];d=Ph(v[(g+v[v[f+1308>>2]+8>>2]|0)+4>>2],u,l);n=1563;U:{if((d|0)!=1){break U}d=Oh(v[(g+v[v[f+1308>>2]+8>>2]|0)+4>>2],u,l);n=1564;if((d|0)!=1){break U}d=Se(v[(g+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[m+40>>2],A[m+32>>3]);n=1567;if((d|0)!=1){break U}d=Se(v[(g+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[m+56>>2],A[m+48>>3]);if((d|0)==1){break T}n=1568}Eb(153318,n);v[f+608>>2]=d;Fb(276579,f+608|0);break a}c=c+1|0;if((c|0)<v[r>>2]){continue}break}c=v[x>>2]}k=k+1|0;if((k|0)<(c|0)){continue}break}d=v[f+1308>>2]}o=B(h,48);d=Xe(v[(v[d+8>>2]+o|0)+4>>2],73451,N);if((d|0)==1){while(1){c=ub-224|0;ub=c;V:{W:{m=o+v[v[f+1308>>2]+8>>2]|0;d=v[m+4>>2];g=Pd(d);if(g){k=Ib(v[v[d>>2]+8>>2],3,4,153284,637);v[c+216>>2]=k;if(!k){Eb(153318,637);g=-1;v[c>>2]=-1;Fb(276579,c);break V}u=v[(Wh(d)+(g<<2)|0)-4>>2];n=fc(d);K=Lc(d);r=Ib(v[v[d>>2]+8>>2],n,8,153284,645);v[c+212>>2]=r;if(!r){Eb(153318,645);g=-1;v[c+16>>2]=-1;Fb(276579,c+16|0);break V}g=Vg(d,u,n,K,r);if((g|0)!=1){Eb(153318,646);v[c+192>>2]=g;Fb(276579,c+192|0);break V}g=dp(d,c+220|0,0);if((g|0)!=1){Eb(153318,647);v[c+176>>2]=g;Fb(276579,c+176|0);break V}g=ho(d,v[c+220>>2],n,K,r);if((g|0)!=1){break W}if(v[m+32>>2]>0){r=0;while(1){n=r<<2;g=Bl(d,v[n+v[m+28>>2]>>2],k,3,c+208|0);if((g|0)!=1){Eb(153318,659);v[c+144>>2]=g;Fb(276579,c+144|0);break V}l=Ob(d,u,v[k>>2]);X:{l=ge(v[n+v[m+28>>2]>>2])-l;if(l>0){g=Wc(d,v[c+220>>2],v[n+v[m+20>>2]>>2],l);if((g|0)!=1){Eb(153318,670);v[c+64>>2]=g;Fb(276579,c- -64|0);break V}g=Wc(d,v[c+220>>2],v[n+v[m+24>>2]>>2],0);if((g|0)==1){break X}Eb(153318,671);v[c+48>>2]=g;Fb(276579,c+48|0);break V}g=v[c+220>>2];if(l<0){g=Wc(d,g,v[n+v[m+24>>2]>>2],-l);if((g|0)!=1){Eb(153318,676);v[c+96>>2]=g;Fb(276579,c+96|0);break V}g=Wc(d,v[c+220>>2],v[n+v[m+20>>2]>>2],0);if((g|0)==1){break X}Eb(153318,677);v[c+80>>2]=g;Fb(276579,c+80|0);break V}g=Wc(d,g,v[n+v[m+20>>2]>>2],0);if((g|0)!=1){Eb(153318,682);v[c+128>>2]=g;Fb(276579,c+128|0);break V}g=Wc(d,v[c+220>>2],v[n+v[m+24>>2]>>2],0);if((g|0)==1){break X}Eb(153318,683);v[c+112>>2]=g;Fb(276579,c+112|0);break V}r=r+1|0;if((r|0)<v[m+32>>2]){continue}break}}g=cp(d,c+220|0,c+208|0);if((g|0)!=1){Eb(153318,688);v[c+32>>2]=g;Fb(276579,c+32|0);break V}Hb(v[v[d>>2]+8>>2],c+212|0,153284,697);Hb(v[v[d>>2]+8>>2],c+216|0,153284,698)}g=1;break V}Eb(153318,648);v[c+160>>2]=g;Fb(276579,c+160|0)}ub=c+224|0;d=g;if((d|0)!=1){Eb(153318,1588);v[f+592>>2]=d;Fb(276579,f+592|0);break a}d=Xh(a,v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2]);if((d|0)!=1){Eb(153318,1591);v[f+576>>2]=d;Fb(276579,f+576|0);break a}c=v[E+8>>2];g=v[E+12>>2];d=g;if(c>>>0>O>>>0&(d|0)>=(T|0)|(d|0)>(T|0)){break d}n=o+v[v[f+1308>>2]+8>>2]|0;l=I(A[n+40>>3]*(+(O>>>0)+ +(T|0)*4294967296)*(1-Zd(A[E+32>>3],+(B(v[E+16>>2],i)+q|0)))-A[v[a+4>>2]+1280>>3]);Y:{if(D(l)<0x8000000000000000){m=~~l>>>0;if(D(l)>=1){d=~~(l>0?F(H(l*2.3283064365386963e-10),4294967295):I((l-+(~~l>>>0>>>0))*2.3283064365386963e-10))>>>0}else{d=0}break Y}m=0;d=-2147483648}k=c;c=(d|0)<=(g|0)&c>>>0>m>>>0|(d|0)<(g|0);d=_d(v[n+4>>2],56040,c?k:m,c?g:d);if((d|0)!=1){Eb(153318,1606);v[f+560>>2]=d;Fb(276579,f+560|0);break a}c=Me(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2]);if((c|0)!=1){Eb(153318,1613);v[f+544>>2]=c;Fb(276579,f+544|0)}c=0;d=v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2];g=v[v[d+4>>2]>>2];if(!(!g|(g|0)==13)){c=v[v[d+24>>2]+896>>2]}k=o+v[v[f+1308>>2]+8>>2]|0;d=v[v[k+4>>2]+24>>2];l=I((+y[d+168>>2]+ +v[d+172>>2]*4294967296)*A[k+40>>3]-A[v[a+4>>2]+1280>>3]);Z:{if(D(l)<0x8000000000000000){d=~~l>>>0;if(D(l)>=1){g=~~(l>0?F(H(l*2.3283064365386963e-10),4294967295):I((l-+(~~l>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break Z}d=0;g=-2147483648}m=d;n=g;_:{$:{aa:{ba:{ca:{da:{u=c-2|0;switch(u|0){case 5:case 9:break $;case 0:break ba;case 3:break ca;case 11:break da;default:break d}}if(v[x>>2]<=0){break _}k=0;K=v[f+1284>>2];while(1){R=v[v[x+4>>2]+(k<<2)>>2];r=K+(R<<3)|0;if(v[r>>2]>0){g=0;while(1){ea:{c=v[v[r+4>>2]+(g<<2)>>2];if((c|0)==(h|0)){break ea}v[f+1152>>2]=R;v[f+1148>>2]=c;v[f+1144>>2]=h;c=sc(v[f+1272>>2],f+1144|0);l=A[c+32>>3]*10;A[c+32>>3]=l;A[c+48>>3]=A[c+48>>3]*10;d=Se(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[c+40>>2],l);if((d|0)!=1){a=1702}else{d=Se(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2],v[c+56>>2],A[c+48>>3]);if((d|0)==1){break ea}a=1703}Eb(153318,a);v[f+528>>2]=d;Fb(276579,f+528|0);break a}g=g+1|0;if((g|0)<v[r>>2]){continue}break}}k=k+1|0;if((k|0)<v[x>>2]){continue}break}break _}if((Pd(v[k+4>>2])|0)<=0){break d}d=v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2];if(!(D($f(d,Yc(d)))<=A[v[a+4>>2]+1280>>3])){break d}break aa}if((Pd(v[k+4>>2])|0)<=0){break d}}L=(c|0)!=5?L:0}if(v[x>>2]<=0){break _}k=0;r=v[f+1284>>2];while(1){K=v[v[x+4>>2]+(k<<2)>>2];g=r+(K<<3)|0;if(v[g>>2]>0){d=0;while(1){c=v[v[g+4>>2]+(d<<2)>>2];if((c|0)!=(h|0)){v[f+1152>>2]=K;v[f+1148>>2]=c;v[f+1144>>2]=h;c=sc(v[f+1272>>2],f+1144|0);R=Yc(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2]);l=Ob(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2],R,v[c+24>>2]);J=A[c+16>>3];A[c+16>>3]=l;s=D(J-l)<=1e-9?s:1}d=d+1|0;if((d|0)<v[g>>2]){continue}break}}k=k+1|0;if((k|0)<v[x>>2]){continue}break}}d=ak(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2]);if((d|0)!=1){Eb(153318,1720);v[f+512>>2]=d;Fb(276579,f+512|0);break a}c=O;O=c-m|0;T=T-(n+(c>>>0<m>>>0)|0)|0;fa:{ga:{ha:{switch(u|0){case 3:if((Pd(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2])|0)<=0){break fa}c=v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2];if(D($f(c,Yc(c)))<=A[v[a+4>>2]+1280>>3]){break ga}break fa;case 5:case 9:break ga;case 0:break ha;default:break fa}}if((Pd(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2])|0)<=0){break fa}}h=h+1|0;d=v[f+1308>>2];if((h|0)>=v[d+12>>2]){break R}continue S}d=Xe(v[(o+v[v[f+1308>>2]+8>>2]|0)+4>>2],73451,N);if((d|0)==1){continue}break}}break}Eb(153318,1585);v[f+320>>2]=d;Fb(276579,f+320|0);break a}if(s){continue}}break}k=1;ia:{ja:{ka:{la:{ma:{if(v[d+12>>2]<=0){break ma}s=0;l=-17976931348623157e292;x=v[f+1280>>2];h=0;while(1){g=x+(h<<3)|0;if(v[g>>2]>0){i=0;r=v[f+1284>>2];while(1){u=v[v[g+4>>2]+(i<<2)>>2];m=r+(u<<3)|0;if(v[m>>2]>0){d=0;while(1){c=v[v[m+4>>2]+(d<<2)>>2];na:{if((c|0)==(h|0)){break na}v[f+1152>>2]=u;v[f+1148>>2]=c;v[f+1144>>2]=h;c=sc(v[f+1272>>2],f+1144|0);n=B(h,48);o=Yc(v[(n+v[v[f+1308>>2]+8>>2]|0)+4>>2]);J=Ob(v[(n+v[v[f+1308>>2]+8>>2]|0)+4>>2],o,v[c+40>>2]);P=Ob(v[(n+v[v[f+1308>>2]+8>>2]|0)+4>>2],o,v[c+56>>2]);U=A[v[a+4>>2]+1280>>3];if(U<J){J=A[c+32>>3]*10;A[c+32>>3]=J;s=G<J?1:s;k=0;l=l<J?J:l}if(!(P>U)){break na}J=A[c+48>>3]*10;A[c+48>>3]=J;l=l<J?J:l;s=G<J?1:s;k=0}d=d+1|0;if((d|0)<v[m>>2]){continue}break}}i=i+1|0;if((i|0)<v[g>>2]){continue}break}d=v[f+1308>>2]}h=h+1|0;c=v[d+12>>2];if((h|0)<(c|0)){continue}break}if(!s){break ma}if(v[E+52>>2]){o=v[f+1284>>2];x=v[f+1280>>2];r=v[f+1272>>2];g=0;i=ub+-64|0;ub=i;h=c;if((c|0)>0){J=l/10;l=l*.5;while(1){m=x+(g<<3)|0;c=v[m>>2];if((c|0)>0){s=0;while(1){u=v[v[m+4>>2]+(s<<2)>>2];n=o+(u<<3)|0;h=v[n>>2];if((h|0)>0){c=0;while(1){K=v[v[n+4>>2]+(c<<2)>>2];if((K|0)!=(g|0)){v[i+8>>2]=u;v[i+4>>2]=K;v[i>>2]=g;h=sc(r,i);P=A[h+32>>3]-l;A[h+32>>3]=P/(J+D(P))*10*.5+5.1;P=A[h+48>>3]-l;A[h+48>>3]=P/(J+D(P))*10*.5+5.1;h=v[n>>2]}c=c+1|0;if((h|0)>(c|0)){continue}break}c=v[m>>2]}s=s+1|0;if((s|0)<(c|0)){continue}break}h=v[d+12>>2]}g=g+1|0;if((h|0)>(g|0)){continue}break}}ub=i- -64|0}if(C&(q|0)==1){break la}if(!v[E+52>>2]){break ia}l=N*.5;N=l>=.001?l:.001;break ka}if(!C|(q|0)!=1){break ia}l=N*.5;N=l>=.001?l:.001;break ja}l=N*.5;N=l>=.001?l:.001;if(!v[E+52>>2]){break ja}}A[f+496>>3]=N;Jb(f+1312|0,1024,107764,f+496|0);break ia}A[f+480>>3]=N;Jb(f+1312|0,1024,107771,f+480|0)}oa:{if(!k){c=0;d=v[f+1308>>2];if(v[d+12>>2]<=0){break oa}while(1){d=ak(v[(v[d+8>>2]+B(c,48)|0)+4>>2]);if((d|0)==1){c=c+1|0;d=v[f+1308>>2];if((c|0)<v[d+12>>2]){continue}break oa}break}Eb(153318,1831);v[f+336>>2]=d;Fb(276579,f+336|0);break a}c=Ib(v[v[a>>2]+8>>2],z,8,153284,1843);v[f+1080>>2]=c;if(!c){Eb(153318,1843);d=-1;v[f+352>>2]=-1;Fb(276579,f+352|0);break a}pa:{d=Ed(a,f+1144|0,b);if((d|0)==1){i=0;qa:{ra:{d=v[f+1308>>2];if(v[d+12>>2]>0){while(1){c=B(i,48);g=Yc(v[(c+v[d+8>>2]|0)+4>>2]);d=c+v[v[f+1308>>2]+8>>2]|0;c=v[d+16>>2];j=g;g=v[d+12>>2];d=Vg(v[d+4>>2],j,c,g,v[f+1080>>2]);if((d|0)!=1){break ra}d=0;if((c|0)>0){while(1){h=af(a,v[v[g+(d<<2)>>2]+208>>2]);h=Wc(a,v[f+1144>>2],h,A[v[f+1080>>2]+(d<<3)>>3]);if((h|0)!=1){Eb(153318,1866);v[f+432>>2]=h;Fb(276579,f+432|0)}d=d+1|0;if((c|0)!=(d|0)){continue}break}}i=i+1|0;d=v[f+1308>>2];if((i|0)<v[d+12>>2]){continue}break}}sa:{if((t|0)<=0){break sa}d=0;g=v[f+1252>>2];while(1){c=d<<2;ta:{if(!v[c+g>>2]){break ta}N=A[v[a+4>>2]+1272>>3];c=v[c+v[f+1296>>2]>>2];ua:{if(A[c>>3]<0){l=A[c+160>>3];if(!(N<=l)){break ua}break sa}l=A[c+152>>3];if(N<=l){break sa}}c=Wc(a,v[f+1144>>2],c,l);if((c|0)==1){break ta}Eb(153318,1888);v[f+416>>2]=c;Fb(276579,f+416|0)}d=d+1|0;if((t|0)!=(d|0)){continue}break}}va:{if(!v[E+48>>2]){break va}v[f+1076>>2]=0;c=1898;O=v[f+1144>>2];j=v[f+1296>>2];k=f+1076|0;i=f+1228|0;d=ub-528|0;ub=d;h=Ib(v[v[a>>2]+8>>2],t,8,153284,737);v[d+508>>2]=h;wa:{if(!h){Eb(153318,737);g=-1;v[d>>2]=-1;Fb(276579,d);break wa}m=Ib(v[v[a>>2]+8>>2],z,4,153284,738);v[d+512>>2]=m;if(!m){Eb(153318,738);g=-1;v[d+16>>2]=-1;Fb(276579,d+16|0);break wa}g=Vg(a,O,t,j,h);if((g|0)!=1){Eb(153318,740);v[d+480>>2]=g;Fb(276579,d+480|0);break wa}g=Gf(d+524|0);if((g|0)!=1){Eb(153318,743);v[d+464>>2]=g;Fb(276579,d+464|0);break wa}g=v[v[v[d+524>>2]>>2]+4>>2];xa:{if(v[v[b+60>>2]+60>>2]){g=Ic(d+516|0,g,v[v[a+28>>2]+92>>2]);if((g|0)!=1){Eb(153318,750);v[d+448>>2]=g;Fb(276579,d+448|0);break wa}n=ub-16|0;ub=n;q=3168;ya:{za:{s=v[d+524>>2];g=SF(a,s,v[d+516>>2],89073,j,h,t,1,1,1,0,1,i);if((g|0)!=1){break za}q=3170;g=cN(s+112|0);if((g|0)!=1){break za}g=v[a+112>>2];v[s+112>>2]=g;v[g>>2]=v[g>>2]+1;g=1;break ya}Eb(144515,q);v[n>>2]=g;Fb(276579,n)}ub=n+16|0;if((g|0)==1){break xa}Eb(153318,752);v[d+432>>2]=g;Fb(276579,d+432|0);break wa}g=Ic(d+516|0,g,fc(a));if((g|0)!=1){Eb(153318,756);v[d+416>>2]=g;Fb(276579,d+416|0);break wa}g=kp(a,v[d+524>>2],v[d+516>>2],89073,j,h,t,1,i);if((g|0)==1){break xa}Eb(153318,758);v[d+400>>2]=g;Fb(276579,d+400|0);break wa}if((z|0)>0){g=0;while(1){h=g<<2;v[h+m>>2]=Ac(v[d+516>>2],v[h+Q>>2]);g=g+1|0;if((z|0)!=(g|0)){continue}break}}g=Rc(v[d+524>>2],140470,0);if((g|0)!=1){Eb(153318,766);v[d+384>>2]=g;Fb(276579,d+384|0);break wa}g=Bh(v[d+524>>2]);if((g|0)!=1){Eb(153318,769);v[d+368>>2]=g;Fb(276579,d+368|0);break wa}g=qc(v[d+524>>2],92013,0);if((g|0)!=1){Eb(153318,777);v[d+352>>2]=g;Fb(276579,d+352|0);break wa}g=Rc(v[d+524>>2],103062,0);if((g|0)!=1){Eb(153318,778);v[d+336>>2]=g;Fb(276579,d+336|0);break wa}g=Wg(v[d+524>>2],3,1);if((g|0)!=1){Eb(153318,782);v[d+320>>2]=g;Fb(276579,d+320|0);break wa}g=Uf(v[d+524>>2],2,1);if((g|0)!=1){Eb(153318,785);v[d+304>>2]=g;Fb(276579,d+304|0);break wa}g=qc(v[d+524>>2],58344,1);if((g|0)!=1){Eb(153318,786);v[d+288>>2]=g;Fb(276579,d+288|0);break wa}g=_d(v[d+524>>2],19171,0,0);if((g|0)!=1){Eb(153318,787);v[d+272>>2]=g;Fb(276579,d+272|0);break wa}g=qc(v[d+524>>2],3458,0);if((g|0)!=1){Eb(153318,790);v[d+256>>2]=g;Fb(276579,d+256|0);break wa}g=Rc(v[d+524>>2],61690,0);if((g|0)!=1){Eb(153318,793);v[d+240>>2]=g;Fb(276579,d+240|0);break wa}g=Ui(v[d+524>>2]);if((g|0)!=1){Eb(153318,796);v[d+224>>2]=g;Fb(276579,d+224|0);break wa}v[i>>2]=0;Aa:{Ba:{l=$f(a,O);g=v[a+4>>2];if(!(l-A[g+1272>>3]<-A[g+1280>>3])){break Ba}g=Ed(v[d+524>>2],d+520|0,b);if((g|0)!=1){break Aa}h=0;if((z|0)>0){while(1){Ca:{g=(h<<2)+Q|0;j=Ac(v[d+516>>2],v[g>>2]);if(!j){break Ca}g=Wc(v[d+524>>2],v[d+520>>2],j,Ob(a,O,v[g>>2]));if((g|0)==1){break Ca}Eb(153318,807);v[d+192>>2]=g;Fb(276579,d+192|0);break wa}h=h+1|0;if((z|0)!=(h|0)){continue}break}}g=Tg(v[d+524>>2],d+520|0,0,0,0,0,0,i);if((g|0)==1){break Ba}Eb(153318,811);v[d+176>>2]=g;Fb(276579,d+176|0);break wa}g=Xh(a,v[d+524>>2]);if((g|0)!=1){Eb(153318,819);v[d+160>>2]=g;Fb(276579,d+160|0);break wa}g=_d(v[d+524>>2],56040,1,0);if((g|0)!=1){Eb(153318,820);v[d+144>>2]=g;Fb(276579,d+144|0);break wa}g=re(v[d+524>>2],117257,d+496|0);if((g|0)!=1){Eb(153318,821);v[d+128>>2]=g;Fb(276579,d+128|0);break wa}Da:{if(!(XG(b)<A[d+496>>3]+-1)){break Da}g=Xe(v[d+524>>2],117257,XG(b)+1);if((g|0)==1){break Da}Eb(153318,824);v[d+112>>2]=g;Fb(276579,d+112|0);break wa}g=v[d+524>>2];Ea:{if(v[i>>2]){g=qc(g,89901,2);if((g|0)==1){break Ea}Eb(153318,828);v[d+96>>2]=g;Fb(276579,d+96|0);break wa}g=qc(g,89901,1);if((g|0)==1){break Ea}Eb(153318,832);v[d+80>>2]=g;Fb(276579,d+80|0);break wa}g=Me(v[d+524>>2]);if((g|0)!=1){Eb(153318,836);v[d+64>>2]=g;Fb(276579,d- -64|0)}h=0;g=0;Fa:{O=v[d+524>>2];j=v[v[O+4>>2]>>2];if(!(!j|(j|0)==13)){g=v[v[O+24>>2]+896>>2]}if((g&-3)!=9){break Fa}h=1;g=Yc(v[d+524>>2]);g=qq(a,v[d+524>>2],g,b,m,k);if((g|0)==1){break Fa}Eb(153318,845);v[d+48>>2]=g;Fb(276579,d+48|0);break wa}v[i>>2]=h;Bc(d+516|0);g=ne(d+524|0);if((g|0)!=1){Eb(153318,857);v[d+32>>2]=g;Fb(276579,d+32|0);break wa}Hb(v[v[a>>2]+8>>2],d+512|0,153284,858);Hb(v[v[a>>2]+8>>2],d+508|0,153284,859);g=1;break wa}Eb(153318,800);v[d+208>>2]=g;Fb(276579,d+208|0)}ub=d+528|0;d=g;if((d|0)!=1){break qa}if(!v[f+1228>>2]){break va}c=1903;d=Tg(a,k,0,0,1,1,1,i);if((d|0)!=1){break qa}if(!v[f+1228>>2]){break va}v[e>>2]=15}if(v[e>>2]!=15){d=Tg(a,f+1144|0,0,0,1,1,1,f+1228|0);if((d|0)!=1){Eb(153318,1919);v[f+384>>2]=d;Fb(276579,f+384|0);break a}if(!v[f+1228>>2]){break pa}v[e>>2]=15;break pa}d=Zc(a,f+1144|0);if((d|0)==1){break pa}Eb(153318,1932);v[f+368>>2]=d;Fb(276579,f+368|0);break a}Eb(153318,1857);v[f+448>>2]=d;Fb(276579,f+448|0);break a}Eb(153318,c);v[f+400>>2]=d;Fb(276579,f+400|0);break a}Eb(153318,1844);v[f+464>>2]=d;Fb(276579,f+464|0);break a}Hb(v[v[a>>2]+8>>2],f+1080|0,153284,1935);break d}if((j|0)>=v[E+20>>2]){break P}i=j;if(L){continue}break}}v[e>>2]=3}d=v[f+1308>>2];if(!(!d|v[d+12>>2]<=0)){z=0;while(1){c=0;Ga:{g=B(z,48);b=g+v[d+8>>2]|0;if(v[b+32>>2]<=0){break Ga}h=v[b+28>>2];i=v[b+24>>2];O=v[b+20>>2];b=v[b+4>>2];while(1){e=c<<2;d=ec(b,e+h|0);if((d|0)!=1){Eb(153318,1952);v[f+48>>2]=d;Fb(276579,f+48|0);break a}d=Dc(b,e+O|0);if((d|0)!=1){Eb(153318,1953);v[f+32>>2]=d;Fb(276579,f+32|0);break a}d=Dc(b,e+i|0);if((d|0)==1){c=c+1|0;d=v[f+1308>>2];if((c|0)>=v[(g+v[d+8>>2]|0)+32>>2]){break Ga}continue}break}Eb(153318,1954);v[f+16>>2]=d;Fb(276579,f+16|0);break a}z=z+1|0;if((z|0)<v[d+12>>2]){continue}break}}if(v[f+1272>>2]){cf(f+1272|0)}if(v[f+1276>>2]){Hb(v[v[a>>2]+8>>2],f+1276|0,153284,1963)}if(v[f+1248>>2]){Hb(v[v[a>>2]+8>>2],f+1248|0,153284,1966)}if(v[f+1292>>2]){Hb(v[v[a>>2]+8>>2],f+1292|0,153284,1969)}b=v[f+1308>>2];Ha:{if(!b){break Ha}d=v[b+12>>2];if((d|0)<=0){break Ha}while(1){b=d-1|0;c=B(b,48);e=v[v[f+1308>>2]+8>>2];if(v[(c+e|0)+28>>2]){Hb(v[v[a>>2]+8>>2],(c+e|0)+28|0,153284,1977);Hb(v[v[a>>2]+8>>2],(c+v[v[f+1308>>2]+8>>2]|0)+24|0,153284,1978);Hb(v[v[a>>2]+8>>2],(c+v[v[f+1308>>2]+8>>2]|0)+20|0,153284,1979)}c=d>>>0>1;d=b;if(c){continue}break}}if(v[f+1252>>2]){Hb(v[v[a>>2]+8>>2],f+1252|0,153284,1985)}b=v[f+1308>>2];c=v[f+1280>>2];Ia:{if(!b|!c){break Ia}d=v[b+12>>2];if((d|0)<=0){break Ia}while(1){b=d-1|0;e=c+(b<<3)|0;if(v[e+4>>2]){Hb(v[v[a>>2]+8>>2],e+4|0,153284,1992)}e=d>>>0>1;d=b;if(e){continue}break}}if(v[f+1296>>2]){Hb(v[v[a>>2]+8>>2],f+1296|0,153284,1997)}if(v[f+1256>>2]){Hb(v[v[a>>2]+8>>2],f+1256|0,153284,2e3)}if(c){Hb(v[v[a>>2]+8>>2],f+1280|0,153284,2003)}if(v[f+1284>>2]){Hb(v[v[a>>2]+8>>2],f+1284|0,153284,2006)}if(v[f+1300>>2]){VB(f+1300|0,v[v[a>>2]+4>>2])}if(v[f+1260>>2]){Hb(v[v[a>>2]+8>>2],f+1260|0,153284,2012)}if(v[f+1264>>2]){Hb(v[v[a>>2]+8>>2],f+1264|0,153284,2015)}if(v[f+1268>>2]){Hb(v[v[a>>2]+8>>2],f+1268|0,153284,2018)}if(v[f+1288>>2]){Hb(v[v[a>>2]+8>>2],f+1288|0,153284,2021)}if(!v[f+1308>>2]){d=1;break a}d=1;a=lia(f+1308|0,p);if((a|0)==1){break a}Eb(153318,2025);v[f>>2]=a;Fb(276579,f);d=a;break a}Eb(153318,1350);v[f+832>>2]=d;Fb(276579,f+832|0)}ub=f+3360|0;return d|0}function qUa(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,x=0,y=0,z=0,B=0,C=0,E=0;m=ub-288|0;ub=m;v[m+172>>2]=0;e=Tb(v[v[a>>2]+4>>2],65536,1,152128,4784);v[m+188>>2]=e;a:{if(!e){Eb(152162,4784);e=-1;v[m>>2]=-1;Fb(276579,m);break a}t[e|0]=0;v[m+212>>2]=65536;e=Ib(v[v[a>>2]+8>>2],65536,1,152128,4787);v[m+192>>2]=e;if(!e){Eb(152162,4787);e=-1;v[m+16>>2]=-1;Fb(276579,m+16|0);break a}t[e|0]=0;e=Ib(v[v[a>>2]+8>>2],65536,1,152128,4792);v[m+196>>2]=e;if(!e){Eb(152162,4792);e=-1;v[m+32>>2]=-1;Fb(276579,m+32|0);break a}v[m+272>>2]=0;v[m+276>>2]=0;v[m+280>>2]=0;v[m+284>>2]=0;v[m+216>>2]=0;v[m+200>>2]=0;v[m+204>>2]=1;v[m+264>>2]=0;v[m+268>>2]=0;v[m+244>>2]=1;v[m+236>>2]=0;v[m+240>>2]=0;v[m+228>>2]=1;v[m+208>>2]=0;e=Bd(a,33100,m+248|0);if((e|0)!=1){Eb(152162,4810);v[m+160>>2]=e;Fb(276579,m+160|0);break a}e=Bd(a,33287,m+252|0);if((e|0)!=1){Eb(152162,4811);v[m+144>>2]=e;Fb(276579,m+144|0);break a}e=Bd(a,44070,m+256|0);if((e|0)!=1){Eb(152162,4812);v[m+128>>2]=e;Fb(276579,m+128|0);break a}e=Bd(a,24772,m+260|0);if((e|0)!=1){Eb(152162,4813);v[m+112>>2]=e;Fb(276579,m+112|0);break a}B=m+176|0;e=Bf(B,v[v[a>>2]+4>>2],500,1823,1824,1825,0);if((e|0)!=1){Eb(152162,4816);v[m+96>>2]=e;Fb(276579,m+96|0);break a}C=m+180|0;e=Bf(C,v[v[a>>2]+4>>2],500,1826,1824,1825,0);if((e|0)!=1){Eb(152162,4819);v[m+80>>2]=e;Fb(276579,m+80|0);break a}e=Ib(v[v[a>>2]+8>>2],10,4,152128,4820);v[m+184>>2]=e;if(!e){Eb(152162,4820);e=-1;v[m+48>>2]=-1;Fb(276579,m+48|0);break a}v[m+220>>2]=0;v[m+224>>2]=10;h=a;x=v[b+28>>2];i=ub-131744|0;ub=i;f=m+172|0;a=Kf(c,69756);v[f>>2]=a;b:{if(!a){Eb(152162,3712);v[i>>2]=c;Fb(279368,i);$h(c);a=-4;break b}a=tk(h,c,0,0,0,0,0,0,0);if((a|0)!=1){Eb(152162,3718);v[i+592>>2]=a;Fb(276579,i+592|0);break b}a=AB(h,f,0,110837,1,1,0);if((a|0)!=1){Eb(152162,3721);v[i+576>>2]=a;Fb(276579,i+576|0);break b}a=AB(h,f,0,114168,0,0,0);if((a|0)==1){a=v[f>>2];c:{if(v[a+76>>2]<0){a=v[a>>2];break c}a=v[a>>2]}d:{if(a>>>4&1){break d}E=f+24|0;while(1){if(v[f+68>>2]|!v[f+72>>2]){break d}e:{if(!Pe(h,f)){break e}f:{g:{h:{i:{j:{k:{l:{m:{n:{a=v[f+20>>2];b=Pb(a);switch(b-3|0){case 0:break k;case 7:break l;case 2:break m;case 6:break n;default:break j}}if(Nc(a,114007,9)){break j}v[f+64>>2]=1;break f}if(Nc(a,5403,b)){break j}v[i+620>>2]=0;a=84091;o:{p:{if(!Pe(h,f)){break p}b=v[f+20>>2];if((Pb(b)|0)!=1|w[b|0]!=91){break p}XH(h,f,i+131740|0,i+624|0,i+131712|0);if(v[f+68>>2]){break f}a=22818;if(v[i+131740>>2]!=1|A[i+624>>3]!=1){break p}n=A[i+131712>>3];if(n<=0){break p}if(D(n)<2147483648){b=~~n}else{b=-2147483648}a=84052;if(!Pe(h,f)){break p}e=v[f+20>>2];if((Pb(e)|0)!=1){break p}if(w[e|0]==93){break o}}Eb(152162,668);b=v[f+32>>2];v[i+280>>2]=v[f+20>>2];v[i+276>>2]=a;v[i+272>>2]=b;Fb(310967,i+272|0);Eb(152162,669);v[i+256>>2]=v[f+16>>2];Fb(269340,i+256|0);v[f+68>>2]=1;break f}if(v[f+68>>2]|!v[f+72>>2]){break f}q:{r:{if(!Pe(h,f)){break r}a=v[f+20>>2];if((Pb(a)|0)!=2){break r}if(!Nc(a,106312,2)){break q}}Eb(152162,668);a=v[f+32>>2];v[i+312>>2]=v[f+20>>2];v[i+308>>2]=200344;v[i+304>>2]=a;Fb(310967,i+304|0);Eb(152162,669);v[i+288>>2]=v[f+16>>2];Fb(269340,i+288|0);v[f+68>>2]=1;break f}if(!Pe(h,f)){Eb(152162,668);a=v[f+32>>2];v[i+344>>2]=v[f+20>>2];v[i+340>>2]=42725;v[i+336>>2]=a;Fb(310967,i+336|0);Eb(152162,669);v[i+320>>2]=v[f+16>>2];Fb(269340,i+320|0);v[f+68>>2]=1;break f}s:{t:{a=v[f+20>>2];if((Pb(a)|0)!=3){break t}if(Nc(a,69177,3)){break t}a=0;break s}a=(v[f+28>>2]<<2)+E|0;e=v[a>>2];v[a>>2]=v[f+20>>2];v[f+20>>2]=e;v[f+28>>2]=v[f+28>>2]+1;a=1}wfa(h,f,i+131708|0,i+608|0,i+600|0);if(v[f+68>>2]|!v[f+72>>2]){break f}e=a;a=PS(h,f,i+66160|0,i+596|0,i+620|0);if((a|0)!=1){b=2176;break g}if(v[f+68>>2]|!v[f+72>>2]){break f}a=v[i+131708>>2];u:{if(!e){g=i+66160|0;e=a;n=A[i+608>>3];y=A[i+600>>3];o=v[i+620>>2];a=0;k=ub-65696|0;ub=k;p=Ib(v[v[h>>2]+8>>2],b,4,152128,2017);v[k+65688>>2]=p;v:{w:{x:{y:{if(p){l=(b|0)>0?b:0;z:{while(1){if((a|0)==(l|0)){break z}v[k+128>>2]=g;j=a+1|0;v[k+132>>2]=j;r=k+144|0;Jb(r,65536,163223,k+128|0);u=a<<2;a=j;j=AB(h,f,p+u|0,r,n,y,e);if((j|0)==1){continue}break}Eb(152162,2024);v[k+112>>2]=j;Fb(276579,k+112|0);break v}if(!Pe(h,f)){Eb(152162,668);a=v[f+32>>2];v[k+40>>2]=v[f+20>>2];v[k+36>>2]=74897;v[k+32>>2]=a;Fb(310967,k+32|0);Eb(152162,669);v[k+16>>2]=v[f+16>>2];Fb(269340,k+16|0);v[f+68>>2]=1;break w}a=v[f+20>>2];if(!((Pb(a)|0)!=1|w[a|0]!=61)){a=2038;j=Ib(v[v[h>>2]+8>>2],b,4,152128,2038);v[k+140>>2]=j;A:{if(!j){j=-1;break A}v[k+136>>2]=0;a=2041;j=VH(h,f,k+140|0,k+136|0,b);if((j|0)!=1){break A}if(v[f+68>>2]){l=v[k+140>>2];break y}l=v[k+140>>2];if(!v[f+72>>2]|(b|0)<=0){break y}a=0;while(1){if(v[f+68>>2]|!v[f+72>>2]){break y}j=a<<2;j=sfa(h,f,v[j+p>>2],e,v[j+l>>2]);if((j|0)==1){a=a+1|0;if((b|0)==(a|0)){break y}continue}break}a=2048}Eb(152162,a);v[k+48>>2]=j;Fb(276579,k+48|0);break v}a=(v[f+28>>2]<<2)+f|0;j=v[a+24>>2];v[a+24>>2]=v[f+20>>2];v[f+20>>2]=j;v[f+28>>2]=v[f+28>>2]+1;break x}Eb(152162,2017);j=-1;v[k>>2]=-1;Fb(276579,k);break v}a=v[k+136>>2];v[k+65692>>2]=l;if((a|0)>0){while(1){j=a-1|0;Hb(v[v[h>>2]+8>>2],(j<<2)+l|0,152128,272);p=a>>>0>1;a=j;if(p){continue}break}}Hb(v[v[h>>2]+8>>2],k+65692|0,152128,274)}a=v[k+65688>>2];B:{if(!o){j=rfa(h,f,g,a,b,e,0);break B}p=v[x+4>>2];l=1082;C:{j=tfa(h,x);if((j|0)==1){l=1086;j=qfa(h,k+65692|0,g,a,b,e,o);if((j|0)==1){break C}}Eb(152162,l);v[k+96>>2]=j;Fb(276579,k+96|0);Eb(152162,2063);v[k+80>>2]=j;Fb(276579,k+80|0);break v}v[v[x>>2]+(p<<2)>>2]=v[k+65692>>2];v[x+4>>2]=v[x+4>>2]+1;j=rfa(h,f,g,a,b,e,o)}if((j|0)==1){break w}Eb(152162,2067);v[k+64>>2]=j;Fb(276579,k- -64|0);break v}Hb(v[v[h>>2]+8>>2],k+65688|0,152128,2070);j=1}ub=k+65696|0;a=j;if((a|0)==1){break u}b=2187;break g}p=i+66160|0;j=a;k=ub-65680|0;ub=k;D:{E:{F:{if(!Pe(h,f)){break F}a=v[f+20>>2];if((Pb(a)|0)!=1){break F}if(w[a|0]==61){break E}}Eb(152162,668);a=v[f+32>>2];v[k+24>>2]=v[f+20>>2];v[k+20>>2]=200686;v[k+16>>2]=a;Fb(310967,k+16|0);Eb(152162,669);v[k>>2]=v[f+16>>2];Fb(269340,k);a=1;v[f+68>>2]=1;break D}a=Ib(v[v[h>>2]+8>>2],b,4,152128,2097);v[k+65668>>2]=a;if(!a){Eb(152162,2097);a=-1;v[k+32>>2]=-1;Fb(276579,k+32|0);break D}r=Ib(v[v[h>>2]+8>>2],b,4,152128,2098);v[k+65672>>2]=r;if(!r){Eb(152162,2098);a=-1;v[k+48>>2]=-1;Fb(276579,k+48|0);break D}v[k+124>>2]=0;a=VH(h,f,k+65668|0,k+124|0,b);if((a|0)!=1){Eb(152162,2101);v[k+112>>2]=a;Fb(276579,k+112|0);break D}G:{if(v[f+68>>2]){o=v[k+65668>>2];break G}o=v[k+65668>>2];if(!v[f+72>>2]){break G}e=0;l=(b|0)>0?b:0;H:{while(1){if((e|0)==(l|0)){break H}v[k+96>>2]=p;a=e+1|0;v[k+100>>2]=a;u=k+128|0;Jb(u,65536,163223,k+96|0);g=e<<2;e=a;a=ufa(h,g+r|0,f,u,j,v[g+o>>2]);if((a|0)==1){continue}break}Eb(152162,2108);v[k+80>>2]=a;Fb(276579,k+80|0);break D}g=ub+-64|0;ub=g;I:{J:{a=v[f+112>>2];u=v[f+108>>2];if((a|0)!=(u|0)){break J}K:{if(!u){e=783;a=100;l=Tb(v[v[h>>2]+4>>2],100,4,152128,783);v[f+104>>2]=l;if(!l){break K}break J}e=788;a=u<<1;l=gc(v[v[h>>2]+4>>2],v[f+104>>2],v[f+112>>2],a,4,152128,788);v[f+104>>2]=l;if(l){break J}}Eb(152162,e);e=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);Eb(152162,1139);v[g>>2]=-1;Fb(276579,g);break I}v[f+112>>2]=a;a=963;L:{l=Vb(v[v[h>>2]+4>>2],16,152128,963);M:{if(!l){break M}a=966;e=Fc(v[v[h>>2]+4>>2],r,b,4,152128,966);v[l>>2]=e;if(!e){break M}e=1;a=969;p=Fc(v[v[h>>2]+4>>2],p,Pb(p)+1|0,1,152128,969);v[l+4>>2]=p;if(p){break L}}Eb(152162,a);e=-1;v[g+48>>2]=-1;Fb(276579,g+48|0);Eb(152162,1143);v[g+32>>2]=-1;Fb(276579,g+32|0);break I}v[l+12>>2]=j;v[l+8>>2]=b;v[v[f+104>>2]+(u<<2)>>2]=l;v[f+108>>2]=v[f+108>>2]+1}ub=g- -64|0;a=e;if((a|0)==1){break G}Eb(152162,2112);v[k+64>>2]=a;Fb(276579,k- -64|0);break D}Hb(v[v[h>>2]+8>>2],k+65672|0,152128,2115);b=v[k+124>>2];v[k+65676>>2]=o;a=1;if((b|0)>0){while(1){e=b-1|0;Hb(v[v[h>>2]+8>>2],(e<<2)+o|0,152128,272);j=b>>>0>1;b=e;if(j){continue}break}}Hb(v[v[h>>2]+8>>2],k+65676|0,152128,274)}ub=k+65680|0;if((a|0)==1){break u}b=2189;break g}RS(h,i+620|0);break f}if(Nc(a,15212,b)){break j}a=i+66160|0;Du(h,f,a);a=sc(v[f+4>>2],a);v[i+131740>>2]=a;if(a){v[i+608>>2]=0;v[i+612>>2]=1072693248;e=i+600|0;a=kd(h,e,99172,1,i+131740|0,i+608|0,1,1,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);b=1202;N:{if((a|0)!=1){break N}a=mc(h,v[i+600>>2]);b=1206;if((a|0)!=1){break N}a=ec(h,e);if((a|0)==1){break f}b=1207}Eb(152162,b);v[i+528>>2]=a;Fb(276579,i+528|0);Eb(152162,3461);v[i+512>>2]=a;Fb(276579,i+512|0);break h}O:{a=w[i+66160|0];if(!a|(a|32)-97>>>0>25){break O}b=1;a=w[i+66161|0];if(!a){break i}while(1){a=a&255;if(!(a-48>>>0<10|(a|32)-97>>>0<26)&(a|0)!=95){break O}b=b+1|0;a=w[b+(i+66160|0)|0];if(a){continue}break}break i}Eb(152162,668);a=v[f+32>>2];v[i+408>>2]=v[f+20>>2];v[i+404>>2]=117754;v[i+400>>2]=a;Fb(310967,i+400|0);Eb(152162,669);v[i+384>>2]=v[f+16>>2];Fb(269340,i+384|0);v[f+68>>2]=1;break f}if(Nc(a,15330,b)){break j}a=WH(h,f,1);if((a|0)==1){break f}Eb(152162,3748);v[i+544>>2]=a;Fb(276579,i+544|0);break b}if(Lg(a,22805)){a=WH(h,f,2);if((a|0)==1){break f}Eb(152162,3753);v[i+240>>2]=a;Fb(276579,i+240|0);break b}if(Lg(a,90897)){a=WH(h,f,0);if((a|0)==1){break f}Eb(152162,3758);v[i+224>>2]=a;Fb(276579,i+224|0);break b}if(Lg(a,22251)){jc(h,258220,0);v[f+72>>2]=0;break d}if(Lg(a,109874)){a=ub-65648|0;ub=a;P:{if(!Pe(h,f)){Eb(152162,668);b=v[f+32>>2];v[a+24>>2]=v[f+20>>2];v[a+20>>2]=83364;v[a+16>>2]=b;Fb(310967,a+16|0);Eb(152162,669);v[a>>2]=v[f+16>>2];Fb(269340,a);b=1;v[f+68>>2]=1;break P}b=v[f+20>>2];Q:{if((Pb(b)|0)!=2){break Q}if(Nc(b,202013,2)){break Q}while(1){if(!Pe(h,f)){Eb(152162,668);b=v[f+32>>2];v[a+88>>2]=v[f+20>>2];v[a+84>>2]=42725;v[a+80>>2]=b;Fb(310967,a+80|0);Eb(152162,669);v[a+64>>2]=v[f+16>>2];Fb(269340,a- -64|0);v[f+68>>2]=1}e=0;R:{S:{T:{b=v[f+20>>2];switch(Pb(b)-7|0){case 1:break S;case 0:break T;default:break R}}if(Nc(b,4707,7)){break R}break Q}if(!Nc(b,108442,8)){break Q}e=!Nc(b,108371,8)}if(!e){continue}break}}U:{V:{W:{e=Pb(b);if((e|0)==7){if(!Nc(b,4707,7)){break U}break W}if((e|0)!=8){break W}if(Nc(b,108442,8)){break W}b=1;break V}b=-1}v[f+56>>2]=b;b=a+112|0;Du(h,f,b);e=sc(v[f+4>>2],b);b=sc(v[f+8>>2],b);if(e){b=Se(h,e,1);if((b|0)==1){break U}Eb(152162,3595);v[a+48>>2]=b;Fb(276579,a+48|0);break P}if(b){break U}X:{Y:{b=a+112|0;if((Pb(b)|0)!=13){break Y}if(kf(b,85099,13)){break Y}v[a+100>>2]=0;v[a+96>>2]=0;j=Ib(v[v[h>>2]+8>>2],10,4,152128,3614);v[a+108>>2]=j;b=-1;e=3614;Z:{if(!j){break Z}j=Ib(v[v[h>>2]+8>>2],10,8,152128,3615);v[a+104>>2]=j;e=3615;if(!j){break Z}b=200823;_:{$:{if(!Pe(h,f)){break $}e=v[f+20>>2];if((Pb(e)|0)!=1|w[e|0]!=40){break $}b=zB(h,f,a+104|0,a+96|0,10);e=3626;if((b|0)!=1){break Z}if(v[f+68>>2]){break X}aa:{ba:{if(!v[f+72>>2]){break ba}if(!Pe(h,f)){break ba}b=v[f+20>>2];if((Pb(b)|0)!=1){break ba}if(w[b|0]==44){break aa}}if(v[f+68>>2]){break X}b=200770;if(!v[f+72>>2]){break X}break $}b=v[a+96>>2];b=zB(h,f,a+104|0,a+96|0,(b|0)<=10?10:b);e=3638;if((b|0)!=1){break Z}if(v[f+68>>2]|!v[f+72>>2]){break X}ca:{da:{if(!Pe(h,f)){break da}b=v[f+20>>2];if((Pb(b)|0)!=1){break da}if(w[b|0]==44){break ca}}if(v[f+68>>2]){break X}b=200770;if(!v[f+72>>2]){break X}break $}b=Dx(h,f,a+108|0,a+100|0,10);e=3650;if((b|0)!=1){break Z}if(v[f+68>>2]|!v[f+72>>2]){break X}ea:{fa:{if(!Pe(h,f)){break fa}b=v[f+20>>2];if((Pb(b)|0)!=1){break fa}if(w[b|0]==44){break ea}}if(v[f+68>>2]){break X}b=200770;if(v[f+72>>2]){break $}break X}b=v[a+100>>2];b=Dx(h,f,a+108|0,a+100|0,(b|0)<=10?10:b);e=3664;if((b|0)!=1){break Z}if(v[f+68>>2]|!v[f+72>>2]){break X}ga:{if(!Pe(h,f)){break ga}b=v[f+20>>2];if((Pb(b)|0)!=1|w[b|0]!=41){break ga}j=v[a+100>>2];if((j|0)<=0){break X}e=0;k=v[a+104>>2];g=v[a+108>>2];break _}if(v[f+68>>2]){break X}b=200789;if(!v[f+72>>2]){break X}}Jn(f,b);break X}while(1){b=Se(h,v[g+(e<<2)>>2],A[k+(e<<3)>>3]);if((b|0)==1){e=e+1|0;if((j|0)!=(e|0)){continue}break X}break}e=3679}Eb(152162,e);v[a+32>>2]=b;Fb(276579,a+32|0);break P}Jn(f,77490);break U}Hb(v[v[h>>2]+8>>2],a+104|0,152128,3683);Hb(v[v[h>>2]+8>>2],a+108|0,152128,3684)}b=1}ub=a+65648|0;a=b;if((a|0)==1){break f}Eb(152162,3770);v[i+208>>2]=a;Fb(276579,i+208|0);break b}if(Lg(a,69177)){e=ub-131184|0;ub=e;wfa(h,f,e+131176|0,e+131168|0,e+131160|0);a=1;ha:{if(v[f+68>>2]|!v[f+72>>2]){break ha}b=PS(h,f,e+80|0,e+131156|0,0);if((b|0)!=1){Eb(152162,2224);v[e+64>>2]=b;Fb(276579,e- -64|0);a=b;break ha}if(v[f+68>>2]|!v[f+72>>2]){break ha}g=v[e+131176>>2];a=AB(h,f,e+131180|0,e+80|0,A[e+131168>>3],A[e+131160>>3],g);if((a|0)!=1){Eb(152162,2232);v[e+48>>2]=a;Fb(276579,e+48|0);break ha}ia:{if(v[e+131156>>2]){b=v[e+131180>>2];v[e+65616>>2]=b;l=v[x+4>>2];j=1034;a=tfa(h,x);if((a|0)!=1){break ia}k=v[b+208>>2];a=-1;j=1041;b=Vb(v[v[h>>2]+4>>2],20,152128,1041);if(!b){break ia}j=1044;o=Fc(v[v[h>>2]+4>>2],e+65616|0,1,4,152128,1044);v[b>>2]=o;if(!o){break ia}j=1047;k=Fc(v[v[h>>2]+4>>2],k,Pb(k)+1|0,1,152128,1047);v[b+4>>2]=k;if(!k){break ia}j=1049;k=Vb(v[v[h>>2]+4>>2],16,152128,1049);if(!k){break ia}v[k>>2]=0;v[k+4>>2]=0;v[k+8>>2]=0;v[k+12>>2]=0;v[b+16>>2]=g;v[b+12>>2]=1;v[b+8>>2]=k;v[v[x>>2]+(l<<2)>>2]=b;v[x+4>>2]=v[x+4>>2]+1}if(!Pe(h,f)){Jn(f,74897);a=1;break ha}a=1;b=v[f+20>>2];if(!((Pb(b)|0)!=1|w[b|0]!=61)){b=e+65616|0;Du(h,f,b);b=sfa(h,f,v[e+131180>>2],g,b);if((b|0)==1){break ha}Eb(152162,2252);v[e>>2]=b;Fb(276579,e);a=b;break ha}b=(v[f+28>>2]<<2)+f|0;j=v[b+24>>2];v[b+24>>2]=v[f+20>>2];v[f+20>>2]=j;v[f+28>>2]=v[f+28>>2]+1;break ha}Eb(152162,j);v[e+32>>2]=a;Fb(276579,e+32|0);Eb(152162,2237);v[e+16>>2]=a;Fb(276579,e+16|0)}ub=e+131184|0;if((a|0)==1){break f}Eb(152162,3775);v[i+192>>2]=a;Fb(276579,i+192|0);break b}if(Lg(a,7829)){break d}a=(v[f+28>>2]<<2)+E|0;b=v[a>>2];v[a>>2]=v[f+20>>2];v[f+20>>2]=b;v[f+28>>2]=v[f+28>>2]+1;XH(h,f,i+131712|0,i+66160|0,i+624|0);if(v[f+68>>2]|!v[f+72>>2]){break d}a=WH(h,f,v[i+131712>>2]);if((a|0)!=1){Eb(152162,3801);v[i+176>>2]=a;Fb(276579,i+176|0);break b}if(!(v[f+72>>2]?v[f+68>>2]:1)){break f}v[i+64>>2]=v[f+20>>2];jc(h,257864,i- -64|0);break b}ja:{ka:{if(!Pe(h,f)){break ka}a=v[f+20>>2];if((Pb(a)|0)!=1){break ka}if(w[a|0]==40){break ja}}Eb(152162,668);a=v[f+32>>2];v[i+440>>2]=v[f+20>>2];v[i+436>>2]=200823;v[i+432>>2]=a;Fb(310967,i+432|0);Eb(152162,669);v[i+416>>2]=v[f+16>>2];Fb(269340,i+416|0);v[f+68>>2]=1;break f}a=i+66160|0;v[i+496>>2]=a;Jb(i+624|0,65536,63138,i+496|0);b=0;la:{a=B8(a,i+131708|0);ma:{if(!a){break ma}while(1){u=3490;a=Oc(v[v[h>>2]+8>>2],a,Pb(a)+1|0,1,152128,3490);v[(i+131712|0)+(b<<2)>>2]=a;if(!a){a=-1;break la}b=b+1|0;a=B8(0,i+131708|0);if(!a){break ma}if((b|0)!=4){continue}break}}v[i+620>>2]=0;na:{if(v[f+68>>2]|!v[f+72>>2]){break na}u=3508;e=ub-16|0;ub=e;a=1;oa:{pa:{qa:{ra:{j=i+624|0;switch(Pb(j)-8|0){case 0:break qa;case 1:break ra;default:break oa}}if(!Nc(j,22801,9)){break pa}break oa}if(Nc(j,15312,8)){break oa}}a=ofa(h,f,j,71338);if((a|0)!=1){Eb(152162,2865);v[e>>2]=a;Fb(276579,e);break oa}v[i+620>>2]=1;a=1}ub=e+16|0;if((a|0)!=1){break la}a=v[i+620>>2];sa:{if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}a=ub-16|0;ub=a;e=v[i+131712>>2];ta:{if((Pb(e)|0)!=3){break ta}if(Nc(e,22251,3)){break ta}v[f+72>>2]=0;v[a>>2]=v[f+32>>2];jc(h,321589,a)}ub=a+16|0;a=v[i+620>>2];if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}j=i+624|0;k=i+131712|0;a=ub-352|0;ub=a;e=1;ua:{if((b|0)<2){break ua}va:{g=v[k>>2];if((Pb(g)|0)!=4){break va}if(Nc(g,90897,4)|(b|0)!=2){break va}g=v[k+4>>2];if((Pb(g)|0)==2){if(!Nc(g,71338,2)){break ua}if(!Nc(g,122821,2)){break ua}if(!Nc(g,122069,2)){break ua}}if(Lg(g,18035)){break ua}if(Lg(g,21674)){break ua}e=Ib(v[v[h>>2]+8>>2],3,4,152128,2927);v[a+348>>2]=e;if(!e){Eb(152162,2927);e=-1;v[a>>2]=-1;Fb(276579,a);break ua}v[a+344>>2]=0;e=Cx(h,f,a+348|0,a+344|0,3);if((e|0)!=1){Eb(152162,2930);v[a+144>>2]=e;Fb(276579,a+144|0);break ua}wa:{if(!(v[f+68>>2]|!v[f+72>>2])){l=2;e=v[k+4>>2];if(!Lg(e,117137)){l=Lg(e,13827)?2:3}e=Ib(v[v[h>>2]+8>>2],l,4,152128,2944);v[a+336>>2]=e;if(!e){break wa}g=0;p=v[a+348>>2];xa:{ya:{while(1){za:{r=g<<2;o=sc(v[f+4>>2],v[r+p>>2]);v[e+r>>2]=o;if(!o){break za}g=g+1|0;if((g|0)!=(l|0)){continue}break ya}break}Jn(f,117816);break xa}Aa:{Ba:{Ca:{Da:{k=v[k+4>>2];if(!Lg(k,117137)){if(!Lg(k,13827)){break Da}}v[a+328>>2]=0;v[a+332>>2]=1072693248;v[a+320>>2]=0;v[a+324>>2]=1072693248;e=kd(h,a+340|0,j,2,e,a+320|0,1,1,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);if((e|0)!=1){break Ba}break Ca}Ea:{if(Lg(k,65650)){e=mC(h,a+340|0,j,v[e+8>>2],2,e,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);if((e|0)==1){break Ea}Eb(152162,2970);v[a+112>>2]=e;Fb(276579,a+112|0);break ua}if(Lg(k,132048)){e=uo(h,a+340|0,j,v[e+8>>2],2,e,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);if((e|0)!=1){Eb(152162,2977);v[a+96>>2]=e;Fb(276579,a+96|0);break ua}break Ca}if(!Lg(k,63243)){break Aa}k=v[e>>2];v[e>>2]=v[e+8>>2];v[e+8>>2]=k;e=BI(h,a+340|0,j,0,3,e,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);if((e|0)!=1){Eb(152162,2987);v[a+80>>2]=e;Fb(276579,a+80|0);break ua}}}v[i+620>>2]=1;e=mc(h,v[a+340>>2]);if((e|0)!=1){Eb(152162,3e3);v[a+64>>2]=e;Fb(276579,a- -64|0);break ua}e=ec(h,a+340|0);if((e|0)==1){break xa}Eb(152162,3001);v[a+48>>2]=e;Fb(276579,a+48|0);break ua}Eb(152162,2963);v[a+128>>2]=e;Fb(276579,a+128|0);break ua}v[f+72>>2]=0;v[a+32>>2]=j;jc(h,258175,a+32|0)}Hb(v[v[h>>2]+8>>2],a+336|0,152128,3004)}pfa(h,v[a+348>>2],v[a+344>>2]);e=1;break ua}Eb(152162,2944);e=-1;v[a+16>>2]=-1;Fb(276579,a+16|0);break ua}g=v[k+4>>2];if((Pb(g)|0)!=4){break ua}Fa:{Ga:{g=Nc(g,90897,4);if(!(g|(b|0)!=3)){Ha:{Ia:{Ja:{g=v[k+8>>2];switch(Pb(g)-2|0){case 0:break Ia;case 1:break Ja;default:break Fa}}if(!Nc(g,132048,3)){break Ha}break Fa}if(Nc(g,65650,2)){break Fa}}v[a+344>>2]=0;e=Ib(v[v[h>>2]+8>>2],10,4,152128,3030);v[a+348>>2]=e;if(!e){Eb(152162,3030);e=-1;v[a+176>>2]=-1;Fb(276579,a+176|0);break ua}g=Ib(v[v[h>>2]+8>>2],1,4,152128,3031);v[a+340>>2]=g;if(!g){Eb(152162,3031);e=-1;v[a+192>>2]=-1;Fb(276579,a+192|0);break ua}v[a+336>>2]=0;e=Dx(h,f,a+348|0,a+344|0,10);if((e|0)!=1){Eb(152162,3037);v[a+288>>2]=e;Fb(276579,a+288|0);break ua}l=7836;Ka:{La:{if(v[f+68>>2]){break La}Ma:{Na:{if(!v[f+72>>2]){break Na}if(!Pe(h,f)){break Na}e=v[f+20>>2];if((Pb(e)|0)!=1){break Na}if(w[e|0]==44){break Ma}}if(v[f+68>>2]){break La}l=v[f+72>>2]?200770:7836;break La}e=Cx(h,f,a+340|0,a+336|0,1);if((e|0)!=1){Eb(152162,3051);v[a+272>>2]=e;Fb(276579,a+272|0);break ua}g=v[a+340>>2];e=sc(v[f+4>>2],v[g>>2]);if(v[f+68>>2]){break La}l=v[f+72>>2];if(e?l:0){break Ka}l=l?117816:7836}Jn(f,l);break Ga}l=v[f+88>>2];o=v[f+80>>2];p=v[f+76>>2];r=v[a+348>>2];q=v[a+344>>2];Oa:{if(Lg(v[k+8>>2],65650)){e=mC(h,a+320|0,j,e,q,r,p,1,1,1,1,0,0,o,l,0);if((e|0)==1){break Oa}Eb(152162,3068);v[a+256>>2]=e;Fb(276579,a+256|0);break ua}e=uo(h,a+320|0,j,e,q,r,p,1,1,1,1,0,0,o,l,0);if((e|0)==1){break Oa}Eb(152162,3075);v[a+240>>2]=e;Fb(276579,a+240|0);break ua}v[i+620>>2]=1;e=mc(h,v[a+320>>2]);if((e|0)!=1){Eb(152162,3081);v[a+224>>2]=e;Fb(276579,a+224|0);break ua}e=ec(h,a+320|0);if((e|0)==1){break Ga}Eb(152162,3082);v[a+208>>2]=e;Fb(276579,a+208|0);break ua}if(g){break ua}v[f+72>>2]=0;v[a+304>>2]=j;jc(h,258175,a+304|0);break ua}pfa(h,g,v[a+336>>2]);Hb(v[v[h>>2]+8>>2],a+348|0,152128,3087);e=1;break ua}v[f+72>>2]=0;v[a+160>>2]=j;jc(h,258175,a+160|0)}ub=a+352|0;a=e;if((a|0)!=1){break la}a=v[i+620>>2];if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}a=ub-16|0;ub=a;e=v[i+131712>>2];Pa:{if((Pb(e)|0)!=5){break Pa}if(Nc(e,5403,5)){break Pa}v[f+72>>2]=0;v[a>>2]=v[f+32>>2];jc(h,321539,a)}ub=a+16|0;a=v[i+620>>2];if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}k=i+624|0;n=0;l=ub-65712|0;ub=l;Qa:{Ra:{j=i+131712|0;e=v[(j+(b<<2)|0)-4>>2];g=Pb(e);if((g|0)!=4){break Ra}if(Nc(e,106465,4)){break Ra}v[l>>2]=v[f+32>>2];jc(h,339531,l);v[f+72>>2]=0;a=1;break Qa}a=1;if((b|0)!=2&(g|0)!=2){break Qa}Sa:{o=v[j>>2];p=Pb(o);if((p|0)!=3){break Sa}if(Nc(o,22251,3)){break Sa}jc(h,297531,0);v[f+72>>2]=0;break Qa}Ta:{if((g|0)!=2){break Ta}if(Nc(e,117137,2)){break Ta}jc(h,297731,0);v[f+72>>2]=0;break Qa}Ua:{if((p|0)!=5){break Ua}if(Nc(o,22805,5)){break Ua}if(!Lg(e,18035)){if(!Lg(e,21674)){break Ua}}jc(h,297650,0);v[f+72>>2]=0;break Qa}Va:{Wa:{e=v[j+4>>2];if(Lg(e,85109)){v[l+160>>2]=-1568170194;v[l+164>>2]=1417495214;v[l+156>>2]=0;v[l+152>>2]=0;a=Ib(v[v[h>>2]+8>>2],10,4,152128,3175);v[l+172>>2]=a;if(!a){Eb(152162,3175);a=-1;v[l+64>>2]=-1;Fb(276579,l- -64|0);break Qa}a=Ib(v[v[h>>2]+8>>2],10,8,152128,3176);v[l+168>>2]=a;if(!a){Eb(152162,3176);a=-1;v[l+80>>2]=-1;Fb(276579,l+80|0);break Qa}a=zB(h,f,l+168|0,l+152|0,10);if((a|0)!=1){Eb(152162,3181);v[l+128>>2]=a;Fb(276579,l+128|0);break Qa}if(v[f+68>>2]){break Wa}Xa:{Ya:{if(!v[f+72>>2]){break Ya}if(!Pe(h,f)){break Ya}a=v[f+20>>2];if((Pb(a)|0)!=1){break Ya}if(w[a|0]==44){break Xa}}if(v[f+68>>2]|!v[f+72>>2]){break Wa}Jn(f,200770);break Wa}a=Dx(h,f,l+172|0,l+156|0,10);if((a|0)!=1){Eb(152162,3193);v[l+112>>2]=a;Fb(276579,l+112|0);break Qa}if(v[f+68>>2]|!v[f+72>>2]){break Wa}Za:{_a:{if(!Pe(h,f)){break _a}a=v[f+20>>2];if((Pb(a)|0)!=1){break _a}if(w[a|0]==44){break Za}}if(v[f+68>>2]|!v[f+72>>2]){break Wa}Jn(f,200770);break Wa}a=l+176|0;Du(h,f,a);Nq(h,f,l+160|0,a);if(v[f+68>>2]|!v[f+72>>2]){break Wa}n=A[v[h+4>>2]+1272>>3];A[l+144>>3]=-n;A[l+136>>3]=n;nfa(f,v[j+8>>2],A[l+160>>3],l+144|0,l+136|0);if(v[f+68>>2]|!v[f+72>>2]){break Wa}a=OS(h,k,v[l+156>>2],v[l+172>>2],v[l+168>>2],A[l+144>>3],A[l+136>>3],v[f+76>>2],v[f+80>>2],v[f+88>>2]);if((a|0)==1){break Wa}Eb(152162,3221);v[l+96>>2]=a;Fb(276579,l+96|0);break Qa}$a:{ab:{if(Lg(e,25293)){break ab}if(Lg(e,25299)){break ab}if(!Lg(e,113618)){break $a}}g=ub-128|0;ub=g;a=Ib(v[v[h>>2]+8>>2],3,4,152128,2725);v[g+120>>2]=a;bb:{if(!a){Eb(152162,2725);j=-1;v[g>>2]=-1;Fb(276579,g);break bb}v[g+116>>2]=0;j=Cx(h,f,g+120|0,g+116|0,3);if((j|0)!=1){Eb(152162,2729);v[g+80>>2]=j;Fb(276579,g+80|0);break bb}if(!(v[f+68>>2]|!v[f+72>>2])){a=Ib(v[v[h>>2]+8>>2],3,4,152128,2743);v[g+112>>2]=a;if(!a){Eb(152162,2743);j=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);break bb}o=Ib(v[v[h>>2]+8>>2],3,8,152128,2744);v[g+108>>2]=o;if(!o){Eb(152162,2744);j=-1;v[g+32>>2]=-1;Fb(276579,g+32|0);break bb}p=v[g+120>>2];j=sc(v[f+4>>2],v[p>>2]);v[a>>2]=j;cb:{if(!j){Nq(h,f,g+96|0,v[p>>2]);n=0-A[g+96>>3];j=0;break cb}v[o>>2]=0;v[o+4>>2]=1072693248;j=1}r=sc(v[f+4>>2],v[p+4>>2]);v[(j<<2)+a>>2]=r;db:{if(!r){Nq(h,f,g+96|0,v[p+4>>2]);y=A[g+96>>3];if(Lg(e,25293)){n=n+y;break db}n=n-y;break db}r=o+(j<<3)|0;eb:{fb:{if((Pb(e)|0)!=5){break fb}if(Nc(e,25293,5)){break fb}y=-1;break eb}y=1}A[r>>3]=y;j=j+1|0}gb:{if((Pb(e)|0)==6){if(!Nc(e,113618,6)){break gb}}e=sc(v[f+4>>2],v[p+8>>2]);v[a+(j<<2)>>2]=e;if(!e){Nq(h,f,g+96|0,v[p+8>>2]);n=n+A[g+96>>3];break gb}e=o+(j<<3)|0;v[e>>2]=0;v[e+4>>2]=-1074790400;j=j+1|0}e=1202;hb:{p=g+124|0;j=kd(h,p,k,j,a,o,n,n,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);ib:{if((j|0)!=1){break ib}e=1206;j=mc(h,v[g+124>>2]);if((j|0)!=1){break ib}e=1207;j=ec(h,p);if((j|0)==1){break hb}}Eb(152162,e);v[g+64>>2]=j;Fb(276579,g- -64|0);Eb(152162,2804);v[g+48>>2]=j;Fb(276579,g+48|0);break bb}Hb(v[v[h>>2]+8>>2],g+108|0,152128,2807);Hb(v[v[h>>2]+8>>2],g+112|0,152128,2808)}a=v[g+116>>2];k=v[g+120>>2];v[g+96>>2]=k;j=1;if((a|0)>0){while(1){e=a-1|0;Hb(v[v[h>>2]+8>>2],k+(e<<2)|0,152128,272);o=a>>>0>1;a=e;if(o){continue}break}}Hb(v[v[h>>2]+8>>2],g+96|0,152128,274)}ub=g+128|0;a=j;if((a|0)==1){break Va}Eb(152162,3231);v[l+48>>2]=a;Fb(276579,l+48|0);break Qa}jb:{kb:{if(Lg(e,71338)){break kb}if(Lg(e,122069)){break kb}if(Lg(e,122821)){break kb}if(Lg(e,18035)){break kb}if(!Lg(e,21674)){break jb}}a=ofa(h,f,k,e);if((a|0)==1){break Va}Eb(152162,3237);v[l+32>>2]=a;Fb(276579,l+32|0);break Qa}if(Lg(e,51126)){g=ub-192|0;ub=g;a=Ib(v[v[h>>2]+8>>2],3,4,152128,2589);v[g+188>>2]=a;lb:{if(!a){Eb(152162,2589);e=-1;v[g>>2]=-1;Fb(276579,g);break lb}v[g+184>>2]=0;e=Cx(h,f,g+188|0,g+184|0,3);if((e|0)!=1){Eb(152162,2593);v[g+144>>2]=e;Fb(276579,g+144|0);break lb}mb:{if(!(v[f+68>>2]|!v[f+72>>2])){e=Ib(v[v[h>>2]+8>>2],3,4,152128,2605);v[g+180>>2]=e;if(!e){Eb(152162,2605);e=-1;v[g+16>>2]=-1;Fb(276579,g+16|0);break lb}a=Ib(v[v[h>>2]+8>>2],3,8,152128,2606);v[g+176>>2]=a;if(!a){break mb}j=v[g+188>>2];o=sc(v[f+4>>2],v[j>>2]);v[e>>2]=o;nb:{if(!o){Nq(h,f,a,v[j>>2]);break nb}v[a>>2]=-1568170194;v[a+4>>2]=1417495214}p=sc(v[f+4>>2],v[j+4>>2]);v[e+4>>2]=p;o=a+8|0;ob:{if(p){v[o>>2]=-1568170194;v[o+4>>2]=1417495214;break ob}Nq(h,f,o,v[j+4>>2])}p=sc(v[f+4>>2],v[j+8>>2]);v[e+8>>2]=p;o=a+16|0;pb:{if(p){v[o>>2]=-1568170194;v[o+4>>2]=1417495214;break pb}Nq(h,f,o,v[j+8>>2])}j=e+4|0;o=e+8|0;p=v[e+4>>2];qb:{rb:{sb:{tb:{if(v[e>>2]){if(!p){break tb}v[g+168>>2]=0;v[g+172>>2]=1072693248;if(v[o>>2]){v[g+160>>2]=0;v[g+164>>2]=-1074790400;e=mfa(h,k,1,o,g+160|0,e,j,g+168|0,0,0,v[f+76>>2],v[f+80>>2],v[f+88>>2]);if((e|0)==1){break qb}Eb(152162,2636);v[g+128>>2]=e;Fb(276579,g+128|0);break lb}n=A[a+16>>3]+0;e=mfa(h,k,0,0,0,e,j,g+168|0,n,n,v[f+76>>2],v[f+80>>2],v[f+88>>2]);if((e|0)==1){break qb}Eb(152162,2642);v[g+112>>2]=e;Fb(276579,g+112|0);break lb}if(!p){break rb}p=v[e>>2];v[e>>2]=v[j>>2];v[j>>2]=p;break sb}p=v[a>>2];v[a>>2]=v[a+8>>2];v[a+8>>2]=p}p=1202;r=g+168|0;q=v[o>>2];ub:{if(q){z=v[j>>2];v[j>>2]=q;v[o>>2]=z;v[a+8>>2]=0;v[a+12>>2]=-1074790400;j=2;break ub}n=A[a+16>>3]+0;j=1}e=kd(h,r,k,j,e,a,n,n,v[f+76>>2],1,1,1,1,0,0,v[f+80>>2],v[f+88>>2],0);vb:{if((e|0)!=1){break vb}p=1206;e=mc(h,v[g+168>>2]);if((e|0)!=1){break vb}p=1207;e=ec(h,r);if((e|0)==1){break qb}}Eb(152162,p);v[g+96>>2]=e;Fb(276579,g+96|0);Eb(152162,2672);v[g+80>>2]=e;Fb(276579,g+80|0);break lb}n=0-A[a>>3]*A[a+8>>3];if(v[o>>2]){v[g+168>>2]=0;v[g+172>>2]=-1074790400;e=OS(h,k,1,o,g+168|0,n,n,v[f+76>>2],v[f+80>>2],v[f+88>>2]);if((e|0)==1){break qb}Eb(152162,2686);v[g+64>>2]=e;Fb(276579,g- -64|0);break lb}n=n+A[a+16>>3];e=OS(h,k,0,0,0,n,n,v[f+76>>2],v[f+80>>2],v[f+88>>2]);if((e|0)==1){break qb}Eb(152162,2692);v[g+48>>2]=e;Fb(276579,g+48|0);break lb}Hb(v[v[h>>2]+8>>2],g+176|0,152128,2697);Hb(v[v[h>>2]+8>>2],g+180|0,152128,2698)}a=v[g+184>>2];k=v[g+188>>2];v[g+168>>2]=k;e=1;if((a|0)>0){while(1){j=a-1|0;Hb(v[v[h>>2]+8>>2],k+(j<<2)|0,152128,272);o=a>>>0>1;a=j;if(o){continue}break}}Hb(v[v[h>>2]+8>>2],g+168|0,152128,274);break lb}Eb(152162,2606);e=-1;v[g+32>>2]=-1;Fb(276579,g+32|0)}ub=g+192|0;a=e;if((a|0)==1){break Va}Eb(152162,3242);v[l+16>>2]=a;Fb(276579,l+16|0);break Qa}Jn(f,116217);break Va}Hb(v[v[h>>2]+8>>2],l+168|0,152128,3225);Hb(v[v[h>>2]+8>>2],l+172|0,152128,3226)}a=1;v[i+620>>2]=1}ub=l+65712|0;if((a|0)!=1){break la}a=v[i+620>>2];if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}a=ub-32|0;ub=a;e=1;j=i+131712|0;k=v[j>>2];wb:{if((Pb(k)|0)!=3){break wb}if(Nc(k,91679,3)){break wb}j=v[j+4>>2];if((Pb(j)|0)!=9){break wb}if(Nc(j,15473,9)){break wb}v[a+24>>2]=0;e=Ib(v[v[h>>2]+8>>2],10,4,152128,3274);v[a+28>>2]=e;if(!e){Eb(152162,3274);e=-1;v[a>>2]=-1;Fb(276579,a);break wb}e=Dx(h,f,a+28|0,a+24|0,10);if((e|0)!=1){Eb(152162,3279);v[a+16>>2]=e;Fb(276579,a+16|0);break wb}Hb(v[v[h>>2]+8>>2],a+28|0,152128,3295);e=1}ub=a+32|0;a=e;if((a|0)!=1){break la}a=v[i+620>>2];if(a){a=(a|0)!=0;break sa}if(v[f+68>>2]|!v[f+72>>2]){break na}k=i+624|0;o=0;l=0;p=0;g=ub-65760|0;ub=g;v[g+65748>>2]=0;v[g+65744>>2]=0;v[g+65740>>2]=0;e=1;a=v[i+131712>>2];xb:{if((Pb(a)|0)!=10){break xb}if(Nc(a,110685,10)){break xb}v[g+184>>2]=0;v[g+188>>2]=0;v[g+180>>2]=0;a=Ib(v[v[h>>2]+8>>2],10,4,152128,3334);v[g+65752>>2]=a;if(!a){Eb(152162,3334);e=-1;v[g>>2]=-1;Fb(276579,g);break xb}e=Dx(h,f,g+65752|0,g+188|0,10);if((e|0)!=1){Eb(152162,3335);v[g+176>>2]=e;Fb(276579,g+176|0);break xb}yb:{zb:{Ab:{if(v[f+68>>2]){break Ab}Bb:{Cb:{if(!v[f+72>>2]){break Cb}if(!Pe(h,f)){break Cb}a=v[f+20>>2];if((Pb(a)|0)!=1){break Cb}if(w[a|0]==44){break Bb}}if(v[f+68>>2]|!v[f+72>>2]){break Ab}Eb(152162,668);a=v[f+32>>2];v[g+40>>2]=v[f+20>>2];v[g+36>>2]=200770;v[g+32>>2]=a;Fb(310967,g+32|0);Eb(152162,669);v[g+16>>2]=v[f+16>>2];Fb(269340,g+16|0);v[f+68>>2]=1;break Ab}a=Ib(v[v[h>>2]+8>>2],10,8,152128,3347);v[g+65748>>2]=a;if(!a){Eb(152162,3347);e=-1;v[g+48>>2]=-1;Fb(276579,g+48|0);break xb}e=zB(h,f,g+65748|0,g+184|0,10);if((e|0)!=1){Eb(152162,3348);v[g+160>>2]=e;Fb(276579,g+160|0);break xb}r=v[g+184>>2];a=Ib(v[v[h>>2]+8>>2],r,4,152128,3350);v[g+65744>>2]=a;if(!a){break zb}Db:{if((r|0)<=0){break Db}j=v[g+65748>>2];e=0;if(r>>>0>=4){z=r&2147483644;while(1){s=a+(e<<2)|0;n=A[j+(e<<3)>>3];Eb:{if(D(n)<2147483648){q=~~n;break Eb}q=-2147483648}v[s>>2]=q;q=e|1;s=a+(q<<2)|0;n=A[j+(q<<3)>>3];Fb:{if(D(n)<2147483648){q=~~n;break Fb}q=-2147483648}v[s>>2]=q;q=e|2;s=a+(q<<2)|0;n=A[j+(q<<3)>>3];Gb:{if(D(n)<2147483648){q=~~n;break Gb}q=-2147483648}v[s>>2]=q;q=e|3;s=a+(q<<2)|0;n=A[j+(q<<3)>>3];Hb:{if(D(n)<2147483648){q=~~n;break Hb}q=-2147483648}v[s>>2]=q;e=e+4|0;l=l+4|0;if((z|0)!=(l|0)){continue}break}}r=r&3;if(!r){break Db}while(1){q=a+(e<<2)|0;n=A[j+(e<<3)>>3];Ib:{if(D(n)<2147483648){l=~~n;break Ib}l=-2147483648}v[q>>2]=l;e=e+1|0;o=o+1|0;if((r|0)!=(o|0)){continue}break}}if(v[f+68>>2]|!v[f+72>>2]){break Ab}Jb:{Kb:{if(!Pe(h,f)){break Kb}e=v[f+20>>2];if((Pb(e)|0)!=1){break Kb}if(w[e|0]==44){break Jb}}if(v[f+68>>2]|!v[f+72>>2]){break Ab}Jn(f,200770);break Ab}e=zB(h,f,g+65748|0,g+180|0,10);if((e|0)!=1){Eb(152162,3364);v[g+144>>2]=e;Fb(276579,g+144|0);break xb}r=v[g+180>>2];j=Ib(v[v[h>>2]+8>>2],r,4,152128,3366);v[g+65740>>2]=j;if(!j){break yb}Lb:{if((r|0)<=0){break Lb}l=0;o=v[g+65748>>2];e=0;if(r>>>0>=4){z=r&2147483644;while(1){s=j+(e<<2)|0;n=A[o+(e<<3)>>3];Mb:{if(D(n)<2147483648){q=~~n;break Mb}q=-2147483648}v[s>>2]=q;q=e|1;s=j+(q<<2)|0;n=A[o+(q<<3)>>3];Nb:{if(D(n)<2147483648){q=~~n;break Nb}q=-2147483648}v[s>>2]=q;q=e|2;s=j+(q<<2)|0;n=A[o+(q<<3)>>3];Ob:{if(D(n)<2147483648){q=~~n;break Ob}q=-2147483648}v[s>>2]=q;q=e|3;s=j+(q<<2)|0;n=A[o+(q<<3)>>3];Pb:{if(D(n)<2147483648){q=~~n;break Pb}q=-2147483648}v[s>>2]=q;e=e+4|0;p=p+4|0;if((z|0)!=(p|0)){continue}break}}r=r&3;if(!r){break Lb}while(1){q=j+(e<<2)|0;n=A[o+(e<<3)>>3];Qb:{if(D(n)<2147483648){p=~~n;break Qb}p=-2147483648}v[q>>2]=p;e=e+1|0;l=l+1|0;if((r|0)!=(l|0)){continue}break}}if(v[f+68>>2]|!v[f+72>>2]){break Ab}Rb:{Sb:{if(!Pe(h,f)){break Sb}e=v[f+20>>2];if((Pb(e)|0)!=1){break Sb}if(w[e|0]==44){break Rb}}if(v[f+68>>2]|!v[f+72>>2]){break Ab}Jn(f,200770);break Ab}e=g+192|0;Du(h,f,e);Nq(h,f,g+65728|0,e);l=v[f+88>>2];o=v[f+80>>2];p=v[f+76>>2];r=g+65756|0;q=v[g+188>>2];z=v[g+65752>>2];n=A[g+65728>>3];Tb:{if(D(n)<2147483648){e=~~n;break Tb}e=-2147483648}e=Hw(h,r,k,q,z,a,j,e,p,1,1,1,1,0,0,o,l,0);if((e|0)!=1){Eb(152162,3391);v[g+128>>2]=e;Fb(276579,g+128|0);break xb}e=mc(h,v[g+65756>>2]);if((e|0)!=1){Eb(152162,3396);v[g+112>>2]=e;Fb(276579,g+112|0);break xb}e=ec(h,g+65756|0);if((e|0)!=1){Eb(152162,3397);v[g+96>>2]=e;Fb(276579,g+96|0);break xb}v[i+620>>2]=1}lc(v[v[h>>2]+8>>2],g+65740|0);lc(v[v[h>>2]+8>>2],g+65744|0);lc(v[v[h>>2]+8>>2],g+65748|0);Hb(v[v[h>>2]+8>>2],g+65752|0,152128,3407);e=1;break xb}Eb(152162,3350);e=-1;v[g+64>>2]=-1;Fb(276579,g- -64|0);break xb}Eb(152162,3366);e=-1;v[g+80>>2]=-1;Fb(276579,g+80|0)}ub=g+65760|0;a=e;if((a|0)!=1){break la}a=v[i+620>>2]!=0}if(v[f+68>>2]|(a|!v[f+72>>2])){break na}v[f+72>>2]=0;v[i+448>>2]=v[f+32>>2];v[i+452>>2]=i+624;jc(h,321491,i+448|0)}if((b|0)>0){while(1){a=b-1|0;Hb(v[v[h>>2]+8>>2],(i+131712|0)+(a<<2)|0,152128,3521);e=b>>>0>1;b=a;if(e){continue}break}}if(v[f+68>>2]|!v[f+72>>2]){break f}Ub:{if(!Pe(h,f)){break Ub}a=v[f+20>>2];if((Pb(a)|0)!=1){break Ub}if(w[a|0]==41){break f}}Jn(f,200789);break f}Eb(152162,u);v[i+480>>2]=a;Fb(276579,i+480|0)}Eb(152162,3743);v[i+464>>2]=a;Fb(276579,i+464|0);break b}Eb(152162,b);v[i+368>>2]=a;Fb(276579,i+368|0);Eb(152162,3738);v[i+352>>2]=a;Fb(276579,i+352|0);break b}if(v[f+68>>2]|!v[f+72>>2]){break d}if(v[f+64>>2]){break e}if(!Pe(h,f)){Eb(152162,668);a=v[f+32>>2];v[i+168>>2]=v[f+20>>2];v[i+164>>2]=74897;v[i+160>>2]=a;Fb(310967,i+160|0);Eb(152162,669);v[i+144>>2]=v[f+16>>2];Fb(269340,i+144|0);v[f+68>>2]=1}a=v[f+20>>2];Vb:{if((Pb(a)|0)!=2){break Vb}if(Nc(a,202013,2)){break Vb}while(1){if(!Pe(h,f)){Eb(152162,668);a=v[f+32>>2];v[i+136>>2]=v[f+20>>2];v[i+132>>2]=42725;v[i+128>>2]=a;Fb(310967,i+128|0);Eb(152162,669);v[i+112>>2]=v[f+16>>2];Fb(269340,i+112|0);v[f+68>>2]=1}a=v[f+20>>2];if((Pb(a)|0)!=1|w[a|0]!=59){continue}break}}if((Pb(a)|0)==1&w[a|0]==59){break e}Eb(152162,668);a=v[f+32>>2];v[i+104>>2]=v[f+20>>2];v[i+100>>2]=74897;v[i+96>>2]=a;Fb(310967,i+96|0);Eb(152162,669);v[i+80>>2]=v[f+16>>2];Fb(269340,i+80|0);v[f+68>>2]=1}a=v[f>>2];Wb:{if(v[a+76>>2]<0){a=v[a>>2];break Wb}a=v[a>>2]}if(!(a>>>4&1)){continue}break}}hh(v[f>>2]);if(!(v[f+68>>2]|!v[f+72>>2])){a=1;b=Qk(h,v[f+56>>2]);if((b|0)==1){break b}Eb(152162,3851);v[i+48>>2]=b;Fb(276579,i+48|0);a=b;break b}a=1;b=Fw(h);if((b|0)!=1){Eb(152162,3844);v[i+32>>2]=b;Fb(276579,i+32|0);a=b;break b}b=tk(h,c,0,0,0,0,0,0,0);if((b|0)==1){break b}Eb(152162,3847);v[i+16>>2]=b;Fb(276579,i+16|0);a=b;break b}Eb(152162,3722);v[i+560>>2]=a;Fb(276579,i+560|0)}ub=i+131744|0;e=a;if((a|0)!=1){Eb(152162,4826);v[m+64>>2]=a;Fb(276579,m- -64|0);break a}e=v[m+220>>2];if((e|0)>0){while(1){a=e-1|0;b=a<<2;Hb(v[v[h>>2]+8>>2],v[b+v[m+184>>2]>>2],152128,4831);Hb(v[v[h>>2]+8>>2],b+v[m+184>>2]|0,152128,4832);b=e>>>0>1;e=a;if(b){continue}break}}Hb(v[v[h>>2]+8>>2],m+184|0,152128,4834);lc(v[v[h>>2]+8>>2],m+196|0);lc(v[v[h>>2]+8>>2],m+192|0);cf(B);cf(C);if(v[m+268>>2]>0){c=0;while(1){a=v[m+264>>2]+(c<<2)|0;RS(h,v[a>>2]+8|0);b=v[a>>2];Lb(v[v[h>>2]+4>>2],b+4|0,Pb(v[b+4>>2])+1|0,152128,917);b=v[a>>2];Lb(v[v[h>>2]+4>>2],b,v[b+12>>2]<<2,152128,918);Lb(v[v[h>>2]+4>>2],a,20,152128,920);c=c+1|0;if((c|0)<v[m+268>>2]){continue}break}}_b(v[v[h>>2]+4>>2],m+264|0,v[m+272>>2]<<2,152128,4851);if(v[m+280>>2]>0){e=0;while(1){a=v[m+276>>2]+(e<<2)|0;b=v[a>>2];Lb(v[v[h>>2]+4>>2],b,v[b+8>>2]<<2,152128,987);b=v[a>>2];Lb(v[v[h>>2]+4>>2],b+4|0,Pb(v[b+4>>2])+1|0,152128,990);Lb(v[v[h>>2]+4>>2],a,16,152128,993);e=e+1|0;if((e|0)<v[m+280>>2]){continue}break}}_b(v[v[h>>2]+4>>2],m+276|0,v[m+284>>2]<<2,152128,4858);Lb(v[v[h>>2]+4>>2],m+188|0,v[m+212>>2],152128,4860);e=-2;if(v[m+240>>2]|!v[m+244>>2]){break a}v[d>>2]=17;e=1}ub=m+288|0;return e|0}function FR(a,b,c,d,e,f,g,h,i,k,m,p,q,r){var s=0,u=0,x=0,y=0,z=0,B=0,C=0,E=0,G=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0;z=ub-288|0;ub=z;oa=fc(a);v[r>>2]=0;B=Ib(v[v[a>>2]+8>>2],oa,4,147416,7460);v[z+164>>2]=B;a:{if(!B){Eb(147450,7460);y=-1;v[z>>2]=-1;Fb(276579,z);break a}y=5970;B=Ib(v[v[a>>2]+8>>2],oa,4,147416,5970);v[z+176>>2]=B;b:{c:{if(!B){break c}y=5971;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5971);v[z+180>>2]=B;if(!B){break c}y=5972;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5972);v[z+184>>2]=B;if(!B){break c}y=5973;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5973);v[z+188>>2]=B;if(!B){break c}y=5974;B=Ib(v[v[a>>2]+8>>2],oa,4,147416,5974);v[z+208>>2]=B;if(!B){break c}y=5975;B=Ib(v[v[a>>2]+8>>2],oa,4,147416,5975);v[z+212>>2]=B;if(!B){break c}y=5976;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5976);v[z+216>>2]=B;if(!B){break c}y=5977;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5977);v[z+220>>2]=B;if(!B){break c}y=5978;B=Ib(v[v[a>>2]+8>>2],oa,8,147416,5978);v[z+224>>2]=B;if(B){break b}}Eb(147450,y);y=-1;v[z+32>>2]=-1;Fb(276579,z+32|0);Eb(147450,7461);v[z+16>>2]=-1;Fb(276579,z+16|0);break a}pa=v[f+4>>2];J=A[f+32>>3];x=A[f+24>>3];ua=v[f>>2];ja=v[f+40>>2];v[r>>2]=0;B=5445;O=hd(a);Da=Lc(a);Ia=Ib(v[v[a>>2]+8>>2],ja,8,147416,5445);v[z+240>>2]=Ia;d:{e:{f:{g:{h:{if(!Ia){break h}B=5446;W=Ib(v[v[a>>2]+8>>2],ja,8,147416,5446);v[z+168>>2]=W;if(!W){break h}B=5447;_=Ib(v[v[a>>2]+8>>2],ja,8,147416,5447);v[z+284>>2]=_;if(!_){break h}B=5448;Ea=Ib(v[v[a>>2]+8>>2],ja,8,147416,5448);v[z+280>>2]=Ea;if(!Ea){break h}B=5449;ka=Ib(v[v[a>>2]+8>>2],ja,4,147416,5449);v[z+276>>2]=ka;if(!ka){break h}B=5450;Fa=Ib(v[v[a>>2]+8>>2],ja,4,147416,5450);v[z+272>>2]=Fa;if(!Fa){break h}B=5451;ea=Ib(v[v[a>>2]+8>>2],ja,4,147416,5451);v[z+268>>2]=ea;if(!ea){break h}B=5452;Ga=Ib(v[v[a>>2]+8>>2],ja,4,147416,5452);v[z+264>>2]=Ga;if(!Ga){break h}B=5453;wa=Ib(v[v[a>>2]+8>>2],ja,4,147416,5453);v[z+260>>2]=wa;if(!wa){break h}sG(pa,ja);B=5459;ma=Ib(v[v[a>>2]+12>>2],O,1,147416,5459);v[z+248>>2]=ma;if(!ma){break h}P=ja-1|0;i:{j:{k:{l:{if((ja|0)<=0){B=P;break l}U=P;while(1){B=v[pa+(U<<2)>>2];if((B|0)>=(O|0)){break k}t[B+ma|0]=255;Ja=Ja+1|0;B=-1;y=(U|0)>0;U=U-1|0;if(y){continue}break}}v[z+192>>2]=0;break j}M=1-d;B=0;while(1){Q=B<<3;xa=Ia+Q|0;S=v[a+4>>2];A[xa>>3]=-A[S+1272>>3];ya=Q+W|0;A[ya>>3]=A[S+1272>>3];X=B;qa=B<<2;za=qa+ka|0;v[za>>2]=-3;Aa=qa+Fa|0;v[Aa>>2]=-3;y=v[pa+qa>>2];B=ua+(y<<4)|0;E=A[B>>3];C=A[B+8>>3];va=Q+_|0;la=v[(y<<2)+Da>>2];u=A[la+128>>3];A[va>>3]=u;O=ea+qa|0;v[O>>2]=-1;m:{if(e){s=A[la+152>>3];if(A[S+1280>>3]<s-u){A[va>>3]=s;v[O>>2]=-2}na=Q+Ea|0;s=A[la+136>>3];A[na>>3]=s;Ba=qa+Ga|0;v[Ba>>2]=-1;u=A[la+160>>3];if(!(-A[S+1280>>3]>u-s)){u=s;break m}A[na>>3]=u;v[Ba>>2]=-2;break m}na=Q+Ea|0;u=A[la+136>>3];A[na>>3]=u;Ba=qa+Ga|0;v[Ba>>2]=-1}if(A[va>>3]<=-1e10){A[va>>3]=-A[S+1272>>3];u=A[na>>3]}if(u>=1e10){A[na>>3]=A[S+1272>>3]}K=Ob(a,b,la);B=v[a+4>>2];u=A[B+1272>>3];y=u<=A[na>>3];n:{o:{p:{q:{s=A[va>>3];if(y&u<=-s){break q}R=E+C;r:{if(y){break r}A[xa>>3]=s;v[za>>2]=v[O>>2];if((v[la+376>>2]&192)!=192){break r}B=v[la+240>>2];if(B){O=v[B+12>>2]}else{O=0}N=A[na>>3];aa=hd(a);B=v[a+4>>2];s=-A[B+1272>>3];s:{if((O|0)<=0){S=-1;break s}B=0;V=0;y=0;Ca=0;S=v[la+240>>2];if(S){Ca=v[S+8>>2];V=v[S+4>>2];y=v[S>>2]}o(1);Q=j(1)|0;ca=j(0)|0;o(+R);S=j(1)|0;j(0)|0;l(0,ca|0);l(1,Q&2147483647|S&-2147483648);G=+n();S=-1;while(1){Q=B<<3;ca=Ca+Q|0;E=A[ca>>3];t:{if(E<N){break t}L=A[Q+V>>3];if(D(L)>1e5){break t}ha=v[(B<<2)+y>>2];Q=v[ha+292>>2];if(aa>>>0<=Q>>>0|w[Q+ma|0]==1){break t}Q=ua+(Q<<4)|0;C=A[Q>>3]+A[Q+8>>3];u=G*(R*L+C);if(u>0|A[v[a+4>>2]+1272>>3]<=-u|G*(R*(N-E)+C)>0){break t}u=L*Ob(a,b,ha)+A[ca>>3];if(!(u>s)){break t}s=u;S=B}B=B+1|0;if((O|0)!=(B|0)){continue}break}B=v[a+4>>2]}if(!(A[B+1280>>3]<s-A[xa>>3])){break r}A[xa>>3]=s;v[za>>2]=S}u:{if(A[B+1272>>3]<=-A[va>>3]){s=A[ya>>3];break u}s=A[na>>3];A[ya>>3]=s;v[Aa>>2]=v[Ba>>2];if((v[la+376>>2]&192)!=192){break u}B=v[la+244>>2];if(B){O=v[B+12>>2]}else{O=0}N=A[va>>3];aa=hd(a);B=v[a+4>>2];s=A[B+1272>>3];v:{if((O|0)<=0){y=-1;break v}B=0;S=0;na=0;Ca=0;y=v[la+244>>2];if(y){Ca=v[y+8>>2];na=v[y>>2];S=v[y+4>>2]}o(1);Q=j(1)|0;V=j(0)|0;o(+R);y=j(1)|0;j(0)|0;l(0,V|0);l(1,Q&2147483647|y&-2147483648);G=+n();y=-1;while(1){Q=B<<3;ca=Ca+Q|0;E=A[ca>>3];w:{if(E>N){break w}L=A[Q+S>>3];if(D(L)>1e5){break w}ha=v[(B<<2)+na>>2];Q=v[ha+292>>2];if(aa>>>0<=Q>>>0|w[Q+ma|0]==1){break w}Q=ua+(Q<<4)|0;C=A[Q>>3]+A[Q+8>>3];u=G*(R*L+C);if(u<0|u>=A[v[a+4>>2]+1272>>3]|G*(R*(N-E)+C)<0){break w}u=L*Ob(a,b,ha)+A[ca>>3];if(!(u<s)){break w}s=u;y=B}B=B+1|0;if((O|0)!=(B|0)){continue}break}B=v[a+4>>2]}u=A[ya>>3];if(!(-A[B+1280>>3]>s-u)){s=u;break u}A[ya>>3]=s;v[Aa>>2]=y}u=A[B+1272>>3];C=A[xa>>3];if(u<=-C&s>=u){break q}x:{y:{u=K-(M*C+s*d);s=A[B+1280>>3];if(!(D(u)<=s)){break y}if(v[za>>2]>=0){B=qa+wa|0;break x}if(v[Aa>>2]<0){break y}B=qa+wa|0;break p}B=qa+wa|0;if(!(s>=u)){break p}}v[B>>2]=0;B=240;Q=v[za>>2];if((Q|0)<0){break n}break o}z:{if((P|0)<=(U|0)){break z}e=Ja&3;if(e){y=0;while(1){t[ma+v[pa+(P<<2)>>2]|0]=0;P=P-1|0;y=y+1|0;if((e|0)!=(y|0)){continue}break}}if(Ja-1>>>0<3){break z}y=pa-12|0;B=pa-8|0;e=pa-4|0;while(1){O=P<<2;t[ma+v[O+pa>>2]|0]=0;t[ma+v[e+O>>2]|0]=0;t[ma+v[B+O>>2]|0]=0;t[ma+v[y+O>>2]|0]=0;P=P-4|0;if((P|0)>(U|0)){continue}break}}if(!X){break i}y=0;while(1){A:{B:{C:{D:{B=y<<2;switch(v[B+wa>>2]){case 1:break C;case 0:break D;default:break A}}e=240;P=v[B+v[z+276>>2]>>2];if((P|0)>=0){break B}break A}e=244;P=v[B+Fa>>2];if((P|0)<0){break A}}t[ma+v[v[v[v[v[(v[B+pa>>2]<<2)+Da>>2]+e>>2]>>2]+(P<<2)>>2]+292>>2]|0]=0}y=y+1|0;if((X|0)!=(y|0)){continue}break}break i}v[B>>2]=1;B=244;Q=v[Aa>>2];if((Q|0)<0){break n}}t[ma+v[v[v[v[B+la>>2]>>2]+(Q<<2)>>2]+292>>2]|0]=1}B=X+1|0;if((U|0)!=(X|0)){continue}break}v[z+192>>2]=0;P=0;Q=0;B=0;while(1){e=B;S=e<<2;O=v[S+pa>>2];y=ua+(O<<4)|0;$=A[y>>3];ga=A[y+8>>3];X=v[(O<<2)+Da>>2];G=Ob(a,b,X);y=v[S+v[z+260>>2]>>2];v[v[z+212>>2]+(P<<2)>>2]=O;E:{if(!y){O=S+v[z+276>>2]|0;y=v[O>>2];if((y|0)<0){B=e<<3;T=A[B+v[z+280>>2]>>3];L=G-T;d=L*134217729;K=d-(d-L);d=L-G;u=(-T-d+(G-(L-d)))*$;E=$*L;M=u+E;C=M-E;s=L-K;d=$*134217729;Y=d-(d-$);N=$-Y;E=s*N-(E-K*Y-s*Y-K*N)+(u-C+(E-(M-C)));d=L*ga;L=d+M;s=L-M;C=d-s+(M-(L-s));d=A[B+v[z+240>>2]>>3];R=T-d;u=R*ga;s=-d;d=R-T;s=(s-d+(T-(R-d)))*$;M=$*R;G=s+M;K=u+G;d=K-G;Z=u-d+(G-(K-d));d=R*134217729;u=d-(d-R);d=R-u;u=d*N-(M-u*Y-d*Y-u*N);d=G-M;s=Z+(u+(s-d+(M-(G-d))));Q=(y|0)!=-2&v[S+v[z+264>>2]>>2]!=-2?Q:1;C=C+E;v[v[z+208>>2]+(v[z+192>>2]<<2)>>2]=-1;y=v[z+192>>2];B=v[z+216>>2]+(y<<3)|0;v[B>>2]=0;v[B+4>>2]=0;d=T*134217729;u=d-(d-T);d=T-u;M=$*T;E=ga*T+(N*d-(M-Y*u-N*u-Y*d));u=M+E;s=K+s;B=v[z+176>>2]+(y<<2)|0;d=$+ga;F:{if(d>1e-12){v[B>>2]=-1;P=v[z+188>>2];B=v[z+192>>2];O=B<<3;A[P+O>>3]=s;y=O+v[z+180>>2]|0;v[y>>2]=0;v[y+4>>2]=1072693248;A[O+v[z+184>>2]>>3]=-(L+C);A[O+v[z+224>>2]>>3]=u;d=-d;break F}v[B>>2]=1;P=v[z+188>>2];B=v[z+192>>2];O=B<<3;A[P+O>>3]=-s;y=O+v[z+180>>2]|0;v[y>>2]=0;v[y+4>>2]=1072693248;A[O+v[z+184>>2]>>3]=L+C;A[O+v[z+224>>2]>>3]=-u}A[v[z+220>>2]+(B<<3)>>3]=d;s=x-M;d=s-x;u=J+(-M-d+(x-(s-d)));x=s-E;d=x-s;J=u+(-E-d+(s-(x-d)));break E}S=v[X+240>>2];P=v[v[S>>2]+(y<<2)>>2];X=v[P+292>>2];B=ua+(X<<4)|0;Y=A[B+8>>3];fa=A[B>>3];y=v[S+8>>2];B=v[S+4>>2];ba=Ob(a,b,P);P=B;B=v[O>>2]<<3;R=A[P+B>>3];da=A[y+B>>3];t[X+v[z+248>>2]|0]=0;v[v[z+208>>2]+(v[z+192>>2]<<2)>>2]=X;d=fa*134217729;C=d-(d-fa);s=fa-C;d=ba*134217729;u=d-(d-ba);d=ba-u;E=fa*ba;C=Y*ba+(s*d-(E-C*u-s*u-C*d));T=G-da;s=T*ga;d=T-G;u=(-da-d+(G-(T-d)))*$;M=$*T;N=u+M;G=s+N;L=E+G;K=C+L;d=K-L;Z=C-d+(L-(K-d));d=L-G;E=E-d+(G-(L-d));d=G-N;ia=s-d+(N-(G-d));d=T*134217729;C=d-(d-T);s=T-C;d=$*134217729;G=d-(d-$);L=$-G;d=N-M;C=Z+(E+(ia+(s*L-(M-C*G-s*G-C*L)+(u-d+(M-(N-d))))));u=$*R;E=fa+u;s=Y+E;d=s-E;Z=s;M=Y-d+(E-(s-d));d=E-u;E=fa-d+(u-(E-d));d=R*134217729;s=d-(d-R);d=R-s;u=Z+(M+(E+(ga*R+(L*d-(u-G*s-L*s-G*d)))));d=da*134217729;s=d-(d-da);d=da-s;M=$*da;E=ga*da+(L*d-(M-G*s-L*s-G*d));B=v[z+176>>2]+(v[z+192>>2]<<2)|0;d=$+ga;G:{if(d>1e-12){v[B>>2]=-1;P=v[z+188>>2];B=v[z+192>>2];y=B<<3;A[P+y>>3]=-u;A[y+v[z+180>>2]>>3]=ba;A[y+v[z+184>>2]>>3]=-(K+C);A[y+v[z+216>>2]>>3]=-(fa+Y);A[y+v[z+220>>2]>>3]=-d;d=M+E;break G}v[B>>2]=1;P=v[z+188>>2];B=v[z+192>>2];y=B<<3;A[P+y>>3]=u;A[y+v[z+180>>2]>>3]=ba;A[y+v[z+184>>2]>>3]=K+C;A[y+v[z+216>>2]>>3]=fa+Y;A[y+v[z+220>>2]>>3]=d;d=-(M+E)}A[v[z+224>>2]+(B<<3)>>3]=d;s=x-M;d=s-x;u=J+(-M-d+(x-(s-d)));x=s-E;d=x-s;J=u+(-E-d+(s-(x-d)));break E}O=S+v[z+272>>2]|0;y=v[O>>2];if((y|0)<0){B=e<<3;T=A[B+v[z+284>>2]>>3];L=G-T;d=L*134217729;M=d-(d-L);K=-T;d=L-G;u=(K-d+(G-(L-d)))*$;E=$*L;G=u+E;C=G-E;s=L-M;d=$*134217729;Y=d-(d-$);N=$-Y;E=s*N-(E-M*Y-s*Y-M*N)+(u-C+(E-(G-C)));d=L*ga;L=d+G;s=L-G;C=d-s+(G-(L-s));s=A[B+v[z+168>>2]>>3];R=s-T;u=R*ga;d=R-s;s=(K-d+(s-(R-d)))*$;M=$*R;G=s+M;K=u+G;d=K-G;Z=u-d+(G-(K-d));d=R*134217729;u=d-(d-R);d=R-u;u=d*N-(M-u*Y-d*Y-u*N);d=G-M;s=Z+(u+(s-d+(M-(G-d))));Q=(y|0)!=-2&v[S+v[z+268>>2]>>2]!=-2?Q:1;C=C+E;v[v[z+208>>2]+(v[z+192>>2]<<2)>>2]=-1;y=v[z+192>>2];B=v[z+216>>2]+(y<<3)|0;v[B>>2]=0;v[B+4>>2]=0;d=T*134217729;u=d-(d-T);d=T-u;E=$*T;u=ga*T+(N*d-(E-Y*u-N*u-Y*d));s=K+s;B=v[z+176>>2]+(y<<2)|0;d=$+ga;H:{if(d>1e-12){v[B>>2]=1;P=v[z+188>>2];B=v[z+192>>2];O=B<<3;A[P+O>>3]=s;y=O+v[z+180>>2]|0;v[y>>2]=0;v[y+4>>2]=1072693248;A[O+v[z+184>>2]>>3]=L+C;A[O+v[z+220>>2]>>3]=d;d=-(E+u);break H}v[B>>2]=-1;P=v[z+188>>2];B=v[z+192>>2];O=B<<3;A[P+O>>3]=-s;y=O+v[z+180>>2]|0;v[y>>2]=0;v[y+4>>2]=1072693248;A[O+v[z+184>>2]>>3]=-(L+C);A[O+v[z+220>>2]>>3]=-d;d=E+u}A[v[z+224>>2]+(B<<3)>>3]=d;s=x-E;d=s-x;C=J+(-E-d+(x-(s-d)));x=s-u;d=x-s;J=C+(-u-d+(s-(x-d)));break E}S=v[X+244>>2];P=v[v[S>>2]+(y<<2)>>2];X=v[P+292>>2];B=ua+(X<<4)|0;Y=A[B+8>>3];fa=A[B>>3];y=v[S+8>>2];B=v[S+4>>2];ba=Ob(a,b,P);t[X+v[z+248>>2]|0]=0;P=B;B=v[O>>2]<<3;R=A[P+B>>3];da=A[y+B>>3];v[v[z+208>>2]+(v[z+192>>2]<<2)>>2]=X;d=fa*134217729;C=d-(d-fa);s=fa-C;d=ba*134217729;u=d-(d-ba);d=ba-u;E=fa*ba;C=Y*ba+(s*d-(E-C*u-s*u-C*d));T=G-da;s=T*ga;d=T-G;u=(-da-d+(G-(T-d)))*$;M=$*T;N=u+M;G=s+N;L=E+G;K=C+L;d=K-L;Z=C-d+(L-(K-d));d=L-G;E=E-d+(G-(L-d));d=G-N;ia=s-d+(N-(G-d));d=T*134217729;C=d-(d-T);s=T-C;d=$*134217729;G=d-(d-$);L=$-G;d=N-M;C=Z+(E+(ia+(s*L-(M-C*G-s*G-C*L)+(u-d+(M-(N-d))))));u=$*R;E=fa+u;s=Y+E;d=s-E;Z=s;M=Y-d+(E-(s-d));d=E-u;E=fa-d+(u-(E-d));d=R*134217729;s=d-(d-R);d=R-s;u=Z+(M+(E+(ga*R+(L*d-(u-G*s-L*s-G*d)))));d=da*134217729;s=d-(d-da);d=da-s;M=$*da;E=ga*da+(L*d-(M-G*s-L*s-G*d));B=v[z+176>>2]+(v[z+192>>2]<<2)|0;d=$+ga;I:{if(d>1e-12){v[B>>2]=1;P=v[z+188>>2];B=v[z+192>>2];y=B<<3;A[P+y>>3]=u;A[y+v[z+180>>2]>>3]=ba;A[y+v[z+184>>2]>>3]=K+C;A[y+v[z+216>>2]>>3]=fa+Y;A[y+v[z+220>>2]>>3]=d;d=-(M+E);break I}v[B>>2]=-1;P=v[z+188>>2];B=v[z+192>>2];y=B<<3;A[P+y>>3]=-u;A[y+v[z+180>>2]>>3]=ba;A[y+v[z+184>>2]>>3]=-(K+C);A[y+v[z+216>>2]>>3]=-(fa+Y);A[y+v[z+220>>2]>>3]=-d;d=M+E}A[v[z+224>>2]+(B<<3)>>3]=d;s=x-M;d=s-x;u=J+(-M-d+(x-(s-d)));x=s-E;d=x-s;J=u+(-E-d+(s-(x-d)))}y=(B<<3)+P|0;d=A[y>>3];A[y>>3]=d>=0?d:0;P=B+1|0;v[z+192>>2]=P;B=e+1|0;if((e|0)!=(U|0)){continue}break}B=U}A[z+200>>3]=J+x;B=B+1|0;if((ja|0)>(B|0)){U=v[z+248>>2];while(1){y=v[pa+(B<<2)>>2];e=y+U|0;if(w[e|0]){t[e|0]=0;e=ua+(y<<4)|0;s=A[e>>3];d=A[e+8>>3];x=Ob(a,b,v[(y<<2)+Da>>2]);v[v[z+208>>2]+(v[z+192>>2]<<2)>>2]=y;v[v[z+212>>2]+(v[z+192>>2]<<2)>>2]=-1;P=v[z+192>>2];y=P<<3;e=y+v[z+220>>2]|0;v[e>>2]=0;v[e+4>>2]=0;e=y+v[z+224>>2]|0;v[e>>2]=0;v[e+4>>2]=0;d=s+d;J=x*d;e=v[z+176>>2]+(P<<2)|0;J:{if(d>1e-12){v[e>>2]=1;e=v[z+192>>2];y=e<<3;A[y+v[z+188>>2]>>3]=d;A[y+v[z+180>>2]>>3]=x;break J}v[e>>2]=-1;e=v[z+192>>2];y=e<<3;d=-d;A[y+v[z+188>>2]>>3]=d;A[y+v[z+180>>2]>>3]=x;J=-J}y=e<<3;A[y+v[z+184>>2]>>3]=J;A[y+v[z+216>>2]>>3]=d;v[z+192>>2]=e+1}B=B+1|0;if((ja|0)!=(B|0)){continue}break}}v[r>>2]=1}Hb(v[v[a>>2]+12>>2],z+248|0,147416,5948);Hb(v[v[a>>2]+8>>2],z+260|0,147416,5949);Hb(v[v[a>>2]+8>>2],z+264|0,147416,5950);Hb(v[v[a>>2]+8>>2],z+268|0,147416,5951);Hb(v[v[a>>2]+8>>2],z+272|0,147416,5952);Hb(v[v[a>>2]+8>>2],z+276|0,147416,5953);Hb(v[v[a>>2]+8>>2],z+280|0,147416,5954);Hb(v[v[a>>2]+8>>2],z+284|0,147416,5955);Hb(v[v[a>>2]+8>>2],z+168|0,147416,5956);Hb(v[v[a>>2]+8>>2],z+240|0,147416,5957);if(!v[r>>2]){break e}v[q>>2]=(v[f+56>>2]|Q)!=0;v[z+168>>2]=0;v[z+172>>2]=0;ka=v[z+164>>2];B=6659;V=Ib(v[v[a>>2]+8>>2],v[z+192>>2],4,147416,6659);v[z+272>>2]=V;y=-1;if(!V){break d}B=6660;e=Ib(v[v[a>>2]+8>>2],v[z+192>>2],4,147416,6660);v[z+268>>2]=e;if(!e){break d}B=6661;aa=Ib(v[v[a>>2]+8>>2],v[z+192>>2],8,147416,6661);v[z+284>>2]=aa;if(!aa){break d}B=6662;ea=Ib(v[v[a>>2]+8>>2],v[z+192>>2],8,147416,6662);v[z+280>>2]=ea;if(!ea){break d}B=6663;e=Ib(v[v[a>>2]+8>>2],v[z+192>>2],8,147416,6663);v[z+276>>2]=e;if(!e){break d}B=6664;U=Ib(v[v[a>>2]+8>>2],v[z+192>>2],4,147416,6664);v[z+260>>2]=U;if(!U){break d}B=6665;ha=Ib(v[v[a>>2]+8>>2],v[z+192>>2],4,147416,6665);v[z+264>>2]=ha;if(!ha){break d}dc(ka,v[z+192>>2]<<2);P=0;v[r>>2]=0;v[z+156>>2]=0;v[z+160>>2]=0;if(v[z+192>>2]<=0){v[z+240>>2]=0;v[z+244>>2]=0;v[z+248>>2]=0;v[z+252>>2]=0;u=0;d=0;s=0;break f}J=A[v[a+4>>2]+1296>>3];u=0;e=0;X=v[z+176>>2];O=v[z+180>>2];S=v[z+188>>2];ca=0;y=0;d=0;s=0;while(1){B=y<<3;C=A[B+S>>3];K:{L:{if(J>=D(C)){v[ka+(y<<2)>>2]=-1;break L}x=A[B+O>>3];if(!(J>=x-H(J+x))){v[V+(P<<2)>>2]=y;P=P+1|0;u=u+(v[X+(y<<2)>>2]==1?C:-0);break K}Q=y<<2;B=v[Q+X>>2];if(!(!(x<.5)|(B|0)!=1)){v[Q+ka>>2]=-1;break L}M:{if((B|0)==1){if(!(x>.5)){break M}v[Q+ka>>2]=1;E=s;x=d+C;s=x-d;s=E+(C-s+(d-(x-s)));e=e+1|0;d=x;break K}if(!(x>.5)|(B|0)!=-1){break M}v[Q+ka>>2]=1;E=s;x=d-C;s=x-d;s=E+(-C-s+(d-(x-s)));e=e+1|0;d=x;break K}v[Q+ka>>2]=-1}ca=ca+1|0}y=y+1|0;if((y|0)<v[z+192>>2]){continue}break}break g}Eb(147450,B);y=-1;v[z+64>>2]=-1;Fb(276579,z- -64|0);Eb(147450,7465);v[z+48>>2]=-1;Fb(276579,z+48|0);break a}v[z+160>>2]=e;v[z+156>>2]=ca;A[z+248>>3]=d;A[z+240>>3]=s;if((P|0)<=0){break f}y=0;X=v[z+176>>2];while(1){O=y<<3;B=v[V+(y<<2)>>2];e=B<<3;A[O+ea>>3]=A[e+S>>3];x=A[e+v[z+180>>2]>>3];A[O+aa>>3]=v[X+(B<<2)>>2]==1?1-x:x;y=y+1|0;if((P|0)!=(y|0)){continue}break}}x=0;C=A[z+200>>3];u=u+(d+s-C);E=u/10;J=D(E);N:{if(!(A[v[a+4>>2]+1296>>3]<E/(J<=1?1:E==E?J:0))){break N}if(!P){u=d-C;x=u-d;x=u+(s+(-C-x+(d-(u-x))));v[r>>2]=1;break N}v[z+236>>2]=-1;v[z+232>>2]=-1;B=6831;S=z+232|0;X=z+236|0;d=0;ca=ub-16|0;ub=ca;if(U){v[S>>2]=0;v[X>>2]=0}Q=Ib(v[v[a>>2]+8>>2],P,8,147416,6042);v[ca+12>>2]=Q;O:{if(Q){P:{Q:{if((P|0)>0){y=P;if(y&1){y=y-1|0;e=y<<3;A[e+Q>>3]=A[e+aa>>3]/A[e+ea>>3]}if((P|0)!=1){while(1){e=y-1|0;O=e<<3;A[O+Q>>3]=A[O+aa>>3]/A[O+ea>>3];y=y-2|0;O=y<<3;A[O+Q>>3]=A[O+aa>>3]/A[O+ea>>3];if(e>>>0>1){continue}break}}X8(Q,aa,V,ea,(1-A[v[a+4>>2]+1296>>3])*u,P,ca+8|0);Hb(v[v[a>>2]+8>>2],ca+12|0,147416,6055);if((P|0)<=0){break Q}E=D(u);J=E<=1?1:E;x=-A[v[a+4>>2]+1296>>3];y=0;if(!U){while(1){s=d+A[ea+(y<<3)>>3];C=D(s);if(!(x>(s-u)/(C<=1?J:C>=E?C:E))){break P}Q=1;d=s;y=y+1|0;if((P|0)!=(y|0)){continue}break O}}while(1){s=d+A[ea+(y<<3)>>3];C=D(s);if(!(x>(s-u)/(C<=1?J:C>=E?C:E))){break P}v[U+(v[S>>2]<<2)>>2]=v[V+(y<<2)>>2];Q=1;v[S>>2]=v[S>>2]+1;d=s;y=y+1|0;if((P|0)!=(y|0)){continue}break}break O}X8(Q,aa,V,ea,(1-A[v[a+4>>2]+1296>>3])*u,P,ca+8|0);Hb(v[v[a>>2]+8>>2],ca+12|0,147416,6055)}y=0}Q=1;if((y|0)>=(P|0)){break O}E=D(u);x=E<=1?1:E;s=-A[v[a+4>>2]+1296>>3];while(1){J=d+A[ea+(y<<3)>>3];C=D(J);O=s>(J-u)/(C<=1?x:C>=E?C:E);if(U){e=O?S:X;v[(v[e>>2]<<2)+(O?U:ha)>>2]=v[V+(y<<2)>>2];v[e>>2]=v[e>>2]+1}d=O?J:d;y=y+1|0;if((P|0)!=(y|0)){continue}break}break O}Eb(147450,6042);Q=-1;v[ca>>2]=-1;Fb(276579,ca)}ub=ca+16|0;y=Q;if((y|0)!=1){break d}Q=v[z+176>>2];S=v[z+188>>2];J=A[z+200>>3];X=v[z+236>>2];B=0;P=v[z+232>>2];if((P|0)>0){while(1){y=U+(B<<2)|0;e=v[y>>2]<<2;O=e+ka|0;R:{if(v[e+Q>>2]==1){v[O>>2]=-1;v[z+156>>2]=v[z+156>>2]+1;break R}v[O>>2]=1;v[z+160>>2]=v[z+160>>2]+1;u=A[z+248>>3];d=A[S+(v[y>>2]<<3)>>3];x=u-d;s=x-u;A[z+240>>3]=A[z+240>>3]+(-d-s+(u-(x-s)));A[z+248>>3]=x}B=B+1|0;if((P|0)!=(B|0)){continue}break}}B=0;if((X|0)>0){while(1){y=ha+(B<<2)|0;e=v[y>>2]<<2;P=e+ka|0;S:{if(v[e+Q>>2]==1){v[P>>2]=1;v[z+160>>2]=v[z+160>>2]+1;d=A[S+(v[y>>2]<<3)>>3];u=A[z+248>>3];x=d+u;s=x-u;A[z+240>>3]=A[z+240>>3]+(d-s+(u-(x-s)));A[z+248>>3]=x;break S}v[P>>2]=-1;v[z+156>>2]=v[z+156>>2]+1}B=B+1|0;if((X|0)!=(B|0)){continue}break}}x=A[z+248>>3];s=x-J;d=s-x;A[z+168>>3]=s+(A[z+240>>3]+(-J-d+(x-(s-d))));x=A[z+168>>3];d=D(x);v[r>>2]=A[v[a+4>>2]+1296>>3]<x/(d<=1?1:x==x?d:0)}Hb(v[v[a>>2]+8>>2],z+264|0,147416,6866);Hb(v[v[a>>2]+8>>2],z+260|0,147416,6867);Hb(v[v[a>>2]+8>>2],z+276|0,147416,6868);Hb(v[v[a>>2]+8>>2],z+280|0,147416,6869);Hb(v[v[a>>2]+8>>2],z+284|0,147416,6870);Hb(v[v[a>>2]+8>>2],z+268|0,147416,6871);Hb(v[v[a>>2]+8>>2],z+272|0,147416,6872);if(!v[r>>2]){break e}W=Ib(v[v[a>>2]+12>>2],oa,8,147416,7483);v[z+284>>2]=W;if(!W){Eb(147450,7483);y=-1;v[z+112>>2]=-1;Fb(276579,z+112|0);break a}P=f;C=x;B=r;s=0;d=0;T=0;J=0;G=0;f=0;L=0;E=0;ba=0;_=ub-80|0;ub=_;e=7029;S=Ib(v[v[a>>2]+8>>2],v[z+192>>2],8,147416,7029);v[_+28>>2]=S;T:{U:{if(!S){break U}v[_+32>>2]=0;X=v[a+4>>2];x=A[X+1272>>3];A[_+64>>3]=x;v[B>>2]=0;O=v[z+192>>2];V:{if((O|0)<=0){u=x;break V}U=v[z+176>>2];u=x;e=0;while(1){W:{X:{Y:{Z:{r=e<<2;switch((v[r+U>>2]+((v[r+ka>>2]+1|0)/2|0)|0)+1|0){case 3:break X;case 1:break Y;case 0:break Z;default:break W}}x=A[v[z+188>>2]+(e<<3)>>3];if(A[X+1280>>3]<x-C){r=f+1|0;v[_+32>>2]=r;A[S+(f<<3)>>3]=x;Z=x;x=E+x;K=x-E;G=G+(Z-K+(E-(x-K)));f=r;E=x;break W}Z=x;x=d+x;K=x-d;ba=ba+(Z-K+(d-(x-K)));d=x;break W}K=A[v[z+188>>2]+(e<<3)>>3];x=s+K;M=x-s;T=T+(K-M+(s-(x-M)));s=x;break W}y=v[z+188>>2]+(e<<3)|0;x=A[y>>3];if(A[X+1280>>3]<x-C){r=f+1|0;v[_+32>>2]=r;A[S+(f<<3)>>3]=x;x=A[y>>3];u=u<=x?u:x;A[_+64>>3]=u;f=r;break W}Z=x;x=J+x;K=x-J;L=L+(Z-K+(J-(x-K)));J=x}e=e+1|0;if((O|0)!=(e|0)){continue}break}x=A[X+1272>>3]}aa=_+24|4;r=v[v[a>>2]+8>>2];_:{if(u>=x){Hb(r,aa,147416,7089);break _}e=7093;X=Ib(r,f+1|0,8,147416,7093);v[_+24>>2]=X;if(!X){break U}v[B>>2]=1;K=J+d;u=ba+K;x=u-K;Z=ba-x+(K-(u-x));x=K-J;x=u+(Z+(L+(d-x+(J-(K-x)))));A[_+72>>3]=x>=C?C:x;x=A[z+200>>3];L=s+x;u=L-s;s=T+(x-u+(s-(L-u)));A[_+40>>3]=L+s;M=E+L;K=G+M;J=d+K;u=ba+J;x=u-J;Z=d;d=J-K;Z=Z-d+(K-(J-d));d=K-M;G=G-d+(M-(K-d));d=M-L;A[_+48>>3]=u+(ba-x+(J-(u-x))+(Z+(G+(E-d+(L-(M-d))+s))));if((f|0)>=2){$:{e=f-1|0;if(f>>>0<=25){$8(S,0,e);break $}XP(S,0,e,1)}}O=X+(f<<3)|0;if((f|0)<=0){d=0}else{U=f&1;aa:{if((f|0)==1){s=0;e=0;d=0;break aa}y=f&2147483646;s=0;e=0;d=0;Q=0;while(1){r=e<<3;A[r+X>>3]=s+d;x=A[r+S>>3];J=s+x;u=J-s;r=r|8;x=d+(x-u+(s-(J-u)));A[r+X>>3]=J+x;d=A[r+S>>3];s=J+d;u=s-J;d=x+(d-u+(J-(s-u)));e=e+2|0;Q=Q+2|0;if((y|0)!=(Q|0)){continue}break}}if(U){e=e<<3;A[e+X>>3]=s+d;u=A[e+S>>3];x=s+u;J=x-s;d=d+(u-J+(s-(x-J)));s=x}d=s+d}A[O>>3]=d;s=A[_+64>>3];ba:{if((f|0)<=0){v[_+36>>2]=0;break ba}f=f-1|0;e=0;while(1){r=(e+f|0)/2|0;d=A[S+(r<<3)>>3];ca:{if(d-s<0){f=r-1|0;break ca}if(!(s-d<0)){v[_+36>>2]=r;break ba}e=r+1|0}if((e|0)<=(f|0)){continue}break}v[_+36>>2]=e}y=v[_+32>>2];e=v[_+36>>2];f=e+1|0;f=(f|0)<(y|0)?y:f;d=A[_+64>>3];r=v[_+28>>2];while(1){da:{e=e+1|0;if((y|0)<=(e|0)){e=f;break da}if(d==A[r+(e<<3)>>3]){continue}}break}A[_+56>>3]=C;v[_+36>>2]=e}if(!v[B>>2]){e=1;break T}d=A[_+40>>3];v[k>>2]=0;ea:{if(v[z+192>>2]<=0){J=0;break ea}e=v[_+32>>2];u=+(e|0);s=u*134217729;x=s-(s-u);ia=A[_+56>>3];s=ia*134217729;ra=s-(s-ia);s=u-x;sa=ia-ra;ba=ia*u;L=s*sa-(ba-x*ra-s*ra-x*sa);f=(e|0)>0?e:0;V=v[_+24>>2];ha=V+(e<<3)|0;da=A[_+72>>3];M=-da;K=A[_+64>>3];E=-K;Y=-C;S=v[z+176>>2];X=v[_+28>>2];ca=v[_+36>>2];y=0;J=0;Q=0;while(1){fa:{ga:{ha:{ia:{ja:{ea=Q<<2;switch((v[ea+S>>2]+((v[ea+ka>>2]+1|0)/2|0)|0)+1|0){case 3:break ga;case 2:break ha;case 1:break ia;case 0:break ja;default:break fa}}U=Q<<3;if(A[v[a+4>>2]+1280>>3]<A[U+v[z+188>>2]>>3]-C){r=ea+v[z+208>>2]|0;e=v[r>>2];if((e|0)!=-1){v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=Y;y=v[k>>2]+1|0;v[k>>2]=y;break fa}s=d+C;x=s-d;J=J+(C-x+(d-(s-x)));d=s;break fa}r=ea+v[z+212>>2]|0;e=v[r>>2];ka:{if((e|0)==-1){break ka}s=A[U+v[z+220>>2]>>3];if(s==0){break ka}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=-s;y=v[k>>2]+1|0;v[k>>2]=y}r=ea+v[z+208>>2]|0;e=v[r>>2];la:{if((e|0)==-1){break la}s=A[U+v[z+216>>2]>>3];if(s==0){break la}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=-s;y=v[k>>2]+1|0;v[k>>2]=y}x=A[U+v[z+224>>2]>>3];s=d+x;u=s-d;J=J+(x-u+(d-(s-u)));d=s;break fa}O=ea+v[z+208>>2]|0;U=v[O>>2];if((U|0)==-1){break fa}ta=A[v[z+188>>2]+(Q<<3)>>3];R=ta+ia;r=0;ma:{na:{oa:{pa:{qa:{while(1){e=r;if((f|0)==(e|0)){break qa}x=A[v[a+4>>2]+1280>>3];r=e+1|0;if(x<R-A[V+(r<<3)>>3]){continue}break}if((e|0)<(ca|0)){break pa}Z=+(e|0);e=e<<3;Ha=A[e+V>>3];N=A[e+X>>3];$=N-K;ga=$-da;T=ia+ga;e=T<0;G=e?0:T;fa=Ha+G;u=da+fa;s=u-fa;Ka=da-s+(fa-(u-s));s=T-ga;T=ia-s+(ga-(T-s));s=$-N;N=E-s+(N-($-s));s=ga-$;N=e?0:T+(N+(M-s+($-(ga-s))));s=fa-G;if(!(-x>u+(Ka+(N+(Ha-s+(G-(fa-s)))))-R)){break oa}G=ia*Z;break ma}if((f|0)>=(ca|0)){break na}x=A[v[a+4>>2]+1280>>3];e=f}R=+(e|0);u=A[V+(e<<3)>>3];G=ia*R;if(u-ta<=x){break ma}G=ia*R;N=ta+G;x=N-u;s=x-N;Z=x;u=-u-s+(N-(x-s));s=N-G;N=ta-s+(G-(N-s));s=R*134217729;x=s-(s-R);s=R-x;G=Z+(u+(N+(s*sa-(G-x*ra-s*ra-x*sa))));break ma}G=ia*Z;N=ta+G;u=N-Ha;s=N-G;R=ta-s+(G-(N-s));s=Z*134217729;x=s-(s-Z);s=Z-x;x=R+(s*sa-(G-x*ra-s*ra-x*sa));s=u-N;G=u+(x+(-Ha-s+(N-(u-s))));break ma}G=ta+ba;x=A[ha>>3];u=G-x;s=G-ba;Z=ta-s+(ba-(G-s))+L;s=u-G;G=u+(Z+(-x-s+(G-(u-s))))}if(G==0){break fa}v[(y<<2)+i>>2]=U;s=-G;A[W+(v[O>>2]<<3)>>3]=s;y=v[k>>2]+1|0;v[k>>2]=y;u=s;s=d-G;x=s-d;J=J+(u-x+(d-(s-x)));d=s;break fa}O=Q<<3;u=A[O+v[z+188>>2]>>3];x=u+ia;U=v[a+4>>2];r=0;while(1){ra:{e=r;if((f|0)==(e|0)){s=A[U+1280>>3];e=f;break ra}s=A[U+1280>>3];r=e+1|0;if(s<x-A[V+(r<<3)>>3]){continue}}break}x=u;u=A[V+(e<<3)>>3];if(!(-s>x-u)){break fa}N=+(0-e|0);G=ia*N;x=u+G;s=x-G;Z=x;u=u-s+(G-(x-s));s=N*134217729;x=s-(s-N);s=N-x;u=Z+(u+(s*sa-(G-x*ra-s*ra-x*sa)));r=ea+v[z+212>>2]|0;e=v[r>>2];sa:{if((e|0)==-1){break sa}s=A[O+v[z+220>>2]>>3];if(s==0){break sa}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=s;y=v[k>>2]+1|0;v[k>>2]=y}G=-u;x=A[O+v[z+216>>2]>>3];u=x-u;s=u-x;x=G-s+(x-(u-s));r=ea+v[z+208>>2]|0;e=v[r>>2];ta:{if((e|0)!=-1){s=u+x;if(s==0){s=d;break ta}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=s;y=v[k>>2]+1|0;v[k>>2]=y;s=d;break ta}G=-u;u=d-u;s=u-d;J=J+(G-s+(d-(u-s)));s=u-x;d=s-u;J=J+(-x-d+(u-(s-d)))}x=A[O+v[z+224>>2]>>3];d=s-x;u=d-s;J=J+(-x-u+(s-(d-u)));break fa}U=Q<<3;s=A[U+v[z+224>>2]>>3];r=ea+v[z+208>>2]|0;e=v[r>>2];ua:{if((e|0)==-1){break ua}T=A[U+v[z+216>>2]>>3];N=A[U+v[z+188>>2]>>3];R=N-C;if(R>A[v[a+4>>2]+1280>>3]){G=s+R;u=G-R;x=R-N;x=Y-x+(N-(R-x));s=G+(x+(s-u+(R-(G-u))));G=R-T;u=G-R;T=-(G+(x+(-T-u+(R-(G-u)))))}if(T==0){break ua}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=T;y=v[k>>2]+1|0;v[k>>2]=y}r=ea+v[z+212>>2]|0;e=v[r>>2];va:{if((e|0)==-1){break va}x=A[U+v[z+220>>2]>>3];if(x==0){break va}v[(y<<2)+i>>2]=e;A[W+(v[r>>2]<<3)>>3]=x;y=v[k>>2]+1|0;v[k>>2]=y}u=-s;s=d-s;x=s-d;J=J+(u-x+(d-(s-x)));d=s}Q=Q+1|0;if((Q|0)<v[z+192>>2]){continue}break}}Hb(v[v[a>>2]+8>>2],_+24|0,147416,7139);Hb(v[v[a>>2]+8>>2],aa,147416,7140);f=v[v[a+72>>2]+204>>2]?v[v[a+56>>2]+196>>2]:0;if(v[P+44>>2]>0){e=v[P+16>>2];r=0;while(1){ca=r<<3;s=A[ca+e>>3];y=r<<2;ha=y+v[P+12>>2]|0;wa:{if(s*+v[ha>>2]>0){break wa}aa=v[f+(v[y+v[P+8>>2]>>2]<<2)>>2];Q=v[aa+216>>2];if((Q|0)>0){x=-s;S=v[aa+188>>2];X=v[aa+180>>2];e=0;while(1){O=v[v[X+(e<<2)>>2]+248>>2];U=W+(O<<3)|0;s=A[U>>3];if(s==0){y=v[k>>2];v[k>>2]=y+1;v[(y<<2)+i>>2]=O}O=U;s=A[S+(e<<3)>>3]*x+s;o(1e-100);U=j(1)|0;V=j(0)|0;o(+s);y=j(1)|0;j(0)|0;l(0,V|0);l(1,U&2147483647|y&-2147483648);A[O>>3]=s+ +n();e=e+1|0;if((Q|0)!=(e|0)){continue}break}}x=A[aa>>3];s=A[aa+16>>3]-x;x=A[aa+8>>3]-x;if(w[aa+273|0]&4){u=A[v[a+4>>2]+1280>>3];x=I(x-u);s=H(s+u)}u=s-x;if(v[ha>>2]==1){x=s-Q5(a,aa);e=v[P+16>>2];E=-A[ca+e>>3];xa:{if(!((u>=x?x:u)*E-C>=-A[v[a+4>>2]+1280>>3])){x=d;break xa}x=d+C;u=x-d;J=J+(C-u+(d-(x-u)))}s=E*s;d=s+x;u=d-x;J=J+(s-u+(x-(d-u)));break wa}s=P5(a,aa);e=v[P+16>>2];E=A[ca+e>>3];s=s-x;ya:{if(!(-A[v[a+4>>2]+1280>>3]<=E*(s<=u?s:u)-C)){s=d;break ya}s=d+C;u=s-d;J=J+(C-u+(d-(s-u)))}x=-E*x;d=x+s;u=d-s;J=J+(x-u+(s-(d-u)))}r=r+1|0;if((r|0)<v[P+44>>2]){continue}break}}d=J+d;A[h>>3]=d;e=1;if(!(d<0)|!(d>=-A[v[a+4>>2]+1280>>3])){break T}v[h>>2]=0;v[h+4>>2]=0;break T}Eb(147450,e);e=-1;v[_+16>>2]=-1;Fb(276579,_+16|0);Eb(147450,7164);v[_>>2]=-1;Fb(276579,_)}ub=_+80|0;y=e;if((y|0)!=1){Eb(147450,7485);v[z+144>>2]=y;Fb(276579,z+144|0);break a}za:{if(!v[B>>2]){break za}Aa:{if(c){aa=v[q>>2];d=0;E=0;x=0;V=ub-80|0;ub=V;v[B>>2]=0;s=A[h>>3];v[V+48>>2]=0;v[V+52>>2]=0;A[V+56>>3]=s;c=1;Ba:{if(ER(a,A[v[a+4>>2]+1296>>3],aa,W,V+56|0,V+48|0,i,k)|!v[k>>2]){break Ba}ha=Lc(a);Q=fc(a)-Ne(a)|0;q=1;f=v[k>>2];Ca:{Da:{Ea:{Fa:{if((f|0)<=0){s=0;break Fa}r=aa?152:128;e=aa?160:136;c=0;s=0;while(1){U=v[(c<<2)+i>>2];y=v[ha+(U<<2)>>2];L=A[W+(U<<3)>>3];Ga:{if(L<0){C=A[r+y>>3];if(A[v[a+4>>2]+1272>>3]<=-C){break Ea}K=L*C;M=s+K;u=M-s;J=E+(K-u+(s-(M-u)));s=L*134217729;E=s-(s-L);u=L-E;G=C;s=C*134217729;C=s-(s-C);s=G-C;u=u*s-(K-E*C-u*C-E*s);s=M+u;C=s-M;E=J+(u-C+(M-(s-C)));u=-L;y=(Q|0)>(U|0);d=y?d>=u?d:u:d;x=y?x:u<=x?x:u;q=y?q:0;break Ga}C=A[e+y>>3];if(C>=A[v[a+4>>2]+1272>>3]){break Ea}K=L*C;M=s+K;u=M-s;J=E+(K-u+(s-(M-u)));s=L*134217729;E=s-(s-L);u=L-E;G=C;s=C*134217729;C=s-(s-C);s=G-C;u=u*s-(K-E*C-u*C-E*s);s=M+u;C=s-M;E=J+(u-C+(M-(s-C)));y=(Q|0)>(U|0);d=y?d>=L?d:L:d;x=y?x:x>=L?x:L;q=y?q:0}c=c+1|0;if((f|0)!=(c|0)){continue}break}}J=E+s;G=A[V+56>>3];M=A[V+48>>3];C=G+M;L=J-C;u=1;C=D(C);K=D(J);Ha:{if(K<=1){if(C<=1){break Ha}u=C;break Ha}u=C<=K?K:C}c=1;ca=v[a+4>>2];if(!(A[ca+1296>>3]<L/u)){break Ba}Ia:{if(q){e=Ib(v[v[a>>2]+8>>2],v[k>>2],8,147416,1265);v[V+64>>2]=e;Ja:{Ka:{if(!e){Eb(147450,1265);c=-1;v[V+16>>2]=-1;Fb(276579,V+16|0);break Ka}N=1/(d>=L?L:d);f=v[k>>2];La:{if((f|0)<=0){break La}c=0;if((f|0)!=1){y=f&2147483646;q=0;while(1){A[e+(c<<3)>>3]=N*A[W+(v[(c<<2)+i>>2]<<3)>>3];r=c|1;A[e+(r<<3)>>3]=N*A[W+(v[(r<<2)+i>>2]<<3)>>3];c=c+2|0;q=q+2|0;if((y|0)!=(q|0)){continue}break}}if(!(f&1)){break La}A[e+(c<<3)>>3]=N*A[W+(v[(c<<2)+i>>2]<<3)>>3]}c=f;f=v[a+4>>2];C=-A[f+1288>>3];u=A[f+1280>>3];x=A[f+1640>>3];Ma:{if(D(x)<0x8000000000000000){q=~~x>>>0;if(D(x)>=1){f=~~(x>0?F(H(x*2.3283064365386963e-10),4294967295):I((x-+(~~x>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break Ma}q=0;f=-2147483648}c=$w(e,c,C,u,q,f,x,V+72|0,V+68|0);if((c|0)==1){break Ja}Eb(147450,1279);v[V+32>>2]=c;Fb(276579,V+32|0)}Eb(147450,2386);v[V>>2]=c;Fb(276579,V);break Ba}Hb(v[v[a>>2]+8>>2],V- -64|0,147416,1281);O=v[V+68>>2];Na:{if(O){L=N*A[V+72>>3];A[V+72>>3]=L;d=G*134217729;J=d-(d-G);x=G-J;d=L*134217729;u=d-(d-L);s=L-u;d=G*L;J=M*L+(x*s-(d-J*u-x*u-J*s));f=v[k>>2];if((f|0)>0){U=aa?160:136;y=aa?152:128;S=v[a+4>>2];c=0;while(1){r=(c<<2)+i|0;e=v[r>>2];X=v[ha+(e<<2)>>2];q=W+(e<<3)|0;u=L*A[q>>3];s=I(A[S+1280>>3]+(u+-.5));M=s-u;x=M-s;u=-u-x+(s-(M-x));x=M+u;Oa:{if(x>1e-12){E=A[U+X>>3];if(E>=A[S+1272>>3]){break Ca}G=u*E;x=M*134217729;K=x-(x-M);u=M-K;x=E*134217729;C=x-(x-E);x=E-C;E=M*E;u=G+(u*x-(E-K*C-u*C-K*x));K=E+d;x=u+K;C=x-K;C=u-C+(K-(x-C));u=K-d;J=C+(J+(E-u+(d-(K-u))));d=x;break Oa}if(!(x<-1e-12)){break Oa}E=A[y+X>>3];if(A[S+1272>>3]<=-E){break Ca}G=u*E;x=M*134217729;K=x-(x-M);u=M-K;x=E*134217729;C=x-(x-E);x=E-C;E=M*E;u=G+(u*x-(E-K*C-u*C-K*x));K=E+d;x=u+K;C=x-K;C=u-C+(K-(x-C));u=K-d;J=C+(J+(E-u+(d-(K-u))));d=x}Pa:{if(s!=0){c=c+1|0;break Pa}e=f-1|0;v[k>>2]=e;v[r>>2]=v[(e<<2)+i>>2];s=0}A[q>>3]=s;f=v[k>>2];if((f|0)>(c|0)){continue}break}}u=0;x=J+A[v[a+4>>2]+1296>>3];s=H(d+x);C=d-s;J=C-d;x=x+(-s-J+(d-(C-J)));d=C+x;Qa:{if(!(!(d>=0)|!(C+-1+x<0))){x=s;break Qa}d=H(d);x=s+d;u=x-s;u=d-u+(s-(x-u))}A[V+56>>3]=x;A[V+48>>3]=u;Ra:{if((f|0)<=0){d=0;s=-.5;break Ra}r=aa?152:128;q=aa?160:136;c=0;s=0;E=0;d=0;while(1){e=v[(c<<2)+i>>2];y=v[ha+(e<<2)>>2];N=A[W+(e<<3)>>3];Sa:{if(N<0){L=A[r+y>>3];M=N*L;G=s+M;J=G-s;C=E+(M-J+(s-(G-J)));s=N*134217729;K=s-(s-N);J=N-K;s=L*134217729;E=s-(s-L);s=L-E;J=J*s-(M-K*E-J*E-K*s);s=G+J;E=s-G;E=C+(J-E+(G-(s-E)));J=-N;d=d>=J?d:J;break Sa}L=A[q+y>>3];M=N*L;G=s+M;J=G-s;C=E+(M-J+(s-(G-J)));s=N*134217729;K=s-(s-N);J=N-K;s=L*134217729;E=s-(s-L);s=L-E;J=J*s-(M-K*E-J*E-K*s);s=G+J;E=s-G;E=C+(J-E+(G-(s-E)));d=d>=N?d:N}c=c+1|0;if((f|0)!=(c|0)){continue}break}s=E+s+-.5}c=v[a+4>>2];J=I(s+A[c+1280>>3]);C=x+u;K=J-C;s=1;C=D(C);E=D(J);Ta:{if(E<=1){if(C<=1){break Ta}s=C;break Ta}s=C<=E?E:C}E=0;C=J;if(A[c+1296>>3]<K/s){break Na}break Ca}x=G*N;A[V+56>>3]=x;Z=M*N;u=G*134217729;K=u-(u-G);C=G-K;u=N*134217729;L=u-(u-N);M=N-L;u=Z+(C*M-(x-K*L-C*L-K*M));A[V+48>>3]=u;G=E*N;C=s*134217729;K=C-(C-s);E=s-K;C=s*N;E=G+(E*M-(C-K*L-E*L-K*M));d=d*N;f=v[k>>2];if((f|0)<=0){break Na}q=0;c=0;if(f>>>0>=4){r=f&2147483644;U=0;while(1){y=(c<<2)+i|0;e=W+(v[y>>2]<<3)|0;A[e>>3]=N*A[e>>3];e=W+(v[y+4>>2]<<3)|0;A[e>>3]=N*A[e>>3];e=W+(v[y+8>>2]<<3)|0;A[e>>3]=N*A[e>>3];e=W+(v[y+12>>2]<<3)|0;A[e>>3]=N*A[e>>3];c=c+4|0;U=U+4|0;if((r|0)!=(U|0)){continue}break}}r=f&3;if(!r){break Na}while(1){e=W+(v[(c<<2)+i>>2]<<3)|0;A[e>>3]=N*A[e>>3];c=c+1|0;q=q+1|0;if((r|0)!=(q|0)){continue}break}}U=!O;ca=v[a+4>>2];break Ia}u=d>=L?L:d;L=1/(u>=x?u:x);x=G*L;A[V+56>>3]=x;Z=M*L;u=G*134217729;C=u-(u-G);J=G-C;u=L*134217729;M=u-(u-L);K=L-M;u=Z+(J*K-(x-C*M-J*M-C*K));A[V+48>>3]=u;G=E*L;J=s*134217729;E=J-(J-s);J=s-E;C=s*L;E=G+(J*K-(C-E*M-J*M-E*K));J=C+E;d=d*L;U=1;if((f|0)<=0){break Ia}q=0;c=0;if(f>>>0>=4){r=f&2147483644;y=0;while(1){O=(c<<2)+i|0;e=W+(v[O>>2]<<3)|0;A[e>>3]=L*A[e>>3];e=W+(v[O+4>>2]<<3)|0;A[e>>3]=L*A[e>>3];e=W+(v[O+8>>2]<<3)|0;A[e>>3]=L*A[e>>3];e=W+(v[O+12>>2]<<3)|0;A[e>>3]=L*A[e>>3];c=c+4|0;y=y+4|0;if((r|0)!=(y|0)){continue}break}}r=f&3;if(!r){break Ia}while(1){e=W+(v[(c<<2)+i>>2]<<3)|0;A[e>>3]=L*A[e>>3];c=c+1|0;q=q+1|0;if((r|0)!=(q|0)){continue}break}}if(A[ca+1280>>3]<J-d-(x+u)){break Ea}aQ(i,2078,W,f);f=v[k>>2];if((f|0)<=0){s=0;break Da}r=aa?160:136;q=aa?152:128;c=0;while(1){Ua:{Va:{Wa:{y=(c<<2)+i|0;e=v[y>>2];Xa:{if((e|0)>=(Q|0)){break Xa}Ya:{Za:{O=W+(e<<3)|0;da=A[O>>3];if(!(da<0)){break Za}L=A[v[a+4>>2]+1280>>3];if(!(L>=J+da-(x+u))){break Za}K=x-C;s=K+u;d=s-K;G=u-d+(K-(s-d));d=C+K;d=G+(x-d+(-C-(K-d))-E);M=U?d:0;G=U?s:I(L+(s+d+-.5));ba=M+G;if(!(da<ba)){break Xa}T=G-da;R=A[q+v[ha+(e<<2)>>2]>>3];Y=T*R;N=x+Y;K=N-Y;s=x-K;x=u+N;d=x-N;Z=u-d+(N-(x-d));N=s+(Y-(N-K));d=T-G;G=(M+(-da-d+(G-(T-d))))*R;d=T*134217729;K=d-(d-T);s=T-K;d=R*134217729;u=d-(d-R);d=R-u;K=G+(s*d-(Y-K*u-s*u-K*d));u=Z+(N+K);if(-L>ba){J=C+Y;d=J+K;s=J-C;C=E+(Y-s+(C-(J-s)));s=d-J;E=C+(K-s+(J-(d-s)));J=d+E;break Ya}v[O>>2]=0;v[O+4>>2]=0;e=f-1|0;v[k>>2]=e;v[y>>2]=v[(e<<2)+i>>2];break Va}if(!(da>0)){break Ua}L=A[v[a+4>>2]+1280>>3];if(!(L>=J-da-(x+u))){break Ua}K=C-x;s=K-u;d=s-K;G=-u-d+(K-(s-d));d=K-C;d=G+(E+(-x-d+(C-(K-d))));M=U?d:0;G=U?s:I(L+(s+d+-.5));ba=M+G;if(!(da>ba)){break Xa}T=G-da;R=A[r+v[ha+(e<<2)>>2]>>3];Y=T*R;N=x+Y;K=N-Y;s=x-K;x=u+N;d=x-N;Z=u-d+(N-(x-d));N=s+(Y-(N-K));d=T-G;G=(M+(-da-d+(G-(T-d))))*R;d=T*134217729;K=d-(d-T);s=T-K;d=R*134217729;u=d-(d-R);d=R-u;K=G+(s*d-(Y-K*u-s*u-K*d));u=Z+(N+K);if(!(L<ba)){break Wa}J=C+Y;d=J+K;s=J-C;C=E+(Y-s+(C-(J-s)));s=d-J;E=C+(K-s+(J-(d-s)));J=d+E}C=d;A[O>>3]=ba}c=c+1|0;break Va}v[O>>2]=0;v[O+4>>2]=0;e=f-1|0;v[k>>2]=e;v[y>>2]=v[(e<<2)+i>>2]}f=v[k>>2];if((f|0)>(c|0)){continue}}break}A[V+48>>3]=u;A[V+56>>3]=x}if((f|0)<=0){s=0;break Da}r=f&1;_a:{if((f|0)==1){s=0;c=0;break _a}q=f&2147483646;s=0;c=0;f=0;while(1){e=(c<<2)+i|0;x=D(A[W+(v[e+4>>2]<<3)>>3]);d=D(A[W+(v[e>>2]<<3)>>3]);d=d>=s?d:s;s=d<=x?x:d;c=c+2|0;f=f+2|0;if((q|0)!=(f|0)){continue}break}}if(!r){break Da}d=D(A[W+(v[(c<<2)+i>>2]<<3)>>3]);s=d>=s?d:s}c=v[a+4>>2];x=A[c+1288>>3];d=s/A[c+1640>>3];v[B>>2]=!ER(a,d<=x?x:d,aa,W,V+56|0,V+48|0,i,k);A[h>>3]=A[V+56>>3]+A[V+48>>3]}c=1}ub=V+80|0;y=c;if((y|0)==1){y=v[B>>2];break Aa}Eb(147450,7493);v[z+128>>2]=y;Fb(276579,z+128|0);break a}d=A[h>>3];v[z+240>>2]=0;v[z+244>>2]=0;A[z+248>>3]=d;y=!ER(a,A[v[a+4>>2]+1288>>3],v[q>>2],W,z+248|0,z+240|0,i,k);v[B>>2]=y;A[h>>3]=A[z+248>>3]+A[z+240>>3]}k=v[k>>2];if(y){$a:{if((k|0)<=0){break $a}y=0;if((k|0)!=1){e=k&2147483646;r=0;while(1){c=W+(v[(y<<2)+i>>2]<<3)|0;A[(y<<3)+g>>3]=A[c>>3];v[c>>2]=0;v[c+4>>2]=0;c=y|1;f=W+(v[(c<<2)+i>>2]<<3)|0;A[(c<<3)+g>>3]=A[f>>3];v[f>>2]=0;v[f+4>>2]=0;y=y+2|0;r=r+2|0;if((e|0)!=(r|0)){continue}break}}if(!(k&1)){break $a}c=W+(v[(y<<2)+i>>2]<<3)|0;A[(y<<3)+g>>3]=A[c>>3];v[c>>2]=0;v[c+4>>2]=0}if(m){A[m>>3]=DR(a,b,g,A[h>>3],i,k)}if(!p){break za}v[p>>2]=v[P+52>>2]+1;break za}if((k|0)<=0){break za}B=0;y=0;if(k>>>0>=4){c=k&2147483644;f=0;while(1){e=(y<<2)+i|0;b=W+(v[e>>2]<<3)|0;v[b>>2]=0;v[b+4>>2]=0;b=W+(v[e+4>>2]<<3)|0;v[b>>2]=0;v[b+4>>2]=0;b=W+(v[e+8>>2]<<3)|0;v[b>>2]=0;v[b+4>>2]=0;b=W+(v[e+12>>2]<<3)|0;v[b>>2]=0;v[b+4>>2]=0;y=y+4|0;f=f+4|0;if((c|0)!=(f|0)){continue}break}}c=k&3;if(!c){break za}while(1){b=W+(v[(y<<2)+i>>2]<<3)|0;v[b>>2]=0;v[b+4>>2]=0;y=y+1|0;B=B+1|0;if((c|0)!=(B|0)){continue}break}}Hb(v[v[a>>2]+12>>2],z+284|0,147416,7533)}Hb(v[v[a>>2]+8>>2],z+224|0,147416,5990);Hb(v[v[a>>2]+8>>2],z+220|0,147416,5991);Hb(v[v[a>>2]+8>>2],z+216|0,147416,5992);Hb(v[v[a>>2]+8>>2],z+212|0,147416,5993);Hb(v[v[a>>2]+8>>2],z+208|0,147416,5994);Hb(v[v[a>>2]+8>>2],z+188|0,147416,5995);Hb(v[v[a>>2]+8>>2],z+184|0,147416,5996);b=z+176|0;Hb(v[v[a>>2]+8>>2],b|4,147416,5997);Hb(v[v[a>>2]+8>>2],b,147416,5998);Hb(v[v[a>>2]+8>>2],z+164|0,147416,7537);y=1;break a}Eb(147450,B);v[z+96>>2]=y;Fb(276579,z+96|0);Eb(147450,7476);v[z+80>>2]=y;Fb(276579,z+80|0)}ub=z+288|0;return y}function Peb(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,y,z,C,D,E,F,G,H){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;y=y|0;z=z|0;C=C|0;D=D|0;E=E|0;F=F|0;G=G|0;H=H|0;var I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0;z=ub-1200|0;ub=z;v[H>>2]=3;ha=v[F>>2];ea=v[r>>2];Z=v[C>>2];ga=v[q>>2];v[z+1108>>2]=0;E=v[b+328>>2];g=1;a:{if(v[E+48>>2]){break a}g=1;if(v[E+40>>2]){break a}g=1;if(v[E+20>>2]!=(sk(a)|0)){break a}g=1;if(v[v[a+24>>2]+1232>>2]!=v[E+24>>2]){break a}g=1;if(v[v[a+80>>2]+24>>2]!=v[E+28>>2]){break a}g=v[E+32>>2]!=(d|0)}v[E+48>>2]=g;ma=v[C>>2];v[E+24>>2]=v[v[a+24>>2]+1232>>2];b=v[v[a+80>>2]+24>>2];v[E+40>>2]=0;v[E+28>>2]=b;b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{if((d|0)<=0){l=-1;T=2147483647;i=2147483647;break k}l=-1;Q=(n|0)>0;S=(m|0)>0;U=(h|0)>0;b=0;i=2147483647;T=2147483647;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break k}m=v[(b<<2)+c>>2];p=v[m+16>>2];l:{m:{n:{if(Q|S|(v[p+28>>2]>0|U)){break n}if(v[r>>2]>(ea|0)){break n}if(v[v[a+24>>2]+1144>>2]<2|e){break m}}n=zo(a,m,D,C,q,z+1108|0);if((n|0)!=1){Eb(159810,8244);v[z+1104>>2]=n;Fb(276579,z+1104|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}if(w[m+86|0]&8){break l}}n=gC(a,m,q,C,F,z+1108|0);if((n|0)!=1){Eb(159810,8264);v[z+1088>>2]=n;Fb(276579,z+1088|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}g=v[m+84>>2];if(!(g&4194304)&(g&8404992)!=16384){break l}if(v[p+28>>2]>0){n=zo(a,m,D,C,q,z+1108|0);if((n|0)!=1){Eb(159810,8279);v[z+1072>>2]=n;Fb(276579,z+1072|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}if(w[m+86|0]&8){break l}}n=fC(a,m,1,0,0,0,0,q,r,C,z+1108|0);if((n|0)!=1){Eb(159810,8294);v[z+1056>>2]=n;Fb(276579,z+1056|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}g=v[m+84>>2];if(!(g&4194304)&(g&8404992)!=16384){break l}if(v[p+28>>2]>0){n=zo(a,m,D,C,q,z+1108|0);if((n|0)!=1){Eb(159810,8309);v[z+1040>>2]=n;Fb(276579,z+1040|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}if(w[m+86|0]&8){break l}}o:{if(!v[E+72>>2]){break o}g=v[a+4>>2];if(v[g+1580>>2]){g=0}else{g=v[g+1216>>2]!=0}if(!g){break o}J=0;k=ub-128|0;ub=k;n=1;h=v[m+84>>2];p:{if(!(h&8)){break p}g=v[m+16>>2];if(v[g+32>>2]==1&(h&256)!=0){break p}h=v[g+24>>2];if((h|0)<2){break p}s=x[g+36>>1]&3;if((s|0)==3){Eb(159810,1361);Fb(285833,0);n=-9;break p}I=v[g+16>>2];g=s<<2;O=v[g+365680>>2];N=v[g+365668>>2];Y=1e99;g=0;o=-1;while(1){j=v[I+(g<<2)>>2];q:{if((od(j,0)|0)<(O|0)){break q}if((nd(j,0)|0)!=(N|0)){break q}v[k+112>>2]=0;v[k+124>>2]=j;n=gj(k+124|0,k+112|0);if((n|0)!=1){Eb(159810,1386);v[k+96>>2]=n;Fb(276579,k+96|0);break p}R=A[v[k+124>>2]>>3];R=v[k+112>>2]?-R:R;n=(o|0)==-1|R<Y;Y=n?R:Y;o=n?g:o}if((od(j,0)|0)==(O|0)){J=((nd(j,0)|0)>=(N|0))+J|0}g=g+1|0;if((h|0)!=(g|0)){continue}break}r:{if(!J|(o|0)==-1){break r}P=v[q>>2];s:{if((s|0)==2){g=h;while(1){j=g;g=g-1|0;t:{if((o|0)==(g|0)){break t}J=v[I+(g<<2)>>2];if((od(J,0)|0)!=(O|0)){break t}if((nd(J,0)|0)<(N|0)){break t}v[k+112>>2]=0;v[k+124>>2]=J;n=gj(k+124|0,k+112|0);if((n|0)!=1){Eb(159810,1489);v[k+48>>2]=n;Fb(276579,k+48|0);break p}R=A[v[k+124>>2]>>3];R=v[k+112>>2]?-R:R;ia=R>0?0:1;u:{if(ia==1){if((nd(J,0)|0)>(N|0)){break t}if(!(R<Y)){break u}break t}if(R<Y){break t}}n=Qc(a,J,ia,k+120|0,k+116|0);if((n|0)!=1){Eb(159810,1514);v[k+32>>2]=n;Fb(276579,k+32|0);break p}v[q>>2]=v[q>>2]+1}if((j|0)>1){continue}break}break s}g=h;while(1){j=g;g=g-1|0;v:{if((o|0)==(g|0)){break v}J=v[I+(g<<2)>>2];if((od(J,0)|0)!=(O|0)){break v}if((nd(J,0)|0)<(N|0)){break v}v[k+112>>2]=0;v[k+124>>2]=J;n=gj(k+124|0,k+112|0);if((n|0)!=1){Eb(159810,1444);v[k+80>>2]=n;Fb(276579,k+80|0);break p}R=A[v[k+124>>2]>>3];if(!((v[k+112>>2]?-R:R)>=Y)){break v}n=Qc(a,J,0,k+120|0,k+116|0);if((n|0)!=1){Eb(159810,1454);v[k+64>>2]=n;Fb(276579,k- -64|0);break p}v[q>>2]=v[q>>2]+1}if((j|0)>1){continue}break}}g=v[q>>2];w:{x:{y:{if(!(!(t[m+85|0]&1)&(h-1|0)==(g-P|0))){if((s|0)!=2){break w}R=1;if(Y<=0){break y}break w}z:{if((s|0)!=1){break z}R=0;if(!(Y>0)){break z}if(!od(v[I+(o<<2)>>2],0)|Y<=0){break y}break x}R=1;if((s|0)!=1){break y}if(!(Y<=0)){break x}}n=Qc(a,v[I+(o<<2)>>2],R,k+120|0,k+116|0);if((n|0)!=1){Eb(159810,1542);v[k+16>>2]=n;Fb(276579,k+16|0);break p}v[q>>2]=v[q>>2]+1}n=pc(a,m);if((n|0)!=1){Eb(159810,1556);v[k>>2]=n;Fb(276579,k);break p}v[C>>2]=v[C>>2]+1;g=v[q>>2]}if((g|0)==(P|0)){break r}v[H>>2]=17}n=1}ub=k+128|0;if((n|0)!=1){Eb(159810,8324);v[z+1024>>2]=n;Fb(276579,z+1024|0);break b}g=v[m+84>>2];if(g&4194304){break o}if((g&8404992)!=16384){break l}}g=x[p+36>>1];T=(T|0)==2147483647?g&32?b:2147483647:T;if(g&8|v[p+24>>2]<2){break l}i=(i|0)==2147483647?b:i;l=b}b=b+1|0;if((d|0)!=(b|0)){continue}break}}A:{if(!(v[q>>2]>(ga|0)|v[r>>2]>(ea|0)|v[C>>2]>(Z|0))){if(v[F>>2]<=(ha|0)){break A}}v[H>>2]=17}B:{if(!v[E+68>>2]|(d|0)<=(T|0)){break B}g=v[v[a>>2]+4>>2];if(d){b=6401;n=Bf(z+1112|0,g,(d|0)<=500?500:d,619,620,621,a);if((n|0)!=1){break c}if((d|0)>0){k=0;while(1){C:{g=v[(k<<2)+c>>2];b=v[g+84>>2];D:{if(!(b&4194304)){if((b&8405248)==16384){break D}break C}if(b&256){break C}}b=sc(v[z+1112>>2],g);if(b){j=x[v[b+16>>2]+36>>1]&3;h=v[g+16>>2];if(!(!j|(j|0)==(x[h+36>>1]&3))){n=PI(a,b,0);if((n|0)!=1){b=6447;break c}v[G>>2]=v[G>>2]+1}n=bf(a,b,g);if((n|0)!=1){b=6453;break c}n=pc(a,g);if((n|0)!=1){b=6456;break c}v[C>>2]=v[C>>2]+1;if(!(w[h+36|0]&32)){break C}b=v[b+32>>2];T=(b|0)<(T|0)?b:T;break C}n=ee(v[z+1112>>2],g);if((n|0)==1){break C}b=6468;break c}k=k+1|0;if((k|0)!=(d|0)){continue}break}}cf(z+1112|0)}if(v[C>>2]<=(Z|0)){break B}v[H>>2]=17}E:{if(!(f&8)|(d|0)<2){break E}b=v[E+8>>2];g=v[E+12>>2];if((g|0)<0){b=1}else{b=!b&(g|0)<=0}F:{if(!(b|v[v[a+4>>2]+1440>>2])){if(v[E+4>>2]){break F}}if(!v[E+72>>2]){break E}b=v[a+4>>2];if(v[b+1580>>2]){b=0}else{b=v[b+1216>>2]!=0}if(!b){break E}b=v[E+8>>2];g=v[E+12>>2];if((g|0)>0){b=1}else{b=(g|0)>=0&b>>>0>=d>>>0}if(b|v[v[a+4>>2]+1444>>2]){break E}}if(v[E+72>>2]){b=v[a+4>>2];if(v[b+1580>>2]){M=0}else{M=v[b+1216>>2]!=0}}m=v[E+4>>2];o=hd(a);b=fc(a);g=Ne(a);p=Lc(a);b=b-g|0;G:{if((b|0)<=0){break G}n=b;while(1){g=n;n=n-1|0;j=p+(n<<2)|0;h=v[j>>2];H:{I:{if((g|0)<=(o|0)){break I}J:{switch(v[h+376>>2]>>>6&3){case 3:break H;case 0:break I;default:break J}}if(!(A[h+128>>3]>=0)|!(A[h+136>>3]<=1)){break H}}h=nd(h,0);k=od(v[j>>2],0);if(!((h|0)==1&(k|0)<2|(k|0)==1&(h|0)<=1)){if(!v[v[j>>2]+236>>2]|((h|0)>2|(k|0)>2)){break H}}K=K+1|0}if(g>>>0>1){continue}break}if(!K){break G}n=Ic(z+1192|0,v[v[a>>2]+4>>2],K);if((n|0)!=1){Eb(159810,5678);v[z+976>>2]=n;Fb(276579,z+976|0);break d}X=Ib(v[v[a>>2]+8>>2],d,4,159776,5681);v[z+1188>>2]=X;if(!X){Eb(159810,5681);n=-1;v[z+352>>2]=-1;Fb(276579,z+352|0);break d}dc(X,d<<2);Q=Ib(v[v[a>>2]+8>>2],b,4,159776,5684);v[z+1184>>2]=Q;if(!Q){Eb(159810,5684);n=-1;v[z+368>>2]=-1;Fb(276579,z+368|0);break d}S=Ib(v[v[a>>2]+8>>2],b,4,159776,5685);v[z+1180>>2]=S;if(!S){Eb(159810,5685);n=-1;v[z+384>>2]=-1;Fb(276579,z+384|0);break d}N=Oc(v[v[a>>2]+8>>2],c,d,4,159776,5687);v[z+1196>>2]=N;if(!N){Eb(159810,5687);n=-1;v[z+400>>2]=-1;Fb(276579,z+400|0);break d}J=(m|0)!=0;Dd(N,622,d);b=v[a+4>>2];fa=v[b+1444>>2];ca=v[b+1440>>2];n=1;p=0;k=0;while(1){K:{v[z+1160>>2]=0;L:{da=k<<2;g=v[da+N>>2];b=v[g+84>>2];if(b&524288){break L}I=v[g+16>>2];if((x[I+36>>1]&3)==2){break K}if((b&264)!=8){break L}b=zo(a,g,z+1160|0,C,q,z+1108|0);if((b|0)!=1){Eb(159810,5730);v[z+960>>2]=b;Fb(276579,z+960|0);n=b;break d}if(v[z+1108>>2]){break K}if(w[g+86|0]&8){break L}b=_x(a,g,z+1108|0,q,z+1164|0,z+1168|0);if((b|0)!=1){Eb(159810,5739);v[z+944>>2]=b;Fb(276579,z+944|0);n=b;break d}if(v[z+1108>>2]){break K}if(w[g+86|0]&8){break L}h=v[q>>2];b=gC(a,g,q,C,F,z+1108|0);if((b|0)!=1){Eb(159810,5751);v[z+928>>2]=b;Fb(276579,z+928|0);n=b;break d}if(v[z+1108>>2]){break K}if(w[g+86|0]&8){break L}if((h|0)<v[q>>2]){b=zo(a,g,z+1160|0,C,q,z+1108|0);if((b|0)!=1){Eb(159810,5762);v[z+912>>2]=b;Fb(276579,z+912|0);n=b;break d}if(w[g+86|0]&8){break L}}M:{N:{O:{P:{b=v[I+24>>2];if((b|0)<=1){if((x[I+36>>1]&3)==1){b=pc(a,g);if((b|0)==1){break O}Eb(159810,5779);v[z+416>>2]=b;Fb(276579,z+416|0);n=b;break d}if(!b){break N}b=Qc(a,v[v[I+16>>2]>>2],1,z+1176|0,z+1112|0);if((b|0)!=1){Eb(159810,5800);v[z+448>>2]=b;Fb(276579,z+448|0);h=1;n=b;break M}if(v[z+1112>>2]){v[q>>2]=v[q>>2]+1}b=pc(a,g);if((b|0)==1){break P}Eb(159810,5810);v[z+432>>2]=b;Fb(276579,z+432|0);h=1;n=b;break M}Q:{if(fa){break Q}b=(b|0)!=2;R:{if(!(b|!M)){j=x[I+36>>1];if((j&3)!=1){break R}j=v[v[I+16>>2]>>2];b=Yl(j,z+1112|0);if((b|0)!=1){Eb(159810,5828);v[z+864>>2]=b;Fb(276579,z+864|0);h=1;n=b;break M}b=nd(j,0);h=v[v[I+16>>2]+4>>2];if(!(!(A[z+1112>>3]<=0)|(b|0)!=1)){b=Le(a,j,h,1,1,1,z+1176|0,z+1156|0,z+1172|0);if((b|0)!=1){Eb(159810,5835);v[z+480>>2]=b;Fb(276579,z+480|0);h=1;n=b;break M}if(v[z+1176>>2]){break N}h=19;if(!v[z+1172>>2]){break M}v[r>>2]=v[r>>2]+1;b=pc(a,g);if((b|0)!=1){Eb(159810,5848);v[z+464>>2]=b;Fb(276579,z+464|0);h=1;n=b;break M}v[C>>2]=v[C>>2]+1;break M}b=Yl(h,z+1112|0);if((b|0)!=1){Eb(159810,5860);v[z+848>>2]=b;Fb(276579,z+848|0);h=1;n=b;break M}if((nd(h,0)|0)!=1|!(A[z+1112>>3]<=0)){break Q}b=Le(a,h,v[v[I+16>>2]>>2],1,1,1,z+1176|0,z+1156|0,z+1172|0);if((b|0)!=1){Eb(159810,5867);v[z+512>>2]=b;Fb(276579,z+512|0);h=1;n=b;break M}if(v[z+1176>>2]){break N}h=19;if(!v[z+1172>>2]){break M}v[r>>2]=v[r>>2]+1;b=pc(a,g);if((b|0)!=1){Eb(159810,5880);v[z+496>>2]=b;Fb(276579,z+496|0);h=1;n=b;break M}v[C>>2]=v[C>>2]+1;break M}if(b){break Q}j=x[I+36>>1]}if(j&3){break Q}b=v[I+16>>2];b=Le(a,v[b>>2],v[b+4>>2],1,1,1,z+1176|0,z+1112|0,z+1172|0);if((b|0)!=1){Eb(159810,5893);v[z+896>>2]=b;Fb(276579,z+896|0);h=1;n=b;break M}if(v[z+1176>>2]){break N}h=19;if(!v[z+1172>>2]){break M}v[r>>2]=v[r>>2]+1;b=pc(a,g);if((b|0)!=1){Eb(159810,5906);v[z+880>>2]=b;Fb(276579,z+880|0);h=1;n=b;break M}v[C>>2]=v[C>>2]+1;break M}if(ca|(K|0)<=(L|0)){break L}m=v[I+24>>2];if((m|0)<=0){break L}while(1){s=m;m=m-1|0;j=v[v[I+16>>2]+(m<<2)>>2];v[z+1172>>2]=0;U=nd(j,0);O=od(j,0);S:{T:{U:{b=x[I+36>>1]&3;V:{if(!(!M|(b|0)!=1|((U|0)>1|(O+U|0)>2))){h=-1;b=g;W:{switch(O|0){case 0:b=Yl(j,z+1112|0);if((b|0)!=1){Eb(159810,5951);v[z+640>>2]=b;Fb(276579,z+640|0);n=b;break d}X:{Y:{Z:{if(!(A[z+1112>>3]<-A[v[a+4>>2]+1280>>3])){b=Qc(a,j,0,z+1176|0,z+1156|0);if((b|0)!=1){break Z}v[q>>2]=v[q>>2]+1;break X}b=Vs(a,J,v[I+16>>2],v[I+24>>2],m,z+1176|0,z+1172|0);if((b|0)==1){break Y}Eb(159810,5971);v[z+608>>2]=b;Fb(276579,z+608|0);n=b;break d}Eb(159810,5960);v[z+624>>2]=b;Fb(276579,z+624|0);n=b;break d}if(v[z+1176>>2]){break U}}L=L+1|0;b=g;break V;case 1:break W;default:break V}}P=v[j+236>>2];if(!P){break V}if(!cd(v[z+1192>>2],P)){h=p+1|0;b=Ge(v[z+1192>>2],j,h);if((b|0)==1){break T}Eb(159810,6002);v[z+656>>2]=b;Fb(276579,z+656|0);n=b;break d}h=(Pc(v[z+1192>>2],P)<<2)-4|0;o=h+S|0;b=v[o>>2];h=h+Q|0;_=v[h>>2];v[h>>2]=-1;v[o>>2]=-1;h=vj(v[z+1192>>2],P);if((h|0)!=1){Eb(159810,6032);v[z+736>>2]=h;Fb(276579,z+736|0);n=h;break d}L=L+1|0;h=v[N+(_<<2)>>2];if(w[h+86|0]&8){break S}W=v[h+16>>2];o=v[W+24>>2];_:{if((o|0)>(b|0)&(P|0)==v[v[W+16>>2]+(b<<2)>>2]){break _}h=(o&o>>31)-1|0;b=o;while(1){if((b|0)<=0){b=h;break _}b=b-1|0;if((P|0)!=v[v[W+16>>2]+(b<<2)>>2]){continue}break}}aa=(v[j+376>>2]&1792)==1536;h=aa?_:k;$:{if(A[(aa?P:j)>>3]<=0){if((h|0)==(k|0)){h=k;b=Vs(a,J,v[I+16>>2],v[I+24>>2],m,z+1176|0,z+1172|0);if((b|0)==1){break $}Eb(159810,6090);v[z+704>>2]=b;Fb(276579,z+704|0);n=b;break d}b=Vs(a,J,v[W+16>>2],o,b,z+1176|0,z+1172|0);if((b|0)==1){break $}Eb(159810,6094);v[z+720>>2]=b;Fb(276579,z+720|0);n=b;break d}j=aa?k:_;if((h|0)==(k|0)){h=j;b=Vs(a,J,v[W+16>>2],o,b,z+1176|0,z+1172|0);if((b|0)==1){break $}Eb(159810,6104);v[z+672>>2]=b;Fb(276579,z+672|0);n=b;break d}h=j;b=Vs(a,J,v[I+16>>2],v[I+24>>2],m,z+1176|0,z+1172|0);if((b|0)==1){break $}Eb(159810,6108);v[z+688>>2]=b;Fb(276579,z+688|0);n=b;break d}if(!v[z+1176>>2]){b=g;break V}v[z+1108>>2]=1;break L}if(!((U|0)!=1|b|(O|0)!=1)){b=Vs(a,J,v[I+16>>2],v[I+24>>2],m,z+1176|0,z+1172|0);if((b|0)!=1){Eb(159810,6128);v[z+752>>2]=b;Fb(276579,z+752|0);n=b;break d}if(v[z+1176>>2]){v[z+1108>>2]=1;break L}L=L+1|0;h=-1;b=g;break V}h=-1;if((O|0)>2){b=g;break V}if((U|0)>2){b=g;break V}if(!v[j+236>>2]){b=g;break V}if(cd(v[z+1192>>2],j)){b=(Pc(v[z+1192>>2],j)<<2)-4|0;v[b+Q>>2]=-1;v[b+S>>2]=-1;b=vj(v[z+1192>>2],j);if((b|0)==1){break S}Eb(159810,6158);v[z+832>>2]=b;Fb(276579,z+832|0);n=b;break d}o=x[I+36>>1];b=cd(v[z+1192>>2],v[j+236>>2]);aa:{if(!(o&3)){if(b){break aa}h=p+1|0;b=Ge(v[z+1192>>2],j,h);if((b|0)==1){break T}Eb(159810,6175);v[z+768>>2]=b;Fb(276579,z+768|0);n=b;break d}if(!b){break S}}b=(Pc(v[z+1192>>2],v[j+236>>2])<<2)-4|0;o=b+S|0;P=v[o>>2];b=b+Q|0;W=v[b>>2];v[b>>2]=-1;v[o>>2]=-1;b=vj(v[z+1192>>2],v[j+236>>2]);if((b|0)!=1){Eb(159810,6217);v[z+816>>2]=b;Fb(276579,z+816|0);n=b;break d}L=L+1|0;j=W<<2;o=j+N|0;b=v[o>>2];if(w[b+86|0]&8){break S}b=v[b+16>>2];if((x[I+36>>1]&3)==1&(x[b+36>>1]&3)==1){break S}if(v[j+X>>2]){b=Vs(a,J,v[I+16>>2],v[I+24>>2],m,z+1176|0,z+1172|0);if((b|0)!=1){Eb(159810,6262);v[z+800>>2]=b;Fb(276579,z+800|0);n=b;break d}if(!v[z+1176>>2]){b=g;break V}v[z+1108>>2]=1;break L}if(w[b+36|0]&3){break S}b=Vs(a,J,v[b+16>>2],v[b+24>>2],P,z+1176|0,z+1172|0);if((b|0)!=1){Eb(159810,6288);v[z+784>>2]=b;Fb(276579,z+784|0);n=b;break d}if(v[z+1176>>2]){v[z+1108>>2]=1;break L}b=v[o>>2]}if(!v[z+1172>>2]){break S}v[r>>2]=v[r>>2]+1;ba:{g=(U|0)!=1;if(!(O|g)){if((x[I+36>>1]&3)!=1){break ba}b=Rq(a,b,m);if((b|0)!=1){Eb(159810,6311);v[z+528>>2]=b;Fb(276579,z+528|0);n=b;break d}v[F>>2]=v[F>>2]+1;break L}if(w[I+36|0]&3|((O|0)!=1|g)){break ba}g=Rq(a,b,m);if((g|0)!=1){Eb(159810,6318);v[z+592>>2]=g;Fb(276579,z+592|0);n=g;break d}v[F>>2]=v[F>>2]+1;v[X+da>>2]=1;b=PI(a,b,1);if((b|0)!=1){Eb(159810,6325);v[z+576>>2]=b;Fb(276579,z+576|0);n=b;break d}v[G>>2]=v[G>>2]+1;break L}ca:{if((h|0)>=0){b=pc(a,v[N+(h<<2)>>2]);if((b|0)==1){break ca}Eb(159810,6336);v[z+544>>2]=b;Fb(276579,z+544|0);n=b;break d}b=pc(a,b);if((b|0)==1){break ca}Eb(159810,6344);v[z+560>>2]=b;Fb(276579,z+560|0);n=b;break d}v[C>>2]=v[C>>2]+1;break L}v[z+1108>>2]=1;break L}b=p<<2;v[b+Q>>2]=k;v[b+S>>2]=m;p=h}if((s|0)>1){continue}break}break L}v[C>>2]=v[C>>2]+1;h=19;break M}v[C>>2]=v[C>>2]+1;break L}v[z+1108>>2]=1;h=17}if((h|0)==19){break L}if((h|0)==17){break K}if((n|0)==1){break G}break d}k=k+1|0;if((k|0)!=(d|0)){continue}}break}Hb(v[v[a>>2]+8>>2],z+1196|0,159776,6355);Hb(v[v[a>>2]+8>>2],z+1180|0,159776,6356);Hb(v[v[a>>2]+8>>2],z+1184|0,159776,6357);Hb(v[v[a>>2]+8>>2],z+1188|0,159776,6358);Bc(z+1192|0)}if(v[z+1108>>2]){v[H>>2]=7;break j}if(!(v[q>>2]>(ga|0)|v[r>>2]>(ea|0))&v[C>>2]<=(Z|0)){break E}v[H>>2]=17}da:{if(!v[E+44>>2]){k=f&16;break da}k=f&16;if(!k|!v[E+48>>2]){break da}n=Sla(a,c,i,l,D,C,y,z+1108|0);if((n|0)!=1){Eb(159810,8381);v[z+320>>2]=n;Fb(276579,z+320|0);break b}if(v[z+1108>>2]){v[H>>2]=7;break j}i=0;v[z+1180>>2]=0;v[z+1176>>2]=0;l=-1;ea:{fa:{ga:{if(!d){break ga}b=fc(a);if(!b){i=d;break ga}n=Ic(z+1172|0,v[v[a>>2]+4>>2],b);if((n|0)!=1){Eb(159810,5038);v[z+304>>2]=n;Fb(276579,z+304|0);break e}v[z+1144>>2]=b;f=b<<1;S=Ib(v[v[a>>2]+8>>2],f,4,159776,5042);v[z+1152>>2]=S;if(!S){Eb(159810,5042);n=-1;v[z+80>>2]=-1;Fb(276579,z+80|0);break e}g=Ib(v[v[a>>2]+8>>2],b,4,159776,5043);v[z+1148>>2]=g;if(!g){Eb(159810,5043);n=-1;v[z+96>>2]=-1;Fb(276579,z+96|0);break e}dc(g,b<<2);v[z+1140>>2]=0;K=Ib(v[v[a>>2]+8>>2],d,4,159776,5048);v[z+1112>>2]=K;if(!K){Eb(159810,5048);n=-1;v[z+112>>2]=-1;Fb(276579,z+112|0);break e}M=Ib(v[v[a>>2]+8>>2],f,4,159776,5049);v[z+1196>>2]=M;if(!M){Eb(159810,5049);n=-1;v[z+128>>2]=-1;Fb(276579,z+128|0);break e}dc(M,b<<3);b=f|1;I=Ib(v[v[a>>2]+8>>2],b,4,159776,5051);v[z+1188>>2]=I;if(!I){Eb(159810,5051);n=-1;v[z+144>>2]=-1;Fb(276579,z+144|0);break e}f=b<<2;dc(I,f);J=Ib(v[v[a>>2]+8>>2],b,4,159776,5053);v[z+1184>>2]=J;if(!J){Eb(159810,5053);n=-1;v[z+160>>2]=-1;Fb(276579,z+160|0);break e}p=Ib(v[v[a>>2]+8>>2],b,4,159776,5054);v[z+1192>>2]=p;if(!p){Eb(159810,5054);n=-1;v[z+176>>2]=-1;Fb(276579,z+176|0);break e}dc(p,f);v[z+1164>>2]=0;v[z+1160>>2]=0;v[z+1156>>2]=0;ha:{ia:{if(v[E+36>>2]|!v[E+56>>2]){break ia}f=Lc(a);l=5072;b=hd(a);f=Oc(v[v[a>>2]+8>>2],f,b,4,159776,5072);v[z+1136>>2]=f;n=-1;if(!f){break fa}l=5073;f=Ib(v[v[a>>2]+8>>2],b,4,159776,5073);v[z+1132>>2]=f;if(!f){break fa}yq(v[E+60>>2],v[z+1136>>2],0,b);l=5084;n=Kz(a,v[z+1136>>2],b,v[z+1132>>2],z+1128|0);if((n|0)!=1){break fa}l=5087;K=hc(v[v[a>>2]+8>>2],K,v[z+1128>>2]+d|0,4,159776,5087);v[z+1112>>2]=K;n=-1;if(!K){break fa}v[z+1124>>2]=0;l=5093;N=v[z+1136>>2];j=v[z+1132>>2];m=z+1164|0;h=e;n=z+1124|0;o=z+1108|0;g=0;i=ub-1072|0;ub=i;f=1;e=v[z+1128>>2];ja:{if((e|0)<2|(b|0)==(e|0)|(!b|!e)){break ja}O=e-2|0;s=b-1|0;b=0;while(1){ka:{L=j+(g<<2)|0;e=v[L>>2];if((e|0)>(b|0)){v[i+20>>2]=h;v[i+16>>2]=e;b=i+32|0;Jb(b,1024,139818,i+16|0);b=jf(a,i+1068|0,b,0,0,1,1,1,0,0,1,0,0,0,0,0);if((b|0)!=1){e=2832;break ka}f=0;la:{ma:{e=g;if((s|0)<=(g|0)){break ma}while(1){b=e<<2;if(v[L>>2]==v[b+j>>2]){b=Us(a,v[i+1068>>2],v[b+N>>2]);if((b|0)!=1){e=2839;break ka}f=f+1|0}e=e+1|0;if((s|0)!=(e|0)){continue}break}if((f|0)<2){break ma}b=mc(a,v[i+1068>>2]);if((b|0)!=1){e=2852;break ka}v[n>>2]=v[n>>2]+1;b=gC(a,v[i+1068>>2],q,C,F,o);if((b|0)!=1){e=2856;break ka}if(v[o>>2]){f=1;e=2859;b=ec(a,i+1068|0);if((b|0)==1){break ja}break ka}b=v[i+1068>>2];if(!(w[b+86|0]&8|(f-v[v[b+16>>2]+28>>2]|0)<2)){e=v[m>>2];v[(e<<2)+K>>2]=b;v[m>>2]=e+1}b=ec(a,i+1068|0);if((b|0)==1){break la}e=2876;break ka}b=ec(a,i+1068|0);if((b|0)==1){break la}e=2880;break ka}b=v[L>>2]}f=1;e=(g|0)==(O|0);g=g+1|0;if(!e){continue}break ja}break}Eb(159810,e);v[i>>2]=b;Fb(276579,i);f=b}ub=i+1072|0;n=f;if((n|0)!=1){break fa}v[C>>2]=v[C>>2]-v[z+1124>>2];Hb(v[v[a>>2]+8>>2],z+1132|0,159776,5100);Hb(v[v[a>>2]+8>>2],z+1136|0,159776,5101);l=-1;if(!v[z+1108>>2]){break ia}i=d;break ha}m=z+1164|0;i=z+1108|0;h=ub-16|0;ub=h;v[h+4>>2]=0;b=1;e=d;na:{if((e|0)<=0){break na}while(1){oa:{f=e;e=e-1|0;j=v[(e<<2)+c>>2];b=zo(a,j,h+4|0,C,q,i);if((b|0)!=1){e=2935;break oa}b=1;if(v[i>>2]){break na}pa:{if(w[j+86|0]&8){v[h+4>>2]=0;break pa}g=_x(a,j,i,q,h+12|0,h+8|0);if((g|0)!=1){e=2947;b=g;break oa}if(v[i>>2]){break na}n=v[j+16>>2];g=gC(a,j,q,C,F,i);if((g|0)!=1){e=2955;b=g;break oa}if(v[i>>2]){break na}b=v[j+84>>2];if(b&256|!(b&4194304)&(b&8404992)!=16384|(!v[n+24>>2]|(x[n+36>>1]&3)==2)){break pa}b=v[m>>2];v[(b<<2)+K>>2]=j;v[m>>2]=b+1}b=1;if(f>>>0>1){continue}break na}break}Eb(159810,e);v[h>>2]=b;Fb(276579,h)}ub=h+16|0;n=b;if((b|0)!=1){Eb(159810,5110);v[z+272>>2]=b;Fb(276579,z+272|0);break e}if(v[z+1108>>2]){i=d;break ha}m=v[z+1164>>2];if((m|0)<2){i=d;break ha}$i(K,623,m);o=K;N=z+1160|0;h=v[z+1172>>2];O=z+1156|0;i=ub-16|0;ub=i;b=m;qa:{if((b|0)<=0){s=1;break qa}while(1){f=b;b=b-1|0;P=v[v[o+(b<<2)>>2]+16>>2];e=v[P+24>>2];if((e|0)>v[O>>2]){v[O>>2]=e;e=v[P+24>>2]}ra:{if((e|0)<=0){break ra}while(1){sa:{g=e;e=g-1|0;n=v[v[P+16>>2]+(e<<2)>>2];if(!(A[n+152>>3]>.5|A[n+160>>3]<.5)){ta:{if(!cd(h,n)){j=v[N>>2];v[M+(j<<2)>>2]=n;K=j+1|0;v[N>>2]=K;s=Ge(h,n,K);if((s|0)!=1){n=3058;break sa}j=K<<2;s=j+J|0;n=(v[n+376>>2]&1792)==1536?v[n+236>>2]:n;v[s>>2]=od(n,0)+nd(n,0);n=3064;L=j+p|0;j=Ib(v[v[a>>2]+8>>2],v[s>>2],4,159776,3064);v[L>>2]=j;if(j){break ta}s=-1;break sa}K=Pc(h,n)}j=K<<2;L=j+I|0;s=v[L>>2];K=j+J|0;ua:{if((s|0)!=v[K>>2]){K=v[j+p>>2];break ua}v[K>>2]=td(a,s+1|0);n=3077;j=j+p|0;K=hc(v[v[a>>2]+8>>2],v[j>>2],v[K>>2],4,159776,3077);v[j>>2]=K;if(!K){s=-1;break sa}s=v[L>>2]}v[(s<<2)+K>>2]=b;v[L>>2]=v[L>>2]+1}if(g>>>0>1){continue}break ra}break}Eb(159810,n);v[i>>2]=s;Fb(276579,i);break qa}if((f|0)>=2){continue}break}s=1}ub=i+16|0;n=s;if((n|0)!=1){Eb(159810,5131);v[z+256>>2]=n;Fb(276579,z+256|0);break e}b=Ib(v[v[a>>2]+8>>2],v[z+1156>>2],4,159776,5135);v[z+1176>>2]=b;if(!b){Eb(159810,5135);n=-1;v[z+208>>2]=-1;Fb(276579,z+208|0);break e}b=Ib(v[v[a>>2]+8>>2],m,4,159776,5137);v[z+1180>>2]=b;if(!b){Eb(159810,5137);n=-1;v[z+224>>2]=-1;Fb(276579,z+224|0);break e}$i(M,359,v[z+1160>>2]);fa=m<<2;i=d;f=m;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break ha}p=f;f=f-1|0;M=v[o+(f<<2)>>2];b=v[M+84>>2];va:{if(!(b&4194304)&(b&8404992)!=16384){break va}n=fC(a,M,0,S,v[z+1148>>2],z+1140|0,z+1144|0,q,r,C,z+1108|0);if((n|0)!=1){a=5164;break f}if(v[z+1108>>2]){break ha}b=v[M+84>>2];if(!(b&4194304)&(b&8404992)!=16384){break va}h=v[M+16>>2];s=v[h+16>>2];j=v[h+24>>2];$i(s,359,j);u[h+36>>1]=x[h+36>>1]&65531;n=v[z+1180>>2];dc(n,fa);e=j;if((j|0)>0){while(1){g=e;e=g-1|0;b=v[(e<<2)+s>>2];wa:{if(A[b+152>>3]>.5|A[b+160>>3]<.5){break wa}K=Pc(v[z+1172>>2],b)<<2;I=v[K+v[z+1188>>2]>>2];b=I-1|0;v[z+1136>>2]=b;if((I|0)<=0){break wa}K=v[K+v[z+1192>>2]>>2];while(1){b=n+(v[K+(b<<2)>>2]<<2)|0;v[b>>2]=v[b>>2]+1;I=v[z+1136>>2];b=I-1|0;v[z+1136>>2]=b;if((I|0)>0){continue}break}}if((g|0)>1){continue}break}}b=v[h+28>>2];e=v[F>>2];v[z+1168>>2]=0;ca=v[z+1148>>2];n=Rla(a,M,f,f,o,v[z+1196>>2],z+1160|0,v[z+1172>>2],v[z+1188>>2],v[z+1184>>2],v[z+1192>>2],n,v[E+52>>2],z+1168|0,S,ca,z+1140|0,z+1144|0,q,r,F,C,z+1108|0);if((n|0)!=1){a=5218;break f}if(v[z+1108>>2]){break ha}if(!(!v[z+1168>>2]|(e|0)>=v[F>>2])){h=v[M+16>>2];s=v[h+16>>2];j=v[h+24>>2];$i(s,359,j);u[h+36>>1]=x[h+36>>1]&65531}xa:{if(v[h+32>>2]<=0&(b|0)>=v[h+28>>2]){break xa}n=fC(a,M,0,S,ca,z+1140|0,z+1144|0,q,r,C,z+1108|0);if((n|0)!=1){a=5247;break f}if(v[z+1108>>2]){break ha}b=v[M+84>>2];if(b&4194304){break xa}if((b&8404992)!=16384){break va}}v[z+1132>>2]=0;ya:{if(!(w[h+36|0]&3)){b=v[z+1160>>2]-1|0;v[z+1136>>2]=b;break ya}if(v[E+36>>2]>0){b=v[z+1160>>2]-1|0;v[z+1136>>2]=b;break ya}g=v[z+1196>>2];K=v[((j<<2)+s|0)-4>>2];I=z+1136|0;b=0;e=v[z+1160>>2];za:{if((e|0)>0){e=e-1|0;while(1){n=(b+e|0)/2|0;J=g+(n<<2)|0;Aa:{if((pz(K,v[J>>2])|0)>0){e=n-1|0;break Aa}if((pz(v[J>>2],K)|0)<=0){v[I>>2]=n;break za}b=n+1|0}if((b|0)<=(e|0)){continue}break}}v[I>>2]=b}b=v[z+1136>>2];e=b+1|0;if((e|0)>=v[z+1160>>2]){break ya}K=v[g+(e<<2)>>2];Ba:{Ca:{if((v[K+376>>2]&1792)!=1536){n=v[g+(b<<2)>>2];break Ca}n=v[g+(b<<2)>>2];if((n|0)==v[K+236>>2]){break Ba}}if((v[n+376>>2]&1792)!=1536|(K|0)!=v[n+236>>2]){break ya}}v[z+1136>>2]=e;b=e}if((j|0)>0){g=v[z+1176>>2];while(1){b=j;j=b-1|0;n=j<<2;e=v[n+s>>2];if(!(!(A[e+152>>3]<.5)|!(A[e+160>>3]>.5))){v[g+n>>2]=(v[e+292>>2]^-1)>>>31}if(b>>>0>1){continue}break}b=v[z+1136>>2]}v[z+1168>>2]=0;X=v[z+1196>>2];da=z+1160|0;e=b;L=z+1176|0;ja=v[z+1172>>2];W=v[z+1188>>2];aa=v[z+1184>>2];_=v[z+1192>>2];U=z+1156|0;N=z+1132|0;ka=z+1168|0;O=z+1108|0;Q=ub-16|0;ub=Q;s=1;g=v[M+84>>2];Da:{if(!(g&4194304)&(g&8404992)!=16384){break Da}I=v[M+16>>2];g=v[I+24>>2];if(!g){break Da}J=v[I+16>>2];Ea:{Fa:{Ga:{if((b|0)<0|(g|0)<=0){break Ga}P=g-1|0;Ha:while(1){V=X+(e<<2)|0;b=v[V>>2];if(!(A[b+152>>3]>.5|A[b+160>>3]<.5)){while(1){Ia:{n=P<<2;j=v[n+J>>2];if(A[j+160>>3]<.5){break Ia}s=1;n=v[n+v[L>>2]>>2];if(!n){j=v[j+236>>2]}K=v[j+288>>2];j=b;if(v[b+292>>2]<0){s=0;j=v[b+236>>2]}$=v[j+288>>2];if((K|0)<($|0)){break Ia}Ja:{Ka:{if((K|0)>($|0)){b=g;if((b|0)<=0){break Ka}while(1){K=b-1|0;$=K<<2;n=v[$+J>>2];if(A[n+160>>3]>.5){$=v[$+v[L>>2]>>2];if(!$){n=v[n+236>>2]}if(!r4(a,j,s,n,$)){break Ja}}n=b>>>0>1;b=K;if(n){continue}break}break Ka}if((n|0)==(s|0)){break Ja}b=g;if((b|0)>0){while(1){K=b;b=b-1|0;V=b<<2;n=v[V+J>>2];if(!(!(A[n+160>>3]>.5)|(b|0)==(P|0))){V=v[V+v[L>>2]>>2];if(!V){n=v[n+236>>2]}if(!r4(a,j,s,n,V)){break Ja}}if(K>>>0>1){continue}break}}v[N>>2]=v[N>>2]+1;b=v[I+24>>2];if((b|0)>0){while(1){j=b;b=b-1|0;n=v[(b<<2)+J>>2];if(!(!(A[n+160>>3]>.5)|(b|0)==(P|0))){s=Qc(a,n,0,O,Q+12|0);if((s|0)!=1){n=4656;break Ea}if(v[O>>2]){s=1;break Da}v[q>>2]=v[q>>2]+1}if(j>>>0>1){continue}break}}if(!(w[I+36|0]&3)){n=4677;s=Qc(a,v[(P<<2)+J>>2],1,O,Q+12|0);if((s|0)!=1){break Ea}s=1;if(v[O>>2]){break Da}v[q>>2]=v[q>>2]+1}n=4692;s=pc(a,M);if((s|0)!=1){break Ea}b=e-1|0;v[C>>2]=v[C>>2]+1;break Ga}v[N>>2]=v[N>>2]+1;j=v[V>>2];if(!(w[I+36|0]&3)){s=Qc(a,j,0,O,Q+12|0);if((s|0)!=1){n=4702;break Ea}if(v[O>>2]){s=1;break Da}v[q>>2]=v[q>>2]+1;break Ja}s=Us(a,M,j);if((s|0)!=1){n=4728;break Ea}u[I+36>>1]=x[I+36>>1]|128;s=iU(a,j,f,0,X,da,ja,W,aa,_);if((s|0)!=1){n=4737;break Ea}J=v[I+16>>2];b=v[U>>2];g=v[I+24>>2];La:{if((b|0)>=(g|0)){b=v[L>>2];break La}while(1){b=b<<1;if((g|0)>(b|0)){continue}break}v[U>>2]=b;n=4753;b=hc(v[v[a>>2]+8>>2],v[L>>2],v[U>>2],4,159776,4753);v[L>>2]=b;if(!b){break Fa}}v[((g<<2)+b|0)-4>>2]=(v[j+292>>2]^-1)>>>31;v[ka>>2]=1}b=e-1|0;if((P|0)<0){break Ga}j=(e|0)>0;e=b;if(j){continue Ha}break Ga}j=(P|0)>0;P=P-1|0;if(j){continue}break}b=e;break Ga}b=-1;j=(e|0)>0;e=e-1|0;if(j){continue}break}}e=v[M+84>>2];if(!(e&4194304)&(e&8404992)!=16384){s=1;break Da}s=1;if((b|0)<0){break Da}while(1){j=b;P=X+(b<<2)|0;n=v[P>>2];Ma:{if(A[n+152>>3]>.5|A[n+160>>3]<.5){break Ma}s=1;if(v[n+292>>2]<0){s=0;n=v[n+236>>2]}e=g;if((g|0)>0){while(1){K=e-1|0;V=K<<2;b=v[V+J>>2];if(A[b+160>>3]>.5){V=v[V+v[L>>2]>>2];if(!V){b=v[b+236>>2]}if(!wi(n,s,b,V,1)){break Ma}}b=e>>>0>1;e=K;if(b){continue}break}}b=v[P>>2];if(!(w[I+36|0]&3)){s=Qc(a,b,0,O,Q+12|0);if((s|0)!=1){n=4822;break Ea}if(v[O>>2]){s=1;break Da}v[q>>2]=v[q>>2]+1;v[N>>2]=v[N>>2]+1;break Ma}s=Us(a,M,b);if((s|0)!=1){n=4847;break Ea}u[I+36>>1]=x[I+36>>1]|128;s=iU(a,b,f,0,X,da,ja,W,aa,_);if((s|0)!=1){n=4856;break Ea}J=v[I+16>>2];e=v[U>>2];g=v[I+24>>2];Na:{if((e|0)>=(g|0)){e=v[L>>2];break Na}while(1){e=e<<1;if((g|0)>(e|0)){continue}break}v[U>>2]=e;n=4872;e=hc(v[v[a>>2]+8>>2],v[L>>2],v[U>>2],4,159776,4872);v[L>>2]=e;if(!e){break Fa}}v[((g<<2)+e|0)-4>>2]=(v[b+292>>2]^-1)>>>31;v[N>>2]=v[N>>2]+1;v[ka>>2]=1}b=j-1|0;if((j|0)>0){continue}break}s=1;break Da}s=-1}Eb(159810,n);v[Q>>2]=s;Fb(276579,Q)}ub=Q+16|0;n=s;if((n|0)!=1){a=5305;break f}if(v[z+1108>>2]){break ha}b=v[M+84>>2];Oa:{if(!(b&4194304)){if((b&8404992)!=16384){break va}if(v[z+1168>>2]){break Oa}break va}if(!v[z+1168>>2]){break va}}K=v[h+16>>2];j=v[h+24>>2];$i(K,359,j);u[h+36>>1]=x[h+36>>1]&65531;n=v[z+1180>>2];dc(n,fa);if((j|0)>0){while(1){g=j;j=g-1|0;b=v[K+(j<<2)>>2];Pa:{if(A[b+152>>3]>.5|A[b+160>>3]<.5){break Pa}b=Pc(v[z+1172>>2],b)<<2;e=v[b+W>>2];if((e|0)<=0){break Pa}s=v[b+_>>2];h=0;b=e;I=b&3;if(I){while(1){b=b-1|0;J=n+(v[s+(b<<2)>>2]<<2)|0;v[J>>2]=v[J>>2]+1;h=h+1|0;if((I|0)!=(h|0)){continue}break}}if(e>>>0<4){break Pa}e=s-8|0;h=s-4|0;while(1){I=b<<2;J=n+(v[I+h>>2]<<2)|0;v[J>>2]=v[J>>2]+1;I=n+(v[e+I>>2]<<2)|0;v[I>>2]=v[I>>2]+1;I=b-3|0;J=n+(v[s+(I<<2)>>2]<<2)|0;v[J>>2]=v[J>>2]+1;b=b-4|0;J=n+(v[s+(b<<2)>>2]<<2)|0;v[J>>2]=v[J>>2]+1;if(I>>>0>1){continue}break}}if((g|0)>1){continue}break}}v[z+1168>>2]=0;n=Rla(a,M,f,v[E+36>>2]>0?m:f,o,X,z+1160|0,v[z+1172>>2],W,aa,_,n,v[E+52>>2],z+1168|0,S,ca,z+1140|0,z+1144|0,q,r,F,C,z+1108|0);if((n|0)!=1){a=5359;break f}l=(f|0)<(l|0)?l:f;i=(i|0)<(p|0)?i:f;T=(p|0)>(T|0)?T:f;if(v[z+1108>>2]){break ha}}if((p|0)>1){continue}break}}lc(v[v[a>>2]+8>>2],z+1180|0);lc(v[v[a>>2]+8>>2],z+1176|0);b=v[z+1160>>2];if((b|0)>0){e=v[z+1192>>2];while(1){f=e+(b<<2)|0;if(v[f>>2]){lc(v[v[a>>2]+8>>2],f)}f=(b|0)>1;b=b-1|0;if(f){continue}break}}Hb(v[v[a>>2]+8>>2],z+1192|0,159776,5384);Hb(v[v[a>>2]+8>>2],z+1184|0,159776,5385);Hb(v[v[a>>2]+8>>2],z+1188|0,159776,5386);Hb(v[v[a>>2]+8>>2],z+1196|0,159776,5387);Hb(v[v[a>>2]+8>>2],z+1112|0,159776,5388);Qa:{if(v[z+1108>>2]){break Qa}h=v[z+1140>>2];if(v[v[a+4>>2]+1444>>2]|(h|0)<=0){break Qa}m=v[z+1148>>2];e=z+1108|0;f=0;b=ub-16|0;ub=b;g=1;Ra:{if((h|0)<=0){break Ra}while(1){Sa:{j=S+(f<<3)|0;g=v[j>>2];j=v[j+4>>2];Ta:{if(v[m+(f<<2)>>2]){g=Le(a,g,j,1,-1,0,e,b+8|0,b+12|0);if((g|0)==1){break Ta}f=4934;break Sa}g=Le(a,g,j,1,1,1,e,b+8|0,b+12|0);if((g|0)==1){break Ta}f=4938;break Sa}if(v[e>>2]){g=1;break Ra}if(v[b+12>>2]){v[r>>2]=v[r>>2]+1}g=1;f=f+1|0;if((h|0)!=(f|0)){continue}break Ra}break}Eb(159810,f);v[b>>2]=g;Fb(276579,b)}ub=b+16|0;n=g;if((n|0)==1){break Qa}Eb(159810,5393);v[z+192>>2]=n;Fb(276579,z+192|0);break e}Hb(v[v[a>>2]+8>>2],z+1148|0,159776,5397);Hb(v[v[a>>2]+8>>2],z+1152|0,159776,5398);Bc(z+1172|0);if(v[C>>2]>=0){break ga}v[C>>2]=0}n=1;v[E+36>>2]=v[E+36>>2]+1;if(!v[z+1108>>2]){break ea}v[H>>2]=7;break b}Eb(159810,l);v[z+288>>2]=n;Fb(276579,z+288|0);break e}b=v[q>>2];Ua:{Va:{if((ga|0)<(b|0)){break Va}n=v[r>>2];if((ea|0)<(n|0)|v[C>>2]>(Z|0)){break Va}if(v[F>>2]<=(ha|0)){break Ua}}v[H>>2]=17;n=v[r>>2];b=v[q>>2]}v[E+48>>2]=0;v[E+20>>2]=b+n}Wa:{if(!k|v[C>>2]!=(Z|0)|(!v[E+64>>2]|(d|0)<=(T|0))){break Wa}f=v[q>>2];g=T;P=g>>31;h=P;while(1){if(rc(v[a+4>>2],v[a+24>>2],0)){break Wa}s=v[(g<<2)+c>>2];b=v[s+84>>2];Xa:{Ya:{if(!(b&4194304)){if((b&8405248)==16384){break Ya}break Xa}if(b&256){break Xa}}o=v[s+16>>2];r=x[o+36>>1];v[z+1108>>2]=0;m=r;if(!(m&4)){b=v[o+24>>2];if((b|0)>=2){Dd(v[o+16>>2],65,b);m=x[o+36>>1]}m=m|4;u[o+36>>1]=m}Za:{if(m&16){p=v[o>>2];I=v[o+4>>2];break Za}p=0;I=0;v[o>>2]=0;v[o+4>>2]=0;b=v[o+24>>2];if((b|0)>0){K=b&1;F=v[o+16>>2];_a:{if((b|0)==1){k=0;break _a}M=b&2147483646;k=0;b=0;while(1){n=F+(k<<2)|0;e=B(v[v[n+4>>2]+288>>2],-1640531527)>>>26|0;j=e&31;if((e&63)>>>0>=32){e=0;J=-2147483648>>>j|0}else{e=-2147483648>>>j|0;J=((1<<j)-1&-2147483648)<<32-j}j=e;e=B(v[v[n>>2]+288>>2],-1640531527)>>>26|0;n=e&31;if((e&63)>>>0>=32){e=0;n=-2147483648>>>n|0}else{e=-2147483648>>>n|0;n=((1<<n)-1&-2147483648)<<32-n}p=n|p|J;I=e|I|j;k=k+2|0;b=b+2|0;if((M|0)!=(b|0)){continue}break}}if(K){e=B(v[v[F+(k<<2)>>2]+288>>2],-1640531527)>>>26|0;b=e&31;if((e&63)>>>0>=32){e=0;b=-2147483648>>>b|0}else{e=-2147483648>>>b|0;b=((1<<b)-1&-2147483648)<<32-b}p=b|p;I=e|I}v[o>>2]=p;v[o+4>>2]=I}m=m|16}u[o+36>>1]=m&65503;$a:{m=m&32?0:T;b=m>>31;ab:{bb:{if((b|0)>=(h|0)&g>>>0<=m>>>0|(b|0)>(h|0)){break bb}while(1){if(v[z+1108>>2]){break ab}b=v[s+84>>2];if(!(b&4194304)&(b&8404992)!=16384){break bb}F=v[(m<<2)+c>>2];b=v[F+84>>2];cb:{db:{if(!(b&4194304)){if((b&8405248)==16384){break db}break cb}if(b&256){break cb}}n=v[F+16>>2];K=x[n+36>>1];if(!(K&4)){b=v[n+24>>2];if((b|0)>=2){Dd(v[n+16>>2],65,b);K=x[n+36>>1]}K=K|4;u[n+36>>1]=K}eb:{if(K&16){j=v[n>>2];M=v[n+4>>2];break eb}j=0;M=0;v[n>>2]=0;v[n+4>>2]=0;b=v[n+24>>2];if((b|0)>0){O=b&1;N=v[n+16>>2];fb:{if((b|0)==1){k=0;break fb}Q=b&2147483646;k=0;b=0;while(1){L=N+(k<<2)|0;e=B(v[v[L+4>>2]+288>>2],-1640531527)>>>26|0;J=e&31;if((e&63)>>>0>=32){e=0;J=-2147483648>>>J|0}else{e=-2147483648>>>J|0;J=((1<<J)-1&-2147483648)<<32-J}S=J;J=B(v[v[L>>2]+288>>2],-1640531527)>>>26|0;L=J&31;if((J&63)>>>0>=32){J=0;L=-2147483648>>>L|0}else{J=-2147483648>>>L|0;L=((1<<L)-1&-2147483648)<<32-L}j=S|(L|j);M=J|M|e;k=k+2|0;b=b+2|0;if((Q|0)!=(b|0)){continue}break}}if(O){e=B(v[v[N+(k<<2)>>2]+288>>2],-1640531527)>>>26|0;b=e&31;if((e&63)>>>0>=32){J=0;b=-2147483648>>>b|0}else{J=-2147483648>>>b|0;b=((1<<b)-1&-2147483648)<<32-b}j=b|j;M=J|M}v[n>>2]=j;v[n+4>>2]=M}K=K|16;u[n+36>>1]=K}b=j|p;e=I|M;if(((b|0)!=(p|0)|(e|0)!=(I|0))&((b|0)!=(j|0)|(e|0)!=(M|0))){break cb}e=v[n+24>>2];J=v[o+24>>2];j=(e|0)<=(J|0);M=(e|0)>=(J|0);b=0;gb:{hb:{ib:{jb:{kb:{if((J|0)<=0){k=0;break kb}if((e|0)<=0){k=0;break kb}n=v[n+16>>2];L=v[o+16>>2];k=0;while(1){N=v[v[L+(k<<2)>>2]+288>>2];O=v[v[n+(b<<2)>>2]+288>>2];lb:{if((N|0)<(O|0)){if(!j){break cb}while(1){k=k+1|0;if((J|0)<=(k|0)){if((b|0)==(e|0)){break hb}break cb}if((O|0)>v[v[L+(k<<2)>>2]+288>>2]){continue}break}M=0;j=1;break lb}if((N|0)>(O|0)){if(!M){break cb}while(1){b=b+1|0;if((e|0)<=(b|0)){if((k|0)==(J|0)){break jb}break cb}if((N|0)>v[v[n+(b<<2)>>2]+288>>2]){continue}break}M=1;j=0;break lb}b=b+1|0;k=k+1|0}if((k|0)>=(J|0)){break kb}if((b|0)<(e|0)){continue}break}}k=(k|0)==(J|0)&M;if(!j){if(k){break jb}break cb}if(k&(b|0)==(e|0)){b=x[o+36>>1]&3;e=K&3;if((b|0)==(e|0)){k=6817;n=bf(a,s,F);if((n|0)!=1){break i}n=pc(a,F);if((n|0)==1){break gb}a=6498;break h}if(!b){k=6822;n=bf(a,s,F);if((n|0)!=1){break i}n=pc(a,F);if((n|0)==1){break gb}a=6498;break h}if(!e){k=6827;n=bf(a,F,s);if((n|0)!=1){break i}n=pc(a,s);if((n|0)==1){break gb}a=6498;break h}n=PI(a,s,0);if((n|0)!=1){k=6836;break g}v[G>>2]=v[G>>2]+1;k=6840;n=bf(a,s,F);if((n|0)!=1){break i}n=pc(a,F);if((n|0)==1){break gb}a=6498;break h}if(!k){break ib}}n=Qla(a,s,F,z+1108|0,q,C,G);if((n|0)==1){break cb}k=6849;break g}if((b|0)!=(e|0)){break cb}}n=Qla(a,F,s,z+1108|0,q,C,G);if((n|0)==1){break cb}k=6857;break g}v[C>>2]=v[C>>2]+1}m=m+1|0;if((g|0)!=(m|0)){continue}break}}if(!v[z+1108>>2]){break $a}}v[H>>2]=7;break j}b=r&32;e=b?0:T;j=g-e|0;e=la+(h-((e>>>0>g>>>0)+(b?0:P)|0)|0)|0;b=ba;ba=j+ba|0;e=b>>>0>ba>>>0?e+1|0:e;la=e;if(ba>>>0<200001&(e|0)<=0|(e|0)<0){break Xa}b=f+Z|0;f=v[q>>2];Z=v[C>>2];if(+(f+(Z-b|0)|0)/(+(ba>>>0)+ +(e|0)*4294967296)<1e-6){break Wa}v[H>>2]=17;ba=0;la=0}e=h;g=g+1|0;h=g?e:e+1|0;if((d|0)!=(g|0)){continue}break}}n=Sla(a,c,(d|0)>(i|0)?i:d,(d|0)>(l|0)?l:d,D,C,y,z+1108|0);if((n|0)!=1){Eb(159810,8452);v[z>>2]=n;Fb(276579,z);break b}if(v[z+1108>>2]){v[H>>2]=7}v[E+32>>2]=(d+ma|0)-v[C>>2]}n=1;break b}a=6495}Eb(159810,a);v[z+48>>2]=n;Fb(276579,z+48|0)}Eb(159810,k);v[z+32>>2]=n;Fb(276579,z+32|0);Eb(159810,8429);v[z+16>>2]=n;Fb(276579,z+16|0);break b}Eb(159810,a);v[z+240>>2]=n;Fb(276579,z+240|0)}Eb(159810,8394);v[z+64>>2]=n;Fb(276579,z- -64|0);break b}Eb(159810,8366);v[z+336>>2]=n;Fb(276579,z+336|0);break b}Eb(159810,b);v[z+1008>>2]=n;Fb(276579,z+1008|0);Eb(159810,8351);v[z+992>>2]=n;Fb(276579,z+992|0)}ub=z+1200|0;return n|0}function UJa(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,u=0,x=0,y=0,z=0,A=0,B=0,C=0;i=ub-33168|0;ub=i;o=N0(i+24808|0,-1,-1);v[111924]=0;q=Q(2354,i+24664|0,-1,-1)|0;f=v[111924];v[111924]=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{if((f|0)!=1){v[i+24648>>2]=0;v[i+24652>>2]=0;v[i+24656>>2]=0;v[i+24660>>2]=0;v[111924]=0;v[i+24644>>2]=384124;O(2257,i+24660|0,2);f=v[111924];v[111924]=0;if((f|0)==1){break j}f=v[i+24660>>2];v[f+12>>2]=0;v[f+4>>2]=0;v[i+24648>>2]=f;v[i+24652>>2]=2;v[i+24656>>2]=0;v[i+24624>>2]=0;v[i+24628>>2]=0;v[i+24632>>2]=0;v[i+24636>>2]=0;v[111924]=0;v[i+24620>>2]=384124;O(2257,i+24636|0,2);f=v[111924];v[111924]=0;if((f|0)==1){break i}f=v[i+24636>>2];v[f+12>>2]=0;v[f+4>>2]=0;v[i+24624>>2]=f;v[i+24628>>2]=2;v[i+24632>>2]=0;v[111924]=0;v[i+24600>>2]=0;v[i+24604>>2]=0;v[i+24608>>2]=0;v[i+24612>>2]=0;v[i+24596>>2]=384124;O(2257,i+24612|0,8);f=v[111924];v[111924]=0;if((f|0)==1){break h}f=v[i+24612>>2];v[f+60>>2]=0;v[f+52>>2]=0;v[f+44>>2]=0;v[f+36>>2]=0;v[f+28>>2]=0;v[f+20>>2]=0;v[f+12>>2]=0;v[f+4>>2]=0;v[i+24600>>2]=f;v[i+24604>>2]=8;v[i+24608>>2]=0;f=d;if(f){break g}v[111924]=0;v[i+24952>>2]=0;O(2355,i+24952|0,1);f=v[111924];v[111924]=0;if((f|0)==1){break f}v[111924]=0;f=ra(2356,v[i+24952>>2],1e4,-1,2,2)|0;h=v[111924];v[111924]=0;if((h|0)!=1){break g}break f}f=M()|0;break a}f=M()|0;break b}f=M()|0;break c}f=M()|0;break d}v[111924]=0;v[i+24952>>2]=f;Kp(f);f=v[111924];v[111924]=0;if((f|0)