#![no_std]
#![no_main]
#![allow(unused_unsafe)]
// #![warn(clippy::missing_errors_doc)]
// #![warn(clippy::missing_panics_doc)]
#![allow(clippy::missing_safety_doc)]
#![feature(alloc_layout_extra)]
#![feature(alloc_error_handler)]
#![feature(allocator_api)]
#![feature(assert_matches)]
#![feature(box_into_inner)]
#![feature(coerce_unsized)]
#![feature(core_intrinsics)]
#![feature(downcast_unchecked)]
#![feature(drain_filter)]
#![feature(layout_for_ptr)]
#![feature(linked_list_cursors)]
#![feature(map_try_insert)]
#![feature(new_uninit)]
#![feature(nonnull_slice_from_raw_parts)]
#![feature(once_cell)]
#![feature(pointer_byte_offsets)]
#![feature(ptr_metadata)]
#![feature(receiver_trait)]
#![feature(result_option_inspect)]
#![feature(slice_ptr_get)]
#![feature(slice_ptr_len)]
#![feature(thread_local)]
#![feature(trace_macros)]
#![feature(unsize)]
#![feature(vec_into_raw_parts)]

core::arch::global_asm!(include_str!("../entry/x86_64/entry.asm"));

pub mod cpu;
pub mod dev;
mod logger;
mod mem;
mod rxx;
pub mod sched;
mod syscall;

use core::mem::MaybeUninit;

extern crate alloc;

static mut KARGS: MaybeUninit<minfo::KernelArgs> = MaybeUninit::uninit();
#[inline]
fn kargs() -> &'static minfo::KernelArgs {
    unsafe { KARGS.assume_init_ref() }
}

#[no_mangle]
pub extern "C" fn kmain() {
    unsafe {
        KARGS.write(core::ptr::read(
            minfo::KARGS_BASE as *const minfo::KernelArgs,
        ));
        cpu::set_id(true);
        cpu::arch::reload_pls();
    }

    // SAFETY: Everything is uninitialized.
    unsafe { logger::init(log::Level::Debug) };
    log::info!("Starting the kernel");

    mem::init();
    sched::task::init_early();

    unsafe { cpu::arch::init() };

    unsafe { dev::init() };

    sched::init();

    // Test end
    log::trace!("Reaching end of kernel");
}

pub fn kmain_ap() {
    unsafe { cpu::set_id(false) };
    cpu::arch::seg::test_pls();
    log::trace!("Starting the kernel");

    unsafe { mem::space::init() };
    unsafe { cpu::arch::init_ap() };

    sched::init();

    log::trace!("Finished");
    unsafe { archop::halt_loop(Some(true)) };
}
