import React, { PropTypes } from 'react';
import { View } from 'react-native';

export const Card = ({ children }) => (
  <View style={styles.containerStyle}>
    {children}
  </View>
);

Card.propTypes = {
  children: PropTypes.node.isRequired,
};

const styles = {
  containerStyle: {
    borderWidth: 1,
    borderRadius: 2,
    borderColor: '#ddd',
    borderBottomWidth: 0,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 2,
    elevation: 1,
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 10,
  },
};

export default Card;
