# About ActionScript 3.0 Components

Adobe® Flash® Professional CS5 components are movie clips with parameters that
allow you to modify their appearance and behavior. A component can be a simple
user interface control, such as a RadioButton or a CheckBox, or it can contain
content, such as a List or DataGrid.

Components allow you to easily and quickly build robust Flash applications with
consistent behavior and appearance. Rather than creating custom buttons, combo
boxes, and lists, you can use the Flash components that implement these
controls. Simply drag them from the Components panel into your application
document. You can also easily customize the look and feel of these components to
suit your application design.

While you can do all of this without an advanced understanding of ActionScript,
you can also use ActionScript 3.0 to modify a component's behavior or implement
new behavior. Each component has a unique set of ActionScript methods,
properties, and events that make up its _application programming interface_
(API). The API allows you to create and manipulate components while the
application is running.

The API also allows you to create new, custom components of your own. You can
download components built by members of the Flash community on the Adobe
Exchange at
[Adobe Flash Professional Exchange](https://web.archive.org/web/20110811114614/http://www.adobe.com/cfusion/exchange/index.cfm?event=productHome&exc=2&loc=en_us).

The ActionScript 3.0
[component architecture](../working-with-components/component-architecture.md)
includes classes on which all components are based, skins and styles that allow
you to customize appearance, an event-handling model, focus management, an
accessibility interface, and more.

> **Note:** Adobe Flash CS5 includes ActionScript 2.0 components as well as
> ActionScript 3.0 components. You cannot mix these two sets of components. You
> must use one set or the other for a given application. Flash CS5 presents
> either ActionScript 2.0 components or ActionScript 3.0 components based on
> whether you open an ActionScript 2.0 or an ActionScript 3.0 file. When you
> create a new Flash document, you must specify either Flash File (ActionScript
> 3.0) or Flash File (ActionScript 2.0). When you open an existing document,
> Flash examines the Publish Settings to determine which set of components to
> use. For information about ActionScript 2.0 components, see Using Adobe®
> ActionScript® 2.0 Components.

For a complete list of the Flash ActionScript 3.0 components, see
[Component types](./component-types.md).

- [Benefits of using components](./benefits-of-using-components.md)
- [Component types](./component-types.md)
- [Add to and delete from a document](./add-to-or-delete-from-a-document.md)
- [Find the version of the component](./find-the-version-of-a-component.md)
- [ActionScript 3.0 event handling model](./actionscript-3.0-event-handling-model.md)
- [A simple application](./a-simple-application.md)
