# Introduction

Adobe® AIR® and Adobe® Flash® Player applications run on many platforms,
including desktops, mobile devices, tablets, and television devices. Through
code examples and use cases, this document outlines best practices for
developers deploying these applications. Topics include:

- Conserving memory

- Minimizing CPU usage

- Improving ActionScript 3.0 performance

- Increasing rendering speed

- Optimizing network interaction

- Working with audio and video

- Optimizing SQL database performance

- Benchmarking and deploying applications

Most of these optimizations apply to applications on all devices, on both the
AIR runtime and Flash Player runtime. Additions and exceptions for specific
devices are also discussed.

Some of these optimizations focus on capabilities introduced in Flash Player
10.1 and AIR 2.5. However, many of these optimizations apply to earlier AIR and
Flash Player releases, too.

- [Runtime code execution fundamentals](./runtime-code-execution-fundamentals.md)
- [Perceived performance versus actual performance](./perceived-performance-vs-actual-performance.md)
- [Target your optimizations](./target-your-optimizations.md)
