# iPhone application design considerations

The processing speed and screen size of the iPhone lend to special design and
coding considerations. However, many of the design considerations are common to
development for all applications or for mobile applications.

For more information on optimizing applications, see
[Optimizing Content for the Flash Platform](https://web.archive.org/web/20220814030226/http://help.adobe.com/en_US/as3/mobile/index.html).
This document includes many suggestions for optimizing performance of mobile
content, Flash Player content, AIR content, and ActionScript-based content in
general. Most of these suggestions also apply to AIR applications for the
iPhone.

**Important:** Many of these design considerations and optimization techniques
are essential in developing applications that run well on the iPhone.

- [Hardware acceleration](./hardware-acceleration.md)
- [Other ways to improve display object performance](./other-ways-to-improve-display-object-performance.md)
- [Information density](./information-density.md)
- [Fonts and text input](./fonts-and-text-input.md)
- [Saving application state](./saving-application-state.md)
- [Screen orientation changes](./screen-orientation-changes.md)
- [Hit targets](./hit-targets.md)
- [Memory allocation](./memory-allocation.md)
- [Drawing API](./drawing-api.md)
- [Event bubbling](./event-bubbling.md)
- [Optimizing video performance](./optimizing-video-performance.md)
- [Flex and Flash components](./flex-and-flash-components.md)
- [Reducing application file size](./reducing-application-file-size.md)
