# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import multiselectfield.db.fields
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('musictherapy', '0018_auto_20150622_1547'),
    ]

    operations = [
        migrations.CreateModel(
            name='CognitionMemorySkillsGoals',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('choice_made_verbally', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('choice_made_nonverbally', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('reaction_to_vocal_stimuli', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('reaction_to_recorded_stimuli', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('reactions_to_instrumental_stimuli', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('questions_were_answered', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('long_term_memory_retrieved', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('short_term_memory_retrieved', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('occurrences_confusion_disorientation', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('willing_participation', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('encouraged_participation', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
            ],
        ),
        migrations.CreateModel(
            name='CognitiveMemorySkillsAssessment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('total', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('cognition', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('recalls_own_name', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('recalls_name_familiar_persons', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('recalls_melody_familiar_songs', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('recalls_lyrics_familiar_songs', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('play_instruments', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('recognize_error_self_correct', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('read_song_sheet_book', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('organize_thoughts', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('remains_on_task', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('starts_stops_correct', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('maintains_synchrony_with_another', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('follow_verbal_directions', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('follow_non_verbal_directions', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('follows_hand_over_hand_directions', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('memory', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('long_term_memory', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('short_term_memory', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('oriented_time', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('oriented_place', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
            ],
        ),
        migrations.CreateModel(
            name='MotorSkillsAssessment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('total', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('mobility', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('independent_mobility', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('gait', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('endurance', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('structure_dance', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('fine_motor', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('grasped_instruments_mallets', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('demonstrated_finger_independence', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('turn_pages_of_songbook', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('gross_motor', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('demonstrated_upper_extremity_control', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('range_of_motion', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('crosses_midline', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('reach_for_instrument', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('coordination', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('demonstrates_adequate_eye_hand_coordination', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('demonstrated_adequate_body_coordination', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('limitations', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('full_hearing', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('full_sight', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
            ],
        ),
        migrations.CreateModel(
            name='MotorSkillsGoals',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('mobility_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('fine_motor_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('gross_motor_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('coordination_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
            ],
        ),
        migrations.CreateModel(
            name='MusicSkillsAssessment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('total', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('rhythm_beat', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('match_rhythm', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('keep_steady_beat', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('adapt_to_rhythmic_changes', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('melody_tonal', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('match_pitch', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('discriminates_dynamics', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('discriminates_duration', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('sing_familiar_songs', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('finish_musical_phrase', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('instrument_exploration', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('choose_instrument_play', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('interest_preference', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('response_to_music', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('choose_song_style', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('familiar_song_title_melody', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('familiar_song_title_lyrics', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
            ],
        ),
        migrations.CreateModel(
            name='MusicSkillsGoals',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('music_trivia_answered_correctly', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('song_known_without_lyrics', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('song_known_without_title', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('song_known', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('music_skill_demonstrated', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('opinions_given', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
            ],
        ),
        migrations.CreateModel(
            name='ObservableBehaviours',
            fields=[
                ('user', models.OneToOneField(primary_key=True, serialize=False, to='musictherapy.UserInfo')),
                ('observable_behaviours', multiselectfield.db.fields.MultiSelectField(blank=True, max_length=405, null=True, choices=[(b'Abusive to others (physically)', b'Abusive to others (physically)'), (b'Abusive to others (verbally)', b'Abusive to others (verbally)'), (b'Agitation', b'Agitation'), (b'Amivalent/detached', b'Ambivalent/detached'), (b'Assertive', b'Assertive'), (b'Crying', b'Crying'), (b'Delusions', b'Delusions'), (b'Depressed', b'Depressed'), (b'Disruptive', b'Disruptive'), (b'Exit Seeking', b'Exit Seeking'), (b'Fearful', b'Fearful'), (b'Flat affect', b'Flat affect'), (b'Hallucinations', b'Hallucinations'), (b'Hoarding', b'Hoarding'), (b'Impulsive', b'Impulsive'), (b'Isolative', b'Isolative'), (b'Labile', b'Labile'), (b'Manipulative', b'Manipulative'), (b'Oral Fixation', b'Oral Fixation'), (b'Passive', b'Passive'), (b'Physically Perseverative', b'Physically Perseveration'), (b'Questioning', b'Questioning'), (b'Repetitive', b'Repetitive'), (b'Resistive', b'Resistive'), (b'Restless', b'Restless'), (b'Self-abusive', b'Self-abusive'), (b'Self-stimulative', b'Self-stimulative'), (b'Sleeping', b'Sleeping'), (b'Territorial', b'Territorial'), (b'Uncooperative', b'Uncooperative'), (b'Wanders', b'Wanders'), (b'Withdrawn', b'Withdrawn')])),
                ('obsessions', models.CharField(max_length=400, null=True, blank=True)),
                ('catastrophic_reactions', models.CharField(max_length=400, null=True, blank=True)),
                ('inappropriate_verbal_behaviour', models.CharField(max_length=400, null=True, blank=True)),
                ('inappropriate_nonverbal_behaviour', models.CharField(max_length=400, null=True, blank=True)),
                ('expresses_exhibits_pain', models.CharField(max_length=400, null=True, blank=True)),
                ('comments', models.CharField(max_length=600, null=True, blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='PsychoSocialAssessment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('total', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('mood_affect', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('display_range_of_affect', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('self_esteem_confidence', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('sense_of_humour', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('user', models.ForeignKey(to='musictherapy.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='PsychoSocialGoals',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('smiled', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('frowned', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('made_negative_comments_self', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('made_positive_comments_self', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('refused_to_lead_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('lead_activity', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('left_program', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('complained_of_pain', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('destructive_behaviour_number_of_occurrences', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('displayed_depressive_symptoms', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('depressive_symptoms_number_of_occurences', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('frustration_tolerance_number_of_occurences', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('demonstrated_anxiety', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('user', models.ForeignKey(to='musictherapy.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='SocialSkillsAssessment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('total', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('interactions', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('engage_imitation', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('passing_sharing_instruments', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('converse_others', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('dancing_others', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('attending_skills', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('make_maintain_eye_contact', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('attend_task', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('sharing_turn_taking', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('pass_exchange_instrument', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('play_response_name', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('participation_group_music', models.FloatField(default=0, validators=[django.core.validators.MaxValueValidator(101)])),
                ('active_in_session', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('remain_in_group', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('accept_leadership', models.IntegerField(choices=[(3, b'High/ Always'), (0, b'None/ Never'), (2, b'Medium/ Sometimes'), (1, b'Low/ Rarely')])),
                ('user', models.ForeignKey(to='musictherapy.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='SocialSkillsGoals',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('redirection_required', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('encouragement_to_stay_required', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('participation_in_program', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('joining_of_program', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('interactions_with_staff', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('interactions_with_peers', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('therapist', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(10)])),
                ('user', models.ForeignKey(to='musictherapy.UserInfo')),
            ],
        ),
        migrations.AddField(
            model_name='musicskillsgoals',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
        migrations.AddField(
            model_name='musicskillsassessment',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
        migrations.AddField(
            model_name='motorskillsgoals',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
        migrations.AddField(
            model_name='motorskillsassessment',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
        migrations.AddField(
            model_name='cognitivememoryskillsassessment',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
        migrations.AddField(
            model_name='cognitionmemoryskillsgoals',
            name='user',
            field=models.ForeignKey(to='musictherapy.UserInfo'),
        ),
    ]
