# parser-front-matter [![NPM version](https://img.shields.io/npm/v/parser-front-matter.svg?style=flat)](https://www.npmjs.com/package/parser-front-matter) [![NPM monthly downloads](https://img.shields.io/npm/dm/parser-front-matter.svg?style=flat)](https://npmjs.org/package/parser-front-matter) [![NPM total downloads](https://img.shields.io/npm/dt/parser-front-matter.svg?style=flat)](https://npmjs.org/package/parser-front-matter) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/parser-front-matter.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/parser-front-matter)

> Front matter parsing middleware based on gray-matter.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save parser-front-matter
```

This is similar to a consolidate.js engine, but for parsing. Works with [assemble](https://github.com/assemble/assemble), [verb](https://github.com/verbose/verb), [generate](https://github.com/generate/generate), [update](https://github.com/update/update), express.js, parser-cache, or any application with similar conventions.

## Usage

```js
var parser = require('parser-front-matter');
```

## API

### [.parse](index.js#L36)

Parse front matter from the given string or the `contents` in the given `file` and callback `next(err, file)`.

If an object is passed, either `file.contents` or `file.content`
may be used (for gulp and assemble compatibility).

**Params**

* `file` **{String|Object}**: The object or string to parse.
* `options` **{Object|Function}**: or `next` callback function. Options are passed to [gray-matter](https://github.com/jonschlinkert/gray-matter).
* `next` **{Function}**: callback function.

**Example**

```js
// pass a string
parser.parse('---\ntitle: foo\n---\nbar', function (err, file) {
  //=> {content: 'bar', data: {title: 'foo'}}
});

// or an object
var file = {contents: new Buffer('---\ntitle: foo\nbar')};
parser.parse(file, function(err, res) {
  //=> {content: 'bar', data: {title: 'foo'}}
});
```

### [.parseSync](index.js#L72)

Parse front matter from the given string or the `contents` in the given `file`. If an object is passed, either `file.contents` or `file.content` may be used (for gulp and assemble compatibility).

**Params**

* `file` **{String|Object}**: The object or string to parse.
* `options` **{Object}**: passed to [gray-matter](https://github.com/jonschlinkert/gray-matter).

**Example**

```js
// pass a string
var res = parser.parseSync('---\ntitle: foo\n---\nbar');

// or an object
var file = {contents: new Buffer('---\ntitle: foo\nbar')};
var res = parser.parseSync(file);
//=> {content: 'bar', data: {title: 'foo'}}
```

## file object

Returned `file` objects have the following properties (no other properties are modified on the given file):

* `data`: data from parsed front matter
* `content`: the content string, excluding front-matter (assemble compatibility)
* `contents`: the content string as a buffer, excluding front-matter
* `orig`: the original content string with front-matter included

## About

### Related projects

* [gray-matter](https://www.npmjs.com/package/gray-matter): Parse front-matter from a string or file. Fast, reliable and easy to use. Parses YAML… [more](https://github.com/jonschlinkert/gray-matter) | [homepage](https://github.com/jonschlinkert/gray-matter "Parse front-matter from a string or file. Fast, reliable and easy to use. Parses YAML front matter by default, but also has support for YAML, JSON, TOML or Coffee Front-Matter, with options to set custom delimiters. Used by metalsmith, assemble, verb and ")
* [parser-cache](https://www.npmjs.com/package/parser-cache): Cache and load parsers, similiar to consolidate.js engines. | [homepage](https://github.com/jonschlinkert/parser-cache "Cache and load parsers, similiar to consolidate.js engines.")
* [parser-csv](https://www.npmjs.com/package/parser-csv): CSV parser, compatible with [parser-cache](https://github.com/jonschlinkert/parser-cache). | [homepage](https://github.com/jonschlinkert/parser-csv "CSV parser, compatible with [parser-cache].")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 69 | [jonschlinkert](https://github.com/jonschlinkert) |
| 2 | [doowb](https://github.com/doowb) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on July 16, 2017._