# Examples

## Builtin examples

Castor's repository provides a bunch of usage examples in the
[examples directory](https://github.com/jolicode/castor/tree/main/examples).
These examples are useful to show different Castor features in action, do not
hesitate to browse them.

As a side note, these examples also act as a full test suite for Castor to
ensure each feature works as expected.

## Real-world examples

Here is some real-world projects using Castor:

- [Castor itself](https://github.com/jolicode/castor/blob/main/castor.php): Castor itself is developed with Castor ✨
- [jolicode/docker-starter](https://github.com/jolicode/docker-starter/blob/main/castor.php): JoliCode provides a skeleton to start a web
project with PHP and Docker, encapsulated by Castor tasks
- [monsieurbiz/SyliusPluginMaker](https://github.com/monsieurbiz/SyliusPluginMaker/blob/master/castor.php):
MonsieurBiz created a CLI application based on Castor to ease the creation of
Sylius plugins
- [redirectionio/docker-example](https://github.com/redirectionio/docker-example/blob/master/.castor/castor.php):
redirection.io uses some Castor tasks to build, run and tests their Docker
examples
- [lyrixx/twig-include-syntax](https://github.com/lyrixx/twig-include-syntax/blob/main/castor.php): Lyrixx developed a CLI tool to fix Twig
include syntax
- [jolicode/JoliTypo](https://github.com/jolicode/JoliTypo/blob/main/website/castor.php): JoliCode uses some Castor tasks to compile the PHP
demo application of JoliTypo in WASM and host it on GitHub Pages
- [gist Spomky/a93cfa4d5373f865c2435bd9b0606522](https://gist.github.com/Spomky/a93cfa4d5373f865c2435bd9b0606522): Spomky proposed a Castor
task to check licenses used on a Composer project

Using Castor in one of your public projects? Feel free to contact us, we might
add it to this list.
