<p align="center">
  <img src="https://raw.githubusercontent.com/jlucansky/Swiddler/master/Images/logo.png" height="192">
</p>

# TCP/UDP debugging tool

![](https://raw.githubusercontent.com/jlucansky/Swiddler/master/Images/screen.gif)

# Features
### Capture & Inspect
- Capture virtually unlimited amount of data
- Export captured raw data (drag selection to file)

### Create TCP/UDP server
- Bind to any local IP
- Supported IPv4/IPv6 dual stack
- Allow reuse same address & port

### Connect to remote host
- Specify source address
- Broadcast or join multicast groups

### Rewrite traffic
- Replace matched content
- Match arbitrary data in binary mode

### SSL/TLS client & server
- Supported SSL/3.0, TLS/1.0, TLS/1.1, TLS/1.2
- Send custom Server Name Indication (SNI)
- Create certificates and self-signed CA
- Auto generate server certificates based on SNI
- Export negotiated certificate chain
- Observe SSL/TLS client & server hello messages
- Request or send client certificate


# Minimum requirements
- .NET Framework 4.5
- Windows 7 SP1 or higher
- Windows Server 2008 SP2 or higher

# License
This project is made available under the Apache License 2.0

See [LICENSE](LICENSE) for details.
