# Contributing

[Light Saver](https://github.com/jkuatdsc/light-saver) is [MIT](LICENSE) licensed and accepts contributions via GitHub pull requests. This document outlines some of the conventions on development workflow, commit message formatting, contact points, and other resources to make it easier to get your contribution accepted.

## Getting Started

- Fork the repository on GitHub.
- **For Free email list** : Welcome contributor to add free email services to list, just form and edit '\src\freeEmailService.json' file only and drop a pull request.
- **For helper libraries** : Create/Improve helpers libraries and make sure to add sample and drop a pull request.

## Contribution Flow

This is a outline of what a contributor's workflow looks like:

- Create a separate branch from `master` branch to base your work.
- Make commits of logical units.
- Make sure your commit messages are in the proper format (see below).
- Push your changes to a topic branch in your fork of the repository.
- Make sure to proofread the content before submitting.
- Submit a pull request to the original repository.

#### Commit Messages

Please follow the below format while writing commit messages:

```
  title: One line description about your change
  <Blank Line>
  description: An optional description of your changes.
```

Thanks for your contributions!

## Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.

### Our Responsibilities

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.
