export const icons = {
	alert: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSIxNC4yIiB3aWR0aD0iNDIuNiIgaGVpZ2h0PSIyMC42IiByeD0iNC44IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+PGNpcmNsZSBjeD0iMTIiIGN5PSIyNCIgcj0iNiIgZmlsbD0iI0ZCRURDOCIvPjxjaXJjbGUgY3g9IjEyIiBjeT0iMjgiIHI9IjEiIGZpbGw9IiNDMDg4MTEiLz48cGF0aCBkPSJNMTIgMjB2NiIgc3Ryb2tlPSIjQzA4ODExIiBzdHJva2Utd2lkdGg9IjIiLz48cGF0aCBzdHJva2U9IiM4RThFOEUiIHN0cm9rZS13aWR0aD0iMiIgZD0iTTIyIDIyaDExIi8+PHBhdGggc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjIiIGQ9Ik0yMiAyN2gxOSIvPjwvc3ZnPgo=',
	button: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNi41IiB5PSIxNS41IiB3aWR0aD0iMzYiIGhlaWdodD0iMTciIHJ4PSIzLjUiIGZpbGw9IiM0QUExRUQiIHN0cm9rZT0iIzRBQTFFRCIvPjxwYXRoIGQ9Im0xMi42ODQgMjcgLjQzMi0xLjMyN2gyLjFMMTUuNjQ3IDI3aDEuMzE5bC0yLjAwNi01LjgxOGgtMS41ODVMMTEuMzY2IDI3aDEuMzE4Wm0uNzQ1LTIuMjg3LjcxNi0yLjIwMmguMDQ1bC43MTYgMi4yMDJoLTEuNDc3Wm01Ljk4MyAyLjM3MmMxLjE2MiAwIDEuODkyLS42ODIgMS45NDgtMS42ODRoLTEuMTQyYy0uMDcuNDY1LS4zNzcuNzI3LS43OTIuNzI3LS41NjYgMC0uOTMyLS40NzUtLjkzMi0xLjMxIDAtLjgyNC4zNy0xLjI5NS45MzItMS4yOTUuNDQzIDAgLjcyNy4yOTIuNzkyLjcyN2gxLjE0MmMtLjA1LTEuMDA5LS44MTUtMS42Ny0xLjk1NC0xLjY3LTEuMzI0IDAtMi4xNDIuOTE3LTIuMTQyIDIuMjU1IDAgMS4zMjcuODA0IDIuMjUgMi4xNDggMi4yNVptNS4wNDQtNC40NDloLS44MnYtMS4wNDVoLTEuMjF2MS4wNDVoLS41OTh2LjkxaC41OTd2Mi4yNzJjLS4wMDYuODU1LjU3NyAxLjI3OSAxLjQ1NSAxLjI0Mi4zMTItLjAxMi41MzQtLjA3NC42NTYtLjExNGwtLjE5LS45Yy0uMDYuMDEtLjE4OC4wNC0uMzAyLjA0LS4yNDEgMC0uNDA5LS4wOTItLjQwOS0uNDI3di0yLjExM2guODIxdi0uOTFaTTI1LjI0NSAyN2gxLjIxdi00LjM2NGgtMS4yMVYyN1ptLjYwOC00LjkyNmMuMzYgMCAuNjU2LS4yNzYuNjU2LS42MTQgMC0uMzM1LS4yOTYtLjYxLS42NTYtLjYxLS4zNTggMC0uNjU0LjI3NS0uNjU0LjYxIDAgLjMzOC4yOTYuNjE0LjY1NC42MTRabTMuNTQzIDUuMDExYzEuMzI0IDAgMi4xNDgtLjkwNiAyLjE0OC0yLjI1IDAtMS4zNTItLjgyNC0yLjI1Ni0yLjE0OC0yLjI1Ni0xLjMyNCAwLTIuMTQ4LjkwNC0yLjE0OCAyLjI1NiAwIDEuMzQ0LjgyNCAyLjI1IDIuMTQ4IDIuMjVabS4wMDYtLjkzN2MtLjYxMSAwLS45MjQtLjU2LS45MjQtMS4zMjEgMC0uNzYyLjMxMy0xLjMyNC45MjQtMS4zMjQuNiAwIC45MTIuNTYyLjkxMiAxLjMyNCAwIC43NjEtLjMxMyAxLjMyLS45MTIgMS4zMlptNC4xMzktMS42N2MuMDAzLS41NjMuMzM4LS44OTMuODI3LS44OTMuNDg1IDAgLjc3OC4zMTguNzc1Ljg1MlYyN2gxLjIxdi0yLjc3OGMwLTEuMDE4LS41OTYtMS42NDMtMS41MDUtMS42NDMtLjY0OCAwLTEuMTE3LjMxOS0xLjMxMy44MjdoLS4wNTF2LS43N2gtMS4xNTNWMjdoMS4yMXYtMi41MjNaIiBmaWxsPSIjZmZmIi8+PC9zdmc+Cg==',
	batch: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSIzLjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjQxLjYiIHJ4PSI0LjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNOCAxMHY1YTIgMiAwIDAgMCAyIDJoMjhhMiAyIDAgMCAwIDItMnYtNWEyIDIgMCAwIDAtMi0ySDEwYTIgMiAwIDAgMC0yIDJaTTggMjJ2NWEyIDIgMCAwIDAgMiAyaDI4YTIgMiAwIDAgMCAyLTJ2LTVhMiAyIDAgMCAwLTItMkgxMGEyIDIgMCAwIDAtMiAyWk04IDM0djVhMiAyIDAgMCAwIDIgMmgyOGEyIDIgMCAwIDAgMi0ydi01YTIgMiAwIDAgMC0yLTJIMTBhMiAyIDAgMCAwLTIgMloiIGZpbGw9IiNFRUUiLz48L3N2Zz4K',
	cascader: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgY2xpcC1wYXRoPSJ1cmwoI2EpIj48cmVjdCB4PSIuMiIgeT0iMy4yIiB3aWR0aD0iNDcuNiIgaGVpZ2h0PSIxNC42IiByeD0iMy44IiBmaWxsPSIjRkNGQ0ZDIiBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PHJlY3QgeD0iNCIgeT0iMTUiIHdpZHRoPSI0MyIgaGVpZ2h0PSIyOSIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNNyAxMWgyTTIwIDExaDkiLz48cGF0aCBzdHJva2U9IiNCRUJFQkUiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0xNyA5LjEzMSAxMy4xMzEgMTMiLz48cGF0aCBkPSJNMjQgMzRoMjJ2N2EyIDIgMCAwIDEtMiAySDI0di05WiIgZmlsbD0iI0VDRjVGRCIvPjxwYXRoIHN0cm9rZT0iIzc1NzU3NSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0xNyAyMGgxOU0yNiAyOWgxNU0yOCAzOWg4Ii8+PHBhdGggZD0ibTE2IDI4IDIuNSAyIDIuNS0yTTggMTlsMi41IDIgMi41LTJNMzcgMTBsMi41IDIgMi41LTIiIHN0cm9rZT0iI0JFQkVCRSIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIGQ9Im00MCAzOS4zNjEgMS4zNjEgMS4xMzRMNDMuNjMgMzgiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjwvZz48ZGVmcz48Y2xpcFBhdGggaWQ9ImEiPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik0wIDBoNDh2NDhIMHoiLz48L2NsaXBQYXRoPjwvZGVmcz48L3N2Zz4K',
	checkbox: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0ibTguMTY2IDEzLjc5MSAxLjc1IDEuNDU4IDIuOTE3LTMuMjA4TTguMTY2IDM0LjQ1OGwxLjc1IDEuNDU4IDIuOTE3LTMuMjA4IiBzdHJva2U9IiNGNUY1RjUiIHN0cm9rZS13aWR0aD0iMS4yIi8+PHJlY3QgeD0iOS41IiB5PSI2LjUiIHdpZHRoPSI5IiBoZWlnaHQ9IjkiIHJ4PSIyLjUiIGZpbGw9IiMzQzkyREMiIHN0cm9rZT0iIzNDOTJEQyIvPjxyZWN0IHg9IjkuNSIgeT0iMzIuNSIgd2lkdGg9IjkiIGhlaWdodD0iOSIgcng9IjIuNSIgZmlsbD0iIzNDOTJEQyIgc3Ryb2tlPSIjM0M5MkRDIi8+PHBhdGggZD0ibTEyIDExLjM2MSAxLjM2MSAxLjEzNEwxNS42MyAxME0xMiAzNy4zNjFsMS4zNjEgMS4xMzRMMTUuNjMgMzYiIHN0cm9rZT0iI2ZmZiIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yMyAxMC42NjZoMTRNMjMgMzYuNjY2aDE0Ii8+PHJlY3QgeD0iOS41IiB5PSIxOS41IiB3aWR0aD0iOSIgaGVpZ2h0PSI5IiByeD0iMi41IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNERURFREUiLz48cGF0aCBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjMgMjMuMzM0aDExIi8+PC9zdmc+Cg==',
	controller: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjMzLjYiIHJ4PSI0LjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42IiBkPSJNNCAxNi4yaDQwIi8+PHJlY3QgeD0iNyIgeT0iMTkiIHdpZHRoPSIzNCIgaGVpZ2h0PSIxOCIgcng9IjIiIGZpbGw9IiNFRUUiLz48L3N2Zz4K',
	date: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE1LjQgMjIuNUg2LjZ2NC43MzdjMCAuMjI4LjE4NS40MTMuNDE0LjQxM2g3Ljk3MmEuNDE0LjQxNCAwIDAgMCAuNDE0LS40MTNWMjIuNVptLTguMzg3LTMuNzVoNy45NzRjMS4xMTIgMCAyLjAxMy45MDEgMi4wMTMgMi4wMTN2Ni40NzRhMi4wMTQgMi4wMTQgMCAwIDEtMi4wMTQgMi4wMTNINy4wMTRBMi4wMTQgMi4wMTQgMCAwIDEgNSAyNy4yMzd2LTYuNDc0YzAtMS4xMTIuOTAxLTIuMDEzIDIuMDEzLTIuMDEzWm0yLjM1MyA1LjM3NWEuODc1Ljg3NSAwIDEgMS0xLjc1IDAgLjg3NS44NzUgMCAwIDEgMS43NSAwWk04LjQ5IDI3LjI1YS44NzUuODc1IDAgMSAwIDAtMS43NS44NzUuODc1IDAgMCAwIDAgMS43NVptMy4zODQtMy4xMjVhLjg3NS44NzUgMCAxIDEtMS43NSAwIC44NzUuODc1IDAgMCAxIDEuNzUgMFpNMTEgMjcuMjVhLjg3NS44NzUgMCAxIDAgMC0xLjc1Ljg3NS44NzUgMCAwIDAgMCAxLjc1Wm0zLjU1LTMuMTI1YS44NzUuODc1IDAgMSAxLTEuNzUgMCAuODc1Ljg3NSAwIDAgMSAxLjc1IDBaIiBmaWxsPSIjQjJCMkIyIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
	daterange: 'data:image/svg+xml;base64,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',
	datePicker: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTExLjQzNSAyMi41SDYuNnY0LjczN2MwIC4yMjguMTg1LjQxNC40MTQuNDE0aDIuMTM0Yy4xNTYuNTg5LjQyOCAxLjEzLjc5IDEuNkg3LjAxNEEyLjAxNCAyLjAxNCAwIDAgMSA1IDI3LjIzNnYtNi40NzNjMC0xLjExMi45MDEtMi4wMTQgMi4wMTMtMi4wMTRoNy45NzRjMS4xMTIgMCAyLjAxMy45MDIgMi4wMTMgMi4wMTRWMjMuNjcyQTQuNDkxIDQuNDkxIDAgMCAwIDEzLjUgMjJjLS43NDQgMC0xLjQ0Ni4xODEtMi4wNjUuNVpNOCAyNC43NWEuNzUuNzUgMCAxIDAgMC0xLjUuNzUuNzUgMCAwIDAgMCAxLjVabS43NSAxLjVhLjc1Ljc1IDAgMSAxLTEuNSAwIC43NS43NSAwIDAgMSAxLjUgMFoiIGZpbGw9IiNCMkIyQjIiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE1LjY4NCAyOC42NWEzLjE1IDMuMTUgMCAwIDAgMC00LjQ3MyAzLjE5NyAzLjE5NyAwIDAgMC00LjUwMiAwIDMuMTUgMy4xNSAwIDAgMCAwIDQuNDc0IDMuMTk3IDMuMTk3IDAgMCAwIDQuNTAyIDBabS0xLjg3NS0zLjU1M2EuNTIyLjUyMiAwIDEgMC0xLjA0NCAwdjEuNWMwIC4yNDUuMTcuNDU4LjQxLjUxbDEuNjM2LjM1NmEuNTIyLjUyMiAwIDEgMCAuMjIzLTEuMDJsLTEuMjI2LS4yNjd2LTEuMDhaIiBmaWxsPSIjQjJCMkIyIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
	divider: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcgNnY4YTQgNCAwIDAgMCA0IDRoMjZhNCA0IDAgMCAwIDQtNFY2TTQxIDQydi04YTQgNCAwIDAgMC00LTRIMTFhNCA0IDAgMCAwLTQgNHY4IiBzdHJva2U9IiNCRUJFQkUiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1kYXNoYXJyYXk9IjEgNCIvPjxwYXRoIGQ9Ik00MSAyNC44YS44LjggMCAwIDAgMC0xLjZ2MS42Wk03IDIzLjJhLjguOCAwIDAgMCAwIDEuNnYtMS42Wm0zNCAwSDd2MS42aDM0di0xLjZaIiBmaWxsPSIjOEU4RThFIi8+PC9zdmc+Cg==',
	grid: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQwIDM5SDdWMTZhMSAxIDAgMCAxIDEtMWgzMWExIDEgMCAwIDEgMSAxdjIzWiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik0yMyAzOFYxME03IDI3aDMzLjI1TTcgMjFoMzMuMjVNNyAzM2gzMy4yNSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik00MCAxNUg3di01YTEgMSAwIDAgMSAxLTFoMzFhMSAxIDAgMCAxIDEgMXY1WiIgZmlsbD0iI0VFRSIvPjxwYXRoIGQ9Ik02Ljg3NSAxNWgzMy4yNSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxyZWN0IHg9IjYuOCIgeT0iOS44IiB3aWR0aD0iMzMuNCIgaGVpZ2h0PSIyOC40IiByeD0iMi4yIiBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PC9zdmc+Cg==',
	html: 'data:image/svg+xml;base64,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',
	input: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjEgMjRoMTIiLz48cGF0aCBkPSJNMzggMjBoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM4bTEuNSAwSDQxIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz48cGF0aCBkPSJNNy4yNSAyMi4wNzRWMjAuOThhLjczLjczIDAgMCAxIC43My0uNzNIMTFtMy43NSAxLjgyNFYyMC45OGEuNzMuNzMgMCAwIDAtLjczLS43M0gxMW0wIDB2Ny41bTAgMEg5LjExbTEuODkgMGgyLjA1MSIgc3Ryb2tlPSIjQjJCMkIyIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
	number: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNNC41IDI2LjA2aDguNTU1TTExLjYyOSAxOS41bC0xLjQyNiA4LjU1NU04LjA2NCAxOS41bC0xLjQyNiA4LjU1NU01LjIxMyAyMi4wNjdIMTMuNSIgc3Ryb2tlPSIjQjJCMkIyIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
	radio: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIwIDM1aDE5TTIwIDI0aDIxTTIwIDEzaDEzIi8+PHJlY3QgeD0iNyIgeT0iMzEiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHJ4PSI0IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMS4yIi8+PHJlY3QgeD0iNyIgeT0iMjAiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHJ4PSI0IiBmaWxsPSIjM0M5MkRDIiBzdHJva2U9IiMzQzkyREMiLz48cmVjdCB4PSI3IiB5PSI5IiB3aWR0aD0iOCIgaGVpZ2h0PSI4IiByeD0iNCIgZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuMiIvPjxyZWN0IHg9IjEwIiB5PSIyMyIgd2lkdGg9IjIiIGhlaWdodD0iMiIgcng9IjEiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI2ZmZiIvPjwvc3ZnPgo=',
	rate: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcuODU0IDE3LjljLjIxLS42MTcgMS4wODItLjYxNyAxLjI5MiAwbDEuMTI0IDMuMzA5aDMuNTUzYy42NjggMCAuOTM4Ljg2LjM4OSAxLjI0MmwtMi44NDcgMS45NzcgMS4xMDQgMy4yNDhjLjIxMi42MjItLjQ5NCAxLjE1NC0xLjAzNS43OEw4LjUgMjYuNDE2bC0yLjkzNCAyLjAzOGMtLjU0LjM3NS0xLjI0Ni0uMTU3LTEuMDM1LS43OGwxLjEwNC0zLjI0Ny0yLjg0Ny0xLjk3N2MtLjU0OC0uMzgxLS4yNzktMS4yNDIuMzktMS4yNDJoMy41NTFsMS4xMjUtMy4zMXoiIGZpbGw9IiNFQ0JCNDAiLz48cGF0aCBkPSJNMjQuMjE4IDE3LjljLjIxLS42MTcgMS4wODItLjYxNyAxLjI5MSAwbDEuMTI1IDMuMzA5aDMuNTUzYy42NjggMCAuOTM3Ljg2LjM4OSAxLjI0MmwtMi44NDggMS45NzcgMS4xMDQgMy4yNDhjLjIxMi42MjItLjQ5NCAxLjE1NC0xLjAzNC43OGwtMi45MzQtMi4wMzktMi45MzUgMi4wMzhjLS41NC4zNzUtMS4yNDYtLjE1Ny0xLjAzNC0uNzhsMS4xMDQtMy4yNDctMi44NDctMS45NzdjLS41NDktLjM4MS0uMjgtMS4yNDIuMzg5LTEuMjQyaDMuNTUybDEuMTI1LTMuMzF6IiBmaWxsPSIjRDhEOEQ4Ii8+PHBhdGggZD0iTTM5LjIxNSAxNy45OTZjLjIwNC0uNjI4IDEuMDkzLS42MjggMS4yOTcgMGwuODgyIDIuNzE1YS42ODIuNjgyIDAgMCAwIC42NDkuNDcxaDIuODU1Yy42NiAwIC45MzUuODQ2LjQgMS4yMzRsLTIuMzEgMS42NzhhLjY4Mi42ODIgMCAwIDAtLjI0Ny43NjJsLjg4MyAyLjcxNmMuMjA0LjYyOC0uNTE1IDEuMTUtMS4wNS43NjJsLTIuMzEtMS42NzhhLjY4Mi42ODIgMCAwIDAtLjgwMSAwbC0yLjMxIDEuNjc4Yy0uNTM0LjM4OC0xLjI1My0uMTM0LTEuMDUtLjc2MmwuODgzLTIuNzE2YS42ODIuNjgyIDAgMCAwLS4yNDgtLjc2MmwtMi4zMS0xLjY3OGMtLjUzNC0uMzg4LS4yNi0xLjIzNC40MDEtMS4yMzRoMi44NTVjLjI5NiAwIC41NTgtLjE5LjY0OS0uNDdsLjg4Mi0yLjcxNnoiIGZpbGw9IiNERURFREUiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTI1IDE3LjQ1MWMtLjM0Ni0uMjE2LS44NjYtLjA5NC0xLjAxNS4zNjhsLTEuMDM2IDMuMTg2SDE5LjZjLS42NjEgMC0uOTM2Ljg0Ni0uNDAxIDEuMjM0bDIuNzEgMS45Ny0xLjAzNSAzLjE4NmMtLjIwNC42MjguNTE1IDEuMTUgMS4wNS43NjJsMi43MS0xLjk3LjM2Ny4yNjd2LTkuMDAzeiIgZmlsbD0iI0VDQkI0MCIvPjwvc3ZnPgo=',
	select: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iNCIgd2lkdGg9IjQ2IiBoZWlnaHQ9IjEzIiByeD0iMyIgZmlsbD0iI0ZDRkNGQyIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIHN0cm9rZT0iIzc1NzU3NSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik03IDExaDE3Ii8+PHJlY3QgeD0iNCIgeT0iMTUiIHdpZHRoPSI0MyIgaGVpZ2h0PSIyOSIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsPSIjRUNGNUZEIiBkPSJNNSAyNmg0MXY4SDV6Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDIxaDEzIi8+PHBhdGggc3Ryb2tlPSIjNzU3NTc1IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDMwaDI1Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDM5aDE3Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIgZD0iTTQgMjUuMmg0M000IDM0LjJoNDMiLz48cGF0aCBkPSJtMzggMTAgMi41IDIgMi41LTIiIHN0cm9rZT0iI0JFQkVCRSIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIGQ9Im0zOSAzMC4zNjEgMS4zNjEgMS4xMzRMNDIuNjMgMjkiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjwvc3ZnPgo=',
	slider: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMTAiIHk9IjIyIiB3aWR0aD0iMzQiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iI0Q4RDhEOCIvPjxyZWN0IHg9IjUiIHk9IjIyIiB3aWR0aD0iMjkiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iIzRBQTFFRCIvPjxjaXJjbGUgY3g9IjMxLjM5OSIgY3k9IjIzLjM5OSIgcj0iMy44OTkiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0JFQkVCRSIvPjwvc3ZnPgo=',
	switch: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNy41IiB5PSIyMS41IiB3aWR0aD0iMTMiIGhlaWdodD0iNyIgcng9IjMuNSIgZmlsbD0iIzNDOTJEQyIgc3Ryb2tlPSIjM0M5MkRDIi8+PHJlY3QgeD0iMTUiIHk9IjIzIiB3aWR0aD0iNCIgaGVpZ2h0PSI0IiByeD0iMiIgZmlsbD0iI2ZmZiIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yNSAyNWgxNiIvPjwvc3ZnPgo=',
	table: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQzIDM4SDVWMTdhMSAxIDAgMCAxIDEtMWgzNmExIDEgMCAwIDEgMSAxdjIxWiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik01IDM1aDM4djFhMiAyIDAgMCAxLTIgMkg3YTIgMiAwIDAgMS0yLTJ2LTFaIiBmaWxsPSIjREVERURFIi8+PHBhdGggZD0iTTEyIDM4VjExTTI4IDM4VjExTTUgMjJoMzhNNSAyOWgzOE0yMCAzOFYxMU0zNiAzOFYxMSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik00MyAxNkg1di01YTEgMSAwIDAgMSAxLTFoMzZhMSAxIDAgMCAxIDEgMXY1WiIgZmlsbD0iI0RFREVERSIvPjxyZWN0IHg9IjQuOCIgeT0iMTAuOCIgd2lkdGg9IjM4LjQiIGhlaWdodD0iMjcuNCIgcng9IjIuMiIgc3Ryb2tlPSIjNzU3NTc1IiBzdHJva2Utd2lkdGg9IjEuNiIvPjwvc3ZnPgo=',
	text: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTEwIDExSDZhMiAyIDAgMCAwLTIgMnY0TTM4IDM4aDRhMiAyIDAgMCAwIDItMnYtNE00NCAxN3YtNGEyIDIgMCAwIDAtMi0yaC00TTQgMzJ2NGEyIDIgMCAwIDAgMiAyaDQiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yOCAxN2gxMU0yOCAyMmgxMU05IDI4aDMwTTkgMzNoMjQiLz48cGF0aCBkPSJNOC42MjIgMTUuODQ0VjIzaDEuNDY4di00LjY3NWguMDU5bDEuODUyIDQuNjRoMWwxLjg1MS00LjYyM2guMDZWMjNoMS40Njd2LTcuMTU2aC0xLjg2NmwtMS45NyA0LjgwOGgtLjA4NGwtMS45NzEtNC44MDhIOC42MjJaIiBmaWxsPSIjOEU4RThFIi8+PHBhdGggZD0iTTIxLjAwNiAxNnY3bTAgMEwyNCAyMG0tMi45OTQgM0wxOCAyMCIgc3Ryb2tlPSIjOEU4RThFIiBzdHJva2Utd2lkdGg9IjEuNCIvPjwvc3ZnPgo=',
	textarea: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iOSIgd2lkdGg9IjQ2IiBoZWlnaHQ9IjMxIiByeD0iMyIgZmlsbD0iI0ZDRkNGQyIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik01LjUgMjIuNWg5TTUuNSAyMC4yNWg5TTEzIDE4aDEuNU01LjUgMTQuOTE5di0uNzg3YzAtLjM1LjI4My0uNjMyLjYzMi0uNjMySDguNW0zIDEuNDE5di0uNzg3YS42MzIuNjMyIDAgMCAwLS42MzItLjYzMkg4LjVtMCAwVjE4bTAgMEg2Ljk1N004LjUgMThoMS41NDMiIHN0cm9rZT0iI0IyQjJCMiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik02IDI5aDI4TTYgMzRoMTciLz48cGF0aCBkPSJNMzkgMjdoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM5bTEuNSAwSDQyIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz48L3N2Zz4K',
	time: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTYuNTUgMjRhNC40NSA0LjQ1IDAgMSAxIDguOSAwIDQuNDUgNC40NSAwIDAgMS04LjkgMFpNMTEgMTcuOTVhNi4wNSA2LjA1IDAgMSAwIDAgMTIuMSA2LjA1IDYuMDUgMCAwIDAgMC0xMi4xWk0xMC4yIDIxYS44LjggMCAxIDEgMS42IDB2My4wMmEuOC44IDAgMCAxLS40OS43MzdsLTIuNjI0IDEuMTA2YS44LjggMCAwIDEtLjYyMS0xLjQ3NWwyLjEzNS0uOVYyMVoiIGZpbGw9IiNCMkIyQjIiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjEgMjRoMTIiLz48cGF0aCBkPSJNMzggMjBoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM4bTEuNSAwSDQxIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz48L3N2Zz4K',
	uploadFile: 'data:image/svg+xml;base64,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',
	uploadImg: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNS44IiB5PSIxMC44IiB3aWR0aD0iMzYuNCIgaGVpZ2h0PSIyNi40IiByeD0iMy4yIiBmaWxsPSIjZmZmIiBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PGNpcmNsZSBjeD0iMTMuNSIgY3k9IjE4LjUiIHI9IjMuNSIgZmlsbD0iI0VFQ0E4NiIvPjxwYXRoIGQ9Ik0yNy45MjMgMTguMzY2YTEgMSAwIDAgMSAxLjY5Ni0uMDE4bDguMzk1IDEzLjExM0ExIDEgMCAwIDEgMzcuMTcyIDMzSDIwLjc4MWExIDEgMCAwIDEtLjg1NC0xLjUybDcuOTk2LTEzLjExNFoiIGZpbGw9IiM4MkJGOTkiLz48cGF0aCBkPSJNMTYuNjc2IDI2LjE5OWExIDEgMCAwIDEgMS42NDggMGwzLjU5OSA1LjIzNEExIDEgMCAwIDEgMjEuMDk5IDMzSDEzLjlhMSAxIDAgMCAxLS44MjQtMS41NjdsMy41OTktNS4yMzRaIiBmaWxsPSIjODJCRjk5Ii8+PC9zdmc+Cg==',
	state: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjM0LjYiIHJ4PSIzLjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBvcGFjaXR5PSIuNSIgZD0iTTcgMzB2NmEyIDIgMCAwIDAgMiAyaDMwYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkg5YTIgMiAwIDAgMC0yIDJaTTcgMTN2NmEyIDIgMCAwIDAgMiAyaDMwYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkg5YTIgMiAwIDAgMC0yIDJaIiBmaWxsPSIjRDhEOEQ4Ii8+PHJlY3QgeD0iMTQuMiIgeT0iMTcuMiIgd2lkdGg9IjMyLjYiIGhlaWdodD0iMTUuNiIgcng9IjEuOCIgZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIG9wYWNpdHk9Ii41IiBkPSJNMTcgMjJ2NmEyIDIgMCAwIDAgMiAyaDIzYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkgxOWEyIDIgMCAwIDAtMiAyWiIgZmlsbD0iI0Q4RDhEOCIvPjwvc3ZnPgo=',
	tabs: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjMzLjYiIHJ4PSI0LjgiIGZpbGw9IndoaXRlIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+CjxyZWN0IHg9IjciIHk9IjI2IiB3aWR0aD0iMzQiIGhlaWdodD0iMTAiIHJ4PSIxIiBmaWxsPSIjRTVFNUU1Ii8+CjxsaW5lIHgxPSI0IiB5MT0iMjIuMiIgeDI9IjQ0IiB5Mj0iMjIuMiIgc3Ryb2tlPSIjRTVFNUU1IiBzdHJva2Utd2lkdGg9IjEuNiIvPgo8cGF0aCBkPSJNMjcuNjg4MSAxOEgzMC4zMzc2QzMxLjgzNjUgMTggMzIuNTcxNiAxNy4yMzYyIDMyLjU3MTYgMTYuMjE2NkMzMi41NzE2IDE1LjIyNTkgMzEuODY4NSAxNC42NDQyIDMxLjE3MTcgMTQuNjA5VjE0LjU0NTFDMzEuODEwOSAxNC4zOTQ5IDMyLjMxNTkgMTMuOTQ3NCAzMi4zMTU5IDEzLjE1MTZDMzIuMzE1OSAxMi4xNzY4IDMxLjYxMjggMTEuNDU0NSAzMC4xOTM4IDExLjQ1NDVIMjcuNjg4MVYxOFpNMjguODczOCAxNy4wMDkyVjE1LjA5MTZIMzAuMTgxQzMwLjkxMjkgMTUuMDkxNiAzMS4zNjY3IDE1LjUzOTEgMzEuMzY2NyAxNi4xMjM5QzMxLjM2NjcgMTYuNjQ0OSAzMS4wMDg3IDE3LjAwOTIgMzAuMTQ5IDE3LjAwOTJIMjguODczOFpNMjguODczOCAxNC4yMzgzVjEyLjQzMjVIMzAuMDcyM0MzMC43NjkgMTIuNDMyNSAzMS4xMzAyIDEyLjgwMDEgMzEuMTMwMiAxMy4zMDVDMzEuMTMwMiAxMy44ODAzIDMwLjY2MzYgMTQuMjM4MyAzMC4wNDY3IDE0LjIzODNIMjguODczOFoiIGZpbGw9IiMyQjJCMkIiLz4KPHJlY3QgeD0iNyIgeT0iOSIgd2lkdGg9IjE3IiBoZWlnaHQ9IjExIiByeD0iNS41IiBmaWxsPSIjREFFQ0ZDIi8+CjxwYXRoIGQ9Ik0xMy43Mjk4IDE4TDE0LjI2OTkgMTYuMzg2SDE2LjczMDlMMTcuMjc0MiAxOEgxOC41Mzk4TDE2LjIzMjMgMTEuNDU0NUgxNC43Njg1TDEyLjQ2NDIgMThIMTMuNzI5OFpNMTQuNTg5NSAxNS40MzM2TDE1LjQ3NDggMTIuNzk2OUgxNS41MjZMMTYuNDExMyAxNS40MzM2SDE0LjU4OTVaIiBmaWxsPSIjM0M5MkRDIi8+Cjwvc3ZnPgo=',

}
 
export const getItemIcon = (type)=> { 
	return icons[type]
}