#!/bin/bash

##################################################################################################
#                                                                                                #
#  ____  __.__        __                           _________                        __           #
# |    |/ _|__| ____ |  | _______    ______ ______ \_   ___ \_______ ___.__._______/  |_  ____   #
# |      < |  |/ ___\|  |/ /\__  \  /  ___//  ___/ /    \  \/\_  __ <   |  |\____ \   __\/  _ \  #
# |    |  \|  \  \___|    <  / __ \_\___ \ \___ \  \     \____|  | \/\___  ||  |_> >  | (  <_> ) #
# |____|__ \__|\___  >__|_ \(____  /____  >____  >  \______  /|__|   / ____||   __/|__|  \____/  #
#         \/       \/     \/     \/     \/     \/          \/        \/     |__|                 #
#                                                                                                #
#                                                                                        By jj5  #
#                                                                                                #
##################################################################################################

##################################################################################################
#
# 2023-04-03 jj5 - this script counts how many times "kickass" appears in the code and updates
# the documentation.
#
##################################################################################################

main() {

  set -euo pipefail;

  pushd "$( dirname "$0" )/../../" >/dev/null;
  source bin/inc/env.sh;

  pushd src/code/namespace/KickassCrypto/ >/dev/null;

  if grep -Ri "this->do_" OpenSsl Sodium; then

    echo 'WARNING: $this->do_*() called from module services...';

  fi

  if grep -Ri "parent::do_" OpenSsl Sodium; then

    echo 'WARNING: parent::do_*() called from module services...';

  fi

}

main "$@";
