# Artificial-Intelligence-Terminology-Database

**A comprehensive mapping database of English to Chinese technical vocabulary in the artificial intelligence domain.**

![](https://github.com/jiqizhixin/Artificial-Intelligence-Terminology/blob/master/assets/logo.png)

本术语库目前拥有专业术语约 2442 个、专项领域篇 2 篇，主要为人工智能领域基础概念和术语。

本术语库前两版主要是将机器之心在编译技术文章和论文过程中所遇到的专业术语记录下来，希望有助于大家查阅和翻译，同时也希望大家能积极指出我们编译的不当之处，共同推进知识高效、广泛地传播。

自第三版起，在日常编译工作积累之外，我们将逐领域基于权威教科书及文献，联合领域专家进一步扩展并完善本仓库，为社区提供具有统一性的 AI 及相关领域的中英术语翻译对照参考。

机器之心将从三个方面持续完善术语的收录和扩展阅读的构建：

①第一阶段机器之心将继续完善基础术语的构建，即通过权威教科书或其它有公信力的资料抽取常见术语；

②第二阶段机器之心将持续性地把编译论文或其他资料中所出现的非常见术语更新到术语表中；

③第三阶段机器之心将联合更多的领域专家，构建专项领域的术语表。

##

### [GitBook](https://jiqizhixin.gitbook.io/artificial-intelligence-terminology-database/)

# #

1. 根据首字母排序（全部术语，包含所有专项领域）

| 索引   | V1                                                           | V2                                                           | V3                                                           | V4                                                           | V5                                                           | V6                                                           | V7                                                           | V8                                                           | V9                                                           | V10                                                          |
| ------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| **U1** | -[**Q**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/Q.md)- | -[**W**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/W.md)- | -[**E**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/E.md)- | -[**R**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/R.md)- | -[**T**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/T.md)- | -[**Y**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/Y.md)- | -[**U**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/U.md)- | -[**I**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/I.md)- | -[**O**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/O.md)- | -[**P**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/P.md)- |
| **U2** | -[**A**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/A.md)- | -[**S**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/S.md)- | -[**D**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/D.md)- | -[**F**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/F.md)- | -[**G**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/G.md)- | -[**H**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/H.md)- | -[**J**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/J.md)- | -[**K**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/K.md)- | -[**L**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/L.md)- |                                                              |
| **U3** |                                                              | -[**Z**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/Z.md)- | -[**X**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/X.md)- | -[**C**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/C.md)- | -[**V**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/V.md)- | -[**B**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/B.md)- | -[**N**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/N.md)- | -[**M**](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/data/M.md)- |                                                              |                                                              |

2. 专项领域篇（仅收录对应领域术语）
   1. [机器学习（Machine Learning）篇](https://github.com/jiqizhixin/Artificial-Intelligence-Terminology/blob/master/section/Machine%20Learning.md)
   2. [AI for Science 篇](https://github.com/jiqizhixin/Artificial-Intelligence-Terminology/blob/master/section/AI%20for%20Science.md)

# #

### 组织形式

读者在此项目中，可通过以上字母表盘或不同领域查看自己想要了解的专业术语。其中，术语的组织形式为：

- 索引编号：考虑到讨论交流、数据库维护的效率，我们将使用「**Artificial-Intelligence-Terminology-Database**」的缩写 AITD 并加上数字作为术语的编号，根据当前术语库的首字母顺序进行标注，索引编号将从 AITD-00000 开始；
- 英文术语：英文术语；
- 中文翻译：该英文术语目前推荐的中文翻译；
- 常用缩写：该英文术语常用的缩写形式；
- 来源&扩展：来源&扩展是对该术语的注解，在前两版中的内容为机器之心往期的相关文章。我们希望不仅能提供相对应的术语，同时还希望能为读者提供每一个术语的来源和概念上的扩展。从第三版起，我们将关联更多的资源内容，包括但不限于教科书、论文等来源。但由于这一部分工作量较大，我们将与读者共同推进这一部分扩展的进程，进一步提升术语的置信度。
- 备注：关于该术语的一些注解。

### 准确性

本项目中所有英文专业术语对照的中文都来自机器之心编译的文章和系列机器学习教科书（如周志华教授的《机器学习》、李航博士的《统计学习方法》、邱锡鹏教授的《神经网络与深度学习》、李沐博士的《动手学深度学习》、李宏毅教授的《机器学习方法》和 Ian Goodfellow 的《深度学习》中译版等），我们力求在提供准确翻译的同时保留最常用的形式。同时，为了保证术语翻译的准确性，我们将此项目向读者开源，并希望能与读者共同迭代术语的准确度。

#### 机器之心术语编译标准

因为该项目很多术语都是机器之心平常编译文章所积累的，所以我们首先需要向读者说明机器之心术语编译的标准。

1. 常见术语的编译标准

机器之心常见术语的编译首先会确保术语的正确性，其次再考虑术语的传播广度。机器之心在对常见术语编译时并不会保留英文，也不会作进一步说明。

2. 非常见术语的编译标准

机器之心在编译技术文章或论文时，常常会遇到非常见的术语。因为像论文那样的文章是在特定领域下为解决特定问题而规范化书写的，所以就会存在较多的非常见的术语。而机器之心在编译非常见术语时，唯一的标准就是准确性，通常我们也会保留英文。因为非常见术语通常是数学、神经科学和物理学等领域上的专业术语，机器之心会尽可能地借鉴其他领域内的译法和意义而确定如何编译。例如 fixed-point theorem，在参考数学的情况下，我们会更倾向于译为不动点定理，fixed-point 译为不动点而不是定点。

3. 歧义术语的编译标准

还有很多术语其实是有歧义的，而对于这一类术语，机器之心的编译标准会根据语义进行确定，因此也会有一些误差。例如 bias 在描述神经网络层级单元时可以译为偏置项，而在描述训练误差和交叉验证误差间的关系或学习曲线时，bias 可以译为偏差。这样的例子还有很多，比如 Stationary 在马尔可夫模型中可译为稳态分布（Stationary Distribution），在最优化问题中可译为驻点（Stationary Point），而在涉及博弈论或对抗性训练时，其又可能表达为静态。

以上是机器之心大概编译术语的标准，虽然我们在常用术语的编译上错误率相对较低，但在非常见术语和歧义术语上仍然会出现一些错误。尤其是在非常见术语的编译上，没有特定的背景知识很容易在编译上出现误差。因此我们希望能与读者共同加强术语的编译质量。

#### 专项领域术语编译标准

除了机器之心积累的术语库之外，本项目还包含了来自专项领域的术语，专项领域篇的质量会更高。对于专项领域篇术语编译标准说明如下：

1. 领域专家参与

专项领域专家的参与确保我们收集到的术语具有专业性。例如在机器学习（Machine Learning）篇中，我们在周志华教授、李航博士、邱锡鹏教授、李沐博士、Aston Zhang 博士等该领域权威专家及经典教科书作者的指导下，不仅完成了对该领域术语收录的覆盖度、术语中文翻译用法的准确性、专业性及公信力的提升，同时也完成了为社区构建一套具有公信力的领域术语统一中文翻译用法参考资料的工作。

2. 基于权威教科书、论文等具有公信力的资料源提取术语

机器之心将搜集自权威教科书、论文等具有公信力的资料源中的术语表进行校验汇总，并从中筛选出一些具有争议、没有翻译等情况的术语给到领域专家进行集中讨论以确认翻译、统一翻译。在与专家讨论的过程中，不同的专家对同一个词的翻译也会有分歧。在这种情况下，专家们会从自身经验、理解出发，帮助其余专家理解自己这样翻译的一个背景知识。经过专家们不断的讨论，对于一个词的翻译最终会接近或达到一个共识。

在此过程中，我们也记录了一些有意思的结果。例如 “Robust” 经常会被翻译为“鲁棒性”，专家们认为这个翻译缺少了中文的美感。此外，在控制论中有将 “Robust” 翻译成“强健性的，在经过专家讨论之后，我们将“稳健性”作为“Robust”的推荐翻译；“Dropout”一直没有较好的翻译，几位专家根据 Dropout 原文中 “temporarily removing” 的表述，一致认为“暂退法”是较为合适的翻译；“Zero/Few/One-shot Learning”一般翻译为“零/少/单样本学习”，但专家们认为“样本”不严谨，因为它并不是真的“零/少/单”样本，而是在建立一个映射之后，再利用少量样本进行迁移。翻译成样本的话，很容易跟学习理论中真正的“小样本学习”混淆了。尤其是“shot”本身并没有“样本”的含义，而是“快照”的含义更接近，在确定中文翻译时，联想到 “have a shot” 的意思是“试一试”，于是专家们倾向翻译为“零/少/单试学习”。

#### 特别说明

类似 Accuracy、Recall 等常用的术语在不同领域中都会有使用，因此会有同一个术语出现在不同的专项领域篇中的情况。

## 参与贡献

在使用术语表的过程中若发现了存在的错误、或是想要扩展术语库的内容、讨论特定术语的翻译等等非常欢迎大家提 Issue 与我们以及各位读者进行讨论。同时也非常欢迎读者们进行 Fork、提 Pull Request，共同加强术语的编译质量以及扩充术语库的规模。

读者的反馈意见和更新建议将贯穿整个阶段，我们也将在项目致谢页中展示对该项目起积极作用的读者。我们希望术语的更新更具准确度和置信度，所以我们希望读者能附上该术语的来源地址与扩展地址。这样，我们能更客观地更新术语，并附上可信的来源与扩展。

## 贡献者列表及致谢

衷心感谢以下人员参与了包含但不限于术语提供、校对、翻译讨论等工作，为该项目扩展了专项领域术语收录的覆盖度、提升了术语中文翻译用法的准确性、专业性及公信力，感谢老师们的辛勤贡献。

排名将以 A~Z 进行排序：

**机器学习（Machine Learning）篇特别致谢**

1. [Aston Zhang 博士](https://github.com/astonzhang)，《动手学深度学习》作者
2. 李航博士，《统计学习方法》作者
3. [李沐博士](https://github.com/mli)，《动手学深度学习》作者
4. [邱锡鹏教授](https://github.com/xpqiu)，《神经网络与深度学习》作者
5. 周志华教授，《机器学习》作者

**AI for Science 篇特别致谢**

1. [张铎](https://github.com/iprozd)，DP Technology，DeepModeling 开源社区成员
2. [蔡淳](https://github.com/caic99) ，DP Technology，DeepModeling 开源社区成员  
3. [董昊森](https://github.com/Asuna981002)，DP Technology，DeepModeling 开源社区成员 

**基础工作由机器之心多位项目组成员完成**

1. [胡龙正](https://github.com/VXenomac)（机器之心 Synced）
2. [金丹妮](https://github.com/jindanni)（机器之心 Synced）
3. [蒋思源](https://github.com/HoratioJSY)（机器之心 Synced）
4. 李亚洲（机器之心 Synced）
5. [之乎 Chain Zhang](https://github.com/chainn)（机器之心 Synced）
6. [张赵宇](https://github.com/xavier-zy)（机器之心 Synced）

除目前已包含的机器学习（Machine Learning）、AI for Science 篇，本项目还将进一步制作更多专项领域篇。对我们项目感兴趣并愿意一起支持这个项目的领域专家可以通过 lab@jiqizhixin.com 联系我们。

## 版本更新

## Version 3.1，2022-02-16

* 3.1 版术语库发布，包含了 2442 个术语
* 增加了第二个领域专题 AI for Science 篇，包含了个 491 个术语

## Version 3.0，2021-08-03

- 第三版术语库发布，包含了 2094 个术语
- 增加了领域专题 Section，第一个 Section 为 机器学习（Machine Learning）篇，包含了 726 个术语

## Version 2.0，2018-05-03

- 第二版术语库发布，包含了 755 个术语

## Version 1.0，2017-07-10

- 第一版术语库发布，包含 500 个术语

## 加入我们

![](https://github.com/jiqizhixin/Artificial-Intelligence-Terminology/blob/master/assets/join.png)

我们邀请更多感兴趣一起参与「AITD」项目的小伙伴通过加入「机器之心分析师网络」加入到「AITD」项目工作中来。

![](https://github.com/jiqizhixin/Artificial-Intelligence-Terminology/blob/master/assets/SOTA.png)

**扫码关注「机器之心SOTA模型」服务号，参与「AITD」项目。**

## 许可证

本作品采用[知识共享署名-非商业性使用-相同方式共享 4.0 国际许可协议](http://creativecommons.org/licenses/by-nc-sa/4.0/)进行许可。

