/*
 * Decompiled with CFR 0.152.
 */
package com.script.javascript;

import com.script.AbstractScriptEngine;
import com.script.Bindings;
import com.script.Compilable;
import com.script.CompiledScript;
import com.script.Invocable;
import com.script.ScriptContext;
import com.script.ScriptException;
import com.script.SimpleBindings;
import com.script.javascript.ExternalScriptable;
import com.script.javascript.InterfaceImplementor;
import com.script.javascript.RhinoClassShutter;
import com.script.javascript.RhinoCompiledScript;
import com.script.javascript.RhinoTopLevel;
import com.script.javascript.RhinoWrapFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private static final boolean DEBUG = false;
    private AccessControlContext accCtxt;
    private final RhinoTopLevel topLevel;
    private final Map<Object, Object> indexedProps;
    private final InterfaceImplementor implementor;
    private static final String printSource = "function print(str, newline) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }                                         \n    var out = context.getWriter();            \n    if (!(out instanceof java.io.PrintWriter))\n        out = new java.io.PrintWriter(out);   \n    out.print(String(str));                   \n    if (newline) out.print('\\n');            \n    out.flush();                              \n}\nfunction println(str) {                       \n    print(str, true);                         \n}";

    public RhinoScriptEngine() {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.checkPermission(new AllPermission());
            }
            catch (AccessControlException ace) {
                this.accCtxt = AccessController.getContext();
            }
        }
        Context cx = Context.enter();
        try {
            this.topLevel = new RhinoTopLevel(cx, this);
        }
        finally {
            Context.exit();
        }
        this.indexedProps = new HashMap<Object, Object>();
        this.implementor = new InterfaceImplementor(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean isImplemented(Object thiz, Class<?> iface) {
                try {
                    if (thiz != null && !(thiz instanceof Scriptable)) {
                        thiz = Context.toObject(thiz, RhinoScriptEngine.this.topLevel);
                    }
                    Scriptable engineScope = RhinoScriptEngine.this.getRuntimeScope(RhinoScriptEngine.this.context);
                    Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
                    for (Method method : iface.getMethods()) {
                        Object obj;
                        if (method.getDeclaringClass() == Object.class || (obj = ScriptableObject.getProperty(localScope, method.getName())) instanceof Function) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Context.exit();
                }
            }

            @Override
            protected Object convertResult(Method method, Object res) {
                Class<?> desiredType = method.getReturnType();
                if (desiredType == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava(res, desiredType);
            }
        };
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        Context cx = Context.enter();
        try {
            Scriptable scope = this.getRuntimeScope(ctxt);
            String filename = (String)this.get("javax.script.filename");
            filename = filename == null ? "<Unknown source>" : filename;
            ret = cx.evaluateReader(scope, reader, filename, 1, null);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
            ScriptException se = new ScriptException(msg, re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        catch (IOException ee) {
            throw new ScriptException(ee);
        }
        finally {
            Context.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        return this.eval((Reader)new StringReader(script), ctxt);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invoke(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("\u811a\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.invoke(thiz, name, args);
    }

    private Object invoke(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Context cx = Context.enter();
        try {
            if (name == null) {
                throw new NullPointerException("\u65b9\u6cd5\u540d\u4e3a\u7a7a");
            }
            if (thiz != null && !(thiz instanceof Scriptable)) {
                thiz = Context.toObject(thiz, this.topLevel);
            }
            Scriptable engineScope = this.getRuntimeScope(this.context);
            Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
            Object obj = ScriptableObject.getProperty(localScope, name);
            if (!(obj instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + name);
            }
            Function func = (Function)obj;
            Scriptable scope = func.getParentScope();
            if (scope == null) {
                scope = engineScope;
            }
            Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
            Object object = this.unwrapReturnValue(result);
            return object;
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            ScriptException se = new ScriptException(re.toString(), re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("\u811a\u672c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return this.implementor.getInterface(thiz, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Scriptable getRuntimeScope(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("\u811a\u672ccontext\u4e3a\u7a7a");
        }
        ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
        newScope.setPrototype(this.topLevel);
        newScope.put("context", (Scriptable)newScope, (Object)ctxt);
        Context cx = Context.enter();
        try {
            cx.evaluateString(newScope, printSource, "print", 1, null);
        }
        finally {
            Context.exit();
        }
        return newScope;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret;
        Context cx = Context.enter();
        try {
            String fileName = (String)this.get("javax.script.filename");
            if (fileName == null) {
                fileName = "<Unknown Source>";
            }
            Script scr = cx.compileReader(script, fileName, 1, null);
            ret = new RhinoCompiledScript(this, scr);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    AccessControlContext getAccessContext() {
        return this.accCtxt;
    }

    Object[] wrapArguments(Object[] args) {
        if (args == null) {
            return Context.emptyArgs;
        }
        Object[] res = new Object[args.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Context.javaToJS(args[i], this.topLevel);
        }
        return res;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    static {
        ContextFactory.initGlobal(new ContextFactory(){

            @Override
            protected Context makeContext() {
                Context cx = super.makeContext();
                cx.setLanguageVersion(200);
                cx.setOptimizationLevel(-1);
                cx.setClassShutter(RhinoClassShutter.getInstance());
                cx.setWrapFactory(RhinoWrapFactory.getInstance());
                return cx;
            }

            @Override
            protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                AccessControlContext accCtxt = null;
                Scriptable global = ScriptableObject.getTopLevelScope(scope);
                Scriptable globalProto = global.getPrototype();
                if (globalProto instanceof RhinoTopLevel) {
                    accCtxt = ((RhinoTopLevel)globalProto).getAccessContext();
                }
                if (accCtxt != null) {
                    return AccessController.doPrivileged(() -> this.superDoTopCall(callable, cx, scope, thisObj, args), accCtxt);
                }
                return this.superDoTopCall(callable, cx, scope, thisObj, args);
            }

            private Object superDoTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return super.doTopCall(callable, cx, scope, thisObj, args);
            }
        });
    }
}

