/*
 * Decompiled with CFR 0.152.
 */
package com.script.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.ClassShutter;

final class RhinoClassShutter
implements ClassShutter {
    private static Map<String, Boolean> protectedClasses;
    private static RhinoClassShutter theInstance;

    private RhinoClassShutter() {
    }

    static synchronized ClassShutter getInstance() {
        if (theInstance == null) {
            theInstance = new RhinoClassShutter();
            protectedClasses = new HashMap<String, Boolean>();
            protectedClasses.put("java.lang.Runtime", Boolean.TRUE);
            protectedClasses.put("java.io.File", Boolean.TRUE);
            protectedClasses.put("java.security.AccessController", Boolean.TRUE);
        }
        return theInstance;
    }

    @Override
    public boolean visibleToScripts(String fullClassName) {
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = fullClassName.lastIndexOf(".")) != -1) {
            try {
                sm.checkPackageAccess(fullClassName.substring(0, i));
            }
            catch (SecurityException se) {
                return false;
            }
        }
        return protectedClasses.get(fullClassName) == null;
    }
}

