/*
 * Decompiled with CFR 0.152.
 */
package com.script.javascript;

import com.script.Invocable;
import com.script.ScriptException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;

public class InterfaceImplementor {
    private Invocable engine;

    public InterfaceImplementor(Invocable engine) {
        this.engine = engine;
    }

    public <T> T getInterface(Object thiz, Class<T> iface) throws ScriptException {
        if (iface == null || !iface.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        if (!this.isImplemented(thiz, iface)) {
            return null;
        }
        AccessControlContext accCtxt = AccessController.getContext();
        return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new InterfaceImplementorInvocationHandler(thiz, accCtxt)));
    }

    protected boolean isImplemented(Object thiz, Class<?> iface) {
        return true;
    }

    protected Object convertResult(Method method, Object res) throws ScriptException {
        return res;
    }

    protected Object[] convertArguments(Method method, Object[] args) throws ScriptException {
        return args;
    }

    private final class InterfaceImplementorInvocationHandler
    implements InvocationHandler {
        private Object thiz;
        private AccessControlContext accCtxt;

        public InterfaceImplementorInvocationHandler(Object thiz, AccessControlContext accCtxt) {
            this.thiz = thiz;
            this.accCtxt = accCtxt;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            args = InterfaceImplementor.this.convertArguments(method, args);
            Method m = method;
            Object[] a = args;
            Object result = AccessController.doPrivileged(() -> {
                if (this.thiz == null) {
                    return InterfaceImplementor.this.engine.invokeFunction(m.getName(), a);
                }
                return InterfaceImplementor.this.engine.invokeMethod(this.thiz, m.getName(), a);
            }, this.accCtxt);
            return InterfaceImplementor.this.convertResult(method, result);
        }
    }
}

