<?php

namespace merapi\controllers;

use Yii;
use yii\data\ActiveDataProvider;
use yii\web\NotFoundHttpException;
use common\enums\StatusEnum;

/**
 * 个人信息访问基类
 *
 * 注意：适用于个人中心
 *
 * Class UserAuthController
 * @package merapi\controllers
 * @property yii\db\ActiveRecord|yii\base\Model $modelClass
 * @author jianyan74 <751393839@qq.com>
 */
class UserAuthController extends OnAuthController
{
    /**
     * 首页
     *
     * @return ActiveDataProvider
     */
    public function actionIndex()
    {
        return new ActiveDataProvider([
            'query' => $this->modelClass::find()
                ->where([
                    'status' => StatusEnum::ENABLED,
                    'member_id' => Yii::$app->user->identity->member_id,
                    'merchant_id' => Yii::$app->user->identity->merchant_id
                ])
                ->orderBy('id desc')
                ->asArray(),
            'pagination' => [
                'pageSize' => $this->pageSize,
                'validatePage' => false,// 超出分页不返回data
            ],
        ]);
    }

    /**
     * @param $id
     * @return \yii\db\ActiveRecord
     * @throws NotFoundHttpException
     */
    protected function findModel($id)
    {
        /* @var $model \yii\db\ActiveRecord */
        if (empty($id) || !($model = $this->modelClass::find()->where([
                'id' => $id,
                'status' => StatusEnum::ENABLED,
                'member_id' => Yii::$app->user->identity->member_id,
                'merchant_id' => Yii::$app->user->identity->merchant_id
            ])->one())) {
            throw new NotFoundHttpException('请求的数据不存在或您的权限不足.');
        }

        return $model;
    }
}
