## 开发规范

目录

- 开发说明
- 编码规范
- 框架规范
- 插件规范
- 数据库规范
- 类功能规范

### 开发说明

- 正常开发只需要开发商户端，没有 Saas 的时候商户端就是总后台，有了 Saas，商户端就是子后台
- 插件勾选了商户映射，则所有的代码开发插件对应目录的 merchant 下开发，总后台(backend)访问的 url 对应的代码在 merchant 下
- 插件不勾选商户映射，总后台和商家后台的插件代码都是独立的

### 编码规范

- 符合 PSR-1/PSR-2 的 PHP 编程
- 方法和函数有注释，注释内容包括功用，参数，返回值，必要时还有示例
- 方法命名规范，驼峰命名，不能出现下划线
- 类属性规范，类属性和类方法一致,统一使用驼峰
- 函数命名 小写字母加下划线
- 常量全部大写下划线分割
- 变量、函数名一律为小写格式
- 属性名称开头小写驼峰
- 类私有成员属性，下划线小写开头驼峰
- 以标准计算机英文为蓝本，杜绝一切拼音、或拼音英文混杂的命名方式
- PHP 的内建值 true、false 和 null 必须全部采用小写字母书写
- 文件编码为 UTF-8，并关闭 UTF-8 BOM((Byte Order Mark))的功能。切记请不要使用windows自带的记事本编辑项目文件

### 框架规范

- 自定义助手函数都放在 `common\helpers\` 且方法都为static方法
- Url助手函数必须使用 `common\helpers\Url`，用法和Yii2自带一样多了功能
- Html助手函数必须使用 `common\helpers\Html`，用法和Yii2自带一样多了功能
- 模型统一在`common\models\`下对应的是各个模块的模型，私有的表单模型可在各种应用/模块下面创建
- 状态枚举统一调用`common\enums\StatusEnum.php`中的常量和属性
- 每个应用下面应有一个基础控制器，做为该应用的父控制器，方便做一些公共操作,默认父类控制器为`BaseController`
- 超级管理员在各自应用下的 `config\params.php` 的adminAccount项中定义其UID，超级管理员不需要进行RBAC权限检查
- 公共别名在 `common\config\bootstrap.php` 中定义，使用 `Yii::getAlias()` 访问
- View 视图调用 `Model` 的变量及数据不能直接调用，须控制器传递才可使用
- Service 层在根目录下，统一带上`Service`后缀，例如`TestService`
- Service 层不允许使用事务
- Service 层如果需要当前用户信息必须通过传递参数获取
- 商户 ID 为 1 的默认被总后台占用，如果使用多商户请不要占用该 ID

### 插件规范

- 插件命名统一大写驼峰
- 资源文件在 当前插件根目录/应用/resource下
- 模型为当前插件的common/models下
- 更新文件更新表结构时候无法触发事务，需要单独设定版本号避免全部事务触发失败

### 数据库规范

命名规范

- 数据表名小写，多关键字使用下划线分割（关键字尽量全称）
- 字段名小写，多关键字使用下划线分割（关键字尽量全称）
- 禁止使用保留字并且尽量少用含有关键词来命名
- 临时表必须以tmp_开头、以日期结尾，备份表必须以bak_开头、以日期结尾

基础规范

- 所有的字段必须添加注释
- 尽可能地使用InnoDB作为表的存储引擎
- 数据库和数据表统一使用 `UTF8MB4` 字符编码
- 所有的表和字段必须添加注释
- 尽量控制表行数在500万以内
- 尽可能采用冷热数据分离策略
- 禁止以图片、文件等二进制数据

表设计规范

- 尽可能每张表的索引数量控制在5个以内
- 每一张InnoDB表都必须含有一个主键
- 尽可能避免使用外键约束
- 设置数据表架构应考虑后期扩展型
- 遵循范式与冗余平衡原则

字段设计规范

- 尽可能将所有的数据列定义为 `NOT NULL` 类型
- 避免 ENUM 数据类型
- json 存储的数据用 `json`字段代替 `text`
- 表与表关联的键名保持一致或以关联表名的缩写为前缀
- 固定长度的字符串字段务必使用 `char`
- 使用 `UNSIGNEG` 存储非负整数
- 禁止敏感数据以明文形式存储
- 金额相关的数据必须使用 `DECIMAL` 数据类型
- 尽量所有表有 `status` 字段来标注数据状态(-1:已删除,0:禁用,1:正常)，业务状态请使用其他字段；`status`字段类型 为带符号的 `tinyint(4)`。如果还需要其他的数据状态 请先判断该状态的数据是有用的数据还是无意义的数据,有用的数据状态 > 2,无意义的数据状态 < -1
- 所有的删除（除开清空回收站操作） 请标记 `status` 为 -1
- 创建时间字段为`created_at`，修改时间字段为`updated_at`，类型int(10)
- 用户关联 id 为 `member_id`
- 商户 id 为 `merchant_id`
- 多应用用户 id 混合使用字段用 `user_id`
- 排序字段为 `sort`
- 区分应用字段为 `app_id`
- 区分插件来源需要增加字段为 `addons_name` 和 `is_addon`

### 类功能规范

##### Model(模型)

- 数据库字段管理
- 数据库关联管理
- 数据库触发行为
- 数据库入库验证

##### Form(模型 - 验证)

- 对提交的复杂数据进行验证处理返回

##### View(视图)

- 数据处理显示

##### Controller(控制器)

- 数据接收
- 服务调用
- 简单CURD入库
- 页面渲染

##### Service(服务 - 包含仓库「Repository」功能)

- 数据逻辑处理
- 数据入库
- 数据查询 (Repository)