## 钩子

> 注意：如果钩子方法存在但是无法调用，请检查配置内(Addon.php)是否把hook设置了false或者该模块已经被卸载。修改配置文件后需要重新安装才会生效。  

> 注意：钩子不适合挂太重的业务

目录

- 如何使用钩子?
- 运行过程
- 什么是钩子？

### 如何使用钩子?

参数说明

```
/**
* 实例化钩子
*
* @param string $addonsName 模块名称 如果想自定义钩子方法可以用插件名称.方法，例如 RfExample.test
* @param array $params 传递参数
* @param bool $debug 开发者模式 是否开启报错 默认false
* @return bool
* @throws NotFoundHttpException
*/
<?= \common\helpers\Hook::to($addonsName, $params, $debug); ?>

// 实际案例
<?= \common\helpers\Hook::to('RfExample', []); ?>
```

实际例子

```
<?= \common\helpers\Hook::to('RfExample', ['test' => 1]); ?>
```

### 运行过程

- 初始化了模块信息
- 初始化的路由信息
- 实例化控制器
- 执行钩子

上面的例子实例化

```
\addons\RfExample\backend\controllers\SettingController
```

执行钩子

```
/**
 * 钩子
 *
 * @param array $param
 * @return mixed|string
 */
public function actionHook($param = [])
{
    return $this->render('hook', [
        'param' => $param
    ]);
}
```

在钩子视图或者控制器打印一下`$param`

```
Array
(
    [test] => 1
)
```    

### 什么是钩子？

> 引用onethink的钩子说明

讲到插件，不得不讲钩子。首先，我们之前说明了插件是一个扩展的功能实现。

既然是扩展的，那么就要很灵活、可复用，并不是像我们之前开发项目，一个功能实现了，就写死在代码里了。

项目其他地方要用了，怎么办，复制一份改个名，改的那个地方能调用实现。这样一次两次可以，次数多了就不行了。

因为后面每次开发的底层架构在不断变化。不断重复的功能版本造成人力的浪费。我们做成插件的目的就是为了方便大家扩展我们这个产品的功能。到时候形成规模，大家自由的搭建自己的站点就方便了。

那么如何让一个扩展的功能在多个地方可随意的使用呢。那就用到了我们的钩子。

为什么叫它钩子呢？因为它的作用就是如此和生活中的钩子类似。

打个比方，我们做的网站比作一个有多个功能的立式衣架。

这个衣架给什么人用就有不同的用途。

假如你专门用来挂大衣的，那就是大衣衣架。如果你专门挂袋子，那就是一个储物衣架。

当你不想要某个挂件、衣服时，取下来即可。并不会破坏原有的袋子或者衣服的功能。

你挂与不挂，钩子就在那里。

为什么能挂那么多东西呢？说明被挂的东西都符合一个标准：能挂的住。

换作你挂一个橡皮泥、或者棉花之类的。挂不了多久就会掉了。因为他们不符合要有部分封闭的可固定的这一个部分的标准。

还有挂一个太重的比如10个背包挂一个钩子上。要么架子毁了，要么钩子断了。总之就是挂不住。

因为任何一个钩子都有其承重上限。你加起来的超过了，肯定不行。

所以我们不能把插件当成万能的使，什么东西都整成插件，不管功能的大小。

任何系统都有瓶颈，你不能把个重量级的东西做成插件后挂上，说不定以后就会影响整个站点。就违背了插件的独立性原则。那些就不应该做成插件而是做成模型扩展或者应用扩展。