<?php

use yii\db\Migration;

class m200529_152447_rbac_auth_item extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%rbac_auth_item}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'name' => "varchar(64) NOT NULL DEFAULT '' COMMENT '别名'",
            'title' => "varchar(200) NULL DEFAULT '' COMMENT '标题'",
            'app_id' => "varchar(20) NOT NULL DEFAULT '' COMMENT '应用'",
            'addons_name' => "varchar(200) NULL DEFAULT '' COMMENT '插件名称'",
            'pid' => "int(10) NULL DEFAULT '0' COMMENT '父级id'",
            'level' => "int(5) NULL DEFAULT '1' COMMENT '级别'",
            'is_addon' => "tinyint(1) unsigned NULL DEFAULT '0' COMMENT '是否插件'",
            'sort' => "int(10) NULL DEFAULT '9999' COMMENT '排序'",
            'tree' => "varchar(500) NULL DEFAULT '' COMMENT '树'",
            'status' => "tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态[-1:删除;0:禁用;1启用]'",
            'created_at' => "int(11) NULL DEFAULT '0'",
            'updated_at' => "int(11) NULL DEFAULT '0'",
            'PRIMARY KEY (`id`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='公用_权限表'");
        
        /* 索引设置 */
        
        
        /* 表数据 */
        $this->insert('{{%rbac_auth_item}}',['id'=>'1','name'=>'base','title'=>'系统基础','app_id'=>'backend','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'2','name'=>'/base/member/personal','title'=>'个人中心','app_id'=>'backend','addons_name'=>'','pid'=>'1','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_1 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'3','name'=>'/base/member/up-password','title'=>'修改密码','app_id'=>'backend','addons_name'=>'','pid'=>'1','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_1 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'4','name'=>'/main/clear-cache','title'=>'清理缓存','app_id'=>'backend','addons_name'=>'','pid'=>'1','level'=>'2','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_1 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'5','name'=>'baseAnnounce','title'=>'查看消息','app_id'=>'backend','addons_name'=>'','pid'=>'1','level'=>'2','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_1 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'6','name'=>'/notify/announce','title'=>'公告列表','app_id'=>'backend','addons_name'=>'','pid'=>'5','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_1 tr_5 ','status'=>'1','created_at'=>'1582376897','updated_at'=>'1582376897']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'7','name'=>'/notify/announce-view','title'=>'公告详情','app_id'=>'backend','addons_name'=>'','pid'=>'5','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_1 tr_5 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'8','name'=>'/notify/message','title'=>'私信列表','app_id'=>'backend','addons_name'=>'','pid'=>'5','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_1 tr_5 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'9','name'=>'/notify/remind','title'=>'提醒列表','app_id'=>'backend','addons_name'=>'','pid'=>'5','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_1 tr_5 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'10','name'=>'cate:1','title'=>'平台首页','app_id'=>'backend','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'11','name'=>'indexMember','title'=>'会员管理','app_id'=>'backend','addons_name'=>'','pid'=>'10','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'12','name'=>'indexMemberInfo','title'=>'会员信息','app_id'=>'backend','addons_name'=>'','pid'=>'11','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_11 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'13','name'=>'/member/member/recharge','title'=>'充值','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'14','name'=>'/member/member/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'15','name'=>'/member/member/edit','title'=>'编辑','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'16','name'=>'/member/member/ajax-edit','title'=>'新增/账号密码','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'17','name'=>'/member/member/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'18','name'=>'/member/member/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'5','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'19','name'=>'indexMemberAddress','title'=>'收货地址','app_id'=>'backend','addons_name'=>'','pid'=>'12','level'=>'4','is_addon'=>'0','sort'=>'6','tree'=>'tr_0 tr_10 tr_11 tr_12 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'20','name'=>'/member/address/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'19','level'=>'5','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_11 tr_12 tr_19 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'21','name'=>'/member/address/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'19','level'=>'5','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_11 tr_12 tr_19 ','status'=>'1','created_at'=>'1582376898','updated_at'=>'1582376898']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'22','name'=>'/member/address/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'19','level'=>'5','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 tr_11 tr_12 tr_19 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'23','name'=>'/member/address/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'19','level'=>'5','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_10 tr_11 tr_12 tr_19 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'24','name'=>'indexMemberAuth','title'=>'第三方授权','app_id'=>'backend','addons_name'=>'','pid'=>'11','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_11 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'25','name'=>'/member/auth/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'24','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_11 tr_24 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'26','name'=>'/member/auth/edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'24','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_11 tr_24 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'27','name'=>'/member/auth/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'24','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 tr_11 tr_24 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'28','name'=>'/member/auth/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'24','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_10 tr_11 tr_24 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'29','name'=>'memberCreditsLog','title'=>'会员日志','app_id'=>'backend','addons_name'=>'','pid'=>'10','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'30','name'=>'/member/credits-log/index','title'=>'消费日志','app_id'=>'backend','addons_name'=>'','pid'=>'29','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_29 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'31','name'=>'/member/credits-log/integral','title'=>'积分日志','app_id'=>'backend','addons_name'=>'','pid'=>'29','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_29 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'32','name'=>'/member/credits-log/money','title'=>'余额日志','app_id'=>'backend','addons_name'=>'','pid'=>'29','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 tr_29 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'33','name'=>'memberRechargeConfig','title'=>'充值配置','app_id'=>'backend','addons_name'=>'','pid'=>'10','level'=>'2','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'34','name'=>'/member/recharge-config/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'33','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_10 tr_33 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'35','name'=>'/member/recharge-config/edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'33','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_10 tr_33 ','status'=>'1','created_at'=>'1582376899','updated_at'=>'1582376899']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'36','name'=>'/member/recharge-config/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'33','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_10 tr_33 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'37','name'=>'/member/recharge-config/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'33','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_10 tr_33 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'38','name'=>'cate:2','title'=>'系统管理','app_id'=>'backend','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'39','name'=>'/common/config/edit-all','title'=>'网站设置','app_id'=>'backend','addons_name'=>'','pid'=>'38','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'40','name'=>'/common/config/update-info','title'=>'数据保存','app_id'=>'backend','addons_name'=>'','pid'=>'39','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_39 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'41','name'=>'commonFunction','title'=>'系统功能','app_id'=>'backend','addons_name'=>'','pid'=>'38','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'42','name'=>'commonAddons','title'=>'应用管理','app_id'=>'backend','addons_name'=>'','pid'=>'41','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'43','name'=>'/common/addons/index','title'=>'已安装插件','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'44','name'=>'/common/addons/local','title'=>'本地插件','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'45','name'=>'/common/addons/install','title'=>'安装插件','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'46','name'=>'/common/addons/un-install','title'=>'卸载插件','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'47','name'=>'/common/addons/create','title'=>'设计插件','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'48','name'=>'/common/addons/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'5','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'49','name'=>'/common/addons/ajax-edit','title'=>'编辑','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'6','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376900','updated_at'=>'1582376900']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'50','name'=>'/common/addons/upgrade','title'=>'更新数据库','app_id'=>'backend','addons_name'=>'','pid'=>'42','level'=>'4','is_addon'=>'0','sort'=>'7','tree'=>'tr_0 tr_38 tr_41 tr_42 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'51','name'=>'commonConfig','title'=>'配置管理','app_id'=>'backend','addons_name'=>'','pid'=>'41','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'52','name'=>'/common/config/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'51','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_51 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'53','name'=>'/common/config/ajax-edit','title'=>'编辑','app_id'=>'backend','addons_name'=>'','pid'=>'51','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_51 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'54','name'=>'/common/config/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'51','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_51 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'55','name'=>'/common/config/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'51','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 tr_51 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'56','name'=>'commonConfigCate','title'=>'配置分类','app_id'=>'backend','addons_name'=>'','pid'=>'51','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_41 tr_51 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'57','name'=>'/common/config-cate/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'56','level'=>'5','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_51 tr_56 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'58','name'=>'/common/config-cate/ajax-edit','title'=>'编辑','app_id'=>'backend','addons_name'=>'','pid'=>'56','level'=>'5','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_51 tr_56 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'59','name'=>'/common/config-cate/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'56','level'=>'5','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_51 tr_56 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'60','name'=>'/common/config-cate/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'56','level'=>'5','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 tr_51 tr_56 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'61','name'=>'commonMenu','title'=>'后台菜单','app_id'=>'backend','addons_name'=>'','pid'=>'41','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'62','name'=>'/common/menu/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'61','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_61 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'63','name'=>'/common/menu/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'61','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_61 ','status'=>'1','created_at'=>'1582376901','updated_at'=>'1582376901']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'64','name'=>'/common/menu/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'61','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_61 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'65','name'=>'/common/menu/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'61','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 tr_61 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'66','name'=>'commonMenuCate','title'=>'菜单分类','app_id'=>'backend','addons_name'=>'','pid'=>'61','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_41 tr_61 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'67','name'=>'/common/menu-cate/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'66','level'=>'5','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_61 tr_66 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'68','name'=>'/common/menu-cate/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'66','level'=>'5','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_61 tr_66 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'69','name'=>'/common/menu-cate/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'66','level'=>'5','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_61 tr_66 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'70','name'=>'/common/menu-cate/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'66','level'=>'5','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 tr_61 tr_66 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'71','name'=>'commonNotifyAnnounce','title'=>'公告管理','app_id'=>'backend','addons_name'=>'','pid'=>'41','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_41 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'72','name'=>'/base/notify-announce/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'71','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_71 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'73','name'=>'/base/notify-announce/edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'71','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_71 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'74','name'=>'/base/notify-announce/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'71','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_71 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'75','name'=>'commonNotifyMessage','title'=>'私信管理','app_id'=>'backend','addons_name'=>'','pid'=>'41','level'=>'3','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_41 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'76','name'=>'/base/notify-message/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'75','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_41 tr_75 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'77','name'=>'/base/notify-message/ajax-edit','title'=>'新增','app_id'=>'backend','addons_name'=>'','pid'=>'75','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_41 tr_75 ','status'=>'1','created_at'=>'1582376902','updated_at'=>'1582376902']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'78','name'=>'/base/notify-message/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'75','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_41 tr_75 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'79','name'=>'backendMemberAuth','title'=>'用户权限','app_id'=>'backend','addons_name'=>'','pid'=>'38','level'=>'2','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'80','name'=>'backendMember','title'=>'后台用户','app_id'=>'backend','addons_name'=>'','pid'=>'79','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_79 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'81','name'=>'/base/member/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'80','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_79 tr_80 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'82','name'=>'/base/member/ajax-edit','title'=>'新增/账号密码','app_id'=>'backend','addons_name'=>'','pid'=>'80','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_79 tr_80 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'83','name'=>'/base/member/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'80','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_79 tr_80 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'84','name'=>'/base/member/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'80','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_79 tr_80 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'85','name'=>'/base/member/edit','title'=>'编辑','app_id'=>'backend','addons_name'=>'','pid'=>'80','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_79 tr_80 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'86','name'=>'baseAuthItem','title'=>'权限管理','app_id'=>'backend','addons_name'=>'','pid'=>'79','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_79 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'87','name'=>'/base/auth-item/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'86','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_79 tr_86 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'88','name'=>'/base/auth-item/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'86','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_79 tr_86 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'89','name'=>'/base/auth-item/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'86','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_79 tr_86 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'90','name'=>'/base/auth-item/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'86','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_79 tr_86 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'91','name'=>'basenAuthRole','title'=>'角色管理','app_id'=>'backend','addons_name'=>'','pid'=>'79','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_79 ','status'=>'1','created_at'=>'1582376903','updated_at'=>'1582376903']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'92','name'=>'/base/auth-role/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'91','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_79 tr_91 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'93','name'=>'/base/auth-role/edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'91','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_79 tr_91 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'94','name'=>'/base/auth-role/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'91','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_79 tr_91 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'95','name'=>'/base/auth-role/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'91','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_79 tr_91 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'96','name'=>'oauth2Client','title'=>'客户授权','app_id'=>'backend','addons_name'=>'','pid'=>'38','level'=>'2','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'97','name'=>'/oauth2/client/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'96','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_96 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'98','name'=>'/oauth2/client/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'96','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_96 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'99','name'=>'/oauth2/client/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'96','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_96 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'100','name'=>'/oauth2/client/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'96','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_96 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'101','name'=>'commonTool','title'=>'系统工具','app_id'=>'backend','addons_name'=>'','pid'=>'38','level'=>'2','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'102','name'=>'/common/system/info','title'=>'系统信息','app_id'=>'backend','addons_name'=>'','pid'=>'101','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_101 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'103','name'=>'commonAttachment','title'=>'资源文件','app_id'=>'backend','addons_name'=>'','pid'=>'101','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_101 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'104','name'=>'/common/attachment/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'103','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_101 tr_103 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'105','name'=>'/common/attachment/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'103','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_101 tr_103 ','status'=>'1','created_at'=>'1582376904','updated_at'=>'1582376904']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'106','name'=>'/common/attachment/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'103','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_101 tr_103 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'107','name'=>'commonLog','title'=>'查看日志','app_id'=>'backend','addons_name'=>'','pid'=>'101','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_101 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'108','name'=>'/common/action-log/index','title'=>'行为日志','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'109','name'=>'/common/action-log/view','title'=>'行为日志详情','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'110','name'=>'/common/log/index','title'=>'报错日志','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'111','name'=>'/common/log/view','title'=>'报错日志详情','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'112','name'=>'/common/pay-log/index','title'=>'支付日志','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'113','name'=>'/common/pay-log/view','title'=>'支付日志详情','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'5','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'114','name'=>'/common/sms-log/index','title'=>'短信日志','app_id'=>'backend','addons_name'=>'','pid'=>'107','level'=>'4','is_addon'=>'0','sort'=>'6','tree'=>'tr_0 tr_38 tr_101 tr_107 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'115','name'=>'commonIpBlacklist','title'=>'IP黑名单','app_id'=>'backend','addons_name'=>'','pid'=>'101','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_101 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'116','name'=>'/common/ip-blacklist/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'115','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_101 tr_115 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'117','name'=>'/common/ip-blacklist/destroy','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'115','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_101 tr_115 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'118','name'=>'/common/ip-blacklist/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'115','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_101 tr_115 ','status'=>'1','created_at'=>'1582376905','updated_at'=>'1582376905']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'119','name'=>'/common/ip-blacklist/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'115','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_101 tr_115 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'120','name'=>'commonActionBehavior','title'=>'行为监控','app_id'=>'backend','addons_name'=>'','pid'=>'101','level'=>'3','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_38 tr_101 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'121','name'=>'/common/action-behavior/index','title'=>'首页','app_id'=>'backend','addons_name'=>'','pid'=>'120','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_38 tr_101 tr_120 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'122','name'=>'/common/action-behavior/ajax-edit','title'=>'新增/编辑','app_id'=>'backend','addons_name'=>'','pid'=>'120','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_38 tr_101 tr_120 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'123','name'=>'/common/action-behavior/delete','title'=>'删除','app_id'=>'backend','addons_name'=>'','pid'=>'120','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_38 tr_101 tr_120 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'124','name'=>'/common/action-behavior/ajax-update','title'=>'状态修改','app_id'=>'backend','addons_name'=>'','pid'=>'120','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_38 tr_101 tr_120 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'125','name'=>'cate:3','title'=>'应用中心','app_id'=>'backend','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376906','updated_at'=>'1582376906']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'126','name'=>'base','title'=>'系统基础','app_id'=>'merchant','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'127','name'=>'/base/member/personal','title'=>'个人中心','app_id'=>'merchant','addons_name'=>'','pid'=>'126','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_126 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'128','name'=>'/base/member/up-password','title'=>'修改密码','app_id'=>'merchant','addons_name'=>'','pid'=>'126','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_126 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'129','name'=>'cate:4','title'=>'平台首页','app_id'=>'merchant','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'130','name'=>'indexMember','title'=>'会员管理','app_id'=>'merchant','addons_name'=>'','pid'=>'129','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'131','name'=>'indexMemberInfo','title'=>'会员信息','app_id'=>'merchant','addons_name'=>'','pid'=>'130','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_130 ','status'=>'1','created_at'=>'1582376927','updated_at'=>'1582376927']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'132','name'=>'/member/member/recharge','title'=>'充值','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'133','name'=>'/member/member/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'134','name'=>'/member/member/edit','title'=>'编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'135','name'=>'/member/member/ajax-edit','title'=>'新增/账号密码','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'136','name'=>'/member/member/destroy','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'137','name'=>'/member/member/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'5','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'138','name'=>'indexMemberAddress','title'=>'收货地址','app_id'=>'merchant','addons_name'=>'','pid'=>'131','level'=>'4','is_addon'=>'0','sort'=>'6','tree'=>'tr_0 tr_129 tr_130 tr_131 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'139','name'=>'/member/address/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'138','level'=>'5','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_130 tr_131 tr_138 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'140','name'=>'/member/address/ajax-edit','title'=>'新增/编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'138','level'=>'5','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_130 tr_131 tr_138 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'141','name'=>'/member/address/destroy','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'138','level'=>'5','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 tr_130 tr_131 tr_138 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'142','name'=>'/member/address/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'138','level'=>'5','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_129 tr_130 tr_131 tr_138 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'143','name'=>'indexMemberAuth','title'=>'第三方授权','app_id'=>'merchant','addons_name'=>'','pid'=>'130','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_130 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'144','name'=>'/member/auth/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'143','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_130 tr_143 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'145','name'=>'/member/auth/edit','title'=>'新增/编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'143','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_130 tr_143 ','status'=>'1','created_at'=>'1582376928','updated_at'=>'1582376928']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'146','name'=>'/member/auth/destroy','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'143','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 tr_130 tr_143 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'147','name'=>'/member/auth/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'143','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_129 tr_130 tr_143 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'148','name'=>'memberCreditsLog','title'=>'会员日志','app_id'=>'merchant','addons_name'=>'','pid'=>'129','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'149','name'=>'/member/credits-log/index','title'=>'消费日志','app_id'=>'merchant','addons_name'=>'','pid'=>'148','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_148 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'150','name'=>'/member/credits-log/integral','title'=>'积分日志','app_id'=>'merchant','addons_name'=>'','pid'=>'148','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_148 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'151','name'=>'/member/credits-log/money','title'=>'余额日志','app_id'=>'merchant','addons_name'=>'','pid'=>'148','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 tr_148 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'152','name'=>'memberRechargeConfig','title'=>'充值配置','app_id'=>'merchant','addons_name'=>'','pid'=>'129','level'=>'2','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'153','name'=>'/member/recharge-config/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'152','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_129 tr_152 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'154','name'=>'/member/recharge-config/edit','title'=>'新增/编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'152','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_129 tr_152 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'155','name'=>'/member/recharge-config/delete','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'152','level'=>'3','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_129 tr_152 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'156','name'=>'/member/recharge-config/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'152','level'=>'3','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_129 tr_152 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'157','name'=>'cate:4','title'=>'系统管理','app_id'=>'merchant','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'158','name'=>'/common/config/edit-all','title'=>'网站设置','app_id'=>'merchant','addons_name'=>'','pid'=>'157','level'=>'2','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_157 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'159','name'=>'/common/config/update-info','title'=>'数据保存','app_id'=>'merchant','addons_name'=>'','pid'=>'158','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_157 tr_158 ','status'=>'1','created_at'=>'1582376929','updated_at'=>'1582376929']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'160','name'=>'merchantMemberAuth','title'=>'用户权限','app_id'=>'merchant','addons_name'=>'','pid'=>'157','level'=>'2','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_157 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'161','name'=>'merchantMember','title'=>'后台用户','app_id'=>'merchant','addons_name'=>'','pid'=>'160','level'=>'3','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_157 tr_160 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'162','name'=>'/base/member/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'161','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_157 tr_160 tr_161 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'163','name'=>'/base/member/ajax-edit','title'=>'新增/账号密码','app_id'=>'merchant','addons_name'=>'','pid'=>'161','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_157 tr_160 tr_161 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'164','name'=>'/base/member/destroy','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'161','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_157 tr_160 tr_161 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'165','name'=>'/base/member/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'161','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_157 tr_160 tr_161 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'166','name'=>'/base/member/edit','title'=>'编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'161','level'=>'4','is_addon'=>'0','sort'=>'4','tree'=>'tr_0 tr_157 tr_160 tr_161 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'167','name'=>'baseAuthRole','title'=>'角色管理','app_id'=>'merchant','addons_name'=>'','pid'=>'160','level'=>'3','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_157 tr_160 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'168','name'=>'/base/auth-role/index','title'=>'首页','app_id'=>'merchant','addons_name'=>'','pid'=>'167','level'=>'4','is_addon'=>'0','sort'=>'0','tree'=>'tr_0 tr_157 tr_160 tr_167 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'169','name'=>'/base/auth-role/edit','title'=>'新增/编辑','app_id'=>'merchant','addons_name'=>'','pid'=>'167','level'=>'4','is_addon'=>'0','sort'=>'1','tree'=>'tr_0 tr_157 tr_160 tr_167 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'170','name'=>'/base/auth-role/delete','title'=>'删除','app_id'=>'merchant','addons_name'=>'','pid'=>'167','level'=>'4','is_addon'=>'0','sort'=>'2','tree'=>'tr_0 tr_157 tr_160 tr_167 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'171','name'=>'/base/auth-role/ajax-update','title'=>'状态修改','app_id'=>'merchant','addons_name'=>'','pid'=>'167','level'=>'4','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 tr_157 tr_160 tr_167 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        $this->insert('{{%rbac_auth_item}}',['id'=>'172','name'=>'cate:5','title'=>'应用中心','app_id'=>'merchant','addons_name'=>'','pid'=>'0','level'=>'1','is_addon'=>'0','sort'=>'3','tree'=>'tr_0 ','status'=>'1','created_at'=>'1582376930','updated_at'=>'1582376930']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%rbac_auth_item}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

