<?php

use yii\db\Migration;

class m200529_152445_common_provinces extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%common_provinces}}', [
            'id' => "int(10) NOT NULL COMMENT 'ID'",
            'title' => "varchar(50) NOT NULL DEFAULT '' COMMENT '栏目名'",
            'pid' => "int(10) NOT NULL DEFAULT '0' COMMENT '父栏目'",
            'short_title' => "varchar(50) NULL DEFAULT '' COMMENT '缩写'",
            'areacode' => "int(6) NULL DEFAULT '0' COMMENT '区域编码'",
            'zipcode' => "int(10) NULL DEFAULT '0' COMMENT '邮政编码'",
            'pinyin' => "varchar(100) NULL DEFAULT '' COMMENT '拼音'",
            'lng' => "varchar(20) NULL DEFAULT '' COMMENT '经度'",
            'lat' => "varchar(20) NULL DEFAULT '' COMMENT '纬度'",
            'level' => "tinyint(4) NOT NULL DEFAULT '1' COMMENT '级别'",
            'tree' => "varchar(200) NOT NULL",
            'sort' => "tinyint(3) unsigned NULL DEFAULT '0' COMMENT '排序'",
            'PRIMARY KEY (`id`)'
        ], "ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COMMENT='公用_省市区记录表'");
        
        /* 索引设置 */
        $this->createIndex('parentid','{{%common_provinces}}','pid',0);
        
        
        /* 表数据 */
        $this->insert('{{%common_provinces}}',['id'=>'810000','title'=>'香港特别行政区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.18612410257','lat'=>'22.29358599328','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810100','title'=>'九龙','pid'=>'810000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'101.51341566718','lat'=>'29.006431902925','level'=>'2','tree'=>'tr_0 tr_810000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810101','title'=>'观塘区','pid'=>'810100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.23743100142','lat'=>'22.316803500017','level'=>'3','tree'=>'tr_0 tr_810000 tr_810100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810102','title'=>'黄大仙区','pid'=>'810100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.2055528338','lat'=>'22.344516581114','level'=>'3','tree'=>'tr_0 tr_810000 tr_810100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810103','title'=>'九龙城区','pid'=>'810100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.19855413557','lat'=>'22.325722838593','level'=>'3','tree'=>'tr_0 tr_810000 tr_810100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810104','title'=>'深水埗区','pid'=>'810100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.17556515012','lat'=>'22.334814518942','level'=>'3','tree'=>'tr_0 tr_810000 tr_810100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810105','title'=>'油尖旺区','pid'=>'810100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.17854456','lat'=>'22.306583887776','level'=>'3','tree'=>'tr_0 tr_810000 tr_810100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810200','title'=>'香港岛','pid'=>'810000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.1838696432','lat'=>'22.272099587606','level'=>'2','tree'=>'tr_0 tr_810000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810201','title'=>'东区','pid'=>'810200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.03675495515','lat'=>'32.983906128946','level'=>'3','tree'=>'tr_0 tr_810000 tr_810200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810202','title'=>'南区','pid'=>'810200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.18612410257','lat'=>'22.29358599328','level'=>'3','tree'=>'tr_0 tr_810000 tr_810200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810203','title'=>'湾仔区','pid'=>'810200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.1838696432','lat'=>'22.272099587606','level'=>'3','tree'=>'tr_0 tr_810000 tr_810200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810204','title'=>'中西区','pid'=>'810200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.15949141031','lat'=>'22.291342714292','level'=>'3','tree'=>'tr_0 tr_810000 tr_810200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810300','title'=>'新界','pid'=>'810000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.18612410257','lat'=>'22.29358599328','level'=>'2','tree'=>'tr_0 tr_810000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810301','title'=>'北区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'114.56208137457','lat'=>'38.029818054403','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810302','title'=>'大埔区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.14670082713','lat'=>'22.427434108219','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810303','title'=>'葵青区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'114.14347453324','lat'=>'22.36661881253','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810304','title'=>'离岛区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.95154733906','lat'=>'22.286066480198','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810305','title'=>'荃湾区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.126440954','lat'=>'22.378243962528','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810306','title'=>'沙田区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.19855144065','lat'=>'22.388522255034','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810307','title'=>'屯门区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.98745602385','lat'=>'22.393584799271','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810308','title'=>'西贡区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.28352485373','lat'=>'22.385077305939','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'810309','title'=>'元朗区','pid'=>'810300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.03850969037','lat'=>'22.448564780865','level'=>'3','tree'=>'tr_0 tr_810000 tr_810300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820000','title'=>'澳门特别行政区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'113.55751910182','lat'=>'22.204117988443','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820100','title'=>'离岛','pid'=>'820000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.55751910182','lat'=>'22.204117988443','level'=>'2','tree'=>'tr_0 tr_820000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820101','title'=>'嘉模堂区','pid'=>'820100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.56551473951','lat'=>'22.163142309955','level'=>'3','tree'=>'tr_0 tr_820000 tr_820100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820102','title'=>'路氹填海区','pid'=>'820100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.95154733906','lat'=>'22.286066480198','level'=>'3','tree'=>'tr_0 tr_820000 tr_820100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820103','title'=>'圣方济各堂区','pid'=>'820100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.95154733906','lat'=>'22.286066480198','level'=>'3','tree'=>'tr_0 tr_820000 tr_820100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820200','title'=>'澳门半岛','pid'=>'820000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'113.56643233517','lat'=>'22.195004159218','level'=>'2','tree'=>'tr_0 tr_820000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820201','title'=>'大堂区','pid'=>'820200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.55648488269','lat'=>'22.18919700752','level'=>'3','tree'=>'tr_0 tr_820000 tr_820200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820202','title'=>'风顺堂区','pid'=>'820200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.54545108595','lat'=>'22.192783044934','level'=>'3','tree'=>'tr_0 tr_820000 tr_820200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820203','title'=>'花地玛堂区','pid'=>'820200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.55751029843','lat'=>'22.212783524768','level'=>'3','tree'=>'tr_0 tr_820000 tr_820200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820204','title'=>'花王堂区','pid'=>'820200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.5544936987','lat'=>'22.206635725923','level'=>'3','tree'=>'tr_0 tr_820000 tr_820200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'820205','title'=>'望德堂区','pid'=>'820200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.5615137766','lat'=>'22.202511136588','level'=>'3','tree'=>'tr_0 tr_820000 tr_820200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830000','title'=>'台湾省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830100','title'=>'台北市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830101','title'=>'中正区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830102','title'=>'大同区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.81937675979','lat'=>'46.045583951311','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830103','title'=>'中山区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.65154739367','lat'=>'38.924511115496','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830104','title'=>'万华区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830105','title'=>'信义区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830106','title'=>'松山区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.9394138505','lat'=>'42.292481572694','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830107','title'=>'大安区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.78041635328','lat'=>'29.369928541322','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830108','title'=>'南港区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830109','title'=>'北投区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830110','title'=>'内湖区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830111','title'=>'士林区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830112','title'=>'文山区','pid'=>'830100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.5201088108','lat'=>'25.063029935612','level'=>'3','tree'=>'tr_0 tr_830000 tr_830100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830200','title'=>'新北市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830201','title'=>'板桥区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.46374631322','lat'=>'25.009264935203','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830202','title'=>'土城区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.45638215646','lat'=>'24.969575575642','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830203','title'=>'新庄区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.44987794847','lat'=>'25.035900513246','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830204','title'=>'新店区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.54851057293','lat'=>'24.931579077246','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830205','title'=>'深坑区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.63248449446','lat'=>'25.000182732355','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830206','title'=>'石碇区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.64666268478','lat'=>'24.953083429509','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830207','title'=>'坪林区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.73478767877','lat'=>'24.915696554977','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830208','title'=>'乌来区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.53050817209','lat'=>'24.786532168822','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830209','title'=>'五股区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.44461965429','lat'=>'25.100233770435','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830210','title'=>'八里区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.40465098523','lat'=>'25.130119585774','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830211','title'=>'林口区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.35894397022','lat'=>'25.103036147515','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830212','title'=>'淡水区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'121.47260573633','lat'=>'25.187238161176','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830213','title'=>'中和区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.97751429276','lat'=>'31.836323947624','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830214','title'=>'永和区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.52736966421','lat'=>'25.010500528231','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830215','title'=>'三重区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.49687574316','lat'=>'25.069790814298','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830216','title'=>'芦洲区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.47982274435','lat'=>'25.091134839883','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830217','title'=>'泰山区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.14141108582','lat'=>'36.199444601195','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830218','title'=>'树林区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.412622083','lat'=>'24.984757647837','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830219','title'=>'莺歌区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.35899891418','lat'=>'24.958676651245','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830220','title'=>'三峡区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.42609502893','lat'=>'24.87480469353','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830221','title'=>'汐止区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.66100298061','lat'=>'25.086721897126','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830222','title'=>'金山区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.34848004512','lat'=>'30.74785237657','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830223','title'=>'万里区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.66558782234','lat'=>'25.179420721026','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830224','title'=>'三芝区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.53552324466','lat'=>'25.233947831353','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830225','title'=>'石门区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.59364212175','lat'=>'25.261063301582','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830226','title'=>'瑞芳区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'121.81592241951','lat'=>'25.092372901641','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830227','title'=>'贡寮区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.92278316131','lat'=>'25.044375645825','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830228','title'=>'双溪区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.8310510997','lat'=>'25.001750367683','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830229','title'=>'平溪区','pid'=>'830200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.75897792057','lat'=>'25.028954662262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830300','title'=>'桃园市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830301','title'=>'桃园区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830302','title'=>'中坜区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830303','title'=>'平镇区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830304','title'=>'八德区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830305','title'=>'杨梅区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.86164512823','lat'=>'21.447395667888','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830306','title'=>'芦竹区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830307','title'=>'大溪区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830308','title'=>'龙潭区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'126.56854459242','lat'=>'43.91634255363','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830309','title'=>'龟山区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830310','title'=>'大园区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830311','title'=>'观音区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'120.42538525561','lat'=>'36.169241550407','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830312','title'=>'新屋区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.95771247803','lat'=>'39.980514890446','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830313','title'=>'复兴区','pid'=>'830300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.44809470749','lat'=>'36.610368592227','level'=>'3','tree'=>'tr_0 tr_830000 tr_830300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830400','title'=>'台中市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830401','title'=>'中区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830402','title'=>'东区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830403','title'=>'西区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830404','title'=>'南区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830405','title'=>'北区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830406','title'=>'西屯区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830407','title'=>'南屯区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830408','title'=>'北屯区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830409','title'=>'丰原区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830410','title'=>'大里区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830411','title'=>'太平区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.68538413681','lat'=>'42.016967854141','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830412','title'=>'东势区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830413','title'=>'大甲区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830414','title'=>'清水区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830415','title'=>'沙鹿区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830416','title'=>'梧栖区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830417','title'=>'后里区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830418','title'=>'神冈区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830419','title'=>'潭子区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830420','title'=>'大雅区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830421','title'=>'新小区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830422','title'=>'石冈区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830423','title'=>'外埔区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830424','title'=>'大安区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.78041635328','lat'=>'29.369928541322','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830425','title'=>'乌日区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830426','title'=>'大肚区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830427','title'=>'龙井区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830428','title'=>'雾峰区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.33696304538','lat'=>'26.091557030419','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830429','title'=>'和平区','pid'=>'830400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.2214669949','lat'=>'39.12339025328','level'=>'3','tree'=>'tr_0 tr_830000 tr_830400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830500','title'=>'台南市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830501','title'=>'中西区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.15949141031','lat'=>'22.291342714292','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830502','title'=>'东区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830503','title'=>'南区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830504','title'=>'北区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830505','title'=>'安平区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830506','title'=>'安南区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830507','title'=>'永康区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830508','title'=>'归仁区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830509','title'=>'新化区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830510','title'=>'左镇区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830511','title'=>'玉井区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830512','title'=>'楠西区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830513','title'=>'南化区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830514','title'=>'仁德区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830515','title'=>'关庙区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830516','title'=>'龙崎区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830517','title'=>'官田区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830518','title'=>'麻豆区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830519','title'=>'佳里区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830520','title'=>'西港区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830521','title'=>'七股区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830522','title'=>'将军区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830523','title'=>'学甲区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830524','title'=>'北门区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830525','title'=>'新营区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830526','title'=>'后壁区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830527','title'=>'白河区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830528','title'=>'东山区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'130.32336109407','lat'=>'47.344987135573','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830529','title'=>'六甲区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830530','title'=>'下营区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830531','title'=>'柳营区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830532','title'=>'盐水区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830533','title'=>'善化区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830534','title'=>'大内区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830535','title'=>'山上区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.36052796411','lat'=>'38.965848756262','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830536','title'=>'新市区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.41224520287','lat'=>'38.88118294749','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830537','title'=>'安定区','pid'=>'830500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'104.61650040265','lat'=>'35.585600016725','level'=>'3','tree'=>'tr_0 tr_830000 tr_830500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830600','title'=>'高雄市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830601','title'=>'楠梓区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830602','title'=>'左营区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830603','title'=>'鼓山区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830604','title'=>'三民区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830605','title'=>'盐埕区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830606','title'=>'前金区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830607','title'=>'新兴区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.93837086995','lat'=>'45.822310328543','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830608','title'=>'苓雅区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830609','title'=>'前镇区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830610','title'=>'旗津区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830611','title'=>'小港区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830612','title'=>'凤山区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830613','title'=>'大寮区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830614','title'=>'鸟松区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830615','title'=>'林园区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830616','title'=>'仁武区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830617','title'=>'大树区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830618','title'=>'大社区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830619','title'=>'冈山区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830620','title'=>'路竹区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830621','title'=>'桥头区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830622','title'=>'梓官区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830623','title'=>'弥陀区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830624','title'=>'永安区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830625','title'=>'燕巢区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830626','title'=>'阿莲区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830627','title'=>'茄萣区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830628','title'=>'湖内区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830629','title'=>'旗山区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830630','title'=>'美浓区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830631','title'=>'内门区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830632','title'=>'杉林区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830633','title'=>'甲仙区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830634','title'=>'六龟区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830635','title'=>'茂林区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830636','title'=>'桃源区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.29349244944','lat'=>'30.607022895804','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830637','title'=>'那玛夏区','pid'=>'830600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.71415692906','lat'=>'23.273513646073','level'=>'3','tree'=>'tr_0 tr_830000 tr_830600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830700','title'=>'基隆市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830701','title'=>'中正区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830702','title'=>'七堵区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830703','title'=>'暖暖区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830704','title'=>'仁爱区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830705','title'=>'中山区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.65154739367','lat'=>'38.924511115496','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830706','title'=>'安乐区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830707','title'=>'信义区','pid'=>'830700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.53225032938','lat'=>'24.6210238893','level'=>'3','tree'=>'tr_0 tr_830000 tr_830700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830800','title'=>'新竹市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830801','title'=>'东区','pid'=>'830800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.76701381388','lat'=>'49.221741849328','level'=>'3','tree'=>'tr_0 tr_830000 tr_830800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830802','title'=>'北区','pid'=>'830800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.76701381388','lat'=>'49.221741849328','level'=>'3','tree'=>'tr_0 tr_830000 tr_830800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830803','title'=>'香山区','pid'=>'830800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.76701381388','lat'=>'49.221741849328','level'=>'3','tree'=>'tr_0 tr_830000 tr_830800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830900','title'=>'嘉义市','pid'=>'830000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.97387097872','lat'=>'24.086956718805','level'=>'2','tree'=>'tr_0 tr_830000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830901','title'=>'东区','pid'=>'830900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.2466374103','lat'=>'22.728825804821','level'=>'3','tree'=>'tr_0 tr_830000 tr_830900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'830902','title'=>'西区','pid'=>'830900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.2466374103','lat'=>'22.728825804821','level'=>'3','tree'=>'tr_0 tr_830000 tr_830900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839001','title'=>'宜兰县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.39369436652','lat'=>'31.211883015985','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839002','title'=>'新竹县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.76701381388','lat'=>'49.221741849328','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839003','title'=>'苗栗县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839004','title'=>'彰化县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.04292985822','lat'=>'26.632603089128','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839005','title'=>'南投县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839006','title'=>'嘉义县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.2466374103','lat'=>'22.728825804821','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839007','title'=>'云林县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'124.7995182988','lat'=>'42.918396678776','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839008','title'=>'屏东县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'119.30846756124','lat'=>'26.107056743573','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839009','title'=>'台东县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.33983605008','lat'=>'26.095631255982','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839010','title'=>'花莲县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.16162991211','lat'=>'33.366606824641','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839011','title'=>'澎湖县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.13156576447','lat'=>'30.875327117717','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839012','title'=>'金门县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.3304151596','lat'=>'24.440444541055','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'839013','title'=>'连江县','pid'=>'839000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.54647881621','lat'=>'26.203583291029','level'=>'3','tree'=>'tr_0 tr_830000 tr_839000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110000','title'=>'北京市','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'116.41338369712','lat'=>'39.9109245473','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120000','title'=>'天津市','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.21081309155','lat'=>'39.14392990331','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130000','title'=>'河北省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.53659630532','lat'=>'38.0432016452','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140000','title'=>'山西省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.56937550968','lat'=>'37.879829423856','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150000','title'=>'内蒙古自治区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'111.77260583082','lat'=>'40.823156232446','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210000','title'=>'辽宁省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.43559785683','lat'=>'41.841465251202','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220000','title'=>'吉林省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'125.33257987515','lat'=>'43.901714435444','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230000','title'=>'黑龙江省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.66965282042','lat'=>'45.747929837435','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310000','title'=>'上海市','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.48053886018','lat'=>'31.235929042252','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320000','title'=>'江苏省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.76955164467','lat'=>'32.066776944293','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330000','title'=>'浙江省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.15953308739','lat'=>'30.271548393337','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340000','title'=>'安徽省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'117.33054041772','lat'=>'31.734294156317','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350000','title'=>'福建省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.30244747704','lat'=>'26.106339415901','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360000','title'=>'江西省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.91542320365','lat'=>'28.681690516761','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370000','title'=>'山东省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.02744162848','lat'=>'36.674856650405','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410000','title'=>'河南省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.75938408486','lat'=>'34.771712921931','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420000','title'=>'湖北省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.34844073659','lat'=>'30.551600064658','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430000','title'=>'湖南省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.98960254335','lat'=>'28.118269998009','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440000','title'=>'广东省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.27242891273','lat'=>'23.137948556539','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450000','title'=>'广西壮族自治区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'108.33452122944','lat'=>'22.821268997909','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460000','title'=>'海南省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.35553651088','lat'=>'20.025801964463','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500000','title'=>'重庆市','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.55843415538','lat'=>'29.568996245339','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510000','title'=>'四川省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'104.07346654728','lat'=>'30.577543147015','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520000','title'=>'贵州省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.71447593089','lat'=>'26.604029544995','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530000','title'=>'云南省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.71641607523','lat'=>'25.051562267345','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540000','title'=>'西藏自治区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'91.124342128993','lat'=>'29.652893647473','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610000','title'=>'陕西省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.96039314875','lat'=>'34.275808006024','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620000','title'=>'甘肃省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'103.83247812812','lat'=>'36.065464887368','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630000','title'=>'青海省','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'101.78646183587','lat'=>'36.627158579235','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640000','title'=>'宁夏回族自治区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.26560480701','lat'=>'38.476877967911','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650000','title'=>'新疆维吾尔自治区','pid'=>'0','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'87.633473205738','lat'=>'43.79923810129','level'=>'1','tree'=>'tr_0 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110100','title'=>'市辖区','pid'=>'110000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.41338369712','lat'=>'39.9109245473','level'=>'2','tree'=>'tr_0 tr_110000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120100','title'=>'市辖区','pid'=>'120000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.21081309155','lat'=>'39.14392990331','level'=>'2','tree'=>'tr_0 tr_120000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140100','title'=>'太原市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.55639149167','lat'=>'37.876989028848','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140200','title'=>'大同市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.30643625859','lat'=>'40.082468716161','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140300','title'=>'阳泉市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.58761666288','lat'=>'37.862360847859','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140400','title'=>'长治市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.12255886985','lat'=>'36.201268372155','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140500','title'=>'晋城市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.85857823133','lat'=>'35.496284586473','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140600','title'=>'朔州市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.43937093967','lat'=>'39.337108370542','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140700','title'=>'晋中市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.75959475566','lat'=>'37.69283940976','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140800','title'=>'运城市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.01338945448','lat'=>'35.032706912909','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140900','title'=>'忻州市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.74062416024','lat'=>'38.422383385178','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141000','title'=>'临汾市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.52553022403','lat'=>'36.09374189542','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141100','title'=>'吕梁市','pid'=>'140000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.15044967529','lat'=>'37.524497749577','level'=>'2','tree'=>'tr_0 tr_140000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150100','title'=>'呼和浩特市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.75550856171','lat'=>'40.848422997113','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150200','title'=>'包头市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.84654350721','lat'=>'40.662928788261','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150300','title'=>'乌海市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.80039105','lat'=>'39.662006364891','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150400','title'=>'赤峰市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.89552039752','lat'=>'42.261686103412','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150500','title'=>'通辽市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.25052178738','lat'=>'43.657980083917','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150600','title'=>'鄂尔多斯市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'109.78744317924','lat'=>'39.614482313949','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150700','title'=>'呼伦贝尔市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.77237049947','lat'=>'49.218446475565','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150800','title'=>'巴彦淖尔市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'107.39439808372','lat'=>'40.749359489573','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150900','title'=>'乌兰察布市','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.13946767446','lat'=>'41.000748327674','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152200','title'=>'兴安盟','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'122.04436452583','lat'=>'46.088463713219','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152500','title'=>'锡林郭勒盟','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.05439144075','lat'=>'43.939422665339','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152900','title'=>'阿拉善盟','pid'=>'150000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.73537746449','lat'=>'38.858275883057','level'=>'2','tree'=>'tr_0 tr_150000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210100','title'=>'沈阳市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.45598993089','lat'=>'41.720915668889','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210200','title'=>'大连市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'121.62163148459','lat'=>'38.918953666786','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210300','title'=>'鞍山市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'123.00137251399','lat'=>'41.115053596949','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210400','title'=>'抚顺市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'123.96437461561','lat'=>'41.885969593057','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210500','title'=>'本溪市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'123.69250712421','lat'=>'41.492916460553','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210600','title'=>'丹东市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.36154728159','lat'=>'40.006408705594','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210700','title'=>'锦州市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.13259630056','lat'=>'41.100931499462','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210800','title'=>'营口市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'122.2415746645','lat'=>'40.673136838267','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210900','title'=>'阜新市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'121.67640799866','lat'=>'42.028021901318','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211000','title'=>'辽阳市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.24336640651','lat'=>'41.274161290454','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211100','title'=>'盘锦市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'122.07322781023','lat'=>'41.141248022956','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211200','title'=>'铁岭市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.73236520918','lat'=>'42.229947997184','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211300','title'=>'朝阳市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.45749949793','lat'=>'41.579820864756','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211400','title'=>'葫芦岛市','pid'=>'210000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.84339833993','lat'=>'40.717364436362','level'=>'2','tree'=>'tr_0 tr_210000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220100','title'=>'长春市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.33060207591','lat'=>'43.821953501043','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220200','title'=>'吉林市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.55563450495','lat'=>'43.843567834579','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220300','title'=>'四平市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'124.35648155716','lat'=>'43.171993571561','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220400','title'=>'辽源市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'125.15042516689','lat'=>'42.894055005746','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220500','title'=>'通化市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'125.94660627598','lat'=>'41.733815801613','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220600','title'=>'白山市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'126.42963008938','lat'=>'41.939627205329','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220700','title'=>'松原市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'124.83148187569','lat'=>'45.147404193414','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220800','title'=>'白城市','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'122.8455906085','lat'=>'45.625504359996','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222400','title'=>'延边朝鲜族自治州','pid'=>'220000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'129.47737632023','lat'=>'42.915743033722','level'=>'2','tree'=>'tr_0 tr_220000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230100','title'=>'哈尔滨市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.54161509032','lat'=>'45.808825827952','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230200','title'=>'齐齐哈尔市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'123.92457086842','lat'=>'47.359977186015','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230300','title'=>'鸡西市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'130.97561865877','lat'=>'45.300872317824','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230400','title'=>'鹤岗市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'130.30443289867','lat'=>'47.356056157685','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230500','title'=>'双鸭山市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'131.16534168078','lat'=>'46.653185895886','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230600','title'=>'大庆市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'125.10865763402','lat'=>'46.593633176722','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230700','title'=>'伊春市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'128.8475463802','lat'=>'47.733318457231','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230800','title'=>'佳木斯市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'130.32735909257','lat'=>'46.805689990858','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230900','title'=>'七台河市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'131.01154459103','lat'=>'45.776300321548','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231000','title'=>'牡丹江市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'129.63953977835','lat'=>'44.556245708986','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231100','title'=>'黑河市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'127.53548988622','lat'=>'50.25127231175','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231200','title'=>'绥化市','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'126.9753568753','lat'=>'46.660032179824','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232700','title'=>'大兴安岭地区','pid'=>'230000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.15292785448','lat'=>'50.420025955028','level'=>'2','tree'=>'tr_0 tr_230000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310100','title'=>'市辖区','pid'=>'310000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.48053886018','lat'=>'31.235929042252','level'=>'2','tree'=>'tr_0 tr_310000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320100','title'=>'南京市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.80242172125','lat'=>'32.064652885618','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320200','title'=>'无锡市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.31858328811','lat'=>'31.498809732686','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320300','title'=>'徐州市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.29057543439','lat'=>'34.212666550113','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320400','title'=>'常州市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.98148471328','lat'=>'31.815795653328','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320500','title'=>'苏州市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.59241222959','lat'=>'31.303564074442','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320600','title'=>'南通市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.90159173866','lat'=>'31.986549431201','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320700','title'=>'连云港市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.22862133317','lat'=>'34.602249525267','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320800','title'=>'淮安市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.02148367071','lat'=>'33.616295301033','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320900','title'=>'盐城市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.16754426576','lat'=>'33.355100917626','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321000','title'=>'扬州市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.41941890823','lat'=>'32.40067693609','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321100','title'=>'镇江市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.43048944567','lat'=>'32.194715920524','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321200','title'=>'泰州市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.92956633785','lat'=>'32.460675049308','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321300','title'=>'宿迁市','pid'=>'320000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.28157403571','lat'=>'33.96774971569','level'=>'2','tree'=>'tr_0 tr_320000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330100','title'=>'杭州市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.21551180372','lat'=>'30.253082981693','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330200','title'=>'宁波市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.62857249434','lat'=>'29.866033045866','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330300','title'=>'温州市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.70647689036','lat'=>'28.001085404472','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330400','title'=>'嘉兴市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.76355182586','lat'=>'30.75097483092','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330500','title'=>'湖州市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.09451660916','lat'=>'30.898963937294','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330600','title'=>'绍兴市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.58547847885','lat'=>'30.036369311307','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330700','title'=>'金华市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.65343619053','lat'=>'29.084639385514','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330800','title'=>'衢州市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.86659674036','lat'=>'28.975545802265','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330900','title'=>'舟山市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.21355631852','lat'=>'29.99091168016','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331000','title'=>'台州市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.42743470428','lat'=>'28.662194055996','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331100','title'=>'丽水市','pid'=>'330000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.92957305844','lat'=>'28.473278180563','level'=>'2','tree'=>'tr_0 tr_330000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340100','title'=>'合肥市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.23344266498','lat'=>'31.826577833687','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340200','title'=>'芜湖市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'118.43943137654','lat'=>'31.358536655799','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340300','title'=>'蚌埠市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.39551332814','lat'=>'32.921523704351','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340400','title'=>'淮南市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.00638885072','lat'=>'32.631847399053','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340500','title'=>'马鞍山市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'118.51357957943','lat'=>'31.676265597609','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340600','title'=>'淮北市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.80453726703','lat'=>'33.961656300276','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340700','title'=>'铜陵市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.81847679446','lat'=>'30.951233239913','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340800','title'=>'安庆市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'117.06360390492','lat'=>'30.530956568043','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341000','title'=>'黄山市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.34543725315','lat'=>'29.721889786592','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341100','title'=>'滁州市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.33940613597','lat'=>'32.261270872041','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341200','title'=>'阜阳市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.82043612491','lat'=>'32.896060994852','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341300','title'=>'宿州市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.97054394561','lat'=>'33.652095326452','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341500','title'=>'六安市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.52640966419','lat'=>'31.741450815323','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341600','title'=>'亳州市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'115.78446321127','lat'=>'33.850642695789','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341700','title'=>'池州市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.4984209616','lat'=>'30.670883790765','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341800','title'=>'宣城市','pid'=>'340000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.76553424277','lat'=>'30.946601545293','level'=>'2','tree'=>'tr_0 tr_340000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350100','title'=>'福州市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.30346983854','lat'=>'26.080429420698','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350200','title'=>'厦门市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.09643549977','lat'=>'24.485406605176','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350300','title'=>'莆田市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'119.01452097813','lat'=>'25.459865455923','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350400','title'=>'三明市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.64552116782','lat'=>'26.269736515992','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350500','title'=>'泉州市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.6824462668','lat'=>'24.879952330498','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350600','title'=>'漳州市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.65357645299','lat'=>'24.518929791171','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350700','title'=>'南平市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.18436954814','lat'=>'26.647772874203','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350800','title'=>'龙岩市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.02344756678','lat'=>'25.081219844872','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350900','title'=>'宁德市','pid'=>'350000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'119.55451074543','lat'=>'26.672241711409','level'=>'2','tree'=>'tr_0 tr_350000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360100','title'=>'南昌市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'115.86458944232','lat'=>'28.689455295061','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360200','title'=>'景德镇市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.18457644639','lat'=>'29.274247711041','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360300','title'=>'萍乡市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.86149643375','lat'=>'27.628392709397','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360400','title'=>'九江市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.00753491163','lat'=>'29.711340559079','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360500','title'=>'新余市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.9235346514','lat'=>'27.823578697789','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360600','title'=>'鹰潭市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.07557542703','lat'=>'28.265787063191','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360700','title'=>'赣州市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.94050337298','lat'=>'25.835176103498','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360800','title'=>'吉安市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.00051072001','lat'=>'27.11972682607','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360900','title'=>'宜春市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.42356367591','lat'=>'27.820856421848','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361000','title'=>'抚州市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.36453876864','lat'=>'27.95489225342','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361100','title'=>'上饶市','pid'=>'360000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.94945960312','lat'=>'28.460625921852','level'=>'2','tree'=>'tr_0 tr_360000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370100','title'=>'济南市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.12639941261','lat'=>'36.656554201787','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370200','title'=>'青岛市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'120.38945519115','lat'=>'36.072227496663','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370300','title'=>'淄博市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'118.0614525349','lat'=>'36.819085683322','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370400','title'=>'枣庄市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.33054194484','lat'=>'34.815994048435','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370500','title'=>'东营市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.68138493514','lat'=>'37.439641826323','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370600','title'=>'烟台市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.4544154173','lat'=>'37.470038383731','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370700','title'=>'潍坊市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.16837791143','lat'=>'36.712651551268','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370800','title'=>'济宁市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.59361234854','lat'=>'35.42017739453','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370900','title'=>'泰安市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.0944948348','lat'=>'36.205858044885','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371000','title'=>'威海市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.12754097831','lat'=>'37.516430548015','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371100','title'=>'日照市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'119.53341540457','lat'=>'35.422838998438','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371200','title'=>'莱芜市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.68466691247','lat'=>'36.233654133647','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371300','title'=>'临沂市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.36353300501','lat'=>'35.110671242365','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371400','title'=>'德州市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.36555674397','lat'=>'37.441308454576','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371500','title'=>'聊城市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.9915878483','lat'=>'36.462758187694','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371600','title'=>'滨州市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.97740401715','lat'=>'37.388196196077','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371700','title'=>'菏泽市','pid'=>'370000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.48754503343','lat'=>'35.239407424766','level'=>'2','tree'=>'tr_0 tr_370000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410100','title'=>'郑州市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.63141920734','lat'=>'34.753438850454','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410200','title'=>'开封市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'114.31459258497','lat'=>'34.802885811212','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410300','title'=>'洛阳市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.45942129831','lat'=>'34.624262779219','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410400','title'=>'平顶山市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.19952856052','lat'=>'33.772050748691','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410500','title'=>'安阳市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.39950042177','lat'=>'36.105940984015','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410600','title'=>'鹤壁市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.30359364248','lat'=>'35.7523574114','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410700','title'=>'新乡市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.93360046733','lat'=>'35.309639930337','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410800','title'=>'焦作市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.24854783457','lat'=>'35.220963254039','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410900','title'=>'濮阳市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.03559747034','lat'=>'35.767593028906','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411000','title'=>'许昌市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.85847553686','lat'=>'34.041431611619','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411100','title'=>'漯河市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.02342077765','lat'=>'33.587710707102','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411200','title'=>'三门峡市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.20653322387','lat'=>'34.77832724946','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411300','title'=>'南阳市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.53450131351','lat'=>'32.996562204651','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411400','title'=>'商丘市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.66244933826','lat'=>'34.420201665859','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411500','title'=>'信阳市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.09748283305','lat'=>'32.153014547531','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411600','title'=>'周口市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.70348251482','lat'=>'33.631828875702','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411700','title'=>'驻马店市','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.02847078173','lat'=>'33.017842416744','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'419000','title'=>'省直辖县级行政区划','pid'=>'410000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.75938408486','lat'=>'34.771712921931','level'=>'2','tree'=>'tr_0 tr_410000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420100','title'=>'武汉市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.31158155473','lat'=>'30.598466736401','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420200','title'=>'黄石市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.04553290894','lat'=>'30.205207848942','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420300','title'=>'十堰市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.8045295607','lat'=>'32.635061858401','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420500','title'=>'宜昌市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.29254921035','lat'=>'30.697446484492','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420600','title'=>'襄阳市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.128537201','lat'=>'32.014796804669','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420700','title'=>'鄂州市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'114.90160738827','lat'=>'30.396572173317','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420800','title'=>'荆门市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.20639298023','lat'=>'31.04173257557','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420900','title'=>'孝感市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.92251007734','lat'=>'30.930689227018','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421000','title'=>'荆州市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.24552262926','lat'=>'30.340842107743','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421100','title'=>'黄冈市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.87849048411','lat'=>'30.459358857618','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421200','title'=>'咸宁市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.32851909027','lat'=>'29.847055947646','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421300','title'=>'随州市','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.38945001822','lat'=>'31.696516772328','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422800','title'=>'恩施土家族苗族自治州','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'109.49459261858','lat'=>'30.277939575301','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'429000','title'=>'省直辖县级行政区划','pid'=>'420000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.34844073659','lat'=>'30.551600064658','level'=>'2','tree'=>'tr_0 tr_420000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430100','title'=>'长沙市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.94547319535','lat'=>'28.234889399944','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430200','title'=>'株洲市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.14047079776','lat'=>'27.833567639016','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430300','title'=>'湘潭市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.95046418076','lat'=>'27.835702227136','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430400','title'=>'衡阳市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.57844721326','lat'=>'26.899576139189','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430500','title'=>'邵阳市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.47443288593','lat'=>'27.245270272809','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430600','title'=>'岳阳市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.13548942422','lat'=>'29.363178293926','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430700','title'=>'常德市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'111.70545217996','lat'=>'29.037749999407','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430800','title'=>'张家界市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.48553254695','lat'=>'29.122815562552','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430900','title'=>'益阳市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.36151595471','lat'=>'28.55971117849','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431000','title'=>'郴州市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.02146049909','lat'=>'25.776683273602','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431100','title'=>'永州市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.61945505792','lat'=>'26.4258641179','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431200','title'=>'怀化市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.00851426537','lat'=>'27.575160902979','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431300','title'=>'娄底市','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.00150349288','lat'=>'27.703208596992','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433100','title'=>'湘西土家族苗族自治州','pid'=>'430000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.74557664947','lat'=>'28.317369104701','level'=>'2','tree'=>'tr_0 tr_430000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440100','title'=>'广州市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.27143134446','lat'=>'23.135336306695','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440200','title'=>'韶关市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.60352734562','lat'=>'24.815881278583','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440300','title'=>'深圳市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.06455183659','lat'=>'22.548456637984','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440400','title'=>'珠海市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.58255478655','lat'=>'22.276564654249','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440500','title'=>'汕头市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.68852864055','lat'=>'23.359091717725','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440600','title'=>'佛山市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.1285121955','lat'=>'23.027758750789','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440700','title'=>'江门市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.08855619524','lat'=>'22.584603880965','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440800','title'=>'湛江市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.36555441393','lat'=>'21.276723439012','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440900','title'=>'茂名市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.93154257997','lat'=>'21.669064031332','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441200','title'=>'肇庆市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.47148894063','lat'=>'23.052888771126','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441300','title'=>'惠州市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.42355801658','lat'=>'23.116358854726','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441400','title'=>'梅州市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.12953737612','lat'=>'24.294177532206','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441500','title'=>'汕尾市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.3729242894','lat'=>'22.778730500164','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441600','title'=>'河源市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.70744627291','lat'=>'23.74968437096','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441700','title'=>'阳江市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.98848929181','lat'=>'21.864339726139','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441800','title'=>'清远市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'113.06246832527','lat'=>'23.688230292088','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900','title'=>'东莞市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.75842045788','lat'=>'23.027308411643','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000','title'=>'中山市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.39942236263','lat'=>'22.522314670791','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445100','title'=>'潮州市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.62947017363','lat'=>'23.662623192616','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445200','title'=>'揭阳市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.37851218034','lat'=>'23.555740488276','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445300','title'=>'云浮市','pid'=>'440000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.05151269959','lat'=>'22.920911970343','level'=>'2','tree'=>'tr_0 tr_440000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450100','title'=>'南宁市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'108.37345082582','lat'=>'22.822606601187','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450200','title'=>'柳州市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.43442194635','lat'=>'24.331961386852','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450300','title'=>'桂林市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'110.20354537458','lat'=>'25.242885724873','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450400','title'=>'梧州市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.28551681182','lat'=>'23.482745281135','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450500','title'=>'北海市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.12653321257','lat'=>'21.486836495769','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450600','title'=>'防城港市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'108.3604188383','lat'=>'21.693005289969','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450700','title'=>'钦州市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.66058016842','lat'=>'21.986593539484','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450800','title'=>'贵港市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.60552031033','lat'=>'23.117448382038','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450900','title'=>'玉林市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.18845312337','lat'=>'22.659830509953','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451000','title'=>'百色市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.62458932565','lat'=>'23.908185934296','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451100','title'=>'贺州市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.57352631416','lat'=>'24.409450902865','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451200','title'=>'河池市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.09149994499','lat'=>'24.698911731273','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451300','title'=>'来宾市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.2274581959','lat'=>'23.756546762607','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451400','title'=>'崇左市','pid'=>'450000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'107.3715202061','lat'=>'22.383117234663','level'=>'2','tree'=>'tr_0 tr_450000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460100','title'=>'海口市','pid'=>'460000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.32552547126','lat'=>'20.044049439257','level'=>'2','tree'=>'tr_0 tr_460000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460200','title'=>'三亚市','pid'=>'460000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.5185567014','lat'=>'18.258736291748','level'=>'2','tree'=>'tr_0 tr_460000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460300','title'=>'三沙市','pid'=>'460000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.34048204137','lat'=>'16.838953334409','level'=>'2','tree'=>'tr_0 tr_460000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400','title'=>'儋州市','pid'=>'460000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'109.58745583569','lat'=>'19.527146110044','level'=>'2','tree'=>'tr_0 tr_460000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469000','title'=>'省直辖县级行政区划','pid'=>'460000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.35553651088','lat'=>'20.025801964463','level'=>'2','tree'=>'tr_0 tr_460000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500100','title'=>'市辖区','pid'=>'500000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'106.55843415538','lat'=>'29.568996245339','level'=>'2','tree'=>'tr_0 tr_500000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500200','title'=>'县','pid'=>'500000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.55843415538','lat'=>'29.568996245339','level'=>'2','tree'=>'tr_0 tr_500000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510100','title'=>'成都市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'104.08153351042','lat'=>'30.655821878416','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510300','title'=>'自贡市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.78444884672','lat'=>'29.345584921328','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510400','title'=>'攀枝花市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'101.72554117091','lat'=>'26.588033173333','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510500','title'=>'泸州市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.44852406933','lat'=>'28.877668303607','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510600','title'=>'德阳市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.40441936496','lat'=>'31.133115003657','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510700','title'=>'绵阳市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'104.68556186076','lat'=>'31.473663048746','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510800','title'=>'广元市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'105.85042318166','lat'=>'32.441616305315','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510900','title'=>'遂宁市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'105.59942153064','lat'=>'30.539097671109','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511000','title'=>'内江市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.064588025','lat'=>'29.58588653832','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511100','title'=>'乐山市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.77253760363','lat'=>'29.557940717458','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511300','title'=>'南充市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.11750261487','lat'=>'30.843782508337','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511400','title'=>'眉山市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.85656331579','lat'=>'30.082526119421','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511500','title'=>'宜宾市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.64940370487','lat'=>'28.758007028552','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511600','title'=>'广安市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.63955268233','lat'=>'30.461746110679','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511700','title'=>'达州市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.47459385898','lat'=>'31.214307723927','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511800','title'=>'雅安市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.0495426236','lat'=>'30.016792545706','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511900','title'=>'巴中市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.75158530316','lat'=>'31.872888585957','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'512000','title'=>'资阳市','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.63443534164','lat'=>'30.134956559253','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513200','title'=>'阿坝藏族羌族自治州','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'102.23141546175','lat'=>'31.905511577267','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513300','title'=>'甘孜藏族自治州','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'101.96854674579','lat'=>'30.055278843518','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513400','title'=>'凉山彝族自治州','pid'=>'510000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.27350268097','lat'=>'27.88775230037','level'=>'2','tree'=>'tr_0 tr_510000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520100','title'=>'贵阳市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.63657676353','lat'=>'26.65332482231','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520200','title'=>'六盘水市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.83755460235','lat'=>'26.598833108257','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520300','title'=>'遵义市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.93342774802','lat'=>'27.731700878917','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520400','title'=>'安顺市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.95441712389','lat'=>'26.259252378715','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520500','title'=>'毕节市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'105.33332337117','lat'=>'27.408562131331','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520600','title'=>'铜仁市','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.16855802826','lat'=>'27.674902690624','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522300','title'=>'黔西南布依族苗族自治州','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'104.91249214627','lat'=>'25.093967349417','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522600','title'=>'黔东南苗族侗族自治州','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.98944624078','lat'=>'26.589702969826','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522700','title'=>'黔南布依族苗族自治州','pid'=>'520000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.52840270574','lat'=>'26.260616196074','level'=>'2','tree'=>'tr_0 tr_520000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530100','title'=>'昆明市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'102.852448365','lat'=>'24.873998150044','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530300','title'=>'曲靖市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'103.80243482795','lat'=>'25.496406931544','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530400','title'=>'玉溪市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.55356029311','lat'=>'24.357710942446','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530500','title'=>'保山市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'99.177273285818','lat'=>'25.139038793266','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530600','title'=>'昭通市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'103.72351177197','lat'=>'27.344083860247','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530700','title'=>'丽江市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.23246452903','lat'=>'26.860657438065','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530800','title'=>'普洱市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'100.97256981473','lat'=>'22.83097918601','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530900','title'=>'临沧市','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.09544042015','lat'=>'23.890468556279','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532300','title'=>'楚雄彝族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.5344124805','lat'=>'25.05177356534','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532500','title'=>'红河哈尼族彝族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'103.38154905258','lat'=>'23.369996247605','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532600','title'=>'文山壮族苗族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.22256899109','lat'=>'23.405994293612','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532800','title'=>'西双版纳傣族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'100.80344682456','lat'=>'22.013601254764','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532900','title'=>'大理白族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'100.27458284048','lat'=>'25.612128418193','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533100','title'=>'德宏傣族景颇族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'98.591359356114','lat'=>'24.438010702758','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533300','title'=>'怒江傈僳族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'98.863288381358','lat'=>'25.823707417658','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533400','title'=>'迪庆藏族自治州','pid'=>'530000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'99.70952999014','lat'=>'27.825184683643','level'=>'2','tree'=>'tr_0 tr_530000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540100','title'=>'拉萨市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'91.120823915464','lat'=>'29.650040274768','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540200','title'=>'日喀则市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'88.893703034826','lat'=>'29.275657822512','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540300','title'=>'昌都市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'97.179583594086','lat'=>'31.147346549327','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540400','title'=>'林芝市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'94.368058287133','lat'=>'29.654042176952','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540500','title'=>'山南市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'91.778675138519','lat'=>'29.243026939249','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540600','title'=>'那曲市','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'92.057338498175','lat'=>'31.482438388455','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542500','title'=>'阿里地区','pid'=>'540000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'80.112776921926','lat'=>'32.506866017633','level'=>'2','tree'=>'tr_0 tr_540000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610100','title'=>'西安市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.94646555063','lat'=>'34.347268816624','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610200','title'=>'铜川市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'108.95240424836','lat'=>'34.902637080503','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610300','title'=>'宝鸡市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'107.24457536704','lat'=>'34.36891564287','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610400','title'=>'咸阳市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.71542245143','lat'=>'34.335476293369','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610500','title'=>'渭南市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.51658960526','lat'=>'34.505715516753','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610600','title'=>'延安市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.49658191613','lat'=>'36.591111035218','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610700','title'=>'汉中市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.02943020926','lat'=>'33.073799907834','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610800','title'=>'榆林市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.74161603381','lat'=>'38.290883835484','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610900','title'=>'安康市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'109.03560108266','lat'=>'32.690512770574','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611000','title'=>'商洛市','pid'=>'610000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.92441788136','lat'=>'33.878633852208','level'=>'2','tree'=>'tr_0 tr_610000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620100','title'=>'兰州市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.84052119634','lat'=>'36.067234693546','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620200','title'=>'嘉峪关市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'98.296203843001','lat'=>'39.777960147391','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620300','title'=>'金昌市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.1946056867','lat'=>'38.525820092093','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620400','title'=>'白银市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'104.14445082834','lat'=>'36.550825330415','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620500','title'=>'天水市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'105.73141674567','lat'=>'34.587411881651','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620600','title'=>'武威市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'102.64455434037','lat'=>'37.934377808158','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620700','title'=>'张掖市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'100.45641147406','lat'=>'38.932066007005','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620800','title'=>'平凉市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'106.67144234828','lat'=>'35.549232050464','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620900','title'=>'酒泉市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'98.500685216068','lat'=>'39.738469080716','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621000','title'=>'庆阳市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.64938569595','lat'=>'35.715215983562','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621100','title'=>'定西市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.63242008306','lat'=>'35.586832926562','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621200','title'=>'陇南市','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.92857497071','lat'=>'33.406620229951','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622900','title'=>'临夏回族自治州','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.2163905653','lat'=>'35.607562183503','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623000','title'=>'甘南藏族自治州','pid'=>'620000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'102.91758468826','lat'=>'34.989139909968','level'=>'2','tree'=>'tr_0 tr_620000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630100','title'=>'西宁市','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'101.78445017051','lat'=>'36.623384696517','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630200','title'=>'海东市','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.11044407228','lat'=>'36.508511080941','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632200','title'=>'海北藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'100.90743432146','lat'=>'36.96066282413','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632300','title'=>'黄南藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.02242827808','lat'=>'35.525804586516','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632500','title'=>'海南藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'100.62662114446','lat'=>'36.292102479899','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632600','title'=>'果洛藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.2515919788','lat'=>'34.477193866471','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632700','title'=>'玉树藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'97.013180762773','lat'=>'33.010979585143','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632800','title'=>'海西蒙古族藏族自治州','pid'=>'630000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'97.376299116019','lat'=>'37.382750462527','level'=>'2','tree'=>'tr_0 tr_630000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640100','title'=>'银川市','pid'=>'640000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.2384935874','lat'=>'38.49246005551','level'=>'2','tree'=>'tr_0 tr_640000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640200','title'=>'石嘴山市','pid'=>'640000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'106.3906004255','lat'=>'38.989682839915','level'=>'2','tree'=>'tr_0 tr_640000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640300','title'=>'吴忠市','pid'=>'640000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.20537126664','lat'=>'38.003712913453','level'=>'2','tree'=>'tr_0 tr_640000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640400','title'=>'固原市','pid'=>'640000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.24857742607','lat'=>'36.021617258011','level'=>'2','tree'=>'tr_0 tr_640000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640500','title'=>'中卫市','pid'=>'640000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.20357090089','lat'=>'37.505701418703','level'=>'2','tree'=>'tr_0 tr_640000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650100','title'=>'乌鲁木齐市','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'87.62443993536','lat'=>'43.83076320429','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650200','title'=>'克拉玛依市','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'84.895900538875','lat'=>'45.585675237814','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650400','title'=>'吐鲁番市','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'89.266025488642','lat'=>'42.678924820794','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650500','title'=>'哈密市','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'93.529373012389','lat'=>'42.344467104552','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652300','title'=>'昌吉回族自治州','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'87.315001624474','lat'=>'44.01685415992','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652700','title'=>'博尔塔拉蒙古自治州','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'82.072914758274','lat'=>'44.912196413465','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652800','title'=>'巴音郭楞蒙古自治州','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'86.151713865333','lat'=>'41.77028733045','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652900','title'=>'阿克苏地区','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'80.266943484735','lat'=>'41.175029860077','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653000','title'=>'克孜勒苏柯尔克孜自治州','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'76.174308676212','lat'=>'39.720471204871','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653100','title'=>'喀什地区','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'75.996390556397','lat'=>'39.476096748645','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653200','title'=>'和田地区','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'79.928507063512','lat'=>'37.120446463042','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654000','title'=>'伊犁哈萨克自治州','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'81.330537747532','lat'=>'43.922723137492','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654200','title'=>'塔城地区','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'82.987235518406','lat'=>'46.750948254373','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654300','title'=>'阿勒泰地区','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'88.147926203735','lat'=>'47.850727870102','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659000','title'=>'自治区直辖县级行政区划','pid'=>'650000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'87.633473205738','lat'=>'43.79923810129','level'=>'2','tree'=>'tr_0 tr_650000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110101','title'=>'东城区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.42240097766','lat'=>'39.934827272396','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110102','title'=>'西城区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.37251358117','lat'=>'39.918123605841','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110105','title'=>'朝阳区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110106','title'=>'丰台区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.29240188731','lat'=>'39.864937197557','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110107','title'=>'石景山区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.22961266776','lat'=>'39.911353808778','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110108','title'=>'海淀区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.3054340545','lat'=>'39.965489841101','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110109','title'=>'门头沟区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.10760355577','lat'=>'39.946146720034','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110111','title'=>'房山区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.14944375184','lat'=>'39.754325839773','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110112','title'=>'通州区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110113','title'=>'顺义区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.66142426369','lat'=>'40.136350762231','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110114','title'=>'昌平区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.23761791731','lat'=>'40.226413371594','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110115','title'=>'大兴区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.34862521223','lat'=>'39.732555236554','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110116','title'=>'怀柔区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.63838587143','lat'=>'40.322618404266','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110117','title'=>'平谷区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'117.1273791046','lat'=>'40.146950735799','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110118','title'=>'密云区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.84954704427','lat'=>'40.382175658138','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'110119','title'=>'延庆区','pid'=>'110100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.98163156902','lat'=>'40.462168973754','level'=>'3','tree'=>'tr_0 tr_110000 tr_110100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120101','title'=>'和平区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120102','title'=>'河东区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.26169316527','lat'=>'39.126625684666','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120103','title'=>'河西区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.22941628002','lat'=>'39.115718082216','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120104','title'=>'南开区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'117.15651537432','lat'=>'39.144105279768','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120105','title'=>'河北区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.20359278136','lat'=>'39.153485144705','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120106','title'=>'红桥区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.15751788327','lat'=>'39.173285646564','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120110','title'=>'东丽区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.32056850791','lat'=>'39.092332342815','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120111','title'=>'西青区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.01441017994','lat'=>'39.148726608967','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120112','title'=>'津南区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.36338677903','lat'=>'38.944148568115','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120113','title'=>'北辰区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.14140273158','lat'=>'39.230343909918','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120114','title'=>'武清区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.05059715978','lat'=>'39.389871228788','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120115','title'=>'宝坻区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.31660069248','lat'=>'39.723194482933','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120116','title'=>'滨海新区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.71739882966','lat'=>'39.009415773647','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120117','title'=>'宁河区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'117.83239334342','lat'=>'39.336956431227','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120118','title'=>'静海区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.98046860455','lat'=>'38.953370689172','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'120119','title'=>'蓟州区','pid'=>'120100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.41457869479','lat'=>'40.051508786395','level'=>'3','tree'=>'tr_0 tr_120000 tr_120100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140105','title'=>'小店区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.57239624162','lat'=>'37.742322528645','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140106','title'=>'迎泽区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.5693846724','lat'=>'37.869532484225','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140107','title'=>'杏花岭区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.5763830113','lat'=>'37.900186246845','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140108','title'=>'尖草坪区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.49360496704','lat'=>'37.945943354548','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140109','title'=>'万柏林区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.52257675702','lat'=>'37.864974410402','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140110','title'=>'晋源区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.48456424072','lat'=>'37.721168857849','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140121','title'=>'清徐县','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.36455763137','lat'=>'37.613066838238','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140122','title'=>'阳曲县','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.6794089516','lat'=>'38.064620819448','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140123','title'=>'娄烦县','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.80359063362','lat'=>'38.073195368896','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140171','title'=>'山西转型综合改革示范区','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.55639149167','lat'=>'37.876989028848','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140181','title'=>'古交市','pid'=>'140100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.1824528689','lat'=>'37.912999960962','level'=>'3','tree'=>'tr_0 tr_140000 tr_140100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140212','title'=>'新荣区','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.14644373539','lat'=>'40.261971219328','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140213','title'=>'平城区','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.30442522204','lat'=>'40.081998375025','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140214','title'=>'云冈区','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.16240150396','lat'=>'39.996838811279','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140215','title'=>'云州区','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.61847103172','lat'=>'40.046229886508','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140221','title'=>'阳高县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.75541420332','lat'=>'40.367391842472','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140222','title'=>'天镇县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.09747753304','lat'=>'40.426412198691','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140223','title'=>'广灵县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.28858637097','lat'=>'39.766004217139','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140224','title'=>'灵丘县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.24136819946','lat'=>'39.448825128052','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140225','title'=>'浑源县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.70560028822','lat'=>'39.698952969845','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140226','title'=>'左云县','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.70946328956','lat'=>'40.019623449015','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140271','title'=>'山西大同经济开发区','pid'=>'140200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.30643625859','lat'=>'40.082468716161','level'=>'3','tree'=>'tr_0 tr_140000 tr_140200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140302','title'=>'城区','pid'=>'140300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.61283811719','lat'=>'37.85786536147','level'=>'3','tree'=>'tr_0 tr_140000 tr_140300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140303','title'=>'矿区','pid'=>'140300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'113.54077065934','lat'=>'37.890804244519','level'=>'3','tree'=>'tr_0 tr_140000 tr_140300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140311','title'=>'郊区','pid'=>'140300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.60060283682','lat'=>'37.950352892943','level'=>'3','tree'=>'tr_0 tr_140000 tr_140300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140321','title'=>'平定县','pid'=>'140300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.66442115516','lat'=>'37.792796383591','level'=>'3','tree'=>'tr_0 tr_140000 tr_140300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140322','title'=>'盂县','pid'=>'140300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.41842046075','lat'=>'38.091979630201','level'=>'3','tree'=>'tr_0 tr_140000 tr_140300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140403','title'=>'潞州区','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.12952091721','lat'=>'36.209472481338','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140404','title'=>'上党区','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.05741608986','lat'=>'36.059286479291','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140405','title'=>'屯留区','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.89847476377','lat'=>'36.321630843108','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140406','title'=>'潞城区','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.23557845894','lat'=>'36.339691267612','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140423','title'=>'襄垣县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.05741258647','lat'=>'36.541685821155','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140425','title'=>'平顺县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.44251696707','lat'=>'36.205989459384','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140426','title'=>'黎城县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.39343247604','lat'=>'36.508669901441','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140427','title'=>'壶关县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.21357985531','lat'=>'36.121334604237','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140428','title'=>'长子县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.88456585041','lat'=>'36.128001557794','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140429','title'=>'武乡县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.8706056438','lat'=>'36.843167949301','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140430','title'=>'沁县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.70545801478','lat'=>'36.762189938552','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140431','title'=>'沁源县','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.34445202694','lat'=>'36.506103350913','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140471','title'=>'山西长治高新技术产业园区','pid'=>'140400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.12255886985','lat'=>'36.201268372155','level'=>'3','tree'=>'tr_0 tr_140000 tr_140400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140502','title'=>'城区','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.85958379452','lat'=>'35.507278924584','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140521','title'=>'沁水县','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.19342620969','lat'=>'35.696364462457','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140522','title'=>'阳城县','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.42145378712','lat'=>'35.492181320425','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140524','title'=>'陵川县','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.28740655466','lat'=>'35.781743639538','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140525','title'=>'泽州县','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.79440121959','lat'=>'35.599769729488','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140581','title'=>'高平市','pid'=>'140500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.93041239923','lat'=>'35.804336798578','level'=>'3','tree'=>'tr_0 tr_140000 tr_140500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140602','title'=>'朔城区','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.43837642564','lat'=>'39.325302712534','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140603','title'=>'平鲁区','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'112.29552500886','lat'=>'39.517389104237','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140621','title'=>'山阴县','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.82243194473','lat'=>'39.534030498011','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140622','title'=>'应县','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.19749353922','lat'=>'39.560077852375','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140623','title'=>'右玉县','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.47350008125','lat'=>'39.994859555431','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140671','title'=>'山西朔州经济开发区','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.46306042376','lat'=>'39.354781496121','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140681','title'=>'怀仁市','pid'=>'140600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.10660846738','lat'=>'39.833756889522','level'=>'3','tree'=>'tr_0 tr_140000 tr_140600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140702','title'=>'榆次区','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.71450350211','lat'=>'37.703940486801','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140721','title'=>'榆社县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.98159856583','lat'=>'37.0763696687','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140722','title'=>'左权县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.38545184006','lat'=>'37.088555147171','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140723','title'=>'和顺县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.57660568309','lat'=>'37.334807738688','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140724','title'=>'昔阳县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.71361290387','lat'=>'37.617884042996','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140725','title'=>'寿阳县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.18341017493','lat'=>'37.901307606957','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140726','title'=>'太谷县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.55738411926','lat'=>'37.427395577313','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140727','title'=>'祁县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.34244242768','lat'=>'37.364131283475','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140728','title'=>'平遥县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'112.18245556381','lat'=>'37.195600690703','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140729','title'=>'灵石县','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.78561787596','lat'=>'36.85336750127','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140781','title'=>'介休市','pid'=>'140700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.92356319719','lat'=>'37.032686403603','level'=>'3','tree'=>'tr_0 tr_140000 tr_140700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140802','title'=>'盐湖区','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.00437711462','lat'=>'35.021425327829','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140821','title'=>'临猗县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.78040700351','lat'=>'35.149542242622','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140822','title'=>'万荣县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.84457611016','lat'=>'35.421108800536','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140823','title'=>'闻喜县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.23141035768','lat'=>'35.362931196381','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140824','title'=>'稷山县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'110.98941457872','lat'=>'35.610403569616','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140825','title'=>'新绛县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.23140649497','lat'=>'35.622630103082','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140826','title'=>'绛县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.57548652056','lat'=>'35.497276373896','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140827','title'=>'垣曲县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.67660670572','lat'=>'35.303014517418','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140828','title'=>'夏县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.2264314994','lat'=>'35.147461779807','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140829','title'=>'平陆县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'111.22348047596','lat'=>'34.842925154581','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140830','title'=>'芮城县','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'110.7006115132','lat'=>'34.699388110563','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140881','title'=>'永济市','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.45457767131','lat'=>'34.872829714714','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140882','title'=>'河津市','pid'=>'140800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.71857214373','lat'=>'35.601926575322','level'=>'3','tree'=>'tr_0 tr_140000 tr_140800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140902','title'=>'忻府区','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.75261366422','lat'=>'38.40987981762','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140921','title'=>'定襄县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.96352861152','lat'=>'38.479974305847','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140922','title'=>'五台县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.26145109492','lat'=>'38.734181590565','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140923','title'=>'代县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.96655194854','lat'=>'39.072728346381','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140924','title'=>'繁峙县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.27140827251','lat'=>'39.195237430734','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140925','title'=>'宁武县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.32639824212','lat'=>'39.024342381431','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140926','title'=>'静乐县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.94543190585','lat'=>'38.365147088438','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140927','title'=>'神池县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.21738276001','lat'=>'39.096875824863','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140928','title'=>'五寨县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.85340993856','lat'=>'38.917019909692','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140929','title'=>'岢岚县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'111.57947778177','lat'=>'38.710151038936','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140930','title'=>'河曲县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.14444863516','lat'=>'39.390702488715','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140931','title'=>'保德县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'111.09254175805','lat'=>'39.028336932396','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140932','title'=>'偏关县','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'111.51447352049','lat'=>'39.442230090387','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140971','title'=>'五台山风景名胜区','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.602695497','lat'=>'38.983546253607','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'140981','title'=>'原平市','pid'=>'140900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.71748713403','lat'=>'38.736475897605','level'=>'3','tree'=>'tr_0 tr_140000 tr_140900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141002','title'=>'尧都区','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.58643021727','lat'=>'36.084562230192','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141021','title'=>'曲沃县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'111.48239637819','lat'=>'35.647327335982','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141022','title'=>'翼城县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.72537553219','lat'=>'35.744429075039','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141023','title'=>'襄汾县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.44854005199','lat'=>'35.882062670676','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141024','title'=>'洪洞县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.68158942672','lat'=>'36.259467079377','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141025','title'=>'古县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'111.92657314947','lat'=>'36.272338064827','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141026','title'=>'安泽县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'112.2566128396','lat'=>'36.153514380523','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141027','title'=>'浮山县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.85538495306','lat'=>'35.974392753943','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141028','title'=>'吉县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'110.68854637189','lat'=>'36.103999062021','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141029','title'=>'乡宁县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.85349790083','lat'=>'35.976441665474','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141030','title'=>'大宁县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.75938440882','lat'=>'36.471305687097','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141031','title'=>'隰县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.94759127079','lat'=>'36.699061383227','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141032','title'=>'永和县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.63841589393','lat'=>'36.765908673933','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141033','title'=>'蒲县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'111.10247405258','lat'=>'36.418005429177','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141034','title'=>'汾西县','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.56954629571','lat'=>'36.658782264232','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141081','title'=>'侯马市','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.37839658489','lat'=>'35.625364816258','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141082','title'=>'霍州市','pid'=>'141000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.76150942218','lat'=>'36.574606950709','level'=>'3','tree'=>'tr_0 tr_140000 tr_141000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141102','title'=>'离石区','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.15749077354','lat'=>'37.523577475907','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141121','title'=>'文水县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.0355986926','lat'=>'37.444300082651','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141122','title'=>'交城县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.16256770864','lat'=>'37.557772236259','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141123','title'=>'兴县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.13439210498','lat'=>'38.468803780991','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141124','title'=>'临县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.99841488129','lat'=>'37.957210672321','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141125','title'=>'柳林县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.8953898393','lat'=>'37.435492964934','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141126','title'=>'石楼县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.84159553248','lat'=>'37.004470503012','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141127','title'=>'岚县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.67859223038','lat'=>'38.28502878885','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141128','title'=>'方山县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.25037044293','lat'=>'37.90102023916','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141129','title'=>'中阳县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.18562956483','lat'=>'37.36287279238','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141130','title'=>'交口县','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.18762820476','lat'=>'36.987872666553','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141181','title'=>'孝义市','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.78560601833','lat'=>'37.151063319102','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'141182','title'=>'汾阳市','pid'=>'141100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.7945966192','lat'=>'37.271291794518','level'=>'3','tree'=>'tr_0 tr_140000 tr_141100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150102','title'=>'新城区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.671620122','lat'=>'40.863877021183','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150103','title'=>'回民区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.63047018388','lat'=>'40.814506362944','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150104','title'=>'玉泉区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.68157514366','lat'=>'40.758058968635','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150105','title'=>'赛罕区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.7084206445','lat'=>'40.798394236975','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150121','title'=>'土默特左旗','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'111.16958672672','lat'=>'40.735293711759','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150122','title'=>'托克托县','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'111.20057494309','lat'=>'40.283146729007','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150123','title'=>'和林格尔县','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.82843021826','lat'=>'40.384797744251','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150124','title'=>'清水河县','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'111.65357648803','lat'=>'39.926333854389','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150125','title'=>'武川县','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.45749705623','lat'=>'41.102418723793','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150171','title'=>'呼和浩特金海工业园区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.61859862741','lat'=>'40.813484420815','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150172','title'=>'呼和浩特经济技术开发区','pid'=>'150100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.75550856171','lat'=>'40.848422997113','level'=>'3','tree'=>'tr_0 tr_150000 tr_150100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150202','title'=>'东河区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.05039480879','lat'=>'40.582228038324','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150203','title'=>'昆都仑区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'109.84553830335','lat'=>'40.647644106921','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150204','title'=>'青山区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'109.9074160123','lat'=>'40.649473068783','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150205','title'=>'石拐区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.27838088451','lat'=>'40.67829939834','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150206','title'=>'白云鄂博矿区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.97962576174','lat'=>'41.774995234182','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150207','title'=>'九原区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.96958800614','lat'=>'40.613396589444','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150221','title'=>'土默特右旗','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'110.53038926652','lat'=>'40.575127429108','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150222','title'=>'固阳县','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'110.06643261639','lat'=>'41.040162852726','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150223','title'=>'达尔罕茂明安联合旗','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.43952090317','lat'=>'41.704548551002','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150271','title'=>'包头稀土高新技术产业开发区','pid'=>'150200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.84664914794','lat'=>'40.637085021364','level'=>'3','tree'=>'tr_0 tr_150000 tr_150200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150302','title'=>'海勃湾区','pid'=>'150300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.82943856714','lat'=>'39.696907993535','level'=>'3','tree'=>'tr_0 tr_150000 tr_150300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150303','title'=>'海南区','pid'=>'150300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.89847100998','lat'=>'39.446827515087','level'=>'3','tree'=>'tr_0 tr_150000 tr_150300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150304','title'=>'乌达区','pid'=>'150300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.7326063535','lat'=>'39.511468916129','level'=>'3','tree'=>'tr_0 tr_150000 tr_150300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150402','title'=>'红山区','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.96356353651','lat'=>'42.27047843525','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150403','title'=>'元宝山区','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.29540450885','lat'=>'42.045124715638','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150404','title'=>'松山区','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.9394138505','lat'=>'42.292481572694','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150421','title'=>'阿鲁科尔沁旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'120.07261385472','lat'=>'43.877953412182','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150422','title'=>'巴林左旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.38644328076','lat'=>'43.97638259461','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150423','title'=>'巴林右旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'118.67039425705','lat'=>'43.540131553108','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150424','title'=>'林西县','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.06246142182','lat'=>'43.624210259291','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150425','title'=>'克什克腾旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'117.55162041051','lat'=>'43.270757591896','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150426','title'=>'翁牛特旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.01250888002','lat'=>'42.942019262236','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150428','title'=>'喀喇沁旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.7104736845','lat'=>'41.932214335643','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150429','title'=>'宁城县','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'119.35060897566','lat'=>'41.600245148269','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150430','title'=>'敖汉旗','pid'=>'150400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'119.92757793861','lat'=>'42.296507085243','level'=>'3','tree'=>'tr_0 tr_150000 tr_150400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150502','title'=>'科尔沁区','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'122.2624570337','lat'=>'43.628712488829','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150521','title'=>'科尔沁左翼中旗','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'123.31858853365','lat'=>'44.132294228308','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150522','title'=>'科尔沁左翼后旗','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'122.36356257648','lat'=>'42.93956249402','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150523','title'=>'开鲁县','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'121.32538568843','lat'=>'43.606369431362','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150524','title'=>'库伦旗','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'121.81740576201','lat'=>'42.741211100235','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150525','title'=>'奈曼旗','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.66464641294','lat'=>'42.87184654666','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150526','title'=>'扎鲁特旗','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.91862585689','lat'=>'44.562213133099','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150571','title'=>'通辽经济技术开发区','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.22276854881','lat'=>'43.676026521565','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150581','title'=>'霍林郭勒市','pid'=>'150500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.67046591394','lat'=>'45.53751332061','level'=>'3','tree'=>'tr_0 tr_150000 tr_150500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130100','title'=>'石家庄市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.52153190157','lat'=>'38.048311926873','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130200','title'=>'唐山市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'118.18645947204','lat'=>'39.636583724147','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130300','title'=>'秦皇岛市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'119.60853063334','lat'=>'39.941748102378','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130400','title'=>'邯郸市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.54562822824','lat'=>'36.631262731204','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130500','title'=>'邢台市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.51146225613','lat'=>'37.076685950966','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130600','title'=>'保定市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'115.47146383769','lat'=>'38.879987768455','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130700','title'=>'张家口市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.89257223145','lat'=>'40.773237202691','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130800','title'=>'承德市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.96939750997','lat'=>'40.957856012338','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130900','title'=>'沧州市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.84558075595','lat'=>'38.310215141107','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131000','title'=>'廊坊市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.69058173343','lat'=>'39.543366662759','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131100','title'=>'衡水市','pid'=>'130000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.67540613762','lat'=>'37.745191408077','level'=>'2','tree'=>'tr_0 tr_130000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150602','title'=>'东胜区','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'109.96956006883','lat'=>'39.827986984444','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150603','title'=>'康巴什区','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'109.86962735373','lat'=>'39.616378146766','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150621','title'=>'达拉特旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.04036612608','lat'=>'40.418907154391','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150622','title'=>'准格尔旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.24639840546','lat'=>'39.870540265037','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150623','title'=>'鄂托克前旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'107.48458472303','lat'=>'38.188216741284','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150624','title'=>'鄂托克旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'107.98244495023','lat'=>'39.095293413608','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150625','title'=>'杭锦旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.74241293879','lat'=>'39.838815768815','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150626','title'=>'乌审旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.82443496914','lat'=>'38.610026521177','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150627','title'=>'伊金霍洛旗','pid'=>'150600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.78744317924','lat'=>'39.614482313949','level'=>'3','tree'=>'tr_0 tr_150000 tr_150600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150702','title'=>'海拉尔区','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.74246537006','lat'=>'49.218215799363','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150703','title'=>'扎赉诺尔区','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.69453227349','lat'=>'49.467770183628','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150721','title'=>'阿荣旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'123.46544000531','lat'=>'48.131971245042','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150722','title'=>'莫力达瓦达斡尔族自治旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'124.52557642071','lat'=>'48.482896292115','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150723','title'=>'鄂伦春自治旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'123.73234507742','lat'=>'50.597947928064','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150724','title'=>'鄂温克族自治旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'119.76135125527','lat'=>'49.15304476395','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150725','title'=>'陈巴尔虎旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.43046248677','lat'=>'49.334914288885','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150726','title'=>'新巴尔虎左旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.27660837276','lat'=>'48.223786760037','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150727','title'=>'新巴尔虎右旗','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.83063240352','lat'=>'48.677053599089','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150781','title'=>'满洲里市','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.38543585768','lat'=>'49.604098854866','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150782','title'=>'牙克石市','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.7183468371','lat'=>'49.292023693206','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150783','title'=>'扎兰屯市','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.74445371486','lat'=>'48.01995552011','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150784','title'=>'额尔古纳市','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'120.18663369726','lat'=>'50.248131758636','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150785','title'=>'根河市','pid'=>'150700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.52758526594','lat'=>'50.786140434318','level'=>'3','tree'=>'tr_0 tr_150000 tr_150700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150802','title'=>'临河区','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.36953379568','lat'=>'40.75668072584','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150821','title'=>'五原县','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.2734913541','lat'=>'41.094454821479','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150822','title'=>'磴口县','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.01452247','lat'=>'40.336470177103','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150823','title'=>'乌拉特前旗','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.6586151381','lat'=>'40.742103512928','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150824','title'=>'乌拉特中旗','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.51951244005','lat'=>'41.593346263746','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150825','title'=>'乌拉特后旗','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'107.08154612207','lat'=>'41.089422269258','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150826','title'=>'杭锦后旗','pid'=>'150800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.15737244949','lat'=>'40.892179419823','level'=>'3','tree'=>'tr_0 tr_150000 tr_150800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150902','title'=>'集宁区','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.12058699942','lat'=>'41.041146171787','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150921','title'=>'卓资县','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.5844095507','lat'=>'40.900291837834','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150922','title'=>'化德县','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.0164087845','lat'=>'41.909602587109','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150923','title'=>'商都县','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.58463922926','lat'=>'41.567566637224','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150924','title'=>'兴和县','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.84057886567','lat'=>'40.879341798933','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150925','title'=>'凉城县','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.51060018864','lat'=>'40.5371631252','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150926','title'=>'察哈尔右翼前旗','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.22160531673','lat'=>'40.791267302593','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150927','title'=>'察哈尔右翼中旗','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.64258040196','lat'=>'41.283272943291','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150928','title'=>'察哈尔右翼后旗','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.19853090242','lat'=>'41.441770999655','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150929','title'=>'四子王旗','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.71241927182','lat'=>'41.539353349915','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'150981','title'=>'丰镇市','pid'=>'150900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.11660121788','lat'=>'40.441804808844','level'=>'3','tree'=>'tr_0 tr_150000 tr_150900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152201','title'=>'乌兰浩特市','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.09962235198','lat'=>'46.078654343582','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152202','title'=>'阿尔山市','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'119.95065315166','lat'=>'47.18305415375','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152221','title'=>'科尔沁右翼前旗','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'121.9645531355','lat'=>'46.082648853819','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152222','title'=>'科尔沁右翼中旗','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'121.48354781458','lat'=>'45.066470993428','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152223','title'=>'扎赉特旗','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.90644442883','lat'=>'46.729189539358','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152224','title'=>'突泉县','pid'=>'152200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.60054536997','lat'=>'45.387830342585','level'=>'3','tree'=>'tr_0 tr_150000 tr_152200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152501','title'=>'二连浩特市','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'111.95836319333','lat'=>'43.648800184052','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152502','title'=>'锡林浩特市','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.09361388474','lat'=>'43.93833380136','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152522','title'=>'阿巴嘎旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.95736709772','lat'=>'44.028101587023','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152523','title'=>'苏尼特左旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.67347993742','lat'=>'43.865553657792','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152524','title'=>'苏尼特右旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.64856904548','lat'=>'42.747368922463','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152525','title'=>'东乌珠穆沁旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.97850435996','lat'=>'45.515743305312','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152526','title'=>'西乌珠穆沁旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.61637700896','lat'=>'44.593802912007','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152527','title'=>'太仆寺旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'115.29053531645','lat'=>'41.882291746043','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152528','title'=>'镶黄旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.85450538582','lat'=>'42.237661285279','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152529','title'=>'正镶白旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.03662171828','lat'=>'42.292605429249','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152530','title'=>'正蓝旗','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.99860388383','lat'=>'42.247118844188','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152531','title'=>'多伦县','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.49250878204','lat'=>'42.208920864211','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152571','title'=>'乌拉盖管委会','pid'=>'152500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.09790153324','lat'=>'42.80523252057','level'=>'3','tree'=>'tr_0 tr_150000 tr_152500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152921','title'=>'阿拉善左旗','pid'=>'152900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.67259866528','lat'=>'38.839094137436','level'=>'3','tree'=>'tr_0 tr_150000 tr_152900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152922','title'=>'阿拉善右旗','pid'=>'152900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'101.67346389594','lat'=>'39.222240969855','level'=>'3','tree'=>'tr_0 tr_150000 tr_152900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152923','title'=>'额济纳旗','pid'=>'152900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'101.06240334058','lat'=>'41.960297611813','level'=>'3','tree'=>'tr_0 tr_150000 tr_152900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'152971','title'=>'内蒙古阿拉善经济开发区','pid'=>'152900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.77197191571','lat'=>'40.314622117574','level'=>'3','tree'=>'tr_0 tr_150000 tr_152900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210102','title'=>'和平区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'123.42664426615','lat'=>'41.795236052902','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210103','title'=>'沈河区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.46546103538','lat'=>'41.802274138805','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210104','title'=>'大东区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'123.47640473208','lat'=>'41.811425174494','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210105','title'=>'皇姑区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'123.43162078885','lat'=>'41.826042120277','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210106','title'=>'铁西区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.38343595078','lat'=>'41.809037832217','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210111','title'=>'苏家屯区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.35043463177','lat'=>'41.671253644959','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210112','title'=>'浑南区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'123.45598993089','lat'=>'41.720915668889','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210113','title'=>'沈北新区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.53360460492','lat'=>'42.058914115763','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210114','title'=>'于洪区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'123.31463302499','lat'=>'41.799668255615','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210115','title'=>'辽中区','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'122.77237835983','lat'=>'41.523149081842','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210123','title'=>'康平县','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'123.33751124938','lat'=>'42.749925495719','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210124','title'=>'法库县','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'123.41462107572','lat'=>'42.509606549903','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210181','title'=>'新民市','pid'=>'210100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'122.87539513741','lat'=>'42.007109320665','level'=>'3','tree'=>'tr_0 tr_210000 tr_210100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210202','title'=>'中山区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.65154739367','lat'=>'38.924511115496','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210203','title'=>'西岗区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.61862512554','lat'=>'38.920472689273','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210204','title'=>'沙河口区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.59450670057','lat'=>'38.913544290956','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210211','title'=>'甘井子区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.5315189555','lat'=>'38.958002162932','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210212','title'=>'旅顺口区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.26859688019','lat'=>'38.856832222859','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210213','title'=>'金州区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.78943558267','lat'=>'39.056432991661','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210214','title'=>'普兰店区','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.94645983497','lat'=>'39.398089145183','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210224','title'=>'长海县','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.59462651637','lat'=>'39.278270217167','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210281','title'=>'瓦房店市','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.98563754334','lat'=>'39.632740747388','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210283','title'=>'庄河市','pid'=>'210200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.97449548263','lat'=>'39.686956078878','level'=>'3','tree'=>'tr_0 tr_210000 tr_210200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210302','title'=>'铁东区','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.99739966805','lat'=>'41.096331870506','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210303','title'=>'铁西区','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.97549026615','lat'=>'41.125475259583','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210304','title'=>'立山区','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.03548413862','lat'=>'41.156116121102','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210311','title'=>'千山区','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'122.96757421833','lat'=>'41.080938608935','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210321','title'=>'台安县','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.44255004099','lat'=>'41.418590371099','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210323','title'=>'岫岩满族自治县','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'123.28754677827','lat'=>'40.295892396362','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210381','title'=>'海城市','pid'=>'210300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'122.69156940124','lat'=>'40.887633947097','level'=>'3','tree'=>'tr_0 tr_210000 tr_210300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210402','title'=>'新抚区','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'123.91958231814','lat'=>'41.867805858593','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210403','title'=>'东洲区','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.04554972353','lat'=>'41.859190936634','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210404','title'=>'望花区','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'123.790604152','lat'=>'41.859030362749','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210411','title'=>'顺城区','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.95141404338','lat'=>'41.889163788467','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210421','title'=>'抚顺县','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'123.92159012079','lat'=>'41.887037475382','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210422','title'=>'新宾满族自治县','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'125.04635620406','lat'=>'41.739968775071','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210423','title'=>'清原满族自治县','pid'=>'210400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'124.93036025933','lat'=>'42.106760992634','level'=>'3','tree'=>'tr_0 tr_210000 tr_210400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210502','title'=>'平山区','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'123.77461422409','lat'=>'41.301604181774','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210503','title'=>'溪湖区','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'123.77461054104','lat'=>'41.334802931364','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210504','title'=>'明山区','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'123.82347449807','lat'=>'41.314939368877','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210505','title'=>'南芬区','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'123.75146713686','lat'=>'41.10709572322','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210521','title'=>'本溪满族自治县','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'124.12758486914','lat'=>'41.307902881353','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210522','title'=>'桓仁满族自治县','pid'=>'210500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'125.36754435102','lat'=>'41.27292530103','level'=>'3','tree'=>'tr_0 tr_210000 tr_210500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210602','title'=>'元宝区','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'124.40258403322','lat'=>'40.142251463139','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210603','title'=>'振兴区','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'124.36657851109','lat'=>'40.110719472216','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210604','title'=>'振安区','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'124.43438692285','lat'=>'40.164697025661','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210624','title'=>'宽甸满族自治县','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'124.79042662868','lat'=>'40.73755320049','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210681','title'=>'东港市','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.15961035888','lat'=>'39.867716187286','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210682','title'=>'凤城市','pid'=>'210600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'124.07242172439','lat'=>'40.459180482456','level'=>'3','tree'=>'tr_0 tr_210000 tr_210600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210702','title'=>'古塔区','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'121.13458496929','lat'=>'41.122900925898','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210703','title'=>'凌河区','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.15759003442','lat'=>'41.120690614472','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210711','title'=>'太和区','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.1104532494','lat'=>'41.115109307132','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210726','title'=>'黑山县','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'122.13055703906','lat'=>'41.671592983776','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210727','title'=>'义县','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.24556854895','lat'=>'41.538938862271','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210781','title'=>'凌海市','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.36253879584','lat'=>'41.166487628588','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210782','title'=>'北镇市','pid'=>'210700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.78344729848','lat'=>'41.594428096803','level'=>'3','tree'=>'tr_0 tr_210000 tr_210700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210802','title'=>'站前区','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.26543743173','lat'=>'40.678764125936','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210803','title'=>'西市区','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'122.21358238684','lat'=>'40.672110926311','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210804','title'=>'鲅鱼圈区','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'122.12757349697','lat'=>'40.232339850773','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210811','title'=>'老边区','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'122.38643918392','lat'=>'40.686383619803','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210881','title'=>'盖州市','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'122.35559128288','lat'=>'40.406167457268','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210882','title'=>'大石桥市','pid'=>'210800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'122.5153795314','lat'=>'40.650802164815','level'=>'3','tree'=>'tr_0 tr_210000 tr_210800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210902','title'=>'海州区','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.66943571061','lat'=>'42.023734789385','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210903','title'=>'新邱区','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.79936338568','lat'=>'42.093934514765','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210904','title'=>'太平区','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.68538413681','lat'=>'42.016967854141','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210905','title'=>'清河门区','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'121.42247894964','lat'=>'41.789318551009','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210911','title'=>'细河区','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.68639230508','lat'=>'42.03187124588','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210921','title'=>'阜新蒙古族自治县','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'121.76357399585','lat'=>'42.071368153837','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'210922','title'=>'彰武县','pid'=>'210900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'122.54544932021','lat'=>'42.392706534364','level'=>'3','tree'=>'tr_0 tr_210000 tr_210900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211002','title'=>'白塔区','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'123.18060844799','lat'=>'41.275845361792','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211003','title'=>'文圣区','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'123.19160469557','lat'=>'41.268438007815','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211004','title'=>'宏伟区','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'123.20358018598','lat'=>'41.223368108445','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211005','title'=>'弓长岭区','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'123.42661543055','lat'=>'41.157327042722','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211011','title'=>'太子河区','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.188604445','lat'=>'41.259226178044','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211021','title'=>'辽阳县','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.1124212208','lat'=>'41.211678771808','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211081','title'=>'灯塔市','pid'=>'211000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'123.34546215145','lat'=>'41.432474125926','level'=>'3','tree'=>'tr_0 tr_210000 tr_211000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211102','title'=>'双台子区','pid'=>'211100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'122.04639299922','lat'=>'41.206071617512','level'=>'3','tree'=>'tr_0 tr_210000 tr_211100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211103','title'=>'兴隆台区','pid'=>'211100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.96962911034','lat'=>'41.155830887559','level'=>'3','tree'=>'tr_0 tr_210000 tr_211100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211104','title'=>'大洼区','pid'=>'211100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'122.08855478867','lat'=>'41.00817878896','level'=>'3','tree'=>'tr_0 tr_210000 tr_211100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211122','title'=>'盘山县','pid'=>'211100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'122.00356035522','lat'=>'41.248263682582','level'=>'3','tree'=>'tr_0 tr_210000 tr_211100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211202','title'=>'银州区','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'123.8483863963','lat'=>'42.292573681442','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211204','title'=>'清河区','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'124.16556298034','lat'=>'42.552494793453','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211221','title'=>'铁岭县','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.7353723767','lat'=>'42.229225608048','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211223','title'=>'西丰县','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'124.73361509331','lat'=>'42.744014442436','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211224','title'=>'昌图县','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'124.11750067115','lat'=>'42.792178371844','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211281','title'=>'调兵山市','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'123.57350868313','lat'=>'42.473738012058','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211282','title'=>'开原市','pid'=>'211200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'124.04456886375','lat'=>'42.552079074779','level'=>'3','tree'=>'tr_0 tr_210000 tr_211200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211302','title'=>'双塔区','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.46048690274','lat'=>'41.571779500856','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211303','title'=>'龙城区','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.4435668693','lat'=>'41.59846852305','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211321','title'=>'朝阳县','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.25939061432','lat'=>'41.241075720873','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211322','title'=>'建平县','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.64938035777','lat'=>'41.409455511027','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211324','title'=>'喀喇沁左翼蒙古族自治县','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'119.74741405502','lat'=>'41.133689119828','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211381','title'=>'北票市','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'120.77762773422','lat'=>'41.80648256895','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211382','title'=>'凌源市','pid'=>'211300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.40735807879','lat'=>'41.251651297148','level'=>'3','tree'=>'tr_0 tr_210000 tr_211300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211402','title'=>'连山区','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.87648167423','lat'=>'40.780893808442','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211403','title'=>'龙港区','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.90062076024','lat'=>'40.741056601241','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211404','title'=>'南票区','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.75649312082','lat'=>'41.113097595823','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211421','title'=>'绥中县','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.35042453538','lat'=>'40.331843475397','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211422','title'=>'建昌县','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.84359526665','lat'=>'40.830379953809','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'211481','title'=>'兴城市','pid'=>'211400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.76455846701','lat'=>'40.616555664044','level'=>'3','tree'=>'tr_0 tr_210000 tr_211400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220102','title'=>'南关区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'125.35660981703','lat'=>'43.869873025193','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220103','title'=>'宽城区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'125.33462450832','lat'=>'43.949502239804','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220104','title'=>'朝阳区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'125.29540125585','lat'=>'43.840641474962','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220105','title'=>'二道区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'125.38046755375','lat'=>'43.871276524271','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220106','title'=>'绿园区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'125.26244260635','lat'=>'43.886810403937','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220112','title'=>'双阳区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'125.67144793217','lat'=>'43.531091309119','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220113','title'=>'九台区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'125.84556442307','lat'=>'44.157791853861','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220122','title'=>'农安县','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'125.19148410666','lat'=>'44.438903951261','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220171','title'=>'长春经济技术开发区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.37014719124','lat'=>'43.866004586928','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220172','title'=>'长春净月高新技术产业开发区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.26127292275','lat'=>'43.823034492758','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220173','title'=>'长春高新技术产业开发区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.26127292275','lat'=>'43.823034492758','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220174','title'=>'长春汽车经济技术开发区','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.33060207591','lat'=>'43.821953501043','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220182','title'=>'榆树市','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'126.53960936347','lat'=>'44.845439727693','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220183','title'=>'德惠市','pid'=>'220100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'125.73451517728','lat'=>'44.527161066608','level'=>'3','tree'=>'tr_0 tr_220000 tr_220100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220202','title'=>'昌邑区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'126.58144866124','lat'=>'43.887992474736','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220203','title'=>'龙潭区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'126.56854459242','lat'=>'43.91634255363','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220204','title'=>'船营区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'126.54764973677','lat'=>'43.83992740229','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220211','title'=>'丰满区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'126.56857046362','lat'=>'43.827151576836','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220221','title'=>'永吉县','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'126.50441572986','lat'=>'43.678720676989','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220271','title'=>'吉林经济开发区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.55563450495','lat'=>'43.843567834579','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220272','title'=>'吉林高新技术产业开发区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.55091570611','lat'=>'43.822448990547','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220273','title'=>'吉林中国新加坡食品区','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.55563450495','lat'=>'43.843567834579','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220281','title'=>'蛟河市','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'127.35148018677','lat'=>'43.730003870507','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220282','title'=>'桦甸市','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.75248423373','lat'=>'42.977982779881','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220283','title'=>'舒兰市','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'126.97137703226','lat'=>'44.412270028324','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220284','title'=>'磐石市','pid'=>'220200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'126.06661629889','lat'=>'42.951817500114','level'=>'3','tree'=>'tr_0 tr_220000 tr_220200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220302','title'=>'铁西区','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'124.35246676034','lat'=>'43.152575391803','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220303','title'=>'铁东区','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'124.4164827059','lat'=>'43.167993993185','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220322','title'=>'梨树县','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'124.3424012471','lat'=>'43.313345515553','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220323','title'=>'伊通满族自治县','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'125.31148460754','lat'=>'43.351103666821','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220381','title'=>'公主岭市','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'124.82944866071','lat'=>'43.510832663153','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220382','title'=>'双辽市','pid'=>'220300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'123.50943776128','lat'=>'43.524527382171','level'=>'3','tree'=>'tr_0 tr_220000 tr_220300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220402','title'=>'龙山区','pid'=>'220400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'125.14345242969','lat'=>'42.907634012133','level'=>'3','tree'=>'tr_0 tr_220000 tr_220400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220403','title'=>'西安区','pid'=>'220400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'125.15537330313','lat'=>'42.933308420625','level'=>'3','tree'=>'tr_0 tr_220000 tr_220400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220421','title'=>'东丰县','pid'=>'220400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'125.53737790091','lat'=>'42.683310778553','level'=>'3','tree'=>'tr_0 tr_220000 tr_220400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220422','title'=>'东辽县','pid'=>'220400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.99758944369','lat'=>'42.931879101776','level'=>'3','tree'=>'tr_0 tr_220000 tr_220400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220502','title'=>'东昌区','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'125.93359459016','lat'=>'41.70840538484','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220503','title'=>'二道江区','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'126.0495917027','lat'=>'41.779966174493','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220521','title'=>'通化县','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'125.76539191393','lat'=>'41.685682238068','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220523','title'=>'辉南县','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.05358125713','lat'=>'42.690699881882','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220524','title'=>'柳河县','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'125.75142398189','lat'=>'42.290871215056','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220581','title'=>'梅河口市','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'125.71760780995','lat'=>'42.544883890284','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220582','title'=>'集安市','pid'=>'220500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.199577372','lat'=>'41.131299724033','level'=>'3','tree'=>'tr_0 tr_220000 tr_220500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220602','title'=>'浑江区','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.42361952721','lat'=>'41.95042372822','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220605','title'=>'江源区','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.59739097896','lat'=>'42.062939372081','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220621','title'=>'抚松县','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'127.45537119527','lat'=>'42.227335272553','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220622','title'=>'靖宇县','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'126.81949899257','lat'=>'42.394765734578','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220623','title'=>'长白朝鲜族自治县','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'128.20758420219','lat'=>'41.425895812594','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220681','title'=>'临江市','pid'=>'220600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'126.9245815135','lat'=>'41.817678643992','level'=>'3','tree'=>'tr_0 tr_220000 tr_220600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220702','title'=>'宁江区','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'124.82342254815','lat'=>'45.178039438667','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220721','title'=>'前郭尔罗斯蒙古族自治县','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'124.83045556165','lat'=>'45.123416092926','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220722','title'=>'长岭县','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'123.9743741034','lat'=>'44.281638280052','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220723','title'=>'乾安县','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'124.0475638046','lat'=>'45.008434321605','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220771','title'=>'吉林松原经济开发区','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'124.83148187569','lat'=>'45.147404193414','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220781','title'=>'扶余市','pid'=>'220700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'126.0566062111','lat'=>'44.994168421151','level'=>'3','tree'=>'tr_0 tr_220000 tr_220700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220802','title'=>'洮北区','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.85750977516','lat'=>'45.627524686514','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220821','title'=>'镇赉县','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'123.20657575565','lat'=>'45.853116635389','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220822','title'=>'通榆县','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.09452077673','lat'=>'44.818963735882','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220871','title'=>'吉林白城经济开发区','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'122.81641245977','lat'=>'45.642168989302','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220881','title'=>'洮南市','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'122.7944676826','lat'=>'45.341131872567','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'220882','title'=>'大安市','pid'=>'220800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.29850428102','lat'=>'45.513045149628','level'=>'3','tree'=>'tr_0 tr_220000 tr_220800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222401','title'=>'延吉市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'129.52052013726','lat'=>'42.91271700988','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222402','title'=>'图们市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'129.85038151375','lat'=>'42.974283499075','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222403','title'=>'敦化市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'128.23861239315','lat'=>'43.378291274517','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222404','title'=>'珲春市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'130.37261321858','lat'=>'42.868515115192','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222405','title'=>'龙井市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'129.43263477701','lat'=>'42.771534868349','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222406','title'=>'和龙市','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'129.01738712621','lat'=>'42.552322568432','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222424','title'=>'汪清县','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'129.77760879625','lat'=>'43.318450833865','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'222426','title'=>'安图县','pid'=>'222400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'128.90544846814','lat'=>'43.117916954912','level'=>'3','tree'=>'tr_0 tr_220000 tr_222400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230102','title'=>'道里区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'126.62343158837','lat'=>'45.761844478815','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230103','title'=>'南岗区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'126.67563849952','lat'=>'45.765866163758','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230104','title'=>'道外区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'126.65560404089','lat'=>'45.797776220434','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230108','title'=>'平房区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'126.54161509032','lat'=>'45.808825827952','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230109','title'=>'松北区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'126.51648256825','lat'=>'45.808592561429','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230110','title'=>'香坊区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'126.66962434413','lat'=>'45.713619645389','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230111','title'=>'呼兰区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.5943989831','lat'=>'45.895209780863','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230112','title'=>'阿城区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'126.96435649552','lat'=>'45.554275304352','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230113','title'=>'双城区','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'126.31962313777','lat'=>'45.388111522394','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230123','title'=>'依兰县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'129.57451969721','lat'=>'46.331260289052','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230124','title'=>'方正县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'128.83563368134','lat'=>'45.857758440062','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230125','title'=>'宾县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'127.4734970145','lat'=>'45.752465386742','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230126','title'=>'巴彦县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'127.4105479864','lat'=>'46.091282657815','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230127','title'=>'木兰县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'128.05035620452','lat'=>'45.956871319448','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230128','title'=>'通河县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'128.75241627584','lat'=>'45.996392590921','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230129','title'=>'延寿县','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'128.33860582402','lat'=>'45.457641195714','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230183','title'=>'尚志市','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'128.01548820666','lat'=>'45.215473941867','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230184','title'=>'五常市','pid'=>'230100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'127.17352882965','lat'=>'44.937842855774','level'=>'3','tree'=>'tr_0 tr_230000 tr_230100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230202','title'=>'龙沙区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.96437622285','lat'=>'47.323576977429','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230203','title'=>'建华区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'123.96135010108','lat'=>'47.360554871046','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230204','title'=>'铁锋区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.984415712','lat'=>'47.347018863772','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230205','title'=>'昂昂溪区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'123.82940626913','lat'=>'47.161332243626','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230206','title'=>'富拉尔基区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'123.63650980324','lat'=>'47.215504082791','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230207','title'=>'碾子山区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'122.89436680108','lat'=>'47.523236298133','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230208','title'=>'梅里斯达斡尔族区','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'123.75954091741','lat'=>'47.315549574077','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230221','title'=>'龙江县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'123.21153898342','lat'=>'47.343605740151','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230223','title'=>'依安县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'125.3124821661','lat'=>'47.899483651368','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230224','title'=>'泰来县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'123.42362630925','lat'=>'46.39782928518','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230225','title'=>'甘南县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'123.51248588182','lat'=>'47.92688406951','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230227','title'=>'富裕县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'124.48054247906','lat'=>'47.780228063275','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230229','title'=>'克山县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'125.88137832693','lat'=>'48.043172360737','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230230','title'=>'克东县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'126.25538674804','lat'=>'48.048244160483','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230231','title'=>'拜泉县','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'126.10542147027','lat'=>'47.601867301959','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230281','title'=>'讷河市','pid'=>'230200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'124.8905490562','lat'=>'48.490086593264','level'=>'3','tree'=>'tr_0 tr_230000 tr_230200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230302','title'=>'鸡冠区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'130.98763160852','lat'=>'45.309806344312','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230303','title'=>'恒山区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'130.91138523344','lat'=>'45.216971883154','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230304','title'=>'滴道区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'130.85058046059','lat'=>'45.354433617216','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230305','title'=>'梨树区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'130.70339606719','lat'=>'45.098241780981','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230306','title'=>'城子河区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'131.02770429868','lat'=>'45.379689760283','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230307','title'=>'麻山区','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'130.48453641613','lat'=>'45.217934996767','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230321','title'=>'鸡东县','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'131.13055848296','lat'=>'45.266184560826','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230381','title'=>'虎林市','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'132.94346566318','lat'=>'45.768946912884','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230382','title'=>'密山市','pid'=>'230300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'131.85353110655','lat'=>'45.535640809748','level'=>'3','tree'=>'tr_0 tr_230000 tr_230300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230402','title'=>'向阳区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.30046804764','lat'=>'47.348580889067','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230403','title'=>'工农区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'130.28161728617','lat'=>'47.324430299458','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230404','title'=>'南山区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'130.29354031555','lat'=>'47.321245938809','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230405','title'=>'兴安区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.24554573859','lat'=>'47.258716269483','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230406','title'=>'东山区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'130.32336109407','lat'=>'47.344987135573','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230407','title'=>'兴山区','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.31736364716','lat'=>'47.396045381282','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230421','title'=>'萝北县','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'130.8354950365','lat'=>'47.583422197029','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230422','title'=>'绥滨县','pid'=>'230400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'131.85948651276','lat'=>'47.295265458073','level'=>'3','tree'=>'tr_0 tr_230000 tr_230400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230502','title'=>'尖山区','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'131.16534177061','lat'=>'46.652585923812','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230503','title'=>'岭东区','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'131.164376721','lat'=>'46.464596047853','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230505','title'=>'四方台区','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'131.345657378','lat'=>'46.602012285083','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230506','title'=>'宝山区','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'131.40737518857','lat'=>'46.583598340241','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230521','title'=>'集贤县','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'131.14743449942','lat'=>'46.734517788557','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230522','title'=>'友谊县','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'131.8145948627','lat'=>'46.772973223022','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230523','title'=>'宝清县','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'132.20359411633','lat'=>'46.332651823572','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230524','title'=>'饶河县','pid'=>'230500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'134.02046893233','lat'=>'46.804182744162','level'=>'3','tree'=>'tr_0 tr_230000 tr_230500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230602','title'=>'萨尔图区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'125.13351006443','lat'=>'46.638936435554','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230603','title'=>'龙凤区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'125.14047256095','lat'=>'46.567678067125','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230604','title'=>'让胡路区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'124.87759881447','lat'=>'46.658078458609','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230605','title'=>'红岗区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'124.8974774171','lat'=>'46.404313108628','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230606','title'=>'大同区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.81937675979','lat'=>'46.045583951311','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230621','title'=>'肇州县','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.2753682248','lat'=>'45.705107986871','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230622','title'=>'肇源县','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.08457262601','lat'=>'45.524152914206','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230623','title'=>'林甸县','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'124.86965042766','lat'=>'47.177234395243','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230624','title'=>'杜尔伯特蒙古族自治县','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'124.44935879141','lat'=>'46.868767758452','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230671','title'=>'大庆高新技术产业开发区','pid'=>'230600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'125.15778147083','lat'=>'46.581298438495','level'=>'3','tree'=>'tr_0 tr_230000 tr_230600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230702','title'=>'伊春区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'128.91345891818','lat'=>'47.733954439001','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230703','title'=>'南岔区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'129.28957179961','lat'=>'47.143749913595','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230704','title'=>'友好区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'128.84257946937','lat'=>'47.846436100332','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230705','title'=>'西林区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'129.31959406806','lat'=>'47.486393100686','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230706','title'=>'翠峦区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'128.67648152295','lat'=>'47.732893980201','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230707','title'=>'新青区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'129.54064675236','lat'=>'48.296134660851','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230708','title'=>'美溪区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'129.13536777746','lat'=>'47.64134415168','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230709','title'=>'金山屯区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'129.43563861113','lat'=>'47.418759014597','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230710','title'=>'五营区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'129.25134952898','lat'=>'48.11427128362','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230711','title'=>'乌马河区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'128.80554637557','lat'=>'47.73361851021','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230712','title'=>'汤旺河区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'129.57747422403','lat'=>'48.460614389845','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230713','title'=>'带岭区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'129.02742523145','lat'=>'47.034571951137','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230714','title'=>'乌伊岭区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'129.44457666112','lat'=>'48.596169129772','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230715','title'=>'红星区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'129.39750706935','lat'=>'48.245480405275','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230716','title'=>'上甘岭区','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'129.03043733966','lat'=>'47.980913793769','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230722','title'=>'嘉荫县','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'130.41055547772','lat'=>'48.894983469564','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230781','title'=>'铁力市','pid'=>'230700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'128.03836490393','lat'=>'46.992948620259','level'=>'3','tree'=>'tr_0 tr_230000 tr_230700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230803','title'=>'向阳区','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.37261186145','lat'=>'46.813511816781','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230804','title'=>'前进区','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'130.3816482759','lat'=>'46.819626508482','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230805','title'=>'东风区','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'130.41056077772','lat'=>'46.828385151991','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230811','title'=>'郊区','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'130.32735909257','lat'=>'46.805689990858','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230822','title'=>'桦南县','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'130.56038502153','lat'=>'46.24507747688','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230826','title'=>'桦川县','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'130.72554944886','lat'=>'47.028816852926','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230828','title'=>'汤原县','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'129.91164504155','lat'=>'46.735326720461','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230881','title'=>'同江市','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'132.51750949205','lat'=>'47.647980676666','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230882','title'=>'富锦市','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'132.04453879528','lat'=>'47.255932571848','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230883','title'=>'抚远市','pid'=>'230800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'134.31448962575','lat'=>'48.370944696273','level'=>'3','tree'=>'tr_0 tr_230000 tr_230800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230902','title'=>'新兴区','pid'=>'230900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'130.93837086995','lat'=>'45.822310328543','level'=>'3','tree'=>'tr_0 tr_230000 tr_230900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230903','title'=>'桃山区','pid'=>'230900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'131.02644424554','lat'=>'45.771799915696','level'=>'3','tree'=>'tr_0 tr_230000 tr_230900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230904','title'=>'茄子河区','pid'=>'230900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'131.0744805937','lat'=>'45.791238180152','level'=>'3','tree'=>'tr_0 tr_230000 tr_230900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'230921','title'=>'勃利县','pid'=>'230900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'130.59853255314','lat'=>'45.760964313167','level'=>'3','tree'=>'tr_0 tr_230000 tr_230900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231002','title'=>'东安区','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'129.63347765344','lat'=>'44.587460377571','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231003','title'=>'阳明区','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'129.64252736281','lat'=>'44.601775026515','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231004','title'=>'爱民区','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'129.59836369953','lat'=>'44.602350339442','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231005','title'=>'西安区','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'129.62241286515','lat'=>'44.583861081842','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231025','title'=>'林口县','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'130.28757880086','lat'=>'45.28412885062','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231071','title'=>'牡丹江经济技术开发区','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'129.63953977835','lat'=>'44.556245708986','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231081','title'=>'绥芬河市','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'131.15739222567','lat'=>'44.418154372388','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231083','title'=>'海林市','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'129.38742683358','lat'=>'44.599871973195','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231084','title'=>'宁安市','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'129.48936798014','lat'=>'44.3469835775','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231085','title'=>'穆棱市','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'130.53055850352','lat'=>'44.924784589588','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231086','title'=>'东宁市','pid'=>'231000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'131.13154357445','lat'=>'44.096101486248','level'=>'3','tree'=>'tr_0 tr_230000 tr_231000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231102','title'=>'爱辉区','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'127.50663227086','lat'=>'50.257709616452','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231121','title'=>'嫩江县','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'125.22763469543','lat'=>'49.191320184756','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231123','title'=>'逊克县','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'128.48558459529','lat'=>'49.5694914357','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231124','title'=>'孙吴县','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'127.34238770837','lat'=>'49.431450606859','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231181','title'=>'北安市','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'126.49737974226','lat'=>'48.247419532219','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231182','title'=>'五大连池市','pid'=>'231100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'126.21155518831','lat'=>'48.522609551763','level'=>'3','tree'=>'tr_0 tr_230000 tr_231100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231202','title'=>'北林区','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'126.99144894055','lat'=>'46.643492672111','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231221','title'=>'望奎县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'126.49238489413','lat'=>'46.839167601749','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231222','title'=>'兰西县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'126.29461952255','lat'=>'46.258095172245','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231223','title'=>'青冈县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'126.10048887472','lat'=>'46.71068498305','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231224','title'=>'庆安县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'127.5146121882','lat'=>'46.885744465245','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231225','title'=>'明水县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'125.91248269419','lat'=>'47.179483374941','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231226','title'=>'绥棱县','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'127.12051514063','lat'=>'47.242515793854','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231281','title'=>'安达市','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'125.34862234422','lat'=>'46.425719232144','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231282','title'=>'肇东市','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'125.96853740717','lat'=>'46.056938289303','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'231283','title'=>'海伦市','pid'=>'231200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.93650857556','lat'=>'47.456903841096','level'=>'3','tree'=>'tr_0 tr_230000 tr_231200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232701','title'=>'漠河市','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'122.5454208342','lat'=>'52.978303678377','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232721','title'=>'呼玛县','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'126.65964991907','lat'=>'51.73094674724','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232722','title'=>'塔河县','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'124.71651251449','lat'=>'52.340305081113','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232761','title'=>'加格达奇区','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'124.15292785448','lat'=>'50.420025955028','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232762','title'=>'松岭区','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'124.15292785448','lat'=>'50.420025955028','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232763','title'=>'新林区','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'124.53914092375','lat'=>'51.801225110533','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'232764','title'=>'呼中区','pid'=>'232700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'123.58143136869','lat'=>'52.037468814622','level'=>'3','tree'=>'tr_0 tr_230000 tr_232700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310101','title'=>'黄浦区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.49158559252','lat'=>'31.237247152064','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310104','title'=>'徐汇区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.44339635276','lat'=>'31.194556772823','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310105','title'=>'长宁区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.43045437545','lat'=>'31.226847968225','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310106','title'=>'静安区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.45343177277','lat'=>'31.233844930402','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310107','title'=>'普陀区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310109','title'=>'虹口区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.51158645453','lat'=>'31.269746698931','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310110','title'=>'杨浦区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.53251993733','lat'=>'31.265524144657','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310112','title'=>'闵行区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'121.38861193361','lat'=>'31.118842580087','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310113','title'=>'宝山区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'131.40737518857','lat'=>'46.583598340241','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310114','title'=>'嘉定区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.27259505835','lat'=>'31.380155339677','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310115','title'=>'浦东新区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.55045460683','lat'=>'31.227348292436','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310116','title'=>'金山区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.34848004512','lat'=>'30.74785237657','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310117','title'=>'松江区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.23447959624','lat'=>'31.037135176464','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310118','title'=>'青浦区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'121.13055310467','lat'=>'31.155454317981','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310120','title'=>'奉贤区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'121.48050373643','lat'=>'30.923720110285','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'310151','title'=>'崇明区','pid'=>'310100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'121.40355686272','lat'=>'31.628569984404','level'=>'3','tree'=>'tr_0 tr_310000 tr_310100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320102','title'=>'玄武区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.80441263575','lat'=>'32.054756682949','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320104','title'=>'秦淮区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.80040736097','lat'=>'32.045138606405','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320105','title'=>'建邺区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.73856944695','lat'=>'32.009369695446','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320106','title'=>'鼓楼区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.77651899204','lat'=>'32.072405160557','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320111','title'=>'浦口区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'118.63460405875','lat'=>'32.064679277923','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320113','title'=>'栖霞区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.91542298491','lat'=>'32.10260020783','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320114','title'=>'雨花台区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.78544536406','lat'=>'31.997858805466','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320115','title'=>'江宁区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.84656705909','lat'=>'31.958526869177','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320116','title'=>'六合区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.82747132971','lat'=>'32.32866604102','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320117','title'=>'溧水区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.03440390903','lat'=>'31.657283696314','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320118','title'=>'高淳区','pid'=>'320100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.89849765147','lat'=>'31.333639123905','level'=>'3','tree'=>'tr_0 tr_320000 tr_320100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320205','title'=>'锡山区','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.36342571103','lat'=>'31.594761632814','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320206','title'=>'惠山区','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.30459559335','lat'=>'31.686741337275','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320211','title'=>'滨湖区','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'120.29154752616','lat'=>'31.534639699974','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320213','title'=>'梁溪区','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.30959951436','lat'=>'31.571645024135','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320214','title'=>'新吴区','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.37039647195','lat'=>'31.554850239842','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320281','title'=>'江阴市','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.29156800752','lat'=>'31.926044909769','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320282','title'=>'宜兴市','pid'=>'320200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.83160603216','lat'=>'31.342956624268','level'=>'3','tree'=>'tr_0 tr_320000 tr_320200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320302','title'=>'鼓楼区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.19257874733','lat'=>'34.293760084221','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320303','title'=>'云龙区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.2584239124','lat'=>'34.259086691031','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320305','title'=>'贾汪区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.46943039703','lat'=>'34.441620400617','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320311','title'=>'泉山区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'117.20059046468','lat'=>'34.249942871606','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320312','title'=>'铜山区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.17556960199','lat'=>'34.186100449885','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320321','title'=>'丰县','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.60258246804','lat'=>'34.699769765634','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320322','title'=>'沛县','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.9425856239','lat'=>'34.765151955415','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320324','title'=>'睢宁县','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.94743277245','lat'=>'33.918789417818','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320371','title'=>'徐州经济技术开发区','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.28574962221','lat'=>'34.272904039312','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320381','title'=>'新沂市','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.36153652102','lat'=>'34.375610954637','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320382','title'=>'邳州市','pid'=>'320300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'117.96341066307','lat'=>'34.339753160807','level'=>'3','tree'=>'tr_0 tr_320000 tr_320300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320402','title'=>'天宁区','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.98046316025','lat'=>'31.785570271253','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320404','title'=>'钟楼区','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.908462716','lat'=>'31.807646657754','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320411','title'=>'新北区','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.97751429276','lat'=>'31.836323947624','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320412','title'=>'武进区','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.94861167229','lat'=>'31.706446611742','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320413','title'=>'金坛区','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.60457090266','lat'=>'31.72889303001','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320481','title'=>'溧阳市','pid'=>'320400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.49150603896','lat'=>'31.422102292159','level'=>'3','tree'=>'tr_0 tr_320000 tr_320400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320505','title'=>'虎丘区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.57847178571','lat'=>'31.301932876554','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320506','title'=>'吴中区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.63850751921','lat'=>'31.268261445846','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320507','title'=>'相城区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.64856593584','lat'=>'31.374689921493','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320508','title'=>'姑苏区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'120.6234549731','lat'=>'31.341831300993','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320509','title'=>'吴江区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.65156717454','lat'=>'31.144644190473','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320571','title'=>'苏州工业园区','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.82848521083','lat'=>'31.309610913062','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320581','title'=>'常熟市','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.75949588665','lat'=>'31.659538276741','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320582','title'=>'张家港市','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.56155363871','lat'=>'31.88114053634','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320583','title'=>'昆山市','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'120.98745249795','lat'=>'31.390863425082','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320585','title'=>'太仓市','pid'=>'320500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.1355952935','lat'=>'31.464599352978','level'=>'3','tree'=>'tr_0 tr_320000 tr_320500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320602','title'=>'崇川区','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.86342022229','lat'=>'32.015923029631','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320611','title'=>'港闸区','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'120.82445235808','lat'=>'32.037345124875','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320612','title'=>'通州区','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.08142549498','lat'=>'32.070355739676','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320623','title'=>'如东县','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'121.19243791024','lat'=>'32.335872886155','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320671','title'=>'南通经济技术开发区','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.90159173866','lat'=>'31.986549431201','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320681','title'=>'启东市','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'121.66347374677','lat'=>'31.814232849643','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320682','title'=>'如皋市','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'120.57946558109','lat'=>'32.377851486109','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320684','title'=>'海门市','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.18843649817','lat'=>'31.87361172603','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320685','title'=>'海安市','pid'=>'320600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.47443309578','lat'=>'32.53919574424','level'=>'3','tree'=>'tr_0 tr_320000 tr_320600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320703','title'=>'连云区','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.46701669742','lat'=>'34.638921829102','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320706','title'=>'海州区','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.16940808819','lat'=>'34.577456118597','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320707','title'=>'赣榆区','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.17943461497','lat'=>'34.847682460846','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320722','title'=>'东海县','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.75956509248','lat'=>'34.547918627364','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320723','title'=>'灌云县','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.24653354504','lat'=>'34.288616060258','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320724','title'=>'灌南县','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.3225381861','lat'=>'34.09259130777','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320771','title'=>'连云港经济技术开发区','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.35457059279','lat'=>'34.70740063931','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320772','title'=>'连云港高新技术产业开发区','pid'=>'320700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.22862133317','lat'=>'34.602249525267','level'=>'3','tree'=>'tr_0 tr_320000 tr_320700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320803','title'=>'淮安区','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.14746320322','lat'=>'33.508999838208','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320804','title'=>'淮阴区','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.04142174116','lat'=>'33.638150424768','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320812','title'=>'清江浦区','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'119.03241362334','lat'=>'33.558562240066','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320813','title'=>'洪泽区','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.8795836493','lat'=>'33.29962468147','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320826','title'=>'涟水县','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.26644843921','lat'=>'33.7870787079','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320830','title'=>'盱眙县','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.55144127024','lat'=>'33.01825474166','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320831','title'=>'金湖县','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.02646908663','lat'=>'33.031283826757','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320871','title'=>'淮安经济技术开发区','pid'=>'320800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.13289044209','lat'=>'33.610236869931','level'=>'3','tree'=>'tr_0 tr_320000 tr_320800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320902','title'=>'亭湖区','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'120.20457816804','lat'=>'33.395893486907','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320903','title'=>'盐都区','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.16050325734','lat'=>'33.344020315599','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320904','title'=>'大丰区','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'120.50743881649','lat'=>'33.20475984971','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320921','title'=>'响水县','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.58460112202','lat'=>'34.20474300276','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320922','title'=>'滨海县','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.82762105909','lat'=>'33.995646547467','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320923','title'=>'阜宁县','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.80958074885','lat'=>'33.765078727087','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320924','title'=>'射阳县','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.26444564892','lat'=>'33.78101359213','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320925','title'=>'建湖县','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.80553127745','lat'=>'33.469832978385','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320971','title'=>'盐城经济技术开发区','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.16754426576','lat'=>'33.355100917626','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'320981','title'=>'东台市','pid'=>'320900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'120.32653706475','lat'=>'32.872716312488','level'=>'3','tree'=>'tr_0 tr_320000 tr_320900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321002','title'=>'广陵区','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.43850484608','lat'=>'32.40066115972','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321003','title'=>'邗江区','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.40438513671','lat'=>'32.38275135526','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321012','title'=>'江都区','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.57660296908','lat'=>'32.440294506243','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321023','title'=>'宝应县','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.36555570138','lat'=>'33.247205461148','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321071','title'=>'扬州经济技术开发区','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.41941890823','lat'=>'32.40067693609','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321081','title'=>'仪征市','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.19146705795','lat'=>'32.278090483161','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321084','title'=>'高邮市','pid'=>'321000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.46561561654','lat'=>'32.787147020528','level'=>'3','tree'=>'tr_0 tr_320000 tr_321000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321102','title'=>'京口区','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.47560369584','lat'=>'32.203785483528','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321111','title'=>'润州区','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'119.41844047387','lat'=>'32.201494843152','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321112','title'=>'丹徒区','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.44050079109','lat'=>'32.13792039565','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321171','title'=>'镇江新区','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.67618104484','lat'=>'32.168646770866','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321181','title'=>'丹阳市','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.61250060471','lat'=>'32.01592027417','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321182','title'=>'扬中市','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.80351961209','lat'=>'32.242967194122','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321183','title'=>'句容市','pid'=>'321100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.1754332029','lat'=>'31.950923490521','level'=>'3','tree'=>'tr_0 tr_320000 tr_321100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321202','title'=>'海陵区','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.9255249512','lat'=>'32.496731549227','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321203','title'=>'高港区','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.88842098109','lat'=>'32.32486247444','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321204','title'=>'姜堰区','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.13339832587','lat'=>'32.515233674759','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321271','title'=>'泰州医药高新技术产业开发区','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.91593203649','lat'=>'32.502484457877','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321281','title'=>'兴化市','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.85751406137','lat'=>'32.917824213889','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321282','title'=>'靖江市','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.28353203592','lat'=>'31.988170075211','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321283','title'=>'泰兴市','pid'=>'321200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'120.05859939046','lat'=>'32.177474023712','level'=>'3','tree'=>'tr_0 tr_320000 tr_321200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321302','title'=>'宿城区','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.24956705107','lat'=>'33.968677630731','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321311','title'=>'宿豫区','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.33640094471','lat'=>'33.954804396327','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321322','title'=>'沭阳县','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.81041906571','lat'=>'34.117454209479','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321323','title'=>'泗阳县','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.70946596538','lat'=>'33.728328313047','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321324','title'=>'泗洪县','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.22241594669','lat'=>'33.465732594595','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'321371','title'=>'宿迁经济技术开发区','pid'=>'321300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.27387299732','lat'=>'33.898354594037','level'=>'3','tree'=>'tr_0 tr_320000 tr_321300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330102','title'=>'上城区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.17557880007','lat'=>'30.248398420426','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330103','title'=>'下城区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.18760693119','lat'=>'30.286744052562','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330104','title'=>'江干区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.21153877811','lat'=>'30.263310567012','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330105','title'=>'拱墅区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'120.14844700926','lat'=>'30.32464256663','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330106','title'=>'西湖区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.13643801205','lat'=>'30.265916325589','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330108','title'=>'滨江区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'120.21847118139','lat'=>'30.214332950144','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330109','title'=>'萧山区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.27047058397','lat'=>'30.187511222214','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330110','title'=>'余杭区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.30659216718','lat'=>'30.424739268745','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330111','title'=>'富阳区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.96655568418','lat'=>'30.054722967304','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330112','title'=>'临安区','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.73151737122','lat'=>'30.239805598054','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330122','title'=>'桐庐县','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.69759877583','lat'=>'29.798584790143','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330127','title'=>'淳安县','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.04839230601','lat'=>'29.614950366034','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330182','title'=>'建德市','pid'=>'330100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.28739807501','lat'=>'29.481154026968','level'=>'3','tree'=>'tr_0 tr_330000 tr_330100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330203','title'=>'海曙区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.55740307254','lat'=>'29.865720708366','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330205','title'=>'江北区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.56042128922','lat'=>'29.892948379476','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330206','title'=>'北仑区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'121.85057621461','lat'=>'29.904659359939','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330211','title'=>'镇海区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.72251899132','lat'=>'29.954884963349','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330212','title'=>'鄞州区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.55542706991','lat'=>'29.824206349996','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330213','title'=>'奉化区','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'121.41352776719','lat'=>'29.66114641278','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330225','title'=>'象山县','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'121.87556392982','lat'=>'29.482270653805','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330226','title'=>'宁海县','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'121.43643177294','lat'=>'29.294317441106','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330281','title'=>'余姚市','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.16058507482','lat'=>'30.042734639571','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330282','title'=>'慈溪市','pid'=>'330200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'121.27259613632','lat'=>'30.17525661072','level'=>'3','tree'=>'tr_0 tr_330000 tr_330200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330302','title'=>'鹿城区','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.66158649793','lat'=>'28.020351607763','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330303','title'=>'龙湾区','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.81946755397','lat'=>'27.938652244916','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330304','title'=>'瓯海区','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'O','lng'=>'120.62144724335','lat'=>'27.972857351643','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330305','title'=>'洞头区','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'121.16354856759','lat'=>'27.841870324587','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330324','title'=>'永嘉县','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.68852407508','lat'=>'28.156450332206','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330326','title'=>'平阳县','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'120.57251537444','lat'=>'27.667724401093','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330327','title'=>'苍南县','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.43359512229','lat'=>'27.523066788447','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330328','title'=>'文成县','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.09748845652','lat'=>'27.79321715229','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330329','title'=>'泰顺县','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.72353725759','lat'=>'27.562170559597','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330371','title'=>'温州经济技术开发区','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.82366240355','lat'=>'27.878919129203','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330381','title'=>'瑞安市','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'120.66158218607','lat'=>'27.783950736232','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330382','title'=>'乐清市','pid'=>'330300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.99250185617','lat'=>'28.118179995228','level'=>'3','tree'=>'tr_0 tr_330000 tr_330300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330402','title'=>'南湖区','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.78961005175','lat'=>'30.751546813315','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330411','title'=>'秀洲区','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.71543705563','lat'=>'30.770207214174','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330421','title'=>'嘉善县','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.93251060584','lat'=>'30.83712219382','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330424','title'=>'海盐县','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.95244526273','lat'=>'30.531872894538','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330481','title'=>'海宁市','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.68656506738','lat'=>'30.517923769776','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330482','title'=>'平湖市','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'121.02257525525','lat'=>'30.682240998058','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330483','title'=>'桐乡市','pid'=>'330400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'120.57154315531','lat'=>'30.63631118771','level'=>'3','tree'=>'tr_0 tr_330000 tr_330400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330502','title'=>'吴兴区','pid'=>'330500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'120.1916046602','lat'=>'30.862955454986','level'=>'3','tree'=>'tr_0 tr_330000 tr_330500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330503','title'=>'南浔区','pid'=>'330500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'120.42460139422','lat'=>'30.855242982243','level'=>'3','tree'=>'tr_0 tr_330000 tr_330500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330521','title'=>'德清县','pid'=>'330500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.98346466845','lat'=>'30.548628239139','level'=>'3','tree'=>'tr_0 tr_330000 tr_330500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330522','title'=>'长兴县','pid'=>'330500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.91749832197','lat'=>'31.032579326835','level'=>'3','tree'=>'tr_0 tr_330000 tr_330500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330523','title'=>'安吉县','pid'=>'330500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'119.68656337876','lat'=>'30.644424794114','level'=>'3','tree'=>'tr_0 tr_330000 tr_330500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330602','title'=>'越城区','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.58843667181','lat'=>'29.995309962798','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330603','title'=>'柯桥区','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'120.45151103408','lat'=>'30.07900360495','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330604','title'=>'上虞区','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.87450989364','lat'=>'30.038242967062','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330624','title'=>'新昌县','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.91056965639','lat'=>'29.50554107531','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330681','title'=>'诸暨市','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.25340833197','lat'=>'29.714934649195','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330683','title'=>'嵊州市','pid'=>'330600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.83743725739','lat'=>'29.567326991294','level'=>'3','tree'=>'tr_0 tr_330000 tr_330600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330702','title'=>'婺城区','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.57859260936','lat'=>'29.091775438186','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330703','title'=>'金东区','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.69958241405','lat'=>'29.104765016118','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330723','title'=>'武义县','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.82256555867','lat'=>'28.89824378665','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330726','title'=>'浦江县','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'119.8984360827','lat'=>'29.458692851855','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330727','title'=>'磐安县','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'120.45651305177','lat'=>'29.060103175107','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330781','title'=>'兰溪市','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.46659870554','lat'=>'29.214044345079','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330782','title'=>'义乌市','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.08158099306','lat'=>'29.31114987541','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330783','title'=>'东阳市','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'120.24842192791','lat'=>'29.295861065151','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330784','title'=>'永康市','pid'=>'330700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'120.05455071078','lat'=>'28.894203967255','level'=>'3','tree'=>'tr_0 tr_330000 tr_330700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330802','title'=>'柯城区','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.87758391504','lat'=>'28.974203651128','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330803','title'=>'衢江区','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.9655390736','lat'=>'28.986237907969','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330822','title'=>'常山县','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.51755663118','lat'=>'28.906997949113','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330824','title'=>'开化县','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.42145932131','lat'=>'29.143187521187','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330825','title'=>'龙游县','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.17841825566','lat'=>'29.034486553295','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330881','title'=>'江山市','pid'=>'330800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.63358329793','lat'=>'28.742868480118','level'=>'3','tree'=>'tr_0 tr_330000 tr_330800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330902','title'=>'定海区','pid'=>'330900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'122.11360080392','lat'=>'30.025462378363','level'=>'3','tree'=>'tr_0 tr_330000 tr_330900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330903','title'=>'普陀区','pid'=>'330900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'122.33154416586','lat'=>'29.976835696536','level'=>'3','tree'=>'tr_0 tr_330000 tr_330900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330921','title'=>'岱山县','pid'=>'330900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'122.23260481449','lat'=>'30.269655894035','level'=>'3','tree'=>'tr_0 tr_330000 tr_330900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'330922','title'=>'嵊泗县','pid'=>'330900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'122.45758776506','lat'=>'30.731273949024','level'=>'3','tree'=>'tr_0 tr_330000 tr_330900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331002','title'=>'椒江区','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'121.44940797569','lat'=>'28.679258224903','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331003','title'=>'黄岩区','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.26856605116','lat'=>'28.655333607551','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331004','title'=>'路桥区','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.37157806769','lat'=>'28.586946666726','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331022','title'=>'三门县','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'121.40255379759','lat'=>'29.110355206289','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331023','title'=>'天台县','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'121.01355337629','lat'=>'29.149514378149','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331024','title'=>'仙居县','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.73543520575','lat'=>'28.853225693258','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331081','title'=>'温岭市','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'121.39258889458','lat'=>'28.37765548985','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331082','title'=>'临海市','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.15158529413','lat'=>'28.864049329083','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331083','title'=>'玉环市','pid'=>'331000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.23851297084','lat'=>'28.141862986829','level'=>'3','tree'=>'tr_0 tr_330000 tr_331000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331102','title'=>'莲都区','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.91951913335','lat'=>'28.451745135046','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331121','title'=>'青田县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'120.296573349','lat'=>'28.14548755633','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331122','title'=>'缙云县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.09747830566','lat'=>'28.665214747164','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331123','title'=>'遂昌县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.28243538622','lat'=>'28.59845467671','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331124','title'=>'松阳县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.48854377016','lat'=>'28.455056404273','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331125','title'=>'云和县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'119.57959736407','lat'=>'28.121469507454','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331126','title'=>'庆元县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'119.06948685498','lat'=>'27.625431778354','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331127','title'=>'景宁畲族自治县','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.64243033109','lat'=>'27.979553966951','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'331181','title'=>'龙泉市','pid'=>'331100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.14844476521','lat'=>'28.080508725251','level'=>'3','tree'=>'tr_0 tr_330000 tr_331100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340102','title'=>'瑶海区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.31558704454','lat'=>'31.863786941657','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340103','title'=>'庐阳区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.27145913382','lat'=>'31.884886695554','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340104','title'=>'蜀山区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.2664607823','lat'=>'31.857378217104','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340111','title'=>'包河区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.31657625857','lat'=>'31.799293467782','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340121','title'=>'长丰县','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.17356009256','lat'=>'32.483722623763','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340122','title'=>'肥东县','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'117.47540062528','lat'=>'31.893890354487','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340123','title'=>'肥西县','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'117.16455781372','lat'=>'31.712962132717','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340124','title'=>'庐江县','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.29357730192','lat'=>'31.261327637478','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340171','title'=>'合肥高新技术产业开发区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.1837943471','lat'=>'31.838528178293','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340172','title'=>'合肥经济技术开发区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.21475703093','lat'=>'31.784661076762','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340173','title'=>'合肥新站高新技术产业开发区','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.38386824707','lat'=>'31.946175260915','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340181','title'=>'巢湖市','pid'=>'340100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.89557620045','lat'=>'31.629002428816','level'=>'3','tree'=>'tr_0 tr_340000 tr_340100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340202','title'=>'镜湖区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.39260630352','lat'=>'31.345866595569','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340203','title'=>'弋江区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.37957970583','lat'=>'31.317566272497','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340207','title'=>'鸠江区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.39758848554','lat'=>'31.375804519517','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340208','title'=>'三山区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.27460210698','lat'=>'31.225280124269','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340221','title'=>'芜湖县','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'118.58244251203','lat'=>'31.141239223464','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340222','title'=>'繁昌县','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'118.20542431831','lat'=>'31.107958593586','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340223','title'=>'南陵县','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.34041816695','lat'=>'30.920260298683','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340225','title'=>'无为县','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.90857854389','lat'=>'31.308844155979','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340271','title'=>'芜湖经济技术开发区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'118.39582758127','lat'=>'31.478017093937','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340272','title'=>'安徽芜湖长江大桥经济开发区','pid'=>'340200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'118.37946121933','lat'=>'31.391647770998','level'=>'3','tree'=>'tr_0 tr_340000 tr_340200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340302','title'=>'龙子湖区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.39951276393','lat'=>'32.948644262929','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340303','title'=>'蚌山区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.37944120527','lat'=>'32.923378770395','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340304','title'=>'禹会区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.3484523601','lat'=>'32.935309988858','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340311','title'=>'淮上区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.36638271774','lat'=>'32.970547011885','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340321','title'=>'怀远县','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.21150631391','lat'=>'32.976003726624','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340322','title'=>'五河县','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.88756088987','lat'=>'33.132709462866','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340323','title'=>'固镇县','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.32354764831','lat'=>'33.323274297744','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340371','title'=>'蚌埠市高新技术开发区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.27641494698','lat'=>'32.834931868561','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340372','title'=>'蚌埠市经济开发区','pid'=>'340300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.20923836199','lat'=>'32.962369404949','level'=>'3','tree'=>'tr_0 tr_340000 tr_340300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340402','title'=>'大通区','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.05958317929','lat'=>'32.637269959538','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340403','title'=>'田家庵区','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.02344533676','lat'=>'32.653323007096','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340404','title'=>'谢家集区','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.86543887721','lat'=>'32.606254588196','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340405','title'=>'八公山区','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'116.84056434849','lat'=>'32.637137318437','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340406','title'=>'潘集区','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.84158096084','lat'=>'32.777955491108','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340421','title'=>'凤台县','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.71757320891','lat'=>'32.715103905085','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340422','title'=>'寿县','pid'=>'340400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.8055627726','lat'=>'32.561546151201','level'=>'3','tree'=>'tr_0 tr_340000 tr_340400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340503','title'=>'花山区','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.49960562875','lat'=>'31.725472572001','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340504','title'=>'雨山区','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.50559705701','lat'=>'31.687745482904','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340506','title'=>'博望区','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'118.85155804451','lat'=>'31.556645467065','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340521','title'=>'当涂县','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.50460469891','lat'=>'31.576649154711','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340522','title'=>'含山县','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.10746203634','lat'=>'31.740862208736','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340523','title'=>'和县','pid'=>'340500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.35951254887','lat'=>'31.748243815854','level'=>'3','tree'=>'tr_0 tr_340000 tr_340500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340602','title'=>'杜集区','pid'=>'340600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.83461226601','lat'=>'33.997285436391','level'=>'3','tree'=>'tr_0 tr_340000 tr_340600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340603','title'=>'相山区','pid'=>'340600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.80052112276','lat'=>'33.96582716177','level'=>'3','tree'=>'tr_0 tr_340000 tr_340600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340604','title'=>'烈山区','pid'=>'340600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.9081817805','lat'=>'33.84405351094','level'=>'3','tree'=>'tr_0 tr_340000 tr_340600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340621','title'=>'濉溪县','pid'=>'340600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.77238942808','lat'=>'33.921629194823','level'=>'3','tree'=>'tr_0 tr_340000 tr_340600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340705','title'=>'铜官区','pid'=>'340700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.82145710265','lat'=>'30.940386340633','level'=>'3','tree'=>'tr_0 tr_340000 tr_340700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340706','title'=>'义安区','pid'=>'340700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.79856800876','lat'=>'30.958512099098','level'=>'3','tree'=>'tr_0 tr_340000 tr_340700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340711','title'=>'郊区','pid'=>'340700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.80755007573','lat'=>'30.897741483658','level'=>'3','tree'=>'tr_0 tr_340000 tr_340700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340722','title'=>'枞阳县','pid'=>'340700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.22643695997','lat'=>'30.705671267725','level'=>'3','tree'=>'tr_0 tr_340000 tr_340700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340802','title'=>'迎江区','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.09751448877','lat'=>'30.517523291408','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340803','title'=>'大观区','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.04053820417','lat'=>'30.518231924651','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340811','title'=>'宜秀区','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.99344112425','lat'=>'30.619675877796','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340822','title'=>'怀宁县','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.83659258051','lat'=>'30.739399674607','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340825','title'=>'太湖县','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'116.31547630162','lat'=>'30.460113290448','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340826','title'=>'宿松县','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.13552369949','lat'=>'30.159786861375','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340827','title'=>'望江县','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.7005902941','lat'=>'30.129968329229','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340828','title'=>'岳西县','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.36655539021','lat'=>'30.855227714002','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340871','title'=>'安徽安庆经济开发区','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'117.06360390492','lat'=>'30.530956568043','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340881','title'=>'桐城市','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'116.98046635878','lat'=>'31.041969037674','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'340882','title'=>'潜山市','pid'=>'340800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'116.58761103892','lat'=>'30.636755682399','level'=>'3','tree'=>'tr_0 tr_340000 tr_340800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341002','title'=>'屯溪区','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'118.32141818077','lat'=>'29.702143908546','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341003','title'=>'黄山区','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.14760982484','lat'=>'30.278650980188','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341004','title'=>'徽州区','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.34343582847','lat'=>'29.834221385317','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341021','title'=>'歙县','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.42146012979','lat'=>'29.866287675757','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341022','title'=>'休宁县','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.20543014116','lat'=>'29.795459004963','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341023','title'=>'黟县','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.94447724144','lat'=>'29.931047330704','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341024','title'=>'祁门县','pid'=>'341000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'117.72339257754','lat'=>'29.86034394808','level'=>'3','tree'=>'tr_0 tr_340000 tr_341000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341102','title'=>'琅琊区','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.31244134015','lat'=>'32.300867492599','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341103','title'=>'南谯区','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.42348205204','lat'=>'32.206131899264','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341122','title'=>'来安县','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.4424124932','lat'=>'32.458449762427','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341124','title'=>'全椒县','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.2805842827','lat'=>'32.091939797603','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341125','title'=>'定远县','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.70447068625','lat'=>'32.537046613487','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341126','title'=>'凤阳县','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'117.53858536874','lat'=>'32.880976725258','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341171','title'=>'苏滁现代产业园','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.42315086566','lat'=>'32.314484916002','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341172','title'=>'滁州经济技术开发区','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.37688910117','lat'=>'32.299081918592','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341181','title'=>'天长市','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.01138527949','lat'=>'32.67341003277','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341182','title'=>'明光市','pid'=>'341100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.99550981385','lat'=>'32.783022823418','level'=>'3','tree'=>'tr_0 tr_340000 tr_341100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341202','title'=>'颍州区','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.81341119616','lat'=>'32.88962541655','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341203','title'=>'颍东区','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.86361668264','lat'=>'32.917362240172','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341204','title'=>'颍泉区','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.81542555644','lat'=>'32.931313576025','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341221','title'=>'临泉县','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.26761550051','lat'=>'33.045959528363','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341222','title'=>'太和县','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'115.6286154697','lat'=>'33.165959850096','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341225','title'=>'阜南县','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.60254592516','lat'=>'32.664097385125','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341226','title'=>'颍上县','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.26347689904','lat'=>'32.659028468804','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341271','title'=>'阜阳合肥现代产业园区','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.88456164757','lat'=>'32.809466011566','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341272','title'=>'阜阳经济技术开发区','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.86257063732','lat'=>'32.867285704339','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341282','title'=>'界首市','pid'=>'341200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.38060984722','lat'=>'33.262775236231','level'=>'3','tree'=>'tr_0 tr_340000 tr_341200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341302','title'=>'埇桥区','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.98348044326','lat'=>'33.646130650445','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341321','title'=>'砀山县','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.37252400151','lat'=>'34.448428171397','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341322','title'=>'萧县','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.95358492572','lat'=>'34.194269344319','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341323','title'=>'灵璧县','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.56455699799','lat'=>'33.547892231948','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341324','title'=>'泗县','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.91658999175','lat'=>'33.488694630134','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341371','title'=>'宿州马鞍山现代产业园区','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.97054394561','lat'=>'33.652095326452','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341372','title'=>'宿州经济技术开发区','pid'=>'341300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.97054394561','lat'=>'33.652095326452','level'=>'3','tree'=>'tr_0 tr_340000 tr_341300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341702','title'=>'贵池区','pid'=>'341700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.57449037049','lat'=>'30.693857943819','level'=>'3','tree'=>'tr_0 tr_340000 tr_341700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341721','title'=>'东至县','pid'=>'341700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.03448128944','lat'=>'30.116534528265','level'=>'3','tree'=>'tr_0 tr_340000 tr_341700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341722','title'=>'石台县','pid'=>'341700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.49239440959','lat'=>'30.216530337189','level'=>'3','tree'=>'tr_0 tr_340000 tr_341700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341723','title'=>'青阳县','pid'=>'341700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'117.85343129914','lat'=>'30.645634346235','level'=>'3','tree'=>'tr_0 tr_340000 tr_341700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341802','title'=>'宣州区','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.76254944305','lat'=>'30.952158157984','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341821','title'=>'郎溪县','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.18646592169','lat'=>'31.132681870443','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341822','title'=>'广德县','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.42747581035','lat'=>'30.883667102643','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341823','title'=>'泾县','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.42643469242','lat'=>'30.694672488542','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341824','title'=>'绩溪县','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.58544384057','lat'=>'30.073292199533','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341825','title'=>'旌德县','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.54646735263','lat'=>'30.292481093722','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341871','title'=>'宣城市经济开发区','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.76553424277','lat'=>'30.946601545293','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341881','title'=>'宁国市','pid'=>'341800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.98960981494','lat'=>'30.639352229689','level'=>'3','tree'=>'tr_0 tr_340000 tr_341800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350102','title'=>'鼓楼区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.31049162322','lat'=>'26.088114037555','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350103','title'=>'台江区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'119.32052821102','lat'=>'26.058528150645','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350104','title'=>'仓山区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.28043216493','lat'=>'26.052841691927','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350105','title'=>'马尾区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'119.44551915828','lat'=>'26.004533771063','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350111','title'=>'晋安区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.33457941597','lat'=>'26.087213904434','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350112','title'=>'长乐区','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.52943832001','lat'=>'25.969257448077','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350121','title'=>'闽侯县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'119.13848201812','lat'=>'26.156035214577','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350122','title'=>'连江县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.54647881621','lat'=>'26.203583291029','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350123','title'=>'罗源县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.55648045992','lat'=>'26.495495660324','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350124','title'=>'闽清县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'118.86957650956','lat'=>'26.226847540202','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350125','title'=>'永泰县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.93843072857','lat'=>'25.872787263196','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350128','title'=>'平潭县','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'119.79650131414','lat'=>'25.504700273945','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350181','title'=>'福清市','pid'=>'350100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.39046524749','lat'=>'25.726343299035','level'=>'3','tree'=>'tr_0 tr_350000 tr_350100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350203','title'=>'思明区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.08840797224','lat'=>'24.451948395671','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350205','title'=>'海沧区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.03956171185','lat'=>'24.490325818598','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350206','title'=>'湖里区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.15358812172','lat'=>'24.517573138112','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350211','title'=>'集美区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.10343491664','lat'=>'24.58201906225','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350212','title'=>'同安区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'118.15856347661','lat'=>'24.729113975347','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350213','title'=>'翔安区','pid'=>'350200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.25457589661','lat'=>'24.624216383593','level'=>'3','tree'=>'tr_0 tr_350000 tr_350200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350302','title'=>'城厢区','pid'=>'350300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.00153633131','lat'=>'25.424343792482','level'=>'3','tree'=>'tr_0 tr_350000 tr_350300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350303','title'=>'涵江区','pid'=>'350300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.12256736822','lat'=>'25.464464388124','level'=>'3','tree'=>'tr_0 tr_350000 tr_350300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350304','title'=>'荔城区','pid'=>'350300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.01948169064','lat'=>'25.439754478806','level'=>'3','tree'=>'tr_0 tr_350000 tr_350300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350305','title'=>'秀屿区','pid'=>'350300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'119.11157130031','lat'=>'25.323654397561','level'=>'3','tree'=>'tr_0 tr_350000 tr_350300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350322','title'=>'仙游县','pid'=>'350300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'118.69845425065','lat'=>'25.368291498104','level'=>'3','tree'=>'tr_0 tr_350000 tr_350300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350402','title'=>'梅列区','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.65255022877','lat'=>'26.277335878355','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350403','title'=>'三元区','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.61441509378','lat'=>'26.240219374574','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350421','title'=>'明溪县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.20851763568','lat'=>'26.361853685277','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350423','title'=>'清流县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'116.8235931858','lat'=>'26.18335735321','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350424','title'=>'宁化县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.660425512','lat'=>'26.26795649054','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350425','title'=>'大田县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.85343999668','lat'=>'25.698932641879','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350426','title'=>'尤溪县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.19743971365','lat'=>'26.17621803946','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350427','title'=>'沙县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.79856107581','lat'=>'26.402813444346','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350428','title'=>'将乐县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.47740904084','lat'=>'26.735209519833','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350429','title'=>'泰宁县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.1825958624','lat'=>'26.905660032285','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350430','title'=>'建宁县','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.85250622659','lat'=>'26.836824655349','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350481','title'=>'永安市','pid'=>'350400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.37144258732','lat'=>'25.948143989824','level'=>'3','tree'=>'tr_0 tr_350000 tr_350400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350502','title'=>'鲤城区','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.59348105353','lat'=>'24.913354167054','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350503','title'=>'丰泽区','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'118.61958015232','lat'=>'24.894969993262','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350504','title'=>'洛江区','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.67741629493','lat'=>'24.94621365376','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350505','title'=>'泉港区','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.92243298541','lat'=>'25.139650393954','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350521','title'=>'惠安县','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.8034155003','lat'=>'25.036949815039','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350524','title'=>'安溪县','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'118.19242537229','lat'=>'25.061759553382','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350525','title'=>'永春县','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.30048613527','lat'=>'25.327974202083','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350526','title'=>'德化县','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.24755006956','lat'=>'25.497308594179','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350581','title'=>'石狮市','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.65451902647','lat'=>'24.737665160883','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350582','title'=>'晋江市','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.55843052','lat'=>'24.787824575145','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350583','title'=>'南安市','pid'=>'350500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'118.39257197205','lat'=>'24.966362350468','level'=>'3','tree'=>'tr_0 tr_350000 tr_350500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350602','title'=>'芗城区','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.6605895241','lat'=>'24.516268416111','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350603','title'=>'龙文区','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.7164546946','lat'=>'24.509509680945','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350622','title'=>'云霄县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.34644831448','lat'=>'23.964072828248','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350623','title'=>'漳浦县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.62044335257','lat'=>'24.123461614812','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350624','title'=>'诏安县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.18255858272','lat'=>'23.717053963784','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350625','title'=>'长泰县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.76555257036','lat'=>'24.631243628383','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350626','title'=>'东山县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.43656030457','lat'=>'23.706894688691','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350627','title'=>'南靖县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'117.36344641066','lat'=>'24.52085173207','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350628','title'=>'平和县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'117.32255159131','lat'=>'24.368365040126','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350629','title'=>'华安县','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.54058560971','lat'=>'25.010067731399','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350681','title'=>'龙海市','pid'=>'350600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.82445086941','lat'=>'24.452939738547','level'=>'3','tree'=>'tr_0 tr_350000 tr_350600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350702','title'=>'延平区','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.18845055007','lat'=>'26.643807791057','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350703','title'=>'建阳区','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.12752522464','lat'=>'27.337502466188','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350721','title'=>'顺昌县','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.81651928091','lat'=>'26.799104367214','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350722','title'=>'浦城县','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'118.54743912328','lat'=>'27.923390046145','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350723','title'=>'光泽县','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.34048158963','lat'=>'27.547272859205','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350724','title'=>'松溪县','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.79145438278','lat'=>'27.532554907167','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350725','title'=>'政和县','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'118.86358723724','lat'=>'27.371749198234','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350781','title'=>'邵武市','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.4994195021','lat'=>'27.346469966261','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350782','title'=>'武夷山市','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'118.04157715009','lat'=>'27.762553910259','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350783','title'=>'建瓯市','pid'=>'350700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.31146073369','lat'=>'27.028955089429','level'=>'3','tree'=>'tr_0 tr_350000 tr_350700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350802','title'=>'新罗区','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.04354293052','lat'=>'25.104077629635','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350803','title'=>'永定区','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.89244722515','lat'=>'24.869137411287','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350821','title'=>'长汀县','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'116.36356796988','lat'=>'25.83918461828','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350823','title'=>'上杭县','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.42644288776','lat'=>'25.055570401525','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350824','title'=>'武平县','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.10758916743','lat'=>'25.100855173343','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350825','title'=>'连城县','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.76044617118','lat'=>'25.716337381852','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350881','title'=>'漳平市','pid'=>'350800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.42655632526','lat'=>'25.295743499252','level'=>'3','tree'=>'tr_0 tr_350000 tr_350800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341502','title'=>'金安区','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.54543837997','lat'=>'31.756287719901','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341503','title'=>'裕安区','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.48654978261','lat'=>'31.74362587083','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341504','title'=>'叶集区','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.94747592742','lat'=>'31.83526314225','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341522','title'=>'霍邱县','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.28439133776','lat'=>'32.359343590922','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341523','title'=>'舒城县','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.95560171142','lat'=>'31.467692010556','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341524','title'=>'金寨县','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.94044120714','lat'=>'31.733461734381','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341525','title'=>'霍山县','pid'=>'341500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.33957586218','lat'=>'31.398570812489','level'=>'3','tree'=>'tr_0 tr_340000 tr_341500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350902','title'=>'蕉城区','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'119.53344242699','lat'=>'26.666738555955','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350921','title'=>'霞浦县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'120.01142710564','lat'=>'26.891348873767','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350922','title'=>'古田县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.75257823557','lat'=>'26.583261752073','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350923','title'=>'屏南县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'118.99259621521','lat'=>'26.914264918059','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350924','title'=>'寿宁县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.51142504878','lat'=>'27.466649659969','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350925','title'=>'周宁县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.34556712964','lat'=>'27.110239280448','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350926','title'=>'柘荣县','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.90745668696','lat'=>'27.239961876352','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350981','title'=>'福安市','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.65440636048','lat'=>'27.09432350806','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'350982','title'=>'福鼎市','pid'=>'350900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'120.22345190932','lat'=>'27.330524972528','level'=>'3','tree'=>'tr_0 tr_350000 tr_350900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360102','title'=>'东湖区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.90546602606','lat'=>'28.691259179775','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360103','title'=>'西湖区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.88353569365','lat'=>'28.661976709901','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360104','title'=>'青云谱区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.93141618579','lat'=>'28.627235736484','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360105','title'=>'湾里区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.73759563309','lat'=>'28.720195384308','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360111','title'=>'青山湖区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.96855240505','lat'=>'28.687596006173','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360112','title'=>'新建区','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.8214509253','lat'=>'28.698748625155','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360121','title'=>'南昌县','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'115.95046017277','lat'=>'28.551604186108','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360123','title'=>'安义县','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'115.55544146387','lat'=>'28.850794273751','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360124','title'=>'进贤县','pid'=>'360100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.24853779343','lat'=>'28.382758944474','level'=>'3','tree'=>'tr_0 tr_360000 tr_360100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360202','title'=>'昌江区','pid'=>'360200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.19057910346','lat'=>'29.27885446447','level'=>'3','tree'=>'tr_0 tr_360000 tr_360200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360203','title'=>'珠山区','pid'=>'360200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.20954826159','lat'=>'29.305778220374','level'=>'3','tree'=>'tr_0 tr_360000 tr_360200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360222','title'=>'浮梁县','pid'=>'360200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'117.22146608079','lat'=>'29.357788237529','level'=>'3','tree'=>'tr_0 tr_360000 tr_360200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360281','title'=>'乐平市','pid'=>'360200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.15851067473','lat'=>'28.984363669039','level'=>'3','tree'=>'tr_0 tr_360000 tr_360200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360302','title'=>'安源区','pid'=>'360300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'113.87743991926','lat'=>'27.621307703862','level'=>'3','tree'=>'tr_0 tr_360000 tr_360300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360313','title'=>'湘东区','pid'=>'360300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.74049971211','lat'=>'27.645875074875','level'=>'3','tree'=>'tr_0 tr_360000 tr_360300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360321','title'=>'莲花县','pid'=>'360300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.96854067422','lat'=>'27.133462711028','level'=>'3','tree'=>'tr_0 tr_360000 tr_360300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360322','title'=>'上栗县','pid'=>'360300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.80153822404','lat'=>'27.886415692068','level'=>'3','tree'=>'tr_0 tr_360000 tr_360300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360323','title'=>'芦溪县','pid'=>'360300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.03651940468','lat'=>'27.6366047187','level'=>'3','tree'=>'tr_0 tr_360000 tr_360300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360402','title'=>'濂溪区','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.00753491163','lat'=>'29.711340559079','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360403','title'=>'浔阳区','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.99655806746','lat'=>'29.733093751939','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360404','title'=>'柴桑区','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.91740154188','lat'=>'29.614804909379','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360423','title'=>'武宁县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.10744177399','lat'=>'29.2623521507','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360424','title'=>'修水县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.55356797639','lat'=>'29.031175867959','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360425','title'=>'永修县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.81540658685','lat'=>'29.028005616261','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360426','title'=>'德安县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.76257795847','lat'=>'29.319172496312','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360428','title'=>'都昌县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.21055204665','lat'=>'29.278965044767','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360429','title'=>'湖口县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.25847134559','lat'=>'29.737131514562','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360430','title'=>'彭泽县','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.55550980644','lat'=>'29.902122004906','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360481','title'=>'瑞昌市','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'115.68742967207','lat'=>'29.681951286531','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360482','title'=>'共青城市','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.82142002359','lat'=>'29.248741173716','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360483','title'=>'庐山市','pid'=>'360400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.05142593917','lat'=>'29.454539165717','level'=>'3','tree'=>'tr_0 tr_360000 tr_360400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360502','title'=>'渝水区','pid'=>'360500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.9514238934','lat'=>'27.806839650444','level'=>'3','tree'=>'tr_0 tr_360000 tr_360500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360521','title'=>'分宜县','pid'=>'360500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.69847247036','lat'=>'27.820731344374','level'=>'3','tree'=>'tr_0 tr_360000 tr_360500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360602','title'=>'月湖区','pid'=>'360600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.04354760171','lat'=>'28.245078331555','level'=>'3','tree'=>'tr_0 tr_360000 tr_360600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360603','title'=>'余江区','pid'=>'360600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.82459362864','lat'=>'28.215353761359','level'=>'3','tree'=>'tr_0 tr_360000 tr_360600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360681','title'=>'贵溪市','pid'=>'360600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.25139869833','lat'=>'28.298735072105','level'=>'3','tree'=>'tr_0 tr_360000 tr_360600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360702','title'=>'章贡区','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.9275508855','lat'=>'25.823747013882','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360703','title'=>'南康区','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.77153821509','lat'=>'25.66705293056','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360704','title'=>'赣县区','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.01857016415','lat'=>'25.866384616621','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360722','title'=>'信丰县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.92952113897','lat'=>'25.391975120014','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360723','title'=>'大余县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.36840663965','lat'=>'25.407637298367','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360724','title'=>'上犹县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.55854863129','lat'=>'25.790518799476','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360725','title'=>'崇义县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.31457244808','lat'=>'25.687687192664','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360726','title'=>'安远县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'115.40055913129','lat'=>'25.142743431732','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360727','title'=>'龙南县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.79655413709','lat'=>'24.916599461157','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360728','title'=>'定南县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.0345637751','lat'=>'24.789783831846','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360729','title'=>'全南县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.53658236666','lat'=>'24.748206354967','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360730','title'=>'宁都县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.01549443743','lat'=>'26.47597950334','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360731','title'=>'于都县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.42149926153','lat'=>'25.957893942751','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360732','title'=>'兴国县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.36955169119','lat'=>'26.343882588243','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360733','title'=>'会昌县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.79245964209','lat'=>'25.606661833811','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360734','title'=>'寻乌县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.65351531535','lat'=>'24.96944654678','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360735','title'=>'石城县','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'116.35259426977','lat'=>'26.318972346784','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360781','title'=>'瑞金市','pid'=>'360700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'116.03342066286','lat'=>'25.891666273953','level'=>'3','tree'=>'tr_0 tr_360000 tr_360700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360802','title'=>'吉州区','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.00153936965','lat'=>'27.149314993877','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360803','title'=>'青原区','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.02156071302','lat'=>'27.087662535191','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360821','title'=>'吉安县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.9145913014','lat'=>'27.044989078994','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360822','title'=>'吉水县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.14256983128','lat'=>'27.235259745039','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360823','title'=>'峡江县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.32240322821','lat'=>'27.588234617615','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360824','title'=>'新干县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.39359474833','lat'=>'27.746080951713','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360825','title'=>'永丰县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.44740243989','lat'=>'27.324342103714','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360826','title'=>'泰和县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.91559111544','lat'=>'26.795697341165','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360827','title'=>'遂川县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.52756212171','lat'=>'26.319517284146','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360828','title'=>'万安县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.79257715894','lat'=>'26.464072836341','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360829','title'=>'安福县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.62647813461','lat'=>'27.399076477105','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360830','title'=>'永新县','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.2494149359','lat'=>'26.951537256563','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360881','title'=>'井冈山市','pid'=>'360800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.29555585942','lat'=>'26.753709741566','level'=>'3','tree'=>'tr_0 tr_360000 tr_360800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360902','title'=>'袁州区','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.43456118111','lat'=>'27.802582705304','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360921','title'=>'奉新县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.40655109853','lat'=>'28.694028951458','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360922','title'=>'万载县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.45253654385','lat'=>'28.112133306116','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360923','title'=>'上高县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.93154115857','lat'=>'28.238815490252','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360924','title'=>'宜丰县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.80951713475','lat'=>'28.400373307265','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360925','title'=>'靖安县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.36955312848','lat'=>'28.867081916186','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360926','title'=>'铜鼓县','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.37741107441','lat'=>'28.52708345654','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360981','title'=>'丰城市','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.77747842145','lat'=>'28.166614024369','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360982','title'=>'樟树市','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.55241893533','lat'=>'28.062153117648','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'360983','title'=>'高安市','pid'=>'360900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.38256535328','lat'=>'28.422857002119','level'=>'3','tree'=>'tr_0 tr_360000 tr_360900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361002','title'=>'临川区','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.31848983161','lat'=>'27.940458992864','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361003','title'=>'东乡区','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.60954171505','lat'=>'28.253977397999','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361021','title'=>'南城县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.64339884971','lat'=>'27.57624096656','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361022','title'=>'黎川县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.91450700338','lat'=>'27.288340234831','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361023','title'=>'南丰县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.53140350859','lat'=>'27.224733524876','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361024','title'=>'崇仁县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.08354898488','lat'=>'27.759079756014','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361025','title'=>'乐安县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.83749627865','lat'=>'27.434079864498','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361026','title'=>'宜黄县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.24254169398','lat'=>'27.5605634607','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361027','title'=>'金溪县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.76040404065','lat'=>'27.925329188976','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361028','title'=>'资溪县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.06657027361','lat'=>'27.711845785732','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361030','title'=>'广昌县','pid'=>'361000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'116.34256064638','lat'=>'26.848454446681','level'=>'3','tree'=>'tr_0 tr_360000 tr_361000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361102','title'=>'信州区','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.97341184157','lat'=>'28.437628311','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361103','title'=>'广丰区','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.19742022042','lat'=>'28.442615061205','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361121','title'=>'上饶县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.91558441252','lat'=>'28.45418687477','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361123','title'=>'玉山县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.2515628901','lat'=>'28.687749687317','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361124','title'=>'铅山县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'117.71642163695','lat'=>'28.321504694791','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361125','title'=>'横峰县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.60239738302','lat'=>'28.413440462384','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361126','title'=>'弋阳县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.45550637624','lat'=>'28.384082001231','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361127','title'=>'余干县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.70160096199','lat'=>'28.707866244419','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361128','title'=>'鄱阳县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.7105661408','lat'=>'29.011452830922','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361129','title'=>'万年县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.06459894217','lat'=>'28.700054054129','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361130','title'=>'婺源县','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.86844502243','lat'=>'29.254039048097','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'361181','title'=>'德兴市','pid'=>'361100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.58547968518','lat'=>'28.952564863028','level'=>'3','tree'=>'tr_0 tr_360000 tr_361100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341602','title'=>'谯城区','pid'=>'341600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.78547191853','lat'=>'33.882663087443','level'=>'3','tree'=>'tr_0 tr_340000 tr_341600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341621','title'=>'涡阳县','pid'=>'341600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.22160903516','lat'=>'33.498566835004','level'=>'3','tree'=>'tr_0 tr_340000 tr_341600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341622','title'=>'蒙城县','pid'=>'341600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.57158940083','lat'=>'33.271658239674','level'=>'3','tree'=>'tr_0 tr_340000 tr_341600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'341623','title'=>'利辛县','pid'=>'341600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.1914935226','lat'=>'33.155595841529','level'=>'3','tree'=>'tr_0 tr_340000 tr_341600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370102','title'=>'历下区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.0825673139','lat'=>'36.672162950043','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370103','title'=>'市中区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.00439910401','lat'=>'36.657551673642','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370104','title'=>'槐荫区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.90745837507','lat'=>'36.657561734426','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370105','title'=>'天桥区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'116.99339917338','lat'=>'36.684067874353','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370112','title'=>'历城区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.07158975107','lat'=>'36.685655534711','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370113','title'=>'长清区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'116.75838709095','lat'=>'36.56021587991','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370114','title'=>'章丘区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.53256537437','lat'=>'36.68553275142','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370115','title'=>'济阳区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.18062113319','lat'=>'36.983970518315','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370124','title'=>'平阴县','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.46261667806','lat'=>'36.294861321066','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370126','title'=>'商河县','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.1635297929','lat'=>'37.314970715556','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370171','title'=>'济南高新技术产业开发区','pid'=>'370100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'117.12639941261','lat'=>'36.656554201787','level'=>'3','tree'=>'tr_0 tr_370000 tr_370100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370202','title'=>'市南区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.41858472358','lat'=>'36.081465640234','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370203','title'=>'市北区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'120.38140448734','lat'=>'36.09344959486','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370211','title'=>'黄岛区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'120.20454654768','lat'=>'35.966382870945','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370212','title'=>'崂山区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.47539724708','lat'=>'36.113499423971','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370213','title'=>'李沧区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.43960282675','lat'=>'36.151024667784','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370214','title'=>'城阳区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'120.40252679394','lat'=>'36.31288619735','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370215','title'=>'即墨区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.45353617402','lat'=>'36.394749170322','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370271','title'=>'青岛高新技术产业开发区','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'120.44085344768','lat'=>'36.124685571214','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370281','title'=>'胶州市','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'120.03953537127','lat'=>'36.270349088049','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370283','title'=>'平度市','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'119.99441429398','lat'=>'36.782692254089','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370285','title'=>'莱西市','pid'=>'370200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.52455620764','lat'=>'36.893956298026','level'=>'3','tree'=>'tr_0 tr_370000 tr_370200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370302','title'=>'淄川区','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.97341185763','lat'=>'36.649834806022','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370303','title'=>'张店区','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'118.02459110728','lat'=>'36.811941952144','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370304','title'=>'博山区','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'117.86846875372','lat'=>'36.500847855131','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370305','title'=>'临淄区','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.31539460935','lat'=>'36.832293635152','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370306','title'=>'周村区','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.87648217785','lat'=>'36.808994352212','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370321','title'=>'桓台县','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.10443420779','lat'=>'36.965607980118','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370322','title'=>'高青县','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.83339432525','lat'=>'37.177268654333','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370323','title'=>'沂源县','pid'=>'370300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.17748944237','lat'=>'36.190916985848','level'=>'3','tree'=>'tr_0 tr_370000 tr_370300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370402','title'=>'市中区','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.56256581399','lat'=>'34.86996272507','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370403','title'=>'薛城区','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.26945761931','lat'=>'34.801124568639','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370404','title'=>'峄城区','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.59639060967','lat'=>'34.778599873011','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370405','title'=>'台儿庄区','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.74042545412','lat'=>'34.568763215633','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370406','title'=>'山亭区','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.46744316558','lat'=>'35.105691980765','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370481','title'=>'滕州市','pid'=>'370400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.17256521921','lat'=>'35.120034809574','level'=>'3','tree'=>'tr_0 tr_370000 tr_370400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370502','title'=>'东营区','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.58846268607','lat'=>'37.454847320166','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370503','title'=>'河口区','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.53250516975','lat'=>'37.891120201056','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370505','title'=>'垦利区','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.58143173867','lat'=>'37.578555133809','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370522','title'=>'利津县','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.26161799914','lat'=>'37.495860299031','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370523','title'=>'广饶县','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.41349864392','lat'=>'37.059638498906','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370571','title'=>'东营经济技术开发区','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.58846268607','lat'=>'37.454847320166','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370572','title'=>'东营港经济开发区','pid'=>'370500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'118.96520739607','lat'=>'38.098236253355','level'=>'3','tree'=>'tr_0 tr_370000 tr_370500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370602','title'=>'芝罘区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'121.40654004549','lat'=>'37.546312866891','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370611','title'=>'福山区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'121.27460474744','lat'=>'37.503668228451','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370612','title'=>'牟平区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'121.60654911474','lat'=>'37.392915451796','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370613','title'=>'莱山区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'121.4513806718','lat'=>'37.517648584109','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370634','title'=>'长岛县','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.74342978244','lat'=>'37.927628387579','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370671','title'=>'烟台高新技术产业开发区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.4544154173','lat'=>'37.470038383731','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370672','title'=>'烟台经济技术开发区','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'121.12513892753','lat'=>'37.636399945094','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370681','title'=>'龙口市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.48536852807','lat'=>'37.652555125496','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370682','title'=>'莱阳市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'120.71841430958','lat'=>'36.984635568304','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370683','title'=>'莱州市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.94859307737','lat'=>'37.182636609074','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370684','title'=>'蓬莱市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'120.76556151495','lat'=>'37.816438725969','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370685','title'=>'招远市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'120.44060165265','lat'=>'37.361137142566','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370686','title'=>'栖霞市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'120.85641658338','lat'=>'37.3414181648','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370687','title'=>'海阳市','pid'=>'370600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'121.18045819779','lat'=>'36.693269738228','level'=>'3','tree'=>'tr_0 tr_370000 tr_370600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370702','title'=>'潍城区','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.03142854152','lat'=>'36.73285441557','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370703','title'=>'寒亭区','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.22661514747','lat'=>'36.780743786201','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370704','title'=>'坊子区','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.17240097265','lat'=>'36.660741599701','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370705','title'=>'奎文区','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'119.13947052995','lat'=>'36.712752014046','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370724','title'=>'临朐县','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.54944999641','lat'=>'36.519129501828','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370725','title'=>'昌乐县','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.83648798144','lat'=>'36.712996190845','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370772','title'=>'潍坊滨海经济技术开发区','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.16837791143','lat'=>'36.712651551268','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370781','title'=>'青州市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.48653672087','lat'=>'36.690416508705','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370782','title'=>'诸城市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'119.41640221867','lat'=>'36.002008858076','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370783','title'=>'寿光市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'118.79741537481','lat'=>'36.861921746471','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370784','title'=>'安丘市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'119.22560751818','lat'=>'36.483842195596','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370785','title'=>'高密市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'119.76241099602','lat'=>'36.388956706465','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370786','title'=>'昌邑市','pid'=>'370700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.40440597739','lat'=>'36.865161072622','level'=>'3','tree'=>'tr_0 tr_370000 tr_370700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370811','title'=>'任城区','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'116.55446985374','lat'=>'35.49373064026','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370812','title'=>'兖州区','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.79011515173','lat'=>'35.557952373283','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370826','title'=>'微山县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.13541381857','lat'=>'34.813315104239','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370827','title'=>'鱼台县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.65739284822','lat'=>'35.017887717823','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370828','title'=>'金乡县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.31852982171','lat'=>'35.072569118665','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370829','title'=>'嘉祥县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.34861308511','lat'=>'35.413255044102','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370830','title'=>'汶上县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.50544105765','lat'=>'35.717055392628','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370831','title'=>'泗水县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.25742858989','lat'=>'35.670600481228','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370832','title'=>'梁山县','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.10262029578','lat'=>'35.808063886611','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370871','title'=>'济宁高新技术产业开发区','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.59361234854','lat'=>'35.42017739453','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370881','title'=>'曲阜市','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'116.99341597169','lat'=>'35.587372286488','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370883','title'=>'邹城市','pid'=>'370800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.01440416129','lat'=>'35.40752093245','level'=>'3','tree'=>'tr_0 tr_370000 tr_370800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370902','title'=>'泰山区','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.14141108582','lat'=>'36.199444601195','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370911','title'=>'岱岳区','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'117.04855647915','lat'=>'36.193291242291','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370921','title'=>'宁阳县','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.81257853863','lat'=>'35.764539097344','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370923','title'=>'东平县','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.47759421565','lat'=>'35.941908015019','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370982','title'=>'新泰市','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.77460624827','lat'=>'35.914619866588','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'370983','title'=>'肥城市','pid'=>'370900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.77540081764','lat'=>'36.188811224315','level'=>'3','tree'=>'tr_0 tr_370000 tr_370900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371002','title'=>'环翠区','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'122.12953818095','lat'=>'37.507968071219','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371003','title'=>'文登区','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.06442836878','lat'=>'37.200113328316','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371071','title'=>'威海火炬高技术产业开发区','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.12754097831','lat'=>'37.516430548015','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371072','title'=>'威海经济技术开发区','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.18792776961','lat'=>'37.412757933019','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371073','title'=>'威海临港经济技术开发区','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'122.12754097831','lat'=>'37.516430548015','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371082','title'=>'荣成市','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'122.49250463074','lat'=>'37.171317939253','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371083','title'=>'乳山市','pid'=>'371000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'121.5464285812','lat'=>'36.925177357878','level'=>'3','tree'=>'tr_0 tr_370000 tr_371000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371102','title'=>'东港区','pid'=>'371100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'119.46862431118','lat'=>'35.431049003942','level'=>'3','tree'=>'tr_0 tr_370000 tr_371100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371103','title'=>'岚山区','pid'=>'371100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.32553044175','lat'=>'35.127432330052','level'=>'3','tree'=>'tr_0 tr_370000 tr_371100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371121','title'=>'五莲县','pid'=>'371100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'119.21558036259','lat'=>'35.755697104104','level'=>'3','tree'=>'tr_0 tr_370000 tr_371100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371122','title'=>'莒县','pid'=>'371100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.8435382424','lat'=>'35.585872122989','level'=>'3','tree'=>'tr_0 tr_370000 tr_371100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371171','title'=>'日照经济技术开发区','pid'=>'371100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'119.53341540457','lat'=>'35.422838998438','level'=>'3','tree'=>'tr_0 tr_370000 tr_371100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371202','title'=>'莱城区','pid'=>'371200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.6459130158','lat'=>'36.313394584932','level'=>'3','tree'=>'tr_0 tr_370000 tr_371200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371203','title'=>'钢城区','pid'=>'371200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'117.8275371813','lat'=>'36.092835887233','level'=>'3','tree'=>'tr_0 tr_370000 tr_371200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371302','title'=>'兰山区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.35449973464','lat'=>'35.057340229806','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371311','title'=>'罗庄区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.29151252855','lat'=>'35.002503733433','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371312','title'=>'河东区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'118.40954744713','lat'=>'35.095675536824','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371321','title'=>'沂南县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.47149154086','lat'=>'35.55609766695','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371322','title'=>'郯城县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'118.37358710977','lat'=>'34.619225932471','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371323','title'=>'沂水县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'118.63461726385','lat'=>'35.796180584718','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371324','title'=>'兰陵县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.07740949499','lat'=>'34.86361638544','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371325','title'=>'费县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'117.98442508318','lat'=>'35.272304128517','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371326','title'=>'平邑县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'117.64654058086','lat'=>'35.51201963664','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371327','title'=>'莒南县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'118.84154077027','lat'=>'35.180811631788','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371328','title'=>'蒙阴县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.95141460145','lat'=>'35.716347166232','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371329','title'=>'临沭县','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.6574945001','lat'=>'34.926018591491','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371371','title'=>'临沂高新技术产业开发区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.27105074598','lat'=>'34.991223857705','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371372','title'=>'临沂经济技术开发区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.41614315832','lat'=>'35.028440855401','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371373','title'=>'临沂临港经济开发区','pid'=>'371300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'119.09098821173','lat'=>'35.192676079483','level'=>'3','tree'=>'tr_0 tr_370000 tr_371300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371402','title'=>'德城区','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.30544896637','lat'=>'37.456993283021','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371403','title'=>'陵城区','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.58940001434','lat'=>'37.347132434581','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371422','title'=>'宁津县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.80653761374','lat'=>'37.658018745855','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371423','title'=>'庆云县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'117.39145244825','lat'=>'37.781585318857','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371424','title'=>'临邑县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.87340370302','lat'=>'37.196169366727','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371425','title'=>'齐河县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'116.76938747073','lat'=>'36.78994480667','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371426','title'=>'平原县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.44050470827','lat'=>'37.171221463312','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371427','title'=>'夏津县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.00853411226','lat'=>'36.954154863323','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371428','title'=>'武城县','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.07550629142','lat'=>'37.219222080288','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371471','title'=>'德州经济技术开发区','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.36555674397','lat'=>'37.441308454576','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371472','title'=>'德州运河经济开发区','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.36555674397','lat'=>'37.441308454576','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371481','title'=>'乐陵市','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.23840643173','lat'=>'37.73592450081','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371482','title'=>'禹城市','pid'=>'371400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.64437110138','lat'=>'36.940242008766','level'=>'3','tree'=>'tr_0 tr_370000 tr_371400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371502','title'=>'东昌府区','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.99458657176','lat'=>'36.440377840732','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371521','title'=>'阳谷县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.79839557041','lat'=>'36.120815514687','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371522','title'=>'莘县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.67739687246','lat'=>'36.239907120546','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371523','title'=>'茌平县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.26145544215','lat'=>'36.586785068842','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371524','title'=>'东阿县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.25449294564','lat'=>'36.340957707761','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371525','title'=>'冠县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.44939579504','lat'=>'36.490243225394','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371526','title'=>'高唐县','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'116.23560427568','lat'=>'36.851591084095','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371581','title'=>'临清市','pid'=>'371500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.71146960045','lat'=>'36.844289186694','level'=>'3','tree'=>'tr_0 tr_370000 tr_371500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371702','title'=>'牡丹区','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'115.42344303021','lat'=>'35.257018176069','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371703','title'=>'定陶区','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.57943737524','lat'=>'35.077275179757','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371721','title'=>'曹县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.54845724362','lat'=>'34.831809348415','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371722','title'=>'单县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.11158367799','lat'=>'34.784658433692','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371723','title'=>'成武县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.89651900839','lat'=>'34.95860565496','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371724','title'=>'巨野县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.10159901224','lat'=>'35.402062380609','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371725','title'=>'郓城县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.95045057629','lat'=>'35.605902319687','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371726','title'=>'鄄城县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.51660692346','lat'=>'35.569204259881','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371728','title'=>'东明县','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.09641733473','lat'=>'35.295701692411','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371771','title'=>'菏泽经济技术开发区','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.48754503343','lat'=>'35.239407424766','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371772','title'=>'菏泽高新技术开发区','pid'=>'371700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.48754503343','lat'=>'35.239407424766','level'=>'3','tree'=>'tr_0 tr_370000 tr_371700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410102','title'=>'中原区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.61947551694','lat'=>'34.754450781329','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410103','title'=>'二七区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'113.63141920734','lat'=>'34.753438850454','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410104','title'=>'管城回族区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.6835246998','lat'=>'34.759673874699','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410105','title'=>'金水区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.6664477324','lat'=>'34.806070445662','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410106','title'=>'上街区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.29818225705','lat'=>'34.822088918243','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410108','title'=>'惠济区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.62345527984','lat'=>'34.873519885776','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410122','title'=>'中牟县','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.98248490573','lat'=>'34.725010848924','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410171','title'=>'郑州经济技术开发区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.77162403642','lat'=>'34.724610916832','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410172','title'=>'郑州高新技术产业开发区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.63793722229','lat'=>'34.742959870174','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410173','title'=>'郑州航空港经济综合实验区','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.97018898974','lat'=>'34.719717969385','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410181','title'=>'巩义市','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.02843100495','lat'=>'34.754096888697','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410182','title'=>'荥阳市','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.38942279956','lat'=>'34.793810500346','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410183','title'=>'新密市','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.3973909491','lat'=>'34.545897983445','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410184','title'=>'新郑市','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.74643447195','lat'=>'34.401766379106','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410185','title'=>'登封市','pid'=>'410100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.05642283346','lat'=>'34.45969746172','level'=>'3','tree'=>'tr_0 tr_410000 tr_410100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410202','title'=>'龙亭区','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.36141316646','lat'=>'34.822035612506','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410203','title'=>'顺河回族区','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.36739165912','lat'=>'34.802241355559','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410204','title'=>'鼓楼区','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.35440485636','lat'=>'34.794874251914','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410205','title'=>'禹王台区','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.35439775975','lat'=>'34.783472105917','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410212','title'=>'祥符区','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.4475325479','lat'=>'34.762739572224','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410221','title'=>'杞县','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.78959210474','lat'=>'34.554856780687','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410222','title'=>'通许县','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.47343590593','lat'=>'34.486771802655','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410223','title'=>'尉氏县','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.19956115086','lat'=>'34.417228010354','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410225','title'=>'兰考县','pid'=>'410200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.82746071249','lat'=>'34.828492897238','level'=>'3','tree'=>'tr_0 tr_410000 tr_410200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410302','title'=>'老城区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.47650356572','lat'=>'34.689601063497','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410303','title'=>'西工区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.43439953731','lat'=>'34.666767847513','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410304','title'=>'瀍河回族区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.50660380709','lat'=>'34.685462421335','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410305','title'=>'涧西区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.4025520019','lat'=>'34.663468974309','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410306','title'=>'吉利区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.59547847119','lat'=>'34.907012657115','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410311','title'=>'洛龙区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.47046928829','lat'=>'34.624704713024','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410322','title'=>'孟津县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'112.45141766571','lat'=>'34.831731570285','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410323','title'=>'新安县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.14060970841','lat'=>'34.734383327344','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410324','title'=>'栾川县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.62242666651','lat'=>'33.791822464323','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410325','title'=>'嵩县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.09240816187','lat'=>'34.140721556406','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410326','title'=>'汝阳县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'112.47950327731','lat'=>'34.159843364893','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410327','title'=>'宜阳县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.17946537426','lat'=>'34.541046942554','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410328','title'=>'洛宁县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.65958740952','lat'=>'34.394984560215','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410329','title'=>'伊川县','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.43240745502','lat'=>'34.427645796427','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410371','title'=>'洛阳高新技术产业开发区','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.45942129831','lat'=>'34.624262779219','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410381','title'=>'偃师市','pid'=>'410300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.79642141885','lat'=>'34.733796624013','level'=>'3','tree'=>'tr_0 tr_410000 tr_410300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410402','title'=>'新华区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.30043988965','lat'=>'33.743657151646','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410403','title'=>'卫东区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.34161111761','lat'=>'33.7403756514','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410404','title'=>'石龙区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.9054552264','lat'=>'33.904754268397','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410411','title'=>'湛河区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.25051467449','lat'=>'33.685790171047','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410421','title'=>'宝丰县','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.06144723584','lat'=>'33.874745598631','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410422','title'=>'叶县','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.36358241276','lat'=>'33.632491674058','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410423','title'=>'鲁山县','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.91443396963','lat'=>'33.744878863452','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410425','title'=>'郏县','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.21960622765','lat'=>'33.977486289177','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410471','title'=>'平顶山高新技术产业开发区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.40808986384','lat'=>'33.737612151054','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410472','title'=>'平顶山市新城区','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.19952856052','lat'=>'33.772050748691','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410481','title'=>'舞钢市','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.53141031593','lat'=>'33.299431105301','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410482','title'=>'汝州市','pid'=>'410400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'112.85054971566','lat'=>'34.172767788551','level'=>'3','tree'=>'tr_0 tr_410000 tr_410400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410502','title'=>'文峰区','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.36337398772','lat'=>'36.096832748136','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410503','title'=>'北关区','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'114.36238189912','lat'=>'36.113131607765','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410505','title'=>'殷都区','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.29712997501','lat'=>'36.135573231517','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410506','title'=>'龙安区','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.3075931681','lat'=>'36.08275278362','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410522','title'=>'安阳县','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.23838187262','lat'=>'36.218906964196','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410523','title'=>'汤阴县','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.36340938096','lat'=>'35.927643740225','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410526','title'=>'滑县','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.52555316619','lat'=>'35.581045400558','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410527','title'=>'内黄县','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.90758875551','lat'=>'35.976949668061','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410571','title'=>'安阳高新技术产业开发区','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'114.39950042177','lat'=>'36.105940984015','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410581','title'=>'林州市','pid'=>'410500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.82559018908','lat'=>'36.088853208448','level'=>'3','tree'=>'tr_0 tr_410000 tr_410500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410602','title'=>'鹤山区','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.16955478242','lat'=>'35.960280248227','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410603','title'=>'山城区','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.19062058561','lat'=>'35.903369613292','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410611','title'=>'淇滨区','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.30559120444','lat'=>'35.746952546289','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410621','title'=>'浚县','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.55760785086','lat'=>'35.681917305913','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410622','title'=>'淇县','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.2154897245','lat'=>'35.627277020336','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410671','title'=>'鹤壁经济技术开发区','pid'=>'410600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.30359364248','lat'=>'35.7523574114','level'=>'3','tree'=>'tr_0 tr_410000 tr_410600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410702','title'=>'红旗区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.88141583415','lat'=>'35.310135512691','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410703','title'=>'卫滨区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.8724387977','lat'=>'35.308459209602','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410704','title'=>'凤泉区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.91245884715','lat'=>'35.375665060578','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410711','title'=>'牧野区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.91551290623','lat'=>'35.321023486499','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410721','title'=>'新乡县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.81159378076','lat'=>'35.196564408993','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410724','title'=>'获嘉县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.66341666994','lat'=>'35.265809284161','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410725','title'=>'原阳县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.94662374129','lat'=>'35.071163864469','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410726','title'=>'延津县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.21151175821','lat'=>'35.147806510509','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410727','title'=>'封丘县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.42560616803','lat'=>'35.046857531651','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410728','title'=>'长垣县','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.67560989146','lat'=>'35.207198224565','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410771','title'=>'新乡高新技术产业开发区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.89511589149','lat'=>'35.288196248852','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410772','title'=>'新乡经济技术开发区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.93360046733','lat'=>'35.309639930337','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410773','title'=>'新乡市平原城乡一体化示范区','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.93360046733','lat'=>'35.309639930337','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410781','title'=>'卫辉市','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.07160094452','lat'=>'35.404068882145','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410782','title'=>'辉县市','pid'=>'410700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.81157302991','lat'=>'35.467957818376','level'=>'3','tree'=>'tr_0 tr_410000 tr_410700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410802','title'=>'解放区','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.23757179887','lat'=>'35.246309807633','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410803','title'=>'中站区','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.18944759643','lat'=>'35.242617103591','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410804','title'=>'马村区','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.32854400634','lat'=>'35.261894441723','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410811','title'=>'山阳区','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.26048370971','lat'=>'35.220272352977','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410821','title'=>'修武县','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.45458192871','lat'=>'35.229323482594','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410822','title'=>'博爱县','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.07047799096','lat'=>'35.177308063756','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410823','title'=>'武陟县','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.40839582041','lat'=>'35.105838449217','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410825','title'=>'温县','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.08656906807','lat'=>'34.946135492247','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410871','title'=>'焦作城乡一体化示范区','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.24854783457','lat'=>'35.220963254039','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410882','title'=>'沁阳市','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.95751688155','lat'=>'35.093785732346','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410883','title'=>'孟州市','pid'=>'410800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'112.79739491254','lat'=>'34.913597817886','level'=>'3','tree'=>'tr_0 tr_410000 tr_410800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410902','title'=>'华龙区','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.0804129441','lat'=>'35.783632884536','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410922','title'=>'清丰县','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.11047186341','lat'=>'35.891308168277','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410923','title'=>'南乐县','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'115.21138615695','lat'=>'36.076030832875','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410926','title'=>'范县','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'115.51058621044','lat'=>'35.857655087719','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410927','title'=>'台前县','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'115.87856816938','lat'=>'35.975012712521','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410928','title'=>'濮阳县','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.03558408559','lat'=>'35.717888889375','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410971','title'=>'河南濮阳工业园区','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.03559747034','lat'=>'35.767593028906','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'410972','title'=>'濮阳经济技术开发区','pid'=>'410900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.03559747034','lat'=>'35.767593028906','level'=>'3','tree'=>'tr_0 tr_410000 tr_410900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411002','title'=>'魏都区','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.82959564352','lat'=>'34.030861228003','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411003','title'=>'建安区','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.82961513675','lat'=>'34.129966976383','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411024','title'=>'鄢陵县','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.18561980866','lat'=>'34.107963250311','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411025','title'=>'襄城县','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.51343127013','lat'=>'33.856967773678','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411071','title'=>'许昌经济技术开发区','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.81237629469','lat'=>'34.009184251036','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411081','title'=>'禹州市','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.49550522436','lat'=>'34.146082195029','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411082','title'=>'长葛市','pid'=>'411000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.77442091063','lat'=>'34.223016266284','level'=>'3','tree'=>'tr_0 tr_410000 tr_411000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411102','title'=>'源汇区','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.99041352982','lat'=>'33.578423262447','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411103','title'=>'郾城区','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.01339389154','lat'=>'33.593415880865','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411104','title'=>'召陵区','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.1004665548','lat'=>'33.592467538561','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411121','title'=>'舞阳县','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.61549000488','lat'=>'33.443577799934','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411122','title'=>'临颍县','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.93757834379','lat'=>'33.83269194793','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411171','title'=>'漯河经济技术开发区','pid'=>'411100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.02342077765','lat'=>'33.587710707102','level'=>'3','tree'=>'tr_0 tr_410000 tr_411100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411202','title'=>'湖滨区','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.19557389665','lat'=>'34.775996792444','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411203','title'=>'陕州区','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.10945065249','lat'=>'34.726914801527','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411221','title'=>'渑池县','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'111.76854234585','lat'=>'34.773197042986','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411224','title'=>'卢氏县','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.05456400617','lat'=>'34.059924845299','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411271','title'=>'河南三门峡经济开发区','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.16756986287','lat'=>'34.791595599754','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411281','title'=>'义马市','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.88051478021','lat'=>'34.753028009473','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411282','title'=>'灵宝市','pid'=>'411200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.90040831286','lat'=>'34.523142624164','level'=>'3','tree'=>'tr_0 tr_410000 tr_411200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411302','title'=>'宛城区','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.54645416663','lat'=>'33.009870040626','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411303','title'=>'卧龙区','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.54146183376','lat'=>'32.992483797527','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411321','title'=>'南召县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.43542522255','lat'=>'33.496185804625','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411322','title'=>'方城县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.0185027528','lat'=>'33.260539455832','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411323','title'=>'西峡县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.48039809758','lat'=>'33.313316115292','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411324','title'=>'镇平县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.24154448331','lat'=>'33.039718529225','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411325','title'=>'内乡县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'111.85542528697','lat'=>'33.051203105476','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411326','title'=>'淅川县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.49743203615','lat'=>'33.144185260027','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411327','title'=>'社旗县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.9544934547','lat'=>'33.062236685935','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411328','title'=>'唐河县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.81342436589','lat'=>'32.687720660005','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411329','title'=>'新野县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.36654962384','lat'=>'32.526631778818','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411330','title'=>'桐柏县','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.43447273106','lat'=>'32.385130754956','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411371','title'=>'南阳高新技术产业开发区','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.53450131351','lat'=>'32.996562204651','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411372','title'=>'南阳市城乡一体化示范区','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.53450131351','lat'=>'32.996562204651','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411381','title'=>'邓州市','pid'=>'411300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.09342010302','lat'=>'32.69391743997','level'=>'3','tree'=>'tr_0 tr_410000 tr_411300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411402','title'=>'梁园区','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.62060204557','lat'=>'34.449471246294','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411403','title'=>'睢阳区','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.65947594702','lat'=>'34.394151920479','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411421','title'=>'民权县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'115.15457605887','lat'=>'34.652478726537','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411422','title'=>'睢县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.07841089061','lat'=>'34.451616965409','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411423','title'=>'宁陵县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'115.32041843737','lat'=>'34.46663402766','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411424','title'=>'柘城县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.31243456749','lat'=>'34.097360212415','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411425','title'=>'虞城县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.83447295698','lat'=>'34.405331502097','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411426','title'=>'夏邑县','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.13751236823','lat'=>'34.243523472378','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411471','title'=>'豫东综合物流产业聚集区','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.66244933826','lat'=>'34.420201665859','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411472','title'=>'河南商丘经济开发区','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.69827951116','lat'=>'34.407726159442','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411481','title'=>'永城市','pid'=>'411400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.4555661476','lat'=>'33.934801475851','level'=>'3','tree'=>'tr_0 tr_410000 tr_411400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411502','title'=>'浉河区','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.06558130947','lat'=>'32.122554156884','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411503','title'=>'平桥区','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'114.13240742415','lat'=>'32.10732538611','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411521','title'=>'罗山县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.51952993791','lat'=>'32.209150451838','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411522','title'=>'光山县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.92553303688','lat'=>'32.015906879568','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411523','title'=>'新县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.88552475523','lat'=>'31.649738468475','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411524','title'=>'商城县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.41351334076','lat'=>'31.804345366903','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411525','title'=>'固始县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.66048788818','lat'=>'32.174174379622','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411526','title'=>'潢川县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.05847075405','lat'=>'32.137530716414','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411527','title'=>'淮滨县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.42643896891','lat'=>'32.479469756663','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411528','title'=>'息县','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.74745313225','lat'=>'32.348955511715','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411571','title'=>'信阳高新技术产业开发区','pid'=>'411500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.09748283305','lat'=>'32.153014547531','level'=>'3','tree'=>'tr_0 tr_410000 tr_411500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411602','title'=>'川汇区','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.65760174056','lat'=>'33.652997102814','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411621','title'=>'扶沟县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.40150984137','lat'=>'34.065906253969','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411622','title'=>'西华县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.53559667094','lat'=>'33.773215334922','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411623','title'=>'商水县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.61841594744','lat'=>'33.548877475353','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411624','title'=>'沈丘县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.10545545595','lat'=>'33.415691094059','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411625','title'=>'郸城县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.18347760136','lat'=>'33.650827955049','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411626','title'=>'淮阳县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.89258615519','lat'=>'33.737347183458','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411627','title'=>'太康县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.84438389','lat'=>'34.070038382248','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411628','title'=>'鹿邑县','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.4905852586','lat'=>'33.867173290317','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411671','title'=>'河南周口经济开发区','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.70348251482','lat'=>'33.631828875702','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411681','title'=>'项城市','pid'=>'411600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.88151400079','lat'=>'33.47300744143','level'=>'3','tree'=>'tr_0 tr_410000 tr_411600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411702','title'=>'驿城区','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.00038696674','lat'=>'32.979519871982','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411721','title'=>'西平县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.02747357279','lat'=>'33.393860997525','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411722','title'=>'上蔡县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.2704868624','lat'=>'33.268511215884','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411723','title'=>'平舆县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'114.62542865923','lat'=>'32.967982400438','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411724','title'=>'正阳县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.39949655906','lat'=>'32.611641077273','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411725','title'=>'确山县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.03249501076','lat'=>'32.808175692984','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411726','title'=>'泌阳县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.33355798837','lat'=>'32.729730650435','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411727','title'=>'汝南县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'114.36940889397','lat'=>'33.013140881992','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411728','title'=>'遂平县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.0194414639','lat'=>'33.151971399579','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411729','title'=>'新蔡县','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.99246928382','lat'=>'32.755268867306','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'411771','title'=>'河南驻马店经济开发区','pid'=>'411700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.02847078173','lat'=>'33.017842416744','level'=>'3','tree'=>'tr_0 tr_410000 tr_411700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'419001','title'=>'济源市','pid'=>'419000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.60858070621','lat'=>'35.072907226847','level'=>'3','tree'=>'tr_0 tr_410000 tr_419000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420102','title'=>'江岸区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.31657918761','lat'=>'30.605402797562','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420103','title'=>'江汉区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.27750613182','lat'=>'30.607282276827','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420104','title'=>'硚口区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.22146031207','lat'=>'30.587584340776','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420105','title'=>'汉阳区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.22544555464','lat'=>'30.560052027443','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420106','title'=>'武昌区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.35362228468','lat'=>'30.564860292785','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420107','title'=>'青山区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.39149265697','lat'=>'30.646593075543','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420111','title'=>'洪山区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.35045554602','lat'=>'30.506333956808','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420112','title'=>'东西湖区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.14345873786','lat'=>'30.625919818109','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420113','title'=>'汉南区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.09151485056','lat'=>'30.314809120145','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420114','title'=>'蔡甸区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.03547963081','lat'=>'30.588113621855','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420115','title'=>'江夏区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.32855126446','lat'=>'30.381564218182','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420116','title'=>'黄陂区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.38245399676','lat'=>'30.887533767835','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420117','title'=>'新洲区','pid'=>'420100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.8075433929','lat'=>'30.847243870523','level'=>'3','tree'=>'tr_0 tr_420000 tr_420100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420202','title'=>'黄石港区','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.07241748608','lat'=>'30.229052639992','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420203','title'=>'西塞山区','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.11648143744','lat'=>'30.210695184118','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420204','title'=>'下陆区','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.96741590247','lat'=>'30.180046155273','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420205','title'=>'铁山区','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.90757141821','lat'=>'30.212250832587','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420222','title'=>'阳新县','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.22142677197','lat'=>'29.836541808086','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420281','title'=>'大冶市','pid'=>'420200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.98643626402','lat'=>'30.101667800103','level'=>'3','tree'=>'tr_0 tr_420000 tr_420200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420302','title'=>'茅箭区','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.81958031019','lat'=>'32.597286519104','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420303','title'=>'张湾区','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.77542410285','lat'=>'32.65839954548','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420304','title'=>'郧阳区','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.81857654362','lat'=>'32.840592413038','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420322','title'=>'郧西县','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.43247261847','lat'=>'32.999167007536','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420323','title'=>'竹山县','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.23558156764','lat'=>'32.230304060376','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420324','title'=>'竹溪县','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.72154249889','lat'=>'32.324120048853','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420325','title'=>'房县','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'110.74746155911','lat'=>'32.061684964544','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420381','title'=>'丹江口市','pid'=>'420300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.51953205848','lat'=>'32.546252688501','level'=>'3','tree'=>'tr_0 tr_420000 tr_420300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420502','title'=>'西陵区','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.29255972053','lat'=>'30.716749346598','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420503','title'=>'伍家岗区','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.36742225597','lat'=>'30.65073733526','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420504','title'=>'点军区','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.27447135095','lat'=>'30.69932951388','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420505','title'=>'猇亭区','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.44157378259','lat'=>'30.536465982707','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420506','title'=>'夷陵区','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.33252973436','lat'=>'30.774833327298','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420525','title'=>'远安县','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.64653035927','lat'=>'31.066627841578','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420526','title'=>'兴山县','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.75344607041','lat'=>'31.354463517716','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420527','title'=>'秭归县','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.98444937468','lat'=>'30.831931643216','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420528','title'=>'长阳土家族自治县','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.21350712887','lat'=>'30.478645783056','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420529','title'=>'五峰土家族自治县','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.05258063744','lat'=>'30.171156151026','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420581','title'=>'宜都市','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.45651583712','lat'=>'30.384404274314','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420582','title'=>'当阳市','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.79456850223','lat'=>'30.826989050281','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420583','title'=>'枝江市','pid'=>'420500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.76653975337','lat'=>'30.431730676998','level'=>'3','tree'=>'tr_0 tr_420000 tr_420500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420602','title'=>'襄城区','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.14057206941','lat'=>'32.016174618141','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420606','title'=>'樊城区','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'112.14259891613','lat'=>'32.050572374692','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420607','title'=>'襄州区','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.21843413678','lat'=>'32.093375783399','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420624','title'=>'南漳县','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'111.84538618392','lat'=>'31.781129706779','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420625','title'=>'谷城县','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'111.65957564172','lat'=>'32.268983068947','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420626','title'=>'保康县','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'111.26744121203','lat'=>'31.883847150262','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420682','title'=>'老河口市','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.68155636908','lat'=>'32.392459585271','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420683','title'=>'枣阳市','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.77847075951','lat'=>'32.134729914319','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420684','title'=>'宜城市','pid'=>'420600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.26461144169','lat'=>'31.725469730972','level'=>'3','tree'=>'tr_0 tr_420000 tr_420600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420702','title'=>'梁子湖区','pid'=>'420700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.69150657526','lat'=>'30.105906774051','level'=>'3','tree'=>'tr_0 tr_420000 tr_420700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420703','title'=>'华容区','pid'=>'420700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.73642634228','lat'=>'30.540599527838','level'=>'3','tree'=>'tr_0 tr_420000 tr_420700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420704','title'=>'鄂城区','pid'=>'420700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'114.89859968176','lat'=>'30.406389456292','level'=>'3','tree'=>'tr_0 tr_420000 tr_420700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420802','title'=>'东宝区','pid'=>'420800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.2083882066','lat'=>'31.058429271365','level'=>'3','tree'=>'tr_0 tr_420000 tr_420800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420804','title'=>'掇刀区','pid'=>'420800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.2144276942','lat'=>'30.979910859804','level'=>'3','tree'=>'tr_0 tr_420000 tr_420800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420822','title'=>'沙洋县','pid'=>'420800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.59548493899','lat'=>'30.715314748831','level'=>'3','tree'=>'tr_0 tr_420000 tr_420800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420881','title'=>'钟祥市','pid'=>'420800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.59447102156','lat'=>'31.174029854963','level'=>'3','tree'=>'tr_0 tr_420000 tr_420800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420882','title'=>'京山市','pid'=>'420800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.12654806496','lat'=>'31.024330601193','level'=>'3','tree'=>'tr_0 tr_420000 tr_420800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420902','title'=>'孝南区','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.91748989699','lat'=>'30.922977925049','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420921','title'=>'孝昌县','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.00440859068','lat'=>'31.264540493062','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420922','title'=>'大悟县','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.13341253819','lat'=>'31.567219806641','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420923','title'=>'云梦县','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.75941220183','lat'=>'31.027218220752','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420981','title'=>'应城市','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.57956739635','lat'=>'30.933976509913','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420982','title'=>'安陆市','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'113.69558292415','lat'=>'31.261414994286','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'420984','title'=>'汉川市','pid'=>'420900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.8455490104','lat'=>'30.666913578821','level'=>'3','tree'=>'tr_0 tr_420000 tr_420900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421002','title'=>'沙市区','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.26157741483','lat'=>'30.316571904872','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421003','title'=>'荆州区','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.19641397381','lat'=>'30.358989490775','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421022','title'=>'公安县','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.23650157584','lat'=>'30.064400686806','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421023','title'=>'监利县','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.91142023009','lat'=>'29.845735162836','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421024','title'=>'江陵县','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.43145201728','lat'=>'30.048042984592','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421071','title'=>'荆州经济技术开发区','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.19641397381','lat'=>'30.358989490775','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421081','title'=>'石首市','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.43141984371','lat'=>'29.727033977407','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421083','title'=>'洪湖市','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.48255290196','lat'=>'29.83277032976','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421087','title'=>'松滋市','pid'=>'421000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.77358031264','lat'=>'30.175342235143','level'=>'3','tree'=>'tr_0 tr_420000 tr_421000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421102','title'=>'黄州区','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.88653238452','lat'=>'30.440224145146','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421121','title'=>'团风县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.87852435023','lat'=>'30.649367767215','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421122','title'=>'红安县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.6244256113','lat'=>'31.294296714037','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421123','title'=>'罗田县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.4055471675','lat'=>'30.788910495685','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421124','title'=>'英山县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.68742160263','lat'=>'30.741350084085','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421125','title'=>'浠水县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.27156903289','lat'=>'30.457460842265','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421126','title'=>'蕲春县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.4423985341','lat'=>'30.232535499734','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421127','title'=>'黄梅县','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.95046198477','lat'=>'30.076605056821','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421171','title'=>'龙感湖管理区','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.01030250647','lat'=>'29.879697031911','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421181','title'=>'麻城市','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'115.01656174777','lat'=>'31.176995837411','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421182','title'=>'武穴市','pid'=>'421100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.56739216105','lat'=>'29.850441430483','level'=>'3','tree'=>'tr_0 tr_420000 tr_421100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421202','title'=>'咸安区','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.30456990606','lat'=>'29.858153915154','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421221','title'=>'嘉鱼县','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.94557046336','lat'=>'29.976353520898','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421222','title'=>'通城县','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.82356790903','lat'=>'29.250857930222','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421223','title'=>'崇阳县','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.04656290943','lat'=>'29.561333782271','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421224','title'=>'通山县','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.48939330027','lat'=>'29.612634338058','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421281','title'=>'赤壁市','pid'=>'421200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.90643686179','lat'=>'29.730665997526','level'=>'3','tree'=>'tr_0 tr_420000 tr_421200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421303','title'=>'曾都区','pid'=>'421300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.3775133346','lat'=>'31.722122861271','level'=>'3','tree'=>'tr_0 tr_420000 tr_421300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421321','title'=>'随县','pid'=>'421300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.3064583569','lat'=>'31.859971678258','level'=>'3','tree'=>'tr_0 tr_420000 tr_421300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'421381','title'=>'广水市','pid'=>'421300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.83259337884','lat'=>'31.622476038007','level'=>'3','tree'=>'tr_0 tr_420000 tr_421300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422801','title'=>'恩施市','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'109.48655026901','lat'=>'30.301037143741','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422802','title'=>'利川市','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.94248057756','lat'=>'30.29720344368','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422822','title'=>'建始县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.72855610899','lat'=>'30.607907026319','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422823','title'=>'巴东县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'110.34757529184','lat'=>'31.04806424896','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422825','title'=>'宣恩县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.49756797283','lat'=>'29.99260392208','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422826','title'=>'咸丰县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.14660773562','lat'=>'29.671077652358','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422827','title'=>'来凤县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.41349484153','lat'=>'29.499443572607','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'422828','title'=>'鹤峰县','pid'=>'422800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.04042423301','lat'=>'29.896116483403','level'=>'3','tree'=>'tr_0 tr_420000 tr_422800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'429004','title'=>'仙桃市','pid'=>'429000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.46159059813','lat'=>'30.368271921725','level'=>'3','tree'=>'tr_0 tr_420000 tr_429000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'429005','title'=>'潜江市','pid'=>'429000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.90547409082','lat'=>'30.408357932419','level'=>'3','tree'=>'tr_0 tr_420000 tr_429000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'429006','title'=>'天门市','pid'=>'429000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.17240916633','lat'=>'30.669621830099','level'=>'3','tree'=>'tr_0 tr_420000 tr_429000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'429021','title'=>'神农架林区','pid'=>'429000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.6825248504','lat'=>'31.750496011246','level'=>'3','tree'=>'tr_0 tr_420000 tr_429000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371602','title'=>'滨城区','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'118.02660385061','lat'=>'37.436843207744','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371603','title'=>'沾化区','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'118.10545441336','lat'=>'37.705298106724','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371621','title'=>'惠民县','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.5165096905','lat'=>'37.49580310894','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371622','title'=>'阳信县','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.58443703791','lat'=>'37.647338034957','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371623','title'=>'无棣县','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.63245748606','lat'=>'37.777567312086','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371625','title'=>'博兴县','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'118.11749269533','lat'=>'37.160477277651','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'371681','title'=>'邹平市','pid'=>'371600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.74947848722','lat'=>'36.870032216697','level'=>'3','tree'=>'tr_0 tr_370000 tr_371600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430202','title'=>'荷塘区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.18045222007','lat'=>'27.862155809141','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430203','title'=>'芦淞区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.15841867236','lat'=>'27.791508825947','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430204','title'=>'石峰区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.12456791567','lat'=>'27.880705165595','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430211','title'=>'天元区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.08954055842','lat'=>'27.833083519485','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430212','title'=>'渌口区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.15042671773','lat'=>'27.704322804857','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430223','title'=>'攸县','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.35157834169','lat'=>'27.005771565213','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430224','title'=>'茶陵县','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.54547165714','lat'=>'26.78358911036','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430225','title'=>'炎陵县','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.77941879832','lat'=>'26.496060691599','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430271','title'=>'云龙示范区','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.17446420357','lat'=>'27.934854931886','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430281','title'=>'醴陵市','pid'=>'430200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.50348315084','lat'=>'27.652325149951','level'=>'3','tree'=>'tr_0 tr_430000 tr_430200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430302','title'=>'雨湖区','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.91344959207','lat'=>'27.862466785111','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430304','title'=>'岳塘区','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.97558942655','lat'=>'27.877720506364','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430321','title'=>'湘潭县','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.95750536884','lat'=>'27.784982534656','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430371','title'=>'湖南湘潭高新技术产业园区','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.95046418076','lat'=>'27.835702227136','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430372','title'=>'湘潭昭山示范区','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.01812844052','lat'=>'27.97161027839','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430373','title'=>'湘潭九华示范区','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.94707945543','lat'=>'27.916546191684','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430381','title'=>'湘乡市','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.54149155341','lat'=>'27.740190553344','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430382','title'=>'韶山市','pid'=>'430300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.53349932929','lat'=>'27.921043749631','level'=>'3','tree'=>'tr_0 tr_430000 tr_430300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430405','title'=>'珠晖区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.62659414282','lat'=>'26.900265361946','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430406','title'=>'雁峰区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.62358823292','lat'=>'26.89436829036','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430407','title'=>'石鼓区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.60452969339','lat'=>'26.948961867165','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430408','title'=>'蒸湘区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.57344401089','lat'=>'26.917719877877','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430412','title'=>'南岳区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.74557434825','lat'=>'27.238360474562','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430421','title'=>'衡阳县','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.37755268433','lat'=>'26.975294950861','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430422','title'=>'衡南县','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.68440252779','lat'=>'26.744531956772','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430423','title'=>'衡山县','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.87556328771','lat'=>'27.235996029656','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430424','title'=>'衡东县','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.95949529521','lat'=>'27.087042820265','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430426','title'=>'祁东县','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.09644737847','lat'=>'26.805995255191','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430471','title'=>'衡阳综合保税区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.57844721326','lat'=>'26.899576139189','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430472','title'=>'湖南衡阳高新技术产业园区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.57844721326','lat'=>'26.899576139189','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430473','title'=>'湖南衡阳松木经济开发区','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.57844721326','lat'=>'26.899576139189','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430481','title'=>'耒阳市','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.86659721058','lat'=>'26.428065593928','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430482','title'=>'常宁市','pid'=>'430400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.40556050266','lat'=>'26.426720432257','level'=>'3','tree'=>'tr_0 tr_430000 tr_430400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430502','title'=>'双清区','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.50344150643','lat'=>'27.239108783297','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430503','title'=>'大祥区','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.44552828921','lat'=>'27.227013968694','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430511','title'=>'北塔区','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'111.45849694619','lat'=>'27.251536276174','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430521','title'=>'邵东县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.75049070296','lat'=>'27.264507471566','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430522','title'=>'新邵县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.46444938799','lat'=>'27.32713173916','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430523','title'=>'邵阳县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.28050768064','lat'=>'26.996528332196','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430524','title'=>'隆回县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.03950668528','lat'=>'27.119946440019','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430525','title'=>'洞口县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.58257909625','lat'=>'27.065975437799','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430527','title'=>'绥宁县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.16241987038','lat'=>'26.588422719333','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430528','title'=>'新宁县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.86349072744','lat'=>'26.439723697954','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430529','title'=>'城步苗族自治县','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'110.32853713032','lat'=>'26.396203220078','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430581','title'=>'武冈市','pid'=>'430500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.63840761588','lat'=>'26.732898572992','level'=>'3','tree'=>'tr_0 tr_430000 tr_430500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430602','title'=>'岳阳楼区','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.13648070435','lat'=>'29.377995036881','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430603','title'=>'云溪区','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.27840659691','lat'=>'29.479907141133','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430611','title'=>'君山区','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.0125171491','lat'=>'29.467129185832','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430621','title'=>'岳阳县','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.1225444825','lat'=>'29.150269316045','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430623','title'=>'华容县','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.54746151216','lat'=>'29.536286434382','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430624','title'=>'湘阴县','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.88952187736','lat'=>'28.676676377581','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430626','title'=>'平江县','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.58760362284','lat'=>'28.707564248115','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430671','title'=>'岳阳市屈原管理区','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.92259003029','lat'=>'28.866288191728','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430681','title'=>'汨罗市','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.07349286947','lat'=>'28.812454694812','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430682','title'=>'临湘市','pid'=>'430600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.45656151','lat'=>'29.482801373395','level'=>'3','tree'=>'tr_0 tr_430000 tr_430600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430702','title'=>'武陵区','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.68954489616','lat'=>'29.060783476578','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430703','title'=>'鼎城区','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.68752209182','lat'=>'29.024443397066','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430721','title'=>'安乡县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'112.1775061558','lat'=>'29.41732043222','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430722','title'=>'汉寿县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'111.97641193356','lat'=>'28.912287603085','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430723','title'=>'澧县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.76553354736','lat'=>'29.638946004609','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430724','title'=>'临澧县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.65358500797','lat'=>'29.446543990119','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430725','title'=>'桃源县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'111.49540733145','lat'=>'28.908694006999','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430726','title'=>'石门县','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.38645140702','lat'=>'29.59036596665','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430771','title'=>'常德市西洞庭管理区','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'112.0093067782','lat'=>'29.197804478833','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430781','title'=>'津市市','pid'=>'430700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.88451734602','lat'=>'29.611258543007','level'=>'3','tree'=>'tr_0 tr_430000 tr_430700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430802','title'=>'永定区','pid'=>'430800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.54443192397','lat'=>'29.126190558381','level'=>'3','tree'=>'tr_0 tr_430000 tr_430800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430811','title'=>'武陵源区','pid'=>'430800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.5574989454','lat'=>'29.351681136671','level'=>'3','tree'=>'tr_0 tr_430000 tr_430800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430821','title'=>'慈利县','pid'=>'430800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'111.14547125235','lat'=>'29.435986725969','level'=>'3','tree'=>'tr_0 tr_430000 tr_430800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430822','title'=>'桑植县','pid'=>'430800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.17041335213','lat'=>'29.405923219415','level'=>'3','tree'=>'tr_0 tr_430000 tr_430800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430902','title'=>'资阳区','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.33043548238','lat'=>'28.597234549737','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430903','title'=>'赫山区','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.38059794001','lat'=>'28.584983567573','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430921','title'=>'南县','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.40254156734','lat'=>'29.367069853363','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430922','title'=>'桃江县','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.16254146398','lat'=>'28.523870869898','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430923','title'=>'安化县','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'111.21949270432','lat'=>'28.380053748765','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430971','title'=>'益阳市大通湖管理区','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.65023278281','lat'=>'29.193681230112','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430972','title'=>'湖南益阳高新技术产业园区','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.3715604476','lat'=>'28.816150235875','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430981','title'=>'沅江市','pid'=>'430900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.36053222035','lat'=>'28.850233588583','level'=>'3','tree'=>'tr_0 tr_430000 tr_430900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431002','title'=>'北湖区','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.01748199382','lat'=>'25.79081459434','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431003','title'=>'苏仙区','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.04842340846','lat'=>'25.806737374104','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431021','title'=>'桂阳县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.74056036622','lat'=>'25.759775327893','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431022','title'=>'宜章县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.95547924076','lat'=>'25.405713969356','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431023','title'=>'永兴县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.12253316386','lat'=>'26.132968478533','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431024','title'=>'嘉禾县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.37558377831','lat'=>'25.593421718268','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431025','title'=>'临武县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.57041115183','lat'=>'25.282527010969','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431026','title'=>'汝城县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'113.69154466692','lat'=>'25.556056733978','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431027','title'=>'桂东县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.9515936018','lat'=>'26.083173927327','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431028','title'=>'安仁县','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'113.27542359381','lat'=>'26.715682788508','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431081','title'=>'资兴市','pid'=>'431000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.24255612233','lat'=>'25.981873602722','level'=>'3','tree'=>'tr_0 tr_430000 tr_431000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431102','title'=>'零陵区','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.63750237493','lat'=>'26.227682089779','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431103','title'=>'冷水滩区','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.59842608526','lat'=>'26.467705510832','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431121','title'=>'祁阳县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'111.84742029288','lat'=>'26.586434994948','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431122','title'=>'东安县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.32354235354','lat'=>'26.398288039365','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431123','title'=>'双牌县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'111.6675938129','lat'=>'25.967169239803','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431124','title'=>'道县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.60740437934','lat'=>'25.53252996283','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431125','title'=>'江永县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.35043663236','lat'=>'25.279720667918','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431126','title'=>'宁远县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'111.95245340697','lat'=>'25.57705193746','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431127','title'=>'蓝山县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.20343493586','lat'=>'25.37593472464','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431128','title'=>'新田县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.21040920018','lat'=>'25.909825802754','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431129','title'=>'江华瑶族自治县','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.58545203845','lat'=>'25.191348924015','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431171','title'=>'永州经济技术开发区','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.61945505792','lat'=>'26.4258641179','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431172','title'=>'永州市金洞管理区','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.09909809837','lat'=>'26.297256941493','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431173','title'=>'永州市回龙圩管理区','pid'=>'431100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.35307783022','lat'=>'25.173038319623','level'=>'3','tree'=>'tr_0 tr_430000 tr_431100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431202','title'=>'鹤城区','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.04639994092','lat'=>'27.585225763164','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431221','title'=>'中方县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.95146189432','lat'=>'27.44608117406','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431222','title'=>'沅陵县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.40043076602','lat'=>'28.459018102626','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431223','title'=>'辰溪县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'110.19048661755','lat'=>'28.012605313813','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431224','title'=>'溆浦县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.60155112895','lat'=>'27.913963373886','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431225','title'=>'会同县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.74158556792','lat'=>'26.893383817274','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431226','title'=>'麻阳苗族自治县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'109.80943628984','lat'=>'27.87193016295','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431227','title'=>'新晃侗族自治县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.18147151144','lat'=>'27.358782968573','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431228','title'=>'芷江侗族自治县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.6914022696','lat'=>'27.449513277765','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431229','title'=>'靖州苗族侗族自治县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.70245160703','lat'=>'26.581321351066','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431230','title'=>'通道侗族自治县','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.79044548256','lat'=>'26.164219864712','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431271','title'=>'怀化市洪江管理区','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.8435098263','lat'=>'27.215077093932','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431281','title'=>'洪江市','pid'=>'431200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.8435098263','lat'=>'27.215077093932','level'=>'3','tree'=>'tr_0 tr_430000 tr_431200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431302','title'=>'娄星区','pid'=>'431300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.00855842504','lat'=>'27.735604842109','level'=>'3','tree'=>'tr_0 tr_430000 tr_431300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431321','title'=>'双峰县','pid'=>'431300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.18146049666','lat'=>'27.462982658573','level'=>'3','tree'=>'tr_0 tr_430000 tr_431300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431322','title'=>'新化县','pid'=>'431300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.334515335','lat'=>'27.732666751066','level'=>'3','tree'=>'tr_0 tr_430000 tr_431300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431381','title'=>'冷水江市','pid'=>'431300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.44153972291','lat'=>'27.692058848958','level'=>'3','tree'=>'tr_0 tr_430000 tr_431300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'431382','title'=>'涟源市','pid'=>'431300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.67056199396','lat'=>'27.698167532255','level'=>'3','tree'=>'tr_0 tr_430000 tr_431300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433101','title'=>'吉首市','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.70444880967','lat'=>'28.267493127593','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433122','title'=>'泸溪县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.22659921769','lat'=>'28.221873097569','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433123','title'=>'凤凰县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'109.6055266883','lat'=>'27.953847809726','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433124','title'=>'花垣县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.48856183128','lat'=>'28.577909934397','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433125','title'=>'保靖县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.66647357306','lat'=>'28.705968872486','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433126','title'=>'古丈县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.95750740057','lat'=>'28.623083527843','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433127','title'=>'永顺县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.86358578665','lat'=>'28.985774485682','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433130','title'=>'龙山县','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.45041573696','lat'=>'29.464121765857','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433172','title'=>'湖南吉首经济开发区','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.70444880967','lat'=>'28.267493127593','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'433173','title'=>'湖南永顺经济开发区','pid'=>'433100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.86358578665','lat'=>'28.985774485682','level'=>'3','tree'=>'tr_0 tr_430000 tr_433100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440103','title'=>'荔湾区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.25050226337','lat'=>'23.131791134975','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440104','title'=>'越秀区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.273426481','lat'=>'23.135260120148','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440105','title'=>'海珠区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.32353998097','lat'=>'23.088981296648','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440106','title'=>'天河区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.36850942428','lat'=>'23.130357835105','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440111','title'=>'白云区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.27943309062','lat'=>'23.164316834456','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440112','title'=>'黄埔区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.48707083969','lat'=>'23.187491541425','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440113','title'=>'番禺区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.39046958043','lat'=>'22.943830731518','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440114','title'=>'花都区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.22657580629','lat'=>'23.411161504876','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440115','title'=>'南沙区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.53143554372','lat'=>'22.807929296528','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440117','title'=>'从化区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.59358543922','lat'=>'23.553985922578','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440118','title'=>'增城区','pid'=>'440100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.8175456689','lat'=>'23.266592400631','level'=>'3','tree'=>'tr_0 tr_440000 tr_440100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440203','title'=>'武江区','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.59455578884','lat'=>'24.798486030733','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440204','title'=>'浈江区','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.61747740137','lat'=>'24.810413749784','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440205','title'=>'曲江区','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'113.61150106465','lat'=>'24.68840784638','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440222','title'=>'始兴县','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.06856735205','lat'=>'24.958558154346','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440224','title'=>'仁化县','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'113.75544293443','lat'=>'25.092287524428','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440229','title'=>'翁源县','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.13642723669','lat'=>'24.356594490867','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440232','title'=>'乳源瑶族自治县','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'113.28243136492','lat'=>'24.782333322942','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440233','title'=>'新丰县','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.21351173078','lat'=>'24.065546505164','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440281','title'=>'乐昌市','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.3545786821','lat'=>'25.135591561195','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440282','title'=>'南雄市','pid'=>'440200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.31857889065','lat'=>'25.123526537362','level'=>'3','tree'=>'tr_0 tr_440000 tr_440200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440303','title'=>'罗湖区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.13743190157','lat'=>'22.554484875856','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440304','title'=>'福田区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.06154700466','lat'=>'22.528465912072','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440305','title'=>'南山区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.93653916925','lat'=>'22.538500195784','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440306','title'=>'宝安区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.89042744066','lat'=>'22.560032908925','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440307','title'=>'龙岗区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.25445487896','lat'=>'22.726016550781','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440308','title'=>'盐田区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.2434301551','lat'=>'22.563437914836','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440309','title'=>'龙华区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.04852876121','lat'=>'22.757596649222','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440310','title'=>'坪山区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'114.35047403625','lat'=>'22.716233464749','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440311','title'=>'光明区','pid'=>'440300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.94256006193','lat'=>'22.754465883635','level'=>'3','tree'=>'tr_0 tr_440000 tr_440300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440402','title'=>'香洲区','pid'=>'440400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.55047243408','lat'=>'22.273003861799','level'=>'3','tree'=>'tr_0 tr_440000 tr_440400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440403','title'=>'斗门区','pid'=>'440400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.30346725453','lat'=>'22.215515662229','level'=>'3','tree'=>'tr_0 tr_440000 tr_440400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440404','title'=>'金湾区','pid'=>'440400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.36951705357','lat'=>'22.152576780675','level'=>'3','tree'=>'tr_0 tr_440000 tr_440400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440507','title'=>'龙湖区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.72352464693','lat'=>'23.377775780628','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440511','title'=>'金平区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.70955006744','lat'=>'23.371750385773','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440512','title'=>'濠江区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.73351658895','lat'=>'23.291546359757','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440513','title'=>'潮阳区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.6085145027','lat'=>'23.270854956943','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440514','title'=>'潮南区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.43949131427','lat'=>'23.256341432673','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440515','title'=>'澄海区','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.76242504839','lat'=>'23.472341401523','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440523','title'=>'南澳县','pid'=>'440500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'117.03049603113','lat'=>'23.427812045946','level'=>'3','tree'=>'tr_0 tr_440000 tr_440500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440604','title'=>'禅城区','pid'=>'440600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.12950518241','lat'=>'23.015374368816','level'=>'3','tree'=>'tr_0 tr_440000 tr_440600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440605','title'=>'南海区','pid'=>'440600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.14944567828','lat'=>'23.035011446003','level'=>'3','tree'=>'tr_0 tr_440000 tr_440600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440606','title'=>'顺德区','pid'=>'440600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.30045343954','lat'=>'22.810453426795','level'=>'3','tree'=>'tr_0 tr_440000 tr_440600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440607','title'=>'三水区','pid'=>'440600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.90347085515','lat'=>'23.161920493984','level'=>'3','tree'=>'tr_0 tr_440000 tr_440600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440608','title'=>'高明区','pid'=>'440600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.89947240749','lat'=>'22.90634960163','level'=>'3','tree'=>'tr_0 tr_440000 tr_440600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440703','title'=>'蓬江区','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.08454642894','lat'=>'22.601065786023','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440704','title'=>'江海区','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'113.11755718015','lat'=>'22.566115451824','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440705','title'=>'新会区','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.03845482239','lat'=>'22.46511306052','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440781','title'=>'台山市','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.80044482505','lat'=>'22.257923470251','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440783','title'=>'开平市','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'112.70446429491','lat'=>'22.382499490201','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440784','title'=>'鹤山市','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.97052666653','lat'=>'22.771169431377','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440785','title'=>'恩平市','pid'=>'440700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'112.31143757848','lat'=>'22.189035201534','level'=>'3','tree'=>'tr_0 tr_440000 tr_440700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440802','title'=>'赤坎区','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'110.37253254096','lat'=>'21.272134812703','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440803','title'=>'霞山区','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.40442535096','lat'=>'21.198227185303','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440804','title'=>'坡头区','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'110.46256709711','lat'=>'21.250376738599','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440811','title'=>'麻章区','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.34057918516','lat'=>'21.269188766567','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440823','title'=>'遂溪县','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.25651530642','lat'=>'21.383102962029','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440825','title'=>'徐闻县','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.18247274427','lat'=>'20.331723686702','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440881','title'=>'廉江市','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.29244770646','lat'=>'21.615816495305','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440882','title'=>'雷州市','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.10258050648','lat'=>'20.919880592716','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440883','title'=>'吴川市','pid'=>'440800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.78645034015','lat'=>'21.447262768557','level'=>'3','tree'=>'tr_0 tr_440000 tr_440800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440902','title'=>'茂南区','pid'=>'440900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.92554576188','lat'=>'21.647152082304','level'=>'3','tree'=>'tr_0 tr_440000 tr_440900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440904','title'=>'电白区','pid'=>'440900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.02047123221','lat'=>'21.520351188198','level'=>'3','tree'=>'tr_0 tr_440000 tr_440900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440981','title'=>'高州市','pid'=>'440900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'110.85947386452','lat'=>'21.924048896771','level'=>'3','tree'=>'tr_0 tr_440000 tr_440900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440982','title'=>'化州市','pid'=>'440900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.6464310112','lat'=>'21.67023109387','level'=>'3','tree'=>'tr_0 tr_440000 tr_440900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'440983','title'=>'信宜市','pid'=>'440900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.95358169717','lat'=>'22.36009314173','level'=>'3','tree'=>'tr_0 tr_440000 tr_440900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441202','title'=>'端州区','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.49156022979','lat'=>'23.057563726176','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441203','title'=>'鼎湖区','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'112.57443448255','lat'=>'23.164308112716','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441204','title'=>'高要区','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.46444604577','lat'=>'23.031895546866','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441223','title'=>'广宁县','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'112.44742387501','lat'=>'23.641035726333','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441224','title'=>'怀集县','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'112.19146878783','lat'=>'23.917842129185','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441225','title'=>'封开县','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.51852585255','lat'=>'23.429768921261','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441226','title'=>'德庆县','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'111.79155377493','lat'=>'23.15137330611','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441284','title'=>'四会市','pid'=>'441200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'112.7405791408','lat'=>'23.332381005175','level'=>'3','tree'=>'tr_0 tr_440000 tr_441200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441302','title'=>'惠城区','pid'=>'441300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.38949004962','lat'=>'23.089725972544','level'=>'3','tree'=>'tr_0 tr_440000 tr_441300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441303','title'=>'惠阳区','pid'=>'441300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.46346443037','lat'=>'22.794720878571','level'=>'3','tree'=>'tr_0 tr_440000 tr_441300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441322','title'=>'博罗县','pid'=>'441300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'114.29657265143','lat'=>'23.178805592433','level'=>'3','tree'=>'tr_0 tr_440000 tr_441300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441323','title'=>'惠东县','pid'=>'441300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.72642585138','lat'=>'22.991443112002','level'=>'3','tree'=>'tr_0 tr_440000 tr_441300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441324','title'=>'龙门县','pid'=>'441300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.26143022124','lat'=>'23.733838340062','level'=>'3','tree'=>'tr_0 tr_440000 tr_441300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441402','title'=>'梅江区','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.12353597667','lat'=>'24.315878769038','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441403','title'=>'梅县区','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'116.08856170928','lat'=>'24.270999314695','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441422','title'=>'大埔县','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.70155892129','lat'=>'24.353459468582','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441423','title'=>'丰顺县','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.18845382094','lat'=>'23.745738303255','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441424','title'=>'五华县','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.78248548653','lat'=>'23.938408899571','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441426','title'=>'平远县','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.89747694601','lat'=>'24.572414126137','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441427','title'=>'蕉岭县','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.17743924793','lat'=>'24.664992548662','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441481','title'=>'兴宁市','pid'=>'441400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.73757946359','lat'=>'24.142293779322','level'=>'3','tree'=>'tr_0 tr_440000 tr_441400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441502','title'=>'城区','pid'=>'441500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.37153074806','lat'=>'22.784551839489','level'=>'3','tree'=>'tr_0 tr_440000 tr_441500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441521','title'=>'海丰县','pid'=>'441500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.32944477561','lat'=>'22.972744260966','level'=>'3','tree'=>'tr_0 tr_440000 tr_441500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441523','title'=>'陆河县','pid'=>'441500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.66648271471','lat'=>'23.30767707649','level'=>'3','tree'=>'tr_0 tr_440000 tr_441500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441581','title'=>'陆丰市','pid'=>'441500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.78802975191','lat'=>'22.967876723873','level'=>'3','tree'=>'tr_0 tr_440000 tr_441500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441602','title'=>'源城区','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.70843899033','lat'=>'23.740298338347','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441621','title'=>'紫金县','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.19044771834','lat'=>'23.641430253189','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441622','title'=>'龙川县','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.26655548485','lat'=>'24.105850721955','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441623','title'=>'连平县','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.49544419635','lat'=>'24.375808067414','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441624','title'=>'和平县','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.9454488143','lat'=>'24.448252767689','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441625','title'=>'东源县','pid'=>'441600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.7535083252','lat'=>'23.794257873114','level'=>'3','tree'=>'tr_0 tr_440000 tr_441600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441702','title'=>'江城区','pid'=>'441700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'111.96145451801','lat'=>'21.868127886755','level'=>'3','tree'=>'tr_0 tr_440000 tr_441700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441704','title'=>'阳东区','pid'=>'441700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.01857947215','lat'=>'21.873996844319','level'=>'3','tree'=>'tr_0 tr_440000 tr_441700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441721','title'=>'阳西县','pid'=>'441700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.62448107725','lat'=>'21.758700627505','level'=>'3','tree'=>'tr_0 tr_440000 tr_441700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441781','title'=>'阳春市','pid'=>'441700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.7975361303','lat'=>'22.17601480732','level'=>'3','tree'=>'tr_0 tr_440000 tr_441700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441802','title'=>'清城区','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'113.06947663537','lat'=>'23.704022037925','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441803','title'=>'清新区','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'112.99155779512','lat'=>'23.754270337093','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441821','title'=>'佛冈县','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.53844124873','lat'=>'23.885475421111','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441823','title'=>'阳山县','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.64751954085','lat'=>'24.47094363588','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441825','title'=>'连山壮族瑶族自治县','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.10042570409','lat'=>'24.576845604093','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441826','title'=>'连南瑶族自治县','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.29351728187','lat'=>'24.73154858148','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441881','title'=>'英德市','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.42144297474','lat'=>'24.191939355217','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441882','title'=>'连州市','pid'=>'441800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'112.38357258887','lat'=>'24.786466855047','level'=>'3','tree'=>'tr_0 tr_440000 tr_441800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900003','title'=>'东城街道办事处','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.78961542643','lat'=>'23.033927867022','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900004','title'=>'南城街道办事处','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.74972154669','lat'=>'23.02491560037','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900005','title'=>'万江街道办事处','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.70128466119','lat'=>'23.044382337638','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900006','title'=>'莞城街道办事处','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.7555643548','lat'=>'23.04532373021','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900101','title'=>'石碣镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.81395530616','lat'=>'23.105172244651','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900102','title'=>'石龙镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.84749077289','lat'=>'23.115219876975','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900103','title'=>'茶山镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'113.89350241139','lat'=>'23.069002516534','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900104','title'=>'石排镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.96394649371','lat'=>'23.088334509001','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900105','title'=>'企石镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.04851828338','lat'=>'23.070690716193','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900106','title'=>'横沥镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.98801324096','lat'=>'23.030051448767','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900107','title'=>'桥头镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.10677408198','lat'=>'23.020458678747','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900108','title'=>'谢岗镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.19511437465','lat'=>'22.946513843008','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900109','title'=>'东坑镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.95246820282','lat'=>'23.002958656049','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900110','title'=>'常平镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.02458867145','lat'=>'22.979369177741','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900111','title'=>'寮步镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.88349112257','lat'=>'22.996428153649','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900112','title'=>'樟木头镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.11559876672','lat'=>'22.912795269745','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900113','title'=>'大朗镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.94820653279','lat'=>'22.912348752542','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900114','title'=>'黄江镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.00621531625','lat'=>'22.872431801821','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900115','title'=>'清溪镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.18744982903','lat'=>'22.841601621999','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900116','title'=>'塘厦镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.08442795001','lat'=>'22.811576132112','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900117','title'=>'凤岗镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.17560299034','lat'=>'22.722315801247','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900118','title'=>'大岭山镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.83293372133','lat'=>'22.903546239236','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900119','title'=>'长安镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.76998309965','lat'=>'22.795308241444','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900121','title'=>'虎门镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.68188667267','lat'=>'22.818449805406','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900122','title'=>'厚街镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.7081456375','lat'=>'22.923357615893','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900123','title'=>'沙田镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.60821459687','lat'=>'22.907479676518','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900124','title'=>'道滘镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.66267069882','lat'=>'22.982801242639','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900125','title'=>'洪梅镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.6125183112','lat'=>'22.978946913376','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900126','title'=>'麻涌镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.58837988097','lat'=>'23.057083015858','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900127','title'=>'望牛墩镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.64023583492','lat'=>'23.047597838769','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900128','title'=>'中堂镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.65890566238','lat'=>'23.096485679975','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900129','title'=>'高埗镇','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.74213386638','lat'=>'23.100270479205','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900401','title'=>'松山湖管委会','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.90386183402','lat'=>'22.928504587758','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900402','title'=>'东莞港','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.75842045788','lat'=>'23.027308411643','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'441900403','title'=>'东莞生态园','pid'=>'441900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.93331900631','lat'=>'23.069150651008','level'=>'3','tree'=>'tr_0 tr_440000 tr_441900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000001','title'=>'石岐区街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.39476330111','lat'=>'22.543405990677','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000002','title'=>'东区街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.39942236263','lat'=>'22.522314670791','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000003','title'=>'火炬开发区街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.47638423802','lat'=>'22.54191612433','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000004','title'=>'西区街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.34742851429','lat'=>'22.557446683319','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000005','title'=>'南区街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.34166389111','lat'=>'22.474593624741','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000006','title'=>'五桂山街道办事处','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'113.40930659782','lat'=>'22.451434375841','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000100','title'=>'小榄镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'113.25710033351','lat'=>'22.668653898989','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000101','title'=>'黄圃镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.38940119784','lat'=>'22.732151367196','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000102','title'=>'民众镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'113.50030740281','lat'=>'22.624234006676','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000103','title'=>'东凤镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.26337563889','lat'=>'22.696772350456','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000104','title'=>'东升镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.31347763067','lat'=>'22.605137527398','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000105','title'=>'古镇镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.18899941194','lat'=>'22.636034421686','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000106','title'=>'沙溪镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.35710852331','lat'=>'22.513668030794','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000107','title'=>'坦洲镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'113.46831862593','lat'=>'22.283731940242','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000108','title'=>'港口镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'113.38354521878','lat'=>'22.577121999043','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000109','title'=>'三角镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.42740190231','lat'=>'22.685663488493','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000110','title'=>'横栏镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'113.24834255727','lat'=>'22.574461443704','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000111','title'=>'南头镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.29481042537','lat'=>'22.721261074602','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000112','title'=>'阜沙镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.34269477842','lat'=>'22.666128002352','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000113','title'=>'南朗镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'113.56057493505','lat'=>'22.519486447352','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000114','title'=>'三乡镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.42695556574','lat'=>'22.371470122528','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000115','title'=>'板芙镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'113.33339573359','lat'=>'22.395149046719','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000116','title'=>'大涌镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'113.29404791311','lat'=>'22.483908949365','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'442000117','title'=>'神湾镇','pid'=>'442000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.35331518036','lat'=>'22.32576323421','level'=>'3','tree'=>'tr_0 tr_440000 tr_442000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445102','title'=>'湘桥区','pid'=>'445100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.63446160819','lat'=>'23.680686981566','level'=>'3','tree'=>'tr_0 tr_440000 tr_445100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445103','title'=>'潮安区','pid'=>'445100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.68452606069','lat'=>'23.468357129831','level'=>'3','tree'=>'tr_0 tr_440000 tr_445100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445122','title'=>'饶平县','pid'=>'445100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'117.01044917588','lat'=>'23.670347111195','level'=>'3','tree'=>'tr_0 tr_440000 tr_445100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445202','title'=>'榕城区','pid'=>'445200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'116.37351589492','lat'=>'23.530746417966','level'=>'3','tree'=>'tr_0 tr_440000 tr_445200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445203','title'=>'揭东区','pid'=>'445200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.41845578398','lat'=>'23.572485187047','level'=>'3','tree'=>'tr_0 tr_440000 tr_445200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445222','title'=>'揭西县','pid'=>'445200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.84856088728','lat'=>'23.437299708209','level'=>'3','tree'=>'tr_0 tr_440000 tr_445200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445224','title'=>'惠来县','pid'=>'445200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.30144448456','lat'=>'23.039645374525','level'=>'3','tree'=>'tr_0 tr_440000 tr_445200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445281','title'=>'普宁市','pid'=>'445200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.17244898117','lat'=>'23.30363452186','level'=>'3','tree'=>'tr_0 tr_440000 tr_445200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430102','title'=>'芙蓉区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'113.03940774487','lat'=>'28.191913247305','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430103','title'=>'天心区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'112.99659225852','lat'=>'28.118211217441','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430104','title'=>'岳麓区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.9374476441','lat'=>'28.241488836473','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430105','title'=>'开福区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'112.99258491764','lat'=>'28.261378687684','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430111','title'=>'雨花区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'113.04242155986','lat'=>'28.142232711654','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430112','title'=>'望城区','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.8244661432','lat'=>'28.367403020376','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430121','title'=>'长沙县','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'113.08755916596','lat'=>'28.251818487944','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430181','title'=>'浏阳市','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'113.64939823851','lat'=>'28.169832216071','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'430182','title'=>'宁乡市','pid'=>'430100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.55840691564','lat'=>'28.284104536209','level'=>'3','tree'=>'tr_0 tr_430000 tr_430100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445302','title'=>'云城区','pid'=>'445300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.05052923472','lat'=>'22.933897802971','level'=>'3','tree'=>'tr_0 tr_440000 tr_445300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445303','title'=>'云安区','pid'=>'445300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'112.00956308992','lat'=>'23.076892611911','level'=>'3','tree'=>'tr_0 tr_440000 tr_445300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445321','title'=>'新兴县','pid'=>'445300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'112.23149683219','lat'=>'22.701890082606','level'=>'3','tree'=>'tr_0 tr_440000 tr_445300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445322','title'=>'郁南县','pid'=>'445300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'111.54155382446','lat'=>'23.240174042653','level'=>'3','tree'=>'tr_0 tr_440000 tr_445300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'445381','title'=>'罗定市','pid'=>'445300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.57648048166','lat'=>'22.774296060763','level'=>'3','tree'=>'tr_0 tr_440000 tr_445300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450102','title'=>'兴宁区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.37544497422','lat'=>'22.860290951255','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450103','title'=>'青秀区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.50143861009','lat'=>'22.792227439631','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450105','title'=>'江南区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.27949435764','lat'=>'22.787045753588','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450107','title'=>'西乡塘区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.31957243762','lat'=>'22.839651509339','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450108','title'=>'良庆区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.32751579392','lat'=>'22.76284928359','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450109','title'=>'邕宁区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.49342024528','lat'=>'22.76460044955','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450110','title'=>'武鸣区','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.28151653318','lat'=>'23.164515606911','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450123','title'=>'隆安县','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.70257390338','lat'=>'23.171585249828','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450124','title'=>'马山县','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'108.18356215633','lat'=>'23.71387772536','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450125','title'=>'上林县','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.61145148078','lat'=>'23.438518877663','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450126','title'=>'宾阳县','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'108.81650237947','lat'=>'23.223700543767','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450127','title'=>'横县','pid'=>'450100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.2675678064','lat'=>'22.685572608838','level'=>'3','tree'=>'tr_0 tr_450000 tr_450100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450202','title'=>'城中区','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'109.4174821502','lat'=>'24.321314069891','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450203','title'=>'鱼峰区','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.44941628225','lat'=>'24.318521699515','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450204','title'=>'柳南区','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.39155193285','lat'=>'24.341578870912','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450205','title'=>'柳北区','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.40853179342','lat'=>'24.367867017648','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450206','title'=>'柳江区','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.33244423878','lat'=>'24.26081496535','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450222','title'=>'柳城县','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.25156152934','lat'=>'24.656370391486','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450223','title'=>'鹿寨县','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.75755447547','lat'=>'24.478622266898','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450224','title'=>'融安县','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'109.40456325934','lat'=>'25.230511447128','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450225','title'=>'融水苗族自治县','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'109.26256083115','lat'=>'25.072076504109','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450226','title'=>'三江侗族自治县','pid'=>'450200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.61454747223','lat'=>'25.788830387788','level'=>'3','tree'=>'tr_0 tr_450000 tr_450200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450302','title'=>'秀峰区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.27043670622','lat'=>'25.27961848567','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450303','title'=>'叠彩区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.30846314624','lat'=>'25.320233274843','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450304','title'=>'象山区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.28742267527','lat'=>'25.267930010211','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450305','title'=>'七星区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'110.32453805385','lat'=>'25.2585670875','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450311','title'=>'雁山区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.3154792716','lat'=>'25.066213543917','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450312','title'=>'临桂区','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.21858669186','lat'=>'25.244301999271','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450321','title'=>'阳朔县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.50347503171','lat'=>'24.784519191433','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450323','title'=>'灵川县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.33253719492','lat'=>'25.41554953076','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450324','title'=>'全州县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'111.07956895508','lat'=>'25.934343027361','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450325','title'=>'兴安县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.67851632807','lat'=>'25.617567220037','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450326','title'=>'永福县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.989590831','lat'=>'24.985577973084','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450327','title'=>'灌阳县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'111.16755205093','lat'=>'25.495120752051','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450328','title'=>'龙胜各族自治县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.01749399674','lat'=>'25.804116784254','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450329','title'=>'资源县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.6584391101','lat'=>'26.048569077338','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450330','title'=>'平乐县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'110.64944626347','lat'=>'24.63963212806','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450332','title'=>'恭城瑶族自治县','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'110.8345596307','lat'=>'24.837194365911','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450381','title'=>'荔浦市','pid'=>'450300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.40143677836','lat'=>'24.494121641923','level'=>'3','tree'=>'tr_0 tr_450000 tr_450300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450403','title'=>'万秀区','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'111.32751969101','lat'=>'23.478845767296','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450405','title'=>'长洲区','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.28149914043','lat'=>'23.491509584406','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450406','title'=>'龙圩区','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'111.25344829326','lat'=>'23.421414485718','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450421','title'=>'苍梧县','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'111.55554663956','lat'=>'23.845998205466','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450422','title'=>'藤县','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'110.92149925488','lat'=>'23.38100991555','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450423','title'=>'蒙山县','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.53141700425','lat'=>'24.200017445935','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450481','title'=>'岑溪市','pid'=>'450400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'111.00143182659','lat'=>'22.92462127872','level'=>'3','tree'=>'tr_0 tr_450000 tr_450400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450502','title'=>'海城区','pid'=>'450500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.12452136755','lat'=>'21.481065838236','level'=>'3','tree'=>'tr_0 tr_450000 tr_450500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450503','title'=>'银海区','pid'=>'450500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.14654476441','lat'=>'21.454768668895','level'=>'3','tree'=>'tr_0 tr_450000 tr_450500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450512','title'=>'铁山港区','pid'=>'450500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.42847264862','lat'=>'21.53529504285','level'=>'3','tree'=>'tr_0 tr_450000 tr_450500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450521','title'=>'合浦县','pid'=>'450500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.2134386113','lat'=>'21.667005735642','level'=>'3','tree'=>'tr_0 tr_450000 tr_450500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450602','title'=>'港口区','pid'=>'450600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'108.38648254385','lat'=>'21.649565586624','level'=>'3','tree'=>'tr_0 tr_450000 tr_450600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450603','title'=>'防城区','pid'=>'450600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'108.36044848238','lat'=>'21.775411305197','level'=>'3','tree'=>'tr_0 tr_450000 tr_450600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450621','title'=>'上思县','pid'=>'450600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'107.99044264125','lat'=>'22.15991408311','level'=>'3','tree'=>'tr_0 tr_450000 tr_450600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450681','title'=>'东兴市','pid'=>'450600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.97748898597','lat'=>'21.55361543358','level'=>'3','tree'=>'tr_0 tr_450000 tr_450600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450802','title'=>'港北区','pid'=>'450800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.57843298566','lat'=>'23.117563632764','level'=>'3','tree'=>'tr_0 tr_450000 tr_450800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450803','title'=>'港南区','pid'=>'450800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.6065534515','lat'=>'23.08123957836','level'=>'3','tree'=>'tr_0 tr_450000 tr_450800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450804','title'=>'覃塘区','pid'=>'450800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.45942672936','lat'=>'23.133251089213','level'=>'3','tree'=>'tr_0 tr_450000 tr_450800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450821','title'=>'平南县','pid'=>'450800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'110.39845197864','lat'=>'23.545506098828','level'=>'3','tree'=>'tr_0 tr_450000 tr_450800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450881','title'=>'桂平市','pid'=>'450800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'110.08552599672','lat'=>'23.400048883699','level'=>'3','tree'=>'tr_0 tr_450000 tr_450800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450902','title'=>'玉州区','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.15743140022','lat'=>'22.634492736172','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450903','title'=>'福绵区','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'110.08853765577','lat'=>'22.563705412249','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450921','title'=>'容县','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'110.56453016229','lat'=>'22.863665599935','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450922','title'=>'陆川县','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.27045619945','lat'=>'22.327221527769','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450923','title'=>'博白县','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.98255305648','lat'=>'22.278674815493','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450924','title'=>'兴业县','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.88155180701','lat'=>'22.742267653423','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450981','title'=>'北流市','pid'=>'450900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'110.36057016581','lat'=>'22.713958021611','level'=>'3','tree'=>'tr_0 tr_450000 tr_450900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451002','title'=>'右江区','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.62558913969','lat'=>'23.907084503109','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451021','title'=>'田阳县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'106.9214125525','lat'=>'23.742005722478','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451022','title'=>'田东县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.13249943541','lat'=>'23.603129804015','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451023','title'=>'平果县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'107.59657106849','lat'=>'23.334922742592','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451024','title'=>'德保县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'106.62158260728','lat'=>'23.328994351286','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451026','title'=>'那坡县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.83942261017','lat'=>'23.393793831292','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451027','title'=>'凌云县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.56841567705','lat'=>'24.354015240604','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451028','title'=>'乐业县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.56342972215','lat'=>'24.783216467053','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451029','title'=>'田林县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'106.23449791231','lat'=>'24.300534611051','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451030','title'=>'西林县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.10049410469','lat'=>'24.495667790362','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451031','title'=>'隆林各族自治县','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.3504594704','lat'=>'24.776813610296','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451081','title'=>'靖西市','pid'=>'451000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.42445269708','lat'=>'23.140125669019','level'=>'3','tree'=>'tr_0 tr_450000 tr_451000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451102','title'=>'八步区','pid'=>'451100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'111.55856737149','lat'=>'24.417531040919','level'=>'3','tree'=>'tr_0 tr_450000 tr_451100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451103','title'=>'平桂区','pid'=>'451100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'111.47841426578','lat'=>'24.462001422773','level'=>'3','tree'=>'tr_0 tr_450000 tr_451100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451121','title'=>'昭平县','pid'=>'451100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.81757491928','lat'=>'24.175106050636','level'=>'3','tree'=>'tr_0 tr_450000 tr_451100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451122','title'=>'钟山县','pid'=>'451100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'111.30958574015','lat'=>'24.531673107939','level'=>'3','tree'=>'tr_0 tr_450000 tr_451100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451123','title'=>'富川瑶族自治县','pid'=>'451100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.28451124863','lat'=>'24.820159951323','level'=>'3','tree'=>'tr_0 tr_450000 tr_451100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451202','title'=>'金城江区','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.04350707483','lat'=>'24.695679382239','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451203','title'=>'宜州区','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.64353158748','lat'=>'24.491084367739','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451221','title'=>'南丹县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'107.54748028934','lat'=>'24.981849775485','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451222','title'=>'天峨县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.17845647579','lat'=>'25.005664155232','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451223','title'=>'凤山县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.04841983631','lat'=>'24.553217796777','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451224','title'=>'东兰县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.3805041595','lat'=>'24.516871463381','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451225','title'=>'罗城仫佬族自治县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.91157445325','lat'=>'24.783084996429','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451226','title'=>'环江毛南族自治县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.26444306917','lat'=>'24.832087938551','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451227','title'=>'巴马瑶族自治县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'107.26648125302','lat'=>'24.14726480427','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451228','title'=>'都安瑶族自治县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'108.11145804765','lat'=>'23.937331261923','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451229','title'=>'大化瑶族自治县','pid'=>'451200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'108.00441075294','lat'=>'23.742818222963','level'=>'3','tree'=>'tr_0 tr_450000 tr_451200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451302','title'=>'兴宾区','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.24149907034','lat'=>'23.733211038144','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451321','title'=>'忻城县','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.67256239612','lat'=>'24.071888636576','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451322','title'=>'象州县','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.71146215028','lat'=>'23.979680993271','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451323','title'=>'武宣县','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.66944220328','lat'=>'23.600404197633','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451324','title'=>'金秀瑶族自治县','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'110.19550625891','lat'=>'24.136319486486','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451381','title'=>'合山市','pid'=>'451300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.89256576969','lat'=>'23.81226007105','level'=>'3','tree'=>'tr_0 tr_450000 tr_451300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451402','title'=>'江州区','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'107.35953321738','lat'=>'22.411245728018','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451421','title'=>'扶绥县','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.91046515426','lat'=>'22.641097136345','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451422','title'=>'宁明县','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'107.08352381902','lat'=>'22.145884844184','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451423','title'=>'龙州县','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.86058190847','lat'=>'22.348298905766','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451424','title'=>'大新县','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.20755690312','lat'=>'22.836229044406','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451425','title'=>'天等县','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.14947264852','lat'=>'23.08750581209','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'451481','title'=>'凭祥市','pid'=>'451400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'106.77352361814','lat'=>'22.100152592954','level'=>'3','tree'=>'tr_0 tr_450000 tr_451400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460105','title'=>'秀英区','pid'=>'460100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'110.30043588821','lat'=>'20.013642385161','level'=>'3','tree'=>'tr_0 tr_460000 tr_460100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460106','title'=>'龙华区','pid'=>'460100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.33554112854','lat'=>'20.036320733521','level'=>'3','tree'=>'tr_0 tr_460000 tr_460100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460107','title'=>'琼山区','pid'=>'460100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'110.36052605901','lat'=>'20.009150644491','level'=>'3','tree'=>'tr_0 tr_460000 tr_460100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460108','title'=>'美兰区','pid'=>'460100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.37349839904','lat'=>'20.034646217625','level'=>'3','tree'=>'tr_0 tr_460000 tr_460100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460202','title'=>'海棠区','pid'=>'460200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.72350007292','lat'=>'18.33787879371','level'=>'3','tree'=>'tr_0 tr_460000 tr_460200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460203','title'=>'吉阳区','pid'=>'460200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.52055165827','lat'=>'18.257057667262','level'=>'3','tree'=>'tr_0 tr_460000 tr_460200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460204','title'=>'天涯区','pid'=>'460200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.46246255283','lat'=>'18.306919633503','level'=>'3','tree'=>'tr_0 tr_460000 tr_460200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460205','title'=>'崖州区','pid'=>'460200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.22846124383','lat'=>'18.44463053478','level'=>'3','tree'=>'tr_0 tr_460000 tr_460200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460321','title'=>'西沙群岛','pid'=>'460300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'111.67308686126','lat'=>'16.497085431044','level'=>'3','tree'=>'tr_0 tr_460000 tr_460300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460322','title'=>'南沙群岛','pid'=>'460300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'112.66030170907','lat'=>'4.9743661921368','level'=>'3','tree'=>'tr_0 tr_460000 tr_460300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460323','title'=>'中沙群岛的岛礁及其海域','pid'=>'460300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'112.34048204137','lat'=>'16.838953334409','level'=>'3','tree'=>'tr_0 tr_460000 tr_460300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400100','title'=>'那大镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'109.552961497','lat'=>'19.52127763772','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400101','title'=>'和庆镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.64738779153','lat'=>'19.531275426074','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400102','title'=>'南丰镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'109.6054369934','lat'=>'19.346095790543','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400103','title'=>'大成镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'109.42116531507','lat'=>'19.548276240672','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400104','title'=>'雅星镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.19716320191','lat'=>'19.517956948407','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400105','title'=>'兰洋镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.67367138789','lat'=>'19.466430878427','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400106','title'=>'光村镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.50795789562','lat'=>'19.809145677126','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400107','title'=>'木棠镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'109.35673473687','lat'=>'19.809926770596','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400108','title'=>'海头镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.95966166166','lat'=>'19.509695855917','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400109','title'=>'峨蔓镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'109.30390924357','lat'=>'19.863144800976','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400111','title'=>'王五镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.33806829512','lat'=>'19.645800769747','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400112','title'=>'白马井镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.58745583569','lat'=>'19.527146110044','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400113','title'=>'中和镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.35613533713','lat'=>'19.749465537088','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400114','title'=>'排浦镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'109.16975400269','lat'=>'19.644673698003','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400115','title'=>'东成镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'109.4680333127','lat'=>'19.709924104042','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400116','title'=>'新州镇','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.32260133284','lat'=>'19.720234743232','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400499','title'=>'洋浦经济开发区','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.19229656623','lat'=>'19.775218244804','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'460400500','title'=>'华南热作学院','pid'=>'460400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.58745583569','lat'=>'19.527146110044','level'=>'3','tree'=>'tr_0 tr_460000 tr_460400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469001','title'=>'五指山市','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.52354032071','lat'=>'18.780994100706','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469002','title'=>'琼海市','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'110.48054452595','lat'=>'19.264254019918','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469005','title'=>'文昌市','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.80450870632','lat'=>'19.549062083121','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469006','title'=>'万宁市','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.39943436555','lat'=>'18.800106988303','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469007','title'=>'东方市','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'108.65856652679','lat'=>'19.101104731289','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469021','title'=>'定安县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.36878601078','lat'=>'31.589181642776','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469022','title'=>'屯昌县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'110.10857732457','lat'=>'19.357374924278','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469023','title'=>'澄迈县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'110.01351091011','lat'=>'19.744348671646','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469024','title'=>'临高县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.69744301483','lat'=>'19.919474770278','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469025','title'=>'白沙黎族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.45747066911','lat'=>'19.231378733013','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469026','title'=>'昌江黎族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'109.06246408734','lat'=>'19.303997876684','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469027','title'=>'乐东黎族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.18050798895','lat'=>'18.755871493855','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469028','title'=>'陵水黎族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.04446409255','lat'=>'18.512331595699','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469029','title'=>'保亭黎族苗族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.7034815143','lat'=>'18.646909955376','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'469030','title'=>'琼中黎族苗族自治县','pid'=>'469000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'109.84451062847','lat'=>'19.039163789181','level'=>'3','tree'=>'tr_0 tr_460000 tr_469000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500101','title'=>'万州区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.4155583705','lat'=>'30.813621636708','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500102','title'=>'涪陵区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.39641979754','lat'=>'29.709278197979','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500103','title'=>'渝中区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.57544006681','lat'=>'29.559090182994','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500104','title'=>'大渡口区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'106.48853359011','lat'=>'29.490107128556','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500105','title'=>'江北区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500106','title'=>'沙坪坝区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'106.46446511093','lat'=>'29.547192516541','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500107','title'=>'九龙坡区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.51755873943','lat'=>'29.507927715553','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500108','title'=>'南岸区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.6684297786','lat'=>'29.502683098835','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500109','title'=>'北碚区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.40356933975','lat'=>'29.811602753904','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500110','title'=>'綦江区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.65748419545','lat'=>'29.034113748311','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500111','title'=>'大足区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'105.72840462545','lat'=>'29.713113506077','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500112','title'=>'渝北区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.6375590606','lat'=>'29.723927343007','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500113','title'=>'巴南区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.54745425696','lat'=>'29.40847473977','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500114','title'=>'黔江区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.77759119835','lat'=>'29.53881256766','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500115','title'=>'长寿区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'107.08753107007','lat'=>'29.863520067323','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500116','title'=>'江津区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.26559760838','lat'=>'29.295884374465','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500117','title'=>'合川区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.28254108758','lat'=>'29.978181239534','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500118','title'=>'永川区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'105.93349936145','lat'=>'29.362046335949','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500119','title'=>'南川区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'107.10558512437','lat'=>'29.163478599606','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500120','title'=>'璧山区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.23347456267','lat'=>'29.598346607316','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500151','title'=>'铜梁区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'106.06344949411','lat'=>'29.850508778722','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500152','title'=>'潼南区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'105.84739903617','lat'=>'30.197314239664','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500153','title'=>'荣昌区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'105.60141979928','lat'=>'29.41130739669','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500154','title'=>'开州区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'108.39949765612','lat'=>'31.166644113193','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500155','title'=>'梁平区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.77609725763','lat'=>'30.660553255023','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500156','title'=>'武隆区','pid'=>'500100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'112.85530302042','lat'=>'35.520558754673','level'=>'3','tree'=>'tr_0 tr_500000 tr_500100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500229','title'=>'城口县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'108.67161164256','lat'=>'31.953390746293','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500230','title'=>'丰都县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.7374806182','lat'=>'29.869412789214','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500231','title'=>'垫江县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.33956587472','lat'=>'30.3332939685','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500233','title'=>'忠县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500235','title'=>'云阳县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.7034475','lat'=>'30.936611271975','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500236','title'=>'奉节县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'109.47047275631','lat'=>'31.024601766549','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500237','title'=>'巫山县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.88554550703','lat'=>'31.080518811736','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500238','title'=>'巫溪县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.576402559','lat'=>'31.404880009858','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500240','title'=>'石柱土家族自治县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.12041416638','lat'=>'30.006108697869','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500241','title'=>'秀山土家族苗族自治县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.01357389981','lat'=>'28.453447864286','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500242','title'=>'酉阳土家族苗族自治县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.7745860071','lat'=>'28.847040258674','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'500243','title'=>'彭水苗族土家族自治县','pid'=>'500200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'108.17257803588','lat'=>'29.299462290443','level'=>'3','tree'=>'tr_0 tr_500000 tr_500200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510104','title'=>'锦江区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.0895617566','lat'=>'30.661904490317','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510105','title'=>'青羊区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'104.06744547494','lat'=>'30.680037807007','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510106','title'=>'金牛区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.05740358714','lat'=>'30.697356042874','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510107','title'=>'武侯区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.04942447828','lat'=>'30.648712685321','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510108','title'=>'成华区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'104.10859155035','lat'=>'30.665589283983','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510112','title'=>'龙泉驿区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.28139696436','lat'=>'30.562697841','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510113','title'=>'青白江区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'104.25751245813','lat'=>'30.884421372736','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510114','title'=>'新都区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'104.16539284504','lat'=>'30.829407468191','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510115','title'=>'温江区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'103.86357306318','lat'=>'30.688486836627','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510116','title'=>'双流区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.93039154227','lat'=>'30.580399352821','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510117','title'=>'郫都区','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'103.90544568809','lat'=>'30.799537653573','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510121','title'=>'金堂县','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.41844263262','lat'=>'30.868358423946','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510129','title'=>'大邑县','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.52752981767','lat'=>'30.593155402402','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510131','title'=>'蒲江县','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'103.51257132415','lat'=>'30.202500428139','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510132','title'=>'新津县','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'103.81743303795','lat'=>'30.416363953297','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510181','title'=>'都江堰市','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.65353360443','lat'=>'30.994256893542','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510182','title'=>'彭州市','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'103.96556137078','lat'=>'30.995564002629','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510183','title'=>'邛崃市','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'103.47048112964','lat'=>'30.416398600854','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510184','title'=>'崇州市','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'103.67943336923','lat'=>'30.636595891379','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510185','title'=>'简阳市','pid'=>'510100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.55349406265','lat'=>'30.417451491353','level'=>'3','tree'=>'tr_0 tr_510000 tr_510100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510302','title'=>'自流井区','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.7834473259','lat'=>'29.343498562348','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510303','title'=>'贡井区','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'104.72155659154','lat'=>'29.351476269522','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510304','title'=>'大安区','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.78041635328','lat'=>'29.369928541322','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510311','title'=>'沿滩区','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.88040907516','lat'=>'29.278797205251','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510321','title'=>'荣县','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'104.42345759121','lat'=>'29.45180089858','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510322','title'=>'富顺县','pid'=>'510300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'104.98149440603','lat'=>'29.186886257831','level'=>'3','tree'=>'tr_0 tr_510000 tr_510300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510402','title'=>'东区','pid'=>'510400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'101.72554117091','lat'=>'26.588033173333','level'=>'3','tree'=>'tr_0 tr_510000 tr_510400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510403','title'=>'西区','pid'=>'510400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'101.72554117091','lat'=>'26.588033173333','level'=>'3','tree'=>'tr_0 tr_510000 tr_510400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510411','title'=>'仁和区','pid'=>'510400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'101.74444996291','lat'=>'26.504019493295','level'=>'3','tree'=>'tr_0 tr_510000 tr_510400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510421','title'=>'米易县','pid'=>'510400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.1164404304','lat'=>'26.89696797612','level'=>'3','tree'=>'tr_0 tr_510000 tr_510400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510422','title'=>'盐边县','pid'=>'510400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.86049854831','lat'=>'26.688767481964','level'=>'3','tree'=>'tr_0 tr_510000 tr_510400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510502','title'=>'江阳区','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'105.44154513382','lat'=>'28.884671972905','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510503','title'=>'纳溪区','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.37740854586','lat'=>'28.779359901658','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510504','title'=>'龙马潭区','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.4445442166','lat'=>'28.919012274486','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510521','title'=>'泸县','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.38845608667','lat'=>'29.157626295708','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510522','title'=>'合江县','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'105.83843195885','lat'=>'28.81779304284','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510524','title'=>'叙永县','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.45150761142','lat'=>'28.161714341911','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510525','title'=>'古蔺县','pid'=>'510500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'105.81947079565','lat'=>'28.044745368759','level'=>'3','tree'=>'tr_0 tr_510000 tr_510500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510603','title'=>'旌阳区','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.42343882821','lat'=>'31.148596291553','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510604','title'=>'罗江区','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.51741416083','lat'=>'31.324178639826','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510623','title'=>'中江县','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.68553015058','lat'=>'31.038953695302','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510681','title'=>'广汉市','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'104.28842189311','lat'=>'30.982415239743','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510682','title'=>'什邡市','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'104.17442710355','lat'=>'31.132889048238','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510683','title'=>'绵竹市','pid'=>'510600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'104.227609305','lat'=>'31.343592258211','level'=>'3','tree'=>'tr_0 tr_510000 tr_510600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510703','title'=>'涪城区','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'104.76342033491','lat'=>'31.46131438858','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510704','title'=>'游仙区','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.77242899171','lat'=>'31.479904474058','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510705','title'=>'安州区','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'104.5735550213','lat'=>'31.540750527876','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510722','title'=>'三台县','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'105.10148979833','lat'=>'31.101585571238','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510723','title'=>'盐亭县','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'105.39550321547','lat'=>'31.214318764837','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510725','title'=>'梓潼县','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.17756684281','lat'=>'31.648313467681','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510726','title'=>'北川羌族自治县','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'104.36158555316','lat'=>'31.963084103415','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510727','title'=>'平武县','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'104.53542150325','lat'=>'32.414681977696','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510781','title'=>'江油市','pid'=>'510700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.75241160088','lat'=>'31.784128193388','level'=>'3','tree'=>'tr_0 tr_510000 tr_510700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510802','title'=>'利州区','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.85242622329','lat'=>'32.440207812726','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510811','title'=>'昭化区','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.96941892782','lat'=>'32.329618490159','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510812','title'=>'朝天区','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.8965888086','lat'=>'32.649726240308','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510821','title'=>'旺苍县','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.29649124536','lat'=>'32.235097383079','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510822','title'=>'青川县','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'105.24540705459','lat'=>'32.5816168573','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510823','title'=>'剑阁县','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'105.53157601887','lat'=>'32.293478516773','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510824','title'=>'苍溪县','pid'=>'510800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.9414826146','lat'=>'31.738684400617','level'=>'3','tree'=>'tr_0 tr_510000 tr_510800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510903','title'=>'船山区','pid'=>'510900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.5745228375','lat'=>'30.531470607829','level'=>'3','tree'=>'tr_0 tr_510000 tr_510900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510904','title'=>'安居区','pid'=>'510900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.46246730988','lat'=>'30.361496469746','level'=>'3','tree'=>'tr_0 tr_510000 tr_510900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510921','title'=>'蓬溪县','pid'=>'510900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'105.71344605411','lat'=>'30.763751441791','level'=>'3','tree'=>'tr_0 tr_510000 tr_510900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510922','title'=>'射洪县','pid'=>'510900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'105.39450950992','lat'=>'30.877138522337','level'=>'3','tree'=>'tr_0 tr_510000 tr_510900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'510923','title'=>'大英县','pid'=>'510900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'105.24340392313','lat'=>'30.600810129921','level'=>'3','tree'=>'tr_0 tr_510000 tr_510900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511002','title'=>'市中区','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'105.07457421786','lat'=>'29.592710148736','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511011','title'=>'东兴区','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'105.08254748773','lat'=>'29.598485728583','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511024','title'=>'威远县','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.6744982286','lat'=>'29.533634931412','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511025','title'=>'资中县','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.85849482242','lat'=>'29.770234032565','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511071','title'=>'内江经济开发区','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.064588025','lat'=>'29.58588653832','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511083','title'=>'隆昌市','pid'=>'511000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.29457175243','lat'=>'29.345244662083','level'=>'3','tree'=>'tr_0 tr_510000 tr_511000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511102','title'=>'市中区','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.76755865552','lat'=>'29.561363941633','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511111','title'=>'沙湾区','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.55643566073','lat'=>'29.419272499245','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511112','title'=>'五通桥区','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'103.82445508074','lat'=>'29.413185014439','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511113','title'=>'金口河区','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'103.08539389554','lat'=>'29.250803570124','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511123','title'=>'犍为县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511124','title'=>'井研县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.07651071353','lat'=>'29.65730305908','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511126','title'=>'夹江县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'103.57841009994','lat'=>'29.743846302985','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511129','title'=>'沐川县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.90846703743','lat'=>'28.962888278216','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511132','title'=>'峨边彝族自治县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'103.26857725338','lat'=>'29.236089109563','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511133','title'=>'马边彝族自治县','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.55245419105','lat'=>'28.841736014812','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511181','title'=>'峨眉山市','pid'=>'511100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'103.4915455741','lat'=>'29.606975527462','level'=>'3','tree'=>'tr_0 tr_510000 tr_511100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511302','title'=>'顺庆区','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'106.09841065838','lat'=>'30.802753098595','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511303','title'=>'高坪区','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.12554047291','lat'=>'30.787254931592','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511304','title'=>'嘉陵区','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.07843297265','lat'=>'30.764895560139','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511321','title'=>'南部县','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.04357826971','lat'=>'31.353705301526','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511322','title'=>'营山县','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.57240802852','lat'=>'31.083002970199','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511323','title'=>'蓬安县','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'106.41848194209','lat'=>'31.034630778271','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511324','title'=>'仪陇县','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.30943016844','lat'=>'31.277597359981','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511325','title'=>'西充县','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.90761137653','lat'=>'31.000688020792','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511381','title'=>'阆中市','pid'=>'511300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.01156526642','lat'=>'31.56407455364','level'=>'3','tree'=>'tr_0 tr_510000 tr_511300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511402','title'=>'东坡区','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.83852480217','lat'=>'30.048272134435','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511403','title'=>'彭山区','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'103.87955823007','lat'=>'30.19885441686','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511421','title'=>'仁寿县','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'104.14047690443','lat'=>'30.001663984301','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511423','title'=>'洪雅县','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'103.37960224488','lat'=>'29.910615837469','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511424','title'=>'丹棱县','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.51958331729','lat'=>'30.020362794872','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511425','title'=>'青神县','pid'=>'511400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'103.85355883179','lat'=>'29.837054743717','level'=>'3','tree'=>'tr_0 tr_510000 tr_511400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511502','title'=>'翠屏区','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'104.62643798553','lat'=>'28.772051773027','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511503','title'=>'南溪区','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'104.97651330198','lat'=>'28.851503648027','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511504','title'=>'叙州区','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'104.53944275624','lat'=>'28.696246394752','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511523','title'=>'江安县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'105.07359488519','lat'=>'28.729609721855','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511524','title'=>'长宁县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.92756445509','lat'=>'28.588133452699','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511525','title'=>'高县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'104.52441132032','lat'=>'28.442510804102','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511526','title'=>'珙县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'104.71557459549','lat'=>'28.444319765248','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511527','title'=>'筠连县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.51740642378','lat'=>'28.170174457648','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511528','title'=>'兴文县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.24240230064','lat'=>'28.309904884117','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511529','title'=>'屏山县','pid'=>'511500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'104.35267533908','lat'=>'28.834274966477','level'=>'3','tree'=>'tr_0 tr_510000 tr_511500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511602','title'=>'广安区','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.64853115608','lat'=>'30.479768100142','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511603','title'=>'前锋区','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.90447959588','lat'=>'30.506435157767','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511621','title'=>'岳池县','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.44641061972','lat'=>'30.54411986458','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511622','title'=>'武胜县','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.3024617431','lat'=>'30.355495660378','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511623','title'=>'邻水县','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.93640258896','lat'=>'30.341072518332','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511681','title'=>'华蓥市','pid'=>'511600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.78946181601','lat'=>'30.396307084289','level'=>'3','tree'=>'tr_0 tr_510000 tr_511600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511702','title'=>'通川区','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.51144711201','lat'=>'31.220931804105','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511703','title'=>'达川区','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.51841059667','lat'=>'31.202393360554','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511722','title'=>'宣汉县','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'107.7335335663','lat'=>'31.359754823662','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511723','title'=>'开江县','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'107.87542487414','lat'=>'31.089372149066','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511724','title'=>'大竹县','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.21157970735','lat'=>'30.74207661791','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511725','title'=>'渠县','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.97958296702','lat'=>'30.842299283481','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511771','title'=>'达州经济开发区','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.47459385898','lat'=>'31.214307723927','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511781','title'=>'万源市','pid'=>'511700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.04154069684','lat'=>'32.087420847789','level'=>'3','tree'=>'tr_0 tr_510000 tr_511700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511802','title'=>'雨城区','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.03957520533','lat'=>'30.011061644393','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511803','title'=>'名山区','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.1154857938','lat'=>'30.075913663382','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511822','title'=>'荥经县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.85343551293','lat'=>'29.799193512656','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511823','title'=>'汉源县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.65857589024','lat'=>'29.350217385987','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511824','title'=>'石棉县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'102.36640453848','lat'=>'29.23430487759','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511825','title'=>'天全县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'102.76453022767','lat'=>'30.072472953275','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511826','title'=>'芦山县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.93452771831','lat'=>'30.149873189563','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511827','title'=>'宝兴县','pid'=>'511800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'102.82148423429','lat'=>'30.374082112445','level'=>'3','tree'=>'tr_0 tr_510000 tr_511800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511902','title'=>'巴州区','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.77551310771','lat'=>'31.857685602645','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511903','title'=>'恩阳区','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'106.63558190249','lat'=>'31.802614044176','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511921','title'=>'通江县','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.25151684321','lat'=>'31.917714346881','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511922','title'=>'南江县','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.83448345088','lat'=>'32.352531654165','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511923','title'=>'平昌县','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'107.11059310023','lat'=>'31.566185810095','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'511971','title'=>'巴中经济开发区','pid'=>'511900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.75158530316','lat'=>'31.872888585957','level'=>'3','tree'=>'tr_0 tr_510000 tr_511900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'512002','title'=>'雁江区','pid'=>'512000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.65842441063','lat'=>'30.123753456785','level'=>'3','tree'=>'tr_0 tr_510000 tr_512000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'512021','title'=>'安岳县','pid'=>'512000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.34245423273','lat'=>'30.103392734494','level'=>'3','tree'=>'tr_0 tr_510000 tr_512000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'512022','title'=>'乐至县','pid'=>'512000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.02747697007','lat'=>'30.282348346','level'=>'3','tree'=>'tr_0 tr_510000 tr_512000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513201','title'=>'马尔康市','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.21350208208','lat'=>'31.911747955648','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513221','title'=>'汶川县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'103.59651788422','lat'=>'31.483005320468','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513222','title'=>'理县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.23141546175','lat'=>'31.905511577267','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513223','title'=>'茂县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.23141546175','lat'=>'31.905511577267','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513224','title'=>'松潘县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.61057968918','lat'=>'32.661796559853','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513225','title'=>'九寨沟县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.24954673403','lat'=>'33.257591509496','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513226','title'=>'金川县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.07061042122','lat'=>'31.482005950337','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513227','title'=>'小金县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.36942635928','lat'=>'31.002208697062','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513228','title'=>'黑水县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.99651735613','lat'=>'32.067805449368','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513230','title'=>'壤塘县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'100.98558348726','lat'=>'32.271093316269','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513231','title'=>'阿坝县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'101.71360970816','lat'=>'32.908220918625','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513232','title'=>'若尔盖县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'102.97439065413','lat'=>'33.584376654702','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513233','title'=>'红原县','pid'=>'513200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.55061520946','lat'=>'32.796605278762','level'=>'3','tree'=>'tr_0 tr_510000 tr_513200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513301','title'=>'康定市','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'101.96355522139','lat'=>'30.004407384262','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513322','title'=>'泸定县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.24143209631','lat'=>'29.920401664951','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513323','title'=>'丹巴县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'101.89643706759','lat'=>'30.88476979933','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513324','title'=>'九龙县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'101.51341566718','lat'=>'29.006431902925','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513325','title'=>'雅江县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.02050035294','lat'=>'30.037568967864','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513326','title'=>'道孚县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'101.13154034619','lat'=>'30.985326277402','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513327','title'=>'炉霍县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.68239693357','lat'=>'31.397991882882','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513328','title'=>'甘孜县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'99.999210350851','lat'=>'31.628956694034','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513329','title'=>'新龙县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'100.31839824093','lat'=>'30.945469525266','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513330','title'=>'德格县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'98.587401611354','lat'=>'31.812106494713','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513331','title'=>'白玉县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'98.83110021824','lat'=>'31.215314448788','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513332','title'=>'石渠县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'98.109480622408','lat'=>'32.984003420478','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513333','title'=>'色达县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'100.33941364918','lat'=>'32.274330413227','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513334','title'=>'理塘县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.27557457998','lat'=>'30.000030621751','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513335','title'=>'巴塘县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'99.11672669582','lat'=>'30.011661707376','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513336','title'=>'乡城县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'99.805059570922','lat'=>'28.936733475224','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513337','title'=>'稻城县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'100.3044615597','lat'=>'29.043121558126','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513338','title'=>'得荣县','pid'=>'513300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'99.292984198181','lat'=>'28.718780051461','level'=>'3','tree'=>'tr_0 tr_510000 tr_513300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513401','title'=>'西昌市','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.27148382917','lat'=>'27.900580896264','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513422','title'=>'木里藏族自治县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'101.28639697674','lat'=>'27.93459855924','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513423','title'=>'盐源县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.51542912915','lat'=>'27.428154867741','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513424','title'=>'德昌县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'102.18259551085','lat'=>'27.408504192994','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513425','title'=>'会理县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.25143634511','lat'=>'26.661199778427','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513426','title'=>'会东县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.5844621823','lat'=>'26.640823775829','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513427','title'=>'宁南县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'102.76252636654','lat'=>'27.064605070116','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513428','title'=>'普格县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'102.54659671863','lat'=>'27.381996213807','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513429','title'=>'布拖县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'102.818478493','lat'=>'27.7121287338','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513430','title'=>'金阳县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'103.25454895521','lat'=>'27.702144511749','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513431','title'=>'昭觉县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'102.84942278222','lat'=>'28.020506268006','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513432','title'=>'喜德县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.41956715684','lat'=>'28.312709832521','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513433','title'=>'冕宁县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.18357457402','lat'=>'28.55529444536','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513434','title'=>'越西县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.5144744814','lat'=>'28.645827564326','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513435','title'=>'甘洛县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'102.77859651312','lat'=>'28.9648231905','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513436','title'=>'美姑县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.13858579866','lat'=>'28.33401962389','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'513437','title'=>'雷波县','pid'=>'513400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.57842869486','lat'=>'28.268950617624','level'=>'3','tree'=>'tr_0 tr_510000 tr_513400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520102','title'=>'南明区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.72052763544','lat'=>'26.574336181539','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520103','title'=>'云岩区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.73053475882','lat'=>'26.610381076426','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520111','title'=>'花溪区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.6764407773','lat'=>'26.41587945643','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520112','title'=>'乌当区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.75755803432','lat'=>'26.636529135598','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520113','title'=>'白云区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.62959683989','lat'=>'26.683588499124','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520115','title'=>'观山湖区','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'106.60953255751','lat'=>'26.623894296899','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520121','title'=>'开阳县','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'106.97155955928','lat'=>'27.063673573951','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520122','title'=>'息烽县','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.74756178044','lat'=>'27.096475267062','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520123','title'=>'修文县','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.59849220314','lat'=>'26.844862447594','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520181','title'=>'清镇市','pid'=>'520100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.47752261032','lat'=>'26.561987898479','level'=>'3','tree'=>'tr_0 tr_520000 tr_520100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520201','title'=>'钟山区','pid'=>'520200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.85052981696','lat'=>'26.580704079622','level'=>'3','tree'=>'tr_0 tr_520000 tr_520200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520203','title'=>'六枝特区','pid'=>'520200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.48342934686','lat'=>'26.219214290638','level'=>'3','tree'=>'tr_0 tr_520000 tr_520200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520221','title'=>'水城县','pid'=>'520200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'104.96456610819','lat'=>'26.553719763692','level'=>'3','tree'=>'tr_0 tr_520000 tr_520200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520281','title'=>'盘州市','pid'=>'520200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'104.47858183932','lat'=>'25.715651258076','level'=>'3','tree'=>'tr_0 tr_520000 tr_520200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520302','title'=>'红花岗区','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.90049658668','lat'=>'27.650870260732','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520303','title'=>'汇川区','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.94045752761','lat'=>'27.756343380087','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520304','title'=>'播州区','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'106.83650354793','lat'=>'27.542500878','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520322','title'=>'桐梓县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'106.83248902061','lat'=>'28.139468384162','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520323','title'=>'绥阳县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'107.19749228819','lat'=>'27.953080005876','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520324','title'=>'正安县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'107.4605748906','lat'=>'28.55909172878','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520325','title'=>'道真仡佬族苗族自治县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.61948378781','lat'=>'28.86864981438','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520326','title'=>'务川仡佬族苗族自治县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'107.90545629257','lat'=>'28.569077110562','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520327','title'=>'凤冈县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.72354763025','lat'=>'27.960695338965','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520328','title'=>'湄潭县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'107.47259853019','lat'=>'27.75449836496','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520329','title'=>'余庆县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'107.91146020728','lat'=>'27.221379027997','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520330','title'=>'习水县','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.20342803999','lat'=>'28.339117886481','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520381','title'=>'赤水市','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.70348859502','lat'=>'28.596118908733','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520382','title'=>'仁怀市','pid'=>'520300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'106.40752655518','lat'=>'27.797752158543','level'=>'3','tree'=>'tr_0 tr_520000 tr_520300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450702','title'=>'钦南区','pid'=>'450700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.66454861267','lat'=>'21.945972440989','level'=>'3','tree'=>'tr_0 tr_450000 tr_450700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450703','title'=>'钦北区','pid'=>'450700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.63851257493','lat'=>'22.020367050196','level'=>'3','tree'=>'tr_0 tr_450000 tr_450700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450721','title'=>'灵山县','pid'=>'450700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.29747796631','lat'=>'22.422413326701','level'=>'3','tree'=>'tr_0 tr_450000 tr_450700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'450722','title'=>'浦北县','pid'=>'450700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'109.5634229294','lat'=>'22.277822326937','level'=>'3','tree'=>'tr_0 tr_450000 tr_450700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520402','title'=>'西秀区','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.97240632053','lat'=>'26.251497663244','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520403','title'=>'平坝区','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'106.26358378709','lat'=>'26.411186471257','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520422','title'=>'普定县','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'105.74848570614','lat'=>'26.308233451347','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520423','title'=>'镇宁布依族苗族自治县','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.77658344485','lat'=>'26.063829083032','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520424','title'=>'关岭布依族苗族自治县','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'105.62547597168','lat'=>'25.949877045969','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520425','title'=>'紫云苗族布依族自治县','pid'=>'520400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.09041375093','lat'=>'25.757408728958','level'=>'3','tree'=>'tr_0 tr_520000 tr_520400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520502','title'=>'七星关区','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'105.31158071811','lat'=>'27.304095223427','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520521','title'=>'大方县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'105.61845131242','lat'=>'27.147060750626','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520522','title'=>'黔西县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.03857397726','lat'=>'27.014344747084','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520523','title'=>'金沙县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.22644163901','lat'=>'27.465354872614','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520524','title'=>'织金县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.77758954702','lat'=>'26.669221885659','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520525','title'=>'纳雍县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'105.38948662276','lat'=>'26.783717229132','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520526','title'=>'威宁彝族回族苗族自治县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.25948063398','lat'=>'26.879247190553','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520527','title'=>'赫章县','pid'=>'520500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'104.73351582262','lat'=>'27.129051675142','level'=>'3','tree'=>'tr_0 tr_520000 tr_520500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520602','title'=>'碧江区','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.18743536171','lat'=>'27.696773471802','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520603','title'=>'万山区','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.22045617394','lat'=>'27.524647851983','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520621','title'=>'江口县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.84540005924','lat'=>'27.705921695043','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520622','title'=>'玉屏侗族自治县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.920563527','lat'=>'27.248557881456','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520623','title'=>'石阡县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.23046385479','lat'=>'27.519722059758','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520624','title'=>'思南县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.25941731933','lat'=>'27.944547877977','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520625','title'=>'印江土家族苗族自治县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.41659167843','lat'=>'27.999823251993','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520626','title'=>'德江县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'108.1264110615','lat'=>'28.270423278494','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520627','title'=>'沿河土家族自治县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.51047753979','lat'=>'28.570101680095','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'520628','title'=>'松桃苗族自治县','pid'=>'520600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.20940351278','lat'=>'28.160420179011','level'=>'3','tree'=>'tr_0 tr_520000 tr_520600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522301','title'=>'兴义市','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'104.9024609483','lat'=>'25.098113310297','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522302','title'=>'兴仁市','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.19256772452','lat'=>'25.440898753576','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522323','title'=>'普安县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'104.95954583802','lat'=>'25.789951769129','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522324','title'=>'晴隆县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'105.22548361467','lat'=>'25.841047900453','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522325','title'=>'贞丰县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.65655958807','lat'=>'25.392123965341','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522326','title'=>'望谟县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'106.10644455174','lat'=>'25.18435492392','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522327','title'=>'册亨县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.81851050706','lat'=>'24.989637494252','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522328','title'=>'安龙县','pid'=>'522300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'105.44954274777','lat'=>'25.103990431232','level'=>'3','tree'=>'tr_0 tr_520000 tr_522300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522601','title'=>'凯里市','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'107.98944624078','lat'=>'26.589702969826','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522622','title'=>'黄平县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.92354780622','lat'=>'26.911288643101','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522623','title'=>'施秉县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.13043978205','lat'=>'27.039822051733','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522624','title'=>'三穗县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.68154500207','lat'=>'26.958666465246','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522625','title'=>'镇远县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.43658077263','lat'=>'27.054820913901','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522626','title'=>'岑巩县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'108.82248096196','lat'=>'27.179902417394','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522627','title'=>'天柱县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'109.21444570161','lat'=>'26.915804084012','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522628','title'=>'锦屏县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'109.20743846948','lat'=>'26.682631631865','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522629','title'=>'剑河县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.44751710323','lat'=>'26.734047558881','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522630','title'=>'台江县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'108.32855163','lat'=>'26.672372539643','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522631','title'=>'黎平县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.14356697147','lat'=>'26.236874050192','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522632','title'=>'榕江县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'108.52755369872','lat'=>'25.93772537325','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522633','title'=>'从江县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'108.91156142782','lat'=>'25.759881327892','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522634','title'=>'雷山县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.08452891457','lat'=>'26.384205121689','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522635','title'=>'麻江县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'107.59555140191','lat'=>'26.496807595584','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522636','title'=>'丹寨县','pid'=>'522600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.79551348972','lat'=>'26.204421169869','level'=>'3','tree'=>'tr_0 tr_520000 tr_522600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522701','title'=>'都匀市','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.52540443144','lat'=>'26.266117957789','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522702','title'=>'福泉市','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.52643281158','lat'=>'26.692525700784','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522722','title'=>'荔波县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.89340938687','lat'=>'25.417097566273','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522723','title'=>'贵定县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'107.2405543594','lat'=>'26.590659655039','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522725','title'=>'瓮安县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'107.47755223592','lat'=>'27.084125602602','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522726','title'=>'独山县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.55149778107','lat'=>'25.828287807074','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522727','title'=>'平塘县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'107.32956664388','lat'=>'25.828201706902','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522728','title'=>'罗甸县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.75854805682','lat'=>'25.430837682972','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522729','title'=>'长顺县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.45842122163','lat'=>'26.028454545714','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522730','title'=>'龙里县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.98658596469','lat'=>'26.459080630642','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522731','title'=>'惠水县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.66345262709','lat'=>'26.138209889396','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'522732','title'=>'三都水族自治县','pid'=>'522700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'107.84263500353','lat'=>'26.096765617985','level'=>'3','tree'=>'tr_0 tr_520000 tr_522700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530102','title'=>'五华区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'102.7134232806','lat'=>'25.049834961981','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530103','title'=>'盘龙区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'102.7585262121','lat'=>'25.12237227983','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530111','title'=>'官渡区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'102.7504817066','lat'=>'25.021196423859','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530112','title'=>'西山区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.6715571235','lat'=>'25.043198760947','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530113','title'=>'东川区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.19445186746','lat'=>'26.089054237623','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530114','title'=>'呈贡区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'102.82747259726','lat'=>'24.891871210947','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530115','title'=>'晋宁区','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.60241805181','lat'=>'24.676098812517','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530124','title'=>'富民县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'102.50447319701','lat'=>'25.228085092195','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530125','title'=>'宜良县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.14755798426','lat'=>'24.925286989652','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530126','title'=>'石林彝族自治县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.29650817676','lat'=>'24.77770196132','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530127','title'=>'嵩明县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.04356394016','lat'=>'25.344409459135','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530128','title'=>'禄劝彝族苗族自治县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.47742324184','lat'=>'25.55767180024','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530129','title'=>'寻甸回族彝族自治县','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'103.26357387135','lat'=>'25.563893580433','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530181','title'=>'安宁市','pid'=>'530100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'102.48440918413','lat'=>'24.925601726344','level'=>'3','tree'=>'tr_0 tr_530000 tr_530100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530302','title'=>'麒麟区','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'103.81143036949','lat'=>'25.502101828437','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530303','title'=>'沾益区','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'103.82848532841','lat'=>'25.606630798868','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530304','title'=>'马龙区','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.58544688632','lat'=>'25.433966374816','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530322','title'=>'陆良县','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.67343249743','lat'=>'25.035639470439','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530323','title'=>'师宗县','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.99155634453','lat'=>'24.827994969501','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530324','title'=>'罗平县','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.31551019438','lat'=>'24.890519724895','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530325','title'=>'富源县','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'104.2614742434','lat'=>'25.680279502133','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530326','title'=>'会泽县','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'103.30348729192','lat'=>'26.424215045561','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530381','title'=>'宣威市','pid'=>'530300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'104.1115760691','lat'=>'26.225598378324','level'=>'3','tree'=>'tr_0 tr_530000 tr_530300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530402','title'=>'红塔区','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.55156461759','lat'=>'24.359801443673','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530403','title'=>'江川区','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.76052700796','lat'=>'24.293438700984','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530422','title'=>'澄江县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'102.91455487235','lat'=>'24.679414908816','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530423','title'=>'通海县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'102.73242289128','lat'=>'24.117891201574','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530424','title'=>'华宁县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.93549185853','lat'=>'24.198581027163','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530425','title'=>'易门县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.1695354962','lat'=>'24.677404477592','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530426','title'=>'峨山彝族自治县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'102.41256450607','lat'=>'24.174774239093','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530427','title'=>'新平彝族傣族自治县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'101.99642771261','lat'=>'24.076262705278','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530428','title'=>'元江哈尼族彝族傣族自治县','pid'=>'530400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.00441463673','lat'=>'23.603000905475','level'=>'3','tree'=>'tr_0 tr_530000 tr_530400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530502','title'=>'隆阳区','pid'=>'530500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'99.172070839289','lat'=>'25.12688832219','level'=>'3','tree'=>'tr_0 tr_530000 tr_530500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530521','title'=>'施甸县','pid'=>'530500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'99.195469362222','lat'=>'24.728835000146','level'=>'3','tree'=>'tr_0 tr_530000 tr_530500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530523','title'=>'龙陵县','pid'=>'530500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'98.695749912275','lat'=>'24.592546947017','level'=>'3','tree'=>'tr_0 tr_530000 tr_530500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530524','title'=>'昌宁县','pid'=>'530500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'99.611616576026','lat'=>'24.833984919853','level'=>'3','tree'=>'tr_0 tr_530000 tr_530500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530581','title'=>'腾冲市','pid'=>'530500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'98.497595035489','lat'=>'25.026616860346','level'=>'3','tree'=>'tr_0 tr_530000 tr_530500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530602','title'=>'昭阳区','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'103.71347042315','lat'=>'27.326144206053','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530621','title'=>'鲁甸县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.5644121645','lat'=>'27.193107219133','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530622','title'=>'巧家县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'102.93651934037','lat'=>'26.914705038577','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530623','title'=>'盐津县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.24157884246','lat'=>'28.114384038516','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530624','title'=>'大关县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.89751489665','lat'=>'27.754021401911','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530625','title'=>'永善县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.6445690431','lat'=>'28.234722481383','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530626','title'=>'绥江县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'103.9645523826','lat'=>'28.604277931727','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530627','title'=>'镇雄县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.88040422431','lat'=>'27.447794634649','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530628','title'=>'彝良县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.05444303021','lat'=>'27.631690165547','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530629','title'=>'威信县','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'105.05557676311','lat'=>'27.85253746404','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530681','title'=>'水富市','pid'=>'530600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'104.42243298394','lat'=>'28.636106975262','level'=>'3','tree'=>'tr_0 tr_530000 tr_530600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530702','title'=>'古城区','pid'=>'530700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.23248033921','lat'=>'26.883161684001','level'=>'3','tree'=>'tr_0 tr_530000 tr_530700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530721','title'=>'玉龙纳西族自治县','pid'=>'530700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'100.24352734105','lat'=>'26.827391803625','level'=>'3','tree'=>'tr_0 tr_530000 tr_530700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530722','title'=>'永胜县','pid'=>'530700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'100.75758141133','lat'=>'26.689950245419','level'=>'3','tree'=>'tr_0 tr_530000 tr_530700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530723','title'=>'华坪县','pid'=>'530700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.27243012268','lat'=>'26.635223014622','level'=>'3','tree'=>'tr_0 tr_530000 tr_530700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530724','title'=>'宁蒗彝族自治县','pid'=>'530700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'100.85859038623','lat'=>'27.287727826052','level'=>'3','tree'=>'tr_0 tr_530000 tr_530700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530802','title'=>'思茅区','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'100.98355510298','lat'=>'22.79249798436','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530821','title'=>'宁洱哈尼族彝族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'101.05244246946','lat'=>'23.054590179481','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530822','title'=>'墨江哈尼族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'101.69858356155','lat'=>'23.437725772256','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530823','title'=>'景东彝族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'100.83848864452','lat'=>'24.451863775495','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530824','title'=>'景谷傣族彝族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'100.7094565801','lat'=>'23.503204071241','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530825','title'=>'镇沅彝族哈尼族拉祜族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'101.11556882305','lat'=>'24.010330833613','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530826','title'=>'江城哈尼族彝族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'101.86847918429','lat'=>'22.59168385943','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530827','title'=>'孟连傣族拉祜族佤族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'99.590962825578','lat'=>'22.335307615556','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530828','title'=>'澜沧拉祜族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'99.938588283239','lat'=>'22.561831918087','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530829','title'=>'西盟佤族自治县','pid'=>'530800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'99.596622150289','lat'=>'22.650656010974','level'=>'3','tree'=>'tr_0 tr_530000 tr_530800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530902','title'=>'临翔区','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.0884425304','lat'=>'23.901401938645','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530921','title'=>'凤庆县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'99.934989222215','lat'=>'24.586472458274','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530922','title'=>'云县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'100.12953102441','lat'=>'24.442807275329','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530923','title'=>'永德县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'99.265075642606','lat'=>'24.024871282777','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530924','title'=>'镇康县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'98.831871224123','lat'=>'23.768315480096','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530925','title'=>'双江拉祜族佤族布朗族傣族自治县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'99.834130982979','lat'=>'23.479836504614','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530926','title'=>'耿马傣族佤族自治县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'99.403942176092','lat'=>'23.543490995101','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'530927','title'=>'沧源佤族自治县','pid'=>'530900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'99.252721696084','lat'=>'23.152878733913','level'=>'3','tree'=>'tr_0 tr_530000 tr_530900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532301','title'=>'楚雄市','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.55247228396','lat'=>'25.038860388323','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532322','title'=>'双柏县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'101.64840700053','lat'=>'24.694898530382','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532323','title'=>'牟定县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'101.55348099122','lat'=>'25.318845903714','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532324','title'=>'南华县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'101.28042055018','lat'=>'25.198587071156','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532325','title'=>'姚安县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.2485272012','lat'=>'25.509775443473','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532326','title'=>'大姚县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'101.33056746713','lat'=>'25.727600600572','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532327','title'=>'永仁县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.67249299667','lat'=>'26.055565754521','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532328','title'=>'元谋县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.8804452425','lat'=>'25.710895319939','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532329','title'=>'武定县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'102.41053182037','lat'=>'25.536089587807','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532331','title'=>'禄丰县','pid'=>'532300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.08553135476','lat'=>'25.155830804806','level'=>'3','tree'=>'tr_0 tr_530000 tr_532300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532501','title'=>'个旧市','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'103.16651860849','lat'=>'23.364941534583','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532502','title'=>'开远市','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'103.27355323709','lat'=>'23.719907796912','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532503','title'=>'蒙自市','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.37154588175','lat'=>'23.402079885198','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532504','title'=>'弥勒市','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.421489063','lat'=>'24.417982225357','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532523','title'=>'屏边苗族自治县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'103.69343183232','lat'=>'22.989989585513','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532524','title'=>'建水县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.83343959161','lat'=>'23.640938563461','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532525','title'=>'石屏县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'102.50244661978','lat'=>'23.712004452449','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532527','title'=>'泸西县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.77252314092','lat'=>'24.53803716745','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532528','title'=>'元阳县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'102.84143280386','lat'=>'23.226198051926','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532529','title'=>'红河县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.42755057757','lat'=>'23.374488738365','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532530','title'=>'金平苗族瑶族傣族自治县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'103.23246860579','lat'=>'22.785560606183','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532531','title'=>'绿春县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.39849398755','lat'=>'23.000164936586','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532532','title'=>'河口瑶族自治县','pid'=>'532500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'103.9454436278','lat'=>'22.535465602947','level'=>'3','tree'=>'tr_0 tr_530000 tr_532500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532601','title'=>'文山市','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.23854382746','lat'=>'23.391944131908','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532622','title'=>'砚山县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.3435508907','lat'=>'23.6114865767','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532623','title'=>'西畴县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'104.67852542203','lat'=>'23.443271275283','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532624','title'=>'麻栗坡县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'104.70954948078','lat'=>'23.13158558356','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532625','title'=>'马关县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'104.40041497692','lat'=>'23.018993577166','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532626','title'=>'丘北县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'104.17344174074','lat'=>'24.056993896218','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532627','title'=>'广南县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'105.06158238459','lat'=>'24.052198510921','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532628','title'=>'富宁县','pid'=>'532600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'105.63749017905','lat'=>'23.63138040952','level'=>'3','tree'=>'tr_0 tr_530000 tr_532600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532801','title'=>'景洪市','pid'=>'532800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'100.80644312258','lat'=>'22.017004423119','level'=>'3','tree'=>'tr_0 tr_530000 tr_532800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532822','title'=>'勐海县','pid'=>'532800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'100.4594459398','lat'=>'21.963433596681','level'=>'3','tree'=>'tr_0 tr_530000 tr_532800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532823','title'=>'勐腊县','pid'=>'532800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'101.57152830823','lat'=>'21.465280880862','level'=>'3','tree'=>'tr_0 tr_530000 tr_532800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532901','title'=>'大理市','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'100.23651930044','lat'=>'25.597604905452','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532922','title'=>'漾濞彝族自治县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'99.964413758168','lat'=>'25.676295762972','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532923','title'=>'祥云县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'100.55744657937','lat'=>'25.489872506242','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532924','title'=>'宾川县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'100.57845668762','lat'=>'25.835249028198','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532925','title'=>'弥渡县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'100.49758601546','lat'=>'25.349336028746','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532926','title'=>'南涧彝族自治县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'100.51554862227','lat'=>'25.049426762094','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532927','title'=>'巍山彝族回族自治县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'100.31346033515','lat'=>'25.233438729799','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532928','title'=>'永平县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'99.547494899931','lat'=>'25.4702064833','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532929','title'=>'云龙县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'99.377416022867','lat'=>'25.891945073902','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532930','title'=>'洱源县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'99.969209721453','lat'=>'26.120093341888','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532931','title'=>'剑川县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'99.912091235112','lat'=>'26.542516534181','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'532932','title'=>'鹤庆县','pid'=>'532900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'100.18249206302','lat'=>'26.566197313345','level'=>'3','tree'=>'tr_0 tr_530000 tr_532900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533102','title'=>'瑞丽市','pid'=>'533100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'97.862485584208','lat'=>'24.022816893105','level'=>'3','tree'=>'tr_0 tr_530000 tr_533100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533103','title'=>'芒市','pid'=>'533100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'98.591359356114','lat'=>'24.438010702758','level'=>'3','tree'=>'tr_0 tr_530000 tr_533100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533122','title'=>'梁河县','pid'=>'533100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'98.303133631636','lat'=>'24.810784458257','level'=>'3','tree'=>'tr_0 tr_530000 tr_533100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533123','title'=>'盈江县','pid'=>'533100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'97.938426535386','lat'=>'24.711534266143','level'=>'3','tree'=>'tr_0 tr_530000 tr_533100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533124','title'=>'陇川县','pid'=>'533100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'97.798530364124','lat'=>'24.189467890549','level'=>'3','tree'=>'tr_0 tr_530000 tr_533100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533301','title'=>'泸水市','pid'=>'533300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'98.864586163328','lat'=>'25.829026769972','level'=>'3','tree'=>'tr_0 tr_530000 tr_533300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533323','title'=>'福贡县','pid'=>'533300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'98.875649424493','lat'=>'26.908055208498','level'=>'3','tree'=>'tr_0 tr_530000 tr_533300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533324','title'=>'贡山独龙族怒族自治县','pid'=>'533300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'98.672399448687','lat'=>'27.747067875272','level'=>'3','tree'=>'tr_0 tr_530000 tr_533300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533325','title'=>'兰坪白族普米族自治县','pid'=>'533300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'99.423284669988','lat'=>'26.459207904688','level'=>'3','tree'=>'tr_0 tr_530000 tr_533300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533401','title'=>'香格里拉市','pid'=>'533400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'99.707444573899','lat'=>'27.835760125321','level'=>'3','tree'=>'tr_0 tr_530000 tr_533400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533422','title'=>'德钦县','pid'=>'533400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'98.924452656054','lat'=>'28.470086006822','level'=>'3','tree'=>'tr_0 tr_530000 tr_533400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'533423','title'=>'维西傈僳族自治县','pid'=>'533400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'99.293465689934','lat'=>'27.183170204022','level'=>'3','tree'=>'tr_0 tr_530000 tr_533400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540102','title'=>'城关区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'91.145100352371','lat'=>'29.658331252915','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540103','title'=>'堆龙德庆区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'91.009963134209','lat'=>'29.651625675009','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540104','title'=>'达孜区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'91.356318118388','lat'=>'29.675409063815','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540121','title'=>'林周县','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'91.26950057393','lat'=>'29.898733205887','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540122','title'=>'当雄县','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'91.107451746831','lat'=>'30.479221726942','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540123','title'=>'尼木县','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'90.171180066243','lat'=>'29.437518981255','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540124','title'=>'曲水县','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'90.749958665453','lat'=>'29.358987058337','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540127','title'=>'墨竹工卡县','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'91.737266398592','lat'=>'29.839752605055','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540171','title'=>'格尔木藏青工业园区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'91.120823915464','lat'=>'29.650040274768','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540172','title'=>'拉萨经济技术开发区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'91.120823915464','lat'=>'29.650040274768','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540173','title'=>'西藏文化旅游创意园区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'91.120823915464','lat'=>'29.650040274768','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540174','title'=>'达孜工业园区','pid'=>'540100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'91.356318118388','lat'=>'29.675409063815','level'=>'3','tree'=>'tr_0 tr_540000 tr_540100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540202','title'=>'桑珠孜区','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'88.902951718862','lat'=>'29.255582814198','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540221','title'=>'南木林县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'89.105704213077','lat'=>'29.687938036552','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540222','title'=>'江孜县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'89.612012194954','lat'=>'28.917634684239','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540223','title'=>'定日县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'87.129597739314','lat'=>'28.663951983289','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540224','title'=>'萨迦县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'88.028269488152','lat'=>'28.90493151262','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540225','title'=>'拉孜县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'87.643647318074','lat'=>'29.087509679995','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540226','title'=>'昂仁县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'87.242427336755','lat'=>'29.301060484014','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540227','title'=>'谢通门县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'88.268206799957','lat'=>'29.438142414132','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540228','title'=>'白朗县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'89.268741991895','lat'=>'29.111858951918','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540229','title'=>'仁布县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'89.848624967899','lat'=>'29.236788327037','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540230','title'=>'康马县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'89.688244915761','lat'=>'28.561443952501','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540231','title'=>'定结县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'87.772376743375','lat'=>'28.369910769393','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540232','title'=>'仲巴县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'84.038116876917','lat'=>'29.775982232026','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540233','title'=>'亚东县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'88.913440783145','lat'=>'27.491108780091','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540234','title'=>'吉隆县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'85.304073768987','lat'=>'28.858501664955','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540235','title'=>'聂拉木县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'85.988770403046','lat'=>'28.160839360543','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540236','title'=>'萨嘎县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'85.239825701307','lat'=>'29.334659688784','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540237','title'=>'岗巴县','pid'=>'540200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'88.526529281476','lat'=>'28.28036304226','level'=>'3','tree'=>'tr_0 tr_540000 tr_540200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540302','title'=>'卡若区','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'97.186654336416','lat'=>'31.144248893947','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540321','title'=>'江达县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'98.224594520968','lat'=>'31.50520701798','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540322','title'=>'贡觉县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'98.277334127289','lat'=>'30.865966958412','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540323','title'=>'类乌齐县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'96.606717192399','lat'=>'31.217793112281','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540324','title'=>'丁青县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'95.602643844218','lat'=>'31.418402964614','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540325','title'=>'察雅县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'97.575123679628','lat'=>'30.659864699371','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540326','title'=>'八宿县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'96.924360446152','lat'=>'30.059028991399','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540327','title'=>'左贡县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'97.847366832989','lat'=>'29.676848537197','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540328','title'=>'芒康县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'98.599685480392','lat'=>'29.685776117713','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540329','title'=>'洛隆县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'95.831306613477','lat'=>'30.747126507478','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540330','title'=>'边坝县','pid'=>'540300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'94.714371149159','lat'=>'30.939624927347','level'=>'3','tree'=>'tr_0 tr_540000 tr_540300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540402','title'=>'巴宜区','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'94.36754427672','lat'=>'29.641644546372','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540421','title'=>'工布江达县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'93.252419796678','lat'=>'29.891367616241','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540422','title'=>'米林县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'94.219938578083','lat'=>'29.220916541197','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540423','title'=>'墨脱县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'95.33949529751','lat'=>'29.330937701878','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540424','title'=>'波密县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'95.773900121645','lat'=>'29.865060090549','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540425','title'=>'察隅县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'97.473269749246','lat'=>'28.667444137201','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540426','title'=>'朗县','pid'=>'540400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'93.081368234407','lat'=>'29.051902419086','level'=>'3','tree'=>'tr_0 tr_540000 tr_540400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540602','title'=>'色尼区','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'92.05984683665','lat'=>'31.476117292678','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540621','title'=>'嘉黎县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'93.23873151504','lat'=>'30.647062455597','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540622','title'=>'比如县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'93.685965938612','lat'=>'31.48635726205','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540623','title'=>'聂荣县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'92.308654466293','lat'=>'32.113707483115','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540624','title'=>'安多县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'91.688890677999','lat'=>'32.271268023108','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540625','title'=>'申扎县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'88.716481108234','lat'=>'30.936393285832','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540626','title'=>'索县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'93.792172958379','lat'=>'31.892424309227','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540627','title'=>'班戈县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'90.016707727114','lat'=>'31.398727622963','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540628','title'=>'巴青县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'94.059881564766','lat'=>'31.924549424276','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540629','title'=>'尼玛县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'87.243292410868','lat'=>'31.790953326638','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540630','title'=>'双湖县','pid'=>'540600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'88.843427936123','lat'=>'33.193503165809','level'=>'3','tree'=>'tr_0 tr_540000 tr_540600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542521','title'=>'普兰县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'81.183094731974','lat'=>'30.300162591078','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542522','title'=>'札达县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'79.809323212178','lat'=>'31.485343070014','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542523','title'=>'噶尔县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'80.102877146054','lat'=>'32.497156823602','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542524','title'=>'日土县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'79.739109138263','lat'=>'33.387186043872','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542525','title'=>'革吉县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'81.151664369638','lat'=>'32.393356020044','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542526','title'=>'改则县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'84.06911336254','lat'=>'32.308356643244','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'542527','title'=>'措勤县','pid'=>'542500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'85.165952205481','lat'=>'31.022666379273','level'=>'3','tree'=>'tr_0 tr_540000 tr_542500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610102','title'=>'新城区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.9673910385','lat'=>'34.272724469533','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610103','title'=>'碑林区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'108.94049774781','lat'=>'34.236473940412','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610104','title'=>'莲湖区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.95042644912','lat'=>'34.271017203053','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610111','title'=>'灞桥区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.07141535554','lat'=>'34.279127674951','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610112','title'=>'未央区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.95340118781','lat'=>'34.299148106589','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610113','title'=>'雁塔区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.95144045638','lat'=>'34.220635239986','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610114','title'=>'阎良区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.23246311822','lat'=>'34.668363274699','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610115','title'=>'临潼区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.22043579558','lat'=>'34.372747432848','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610116','title'=>'长安区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.91358047235','lat'=>'34.163290267305','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610117','title'=>'高陵区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.09438691387','lat'=>'34.541093106058','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610118','title'=>'鄠邑区','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.61142023271','lat'=>'34.115020711599','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610122','title'=>'蓝田县','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.32938812681','lat'=>'34.157620654732','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610124','title'=>'周至县','pid'=>'610100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.22842183954','lat'=>'34.169385269616','level'=>'3','tree'=>'tr_0 tr_610000 tr_610100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610202','title'=>'王益区','pid'=>'610200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'109.08141735858','lat'=>'35.075322096471','level'=>'3','tree'=>'tr_0 tr_610000 tr_610200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610203','title'=>'印台区','pid'=>'610200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.10643408907','lat'=>'35.120859282945','level'=>'3','tree'=>'tr_0 tr_610000 tr_610200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610204','title'=>'耀州区','pid'=>'610200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.98643790006','lat'=>'34.91596030911','level'=>'3','tree'=>'tr_0 tr_610000 tr_610200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610222','title'=>'宜君县','pid'=>'610200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.12353674801','lat'=>'35.404582194219','level'=>'3','tree'=>'tr_0 tr_610000 tr_610200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610302','title'=>'渭滨区','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'107.15641916768','lat'=>'34.377481132682','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610303','title'=>'金台区','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'107.15342367813','lat'=>'34.382351084696','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610304','title'=>'陈仓区','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'107.39343842395','lat'=>'34.360756335457','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610322','title'=>'凤翔县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.40737949665','lat'=>'34.527616279899','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610323','title'=>'岐山县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.62744727879','lat'=>'34.449776962387','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610324','title'=>'扶风县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.9064530651','lat'=>'34.381463351226','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610326','title'=>'眉县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'107.75639813644','lat'=>'34.280375863086','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610327','title'=>'陇县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.87058365441','lat'=>'34.898780253107','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610328','title'=>'千阳县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.13946616644','lat'=>'34.648544600794','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610329','title'=>'麟游县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.799514106','lat'=>'34.683748667164','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610330','title'=>'凤县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'106.52255782187','lat'=>'33.916583016343','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610331','title'=>'太白县','pid'=>'610300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'107.32552913248','lat'=>'34.064248441153','level'=>'3','tree'=>'tr_0 tr_610000 tr_610300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610402','title'=>'秦都区','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'108.71243199239','lat'=>'34.3351451161','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610403','title'=>'杨陵区','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.09151531881','lat'=>'34.278012507654','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610404','title'=>'渭城区','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.74345057148','lat'=>'34.368110229368','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610422','title'=>'三原县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.94744650025','lat'=>'34.623078955252','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610423','title'=>'泾阳县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.84937884705','lat'=>'34.533316532768','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610424','title'=>'乾县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'108.24537762554','lat'=>'34.534018266142','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610425','title'=>'礼泉县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.43161549166','lat'=>'34.487390768504','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610426','title'=>'永寿县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'108.14846878644','lat'=>'34.698035535617','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610428','title'=>'长武县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'107.80556078005','lat'=>'35.211657338715','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610429','title'=>'旬邑县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.34046703665','lat'=>'35.117963919719','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610430','title'=>'淳化县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'108.58744176373','lat'=>'34.804776911295','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610431','title'=>'武功县','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.20655106479','lat'=>'34.266137667633','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610481','title'=>'兴平市','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'108.49639400877','lat'=>'34.305476520292','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610482','title'=>'彬州市','pid'=>'610400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'108.08456557823','lat'=>'35.049610571828','level'=>'3','tree'=>'tr_0 tr_610000 tr_610400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610502','title'=>'临渭区','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.4985962764','lat'=>'34.504000470428','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610503','title'=>'华州区','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.7784773716','lat'=>'34.5187307401','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610522','title'=>'潼关县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'110.25250761972','lat'=>'34.550326848532','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610523','title'=>'大荔县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'109.94845330291','lat'=>'34.801832760484','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610524','title'=>'合阳县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.15539621274','lat'=>'35.243872196866','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610525','title'=>'澄城县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'109.93843360325','lat'=>'35.196572815551','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610526','title'=>'蒲城县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'109.59249651068','lat'=>'34.961274128783','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610527','title'=>'白水县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.59752055374','lat'=>'35.183287514613','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610528','title'=>'富平县','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'109.18643744728','lat'=>'34.757260440256','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610581','title'=>'韩城市','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.44955264012','lat'=>'35.482086787313','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610582','title'=>'华阴市','pid'=>'610500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'110.09860075704','lat'=>'34.571800158753','level'=>'3','tree'=>'tr_0 tr_610000 tr_610500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610602','title'=>'宝塔区','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'109.49959402433','lat'=>'36.596890441313','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610603','title'=>'安塞区','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'109.33541943984','lat'=>'36.870098259307','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610621','title'=>'延长县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.01847172589','lat'=>'36.585328801705','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610622','title'=>'延川县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.20054028665','lat'=>'36.884136960993','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610623','title'=>'子长县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.68138985954','lat'=>'37.148816918367','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610625','title'=>'志丹县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.77557747991','lat'=>'36.828021135864','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610626','title'=>'吴起县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'108.18258966361','lat'=>'36.932576099483','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610627','title'=>'甘泉县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'109.35752350454','lat'=>'36.282688619053','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610628','title'=>'富县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'109.38659653355','lat'=>'35.993367977969','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610629','title'=>'洛川县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'109.43840396825','lat'=>'35.768300429421','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610630','title'=>'宜川县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'110.17541306458','lat'=>'36.056397437854','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610631','title'=>'黄龙县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.84654907671','lat'=>'35.590233768069','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610632','title'=>'黄陵县','pid'=>'610600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.26960598495','lat'=>'35.585076348969','level'=>'3','tree'=>'tr_0 tr_610000 tr_610600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610702','title'=>'汉台区','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.03840167622','lat'=>'33.074191093099','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610703','title'=>'南郑区','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.94243318334','lat'=>'33.005614599734','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610722','title'=>'城固县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'107.3406125803','lat'=>'33.162399385178','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610723','title'=>'洋县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'107.55246428058','lat'=>'33.228862589315','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610724','title'=>'西乡县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'107.77339281906','lat'=>'32.989397441895','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610725','title'=>'勉县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'106.67942594867','lat'=>'33.159804746955','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610726','title'=>'宁强县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'106.26458864382','lat'=>'32.835380199209','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610727','title'=>'略阳县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.16354400616','lat'=>'33.333193777733','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610728','title'=>'镇巴县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'107.9014456407','lat'=>'32.54283336567','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610729','title'=>'留坝县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.92741441352','lat'=>'33.623825216737','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610730','title'=>'佛坪县','pid'=>'610700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'107.99742428443','lat'=>'33.530693101588','level'=>'3','tree'=>'tr_0 tr_610000 tr_610700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610802','title'=>'榆阳区','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'109.72755916953','lat'=>'38.28241962673','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610803','title'=>'横山区','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.30049134534','lat'=>'37.968573394166','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610822','title'=>'府谷县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'111.0736281152','lat'=>'39.03379562985','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610824','title'=>'靖边县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'108.80060049853','lat'=>'37.605063193955','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610825','title'=>'定边县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'107.60756957446','lat'=>'37.600459865341','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610826','title'=>'绥德县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.26942648536','lat'=>'37.508907288933','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610827','title'=>'米脂县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'110.19045141747','lat'=>'37.761397514329','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610828','title'=>'佳县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'110.49747741874','lat'=>'38.025611678572','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610829','title'=>'吴堡县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'110.74645500778','lat'=>'37.458269874078','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610830','title'=>'清涧县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'110.12755916227','lat'=>'37.094852887828','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610831','title'=>'子洲县','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'110.04239845247','lat'=>'37.617025887547','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610881','title'=>'神木市','pid'=>'610800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.50542966826','lat'=>'38.848544495221','level'=>'3','tree'=>'tr_0 tr_610000 tr_610800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610902','title'=>'汉滨区','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'109.03359606476','lat'=>'32.701196105738','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610921','title'=>'汉阴县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.51550698561','lat'=>'32.899120857292','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610922','title'=>'石泉县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'108.25442679592','lat'=>'33.044602110263','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610923','title'=>'宁陕县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'108.32056400011','lat'=>'33.316555486503','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610924','title'=>'紫阳县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.54159431661','lat'=>'32.525785619364','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610925','title'=>'岚皋县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'108.90861535814','lat'=>'32.312880776501','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610926','title'=>'平利县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'109.36854670128','lat'=>'32.394804123185','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610927','title'=>'镇坪县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.53349679292','lat'=>'31.889643295791','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610928','title'=>'旬阳县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'109.37155674338','lat'=>'32.839864221772','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'610929','title'=>'白河县','pid'=>'610900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'110.11958688053','lat'=>'32.814846485284','level'=>'3','tree'=>'tr_0 tr_610000 tr_610900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611002','title'=>'商州区','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.94747163465','lat'=>'33.86885529308','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611021','title'=>'洛南县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'110.15442748007','lat'=>'34.097070538846','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611022','title'=>'丹凤县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'110.3335602886','lat'=>'33.701537322921','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611023','title'=>'商南县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'110.88840847837','lat'=>'33.537533476707','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611024','title'=>'山阳县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'109.88854863218','lat'=>'33.537968382769','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611025','title'=>'镇安县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.15957460914','lat'=>'33.429044650147','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'611026','title'=>'柞水县','pid'=>'611000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'109.120502272','lat'=>'33.692026241945','level'=>'3','tree'=>'tr_0 tr_610000 tr_611000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620102','title'=>'城关区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'103.83147490053','lat'=>'36.063181475369','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620103','title'=>'七里河区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'103.79241388204','lat'=>'36.07212925843','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620104','title'=>'西固区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'103.63458007682','lat'=>'36.094109365757','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620105','title'=>'安宁区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'103.72553503682','lat'=>'36.109753754973','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620111','title'=>'红古区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.86542781272','lat'=>'36.351863423179','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620121','title'=>'永登县','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.26662443823','lat'=>'36.74209521344','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620122','title'=>'皋兰县','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'103.95346415997','lat'=>'36.338142148673','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620123','title'=>'榆中县','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'104.11956587928','lat'=>'35.848851048242','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620171','title'=>'兰州新区','pid'=>'620100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.76383312444','lat'=>'36.082833434467','level'=>'3','tree'=>'tr_0 tr_620000 tr_620100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620201','title'=>'市辖区','pid'=>'620200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'98.208045429791','lat'=>'39.821463455258','level'=>'3','tree'=>'tr_0 tr_620000 tr_620200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620302','title'=>'金川区','pid'=>'620300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.20058588614','lat'=>'38.525772245594','level'=>'3','tree'=>'tr_0 tr_620000 tr_620300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620321','title'=>'永昌县','pid'=>'620300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'101.97946358316','lat'=>'38.252940956889','level'=>'3','tree'=>'tr_0 tr_620000 tr_620300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620402','title'=>'白银区','pid'=>'620400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'104.15541276065','lat'=>'36.541463568069','level'=>'3','tree'=>'tr_0 tr_620000 tr_620400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620403','title'=>'平川区','pid'=>'620400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'104.83161394007','lat'=>'36.733498751869','level'=>'3','tree'=>'tr_0 tr_620000 tr_620400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620421','title'=>'靖远县','pid'=>'620400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.68251507796','lat'=>'36.577096288837','level'=>'3','tree'=>'tr_0 tr_620000 tr_620400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620422','title'=>'会宁县','pid'=>'620400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'105.05960693274','lat'=>'35.698508053094','level'=>'3','tree'=>'tr_0 tr_620000 tr_620400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620423','title'=>'景泰县','pid'=>'620400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'104.06944438436','lat'=>'37.187406260097','level'=>'3','tree'=>'tr_0 tr_620000 tr_620400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620502','title'=>'秦州区','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'105.73041549435','lat'=>'34.587315743121','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620503','title'=>'麦积区','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'105.89559698949','lat'=>'34.576336861448','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620521','title'=>'清水县','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.14359506621','lat'=>'34.753882906363','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620522','title'=>'秦安县','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'105.68157480343','lat'=>'34.864876111568','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620523','title'=>'甘谷县','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'105.34247534291','lat'=>'34.738300137398','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620524','title'=>'武山县','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.89742838309','lat'=>'34.727669101635','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620525','title'=>'张家川回族自治县','pid'=>'620500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.21139036271','lat'=>'34.99490501302','level'=>'3','tree'=>'tr_0 tr_620000 tr_620500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620602','title'=>'凉州区','pid'=>'620600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.64857479651','lat'=>'37.934121948376','level'=>'3','tree'=>'tr_0 tr_620000 tr_620600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620621','title'=>'民勤县','pid'=>'620600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'103.10040027988','lat'=>'38.630624826433','level'=>'3','tree'=>'tr_0 tr_620000 tr_620600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620622','title'=>'古浪县','pid'=>'620600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'102.90362978165','lat'=>'37.475801906601','level'=>'3','tree'=>'tr_0 tr_620000 tr_620600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620623','title'=>'天祝藏族自治县','pid'=>'620600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'103.14862131966','lat'=>'36.97759617654','level'=>'3','tree'=>'tr_0 tr_620000 tr_620600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620702','title'=>'甘州区','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.48455772128','lat'=>'38.934781471785','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620721','title'=>'肃南裕固族自治县','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'99.621905418008','lat'=>'38.843100205023','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620722','title'=>'民乐县','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'100.81942903742','lat'=>'38.436842233981','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620723','title'=>'临泽县','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'100.17055476077','lat'=>'39.158514444726','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620724','title'=>'高台县','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'99.825759504337','lat'=>'39.383646046807','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620725','title'=>'山丹县','pid'=>'620700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'101.09561558172','lat'=>'38.790452663306','level'=>'3','tree'=>'tr_0 tr_620000 tr_620700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620802','title'=>'崆峒区','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'106.68141452757','lat'=>'35.548814892232','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620821','title'=>'泾川县','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'107.37451813364','lat'=>'35.338668597821','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620822','title'=>'灵台县','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'107.62746120252','lat'=>'35.07158181696','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620823','title'=>'崇信县','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'107.04141513189','lat'=>'35.308615839828','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620825','title'=>'庄浪县','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'106.04258582178','lat'=>'35.208192125804','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620826','title'=>'静宁县','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'105.73841580322','lat'=>'35.528257189136','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620881','title'=>'华亭市','pid'=>'620800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.65948599177','lat'=>'35.223550762897','level'=>'3','tree'=>'tr_0 tr_620000 tr_620800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620902','title'=>'肃州区','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'98.514321853032','lat'=>'39.751245509963','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620921','title'=>'金塔县','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'98.908368236172','lat'=>'39.990029254093','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620922','title'=>'瓜州县','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'95.788736364512','lat'=>'40.52610597895','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620923','title'=>'肃北蒙古族自治县','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'94.883692395412','lat'=>'39.518329738436','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620924','title'=>'阿克塞哈萨克族自治县','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'94.346760190396','lat'=>'39.640045316917','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620981','title'=>'玉门市','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'97.051711691182','lat'=>'40.297620020884','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'620982','title'=>'敦煌市','pid'=>'620900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'94.668527025762','lat'=>'40.147867484244','level'=>'3','tree'=>'tr_0 tr_620000 tr_620900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621002','title'=>'西峰区','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'107.65739112517','lat'=>'35.736864475978','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621021','title'=>'庆城县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'107.88840619724','lat'=>'36.021726360644','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621022','title'=>'环县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.31446964419','lat'=>'36.574427108907','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621023','title'=>'华池县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'107.99638952632','lat'=>'36.467575129884','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621024','title'=>'合水县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'108.026447188','lat'=>'35.8252622164','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621025','title'=>'正宁县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'108.36637461671','lat'=>'35.498218780898','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621026','title'=>'宁县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'107.93457092587','lat'=>'35.507932974537','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621027','title'=>'镇原县','pid'=>'621000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'107.20757586986','lat'=>'35.683230586316','level'=>'3','tree'=>'tr_0 tr_620000 tr_621000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621102','title'=>'安定区','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'104.61650040265','lat'=>'35.585600016725','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621121','title'=>'通渭县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'105.24840362211','lat'=>'35.217216821266','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621122','title'=>'陇西县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'104.64138059069','lat'=>'35.010197162318','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621123','title'=>'渭源县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.22158401062','lat'=>'35.142391958021','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621124','title'=>'临洮县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.8656010777','lat'=>'35.400587040258','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621125','title'=>'漳县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.4785953255','lat'=>'34.854249981778','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621126','title'=>'岷县','pid'=>'621100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'104.04339603983','lat'=>'34.44440764065','level'=>'3','tree'=>'tr_0 tr_620000 tr_621100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621202','title'=>'武都区','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.93259336075','lat'=>'33.398072188089','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621221','title'=>'成县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'105.7484779029','lat'=>'33.756635187351','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621222','title'=>'文县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'104.68955842198','lat'=>'32.949601280768','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621223','title'=>'宕昌县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'104.39938579987','lat'=>'34.053486291359','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621224','title'=>'康县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'105.61539187549','lat'=>'33.335376401996','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621225','title'=>'西和县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.30761048912','lat'=>'34.016787358437','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621226','title'=>'礼县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'105.1835909694','lat'=>'34.194685061207','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621227','title'=>'徽县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.09441787005','lat'=>'33.77519418709','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'621228','title'=>'两当县','pid'=>'621200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.31141946599','lat'=>'33.915122835173','level'=>'3','tree'=>'tr_0 tr_620000 tr_621200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622901','title'=>'临夏市','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.2495491776','lat'=>'35.609898772689','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622921','title'=>'临夏县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.00251408439','lat'=>'35.497397958837','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622922','title'=>'康乐县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'103.71547554223','lat'=>'35.376109760702','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622923','title'=>'永靖县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'103.29250749455','lat'=>'35.963330304471','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622924','title'=>'广河县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'103.58240999619','lat'=>'35.494101361696','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622925','title'=>'和政县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'103.35752370329','lat'=>'35.430589904166','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622926','title'=>'东乡族自治县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.39561320437','lat'=>'35.669329728624','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'622927','title'=>'积石山保安族东乡族撒拉族自治县','pid'=>'622900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.88251807505','lat'=>'35.72349932364','level'=>'3','tree'=>'tr_0 tr_620000 tr_622900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623001','title'=>'合作市','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.917571573','lat'=>'35.005935428196','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623021','title'=>'临潭县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'103.36053329624','lat'=>'34.698639411522','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623022','title'=>'卓尼县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'103.51361578396','lat'=>'34.594916432804','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623023','title'=>'舟曲县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'104.37748996239','lat'=>'33.790814973644','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623024','title'=>'迭部县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'103.22844034558','lat'=>'34.062020054097','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623025','title'=>'玛曲县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.07860004026','lat'=>'34.003358168342','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623026','title'=>'碌曲县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.49442413371','lat'=>'34.597087271566','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'623027','title'=>'夏河县','pid'=>'623000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.52857708038','lat'=>'35.208324325541','level'=>'3','tree'=>'tr_0 tr_620000 tr_623000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630102','title'=>'城东区','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.80956903833','lat'=>'36.605707645661','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630103','title'=>'城中区','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.79048354964','lat'=>'36.628800570589','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630104','title'=>'城西区','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.77241422413','lat'=>'36.634496979524','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630105','title'=>'城北区','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'101.77240488176','lat'=>'36.656293630837','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630121','title'=>'大通回族土族自治县','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'101.69256375752','lat'=>'36.932666463407','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630122','title'=>'湟中县','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.57861675782','lat'=>'36.506627546281','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630123','title'=>'湟源县','pid'=>'630100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.26244861154','lat'=>'36.688587514903','level'=>'3','tree'=>'tr_0 tr_630000 tr_630100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630202','title'=>'乐都区','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'102.40856633883','lat'=>'36.487820051522','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630203','title'=>'平安区','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'102.11442787756','lat'=>'36.506553573162','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630222','title'=>'民和回族土族自治县','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'102.11044407228','lat'=>'36.508511080941','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630223','title'=>'互助土族自治县','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.96456904899','lat'=>'36.850021613826','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630224','title'=>'化隆回族自治县','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'102.27044827345','lat'=>'36.100988250893','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'630225','title'=>'循化撒拉族自治县','pid'=>'630200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'102.4953853206','lat'=>'35.856667223862','level'=>'3','tree'=>'tr_0 tr_630000 tr_630200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632221','title'=>'门源回族自治县','pid'=>'632200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'101.62843803903','lat'=>'37.382180626313','level'=>'3','tree'=>'tr_0 tr_630000 tr_632200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632222','title'=>'祁连县','pid'=>'632200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'100.25962157243','lat'=>'38.182924871569','level'=>'3','tree'=>'tr_0 tr_630000 tr_632200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632223','title'=>'海晏县','pid'=>'632200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.0005855486','lat'=>'36.902376022515','level'=>'3','tree'=>'tr_0 tr_630000 tr_632200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632224','title'=>'刚察县','pid'=>'632200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.15360607139','lat'=>'37.327320072254','level'=>'3','tree'=>'tr_0 tr_630000 tr_632200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632321','title'=>'同仁县','pid'=>'632300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'102.0254377812','lat'=>'35.521865150524','level'=>'3','tree'=>'tr_0 tr_630000 tr_632300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632322','title'=>'尖扎县','pid'=>'632300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'102.0375073242','lat'=>'35.944284459868','level'=>'3','tree'=>'tr_0 tr_630000 tr_632300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632323','title'=>'泽库县','pid'=>'632300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'101.47359451319','lat'=>'35.0420144951','level'=>'3','tree'=>'tr_0 tr_630000 tr_632300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632324','title'=>'河南蒙古族自治县','pid'=>'632300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'101.62247338027','lat'=>'34.740396071091','level'=>'3','tree'=>'tr_0 tr_630000 tr_632300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632521','title'=>'共和县','pid'=>'632500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.62662348005','lat'=>'36.288703317865','level'=>'3','tree'=>'tr_0 tr_630000 tr_632500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632522','title'=>'同德县','pid'=>'632500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'100.58542386564','lat'=>'35.259857775817','level'=>'3','tree'=>'tr_0 tr_630000 tr_632500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632523','title'=>'贵德县','pid'=>'632500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'101.43953310384','lat'=>'36.046158080751','level'=>'3','tree'=>'tr_0 tr_630000 tr_632500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632524','title'=>'兴海县','pid'=>'632500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'99.994380072293','lat'=>'35.594629879949','level'=>'3','tree'=>'tr_0 tr_630000 tr_632500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632525','title'=>'贵南县','pid'=>'632500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'100.75359321473','lat'=>'35.592415454611','level'=>'3','tree'=>'tr_0 tr_630000 tr_632500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632621','title'=>'玛沁县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'100.24556434882','lat'=>'34.483569486002','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632622','title'=>'班玛县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'100.74360459645','lat'=>'32.93850392747','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632623','title'=>'甘德县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'99.907510695578','lat'=>'33.975003677602','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632624','title'=>'达日县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'99.658010113065','lat'=>'33.754937373991','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632625','title'=>'久治县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'101.48853225585','lat'=>'33.434773499408','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632626','title'=>'玛多县','pid'=>'632600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'98.215883832099','lat'=>'34.920748646186','level'=>'3','tree'=>'tr_0 tr_630000 tr_632600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632701','title'=>'玉树市','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'97.015376401101','lat'=>'32.999555650886','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632722','title'=>'杂多县','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'95.306964878828','lat'=>'32.89924067586','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632723','title'=>'称多县','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'97.115000009277','lat'=>'33.374225698944','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632724','title'=>'治多县','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'95.61979357437','lat'=>'33.857953267719','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632725','title'=>'囊谦县','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'96.486918271283','lat'=>'32.209194368698','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632726','title'=>'曲麻莱县','pid'=>'632700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'95.803750013992','lat'=>'34.132298666997','level'=>'3','tree'=>'tr_0 tr_630000 tr_632700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632801','title'=>'格尔木市','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'94.933310210425','lat'=>'36.412371046954','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632802','title'=>'德令哈市','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'97.367470299975','lat'=>'37.375345907463','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632803','title'=>'茫崖市','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'90.87951750334','lat'=>'38.261902814972','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632821','title'=>'乌兰县','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'98.486735699295','lat'=>'36.935747859032','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632822','title'=>'都兰县','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'98.102704793777','lat'=>'36.307611028682','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632823','title'=>'天峻县','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'99.029242967967','lat'=>'37.306903395111','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'632857','title'=>'大柴旦行政委员会','pid'=>'632800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'95.371722465415','lat'=>'37.857987655919','level'=>'3','tree'=>'tr_0 tr_630000 tr_632800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640104','title'=>'兴庆区','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.29549376692','lat'=>'38.479578929456','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640105','title'=>'西夏区','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'106.15658124015','lat'=>'38.496817469604','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640106','title'=>'金凤区','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.24956089094','lat'=>'38.478695238722','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640121','title'=>'永宁县','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.25960457536','lat'=>'38.283001541521','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640122','title'=>'贺兰县','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.3565182653','lat'=>'38.560406689579','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640181','title'=>'灵武市','pid'=>'640100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.34644035545','lat'=>'38.108658666793','level'=>'3','tree'=>'tr_0 tr_640000 tr_640100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540502','title'=>'乃东区','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'91.778681965641','lat'=>'29.234229154985','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540521','title'=>'扎囊县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'91.343627127639','lat'=>'29.251164315795','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540522','title'=>'贡嘎县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'90.990582372498','lat'=>'29.295585920341','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540523','title'=>'桑日县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'92.022157253696','lat'=>'29.265175836421','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540524','title'=>'琼结县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'91.690100777976','lat'=>'29.030865581933','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540525','title'=>'曲松县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'92.210174662975','lat'=>'29.068424815624','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540526','title'=>'措美县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'91.439917573188','lat'=>'28.444257990161','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540527','title'=>'洛扎县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'90.866452001915','lat'=>'28.391634617398','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540528','title'=>'加查县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'92.600448881489','lat'=>'29.146087474784','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540529','title'=>'隆子县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'92.468965520987','lat'=>'28.414018998419','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540530','title'=>'错那县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'91.96375005827','lat'=>'27.997004265923','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'540531','title'=>'浪卡子县','pid'=>'540500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'90.404646883462','lat'=>'28.973992017804','level'=>'3','tree'=>'tr_0 tr_540000 tr_540500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640302','title'=>'利通区','pid'=>'640300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.21940702074','lat'=>'37.990746080857','level'=>'3','tree'=>'tr_0 tr_640000 tr_640300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640303','title'=>'红寺堡区','pid'=>'640300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'106.06842117808','lat'=>'37.431882454446','level'=>'3','tree'=>'tr_0 tr_640000 tr_640300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640323','title'=>'盐池县','pid'=>'640300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'107.41337954864','lat'=>'37.789295649909','level'=>'3','tree'=>'tr_0 tr_640000 tr_640300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640324','title'=>'同心县','pid'=>'640300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'105.9205990776','lat'=>'36.986269629165','level'=>'3','tree'=>'tr_0 tr_640000 tr_640300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640381','title'=>'青铜峡市','pid'=>'640300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'106.08537031661','lat'=>'38.027412223967','level'=>'3','tree'=>'tr_0 tr_640000 tr_640300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640402','title'=>'原州区','pid'=>'640400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'106.29451461392','lat'=>'36.009367675763','level'=>'3','tree'=>'tr_0 tr_640000 tr_640400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640422','title'=>'西吉县','pid'=>'640400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'105.73538590857','lat'=>'35.97007642089','level'=>'3','tree'=>'tr_0 tr_640000 tr_640400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640423','title'=>'隆德县','pid'=>'640400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'106.1184982967','lat'=>'35.631762315094','level'=>'3','tree'=>'tr_0 tr_640000 tr_640400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640424','title'=>'泾源县','pid'=>'640400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'106.33739343083','lat'=>'35.504361637679','level'=>'3','tree'=>'tr_0 tr_640000 tr_640400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640425','title'=>'彭阳县','pid'=>'640400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'106.64454429656','lat'=>'35.85540546349','level'=>'3','tree'=>'tr_0 tr_640000 tr_640400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640502','title'=>'沙坡头区','pid'=>'640500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'105.20357090089','lat'=>'37.505701418703','level'=>'3','tree'=>'tr_0 tr_640000 tr_640500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640521','title'=>'中宁县','pid'=>'640500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'105.6915371912','lat'=>'37.497420805579','level'=>'3','tree'=>'tr_0 tr_640000 tr_640500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640522','title'=>'海原县','pid'=>'640500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'105.65055514638','lat'=>'36.570781489719','level'=>'3','tree'=>'tr_0 tr_640000 tr_640500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650102','title'=>'天山区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'87.638407777566','lat'=>'43.800271358313','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650103','title'=>'沙依巴克区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'87.604670027697','lat'=>'43.807262352761','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650104','title'=>'新市区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'87.575908441201','lat'=>'43.861394002748','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650105','title'=>'水磨沟区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'87.648896662192','lat'=>'43.838251163831','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650106','title'=>'头屯河区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'87.434506709858','lat'=>'43.882653022602','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650107','title'=>'达坂城区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'88.317397656607','lat'=>'43.36994274634','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650109','title'=>'米东区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'87.662134271848','lat'=>'43.979247426398','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650121','title'=>'乌鲁木齐县','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'87.416028745179','lat'=>'43.477086065793','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650171','title'=>'乌鲁木齐经济技术开发区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'87.523118529771','lat'=>'43.868981036009','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650172','title'=>'乌鲁木齐高新技术产业开发区','pid'=>'650100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'87.58408445863','lat'=>'43.87767236981','level'=>'3','tree'=>'tr_0 tr_650000 tr_650100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650202','title'=>'独山子区','pid'=>'650200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'84.893613283343','lat'=>'44.334407392365','level'=>'3','tree'=>'tr_0 tr_650000 tr_650200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650203','title'=>'克拉玛依区','pid'=>'650200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'84.866221962114','lat'=>'45.596624206981','level'=>'3','tree'=>'tr_0 tr_650000 tr_650200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650204','title'=>'白碱滩区','pid'=>'650200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'85.139510123686','lat'=>'45.693951629764','level'=>'3','tree'=>'tr_0 tr_650000 tr_650200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650205','title'=>'乌尔禾区','pid'=>'650200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'85.700304826442','lat'=>'46.095295184689','level'=>'3','tree'=>'tr_0 tr_650000 tr_650200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650402','title'=>'高昌区','pid'=>'650400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'89.192458882701','lat'=>'42.948548691684','level'=>'3','tree'=>'tr_0 tr_650000 tr_650400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650421','title'=>'鄯善县','pid'=>'650400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'90.220093886103','lat'=>'42.874759228479','level'=>'3','tree'=>'tr_0 tr_650000 tr_650400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650422','title'=>'托克逊县','pid'=>'650400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'88.660164359541','lat'=>'42.798545831023','level'=>'3','tree'=>'tr_0 tr_650000 tr_650400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650502','title'=>'伊州区','pid'=>'650500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'93.521320462369','lat'=>'42.832824924721','level'=>'3','tree'=>'tr_0 tr_650000 tr_650500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650521','title'=>'巴里坤哈萨克自治县','pid'=>'650500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'93.022930953564','lat'=>'43.605688770787','level'=>'3','tree'=>'tr_0 tr_650000 tr_650500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'650522','title'=>'伊吾县','pid'=>'650500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'94.703825671285','lat'=>'43.260676527466','level'=>'3','tree'=>'tr_0 tr_650000 tr_650500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652301','title'=>'昌吉市','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'87.27386462195','lat'=>'44.020126845939','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652302','title'=>'阜康市','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'87.993677905062','lat'=>'44.163137321346','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652323','title'=>'呼图壁县','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'86.905143806731','lat'=>'44.197654596132','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652324','title'=>'玛纳斯县','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'86.220643452199','lat'=>'44.3100628588','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652325','title'=>'奇台县','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'89.601080811724','lat'=>'44.026897819018','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652327','title'=>'吉木萨尔县','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'89.187122858141','lat'=>'44.005717795203','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652328','title'=>'木垒哈萨克自治县','pid'=>'652300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'90.292514737334','lat'=>'43.840308302807','level'=>'3','tree'=>'tr_0 tr_650000 tr_652300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652701','title'=>'博乐市','pid'=>'652700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'82.057972254591','lat'=>'44.860009784639','level'=>'3','tree'=>'tr_0 tr_650000 tr_652700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652702','title'=>'阿拉山口市','pid'=>'652700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'82.560725272438','lat'=>'45.179670079921','level'=>'3','tree'=>'tr_0 tr_650000 tr_652700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652722','title'=>'精河县','pid'=>'652700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'82.900655316205','lat'=>'44.606645943492','level'=>'3','tree'=>'tr_0 tr_650000 tr_652700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652723','title'=>'温泉县','pid'=>'652700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'81.031145546486','lat'=>'44.974856638705','level'=>'3','tree'=>'tr_0 tr_650000 tr_652700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652801','title'=>'库尔勒市','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'86.181494309938','lat'=>'41.732373221412','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652822','title'=>'轮台县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'84.258212152054','lat'=>'41.783813000515','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652823','title'=>'尉犁县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'86.266036536399','lat'=>'41.350122782054','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652824','title'=>'若羌县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'88.175324441896','lat'=>'39.028991037175','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652825','title'=>'且末县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'85.535990385731','lat'=>'38.15138769413','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652826','title'=>'焉耆回族自治县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'86.581222026277','lat'=>'42.064850858728','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652827','title'=>'和静县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'86.390398220692','lat'=>'42.329365035879','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652828','title'=>'和硕县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'86.883689037252','lat'=>'42.288065062428','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652829','title'=>'博湖县','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'86.638469149986','lat'=>'41.986430356829','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652871','title'=>'库尔勒经济技术开发区','pid'=>'652800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'86.229512961483','lat'=>'41.71760888729','level'=>'3','tree'=>'tr_0 tr_650000 tr_652800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652901','title'=>'阿克苏市','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'80.269926757334','lat'=>'41.173859926953','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652922','title'=>'温宿县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'80.245564352581','lat'=>'41.282567249887','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652923','title'=>'库车县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'82.968458787284','lat'=>'41.723447514833','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652924','title'=>'沙雅县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'82.788823736148','lat'=>'41.227749329027','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652925','title'=>'新和县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'82.615823030526','lat'=>'41.553999628477','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652926','title'=>'拜城县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'81.858516272038','lat'=>'41.800706601984','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652927','title'=>'乌什县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'79.230868990897','lat'=>'41.220871106999','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652928','title'=>'阿瓦提县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'80.381849245908','lat'=>'40.649358802911','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'652929','title'=>'柯坪县','pid'=>'652900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'79.053213535614','lat'=>'40.514055520966','level'=>'3','tree'=>'tr_0 tr_650000 tr_652900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653001','title'=>'阿图什市','pid'=>'653000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'76.174906408698','lat'=>'39.722079128589','level'=>'3','tree'=>'tr_0 tr_650000 tr_653000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653022','title'=>'阿克陶县','pid'=>'653000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'75.953725266709','lat'=>'39.153888517642','level'=>'3','tree'=>'tr_0 tr_650000 tr_653000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653023','title'=>'阿合奇县','pid'=>'653000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'78.45253927839','lat'=>'40.942958224222','level'=>'3','tree'=>'tr_0 tr_650000 tr_653000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653024','title'=>'乌恰县','pid'=>'653000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'75.26533363237','lat'=>'39.725123590953','level'=>'3','tree'=>'tr_0 tr_650000 tr_653000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653101','title'=>'喀什市','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'76.000312737915','lat'=>'39.473649532912','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653121','title'=>'疏附县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'75.869168667361','lat'=>'39.381291555212','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653122','title'=>'疏勒县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'76.056614395075','lat'=>'39.406709108732','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653123','title'=>'英吉沙县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'76.182075425651','lat'=>'38.935670863521','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653124','title'=>'泽普县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'77.266559423761','lat'=>'38.190725516333','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653125','title'=>'莎车县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'77.252436713686','lat'=>'38.420156752419','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653126','title'=>'叶城县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'77.420097621865','lat'=>'37.889166844427','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653127','title'=>'麦盖提县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'77.658824287414','lat'=>'38.911194315553','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653128','title'=>'岳普湖县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'76.78414771574','lat'=>'39.239387333945','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653129','title'=>'伽师县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'76.730385568257','lat'=>'39.493851605868','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653130','title'=>'巴楚县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'78.5557014018','lat'=>'39.79078837708','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653131','title'=>'塔什库尔干塔吉克自治县','pid'=>'653100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'75.230804744838','lat'=>'37.779045640763','level'=>'3','tree'=>'tr_0 tr_650000 tr_653100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653201','title'=>'和田市','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'79.920212469755','lat'=>'37.118335544466','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653221','title'=>'和田县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'79.866215595042','lat'=>'37.090362410221','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653222','title'=>'墨玉县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'79.735479265358','lat'=>'37.282993446907','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653223','title'=>'皮山县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'78.289871062405','lat'=>'37.627248714375','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653224','title'=>'洛浦县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'80.195387611879','lat'=>'37.079611030988','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653225','title'=>'策勒县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'80.813201268742','lat'=>'37.004122359371','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653226','title'=>'于田县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'81.683782914748','lat'=>'36.86295413611','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'653227','title'=>'民丰县','pid'=>'653200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'82.702713427589','lat'=>'37.070256968231','level'=>'3','tree'=>'tr_0 tr_650000 tr_653200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654002','title'=>'伊宁市','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'81.284242405278','lat'=>'43.915299436243','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654003','title'=>'奎屯市','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'84.909449241687','lat'=>'44.432057210004','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654004','title'=>'霍尔果斯市','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'80.427129772427','lat'=>'44.235308556093','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654021','title'=>'伊宁县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'81.533906479394','lat'=>'43.982909125124','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654022','title'=>'察布查尔锡伯自治县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'81.157924570907','lat'=>'43.846690330452','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654023','title'=>'霍城县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'80.885281123201','lat'=>'44.062249507399','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654024','title'=>'巩留县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'82.238225609409','lat'=>'43.488485559536','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654025','title'=>'新源县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'83.267022301497','lat'=>'43.435927002185','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654026','title'=>'昭苏县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'81.137377539147','lat'=>'43.163496741509','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654027','title'=>'特克斯县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'81.842587249244','lat'=>'43.224248213467','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654028','title'=>'尼勒克县','pid'=>'654000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'82.51800753168','lat'=>'43.804594836238','level'=>'3','tree'=>'tr_0 tr_650000 tr_654000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654201','title'=>'塔城市','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'82.987235518406','lat'=>'46.750948254373','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654202','title'=>'乌苏市','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'84.720088146964','lat'=>'44.424048034452','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654221','title'=>'额敏县','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'E','lng'=>'83.633374454783','lat'=>'46.531884861309','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654223','title'=>'沙湾县','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'85.626144686035','lat'=>'44.331949461741','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654224','title'=>'托里县','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'83.612909438315','lat'=>'45.94274280505','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654225','title'=>'裕民县','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'82.9894387025','lat'=>'46.207453546928','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654226','title'=>'和布克赛尔蒙古自治县','pid'=>'654200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'85.735008883548','lat'=>'46.798685112637','level'=>'3','tree'=>'tr_0 tr_650000 tr_654200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654301','title'=>'阿勒泰市','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'88.139226564024','lat'=>'47.832752648475','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654321','title'=>'布尔津县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'86.881360170273','lat'=>'47.707951723888','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654322','title'=>'富蕴县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'89.531953408055','lat'=>'46.999951053055','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654323','title'=>'福海县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'87.493157246325','lat'=>'47.118140737535','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654324','title'=>'哈巴河县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'86.424817684664','lat'=>'48.066148902458','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654325','title'=>'青河县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'90.389444407193','lat'=>'46.68019396705','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'654326','title'=>'吉木乃县','pid'=>'654300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'85.880818240706','lat'=>'47.449018413257','level'=>'3','tree'=>'tr_0 tr_650000 tr_654300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659001','title'=>'石河子市','pid'=>'659000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.5163190347','lat'=>'36.772534944449','level'=>'3','tree'=>'tr_0 tr_650000 tr_659000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659002','title'=>'阿拉尔市','pid'=>'659000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'81.287354225395','lat'=>'40.553263894706','level'=>'3','tree'=>'tr_0 tr_650000 tr_659000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659003','title'=>'图木舒克市','pid'=>'659000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'79.075616286896','lat'=>'39.871209077425','level'=>'3','tree'=>'tr_0 tr_650000 tr_659000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659004','title'=>'五家渠市','pid'=>'659000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'87.549936632296','lat'=>'44.172444518901','level'=>'3','tree'=>'tr_0 tr_650000 tr_659000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'659006','title'=>'铁门关市','pid'=>'659000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'85.686857831724','lat'=>'41.863648697693','level'=>'3','tree'=>'tr_0 tr_650000 tr_659000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130102','title'=>'长安区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.54561160958','lat'=>'38.043256136498','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130104','title'=>'桥西区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.46741977426','lat'=>'38.010381080199','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130105','title'=>'新华区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.46943844641','lat'=>'38.057119539196','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130107','title'=>'井陉矿区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.06863186515','lat'=>'38.070565834517','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130108','title'=>'裕华区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.53758291426','lat'=>'38.012087686284','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130109','title'=>'藁城区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.85337790442','lat'=>'38.027816555321','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130110','title'=>'鹿泉区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.32059757764','lat'=>'38.09174945759','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130111','title'=>'栾城区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.65457561879','lat'=>'37.905816364165','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130121','title'=>'井陉县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.15146299928','lat'=>'38.038386214927','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130123','title'=>'正定县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.57748106365','lat'=>'38.151713727954','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130125','title'=>'行唐县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.55960676028','lat'=>'38.444238747676','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130126','title'=>'灵寿县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.38947775771','lat'=>'38.314629370046','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130127','title'=>'高邑县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.61841307286','lat'=>'37.621879561553','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130128','title'=>'深泽县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.20740369913','lat'=>'38.190451203069','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130129','title'=>'赞皇县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.39246354556','lat'=>'37.671667061291','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130130','title'=>'无极县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.98243934348','lat'=>'38.18543617028','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130131','title'=>'平山县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'113.98543503085','lat'=>'38.271951013311','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130132','title'=>'元氏县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.53256551866','lat'=>'37.772338553855','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130133','title'=>'赵县','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.78259655058','lat'=>'37.761858522888','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130171','title'=>'石家庄高新技术产业开发区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.47561896798','lat'=>'38.014375062684','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130172','title'=>'石家庄循环化工园区','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.69991493042','lat'=>'38.002797025837','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130181','title'=>'辛集市','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.22445084279','lat'=>'37.949309043173','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130183','title'=>'晋州市','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.0505290147','lat'=>'38.039491309736','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130184','title'=>'新乐市','pid'=>'130100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.69053218327','lat'=>'38.349292647959','level'=>'3','tree'=>'tr_0 tr_130000 tr_130100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130202','title'=>'路南区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.20604028639','lat'=>'39.612986996735','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130203','title'=>'路北区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.2239040796','lat'=>'39.673985965975','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130204','title'=>'古冶区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'118.45340092552','lat'=>'39.739735914766','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130205','title'=>'开平区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.26860762449','lat'=>'39.677143635862','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130207','title'=>'丰南区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'118.0903655757','lat'=>'39.581540485109','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130208','title'=>'丰润区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'118.16854133135','lat'=>'39.838353430851','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130209','title'=>'曹妃甸区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.46645986221','lat'=>'39.279283996335','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130224','title'=>'滦南县','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.68040524315','lat'=>'39.510044702469','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130225','title'=>'乐亭县','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.91938406305','lat'=>'39.431931320096','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130227','title'=>'迁西县','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.32038397781','lat'=>'40.147837151362','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130229','title'=>'玉田县','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.74543440564','lat'=>'39.906592348189','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130271','title'=>'唐山市芦台经济技术开发区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.83195389236','lat'=>'39.334328330689','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130272','title'=>'唐山市汉沽管理区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'117.88832858176','lat'=>'39.367125548614','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130273','title'=>'唐山高新技术产业开发区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'118.18645947204','lat'=>'39.636583724147','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130274','title'=>'河北唐山海港经济开发区','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.00992050252','lat'=>'39.237818631017','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130281','title'=>'遵化市','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'117.97237521307','lat'=>'40.195533204033','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130283','title'=>'迁安市','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.70645736056','lat'=>'40.004183924931','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130284','title'=>'滦州市','pid'=>'130200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.71048006247','lat'=>'39.747115765489','level'=>'3','tree'=>'tr_0 tr_130000 tr_130200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130302','title'=>'海港区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'119.61747524097','lat'=>'39.940412688357','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130303','title'=>'山海关区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'119.78243521397','lat'=>'39.984445641831','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130304','title'=>'北戴河区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.49152607118','lat'=>'39.841005667936','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130306','title'=>'抚宁区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'119.25154914402','lat'=>'39.88141356935','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130321','title'=>'青龙满族自治县','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'118.95648129587','lat'=>'40.412793702313','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130322','title'=>'昌黎县','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'119.16937521021','lat'=>'39.71905083388','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130324','title'=>'卢龙县','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'118.89948911126','lat'=>'39.897958466103','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130371','title'=>'秦皇岛市经济技术开发区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'119.48439783729','lat'=>'39.943641230776','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130372','title'=>'北戴河新区','pid'=>'130300','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'119.47981001139','lat'=>'39.831809170026','level'=>'3','tree'=>'tr_0 tr_130000 tr_130300 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130402','title'=>'邯山区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.49638868967','lat'=>'36.586692191979','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130403','title'=>'丛台区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.49943259789','lat'=>'36.642672565982','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130404','title'=>'复兴区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.44809470749','lat'=>'36.610368592227','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130406','title'=>'峰峰矿区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.21948332131','lat'=>'36.425653614399','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130407','title'=>'肥乡区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.80654708226','lat'=>'36.55382525367','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130408','title'=>'永年区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.55062514246','lat'=>'36.747569389575','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130423','title'=>'临漳县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.62642694614','lat'=>'36.340765980595','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130424','title'=>'成安县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.67657655802','lat'=>'36.449796208953','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130425','title'=>'大名县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.15461253007','lat'=>'36.291288466231','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130426','title'=>'涉县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.69758434883','lat'=>'36.590691663211','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130427','title'=>'磁县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'114.38043173139','lat'=>'36.380358940947','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130430','title'=>'邱县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.19339516368','lat'=>'36.817362417143','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130431','title'=>'鸡泽县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'114.89658577064','lat'=>'36.916398206414','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130432','title'=>'广平县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'114.95441490649','lat'=>'36.489779995612','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130433','title'=>'馆陶县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.28853676635','lat'=>'36.553956728653','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130434','title'=>'魏县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.94545044631','lat'=>'36.366156454371','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130435','title'=>'曲周县','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.96340442939','lat'=>'36.771544831336','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130471','title'=>'邯郸经济技术开发区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.54562822824','lat'=>'36.631262731204','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130473','title'=>'邯郸冀南新区','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.54562822824','lat'=>'36.631262731204','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130481','title'=>'武安市','pid'=>'130400','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.21051607638','lat'=>'36.70248828628','level'=>'3','tree'=>'tr_0 tr_130000 tr_130400 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130502','title'=>'桥东区','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.51347113674','lat'=>'37.073749959651','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130503','title'=>'桥西区','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.4743934996','lat'=>'37.066172415704','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130521','title'=>'邢台县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'114.14341085818','lat'=>'37.17710928752','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130522','title'=>'临城县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.50544333972','lat'=>'37.450788548442','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130523','title'=>'内丘县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.51849293403','lat'=>'37.292857912047','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130524','title'=>'柏乡县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'114.69949736209','lat'=>'37.488758727152','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130525','title'=>'隆尧县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.77661608165','lat'=>'37.355908006295','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130526','title'=>'任县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'114.67860600983','lat'=>'37.126726783523','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130527','title'=>'南和县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.69054772395','lat'=>'37.01099797056','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130528','title'=>'宁晋县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'114.92556169283','lat'=>'37.625612279932','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130529','title'=>'巨鹿县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.04358735887','lat'=>'37.227088328938','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130530','title'=>'新河县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.24854716945','lat'=>'37.534590601536','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130531','title'=>'广宗县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.14960474634','lat'=>'37.080457122162','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130532','title'=>'平乡县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'115.03658174369','lat'=>'37.069096393044','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130533','title'=>'威县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.27361761861','lat'=>'36.981581608663','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130534','title'=>'清河县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.67439356765','lat'=>'37.046375401617','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130535','title'=>'临西县','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.50762943786','lat'=>'36.87675996654','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130571','title'=>'河北邢台经济开发区','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.51146225613','lat'=>'37.076685950966','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130581','title'=>'南宫市','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'115.4145290548','lat'=>'37.364069402723','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130582','title'=>'沙河市','pid'=>'130500','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'114.50947385688','lat'=>'36.861127341145','level'=>'3','tree'=>'tr_0 tr_130000 tr_130500 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130602','title'=>'竞秀区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.46543414161','lat'=>'38.883787961691','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130606','title'=>'莲池区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.53548768833','lat'=>'38.860675807041','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130607','title'=>'满城区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'115.3283750886','lat'=>'38.955441208686','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130608','title'=>'清苑区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'115.49660588179','lat'=>'38.771001774749','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130609','title'=>'徐水区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.66247952133','lat'=>'39.024712583834','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130623','title'=>'涞水县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.72054302508','lat'=>'39.400334198489','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130624','title'=>'阜平县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'114.20156347384','lat'=>'38.855351444796','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130626','title'=>'定兴县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'115.81441011189','lat'=>'39.269423528527','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130627','title'=>'唐县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'114.9894471146','lat'=>'38.754019925125','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130628','title'=>'高阳县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.78544721513','lat'=>'38.706257734087','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130629','title'=>'容城县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'115.86863129349','lat'=>'39.048559435416','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130630','title'=>'涞源县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'114.70047561679','lat'=>'39.366271691524','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130631','title'=>'望都县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.16158760286','lat'=>'38.700157645549','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130632','title'=>'安新县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'115.94242628266','lat'=>'38.941734298593','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130633','title'=>'易县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'115.50360664612','lat'=>'39.355054469981','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130634','title'=>'曲阳县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.7514548138','lat'=>'38.628384104122','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130635','title'=>'蠡县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'115.59044548045','lat'=>'38.494200963238','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130636','title'=>'顺平县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.14159743069','lat'=>'38.843261370364','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130637','title'=>'博野县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'115.47046698806','lat'=>'38.463408004952','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130638','title'=>'雄县','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.11460144552','lat'=>'39.000180119499','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130671','title'=>'保定高新技术产业开发区','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'115.47146383769','lat'=>'38.879987768455','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130672','title'=>'保定白沟新城','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'116.06423983354','lat'=>'39.145149134834','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130681','title'=>'涿州市','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.98161971138','lat'=>'39.491065832','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130682','title'=>'定州市','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'114.99649620776','lat'=>'38.522198840134','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130683','title'=>'安国市','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'115.33340802488','lat'=>'38.424828318687','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130684','title'=>'高碑店市','pid'=>'130600','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.88056905507','lat'=>'39.332335447462','level'=>'3','tree'=>'tr_0 tr_130000 tr_130600 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130702','title'=>'桥东区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.90060577763','lat'=>'40.794268437423','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130703','title'=>'桥西区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'114.87651609843','lat'=>'40.825605695041','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130705','title'=>'宣化区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.1054444068','lat'=>'40.614591888266','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130706','title'=>'下花园区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'115.29351688226','lat'=>'40.508145182672','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130708','title'=>'万全区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.74742582376','lat'=>'40.773149648997','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130709','title'=>'崇礼区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.28954933632','lat'=>'40.98047788587','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130722','title'=>'张北县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.7263751121','lat'=>'41.164943620015','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130723','title'=>'康保县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'114.60635583664','lat'=>'41.858636884497','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130724','title'=>'沽源县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.69540744878','lat'=>'41.676015876097','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130725','title'=>'尚义县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'113.97552438548','lat'=>'41.081888482486','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130726','title'=>'蔚县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'114.5954005518','lat'=>'39.847088636366','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130727','title'=>'阳原县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'114.15752413604','lat'=>'40.109588388731','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130728','title'=>'怀安县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'114.39246911506','lat'=>'40.680369343116','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130730','title'=>'怀来县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.52455288485','lat'=>'40.420289890382','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130731','title'=>'涿鹿县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.21138346203','lat'=>'40.385834075003','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130732','title'=>'赤城县','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'115.83850589957','lat'=>'40.918761216841','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130771','title'=>'张家口市高新技术产业开发区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'114.89257223145','lat'=>'40.773237202691','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130772','title'=>'张家口市察北管理区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.13535097349','lat'=>'41.463489368202','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130773','title'=>'张家口市塞北管理区','pid'=>'130700','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.80931788745','lat'=>'41.877919284073','level'=>'3','tree'=>'tr_0 tr_130000 tr_130700 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130802','title'=>'双桥区','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.94942790899','lat'=>'40.980824477401','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130803','title'=>'双滦区','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.80657828883','lat'=>'40.964729148178','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130804','title'=>'鹰手营子矿区','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.66560909159','lat'=>'40.552043233623','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130821','title'=>'承德县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'118.18045573699','lat'=>'40.774367194936','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130822','title'=>'兴隆县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.50742737264','lat'=>'40.423454029635','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130824','title'=>'滦平县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.33949787111','lat'=>'40.94756096291','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130825','title'=>'隆化县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'117.7454510243','lat'=>'41.319898805021','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130826','title'=>'丰宁满族自治县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.65239270009','lat'=>'41.215336380004','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130827','title'=>'宽城满族自治县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'K','lng'=>'118.49159436055','lat'=>'40.617151507814','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130828','title'=>'围场满族蒙古族自治县','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'117.76656434785','lat'=>'41.944323773611','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130871','title'=>'承德高新技术产业开发区','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.96939750997','lat'=>'40.957856012338','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130881','title'=>'平泉市','pid'=>'130800','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'118.70742672204','lat'=>'41.023755625929','level'=>'3','tree'=>'tr_0 tr_130000 tr_130800 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130902','title'=>'新华区','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.87243317375','lat'=>'38.320366719478','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130903','title'=>'运河区','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.8386119713','lat'=>'38.316522737476','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130921','title'=>'沧县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.88439779466','lat'=>'38.299452743407','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130922','title'=>'青县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Q','lng'=>'116.81057477836','lat'=>'38.58846475864','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130923','title'=>'东光县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.54340955698','lat'=>'37.894513906653','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130924','title'=>'海兴县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.50441804918','lat'=>'38.149402516518','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130925','title'=>'盐山县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'117.23741362448','lat'=>'38.064318399559','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130926','title'=>'肃宁县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.83651767998','lat'=>'38.428905919718','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130927','title'=>'南皮县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'N','lng'=>'116.71560115883','lat'=>'38.045187886965','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130928','title'=>'吴桥县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.39739206243','lat'=>'37.633908755554','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130929','title'=>'献县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'116.12956002887','lat'=>'38.195981438007','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130930','title'=>'孟村回族自治县','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'M','lng'=>'117.11043607455','lat'=>'38.059839127888','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130971','title'=>'河北沧州经济开发区','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.84558075595','lat'=>'38.310215141107','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130972','title'=>'沧州高新技术产业开发区','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'116.81727200975','lat'=>'38.34342368505','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130973','title'=>'沧州渤海新区','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'C','lng'=>'117.7623777537','lat'=>'38.282913560669','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130981','title'=>'泊头市','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'P','lng'=>'116.58462803581','lat'=>'38.089256915446','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130982','title'=>'任丘市','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'116.1056050955','lat'=>'38.717348630775','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130983','title'=>'黄骅市','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'117.33648109172','lat'=>'38.377493900735','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'130984','title'=>'河间市','pid'=>'130900','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'116.10562809212','lat'=>'38.451356515106','level'=>'3','tree'=>'tr_0 tr_130000 tr_130900 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131002','title'=>'安次区','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'116.70963326617','lat'=>'39.526159764041','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131003','title'=>'广阳区','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'116.71761426148','lat'=>'39.528611447334','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131022','title'=>'固安县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'116.30542004093','lat'=>'39.444484855304','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131023','title'=>'永清县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Y','lng'=>'116.50542928985','lat'=>'39.327852998574','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131024','title'=>'香河县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'X','lng'=>'117.0124021078','lat'=>'39.767939188546','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131025','title'=>'大城县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.66040917846','lat'=>'38.710858640026','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131026','title'=>'文安县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'116.464609479','lat'=>'38.87895049307','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131028','title'=>'大厂回族自治县','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'D','lng'=>'116.99640912565','lat'=>'39.892208394086','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131071','title'=>'廊坊经济技术开发区','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'L','lng'=>'116.76777922809','lat'=>'39.587610159458','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131081','title'=>'霸州市','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'B','lng'=>'116.3983972663','lat'=>'39.130920596981','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131082','title'=>'三河市','pid'=>'131000','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'117.08458787248','lat'=>'39.988099552443','level'=>'3','tree'=>'tr_0 tr_130000 tr_131000 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131102','title'=>'桃城区','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'T','lng'=>'115.68139532011','lat'=>'37.741636751694','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131103','title'=>'冀州区','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'115.58542988146','lat'=>'37.557086025833','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131121','title'=>'枣强县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'Z','lng'=>'115.7305629044','lat'=>'37.519363689764','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131122','title'=>'武邑县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.89451363117','lat'=>'37.807764276867','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131123','title'=>'武强县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'W','lng'=>'115.98961391178','lat'=>'38.046856805237','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131124','title'=>'饶阳县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'R','lng'=>'115.73257160535','lat'=>'38.241037525428','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131125','title'=>'安平县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'A','lng'=>'115.52554928532','lat'=>'38.240506922191','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131126','title'=>'故城县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'G','lng'=>'115.97260216135','lat'=>'37.353347552477','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131127','title'=>'景县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'J','lng'=>'116.2774107853','lat'=>'37.698814551395','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131128','title'=>'阜城县','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'F','lng'=>'116.18242153525','lat'=>'37.868732457906','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131171','title'=>'河北衡水高新技术产业开发区','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.73456139967','lat'=>'37.807821775773','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131172','title'=>'衡水滨湖新区','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'H','lng'=>'115.70627999969','lat'=>'37.701616037093','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'131182','title'=>'深州市','pid'=>'131100','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'S','lng'=>'115.56636927583','lat'=>'38.006941234922','level'=>'3','tree'=>'tr_0 tr_130000 tr_131100 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640202','title'=>'大武口区','pid'=>'640200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_640000 tr_640200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640205','title'=>'惠农区','pid'=>'640200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_640000 tr_640200 ','sort'=>'0']);
        $this->insert('{{%common_provinces}}',['id'=>'640221','title'=>'平罗县','pid'=>'640200','short_title'=>'','areacode'=>'0','zipcode'=>'0','pinyin'=>'','lng'=>'','lat'=>'','level'=>'3','tree'=>'tr_0 tr_640000 tr_640200 ','sort'=>'0']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%common_provinces}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

