<?php

use common\helpers\Html;
use common\helpers\ImageHelper;
use yii\grid\GridView;

$this->title = '商户账号';
$this->params['breadcrumbs'][] = ['label' => '商户管理', 'url' => ['merchant/index']];
$this->params['breadcrumbs'][] = ['label' => $this->title];
?>

<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title"><?= $this->title; ?></h3>
                <div class="box-tools">
                    <?= Html::create(['ajax-edit', 'merchant_id' => $merchant_id], '创建', [
                        'data-toggle' => 'modal',
                        'data-target' => '#ajaxModal',
                    ]); ?>
                </div>
            </div>
            <div class="box-body table-responsive">
                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    //重新定义分页样式
                    'tableOptions' => ['class' => 'table table-hover'],
                    'columns' => [
                        [
                            'class' => 'yii\grid\SerialColumn',
                        ],
                        [
                            'attribute' => 'head_portrait',
                            'value' => function ($model) {
                                return Html::img(ImageHelper::defaultHeaderPortrait(Html::encode($model->head_portrait)),
                                    [
                                        'class' => 'img-circle rf-img-md img-bordered-sm',
                                    ]);
                            },
                            'filter' => false,
                            'format' => 'raw',
                        ],
                        'attribute' => 'username',
                        'realname',
                        'mobile',
                        [
                            'label' => '角色',
                            'filter' => false, //不显示搜索框
                            'value' => function ($model) {
                                if (isset($model->assignment->role->title)) {
                                    return Html::tag('span', $model->assignment->role->title,
                                        ['class' => 'label label-primary']);
                                } else {
                                    return Html::tag('span', '未授权', ['class' => 'label label-default']);
                                }
                            },
                            'format' => 'raw',
                        ],
                        [
                            'label' => '最后登录',
                            'filter' => false, //不显示搜索框
                            'value' => function ($model) {
                                return "最后访问IP：" . $model->last_ip . '<br>' .
                                    "最后访问：" . Yii::$app->formatter->asDatetime($model->last_time) . '<br>' .
                                    "访问次数：" . $model->visit_count;
                            },
                            'format' => 'raw',
                        ],
                        [
                            'header' => "操作",
                            'class' => 'yii\grid\ActionColumn',
                            'template' => '{recharge} {edit} {status} {destroy}',
                            'buttons' => [
                                'recharge' => function ($url, $model, $key) use ($merchant_id) {
                                    return Html::linkButton([
                                        'ajax-edit',
                                        'id' => $model->id,
                                        'merchant_id' => $merchant_id,
                                    ], '账号密码', [
                                        'data-toggle' => 'modal',
                                        'data-target' => '#ajaxModal',
                                    ]);
                                },
                                'edit' => function ($url, $model, $key) use ($merchant_id) {
                                    return Html::edit(['edit', 'id' => $model->id, 'merchant_id' => $merchant_id]);
                                },
                                'status' => function ($url, $model, $key) {
                                    return Html::status($model->status);
                                },
                                'destroy' => function ($url, $model, $key) use ($merchant_id) {
                                    return Html::delete(['destroy', 'id' => $model->id, 'merchant_id' => $merchant_id]);
                                },
                            ],
                        ],
                    ],
                ]); ?>
            </div>
        </div>
    </div>